/*
 * Decompiled with CFR 0.152.
 */
package com.softwoehr.pigiron.functions;

import com.softwoehr.pigiron.access.Connection;
import com.softwoehr.pigiron.access.ParameterArray;
import com.softwoehr.pigiron.access.SSLSocketConnection;
import com.softwoehr.pigiron.access.SocketConnection;
import com.softwoehr.pigiron.access.VSMException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;

public abstract class VSMCall {
    public static final String PIGIRON_RELEASE_VERSION = "0.9.7";
    private String hostname;
    private int port;
    private String userid;
    private String password;
    private ParameterArray inParams;
    private ParameterArray outParams;
    private Connection connection;
    private String target_identifier;

    protected abstract ParameterArray composeInputArray();

    protected abstract ParameterArray composeOutputArray();

    protected void connect() throws UnknownHostException, IOException {
        this.connection = new SocketConnection(this.hostname, this.port);
        this.connection.connect();
    }

    protected void connect(boolean ssl) throws UnknownHostException, IOException {
        this.connection = ssl ? new SSLSocketConnection(this.hostname, this.port) : new SocketConnection(this.hostname, this.port);
        this.connection.connect();
    }

    protected void connect(String hostname, int port) throws UnknownHostException, IOException {
        this.hostname = hostname;
        this.port = port;
        this.connect();
    }

    protected void connect(String hostname, int port, boolean ssl) throws UnknownHostException, IOException {
        this.hostname = hostname;
        this.port = port;
        this.connect(ssl);
    }

    protected void disconnect() {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    public ParameterArray doIt() throws IOException, VSMException {
        this.composeInputArray();
        this.composeOutputArray();
        this.connect();
        this.writeInput(this.connection.getOutputStream());
        this.readOutput(this.connection.getInputStream());
        this.disconnect();
        return this.outParams;
    }

    public ParameterArray doIt(boolean ssl) throws IOException, VSMException {
        this.composeInputArray();
        this.composeOutputArray();
        this.connect(ssl);
        this.writeInput(this.connection.getOutputStream());
        this.readOutput(this.connection.getInputStream());
        this.disconnect();
        return this.outParams;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public abstract String getFunctionName();

    public String getHostname() {
        return this.hostname;
    }

    public ParameterArray getInParams() {
        return this.inParams;
    }

    public ParameterArray getOutParams() {
        return this.outParams;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public String getTarget_identifier() {
        return this.target_identifier;
    }

    public String getUserid() {
        return this.userid;
    }

    public DataInputStream receiveAll(DataInputStream socketIn) throws IOException {
        int numRead;
        int request_id = socketIn.readInt();
        int output_length = socketIn.readInt();
        ByteBuffer bB = ByteBuffer.allocate(8);
        bB.putInt(0, request_id);
        bB.putInt(4, output_length);
        byte[] bA = new byte[output_length + 8];
        bB.get(bA, 0, 8);
        for (int iHaveRead = 0; iHaveRead < output_length; iHaveRead += numRead) {
            numRead = socketIn.read(bA, iHaveRead + 8, output_length - iHaveRead);
            if (numRead >= 1) continue;
        }
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bA));
        return dis;
    }

    protected void readOutput(DataInputStream in) throws IOException, VSMException {
        this.outParams.readAll(this.receiveAll(in));
    }

    public final void setConnection(Connection connection) {
        this.connection = connection;
    }

    public final void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public final void setInParams(ParameterArray inParams) {
        this.inParams = inParams;
    }

    public final void setOutParams(ParameterArray outParams) {
        this.outParams = outParams;
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public final void setPort(int port) {
        this.port = port;
    }

    public final void setTarget_identifier(String target_identifier) {
        this.target_identifier = target_identifier;
    }

    public final void setUserid(String userid) {
        this.userid = userid;
    }

    protected void writeInput(DataOutputStream out) throws IOException {
        this.inParams.writeAll(out);
    }

    public static final String version() {
        return PIGIRON_RELEASE_VERSION;
    }
}

