/*
 * Decompiled with CFR 0.152.
 */
package com.softwoehr.pigiron.functions;

import com.softwoehr.pigiron.access.CountedString;
import com.softwoehr.pigiron.access.ParameterArray;
import com.softwoehr.pigiron.access.VSMAsciiZ;
import com.softwoehr.pigiron.access.VSMException;
import com.softwoehr.pigiron.access.VSMInt4;
import com.softwoehr.pigiron.access.VSMString;
import com.softwoehr.pigiron.access.paramstructs.AuthorizedUsersArray;
import com.softwoehr.pigiron.functions.VSMCall;
import java.io.IOException;

public class VirtualNetworkLANAccessQuery
extends VSMCall {
    public static final String FUNCTION_NAME = "Virtual_Network_LAN_Access_Query";
    private String lanName = "";
    private String lanOwner = "";

    public VirtualNetworkLANAccessQuery() {
    }

    public VirtualNetworkLANAccessQuery(String hostname, int port, String userid, String password, String target_identifier, String lan_name, String lan_owner) {
        this();
        this.setHostname(hostname);
        this.setPort(port);
        this.setUserid(userid);
        this.setPassword(password);
        this.setTarget_identifier(target_identifier);
        this.set_lanName(lan_name);
        this.set_lanOwner(lan_owner);
    }

    public final void set_lanName(String val) {
        this.lanName = val;
    }

    public String get_lanName() {
        return this.lanName;
    }

    public final void set_lanOwner(String val) {
        this.lanOwner = val;
    }

    public String get_lanOwner() {
        return this.lanOwner;
    }

    @Override
    protected ParameterArray composeInputArray() {
        ParameterArray parameterArray = new ParameterArray(this);
        VSMString tempString = new VSMString(this.getFunctionName(), this.getFunctionName());
        parameterArray.add(new VSMInt4(tempString.paramLength(), "function_name_length"));
        parameterArray.add(tempString);
        tempString = new VSMString(this.getUserid(), "authenticated_userid");
        parameterArray.add(new VSMInt4(tempString.paramLength(), "authenticated_userid_length"));
        parameterArray.add(tempString);
        tempString = new VSMString(this.getPassword(), "password");
        parameterArray.add(new VSMInt4(tempString.paramLength(), "password_length"));
        parameterArray.add(tempString);
        parameterArray.add(new CountedString(this.getTarget_identifier(), "target_identifier"));
        parameterArray.add(new VSMAsciiZ(this.get_lanName(), "lan_name"));
        parameterArray.add(new VSMAsciiZ(this.get_lanOwner(), "lan_owner"));
        VSMInt4 outputLength = new VSMInt4(new Long(parameterArray.totalParameterLength()).intValue(), "output_length");
        parameterArray.add(0, outputLength);
        this.setInParams(parameterArray);
        return parameterArray;
    }

    @Override
    protected ParameterArray composeOutputArray() {
        ParameterArray parameterArray = new ParameterArray(this);
        parameterArray.add(new VSMInt4(-1, "request_id_immediate"));
        parameterArray.add(new VSMInt4(-1, "output_length"));
        parameterArray.add(new VSMInt4(-1, "request_id"));
        parameterArray.add(new VSMInt4(-1, "return_code"));
        parameterArray.add(new VSMInt4(-1, "reason_code"));
        parameterArray.add(new VSMInt4(-1, "authorized_users_array_length"));
        parameterArray.add(AuthorizedUsersArray.modelArray("authorized_users_array"));
        this.setOutParams(parameterArray);
        return parameterArray;
    }

    @Override
    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    public static void main(String[] argv) throws IOException, VSMException {
        VirtualNetworkLANAccessQuery instance = null;
        if (argv.length != 7) {
            System.out.println("usage: args are:\ninetaddr port user pw target_id lan_name lan_owner");
            System.exit(1);
        }
        System.out.println("Args are: " + argv[0] + " " + argv[1] + " " + argv[2] + " " + argv[3] + " " + argv[4] + " " + argv[5] + " " + argv[6]);
        instance = new VirtualNetworkLANAccessQuery(argv[0], Integer.valueOf(argv[1]), argv[2], argv[3], argv[4], argv[5], argv[6]);
        ParameterArray pA = instance.doIt();
        System.out.println("Returns from call to " + instance.getFunctionName() + ":");
        System.out.println(pA.prettyPrintAll());
    }
}

