/*
 * Decompiled with CFR 0.152.
 */
package com.softwoehr.pigiron.webobj;

import com.softwoehr.pigiron.webobj.topview.Function;
import com.softwoehr.pigiron.webobj.topview.Requestor;
import com.softwoehr.pigiron.webobj.topview.Response;
import com.softwoehr.pigiron.webobj.topview.functions.FunctionProxy;
import com.softwoehr.pigiron.webobj.topview.functions.FunctionTable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.json.JSONException;

public class Engine {
    public Response execute(Requestor requestor) throws JSONException {
        Response response;
        block11: {
            response = new Response();
            try {
                response = new Response(requestor);
                Function function = requestor.getFunction();
                String functionName = function.get_function_name();
                try {
                    if (functionName != null) {
                        Class<? extends FunctionProxy> functionProxy = FunctionTable.get(functionName);
                        if (functionProxy != null) {
                            Constructor<? extends FunctionProxy> ctor = functionProxy.getConstructor(Requestor.class, Response.class);
                            FunctionProxy proxy = (FunctionProxy)FunctionProxy.class.cast(ctor.newInstance(requestor, response));
                            response = proxy.execute();
                        } else {
                            response.setResult(Response.Results.PIGIRON_ERR.name());
                            response.setMessageText("No function found mapping to function name " + functionName + ".");
                        }
                        break block11;
                    }
                    response.setResult(Response.Results.JSON_ERR.name());
                    response.setMessageText("No function name found in JSON stream");
                }
                catch (InstantiationException ex) {
                    response.setResult(Response.Results.PIGIRON_ERR.name());
                    response.setMessageText("InstantiationException instancing FunctionProxy: " + ex.getMessage());
                }
                catch (IllegalAccessException ex) {
                    response.setResult(Response.Results.PIGIRON_ERR.name());
                    response.setMessageText("IllegalAccessException instancing FunctionProxy: " + ex.getMessage());
                }
                catch (IllegalArgumentException ex) {
                    response.setResult(Response.Results.PIGIRON_ERR.name());
                    response.setMessageText("IllegalArgumentException instancing FunctionProxy: " + ex.getMessage());
                }
                catch (InvocationTargetException ex) {
                    response.setResult(Response.Results.PIGIRON_ERR.name());
                    response.setMessageText("InvocationTargetException instancing FunctionProxy: " + ex.getMessage());
                }
                catch (NoSuchMethodException ex) {
                    response.setResult(Response.Results.PIGIRON_ERR.name());
                    response.setMessageText("NoSuchMethodException instancing FunctionProxy: " + ex.getMessage());
                }
            }
            catch (JSONException ex) {
                String jsonErr = ex.getMessage();
                response.setResult(Response.Results.JSON_ERR.name());
                response.setMessageText(jsonErr);
            }
        }
        return response;
    }

    public static void main(String[] args) throws JSONException {
        Requestor requestor = new Requestor(args[0]);
        Engine engine = new Engine();
        Response response = engine.execute(requestor);
        System.out.println(response);
    }
}

