/*
 * Decompiled with CFR 0.152.
 */
package com.softwoehr.pigiron.webobj.topview;

import com.softwoehr.pigiron.access.CountedArray;
import com.softwoehr.pigiron.access.CountedString;
import com.softwoehr.pigiron.access.CountedStringZ;
import com.softwoehr.pigiron.access.CountedStruct;
import com.softwoehr.pigiron.access.VSMArray;
import com.softwoehr.pigiron.access.VSMAsciiZ;
import com.softwoehr.pigiron.access.VSMAsciiZArray;
import com.softwoehr.pigiron.access.VSMInt;
import com.softwoehr.pigiron.access.VSMParm;
import com.softwoehr.pigiron.access.VSMString;
import com.softwoehr.pigiron.access.VSMStruct;
import com.softwoehr.pigiron.webobj.WebObject;
import com.softwoehr.pigiron.webobj.topview.ArgumentArray;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Argument
extends WebObject {
    private static WebObject.NameList names = Argument.setNames(new String[]{"formal_name", "value"});

    public String[] getNames() {
        return names.toArray(new String[names.size()]);
    }

    public boolean isName(String name) {
        return Argument.isName(name, names);
    }

    public Argument() throws JSONException {
        this.initDefaults();
    }

    public Argument(JSONObject jsonObject) throws JSONException {
        this();
        this.setFormalName(jsonObject.get("formal_name").toString());
        this.setValue(jsonObject.get("value"));
    }

    public Argument(String jsonRepresentation) throws JSONException {
        super(jsonRepresentation);
    }

    public Argument(String formal_name, JSONObject jsonObj) throws JSONException {
        this();
        this.setFormalName(formal_name);
        this.setValue(jsonObj);
    }

    public Argument(String formal_name, JSONArray jsonArray) throws JSONException {
        this();
        this.setFormalName(formal_name);
        this.setValue(jsonArray);
    }

    public Argument(String formal_name, String value) throws JSONException {
        this();
        this.setFormalName(formal_name);
        this.setValue(value);
    }

    public Argument(String formal_name, long value) throws JSONException {
        this();
        this.setFormalName(formal_name);
        this.setValue(value);
    }

    public Argument(WebObject anArgument) throws JSONException {
        super(anArgument);
    }

    private void initDefaults() throws JSONException {
        this.setFormalName("");
        this.setValue(NULL);
    }

    public String getStringValue() throws JSONException {
        return this.getString("value");
    }

    public long getLongValue() throws JSONException {
        return this.getLong("value");
    }

    public JSONArray getJSONArrayValue() throws JSONException {
        return this.getJSONArray("value");
    }

    public JSONArray optJSONArrayValue() {
        return this.optJSONArray("value");
    }

    public JSONObject getJSONObjectValue() throws JSONException {
        return this.getJSONObject("value");
    }

    public JSONObject optJSONObjectValue() {
        return this.optJSONObject("value");
    }

    public final void setValue(Object value) throws JSONException {
        if (value == null) {
            this.put("value", JSONObject.NULL);
        } else {
            this.put("value", value);
        }
    }

    public final void setValue(String value) throws JSONException {
        if (value == null) {
            this.put("value", JSONObject.NULL);
        } else {
            this.put("value", value);
        }
    }

    public final void setValue(long value) throws JSONException {
        this.put("value", value);
    }

    public final void setValue(JSONObject jsonObj) throws JSONException {
        if (jsonObj == null) {
            this.put("value", JSONObject.NULL);
        } else {
            this.put("value", jsonObj);
        }
    }

    public String getFormalName() throws JSONException {
        return this.getString("formal_name");
    }

    public final void setFormalName(String formal_name) throws JSONException {
        this.put("formal_name", formal_name);
    }

    public static Argument from(VSMInt vsmInt) throws JSONException {
        Argument result = new Argument(((VSMParm)VSMParm.class.cast(vsmInt)).getFormalName(), vsmInt.getLongValue());
        return result;
    }

    public static Argument from(VSMString vsmString) throws JSONException {
        Argument result = new Argument(vsmString.getFormalName(), vsmString.getValue());
        return result;
    }

    public static Argument from(CountedString countedString) throws JSONException {
        Argument result = new Argument(countedString.getFormalName(), countedString.getValue());
        return result;
    }

    public static Argument from(VSMAsciiZ vsmAsciiZ) throws JSONException {
        Argument result = new Argument(vsmAsciiZ.getFormalName(), vsmAsciiZ.getValue());
        return result;
    }

    public static Argument from(CountedStringZ countedStringZ) throws JSONException {
        Argument result = new Argument(countedStringZ.getFormalName(), countedStringZ.getValue());
        return result;
    }

    public static Argument from(VSMStruct vsmStruct) throws JSONException {
        JSONArray ja = new JSONArray();
        Iterator it = vsmStruct.iterator();
        while (it.hasNext()) {
            Argument a = Argument.from((VSMParm)it.next());
            ja.put(a);
        }
        Argument result = new Argument(vsmStruct.getFormalName(), ja);
        return result;
    }

    public static Argument from(CountedStruct countStruct) throws JSONException {
        JSONArray ja = new JSONArray();
        Iterator it = countStruct.iterator();
        while (it.hasNext()) {
            Argument a = Argument.from((VSMParm)it.next());
            ja.put(a);
        }
        Argument result = new Argument(countStruct.getFormalName(), ja);
        return result;
    }

    public static Argument from(VSMArray vsmArray) throws JSONException {
        JSONArray ja = new JSONArray();
        Iterator it = vsmArray.iterator();
        boolean i = false;
        while (it.hasNext()) {
            Argument a = Argument.from((VSMParm)it.next());
            ja.put(a);
        }
        Argument result = new Argument(vsmArray.getFormalName(), ja);
        return result;
    }

    public static Argument from(VSMAsciiZArray vsmAsciiZArray) throws JSONException {
        JSONArray ja = new JSONArray();
        Iterator it = vsmAsciiZArray.iterator();
        boolean i = false;
        while (it.hasNext()) {
            Argument a = Argument.from((VSMParm)it.next());
            ja.put(a);
        }
        Argument result = new Argument(vsmAsciiZArray.getFormalName(), ja);
        return result;
    }

    public static Argument from(CountedArray countedArray) throws JSONException {
        JSONArray ja = new JSONArray();
        Iterator it = countedArray.iterator();
        boolean i = false;
        while (it.hasNext()) {
            Argument a = Argument.from((VSMParm)it.next());
            ja.put(a);
        }
        Argument result = new Argument(countedArray.getFormalName(), ja);
        return result;
    }

    public static Argument from(VSMParm vsmParm) throws JSONException {
        Argument result = null;
        if (vsmParm instanceof CountedArray) {
            result = Argument.from((CountedArray)CountedArray.class.cast(vsmParm));
        } else if (vsmParm instanceof VSMAsciiZArray) {
            result = Argument.from((VSMAsciiZArray)VSMAsciiZArray.class.cast(vsmParm));
        } else if (vsmParm instanceof VSMArray) {
            result = Argument.from((VSMArray)VSMArray.class.cast(vsmParm));
        } else if (vsmParm instanceof CountedStruct) {
            result = Argument.from((CountedStruct)CountedStruct.class.cast(vsmParm));
        } else if (vsmParm instanceof VSMStruct) {
            result = Argument.from((VSMStruct)VSMStruct.class.cast(vsmParm));
        } else if (vsmParm instanceof CountedStringZ) {
            result = Argument.from((CountedStringZ)CountedStringZ.class.cast(vsmParm));
        } else if (vsmParm instanceof VSMAsciiZ) {
            result = Argument.from((VSMAsciiZ)VSMAsciiZ.class.cast(vsmParm));
        } else if (vsmParm instanceof CountedString) {
            result = Argument.from((CountedString)CountedString.class.cast(vsmParm));
        } else if (vsmParm instanceof VSMString) {
            result = Argument.from((VSMString)VSMString.class.cast(vsmParm));
        } else if (vsmParm instanceof VSMInt) {
            result = Argument.from((VSMInt)VSMInt.class.cast(vsmParm));
        } else {
            Logger.getLogger(Argument.class.getName()).log(Level.WARNING, "unrecogized Argument in from(VSMParm)", vsmParm);
        }
        return result;
    }

    @Override
    public String toHTML() throws JSONException {
        StringBuilder sb = new StringBuilder();
        sb.append("<tt>").append(this.getFormalName()).append("</tt>: ");
        JSONArray ja = this.optJSONArrayValue();
        if (ja == null) {
            JSONObject jo = this.optJSONObjectValue();
            if (jo == null) {
                sb.append(this.getStringValue());
            } else {
                sb.append("<blockquote>");
                sb.append(this.getStringValue());
                sb.append("</blockquote>\n");
            }
        } else {
            sb.append("<ul>\n");
            sb.append(new ArgumentArray(ja).toHTML());
            sb.append("</ul>\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) throws JSONException {
        Argument a = new Argument();
        Argument b = new Argument();
        if (args.length > 1) {
            b = new Argument(args[0], args[1]);
        }
        Argument c = new Argument("{\"name\":\"iyamanarg\",\"value\":\"Popeye\"}");
        System.out.println("A == " + a);
        System.out.println("B == " + b);
        System.out.println("C == " + c);
    }
}

