/*
 * Decompiled with CFR 0.152.
 */
package com.softwoehr.pigiron.webobj.topview;

import com.softwoehr.pigiron.webobj.WebObject;
import com.softwoehr.pigiron.webobj.topview.OutputArgumentArray;
import com.softwoehr.pigiron.webobj.topview.Requestor;
import org.json.JSONException;
import org.json.JSONObject;

public class Response
extends WebObject {
    private static WebObject.NameList names = Response.setNames(new String[]{"result", "messageText", "requestor"});

    public String[] getNames() {
        return names.toArray(new String[names.size()]);
    }

    public boolean isName(String name) {
        return Response.isName(name, names);
    }

    public Response() throws JSONException {
        this.initDefaults();
    }

    public Response(String result, String messageText) throws JSONException {
        this(result, messageText, new Requestor());
    }

    public Response(String result, String messageText, Requestor requestor) throws JSONException {
        this.setImportantValues(result, messageText, requestor);
    }

    private void setImportantValues(String result, String messageText, Requestor requestor) throws JSONException {
        this.put("result", result);
        this.put("messageText", messageText);
        this.put("requestor", requestor);
    }

    public Response(Requestor requestor) throws JSONException {
        this();
        this.setRequestor(requestor);
    }

    public Response(WebObject aResponse) throws JSONException {
        super(aResponse);
    }

    public Response(JSONObject aResponse) throws JSONException {
        super(aResponse, new String[]{"result", "messageText", "requestor"});
    }

    public Response(String jsonRepresentation) throws JSONException {
        super(jsonRepresentation);
    }

    public String getResult() throws JSONException {
        return this.getString("result");
    }

    public void setResult(String result) throws JSONException {
        this.put("result", result);
    }

    public String getMessageText() throws JSONException {
        return this.getString("messageText");
    }

    public void setMessageText(String messageText) throws JSONException {
        this.put("messageText", messageText);
    }

    public Requestor getRequestor() throws JSONException {
        return new Requestor(this.getJSONObject("requestor"));
    }

    public final void setRequestor(Requestor requestor) throws JSONException {
        this.put("requestor", requestor);
    }

    private void initDefaults() throws JSONException {
        this.put("result", (Object)Results.NO_RESPONSE);
        this.put("messageText", "");
        this.put("requestor", new Requestor());
    }

    @Override
    public String toHTML() throws JSONException {
        StringBuilder sb = new StringBuilder();
        sb.append("<b>Result:</b> ").append(this.get("result")).append("<br />\n");
        sb.append("<b>Message text:</b> ").append(this.get("messageText")).append("<br />\n");
        OutputArgumentArray output = this.getRequestor().getFunction().get_output_arguments();
        sb.append("<b>Returns:</b>\n<ul>\n").append(output.toHTML()).append("</ul>\n");
        return sb.toString();
    }

    public static enum Results {
        NO_RESPONSE,
        SUCCESS,
        FAILURE,
        JSON_ERR,
        PIGIRON_ERR;

    }
}

