/*
 * Decompiled with CFR 0.152.
 */
package com.softwoehr.pigiron.webobj.topview.functions;

import com.softwoehr.pigiron.access.ParameterArray;
import com.softwoehr.pigiron.access.VSMException;
import com.softwoehr.pigiron.access.VSMInt4;
import com.softwoehr.pigiron.access.VSMParm;
import com.softwoehr.pigiron.bizobj.VsmapiRC;
import com.softwoehr.pigiron.functions.VSMCall;
import com.softwoehr.pigiron.webobj.topview.Argument;
import com.softwoehr.pigiron.webobj.topview.Function;
import com.softwoehr.pigiron.webobj.topview.Host;
import com.softwoehr.pigiron.webobj.topview.InputArgumentArray;
import com.softwoehr.pigiron.webobj.topview.OutputArgumentArray;
import com.softwoehr.pigiron.webobj.topview.Requestor;
import com.softwoehr.pigiron.webobj.topview.Response;
import com.softwoehr.pigiron.webobj.topview.User;
import com.softwoehr.pigiron.webobj.topview.paramstructs.ParamProxy;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;

public abstract class FunctionProxy {
    public Host host = null;
    public User user = null;
    public Response response = null;
    public Requestor requestor = null;
    public Function function = null;
    public InputArgumentArray inArray = null;
    public OutputArgumentArray outArray = null;

    public FunctionProxy(Requestor requestor, Response response) throws JSONException {
        this.assimilate(requestor, response);
    }

    public abstract Response execute() throws JSONException;

    public final void assimilate(Requestor requestor, Response response) throws JSONException {
        this.requestor = requestor;
        this.response = response;
        if (requestor != null) {
            this.host = requestor.getHost();
            this.function = requestor.getFunction();
            this.user = requestor.getUser();
            this.inArray = this.function.get_input_arguments();
            this.outArray = this.function.get_output_arguments();
        }
    }

    public String getHostSpecifier() throws JSONException {
        String host_specifier = null;
        if (this.host != null && ((host_specifier = this.host.getDnsName()) == null || host_specifier.equals(""))) {
            host_specifier = this.host.getIpAddress();
        }
        return host_specifier;
    }

    public Argument getInputArgument(String formal_name) throws JSONException {
        Argument argument = this.inArray != null ? this.inArray.argumentNamed(formal_name) : null;
        return argument;
    }

    public String getInputArgumentString(String formal_name) throws JSONException {
        Argument argument = this.getInputArgument(formal_name);
        String string = argument != null ? argument.getStringValue() : "";
        return string;
    }

    public long getInputArgumentLong(String formal_name) throws JSONException {
        Argument argument = this.getInputArgument(formal_name);
        long along = argument != null ? argument.getLongValue() : -1L;
        return along;
    }

    public VSMParm getInputArgumentObject(Class<? extends ParamProxy> c, String formal_name) throws JSONException {
        VSMParm o = null;
        try {
            o = c.newInstance().from(this.getInputArgument(formal_name));
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FunctionProxy.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FunctionProxy.class.getName()).log(Level.SEVERE, null, ex);
        }
        return o;
    }

    public String getTargetIdentifier() throws JSONException {
        return this.getInputArgumentString("target_identifier");
    }

    public static void execute(VSMCall pigfunc, Requestor requestor, Response response) throws JSONException {
        Host host = requestor.getHost();
        boolean useSSL = host.getSSL();
        try {
            Function f = requestor.getFunction();
            ParameterArray pA = pigfunc.doIt(useSSL);
            OutputArgumentArray outputArgumentArray = OutputArgumentArray.from(pA);
            f.put("output_arguments", outputArgumentArray);
            VSMInt4 rc_int4 = (VSMInt4)VSMInt4.class.cast(pA.parameterNamed("return_code"));
            VSMInt4 reason_int4 = (VSMInt4)VSMInt4.class.cast(pA.parameterNamed("reason_code"));
            VSMInt4 request_id_int4 = (VSMInt4)VSMInt4.class.cast(pA.parameterNamed("request_id"));
            f.put("return_code", rc_int4.getValue());
            f.put("reason_code", reason_int4.getValue());
            f.put("request_id", request_id_int4.getValue());
            requestor.setFunction(f);
            response.setRequestor(requestor);
            response.setMessageText(VsmapiRC.prettyPrint(rc_int4.getValue(), reason_int4.getValue(), pigfunc).replace("\n", " ; "));
            long rc = rc_int4.getLongValue();
            if (rc == 0L) {
                response.setResult(Response.Results.SUCCESS.name());
            } else {
                response.setResult(Response.Results.FAILURE.name());
            }
        }
        catch (IOException ex) {
            response.setResult(Response.Results.FAILURE.name());
            response.setMessageText(ex.toString());
        }
        catch (VSMException ex) {
            response.setResult(Response.Results.PIGIRON_ERR.name());
            response.setMessageText(ex.toString());
        }
    }
}

