# listobjs.sh ... list all objects matching a specification 
# autogenerated Tue Aug 30 22:59:16 MDT 2016 by jax using command:
# gensh -to listobjs.sh -path /opt/ublu/ublu.jar -optr s SERVER @server ${ Server to connect to }$ -optr u USER @user ${ User }$ -optr p PASSWORD @password ${ Password }$ -optr l LIBRARY @library ${ Library spec }$ -optr n OBJNAME @objname ${ Object name spec }$ -optr t OBJTYPE @objtype ${ Object type spec }$ ${ listobjs.sh ... list all objects matching a specification }$ /opt/ublu/examples/listobjs.ublu ${ listObjs ( @server @user @password @library @objname @objtype ) }$

# Usage message
function usage { 
echo "listobjs.sh ... list all objects matching a specification "
echo "This shell script was autogenerated Tue Aug 30 22:59:16 MDT 2016 by jax."
echo "Usage: $0 [silent] -h -s SERVER -u USER -p PASSWORD -l LIBRARY -n OBJNAME -t OBJTYPE "
echo "	where"
echo "	-h		display this help message and exit 0"
echo "	-s SERVER	Server to connect to  (required option)"
echo "	-u USER	User  (required option)"
echo "	-p PASSWORD	Password  (required option)"
echo "	-l LIBRARY	Library spec  (required option)"
echo "	-n OBJNAME	Object name spec  (required option)"
echo "	-t OBJTYPE	Object type spec  (required option)"
echo "---"
echo "If the keyword 'silent' appears ahead of all options, then included files will not echo and prompting is suppressed."
echo "Exit code is the result of execution, or 0 for -h or 2 if there is an error in processing options"
}

#Test if user wants silent includes
if [ "$1" == "silent" ]
then
	SILENT="-silent "
	shift
else
	SILENT=""
fi

# Process options
while getopts s:u:p:l:n:t:h the_opt
do
	case "$the_opt" in
		s)	SERVER="$OPTARG";;
		u)	USER="$OPTARG";;
		p)	PASSWORD="$OPTARG";;
		l)	LIBRARY="$OPTARG";;
		n)	OBJNAME="$OPTARG";;
		t)	OBJTYPE="$OPTARG";;
		h)	usage;exit 0;;
		[?])	usage;exit 2;;

	esac
done
shift `expr ${OPTIND} - 1`
if [ $# -ne 0 ]
then
	echo "Superfluous argument(s) $*"
	usage
	exit 2
fi

# Translate options to tuple assignments
if [ "${SERVER}" != "" ]
then
	gensh_runtime_opts="${gensh_runtime_opts}string -to @server -trim \${ ${SERVER} }$ "
else
	echo "Option -s SERVER is a required option but is not present."
	usage
	exit 2
fi
if [ "${USER}" != "" ]
then
	gensh_runtime_opts="${gensh_runtime_opts}string -to @user -trim \${ ${USER} }$ "
else
	echo "Option -u USER is a required option but is not present."
	usage
	exit 2
fi
if [ "${PASSWORD}" != "" ]
then
	gensh_runtime_opts="${gensh_runtime_opts}string -to @password -trim \${ ${PASSWORD} }$ "
else
	echo "Option -p PASSWORD is a required option but is not present."
	usage
	exit 2
fi
if [ "${LIBRARY}" != "" ]
then
	gensh_runtime_opts="${gensh_runtime_opts}string -to @library -trim \${ ${LIBRARY} }$ "
else
	echo "Option -l LIBRARY is a required option but is not present."
	usage
	exit 2
fi
if [ "${OBJNAME}" != "" ]
then
	gensh_runtime_opts="${gensh_runtime_opts}string -to @objname -trim \${ ${OBJNAME} }$ "
else
	echo "Option -n OBJNAME is a required option but is not present."
	usage
	exit 2
fi
if [ "${OBJTYPE}" != "" ]
then
	gensh_runtime_opts="${gensh_runtime_opts}string -to @objtype -trim \${ ${OBJTYPE} }$ "
else
	echo "Option -t OBJTYPE is a required option but is not present."
	usage
	exit 2
fi

# Invocation
java -jar /opt/ublu/ublu.jar ${gensh_runtime_opts} include ${SILENT}/opt/ublu/examples/listobjs.ublu listObjs \( @server @user @password @library @objname @objtype \) 
exit $?
