# test_query_all_dm.sh ... run automated tests on PigIron binding in Ublu for Query_All_DM using defaults from the file included by the -f switch to this script with two options provided by switches at the command line 
# autogenerated Mon Jan 04 19:28:06 MST 2016 by jax using command:
# gensh -to test_query_all_dm.sh -path /opt/ublu/ublu.jar -optr f INCLUDE_FILE @include_file ${ file of test defaults to include ... see test_defaults.samp for an example }$ -optr q QADM_USER @qadm_user ${ Query_All_DM user }$ -optr o QADM_FORMAT @qadm_format ${ format for Query_All_DM, either FORMAT=YES or FORMAT=NO }$ ${ test_query_all_dm.sh ... run automated tests on PigIron binding in Ublu for Query_All_DM using defaults from the file included by the -f switch to this script with two options provided by switches at the command line }$ test_query_all_dm.ublu ${ test_Query_All_DM ( @include_file @qadm_user @qadm_format ) }$

# Usage message
function usage { 
echo "test_query_all_dm.sh ... run automated tests on PigIron binding in Ublu for Query_All_DM using defaults from the file included by the -f switch to this script with two options provided by switches at the command line "
echo "This shell script was autogenerated Mon Jan 04 19:28:06 MST 2016 by jax."
echo "Usage: $0 [silent] -h -f INCLUDE_FILE -q QADM_USER -o QADM_FORMAT "
echo "	where"
echo "	-h		display this help message and exit 0"
echo "	-f INCLUDE_FILE	file of test defaults to include ... see test_defaults.samp for an example  (required option)"
echo "	-q QADM_USER	Query_All_DM user  (required option)"
echo "	-o QADM_FORMAT	format for Query_All_DM, either FORMAT=YES or FORMAT=NO  (required option)"
echo "---"
echo "If the keyword 'silent' appears ahead of all options, then included files will not echo and prompting is suppressed."
echo "Exit code is the result of execution, or 0 for -h or 2 if there is an error in processing options"
}

#Test if user wants silent includes
if [ "$1" == "silent" ]
then
	SILENT="-silent "
	shift
else
	SILENT=""
fi

# Process options
while getopts f:q:o:h the_opt
do
	case "$the_opt" in
		f)	INCLUDE_FILE="$OPTARG";;
		q)	QADM_USER="$OPTARG";;
		o)	QADM_FORMAT="$OPTARG";;
		h)	usage;exit 0;;
		[?])	usage;exit 2;;

	esac
done
shift `expr ${OPTIND} - 1`
if [ $# -ne 0 ]
then
	echo "Superfluous argument(s) $*"
	usage
	exit 2
fi

# Translate options to tuple assignments
if [ "${INCLUDE_FILE}" != "" ]
then
	gensh_runtime_opts="${gensh_runtime_opts}string -to @include_file -trim \${ ${INCLUDE_FILE} }$ "
else
	echo "Option -f INCLUDE_FILE is a required option but is not present."
	usage
	exit 2
fi
if [ "${QADM_USER}" != "" ]
then
	gensh_runtime_opts="${gensh_runtime_opts}string -to @qadm_user -trim \${ ${QADM_USER} }$ "
else
	echo "Option -q QADM_USER is a required option but is not present."
	usage
	exit 2
fi
if [ "${QADM_FORMAT}" != "" ]
then
	gensh_runtime_opts="${gensh_runtime_opts}string -to @qadm_format -trim \${ ${QADM_FORMAT} }$ "
else
	echo "Option -o QADM_FORMAT is a required option but is not present."
	usage
	exit 2
fi

# Invocation
java -jar /opt/ublu/ublu.jar ${gensh_runtime_opts} include ${SILENT}test_query_all_dm.ublu test_Query_All_DM \( @include_file @qadm_user @qadm_format \) 
exit $?
