/*
 * Copyright (c) 2015, Absolute Performance, Inc. http://www.absolute-performance.com
 * Copyright (c) 2017, Jack J. Woehr jwoehr@softwoehr.com 
 * SoftWoehr LLC PO Box 82, Beulah CO 81023-0082 http://www.softwoehr.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package ublu.command;

import ublu.util.ArgArray;

/**
 * Functionality of the interpreter "bye" command. Signals the intepreter to
 * exit.
 *
 * @author jwoehr
 */
public class CmdBye extends Command {

    {
        setNameAndDescription("bye", "/0 : terminate the session");
    }

    /**
     * /0 ctor
     */
    public CmdBye() {
    }

    /**
     * Exit the {@link ublu.util.Interpreter#loop()}
     *
     * @param args the command stream
     * @return the remainder of the command stream
     */
    public ArgArray bye(ArgArray args) {
        if (getUblu().isWindowing()) {
            getInterpreter().closeHistory();
            getInterpreter().getErroutStream().flush();
            getInterpreter().getOutputStream().flush();
            // !! Nonlocal return
            System.exit(getInterpreter().getGlobal_ret_val());
        }
        getInterpreter().setGoodBye(true);
        return new ArgArray(getInterpreter()); // so we fall out of loop() at current nest level of interpreter, possibly exiting.
    }

    @Override
    public ArgArray cmd(ArgArray args) {
        reinit();
        return bye(args);
    }

    @Override
    public COMMANDRESULT getResult() {
        return getCommandResult();
    }
}
