/*
 * Copyright (c) 2016, Jack J. Woehr jax@well.com po box 51 golden co 80402-0051
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

 /* Note: this file is autogenerated by piggen/gen_smapihelper.sh */
 /* Autogenerated Fri Aug  5 15:42:05 UTC 2016 by piggen's gen-smapihelper.sh */
package ublu.smapi;

import ublu.command.Command;
import ublu.command.CommandInterface;
import ublu.util.ArgArray;
import ublu.util.Tuple;
import com.softwoehr.pigiron.access.ParameterArray;
import com.softwoehr.pigiron.access.VSMException;
import com.softwoehr.pigiron.functions.*;
import com.softwoehr.pigiron.access.paramstructs.*;
import java.io.IOException;
import java.util.logging.Level;

/**
 * Support the CmdSmapi functionality as root class of the calls
 *
 * @author jwoehr jwoehr@softwoehr.com http://www.softwoehr.com
 */
public class SmapiHelper {

    private final Host host;
    private final String funcName;
    private final Command command;
    private final ArgArray argArray;

    /**
     * Instance a SmapiHelper on a host with the full info for the fuction call.
     *
     * @param host target host
     * @param funcName SMAPI function
     * @param command the Ublu command that is instancing this helper
     * @param argArray the Ublu interpreter argument array for call arg parsing
     */
    public SmapiHelper(Host host, String funcName, Command command, ArgArray argArray) {
        this.host = host;
        this.funcName = funcName;
        this.command = command;
        this.argArray = argArray;
    }

    /**
     * Perform the function and return the return parameters
     *
     * @return the array of return parameters
     * @throws VSMException if there is a problem with SMAPI
     * @throws IOException if there is a communications problem
     */
    public ParameterArray doIt() throws VSMException, IOException {
        ParameterArray resultParameterArray = null;
        String hostname = host.getHostname();
        int port = host.getPort();
        String userid = host.getUserid();
        String password = host.getPassword();
        boolean use_ssl = host.isUse_ssl();
        switch (funcName) {
            case "SMAPI_Status_Capture": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new SMAPIStatusCapture(hostname, port, userid, password, target_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "VMRM_Configuration_Query": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String configuration_file_name = argArray.nextMaybeQuotationTuplePopString();
                String configuration_file_type = argArray.nextMaybeQuotationTuplePopString();
                String configuration_dir_name = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new VMRMConfigurationQuery(hostname, port, userid, password, target_identifier, configuration_file_name, configuration_file_type, configuration_dir_name)
                        .doIt(use_ssl);
            }
	    break;
            case "VMRM_Configuration_Update": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String configuration_file_name = argArray.nextMaybeQuotationTuplePopString();
                String configuration_file_type = argArray.nextMaybeQuotationTuplePopString();
                String configuration_dir_name = argArray.nextMaybeQuotationTuplePopString();
                int syncheck_only = argArray.nextIntMaybeQuotationTuplePopString();
                String update_file = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new VMRMConfigurationUpdate(hostname, port, userid, password, target_identifier, configuration_file_name, configuration_file_type, configuration_dir_name, syncheck_only, update_file)
                        .doIt(use_ssl);
            }
	    break;
            case "VMRM_Measurement_Query": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new VMRMMeasurementQuery(hostname, port, userid, password, target_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Asynchronous_Notification_Disable_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                int entity_type = argArray.nextIntMaybeQuotationTuplePopString();
                int communication_type = argArray.nextIntMaybeQuotationTuplePopString();
                int port_number = argArray.nextIntMaybeQuotationTuplePopString();
                String ip_address = argArray.nextMaybeQuotationTuplePopString();
                int encoding = argArray.nextIntMaybeQuotationTuplePopString();
                String subscriber_data = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new AsynchronousNotificationDisableDM(hostname, port, userid, password, target_identifier, entity_type, communication_type, port_number, ip_address, encoding, subscriber_data)
                        .doIt(use_ssl);
            }
	    break;
            case "Asynchronous_Notification_Enable_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                int entity_type = argArray.nextIntMaybeQuotationTuplePopString();
                int subscription_type = argArray.nextIntMaybeQuotationTuplePopString();
                int communication_type = argArray.nextIntMaybeQuotationTuplePopString();
                int port_number = argArray.nextIntMaybeQuotationTuplePopString();
                String ip_address = argArray.nextMaybeQuotationTuplePopString();
                int encoding = argArray.nextIntMaybeQuotationTuplePopString();
                String subscriber_data = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new AsynchronousNotificationEnableDM(hostname, port, userid, password, target_identifier, entity_type, subscription_type, communication_type, port_number, ip_address, encoding, subscriber_data)
                        .doIt(use_ssl);
            }
	    break;
            case "Asynchronous_Notification_Query_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                int entity_type = argArray.nextIntMaybeQuotationTuplePopString();
                int communication_type = argArray.nextIntMaybeQuotationTuplePopString();
                int port_number = argArray.nextIntMaybeQuotationTuplePopString();
                String ip_address = argArray.nextMaybeQuotationTuplePopString();
                int encoding = argArray.nextIntMaybeQuotationTuplePopString();
                String subscriber_data = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new AsynchronousNotificationQueryDM(hostname, port, userid, password, target_identifier, entity_type, communication_type, port_number, ip_address, encoding, subscriber_data)
                        .doIt(use_ssl);
            }
	    break;
            case "Authorization_List_Add": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String for_id = argArray.nextMaybeQuotationTuplePopString();
                String function_id = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new AuthorizationListAdd(hostname, port, userid, password, target_identifier, for_id, function_id)
                        .doIt(use_ssl);
            }
	    break;
            case "Authorization_List_Query": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String for_id = argArray.nextMaybeQuotationTuplePopString();
                String function_id = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new AuthorizationListQuery(hostname, port, userid, password, target_identifier, for_id, function_id)
                        .doIt(use_ssl);
            }
	    break;
            case "Authorization_List_Remove": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String for_id = argArray.nextMaybeQuotationTuplePopString();
                String function_id = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new AuthorizationListRemove(hostname, port, userid, password, target_identifier, for_id, function_id)
                        .doIt(use_ssl);
            }
	    break;
            case "Check_Authentication": {
                resultParameterArray
                        = new CheckAuthentication(hostname, port, userid, password)
                        .doIt(use_ssl);
            }
	    break;
            case "Directory_Manager_Local_Tag_Define_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String tag_name = argArray.nextMaybeQuotationTuplePopString();
                int tag_ordinal = argArray.nextIntMaybeQuotationTuplePopString();
                resultParameterArray
                        = new DirectoryManagerLocalTagDefineDM(hostname, port, userid, password, target_identifier, tag_name, tag_ordinal)
                        .doIt(use_ssl);
            }
	    break;
            case "Directory_Manager_Local_Tag_Delete_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String tag_name = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new DirectoryManagerLocalTagDeleteDM(hostname, port, userid, password, target_identifier, tag_name)
                        .doIt(use_ssl);
            }
	    break;
            case "Directory_Manager_Local_Tag_Query_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String tag_name = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new DirectoryManagerLocalTagQueryDM(hostname, port, userid, password, target_identifier, tag_name)
                        .doIt(use_ssl);
            }
	    break;
            case "Directory_Manager_Local_Tag_Set_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String tag_name = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new DirectoryManagerLocalTagSetDM(hostname, port, userid, password, target_identifier, tag_name)
                        .doIt(use_ssl);
            }
	    break;
            case "Directory_Manager_Search_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String search_pattern = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new DirectoryManagerSearchDM(hostname, port, userid, password, target_identifier, search_pattern)
                        .doIt(use_ssl);
            }
	    break;
            case "Directory_Manager_Task_Cancel_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                int operation_id = argArray.nextIntMaybeQuotationTuplePopString();
                resultParameterArray
                        = new DirectoryManagerTaskCancelDM(hostname, port, userid, password, target_identifier, operation_id)
                        .doIt(use_ssl);
            }
	    break;

            case "Echo_Parameters": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String switch_name = argArray.nextMaybeQuotationTuplePopString();
                int queue_limit = argArray.nextIntMaybeQuotationTuplePopString();
                resultParameterArray
                        = new EchoParameters(hostname, port, userid, password, target_identifier, switch_name, queue_limit)
                        .doIt(use_ssl);
            }
	    break;
            case "Event_Stream_Add": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String event_info = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new EventStreamAdd(hostname, port, userid, password, target_identifier, event_info)
                        .doIt(use_ssl);
            }
	    break;
            case "Event_Subscribe": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String match_key = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new EventSubscribe(hostname, port, userid, password, target_identifier, match_key)
                        .doIt(use_ssl);
            }
	    break;
            case "Event_Unsubscribe": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new EventUnsubscribe(hostname, port, userid, password, target_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_CPU_Define": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String cpu_address = argArray.nextMaybeQuotationTuplePopString();
                int cpu_type = argArray.nextIntMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageCPUDefine(hostname, port, userid, password, target_identifier, cpu_address, cpu_type)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_CPU_Define_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String cpu_address = argArray.nextMaybeQuotationTuplePopString();
                int base_cpu = argArray.nextIntMaybeQuotationTuplePopString();
                String cpu_id = argArray.nextMaybeQuotationTuplePopString();
                int dedicate_cpu = argArray.nextIntMaybeQuotationTuplePopString();
                int crypto = argArray.nextIntMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageCPUDefineDM(hostname, port, userid, password, target_identifier, cpu_address, base_cpu, cpu_id, dedicate_cpu, crypto)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_CPU_Delete": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String cpu_address = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageCPUDelete(hostname, port, userid, password, target_identifier, cpu_address)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_CPU_Delete_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String cpu_address = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageCPUDeleteDM(hostname, port, userid, password, target_identifier, cpu_address)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_CPU_Query": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageCPUQuery(hostname, port, userid, password, target_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_CPU_Query_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String cpu_address = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageCPUQueryDM(hostname, port, userid, password, target_identifier, cpu_address)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_CPU_Set_Maximum_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                int max_cpu = argArray.nextIntMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageCPUSetMaximumDM(hostname, port, userid, password, target_identifier, max_cpu)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_IPL_Delete_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageIPLDeleteDM(hostname, port, userid, password, target_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_IPL_Query_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageIPLQueryDM(hostname, port, userid, password, target_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_IPL_Set_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String saved_system = argArray.nextMaybeQuotationTuplePopString();
                String load_parameter = argArray.nextMaybeQuotationTuplePopString();
                String parameter_string = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageIPLSetDM(hostname, port, userid, password, target_identifier, saved_system, load_parameter, parameter_string)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_MDISK_Link_Query": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String vdev = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageMDISKLinkQuery(hostname, port, userid, password, target_identifier, vdev)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_SCSI_Characteristics_Define_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String boot_program = argArray.nextMaybeQuotationTuplePopString();
                String BR_LBA = argArray.nextMaybeQuotationTuplePopString();
                String LUN = argArray.nextMaybeQuotationTuplePopString();
                String port_name = argArray.nextMaybeQuotationTuplePopString();
                int SCP_data_type = argArray.nextIntMaybeQuotationTuplePopString();
                String SCP_data = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageSCSICharacteristicsDefineDM(hostname, port, userid, password, target_identifier, boot_program, BR_LBA, LUN, port_name, SCP_data_type, SCP_data)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_SCSI_Characteristics_Query_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageSCSICharacteristicsQueryDM(hostname, port, userid, password, target_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Activate": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageActivate(hostname, port, userid, password, target_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Active_Configuration_Query": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageActiveConfigurationQuery(hostname, port, userid, password, target_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Create_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String prototype_name = argArray.nextMaybeQuotationTuplePopString();
                String initial_password = argArray.nextMaybeQuotationTuplePopString();
                String initial_account_number = argArray.nextMaybeQuotationTuplePopString();
                Tuple image_record_array_tuple = argArray.nextTupleOrPop();                
                ImageRecordArray image_record_array = ImageRecordArray.class.cast(image_record_array_tuple.getValue());
                resultParameterArray
                        = new ImageCreateDM(hostname, port, userid, password, target_identifier, prototype_name, initial_password, initial_account_number, image_record_array)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Deactivate": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String force_time = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageDeactivate(hostname, port, userid, password, target_identifier, force_time)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Delete_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                int data_security_erase = argArray.nextIntMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageDeleteDM(hostname, port, userid, password, target_identifier, data_security_erase)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Device_Dedicate": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_device_number = argArray.nextMaybeQuotationTuplePopString();
                String real_device_number = argArray.nextMaybeQuotationTuplePopString();
                int readonly = argArray.nextIntMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageDeviceDedicate(hostname, port, userid, password, target_identifier, image_device_number, real_device_number, readonly)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Device_Dedicate_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_device_number = argArray.nextMaybeQuotationTuplePopString();
                String real_device_number = argArray.nextMaybeQuotationTuplePopString();
                int readonly = argArray.nextIntMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageDeviceDedicateDM(hostname, port, userid, password, target_identifier, image_device_number, real_device_number, readonly)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Device_Reset": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_device_number = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageDeviceReset(hostname, port, userid, password, target_identifier, image_device_number)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Device_Undedicate": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_device_number = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageDeviceUndedicate(hostname, port, userid, password, target_identifier, image_device_number)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Device_Undedicate_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_device_number = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageDeviceUndedicateDM(hostname, port, userid, password, target_identifier, image_device_number)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Disk_Copy": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_disk_number = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageDiskCopy(hostname, port, userid, password, target_identifier, image_disk_number)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Disk_Copy_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_disk_number = argArray.nextMaybeQuotationTuplePopString();
                String source_image_name = argArray.nextMaybeQuotationTuplePopString();
                String source_image_disk_number = argArray.nextMaybeQuotationTuplePopString();
                String image_disk_allocation_type = argArray.nextMaybeQuotationTuplePopString();
                String allocation_area_name_or_volser = argArray.nextMaybeQuotationTuplePopString();
                String image_disk_mode = argArray.nextMaybeQuotationTuplePopString();
                String read_password = argArray.nextMaybeQuotationTuplePopString();
                String write_password = argArray.nextMaybeQuotationTuplePopString();
                String multi_password = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageDiskCopyDM(hostname, port, userid, password, target_identifier, image_disk_number, source_image_name, source_image_disk_number, image_disk_allocation_type, allocation_area_name_or_volser, image_disk_mode, read_password, write_password, multi_password)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Disk_Create": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_disk_number = argArray.nextMaybeQuotationTuplePopString();
                String image_disk_mode = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageDiskCreate(hostname, port, userid, password, target_identifier, image_disk_number, image_disk_mode)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Disk_Create_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_disk_number = argArray.nextMaybeQuotationTuplePopString();
                String image_disk_device_type = argArray.nextMaybeQuotationTuplePopString();
                String image_disk_allocation_type = argArray.nextMaybeQuotationTuplePopString();
                String allocation_area_name_or_volser = argArray.nextMaybeQuotationTuplePopString();
                int allocation_unit_size = argArray.nextIntMaybeQuotationTuplePopString();
                int image_disk_size = argArray.nextIntMaybeQuotationTuplePopString();
                String image_disk_mode = argArray.nextMaybeQuotationTuplePopString();
                int image_disk_formatting = argArray.nextIntMaybeQuotationTuplePopString();
                String image_disk_label = argArray.nextMaybeQuotationTuplePopString();
                String read_password = argArray.nextMaybeQuotationTuplePopString();
                String write_password = argArray.nextMaybeQuotationTuplePopString();
                String multi_password = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageDiskCreateDM(hostname, port, userid, password, target_identifier, image_disk_number, image_disk_device_type, image_disk_allocation_type, allocation_area_name_or_volser, allocation_unit_size, image_disk_size, image_disk_mode, image_disk_formatting, image_disk_label, read_password, write_password, multi_password)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Disk_Delete": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_disk_number = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageDiskDelete(hostname, port, userid, password, target_identifier, image_disk_number)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Disk_Delete_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_disk_number = argArray.nextMaybeQuotationTuplePopString();
                int data_security_erase = argArray.nextIntMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageDiskDeleteDM(hostname, port, userid, password, target_identifier, image_disk_number, data_security_erase)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Disk_Share": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_disk_number = argArray.nextMaybeQuotationTuplePopString();
                String target_image_name = argArray.nextMaybeQuotationTuplePopString();
                String target_image_disk_number = argArray.nextMaybeQuotationTuplePopString();
                String read_write_mode = argArray.nextMaybeQuotationTuplePopString();
                String optional_password = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageDiskShare(hostname, port, userid, password, target_identifier, image_disk_number, target_image_name, target_image_disk_number, read_write_mode, optional_password)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Disk_Share_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_disk_number = argArray.nextMaybeQuotationTuplePopString();
                String target_image_name = argArray.nextMaybeQuotationTuplePopString();
                String target_image_disk_number = argArray.nextMaybeQuotationTuplePopString();
                String read_write_mode = argArray.nextMaybeQuotationTuplePopString();
                String optional_password = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageDiskShareDM(hostname, port, userid, password, target_identifier, image_disk_number, target_image_name, target_image_disk_number, read_write_mode, optional_password)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Disk_Unshare": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_disk_number = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageDiskUnshare(hostname, port, userid, password, target_identifier, image_disk_number)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Disk_Unshare_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_disk_number = argArray.nextMaybeQuotationTuplePopString();
                String target_image_name = argArray.nextMaybeQuotationTuplePopString();
                String target_image_disk_number = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageDiskUnshareDM(hostname, port, userid, password, target_identifier, image_disk_number, target_image_name, target_image_disk_number)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Lock_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String device_address = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageLockDM(hostname, port, userid, password, target_identifier, device_address)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Name_Query_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageNameQueryDM(hostname, port, userid, password, target_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Password_Set_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_password = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImagePasswordSetDM(hostname, port, userid, password, target_identifier, image_password)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Query_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageQueryDM(hostname, port, userid, password, target_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Query_Activate_Time": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                int date_format_indicator = argArray.nextIntMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageQueryActivateTime(hostname, port, userid, password, target_identifier, date_format_indicator)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Recycle": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageRecycle(hostname, port, userid, password, target_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Replace_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                Tuple image_record_array_tuple = argArray.nextTupleOrPop();                
                ImageRecordArray image_record_array = ImageRecordArray.class.cast(image_record_array_tuple.getValue());
                resultParameterArray
                        = new ImageReplaceDM(hostname, port, userid, password, target_identifier, image_record_array)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Status_Query": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageStatusQuery(hostname, port, userid, password, target_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Unlock_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String device_address = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageUnlockDM(hostname, port, userid, password, target_identifier, device_address)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Volume_Add": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_device_number = argArray.nextMaybeQuotationTuplePopString();
                String image_vol_id = argArray.nextMaybeQuotationTuplePopString();
                String system_config_name = argArray.nextMaybeQuotationTuplePopString();
                String system_config_type = argArray.nextMaybeQuotationTuplePopString();
                String parm_disk_owner = argArray.nextMaybeQuotationTuplePopString();
                String parm_disk_number = argArray.nextMaybeQuotationTuplePopString();
                String parm_disk_password = argArray.nextMaybeQuotationTuplePopString();
                String alt_system_config_name = argArray.nextMaybeQuotationTuplePopString();
                String alt_system_config_type = argArray.nextMaybeQuotationTuplePopString();
                String alt_parm_disk_owner = argArray.nextMaybeQuotationTuplePopString();
                String alt_parm_disk_number = argArray.nextMaybeQuotationTuplePopString();
                String alt_parm_disk_password = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageVolumeAdd(hostname, port, userid, password, target_identifier, image_device_number, image_vol_id, system_config_name, system_config_type, parm_disk_owner, parm_disk_number, parm_disk_password, alt_system_config_name, alt_system_config_type, alt_parm_disk_owner, alt_parm_disk_number, alt_parm_disk_password)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Volume_Delete": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_device_number = argArray.nextMaybeQuotationTuplePopString();
                String image_vol_id = argArray.nextMaybeQuotationTuplePopString();
                String system_config_name = argArray.nextMaybeQuotationTuplePopString();
                String system_config_type = argArray.nextMaybeQuotationTuplePopString();
                String parm_disk_owner = argArray.nextMaybeQuotationTuplePopString();
                String parm_disk_number = argArray.nextMaybeQuotationTuplePopString();
                String parm_disk_password = argArray.nextMaybeQuotationTuplePopString();
                String alt_system_config_name = argArray.nextMaybeQuotationTuplePopString();
                String alt_system_config_type = argArray.nextMaybeQuotationTuplePopString();
                String alt_parm_disk_owner = argArray.nextMaybeQuotationTuplePopString();
                String alt_parm_disk_number = argArray.nextMaybeQuotationTuplePopString();
                String alt_parm_disk_password = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageVolumeDelete(hostname, port, userid, password, target_identifier, image_device_number, image_vol_id, system_config_name, system_config_type, parm_disk_owner, parm_disk_number, parm_disk_password, alt_system_config_name, alt_system_config_type, alt_parm_disk_owner, alt_parm_disk_number, alt_parm_disk_password)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Volume_Space_Define_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                int function_type = argArray.nextIntMaybeQuotationTuplePopString();
                String region_name = argArray.nextMaybeQuotationTuplePopString();
                String image_vol_id = argArray.nextMaybeQuotationTuplePopString();
                int start_cylinder = argArray.nextIntMaybeQuotationTuplePopString();
                int size = argArray.nextIntMaybeQuotationTuplePopString();
                String group_name = argArray.nextMaybeQuotationTuplePopString();
                int device_type = argArray.nextIntMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageVolumeSpaceDefineDM(hostname, port, userid, password, target_identifier, function_type, region_name, image_vol_id, start_cylinder, size, group_name, device_type)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Volume_Space_Query_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                int query_type = argArray.nextIntMaybeQuotationTuplePopString();
                int entry_type = argArray.nextIntMaybeQuotationTuplePopString();
                String entry_names = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageVolumeSpaceQueryDM(hostname, port, userid, password, target_identifier, query_type, entry_type, entry_names)
                        .doIt(use_ssl);
            }
	    break;
            case "Image_Volume_Space_Remove_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                int function_type = argArray.nextIntMaybeQuotationTuplePopString();
                String region_name = argArray.nextMaybeQuotationTuplePopString();
                String image_vol_id = argArray.nextMaybeQuotationTuplePopString();
                String group_name = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ImageVolumeSpaceRemoveDM(hostname, port, userid, password, target_identifier, function_type, region_name, image_vol_id, group_name)
                        .doIt(use_ssl);
            }
	    break;
            case "Name_List_Add": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String name = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new NameListAdd(hostname, port, userid, password, target_identifier, name)
                        .doIt(use_ssl);
            }
	    break;
            case "Name_List_Destroy": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String name = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new NameListDestroy(hostname, port, userid, password, target_identifier, name)
                        .doIt(use_ssl);
            }
	    break;
            case "Name_List_Query": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new NameListQuery(hostname, port, userid, password, target_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Name_List_Remove": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String name = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new NameListRemove(hostname, port, userid, password, target_identifier, name)
                        .doIt(use_ssl);
            }
	    break;
            case "Profile_Create_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                Tuple profile_record_array_tuple = argArray.nextTupleOrPop();                
                ProfileRecordArray profile_record_array = ProfileRecordArray.class.cast(profile_record_array_tuple.getValue());
                resultParameterArray
                        = new ProfileCreateDM(hostname, port, userid, password, target_identifier, profile_record_array)
                        .doIt(use_ssl);
            }
	    break;
            case "Profile_Delete_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ProfileDeleteDM(hostname, port, userid, password, target_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Profile_Lock_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ProfileLockDM(hostname, port, userid, password, target_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Profile_Query_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ProfileQueryDM(hostname, port, userid, password, target_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Profile_Replace_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                Tuple profile_record_array_tuple = argArray.nextTupleOrPop();                
                ProfileRecordArray profile_record_array = ProfileRecordArray.class.cast(profile_record_array_tuple.getValue());
                resultParameterArray
                        = new ProfileReplaceDM(hostname, port, userid, password, target_identifier, profile_record_array)
                        .doIt(use_ssl);
            }
	    break;
            case "Profile_Unlock_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ProfileUnlockDM(hostname, port, userid, password, target_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Prototype_Create_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                Tuple prototype_record_array_tuple = argArray.nextTupleOrPop();                
                PrototypeRecordArray prototype_record_array = PrototypeRecordArray.class.cast(prototype_record_array_tuple.getValue());
                resultParameterArray
                        = new PrototypeCreateDM(hostname, port, userid, password, target_identifier, prototype_record_array)
                        .doIt(use_ssl);
            }
	    break;
            case "Prototype_Delete_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new PrototypeDeleteDM(hostname, port, userid, password, target_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Prototype_Name_Query_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new PrototypeNameQueryDM(hostname, port, userid, password, target_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Prototype_Query_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new PrototypeQueryDM(hostname, port, userid, password, target_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Prototype_Replace_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                Tuple prototype_record_array_tuple = argArray.nextTupleOrPop();                
                PrototypeRecordArray prototype_record_array = PrototypeRecordArray.class.cast(prototype_record_array_tuple.getValue());
                resultParameterArray
                        = new PrototypeReplaceDM(hostname, port, userid, password, target_identifier, prototype_record_array)
                        .doIt(use_ssl);
            }
	    break;
            case "Query_API_Functional_Level": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new QueryAPIFunctionalLevel(hostname, port, userid, password, target_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Query_All_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String query_keyword_parameter_list = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new QueryAllDM(hostname, port, userid, password, target_identifier, query_keyword_parameter_list)
                        .doIt(use_ssl);
            }
	    break;
            case "Query_Asynchronous_Operation_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                int operation_id = argArray.nextIntMaybeQuotationTuplePopString();
                resultParameterArray
                        = new QueryAsynchronousOperationDM(hostname, port, userid, password, target_identifier, operation_id)
                        .doIt(use_ssl);
            }
	    break;
            case "Query_Directory_Manager_Level_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new QueryDirectoryManagerLevelDM(hostname, port, userid, password, target_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Response_Recovery": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new ResponseRecovery(hostname, port, userid, password, target_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Shared_Memory_Access_Add_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String memory_segment_name = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new SharedMemoryAccessAddDM(hostname, port, userid, password, target_identifier, memory_segment_name)
                        .doIt(use_ssl);
            }
	    break;
            case "Shared_Memory_Access_Query_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String memory_segment_name = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new SharedMemoryAccessQueryDM(hostname, port, userid, password, target_identifier, memory_segment_name)
                        .doIt(use_ssl);
            }
	    break;
            case "Shared_Memory_Access_Remove_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String memory_segment_name = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new SharedMemoryAccessRemoveDM(hostname, port, userid, password, target_identifier, memory_segment_name)
                        .doIt(use_ssl);
            }
	    break;
            case "Shared_Memory_Create": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String memory_segment_name = argArray.nextMaybeQuotationTuplePopString();
                int begin_page = argArray.nextIntMaybeQuotationTuplePopString();
                int end_page = argArray.nextIntMaybeQuotationTuplePopString();
                int page_access_descriptor = argArray.nextIntMaybeQuotationTuplePopString();
                int memory_attributes = argArray.nextIntMaybeQuotationTuplePopString();
                String memory_access_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new SharedMemoryCreate(hostname, port, userid, password, target_identifier, memory_segment_name, begin_page, end_page, page_access_descriptor, memory_attributes, memory_access_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Shared_Memory_Delete": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String memory_segment_name = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new SharedMemoryDelete(hostname, port, userid, password, target_identifier, memory_segment_name)
                        .doIt(use_ssl);
            }
	    break;
            case "Shared_Memory_Query": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String memory_segment_name = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new SharedMemoryQuery(hostname, port, userid, password, target_identifier, memory_segment_name)
                        .doIt(use_ssl);
            }
	    break;
            case "Shared_Memory_Replace": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String memory_segment_name = argArray.nextMaybeQuotationTuplePopString();
                String memory_access_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new SharedMemoryReplace(hostname, port, userid, password, target_identifier, memory_segment_name, memory_access_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Static_Image_Changes_Activate_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new StaticImageChangesActivateDM(hostname, port, userid, password, target_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Static_Image_Changes_Deactivate_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new StaticImageChangesDeactivateDM(hostname, port, userid, password, target_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Static_Image_Changes_Immediate_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new StaticImageChangesImmediateDM(hostname, port, userid, password, target_identifier)
                        .doIt(use_ssl);
            }
	    break;
            case "Virtual_Channel_Connection_Create": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_device_number = argArray.nextMaybeQuotationTuplePopString();
                String coupled_image_name = argArray.nextMaybeQuotationTuplePopString();
                String coupled_image_device_number = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new VirtualChannelConnectionCreate(hostname, port, userid, password, target_identifier, image_device_number, coupled_image_name, coupled_image_device_number)
                        .doIt(use_ssl);
            }
	    break;
            case "Virtual_Channel_Connection_Create_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_device_number = argArray.nextMaybeQuotationTuplePopString();
                String coupled_image_name = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new VirtualChannelConnectionCreateDM(hostname, port, userid, password, target_identifier, image_device_number, coupled_image_name)
                        .doIt(use_ssl);
            }
	    break;
            case "Virtual_Channel_Connection_Delete": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_device_number = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new VirtualChannelConnectionDelete(hostname, port, userid, password, target_identifier, image_device_number)
                        .doIt(use_ssl);
            }
	    break;
            case "Virtual_Channel_Connection_Delete_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_device_number = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new VirtualChannelConnectionDeleteDM(hostname, port, userid, password, target_identifier, image_device_number)
                        .doIt(use_ssl);
            }
	    break;
            case "Virtual_Network_LAN_Access": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String lan_name = argArray.nextMaybeQuotationTuplePopString();
                String lan_owner = argArray.nextMaybeQuotationTuplePopString();
                String access_op = argArray.nextMaybeQuotationTuplePopString();
                String access_user = argArray.nextMaybeQuotationTuplePopString();
                String promiscuity = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new VirtualNetworkLANAccess(hostname, port, userid, password, target_identifier, lan_name, lan_owner, access_op, access_user, promiscuity)
                        .doIt(use_ssl);
            }
	    break;
            case "Virtual_Network_LAN_Access_Query": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String lan_name = argArray.nextMaybeQuotationTuplePopString();
                String lan_owner = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new VirtualNetworkLANAccessQuery(hostname, port, userid, password, target_identifier, lan_name, lan_owner)
                        .doIt(use_ssl);
            }
	    break;
            case "Virtual_Network_LAN_Create": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String lan_name = argArray.nextMaybeQuotationTuplePopString();
                String lan_owner = argArray.nextMaybeQuotationTuplePopString();
                int lan_type = argArray.nextIntMaybeQuotationTuplePopString();
                int transport_type = argArray.nextIntMaybeQuotationTuplePopString();
                resultParameterArray
                        = new VirtualNetworkLANCreate(hostname, port, userid, password, target_identifier, lan_name, lan_owner, lan_type, transport_type)
                        .doIt(use_ssl);
            }
	    break;
            case "Virtual_Network_LAN_Delete": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String lan_name = argArray.nextMaybeQuotationTuplePopString();
                String lan_owner = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new VirtualNetworkLANDelete(hostname, port, userid, password, target_identifier, lan_name, lan_owner)
                        .doIt(use_ssl);
            }
	    break;
            case "Virtual_Network_LAN_Query": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String lan_name = argArray.nextMaybeQuotationTuplePopString();
                String lan_owner = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new VirtualNetworkLANQuery(hostname, port, userid, password, target_identifier, lan_name, lan_owner)
                        .doIt(use_ssl);
            }
	    break;
            case "Virtual_Network_Adapter_Connect_LAN": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String lan_name = argArray.nextMaybeQuotationTuplePopString();
                String lan_owner = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new VirtualNetworkAdapterConnectLAN(hostname, port, userid, password, target_identifier, lan_name, lan_owner)
                        .doIt(use_ssl);
            }
	    break;
            case "Virtual_Network_Adapter_Connect_LAN_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String lan_name = argArray.nextMaybeQuotationTuplePopString();
                String lan_owner = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new VirtualNetworkAdapterConnectLANDM(hostname, port, userid, password, target_identifier, lan_name, lan_owner)
                        .doIt(use_ssl);
            }
	    break;
            case "Virtual_Network_Adapter_Connect_Vswitch": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_device_number = argArray.nextMaybeQuotationTuplePopString();
                String switch_name = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new VirtualNetworkAdapterConnectVswitch(hostname, port, userid, password, target_identifier, image_device_number, switch_name)
                        .doIt(use_ssl);
            }
	    break;
            case "Virtual_Network_Adapter_Connect_Vswitch_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_device_number = argArray.nextMaybeQuotationTuplePopString();
                String switch_name = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new VirtualNetworkAdapterConnectVswitchDM(hostname, port, userid, password, target_identifier, image_device_number, switch_name)
                        .doIt(use_ssl);
            }
	    break;
            case "Virtual_Network_Adapter_Create": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_device_number = argArray.nextMaybeQuotationTuplePopString();
                int adapter_type = argArray.nextIntMaybeQuotationTuplePopString();
                int network_adapter_devices = argArray.nextIntMaybeQuotationTuplePopString();
                String channel_path_id = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new VirtualNetworkAdapterCreate(hostname, port, userid, password, target_identifier, image_device_number, adapter_type, network_adapter_devices, channel_path_id)
                        .doIt(use_ssl);
            }
	    break;
            case "Virtual_Network_Adapter_Create_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_device_number = argArray.nextMaybeQuotationTuplePopString();
                int adapter_type = argArray.nextIntMaybeQuotationTuplePopString();
                int network_adapter_devices = argArray.nextIntMaybeQuotationTuplePopString();
                String channel_path_id = argArray.nextMaybeQuotationTuplePopString();
                String mac_id = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new VirtualNetworkAdapterCreateDM(hostname, port, userid, password, target_identifier, image_device_number, adapter_type, network_adapter_devices, channel_path_id, mac_id)
                        .doIt(use_ssl);
            }
	    break;
            case "Virtual_Network_Adapter_Delete": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_device_number = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new VirtualNetworkAdapterDelete(hostname, port, userid, password, target_identifier, image_device_number)
                        .doIt(use_ssl);
            }
	    break;
            case "Virtual_Network_Adapter_Delete_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_device_number = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new VirtualNetworkAdapterDeleteDM(hostname, port, userid, password, target_identifier, image_device_number)
                        .doIt(use_ssl);
            }
	    break;
            case "Virtual_Network_Adapter_Disconnect": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_device_number = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new VirtualNetworkAdapterDisconnect(hostname, port, userid, password, target_identifier, image_device_number)
                        .doIt(use_ssl);
            }
	    break;
            case "Virtual_Network_Adapter_Disconnect_DM": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_device_number = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new VirtualNetworkAdapterDisconnectDM(hostname, port, userid, password, target_identifier, image_device_number)
                        .doIt(use_ssl);
            }
	    break;
            case "Virtual_Network_Adapter_Query": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String image_device_number = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new VirtualNetworkAdapterQuery(hostname, port, userid, password, target_identifier, image_device_number)
                        .doIt(use_ssl);
            }
	    break;
            case "Virtual_Network_Vswitch_Create": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String switch_name = argArray.nextMaybeQuotationTuplePopString();
                String real_device_address = argArray.nextMaybeQuotationTuplePopString();
                String port_name = argArray.nextMaybeQuotationTuplePopString();
                String controller_name = argArray.nextMaybeQuotationTuplePopString();
                int connection_value = argArray.nextIntMaybeQuotationTuplePopString();
                int queue_memory_limit = argArray.nextIntMaybeQuotationTuplePopString();
                int routing_value = argArray.nextIntMaybeQuotationTuplePopString();
                int transport_type = argArray.nextIntMaybeQuotationTuplePopString();
                int vlan_id = argArray.nextIntMaybeQuotationTuplePopString();
                int port_type = argArray.nextIntMaybeQuotationTuplePopString();
                int update_system_config_indicator = argArray.nextIntMaybeQuotationTuplePopString();
                String system_config_name = argArray.nextMaybeQuotationTuplePopString();
                String system_config_type = argArray.nextMaybeQuotationTuplePopString();
                String parm_disk_owner = argArray.nextMaybeQuotationTuplePopString();
                String parm_disk_number = argArray.nextMaybeQuotationTuplePopString();
                String parm_disk_password = argArray.nextMaybeQuotationTuplePopString();
                String alt_system_config_name = argArray.nextMaybeQuotationTuplePopString();
                String alt_system_config_type = argArray.nextMaybeQuotationTuplePopString();
                String alt_parm_disk_owner = argArray.nextMaybeQuotationTuplePopString();
                String alt_parm_disk_number = argArray.nextMaybeQuotationTuplePopString();
                String alt_parm_disk_password = argArray.nextMaybeQuotationTuplePopString();
                int gvrp_value = argArray.nextIntMaybeQuotationTuplePopString();
                resultParameterArray
                        = new VirtualNetworkVswitchCreate(hostname, port, userid, password, target_identifier, switch_name, real_device_address, port_name, controller_name, connection_value, queue_memory_limit, routing_value, transport_type, vlan_id, port_type, update_system_config_indicator, system_config_name, system_config_type, parm_disk_owner, parm_disk_number, parm_disk_password, alt_system_config_name, alt_system_config_type, alt_parm_disk_owner, alt_parm_disk_number, alt_parm_disk_password, gvrp_value)
                        .doIt(use_ssl);
            }
	    break;
            case "Virtual_Network_Vswitch_Delete": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String switch_name = argArray.nextMaybeQuotationTuplePopString();
                int update_system_config_indicator = argArray.nextIntMaybeQuotationTuplePopString();
                String system_config_name = argArray.nextMaybeQuotationTuplePopString();
                String system_config_type = argArray.nextMaybeQuotationTuplePopString();
                String parm_disk_owner = argArray.nextMaybeQuotationTuplePopString();
                String parm_disk_number = argArray.nextMaybeQuotationTuplePopString();
                String parm_disk_password = argArray.nextMaybeQuotationTuplePopString();
                String alt_system_config_name = argArray.nextMaybeQuotationTuplePopString();
                String alt_system_config_type = argArray.nextMaybeQuotationTuplePopString();
                String alt_parm_disk_owner = argArray.nextMaybeQuotationTuplePopString();
                String alt_parm_disk_number = argArray.nextMaybeQuotationTuplePopString();
                String alt_parm_disk_password = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new VirtualNetworkVswitchDelete(hostname, port, userid, password, target_identifier, switch_name, update_system_config_indicator, system_config_name, system_config_type, parm_disk_owner, parm_disk_number, parm_disk_password, alt_system_config_name, alt_system_config_type, alt_parm_disk_owner, alt_parm_disk_number, alt_parm_disk_password)
                        .doIt(use_ssl);
            }
	    break;
            case "Virtual_Network_Vswitch_Query": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String switch_name = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new VirtualNetworkVswitchQuery(hostname, port, userid, password, target_identifier, switch_name)
                        .doIt(use_ssl);
            }
	    break;
            case "Virtual_Network_Vswitch_Set": {
                String target_identifier = argArray.nextMaybeQuotationTuplePopString();
                String switch_name = argArray.nextMaybeQuotationTuplePopString();
                String grant_userid = argArray.nextMaybeQuotationTuplePopString();
                String user_vlan_id = argArray.nextMaybeQuotationTuplePopString();
                String revoke_userid = argArray.nextMaybeQuotationTuplePopString();
                String real_device_address = argArray.nextMaybeQuotationTuplePopString();
                String port_name = argArray.nextMaybeQuotationTuplePopString();
                String controller_name = argArray.nextMaybeQuotationTuplePopString();
                int connection_value = argArray.nextIntMaybeQuotationTuplePopString();
                int queue_memory_limit = argArray.nextIntMaybeQuotationTuplePopString();
                int routing_value = argArray.nextIntMaybeQuotationTuplePopString();
                int port_type = argArray.nextIntMaybeQuotationTuplePopString();
                int update_system_config_indicator = argArray.nextIntMaybeQuotationTuplePopString();
                String system_config_name = argArray.nextMaybeQuotationTuplePopString();
                String system_config_type = argArray.nextMaybeQuotationTuplePopString();
                String parm_disk_owner = argArray.nextMaybeQuotationTuplePopString();
                String parm_disk_number = argArray.nextMaybeQuotationTuplePopString();
                String parm_disk_password = argArray.nextMaybeQuotationTuplePopString();
                String alt_system_config_name = argArray.nextMaybeQuotationTuplePopString();
                String alt_system_config_type = argArray.nextMaybeQuotationTuplePopString();
                String alt_parm_disk_owner = argArray.nextMaybeQuotationTuplePopString();
                String alt_parm_disk_number = argArray.nextMaybeQuotationTuplePopString();
                String alt_parm_disk_password = argArray.nextMaybeQuotationTuplePopString();
                int gvrp_value = argArray.nextIntMaybeQuotationTuplePopString();
                String mac_id = argArray.nextMaybeQuotationTuplePopString();
                resultParameterArray
                        = new VirtualNetworkVswitchSet(hostname, port, userid, password, target_identifier, switch_name, grant_userid, user_vlan_id, revoke_userid, real_device_address, port_name, controller_name, connection_value, queue_memory_limit, routing_value, port_type, update_system_config_indicator, system_config_name, system_config_type, parm_disk_owner, parm_disk_number, parm_disk_password, alt_system_config_name, alt_system_config_type, alt_parm_disk_owner, alt_parm_disk_number, alt_parm_disk_password, gvrp_value, mac_id)
                        .doIt(use_ssl);
            }
	    break;
            default:
                command.getLogger().log(Level.SEVERE, "Unknown or unimplemented SMAPI function {0} in {1}", new Object[]{funcName, command.getNameAndDescription()});
                command.setCommandResult(CommandInterface.COMMANDRESULT.FAILURE);
        }
        return resultParameterArray;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" host=").append(host)
                .append(" funcName=").append(funcName).append(" command=").append(command).append(" argarray=").append(argArray);
        return sb.toString();

    }
}
