/*
 * Copyright (c) 2015, Absolute Performance, Inc. http://www.absolute-performance.com
 * Copyright (c) 2017, Jack J. Woehr jwoehr@softwoehr.com 
 * SoftWoehr LLC PO Box 82, Beulah CO 81023-0082 http://www.softwoehr.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package ublu.win;

import java.awt.event.KeyEvent;
import javax.swing.JScrollBar;
// import javax.swing.JEditorPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import ublu.util.Generics.StringArrayList;

/**
 *
 * @author jax
 */
public class UbluPanel extends javax.swing.JPanel {

    private final TextAreaOutputStream jTAOS;
    private UbluFrame ubluFrame;
    private final StringArrayList commands;
    private int pointer = 0;

    private int decPointer() {
        pointer = Math.max(0, --pointer);
        return pointer;
    }

    private int incPointer() {
        pointer = Math.min(commands.size() - 1, ++pointer);
        return pointer;
    }

    private String foreCommand() {
        String result = "";
        if (commands.size() > 0) {
            incPointer();
            result = commands.get(pointer);
        }
        return result;
    }

    private String backCommand() {
        String result = "";
        if (commands.size() > 0) {
            decPointer();
            result = commands.get(pointer);
        }
        return result;
    }

    private String firstCommand() {
        String result = "";
        if (commands.size() > 0) {
            pointer = 0;
            result = commands.get(pointer);
        }
        return result;
    }

    private String lastCommand() {
        String result = "";
        if (commands.size() > 0) {
            pointer = commands.size() - 1;
            result = commands.get(pointer);
        }
        return result;
    }

    /**
     *
     * @return
     */
    public TextAreaOutputStream getjTAOS() {
        return jTAOS;
    }

    /**
     *
     * @param ubluFrame
     */
    protected void setUbluFrame(UbluFrame ubluFrame) {
        this.ubluFrame = ubluFrame;
    }

    /**
     * Creates new form UbluPanel
     */
    public UbluPanel() {
        this.commands = new StringArrayList();
        initComponents();
        jTAOS = new TextAreaOutputStream(this);
    }

    /**
     * Like it sez
     */
    protected void scrollToEnd() {
        JScrollBar jsb = jScrollPane1.getVerticalScrollBar();
        jsb.setValue(jsb.getMaximum());
    }

    /**
     *
     * @return
     */
    protected JTextArea getUbluTextArea() {
        return ubluTextArea;
    }

    /**
     *
     * @return
     */
    protected JTextField getUbluTextField() {
        return ubluInputField;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        ubluTextArea = new javax.swing.JTextArea();
        ubluInputField = new javax.swing.JTextField();

        setDoubleBuffered(false);
        setLayout(new java.awt.BorderLayout());

        jScrollPane1.setFont(new java.awt.Font("Lucida Sans Typewriter", 0, 13)); // NOI18N

        ubluTextArea.setFont(new java.awt.Font("Lucida Sans Typewriter", 0, 13)); // NOI18N
        ubluTextArea.setDoubleBuffered(true);
        ubluTextArea.setName(""); // NOI18N
        ubluTextArea.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                ubluTextAreaKeyReleased(evt);
            }
        });
        jScrollPane1.setViewportView(ubluTextArea);

        add(jScrollPane1, java.awt.BorderLayout.CENTER);

        ubluInputField.setFont(new java.awt.Font("Lucida Sans Typewriter", 0, 13)); // NOI18N
        ubluInputField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                ubluInputFieldKeyReleased(evt);
            }
        });
        add(ubluInputField, java.awt.BorderLayout.PAGE_END);
    }// </editor-fold>//GEN-END:initComponents

    private void ubluInputFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_ubluInputFieldKeyReleased
        switch (evt.getKeyCode()) {
            case KeyEvent.VK_ENTER:
                String ubluText = ubluInputField.getText();
                if (!ubluText.equals("")) {
                    commands.add(ubluText);
                    pointer = commands.size();
                }
                ubluText = ubluText + '\n';
                // jEPOS.write((ubluText).getBytes());
                jTAOS.write((ubluText).getBytes());
                ubluInputField.setText("");
                ubluFrame.interpretText(ubluText);
                scrollToEnd();
                break;
            case KeyEvent.VK_UP:
                ubluInputField.setText(backCommand());
                break;
            case KeyEvent.VK_DOWN:
                ubluInputField.setText(foreCommand());
                break;
            case KeyEvent.VK_PAGE_UP:
                ubluInputField.setText(firstCommand());
                break;
            case KeyEvent.VK_PAGE_DOWN:
                ubluInputField.setText(lastCommand());
                break;
            case KeyEvent.VK_TAB:
                if (evt.isControlDown()) {
                    ubluTextArea.requestFocus();
                }
                break;
        }
    }//GEN-LAST:event_ubluInputFieldKeyReleased

    private void ubluTextAreaKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_ubluTextAreaKeyReleased
        switch (evt.getKeyCode()) {
            case KeyEvent.VK_TAB:
                if (evt.isControlDown()) {
                    ubluInputField.requestFocus();
                }
                break;
        }
    }//GEN-LAST:event_ubluTextAreaKeyReleased


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextField ubluInputField;
    private javax.swing.JTextArea ubluTextArea;
    // End of variables declaration//GEN-END:variables
}
