/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import org.xbill.DNS.Options;
import org.xbill.DNS.utils.hexdump;

class Client {
    protected long endTime;
    protected SelectionKey key;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Client(SelectableChannel channel, long endTime) throws IOException {
        boolean done;
        block5: {
            done = false;
            Selector selector = null;
            this.endTime = endTime;
            try {
                selector = Selector.open();
                channel.configureBlocking(false);
                this.key = channel.register(selector, 0);
                done = true;
                Object var7_5 = null;
                if (done || selector == null) break block5;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (!done && selector != null) {
                    selector.close();
                }
                if (!done) {
                    channel.close();
                }
                throw throwable;
            }
            selector.close();
        }
        if (!done) {
            channel.close();
        }
    }

    protected static void blockUntil(SelectionKey key, long endTime) throws IOException {
        long timeout = endTime - System.currentTimeMillis();
        int nkeys = 0;
        if (timeout > 0L) {
            nkeys = key.selector().select(timeout);
        } else if (timeout == 0L) {
            nkeys = key.selector().selectNow();
        }
        if (nkeys == 0) {
            throw new SocketTimeoutException();
        }
    }

    protected static void verboseLog(String prefix, byte[] data) {
        if (Options.check("verbosemsg")) {
            System.err.println(hexdump.dump(prefix, data));
        }
    }

    void cleanup() throws IOException {
        this.key.selector().close();
        this.key.channel().close();
    }
}

