/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.xbill.DNS.Client;

final class TCPClient
extends Client {
    public TCPClient(long endTime) throws IOException {
        super(SocketChannel.open(), endTime);
    }

    void bind(SocketAddress addr) throws IOException {
        SocketChannel channel = (SocketChannel)this.key.channel();
        channel.socket().bind(addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connect(SocketAddress addr) throws IOException {
        block5: {
            SocketChannel channel = (SocketChannel)this.key.channel();
            if (channel.connect(addr)) {
                return;
            }
            this.key.interestOps(8);
            try {
                while (!channel.finishConnect()) {
                    if (this.key.isConnectable()) continue;
                    TCPClient.blockUntil(this.key, this.endTime);
                }
                Object var4_3 = null;
                if (!this.key.isValid()) break block5;
                this.key.interestOps(0);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (this.key.isValid()) {
                    this.key.interestOps(0);
                }
                throw throwable;
            }
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(byte[] data) throws IOException {
        block6: {
            SocketChannel channel = (SocketChannel)this.key.channel();
            TCPClient.verboseLog("TCP write", data);
            byte[] lengthArray = new byte[]{(byte)(data.length >>> 8), (byte)(data.length & 0xFF)};
            ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.wrap(lengthArray), ByteBuffer.wrap(data)};
            int nsent = 0;
            this.key.interestOps(4);
            try {
                while (nsent < data.length + 2) {
                    if (this.key.isWritable()) {
                        long n = channel.write(buffers);
                        if (n < 0L) {
                            throw new EOFException();
                        }
                        nsent += (int)n;
                        continue;
                    }
                    TCPClient.blockUntil(this.key, this.endTime);
                }
                Object var9_7 = null;
                if (!this.key.isValid()) break block6;
                this.key.interestOps(0);
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                if (this.key.isValid()) {
                    this.key.interestOps(0);
                }
                throw throwable;
            }
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] _recv(int length) throws IOException {
        byte[] data;
        block6: {
            SocketChannel channel = (SocketChannel)this.key.channel();
            int nrecvd = 0;
            data = new byte[length];
            ByteBuffer buffer = ByteBuffer.wrap(data);
            this.key.interestOps(1);
            try {
                while (nrecvd < length) {
                    if (this.key.isReadable()) {
                        long n = channel.read(buffer);
                        if (n < 0L) {
                            throw new EOFException();
                        }
                        nrecvd += (int)n;
                        continue;
                    }
                    TCPClient.blockUntil(this.key, this.endTime);
                }
                Object var9_7 = null;
                if (!this.key.isValid()) break block6;
                this.key.interestOps(0);
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                if (this.key.isValid()) {
                    this.key.interestOps(0);
                }
                throw throwable;
            }
            {
            }
        }
        return data;
    }

    byte[] recv() throws IOException {
        byte[] buf = this._recv(2);
        int length = ((buf[0] & 0xFF) << 8) + (buf[1] & 0xFF);
        byte[] data = this._recv(length);
        TCPClient.verboseLog("TCP read", data);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] sendrecv(SocketAddress local, SocketAddress remote, byte[] data, long endTime) throws IOException {
        TCPClient client = new TCPClient(endTime);
        try {
            if (local != null) {
                client.bind(local);
            }
            client.connect(remote);
            client.send(data);
            byte[] byArray = client.recv();
            return byArray;
        }
        finally {
            client.cleanup();
        }
    }

    static byte[] sendrecv(SocketAddress addr, byte[] data, long endTime) throws IOException {
        return TCPClient.sendrecv(null, addr, data, endTime);
    }
}

