/*
 * Decompiled with CFR 0.152.
 */
package uk.nominet.dnsjnio;

import java.net.SocketTimeoutException;
import org.xbill.DNS.Message;
import org.xbill.DNS.ResolverListener;
import uk.nominet.dnsjnio.Connection;
import uk.nominet.dnsjnio.ConnectionListener;
import uk.nominet.dnsjnio.QueryData;
import uk.nominet.dnsjnio.ResponderThread;
import uk.nominet.dnsjnio.Response;
import uk.nominet.dnsjnio.ResponseQueue;
import uk.nominet.dnsjnio.TimerListener;

public abstract class AbstractTransaction
implements ConnectionListener,
TimerListener {
    protected boolean disconnect(Connection connection) {
        if (connection != null) {
            connection.removeListener(this);
            if (connection.disconnect()) {
                connection = null;
                return true;
            }
        }
        return false;
    }

    public int getPort() {
        return 0;
    }

    protected static void sendQuery(Connection connection, Message message) {
        if (connection != null) {
            byte[] byArray = message.toWire(65535);
            connection.send(byArray);
        }
    }

    protected abstract boolean disconnect(QueryData var1);

    protected abstract void returnException(Exception var1, QueryData var2);

    public void timedOut(QueryData queryData) {
        if (this.disconnect(queryData)) {
            this.returnException(new SocketTimeoutException("Timed out"), queryData);
        }
    }

    protected static void returnResponse(ResolverListener resolverListener, ResponseQueue responseQueue, Message message, Object object) {
        Response response = new Response();
        if (resolverListener == null) {
            response.setId(object);
            response.setMessage(message);
            responseQueue.insert(response);
        } else {
            ResponderThread responderThread = new ResponderThread(resolverListener, object, message);
            responderThread.start();
        }
    }

    protected void returnException(ResolverListener resolverListener, ResponseQueue responseQueue, Exception exception, Object object) {
        Response response = new Response();
        if (resolverListener == null) {
            response.setException(exception);
            response.setId(object);
            response.setException(true);
            responseQueue.insert(response);
        } else {
            ResponderThread responderThread = new ResponderThread(resolverListener, object, exception);
            responderThread.start();
        }
    }

    public void closed(Connection connection) {
    }
}

