/*
 * Decompiled with CFR 0.152.
 */
package uk.nominet.dnsjnio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectionKey;
import java.util.LinkedList;
import org.xbill.DNS.NonblockingResolver;
import uk.nominet.dnsjnio.ConnectionListener;
import uk.nominet.dnsjnio.DnsController;

public abstract class Connection {
    protected static final int SINGLE_PORT_BUFFER_SIZE = 65536;
    protected static final int BUFFER_SIZE = 4096;
    protected byte[] recvBytes;
    protected ConnectionListener listener;
    protected SelectionKey sk;
    protected LinkedList sendQ = new LinkedList();
    protected ByteBuffer sendBuffer = null;
    protected int recvCount = 0;
    protected boolean writeReady = false;
    protected InetSocketAddress remoteAddress;
    protected InetSocketAddress localAddress;
    private int state = 0;
    byte[] bytes;
    protected ByteBuffer inBuf;

    Connection(ConnectionListener connectionListener, int n) {
        this.listener = connectionListener;
        this.recvBytes = new byte[n];
        this.bytes = new byte[n];
        this.inBuf = ByteBuffer.wrap(this.bytes);
    }

    Connection(ConnectionListener connectionListener) {
        this(connectionListener, 4096);
    }

    public void removeListener(ConnectionListener connectionListener) {
        if (this.listener == connectionListener) {
            this.listener = null;
        }
    }

    protected void fireDataAvailable(byte[] byArray) {
        if (this.listener != null) {
            this.listener.dataAvailable(byArray, this);
        }
    }

    private void fireStateChanged() {
        if (this.listener != null) {
            if (this.state == 2) {
                this.listener.readyToSend(this);
            }
            if (this.state == 0) {
                this.listener.closed(this);
            }
        }
    }

    public String getRemoteName() {
        return this.remoteAddress.getHostName();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public void connect(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
        if (this.getState() == 0) {
            this.setRemoteAddress(inetSocketAddress);
            this.setLocalAddress(inetSocketAddress2);
            this.setState(1);
            if (!DnsController.isSelectThread()) {
                DnsController.invoke(new Runnable(){

                    public void run() {
                        Connection.this.connect();
                    }
                });
            } else {
                this.connect();
            }
        }
    }

    public boolean disconnect() {
        if (DnsController.isSelectThread()) {
            return this.close();
        }
        DnsController.invoke(new Runnable(){

            public void run() {
                Connection.this.close();
            }
        });
        return true;
    }

    public void send(final byte[] byArray) {
        if (!DnsController.isSelectThread()) {
            DnsController.invoke(new Runnable(){

                public void run() {
                    Connection.this.send(byArray);
                }
            });
        } else {
            this.sendQ.add(byArray);
            this.writeQueued();
        }
    }

    public void doWrite() {
        if (this.sk.isValid()) {
            this.sk.interestOps(0);
            this.writeReady = true;
            if (this.sendBuffer != null) {
                this.write(this.sendBuffer);
            }
            this.writeQueued();
        } else {
            this.closeComplete();
        }
    }

    protected void writeQueued() {
        while (this.writeReady && this.sendQ.size() > 0) {
            byte[] byArray = (byte[])this.sendQ.remove(0);
            this.write(byArray);
        }
    }

    private void write(byte[] byArray) {
        byte[] byArray2 = this.decorateData(byArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
        this.write(byteBuffer);
    }

    protected byte[] decorateData(byte[] byArray) {
        return byArray;
    }

    protected void commonEndWrite(ByteBuffer byteBuffer) {
        if (byteBuffer.hasRemaining()) {
            this.writeReady = false;
            this.sk.interestOps(5);
            this.sendBuffer = byteBuffer;
            this.writeReady = false;
        } else {
            this.sk.interestOps(1);
            this.sendBuffer = null;
            this.writeReady = true;
        }
    }

    protected void setLocalAddress(InetSocketAddress inetSocketAddress) {
        this.localAddress = inetSocketAddress;
    }

    protected void setRemoteAddress(InetSocketAddress inetSocketAddress) {
        this.remoteAddress = inetSocketAddress;
    }

    protected void setRemoteAddress(String string) {
        String string2;
        int n = string.indexOf(58);
        String string3 = null;
        int n2 = 53;
        if (n == 0) {
            string2 = "127.0.0.1";
            string3 = string.substring(1);
        } else if (n < 0) {
            string2 = string;
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        if (string3 != null) {
            try {
                n2 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = -1;
            }
        }
        this.setRemoteAddress(new InetSocketAddress(string2, n2));
    }

    protected void closeComplete() {
        this.sk.attach(null);
        try {
            this.closeChannel();
            if (this.sk.isValid()) {
                this.sk.interestOps(0);
                this.sk.selector().wakeup();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.inBuf = null;
        this.recvBytes = null;
        this.recvCount = 0;
        this.setState(0);
    }

    protected void clearRecvBytes(int n) {
        if (this.recvBytes != null) {
            if (n == this.recvCount) {
                this.recvCount = 0;
            } else {
                byte[] byArray = new byte[this.recvCount - n];
                System.arraycopy(this.recvBytes, n, byArray, 0, this.recvCount - n);
                this.recvCount -= n;
                System.arraycopy(byArray, 0, this.recvBytes, 0, this.recvCount);
                byArray = null;
            }
        }
    }

    protected void readFromChannel(ByteChannel byteChannel) {
        int n = 0;
        if (byteChannel.isOpen()) {
            try {
                n = byteChannel.read(this.inBuf);
            }
            catch (IOException iOException) {
                n = -1;
            }
            if (n >= 0) {
                this.addToBuffer(this.bytes, n);
                this.inBuf.clear();
            } else if (n < 0) {
                this.closeComplete();
            }
        }
    }

    protected void addToBuffer(byte[] byArray, int n) {
        if (byArray != null) {
            if (this.recvCount + n > this.recvBytes.length) {
                byte[] byArray2 = new byte[this.recvCount];
                System.arraycopy(this.recvBytes, 0, byArray2, 0, this.recvCount);
                this.recvBytes = null;
                this.recvBytes = new byte[this.recvCount + n];
                System.arraycopy(byArray2, 0, this.recvBytes, 0, this.recvCount);
                byArray2 = null;
            }
            System.arraycopy(byArray, 0, this.recvBytes, this.recvCount, n);
            this.recvCount += n;
        }
    }

    protected void sendToUser(byte[] byArray) {
        if (this.listener != null && NonblockingResolver.isDataComplete(byArray)) {
            this.fireDataAvailable(byArray);
        }
    }

    protected abstract boolean close();

    protected abstract void connect();

    protected abstract void write(ByteBuffer var1);

    protected abstract void closeChannel() throws IOException;

    public abstract void doRead();

    public abstract void doConnect();

    protected void setState(int n) {
        if (this.state != n) {
            this.state = n;
            this.fireStateChanged();
        }
    }

    public int getState() {
        return this.state;
    }

    public class State {
        public static final int CLOSED = 0;
        public static final int OPENING = 1;
        public static final int OPENED = 2;
        public static final int CLOSING = 3;
    }
}

