/*
 * Decompiled with CFR 0.152.
 */
package uk.nominet.dnsjnio;

import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import org.xbill.DNS.Message;
import org.xbill.DNS.NonblockingResolver;
import uk.nominet.dnsjnio.Connection;
import uk.nominet.dnsjnio.ConnectionListener;
import uk.nominet.dnsjnio.DnsController;

public class UDPConnection
extends Connection {
    public UDPConnection(ConnectionListener connectionListener, int n) {
        super(connectionListener, n);
    }

    protected void connect() {
        try {
            DatagramChannel datagramChannel = DatagramChannel.open();
            datagramChannel.configureBlocking(false);
            boolean bl = false;
            while (!bl) {
                try {
                    datagramChannel.socket().bind(this.localAddress);
                    bl = true;
                }
                catch (SocketException socketException) {
                    this.localAddress = NonblockingResolver.getNewInetSocketAddressWithRandomPort(this.localAddress.getAddress());
                }
            }
            this.sk = datagramChannel.register(DnsController.getSelector(), 0);
            datagramChannel.connect(this.remoteAddress);
            this.attach(this.sk);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.close();
        }
    }

    public void attach(SelectionKey selectionKey) {
        this.sk = selectionKey;
        selectionKey.attach(this);
        DatagramChannel datagramChannel = (DatagramChannel)selectionKey.channel();
        if (datagramChannel.isConnected()) {
            selectionKey.interestOps(5);
            this.setState(2);
        }
    }

    public void doConnect() {
    }

    public void doRead() {
        DatagramChannel datagramChannel = (DatagramChannel)this.sk.channel();
        try {
            this.readFromChannel(datagramChannel);
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        while (this.recvCount > 0) {
            if (this.recvBytes == null) continue;
            byte[] byArray = new byte[this.recvCount];
            System.arraycopy(this.recvBytes, 0, byArray, 0, this.recvCount);
            try {
                Message message = new Message(byArray);
                if (message.numBytes() < this.recvCount) {
                    byArray = new byte[message.numBytes()];
                    System.arraycopy(this.recvBytes, 0, byArray, 0, message.numBytes());
                }
                this.sendToUser(byArray);
                this.clearRecvBytes(byArray.length);
            }
            catch (IOException iOException) {
                break;
            }
        }
    }

    protected void write(ByteBuffer byteBuffer) {
        DatagramChannel datagramChannel = (DatagramChannel)this.sk.channel();
        if (datagramChannel.isOpen()) {
            if (byteBuffer.hasRemaining()) {
                try {
                    datagramChannel.write(byteBuffer);
                }
                catch (IOException iOException) {
                    this.closeComplete();
                }
            }
            this.commonEndWrite(byteBuffer);
        }
    }

    protected boolean close() {
        DatagramChannel datagramChannel;
        boolean bl = false;
        if (this.getState() != 0 && this.getState() != 3 && this.sk != null && (datagramChannel = (DatagramChannel)this.sk.channel()) != null && datagramChannel.isOpen()) {
            bl = true;
            if (this.getState() == 2) {
                this.sk.interestOps(0);
                this.setState(3);
                try {
                    datagramChannel.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            this.closeComplete();
        }
        return bl;
    }

    protected void closeChannel() throws IOException {
        DatagramChannel datagramChannel = (DatagramChannel)this.sk.channel();
        if (datagramChannel != null && datagramChannel.isOpen()) {
            datagramChannel.close();
        }
    }
}

