// Copyright (c) 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by thriftrw v1.13.1. DO NOT EDIT.
// @generated

package history

import (
	"bytes"
	"encoding/base64"
	"errors"
	"fmt"
	"github.com/uber/cadence/.gen/go/shared"
	"go.uber.org/multierr"
	"go.uber.org/thriftrw/wire"
	"go.uber.org/zap/zapcore"
	"strings"
)

type DescribeMutableStateRequest struct {
	DomainUUID *string                   `json:"domainUUID,omitempty"`
	Execution  *shared.WorkflowExecution `json:"execution,omitempty"`
}

// ToWire translates a DescribeMutableStateRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *DescribeMutableStateRequest) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Execution != nil {
		w, err = v.Execution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _WorkflowExecution_Read(w wire.Value) (*shared.WorkflowExecution, error) {
	var v shared.WorkflowExecution
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a DescribeMutableStateRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a DescribeMutableStateRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v DescribeMutableStateRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *DescribeMutableStateRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.Execution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a DescribeMutableStateRequest
// struct.
func (v *DescribeMutableStateRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.Execution != nil {
		fields[i] = fmt.Sprintf("Execution: %v", v.Execution)
		i++
	}

	return fmt.Sprintf("DescribeMutableStateRequest{%v}", strings.Join(fields[:i], ", "))
}

func _String_EqualsPtr(lhs, rhs *string) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return (x == y)
	}
	return lhs == nil && rhs == nil
}

// Equals returns true if all the fields of this DescribeMutableStateRequest match the
// provided DescribeMutableStateRequest.
//
// This function performs a deep comparison.
func (v *DescribeMutableStateRequest) Equals(rhs *DescribeMutableStateRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.Execution == nil && rhs.Execution == nil) || (v.Execution != nil && rhs.Execution != nil && v.Execution.Equals(rhs.Execution))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DescribeMutableStateRequest.
func (v *DescribeMutableStateRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.Execution != nil {
		err = multierr.Append(err, enc.AddObject("execution", v.Execution))
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *DescribeMutableStateRequest) GetDomainUUID() (o string) {
	if v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// GetExecution returns the value of Execution if it is set or its
// zero value if it is unset.
func (v *DescribeMutableStateRequest) GetExecution() (o *shared.WorkflowExecution) {
	if v.Execution != nil {
		return v.Execution
	}

	return
}

type DescribeMutableStateResponse struct {
	MutableStateInCache    *string `json:"mutableStateInCache,omitempty"`
	MutableStateInDatabase *string `json:"mutableStateInDatabase,omitempty"`
}

// ToWire translates a DescribeMutableStateResponse struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *DescribeMutableStateResponse) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.MutableStateInCache != nil {
		w, err = wire.NewValueString(*(v.MutableStateInCache)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.MutableStateInDatabase != nil {
		w, err = wire.NewValueString(*(v.MutableStateInDatabase)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a DescribeMutableStateResponse struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a DescribeMutableStateResponse struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v DescribeMutableStateResponse
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *DescribeMutableStateResponse) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.MutableStateInCache = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.MutableStateInDatabase = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a DescribeMutableStateResponse
// struct.
func (v *DescribeMutableStateResponse) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.MutableStateInCache != nil {
		fields[i] = fmt.Sprintf("MutableStateInCache: %v", *(v.MutableStateInCache))
		i++
	}
	if v.MutableStateInDatabase != nil {
		fields[i] = fmt.Sprintf("MutableStateInDatabase: %v", *(v.MutableStateInDatabase))
		i++
	}

	return fmt.Sprintf("DescribeMutableStateResponse{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this DescribeMutableStateResponse match the
// provided DescribeMutableStateResponse.
//
// This function performs a deep comparison.
func (v *DescribeMutableStateResponse) Equals(rhs *DescribeMutableStateResponse) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.MutableStateInCache, rhs.MutableStateInCache) {
		return false
	}
	if !_String_EqualsPtr(v.MutableStateInDatabase, rhs.MutableStateInDatabase) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DescribeMutableStateResponse.
func (v *DescribeMutableStateResponse) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.MutableStateInCache != nil {
		enc.AddString("mutableStateInCache", *v.MutableStateInCache)
	}
	if v.MutableStateInDatabase != nil {
		enc.AddString("mutableStateInDatabase", *v.MutableStateInDatabase)
	}
	return err
}

// GetMutableStateInCache returns the value of MutableStateInCache if it is set or its
// zero value if it is unset.
func (v *DescribeMutableStateResponse) GetMutableStateInCache() (o string) {
	if v.MutableStateInCache != nil {
		return *v.MutableStateInCache
	}

	return
}

// GetMutableStateInDatabase returns the value of MutableStateInDatabase if it is set or its
// zero value if it is unset.
func (v *DescribeMutableStateResponse) GetMutableStateInDatabase() (o string) {
	if v.MutableStateInDatabase != nil {
		return *v.MutableStateInDatabase
	}

	return
}

type DescribeWorkflowExecutionRequest struct {
	DomainUUID *string                                  `json:"domainUUID,omitempty"`
	Request    *shared.DescribeWorkflowExecutionRequest `json:"request,omitempty"`
}

// ToWire translates a DescribeWorkflowExecutionRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *DescribeWorkflowExecutionRequest) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Request != nil {
		w, err = v.Request.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _DescribeWorkflowExecutionRequest_Read(w wire.Value) (*shared.DescribeWorkflowExecutionRequest, error) {
	var v shared.DescribeWorkflowExecutionRequest
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a DescribeWorkflowExecutionRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a DescribeWorkflowExecutionRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v DescribeWorkflowExecutionRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *DescribeWorkflowExecutionRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.Request, err = _DescribeWorkflowExecutionRequest_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a DescribeWorkflowExecutionRequest
// struct.
func (v *DescribeWorkflowExecutionRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.Request != nil {
		fields[i] = fmt.Sprintf("Request: %v", v.Request)
		i++
	}

	return fmt.Sprintf("DescribeWorkflowExecutionRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this DescribeWorkflowExecutionRequest match the
// provided DescribeWorkflowExecutionRequest.
//
// This function performs a deep comparison.
func (v *DescribeWorkflowExecutionRequest) Equals(rhs *DescribeWorkflowExecutionRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.Request == nil && rhs.Request == nil) || (v.Request != nil && rhs.Request != nil && v.Request.Equals(rhs.Request))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DescribeWorkflowExecutionRequest.
func (v *DescribeWorkflowExecutionRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.Request != nil {
		err = multierr.Append(err, enc.AddObject("request", v.Request))
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *DescribeWorkflowExecutionRequest) GetDomainUUID() (o string) {
	if v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// GetRequest returns the value of Request if it is set or its
// zero value if it is unset.
func (v *DescribeWorkflowExecutionRequest) GetRequest() (o *shared.DescribeWorkflowExecutionRequest) {
	if v.Request != nil {
		return v.Request
	}

	return
}

type EventAlreadyStartedError struct {
	Message string `json:"message,required"`
}

// ToWire translates a EventAlreadyStartedError struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *EventAlreadyStartedError) ToWire() (wire.Value, error) {
	var (
		fields [1]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	w, err = wire.NewValueString(v.Message), error(nil)
	if err != nil {
		return w, err
	}
	fields[i] = wire.Field{ID: 1, Value: w}
	i++

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a EventAlreadyStartedError struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a EventAlreadyStartedError struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v EventAlreadyStartedError
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *EventAlreadyStartedError) FromWire(w wire.Value) error {
	var err error

	messageIsSet := false

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 1:
			if field.Value.Type() == wire.TBinary {
				v.Message, err = field.Value.GetString(), error(nil)
				if err != nil {
					return err
				}
				messageIsSet = true
			}
		}
	}

	if !messageIsSet {
		return errors.New("field Message of EventAlreadyStartedError is required")
	}

	return nil
}

// String returns a readable string representation of a EventAlreadyStartedError
// struct.
func (v *EventAlreadyStartedError) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [1]string
	i := 0
	fields[i] = fmt.Sprintf("Message: %v", v.Message)
	i++

	return fmt.Sprintf("EventAlreadyStartedError{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this EventAlreadyStartedError match the
// provided EventAlreadyStartedError.
//
// This function performs a deep comparison.
func (v *EventAlreadyStartedError) Equals(rhs *EventAlreadyStartedError) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !(v.Message == rhs.Message) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of EventAlreadyStartedError.
func (v *EventAlreadyStartedError) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	enc.AddString("message", v.Message)
	return err
}

// GetMessage returns the value of Message if it is set or its
// zero value if it is unset.
func (v *EventAlreadyStartedError) GetMessage() (o string) { return v.Message }

func (v *EventAlreadyStartedError) Error() string {
	return v.String()
}

type GetMutableStateRequest struct {
	DomainUUID          *string                   `json:"domainUUID,omitempty"`
	Execution           *shared.WorkflowExecution `json:"execution,omitempty"`
	ExpectedNextEventId *int64                    `json:"expectedNextEventId,omitempty"`
}

// ToWire translates a GetMutableStateRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *GetMutableStateRequest) ToWire() (wire.Value, error) {
	var (
		fields [3]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Execution != nil {
		w, err = v.Execution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.ExpectedNextEventId != nil {
		w, err = wire.NewValueI64(*(v.ExpectedNextEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a GetMutableStateRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a GetMutableStateRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v GetMutableStateRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *GetMutableStateRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.Execution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ExpectedNextEventId = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a GetMutableStateRequest
// struct.
func (v *GetMutableStateRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [3]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.Execution != nil {
		fields[i] = fmt.Sprintf("Execution: %v", v.Execution)
		i++
	}
	if v.ExpectedNextEventId != nil {
		fields[i] = fmt.Sprintf("ExpectedNextEventId: %v", *(v.ExpectedNextEventId))
		i++
	}

	return fmt.Sprintf("GetMutableStateRequest{%v}", strings.Join(fields[:i], ", "))
}

func _I64_EqualsPtr(lhs, rhs *int64) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return (x == y)
	}
	return lhs == nil && rhs == nil
}

// Equals returns true if all the fields of this GetMutableStateRequest match the
// provided GetMutableStateRequest.
//
// This function performs a deep comparison.
func (v *GetMutableStateRequest) Equals(rhs *GetMutableStateRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.Execution == nil && rhs.Execution == nil) || (v.Execution != nil && rhs.Execution != nil && v.Execution.Equals(rhs.Execution))) {
		return false
	}
	if !_I64_EqualsPtr(v.ExpectedNextEventId, rhs.ExpectedNextEventId) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of GetMutableStateRequest.
func (v *GetMutableStateRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.Execution != nil {
		err = multierr.Append(err, enc.AddObject("execution", v.Execution))
	}
	if v.ExpectedNextEventId != nil {
		enc.AddInt64("expectedNextEventId", *v.ExpectedNextEventId)
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *GetMutableStateRequest) GetDomainUUID() (o string) {
	if v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// GetExecution returns the value of Execution if it is set or its
// zero value if it is unset.
func (v *GetMutableStateRequest) GetExecution() (o *shared.WorkflowExecution) {
	if v.Execution != nil {
		return v.Execution
	}

	return
}

// GetExpectedNextEventId returns the value of ExpectedNextEventId if it is set or its
// zero value if it is unset.
func (v *GetMutableStateRequest) GetExpectedNextEventId() (o int64) {
	if v.ExpectedNextEventId != nil {
		return *v.ExpectedNextEventId
	}

	return
}

type GetMutableStateResponse struct {
	Execution                            *shared.WorkflowExecution          `json:"execution,omitempty"`
	WorkflowType                         *shared.WorkflowType               `json:"workflowType,omitempty"`
	NextEventId                          *int64                             `json:"NextEventId,omitempty"`
	PreviousStartedEventId               *int64                             `json:"PreviousStartedEventId,omitempty"`
	LastFirstEventId                     *int64                             `json:"LastFirstEventId,omitempty"`
	TaskList                             *shared.TaskList                   `json:"taskList,omitempty"`
	StickyTaskList                       *shared.TaskList                   `json:"stickyTaskList,omitempty"`
	ClientLibraryVersion                 *string                            `json:"clientLibraryVersion,omitempty"`
	ClientFeatureVersion                 *string                            `json:"clientFeatureVersion,omitempty"`
	ClientImpl                           *string                            `json:"clientImpl,omitempty"`
	IsWorkflowRunning                    *bool                              `json:"isWorkflowRunning,omitempty"`
	StickyTaskListScheduleToStartTimeout *int32                             `json:"stickyTaskListScheduleToStartTimeout,omitempty"`
	EventStoreVersion                    *int32                             `json:"eventStoreVersion,omitempty"`
	BranchToken                          []byte                             `json:"branchToken,omitempty"`
	ReplicationInfo                      map[string]*shared.ReplicationInfo `json:"replicationInfo,omitempty"`
}

type _Map_String_ReplicationInfo_MapItemList map[string]*shared.ReplicationInfo

func (m _Map_String_ReplicationInfo_MapItemList) ForEach(f func(wire.MapItem) error) error {
	for k, v := range m {
		if v == nil {
			return fmt.Errorf("invalid [%v]: value is nil", k)
		}
		kw, err := wire.NewValueString(k), error(nil)
		if err != nil {
			return err
		}

		vw, err := v.ToWire()
		if err != nil {
			return err
		}
		err = f(wire.MapItem{Key: kw, Value: vw})
		if err != nil {
			return err
		}
	}
	return nil
}

func (m _Map_String_ReplicationInfo_MapItemList) Size() int {
	return len(m)
}

func (_Map_String_ReplicationInfo_MapItemList) KeyType() wire.Type {
	return wire.TBinary
}

func (_Map_String_ReplicationInfo_MapItemList) ValueType() wire.Type {
	return wire.TStruct
}

func (_Map_String_ReplicationInfo_MapItemList) Close() {}

// ToWire translates a GetMutableStateResponse struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *GetMutableStateResponse) ToWire() (wire.Value, error) {
	var (
		fields [15]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Execution != nil {
		w, err = v.Execution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.WorkflowType != nil {
		w, err = v.WorkflowType.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.NextEventId != nil {
		w, err = wire.NewValueI64(*(v.NextEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.PreviousStartedEventId != nil {
		w, err = wire.NewValueI64(*(v.PreviousStartedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 35, Value: w}
		i++
	}
	if v.LastFirstEventId != nil {
		w, err = wire.NewValueI64(*(v.LastFirstEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.TaskList != nil {
		w, err = v.TaskList.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.StickyTaskList != nil {
		w, err = v.StickyTaskList.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}
	if v.ClientLibraryVersion != nil {
		w, err = wire.NewValueString(*(v.ClientLibraryVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 70, Value: w}
		i++
	}
	if v.ClientFeatureVersion != nil {
		w, err = wire.NewValueString(*(v.ClientFeatureVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 80, Value: w}
		i++
	}
	if v.ClientImpl != nil {
		w, err = wire.NewValueString(*(v.ClientImpl)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 90, Value: w}
		i++
	}
	if v.IsWorkflowRunning != nil {
		w, err = wire.NewValueBool(*(v.IsWorkflowRunning)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 100, Value: w}
		i++
	}
	if v.StickyTaskListScheduleToStartTimeout != nil {
		w, err = wire.NewValueI32(*(v.StickyTaskListScheduleToStartTimeout)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 110, Value: w}
		i++
	}
	if v.EventStoreVersion != nil {
		w, err = wire.NewValueI32(*(v.EventStoreVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 120, Value: w}
		i++
	}
	if v.BranchToken != nil {
		w, err = wire.NewValueBinary(v.BranchToken), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 130, Value: w}
		i++
	}
	if v.ReplicationInfo != nil {
		w, err = wire.NewValueMap(_Map_String_ReplicationInfo_MapItemList(v.ReplicationInfo)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 140, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _WorkflowType_Read(w wire.Value) (*shared.WorkflowType, error) {
	var v shared.WorkflowType
	err := v.FromWire(w)
	return &v, err
}

func _TaskList_Read(w wire.Value) (*shared.TaskList, error) {
	var v shared.TaskList
	err := v.FromWire(w)
	return &v, err
}

func _ReplicationInfo_Read(w wire.Value) (*shared.ReplicationInfo, error) {
	var v shared.ReplicationInfo
	err := v.FromWire(w)
	return &v, err
}

func _Map_String_ReplicationInfo_Read(m wire.MapItemList) (map[string]*shared.ReplicationInfo, error) {
	if m.KeyType() != wire.TBinary {
		return nil, nil
	}

	if m.ValueType() != wire.TStruct {
		return nil, nil
	}

	o := make(map[string]*shared.ReplicationInfo, m.Size())
	err := m.ForEach(func(x wire.MapItem) error {
		k, err := x.Key.GetString(), error(nil)
		if err != nil {
			return err
		}

		v, err := _ReplicationInfo_Read(x.Value)
		if err != nil {
			return err
		}

		o[k] = v
		return nil
	})
	m.Close()
	return o, err
}

// FromWire deserializes a GetMutableStateResponse struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a GetMutableStateResponse struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v GetMutableStateResponse
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *GetMutableStateResponse) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TStruct {
				v.Execution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowType, err = _WorkflowType_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.NextEventId = &x
				if err != nil {
					return err
				}

			}
		case 35:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.PreviousStartedEventId = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.LastFirstEventId = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TStruct {
				v.TaskList, err = _TaskList_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TStruct {
				v.StickyTaskList, err = _TaskList_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 70:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ClientLibraryVersion = &x
				if err != nil {
					return err
				}

			}
		case 80:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ClientFeatureVersion = &x
				if err != nil {
					return err
				}

			}
		case 90:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ClientImpl = &x
				if err != nil {
					return err
				}

			}
		case 100:
			if field.Value.Type() == wire.TBool {
				var x bool
				x, err = field.Value.GetBool(), error(nil)
				v.IsWorkflowRunning = &x
				if err != nil {
					return err
				}

			}
		case 110:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.StickyTaskListScheduleToStartTimeout = &x
				if err != nil {
					return err
				}

			}
		case 120:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.EventStoreVersion = &x
				if err != nil {
					return err
				}

			}
		case 130:
			if field.Value.Type() == wire.TBinary {
				v.BranchToken, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 140:
			if field.Value.Type() == wire.TMap {
				v.ReplicationInfo, err = _Map_String_ReplicationInfo_Read(field.Value.GetMap())
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a GetMutableStateResponse
// struct.
func (v *GetMutableStateResponse) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [15]string
	i := 0
	if v.Execution != nil {
		fields[i] = fmt.Sprintf("Execution: %v", v.Execution)
		i++
	}
	if v.WorkflowType != nil {
		fields[i] = fmt.Sprintf("WorkflowType: %v", v.WorkflowType)
		i++
	}
	if v.NextEventId != nil {
		fields[i] = fmt.Sprintf("NextEventId: %v", *(v.NextEventId))
		i++
	}
	if v.PreviousStartedEventId != nil {
		fields[i] = fmt.Sprintf("PreviousStartedEventId: %v", *(v.PreviousStartedEventId))
		i++
	}
	if v.LastFirstEventId != nil {
		fields[i] = fmt.Sprintf("LastFirstEventId: %v", *(v.LastFirstEventId))
		i++
	}
	if v.TaskList != nil {
		fields[i] = fmt.Sprintf("TaskList: %v", v.TaskList)
		i++
	}
	if v.StickyTaskList != nil {
		fields[i] = fmt.Sprintf("StickyTaskList: %v", v.StickyTaskList)
		i++
	}
	if v.ClientLibraryVersion != nil {
		fields[i] = fmt.Sprintf("ClientLibraryVersion: %v", *(v.ClientLibraryVersion))
		i++
	}
	if v.ClientFeatureVersion != nil {
		fields[i] = fmt.Sprintf("ClientFeatureVersion: %v", *(v.ClientFeatureVersion))
		i++
	}
	if v.ClientImpl != nil {
		fields[i] = fmt.Sprintf("ClientImpl: %v", *(v.ClientImpl))
		i++
	}
	if v.IsWorkflowRunning != nil {
		fields[i] = fmt.Sprintf("IsWorkflowRunning: %v", *(v.IsWorkflowRunning))
		i++
	}
	if v.StickyTaskListScheduleToStartTimeout != nil {
		fields[i] = fmt.Sprintf("StickyTaskListScheduleToStartTimeout: %v", *(v.StickyTaskListScheduleToStartTimeout))
		i++
	}
	if v.EventStoreVersion != nil {
		fields[i] = fmt.Sprintf("EventStoreVersion: %v", *(v.EventStoreVersion))
		i++
	}
	if v.BranchToken != nil {
		fields[i] = fmt.Sprintf("BranchToken: %v", v.BranchToken)
		i++
	}
	if v.ReplicationInfo != nil {
		fields[i] = fmt.Sprintf("ReplicationInfo: %v", v.ReplicationInfo)
		i++
	}

	return fmt.Sprintf("GetMutableStateResponse{%v}", strings.Join(fields[:i], ", "))
}

func _Bool_EqualsPtr(lhs, rhs *bool) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return (x == y)
	}
	return lhs == nil && rhs == nil
}

func _I32_EqualsPtr(lhs, rhs *int32) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return (x == y)
	}
	return lhs == nil && rhs == nil
}

func _Map_String_ReplicationInfo_Equals(lhs, rhs map[string]*shared.ReplicationInfo) bool {
	if len(lhs) != len(rhs) {
		return false
	}

	for lk, lv := range lhs {
		rv, ok := rhs[lk]
		if !ok {
			return false
		}
		if !lv.Equals(rv) {
			return false
		}
	}
	return true
}

// Equals returns true if all the fields of this GetMutableStateResponse match the
// provided GetMutableStateResponse.
//
// This function performs a deep comparison.
func (v *GetMutableStateResponse) Equals(rhs *GetMutableStateResponse) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.Execution == nil && rhs.Execution == nil) || (v.Execution != nil && rhs.Execution != nil && v.Execution.Equals(rhs.Execution))) {
		return false
	}
	if !((v.WorkflowType == nil && rhs.WorkflowType == nil) || (v.WorkflowType != nil && rhs.WorkflowType != nil && v.WorkflowType.Equals(rhs.WorkflowType))) {
		return false
	}
	if !_I64_EqualsPtr(v.NextEventId, rhs.NextEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.PreviousStartedEventId, rhs.PreviousStartedEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.LastFirstEventId, rhs.LastFirstEventId) {
		return false
	}
	if !((v.TaskList == nil && rhs.TaskList == nil) || (v.TaskList != nil && rhs.TaskList != nil && v.TaskList.Equals(rhs.TaskList))) {
		return false
	}
	if !((v.StickyTaskList == nil && rhs.StickyTaskList == nil) || (v.StickyTaskList != nil && rhs.StickyTaskList != nil && v.StickyTaskList.Equals(rhs.StickyTaskList))) {
		return false
	}
	if !_String_EqualsPtr(v.ClientLibraryVersion, rhs.ClientLibraryVersion) {
		return false
	}
	if !_String_EqualsPtr(v.ClientFeatureVersion, rhs.ClientFeatureVersion) {
		return false
	}
	if !_String_EqualsPtr(v.ClientImpl, rhs.ClientImpl) {
		return false
	}
	if !_Bool_EqualsPtr(v.IsWorkflowRunning, rhs.IsWorkflowRunning) {
		return false
	}
	if !_I32_EqualsPtr(v.StickyTaskListScheduleToStartTimeout, rhs.StickyTaskListScheduleToStartTimeout) {
		return false
	}
	if !_I32_EqualsPtr(v.EventStoreVersion, rhs.EventStoreVersion) {
		return false
	}
	if !((v.BranchToken == nil && rhs.BranchToken == nil) || (v.BranchToken != nil && rhs.BranchToken != nil && bytes.Equal(v.BranchToken, rhs.BranchToken))) {
		return false
	}
	if !((v.ReplicationInfo == nil && rhs.ReplicationInfo == nil) || (v.ReplicationInfo != nil && rhs.ReplicationInfo != nil && _Map_String_ReplicationInfo_Equals(v.ReplicationInfo, rhs.ReplicationInfo))) {
		return false
	}

	return true
}

type _Map_String_ReplicationInfo_Zapper map[string]*shared.ReplicationInfo

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of _Map_String_ReplicationInfo_Zapper.
func (m _Map_String_ReplicationInfo_Zapper) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	for k, v := range m {
		err = multierr.Append(err, enc.AddObject((string)(k), v))
	}
	return err
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of GetMutableStateResponse.
func (v *GetMutableStateResponse) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Execution != nil {
		err = multierr.Append(err, enc.AddObject("execution", v.Execution))
	}
	if v.WorkflowType != nil {
		err = multierr.Append(err, enc.AddObject("workflowType", v.WorkflowType))
	}
	if v.NextEventId != nil {
		enc.AddInt64("NextEventId", *v.NextEventId)
	}
	if v.PreviousStartedEventId != nil {
		enc.AddInt64("PreviousStartedEventId", *v.PreviousStartedEventId)
	}
	if v.LastFirstEventId != nil {
		enc.AddInt64("LastFirstEventId", *v.LastFirstEventId)
	}
	if v.TaskList != nil {
		err = multierr.Append(err, enc.AddObject("taskList", v.TaskList))
	}
	if v.StickyTaskList != nil {
		err = multierr.Append(err, enc.AddObject("stickyTaskList", v.StickyTaskList))
	}
	if v.ClientLibraryVersion != nil {
		enc.AddString("clientLibraryVersion", *v.ClientLibraryVersion)
	}
	if v.ClientFeatureVersion != nil {
		enc.AddString("clientFeatureVersion", *v.ClientFeatureVersion)
	}
	if v.ClientImpl != nil {
		enc.AddString("clientImpl", *v.ClientImpl)
	}
	if v.IsWorkflowRunning != nil {
		enc.AddBool("isWorkflowRunning", *v.IsWorkflowRunning)
	}
	if v.StickyTaskListScheduleToStartTimeout != nil {
		enc.AddInt32("stickyTaskListScheduleToStartTimeout", *v.StickyTaskListScheduleToStartTimeout)
	}
	if v.EventStoreVersion != nil {
		enc.AddInt32("eventStoreVersion", *v.EventStoreVersion)
	}
	if v.BranchToken != nil {
		enc.AddString("branchToken", base64.StdEncoding.EncodeToString(v.BranchToken))
	}
	if v.ReplicationInfo != nil {
		err = multierr.Append(err, enc.AddObject("replicationInfo", (_Map_String_ReplicationInfo_Zapper)(v.ReplicationInfo)))
	}
	return err
}

// GetExecution returns the value of Execution if it is set or its
// zero value if it is unset.
func (v *GetMutableStateResponse) GetExecution() (o *shared.WorkflowExecution) {
	if v.Execution != nil {
		return v.Execution
	}

	return
}

// GetWorkflowType returns the value of WorkflowType if it is set or its
// zero value if it is unset.
func (v *GetMutableStateResponse) GetWorkflowType() (o *shared.WorkflowType) {
	if v.WorkflowType != nil {
		return v.WorkflowType
	}

	return
}

// GetNextEventId returns the value of NextEventId if it is set or its
// zero value if it is unset.
func (v *GetMutableStateResponse) GetNextEventId() (o int64) {
	if v.NextEventId != nil {
		return *v.NextEventId
	}

	return
}

// GetPreviousStartedEventId returns the value of PreviousStartedEventId if it is set or its
// zero value if it is unset.
func (v *GetMutableStateResponse) GetPreviousStartedEventId() (o int64) {
	if v.PreviousStartedEventId != nil {
		return *v.PreviousStartedEventId
	}

	return
}

// GetLastFirstEventId returns the value of LastFirstEventId if it is set or its
// zero value if it is unset.
func (v *GetMutableStateResponse) GetLastFirstEventId() (o int64) {
	if v.LastFirstEventId != nil {
		return *v.LastFirstEventId
	}

	return
}

// GetTaskList returns the value of TaskList if it is set or its
// zero value if it is unset.
func (v *GetMutableStateResponse) GetTaskList() (o *shared.TaskList) {
	if v.TaskList != nil {
		return v.TaskList
	}

	return
}

// GetStickyTaskList returns the value of StickyTaskList if it is set or its
// zero value if it is unset.
func (v *GetMutableStateResponse) GetStickyTaskList() (o *shared.TaskList) {
	if v.StickyTaskList != nil {
		return v.StickyTaskList
	}

	return
}

// GetClientLibraryVersion returns the value of ClientLibraryVersion if it is set or its
// zero value if it is unset.
func (v *GetMutableStateResponse) GetClientLibraryVersion() (o string) {
	if v.ClientLibraryVersion != nil {
		return *v.ClientLibraryVersion
	}

	return
}

// GetClientFeatureVersion returns the value of ClientFeatureVersion if it is set or its
// zero value if it is unset.
func (v *GetMutableStateResponse) GetClientFeatureVersion() (o string) {
	if v.ClientFeatureVersion != nil {
		return *v.ClientFeatureVersion
	}

	return
}

// GetClientImpl returns the value of ClientImpl if it is set or its
// zero value if it is unset.
func (v *GetMutableStateResponse) GetClientImpl() (o string) {
	if v.ClientImpl != nil {
		return *v.ClientImpl
	}

	return
}

// GetIsWorkflowRunning returns the value of IsWorkflowRunning if it is set or its
// zero value if it is unset.
func (v *GetMutableStateResponse) GetIsWorkflowRunning() (o bool) {
	if v.IsWorkflowRunning != nil {
		return *v.IsWorkflowRunning
	}

	return
}

// GetStickyTaskListScheduleToStartTimeout returns the value of StickyTaskListScheduleToStartTimeout if it is set or its
// zero value if it is unset.
func (v *GetMutableStateResponse) GetStickyTaskListScheduleToStartTimeout() (o int32) {
	if v.StickyTaskListScheduleToStartTimeout != nil {
		return *v.StickyTaskListScheduleToStartTimeout
	}

	return
}

// GetEventStoreVersion returns the value of EventStoreVersion if it is set or its
// zero value if it is unset.
func (v *GetMutableStateResponse) GetEventStoreVersion() (o int32) {
	if v.EventStoreVersion != nil {
		return *v.EventStoreVersion
	}

	return
}

// GetBranchToken returns the value of BranchToken if it is set or its
// zero value if it is unset.
func (v *GetMutableStateResponse) GetBranchToken() (o []byte) {
	if v.BranchToken != nil {
		return v.BranchToken
	}

	return
}

// GetReplicationInfo returns the value of ReplicationInfo if it is set or its
// zero value if it is unset.
func (v *GetMutableStateResponse) GetReplicationInfo() (o map[string]*shared.ReplicationInfo) {
	if v.ReplicationInfo != nil {
		return v.ReplicationInfo
	}

	return
}

type ParentExecutionInfo struct {
	DomainUUID  *string                   `json:"domainUUID,omitempty"`
	Domain      *string                   `json:"domain,omitempty"`
	Execution   *shared.WorkflowExecution `json:"execution,omitempty"`
	InitiatedId *int64                    `json:"initiatedId,omitempty"`
}

// ToWire translates a ParentExecutionInfo struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ParentExecutionInfo) ToWire() (wire.Value, error) {
	var (
		fields [4]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 15, Value: w}
		i++
	}
	if v.Execution != nil {
		w, err = v.Execution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.InitiatedId != nil {
		w, err = wire.NewValueI64(*(v.InitiatedId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ParentExecutionInfo struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ParentExecutionInfo struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ParentExecutionInfo
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ParentExecutionInfo) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 15:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.Execution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.InitiatedId = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ParentExecutionInfo
// struct.
func (v *ParentExecutionInfo) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [4]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.Execution != nil {
		fields[i] = fmt.Sprintf("Execution: %v", v.Execution)
		i++
	}
	if v.InitiatedId != nil {
		fields[i] = fmt.Sprintf("InitiatedId: %v", *(v.InitiatedId))
		i++
	}

	return fmt.Sprintf("ParentExecutionInfo{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ParentExecutionInfo match the
// provided ParentExecutionInfo.
//
// This function performs a deep comparison.
func (v *ParentExecutionInfo) Equals(rhs *ParentExecutionInfo) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !((v.Execution == nil && rhs.Execution == nil) || (v.Execution != nil && rhs.Execution != nil && v.Execution.Equals(rhs.Execution))) {
		return false
	}
	if !_I64_EqualsPtr(v.InitiatedId, rhs.InitiatedId) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ParentExecutionInfo.
func (v *ParentExecutionInfo) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.Execution != nil {
		err = multierr.Append(err, enc.AddObject("execution", v.Execution))
	}
	if v.InitiatedId != nil {
		enc.AddInt64("initiatedId", *v.InitiatedId)
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *ParentExecutionInfo) GetDomainUUID() (o string) {
	if v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *ParentExecutionInfo) GetDomain() (o string) {
	if v.Domain != nil {
		return *v.Domain
	}

	return
}

// GetExecution returns the value of Execution if it is set or its
// zero value if it is unset.
func (v *ParentExecutionInfo) GetExecution() (o *shared.WorkflowExecution) {
	if v.Execution != nil {
		return v.Execution
	}

	return
}

// GetInitiatedId returns the value of InitiatedId if it is set or its
// zero value if it is unset.
func (v *ParentExecutionInfo) GetInitiatedId() (o int64) {
	if v.InitiatedId != nil {
		return *v.InitiatedId
	}

	return
}

type RecordActivityTaskHeartbeatRequest struct {
	DomainUUID       *string                                    `json:"domainUUID,omitempty"`
	HeartbeatRequest *shared.RecordActivityTaskHeartbeatRequest `json:"heartbeatRequest,omitempty"`
}

// ToWire translates a RecordActivityTaskHeartbeatRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RecordActivityTaskHeartbeatRequest) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.HeartbeatRequest != nil {
		w, err = v.HeartbeatRequest.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _RecordActivityTaskHeartbeatRequest_Read(w wire.Value) (*shared.RecordActivityTaskHeartbeatRequest, error) {
	var v shared.RecordActivityTaskHeartbeatRequest
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a RecordActivityTaskHeartbeatRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RecordActivityTaskHeartbeatRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RecordActivityTaskHeartbeatRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RecordActivityTaskHeartbeatRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.HeartbeatRequest, err = _RecordActivityTaskHeartbeatRequest_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RecordActivityTaskHeartbeatRequest
// struct.
func (v *RecordActivityTaskHeartbeatRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.HeartbeatRequest != nil {
		fields[i] = fmt.Sprintf("HeartbeatRequest: %v", v.HeartbeatRequest)
		i++
	}

	return fmt.Sprintf("RecordActivityTaskHeartbeatRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RecordActivityTaskHeartbeatRequest match the
// provided RecordActivityTaskHeartbeatRequest.
//
// This function performs a deep comparison.
func (v *RecordActivityTaskHeartbeatRequest) Equals(rhs *RecordActivityTaskHeartbeatRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.HeartbeatRequest == nil && rhs.HeartbeatRequest == nil) || (v.HeartbeatRequest != nil && rhs.HeartbeatRequest != nil && v.HeartbeatRequest.Equals(rhs.HeartbeatRequest))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RecordActivityTaskHeartbeatRequest.
func (v *RecordActivityTaskHeartbeatRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.HeartbeatRequest != nil {
		err = multierr.Append(err, enc.AddObject("heartbeatRequest", v.HeartbeatRequest))
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *RecordActivityTaskHeartbeatRequest) GetDomainUUID() (o string) {
	if v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// GetHeartbeatRequest returns the value of HeartbeatRequest if it is set or its
// zero value if it is unset.
func (v *RecordActivityTaskHeartbeatRequest) GetHeartbeatRequest() (o *shared.RecordActivityTaskHeartbeatRequest) {
	if v.HeartbeatRequest != nil {
		return v.HeartbeatRequest
	}

	return
}

type RecordActivityTaskStartedRequest struct {
	DomainUUID        *string                            `json:"domainUUID,omitempty"`
	WorkflowExecution *shared.WorkflowExecution          `json:"workflowExecution,omitempty"`
	ScheduleId        *int64                             `json:"scheduleId,omitempty"`
	TaskId            *int64                             `json:"taskId,omitempty"`
	RequestId         *string                            `json:"requestId,omitempty"`
	PollRequest       *shared.PollForActivityTaskRequest `json:"pollRequest,omitempty"`
}

// ToWire translates a RecordActivityTaskStartedRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RecordActivityTaskStartedRequest) ToWire() (wire.Value, error) {
	var (
		fields [6]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.WorkflowExecution != nil {
		w, err = v.WorkflowExecution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.ScheduleId != nil {
		w, err = wire.NewValueI64(*(v.ScheduleId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.TaskId != nil {
		w, err = wire.NewValueI64(*(v.TaskId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.RequestId != nil {
		w, err = wire.NewValueString(*(v.RequestId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 45, Value: w}
		i++
	}
	if v.PollRequest != nil {
		w, err = v.PollRequest.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _PollForActivityTaskRequest_Read(w wire.Value) (*shared.PollForActivityTaskRequest, error) {
	var v shared.PollForActivityTaskRequest
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a RecordActivityTaskStartedRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RecordActivityTaskStartedRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RecordActivityTaskStartedRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RecordActivityTaskStartedRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduleId = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.TaskId = &x
				if err != nil {
					return err
				}

			}
		case 45:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.RequestId = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TStruct {
				v.PollRequest, err = _PollForActivityTaskRequest_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RecordActivityTaskStartedRequest
// struct.
func (v *RecordActivityTaskStartedRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [6]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.WorkflowExecution != nil {
		fields[i] = fmt.Sprintf("WorkflowExecution: %v", v.WorkflowExecution)
		i++
	}
	if v.ScheduleId != nil {
		fields[i] = fmt.Sprintf("ScheduleId: %v", *(v.ScheduleId))
		i++
	}
	if v.TaskId != nil {
		fields[i] = fmt.Sprintf("TaskId: %v", *(v.TaskId))
		i++
	}
	if v.RequestId != nil {
		fields[i] = fmt.Sprintf("RequestId: %v", *(v.RequestId))
		i++
	}
	if v.PollRequest != nil {
		fields[i] = fmt.Sprintf("PollRequest: %v", v.PollRequest)
		i++
	}

	return fmt.Sprintf("RecordActivityTaskStartedRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RecordActivityTaskStartedRequest match the
// provided RecordActivityTaskStartedRequest.
//
// This function performs a deep comparison.
func (v *RecordActivityTaskStartedRequest) Equals(rhs *RecordActivityTaskStartedRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.WorkflowExecution == nil && rhs.WorkflowExecution == nil) || (v.WorkflowExecution != nil && rhs.WorkflowExecution != nil && v.WorkflowExecution.Equals(rhs.WorkflowExecution))) {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduleId, rhs.ScheduleId) {
		return false
	}
	if !_I64_EqualsPtr(v.TaskId, rhs.TaskId) {
		return false
	}
	if !_String_EqualsPtr(v.RequestId, rhs.RequestId) {
		return false
	}
	if !((v.PollRequest == nil && rhs.PollRequest == nil) || (v.PollRequest != nil && rhs.PollRequest != nil && v.PollRequest.Equals(rhs.PollRequest))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RecordActivityTaskStartedRequest.
func (v *RecordActivityTaskStartedRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.WorkflowExecution != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecution", v.WorkflowExecution))
	}
	if v.ScheduleId != nil {
		enc.AddInt64("scheduleId", *v.ScheduleId)
	}
	if v.TaskId != nil {
		enc.AddInt64("taskId", *v.TaskId)
	}
	if v.RequestId != nil {
		enc.AddString("requestId", *v.RequestId)
	}
	if v.PollRequest != nil {
		err = multierr.Append(err, enc.AddObject("pollRequest", v.PollRequest))
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *RecordActivityTaskStartedRequest) GetDomainUUID() (o string) {
	if v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// GetWorkflowExecution returns the value of WorkflowExecution if it is set or its
// zero value if it is unset.
func (v *RecordActivityTaskStartedRequest) GetWorkflowExecution() (o *shared.WorkflowExecution) {
	if v.WorkflowExecution != nil {
		return v.WorkflowExecution
	}

	return
}

// GetScheduleId returns the value of ScheduleId if it is set or its
// zero value if it is unset.
func (v *RecordActivityTaskStartedRequest) GetScheduleId() (o int64) {
	if v.ScheduleId != nil {
		return *v.ScheduleId
	}

	return
}

// GetTaskId returns the value of TaskId if it is set or its
// zero value if it is unset.
func (v *RecordActivityTaskStartedRequest) GetTaskId() (o int64) {
	if v.TaskId != nil {
		return *v.TaskId
	}

	return
}

// GetRequestId returns the value of RequestId if it is set or its
// zero value if it is unset.
func (v *RecordActivityTaskStartedRequest) GetRequestId() (o string) {
	if v.RequestId != nil {
		return *v.RequestId
	}

	return
}

// GetPollRequest returns the value of PollRequest if it is set or its
// zero value if it is unset.
func (v *RecordActivityTaskStartedRequest) GetPollRequest() (o *shared.PollForActivityTaskRequest) {
	if v.PollRequest != nil {
		return v.PollRequest
	}

	return
}

type RecordActivityTaskStartedResponse struct {
	ScheduledEvent                  *shared.HistoryEvent `json:"scheduledEvent,omitempty"`
	StartedTimestamp                *int64               `json:"startedTimestamp,omitempty"`
	Attempt                         *int64               `json:"attempt,omitempty"`
	ScheduledTimestampOfThisAttempt *int64               `json:"scheduledTimestampOfThisAttempt,omitempty"`
	HeartbeatDetails                []byte               `json:"heartbeatDetails,omitempty"`
	WorkflowType                    *shared.WorkflowType `json:"workflowType,omitempty"`
	WorkflowDomain                  *string              `json:"workflowDomain,omitempty"`
}

// ToWire translates a RecordActivityTaskStartedResponse struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RecordActivityTaskStartedResponse) ToWire() (wire.Value, error) {
	var (
		fields [7]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.ScheduledEvent != nil {
		w, err = v.ScheduledEvent.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.StartedTimestamp != nil {
		w, err = wire.NewValueI64(*(v.StartedTimestamp)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.Attempt != nil {
		w, err = wire.NewValueI64(*(v.Attempt)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.ScheduledTimestampOfThisAttempt != nil {
		w, err = wire.NewValueI64(*(v.ScheduledTimestampOfThisAttempt)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.HeartbeatDetails != nil {
		w, err = wire.NewValueBinary(v.HeartbeatDetails), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}
	if v.WorkflowType != nil {
		w, err = v.WorkflowType.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 70, Value: w}
		i++
	}
	if v.WorkflowDomain != nil {
		w, err = wire.NewValueString(*(v.WorkflowDomain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 80, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _HistoryEvent_Read(w wire.Value) (*shared.HistoryEvent, error) {
	var v shared.HistoryEvent
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a RecordActivityTaskStartedResponse struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RecordActivityTaskStartedResponse struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RecordActivityTaskStartedResponse
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RecordActivityTaskStartedResponse) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.ScheduledEvent, err = _HistoryEvent_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StartedTimestamp = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.Attempt = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduledTimestampOfThisAttempt = &x
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TBinary {
				v.HeartbeatDetails, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 70:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowType, err = _WorkflowType_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 80:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.WorkflowDomain = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RecordActivityTaskStartedResponse
// struct.
func (v *RecordActivityTaskStartedResponse) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [7]string
	i := 0
	if v.ScheduledEvent != nil {
		fields[i] = fmt.Sprintf("ScheduledEvent: %v", v.ScheduledEvent)
		i++
	}
	if v.StartedTimestamp != nil {
		fields[i] = fmt.Sprintf("StartedTimestamp: %v", *(v.StartedTimestamp))
		i++
	}
	if v.Attempt != nil {
		fields[i] = fmt.Sprintf("Attempt: %v", *(v.Attempt))
		i++
	}
	if v.ScheduledTimestampOfThisAttempt != nil {
		fields[i] = fmt.Sprintf("ScheduledTimestampOfThisAttempt: %v", *(v.ScheduledTimestampOfThisAttempt))
		i++
	}
	if v.HeartbeatDetails != nil {
		fields[i] = fmt.Sprintf("HeartbeatDetails: %v", v.HeartbeatDetails)
		i++
	}
	if v.WorkflowType != nil {
		fields[i] = fmt.Sprintf("WorkflowType: %v", v.WorkflowType)
		i++
	}
	if v.WorkflowDomain != nil {
		fields[i] = fmt.Sprintf("WorkflowDomain: %v", *(v.WorkflowDomain))
		i++
	}

	return fmt.Sprintf("RecordActivityTaskStartedResponse{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RecordActivityTaskStartedResponse match the
// provided RecordActivityTaskStartedResponse.
//
// This function performs a deep comparison.
func (v *RecordActivityTaskStartedResponse) Equals(rhs *RecordActivityTaskStartedResponse) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.ScheduledEvent == nil && rhs.ScheduledEvent == nil) || (v.ScheduledEvent != nil && rhs.ScheduledEvent != nil && v.ScheduledEvent.Equals(rhs.ScheduledEvent))) {
		return false
	}
	if !_I64_EqualsPtr(v.StartedTimestamp, rhs.StartedTimestamp) {
		return false
	}
	if !_I64_EqualsPtr(v.Attempt, rhs.Attempt) {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduledTimestampOfThisAttempt, rhs.ScheduledTimestampOfThisAttempt) {
		return false
	}
	if !((v.HeartbeatDetails == nil && rhs.HeartbeatDetails == nil) || (v.HeartbeatDetails != nil && rhs.HeartbeatDetails != nil && bytes.Equal(v.HeartbeatDetails, rhs.HeartbeatDetails))) {
		return false
	}
	if !((v.WorkflowType == nil && rhs.WorkflowType == nil) || (v.WorkflowType != nil && rhs.WorkflowType != nil && v.WorkflowType.Equals(rhs.WorkflowType))) {
		return false
	}
	if !_String_EqualsPtr(v.WorkflowDomain, rhs.WorkflowDomain) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RecordActivityTaskStartedResponse.
func (v *RecordActivityTaskStartedResponse) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.ScheduledEvent != nil {
		err = multierr.Append(err, enc.AddObject("scheduledEvent", v.ScheduledEvent))
	}
	if v.StartedTimestamp != nil {
		enc.AddInt64("startedTimestamp", *v.StartedTimestamp)
	}
	if v.Attempt != nil {
		enc.AddInt64("attempt", *v.Attempt)
	}
	if v.ScheduledTimestampOfThisAttempt != nil {
		enc.AddInt64("scheduledTimestampOfThisAttempt", *v.ScheduledTimestampOfThisAttempt)
	}
	if v.HeartbeatDetails != nil {
		enc.AddString("heartbeatDetails", base64.StdEncoding.EncodeToString(v.HeartbeatDetails))
	}
	if v.WorkflowType != nil {
		err = multierr.Append(err, enc.AddObject("workflowType", v.WorkflowType))
	}
	if v.WorkflowDomain != nil {
		enc.AddString("workflowDomain", *v.WorkflowDomain)
	}
	return err
}

// GetScheduledEvent returns the value of ScheduledEvent if it is set or its
// zero value if it is unset.
func (v *RecordActivityTaskStartedResponse) GetScheduledEvent() (o *shared.HistoryEvent) {
	if v.ScheduledEvent != nil {
		return v.ScheduledEvent
	}

	return
}

// GetStartedTimestamp returns the value of StartedTimestamp if it is set or its
// zero value if it is unset.
func (v *RecordActivityTaskStartedResponse) GetStartedTimestamp() (o int64) {
	if v.StartedTimestamp != nil {
		return *v.StartedTimestamp
	}

	return
}

// GetAttempt returns the value of Attempt if it is set or its
// zero value if it is unset.
func (v *RecordActivityTaskStartedResponse) GetAttempt() (o int64) {
	if v.Attempt != nil {
		return *v.Attempt
	}

	return
}

// GetScheduledTimestampOfThisAttempt returns the value of ScheduledTimestampOfThisAttempt if it is set or its
// zero value if it is unset.
func (v *RecordActivityTaskStartedResponse) GetScheduledTimestampOfThisAttempt() (o int64) {
	if v.ScheduledTimestampOfThisAttempt != nil {
		return *v.ScheduledTimestampOfThisAttempt
	}

	return
}

// GetHeartbeatDetails returns the value of HeartbeatDetails if it is set or its
// zero value if it is unset.
func (v *RecordActivityTaskStartedResponse) GetHeartbeatDetails() (o []byte) {
	if v.HeartbeatDetails != nil {
		return v.HeartbeatDetails
	}

	return
}

// GetWorkflowType returns the value of WorkflowType if it is set or its
// zero value if it is unset.
func (v *RecordActivityTaskStartedResponse) GetWorkflowType() (o *shared.WorkflowType) {
	if v.WorkflowType != nil {
		return v.WorkflowType
	}

	return
}

// GetWorkflowDomain returns the value of WorkflowDomain if it is set or its
// zero value if it is unset.
func (v *RecordActivityTaskStartedResponse) GetWorkflowDomain() (o string) {
	if v.WorkflowDomain != nil {
		return *v.WorkflowDomain
	}

	return
}

// RecordChildExecutionCompletedRequest is used for reporting the completion of child execution to parent workflow
// execution which started it.  When a child execution is completed it creates this request and calls the
// RecordChildExecutionCompleted API with the workflowExecution of parent.  It also sets the completedExecution of the
// child as it could potentially be different than the ChildExecutionStartedEvent of parent in the situation when
// child creates multiple runs through ContinueAsNew before finally completing.
type RecordChildExecutionCompletedRequest struct {
	DomainUUID         *string                   `json:"domainUUID,omitempty"`
	WorkflowExecution  *shared.WorkflowExecution `json:"workflowExecution,omitempty"`
	InitiatedId        *int64                    `json:"initiatedId,omitempty"`
	CompletedExecution *shared.WorkflowExecution `json:"completedExecution,omitempty"`
	CompletionEvent    *shared.HistoryEvent      `json:"completionEvent,omitempty"`
}

// ToWire translates a RecordChildExecutionCompletedRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RecordChildExecutionCompletedRequest) ToWire() (wire.Value, error) {
	var (
		fields [5]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.WorkflowExecution != nil {
		w, err = v.WorkflowExecution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.InitiatedId != nil {
		w, err = wire.NewValueI64(*(v.InitiatedId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.CompletedExecution != nil {
		w, err = v.CompletedExecution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.CompletionEvent != nil {
		w, err = v.CompletionEvent.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a RecordChildExecutionCompletedRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RecordChildExecutionCompletedRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RecordChildExecutionCompletedRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RecordChildExecutionCompletedRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.InitiatedId = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TStruct {
				v.CompletedExecution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TStruct {
				v.CompletionEvent, err = _HistoryEvent_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RecordChildExecutionCompletedRequest
// struct.
func (v *RecordChildExecutionCompletedRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [5]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.WorkflowExecution != nil {
		fields[i] = fmt.Sprintf("WorkflowExecution: %v", v.WorkflowExecution)
		i++
	}
	if v.InitiatedId != nil {
		fields[i] = fmt.Sprintf("InitiatedId: %v", *(v.InitiatedId))
		i++
	}
	if v.CompletedExecution != nil {
		fields[i] = fmt.Sprintf("CompletedExecution: %v", v.CompletedExecution)
		i++
	}
	if v.CompletionEvent != nil {
		fields[i] = fmt.Sprintf("CompletionEvent: %v", v.CompletionEvent)
		i++
	}

	return fmt.Sprintf("RecordChildExecutionCompletedRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RecordChildExecutionCompletedRequest match the
// provided RecordChildExecutionCompletedRequest.
//
// This function performs a deep comparison.
func (v *RecordChildExecutionCompletedRequest) Equals(rhs *RecordChildExecutionCompletedRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.WorkflowExecution == nil && rhs.WorkflowExecution == nil) || (v.WorkflowExecution != nil && rhs.WorkflowExecution != nil && v.WorkflowExecution.Equals(rhs.WorkflowExecution))) {
		return false
	}
	if !_I64_EqualsPtr(v.InitiatedId, rhs.InitiatedId) {
		return false
	}
	if !((v.CompletedExecution == nil && rhs.CompletedExecution == nil) || (v.CompletedExecution != nil && rhs.CompletedExecution != nil && v.CompletedExecution.Equals(rhs.CompletedExecution))) {
		return false
	}
	if !((v.CompletionEvent == nil && rhs.CompletionEvent == nil) || (v.CompletionEvent != nil && rhs.CompletionEvent != nil && v.CompletionEvent.Equals(rhs.CompletionEvent))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RecordChildExecutionCompletedRequest.
func (v *RecordChildExecutionCompletedRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.WorkflowExecution != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecution", v.WorkflowExecution))
	}
	if v.InitiatedId != nil {
		enc.AddInt64("initiatedId", *v.InitiatedId)
	}
	if v.CompletedExecution != nil {
		err = multierr.Append(err, enc.AddObject("completedExecution", v.CompletedExecution))
	}
	if v.CompletionEvent != nil {
		err = multierr.Append(err, enc.AddObject("completionEvent", v.CompletionEvent))
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *RecordChildExecutionCompletedRequest) GetDomainUUID() (o string) {
	if v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// GetWorkflowExecution returns the value of WorkflowExecution if it is set or its
// zero value if it is unset.
func (v *RecordChildExecutionCompletedRequest) GetWorkflowExecution() (o *shared.WorkflowExecution) {
	if v.WorkflowExecution != nil {
		return v.WorkflowExecution
	}

	return
}

// GetInitiatedId returns the value of InitiatedId if it is set or its
// zero value if it is unset.
func (v *RecordChildExecutionCompletedRequest) GetInitiatedId() (o int64) {
	if v.InitiatedId != nil {
		return *v.InitiatedId
	}

	return
}

// GetCompletedExecution returns the value of CompletedExecution if it is set or its
// zero value if it is unset.
func (v *RecordChildExecutionCompletedRequest) GetCompletedExecution() (o *shared.WorkflowExecution) {
	if v.CompletedExecution != nil {
		return v.CompletedExecution
	}

	return
}

// GetCompletionEvent returns the value of CompletionEvent if it is set or its
// zero value if it is unset.
func (v *RecordChildExecutionCompletedRequest) GetCompletionEvent() (o *shared.HistoryEvent) {
	if v.CompletionEvent != nil {
		return v.CompletionEvent
	}

	return
}

type RecordDecisionTaskStartedRequest struct {
	DomainUUID        *string                            `json:"domainUUID,omitempty"`
	WorkflowExecution *shared.WorkflowExecution          `json:"workflowExecution,omitempty"`
	ScheduleId        *int64                             `json:"scheduleId,omitempty"`
	TaskId            *int64                             `json:"taskId,omitempty"`
	RequestId         *string                            `json:"requestId,omitempty"`
	PollRequest       *shared.PollForDecisionTaskRequest `json:"pollRequest,omitempty"`
}

// ToWire translates a RecordDecisionTaskStartedRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RecordDecisionTaskStartedRequest) ToWire() (wire.Value, error) {
	var (
		fields [6]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.WorkflowExecution != nil {
		w, err = v.WorkflowExecution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.ScheduleId != nil {
		w, err = wire.NewValueI64(*(v.ScheduleId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.TaskId != nil {
		w, err = wire.NewValueI64(*(v.TaskId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.RequestId != nil {
		w, err = wire.NewValueString(*(v.RequestId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 45, Value: w}
		i++
	}
	if v.PollRequest != nil {
		w, err = v.PollRequest.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _PollForDecisionTaskRequest_Read(w wire.Value) (*shared.PollForDecisionTaskRequest, error) {
	var v shared.PollForDecisionTaskRequest
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a RecordDecisionTaskStartedRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RecordDecisionTaskStartedRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RecordDecisionTaskStartedRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RecordDecisionTaskStartedRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduleId = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.TaskId = &x
				if err != nil {
					return err
				}

			}
		case 45:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.RequestId = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TStruct {
				v.PollRequest, err = _PollForDecisionTaskRequest_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RecordDecisionTaskStartedRequest
// struct.
func (v *RecordDecisionTaskStartedRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [6]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.WorkflowExecution != nil {
		fields[i] = fmt.Sprintf("WorkflowExecution: %v", v.WorkflowExecution)
		i++
	}
	if v.ScheduleId != nil {
		fields[i] = fmt.Sprintf("ScheduleId: %v", *(v.ScheduleId))
		i++
	}
	if v.TaskId != nil {
		fields[i] = fmt.Sprintf("TaskId: %v", *(v.TaskId))
		i++
	}
	if v.RequestId != nil {
		fields[i] = fmt.Sprintf("RequestId: %v", *(v.RequestId))
		i++
	}
	if v.PollRequest != nil {
		fields[i] = fmt.Sprintf("PollRequest: %v", v.PollRequest)
		i++
	}

	return fmt.Sprintf("RecordDecisionTaskStartedRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RecordDecisionTaskStartedRequest match the
// provided RecordDecisionTaskStartedRequest.
//
// This function performs a deep comparison.
func (v *RecordDecisionTaskStartedRequest) Equals(rhs *RecordDecisionTaskStartedRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.WorkflowExecution == nil && rhs.WorkflowExecution == nil) || (v.WorkflowExecution != nil && rhs.WorkflowExecution != nil && v.WorkflowExecution.Equals(rhs.WorkflowExecution))) {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduleId, rhs.ScheduleId) {
		return false
	}
	if !_I64_EqualsPtr(v.TaskId, rhs.TaskId) {
		return false
	}
	if !_String_EqualsPtr(v.RequestId, rhs.RequestId) {
		return false
	}
	if !((v.PollRequest == nil && rhs.PollRequest == nil) || (v.PollRequest != nil && rhs.PollRequest != nil && v.PollRequest.Equals(rhs.PollRequest))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RecordDecisionTaskStartedRequest.
func (v *RecordDecisionTaskStartedRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.WorkflowExecution != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecution", v.WorkflowExecution))
	}
	if v.ScheduleId != nil {
		enc.AddInt64("scheduleId", *v.ScheduleId)
	}
	if v.TaskId != nil {
		enc.AddInt64("taskId", *v.TaskId)
	}
	if v.RequestId != nil {
		enc.AddString("requestId", *v.RequestId)
	}
	if v.PollRequest != nil {
		err = multierr.Append(err, enc.AddObject("pollRequest", v.PollRequest))
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *RecordDecisionTaskStartedRequest) GetDomainUUID() (o string) {
	if v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// GetWorkflowExecution returns the value of WorkflowExecution if it is set or its
// zero value if it is unset.
func (v *RecordDecisionTaskStartedRequest) GetWorkflowExecution() (o *shared.WorkflowExecution) {
	if v.WorkflowExecution != nil {
		return v.WorkflowExecution
	}

	return
}

// GetScheduleId returns the value of ScheduleId if it is set or its
// zero value if it is unset.
func (v *RecordDecisionTaskStartedRequest) GetScheduleId() (o int64) {
	if v.ScheduleId != nil {
		return *v.ScheduleId
	}

	return
}

// GetTaskId returns the value of TaskId if it is set or its
// zero value if it is unset.
func (v *RecordDecisionTaskStartedRequest) GetTaskId() (o int64) {
	if v.TaskId != nil {
		return *v.TaskId
	}

	return
}

// GetRequestId returns the value of RequestId if it is set or its
// zero value if it is unset.
func (v *RecordDecisionTaskStartedRequest) GetRequestId() (o string) {
	if v.RequestId != nil {
		return *v.RequestId
	}

	return
}

// GetPollRequest returns the value of PollRequest if it is set or its
// zero value if it is unset.
func (v *RecordDecisionTaskStartedRequest) GetPollRequest() (o *shared.PollForDecisionTaskRequest) {
	if v.PollRequest != nil {
		return v.PollRequest
	}

	return
}

type RecordDecisionTaskStartedResponse struct {
	WorkflowType              *shared.WorkflowType          `json:"workflowType,omitempty"`
	PreviousStartedEventId    *int64                        `json:"previousStartedEventId,omitempty"`
	ScheduledEventId          *int64                        `json:"scheduledEventId,omitempty"`
	StartedEventId            *int64                        `json:"startedEventId,omitempty"`
	NextEventId               *int64                        `json:"nextEventId,omitempty"`
	Attempt                   *int64                        `json:"attempt,omitempty"`
	StickyExecutionEnabled    *bool                         `json:"stickyExecutionEnabled,omitempty"`
	DecisionInfo              *shared.TransientDecisionInfo `json:"decisionInfo,omitempty"`
	WorkflowExecutionTaskList *shared.TaskList              `json:"WorkflowExecutionTaskList,omitempty"`
	EventStoreVersion         *int32                        `json:"eventStoreVersion,omitempty"`
	BranchToken               []byte                        `json:"branchToken,omitempty"`
}

// ToWire translates a RecordDecisionTaskStartedResponse struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RecordDecisionTaskStartedResponse) ToWire() (wire.Value, error) {
	var (
		fields [11]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.WorkflowType != nil {
		w, err = v.WorkflowType.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.PreviousStartedEventId != nil {
		w, err = wire.NewValueI64(*(v.PreviousStartedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.ScheduledEventId != nil {
		w, err = wire.NewValueI64(*(v.ScheduledEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.StartedEventId != nil {
		w, err = wire.NewValueI64(*(v.StartedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.NextEventId != nil {
		w, err = wire.NewValueI64(*(v.NextEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.Attempt != nil {
		w, err = wire.NewValueI64(*(v.Attempt)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}
	if v.StickyExecutionEnabled != nil {
		w, err = wire.NewValueBool(*(v.StickyExecutionEnabled)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 70, Value: w}
		i++
	}
	if v.DecisionInfo != nil {
		w, err = v.DecisionInfo.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 80, Value: w}
		i++
	}
	if v.WorkflowExecutionTaskList != nil {
		w, err = v.WorkflowExecutionTaskList.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 90, Value: w}
		i++
	}
	if v.EventStoreVersion != nil {
		w, err = wire.NewValueI32(*(v.EventStoreVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 100, Value: w}
		i++
	}
	if v.BranchToken != nil {
		w, err = wire.NewValueBinary(v.BranchToken), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 110, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _TransientDecisionInfo_Read(w wire.Value) (*shared.TransientDecisionInfo, error) {
	var v shared.TransientDecisionInfo
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a RecordDecisionTaskStartedResponse struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RecordDecisionTaskStartedResponse struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RecordDecisionTaskStartedResponse
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RecordDecisionTaskStartedResponse) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowType, err = _WorkflowType_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.PreviousStartedEventId = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduledEventId = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StartedEventId = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.NextEventId = &x
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.Attempt = &x
				if err != nil {
					return err
				}

			}
		case 70:
			if field.Value.Type() == wire.TBool {
				var x bool
				x, err = field.Value.GetBool(), error(nil)
				v.StickyExecutionEnabled = &x
				if err != nil {
					return err
				}

			}
		case 80:
			if field.Value.Type() == wire.TStruct {
				v.DecisionInfo, err = _TransientDecisionInfo_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 90:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecutionTaskList, err = _TaskList_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 100:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.EventStoreVersion = &x
				if err != nil {
					return err
				}

			}
		case 110:
			if field.Value.Type() == wire.TBinary {
				v.BranchToken, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RecordDecisionTaskStartedResponse
// struct.
func (v *RecordDecisionTaskStartedResponse) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [11]string
	i := 0
	if v.WorkflowType != nil {
		fields[i] = fmt.Sprintf("WorkflowType: %v", v.WorkflowType)
		i++
	}
	if v.PreviousStartedEventId != nil {
		fields[i] = fmt.Sprintf("PreviousStartedEventId: %v", *(v.PreviousStartedEventId))
		i++
	}
	if v.ScheduledEventId != nil {
		fields[i] = fmt.Sprintf("ScheduledEventId: %v", *(v.ScheduledEventId))
		i++
	}
	if v.StartedEventId != nil {
		fields[i] = fmt.Sprintf("StartedEventId: %v", *(v.StartedEventId))
		i++
	}
	if v.NextEventId != nil {
		fields[i] = fmt.Sprintf("NextEventId: %v", *(v.NextEventId))
		i++
	}
	if v.Attempt != nil {
		fields[i] = fmt.Sprintf("Attempt: %v", *(v.Attempt))
		i++
	}
	if v.StickyExecutionEnabled != nil {
		fields[i] = fmt.Sprintf("StickyExecutionEnabled: %v", *(v.StickyExecutionEnabled))
		i++
	}
	if v.DecisionInfo != nil {
		fields[i] = fmt.Sprintf("DecisionInfo: %v", v.DecisionInfo)
		i++
	}
	if v.WorkflowExecutionTaskList != nil {
		fields[i] = fmt.Sprintf("WorkflowExecutionTaskList: %v", v.WorkflowExecutionTaskList)
		i++
	}
	if v.EventStoreVersion != nil {
		fields[i] = fmt.Sprintf("EventStoreVersion: %v", *(v.EventStoreVersion))
		i++
	}
	if v.BranchToken != nil {
		fields[i] = fmt.Sprintf("BranchToken: %v", v.BranchToken)
		i++
	}

	return fmt.Sprintf("RecordDecisionTaskStartedResponse{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RecordDecisionTaskStartedResponse match the
// provided RecordDecisionTaskStartedResponse.
//
// This function performs a deep comparison.
func (v *RecordDecisionTaskStartedResponse) Equals(rhs *RecordDecisionTaskStartedResponse) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.WorkflowType == nil && rhs.WorkflowType == nil) || (v.WorkflowType != nil && rhs.WorkflowType != nil && v.WorkflowType.Equals(rhs.WorkflowType))) {
		return false
	}
	if !_I64_EqualsPtr(v.PreviousStartedEventId, rhs.PreviousStartedEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduledEventId, rhs.ScheduledEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.StartedEventId, rhs.StartedEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.NextEventId, rhs.NextEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.Attempt, rhs.Attempt) {
		return false
	}
	if !_Bool_EqualsPtr(v.StickyExecutionEnabled, rhs.StickyExecutionEnabled) {
		return false
	}
	if !((v.DecisionInfo == nil && rhs.DecisionInfo == nil) || (v.DecisionInfo != nil && rhs.DecisionInfo != nil && v.DecisionInfo.Equals(rhs.DecisionInfo))) {
		return false
	}
	if !((v.WorkflowExecutionTaskList == nil && rhs.WorkflowExecutionTaskList == nil) || (v.WorkflowExecutionTaskList != nil && rhs.WorkflowExecutionTaskList != nil && v.WorkflowExecutionTaskList.Equals(rhs.WorkflowExecutionTaskList))) {
		return false
	}
	if !_I32_EqualsPtr(v.EventStoreVersion, rhs.EventStoreVersion) {
		return false
	}
	if !((v.BranchToken == nil && rhs.BranchToken == nil) || (v.BranchToken != nil && rhs.BranchToken != nil && bytes.Equal(v.BranchToken, rhs.BranchToken))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RecordDecisionTaskStartedResponse.
func (v *RecordDecisionTaskStartedResponse) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.WorkflowType != nil {
		err = multierr.Append(err, enc.AddObject("workflowType", v.WorkflowType))
	}
	if v.PreviousStartedEventId != nil {
		enc.AddInt64("previousStartedEventId", *v.PreviousStartedEventId)
	}
	if v.ScheduledEventId != nil {
		enc.AddInt64("scheduledEventId", *v.ScheduledEventId)
	}
	if v.StartedEventId != nil {
		enc.AddInt64("startedEventId", *v.StartedEventId)
	}
	if v.NextEventId != nil {
		enc.AddInt64("nextEventId", *v.NextEventId)
	}
	if v.Attempt != nil {
		enc.AddInt64("attempt", *v.Attempt)
	}
	if v.StickyExecutionEnabled != nil {
		enc.AddBool("stickyExecutionEnabled", *v.StickyExecutionEnabled)
	}
	if v.DecisionInfo != nil {
		err = multierr.Append(err, enc.AddObject("decisionInfo", v.DecisionInfo))
	}
	if v.WorkflowExecutionTaskList != nil {
		err = multierr.Append(err, enc.AddObject("WorkflowExecutionTaskList", v.WorkflowExecutionTaskList))
	}
	if v.EventStoreVersion != nil {
		enc.AddInt32("eventStoreVersion", *v.EventStoreVersion)
	}
	if v.BranchToken != nil {
		enc.AddString("branchToken", base64.StdEncoding.EncodeToString(v.BranchToken))
	}
	return err
}

// GetWorkflowType returns the value of WorkflowType if it is set or its
// zero value if it is unset.
func (v *RecordDecisionTaskStartedResponse) GetWorkflowType() (o *shared.WorkflowType) {
	if v.WorkflowType != nil {
		return v.WorkflowType
	}

	return
}

// GetPreviousStartedEventId returns the value of PreviousStartedEventId if it is set or its
// zero value if it is unset.
func (v *RecordDecisionTaskStartedResponse) GetPreviousStartedEventId() (o int64) {
	if v.PreviousStartedEventId != nil {
		return *v.PreviousStartedEventId
	}

	return
}

// GetScheduledEventId returns the value of ScheduledEventId if it is set or its
// zero value if it is unset.
func (v *RecordDecisionTaskStartedResponse) GetScheduledEventId() (o int64) {
	if v.ScheduledEventId != nil {
		return *v.ScheduledEventId
	}

	return
}

// GetStartedEventId returns the value of StartedEventId if it is set or its
// zero value if it is unset.
func (v *RecordDecisionTaskStartedResponse) GetStartedEventId() (o int64) {
	if v.StartedEventId != nil {
		return *v.StartedEventId
	}

	return
}

// GetNextEventId returns the value of NextEventId if it is set or its
// zero value if it is unset.
func (v *RecordDecisionTaskStartedResponse) GetNextEventId() (o int64) {
	if v.NextEventId != nil {
		return *v.NextEventId
	}

	return
}

// GetAttempt returns the value of Attempt if it is set or its
// zero value if it is unset.
func (v *RecordDecisionTaskStartedResponse) GetAttempt() (o int64) {
	if v.Attempt != nil {
		return *v.Attempt
	}

	return
}

// GetStickyExecutionEnabled returns the value of StickyExecutionEnabled if it is set or its
// zero value if it is unset.
func (v *RecordDecisionTaskStartedResponse) GetStickyExecutionEnabled() (o bool) {
	if v.StickyExecutionEnabled != nil {
		return *v.StickyExecutionEnabled
	}

	return
}

// GetDecisionInfo returns the value of DecisionInfo if it is set or its
// zero value if it is unset.
func (v *RecordDecisionTaskStartedResponse) GetDecisionInfo() (o *shared.TransientDecisionInfo) {
	if v.DecisionInfo != nil {
		return v.DecisionInfo
	}

	return
}

// GetWorkflowExecutionTaskList returns the value of WorkflowExecutionTaskList if it is set or its
// zero value if it is unset.
func (v *RecordDecisionTaskStartedResponse) GetWorkflowExecutionTaskList() (o *shared.TaskList) {
	if v.WorkflowExecutionTaskList != nil {
		return v.WorkflowExecutionTaskList
	}

	return
}

// GetEventStoreVersion returns the value of EventStoreVersion if it is set or its
// zero value if it is unset.
func (v *RecordDecisionTaskStartedResponse) GetEventStoreVersion() (o int32) {
	if v.EventStoreVersion != nil {
		return *v.EventStoreVersion
	}

	return
}

// GetBranchToken returns the value of BranchToken if it is set or its
// zero value if it is unset.
func (v *RecordDecisionTaskStartedResponse) GetBranchToken() (o []byte) {
	if v.BranchToken != nil {
		return v.BranchToken
	}

	return
}

type RemoveSignalMutableStateRequest struct {
	DomainUUID        *string                   `json:"domainUUID,omitempty"`
	WorkflowExecution *shared.WorkflowExecution `json:"workflowExecution,omitempty"`
	RequestId         *string                   `json:"requestId,omitempty"`
}

// ToWire translates a RemoveSignalMutableStateRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RemoveSignalMutableStateRequest) ToWire() (wire.Value, error) {
	var (
		fields [3]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.WorkflowExecution != nil {
		w, err = v.WorkflowExecution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.RequestId != nil {
		w, err = wire.NewValueString(*(v.RequestId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a RemoveSignalMutableStateRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RemoveSignalMutableStateRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RemoveSignalMutableStateRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RemoveSignalMutableStateRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.RequestId = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RemoveSignalMutableStateRequest
// struct.
func (v *RemoveSignalMutableStateRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [3]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.WorkflowExecution != nil {
		fields[i] = fmt.Sprintf("WorkflowExecution: %v", v.WorkflowExecution)
		i++
	}
	if v.RequestId != nil {
		fields[i] = fmt.Sprintf("RequestId: %v", *(v.RequestId))
		i++
	}

	return fmt.Sprintf("RemoveSignalMutableStateRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RemoveSignalMutableStateRequest match the
// provided RemoveSignalMutableStateRequest.
//
// This function performs a deep comparison.
func (v *RemoveSignalMutableStateRequest) Equals(rhs *RemoveSignalMutableStateRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.WorkflowExecution == nil && rhs.WorkflowExecution == nil) || (v.WorkflowExecution != nil && rhs.WorkflowExecution != nil && v.WorkflowExecution.Equals(rhs.WorkflowExecution))) {
		return false
	}
	if !_String_EqualsPtr(v.RequestId, rhs.RequestId) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RemoveSignalMutableStateRequest.
func (v *RemoveSignalMutableStateRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.WorkflowExecution != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecution", v.WorkflowExecution))
	}
	if v.RequestId != nil {
		enc.AddString("requestId", *v.RequestId)
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *RemoveSignalMutableStateRequest) GetDomainUUID() (o string) {
	if v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// GetWorkflowExecution returns the value of WorkflowExecution if it is set or its
// zero value if it is unset.
func (v *RemoveSignalMutableStateRequest) GetWorkflowExecution() (o *shared.WorkflowExecution) {
	if v.WorkflowExecution != nil {
		return v.WorkflowExecution
	}

	return
}

// GetRequestId returns the value of RequestId if it is set or its
// zero value if it is unset.
func (v *RemoveSignalMutableStateRequest) GetRequestId() (o string) {
	if v.RequestId != nil {
		return *v.RequestId
	}

	return
}

type ReplicateEventsRequest struct {
	SourceCluster           *string                            `json:"sourceCluster,omitempty"`
	DomainUUID              *string                            `json:"domainUUID,omitempty"`
	WorkflowExecution       *shared.WorkflowExecution          `json:"workflowExecution,omitempty"`
	FirstEventId            *int64                             `json:"firstEventId,omitempty"`
	NextEventId             *int64                             `json:"nextEventId,omitempty"`
	Version                 *int64                             `json:"version,omitempty"`
	ReplicationInfo         map[string]*shared.ReplicationInfo `json:"replicationInfo,omitempty"`
	History                 *shared.History                    `json:"history,omitempty"`
	NewRunHistory           *shared.History                    `json:"newRunHistory,omitempty"`
	ForceBufferEvents       *bool                              `json:"forceBufferEvents,omitempty"`
	EventStoreVersion       *int32                             `json:"eventStoreVersion,omitempty"`
	NewRunEventStoreVersion *int32                             `json:"newRunEventStoreVersion,omitempty"`
	ResetWorkflow           *bool                              `json:"resetWorkflow,omitempty"`
}

// ToWire translates a ReplicateEventsRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ReplicateEventsRequest) ToWire() (wire.Value, error) {
	var (
		fields [13]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.SourceCluster != nil {
		w, err = wire.NewValueString(*(v.SourceCluster)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.WorkflowExecution != nil {
		w, err = v.WorkflowExecution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.FirstEventId != nil {
		w, err = wire.NewValueI64(*(v.FirstEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.NextEventId != nil {
		w, err = wire.NewValueI64(*(v.NextEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.Version != nil {
		w, err = wire.NewValueI64(*(v.Version)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}
	if v.ReplicationInfo != nil {
		w, err = wire.NewValueMap(_Map_String_ReplicationInfo_MapItemList(v.ReplicationInfo)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 70, Value: w}
		i++
	}
	if v.History != nil {
		w, err = v.History.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 80, Value: w}
		i++
	}
	if v.NewRunHistory != nil {
		w, err = v.NewRunHistory.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 90, Value: w}
		i++
	}
	if v.ForceBufferEvents != nil {
		w, err = wire.NewValueBool(*(v.ForceBufferEvents)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 100, Value: w}
		i++
	}
	if v.EventStoreVersion != nil {
		w, err = wire.NewValueI32(*(v.EventStoreVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 110, Value: w}
		i++
	}
	if v.NewRunEventStoreVersion != nil {
		w, err = wire.NewValueI32(*(v.NewRunEventStoreVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 120, Value: w}
		i++
	}
	if v.ResetWorkflow != nil {
		w, err = wire.NewValueBool(*(v.ResetWorkflow)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 130, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _History_Read(w wire.Value) (*shared.History, error) {
	var v shared.History
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a ReplicateEventsRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ReplicateEventsRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ReplicateEventsRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ReplicateEventsRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.SourceCluster = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.FirstEventId = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.NextEventId = &x
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.Version = &x
				if err != nil {
					return err
				}

			}
		case 70:
			if field.Value.Type() == wire.TMap {
				v.ReplicationInfo, err = _Map_String_ReplicationInfo_Read(field.Value.GetMap())
				if err != nil {
					return err
				}

			}
		case 80:
			if field.Value.Type() == wire.TStruct {
				v.History, err = _History_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 90:
			if field.Value.Type() == wire.TStruct {
				v.NewRunHistory, err = _History_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 100:
			if field.Value.Type() == wire.TBool {
				var x bool
				x, err = field.Value.GetBool(), error(nil)
				v.ForceBufferEvents = &x
				if err != nil {
					return err
				}

			}
		case 110:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.EventStoreVersion = &x
				if err != nil {
					return err
				}

			}
		case 120:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.NewRunEventStoreVersion = &x
				if err != nil {
					return err
				}

			}
		case 130:
			if field.Value.Type() == wire.TBool {
				var x bool
				x, err = field.Value.GetBool(), error(nil)
				v.ResetWorkflow = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ReplicateEventsRequest
// struct.
func (v *ReplicateEventsRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [13]string
	i := 0
	if v.SourceCluster != nil {
		fields[i] = fmt.Sprintf("SourceCluster: %v", *(v.SourceCluster))
		i++
	}
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.WorkflowExecution != nil {
		fields[i] = fmt.Sprintf("WorkflowExecution: %v", v.WorkflowExecution)
		i++
	}
	if v.FirstEventId != nil {
		fields[i] = fmt.Sprintf("FirstEventId: %v", *(v.FirstEventId))
		i++
	}
	if v.NextEventId != nil {
		fields[i] = fmt.Sprintf("NextEventId: %v", *(v.NextEventId))
		i++
	}
	if v.Version != nil {
		fields[i] = fmt.Sprintf("Version: %v", *(v.Version))
		i++
	}
	if v.ReplicationInfo != nil {
		fields[i] = fmt.Sprintf("ReplicationInfo: %v", v.ReplicationInfo)
		i++
	}
	if v.History != nil {
		fields[i] = fmt.Sprintf("History: %v", v.History)
		i++
	}
	if v.NewRunHistory != nil {
		fields[i] = fmt.Sprintf("NewRunHistory: %v", v.NewRunHistory)
		i++
	}
	if v.ForceBufferEvents != nil {
		fields[i] = fmt.Sprintf("ForceBufferEvents: %v", *(v.ForceBufferEvents))
		i++
	}
	if v.EventStoreVersion != nil {
		fields[i] = fmt.Sprintf("EventStoreVersion: %v", *(v.EventStoreVersion))
		i++
	}
	if v.NewRunEventStoreVersion != nil {
		fields[i] = fmt.Sprintf("NewRunEventStoreVersion: %v", *(v.NewRunEventStoreVersion))
		i++
	}
	if v.ResetWorkflow != nil {
		fields[i] = fmt.Sprintf("ResetWorkflow: %v", *(v.ResetWorkflow))
		i++
	}

	return fmt.Sprintf("ReplicateEventsRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ReplicateEventsRequest match the
// provided ReplicateEventsRequest.
//
// This function performs a deep comparison.
func (v *ReplicateEventsRequest) Equals(rhs *ReplicateEventsRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.SourceCluster, rhs.SourceCluster) {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.WorkflowExecution == nil && rhs.WorkflowExecution == nil) || (v.WorkflowExecution != nil && rhs.WorkflowExecution != nil && v.WorkflowExecution.Equals(rhs.WorkflowExecution))) {
		return false
	}
	if !_I64_EqualsPtr(v.FirstEventId, rhs.FirstEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.NextEventId, rhs.NextEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.Version, rhs.Version) {
		return false
	}
	if !((v.ReplicationInfo == nil && rhs.ReplicationInfo == nil) || (v.ReplicationInfo != nil && rhs.ReplicationInfo != nil && _Map_String_ReplicationInfo_Equals(v.ReplicationInfo, rhs.ReplicationInfo))) {
		return false
	}
	if !((v.History == nil && rhs.History == nil) || (v.History != nil && rhs.History != nil && v.History.Equals(rhs.History))) {
		return false
	}
	if !((v.NewRunHistory == nil && rhs.NewRunHistory == nil) || (v.NewRunHistory != nil && rhs.NewRunHistory != nil && v.NewRunHistory.Equals(rhs.NewRunHistory))) {
		return false
	}
	if !_Bool_EqualsPtr(v.ForceBufferEvents, rhs.ForceBufferEvents) {
		return false
	}
	if !_I32_EqualsPtr(v.EventStoreVersion, rhs.EventStoreVersion) {
		return false
	}
	if !_I32_EqualsPtr(v.NewRunEventStoreVersion, rhs.NewRunEventStoreVersion) {
		return false
	}
	if !_Bool_EqualsPtr(v.ResetWorkflow, rhs.ResetWorkflow) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ReplicateEventsRequest.
func (v *ReplicateEventsRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.SourceCluster != nil {
		enc.AddString("sourceCluster", *v.SourceCluster)
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.WorkflowExecution != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecution", v.WorkflowExecution))
	}
	if v.FirstEventId != nil {
		enc.AddInt64("firstEventId", *v.FirstEventId)
	}
	if v.NextEventId != nil {
		enc.AddInt64("nextEventId", *v.NextEventId)
	}
	if v.Version != nil {
		enc.AddInt64("version", *v.Version)
	}
	if v.ReplicationInfo != nil {
		err = multierr.Append(err, enc.AddObject("replicationInfo", (_Map_String_ReplicationInfo_Zapper)(v.ReplicationInfo)))
	}
	if v.History != nil {
		err = multierr.Append(err, enc.AddObject("history", v.History))
	}
	if v.NewRunHistory != nil {
		err = multierr.Append(err, enc.AddObject("newRunHistory", v.NewRunHistory))
	}
	if v.ForceBufferEvents != nil {
		enc.AddBool("forceBufferEvents", *v.ForceBufferEvents)
	}
	if v.EventStoreVersion != nil {
		enc.AddInt32("eventStoreVersion", *v.EventStoreVersion)
	}
	if v.NewRunEventStoreVersion != nil {
		enc.AddInt32("newRunEventStoreVersion", *v.NewRunEventStoreVersion)
	}
	if v.ResetWorkflow != nil {
		enc.AddBool("resetWorkflow", *v.ResetWorkflow)
	}
	return err
}

// GetSourceCluster returns the value of SourceCluster if it is set or its
// zero value if it is unset.
func (v *ReplicateEventsRequest) GetSourceCluster() (o string) {
	if v.SourceCluster != nil {
		return *v.SourceCluster
	}

	return
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *ReplicateEventsRequest) GetDomainUUID() (o string) {
	if v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// GetWorkflowExecution returns the value of WorkflowExecution if it is set or its
// zero value if it is unset.
func (v *ReplicateEventsRequest) GetWorkflowExecution() (o *shared.WorkflowExecution) {
	if v.WorkflowExecution != nil {
		return v.WorkflowExecution
	}

	return
}

// GetFirstEventId returns the value of FirstEventId if it is set or its
// zero value if it is unset.
func (v *ReplicateEventsRequest) GetFirstEventId() (o int64) {
	if v.FirstEventId != nil {
		return *v.FirstEventId
	}

	return
}

// GetNextEventId returns the value of NextEventId if it is set or its
// zero value if it is unset.
func (v *ReplicateEventsRequest) GetNextEventId() (o int64) {
	if v.NextEventId != nil {
		return *v.NextEventId
	}

	return
}

// GetVersion returns the value of Version if it is set or its
// zero value if it is unset.
func (v *ReplicateEventsRequest) GetVersion() (o int64) {
	if v.Version != nil {
		return *v.Version
	}

	return
}

// GetReplicationInfo returns the value of ReplicationInfo if it is set or its
// zero value if it is unset.
func (v *ReplicateEventsRequest) GetReplicationInfo() (o map[string]*shared.ReplicationInfo) {
	if v.ReplicationInfo != nil {
		return v.ReplicationInfo
	}

	return
}

// GetHistory returns the value of History if it is set or its
// zero value if it is unset.
func (v *ReplicateEventsRequest) GetHistory() (o *shared.History) {
	if v.History != nil {
		return v.History
	}

	return
}

// GetNewRunHistory returns the value of NewRunHistory if it is set or its
// zero value if it is unset.
func (v *ReplicateEventsRequest) GetNewRunHistory() (o *shared.History) {
	if v.NewRunHistory != nil {
		return v.NewRunHistory
	}

	return
}

// GetForceBufferEvents returns the value of ForceBufferEvents if it is set or its
// zero value if it is unset.
func (v *ReplicateEventsRequest) GetForceBufferEvents() (o bool) {
	if v.ForceBufferEvents != nil {
		return *v.ForceBufferEvents
	}

	return
}

// GetEventStoreVersion returns the value of EventStoreVersion if it is set or its
// zero value if it is unset.
func (v *ReplicateEventsRequest) GetEventStoreVersion() (o int32) {
	if v.EventStoreVersion != nil {
		return *v.EventStoreVersion
	}

	return
}

// GetNewRunEventStoreVersion returns the value of NewRunEventStoreVersion if it is set or its
// zero value if it is unset.
func (v *ReplicateEventsRequest) GetNewRunEventStoreVersion() (o int32) {
	if v.NewRunEventStoreVersion != nil {
		return *v.NewRunEventStoreVersion
	}

	return
}

// GetResetWorkflow returns the value of ResetWorkflow if it is set or its
// zero value if it is unset.
func (v *ReplicateEventsRequest) GetResetWorkflow() (o bool) {
	if v.ResetWorkflow != nil {
		return *v.ResetWorkflow
	}

	return
}

type ReplicateRawEventsRequest struct {
	DomainUUID              *string                            `json:"domainUUID,omitempty"`
	WorkflowExecution       *shared.WorkflowExecution          `json:"workflowExecution,omitempty"`
	ReplicationInfo         map[string]*shared.ReplicationInfo `json:"replicationInfo,omitempty"`
	History                 *shared.DataBlob                   `json:"history,omitempty"`
	NewRunHistory           *shared.DataBlob                   `json:"newRunHistory,omitempty"`
	EventStoreVersion       *int32                             `json:"eventStoreVersion,omitempty"`
	NewRunEventStoreVersion *int32                             `json:"newRunEventStoreVersion,omitempty"`
}

// ToWire translates a ReplicateRawEventsRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ReplicateRawEventsRequest) ToWire() (wire.Value, error) {
	var (
		fields [7]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.WorkflowExecution != nil {
		w, err = v.WorkflowExecution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.ReplicationInfo != nil {
		w, err = wire.NewValueMap(_Map_String_ReplicationInfo_MapItemList(v.ReplicationInfo)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.History != nil {
		w, err = v.History.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.NewRunHistory != nil {
		w, err = v.NewRunHistory.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.EventStoreVersion != nil {
		w, err = wire.NewValueI32(*(v.EventStoreVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}
	if v.NewRunEventStoreVersion != nil {
		w, err = wire.NewValueI32(*(v.NewRunEventStoreVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 70, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _DataBlob_Read(w wire.Value) (*shared.DataBlob, error) {
	var v shared.DataBlob
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a ReplicateRawEventsRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ReplicateRawEventsRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ReplicateRawEventsRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ReplicateRawEventsRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TMap {
				v.ReplicationInfo, err = _Map_String_ReplicationInfo_Read(field.Value.GetMap())
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TStruct {
				v.History, err = _DataBlob_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TStruct {
				v.NewRunHistory, err = _DataBlob_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.EventStoreVersion = &x
				if err != nil {
					return err
				}

			}
		case 70:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.NewRunEventStoreVersion = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ReplicateRawEventsRequest
// struct.
func (v *ReplicateRawEventsRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [7]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.WorkflowExecution != nil {
		fields[i] = fmt.Sprintf("WorkflowExecution: %v", v.WorkflowExecution)
		i++
	}
	if v.ReplicationInfo != nil {
		fields[i] = fmt.Sprintf("ReplicationInfo: %v", v.ReplicationInfo)
		i++
	}
	if v.History != nil {
		fields[i] = fmt.Sprintf("History: %v", v.History)
		i++
	}
	if v.NewRunHistory != nil {
		fields[i] = fmt.Sprintf("NewRunHistory: %v", v.NewRunHistory)
		i++
	}
	if v.EventStoreVersion != nil {
		fields[i] = fmt.Sprintf("EventStoreVersion: %v", *(v.EventStoreVersion))
		i++
	}
	if v.NewRunEventStoreVersion != nil {
		fields[i] = fmt.Sprintf("NewRunEventStoreVersion: %v", *(v.NewRunEventStoreVersion))
		i++
	}

	return fmt.Sprintf("ReplicateRawEventsRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ReplicateRawEventsRequest match the
// provided ReplicateRawEventsRequest.
//
// This function performs a deep comparison.
func (v *ReplicateRawEventsRequest) Equals(rhs *ReplicateRawEventsRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.WorkflowExecution == nil && rhs.WorkflowExecution == nil) || (v.WorkflowExecution != nil && rhs.WorkflowExecution != nil && v.WorkflowExecution.Equals(rhs.WorkflowExecution))) {
		return false
	}
	if !((v.ReplicationInfo == nil && rhs.ReplicationInfo == nil) || (v.ReplicationInfo != nil && rhs.ReplicationInfo != nil && _Map_String_ReplicationInfo_Equals(v.ReplicationInfo, rhs.ReplicationInfo))) {
		return false
	}
	if !((v.History == nil && rhs.History == nil) || (v.History != nil && rhs.History != nil && v.History.Equals(rhs.History))) {
		return false
	}
	if !((v.NewRunHistory == nil && rhs.NewRunHistory == nil) || (v.NewRunHistory != nil && rhs.NewRunHistory != nil && v.NewRunHistory.Equals(rhs.NewRunHistory))) {
		return false
	}
	if !_I32_EqualsPtr(v.EventStoreVersion, rhs.EventStoreVersion) {
		return false
	}
	if !_I32_EqualsPtr(v.NewRunEventStoreVersion, rhs.NewRunEventStoreVersion) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ReplicateRawEventsRequest.
func (v *ReplicateRawEventsRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.WorkflowExecution != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecution", v.WorkflowExecution))
	}
	if v.ReplicationInfo != nil {
		err = multierr.Append(err, enc.AddObject("replicationInfo", (_Map_String_ReplicationInfo_Zapper)(v.ReplicationInfo)))
	}
	if v.History != nil {
		err = multierr.Append(err, enc.AddObject("history", v.History))
	}
	if v.NewRunHistory != nil {
		err = multierr.Append(err, enc.AddObject("newRunHistory", v.NewRunHistory))
	}
	if v.EventStoreVersion != nil {
		enc.AddInt32("eventStoreVersion", *v.EventStoreVersion)
	}
	if v.NewRunEventStoreVersion != nil {
		enc.AddInt32("newRunEventStoreVersion", *v.NewRunEventStoreVersion)
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *ReplicateRawEventsRequest) GetDomainUUID() (o string) {
	if v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// GetWorkflowExecution returns the value of WorkflowExecution if it is set or its
// zero value if it is unset.
func (v *ReplicateRawEventsRequest) GetWorkflowExecution() (o *shared.WorkflowExecution) {
	if v.WorkflowExecution != nil {
		return v.WorkflowExecution
	}

	return
}

// GetReplicationInfo returns the value of ReplicationInfo if it is set or its
// zero value if it is unset.
func (v *ReplicateRawEventsRequest) GetReplicationInfo() (o map[string]*shared.ReplicationInfo) {
	if v.ReplicationInfo != nil {
		return v.ReplicationInfo
	}

	return
}

// GetHistory returns the value of History if it is set or its
// zero value if it is unset.
func (v *ReplicateRawEventsRequest) GetHistory() (o *shared.DataBlob) {
	if v.History != nil {
		return v.History
	}

	return
}

// GetNewRunHistory returns the value of NewRunHistory if it is set or its
// zero value if it is unset.
func (v *ReplicateRawEventsRequest) GetNewRunHistory() (o *shared.DataBlob) {
	if v.NewRunHistory != nil {
		return v.NewRunHistory
	}

	return
}

// GetEventStoreVersion returns the value of EventStoreVersion if it is set or its
// zero value if it is unset.
func (v *ReplicateRawEventsRequest) GetEventStoreVersion() (o int32) {
	if v.EventStoreVersion != nil {
		return *v.EventStoreVersion
	}

	return
}

// GetNewRunEventStoreVersion returns the value of NewRunEventStoreVersion if it is set or its
// zero value if it is unset.
func (v *ReplicateRawEventsRequest) GetNewRunEventStoreVersion() (o int32) {
	if v.NewRunEventStoreVersion != nil {
		return *v.NewRunEventStoreVersion
	}

	return
}

type RequestCancelWorkflowExecutionRequest struct {
	DomainUUID                *string                                       `json:"domainUUID,omitempty"`
	CancelRequest             *shared.RequestCancelWorkflowExecutionRequest `json:"cancelRequest,omitempty"`
	ExternalInitiatedEventId  *int64                                        `json:"externalInitiatedEventId,omitempty"`
	ExternalWorkflowExecution *shared.WorkflowExecution                     `json:"externalWorkflowExecution,omitempty"`
	ChildWorkflowOnly         *bool                                         `json:"childWorkflowOnly,omitempty"`
}

// ToWire translates a RequestCancelWorkflowExecutionRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RequestCancelWorkflowExecutionRequest) ToWire() (wire.Value, error) {
	var (
		fields [5]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.CancelRequest != nil {
		w, err = v.CancelRequest.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.ExternalInitiatedEventId != nil {
		w, err = wire.NewValueI64(*(v.ExternalInitiatedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.ExternalWorkflowExecution != nil {
		w, err = v.ExternalWorkflowExecution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.ChildWorkflowOnly != nil {
		w, err = wire.NewValueBool(*(v.ChildWorkflowOnly)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _RequestCancelWorkflowExecutionRequest_Read(w wire.Value) (*shared.RequestCancelWorkflowExecutionRequest, error) {
	var v shared.RequestCancelWorkflowExecutionRequest
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a RequestCancelWorkflowExecutionRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RequestCancelWorkflowExecutionRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RequestCancelWorkflowExecutionRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RequestCancelWorkflowExecutionRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.CancelRequest, err = _RequestCancelWorkflowExecutionRequest_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ExternalInitiatedEventId = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TStruct {
				v.ExternalWorkflowExecution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TBool {
				var x bool
				x, err = field.Value.GetBool(), error(nil)
				v.ChildWorkflowOnly = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RequestCancelWorkflowExecutionRequest
// struct.
func (v *RequestCancelWorkflowExecutionRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [5]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.CancelRequest != nil {
		fields[i] = fmt.Sprintf("CancelRequest: %v", v.CancelRequest)
		i++
	}
	if v.ExternalInitiatedEventId != nil {
		fields[i] = fmt.Sprintf("ExternalInitiatedEventId: %v", *(v.ExternalInitiatedEventId))
		i++
	}
	if v.ExternalWorkflowExecution != nil {
		fields[i] = fmt.Sprintf("ExternalWorkflowExecution: %v", v.ExternalWorkflowExecution)
		i++
	}
	if v.ChildWorkflowOnly != nil {
		fields[i] = fmt.Sprintf("ChildWorkflowOnly: %v", *(v.ChildWorkflowOnly))
		i++
	}

	return fmt.Sprintf("RequestCancelWorkflowExecutionRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RequestCancelWorkflowExecutionRequest match the
// provided RequestCancelWorkflowExecutionRequest.
//
// This function performs a deep comparison.
func (v *RequestCancelWorkflowExecutionRequest) Equals(rhs *RequestCancelWorkflowExecutionRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.CancelRequest == nil && rhs.CancelRequest == nil) || (v.CancelRequest != nil && rhs.CancelRequest != nil && v.CancelRequest.Equals(rhs.CancelRequest))) {
		return false
	}
	if !_I64_EqualsPtr(v.ExternalInitiatedEventId, rhs.ExternalInitiatedEventId) {
		return false
	}
	if !((v.ExternalWorkflowExecution == nil && rhs.ExternalWorkflowExecution == nil) || (v.ExternalWorkflowExecution != nil && rhs.ExternalWorkflowExecution != nil && v.ExternalWorkflowExecution.Equals(rhs.ExternalWorkflowExecution))) {
		return false
	}
	if !_Bool_EqualsPtr(v.ChildWorkflowOnly, rhs.ChildWorkflowOnly) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RequestCancelWorkflowExecutionRequest.
func (v *RequestCancelWorkflowExecutionRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.CancelRequest != nil {
		err = multierr.Append(err, enc.AddObject("cancelRequest", v.CancelRequest))
	}
	if v.ExternalInitiatedEventId != nil {
		enc.AddInt64("externalInitiatedEventId", *v.ExternalInitiatedEventId)
	}
	if v.ExternalWorkflowExecution != nil {
		err = multierr.Append(err, enc.AddObject("externalWorkflowExecution", v.ExternalWorkflowExecution))
	}
	if v.ChildWorkflowOnly != nil {
		enc.AddBool("childWorkflowOnly", *v.ChildWorkflowOnly)
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *RequestCancelWorkflowExecutionRequest) GetDomainUUID() (o string) {
	if v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// GetCancelRequest returns the value of CancelRequest if it is set or its
// zero value if it is unset.
func (v *RequestCancelWorkflowExecutionRequest) GetCancelRequest() (o *shared.RequestCancelWorkflowExecutionRequest) {
	if v.CancelRequest != nil {
		return v.CancelRequest
	}

	return
}

// GetExternalInitiatedEventId returns the value of ExternalInitiatedEventId if it is set or its
// zero value if it is unset.
func (v *RequestCancelWorkflowExecutionRequest) GetExternalInitiatedEventId() (o int64) {
	if v.ExternalInitiatedEventId != nil {
		return *v.ExternalInitiatedEventId
	}

	return
}

// GetExternalWorkflowExecution returns the value of ExternalWorkflowExecution if it is set or its
// zero value if it is unset.
func (v *RequestCancelWorkflowExecutionRequest) GetExternalWorkflowExecution() (o *shared.WorkflowExecution) {
	if v.ExternalWorkflowExecution != nil {
		return v.ExternalWorkflowExecution
	}

	return
}

// GetChildWorkflowOnly returns the value of ChildWorkflowOnly if it is set or its
// zero value if it is unset.
func (v *RequestCancelWorkflowExecutionRequest) GetChildWorkflowOnly() (o bool) {
	if v.ChildWorkflowOnly != nil {
		return *v.ChildWorkflowOnly
	}

	return
}

type ResetStickyTaskListRequest struct {
	DomainUUID *string                   `json:"domainUUID,omitempty"`
	Execution  *shared.WorkflowExecution `json:"execution,omitempty"`
}

// ToWire translates a ResetStickyTaskListRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ResetStickyTaskListRequest) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Execution != nil {
		w, err = v.Execution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ResetStickyTaskListRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ResetStickyTaskListRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ResetStickyTaskListRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ResetStickyTaskListRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.Execution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ResetStickyTaskListRequest
// struct.
func (v *ResetStickyTaskListRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.Execution != nil {
		fields[i] = fmt.Sprintf("Execution: %v", v.Execution)
		i++
	}

	return fmt.Sprintf("ResetStickyTaskListRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ResetStickyTaskListRequest match the
// provided ResetStickyTaskListRequest.
//
// This function performs a deep comparison.
func (v *ResetStickyTaskListRequest) Equals(rhs *ResetStickyTaskListRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.Execution == nil && rhs.Execution == nil) || (v.Execution != nil && rhs.Execution != nil && v.Execution.Equals(rhs.Execution))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ResetStickyTaskListRequest.
func (v *ResetStickyTaskListRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.Execution != nil {
		err = multierr.Append(err, enc.AddObject("execution", v.Execution))
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *ResetStickyTaskListRequest) GetDomainUUID() (o string) {
	if v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// GetExecution returns the value of Execution if it is set or its
// zero value if it is unset.
func (v *ResetStickyTaskListRequest) GetExecution() (o *shared.WorkflowExecution) {
	if v.Execution != nil {
		return v.Execution
	}

	return
}

type ResetStickyTaskListResponse struct {
}

// ToWire translates a ResetStickyTaskListResponse struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ResetStickyTaskListResponse) ToWire() (wire.Value, error) {
	var (
		fields [0]wire.Field
		i      int = 0
	)

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ResetStickyTaskListResponse struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ResetStickyTaskListResponse struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ResetStickyTaskListResponse
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ResetStickyTaskListResponse) FromWire(w wire.Value) error {

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		}
	}

	return nil
}

// String returns a readable string representation of a ResetStickyTaskListResponse
// struct.
func (v *ResetStickyTaskListResponse) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [0]string
	i := 0

	return fmt.Sprintf("ResetStickyTaskListResponse{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ResetStickyTaskListResponse match the
// provided ResetStickyTaskListResponse.
//
// This function performs a deep comparison.
func (v *ResetStickyTaskListResponse) Equals(rhs *ResetStickyTaskListResponse) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ResetStickyTaskListResponse.
func (v *ResetStickyTaskListResponse) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	return err
}

type ResetWorkflowExecutionRequest struct {
	DomainUUID   *string                               `json:"domainUUID,omitempty"`
	ResetRequest *shared.ResetWorkflowExecutionRequest `json:"resetRequest,omitempty"`
}

// ToWire translates a ResetWorkflowExecutionRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ResetWorkflowExecutionRequest) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.ResetRequest != nil {
		w, err = v.ResetRequest.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _ResetWorkflowExecutionRequest_Read(w wire.Value) (*shared.ResetWorkflowExecutionRequest, error) {
	var v shared.ResetWorkflowExecutionRequest
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a ResetWorkflowExecutionRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ResetWorkflowExecutionRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ResetWorkflowExecutionRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ResetWorkflowExecutionRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.ResetRequest, err = _ResetWorkflowExecutionRequest_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ResetWorkflowExecutionRequest
// struct.
func (v *ResetWorkflowExecutionRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.ResetRequest != nil {
		fields[i] = fmt.Sprintf("ResetRequest: %v", v.ResetRequest)
		i++
	}

	return fmt.Sprintf("ResetWorkflowExecutionRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ResetWorkflowExecutionRequest match the
// provided ResetWorkflowExecutionRequest.
//
// This function performs a deep comparison.
func (v *ResetWorkflowExecutionRequest) Equals(rhs *ResetWorkflowExecutionRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.ResetRequest == nil && rhs.ResetRequest == nil) || (v.ResetRequest != nil && rhs.ResetRequest != nil && v.ResetRequest.Equals(rhs.ResetRequest))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ResetWorkflowExecutionRequest.
func (v *ResetWorkflowExecutionRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.ResetRequest != nil {
		err = multierr.Append(err, enc.AddObject("resetRequest", v.ResetRequest))
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *ResetWorkflowExecutionRequest) GetDomainUUID() (o string) {
	if v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// GetResetRequest returns the value of ResetRequest if it is set or its
// zero value if it is unset.
func (v *ResetWorkflowExecutionRequest) GetResetRequest() (o *shared.ResetWorkflowExecutionRequest) {
	if v.ResetRequest != nil {
		return v.ResetRequest
	}

	return
}

type RespondActivityTaskCanceledRequest struct {
	DomainUUID    *string                                    `json:"domainUUID,omitempty"`
	CancelRequest *shared.RespondActivityTaskCanceledRequest `json:"cancelRequest,omitempty"`
}

// ToWire translates a RespondActivityTaskCanceledRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RespondActivityTaskCanceledRequest) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.CancelRequest != nil {
		w, err = v.CancelRequest.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _RespondActivityTaskCanceledRequest_Read(w wire.Value) (*shared.RespondActivityTaskCanceledRequest, error) {
	var v shared.RespondActivityTaskCanceledRequest
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a RespondActivityTaskCanceledRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RespondActivityTaskCanceledRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RespondActivityTaskCanceledRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RespondActivityTaskCanceledRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.CancelRequest, err = _RespondActivityTaskCanceledRequest_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RespondActivityTaskCanceledRequest
// struct.
func (v *RespondActivityTaskCanceledRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.CancelRequest != nil {
		fields[i] = fmt.Sprintf("CancelRequest: %v", v.CancelRequest)
		i++
	}

	return fmt.Sprintf("RespondActivityTaskCanceledRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RespondActivityTaskCanceledRequest match the
// provided RespondActivityTaskCanceledRequest.
//
// This function performs a deep comparison.
func (v *RespondActivityTaskCanceledRequest) Equals(rhs *RespondActivityTaskCanceledRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.CancelRequest == nil && rhs.CancelRequest == nil) || (v.CancelRequest != nil && rhs.CancelRequest != nil && v.CancelRequest.Equals(rhs.CancelRequest))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RespondActivityTaskCanceledRequest.
func (v *RespondActivityTaskCanceledRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.CancelRequest != nil {
		err = multierr.Append(err, enc.AddObject("cancelRequest", v.CancelRequest))
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskCanceledRequest) GetDomainUUID() (o string) {
	if v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// GetCancelRequest returns the value of CancelRequest if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskCanceledRequest) GetCancelRequest() (o *shared.RespondActivityTaskCanceledRequest) {
	if v.CancelRequest != nil {
		return v.CancelRequest
	}

	return
}

type RespondActivityTaskCompletedRequest struct {
	DomainUUID      *string                                     `json:"domainUUID,omitempty"`
	CompleteRequest *shared.RespondActivityTaskCompletedRequest `json:"completeRequest,omitempty"`
}

// ToWire translates a RespondActivityTaskCompletedRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RespondActivityTaskCompletedRequest) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.CompleteRequest != nil {
		w, err = v.CompleteRequest.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _RespondActivityTaskCompletedRequest_Read(w wire.Value) (*shared.RespondActivityTaskCompletedRequest, error) {
	var v shared.RespondActivityTaskCompletedRequest
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a RespondActivityTaskCompletedRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RespondActivityTaskCompletedRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RespondActivityTaskCompletedRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RespondActivityTaskCompletedRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.CompleteRequest, err = _RespondActivityTaskCompletedRequest_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RespondActivityTaskCompletedRequest
// struct.
func (v *RespondActivityTaskCompletedRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.CompleteRequest != nil {
		fields[i] = fmt.Sprintf("CompleteRequest: %v", v.CompleteRequest)
		i++
	}

	return fmt.Sprintf("RespondActivityTaskCompletedRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RespondActivityTaskCompletedRequest match the
// provided RespondActivityTaskCompletedRequest.
//
// This function performs a deep comparison.
func (v *RespondActivityTaskCompletedRequest) Equals(rhs *RespondActivityTaskCompletedRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.CompleteRequest == nil && rhs.CompleteRequest == nil) || (v.CompleteRequest != nil && rhs.CompleteRequest != nil && v.CompleteRequest.Equals(rhs.CompleteRequest))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RespondActivityTaskCompletedRequest.
func (v *RespondActivityTaskCompletedRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.CompleteRequest != nil {
		err = multierr.Append(err, enc.AddObject("completeRequest", v.CompleteRequest))
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskCompletedRequest) GetDomainUUID() (o string) {
	if v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// GetCompleteRequest returns the value of CompleteRequest if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskCompletedRequest) GetCompleteRequest() (o *shared.RespondActivityTaskCompletedRequest) {
	if v.CompleteRequest != nil {
		return v.CompleteRequest
	}

	return
}

type RespondActivityTaskFailedRequest struct {
	DomainUUID    *string                                  `json:"domainUUID,omitempty"`
	FailedRequest *shared.RespondActivityTaskFailedRequest `json:"failedRequest,omitempty"`
}

// ToWire translates a RespondActivityTaskFailedRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RespondActivityTaskFailedRequest) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.FailedRequest != nil {
		w, err = v.FailedRequest.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _RespondActivityTaskFailedRequest_Read(w wire.Value) (*shared.RespondActivityTaskFailedRequest, error) {
	var v shared.RespondActivityTaskFailedRequest
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a RespondActivityTaskFailedRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RespondActivityTaskFailedRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RespondActivityTaskFailedRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RespondActivityTaskFailedRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.FailedRequest, err = _RespondActivityTaskFailedRequest_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RespondActivityTaskFailedRequest
// struct.
func (v *RespondActivityTaskFailedRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.FailedRequest != nil {
		fields[i] = fmt.Sprintf("FailedRequest: %v", v.FailedRequest)
		i++
	}

	return fmt.Sprintf("RespondActivityTaskFailedRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RespondActivityTaskFailedRequest match the
// provided RespondActivityTaskFailedRequest.
//
// This function performs a deep comparison.
func (v *RespondActivityTaskFailedRequest) Equals(rhs *RespondActivityTaskFailedRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.FailedRequest == nil && rhs.FailedRequest == nil) || (v.FailedRequest != nil && rhs.FailedRequest != nil && v.FailedRequest.Equals(rhs.FailedRequest))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RespondActivityTaskFailedRequest.
func (v *RespondActivityTaskFailedRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.FailedRequest != nil {
		err = multierr.Append(err, enc.AddObject("failedRequest", v.FailedRequest))
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskFailedRequest) GetDomainUUID() (o string) {
	if v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// GetFailedRequest returns the value of FailedRequest if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskFailedRequest) GetFailedRequest() (o *shared.RespondActivityTaskFailedRequest) {
	if v.FailedRequest != nil {
		return v.FailedRequest
	}

	return
}

type RespondDecisionTaskCompletedRequest struct {
	DomainUUID      *string                                     `json:"domainUUID,omitempty"`
	CompleteRequest *shared.RespondDecisionTaskCompletedRequest `json:"completeRequest,omitempty"`
}

// ToWire translates a RespondDecisionTaskCompletedRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RespondDecisionTaskCompletedRequest) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.CompleteRequest != nil {
		w, err = v.CompleteRequest.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _RespondDecisionTaskCompletedRequest_Read(w wire.Value) (*shared.RespondDecisionTaskCompletedRequest, error) {
	var v shared.RespondDecisionTaskCompletedRequest
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a RespondDecisionTaskCompletedRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RespondDecisionTaskCompletedRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RespondDecisionTaskCompletedRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RespondDecisionTaskCompletedRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.CompleteRequest, err = _RespondDecisionTaskCompletedRequest_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RespondDecisionTaskCompletedRequest
// struct.
func (v *RespondDecisionTaskCompletedRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.CompleteRequest != nil {
		fields[i] = fmt.Sprintf("CompleteRequest: %v", v.CompleteRequest)
		i++
	}

	return fmt.Sprintf("RespondDecisionTaskCompletedRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RespondDecisionTaskCompletedRequest match the
// provided RespondDecisionTaskCompletedRequest.
//
// This function performs a deep comparison.
func (v *RespondDecisionTaskCompletedRequest) Equals(rhs *RespondDecisionTaskCompletedRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.CompleteRequest == nil && rhs.CompleteRequest == nil) || (v.CompleteRequest != nil && rhs.CompleteRequest != nil && v.CompleteRequest.Equals(rhs.CompleteRequest))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RespondDecisionTaskCompletedRequest.
func (v *RespondDecisionTaskCompletedRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.CompleteRequest != nil {
		err = multierr.Append(err, enc.AddObject("completeRequest", v.CompleteRequest))
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *RespondDecisionTaskCompletedRequest) GetDomainUUID() (o string) {
	if v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// GetCompleteRequest returns the value of CompleteRequest if it is set or its
// zero value if it is unset.
func (v *RespondDecisionTaskCompletedRequest) GetCompleteRequest() (o *shared.RespondDecisionTaskCompletedRequest) {
	if v.CompleteRequest != nil {
		return v.CompleteRequest
	}

	return
}

type RespondDecisionTaskCompletedResponse struct {
	StartedResponse *RecordDecisionTaskStartedResponse `json:"startedResponse,omitempty"`
}

// ToWire translates a RespondDecisionTaskCompletedResponse struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RespondDecisionTaskCompletedResponse) ToWire() (wire.Value, error) {
	var (
		fields [1]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.StartedResponse != nil {
		w, err = v.StartedResponse.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _RecordDecisionTaskStartedResponse_Read(w wire.Value) (*RecordDecisionTaskStartedResponse, error) {
	var v RecordDecisionTaskStartedResponse
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a RespondDecisionTaskCompletedResponse struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RespondDecisionTaskCompletedResponse struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RespondDecisionTaskCompletedResponse
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RespondDecisionTaskCompletedResponse) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TStruct {
				v.StartedResponse, err = _RecordDecisionTaskStartedResponse_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RespondDecisionTaskCompletedResponse
// struct.
func (v *RespondDecisionTaskCompletedResponse) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [1]string
	i := 0
	if v.StartedResponse != nil {
		fields[i] = fmt.Sprintf("StartedResponse: %v", v.StartedResponse)
		i++
	}

	return fmt.Sprintf("RespondDecisionTaskCompletedResponse{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RespondDecisionTaskCompletedResponse match the
// provided RespondDecisionTaskCompletedResponse.
//
// This function performs a deep comparison.
func (v *RespondDecisionTaskCompletedResponse) Equals(rhs *RespondDecisionTaskCompletedResponse) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.StartedResponse == nil && rhs.StartedResponse == nil) || (v.StartedResponse != nil && rhs.StartedResponse != nil && v.StartedResponse.Equals(rhs.StartedResponse))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RespondDecisionTaskCompletedResponse.
func (v *RespondDecisionTaskCompletedResponse) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.StartedResponse != nil {
		err = multierr.Append(err, enc.AddObject("startedResponse", v.StartedResponse))
	}
	return err
}

// GetStartedResponse returns the value of StartedResponse if it is set or its
// zero value if it is unset.
func (v *RespondDecisionTaskCompletedResponse) GetStartedResponse() (o *RecordDecisionTaskStartedResponse) {
	if v.StartedResponse != nil {
		return v.StartedResponse
	}

	return
}

type RespondDecisionTaskFailedRequest struct {
	DomainUUID    *string                                  `json:"domainUUID,omitempty"`
	FailedRequest *shared.RespondDecisionTaskFailedRequest `json:"failedRequest,omitempty"`
}

// ToWire translates a RespondDecisionTaskFailedRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RespondDecisionTaskFailedRequest) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.FailedRequest != nil {
		w, err = v.FailedRequest.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _RespondDecisionTaskFailedRequest_Read(w wire.Value) (*shared.RespondDecisionTaskFailedRequest, error) {
	var v shared.RespondDecisionTaskFailedRequest
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a RespondDecisionTaskFailedRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RespondDecisionTaskFailedRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RespondDecisionTaskFailedRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RespondDecisionTaskFailedRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.FailedRequest, err = _RespondDecisionTaskFailedRequest_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RespondDecisionTaskFailedRequest
// struct.
func (v *RespondDecisionTaskFailedRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.FailedRequest != nil {
		fields[i] = fmt.Sprintf("FailedRequest: %v", v.FailedRequest)
		i++
	}

	return fmt.Sprintf("RespondDecisionTaskFailedRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RespondDecisionTaskFailedRequest match the
// provided RespondDecisionTaskFailedRequest.
//
// This function performs a deep comparison.
func (v *RespondDecisionTaskFailedRequest) Equals(rhs *RespondDecisionTaskFailedRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.FailedRequest == nil && rhs.FailedRequest == nil) || (v.FailedRequest != nil && rhs.FailedRequest != nil && v.FailedRequest.Equals(rhs.FailedRequest))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RespondDecisionTaskFailedRequest.
func (v *RespondDecisionTaskFailedRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.FailedRequest != nil {
		err = multierr.Append(err, enc.AddObject("failedRequest", v.FailedRequest))
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *RespondDecisionTaskFailedRequest) GetDomainUUID() (o string) {
	if v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// GetFailedRequest returns the value of FailedRequest if it is set or its
// zero value if it is unset.
func (v *RespondDecisionTaskFailedRequest) GetFailedRequest() (o *shared.RespondDecisionTaskFailedRequest) {
	if v.FailedRequest != nil {
		return v.FailedRequest
	}

	return
}

type ScheduleDecisionTaskRequest struct {
	DomainUUID        *string                   `json:"domainUUID,omitempty"`
	WorkflowExecution *shared.WorkflowExecution `json:"workflowExecution,omitempty"`
}

// ToWire translates a ScheduleDecisionTaskRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ScheduleDecisionTaskRequest) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.WorkflowExecution != nil {
		w, err = v.WorkflowExecution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ScheduleDecisionTaskRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ScheduleDecisionTaskRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ScheduleDecisionTaskRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ScheduleDecisionTaskRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ScheduleDecisionTaskRequest
// struct.
func (v *ScheduleDecisionTaskRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.WorkflowExecution != nil {
		fields[i] = fmt.Sprintf("WorkflowExecution: %v", v.WorkflowExecution)
		i++
	}

	return fmt.Sprintf("ScheduleDecisionTaskRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ScheduleDecisionTaskRequest match the
// provided ScheduleDecisionTaskRequest.
//
// This function performs a deep comparison.
func (v *ScheduleDecisionTaskRequest) Equals(rhs *ScheduleDecisionTaskRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.WorkflowExecution == nil && rhs.WorkflowExecution == nil) || (v.WorkflowExecution != nil && rhs.WorkflowExecution != nil && v.WorkflowExecution.Equals(rhs.WorkflowExecution))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ScheduleDecisionTaskRequest.
func (v *ScheduleDecisionTaskRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.WorkflowExecution != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecution", v.WorkflowExecution))
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *ScheduleDecisionTaskRequest) GetDomainUUID() (o string) {
	if v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// GetWorkflowExecution returns the value of WorkflowExecution if it is set or its
// zero value if it is unset.
func (v *ScheduleDecisionTaskRequest) GetWorkflowExecution() (o *shared.WorkflowExecution) {
	if v.WorkflowExecution != nil {
		return v.WorkflowExecution
	}

	return
}

type ShardOwnershipLostError struct {
	Message *string `json:"message,omitempty"`
	Owner   *string `json:"owner,omitempty"`
}

// ToWire translates a ShardOwnershipLostError struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ShardOwnershipLostError) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Message != nil {
		w, err = wire.NewValueString(*(v.Message)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Owner != nil {
		w, err = wire.NewValueString(*(v.Owner)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ShardOwnershipLostError struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ShardOwnershipLostError struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ShardOwnershipLostError
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ShardOwnershipLostError) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Message = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Owner = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ShardOwnershipLostError
// struct.
func (v *ShardOwnershipLostError) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.Message != nil {
		fields[i] = fmt.Sprintf("Message: %v", *(v.Message))
		i++
	}
	if v.Owner != nil {
		fields[i] = fmt.Sprintf("Owner: %v", *(v.Owner))
		i++
	}

	return fmt.Sprintf("ShardOwnershipLostError{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ShardOwnershipLostError match the
// provided ShardOwnershipLostError.
//
// This function performs a deep comparison.
func (v *ShardOwnershipLostError) Equals(rhs *ShardOwnershipLostError) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Message, rhs.Message) {
		return false
	}
	if !_String_EqualsPtr(v.Owner, rhs.Owner) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ShardOwnershipLostError.
func (v *ShardOwnershipLostError) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Message != nil {
		enc.AddString("message", *v.Message)
	}
	if v.Owner != nil {
		enc.AddString("owner", *v.Owner)
	}
	return err
}

// GetMessage returns the value of Message if it is set or its
// zero value if it is unset.
func (v *ShardOwnershipLostError) GetMessage() (o string) {
	if v.Message != nil {
		return *v.Message
	}

	return
}

// GetOwner returns the value of Owner if it is set or its
// zero value if it is unset.
func (v *ShardOwnershipLostError) GetOwner() (o string) {
	if v.Owner != nil {
		return *v.Owner
	}

	return
}

func (v *ShardOwnershipLostError) Error() string {
	return v.String()
}

type SignalWithStartWorkflowExecutionRequest struct {
	DomainUUID             *string                                         `json:"domainUUID,omitempty"`
	SignalWithStartRequest *shared.SignalWithStartWorkflowExecutionRequest `json:"signalWithStartRequest,omitempty"`
}

// ToWire translates a SignalWithStartWorkflowExecutionRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *SignalWithStartWorkflowExecutionRequest) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.SignalWithStartRequest != nil {
		w, err = v.SignalWithStartRequest.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _SignalWithStartWorkflowExecutionRequest_Read(w wire.Value) (*shared.SignalWithStartWorkflowExecutionRequest, error) {
	var v shared.SignalWithStartWorkflowExecutionRequest
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a SignalWithStartWorkflowExecutionRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a SignalWithStartWorkflowExecutionRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v SignalWithStartWorkflowExecutionRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *SignalWithStartWorkflowExecutionRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.SignalWithStartRequest, err = _SignalWithStartWorkflowExecutionRequest_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a SignalWithStartWorkflowExecutionRequest
// struct.
func (v *SignalWithStartWorkflowExecutionRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.SignalWithStartRequest != nil {
		fields[i] = fmt.Sprintf("SignalWithStartRequest: %v", v.SignalWithStartRequest)
		i++
	}

	return fmt.Sprintf("SignalWithStartWorkflowExecutionRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this SignalWithStartWorkflowExecutionRequest match the
// provided SignalWithStartWorkflowExecutionRequest.
//
// This function performs a deep comparison.
func (v *SignalWithStartWorkflowExecutionRequest) Equals(rhs *SignalWithStartWorkflowExecutionRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.SignalWithStartRequest == nil && rhs.SignalWithStartRequest == nil) || (v.SignalWithStartRequest != nil && rhs.SignalWithStartRequest != nil && v.SignalWithStartRequest.Equals(rhs.SignalWithStartRequest))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of SignalWithStartWorkflowExecutionRequest.
func (v *SignalWithStartWorkflowExecutionRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.SignalWithStartRequest != nil {
		err = multierr.Append(err, enc.AddObject("signalWithStartRequest", v.SignalWithStartRequest))
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *SignalWithStartWorkflowExecutionRequest) GetDomainUUID() (o string) {
	if v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// GetSignalWithStartRequest returns the value of SignalWithStartRequest if it is set or its
// zero value if it is unset.
func (v *SignalWithStartWorkflowExecutionRequest) GetSignalWithStartRequest() (o *shared.SignalWithStartWorkflowExecutionRequest) {
	if v.SignalWithStartRequest != nil {
		return v.SignalWithStartRequest
	}

	return
}

type SignalWorkflowExecutionRequest struct {
	DomainUUID                *string                                `json:"domainUUID,omitempty"`
	SignalRequest             *shared.SignalWorkflowExecutionRequest `json:"signalRequest,omitempty"`
	ExternalWorkflowExecution *shared.WorkflowExecution              `json:"externalWorkflowExecution,omitempty"`
	ChildWorkflowOnly         *bool                                  `json:"childWorkflowOnly,omitempty"`
}

// ToWire translates a SignalWorkflowExecutionRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *SignalWorkflowExecutionRequest) ToWire() (wire.Value, error) {
	var (
		fields [4]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.SignalRequest != nil {
		w, err = v.SignalRequest.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.ExternalWorkflowExecution != nil {
		w, err = v.ExternalWorkflowExecution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.ChildWorkflowOnly != nil {
		w, err = wire.NewValueBool(*(v.ChildWorkflowOnly)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _SignalWorkflowExecutionRequest_Read(w wire.Value) (*shared.SignalWorkflowExecutionRequest, error) {
	var v shared.SignalWorkflowExecutionRequest
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a SignalWorkflowExecutionRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a SignalWorkflowExecutionRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v SignalWorkflowExecutionRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *SignalWorkflowExecutionRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.SignalRequest, err = _SignalWorkflowExecutionRequest_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TStruct {
				v.ExternalWorkflowExecution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBool {
				var x bool
				x, err = field.Value.GetBool(), error(nil)
				v.ChildWorkflowOnly = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a SignalWorkflowExecutionRequest
// struct.
func (v *SignalWorkflowExecutionRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [4]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.SignalRequest != nil {
		fields[i] = fmt.Sprintf("SignalRequest: %v", v.SignalRequest)
		i++
	}
	if v.ExternalWorkflowExecution != nil {
		fields[i] = fmt.Sprintf("ExternalWorkflowExecution: %v", v.ExternalWorkflowExecution)
		i++
	}
	if v.ChildWorkflowOnly != nil {
		fields[i] = fmt.Sprintf("ChildWorkflowOnly: %v", *(v.ChildWorkflowOnly))
		i++
	}

	return fmt.Sprintf("SignalWorkflowExecutionRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this SignalWorkflowExecutionRequest match the
// provided SignalWorkflowExecutionRequest.
//
// This function performs a deep comparison.
func (v *SignalWorkflowExecutionRequest) Equals(rhs *SignalWorkflowExecutionRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.SignalRequest == nil && rhs.SignalRequest == nil) || (v.SignalRequest != nil && rhs.SignalRequest != nil && v.SignalRequest.Equals(rhs.SignalRequest))) {
		return false
	}
	if !((v.ExternalWorkflowExecution == nil && rhs.ExternalWorkflowExecution == nil) || (v.ExternalWorkflowExecution != nil && rhs.ExternalWorkflowExecution != nil && v.ExternalWorkflowExecution.Equals(rhs.ExternalWorkflowExecution))) {
		return false
	}
	if !_Bool_EqualsPtr(v.ChildWorkflowOnly, rhs.ChildWorkflowOnly) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of SignalWorkflowExecutionRequest.
func (v *SignalWorkflowExecutionRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.SignalRequest != nil {
		err = multierr.Append(err, enc.AddObject("signalRequest", v.SignalRequest))
	}
	if v.ExternalWorkflowExecution != nil {
		err = multierr.Append(err, enc.AddObject("externalWorkflowExecution", v.ExternalWorkflowExecution))
	}
	if v.ChildWorkflowOnly != nil {
		enc.AddBool("childWorkflowOnly", *v.ChildWorkflowOnly)
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *SignalWorkflowExecutionRequest) GetDomainUUID() (o string) {
	if v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// GetSignalRequest returns the value of SignalRequest if it is set or its
// zero value if it is unset.
func (v *SignalWorkflowExecutionRequest) GetSignalRequest() (o *shared.SignalWorkflowExecutionRequest) {
	if v.SignalRequest != nil {
		return v.SignalRequest
	}

	return
}

// GetExternalWorkflowExecution returns the value of ExternalWorkflowExecution if it is set or its
// zero value if it is unset.
func (v *SignalWorkflowExecutionRequest) GetExternalWorkflowExecution() (o *shared.WorkflowExecution) {
	if v.ExternalWorkflowExecution != nil {
		return v.ExternalWorkflowExecution
	}

	return
}

// GetChildWorkflowOnly returns the value of ChildWorkflowOnly if it is set or its
// zero value if it is unset.
func (v *SignalWorkflowExecutionRequest) GetChildWorkflowOnly() (o bool) {
	if v.ChildWorkflowOnly != nil {
		return *v.ChildWorkflowOnly
	}

	return
}

type StartWorkflowExecutionRequest struct {
	DomainUUID                      *string                               `json:"domainUUID,omitempty"`
	StartRequest                    *shared.StartWorkflowExecutionRequest `json:"startRequest,omitempty"`
	ParentExecutionInfo             *ParentExecutionInfo                  `json:"parentExecutionInfo,omitempty"`
	Attempt                         *int32                                `json:"attempt,omitempty"`
	ExpirationTimestamp             *int64                                `json:"expirationTimestamp,omitempty"`
	ContinueAsNewInitiator          *shared.ContinueAsNewInitiator        `json:"continueAsNewInitiator,omitempty"`
	ContinuedFailureReason          *string                               `json:"continuedFailureReason,omitempty"`
	ContinuedFailureDetails         []byte                                `json:"continuedFailureDetails,omitempty"`
	LastCompletionResult            []byte                                `json:"lastCompletionResult,omitempty"`
	FirstDecisionTaskBackoffSeconds *int32                                `json:"firstDecisionTaskBackoffSeconds,omitempty"`
}

// ToWire translates a StartWorkflowExecutionRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *StartWorkflowExecutionRequest) ToWire() (wire.Value, error) {
	var (
		fields [10]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.StartRequest != nil {
		w, err = v.StartRequest.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.ParentExecutionInfo != nil {
		w, err = v.ParentExecutionInfo.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.Attempt != nil {
		w, err = wire.NewValueI32(*(v.Attempt)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.ExpirationTimestamp != nil {
		w, err = wire.NewValueI64(*(v.ExpirationTimestamp)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.ContinueAsNewInitiator != nil {
		w, err = v.ContinueAsNewInitiator.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 55, Value: w}
		i++
	}
	if v.ContinuedFailureReason != nil {
		w, err = wire.NewValueString(*(v.ContinuedFailureReason)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 56, Value: w}
		i++
	}
	if v.ContinuedFailureDetails != nil {
		w, err = wire.NewValueBinary(v.ContinuedFailureDetails), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 57, Value: w}
		i++
	}
	if v.LastCompletionResult != nil {
		w, err = wire.NewValueBinary(v.LastCompletionResult), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 58, Value: w}
		i++
	}
	if v.FirstDecisionTaskBackoffSeconds != nil {
		w, err = wire.NewValueI32(*(v.FirstDecisionTaskBackoffSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _StartWorkflowExecutionRequest_Read(w wire.Value) (*shared.StartWorkflowExecutionRequest, error) {
	var v shared.StartWorkflowExecutionRequest
	err := v.FromWire(w)
	return &v, err
}

func _ParentExecutionInfo_Read(w wire.Value) (*ParentExecutionInfo, error) {
	var v ParentExecutionInfo
	err := v.FromWire(w)
	return &v, err
}

func _ContinueAsNewInitiator_Read(w wire.Value) (shared.ContinueAsNewInitiator, error) {
	var v shared.ContinueAsNewInitiator
	err := v.FromWire(w)
	return v, err
}

// FromWire deserializes a StartWorkflowExecutionRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a StartWorkflowExecutionRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v StartWorkflowExecutionRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *StartWorkflowExecutionRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.StartRequest, err = _StartWorkflowExecutionRequest_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TStruct {
				v.ParentExecutionInfo, err = _ParentExecutionInfo_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.Attempt = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ExpirationTimestamp = &x
				if err != nil {
					return err
				}

			}
		case 55:
			if field.Value.Type() == wire.TI32 {
				var x shared.ContinueAsNewInitiator
				x, err = _ContinueAsNewInitiator_Read(field.Value)
				v.ContinueAsNewInitiator = &x
				if err != nil {
					return err
				}

			}
		case 56:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ContinuedFailureReason = &x
				if err != nil {
					return err
				}

			}
		case 57:
			if field.Value.Type() == wire.TBinary {
				v.ContinuedFailureDetails, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 58:
			if field.Value.Type() == wire.TBinary {
				v.LastCompletionResult, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.FirstDecisionTaskBackoffSeconds = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a StartWorkflowExecutionRequest
// struct.
func (v *StartWorkflowExecutionRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [10]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.StartRequest != nil {
		fields[i] = fmt.Sprintf("StartRequest: %v", v.StartRequest)
		i++
	}
	if v.ParentExecutionInfo != nil {
		fields[i] = fmt.Sprintf("ParentExecutionInfo: %v", v.ParentExecutionInfo)
		i++
	}
	if v.Attempt != nil {
		fields[i] = fmt.Sprintf("Attempt: %v", *(v.Attempt))
		i++
	}
	if v.ExpirationTimestamp != nil {
		fields[i] = fmt.Sprintf("ExpirationTimestamp: %v", *(v.ExpirationTimestamp))
		i++
	}
	if v.ContinueAsNewInitiator != nil {
		fields[i] = fmt.Sprintf("ContinueAsNewInitiator: %v", *(v.ContinueAsNewInitiator))
		i++
	}
	if v.ContinuedFailureReason != nil {
		fields[i] = fmt.Sprintf("ContinuedFailureReason: %v", *(v.ContinuedFailureReason))
		i++
	}
	if v.ContinuedFailureDetails != nil {
		fields[i] = fmt.Sprintf("ContinuedFailureDetails: %v", v.ContinuedFailureDetails)
		i++
	}
	if v.LastCompletionResult != nil {
		fields[i] = fmt.Sprintf("LastCompletionResult: %v", v.LastCompletionResult)
		i++
	}
	if v.FirstDecisionTaskBackoffSeconds != nil {
		fields[i] = fmt.Sprintf("FirstDecisionTaskBackoffSeconds: %v", *(v.FirstDecisionTaskBackoffSeconds))
		i++
	}

	return fmt.Sprintf("StartWorkflowExecutionRequest{%v}", strings.Join(fields[:i], ", "))
}

func _ContinueAsNewInitiator_EqualsPtr(lhs, rhs *shared.ContinueAsNewInitiator) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return x.Equals(y)
	}
	return lhs == nil && rhs == nil
}

// Equals returns true if all the fields of this StartWorkflowExecutionRequest match the
// provided StartWorkflowExecutionRequest.
//
// This function performs a deep comparison.
func (v *StartWorkflowExecutionRequest) Equals(rhs *StartWorkflowExecutionRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.StartRequest == nil && rhs.StartRequest == nil) || (v.StartRequest != nil && rhs.StartRequest != nil && v.StartRequest.Equals(rhs.StartRequest))) {
		return false
	}
	if !((v.ParentExecutionInfo == nil && rhs.ParentExecutionInfo == nil) || (v.ParentExecutionInfo != nil && rhs.ParentExecutionInfo != nil && v.ParentExecutionInfo.Equals(rhs.ParentExecutionInfo))) {
		return false
	}
	if !_I32_EqualsPtr(v.Attempt, rhs.Attempt) {
		return false
	}
	if !_I64_EqualsPtr(v.ExpirationTimestamp, rhs.ExpirationTimestamp) {
		return false
	}
	if !_ContinueAsNewInitiator_EqualsPtr(v.ContinueAsNewInitiator, rhs.ContinueAsNewInitiator) {
		return false
	}
	if !_String_EqualsPtr(v.ContinuedFailureReason, rhs.ContinuedFailureReason) {
		return false
	}
	if !((v.ContinuedFailureDetails == nil && rhs.ContinuedFailureDetails == nil) || (v.ContinuedFailureDetails != nil && rhs.ContinuedFailureDetails != nil && bytes.Equal(v.ContinuedFailureDetails, rhs.ContinuedFailureDetails))) {
		return false
	}
	if !((v.LastCompletionResult == nil && rhs.LastCompletionResult == nil) || (v.LastCompletionResult != nil && rhs.LastCompletionResult != nil && bytes.Equal(v.LastCompletionResult, rhs.LastCompletionResult))) {
		return false
	}
	if !_I32_EqualsPtr(v.FirstDecisionTaskBackoffSeconds, rhs.FirstDecisionTaskBackoffSeconds) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of StartWorkflowExecutionRequest.
func (v *StartWorkflowExecutionRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.StartRequest != nil {
		err = multierr.Append(err, enc.AddObject("startRequest", v.StartRequest))
	}
	if v.ParentExecutionInfo != nil {
		err = multierr.Append(err, enc.AddObject("parentExecutionInfo", v.ParentExecutionInfo))
	}
	if v.Attempt != nil {
		enc.AddInt32("attempt", *v.Attempt)
	}
	if v.ExpirationTimestamp != nil {
		enc.AddInt64("expirationTimestamp", *v.ExpirationTimestamp)
	}
	if v.ContinueAsNewInitiator != nil {
		err = multierr.Append(err, enc.AddObject("continueAsNewInitiator", *v.ContinueAsNewInitiator))
	}
	if v.ContinuedFailureReason != nil {
		enc.AddString("continuedFailureReason", *v.ContinuedFailureReason)
	}
	if v.ContinuedFailureDetails != nil {
		enc.AddString("continuedFailureDetails", base64.StdEncoding.EncodeToString(v.ContinuedFailureDetails))
	}
	if v.LastCompletionResult != nil {
		enc.AddString("lastCompletionResult", base64.StdEncoding.EncodeToString(v.LastCompletionResult))
	}
	if v.FirstDecisionTaskBackoffSeconds != nil {
		enc.AddInt32("firstDecisionTaskBackoffSeconds", *v.FirstDecisionTaskBackoffSeconds)
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *StartWorkflowExecutionRequest) GetDomainUUID() (o string) {
	if v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// GetStartRequest returns the value of StartRequest if it is set or its
// zero value if it is unset.
func (v *StartWorkflowExecutionRequest) GetStartRequest() (o *shared.StartWorkflowExecutionRequest) {
	if v.StartRequest != nil {
		return v.StartRequest
	}

	return
}

// GetParentExecutionInfo returns the value of ParentExecutionInfo if it is set or its
// zero value if it is unset.
func (v *StartWorkflowExecutionRequest) GetParentExecutionInfo() (o *ParentExecutionInfo) {
	if v.ParentExecutionInfo != nil {
		return v.ParentExecutionInfo
	}

	return
}

// GetAttempt returns the value of Attempt if it is set or its
// zero value if it is unset.
func (v *StartWorkflowExecutionRequest) GetAttempt() (o int32) {
	if v.Attempt != nil {
		return *v.Attempt
	}

	return
}

// GetExpirationTimestamp returns the value of ExpirationTimestamp if it is set or its
// zero value if it is unset.
func (v *StartWorkflowExecutionRequest) GetExpirationTimestamp() (o int64) {
	if v.ExpirationTimestamp != nil {
		return *v.ExpirationTimestamp
	}

	return
}

// GetContinueAsNewInitiator returns the value of ContinueAsNewInitiator if it is set or its
// zero value if it is unset.
func (v *StartWorkflowExecutionRequest) GetContinueAsNewInitiator() (o shared.ContinueAsNewInitiator) {
	if v.ContinueAsNewInitiator != nil {
		return *v.ContinueAsNewInitiator
	}

	return
}

// GetContinuedFailureReason returns the value of ContinuedFailureReason if it is set or its
// zero value if it is unset.
func (v *StartWorkflowExecutionRequest) GetContinuedFailureReason() (o string) {
	if v.ContinuedFailureReason != nil {
		return *v.ContinuedFailureReason
	}

	return
}

// GetContinuedFailureDetails returns the value of ContinuedFailureDetails if it is set or its
// zero value if it is unset.
func (v *StartWorkflowExecutionRequest) GetContinuedFailureDetails() (o []byte) {
	if v.ContinuedFailureDetails != nil {
		return v.ContinuedFailureDetails
	}

	return
}

// GetLastCompletionResult returns the value of LastCompletionResult if it is set or its
// zero value if it is unset.
func (v *StartWorkflowExecutionRequest) GetLastCompletionResult() (o []byte) {
	if v.LastCompletionResult != nil {
		return v.LastCompletionResult
	}

	return
}

// GetFirstDecisionTaskBackoffSeconds returns the value of FirstDecisionTaskBackoffSeconds if it is set or its
// zero value if it is unset.
func (v *StartWorkflowExecutionRequest) GetFirstDecisionTaskBackoffSeconds() (o int32) {
	if v.FirstDecisionTaskBackoffSeconds != nil {
		return *v.FirstDecisionTaskBackoffSeconds
	}

	return
}

type SyncActivityRequest struct {
	DomainId          *string `json:"domainId,omitempty"`
	WorkflowId        *string `json:"workflowId,omitempty"`
	RunId             *string `json:"runId,omitempty"`
	Version           *int64  `json:"version,omitempty"`
	ScheduledId       *int64  `json:"scheduledId,omitempty"`
	ScheduledTime     *int64  `json:"scheduledTime,omitempty"`
	StartedId         *int64  `json:"startedId,omitempty"`
	StartedTime       *int64  `json:"startedTime,omitempty"`
	LastHeartbeatTime *int64  `json:"lastHeartbeatTime,omitempty"`
	Details           []byte  `json:"details,omitempty"`
	Attempt           *int32  `json:"attempt,omitempty"`
}

// ToWire translates a SyncActivityRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *SyncActivityRequest) ToWire() (wire.Value, error) {
	var (
		fields [11]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainId != nil {
		w, err = wire.NewValueString(*(v.DomainId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.WorkflowId != nil {
		w, err = wire.NewValueString(*(v.WorkflowId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.RunId != nil {
		w, err = wire.NewValueString(*(v.RunId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.Version != nil {
		w, err = wire.NewValueI64(*(v.Version)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.ScheduledId != nil {
		w, err = wire.NewValueI64(*(v.ScheduledId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.ScheduledTime != nil {
		w, err = wire.NewValueI64(*(v.ScheduledTime)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}
	if v.StartedId != nil {
		w, err = wire.NewValueI64(*(v.StartedId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 70, Value: w}
		i++
	}
	if v.StartedTime != nil {
		w, err = wire.NewValueI64(*(v.StartedTime)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 80, Value: w}
		i++
	}
	if v.LastHeartbeatTime != nil {
		w, err = wire.NewValueI64(*(v.LastHeartbeatTime)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 90, Value: w}
		i++
	}
	if v.Details != nil {
		w, err = wire.NewValueBinary(v.Details), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 100, Value: w}
		i++
	}
	if v.Attempt != nil {
		w, err = wire.NewValueI32(*(v.Attempt)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 110, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a SyncActivityRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a SyncActivityRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v SyncActivityRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *SyncActivityRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainId = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.WorkflowId = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.RunId = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.Version = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduledId = &x
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduledTime = &x
				if err != nil {
					return err
				}

			}
		case 70:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StartedId = &x
				if err != nil {
					return err
				}

			}
		case 80:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StartedTime = &x
				if err != nil {
					return err
				}

			}
		case 90:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.LastHeartbeatTime = &x
				if err != nil {
					return err
				}

			}
		case 100:
			if field.Value.Type() == wire.TBinary {
				v.Details, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 110:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.Attempt = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a SyncActivityRequest
// struct.
func (v *SyncActivityRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [11]string
	i := 0
	if v.DomainId != nil {
		fields[i] = fmt.Sprintf("DomainId: %v", *(v.DomainId))
		i++
	}
	if v.WorkflowId != nil {
		fields[i] = fmt.Sprintf("WorkflowId: %v", *(v.WorkflowId))
		i++
	}
	if v.RunId != nil {
		fields[i] = fmt.Sprintf("RunId: %v", *(v.RunId))
		i++
	}
	if v.Version != nil {
		fields[i] = fmt.Sprintf("Version: %v", *(v.Version))
		i++
	}
	if v.ScheduledId != nil {
		fields[i] = fmt.Sprintf("ScheduledId: %v", *(v.ScheduledId))
		i++
	}
	if v.ScheduledTime != nil {
		fields[i] = fmt.Sprintf("ScheduledTime: %v", *(v.ScheduledTime))
		i++
	}
	if v.StartedId != nil {
		fields[i] = fmt.Sprintf("StartedId: %v", *(v.StartedId))
		i++
	}
	if v.StartedTime != nil {
		fields[i] = fmt.Sprintf("StartedTime: %v", *(v.StartedTime))
		i++
	}
	if v.LastHeartbeatTime != nil {
		fields[i] = fmt.Sprintf("LastHeartbeatTime: %v", *(v.LastHeartbeatTime))
		i++
	}
	if v.Details != nil {
		fields[i] = fmt.Sprintf("Details: %v", v.Details)
		i++
	}
	if v.Attempt != nil {
		fields[i] = fmt.Sprintf("Attempt: %v", *(v.Attempt))
		i++
	}

	return fmt.Sprintf("SyncActivityRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this SyncActivityRequest match the
// provided SyncActivityRequest.
//
// This function performs a deep comparison.
func (v *SyncActivityRequest) Equals(rhs *SyncActivityRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainId, rhs.DomainId) {
		return false
	}
	if !_String_EqualsPtr(v.WorkflowId, rhs.WorkflowId) {
		return false
	}
	if !_String_EqualsPtr(v.RunId, rhs.RunId) {
		return false
	}
	if !_I64_EqualsPtr(v.Version, rhs.Version) {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduledId, rhs.ScheduledId) {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduledTime, rhs.ScheduledTime) {
		return false
	}
	if !_I64_EqualsPtr(v.StartedId, rhs.StartedId) {
		return false
	}
	if !_I64_EqualsPtr(v.StartedTime, rhs.StartedTime) {
		return false
	}
	if !_I64_EqualsPtr(v.LastHeartbeatTime, rhs.LastHeartbeatTime) {
		return false
	}
	if !((v.Details == nil && rhs.Details == nil) || (v.Details != nil && rhs.Details != nil && bytes.Equal(v.Details, rhs.Details))) {
		return false
	}
	if !_I32_EqualsPtr(v.Attempt, rhs.Attempt) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of SyncActivityRequest.
func (v *SyncActivityRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainId != nil {
		enc.AddString("domainId", *v.DomainId)
	}
	if v.WorkflowId != nil {
		enc.AddString("workflowId", *v.WorkflowId)
	}
	if v.RunId != nil {
		enc.AddString("runId", *v.RunId)
	}
	if v.Version != nil {
		enc.AddInt64("version", *v.Version)
	}
	if v.ScheduledId != nil {
		enc.AddInt64("scheduledId", *v.ScheduledId)
	}
	if v.ScheduledTime != nil {
		enc.AddInt64("scheduledTime", *v.ScheduledTime)
	}
	if v.StartedId != nil {
		enc.AddInt64("startedId", *v.StartedId)
	}
	if v.StartedTime != nil {
		enc.AddInt64("startedTime", *v.StartedTime)
	}
	if v.LastHeartbeatTime != nil {
		enc.AddInt64("lastHeartbeatTime", *v.LastHeartbeatTime)
	}
	if v.Details != nil {
		enc.AddString("details", base64.StdEncoding.EncodeToString(v.Details))
	}
	if v.Attempt != nil {
		enc.AddInt32("attempt", *v.Attempt)
	}
	return err
}

// GetDomainId returns the value of DomainId if it is set or its
// zero value if it is unset.
func (v *SyncActivityRequest) GetDomainId() (o string) {
	if v.DomainId != nil {
		return *v.DomainId
	}

	return
}

// GetWorkflowId returns the value of WorkflowId if it is set or its
// zero value if it is unset.
func (v *SyncActivityRequest) GetWorkflowId() (o string) {
	if v.WorkflowId != nil {
		return *v.WorkflowId
	}

	return
}

// GetRunId returns the value of RunId if it is set or its
// zero value if it is unset.
func (v *SyncActivityRequest) GetRunId() (o string) {
	if v.RunId != nil {
		return *v.RunId
	}

	return
}

// GetVersion returns the value of Version if it is set or its
// zero value if it is unset.
func (v *SyncActivityRequest) GetVersion() (o int64) {
	if v.Version != nil {
		return *v.Version
	}

	return
}

// GetScheduledId returns the value of ScheduledId if it is set or its
// zero value if it is unset.
func (v *SyncActivityRequest) GetScheduledId() (o int64) {
	if v.ScheduledId != nil {
		return *v.ScheduledId
	}

	return
}

// GetScheduledTime returns the value of ScheduledTime if it is set or its
// zero value if it is unset.
func (v *SyncActivityRequest) GetScheduledTime() (o int64) {
	if v.ScheduledTime != nil {
		return *v.ScheduledTime
	}

	return
}

// GetStartedId returns the value of StartedId if it is set or its
// zero value if it is unset.
func (v *SyncActivityRequest) GetStartedId() (o int64) {
	if v.StartedId != nil {
		return *v.StartedId
	}

	return
}

// GetStartedTime returns the value of StartedTime if it is set or its
// zero value if it is unset.
func (v *SyncActivityRequest) GetStartedTime() (o int64) {
	if v.StartedTime != nil {
		return *v.StartedTime
	}

	return
}

// GetLastHeartbeatTime returns the value of LastHeartbeatTime if it is set or its
// zero value if it is unset.
func (v *SyncActivityRequest) GetLastHeartbeatTime() (o int64) {
	if v.LastHeartbeatTime != nil {
		return *v.LastHeartbeatTime
	}

	return
}

// GetDetails returns the value of Details if it is set or its
// zero value if it is unset.
func (v *SyncActivityRequest) GetDetails() (o []byte) {
	if v.Details != nil {
		return v.Details
	}

	return
}

// GetAttempt returns the value of Attempt if it is set or its
// zero value if it is unset.
func (v *SyncActivityRequest) GetAttempt() (o int32) {
	if v.Attempt != nil {
		return *v.Attempt
	}

	return
}

type SyncShardStatusRequest struct {
	SourceCluster *string `json:"sourceCluster,omitempty"`
	ShardId       *int64  `json:"shardId,omitempty"`
	Timestamp     *int64  `json:"timestamp,omitempty"`
}

// ToWire translates a SyncShardStatusRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *SyncShardStatusRequest) ToWire() (wire.Value, error) {
	var (
		fields [3]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.SourceCluster != nil {
		w, err = wire.NewValueString(*(v.SourceCluster)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.ShardId != nil {
		w, err = wire.NewValueI64(*(v.ShardId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.Timestamp != nil {
		w, err = wire.NewValueI64(*(v.Timestamp)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a SyncShardStatusRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a SyncShardStatusRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v SyncShardStatusRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *SyncShardStatusRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.SourceCluster = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ShardId = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.Timestamp = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a SyncShardStatusRequest
// struct.
func (v *SyncShardStatusRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [3]string
	i := 0
	if v.SourceCluster != nil {
		fields[i] = fmt.Sprintf("SourceCluster: %v", *(v.SourceCluster))
		i++
	}
	if v.ShardId != nil {
		fields[i] = fmt.Sprintf("ShardId: %v", *(v.ShardId))
		i++
	}
	if v.Timestamp != nil {
		fields[i] = fmt.Sprintf("Timestamp: %v", *(v.Timestamp))
		i++
	}

	return fmt.Sprintf("SyncShardStatusRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this SyncShardStatusRequest match the
// provided SyncShardStatusRequest.
//
// This function performs a deep comparison.
func (v *SyncShardStatusRequest) Equals(rhs *SyncShardStatusRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.SourceCluster, rhs.SourceCluster) {
		return false
	}
	if !_I64_EqualsPtr(v.ShardId, rhs.ShardId) {
		return false
	}
	if !_I64_EqualsPtr(v.Timestamp, rhs.Timestamp) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of SyncShardStatusRequest.
func (v *SyncShardStatusRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.SourceCluster != nil {
		enc.AddString("sourceCluster", *v.SourceCluster)
	}
	if v.ShardId != nil {
		enc.AddInt64("shardId", *v.ShardId)
	}
	if v.Timestamp != nil {
		enc.AddInt64("timestamp", *v.Timestamp)
	}
	return err
}

// GetSourceCluster returns the value of SourceCluster if it is set or its
// zero value if it is unset.
func (v *SyncShardStatusRequest) GetSourceCluster() (o string) {
	if v.SourceCluster != nil {
		return *v.SourceCluster
	}

	return
}

// GetShardId returns the value of ShardId if it is set or its
// zero value if it is unset.
func (v *SyncShardStatusRequest) GetShardId() (o int64) {
	if v.ShardId != nil {
		return *v.ShardId
	}

	return
}

// GetTimestamp returns the value of Timestamp if it is set or its
// zero value if it is unset.
func (v *SyncShardStatusRequest) GetTimestamp() (o int64) {
	if v.Timestamp != nil {
		return *v.Timestamp
	}

	return
}

type TerminateWorkflowExecutionRequest struct {
	DomainUUID       *string                                   `json:"domainUUID,omitempty"`
	TerminateRequest *shared.TerminateWorkflowExecutionRequest `json:"terminateRequest,omitempty"`
}

// ToWire translates a TerminateWorkflowExecutionRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *TerminateWorkflowExecutionRequest) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.TerminateRequest != nil {
		w, err = v.TerminateRequest.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _TerminateWorkflowExecutionRequest_Read(w wire.Value) (*shared.TerminateWorkflowExecutionRequest, error) {
	var v shared.TerminateWorkflowExecutionRequest
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a TerminateWorkflowExecutionRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a TerminateWorkflowExecutionRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v TerminateWorkflowExecutionRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *TerminateWorkflowExecutionRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.TerminateRequest, err = _TerminateWorkflowExecutionRequest_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a TerminateWorkflowExecutionRequest
// struct.
func (v *TerminateWorkflowExecutionRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.TerminateRequest != nil {
		fields[i] = fmt.Sprintf("TerminateRequest: %v", v.TerminateRequest)
		i++
	}

	return fmt.Sprintf("TerminateWorkflowExecutionRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this TerminateWorkflowExecutionRequest match the
// provided TerminateWorkflowExecutionRequest.
//
// This function performs a deep comparison.
func (v *TerminateWorkflowExecutionRequest) Equals(rhs *TerminateWorkflowExecutionRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.TerminateRequest == nil && rhs.TerminateRequest == nil) || (v.TerminateRequest != nil && rhs.TerminateRequest != nil && v.TerminateRequest.Equals(rhs.TerminateRequest))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of TerminateWorkflowExecutionRequest.
func (v *TerminateWorkflowExecutionRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.TerminateRequest != nil {
		err = multierr.Append(err, enc.AddObject("terminateRequest", v.TerminateRequest))
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *TerminateWorkflowExecutionRequest) GetDomainUUID() (o string) {
	if v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// GetTerminateRequest returns the value of TerminateRequest if it is set or its
// zero value if it is unset.
func (v *TerminateWorkflowExecutionRequest) GetTerminateRequest() (o *shared.TerminateWorkflowExecutionRequest) {
	if v.TerminateRequest != nil {
		return v.TerminateRequest
	}

	return
}
