// Copyright (c) 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by mockery v1.0.0. DO NOT EDIT.
package mocks

import context "context"
import elastic "github.com/olivere/elastic"
import elasticsearch "github.com/uber/cadence/common/elasticsearch"
import mock "github.com/stretchr/testify/mock"

// Client is an autogenerated mock type for the Client type
type Client struct {
	mock.Mock
}

// RunBulkProcessor provides a mock function with given fields: ctx, p
func (_m *Client) RunBulkProcessor(ctx context.Context, p *elasticsearch.BulkProcessorParameters) (*elastic.BulkProcessor, error) {
	ret := _m.Called(ctx, p)

	var r0 *elastic.BulkProcessor
	if rf, ok := ret.Get(0).(func(context.Context, *elasticsearch.BulkProcessorParameters) *elastic.BulkProcessor); ok {
		r0 = rf(ctx, p)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*elastic.BulkProcessor)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *elasticsearch.BulkProcessorParameters) error); ok {
		r1 = rf(ctx, p)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Search provides a mock function with given fields: ctx, p
func (_m *Client) Search(ctx context.Context, p *elasticsearch.SearchParameters) (*elastic.SearchResult, error) {
	ret := _m.Called(ctx, p)

	var r0 *elastic.SearchResult
	if rf, ok := ret.Get(0).(func(context.Context, *elasticsearch.SearchParameters) *elastic.SearchResult); ok {
		r0 = rf(ctx, p)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*elastic.SearchResult)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *elasticsearch.SearchParameters) error); ok {
		r1 = rf(ctx, p)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}
