// Copyright (c) 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by mockery v1.0.0. DO NOT EDIT.

package mocks

import blob "github.com/uber/cadence/common/blobstore/blob"
import blobstore "github.com/uber/cadence/common/blobstore"
import context "context"
import mock "github.com/stretchr/testify/mock"

// BlobstoreClient is an autogenerated mock type for the blobstore.Client type
type BlobstoreClient struct {
	mock.Mock
}

// BucketMetadata provides a mock function with given fields: ctx, bucket
func (_m *BlobstoreClient) BucketMetadata(ctx context.Context, bucket string) (*blobstore.BucketMetadataResponse, error) {
	ret := _m.Called(ctx, bucket)

	var r0 *blobstore.BucketMetadataResponse
	if rf, ok := ret.Get(0).(func(context.Context, string) *blobstore.BucketMetadataResponse); ok {
		r0 = rf(ctx, bucket)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*blobstore.BucketMetadataResponse)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, bucket)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Delete provides a mock function with given fields: ctx, bucket, key
func (_m *BlobstoreClient) Delete(ctx context.Context, bucket string, key blob.Key) (bool, error) {
	ret := _m.Called(ctx, bucket, key)

	var r0 bool
	if rf, ok := ret.Get(0).(func(context.Context, string, blob.Key) bool); ok {
		r0 = rf(ctx, bucket, key)
	} else {
		r0 = ret.Get(0).(bool)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, blob.Key) error); ok {
		r1 = rf(ctx, bucket, key)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Download provides a mock function with given fields: ctx, bucket, key
func (_m *BlobstoreClient) Download(ctx context.Context, bucket string, key blob.Key) (*blob.Blob, error) {
	ret := _m.Called(ctx, bucket, key)

	var r0 *blob.Blob
	if rf, ok := ret.Get(0).(func(context.Context, string, blob.Key) *blob.Blob); ok {
		r0 = rf(ctx, bucket, key)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*blob.Blob)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, blob.Key) error); ok {
		r1 = rf(ctx, bucket, key)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Exists provides a mock function with given fields: ctx, bucket, key
func (_m *BlobstoreClient) Exists(ctx context.Context, bucket string, key blob.Key) (bool, error) {
	ret := _m.Called(ctx, bucket, key)

	var r0 bool
	if rf, ok := ret.Get(0).(func(context.Context, string, blob.Key) bool); ok {
		r0 = rf(ctx, bucket, key)
	} else {
		r0 = ret.Get(0).(bool)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, blob.Key) error); ok {
		r1 = rf(ctx, bucket, key)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListByPrefix provides a mock function with given fields: ctx, bucket, prefix
func (_m *BlobstoreClient) ListByPrefix(ctx context.Context, bucket string, prefix string) ([]blob.Key, error) {
	ret := _m.Called(ctx, bucket, prefix)

	var r0 []blob.Key
	if rf, ok := ret.Get(0).(func(context.Context, string, string) []blob.Key); ok {
		r0 = rf(ctx, bucket, prefix)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]blob.Key)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string) error); ok {
		r1 = rf(ctx, bucket, prefix)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Upload provides a mock function with given fields: ctx, bucket, key, _a3
func (_m *BlobstoreClient) Upload(ctx context.Context, bucket string, key blob.Key, _a3 *blob.Blob) error {
	ret := _m.Called(ctx, bucket, key, _a3)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, blob.Key, *blob.Blob) error); ok {
		r0 = rf(ctx, bucket, key, _a3)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}
