// Copyright (c) 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by thriftrw v1.18.0. DO NOT EDIT.
// @generated

package matching

import (
	bytes "bytes"
	base64 "encoding/base64"
	fmt "fmt"
	shared "github.com/uber/cadence/.gen/go/shared"
	multierr "go.uber.org/multierr"
	wire "go.uber.org/thriftrw/wire"
	zapcore "go.uber.org/zap/zapcore"
	strings "strings"
)

type AddActivityTaskRequest struct {
	DomainUUID                    *string                   `json:"domainUUID,omitempty"`
	Execution                     *shared.WorkflowExecution `json:"execution,omitempty"`
	SourceDomainUUID              *string                   `json:"sourceDomainUUID,omitempty"`
	TaskList                      *shared.TaskList          `json:"taskList,omitempty"`
	ScheduleId                    *int64                    `json:"scheduleId,omitempty"`
	ScheduleToStartTimeoutSeconds *int32                    `json:"scheduleToStartTimeoutSeconds,omitempty"`
}

// ToWire translates a AddActivityTaskRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *AddActivityTaskRequest) ToWire() (wire.Value, error) {
	var (
		fields [6]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Execution != nil {
		w, err = v.Execution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.SourceDomainUUID != nil {
		w, err = wire.NewValueString(*(v.SourceDomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.TaskList != nil {
		w, err = v.TaskList.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.ScheduleId != nil {
		w, err = wire.NewValueI64(*(v.ScheduleId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.ScheduleToStartTimeoutSeconds != nil {
		w, err = wire.NewValueI32(*(v.ScheduleToStartTimeoutSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _WorkflowExecution_Read(w wire.Value) (*shared.WorkflowExecution, error) {
	var v shared.WorkflowExecution
	err := v.FromWire(w)
	return &v, err
}

func _TaskList_Read(w wire.Value) (*shared.TaskList, error) {
	var v shared.TaskList
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a AddActivityTaskRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a AddActivityTaskRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v AddActivityTaskRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *AddActivityTaskRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.Execution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.SourceDomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TStruct {
				v.TaskList, err = _TaskList_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduleId = &x
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.ScheduleToStartTimeoutSeconds = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a AddActivityTaskRequest
// struct.
func (v *AddActivityTaskRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [6]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.Execution != nil {
		fields[i] = fmt.Sprintf("Execution: %v", v.Execution)
		i++
	}
	if v.SourceDomainUUID != nil {
		fields[i] = fmt.Sprintf("SourceDomainUUID: %v", *(v.SourceDomainUUID))
		i++
	}
	if v.TaskList != nil {
		fields[i] = fmt.Sprintf("TaskList: %v", v.TaskList)
		i++
	}
	if v.ScheduleId != nil {
		fields[i] = fmt.Sprintf("ScheduleId: %v", *(v.ScheduleId))
		i++
	}
	if v.ScheduleToStartTimeoutSeconds != nil {
		fields[i] = fmt.Sprintf("ScheduleToStartTimeoutSeconds: %v", *(v.ScheduleToStartTimeoutSeconds))
		i++
	}

	return fmt.Sprintf("AddActivityTaskRequest{%v}", strings.Join(fields[:i], ", "))
}

func _String_EqualsPtr(lhs, rhs *string) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return (x == y)
	}
	return lhs == nil && rhs == nil
}

func _I64_EqualsPtr(lhs, rhs *int64) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return (x == y)
	}
	return lhs == nil && rhs == nil
}

func _I32_EqualsPtr(lhs, rhs *int32) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return (x == y)
	}
	return lhs == nil && rhs == nil
}

// Equals returns true if all the fields of this AddActivityTaskRequest match the
// provided AddActivityTaskRequest.
//
// This function performs a deep comparison.
func (v *AddActivityTaskRequest) Equals(rhs *AddActivityTaskRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.Execution == nil && rhs.Execution == nil) || (v.Execution != nil && rhs.Execution != nil && v.Execution.Equals(rhs.Execution))) {
		return false
	}
	if !_String_EqualsPtr(v.SourceDomainUUID, rhs.SourceDomainUUID) {
		return false
	}
	if !((v.TaskList == nil && rhs.TaskList == nil) || (v.TaskList != nil && rhs.TaskList != nil && v.TaskList.Equals(rhs.TaskList))) {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduleId, rhs.ScheduleId) {
		return false
	}
	if !_I32_EqualsPtr(v.ScheduleToStartTimeoutSeconds, rhs.ScheduleToStartTimeoutSeconds) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of AddActivityTaskRequest.
func (v *AddActivityTaskRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.Execution != nil {
		err = multierr.Append(err, enc.AddObject("execution", v.Execution))
	}
	if v.SourceDomainUUID != nil {
		enc.AddString("sourceDomainUUID", *v.SourceDomainUUID)
	}
	if v.TaskList != nil {
		err = multierr.Append(err, enc.AddObject("taskList", v.TaskList))
	}
	if v.ScheduleId != nil {
		enc.AddInt64("scheduleId", *v.ScheduleId)
	}
	if v.ScheduleToStartTimeoutSeconds != nil {
		enc.AddInt32("scheduleToStartTimeoutSeconds", *v.ScheduleToStartTimeoutSeconds)
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *AddActivityTaskRequest) GetDomainUUID() (o string) {
	if v != nil && v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// IsSetDomainUUID returns true if DomainUUID is not nil.
func (v *AddActivityTaskRequest) IsSetDomainUUID() bool {
	return v != nil && v.DomainUUID != nil
}

// GetExecution returns the value of Execution if it is set or its
// zero value if it is unset.
func (v *AddActivityTaskRequest) GetExecution() (o *shared.WorkflowExecution) {
	if v != nil && v.Execution != nil {
		return v.Execution
	}

	return
}

// IsSetExecution returns true if Execution is not nil.
func (v *AddActivityTaskRequest) IsSetExecution() bool {
	return v != nil && v.Execution != nil
}

// GetSourceDomainUUID returns the value of SourceDomainUUID if it is set or its
// zero value if it is unset.
func (v *AddActivityTaskRequest) GetSourceDomainUUID() (o string) {
	if v != nil && v.SourceDomainUUID != nil {
		return *v.SourceDomainUUID
	}

	return
}

// IsSetSourceDomainUUID returns true if SourceDomainUUID is not nil.
func (v *AddActivityTaskRequest) IsSetSourceDomainUUID() bool {
	return v != nil && v.SourceDomainUUID != nil
}

// GetTaskList returns the value of TaskList if it is set or its
// zero value if it is unset.
func (v *AddActivityTaskRequest) GetTaskList() (o *shared.TaskList) {
	if v != nil && v.TaskList != nil {
		return v.TaskList
	}

	return
}

// IsSetTaskList returns true if TaskList is not nil.
func (v *AddActivityTaskRequest) IsSetTaskList() bool {
	return v != nil && v.TaskList != nil
}

// GetScheduleId returns the value of ScheduleId if it is set or its
// zero value if it is unset.
func (v *AddActivityTaskRequest) GetScheduleId() (o int64) {
	if v != nil && v.ScheduleId != nil {
		return *v.ScheduleId
	}

	return
}

// IsSetScheduleId returns true if ScheduleId is not nil.
func (v *AddActivityTaskRequest) IsSetScheduleId() bool {
	return v != nil && v.ScheduleId != nil
}

// GetScheduleToStartTimeoutSeconds returns the value of ScheduleToStartTimeoutSeconds if it is set or its
// zero value if it is unset.
func (v *AddActivityTaskRequest) GetScheduleToStartTimeoutSeconds() (o int32) {
	if v != nil && v.ScheduleToStartTimeoutSeconds != nil {
		return *v.ScheduleToStartTimeoutSeconds
	}

	return
}

// IsSetScheduleToStartTimeoutSeconds returns true if ScheduleToStartTimeoutSeconds is not nil.
func (v *AddActivityTaskRequest) IsSetScheduleToStartTimeoutSeconds() bool {
	return v != nil && v.ScheduleToStartTimeoutSeconds != nil
}

type AddDecisionTaskRequest struct {
	DomainUUID                    *string                   `json:"domainUUID,omitempty"`
	Execution                     *shared.WorkflowExecution `json:"execution,omitempty"`
	TaskList                      *shared.TaskList          `json:"taskList,omitempty"`
	ScheduleId                    *int64                    `json:"scheduleId,omitempty"`
	ScheduleToStartTimeoutSeconds *int32                    `json:"scheduleToStartTimeoutSeconds,omitempty"`
}

// ToWire translates a AddDecisionTaskRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *AddDecisionTaskRequest) ToWire() (wire.Value, error) {
	var (
		fields [5]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Execution != nil {
		w, err = v.Execution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.TaskList != nil {
		w, err = v.TaskList.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.ScheduleId != nil {
		w, err = wire.NewValueI64(*(v.ScheduleId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.ScheduleToStartTimeoutSeconds != nil {
		w, err = wire.NewValueI32(*(v.ScheduleToStartTimeoutSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a AddDecisionTaskRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a AddDecisionTaskRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v AddDecisionTaskRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *AddDecisionTaskRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.Execution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TStruct {
				v.TaskList, err = _TaskList_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduleId = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.ScheduleToStartTimeoutSeconds = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a AddDecisionTaskRequest
// struct.
func (v *AddDecisionTaskRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [5]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.Execution != nil {
		fields[i] = fmt.Sprintf("Execution: %v", v.Execution)
		i++
	}
	if v.TaskList != nil {
		fields[i] = fmt.Sprintf("TaskList: %v", v.TaskList)
		i++
	}
	if v.ScheduleId != nil {
		fields[i] = fmt.Sprintf("ScheduleId: %v", *(v.ScheduleId))
		i++
	}
	if v.ScheduleToStartTimeoutSeconds != nil {
		fields[i] = fmt.Sprintf("ScheduleToStartTimeoutSeconds: %v", *(v.ScheduleToStartTimeoutSeconds))
		i++
	}

	return fmt.Sprintf("AddDecisionTaskRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this AddDecisionTaskRequest match the
// provided AddDecisionTaskRequest.
//
// This function performs a deep comparison.
func (v *AddDecisionTaskRequest) Equals(rhs *AddDecisionTaskRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.Execution == nil && rhs.Execution == nil) || (v.Execution != nil && rhs.Execution != nil && v.Execution.Equals(rhs.Execution))) {
		return false
	}
	if !((v.TaskList == nil && rhs.TaskList == nil) || (v.TaskList != nil && rhs.TaskList != nil && v.TaskList.Equals(rhs.TaskList))) {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduleId, rhs.ScheduleId) {
		return false
	}
	if !_I32_EqualsPtr(v.ScheduleToStartTimeoutSeconds, rhs.ScheduleToStartTimeoutSeconds) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of AddDecisionTaskRequest.
func (v *AddDecisionTaskRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.Execution != nil {
		err = multierr.Append(err, enc.AddObject("execution", v.Execution))
	}
	if v.TaskList != nil {
		err = multierr.Append(err, enc.AddObject("taskList", v.TaskList))
	}
	if v.ScheduleId != nil {
		enc.AddInt64("scheduleId", *v.ScheduleId)
	}
	if v.ScheduleToStartTimeoutSeconds != nil {
		enc.AddInt32("scheduleToStartTimeoutSeconds", *v.ScheduleToStartTimeoutSeconds)
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *AddDecisionTaskRequest) GetDomainUUID() (o string) {
	if v != nil && v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// IsSetDomainUUID returns true if DomainUUID is not nil.
func (v *AddDecisionTaskRequest) IsSetDomainUUID() bool {
	return v != nil && v.DomainUUID != nil
}

// GetExecution returns the value of Execution if it is set or its
// zero value if it is unset.
func (v *AddDecisionTaskRequest) GetExecution() (o *shared.WorkflowExecution) {
	if v != nil && v.Execution != nil {
		return v.Execution
	}

	return
}

// IsSetExecution returns true if Execution is not nil.
func (v *AddDecisionTaskRequest) IsSetExecution() bool {
	return v != nil && v.Execution != nil
}

// GetTaskList returns the value of TaskList if it is set or its
// zero value if it is unset.
func (v *AddDecisionTaskRequest) GetTaskList() (o *shared.TaskList) {
	if v != nil && v.TaskList != nil {
		return v.TaskList
	}

	return
}

// IsSetTaskList returns true if TaskList is not nil.
func (v *AddDecisionTaskRequest) IsSetTaskList() bool {
	return v != nil && v.TaskList != nil
}

// GetScheduleId returns the value of ScheduleId if it is set or its
// zero value if it is unset.
func (v *AddDecisionTaskRequest) GetScheduleId() (o int64) {
	if v != nil && v.ScheduleId != nil {
		return *v.ScheduleId
	}

	return
}

// IsSetScheduleId returns true if ScheduleId is not nil.
func (v *AddDecisionTaskRequest) IsSetScheduleId() bool {
	return v != nil && v.ScheduleId != nil
}

// GetScheduleToStartTimeoutSeconds returns the value of ScheduleToStartTimeoutSeconds if it is set or its
// zero value if it is unset.
func (v *AddDecisionTaskRequest) GetScheduleToStartTimeoutSeconds() (o int32) {
	if v != nil && v.ScheduleToStartTimeoutSeconds != nil {
		return *v.ScheduleToStartTimeoutSeconds
	}

	return
}

// IsSetScheduleToStartTimeoutSeconds returns true if ScheduleToStartTimeoutSeconds is not nil.
func (v *AddDecisionTaskRequest) IsSetScheduleToStartTimeoutSeconds() bool {
	return v != nil && v.ScheduleToStartTimeoutSeconds != nil
}

type CancelOutstandingPollRequest struct {
	DomainUUID   *string          `json:"domainUUID,omitempty"`
	TaskListType *int32           `json:"taskListType,omitempty"`
	TaskList     *shared.TaskList `json:"taskList,omitempty"`
	PollerID     *string          `json:"pollerID,omitempty"`
}

// ToWire translates a CancelOutstandingPollRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *CancelOutstandingPollRequest) ToWire() (wire.Value, error) {
	var (
		fields [4]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.TaskListType != nil {
		w, err = wire.NewValueI32(*(v.TaskListType)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.TaskList != nil {
		w, err = v.TaskList.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.PollerID != nil {
		w, err = wire.NewValueString(*(v.PollerID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a CancelOutstandingPollRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a CancelOutstandingPollRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v CancelOutstandingPollRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *CancelOutstandingPollRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.TaskListType = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TStruct {
				v.TaskList, err = _TaskList_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.PollerID = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a CancelOutstandingPollRequest
// struct.
func (v *CancelOutstandingPollRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [4]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.TaskListType != nil {
		fields[i] = fmt.Sprintf("TaskListType: %v", *(v.TaskListType))
		i++
	}
	if v.TaskList != nil {
		fields[i] = fmt.Sprintf("TaskList: %v", v.TaskList)
		i++
	}
	if v.PollerID != nil {
		fields[i] = fmt.Sprintf("PollerID: %v", *(v.PollerID))
		i++
	}

	return fmt.Sprintf("CancelOutstandingPollRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this CancelOutstandingPollRequest match the
// provided CancelOutstandingPollRequest.
//
// This function performs a deep comparison.
func (v *CancelOutstandingPollRequest) Equals(rhs *CancelOutstandingPollRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !_I32_EqualsPtr(v.TaskListType, rhs.TaskListType) {
		return false
	}
	if !((v.TaskList == nil && rhs.TaskList == nil) || (v.TaskList != nil && rhs.TaskList != nil && v.TaskList.Equals(rhs.TaskList))) {
		return false
	}
	if !_String_EqualsPtr(v.PollerID, rhs.PollerID) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of CancelOutstandingPollRequest.
func (v *CancelOutstandingPollRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.TaskListType != nil {
		enc.AddInt32("taskListType", *v.TaskListType)
	}
	if v.TaskList != nil {
		err = multierr.Append(err, enc.AddObject("taskList", v.TaskList))
	}
	if v.PollerID != nil {
		enc.AddString("pollerID", *v.PollerID)
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *CancelOutstandingPollRequest) GetDomainUUID() (o string) {
	if v != nil && v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// IsSetDomainUUID returns true if DomainUUID is not nil.
func (v *CancelOutstandingPollRequest) IsSetDomainUUID() bool {
	return v != nil && v.DomainUUID != nil
}

// GetTaskListType returns the value of TaskListType if it is set or its
// zero value if it is unset.
func (v *CancelOutstandingPollRequest) GetTaskListType() (o int32) {
	if v != nil && v.TaskListType != nil {
		return *v.TaskListType
	}

	return
}

// IsSetTaskListType returns true if TaskListType is not nil.
func (v *CancelOutstandingPollRequest) IsSetTaskListType() bool {
	return v != nil && v.TaskListType != nil
}

// GetTaskList returns the value of TaskList if it is set or its
// zero value if it is unset.
func (v *CancelOutstandingPollRequest) GetTaskList() (o *shared.TaskList) {
	if v != nil && v.TaskList != nil {
		return v.TaskList
	}

	return
}

// IsSetTaskList returns true if TaskList is not nil.
func (v *CancelOutstandingPollRequest) IsSetTaskList() bool {
	return v != nil && v.TaskList != nil
}

// GetPollerID returns the value of PollerID if it is set or its
// zero value if it is unset.
func (v *CancelOutstandingPollRequest) GetPollerID() (o string) {
	if v != nil && v.PollerID != nil {
		return *v.PollerID
	}

	return
}

// IsSetPollerID returns true if PollerID is not nil.
func (v *CancelOutstandingPollRequest) IsSetPollerID() bool {
	return v != nil && v.PollerID != nil
}

type DescribeTaskListRequest struct {
	DomainUUID  *string                         `json:"domainUUID,omitempty"`
	DescRequest *shared.DescribeTaskListRequest `json:"descRequest,omitempty"`
}

// ToWire translates a DescribeTaskListRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *DescribeTaskListRequest) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.DescRequest != nil {
		w, err = v.DescRequest.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _DescribeTaskListRequest_Read(w wire.Value) (*shared.DescribeTaskListRequest, error) {
	var v shared.DescribeTaskListRequest
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a DescribeTaskListRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a DescribeTaskListRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v DescribeTaskListRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *DescribeTaskListRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.DescRequest, err = _DescribeTaskListRequest_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a DescribeTaskListRequest
// struct.
func (v *DescribeTaskListRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.DescRequest != nil {
		fields[i] = fmt.Sprintf("DescRequest: %v", v.DescRequest)
		i++
	}

	return fmt.Sprintf("DescribeTaskListRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this DescribeTaskListRequest match the
// provided DescribeTaskListRequest.
//
// This function performs a deep comparison.
func (v *DescribeTaskListRequest) Equals(rhs *DescribeTaskListRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.DescRequest == nil && rhs.DescRequest == nil) || (v.DescRequest != nil && rhs.DescRequest != nil && v.DescRequest.Equals(rhs.DescRequest))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DescribeTaskListRequest.
func (v *DescribeTaskListRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.DescRequest != nil {
		err = multierr.Append(err, enc.AddObject("descRequest", v.DescRequest))
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *DescribeTaskListRequest) GetDomainUUID() (o string) {
	if v != nil && v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// IsSetDomainUUID returns true if DomainUUID is not nil.
func (v *DescribeTaskListRequest) IsSetDomainUUID() bool {
	return v != nil && v.DomainUUID != nil
}

// GetDescRequest returns the value of DescRequest if it is set or its
// zero value if it is unset.
func (v *DescribeTaskListRequest) GetDescRequest() (o *shared.DescribeTaskListRequest) {
	if v != nil && v.DescRequest != nil {
		return v.DescRequest
	}

	return
}

// IsSetDescRequest returns true if DescRequest is not nil.
func (v *DescribeTaskListRequest) IsSetDescRequest() bool {
	return v != nil && v.DescRequest != nil
}

type PollForActivityTaskRequest struct {
	DomainUUID  *string                            `json:"domainUUID,omitempty"`
	PollerID    *string                            `json:"pollerID,omitempty"`
	PollRequest *shared.PollForActivityTaskRequest `json:"pollRequest,omitempty"`
}

// ToWire translates a PollForActivityTaskRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *PollForActivityTaskRequest) ToWire() (wire.Value, error) {
	var (
		fields [3]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.PollerID != nil {
		w, err = wire.NewValueString(*(v.PollerID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 15, Value: w}
		i++
	}
	if v.PollRequest != nil {
		w, err = v.PollRequest.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _PollForActivityTaskRequest_Read(w wire.Value) (*shared.PollForActivityTaskRequest, error) {
	var v shared.PollForActivityTaskRequest
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a PollForActivityTaskRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a PollForActivityTaskRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v PollForActivityTaskRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *PollForActivityTaskRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 15:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.PollerID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.PollRequest, err = _PollForActivityTaskRequest_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a PollForActivityTaskRequest
// struct.
func (v *PollForActivityTaskRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [3]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.PollerID != nil {
		fields[i] = fmt.Sprintf("PollerID: %v", *(v.PollerID))
		i++
	}
	if v.PollRequest != nil {
		fields[i] = fmt.Sprintf("PollRequest: %v", v.PollRequest)
		i++
	}

	return fmt.Sprintf("PollForActivityTaskRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this PollForActivityTaskRequest match the
// provided PollForActivityTaskRequest.
//
// This function performs a deep comparison.
func (v *PollForActivityTaskRequest) Equals(rhs *PollForActivityTaskRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !_String_EqualsPtr(v.PollerID, rhs.PollerID) {
		return false
	}
	if !((v.PollRequest == nil && rhs.PollRequest == nil) || (v.PollRequest != nil && rhs.PollRequest != nil && v.PollRequest.Equals(rhs.PollRequest))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of PollForActivityTaskRequest.
func (v *PollForActivityTaskRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.PollerID != nil {
		enc.AddString("pollerID", *v.PollerID)
	}
	if v.PollRequest != nil {
		err = multierr.Append(err, enc.AddObject("pollRequest", v.PollRequest))
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *PollForActivityTaskRequest) GetDomainUUID() (o string) {
	if v != nil && v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// IsSetDomainUUID returns true if DomainUUID is not nil.
func (v *PollForActivityTaskRequest) IsSetDomainUUID() bool {
	return v != nil && v.DomainUUID != nil
}

// GetPollerID returns the value of PollerID if it is set or its
// zero value if it is unset.
func (v *PollForActivityTaskRequest) GetPollerID() (o string) {
	if v != nil && v.PollerID != nil {
		return *v.PollerID
	}

	return
}

// IsSetPollerID returns true if PollerID is not nil.
func (v *PollForActivityTaskRequest) IsSetPollerID() bool {
	return v != nil && v.PollerID != nil
}

// GetPollRequest returns the value of PollRequest if it is set or its
// zero value if it is unset.
func (v *PollForActivityTaskRequest) GetPollRequest() (o *shared.PollForActivityTaskRequest) {
	if v != nil && v.PollRequest != nil {
		return v.PollRequest
	}

	return
}

// IsSetPollRequest returns true if PollRequest is not nil.
func (v *PollForActivityTaskRequest) IsSetPollRequest() bool {
	return v != nil && v.PollRequest != nil
}

type PollForDecisionTaskRequest struct {
	DomainUUID  *string                            `json:"domainUUID,omitempty"`
	PollerID    *string                            `json:"pollerID,omitempty"`
	PollRequest *shared.PollForDecisionTaskRequest `json:"pollRequest,omitempty"`
}

// ToWire translates a PollForDecisionTaskRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *PollForDecisionTaskRequest) ToWire() (wire.Value, error) {
	var (
		fields [3]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.PollerID != nil {
		w, err = wire.NewValueString(*(v.PollerID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 15, Value: w}
		i++
	}
	if v.PollRequest != nil {
		w, err = v.PollRequest.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _PollForDecisionTaskRequest_Read(w wire.Value) (*shared.PollForDecisionTaskRequest, error) {
	var v shared.PollForDecisionTaskRequest
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a PollForDecisionTaskRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a PollForDecisionTaskRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v PollForDecisionTaskRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *PollForDecisionTaskRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 15:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.PollerID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.PollRequest, err = _PollForDecisionTaskRequest_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a PollForDecisionTaskRequest
// struct.
func (v *PollForDecisionTaskRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [3]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.PollerID != nil {
		fields[i] = fmt.Sprintf("PollerID: %v", *(v.PollerID))
		i++
	}
	if v.PollRequest != nil {
		fields[i] = fmt.Sprintf("PollRequest: %v", v.PollRequest)
		i++
	}

	return fmt.Sprintf("PollForDecisionTaskRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this PollForDecisionTaskRequest match the
// provided PollForDecisionTaskRequest.
//
// This function performs a deep comparison.
func (v *PollForDecisionTaskRequest) Equals(rhs *PollForDecisionTaskRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !_String_EqualsPtr(v.PollerID, rhs.PollerID) {
		return false
	}
	if !((v.PollRequest == nil && rhs.PollRequest == nil) || (v.PollRequest != nil && rhs.PollRequest != nil && v.PollRequest.Equals(rhs.PollRequest))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of PollForDecisionTaskRequest.
func (v *PollForDecisionTaskRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.PollerID != nil {
		enc.AddString("pollerID", *v.PollerID)
	}
	if v.PollRequest != nil {
		err = multierr.Append(err, enc.AddObject("pollRequest", v.PollRequest))
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskRequest) GetDomainUUID() (o string) {
	if v != nil && v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// IsSetDomainUUID returns true if DomainUUID is not nil.
func (v *PollForDecisionTaskRequest) IsSetDomainUUID() bool {
	return v != nil && v.DomainUUID != nil
}

// GetPollerID returns the value of PollerID if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskRequest) GetPollerID() (o string) {
	if v != nil && v.PollerID != nil {
		return *v.PollerID
	}

	return
}

// IsSetPollerID returns true if PollerID is not nil.
func (v *PollForDecisionTaskRequest) IsSetPollerID() bool {
	return v != nil && v.PollerID != nil
}

// GetPollRequest returns the value of PollRequest if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskRequest) GetPollRequest() (o *shared.PollForDecisionTaskRequest) {
	if v != nil && v.PollRequest != nil {
		return v.PollRequest
	}

	return
}

// IsSetPollRequest returns true if PollRequest is not nil.
func (v *PollForDecisionTaskRequest) IsSetPollRequest() bool {
	return v != nil && v.PollRequest != nil
}

type PollForDecisionTaskResponse struct {
	TaskToken                 []byte                        `json:"taskToken,omitempty"`
	WorkflowExecution         *shared.WorkflowExecution     `json:"workflowExecution,omitempty"`
	WorkflowType              *shared.WorkflowType          `json:"workflowType,omitempty"`
	PreviousStartedEventId    *int64                        `json:"previousStartedEventId,omitempty"`
	StartedEventId            *int64                        `json:"startedEventId,omitempty"`
	Attempt                   *int64                        `json:"attempt,omitempty"`
	NextEventId               *int64                        `json:"nextEventId,omitempty"`
	BacklogCountHint          *int64                        `json:"backlogCountHint,omitempty"`
	StickyExecutionEnabled    *bool                         `json:"stickyExecutionEnabled,omitempty"`
	Query                     *shared.WorkflowQuery         `json:"query,omitempty"`
	DecisionInfo              *shared.TransientDecisionInfo `json:"decisionInfo,omitempty"`
	WorkflowExecutionTaskList *shared.TaskList              `json:"WorkflowExecutionTaskList,omitempty"`
	EventStoreVersion         *int32                        `json:"eventStoreVersion,omitempty"`
	BranchToken               []byte                        `json:"branchToken,omitempty"`
}

// ToWire translates a PollForDecisionTaskResponse struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *PollForDecisionTaskResponse) ToWire() (wire.Value, error) {
	var (
		fields [14]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.TaskToken != nil {
		w, err = wire.NewValueBinary(v.TaskToken), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.WorkflowExecution != nil {
		w, err = v.WorkflowExecution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.WorkflowType != nil {
		w, err = v.WorkflowType.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.PreviousStartedEventId != nil {
		w, err = wire.NewValueI64(*(v.PreviousStartedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.StartedEventId != nil {
		w, err = wire.NewValueI64(*(v.StartedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.Attempt != nil {
		w, err = wire.NewValueI64(*(v.Attempt)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 51, Value: w}
		i++
	}
	if v.NextEventId != nil {
		w, err = wire.NewValueI64(*(v.NextEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}
	if v.BacklogCountHint != nil {
		w, err = wire.NewValueI64(*(v.BacklogCountHint)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 65, Value: w}
		i++
	}
	if v.StickyExecutionEnabled != nil {
		w, err = wire.NewValueBool(*(v.StickyExecutionEnabled)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 70, Value: w}
		i++
	}
	if v.Query != nil {
		w, err = v.Query.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 80, Value: w}
		i++
	}
	if v.DecisionInfo != nil {
		w, err = v.DecisionInfo.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 90, Value: w}
		i++
	}
	if v.WorkflowExecutionTaskList != nil {
		w, err = v.WorkflowExecutionTaskList.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 100, Value: w}
		i++
	}
	if v.EventStoreVersion != nil {
		w, err = wire.NewValueI32(*(v.EventStoreVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 110, Value: w}
		i++
	}
	if v.BranchToken != nil {
		w, err = wire.NewValueBinary(v.BranchToken), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 120, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _WorkflowType_Read(w wire.Value) (*shared.WorkflowType, error) {
	var v shared.WorkflowType
	err := v.FromWire(w)
	return &v, err
}

func _WorkflowQuery_Read(w wire.Value) (*shared.WorkflowQuery, error) {
	var v shared.WorkflowQuery
	err := v.FromWire(w)
	return &v, err
}

func _TransientDecisionInfo_Read(w wire.Value) (*shared.TransientDecisionInfo, error) {
	var v shared.TransientDecisionInfo
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a PollForDecisionTaskResponse struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a PollForDecisionTaskResponse struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v PollForDecisionTaskResponse
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *PollForDecisionTaskResponse) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				v.TaskToken, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowType, err = _WorkflowType_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.PreviousStartedEventId = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StartedEventId = &x
				if err != nil {
					return err
				}

			}
		case 51:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.Attempt = &x
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.NextEventId = &x
				if err != nil {
					return err
				}

			}
		case 65:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.BacklogCountHint = &x
				if err != nil {
					return err
				}

			}
		case 70:
			if field.Value.Type() == wire.TBool {
				var x bool
				x, err = field.Value.GetBool(), error(nil)
				v.StickyExecutionEnabled = &x
				if err != nil {
					return err
				}

			}
		case 80:
			if field.Value.Type() == wire.TStruct {
				v.Query, err = _WorkflowQuery_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 90:
			if field.Value.Type() == wire.TStruct {
				v.DecisionInfo, err = _TransientDecisionInfo_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 100:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecutionTaskList, err = _TaskList_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 110:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.EventStoreVersion = &x
				if err != nil {
					return err
				}

			}
		case 120:
			if field.Value.Type() == wire.TBinary {
				v.BranchToken, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a PollForDecisionTaskResponse
// struct.
func (v *PollForDecisionTaskResponse) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [14]string
	i := 0
	if v.TaskToken != nil {
		fields[i] = fmt.Sprintf("TaskToken: %v", v.TaskToken)
		i++
	}
	if v.WorkflowExecution != nil {
		fields[i] = fmt.Sprintf("WorkflowExecution: %v", v.WorkflowExecution)
		i++
	}
	if v.WorkflowType != nil {
		fields[i] = fmt.Sprintf("WorkflowType: %v", v.WorkflowType)
		i++
	}
	if v.PreviousStartedEventId != nil {
		fields[i] = fmt.Sprintf("PreviousStartedEventId: %v", *(v.PreviousStartedEventId))
		i++
	}
	if v.StartedEventId != nil {
		fields[i] = fmt.Sprintf("StartedEventId: %v", *(v.StartedEventId))
		i++
	}
	if v.Attempt != nil {
		fields[i] = fmt.Sprintf("Attempt: %v", *(v.Attempt))
		i++
	}
	if v.NextEventId != nil {
		fields[i] = fmt.Sprintf("NextEventId: %v", *(v.NextEventId))
		i++
	}
	if v.BacklogCountHint != nil {
		fields[i] = fmt.Sprintf("BacklogCountHint: %v", *(v.BacklogCountHint))
		i++
	}
	if v.StickyExecutionEnabled != nil {
		fields[i] = fmt.Sprintf("StickyExecutionEnabled: %v", *(v.StickyExecutionEnabled))
		i++
	}
	if v.Query != nil {
		fields[i] = fmt.Sprintf("Query: %v", v.Query)
		i++
	}
	if v.DecisionInfo != nil {
		fields[i] = fmt.Sprintf("DecisionInfo: %v", v.DecisionInfo)
		i++
	}
	if v.WorkflowExecutionTaskList != nil {
		fields[i] = fmt.Sprintf("WorkflowExecutionTaskList: %v", v.WorkflowExecutionTaskList)
		i++
	}
	if v.EventStoreVersion != nil {
		fields[i] = fmt.Sprintf("EventStoreVersion: %v", *(v.EventStoreVersion))
		i++
	}
	if v.BranchToken != nil {
		fields[i] = fmt.Sprintf("BranchToken: %v", v.BranchToken)
		i++
	}

	return fmt.Sprintf("PollForDecisionTaskResponse{%v}", strings.Join(fields[:i], ", "))
}

func _Bool_EqualsPtr(lhs, rhs *bool) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return (x == y)
	}
	return lhs == nil && rhs == nil
}

// Equals returns true if all the fields of this PollForDecisionTaskResponse match the
// provided PollForDecisionTaskResponse.
//
// This function performs a deep comparison.
func (v *PollForDecisionTaskResponse) Equals(rhs *PollForDecisionTaskResponse) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.TaskToken == nil && rhs.TaskToken == nil) || (v.TaskToken != nil && rhs.TaskToken != nil && bytes.Equal(v.TaskToken, rhs.TaskToken))) {
		return false
	}
	if !((v.WorkflowExecution == nil && rhs.WorkflowExecution == nil) || (v.WorkflowExecution != nil && rhs.WorkflowExecution != nil && v.WorkflowExecution.Equals(rhs.WorkflowExecution))) {
		return false
	}
	if !((v.WorkflowType == nil && rhs.WorkflowType == nil) || (v.WorkflowType != nil && rhs.WorkflowType != nil && v.WorkflowType.Equals(rhs.WorkflowType))) {
		return false
	}
	if !_I64_EqualsPtr(v.PreviousStartedEventId, rhs.PreviousStartedEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.StartedEventId, rhs.StartedEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.Attempt, rhs.Attempt) {
		return false
	}
	if !_I64_EqualsPtr(v.NextEventId, rhs.NextEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.BacklogCountHint, rhs.BacklogCountHint) {
		return false
	}
	if !_Bool_EqualsPtr(v.StickyExecutionEnabled, rhs.StickyExecutionEnabled) {
		return false
	}
	if !((v.Query == nil && rhs.Query == nil) || (v.Query != nil && rhs.Query != nil && v.Query.Equals(rhs.Query))) {
		return false
	}
	if !((v.DecisionInfo == nil && rhs.DecisionInfo == nil) || (v.DecisionInfo != nil && rhs.DecisionInfo != nil && v.DecisionInfo.Equals(rhs.DecisionInfo))) {
		return false
	}
	if !((v.WorkflowExecutionTaskList == nil && rhs.WorkflowExecutionTaskList == nil) || (v.WorkflowExecutionTaskList != nil && rhs.WorkflowExecutionTaskList != nil && v.WorkflowExecutionTaskList.Equals(rhs.WorkflowExecutionTaskList))) {
		return false
	}
	if !_I32_EqualsPtr(v.EventStoreVersion, rhs.EventStoreVersion) {
		return false
	}
	if !((v.BranchToken == nil && rhs.BranchToken == nil) || (v.BranchToken != nil && rhs.BranchToken != nil && bytes.Equal(v.BranchToken, rhs.BranchToken))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of PollForDecisionTaskResponse.
func (v *PollForDecisionTaskResponse) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.TaskToken != nil {
		enc.AddString("taskToken", base64.StdEncoding.EncodeToString(v.TaskToken))
	}
	if v.WorkflowExecution != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecution", v.WorkflowExecution))
	}
	if v.WorkflowType != nil {
		err = multierr.Append(err, enc.AddObject("workflowType", v.WorkflowType))
	}
	if v.PreviousStartedEventId != nil {
		enc.AddInt64("previousStartedEventId", *v.PreviousStartedEventId)
	}
	if v.StartedEventId != nil {
		enc.AddInt64("startedEventId", *v.StartedEventId)
	}
	if v.Attempt != nil {
		enc.AddInt64("attempt", *v.Attempt)
	}
	if v.NextEventId != nil {
		enc.AddInt64("nextEventId", *v.NextEventId)
	}
	if v.BacklogCountHint != nil {
		enc.AddInt64("backlogCountHint", *v.BacklogCountHint)
	}
	if v.StickyExecutionEnabled != nil {
		enc.AddBool("stickyExecutionEnabled", *v.StickyExecutionEnabled)
	}
	if v.Query != nil {
		err = multierr.Append(err, enc.AddObject("query", v.Query))
	}
	if v.DecisionInfo != nil {
		err = multierr.Append(err, enc.AddObject("decisionInfo", v.DecisionInfo))
	}
	if v.WorkflowExecutionTaskList != nil {
		err = multierr.Append(err, enc.AddObject("WorkflowExecutionTaskList", v.WorkflowExecutionTaskList))
	}
	if v.EventStoreVersion != nil {
		enc.AddInt32("eventStoreVersion", *v.EventStoreVersion)
	}
	if v.BranchToken != nil {
		enc.AddString("branchToken", base64.StdEncoding.EncodeToString(v.BranchToken))
	}
	return err
}

// GetTaskToken returns the value of TaskToken if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskResponse) GetTaskToken() (o []byte) {
	if v != nil && v.TaskToken != nil {
		return v.TaskToken
	}

	return
}

// IsSetTaskToken returns true if TaskToken is not nil.
func (v *PollForDecisionTaskResponse) IsSetTaskToken() bool {
	return v != nil && v.TaskToken != nil
}

// GetWorkflowExecution returns the value of WorkflowExecution if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskResponse) GetWorkflowExecution() (o *shared.WorkflowExecution) {
	if v != nil && v.WorkflowExecution != nil {
		return v.WorkflowExecution
	}

	return
}

// IsSetWorkflowExecution returns true if WorkflowExecution is not nil.
func (v *PollForDecisionTaskResponse) IsSetWorkflowExecution() bool {
	return v != nil && v.WorkflowExecution != nil
}

// GetWorkflowType returns the value of WorkflowType if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskResponse) GetWorkflowType() (o *shared.WorkflowType) {
	if v != nil && v.WorkflowType != nil {
		return v.WorkflowType
	}

	return
}

// IsSetWorkflowType returns true if WorkflowType is not nil.
func (v *PollForDecisionTaskResponse) IsSetWorkflowType() bool {
	return v != nil && v.WorkflowType != nil
}

// GetPreviousStartedEventId returns the value of PreviousStartedEventId if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskResponse) GetPreviousStartedEventId() (o int64) {
	if v != nil && v.PreviousStartedEventId != nil {
		return *v.PreviousStartedEventId
	}

	return
}

// IsSetPreviousStartedEventId returns true if PreviousStartedEventId is not nil.
func (v *PollForDecisionTaskResponse) IsSetPreviousStartedEventId() bool {
	return v != nil && v.PreviousStartedEventId != nil
}

// GetStartedEventId returns the value of StartedEventId if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskResponse) GetStartedEventId() (o int64) {
	if v != nil && v.StartedEventId != nil {
		return *v.StartedEventId
	}

	return
}

// IsSetStartedEventId returns true if StartedEventId is not nil.
func (v *PollForDecisionTaskResponse) IsSetStartedEventId() bool {
	return v != nil && v.StartedEventId != nil
}

// GetAttempt returns the value of Attempt if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskResponse) GetAttempt() (o int64) {
	if v != nil && v.Attempt != nil {
		return *v.Attempt
	}

	return
}

// IsSetAttempt returns true if Attempt is not nil.
func (v *PollForDecisionTaskResponse) IsSetAttempt() bool {
	return v != nil && v.Attempt != nil
}

// GetNextEventId returns the value of NextEventId if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskResponse) GetNextEventId() (o int64) {
	if v != nil && v.NextEventId != nil {
		return *v.NextEventId
	}

	return
}

// IsSetNextEventId returns true if NextEventId is not nil.
func (v *PollForDecisionTaskResponse) IsSetNextEventId() bool {
	return v != nil && v.NextEventId != nil
}

// GetBacklogCountHint returns the value of BacklogCountHint if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskResponse) GetBacklogCountHint() (o int64) {
	if v != nil && v.BacklogCountHint != nil {
		return *v.BacklogCountHint
	}

	return
}

// IsSetBacklogCountHint returns true if BacklogCountHint is not nil.
func (v *PollForDecisionTaskResponse) IsSetBacklogCountHint() bool {
	return v != nil && v.BacklogCountHint != nil
}

// GetStickyExecutionEnabled returns the value of StickyExecutionEnabled if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskResponse) GetStickyExecutionEnabled() (o bool) {
	if v != nil && v.StickyExecutionEnabled != nil {
		return *v.StickyExecutionEnabled
	}

	return
}

// IsSetStickyExecutionEnabled returns true if StickyExecutionEnabled is not nil.
func (v *PollForDecisionTaskResponse) IsSetStickyExecutionEnabled() bool {
	return v != nil && v.StickyExecutionEnabled != nil
}

// GetQuery returns the value of Query if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskResponse) GetQuery() (o *shared.WorkflowQuery) {
	if v != nil && v.Query != nil {
		return v.Query
	}

	return
}

// IsSetQuery returns true if Query is not nil.
func (v *PollForDecisionTaskResponse) IsSetQuery() bool {
	return v != nil && v.Query != nil
}

// GetDecisionInfo returns the value of DecisionInfo if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskResponse) GetDecisionInfo() (o *shared.TransientDecisionInfo) {
	if v != nil && v.DecisionInfo != nil {
		return v.DecisionInfo
	}

	return
}

// IsSetDecisionInfo returns true if DecisionInfo is not nil.
func (v *PollForDecisionTaskResponse) IsSetDecisionInfo() bool {
	return v != nil && v.DecisionInfo != nil
}

// GetWorkflowExecutionTaskList returns the value of WorkflowExecutionTaskList if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskResponse) GetWorkflowExecutionTaskList() (o *shared.TaskList) {
	if v != nil && v.WorkflowExecutionTaskList != nil {
		return v.WorkflowExecutionTaskList
	}

	return
}

// IsSetWorkflowExecutionTaskList returns true if WorkflowExecutionTaskList is not nil.
func (v *PollForDecisionTaskResponse) IsSetWorkflowExecutionTaskList() bool {
	return v != nil && v.WorkflowExecutionTaskList != nil
}

// GetEventStoreVersion returns the value of EventStoreVersion if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskResponse) GetEventStoreVersion() (o int32) {
	if v != nil && v.EventStoreVersion != nil {
		return *v.EventStoreVersion
	}

	return
}

// IsSetEventStoreVersion returns true if EventStoreVersion is not nil.
func (v *PollForDecisionTaskResponse) IsSetEventStoreVersion() bool {
	return v != nil && v.EventStoreVersion != nil
}

// GetBranchToken returns the value of BranchToken if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskResponse) GetBranchToken() (o []byte) {
	if v != nil && v.BranchToken != nil {
		return v.BranchToken
	}

	return
}

// IsSetBranchToken returns true if BranchToken is not nil.
func (v *PollForDecisionTaskResponse) IsSetBranchToken() bool {
	return v != nil && v.BranchToken != nil
}

type QueryWorkflowRequest struct {
	DomainUUID   *string                      `json:"domainUUID,omitempty"`
	TaskList     *shared.TaskList             `json:"taskList,omitempty"`
	QueryRequest *shared.QueryWorkflowRequest `json:"queryRequest,omitempty"`
}

// ToWire translates a QueryWorkflowRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *QueryWorkflowRequest) ToWire() (wire.Value, error) {
	var (
		fields [3]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.TaskList != nil {
		w, err = v.TaskList.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.QueryRequest != nil {
		w, err = v.QueryRequest.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _QueryWorkflowRequest_Read(w wire.Value) (*shared.QueryWorkflowRequest, error) {
	var v shared.QueryWorkflowRequest
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a QueryWorkflowRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a QueryWorkflowRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v QueryWorkflowRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *QueryWorkflowRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.TaskList, err = _TaskList_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TStruct {
				v.QueryRequest, err = _QueryWorkflowRequest_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a QueryWorkflowRequest
// struct.
func (v *QueryWorkflowRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [3]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.TaskList != nil {
		fields[i] = fmt.Sprintf("TaskList: %v", v.TaskList)
		i++
	}
	if v.QueryRequest != nil {
		fields[i] = fmt.Sprintf("QueryRequest: %v", v.QueryRequest)
		i++
	}

	return fmt.Sprintf("QueryWorkflowRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this QueryWorkflowRequest match the
// provided QueryWorkflowRequest.
//
// This function performs a deep comparison.
func (v *QueryWorkflowRequest) Equals(rhs *QueryWorkflowRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.TaskList == nil && rhs.TaskList == nil) || (v.TaskList != nil && rhs.TaskList != nil && v.TaskList.Equals(rhs.TaskList))) {
		return false
	}
	if !((v.QueryRequest == nil && rhs.QueryRequest == nil) || (v.QueryRequest != nil && rhs.QueryRequest != nil && v.QueryRequest.Equals(rhs.QueryRequest))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of QueryWorkflowRequest.
func (v *QueryWorkflowRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.TaskList != nil {
		err = multierr.Append(err, enc.AddObject("taskList", v.TaskList))
	}
	if v.QueryRequest != nil {
		err = multierr.Append(err, enc.AddObject("queryRequest", v.QueryRequest))
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *QueryWorkflowRequest) GetDomainUUID() (o string) {
	if v != nil && v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// IsSetDomainUUID returns true if DomainUUID is not nil.
func (v *QueryWorkflowRequest) IsSetDomainUUID() bool {
	return v != nil && v.DomainUUID != nil
}

// GetTaskList returns the value of TaskList if it is set or its
// zero value if it is unset.
func (v *QueryWorkflowRequest) GetTaskList() (o *shared.TaskList) {
	if v != nil && v.TaskList != nil {
		return v.TaskList
	}

	return
}

// IsSetTaskList returns true if TaskList is not nil.
func (v *QueryWorkflowRequest) IsSetTaskList() bool {
	return v != nil && v.TaskList != nil
}

// GetQueryRequest returns the value of QueryRequest if it is set or its
// zero value if it is unset.
func (v *QueryWorkflowRequest) GetQueryRequest() (o *shared.QueryWorkflowRequest) {
	if v != nil && v.QueryRequest != nil {
		return v.QueryRequest
	}

	return
}

// IsSetQueryRequest returns true if QueryRequest is not nil.
func (v *QueryWorkflowRequest) IsSetQueryRequest() bool {
	return v != nil && v.QueryRequest != nil
}

type RespondQueryTaskCompletedRequest struct {
	DomainUUID       *string                                  `json:"domainUUID,omitempty"`
	TaskList         *shared.TaskList                         `json:"taskList,omitempty"`
	TaskID           *string                                  `json:"taskID,omitempty"`
	CompletedRequest *shared.RespondQueryTaskCompletedRequest `json:"completedRequest,omitempty"`
}

// ToWire translates a RespondQueryTaskCompletedRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RespondQueryTaskCompletedRequest) ToWire() (wire.Value, error) {
	var (
		fields [4]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainUUID != nil {
		w, err = wire.NewValueString(*(v.DomainUUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.TaskList != nil {
		w, err = v.TaskList.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.TaskID != nil {
		w, err = wire.NewValueString(*(v.TaskID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.CompletedRequest != nil {
		w, err = v.CompletedRequest.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _RespondQueryTaskCompletedRequest_Read(w wire.Value) (*shared.RespondQueryTaskCompletedRequest, error) {
	var v shared.RespondQueryTaskCompletedRequest
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a RespondQueryTaskCompletedRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RespondQueryTaskCompletedRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RespondQueryTaskCompletedRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RespondQueryTaskCompletedRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainUUID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.TaskList, err = _TaskList_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.TaskID = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TStruct {
				v.CompletedRequest, err = _RespondQueryTaskCompletedRequest_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RespondQueryTaskCompletedRequest
// struct.
func (v *RespondQueryTaskCompletedRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [4]string
	i := 0
	if v.DomainUUID != nil {
		fields[i] = fmt.Sprintf("DomainUUID: %v", *(v.DomainUUID))
		i++
	}
	if v.TaskList != nil {
		fields[i] = fmt.Sprintf("TaskList: %v", v.TaskList)
		i++
	}
	if v.TaskID != nil {
		fields[i] = fmt.Sprintf("TaskID: %v", *(v.TaskID))
		i++
	}
	if v.CompletedRequest != nil {
		fields[i] = fmt.Sprintf("CompletedRequest: %v", v.CompletedRequest)
		i++
	}

	return fmt.Sprintf("RespondQueryTaskCompletedRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RespondQueryTaskCompletedRequest match the
// provided RespondQueryTaskCompletedRequest.
//
// This function performs a deep comparison.
func (v *RespondQueryTaskCompletedRequest) Equals(rhs *RespondQueryTaskCompletedRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainUUID, rhs.DomainUUID) {
		return false
	}
	if !((v.TaskList == nil && rhs.TaskList == nil) || (v.TaskList != nil && rhs.TaskList != nil && v.TaskList.Equals(rhs.TaskList))) {
		return false
	}
	if !_String_EqualsPtr(v.TaskID, rhs.TaskID) {
		return false
	}
	if !((v.CompletedRequest == nil && rhs.CompletedRequest == nil) || (v.CompletedRequest != nil && rhs.CompletedRequest != nil && v.CompletedRequest.Equals(rhs.CompletedRequest))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RespondQueryTaskCompletedRequest.
func (v *RespondQueryTaskCompletedRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainUUID != nil {
		enc.AddString("domainUUID", *v.DomainUUID)
	}
	if v.TaskList != nil {
		err = multierr.Append(err, enc.AddObject("taskList", v.TaskList))
	}
	if v.TaskID != nil {
		enc.AddString("taskID", *v.TaskID)
	}
	if v.CompletedRequest != nil {
		err = multierr.Append(err, enc.AddObject("completedRequest", v.CompletedRequest))
	}
	return err
}

// GetDomainUUID returns the value of DomainUUID if it is set or its
// zero value if it is unset.
func (v *RespondQueryTaskCompletedRequest) GetDomainUUID() (o string) {
	if v != nil && v.DomainUUID != nil {
		return *v.DomainUUID
	}

	return
}

// IsSetDomainUUID returns true if DomainUUID is not nil.
func (v *RespondQueryTaskCompletedRequest) IsSetDomainUUID() bool {
	return v != nil && v.DomainUUID != nil
}

// GetTaskList returns the value of TaskList if it is set or its
// zero value if it is unset.
func (v *RespondQueryTaskCompletedRequest) GetTaskList() (o *shared.TaskList) {
	if v != nil && v.TaskList != nil {
		return v.TaskList
	}

	return
}

// IsSetTaskList returns true if TaskList is not nil.
func (v *RespondQueryTaskCompletedRequest) IsSetTaskList() bool {
	return v != nil && v.TaskList != nil
}

// GetTaskID returns the value of TaskID if it is set or its
// zero value if it is unset.
func (v *RespondQueryTaskCompletedRequest) GetTaskID() (o string) {
	if v != nil && v.TaskID != nil {
		return *v.TaskID
	}

	return
}

// IsSetTaskID returns true if TaskID is not nil.
func (v *RespondQueryTaskCompletedRequest) IsSetTaskID() bool {
	return v != nil && v.TaskID != nil
}

// GetCompletedRequest returns the value of CompletedRequest if it is set or its
// zero value if it is unset.
func (v *RespondQueryTaskCompletedRequest) GetCompletedRequest() (o *shared.RespondQueryTaskCompletedRequest) {
	if v != nil && v.CompletedRequest != nil {
		return v.CompletedRequest
	}

	return
}

// IsSetCompletedRequest returns true if CompletedRequest is not nil.
func (v *RespondQueryTaskCompletedRequest) IsSetCompletedRequest() bool {
	return v != nil && v.CompletedRequest != nil
}
