// Copyright (c) 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by thriftrw v1.18.0. DO NOT EDIT.
// @generated

package replicator

import (
	bytes "bytes"
	base64 "encoding/base64"
	json "encoding/json"
	fmt "fmt"
	shared "github.com/uber/cadence/.gen/go/shared"
	multierr "go.uber.org/multierr"
	wire "go.uber.org/thriftrw/wire"
	zapcore "go.uber.org/zap/zapcore"
	math "math"
	strconv "strconv"
	strings "strings"
)

type DomainOperation int32

const (
	DomainOperationCreate DomainOperation = 0
	DomainOperationUpdate DomainOperation = 1
)

// DomainOperation_Values returns all recognized values of DomainOperation.
func DomainOperation_Values() []DomainOperation {
	return []DomainOperation{
		DomainOperationCreate,
		DomainOperationUpdate,
	}
}

// UnmarshalText tries to decode DomainOperation from a byte slice
// containing its name.
//
//   var v DomainOperation
//   err := v.UnmarshalText([]byte("Create"))
func (v *DomainOperation) UnmarshalText(value []byte) error {
	switch s := string(value); s {
	case "Create":
		*v = DomainOperationCreate
		return nil
	case "Update":
		*v = DomainOperationUpdate
		return nil
	default:
		val, err := strconv.ParseInt(s, 10, 32)
		if err != nil {
			return fmt.Errorf("unknown enum value %q for %q: %v", s, "DomainOperation", err)
		}
		*v = DomainOperation(val)
		return nil
	}
}

// MarshalText encodes DomainOperation to text.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements the TextMarshaler interface.
func (v DomainOperation) MarshalText() ([]byte, error) {
	switch int32(v) {
	case 0:
		return []byte("Create"), nil
	case 1:
		return []byte("Update"), nil
	}
	return []byte(strconv.FormatInt(int64(v), 10)), nil
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DomainOperation.
// Enums are logged as objects, where the value is logged with key "value", and
// if this value's name is known, the name is logged with key "name".
func (v DomainOperation) MarshalLogObject(enc zapcore.ObjectEncoder) error {
	enc.AddInt32("value", int32(v))
	switch int32(v) {
	case 0:
		enc.AddString("name", "Create")
	case 1:
		enc.AddString("name", "Update")
	}
	return nil
}

// Ptr returns a pointer to this enum value.
func (v DomainOperation) Ptr() *DomainOperation {
	return &v
}

// ToWire translates DomainOperation into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// Enums are represented as 32-bit integers over the wire.
func (v DomainOperation) ToWire() (wire.Value, error) {
	return wire.NewValueI32(int32(v)), nil
}

// FromWire deserializes DomainOperation from its Thrift-level
// representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TI32)
//   if err != nil {
//     return DomainOperation(0), err
//   }
//
//   var v DomainOperation
//   if err := v.FromWire(x); err != nil {
//     return DomainOperation(0), err
//   }
//   return v, nil
func (v *DomainOperation) FromWire(w wire.Value) error {
	*v = (DomainOperation)(w.GetI32())
	return nil
}

// String returns a readable string representation of DomainOperation.
func (v DomainOperation) String() string {
	w := int32(v)
	switch w {
	case 0:
		return "Create"
	case 1:
		return "Update"
	}
	return fmt.Sprintf("DomainOperation(%d)", w)
}

// Equals returns true if this DomainOperation value matches the provided
// value.
func (v DomainOperation) Equals(rhs DomainOperation) bool {
	return v == rhs
}

// MarshalJSON serializes DomainOperation into JSON.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements json.Marshaler.
func (v DomainOperation) MarshalJSON() ([]byte, error) {
	switch int32(v) {
	case 0:
		return ([]byte)("\"Create\""), nil
	case 1:
		return ([]byte)("\"Update\""), nil
	}
	return ([]byte)(strconv.FormatInt(int64(v), 10)), nil
}

// UnmarshalJSON attempts to decode DomainOperation from its JSON
// representation.
//
// This implementation supports both, numeric and string inputs. If a
// string is provided, it must be a known enum name.
//
// This implements json.Unmarshaler.
func (v *DomainOperation) UnmarshalJSON(text []byte) error {
	d := json.NewDecoder(bytes.NewReader(text))
	d.UseNumber()
	t, err := d.Token()
	if err != nil {
		return err
	}

	switch w := t.(type) {
	case json.Number:
		x, err := w.Int64()
		if err != nil {
			return err
		}
		if x > math.MaxInt32 {
			return fmt.Errorf("enum overflow from JSON %q for %q", text, "DomainOperation")
		}
		if x < math.MinInt32 {
			return fmt.Errorf("enum underflow from JSON %q for %q", text, "DomainOperation")
		}
		*v = (DomainOperation)(x)
		return nil
	case string:
		return v.UnmarshalText([]byte(w))
	default:
		return fmt.Errorf("invalid JSON value %q (%T) to unmarshal into %q", t, t, "DomainOperation")
	}
}

type DomainTaskAttributes struct {
	DomainOperation   *DomainOperation                       `json:"domainOperation,omitempty"`
	ID                *string                                `json:"id,omitempty"`
	Info              *shared.DomainInfo                     `json:"info,omitempty"`
	Config            *shared.DomainConfiguration            `json:"config,omitempty"`
	ReplicationConfig *shared.DomainReplicationConfiguration `json:"replicationConfig,omitempty"`
	ConfigVersion     *int64                                 `json:"configVersion,omitempty"`
	FailoverVersion   *int64                                 `json:"failoverVersion,omitempty"`
}

// ToWire translates a DomainTaskAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *DomainTaskAttributes) ToWire() (wire.Value, error) {
	var (
		fields [7]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainOperation != nil {
		w, err = v.DomainOperation.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 5, Value: w}
		i++
	}
	if v.ID != nil {
		w, err = wire.NewValueString(*(v.ID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Info != nil {
		w, err = v.Info.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.Config != nil {
		w, err = v.Config.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.ReplicationConfig != nil {
		w, err = v.ReplicationConfig.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.ConfigVersion != nil {
		w, err = wire.NewValueI64(*(v.ConfigVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.FailoverVersion != nil {
		w, err = wire.NewValueI64(*(v.FailoverVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _DomainOperation_Read(w wire.Value) (DomainOperation, error) {
	var v DomainOperation
	err := v.FromWire(w)
	return v, err
}

func _DomainInfo_Read(w wire.Value) (*shared.DomainInfo, error) {
	var v shared.DomainInfo
	err := v.FromWire(w)
	return &v, err
}

func _DomainConfiguration_Read(w wire.Value) (*shared.DomainConfiguration, error) {
	var v shared.DomainConfiguration
	err := v.FromWire(w)
	return &v, err
}

func _DomainReplicationConfiguration_Read(w wire.Value) (*shared.DomainReplicationConfiguration, error) {
	var v shared.DomainReplicationConfiguration
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a DomainTaskAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a DomainTaskAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v DomainTaskAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *DomainTaskAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 5:
			if field.Value.Type() == wire.TI32 {
				var x DomainOperation
				x, err = _DomainOperation_Read(field.Value)
				v.DomainOperation = &x
				if err != nil {
					return err
				}

			}
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.Info, err = _DomainInfo_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TStruct {
				v.Config, err = _DomainConfiguration_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TStruct {
				v.ReplicationConfig, err = _DomainReplicationConfiguration_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ConfigVersion = &x
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.FailoverVersion = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a DomainTaskAttributes
// struct.
func (v *DomainTaskAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [7]string
	i := 0
	if v.DomainOperation != nil {
		fields[i] = fmt.Sprintf("DomainOperation: %v", *(v.DomainOperation))
		i++
	}
	if v.ID != nil {
		fields[i] = fmt.Sprintf("ID: %v", *(v.ID))
		i++
	}
	if v.Info != nil {
		fields[i] = fmt.Sprintf("Info: %v", v.Info)
		i++
	}
	if v.Config != nil {
		fields[i] = fmt.Sprintf("Config: %v", v.Config)
		i++
	}
	if v.ReplicationConfig != nil {
		fields[i] = fmt.Sprintf("ReplicationConfig: %v", v.ReplicationConfig)
		i++
	}
	if v.ConfigVersion != nil {
		fields[i] = fmt.Sprintf("ConfigVersion: %v", *(v.ConfigVersion))
		i++
	}
	if v.FailoverVersion != nil {
		fields[i] = fmt.Sprintf("FailoverVersion: %v", *(v.FailoverVersion))
		i++
	}

	return fmt.Sprintf("DomainTaskAttributes{%v}", strings.Join(fields[:i], ", "))
}

func _DomainOperation_EqualsPtr(lhs, rhs *DomainOperation) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return x.Equals(y)
	}
	return lhs == nil && rhs == nil
}

func _String_EqualsPtr(lhs, rhs *string) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return (x == y)
	}
	return lhs == nil && rhs == nil
}

func _I64_EqualsPtr(lhs, rhs *int64) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return (x == y)
	}
	return lhs == nil && rhs == nil
}

// Equals returns true if all the fields of this DomainTaskAttributes match the
// provided DomainTaskAttributes.
//
// This function performs a deep comparison.
func (v *DomainTaskAttributes) Equals(rhs *DomainTaskAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_DomainOperation_EqualsPtr(v.DomainOperation, rhs.DomainOperation) {
		return false
	}
	if !_String_EqualsPtr(v.ID, rhs.ID) {
		return false
	}
	if !((v.Info == nil && rhs.Info == nil) || (v.Info != nil && rhs.Info != nil && v.Info.Equals(rhs.Info))) {
		return false
	}
	if !((v.Config == nil && rhs.Config == nil) || (v.Config != nil && rhs.Config != nil && v.Config.Equals(rhs.Config))) {
		return false
	}
	if !((v.ReplicationConfig == nil && rhs.ReplicationConfig == nil) || (v.ReplicationConfig != nil && rhs.ReplicationConfig != nil && v.ReplicationConfig.Equals(rhs.ReplicationConfig))) {
		return false
	}
	if !_I64_EqualsPtr(v.ConfigVersion, rhs.ConfigVersion) {
		return false
	}
	if !_I64_EqualsPtr(v.FailoverVersion, rhs.FailoverVersion) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DomainTaskAttributes.
func (v *DomainTaskAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainOperation != nil {
		err = multierr.Append(err, enc.AddObject("domainOperation", *v.DomainOperation))
	}
	if v.ID != nil {
		enc.AddString("id", *v.ID)
	}
	if v.Info != nil {
		err = multierr.Append(err, enc.AddObject("info", v.Info))
	}
	if v.Config != nil {
		err = multierr.Append(err, enc.AddObject("config", v.Config))
	}
	if v.ReplicationConfig != nil {
		err = multierr.Append(err, enc.AddObject("replicationConfig", v.ReplicationConfig))
	}
	if v.ConfigVersion != nil {
		enc.AddInt64("configVersion", *v.ConfigVersion)
	}
	if v.FailoverVersion != nil {
		enc.AddInt64("failoverVersion", *v.FailoverVersion)
	}
	return err
}

// GetDomainOperation returns the value of DomainOperation if it is set or its
// zero value if it is unset.
func (v *DomainTaskAttributes) GetDomainOperation() (o DomainOperation) {
	if v != nil && v.DomainOperation != nil {
		return *v.DomainOperation
	}

	return
}

// IsSetDomainOperation returns true if DomainOperation is not nil.
func (v *DomainTaskAttributes) IsSetDomainOperation() bool {
	return v != nil && v.DomainOperation != nil
}

// GetID returns the value of ID if it is set or its
// zero value if it is unset.
func (v *DomainTaskAttributes) GetID() (o string) {
	if v != nil && v.ID != nil {
		return *v.ID
	}

	return
}

// IsSetID returns true if ID is not nil.
func (v *DomainTaskAttributes) IsSetID() bool {
	return v != nil && v.ID != nil
}

// GetInfo returns the value of Info if it is set or its
// zero value if it is unset.
func (v *DomainTaskAttributes) GetInfo() (o *shared.DomainInfo) {
	if v != nil && v.Info != nil {
		return v.Info
	}

	return
}

// IsSetInfo returns true if Info is not nil.
func (v *DomainTaskAttributes) IsSetInfo() bool {
	return v != nil && v.Info != nil
}

// GetConfig returns the value of Config if it is set or its
// zero value if it is unset.
func (v *DomainTaskAttributes) GetConfig() (o *shared.DomainConfiguration) {
	if v != nil && v.Config != nil {
		return v.Config
	}

	return
}

// IsSetConfig returns true if Config is not nil.
func (v *DomainTaskAttributes) IsSetConfig() bool {
	return v != nil && v.Config != nil
}

// GetReplicationConfig returns the value of ReplicationConfig if it is set or its
// zero value if it is unset.
func (v *DomainTaskAttributes) GetReplicationConfig() (o *shared.DomainReplicationConfiguration) {
	if v != nil && v.ReplicationConfig != nil {
		return v.ReplicationConfig
	}

	return
}

// IsSetReplicationConfig returns true if ReplicationConfig is not nil.
func (v *DomainTaskAttributes) IsSetReplicationConfig() bool {
	return v != nil && v.ReplicationConfig != nil
}

// GetConfigVersion returns the value of ConfigVersion if it is set or its
// zero value if it is unset.
func (v *DomainTaskAttributes) GetConfigVersion() (o int64) {
	if v != nil && v.ConfigVersion != nil {
		return *v.ConfigVersion
	}

	return
}

// IsSetConfigVersion returns true if ConfigVersion is not nil.
func (v *DomainTaskAttributes) IsSetConfigVersion() bool {
	return v != nil && v.ConfigVersion != nil
}

// GetFailoverVersion returns the value of FailoverVersion if it is set or its
// zero value if it is unset.
func (v *DomainTaskAttributes) GetFailoverVersion() (o int64) {
	if v != nil && v.FailoverVersion != nil {
		return *v.FailoverVersion
	}

	return
}

// IsSetFailoverVersion returns true if FailoverVersion is not nil.
func (v *DomainTaskAttributes) IsSetFailoverVersion() bool {
	return v != nil && v.FailoverVersion != nil
}

type HistoryMetadataTaskAttributes struct {
	TargetClusters []string `json:"targetClusters,omitempty"`
	DomainId       *string  `json:"domainId,omitempty"`
	WorkflowId     *string  `json:"workflowId,omitempty"`
	RunId          *string  `json:"runId,omitempty"`
	FirstEventId   *int64   `json:"firstEventId,omitempty"`
	NextEventId    *int64   `json:"nextEventId,omitempty"`
}

type _List_String_ValueList []string

func (v _List_String_ValueList) ForEach(f func(wire.Value) error) error {
	for _, x := range v {
		w, err := wire.NewValueString(x), error(nil)
		if err != nil {
			return err
		}
		err = f(w)
		if err != nil {
			return err
		}
	}
	return nil
}

func (v _List_String_ValueList) Size() int {
	return len(v)
}

func (_List_String_ValueList) ValueType() wire.Type {
	return wire.TBinary
}

func (_List_String_ValueList) Close() {}

// ToWire translates a HistoryMetadataTaskAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *HistoryMetadataTaskAttributes) ToWire() (wire.Value, error) {
	var (
		fields [6]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.TargetClusters != nil {
		w, err = wire.NewValueList(_List_String_ValueList(v.TargetClusters)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 5, Value: w}
		i++
	}
	if v.DomainId != nil {
		w, err = wire.NewValueString(*(v.DomainId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.WorkflowId != nil {
		w, err = wire.NewValueString(*(v.WorkflowId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.RunId != nil {
		w, err = wire.NewValueString(*(v.RunId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.FirstEventId != nil {
		w, err = wire.NewValueI64(*(v.FirstEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.NextEventId != nil {
		w, err = wire.NewValueI64(*(v.NextEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _List_String_Read(l wire.ValueList) ([]string, error) {
	if l.ValueType() != wire.TBinary {
		return nil, nil
	}

	o := make([]string, 0, l.Size())
	err := l.ForEach(func(x wire.Value) error {
		i, err := x.GetString(), error(nil)
		if err != nil {
			return err
		}
		o = append(o, i)
		return nil
	})
	l.Close()
	return o, err
}

// FromWire deserializes a HistoryMetadataTaskAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a HistoryMetadataTaskAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v HistoryMetadataTaskAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *HistoryMetadataTaskAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 5:
			if field.Value.Type() == wire.TList {
				v.TargetClusters, err = _List_String_Read(field.Value.GetList())
				if err != nil {
					return err
				}

			}
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainId = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.WorkflowId = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.RunId = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.FirstEventId = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.NextEventId = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a HistoryMetadataTaskAttributes
// struct.
func (v *HistoryMetadataTaskAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [6]string
	i := 0
	if v.TargetClusters != nil {
		fields[i] = fmt.Sprintf("TargetClusters: %v", v.TargetClusters)
		i++
	}
	if v.DomainId != nil {
		fields[i] = fmt.Sprintf("DomainId: %v", *(v.DomainId))
		i++
	}
	if v.WorkflowId != nil {
		fields[i] = fmt.Sprintf("WorkflowId: %v", *(v.WorkflowId))
		i++
	}
	if v.RunId != nil {
		fields[i] = fmt.Sprintf("RunId: %v", *(v.RunId))
		i++
	}
	if v.FirstEventId != nil {
		fields[i] = fmt.Sprintf("FirstEventId: %v", *(v.FirstEventId))
		i++
	}
	if v.NextEventId != nil {
		fields[i] = fmt.Sprintf("NextEventId: %v", *(v.NextEventId))
		i++
	}

	return fmt.Sprintf("HistoryMetadataTaskAttributes{%v}", strings.Join(fields[:i], ", "))
}

func _List_String_Equals(lhs, rhs []string) bool {
	if len(lhs) != len(rhs) {
		return false
	}

	for i, lv := range lhs {
		rv := rhs[i]
		if !(lv == rv) {
			return false
		}
	}

	return true
}

// Equals returns true if all the fields of this HistoryMetadataTaskAttributes match the
// provided HistoryMetadataTaskAttributes.
//
// This function performs a deep comparison.
func (v *HistoryMetadataTaskAttributes) Equals(rhs *HistoryMetadataTaskAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.TargetClusters == nil && rhs.TargetClusters == nil) || (v.TargetClusters != nil && rhs.TargetClusters != nil && _List_String_Equals(v.TargetClusters, rhs.TargetClusters))) {
		return false
	}
	if !_String_EqualsPtr(v.DomainId, rhs.DomainId) {
		return false
	}
	if !_String_EqualsPtr(v.WorkflowId, rhs.WorkflowId) {
		return false
	}
	if !_String_EqualsPtr(v.RunId, rhs.RunId) {
		return false
	}
	if !_I64_EqualsPtr(v.FirstEventId, rhs.FirstEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.NextEventId, rhs.NextEventId) {
		return false
	}

	return true
}

type _List_String_Zapper []string

// MarshalLogArray implements zapcore.ArrayMarshaler, enabling
// fast logging of _List_String_Zapper.
func (l _List_String_Zapper) MarshalLogArray(enc zapcore.ArrayEncoder) (err error) {
	for _, v := range l {
		enc.AppendString(v)
	}
	return err
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of HistoryMetadataTaskAttributes.
func (v *HistoryMetadataTaskAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.TargetClusters != nil {
		err = multierr.Append(err, enc.AddArray("targetClusters", (_List_String_Zapper)(v.TargetClusters)))
	}
	if v.DomainId != nil {
		enc.AddString("domainId", *v.DomainId)
	}
	if v.WorkflowId != nil {
		enc.AddString("workflowId", *v.WorkflowId)
	}
	if v.RunId != nil {
		enc.AddString("runId", *v.RunId)
	}
	if v.FirstEventId != nil {
		enc.AddInt64("firstEventId", *v.FirstEventId)
	}
	if v.NextEventId != nil {
		enc.AddInt64("nextEventId", *v.NextEventId)
	}
	return err
}

// GetTargetClusters returns the value of TargetClusters if it is set or its
// zero value if it is unset.
func (v *HistoryMetadataTaskAttributes) GetTargetClusters() (o []string) {
	if v != nil && v.TargetClusters != nil {
		return v.TargetClusters
	}

	return
}

// IsSetTargetClusters returns true if TargetClusters is not nil.
func (v *HistoryMetadataTaskAttributes) IsSetTargetClusters() bool {
	return v != nil && v.TargetClusters != nil
}

// GetDomainId returns the value of DomainId if it is set or its
// zero value if it is unset.
func (v *HistoryMetadataTaskAttributes) GetDomainId() (o string) {
	if v != nil && v.DomainId != nil {
		return *v.DomainId
	}

	return
}

// IsSetDomainId returns true if DomainId is not nil.
func (v *HistoryMetadataTaskAttributes) IsSetDomainId() bool {
	return v != nil && v.DomainId != nil
}

// GetWorkflowId returns the value of WorkflowId if it is set or its
// zero value if it is unset.
func (v *HistoryMetadataTaskAttributes) GetWorkflowId() (o string) {
	if v != nil && v.WorkflowId != nil {
		return *v.WorkflowId
	}

	return
}

// IsSetWorkflowId returns true if WorkflowId is not nil.
func (v *HistoryMetadataTaskAttributes) IsSetWorkflowId() bool {
	return v != nil && v.WorkflowId != nil
}

// GetRunId returns the value of RunId if it is set or its
// zero value if it is unset.
func (v *HistoryMetadataTaskAttributes) GetRunId() (o string) {
	if v != nil && v.RunId != nil {
		return *v.RunId
	}

	return
}

// IsSetRunId returns true if RunId is not nil.
func (v *HistoryMetadataTaskAttributes) IsSetRunId() bool {
	return v != nil && v.RunId != nil
}

// GetFirstEventId returns the value of FirstEventId if it is set or its
// zero value if it is unset.
func (v *HistoryMetadataTaskAttributes) GetFirstEventId() (o int64) {
	if v != nil && v.FirstEventId != nil {
		return *v.FirstEventId
	}

	return
}

// IsSetFirstEventId returns true if FirstEventId is not nil.
func (v *HistoryMetadataTaskAttributes) IsSetFirstEventId() bool {
	return v != nil && v.FirstEventId != nil
}

// GetNextEventId returns the value of NextEventId if it is set or its
// zero value if it is unset.
func (v *HistoryMetadataTaskAttributes) GetNextEventId() (o int64) {
	if v != nil && v.NextEventId != nil {
		return *v.NextEventId
	}

	return
}

// IsSetNextEventId returns true if NextEventId is not nil.
func (v *HistoryMetadataTaskAttributes) IsSetNextEventId() bool {
	return v != nil && v.NextEventId != nil
}

type HistoryTaskAttributes struct {
	TargetClusters          []string                           `json:"targetClusters,omitempty"`
	DomainId                *string                            `json:"domainId,omitempty"`
	WorkflowId              *string                            `json:"workflowId,omitempty"`
	RunId                   *string                            `json:"runId,omitempty"`
	FirstEventId            *int64                             `json:"firstEventId,omitempty"`
	NextEventId             *int64                             `json:"nextEventId,omitempty"`
	Version                 *int64                             `json:"version,omitempty"`
	ReplicationInfo         map[string]*shared.ReplicationInfo `json:"replicationInfo,omitempty"`
	History                 *shared.History                    `json:"history,omitempty"`
	NewRunHistory           *shared.History                    `json:"newRunHistory,omitempty"`
	EventStoreVersion       *int32                             `json:"eventStoreVersion,omitempty"`
	NewRunEventStoreVersion *int32                             `json:"newRunEventStoreVersion,omitempty"`
	ResetWorkflow           *bool                              `json:"resetWorkflow,omitempty"`
}

type _Map_String_ReplicationInfo_MapItemList map[string]*shared.ReplicationInfo

func (m _Map_String_ReplicationInfo_MapItemList) ForEach(f func(wire.MapItem) error) error {
	for k, v := range m {
		if v == nil {
			return fmt.Errorf("invalid [%v]: value is nil", k)
		}
		kw, err := wire.NewValueString(k), error(nil)
		if err != nil {
			return err
		}

		vw, err := v.ToWire()
		if err != nil {
			return err
		}
		err = f(wire.MapItem{Key: kw, Value: vw})
		if err != nil {
			return err
		}
	}
	return nil
}

func (m _Map_String_ReplicationInfo_MapItemList) Size() int {
	return len(m)
}

func (_Map_String_ReplicationInfo_MapItemList) KeyType() wire.Type {
	return wire.TBinary
}

func (_Map_String_ReplicationInfo_MapItemList) ValueType() wire.Type {
	return wire.TStruct
}

func (_Map_String_ReplicationInfo_MapItemList) Close() {}

// ToWire translates a HistoryTaskAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *HistoryTaskAttributes) ToWire() (wire.Value, error) {
	var (
		fields [13]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.TargetClusters != nil {
		w, err = wire.NewValueList(_List_String_ValueList(v.TargetClusters)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 5, Value: w}
		i++
	}
	if v.DomainId != nil {
		w, err = wire.NewValueString(*(v.DomainId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.WorkflowId != nil {
		w, err = wire.NewValueString(*(v.WorkflowId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.RunId != nil {
		w, err = wire.NewValueString(*(v.RunId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.FirstEventId != nil {
		w, err = wire.NewValueI64(*(v.FirstEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.NextEventId != nil {
		w, err = wire.NewValueI64(*(v.NextEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.Version != nil {
		w, err = wire.NewValueI64(*(v.Version)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}
	if v.ReplicationInfo != nil {
		w, err = wire.NewValueMap(_Map_String_ReplicationInfo_MapItemList(v.ReplicationInfo)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 70, Value: w}
		i++
	}
	if v.History != nil {
		w, err = v.History.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 80, Value: w}
		i++
	}
	if v.NewRunHistory != nil {
		w, err = v.NewRunHistory.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 90, Value: w}
		i++
	}
	if v.EventStoreVersion != nil {
		w, err = wire.NewValueI32(*(v.EventStoreVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 100, Value: w}
		i++
	}
	if v.NewRunEventStoreVersion != nil {
		w, err = wire.NewValueI32(*(v.NewRunEventStoreVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 110, Value: w}
		i++
	}
	if v.ResetWorkflow != nil {
		w, err = wire.NewValueBool(*(v.ResetWorkflow)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 120, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _ReplicationInfo_Read(w wire.Value) (*shared.ReplicationInfo, error) {
	var v shared.ReplicationInfo
	err := v.FromWire(w)
	return &v, err
}

func _Map_String_ReplicationInfo_Read(m wire.MapItemList) (map[string]*shared.ReplicationInfo, error) {
	if m.KeyType() != wire.TBinary {
		return nil, nil
	}

	if m.ValueType() != wire.TStruct {
		return nil, nil
	}

	o := make(map[string]*shared.ReplicationInfo, m.Size())
	err := m.ForEach(func(x wire.MapItem) error {
		k, err := x.Key.GetString(), error(nil)
		if err != nil {
			return err
		}

		v, err := _ReplicationInfo_Read(x.Value)
		if err != nil {
			return err
		}

		o[k] = v
		return nil
	})
	m.Close()
	return o, err
}

func _History_Read(w wire.Value) (*shared.History, error) {
	var v shared.History
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a HistoryTaskAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a HistoryTaskAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v HistoryTaskAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *HistoryTaskAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 5:
			if field.Value.Type() == wire.TList {
				v.TargetClusters, err = _List_String_Read(field.Value.GetList())
				if err != nil {
					return err
				}

			}
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainId = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.WorkflowId = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.RunId = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.FirstEventId = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.NextEventId = &x
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.Version = &x
				if err != nil {
					return err
				}

			}
		case 70:
			if field.Value.Type() == wire.TMap {
				v.ReplicationInfo, err = _Map_String_ReplicationInfo_Read(field.Value.GetMap())
				if err != nil {
					return err
				}

			}
		case 80:
			if field.Value.Type() == wire.TStruct {
				v.History, err = _History_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 90:
			if field.Value.Type() == wire.TStruct {
				v.NewRunHistory, err = _History_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 100:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.EventStoreVersion = &x
				if err != nil {
					return err
				}

			}
		case 110:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.NewRunEventStoreVersion = &x
				if err != nil {
					return err
				}

			}
		case 120:
			if field.Value.Type() == wire.TBool {
				var x bool
				x, err = field.Value.GetBool(), error(nil)
				v.ResetWorkflow = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a HistoryTaskAttributes
// struct.
func (v *HistoryTaskAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [13]string
	i := 0
	if v.TargetClusters != nil {
		fields[i] = fmt.Sprintf("TargetClusters: %v", v.TargetClusters)
		i++
	}
	if v.DomainId != nil {
		fields[i] = fmt.Sprintf("DomainId: %v", *(v.DomainId))
		i++
	}
	if v.WorkflowId != nil {
		fields[i] = fmt.Sprintf("WorkflowId: %v", *(v.WorkflowId))
		i++
	}
	if v.RunId != nil {
		fields[i] = fmt.Sprintf("RunId: %v", *(v.RunId))
		i++
	}
	if v.FirstEventId != nil {
		fields[i] = fmt.Sprintf("FirstEventId: %v", *(v.FirstEventId))
		i++
	}
	if v.NextEventId != nil {
		fields[i] = fmt.Sprintf("NextEventId: %v", *(v.NextEventId))
		i++
	}
	if v.Version != nil {
		fields[i] = fmt.Sprintf("Version: %v", *(v.Version))
		i++
	}
	if v.ReplicationInfo != nil {
		fields[i] = fmt.Sprintf("ReplicationInfo: %v", v.ReplicationInfo)
		i++
	}
	if v.History != nil {
		fields[i] = fmt.Sprintf("History: %v", v.History)
		i++
	}
	if v.NewRunHistory != nil {
		fields[i] = fmt.Sprintf("NewRunHistory: %v", v.NewRunHistory)
		i++
	}
	if v.EventStoreVersion != nil {
		fields[i] = fmt.Sprintf("EventStoreVersion: %v", *(v.EventStoreVersion))
		i++
	}
	if v.NewRunEventStoreVersion != nil {
		fields[i] = fmt.Sprintf("NewRunEventStoreVersion: %v", *(v.NewRunEventStoreVersion))
		i++
	}
	if v.ResetWorkflow != nil {
		fields[i] = fmt.Sprintf("ResetWorkflow: %v", *(v.ResetWorkflow))
		i++
	}

	return fmt.Sprintf("HistoryTaskAttributes{%v}", strings.Join(fields[:i], ", "))
}

func _Map_String_ReplicationInfo_Equals(lhs, rhs map[string]*shared.ReplicationInfo) bool {
	if len(lhs) != len(rhs) {
		return false
	}

	for lk, lv := range lhs {
		rv, ok := rhs[lk]
		if !ok {
			return false
		}
		if !lv.Equals(rv) {
			return false
		}
	}
	return true
}

func _I32_EqualsPtr(lhs, rhs *int32) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return (x == y)
	}
	return lhs == nil && rhs == nil
}

func _Bool_EqualsPtr(lhs, rhs *bool) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return (x == y)
	}
	return lhs == nil && rhs == nil
}

// Equals returns true if all the fields of this HistoryTaskAttributes match the
// provided HistoryTaskAttributes.
//
// This function performs a deep comparison.
func (v *HistoryTaskAttributes) Equals(rhs *HistoryTaskAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.TargetClusters == nil && rhs.TargetClusters == nil) || (v.TargetClusters != nil && rhs.TargetClusters != nil && _List_String_Equals(v.TargetClusters, rhs.TargetClusters))) {
		return false
	}
	if !_String_EqualsPtr(v.DomainId, rhs.DomainId) {
		return false
	}
	if !_String_EqualsPtr(v.WorkflowId, rhs.WorkflowId) {
		return false
	}
	if !_String_EqualsPtr(v.RunId, rhs.RunId) {
		return false
	}
	if !_I64_EqualsPtr(v.FirstEventId, rhs.FirstEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.NextEventId, rhs.NextEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.Version, rhs.Version) {
		return false
	}
	if !((v.ReplicationInfo == nil && rhs.ReplicationInfo == nil) || (v.ReplicationInfo != nil && rhs.ReplicationInfo != nil && _Map_String_ReplicationInfo_Equals(v.ReplicationInfo, rhs.ReplicationInfo))) {
		return false
	}
	if !((v.History == nil && rhs.History == nil) || (v.History != nil && rhs.History != nil && v.History.Equals(rhs.History))) {
		return false
	}
	if !((v.NewRunHistory == nil && rhs.NewRunHistory == nil) || (v.NewRunHistory != nil && rhs.NewRunHistory != nil && v.NewRunHistory.Equals(rhs.NewRunHistory))) {
		return false
	}
	if !_I32_EqualsPtr(v.EventStoreVersion, rhs.EventStoreVersion) {
		return false
	}
	if !_I32_EqualsPtr(v.NewRunEventStoreVersion, rhs.NewRunEventStoreVersion) {
		return false
	}
	if !_Bool_EqualsPtr(v.ResetWorkflow, rhs.ResetWorkflow) {
		return false
	}

	return true
}

type _Map_String_ReplicationInfo_Zapper map[string]*shared.ReplicationInfo

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of _Map_String_ReplicationInfo_Zapper.
func (m _Map_String_ReplicationInfo_Zapper) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	for k, v := range m {
		err = multierr.Append(err, enc.AddObject((string)(k), v))
	}
	return err
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of HistoryTaskAttributes.
func (v *HistoryTaskAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.TargetClusters != nil {
		err = multierr.Append(err, enc.AddArray("targetClusters", (_List_String_Zapper)(v.TargetClusters)))
	}
	if v.DomainId != nil {
		enc.AddString("domainId", *v.DomainId)
	}
	if v.WorkflowId != nil {
		enc.AddString("workflowId", *v.WorkflowId)
	}
	if v.RunId != nil {
		enc.AddString("runId", *v.RunId)
	}
	if v.FirstEventId != nil {
		enc.AddInt64("firstEventId", *v.FirstEventId)
	}
	if v.NextEventId != nil {
		enc.AddInt64("nextEventId", *v.NextEventId)
	}
	if v.Version != nil {
		enc.AddInt64("version", *v.Version)
	}
	if v.ReplicationInfo != nil {
		err = multierr.Append(err, enc.AddObject("replicationInfo", (_Map_String_ReplicationInfo_Zapper)(v.ReplicationInfo)))
	}
	if v.History != nil {
		err = multierr.Append(err, enc.AddObject("history", v.History))
	}
	if v.NewRunHistory != nil {
		err = multierr.Append(err, enc.AddObject("newRunHistory", v.NewRunHistory))
	}
	if v.EventStoreVersion != nil {
		enc.AddInt32("eventStoreVersion", *v.EventStoreVersion)
	}
	if v.NewRunEventStoreVersion != nil {
		enc.AddInt32("newRunEventStoreVersion", *v.NewRunEventStoreVersion)
	}
	if v.ResetWorkflow != nil {
		enc.AddBool("resetWorkflow", *v.ResetWorkflow)
	}
	return err
}

// GetTargetClusters returns the value of TargetClusters if it is set or its
// zero value if it is unset.
func (v *HistoryTaskAttributes) GetTargetClusters() (o []string) {
	if v != nil && v.TargetClusters != nil {
		return v.TargetClusters
	}

	return
}

// IsSetTargetClusters returns true if TargetClusters is not nil.
func (v *HistoryTaskAttributes) IsSetTargetClusters() bool {
	return v != nil && v.TargetClusters != nil
}

// GetDomainId returns the value of DomainId if it is set or its
// zero value if it is unset.
func (v *HistoryTaskAttributes) GetDomainId() (o string) {
	if v != nil && v.DomainId != nil {
		return *v.DomainId
	}

	return
}

// IsSetDomainId returns true if DomainId is not nil.
func (v *HistoryTaskAttributes) IsSetDomainId() bool {
	return v != nil && v.DomainId != nil
}

// GetWorkflowId returns the value of WorkflowId if it is set or its
// zero value if it is unset.
func (v *HistoryTaskAttributes) GetWorkflowId() (o string) {
	if v != nil && v.WorkflowId != nil {
		return *v.WorkflowId
	}

	return
}

// IsSetWorkflowId returns true if WorkflowId is not nil.
func (v *HistoryTaskAttributes) IsSetWorkflowId() bool {
	return v != nil && v.WorkflowId != nil
}

// GetRunId returns the value of RunId if it is set or its
// zero value if it is unset.
func (v *HistoryTaskAttributes) GetRunId() (o string) {
	if v != nil && v.RunId != nil {
		return *v.RunId
	}

	return
}

// IsSetRunId returns true if RunId is not nil.
func (v *HistoryTaskAttributes) IsSetRunId() bool {
	return v != nil && v.RunId != nil
}

// GetFirstEventId returns the value of FirstEventId if it is set or its
// zero value if it is unset.
func (v *HistoryTaskAttributes) GetFirstEventId() (o int64) {
	if v != nil && v.FirstEventId != nil {
		return *v.FirstEventId
	}

	return
}

// IsSetFirstEventId returns true if FirstEventId is not nil.
func (v *HistoryTaskAttributes) IsSetFirstEventId() bool {
	return v != nil && v.FirstEventId != nil
}

// GetNextEventId returns the value of NextEventId if it is set or its
// zero value if it is unset.
func (v *HistoryTaskAttributes) GetNextEventId() (o int64) {
	if v != nil && v.NextEventId != nil {
		return *v.NextEventId
	}

	return
}

// IsSetNextEventId returns true if NextEventId is not nil.
func (v *HistoryTaskAttributes) IsSetNextEventId() bool {
	return v != nil && v.NextEventId != nil
}

// GetVersion returns the value of Version if it is set or its
// zero value if it is unset.
func (v *HistoryTaskAttributes) GetVersion() (o int64) {
	if v != nil && v.Version != nil {
		return *v.Version
	}

	return
}

// IsSetVersion returns true if Version is not nil.
func (v *HistoryTaskAttributes) IsSetVersion() bool {
	return v != nil && v.Version != nil
}

// GetReplicationInfo returns the value of ReplicationInfo if it is set or its
// zero value if it is unset.
func (v *HistoryTaskAttributes) GetReplicationInfo() (o map[string]*shared.ReplicationInfo) {
	if v != nil && v.ReplicationInfo != nil {
		return v.ReplicationInfo
	}

	return
}

// IsSetReplicationInfo returns true if ReplicationInfo is not nil.
func (v *HistoryTaskAttributes) IsSetReplicationInfo() bool {
	return v != nil && v.ReplicationInfo != nil
}

// GetHistory returns the value of History if it is set or its
// zero value if it is unset.
func (v *HistoryTaskAttributes) GetHistory() (o *shared.History) {
	if v != nil && v.History != nil {
		return v.History
	}

	return
}

// IsSetHistory returns true if History is not nil.
func (v *HistoryTaskAttributes) IsSetHistory() bool {
	return v != nil && v.History != nil
}

// GetNewRunHistory returns the value of NewRunHistory if it is set or its
// zero value if it is unset.
func (v *HistoryTaskAttributes) GetNewRunHistory() (o *shared.History) {
	if v != nil && v.NewRunHistory != nil {
		return v.NewRunHistory
	}

	return
}

// IsSetNewRunHistory returns true if NewRunHistory is not nil.
func (v *HistoryTaskAttributes) IsSetNewRunHistory() bool {
	return v != nil && v.NewRunHistory != nil
}

// GetEventStoreVersion returns the value of EventStoreVersion if it is set or its
// zero value if it is unset.
func (v *HistoryTaskAttributes) GetEventStoreVersion() (o int32) {
	if v != nil && v.EventStoreVersion != nil {
		return *v.EventStoreVersion
	}

	return
}

// IsSetEventStoreVersion returns true if EventStoreVersion is not nil.
func (v *HistoryTaskAttributes) IsSetEventStoreVersion() bool {
	return v != nil && v.EventStoreVersion != nil
}

// GetNewRunEventStoreVersion returns the value of NewRunEventStoreVersion if it is set or its
// zero value if it is unset.
func (v *HistoryTaskAttributes) GetNewRunEventStoreVersion() (o int32) {
	if v != nil && v.NewRunEventStoreVersion != nil {
		return *v.NewRunEventStoreVersion
	}

	return
}

// IsSetNewRunEventStoreVersion returns true if NewRunEventStoreVersion is not nil.
func (v *HistoryTaskAttributes) IsSetNewRunEventStoreVersion() bool {
	return v != nil && v.NewRunEventStoreVersion != nil
}

// GetResetWorkflow returns the value of ResetWorkflow if it is set or its
// zero value if it is unset.
func (v *HistoryTaskAttributes) GetResetWorkflow() (o bool) {
	if v != nil && v.ResetWorkflow != nil {
		return *v.ResetWorkflow
	}

	return
}

// IsSetResetWorkflow returns true if ResetWorkflow is not nil.
func (v *HistoryTaskAttributes) IsSetResetWorkflow() bool {
	return v != nil && v.ResetWorkflow != nil
}

type ReplicationTask struct {
	TaskType                      *ReplicationTaskType           `json:"taskType,omitempty"`
	DomainTaskAttributes          *DomainTaskAttributes          `json:"domainTaskAttributes,omitempty"`
	HistoryTaskAttributes         *HistoryTaskAttributes         `json:"historyTaskAttributes,omitempty"`
	SyncShardStatusTaskAttributes *SyncShardStatusTaskAttributes `json:"syncShardStatusTaskAttributes,omitempty"`
	SyncActicvityTaskAttributes   *SyncActicvityTaskAttributes   `json:"syncActicvityTaskAttributes,omitempty"`
	HistoryMetadataTaskAttributes *HistoryMetadataTaskAttributes `json:"historyMetadataTaskAttributes,omitempty"`
}

// ToWire translates a ReplicationTask struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ReplicationTask) ToWire() (wire.Value, error) {
	var (
		fields [6]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.TaskType != nil {
		w, err = v.TaskType.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.DomainTaskAttributes != nil {
		w, err = v.DomainTaskAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.HistoryTaskAttributes != nil {
		w, err = v.HistoryTaskAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.SyncShardStatusTaskAttributes != nil {
		w, err = v.SyncShardStatusTaskAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.SyncActicvityTaskAttributes != nil {
		w, err = v.SyncActicvityTaskAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.HistoryMetadataTaskAttributes != nil {
		w, err = v.HistoryMetadataTaskAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _ReplicationTaskType_Read(w wire.Value) (ReplicationTaskType, error) {
	var v ReplicationTaskType
	err := v.FromWire(w)
	return v, err
}

func _DomainTaskAttributes_Read(w wire.Value) (*DomainTaskAttributes, error) {
	var v DomainTaskAttributes
	err := v.FromWire(w)
	return &v, err
}

func _HistoryTaskAttributes_Read(w wire.Value) (*HistoryTaskAttributes, error) {
	var v HistoryTaskAttributes
	err := v.FromWire(w)
	return &v, err
}

func _SyncShardStatusTaskAttributes_Read(w wire.Value) (*SyncShardStatusTaskAttributes, error) {
	var v SyncShardStatusTaskAttributes
	err := v.FromWire(w)
	return &v, err
}

func _SyncActicvityTaskAttributes_Read(w wire.Value) (*SyncActicvityTaskAttributes, error) {
	var v SyncActicvityTaskAttributes
	err := v.FromWire(w)
	return &v, err
}

func _HistoryMetadataTaskAttributes_Read(w wire.Value) (*HistoryMetadataTaskAttributes, error) {
	var v HistoryMetadataTaskAttributes
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a ReplicationTask struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ReplicationTask struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ReplicationTask
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ReplicationTask) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI32 {
				var x ReplicationTaskType
				x, err = _ReplicationTaskType_Read(field.Value)
				v.TaskType = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.DomainTaskAttributes, err = _DomainTaskAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TStruct {
				v.HistoryTaskAttributes, err = _HistoryTaskAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TStruct {
				v.SyncShardStatusTaskAttributes, err = _SyncShardStatusTaskAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TStruct {
				v.SyncActicvityTaskAttributes, err = _SyncActicvityTaskAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TStruct {
				v.HistoryMetadataTaskAttributes, err = _HistoryMetadataTaskAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ReplicationTask
// struct.
func (v *ReplicationTask) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [6]string
	i := 0
	if v.TaskType != nil {
		fields[i] = fmt.Sprintf("TaskType: %v", *(v.TaskType))
		i++
	}
	if v.DomainTaskAttributes != nil {
		fields[i] = fmt.Sprintf("DomainTaskAttributes: %v", v.DomainTaskAttributes)
		i++
	}
	if v.HistoryTaskAttributes != nil {
		fields[i] = fmt.Sprintf("HistoryTaskAttributes: %v", v.HistoryTaskAttributes)
		i++
	}
	if v.SyncShardStatusTaskAttributes != nil {
		fields[i] = fmt.Sprintf("SyncShardStatusTaskAttributes: %v", v.SyncShardStatusTaskAttributes)
		i++
	}
	if v.SyncActicvityTaskAttributes != nil {
		fields[i] = fmt.Sprintf("SyncActicvityTaskAttributes: %v", v.SyncActicvityTaskAttributes)
		i++
	}
	if v.HistoryMetadataTaskAttributes != nil {
		fields[i] = fmt.Sprintf("HistoryMetadataTaskAttributes: %v", v.HistoryMetadataTaskAttributes)
		i++
	}

	return fmt.Sprintf("ReplicationTask{%v}", strings.Join(fields[:i], ", "))
}

func _ReplicationTaskType_EqualsPtr(lhs, rhs *ReplicationTaskType) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return x.Equals(y)
	}
	return lhs == nil && rhs == nil
}

// Equals returns true if all the fields of this ReplicationTask match the
// provided ReplicationTask.
//
// This function performs a deep comparison.
func (v *ReplicationTask) Equals(rhs *ReplicationTask) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_ReplicationTaskType_EqualsPtr(v.TaskType, rhs.TaskType) {
		return false
	}
	if !((v.DomainTaskAttributes == nil && rhs.DomainTaskAttributes == nil) || (v.DomainTaskAttributes != nil && rhs.DomainTaskAttributes != nil && v.DomainTaskAttributes.Equals(rhs.DomainTaskAttributes))) {
		return false
	}
	if !((v.HistoryTaskAttributes == nil && rhs.HistoryTaskAttributes == nil) || (v.HistoryTaskAttributes != nil && rhs.HistoryTaskAttributes != nil && v.HistoryTaskAttributes.Equals(rhs.HistoryTaskAttributes))) {
		return false
	}
	if !((v.SyncShardStatusTaskAttributes == nil && rhs.SyncShardStatusTaskAttributes == nil) || (v.SyncShardStatusTaskAttributes != nil && rhs.SyncShardStatusTaskAttributes != nil && v.SyncShardStatusTaskAttributes.Equals(rhs.SyncShardStatusTaskAttributes))) {
		return false
	}
	if !((v.SyncActicvityTaskAttributes == nil && rhs.SyncActicvityTaskAttributes == nil) || (v.SyncActicvityTaskAttributes != nil && rhs.SyncActicvityTaskAttributes != nil && v.SyncActicvityTaskAttributes.Equals(rhs.SyncActicvityTaskAttributes))) {
		return false
	}
	if !((v.HistoryMetadataTaskAttributes == nil && rhs.HistoryMetadataTaskAttributes == nil) || (v.HistoryMetadataTaskAttributes != nil && rhs.HistoryMetadataTaskAttributes != nil && v.HistoryMetadataTaskAttributes.Equals(rhs.HistoryMetadataTaskAttributes))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ReplicationTask.
func (v *ReplicationTask) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.TaskType != nil {
		err = multierr.Append(err, enc.AddObject("taskType", *v.TaskType))
	}
	if v.DomainTaskAttributes != nil {
		err = multierr.Append(err, enc.AddObject("domainTaskAttributes", v.DomainTaskAttributes))
	}
	if v.HistoryTaskAttributes != nil {
		err = multierr.Append(err, enc.AddObject("historyTaskAttributes", v.HistoryTaskAttributes))
	}
	if v.SyncShardStatusTaskAttributes != nil {
		err = multierr.Append(err, enc.AddObject("syncShardStatusTaskAttributes", v.SyncShardStatusTaskAttributes))
	}
	if v.SyncActicvityTaskAttributes != nil {
		err = multierr.Append(err, enc.AddObject("syncActicvityTaskAttributes", v.SyncActicvityTaskAttributes))
	}
	if v.HistoryMetadataTaskAttributes != nil {
		err = multierr.Append(err, enc.AddObject("historyMetadataTaskAttributes", v.HistoryMetadataTaskAttributes))
	}
	return err
}

// GetTaskType returns the value of TaskType if it is set or its
// zero value if it is unset.
func (v *ReplicationTask) GetTaskType() (o ReplicationTaskType) {
	if v != nil && v.TaskType != nil {
		return *v.TaskType
	}

	return
}

// IsSetTaskType returns true if TaskType is not nil.
func (v *ReplicationTask) IsSetTaskType() bool {
	return v != nil && v.TaskType != nil
}

// GetDomainTaskAttributes returns the value of DomainTaskAttributes if it is set or its
// zero value if it is unset.
func (v *ReplicationTask) GetDomainTaskAttributes() (o *DomainTaskAttributes) {
	if v != nil && v.DomainTaskAttributes != nil {
		return v.DomainTaskAttributes
	}

	return
}

// IsSetDomainTaskAttributes returns true if DomainTaskAttributes is not nil.
func (v *ReplicationTask) IsSetDomainTaskAttributes() bool {
	return v != nil && v.DomainTaskAttributes != nil
}

// GetHistoryTaskAttributes returns the value of HistoryTaskAttributes if it is set or its
// zero value if it is unset.
func (v *ReplicationTask) GetHistoryTaskAttributes() (o *HistoryTaskAttributes) {
	if v != nil && v.HistoryTaskAttributes != nil {
		return v.HistoryTaskAttributes
	}

	return
}

// IsSetHistoryTaskAttributes returns true if HistoryTaskAttributes is not nil.
func (v *ReplicationTask) IsSetHistoryTaskAttributes() bool {
	return v != nil && v.HistoryTaskAttributes != nil
}

// GetSyncShardStatusTaskAttributes returns the value of SyncShardStatusTaskAttributes if it is set or its
// zero value if it is unset.
func (v *ReplicationTask) GetSyncShardStatusTaskAttributes() (o *SyncShardStatusTaskAttributes) {
	if v != nil && v.SyncShardStatusTaskAttributes != nil {
		return v.SyncShardStatusTaskAttributes
	}

	return
}

// IsSetSyncShardStatusTaskAttributes returns true if SyncShardStatusTaskAttributes is not nil.
func (v *ReplicationTask) IsSetSyncShardStatusTaskAttributes() bool {
	return v != nil && v.SyncShardStatusTaskAttributes != nil
}

// GetSyncActicvityTaskAttributes returns the value of SyncActicvityTaskAttributes if it is set or its
// zero value if it is unset.
func (v *ReplicationTask) GetSyncActicvityTaskAttributes() (o *SyncActicvityTaskAttributes) {
	if v != nil && v.SyncActicvityTaskAttributes != nil {
		return v.SyncActicvityTaskAttributes
	}

	return
}

// IsSetSyncActicvityTaskAttributes returns true if SyncActicvityTaskAttributes is not nil.
func (v *ReplicationTask) IsSetSyncActicvityTaskAttributes() bool {
	return v != nil && v.SyncActicvityTaskAttributes != nil
}

// GetHistoryMetadataTaskAttributes returns the value of HistoryMetadataTaskAttributes if it is set or its
// zero value if it is unset.
func (v *ReplicationTask) GetHistoryMetadataTaskAttributes() (o *HistoryMetadataTaskAttributes) {
	if v != nil && v.HistoryMetadataTaskAttributes != nil {
		return v.HistoryMetadataTaskAttributes
	}

	return
}

// IsSetHistoryMetadataTaskAttributes returns true if HistoryMetadataTaskAttributes is not nil.
func (v *ReplicationTask) IsSetHistoryMetadataTaskAttributes() bool {
	return v != nil && v.HistoryMetadataTaskAttributes != nil
}

type ReplicationTaskType int32

const (
	ReplicationTaskTypeDomain          ReplicationTaskType = 0
	ReplicationTaskTypeHistory         ReplicationTaskType = 1
	ReplicationTaskTypeSyncShardStatus ReplicationTaskType = 2
	ReplicationTaskTypeSyncActivity    ReplicationTaskType = 3
	ReplicationTaskTypeHistoryMetadata ReplicationTaskType = 4
)

// ReplicationTaskType_Values returns all recognized values of ReplicationTaskType.
func ReplicationTaskType_Values() []ReplicationTaskType {
	return []ReplicationTaskType{
		ReplicationTaskTypeDomain,
		ReplicationTaskTypeHistory,
		ReplicationTaskTypeSyncShardStatus,
		ReplicationTaskTypeSyncActivity,
		ReplicationTaskTypeHistoryMetadata,
	}
}

// UnmarshalText tries to decode ReplicationTaskType from a byte slice
// containing its name.
//
//   var v ReplicationTaskType
//   err := v.UnmarshalText([]byte("Domain"))
func (v *ReplicationTaskType) UnmarshalText(value []byte) error {
	switch s := string(value); s {
	case "Domain":
		*v = ReplicationTaskTypeDomain
		return nil
	case "History":
		*v = ReplicationTaskTypeHistory
		return nil
	case "SyncShardStatus":
		*v = ReplicationTaskTypeSyncShardStatus
		return nil
	case "SyncActivity":
		*v = ReplicationTaskTypeSyncActivity
		return nil
	case "HistoryMetadata":
		*v = ReplicationTaskTypeHistoryMetadata
		return nil
	default:
		val, err := strconv.ParseInt(s, 10, 32)
		if err != nil {
			return fmt.Errorf("unknown enum value %q for %q: %v", s, "ReplicationTaskType", err)
		}
		*v = ReplicationTaskType(val)
		return nil
	}
}

// MarshalText encodes ReplicationTaskType to text.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements the TextMarshaler interface.
func (v ReplicationTaskType) MarshalText() ([]byte, error) {
	switch int32(v) {
	case 0:
		return []byte("Domain"), nil
	case 1:
		return []byte("History"), nil
	case 2:
		return []byte("SyncShardStatus"), nil
	case 3:
		return []byte("SyncActivity"), nil
	case 4:
		return []byte("HistoryMetadata"), nil
	}
	return []byte(strconv.FormatInt(int64(v), 10)), nil
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ReplicationTaskType.
// Enums are logged as objects, where the value is logged with key "value", and
// if this value's name is known, the name is logged with key "name".
func (v ReplicationTaskType) MarshalLogObject(enc zapcore.ObjectEncoder) error {
	enc.AddInt32("value", int32(v))
	switch int32(v) {
	case 0:
		enc.AddString("name", "Domain")
	case 1:
		enc.AddString("name", "History")
	case 2:
		enc.AddString("name", "SyncShardStatus")
	case 3:
		enc.AddString("name", "SyncActivity")
	case 4:
		enc.AddString("name", "HistoryMetadata")
	}
	return nil
}

// Ptr returns a pointer to this enum value.
func (v ReplicationTaskType) Ptr() *ReplicationTaskType {
	return &v
}

// ToWire translates ReplicationTaskType into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// Enums are represented as 32-bit integers over the wire.
func (v ReplicationTaskType) ToWire() (wire.Value, error) {
	return wire.NewValueI32(int32(v)), nil
}

// FromWire deserializes ReplicationTaskType from its Thrift-level
// representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TI32)
//   if err != nil {
//     return ReplicationTaskType(0), err
//   }
//
//   var v ReplicationTaskType
//   if err := v.FromWire(x); err != nil {
//     return ReplicationTaskType(0), err
//   }
//   return v, nil
func (v *ReplicationTaskType) FromWire(w wire.Value) error {
	*v = (ReplicationTaskType)(w.GetI32())
	return nil
}

// String returns a readable string representation of ReplicationTaskType.
func (v ReplicationTaskType) String() string {
	w := int32(v)
	switch w {
	case 0:
		return "Domain"
	case 1:
		return "History"
	case 2:
		return "SyncShardStatus"
	case 3:
		return "SyncActivity"
	case 4:
		return "HistoryMetadata"
	}
	return fmt.Sprintf("ReplicationTaskType(%d)", w)
}

// Equals returns true if this ReplicationTaskType value matches the provided
// value.
func (v ReplicationTaskType) Equals(rhs ReplicationTaskType) bool {
	return v == rhs
}

// MarshalJSON serializes ReplicationTaskType into JSON.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements json.Marshaler.
func (v ReplicationTaskType) MarshalJSON() ([]byte, error) {
	switch int32(v) {
	case 0:
		return ([]byte)("\"Domain\""), nil
	case 1:
		return ([]byte)("\"History\""), nil
	case 2:
		return ([]byte)("\"SyncShardStatus\""), nil
	case 3:
		return ([]byte)("\"SyncActivity\""), nil
	case 4:
		return ([]byte)("\"HistoryMetadata\""), nil
	}
	return ([]byte)(strconv.FormatInt(int64(v), 10)), nil
}

// UnmarshalJSON attempts to decode ReplicationTaskType from its JSON
// representation.
//
// This implementation supports both, numeric and string inputs. If a
// string is provided, it must be a known enum name.
//
// This implements json.Unmarshaler.
func (v *ReplicationTaskType) UnmarshalJSON(text []byte) error {
	d := json.NewDecoder(bytes.NewReader(text))
	d.UseNumber()
	t, err := d.Token()
	if err != nil {
		return err
	}

	switch w := t.(type) {
	case json.Number:
		x, err := w.Int64()
		if err != nil {
			return err
		}
		if x > math.MaxInt32 {
			return fmt.Errorf("enum overflow from JSON %q for %q", text, "ReplicationTaskType")
		}
		if x < math.MinInt32 {
			return fmt.Errorf("enum underflow from JSON %q for %q", text, "ReplicationTaskType")
		}
		*v = (ReplicationTaskType)(x)
		return nil
	case string:
		return v.UnmarshalText([]byte(w))
	default:
		return fmt.Errorf("invalid JSON value %q (%T) to unmarshal into %q", t, t, "ReplicationTaskType")
	}
}

type SyncActicvityTaskAttributes struct {
	DomainId          *string `json:"domainId,omitempty"`
	WorkflowId        *string `json:"workflowId,omitempty"`
	RunId             *string `json:"runId,omitempty"`
	Version           *int64  `json:"version,omitempty"`
	ScheduledId       *int64  `json:"scheduledId,omitempty"`
	ScheduledTime     *int64  `json:"scheduledTime,omitempty"`
	StartedId         *int64  `json:"startedId,omitempty"`
	StartedTime       *int64  `json:"startedTime,omitempty"`
	LastHeartbeatTime *int64  `json:"lastHeartbeatTime,omitempty"`
	Details           []byte  `json:"details,omitempty"`
	Attempt           *int32  `json:"attempt,omitempty"`
}

// ToWire translates a SyncActicvityTaskAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *SyncActicvityTaskAttributes) ToWire() (wire.Value, error) {
	var (
		fields [11]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainId != nil {
		w, err = wire.NewValueString(*(v.DomainId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.WorkflowId != nil {
		w, err = wire.NewValueString(*(v.WorkflowId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.RunId != nil {
		w, err = wire.NewValueString(*(v.RunId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.Version != nil {
		w, err = wire.NewValueI64(*(v.Version)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.ScheduledId != nil {
		w, err = wire.NewValueI64(*(v.ScheduledId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.ScheduledTime != nil {
		w, err = wire.NewValueI64(*(v.ScheduledTime)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}
	if v.StartedId != nil {
		w, err = wire.NewValueI64(*(v.StartedId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 70, Value: w}
		i++
	}
	if v.StartedTime != nil {
		w, err = wire.NewValueI64(*(v.StartedTime)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 80, Value: w}
		i++
	}
	if v.LastHeartbeatTime != nil {
		w, err = wire.NewValueI64(*(v.LastHeartbeatTime)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 90, Value: w}
		i++
	}
	if v.Details != nil {
		w, err = wire.NewValueBinary(v.Details), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 100, Value: w}
		i++
	}
	if v.Attempt != nil {
		w, err = wire.NewValueI32(*(v.Attempt)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 110, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a SyncActicvityTaskAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a SyncActicvityTaskAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v SyncActicvityTaskAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *SyncActicvityTaskAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainId = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.WorkflowId = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.RunId = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.Version = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduledId = &x
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduledTime = &x
				if err != nil {
					return err
				}

			}
		case 70:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StartedId = &x
				if err != nil {
					return err
				}

			}
		case 80:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StartedTime = &x
				if err != nil {
					return err
				}

			}
		case 90:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.LastHeartbeatTime = &x
				if err != nil {
					return err
				}

			}
		case 100:
			if field.Value.Type() == wire.TBinary {
				v.Details, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 110:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.Attempt = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a SyncActicvityTaskAttributes
// struct.
func (v *SyncActicvityTaskAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [11]string
	i := 0
	if v.DomainId != nil {
		fields[i] = fmt.Sprintf("DomainId: %v", *(v.DomainId))
		i++
	}
	if v.WorkflowId != nil {
		fields[i] = fmt.Sprintf("WorkflowId: %v", *(v.WorkflowId))
		i++
	}
	if v.RunId != nil {
		fields[i] = fmt.Sprintf("RunId: %v", *(v.RunId))
		i++
	}
	if v.Version != nil {
		fields[i] = fmt.Sprintf("Version: %v", *(v.Version))
		i++
	}
	if v.ScheduledId != nil {
		fields[i] = fmt.Sprintf("ScheduledId: %v", *(v.ScheduledId))
		i++
	}
	if v.ScheduledTime != nil {
		fields[i] = fmt.Sprintf("ScheduledTime: %v", *(v.ScheduledTime))
		i++
	}
	if v.StartedId != nil {
		fields[i] = fmt.Sprintf("StartedId: %v", *(v.StartedId))
		i++
	}
	if v.StartedTime != nil {
		fields[i] = fmt.Sprintf("StartedTime: %v", *(v.StartedTime))
		i++
	}
	if v.LastHeartbeatTime != nil {
		fields[i] = fmt.Sprintf("LastHeartbeatTime: %v", *(v.LastHeartbeatTime))
		i++
	}
	if v.Details != nil {
		fields[i] = fmt.Sprintf("Details: %v", v.Details)
		i++
	}
	if v.Attempt != nil {
		fields[i] = fmt.Sprintf("Attempt: %v", *(v.Attempt))
		i++
	}

	return fmt.Sprintf("SyncActicvityTaskAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this SyncActicvityTaskAttributes match the
// provided SyncActicvityTaskAttributes.
//
// This function performs a deep comparison.
func (v *SyncActicvityTaskAttributes) Equals(rhs *SyncActicvityTaskAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.DomainId, rhs.DomainId) {
		return false
	}
	if !_String_EqualsPtr(v.WorkflowId, rhs.WorkflowId) {
		return false
	}
	if !_String_EqualsPtr(v.RunId, rhs.RunId) {
		return false
	}
	if !_I64_EqualsPtr(v.Version, rhs.Version) {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduledId, rhs.ScheduledId) {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduledTime, rhs.ScheduledTime) {
		return false
	}
	if !_I64_EqualsPtr(v.StartedId, rhs.StartedId) {
		return false
	}
	if !_I64_EqualsPtr(v.StartedTime, rhs.StartedTime) {
		return false
	}
	if !_I64_EqualsPtr(v.LastHeartbeatTime, rhs.LastHeartbeatTime) {
		return false
	}
	if !((v.Details == nil && rhs.Details == nil) || (v.Details != nil && rhs.Details != nil && bytes.Equal(v.Details, rhs.Details))) {
		return false
	}
	if !_I32_EqualsPtr(v.Attempt, rhs.Attempt) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of SyncActicvityTaskAttributes.
func (v *SyncActicvityTaskAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainId != nil {
		enc.AddString("domainId", *v.DomainId)
	}
	if v.WorkflowId != nil {
		enc.AddString("workflowId", *v.WorkflowId)
	}
	if v.RunId != nil {
		enc.AddString("runId", *v.RunId)
	}
	if v.Version != nil {
		enc.AddInt64("version", *v.Version)
	}
	if v.ScheduledId != nil {
		enc.AddInt64("scheduledId", *v.ScheduledId)
	}
	if v.ScheduledTime != nil {
		enc.AddInt64("scheduledTime", *v.ScheduledTime)
	}
	if v.StartedId != nil {
		enc.AddInt64("startedId", *v.StartedId)
	}
	if v.StartedTime != nil {
		enc.AddInt64("startedTime", *v.StartedTime)
	}
	if v.LastHeartbeatTime != nil {
		enc.AddInt64("lastHeartbeatTime", *v.LastHeartbeatTime)
	}
	if v.Details != nil {
		enc.AddString("details", base64.StdEncoding.EncodeToString(v.Details))
	}
	if v.Attempt != nil {
		enc.AddInt32("attempt", *v.Attempt)
	}
	return err
}

// GetDomainId returns the value of DomainId if it is set or its
// zero value if it is unset.
func (v *SyncActicvityTaskAttributes) GetDomainId() (o string) {
	if v != nil && v.DomainId != nil {
		return *v.DomainId
	}

	return
}

// IsSetDomainId returns true if DomainId is not nil.
func (v *SyncActicvityTaskAttributes) IsSetDomainId() bool {
	return v != nil && v.DomainId != nil
}

// GetWorkflowId returns the value of WorkflowId if it is set or its
// zero value if it is unset.
func (v *SyncActicvityTaskAttributes) GetWorkflowId() (o string) {
	if v != nil && v.WorkflowId != nil {
		return *v.WorkflowId
	}

	return
}

// IsSetWorkflowId returns true if WorkflowId is not nil.
func (v *SyncActicvityTaskAttributes) IsSetWorkflowId() bool {
	return v != nil && v.WorkflowId != nil
}

// GetRunId returns the value of RunId if it is set or its
// zero value if it is unset.
func (v *SyncActicvityTaskAttributes) GetRunId() (o string) {
	if v != nil && v.RunId != nil {
		return *v.RunId
	}

	return
}

// IsSetRunId returns true if RunId is not nil.
func (v *SyncActicvityTaskAttributes) IsSetRunId() bool {
	return v != nil && v.RunId != nil
}

// GetVersion returns the value of Version if it is set or its
// zero value if it is unset.
func (v *SyncActicvityTaskAttributes) GetVersion() (o int64) {
	if v != nil && v.Version != nil {
		return *v.Version
	}

	return
}

// IsSetVersion returns true if Version is not nil.
func (v *SyncActicvityTaskAttributes) IsSetVersion() bool {
	return v != nil && v.Version != nil
}

// GetScheduledId returns the value of ScheduledId if it is set or its
// zero value if it is unset.
func (v *SyncActicvityTaskAttributes) GetScheduledId() (o int64) {
	if v != nil && v.ScheduledId != nil {
		return *v.ScheduledId
	}

	return
}

// IsSetScheduledId returns true if ScheduledId is not nil.
func (v *SyncActicvityTaskAttributes) IsSetScheduledId() bool {
	return v != nil && v.ScheduledId != nil
}

// GetScheduledTime returns the value of ScheduledTime if it is set or its
// zero value if it is unset.
func (v *SyncActicvityTaskAttributes) GetScheduledTime() (o int64) {
	if v != nil && v.ScheduledTime != nil {
		return *v.ScheduledTime
	}

	return
}

// IsSetScheduledTime returns true if ScheduledTime is not nil.
func (v *SyncActicvityTaskAttributes) IsSetScheduledTime() bool {
	return v != nil && v.ScheduledTime != nil
}

// GetStartedId returns the value of StartedId if it is set or its
// zero value if it is unset.
func (v *SyncActicvityTaskAttributes) GetStartedId() (o int64) {
	if v != nil && v.StartedId != nil {
		return *v.StartedId
	}

	return
}

// IsSetStartedId returns true if StartedId is not nil.
func (v *SyncActicvityTaskAttributes) IsSetStartedId() bool {
	return v != nil && v.StartedId != nil
}

// GetStartedTime returns the value of StartedTime if it is set or its
// zero value if it is unset.
func (v *SyncActicvityTaskAttributes) GetStartedTime() (o int64) {
	if v != nil && v.StartedTime != nil {
		return *v.StartedTime
	}

	return
}

// IsSetStartedTime returns true if StartedTime is not nil.
func (v *SyncActicvityTaskAttributes) IsSetStartedTime() bool {
	return v != nil && v.StartedTime != nil
}

// GetLastHeartbeatTime returns the value of LastHeartbeatTime if it is set or its
// zero value if it is unset.
func (v *SyncActicvityTaskAttributes) GetLastHeartbeatTime() (o int64) {
	if v != nil && v.LastHeartbeatTime != nil {
		return *v.LastHeartbeatTime
	}

	return
}

// IsSetLastHeartbeatTime returns true if LastHeartbeatTime is not nil.
func (v *SyncActicvityTaskAttributes) IsSetLastHeartbeatTime() bool {
	return v != nil && v.LastHeartbeatTime != nil
}

// GetDetails returns the value of Details if it is set or its
// zero value if it is unset.
func (v *SyncActicvityTaskAttributes) GetDetails() (o []byte) {
	if v != nil && v.Details != nil {
		return v.Details
	}

	return
}

// IsSetDetails returns true if Details is not nil.
func (v *SyncActicvityTaskAttributes) IsSetDetails() bool {
	return v != nil && v.Details != nil
}

// GetAttempt returns the value of Attempt if it is set or its
// zero value if it is unset.
func (v *SyncActicvityTaskAttributes) GetAttempt() (o int32) {
	if v != nil && v.Attempt != nil {
		return *v.Attempt
	}

	return
}

// IsSetAttempt returns true if Attempt is not nil.
func (v *SyncActicvityTaskAttributes) IsSetAttempt() bool {
	return v != nil && v.Attempt != nil
}

type SyncShardStatusTaskAttributes struct {
	SourceCluster *string `json:"sourceCluster,omitempty"`
	ShardId       *int64  `json:"shardId,omitempty"`
	Timestamp     *int64  `json:"timestamp,omitempty"`
}

// ToWire translates a SyncShardStatusTaskAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *SyncShardStatusTaskAttributes) ToWire() (wire.Value, error) {
	var (
		fields [3]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.SourceCluster != nil {
		w, err = wire.NewValueString(*(v.SourceCluster)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.ShardId != nil {
		w, err = wire.NewValueI64(*(v.ShardId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.Timestamp != nil {
		w, err = wire.NewValueI64(*(v.Timestamp)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a SyncShardStatusTaskAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a SyncShardStatusTaskAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v SyncShardStatusTaskAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *SyncShardStatusTaskAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.SourceCluster = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ShardId = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.Timestamp = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a SyncShardStatusTaskAttributes
// struct.
func (v *SyncShardStatusTaskAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [3]string
	i := 0
	if v.SourceCluster != nil {
		fields[i] = fmt.Sprintf("SourceCluster: %v", *(v.SourceCluster))
		i++
	}
	if v.ShardId != nil {
		fields[i] = fmt.Sprintf("ShardId: %v", *(v.ShardId))
		i++
	}
	if v.Timestamp != nil {
		fields[i] = fmt.Sprintf("Timestamp: %v", *(v.Timestamp))
		i++
	}

	return fmt.Sprintf("SyncShardStatusTaskAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this SyncShardStatusTaskAttributes match the
// provided SyncShardStatusTaskAttributes.
//
// This function performs a deep comparison.
func (v *SyncShardStatusTaskAttributes) Equals(rhs *SyncShardStatusTaskAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.SourceCluster, rhs.SourceCluster) {
		return false
	}
	if !_I64_EqualsPtr(v.ShardId, rhs.ShardId) {
		return false
	}
	if !_I64_EqualsPtr(v.Timestamp, rhs.Timestamp) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of SyncShardStatusTaskAttributes.
func (v *SyncShardStatusTaskAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.SourceCluster != nil {
		enc.AddString("sourceCluster", *v.SourceCluster)
	}
	if v.ShardId != nil {
		enc.AddInt64("shardId", *v.ShardId)
	}
	if v.Timestamp != nil {
		enc.AddInt64("timestamp", *v.Timestamp)
	}
	return err
}

// GetSourceCluster returns the value of SourceCluster if it is set or its
// zero value if it is unset.
func (v *SyncShardStatusTaskAttributes) GetSourceCluster() (o string) {
	if v != nil && v.SourceCluster != nil {
		return *v.SourceCluster
	}

	return
}

// IsSetSourceCluster returns true if SourceCluster is not nil.
func (v *SyncShardStatusTaskAttributes) IsSetSourceCluster() bool {
	return v != nil && v.SourceCluster != nil
}

// GetShardId returns the value of ShardId if it is set or its
// zero value if it is unset.
func (v *SyncShardStatusTaskAttributes) GetShardId() (o int64) {
	if v != nil && v.ShardId != nil {
		return *v.ShardId
	}

	return
}

// IsSetShardId returns true if ShardId is not nil.
func (v *SyncShardStatusTaskAttributes) IsSetShardId() bool {
	return v != nil && v.ShardId != nil
}

// GetTimestamp returns the value of Timestamp if it is set or its
// zero value if it is unset.
func (v *SyncShardStatusTaskAttributes) GetTimestamp() (o int64) {
	if v != nil && v.Timestamp != nil {
		return *v.Timestamp
	}

	return
}

// IsSetTimestamp returns true if Timestamp is not nil.
func (v *SyncShardStatusTaskAttributes) IsSetTimestamp() bool {
	return v != nil && v.Timestamp != nil
}
