// Copyright (c) 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by thriftrw v1.18.0. DO NOT EDIT.
// @generated

package shared

import (
	bytes "bytes"
	base64 "encoding/base64"
	json "encoding/json"
	errors "errors"
	fmt "fmt"
	multierr "go.uber.org/multierr"
	wire "go.uber.org/thriftrw/wire"
	zapcore "go.uber.org/zap/zapcore"
	math "math"
	strconv "strconv"
	strings "strings"
)

type AccessDeniedError struct {
	Message string `json:"message,required"`
}

// ToWire translates a AccessDeniedError struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *AccessDeniedError) ToWire() (wire.Value, error) {
	var (
		fields [1]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	w, err = wire.NewValueString(v.Message), error(nil)
	if err != nil {
		return w, err
	}
	fields[i] = wire.Field{ID: 1, Value: w}
	i++

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a AccessDeniedError struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a AccessDeniedError struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v AccessDeniedError
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *AccessDeniedError) FromWire(w wire.Value) error {
	var err error

	messageIsSet := false

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 1:
			if field.Value.Type() == wire.TBinary {
				v.Message, err = field.Value.GetString(), error(nil)
				if err != nil {
					return err
				}
				messageIsSet = true
			}
		}
	}

	if !messageIsSet {
		return errors.New("field Message of AccessDeniedError is required")
	}

	return nil
}

// String returns a readable string representation of a AccessDeniedError
// struct.
func (v *AccessDeniedError) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [1]string
	i := 0
	fields[i] = fmt.Sprintf("Message: %v", v.Message)
	i++

	return fmt.Sprintf("AccessDeniedError{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this AccessDeniedError match the
// provided AccessDeniedError.
//
// This function performs a deep comparison.
func (v *AccessDeniedError) Equals(rhs *AccessDeniedError) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !(v.Message == rhs.Message) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of AccessDeniedError.
func (v *AccessDeniedError) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	enc.AddString("message", v.Message)
	return err
}

// GetMessage returns the value of Message if it is set or its
// zero value if it is unset.
func (v *AccessDeniedError) GetMessage() (o string) {
	if v != nil {
		o = v.Message
	}
	return
}

func (v *AccessDeniedError) Error() string {
	return v.String()
}

type ActivityTaskCancelRequestedEventAttributes struct {
	ActivityId                   *string `json:"activityId,omitempty"`
	DecisionTaskCompletedEventId *int64  `json:"decisionTaskCompletedEventId,omitempty"`
}

// ToWire translates a ActivityTaskCancelRequestedEventAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ActivityTaskCancelRequestedEventAttributes) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.ActivityId != nil {
		w, err = wire.NewValueString(*(v.ActivityId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.DecisionTaskCompletedEventId != nil {
		w, err = wire.NewValueI64(*(v.DecisionTaskCompletedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ActivityTaskCancelRequestedEventAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ActivityTaskCancelRequestedEventAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ActivityTaskCancelRequestedEventAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ActivityTaskCancelRequestedEventAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ActivityId = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.DecisionTaskCompletedEventId = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ActivityTaskCancelRequestedEventAttributes
// struct.
func (v *ActivityTaskCancelRequestedEventAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.ActivityId != nil {
		fields[i] = fmt.Sprintf("ActivityId: %v", *(v.ActivityId))
		i++
	}
	if v.DecisionTaskCompletedEventId != nil {
		fields[i] = fmt.Sprintf("DecisionTaskCompletedEventId: %v", *(v.DecisionTaskCompletedEventId))
		i++
	}

	return fmt.Sprintf("ActivityTaskCancelRequestedEventAttributes{%v}", strings.Join(fields[:i], ", "))
}

func _String_EqualsPtr(lhs, rhs *string) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return (x == y)
	}
	return lhs == nil && rhs == nil
}

func _I64_EqualsPtr(lhs, rhs *int64) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return (x == y)
	}
	return lhs == nil && rhs == nil
}

// Equals returns true if all the fields of this ActivityTaskCancelRequestedEventAttributes match the
// provided ActivityTaskCancelRequestedEventAttributes.
//
// This function performs a deep comparison.
func (v *ActivityTaskCancelRequestedEventAttributes) Equals(rhs *ActivityTaskCancelRequestedEventAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.ActivityId, rhs.ActivityId) {
		return false
	}
	if !_I64_EqualsPtr(v.DecisionTaskCompletedEventId, rhs.DecisionTaskCompletedEventId) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ActivityTaskCancelRequestedEventAttributes.
func (v *ActivityTaskCancelRequestedEventAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.ActivityId != nil {
		enc.AddString("activityId", *v.ActivityId)
	}
	if v.DecisionTaskCompletedEventId != nil {
		enc.AddInt64("decisionTaskCompletedEventId", *v.DecisionTaskCompletedEventId)
	}
	return err
}

// GetActivityId returns the value of ActivityId if it is set or its
// zero value if it is unset.
func (v *ActivityTaskCancelRequestedEventAttributes) GetActivityId() (o string) {
	if v != nil && v.ActivityId != nil {
		return *v.ActivityId
	}

	return
}

// IsSetActivityId returns true if ActivityId is not nil.
func (v *ActivityTaskCancelRequestedEventAttributes) IsSetActivityId() bool {
	return v != nil && v.ActivityId != nil
}

// GetDecisionTaskCompletedEventId returns the value of DecisionTaskCompletedEventId if it is set or its
// zero value if it is unset.
func (v *ActivityTaskCancelRequestedEventAttributes) GetDecisionTaskCompletedEventId() (o int64) {
	if v != nil && v.DecisionTaskCompletedEventId != nil {
		return *v.DecisionTaskCompletedEventId
	}

	return
}

// IsSetDecisionTaskCompletedEventId returns true if DecisionTaskCompletedEventId is not nil.
func (v *ActivityTaskCancelRequestedEventAttributes) IsSetDecisionTaskCompletedEventId() bool {
	return v != nil && v.DecisionTaskCompletedEventId != nil
}

type ActivityTaskCanceledEventAttributes struct {
	Details                      []byte  `json:"details,omitempty"`
	LatestCancelRequestedEventId *int64  `json:"latestCancelRequestedEventId,omitempty"`
	ScheduledEventId             *int64  `json:"scheduledEventId,omitempty"`
	StartedEventId               *int64  `json:"startedEventId,omitempty"`
	Identity                     *string `json:"identity,omitempty"`
}

// ToWire translates a ActivityTaskCanceledEventAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ActivityTaskCanceledEventAttributes) ToWire() (wire.Value, error) {
	var (
		fields [5]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Details != nil {
		w, err = wire.NewValueBinary(v.Details), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.LatestCancelRequestedEventId != nil {
		w, err = wire.NewValueI64(*(v.LatestCancelRequestedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.ScheduledEventId != nil {
		w, err = wire.NewValueI64(*(v.ScheduledEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.StartedEventId != nil {
		w, err = wire.NewValueI64(*(v.StartedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.Identity != nil {
		w, err = wire.NewValueString(*(v.Identity)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ActivityTaskCanceledEventAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ActivityTaskCanceledEventAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ActivityTaskCanceledEventAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ActivityTaskCanceledEventAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				v.Details, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.LatestCancelRequestedEventId = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduledEventId = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StartedEventId = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Identity = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ActivityTaskCanceledEventAttributes
// struct.
func (v *ActivityTaskCanceledEventAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [5]string
	i := 0
	if v.Details != nil {
		fields[i] = fmt.Sprintf("Details: %v", v.Details)
		i++
	}
	if v.LatestCancelRequestedEventId != nil {
		fields[i] = fmt.Sprintf("LatestCancelRequestedEventId: %v", *(v.LatestCancelRequestedEventId))
		i++
	}
	if v.ScheduledEventId != nil {
		fields[i] = fmt.Sprintf("ScheduledEventId: %v", *(v.ScheduledEventId))
		i++
	}
	if v.StartedEventId != nil {
		fields[i] = fmt.Sprintf("StartedEventId: %v", *(v.StartedEventId))
		i++
	}
	if v.Identity != nil {
		fields[i] = fmt.Sprintf("Identity: %v", *(v.Identity))
		i++
	}

	return fmt.Sprintf("ActivityTaskCanceledEventAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ActivityTaskCanceledEventAttributes match the
// provided ActivityTaskCanceledEventAttributes.
//
// This function performs a deep comparison.
func (v *ActivityTaskCanceledEventAttributes) Equals(rhs *ActivityTaskCanceledEventAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.Details == nil && rhs.Details == nil) || (v.Details != nil && rhs.Details != nil && bytes.Equal(v.Details, rhs.Details))) {
		return false
	}
	if !_I64_EqualsPtr(v.LatestCancelRequestedEventId, rhs.LatestCancelRequestedEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduledEventId, rhs.ScheduledEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.StartedEventId, rhs.StartedEventId) {
		return false
	}
	if !_String_EqualsPtr(v.Identity, rhs.Identity) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ActivityTaskCanceledEventAttributes.
func (v *ActivityTaskCanceledEventAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Details != nil {
		enc.AddString("details", base64.StdEncoding.EncodeToString(v.Details))
	}
	if v.LatestCancelRequestedEventId != nil {
		enc.AddInt64("latestCancelRequestedEventId", *v.LatestCancelRequestedEventId)
	}
	if v.ScheduledEventId != nil {
		enc.AddInt64("scheduledEventId", *v.ScheduledEventId)
	}
	if v.StartedEventId != nil {
		enc.AddInt64("startedEventId", *v.StartedEventId)
	}
	if v.Identity != nil {
		enc.AddString("identity", *v.Identity)
	}
	return err
}

// GetDetails returns the value of Details if it is set or its
// zero value if it is unset.
func (v *ActivityTaskCanceledEventAttributes) GetDetails() (o []byte) {
	if v != nil && v.Details != nil {
		return v.Details
	}

	return
}

// IsSetDetails returns true if Details is not nil.
func (v *ActivityTaskCanceledEventAttributes) IsSetDetails() bool {
	return v != nil && v.Details != nil
}

// GetLatestCancelRequestedEventId returns the value of LatestCancelRequestedEventId if it is set or its
// zero value if it is unset.
func (v *ActivityTaskCanceledEventAttributes) GetLatestCancelRequestedEventId() (o int64) {
	if v != nil && v.LatestCancelRequestedEventId != nil {
		return *v.LatestCancelRequestedEventId
	}

	return
}

// IsSetLatestCancelRequestedEventId returns true if LatestCancelRequestedEventId is not nil.
func (v *ActivityTaskCanceledEventAttributes) IsSetLatestCancelRequestedEventId() bool {
	return v != nil && v.LatestCancelRequestedEventId != nil
}

// GetScheduledEventId returns the value of ScheduledEventId if it is set or its
// zero value if it is unset.
func (v *ActivityTaskCanceledEventAttributes) GetScheduledEventId() (o int64) {
	if v != nil && v.ScheduledEventId != nil {
		return *v.ScheduledEventId
	}

	return
}

// IsSetScheduledEventId returns true if ScheduledEventId is not nil.
func (v *ActivityTaskCanceledEventAttributes) IsSetScheduledEventId() bool {
	return v != nil && v.ScheduledEventId != nil
}

// GetStartedEventId returns the value of StartedEventId if it is set or its
// zero value if it is unset.
func (v *ActivityTaskCanceledEventAttributes) GetStartedEventId() (o int64) {
	if v != nil && v.StartedEventId != nil {
		return *v.StartedEventId
	}

	return
}

// IsSetStartedEventId returns true if StartedEventId is not nil.
func (v *ActivityTaskCanceledEventAttributes) IsSetStartedEventId() bool {
	return v != nil && v.StartedEventId != nil
}

// GetIdentity returns the value of Identity if it is set or its
// zero value if it is unset.
func (v *ActivityTaskCanceledEventAttributes) GetIdentity() (o string) {
	if v != nil && v.Identity != nil {
		return *v.Identity
	}

	return
}

// IsSetIdentity returns true if Identity is not nil.
func (v *ActivityTaskCanceledEventAttributes) IsSetIdentity() bool {
	return v != nil && v.Identity != nil
}

type ActivityTaskCompletedEventAttributes struct {
	Result           []byte  `json:"result,omitempty"`
	ScheduledEventId *int64  `json:"scheduledEventId,omitempty"`
	StartedEventId   *int64  `json:"startedEventId,omitempty"`
	Identity         *string `json:"identity,omitempty"`
}

// ToWire translates a ActivityTaskCompletedEventAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ActivityTaskCompletedEventAttributes) ToWire() (wire.Value, error) {
	var (
		fields [4]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Result != nil {
		w, err = wire.NewValueBinary(v.Result), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.ScheduledEventId != nil {
		w, err = wire.NewValueI64(*(v.ScheduledEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.StartedEventId != nil {
		w, err = wire.NewValueI64(*(v.StartedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.Identity != nil {
		w, err = wire.NewValueString(*(v.Identity)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ActivityTaskCompletedEventAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ActivityTaskCompletedEventAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ActivityTaskCompletedEventAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ActivityTaskCompletedEventAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				v.Result, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduledEventId = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StartedEventId = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Identity = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ActivityTaskCompletedEventAttributes
// struct.
func (v *ActivityTaskCompletedEventAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [4]string
	i := 0
	if v.Result != nil {
		fields[i] = fmt.Sprintf("Result: %v", v.Result)
		i++
	}
	if v.ScheduledEventId != nil {
		fields[i] = fmt.Sprintf("ScheduledEventId: %v", *(v.ScheduledEventId))
		i++
	}
	if v.StartedEventId != nil {
		fields[i] = fmt.Sprintf("StartedEventId: %v", *(v.StartedEventId))
		i++
	}
	if v.Identity != nil {
		fields[i] = fmt.Sprintf("Identity: %v", *(v.Identity))
		i++
	}

	return fmt.Sprintf("ActivityTaskCompletedEventAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ActivityTaskCompletedEventAttributes match the
// provided ActivityTaskCompletedEventAttributes.
//
// This function performs a deep comparison.
func (v *ActivityTaskCompletedEventAttributes) Equals(rhs *ActivityTaskCompletedEventAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.Result == nil && rhs.Result == nil) || (v.Result != nil && rhs.Result != nil && bytes.Equal(v.Result, rhs.Result))) {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduledEventId, rhs.ScheduledEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.StartedEventId, rhs.StartedEventId) {
		return false
	}
	if !_String_EqualsPtr(v.Identity, rhs.Identity) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ActivityTaskCompletedEventAttributes.
func (v *ActivityTaskCompletedEventAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Result != nil {
		enc.AddString("result", base64.StdEncoding.EncodeToString(v.Result))
	}
	if v.ScheduledEventId != nil {
		enc.AddInt64("scheduledEventId", *v.ScheduledEventId)
	}
	if v.StartedEventId != nil {
		enc.AddInt64("startedEventId", *v.StartedEventId)
	}
	if v.Identity != nil {
		enc.AddString("identity", *v.Identity)
	}
	return err
}

// GetResult returns the value of Result if it is set or its
// zero value if it is unset.
func (v *ActivityTaskCompletedEventAttributes) GetResult() (o []byte) {
	if v != nil && v.Result != nil {
		return v.Result
	}

	return
}

// IsSetResult returns true if Result is not nil.
func (v *ActivityTaskCompletedEventAttributes) IsSetResult() bool {
	return v != nil && v.Result != nil
}

// GetScheduledEventId returns the value of ScheduledEventId if it is set or its
// zero value if it is unset.
func (v *ActivityTaskCompletedEventAttributes) GetScheduledEventId() (o int64) {
	if v != nil && v.ScheduledEventId != nil {
		return *v.ScheduledEventId
	}

	return
}

// IsSetScheduledEventId returns true if ScheduledEventId is not nil.
func (v *ActivityTaskCompletedEventAttributes) IsSetScheduledEventId() bool {
	return v != nil && v.ScheduledEventId != nil
}

// GetStartedEventId returns the value of StartedEventId if it is set or its
// zero value if it is unset.
func (v *ActivityTaskCompletedEventAttributes) GetStartedEventId() (o int64) {
	if v != nil && v.StartedEventId != nil {
		return *v.StartedEventId
	}

	return
}

// IsSetStartedEventId returns true if StartedEventId is not nil.
func (v *ActivityTaskCompletedEventAttributes) IsSetStartedEventId() bool {
	return v != nil && v.StartedEventId != nil
}

// GetIdentity returns the value of Identity if it is set or its
// zero value if it is unset.
func (v *ActivityTaskCompletedEventAttributes) GetIdentity() (o string) {
	if v != nil && v.Identity != nil {
		return *v.Identity
	}

	return
}

// IsSetIdentity returns true if Identity is not nil.
func (v *ActivityTaskCompletedEventAttributes) IsSetIdentity() bool {
	return v != nil && v.Identity != nil
}

type ActivityTaskFailedEventAttributes struct {
	Reason           *string `json:"reason,omitempty"`
	Details          []byte  `json:"details,omitempty"`
	ScheduledEventId *int64  `json:"scheduledEventId,omitempty"`
	StartedEventId   *int64  `json:"startedEventId,omitempty"`
	Identity         *string `json:"identity,omitempty"`
}

// ToWire translates a ActivityTaskFailedEventAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ActivityTaskFailedEventAttributes) ToWire() (wire.Value, error) {
	var (
		fields [5]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Reason != nil {
		w, err = wire.NewValueString(*(v.Reason)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Details != nil {
		w, err = wire.NewValueBinary(v.Details), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.ScheduledEventId != nil {
		w, err = wire.NewValueI64(*(v.ScheduledEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.StartedEventId != nil {
		w, err = wire.NewValueI64(*(v.StartedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.Identity != nil {
		w, err = wire.NewValueString(*(v.Identity)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ActivityTaskFailedEventAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ActivityTaskFailedEventAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ActivityTaskFailedEventAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ActivityTaskFailedEventAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Reason = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				v.Details, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduledEventId = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StartedEventId = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Identity = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ActivityTaskFailedEventAttributes
// struct.
func (v *ActivityTaskFailedEventAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [5]string
	i := 0
	if v.Reason != nil {
		fields[i] = fmt.Sprintf("Reason: %v", *(v.Reason))
		i++
	}
	if v.Details != nil {
		fields[i] = fmt.Sprintf("Details: %v", v.Details)
		i++
	}
	if v.ScheduledEventId != nil {
		fields[i] = fmt.Sprintf("ScheduledEventId: %v", *(v.ScheduledEventId))
		i++
	}
	if v.StartedEventId != nil {
		fields[i] = fmt.Sprintf("StartedEventId: %v", *(v.StartedEventId))
		i++
	}
	if v.Identity != nil {
		fields[i] = fmt.Sprintf("Identity: %v", *(v.Identity))
		i++
	}

	return fmt.Sprintf("ActivityTaskFailedEventAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ActivityTaskFailedEventAttributes match the
// provided ActivityTaskFailedEventAttributes.
//
// This function performs a deep comparison.
func (v *ActivityTaskFailedEventAttributes) Equals(rhs *ActivityTaskFailedEventAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Reason, rhs.Reason) {
		return false
	}
	if !((v.Details == nil && rhs.Details == nil) || (v.Details != nil && rhs.Details != nil && bytes.Equal(v.Details, rhs.Details))) {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduledEventId, rhs.ScheduledEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.StartedEventId, rhs.StartedEventId) {
		return false
	}
	if !_String_EqualsPtr(v.Identity, rhs.Identity) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ActivityTaskFailedEventAttributes.
func (v *ActivityTaskFailedEventAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Reason != nil {
		enc.AddString("reason", *v.Reason)
	}
	if v.Details != nil {
		enc.AddString("details", base64.StdEncoding.EncodeToString(v.Details))
	}
	if v.ScheduledEventId != nil {
		enc.AddInt64("scheduledEventId", *v.ScheduledEventId)
	}
	if v.StartedEventId != nil {
		enc.AddInt64("startedEventId", *v.StartedEventId)
	}
	if v.Identity != nil {
		enc.AddString("identity", *v.Identity)
	}
	return err
}

// GetReason returns the value of Reason if it is set or its
// zero value if it is unset.
func (v *ActivityTaskFailedEventAttributes) GetReason() (o string) {
	if v != nil && v.Reason != nil {
		return *v.Reason
	}

	return
}

// IsSetReason returns true if Reason is not nil.
func (v *ActivityTaskFailedEventAttributes) IsSetReason() bool {
	return v != nil && v.Reason != nil
}

// GetDetails returns the value of Details if it is set or its
// zero value if it is unset.
func (v *ActivityTaskFailedEventAttributes) GetDetails() (o []byte) {
	if v != nil && v.Details != nil {
		return v.Details
	}

	return
}

// IsSetDetails returns true if Details is not nil.
func (v *ActivityTaskFailedEventAttributes) IsSetDetails() bool {
	return v != nil && v.Details != nil
}

// GetScheduledEventId returns the value of ScheduledEventId if it is set or its
// zero value if it is unset.
func (v *ActivityTaskFailedEventAttributes) GetScheduledEventId() (o int64) {
	if v != nil && v.ScheduledEventId != nil {
		return *v.ScheduledEventId
	}

	return
}

// IsSetScheduledEventId returns true if ScheduledEventId is not nil.
func (v *ActivityTaskFailedEventAttributes) IsSetScheduledEventId() bool {
	return v != nil && v.ScheduledEventId != nil
}

// GetStartedEventId returns the value of StartedEventId if it is set or its
// zero value if it is unset.
func (v *ActivityTaskFailedEventAttributes) GetStartedEventId() (o int64) {
	if v != nil && v.StartedEventId != nil {
		return *v.StartedEventId
	}

	return
}

// IsSetStartedEventId returns true if StartedEventId is not nil.
func (v *ActivityTaskFailedEventAttributes) IsSetStartedEventId() bool {
	return v != nil && v.StartedEventId != nil
}

// GetIdentity returns the value of Identity if it is set or its
// zero value if it is unset.
func (v *ActivityTaskFailedEventAttributes) GetIdentity() (o string) {
	if v != nil && v.Identity != nil {
		return *v.Identity
	}

	return
}

// IsSetIdentity returns true if Identity is not nil.
func (v *ActivityTaskFailedEventAttributes) IsSetIdentity() bool {
	return v != nil && v.Identity != nil
}

type ActivityTaskScheduledEventAttributes struct {
	ActivityId                    *string       `json:"activityId,omitempty"`
	ActivityType                  *ActivityType `json:"activityType,omitempty"`
	Domain                        *string       `json:"domain,omitempty"`
	TaskList                      *TaskList     `json:"taskList,omitempty"`
	Input                         []byte        `json:"input,omitempty"`
	ScheduleToCloseTimeoutSeconds *int32        `json:"scheduleToCloseTimeoutSeconds,omitempty"`
	ScheduleToStartTimeoutSeconds *int32        `json:"scheduleToStartTimeoutSeconds,omitempty"`
	StartToCloseTimeoutSeconds    *int32        `json:"startToCloseTimeoutSeconds,omitempty"`
	HeartbeatTimeoutSeconds       *int32        `json:"heartbeatTimeoutSeconds,omitempty"`
	DecisionTaskCompletedEventId  *int64        `json:"decisionTaskCompletedEventId,omitempty"`
	RetryPolicy                   *RetryPolicy  `json:"retryPolicy,omitempty"`
	Header                        *Header       `json:"header,omitempty"`
}

// ToWire translates a ActivityTaskScheduledEventAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ActivityTaskScheduledEventAttributes) ToWire() (wire.Value, error) {
	var (
		fields [12]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.ActivityId != nil {
		w, err = wire.NewValueString(*(v.ActivityId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.ActivityType != nil {
		w, err = v.ActivityType.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 25, Value: w}
		i++
	}
	if v.TaskList != nil {
		w, err = v.TaskList.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.Input != nil {
		w, err = wire.NewValueBinary(v.Input), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.ScheduleToCloseTimeoutSeconds != nil {
		w, err = wire.NewValueI32(*(v.ScheduleToCloseTimeoutSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 45, Value: w}
		i++
	}
	if v.ScheduleToStartTimeoutSeconds != nil {
		w, err = wire.NewValueI32(*(v.ScheduleToStartTimeoutSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.StartToCloseTimeoutSeconds != nil {
		w, err = wire.NewValueI32(*(v.StartToCloseTimeoutSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 55, Value: w}
		i++
	}
	if v.HeartbeatTimeoutSeconds != nil {
		w, err = wire.NewValueI32(*(v.HeartbeatTimeoutSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}
	if v.DecisionTaskCompletedEventId != nil {
		w, err = wire.NewValueI64(*(v.DecisionTaskCompletedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 90, Value: w}
		i++
	}
	if v.RetryPolicy != nil {
		w, err = v.RetryPolicy.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 110, Value: w}
		i++
	}
	if v.Header != nil {
		w, err = v.Header.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 120, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _ActivityType_Read(w wire.Value) (*ActivityType, error) {
	var v ActivityType
	err := v.FromWire(w)
	return &v, err
}

func _TaskList_Read(w wire.Value) (*TaskList, error) {
	var v TaskList
	err := v.FromWire(w)
	return &v, err
}

func _RetryPolicy_Read(w wire.Value) (*RetryPolicy, error) {
	var v RetryPolicy
	err := v.FromWire(w)
	return &v, err
}

func _Header_Read(w wire.Value) (*Header, error) {
	var v Header
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a ActivityTaskScheduledEventAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ActivityTaskScheduledEventAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ActivityTaskScheduledEventAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ActivityTaskScheduledEventAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ActivityId = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.ActivityType, err = _ActivityType_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 25:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TStruct {
				v.TaskList, err = _TaskList_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBinary {
				v.Input, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 45:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.ScheduleToCloseTimeoutSeconds = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.ScheduleToStartTimeoutSeconds = &x
				if err != nil {
					return err
				}

			}
		case 55:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.StartToCloseTimeoutSeconds = &x
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.HeartbeatTimeoutSeconds = &x
				if err != nil {
					return err
				}

			}
		case 90:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.DecisionTaskCompletedEventId = &x
				if err != nil {
					return err
				}

			}
		case 110:
			if field.Value.Type() == wire.TStruct {
				v.RetryPolicy, err = _RetryPolicy_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 120:
			if field.Value.Type() == wire.TStruct {
				v.Header, err = _Header_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ActivityTaskScheduledEventAttributes
// struct.
func (v *ActivityTaskScheduledEventAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [12]string
	i := 0
	if v.ActivityId != nil {
		fields[i] = fmt.Sprintf("ActivityId: %v", *(v.ActivityId))
		i++
	}
	if v.ActivityType != nil {
		fields[i] = fmt.Sprintf("ActivityType: %v", v.ActivityType)
		i++
	}
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.TaskList != nil {
		fields[i] = fmt.Sprintf("TaskList: %v", v.TaskList)
		i++
	}
	if v.Input != nil {
		fields[i] = fmt.Sprintf("Input: %v", v.Input)
		i++
	}
	if v.ScheduleToCloseTimeoutSeconds != nil {
		fields[i] = fmt.Sprintf("ScheduleToCloseTimeoutSeconds: %v", *(v.ScheduleToCloseTimeoutSeconds))
		i++
	}
	if v.ScheduleToStartTimeoutSeconds != nil {
		fields[i] = fmt.Sprintf("ScheduleToStartTimeoutSeconds: %v", *(v.ScheduleToStartTimeoutSeconds))
		i++
	}
	if v.StartToCloseTimeoutSeconds != nil {
		fields[i] = fmt.Sprintf("StartToCloseTimeoutSeconds: %v", *(v.StartToCloseTimeoutSeconds))
		i++
	}
	if v.HeartbeatTimeoutSeconds != nil {
		fields[i] = fmt.Sprintf("HeartbeatTimeoutSeconds: %v", *(v.HeartbeatTimeoutSeconds))
		i++
	}
	if v.DecisionTaskCompletedEventId != nil {
		fields[i] = fmt.Sprintf("DecisionTaskCompletedEventId: %v", *(v.DecisionTaskCompletedEventId))
		i++
	}
	if v.RetryPolicy != nil {
		fields[i] = fmt.Sprintf("RetryPolicy: %v", v.RetryPolicy)
		i++
	}
	if v.Header != nil {
		fields[i] = fmt.Sprintf("Header: %v", v.Header)
		i++
	}

	return fmt.Sprintf("ActivityTaskScheduledEventAttributes{%v}", strings.Join(fields[:i], ", "))
}

func _I32_EqualsPtr(lhs, rhs *int32) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return (x == y)
	}
	return lhs == nil && rhs == nil
}

// Equals returns true if all the fields of this ActivityTaskScheduledEventAttributes match the
// provided ActivityTaskScheduledEventAttributes.
//
// This function performs a deep comparison.
func (v *ActivityTaskScheduledEventAttributes) Equals(rhs *ActivityTaskScheduledEventAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.ActivityId, rhs.ActivityId) {
		return false
	}
	if !((v.ActivityType == nil && rhs.ActivityType == nil) || (v.ActivityType != nil && rhs.ActivityType != nil && v.ActivityType.Equals(rhs.ActivityType))) {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !((v.TaskList == nil && rhs.TaskList == nil) || (v.TaskList != nil && rhs.TaskList != nil && v.TaskList.Equals(rhs.TaskList))) {
		return false
	}
	if !((v.Input == nil && rhs.Input == nil) || (v.Input != nil && rhs.Input != nil && bytes.Equal(v.Input, rhs.Input))) {
		return false
	}
	if !_I32_EqualsPtr(v.ScheduleToCloseTimeoutSeconds, rhs.ScheduleToCloseTimeoutSeconds) {
		return false
	}
	if !_I32_EqualsPtr(v.ScheduleToStartTimeoutSeconds, rhs.ScheduleToStartTimeoutSeconds) {
		return false
	}
	if !_I32_EqualsPtr(v.StartToCloseTimeoutSeconds, rhs.StartToCloseTimeoutSeconds) {
		return false
	}
	if !_I32_EqualsPtr(v.HeartbeatTimeoutSeconds, rhs.HeartbeatTimeoutSeconds) {
		return false
	}
	if !_I64_EqualsPtr(v.DecisionTaskCompletedEventId, rhs.DecisionTaskCompletedEventId) {
		return false
	}
	if !((v.RetryPolicy == nil && rhs.RetryPolicy == nil) || (v.RetryPolicy != nil && rhs.RetryPolicy != nil && v.RetryPolicy.Equals(rhs.RetryPolicy))) {
		return false
	}
	if !((v.Header == nil && rhs.Header == nil) || (v.Header != nil && rhs.Header != nil && v.Header.Equals(rhs.Header))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ActivityTaskScheduledEventAttributes.
func (v *ActivityTaskScheduledEventAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.ActivityId != nil {
		enc.AddString("activityId", *v.ActivityId)
	}
	if v.ActivityType != nil {
		err = multierr.Append(err, enc.AddObject("activityType", v.ActivityType))
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.TaskList != nil {
		err = multierr.Append(err, enc.AddObject("taskList", v.TaskList))
	}
	if v.Input != nil {
		enc.AddString("input", base64.StdEncoding.EncodeToString(v.Input))
	}
	if v.ScheduleToCloseTimeoutSeconds != nil {
		enc.AddInt32("scheduleToCloseTimeoutSeconds", *v.ScheduleToCloseTimeoutSeconds)
	}
	if v.ScheduleToStartTimeoutSeconds != nil {
		enc.AddInt32("scheduleToStartTimeoutSeconds", *v.ScheduleToStartTimeoutSeconds)
	}
	if v.StartToCloseTimeoutSeconds != nil {
		enc.AddInt32("startToCloseTimeoutSeconds", *v.StartToCloseTimeoutSeconds)
	}
	if v.HeartbeatTimeoutSeconds != nil {
		enc.AddInt32("heartbeatTimeoutSeconds", *v.HeartbeatTimeoutSeconds)
	}
	if v.DecisionTaskCompletedEventId != nil {
		enc.AddInt64("decisionTaskCompletedEventId", *v.DecisionTaskCompletedEventId)
	}
	if v.RetryPolicy != nil {
		err = multierr.Append(err, enc.AddObject("retryPolicy", v.RetryPolicy))
	}
	if v.Header != nil {
		err = multierr.Append(err, enc.AddObject("header", v.Header))
	}
	return err
}

// GetActivityId returns the value of ActivityId if it is set or its
// zero value if it is unset.
func (v *ActivityTaskScheduledEventAttributes) GetActivityId() (o string) {
	if v != nil && v.ActivityId != nil {
		return *v.ActivityId
	}

	return
}

// IsSetActivityId returns true if ActivityId is not nil.
func (v *ActivityTaskScheduledEventAttributes) IsSetActivityId() bool {
	return v != nil && v.ActivityId != nil
}

// GetActivityType returns the value of ActivityType if it is set or its
// zero value if it is unset.
func (v *ActivityTaskScheduledEventAttributes) GetActivityType() (o *ActivityType) {
	if v != nil && v.ActivityType != nil {
		return v.ActivityType
	}

	return
}

// IsSetActivityType returns true if ActivityType is not nil.
func (v *ActivityTaskScheduledEventAttributes) IsSetActivityType() bool {
	return v != nil && v.ActivityType != nil
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *ActivityTaskScheduledEventAttributes) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *ActivityTaskScheduledEventAttributes) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetTaskList returns the value of TaskList if it is set or its
// zero value if it is unset.
func (v *ActivityTaskScheduledEventAttributes) GetTaskList() (o *TaskList) {
	if v != nil && v.TaskList != nil {
		return v.TaskList
	}

	return
}

// IsSetTaskList returns true if TaskList is not nil.
func (v *ActivityTaskScheduledEventAttributes) IsSetTaskList() bool {
	return v != nil && v.TaskList != nil
}

// GetInput returns the value of Input if it is set or its
// zero value if it is unset.
func (v *ActivityTaskScheduledEventAttributes) GetInput() (o []byte) {
	if v != nil && v.Input != nil {
		return v.Input
	}

	return
}

// IsSetInput returns true if Input is not nil.
func (v *ActivityTaskScheduledEventAttributes) IsSetInput() bool {
	return v != nil && v.Input != nil
}

// GetScheduleToCloseTimeoutSeconds returns the value of ScheduleToCloseTimeoutSeconds if it is set or its
// zero value if it is unset.
func (v *ActivityTaskScheduledEventAttributes) GetScheduleToCloseTimeoutSeconds() (o int32) {
	if v != nil && v.ScheduleToCloseTimeoutSeconds != nil {
		return *v.ScheduleToCloseTimeoutSeconds
	}

	return
}

// IsSetScheduleToCloseTimeoutSeconds returns true if ScheduleToCloseTimeoutSeconds is not nil.
func (v *ActivityTaskScheduledEventAttributes) IsSetScheduleToCloseTimeoutSeconds() bool {
	return v != nil && v.ScheduleToCloseTimeoutSeconds != nil
}

// GetScheduleToStartTimeoutSeconds returns the value of ScheduleToStartTimeoutSeconds if it is set or its
// zero value if it is unset.
func (v *ActivityTaskScheduledEventAttributes) GetScheduleToStartTimeoutSeconds() (o int32) {
	if v != nil && v.ScheduleToStartTimeoutSeconds != nil {
		return *v.ScheduleToStartTimeoutSeconds
	}

	return
}

// IsSetScheduleToStartTimeoutSeconds returns true if ScheduleToStartTimeoutSeconds is not nil.
func (v *ActivityTaskScheduledEventAttributes) IsSetScheduleToStartTimeoutSeconds() bool {
	return v != nil && v.ScheduleToStartTimeoutSeconds != nil
}

// GetStartToCloseTimeoutSeconds returns the value of StartToCloseTimeoutSeconds if it is set or its
// zero value if it is unset.
func (v *ActivityTaskScheduledEventAttributes) GetStartToCloseTimeoutSeconds() (o int32) {
	if v != nil && v.StartToCloseTimeoutSeconds != nil {
		return *v.StartToCloseTimeoutSeconds
	}

	return
}

// IsSetStartToCloseTimeoutSeconds returns true if StartToCloseTimeoutSeconds is not nil.
func (v *ActivityTaskScheduledEventAttributes) IsSetStartToCloseTimeoutSeconds() bool {
	return v != nil && v.StartToCloseTimeoutSeconds != nil
}

// GetHeartbeatTimeoutSeconds returns the value of HeartbeatTimeoutSeconds if it is set or its
// zero value if it is unset.
func (v *ActivityTaskScheduledEventAttributes) GetHeartbeatTimeoutSeconds() (o int32) {
	if v != nil && v.HeartbeatTimeoutSeconds != nil {
		return *v.HeartbeatTimeoutSeconds
	}

	return
}

// IsSetHeartbeatTimeoutSeconds returns true if HeartbeatTimeoutSeconds is not nil.
func (v *ActivityTaskScheduledEventAttributes) IsSetHeartbeatTimeoutSeconds() bool {
	return v != nil && v.HeartbeatTimeoutSeconds != nil
}

// GetDecisionTaskCompletedEventId returns the value of DecisionTaskCompletedEventId if it is set or its
// zero value if it is unset.
func (v *ActivityTaskScheduledEventAttributes) GetDecisionTaskCompletedEventId() (o int64) {
	if v != nil && v.DecisionTaskCompletedEventId != nil {
		return *v.DecisionTaskCompletedEventId
	}

	return
}

// IsSetDecisionTaskCompletedEventId returns true if DecisionTaskCompletedEventId is not nil.
func (v *ActivityTaskScheduledEventAttributes) IsSetDecisionTaskCompletedEventId() bool {
	return v != nil && v.DecisionTaskCompletedEventId != nil
}

// GetRetryPolicy returns the value of RetryPolicy if it is set or its
// zero value if it is unset.
func (v *ActivityTaskScheduledEventAttributes) GetRetryPolicy() (o *RetryPolicy) {
	if v != nil && v.RetryPolicy != nil {
		return v.RetryPolicy
	}

	return
}

// IsSetRetryPolicy returns true if RetryPolicy is not nil.
func (v *ActivityTaskScheduledEventAttributes) IsSetRetryPolicy() bool {
	return v != nil && v.RetryPolicy != nil
}

// GetHeader returns the value of Header if it is set or its
// zero value if it is unset.
func (v *ActivityTaskScheduledEventAttributes) GetHeader() (o *Header) {
	if v != nil && v.Header != nil {
		return v.Header
	}

	return
}

// IsSetHeader returns true if Header is not nil.
func (v *ActivityTaskScheduledEventAttributes) IsSetHeader() bool {
	return v != nil && v.Header != nil
}

type ActivityTaskStartedEventAttributes struct {
	ScheduledEventId *int64  `json:"scheduledEventId,omitempty"`
	Identity         *string `json:"identity,omitempty"`
	RequestId        *string `json:"requestId,omitempty"`
	Attempt          *int32  `json:"attempt,omitempty"`
}

// ToWire translates a ActivityTaskStartedEventAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ActivityTaskStartedEventAttributes) ToWire() (wire.Value, error) {
	var (
		fields [4]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.ScheduledEventId != nil {
		w, err = wire.NewValueI64(*(v.ScheduledEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Identity != nil {
		w, err = wire.NewValueString(*(v.Identity)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.RequestId != nil {
		w, err = wire.NewValueString(*(v.RequestId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.Attempt != nil {
		w, err = wire.NewValueI32(*(v.Attempt)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ActivityTaskStartedEventAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ActivityTaskStartedEventAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ActivityTaskStartedEventAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ActivityTaskStartedEventAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduledEventId = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Identity = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.RequestId = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.Attempt = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ActivityTaskStartedEventAttributes
// struct.
func (v *ActivityTaskStartedEventAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [4]string
	i := 0
	if v.ScheduledEventId != nil {
		fields[i] = fmt.Sprintf("ScheduledEventId: %v", *(v.ScheduledEventId))
		i++
	}
	if v.Identity != nil {
		fields[i] = fmt.Sprintf("Identity: %v", *(v.Identity))
		i++
	}
	if v.RequestId != nil {
		fields[i] = fmt.Sprintf("RequestId: %v", *(v.RequestId))
		i++
	}
	if v.Attempt != nil {
		fields[i] = fmt.Sprintf("Attempt: %v", *(v.Attempt))
		i++
	}

	return fmt.Sprintf("ActivityTaskStartedEventAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ActivityTaskStartedEventAttributes match the
// provided ActivityTaskStartedEventAttributes.
//
// This function performs a deep comparison.
func (v *ActivityTaskStartedEventAttributes) Equals(rhs *ActivityTaskStartedEventAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduledEventId, rhs.ScheduledEventId) {
		return false
	}
	if !_String_EqualsPtr(v.Identity, rhs.Identity) {
		return false
	}
	if !_String_EqualsPtr(v.RequestId, rhs.RequestId) {
		return false
	}
	if !_I32_EqualsPtr(v.Attempt, rhs.Attempt) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ActivityTaskStartedEventAttributes.
func (v *ActivityTaskStartedEventAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.ScheduledEventId != nil {
		enc.AddInt64("scheduledEventId", *v.ScheduledEventId)
	}
	if v.Identity != nil {
		enc.AddString("identity", *v.Identity)
	}
	if v.RequestId != nil {
		enc.AddString("requestId", *v.RequestId)
	}
	if v.Attempt != nil {
		enc.AddInt32("attempt", *v.Attempt)
	}
	return err
}

// GetScheduledEventId returns the value of ScheduledEventId if it is set or its
// zero value if it is unset.
func (v *ActivityTaskStartedEventAttributes) GetScheduledEventId() (o int64) {
	if v != nil && v.ScheduledEventId != nil {
		return *v.ScheduledEventId
	}

	return
}

// IsSetScheduledEventId returns true if ScheduledEventId is not nil.
func (v *ActivityTaskStartedEventAttributes) IsSetScheduledEventId() bool {
	return v != nil && v.ScheduledEventId != nil
}

// GetIdentity returns the value of Identity if it is set or its
// zero value if it is unset.
func (v *ActivityTaskStartedEventAttributes) GetIdentity() (o string) {
	if v != nil && v.Identity != nil {
		return *v.Identity
	}

	return
}

// IsSetIdentity returns true if Identity is not nil.
func (v *ActivityTaskStartedEventAttributes) IsSetIdentity() bool {
	return v != nil && v.Identity != nil
}

// GetRequestId returns the value of RequestId if it is set or its
// zero value if it is unset.
func (v *ActivityTaskStartedEventAttributes) GetRequestId() (o string) {
	if v != nil && v.RequestId != nil {
		return *v.RequestId
	}

	return
}

// IsSetRequestId returns true if RequestId is not nil.
func (v *ActivityTaskStartedEventAttributes) IsSetRequestId() bool {
	return v != nil && v.RequestId != nil
}

// GetAttempt returns the value of Attempt if it is set or its
// zero value if it is unset.
func (v *ActivityTaskStartedEventAttributes) GetAttempt() (o int32) {
	if v != nil && v.Attempt != nil {
		return *v.Attempt
	}

	return
}

// IsSetAttempt returns true if Attempt is not nil.
func (v *ActivityTaskStartedEventAttributes) IsSetAttempt() bool {
	return v != nil && v.Attempt != nil
}

type ActivityTaskTimedOutEventAttributes struct {
	Details          []byte       `json:"details,omitempty"`
	ScheduledEventId *int64       `json:"scheduledEventId,omitempty"`
	StartedEventId   *int64       `json:"startedEventId,omitempty"`
	TimeoutType      *TimeoutType `json:"timeoutType,omitempty"`
}

// ToWire translates a ActivityTaskTimedOutEventAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ActivityTaskTimedOutEventAttributes) ToWire() (wire.Value, error) {
	var (
		fields [4]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Details != nil {
		w, err = wire.NewValueBinary(v.Details), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 5, Value: w}
		i++
	}
	if v.ScheduledEventId != nil {
		w, err = wire.NewValueI64(*(v.ScheduledEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.StartedEventId != nil {
		w, err = wire.NewValueI64(*(v.StartedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.TimeoutType != nil {
		w, err = v.TimeoutType.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _TimeoutType_Read(w wire.Value) (TimeoutType, error) {
	var v TimeoutType
	err := v.FromWire(w)
	return v, err
}

// FromWire deserializes a ActivityTaskTimedOutEventAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ActivityTaskTimedOutEventAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ActivityTaskTimedOutEventAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ActivityTaskTimedOutEventAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 5:
			if field.Value.Type() == wire.TBinary {
				v.Details, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 10:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduledEventId = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StartedEventId = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI32 {
				var x TimeoutType
				x, err = _TimeoutType_Read(field.Value)
				v.TimeoutType = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ActivityTaskTimedOutEventAttributes
// struct.
func (v *ActivityTaskTimedOutEventAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [4]string
	i := 0
	if v.Details != nil {
		fields[i] = fmt.Sprintf("Details: %v", v.Details)
		i++
	}
	if v.ScheduledEventId != nil {
		fields[i] = fmt.Sprintf("ScheduledEventId: %v", *(v.ScheduledEventId))
		i++
	}
	if v.StartedEventId != nil {
		fields[i] = fmt.Sprintf("StartedEventId: %v", *(v.StartedEventId))
		i++
	}
	if v.TimeoutType != nil {
		fields[i] = fmt.Sprintf("TimeoutType: %v", *(v.TimeoutType))
		i++
	}

	return fmt.Sprintf("ActivityTaskTimedOutEventAttributes{%v}", strings.Join(fields[:i], ", "))
}

func _TimeoutType_EqualsPtr(lhs, rhs *TimeoutType) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return x.Equals(y)
	}
	return lhs == nil && rhs == nil
}

// Equals returns true if all the fields of this ActivityTaskTimedOutEventAttributes match the
// provided ActivityTaskTimedOutEventAttributes.
//
// This function performs a deep comparison.
func (v *ActivityTaskTimedOutEventAttributes) Equals(rhs *ActivityTaskTimedOutEventAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.Details == nil && rhs.Details == nil) || (v.Details != nil && rhs.Details != nil && bytes.Equal(v.Details, rhs.Details))) {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduledEventId, rhs.ScheduledEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.StartedEventId, rhs.StartedEventId) {
		return false
	}
	if !_TimeoutType_EqualsPtr(v.TimeoutType, rhs.TimeoutType) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ActivityTaskTimedOutEventAttributes.
func (v *ActivityTaskTimedOutEventAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Details != nil {
		enc.AddString("details", base64.StdEncoding.EncodeToString(v.Details))
	}
	if v.ScheduledEventId != nil {
		enc.AddInt64("scheduledEventId", *v.ScheduledEventId)
	}
	if v.StartedEventId != nil {
		enc.AddInt64("startedEventId", *v.StartedEventId)
	}
	if v.TimeoutType != nil {
		err = multierr.Append(err, enc.AddObject("timeoutType", *v.TimeoutType))
	}
	return err
}

// GetDetails returns the value of Details if it is set or its
// zero value if it is unset.
func (v *ActivityTaskTimedOutEventAttributes) GetDetails() (o []byte) {
	if v != nil && v.Details != nil {
		return v.Details
	}

	return
}

// IsSetDetails returns true if Details is not nil.
func (v *ActivityTaskTimedOutEventAttributes) IsSetDetails() bool {
	return v != nil && v.Details != nil
}

// GetScheduledEventId returns the value of ScheduledEventId if it is set or its
// zero value if it is unset.
func (v *ActivityTaskTimedOutEventAttributes) GetScheduledEventId() (o int64) {
	if v != nil && v.ScheduledEventId != nil {
		return *v.ScheduledEventId
	}

	return
}

// IsSetScheduledEventId returns true if ScheduledEventId is not nil.
func (v *ActivityTaskTimedOutEventAttributes) IsSetScheduledEventId() bool {
	return v != nil && v.ScheduledEventId != nil
}

// GetStartedEventId returns the value of StartedEventId if it is set or its
// zero value if it is unset.
func (v *ActivityTaskTimedOutEventAttributes) GetStartedEventId() (o int64) {
	if v != nil && v.StartedEventId != nil {
		return *v.StartedEventId
	}

	return
}

// IsSetStartedEventId returns true if StartedEventId is not nil.
func (v *ActivityTaskTimedOutEventAttributes) IsSetStartedEventId() bool {
	return v != nil && v.StartedEventId != nil
}

// GetTimeoutType returns the value of TimeoutType if it is set or its
// zero value if it is unset.
func (v *ActivityTaskTimedOutEventAttributes) GetTimeoutType() (o TimeoutType) {
	if v != nil && v.TimeoutType != nil {
		return *v.TimeoutType
	}

	return
}

// IsSetTimeoutType returns true if TimeoutType is not nil.
func (v *ActivityTaskTimedOutEventAttributes) IsSetTimeoutType() bool {
	return v != nil && v.TimeoutType != nil
}

type ActivityType struct {
	Name *string `json:"name,omitempty"`
}

// ToWire translates a ActivityType struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ActivityType) ToWire() (wire.Value, error) {
	var (
		fields [1]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Name != nil {
		w, err = wire.NewValueString(*(v.Name)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ActivityType struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ActivityType struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ActivityType
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ActivityType) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Name = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ActivityType
// struct.
func (v *ActivityType) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [1]string
	i := 0
	if v.Name != nil {
		fields[i] = fmt.Sprintf("Name: %v", *(v.Name))
		i++
	}

	return fmt.Sprintf("ActivityType{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ActivityType match the
// provided ActivityType.
//
// This function performs a deep comparison.
func (v *ActivityType) Equals(rhs *ActivityType) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Name, rhs.Name) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ActivityType.
func (v *ActivityType) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Name != nil {
		enc.AddString("name", *v.Name)
	}
	return err
}

// GetName returns the value of Name if it is set or its
// zero value if it is unset.
func (v *ActivityType) GetName() (o string) {
	if v != nil && v.Name != nil {
		return *v.Name
	}

	return
}

// IsSetName returns true if Name is not nil.
func (v *ActivityType) IsSetName() bool {
	return v != nil && v.Name != nil
}

type ArchivalStatus int32

const (
	ArchivalStatusDisabled ArchivalStatus = 0
	ArchivalStatusEnabled  ArchivalStatus = 1
)

// ArchivalStatus_Values returns all recognized values of ArchivalStatus.
func ArchivalStatus_Values() []ArchivalStatus {
	return []ArchivalStatus{
		ArchivalStatusDisabled,
		ArchivalStatusEnabled,
	}
}

// UnmarshalText tries to decode ArchivalStatus from a byte slice
// containing its name.
//
//   var v ArchivalStatus
//   err := v.UnmarshalText([]byte("DISABLED"))
func (v *ArchivalStatus) UnmarshalText(value []byte) error {
	switch s := string(value); s {
	case "DISABLED":
		*v = ArchivalStatusDisabled
		return nil
	case "ENABLED":
		*v = ArchivalStatusEnabled
		return nil
	default:
		val, err := strconv.ParseInt(s, 10, 32)
		if err != nil {
			return fmt.Errorf("unknown enum value %q for %q: %v", s, "ArchivalStatus", err)
		}
		*v = ArchivalStatus(val)
		return nil
	}
}

// MarshalText encodes ArchivalStatus to text.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements the TextMarshaler interface.
func (v ArchivalStatus) MarshalText() ([]byte, error) {
	switch int32(v) {
	case 0:
		return []byte("DISABLED"), nil
	case 1:
		return []byte("ENABLED"), nil
	}
	return []byte(strconv.FormatInt(int64(v), 10)), nil
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ArchivalStatus.
// Enums are logged as objects, where the value is logged with key "value", and
// if this value's name is known, the name is logged with key "name".
func (v ArchivalStatus) MarshalLogObject(enc zapcore.ObjectEncoder) error {
	enc.AddInt32("value", int32(v))
	switch int32(v) {
	case 0:
		enc.AddString("name", "DISABLED")
	case 1:
		enc.AddString("name", "ENABLED")
	}
	return nil
}

// Ptr returns a pointer to this enum value.
func (v ArchivalStatus) Ptr() *ArchivalStatus {
	return &v
}

// ToWire translates ArchivalStatus into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// Enums are represented as 32-bit integers over the wire.
func (v ArchivalStatus) ToWire() (wire.Value, error) {
	return wire.NewValueI32(int32(v)), nil
}

// FromWire deserializes ArchivalStatus from its Thrift-level
// representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TI32)
//   if err != nil {
//     return ArchivalStatus(0), err
//   }
//
//   var v ArchivalStatus
//   if err := v.FromWire(x); err != nil {
//     return ArchivalStatus(0), err
//   }
//   return v, nil
func (v *ArchivalStatus) FromWire(w wire.Value) error {
	*v = (ArchivalStatus)(w.GetI32())
	return nil
}

// String returns a readable string representation of ArchivalStatus.
func (v ArchivalStatus) String() string {
	w := int32(v)
	switch w {
	case 0:
		return "DISABLED"
	case 1:
		return "ENABLED"
	}
	return fmt.Sprintf("ArchivalStatus(%d)", w)
}

// Equals returns true if this ArchivalStatus value matches the provided
// value.
func (v ArchivalStatus) Equals(rhs ArchivalStatus) bool {
	return v == rhs
}

// MarshalJSON serializes ArchivalStatus into JSON.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements json.Marshaler.
func (v ArchivalStatus) MarshalJSON() ([]byte, error) {
	switch int32(v) {
	case 0:
		return ([]byte)("\"DISABLED\""), nil
	case 1:
		return ([]byte)("\"ENABLED\""), nil
	}
	return ([]byte)(strconv.FormatInt(int64(v), 10)), nil
}

// UnmarshalJSON attempts to decode ArchivalStatus from its JSON
// representation.
//
// This implementation supports both, numeric and string inputs. If a
// string is provided, it must be a known enum name.
//
// This implements json.Unmarshaler.
func (v *ArchivalStatus) UnmarshalJSON(text []byte) error {
	d := json.NewDecoder(bytes.NewReader(text))
	d.UseNumber()
	t, err := d.Token()
	if err != nil {
		return err
	}

	switch w := t.(type) {
	case json.Number:
		x, err := w.Int64()
		if err != nil {
			return err
		}
		if x > math.MaxInt32 {
			return fmt.Errorf("enum overflow from JSON %q for %q", text, "ArchivalStatus")
		}
		if x < math.MinInt32 {
			return fmt.Errorf("enum underflow from JSON %q for %q", text, "ArchivalStatus")
		}
		*v = (ArchivalStatus)(x)
		return nil
	case string:
		return v.UnmarshalText([]byte(w))
	default:
		return fmt.Errorf("invalid JSON value %q (%T) to unmarshal into %q", t, t, "ArchivalStatus")
	}
}

type BadBinaries struct {
	Binaries map[string]*BadBinaryInfo `json:"binaries,omitempty"`
}

type _Map_String_BadBinaryInfo_MapItemList map[string]*BadBinaryInfo

func (m _Map_String_BadBinaryInfo_MapItemList) ForEach(f func(wire.MapItem) error) error {
	for k, v := range m {
		if v == nil {
			return fmt.Errorf("invalid [%v]: value is nil", k)
		}
		kw, err := wire.NewValueString(k), error(nil)
		if err != nil {
			return err
		}

		vw, err := v.ToWire()
		if err != nil {
			return err
		}
		err = f(wire.MapItem{Key: kw, Value: vw})
		if err != nil {
			return err
		}
	}
	return nil
}

func (m _Map_String_BadBinaryInfo_MapItemList) Size() int {
	return len(m)
}

func (_Map_String_BadBinaryInfo_MapItemList) KeyType() wire.Type {
	return wire.TBinary
}

func (_Map_String_BadBinaryInfo_MapItemList) ValueType() wire.Type {
	return wire.TStruct
}

func (_Map_String_BadBinaryInfo_MapItemList) Close() {}

// ToWire translates a BadBinaries struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *BadBinaries) ToWire() (wire.Value, error) {
	var (
		fields [1]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Binaries != nil {
		w, err = wire.NewValueMap(_Map_String_BadBinaryInfo_MapItemList(v.Binaries)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _BadBinaryInfo_Read(w wire.Value) (*BadBinaryInfo, error) {
	var v BadBinaryInfo
	err := v.FromWire(w)
	return &v, err
}

func _Map_String_BadBinaryInfo_Read(m wire.MapItemList) (map[string]*BadBinaryInfo, error) {
	if m.KeyType() != wire.TBinary {
		return nil, nil
	}

	if m.ValueType() != wire.TStruct {
		return nil, nil
	}

	o := make(map[string]*BadBinaryInfo, m.Size())
	err := m.ForEach(func(x wire.MapItem) error {
		k, err := x.Key.GetString(), error(nil)
		if err != nil {
			return err
		}

		v, err := _BadBinaryInfo_Read(x.Value)
		if err != nil {
			return err
		}

		o[k] = v
		return nil
	})
	m.Close()
	return o, err
}

// FromWire deserializes a BadBinaries struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a BadBinaries struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v BadBinaries
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *BadBinaries) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TMap {
				v.Binaries, err = _Map_String_BadBinaryInfo_Read(field.Value.GetMap())
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a BadBinaries
// struct.
func (v *BadBinaries) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [1]string
	i := 0
	if v.Binaries != nil {
		fields[i] = fmt.Sprintf("Binaries: %v", v.Binaries)
		i++
	}

	return fmt.Sprintf("BadBinaries{%v}", strings.Join(fields[:i], ", "))
}

func _Map_String_BadBinaryInfo_Equals(lhs, rhs map[string]*BadBinaryInfo) bool {
	if len(lhs) != len(rhs) {
		return false
	}

	for lk, lv := range lhs {
		rv, ok := rhs[lk]
		if !ok {
			return false
		}
		if !lv.Equals(rv) {
			return false
		}
	}
	return true
}

// Equals returns true if all the fields of this BadBinaries match the
// provided BadBinaries.
//
// This function performs a deep comparison.
func (v *BadBinaries) Equals(rhs *BadBinaries) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.Binaries == nil && rhs.Binaries == nil) || (v.Binaries != nil && rhs.Binaries != nil && _Map_String_BadBinaryInfo_Equals(v.Binaries, rhs.Binaries))) {
		return false
	}

	return true
}

type _Map_String_BadBinaryInfo_Zapper map[string]*BadBinaryInfo

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of _Map_String_BadBinaryInfo_Zapper.
func (m _Map_String_BadBinaryInfo_Zapper) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	for k, v := range m {
		err = multierr.Append(err, enc.AddObject((string)(k), v))
	}
	return err
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of BadBinaries.
func (v *BadBinaries) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Binaries != nil {
		err = multierr.Append(err, enc.AddObject("binaries", (_Map_String_BadBinaryInfo_Zapper)(v.Binaries)))
	}
	return err
}

// GetBinaries returns the value of Binaries if it is set or its
// zero value if it is unset.
func (v *BadBinaries) GetBinaries() (o map[string]*BadBinaryInfo) {
	if v != nil && v.Binaries != nil {
		return v.Binaries
	}

	return
}

// IsSetBinaries returns true if Binaries is not nil.
func (v *BadBinaries) IsSetBinaries() bool {
	return v != nil && v.Binaries != nil
}

type BadBinaryInfo struct {
	Reason          *string `json:"reason,omitempty"`
	Operator        *string `json:"operator,omitempty"`
	CreatedTimeNano *int64  `json:"createdTimeNano,omitempty"`
}

// ToWire translates a BadBinaryInfo struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *BadBinaryInfo) ToWire() (wire.Value, error) {
	var (
		fields [3]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Reason != nil {
		w, err = wire.NewValueString(*(v.Reason)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Operator != nil {
		w, err = wire.NewValueString(*(v.Operator)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.CreatedTimeNano != nil {
		w, err = wire.NewValueI64(*(v.CreatedTimeNano)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a BadBinaryInfo struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a BadBinaryInfo struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v BadBinaryInfo
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *BadBinaryInfo) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Reason = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Operator = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.CreatedTimeNano = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a BadBinaryInfo
// struct.
func (v *BadBinaryInfo) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [3]string
	i := 0
	if v.Reason != nil {
		fields[i] = fmt.Sprintf("Reason: %v", *(v.Reason))
		i++
	}
	if v.Operator != nil {
		fields[i] = fmt.Sprintf("Operator: %v", *(v.Operator))
		i++
	}
	if v.CreatedTimeNano != nil {
		fields[i] = fmt.Sprintf("CreatedTimeNano: %v", *(v.CreatedTimeNano))
		i++
	}

	return fmt.Sprintf("BadBinaryInfo{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this BadBinaryInfo match the
// provided BadBinaryInfo.
//
// This function performs a deep comparison.
func (v *BadBinaryInfo) Equals(rhs *BadBinaryInfo) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Reason, rhs.Reason) {
		return false
	}
	if !_String_EqualsPtr(v.Operator, rhs.Operator) {
		return false
	}
	if !_I64_EqualsPtr(v.CreatedTimeNano, rhs.CreatedTimeNano) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of BadBinaryInfo.
func (v *BadBinaryInfo) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Reason != nil {
		enc.AddString("reason", *v.Reason)
	}
	if v.Operator != nil {
		enc.AddString("operator", *v.Operator)
	}
	if v.CreatedTimeNano != nil {
		enc.AddInt64("createdTimeNano", *v.CreatedTimeNano)
	}
	return err
}

// GetReason returns the value of Reason if it is set or its
// zero value if it is unset.
func (v *BadBinaryInfo) GetReason() (o string) {
	if v != nil && v.Reason != nil {
		return *v.Reason
	}

	return
}

// IsSetReason returns true if Reason is not nil.
func (v *BadBinaryInfo) IsSetReason() bool {
	return v != nil && v.Reason != nil
}

// GetOperator returns the value of Operator if it is set or its
// zero value if it is unset.
func (v *BadBinaryInfo) GetOperator() (o string) {
	if v != nil && v.Operator != nil {
		return *v.Operator
	}

	return
}

// IsSetOperator returns true if Operator is not nil.
func (v *BadBinaryInfo) IsSetOperator() bool {
	return v != nil && v.Operator != nil
}

// GetCreatedTimeNano returns the value of CreatedTimeNano if it is set or its
// zero value if it is unset.
func (v *BadBinaryInfo) GetCreatedTimeNano() (o int64) {
	if v != nil && v.CreatedTimeNano != nil {
		return *v.CreatedTimeNano
	}

	return
}

// IsSetCreatedTimeNano returns true if CreatedTimeNano is not nil.
func (v *BadBinaryInfo) IsSetCreatedTimeNano() bool {
	return v != nil && v.CreatedTimeNano != nil
}

type BadRequestError struct {
	Message string `json:"message,required"`
}

// ToWire translates a BadRequestError struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *BadRequestError) ToWire() (wire.Value, error) {
	var (
		fields [1]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	w, err = wire.NewValueString(v.Message), error(nil)
	if err != nil {
		return w, err
	}
	fields[i] = wire.Field{ID: 1, Value: w}
	i++

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a BadRequestError struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a BadRequestError struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v BadRequestError
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *BadRequestError) FromWire(w wire.Value) error {
	var err error

	messageIsSet := false

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 1:
			if field.Value.Type() == wire.TBinary {
				v.Message, err = field.Value.GetString(), error(nil)
				if err != nil {
					return err
				}
				messageIsSet = true
			}
		}
	}

	if !messageIsSet {
		return errors.New("field Message of BadRequestError is required")
	}

	return nil
}

// String returns a readable string representation of a BadRequestError
// struct.
func (v *BadRequestError) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [1]string
	i := 0
	fields[i] = fmt.Sprintf("Message: %v", v.Message)
	i++

	return fmt.Sprintf("BadRequestError{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this BadRequestError match the
// provided BadRequestError.
//
// This function performs a deep comparison.
func (v *BadRequestError) Equals(rhs *BadRequestError) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !(v.Message == rhs.Message) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of BadRequestError.
func (v *BadRequestError) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	enc.AddString("message", v.Message)
	return err
}

// GetMessage returns the value of Message if it is set or its
// zero value if it is unset.
func (v *BadRequestError) GetMessage() (o string) {
	if v != nil {
		o = v.Message
	}
	return
}

func (v *BadRequestError) Error() string {
	return v.String()
}

type CancelExternalWorkflowExecutionFailedCause int32

const (
	CancelExternalWorkflowExecutionFailedCauseUnknownExternalWorkflowExecution CancelExternalWorkflowExecutionFailedCause = 0
)

// CancelExternalWorkflowExecutionFailedCause_Values returns all recognized values of CancelExternalWorkflowExecutionFailedCause.
func CancelExternalWorkflowExecutionFailedCause_Values() []CancelExternalWorkflowExecutionFailedCause {
	return []CancelExternalWorkflowExecutionFailedCause{
		CancelExternalWorkflowExecutionFailedCauseUnknownExternalWorkflowExecution,
	}
}

// UnmarshalText tries to decode CancelExternalWorkflowExecutionFailedCause from a byte slice
// containing its name.
//
//   var v CancelExternalWorkflowExecutionFailedCause
//   err := v.UnmarshalText([]byte("UNKNOWN_EXTERNAL_WORKFLOW_EXECUTION"))
func (v *CancelExternalWorkflowExecutionFailedCause) UnmarshalText(value []byte) error {
	switch s := string(value); s {
	case "UNKNOWN_EXTERNAL_WORKFLOW_EXECUTION":
		*v = CancelExternalWorkflowExecutionFailedCauseUnknownExternalWorkflowExecution
		return nil
	default:
		val, err := strconv.ParseInt(s, 10, 32)
		if err != nil {
			return fmt.Errorf("unknown enum value %q for %q: %v", s, "CancelExternalWorkflowExecutionFailedCause", err)
		}
		*v = CancelExternalWorkflowExecutionFailedCause(val)
		return nil
	}
}

// MarshalText encodes CancelExternalWorkflowExecutionFailedCause to text.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements the TextMarshaler interface.
func (v CancelExternalWorkflowExecutionFailedCause) MarshalText() ([]byte, error) {
	switch int32(v) {
	case 0:
		return []byte("UNKNOWN_EXTERNAL_WORKFLOW_EXECUTION"), nil
	}
	return []byte(strconv.FormatInt(int64(v), 10)), nil
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of CancelExternalWorkflowExecutionFailedCause.
// Enums are logged as objects, where the value is logged with key "value", and
// if this value's name is known, the name is logged with key "name".
func (v CancelExternalWorkflowExecutionFailedCause) MarshalLogObject(enc zapcore.ObjectEncoder) error {
	enc.AddInt32("value", int32(v))
	switch int32(v) {
	case 0:
		enc.AddString("name", "UNKNOWN_EXTERNAL_WORKFLOW_EXECUTION")
	}
	return nil
}

// Ptr returns a pointer to this enum value.
func (v CancelExternalWorkflowExecutionFailedCause) Ptr() *CancelExternalWorkflowExecutionFailedCause {
	return &v
}

// ToWire translates CancelExternalWorkflowExecutionFailedCause into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// Enums are represented as 32-bit integers over the wire.
func (v CancelExternalWorkflowExecutionFailedCause) ToWire() (wire.Value, error) {
	return wire.NewValueI32(int32(v)), nil
}

// FromWire deserializes CancelExternalWorkflowExecutionFailedCause from its Thrift-level
// representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TI32)
//   if err != nil {
//     return CancelExternalWorkflowExecutionFailedCause(0), err
//   }
//
//   var v CancelExternalWorkflowExecutionFailedCause
//   if err := v.FromWire(x); err != nil {
//     return CancelExternalWorkflowExecutionFailedCause(0), err
//   }
//   return v, nil
func (v *CancelExternalWorkflowExecutionFailedCause) FromWire(w wire.Value) error {
	*v = (CancelExternalWorkflowExecutionFailedCause)(w.GetI32())
	return nil
}

// String returns a readable string representation of CancelExternalWorkflowExecutionFailedCause.
func (v CancelExternalWorkflowExecutionFailedCause) String() string {
	w := int32(v)
	switch w {
	case 0:
		return "UNKNOWN_EXTERNAL_WORKFLOW_EXECUTION"
	}
	return fmt.Sprintf("CancelExternalWorkflowExecutionFailedCause(%d)", w)
}

// Equals returns true if this CancelExternalWorkflowExecutionFailedCause value matches the provided
// value.
func (v CancelExternalWorkflowExecutionFailedCause) Equals(rhs CancelExternalWorkflowExecutionFailedCause) bool {
	return v == rhs
}

// MarshalJSON serializes CancelExternalWorkflowExecutionFailedCause into JSON.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements json.Marshaler.
func (v CancelExternalWorkflowExecutionFailedCause) MarshalJSON() ([]byte, error) {
	switch int32(v) {
	case 0:
		return ([]byte)("\"UNKNOWN_EXTERNAL_WORKFLOW_EXECUTION\""), nil
	}
	return ([]byte)(strconv.FormatInt(int64(v), 10)), nil
}

// UnmarshalJSON attempts to decode CancelExternalWorkflowExecutionFailedCause from its JSON
// representation.
//
// This implementation supports both, numeric and string inputs. If a
// string is provided, it must be a known enum name.
//
// This implements json.Unmarshaler.
func (v *CancelExternalWorkflowExecutionFailedCause) UnmarshalJSON(text []byte) error {
	d := json.NewDecoder(bytes.NewReader(text))
	d.UseNumber()
	t, err := d.Token()
	if err != nil {
		return err
	}

	switch w := t.(type) {
	case json.Number:
		x, err := w.Int64()
		if err != nil {
			return err
		}
		if x > math.MaxInt32 {
			return fmt.Errorf("enum overflow from JSON %q for %q", text, "CancelExternalWorkflowExecutionFailedCause")
		}
		if x < math.MinInt32 {
			return fmt.Errorf("enum underflow from JSON %q for %q", text, "CancelExternalWorkflowExecutionFailedCause")
		}
		*v = (CancelExternalWorkflowExecutionFailedCause)(x)
		return nil
	case string:
		return v.UnmarshalText([]byte(w))
	default:
		return fmt.Errorf("invalid JSON value %q (%T) to unmarshal into %q", t, t, "CancelExternalWorkflowExecutionFailedCause")
	}
}

type CancelTimerDecisionAttributes struct {
	TimerId *string `json:"timerId,omitempty"`
}

// ToWire translates a CancelTimerDecisionAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *CancelTimerDecisionAttributes) ToWire() (wire.Value, error) {
	var (
		fields [1]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.TimerId != nil {
		w, err = wire.NewValueString(*(v.TimerId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a CancelTimerDecisionAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a CancelTimerDecisionAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v CancelTimerDecisionAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *CancelTimerDecisionAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.TimerId = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a CancelTimerDecisionAttributes
// struct.
func (v *CancelTimerDecisionAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [1]string
	i := 0
	if v.TimerId != nil {
		fields[i] = fmt.Sprintf("TimerId: %v", *(v.TimerId))
		i++
	}

	return fmt.Sprintf("CancelTimerDecisionAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this CancelTimerDecisionAttributes match the
// provided CancelTimerDecisionAttributes.
//
// This function performs a deep comparison.
func (v *CancelTimerDecisionAttributes) Equals(rhs *CancelTimerDecisionAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.TimerId, rhs.TimerId) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of CancelTimerDecisionAttributes.
func (v *CancelTimerDecisionAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.TimerId != nil {
		enc.AddString("timerId", *v.TimerId)
	}
	return err
}

// GetTimerId returns the value of TimerId if it is set or its
// zero value if it is unset.
func (v *CancelTimerDecisionAttributes) GetTimerId() (o string) {
	if v != nil && v.TimerId != nil {
		return *v.TimerId
	}

	return
}

// IsSetTimerId returns true if TimerId is not nil.
func (v *CancelTimerDecisionAttributes) IsSetTimerId() bool {
	return v != nil && v.TimerId != nil
}

type CancelTimerFailedEventAttributes struct {
	TimerId                      *string `json:"timerId,omitempty"`
	Cause                        *string `json:"cause,omitempty"`
	DecisionTaskCompletedEventId *int64  `json:"decisionTaskCompletedEventId,omitempty"`
	Identity                     *string `json:"identity,omitempty"`
}

// ToWire translates a CancelTimerFailedEventAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *CancelTimerFailedEventAttributes) ToWire() (wire.Value, error) {
	var (
		fields [4]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.TimerId != nil {
		w, err = wire.NewValueString(*(v.TimerId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Cause != nil {
		w, err = wire.NewValueString(*(v.Cause)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.DecisionTaskCompletedEventId != nil {
		w, err = wire.NewValueI64(*(v.DecisionTaskCompletedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.Identity != nil {
		w, err = wire.NewValueString(*(v.Identity)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a CancelTimerFailedEventAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a CancelTimerFailedEventAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v CancelTimerFailedEventAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *CancelTimerFailedEventAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.TimerId = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Cause = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.DecisionTaskCompletedEventId = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Identity = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a CancelTimerFailedEventAttributes
// struct.
func (v *CancelTimerFailedEventAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [4]string
	i := 0
	if v.TimerId != nil {
		fields[i] = fmt.Sprintf("TimerId: %v", *(v.TimerId))
		i++
	}
	if v.Cause != nil {
		fields[i] = fmt.Sprintf("Cause: %v", *(v.Cause))
		i++
	}
	if v.DecisionTaskCompletedEventId != nil {
		fields[i] = fmt.Sprintf("DecisionTaskCompletedEventId: %v", *(v.DecisionTaskCompletedEventId))
		i++
	}
	if v.Identity != nil {
		fields[i] = fmt.Sprintf("Identity: %v", *(v.Identity))
		i++
	}

	return fmt.Sprintf("CancelTimerFailedEventAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this CancelTimerFailedEventAttributes match the
// provided CancelTimerFailedEventAttributes.
//
// This function performs a deep comparison.
func (v *CancelTimerFailedEventAttributes) Equals(rhs *CancelTimerFailedEventAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.TimerId, rhs.TimerId) {
		return false
	}
	if !_String_EqualsPtr(v.Cause, rhs.Cause) {
		return false
	}
	if !_I64_EqualsPtr(v.DecisionTaskCompletedEventId, rhs.DecisionTaskCompletedEventId) {
		return false
	}
	if !_String_EqualsPtr(v.Identity, rhs.Identity) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of CancelTimerFailedEventAttributes.
func (v *CancelTimerFailedEventAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.TimerId != nil {
		enc.AddString("timerId", *v.TimerId)
	}
	if v.Cause != nil {
		enc.AddString("cause", *v.Cause)
	}
	if v.DecisionTaskCompletedEventId != nil {
		enc.AddInt64("decisionTaskCompletedEventId", *v.DecisionTaskCompletedEventId)
	}
	if v.Identity != nil {
		enc.AddString("identity", *v.Identity)
	}
	return err
}

// GetTimerId returns the value of TimerId if it is set or its
// zero value if it is unset.
func (v *CancelTimerFailedEventAttributes) GetTimerId() (o string) {
	if v != nil && v.TimerId != nil {
		return *v.TimerId
	}

	return
}

// IsSetTimerId returns true if TimerId is not nil.
func (v *CancelTimerFailedEventAttributes) IsSetTimerId() bool {
	return v != nil && v.TimerId != nil
}

// GetCause returns the value of Cause if it is set or its
// zero value if it is unset.
func (v *CancelTimerFailedEventAttributes) GetCause() (o string) {
	if v != nil && v.Cause != nil {
		return *v.Cause
	}

	return
}

// IsSetCause returns true if Cause is not nil.
func (v *CancelTimerFailedEventAttributes) IsSetCause() bool {
	return v != nil && v.Cause != nil
}

// GetDecisionTaskCompletedEventId returns the value of DecisionTaskCompletedEventId if it is set or its
// zero value if it is unset.
func (v *CancelTimerFailedEventAttributes) GetDecisionTaskCompletedEventId() (o int64) {
	if v != nil && v.DecisionTaskCompletedEventId != nil {
		return *v.DecisionTaskCompletedEventId
	}

	return
}

// IsSetDecisionTaskCompletedEventId returns true if DecisionTaskCompletedEventId is not nil.
func (v *CancelTimerFailedEventAttributes) IsSetDecisionTaskCompletedEventId() bool {
	return v != nil && v.DecisionTaskCompletedEventId != nil
}

// GetIdentity returns the value of Identity if it is set or its
// zero value if it is unset.
func (v *CancelTimerFailedEventAttributes) GetIdentity() (o string) {
	if v != nil && v.Identity != nil {
		return *v.Identity
	}

	return
}

// IsSetIdentity returns true if Identity is not nil.
func (v *CancelTimerFailedEventAttributes) IsSetIdentity() bool {
	return v != nil && v.Identity != nil
}

type CancelWorkflowExecutionDecisionAttributes struct {
	Details []byte `json:"details,omitempty"`
}

// ToWire translates a CancelWorkflowExecutionDecisionAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *CancelWorkflowExecutionDecisionAttributes) ToWire() (wire.Value, error) {
	var (
		fields [1]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Details != nil {
		w, err = wire.NewValueBinary(v.Details), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a CancelWorkflowExecutionDecisionAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a CancelWorkflowExecutionDecisionAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v CancelWorkflowExecutionDecisionAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *CancelWorkflowExecutionDecisionAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				v.Details, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a CancelWorkflowExecutionDecisionAttributes
// struct.
func (v *CancelWorkflowExecutionDecisionAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [1]string
	i := 0
	if v.Details != nil {
		fields[i] = fmt.Sprintf("Details: %v", v.Details)
		i++
	}

	return fmt.Sprintf("CancelWorkflowExecutionDecisionAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this CancelWorkflowExecutionDecisionAttributes match the
// provided CancelWorkflowExecutionDecisionAttributes.
//
// This function performs a deep comparison.
func (v *CancelWorkflowExecutionDecisionAttributes) Equals(rhs *CancelWorkflowExecutionDecisionAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.Details == nil && rhs.Details == nil) || (v.Details != nil && rhs.Details != nil && bytes.Equal(v.Details, rhs.Details))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of CancelWorkflowExecutionDecisionAttributes.
func (v *CancelWorkflowExecutionDecisionAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Details != nil {
		enc.AddString("details", base64.StdEncoding.EncodeToString(v.Details))
	}
	return err
}

// GetDetails returns the value of Details if it is set or its
// zero value if it is unset.
func (v *CancelWorkflowExecutionDecisionAttributes) GetDetails() (o []byte) {
	if v != nil && v.Details != nil {
		return v.Details
	}

	return
}

// IsSetDetails returns true if Details is not nil.
func (v *CancelWorkflowExecutionDecisionAttributes) IsSetDetails() bool {
	return v != nil && v.Details != nil
}

type CancellationAlreadyRequestedError struct {
	Message string `json:"message,required"`
}

// ToWire translates a CancellationAlreadyRequestedError struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *CancellationAlreadyRequestedError) ToWire() (wire.Value, error) {
	var (
		fields [1]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	w, err = wire.NewValueString(v.Message), error(nil)
	if err != nil {
		return w, err
	}
	fields[i] = wire.Field{ID: 1, Value: w}
	i++

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a CancellationAlreadyRequestedError struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a CancellationAlreadyRequestedError struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v CancellationAlreadyRequestedError
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *CancellationAlreadyRequestedError) FromWire(w wire.Value) error {
	var err error

	messageIsSet := false

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 1:
			if field.Value.Type() == wire.TBinary {
				v.Message, err = field.Value.GetString(), error(nil)
				if err != nil {
					return err
				}
				messageIsSet = true
			}
		}
	}

	if !messageIsSet {
		return errors.New("field Message of CancellationAlreadyRequestedError is required")
	}

	return nil
}

// String returns a readable string representation of a CancellationAlreadyRequestedError
// struct.
func (v *CancellationAlreadyRequestedError) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [1]string
	i := 0
	fields[i] = fmt.Sprintf("Message: %v", v.Message)
	i++

	return fmt.Sprintf("CancellationAlreadyRequestedError{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this CancellationAlreadyRequestedError match the
// provided CancellationAlreadyRequestedError.
//
// This function performs a deep comparison.
func (v *CancellationAlreadyRequestedError) Equals(rhs *CancellationAlreadyRequestedError) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !(v.Message == rhs.Message) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of CancellationAlreadyRequestedError.
func (v *CancellationAlreadyRequestedError) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	enc.AddString("message", v.Message)
	return err
}

// GetMessage returns the value of Message if it is set or its
// zero value if it is unset.
func (v *CancellationAlreadyRequestedError) GetMessage() (o string) {
	if v != nil {
		o = v.Message
	}
	return
}

func (v *CancellationAlreadyRequestedError) Error() string {
	return v.String()
}

type ChildPolicy int32

const (
	ChildPolicyTerminate     ChildPolicy = 0
	ChildPolicyRequestCancel ChildPolicy = 1
	ChildPolicyAbandon       ChildPolicy = 2
)

// ChildPolicy_Values returns all recognized values of ChildPolicy.
func ChildPolicy_Values() []ChildPolicy {
	return []ChildPolicy{
		ChildPolicyTerminate,
		ChildPolicyRequestCancel,
		ChildPolicyAbandon,
	}
}

// UnmarshalText tries to decode ChildPolicy from a byte slice
// containing its name.
//
//   var v ChildPolicy
//   err := v.UnmarshalText([]byte("TERMINATE"))
func (v *ChildPolicy) UnmarshalText(value []byte) error {
	switch s := string(value); s {
	case "TERMINATE":
		*v = ChildPolicyTerminate
		return nil
	case "REQUEST_CANCEL":
		*v = ChildPolicyRequestCancel
		return nil
	case "ABANDON":
		*v = ChildPolicyAbandon
		return nil
	default:
		val, err := strconv.ParseInt(s, 10, 32)
		if err != nil {
			return fmt.Errorf("unknown enum value %q for %q: %v", s, "ChildPolicy", err)
		}
		*v = ChildPolicy(val)
		return nil
	}
}

// MarshalText encodes ChildPolicy to text.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements the TextMarshaler interface.
func (v ChildPolicy) MarshalText() ([]byte, error) {
	switch int32(v) {
	case 0:
		return []byte("TERMINATE"), nil
	case 1:
		return []byte("REQUEST_CANCEL"), nil
	case 2:
		return []byte("ABANDON"), nil
	}
	return []byte(strconv.FormatInt(int64(v), 10)), nil
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ChildPolicy.
// Enums are logged as objects, where the value is logged with key "value", and
// if this value's name is known, the name is logged with key "name".
func (v ChildPolicy) MarshalLogObject(enc zapcore.ObjectEncoder) error {
	enc.AddInt32("value", int32(v))
	switch int32(v) {
	case 0:
		enc.AddString("name", "TERMINATE")
	case 1:
		enc.AddString("name", "REQUEST_CANCEL")
	case 2:
		enc.AddString("name", "ABANDON")
	}
	return nil
}

// Ptr returns a pointer to this enum value.
func (v ChildPolicy) Ptr() *ChildPolicy {
	return &v
}

// ToWire translates ChildPolicy into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// Enums are represented as 32-bit integers over the wire.
func (v ChildPolicy) ToWire() (wire.Value, error) {
	return wire.NewValueI32(int32(v)), nil
}

// FromWire deserializes ChildPolicy from its Thrift-level
// representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TI32)
//   if err != nil {
//     return ChildPolicy(0), err
//   }
//
//   var v ChildPolicy
//   if err := v.FromWire(x); err != nil {
//     return ChildPolicy(0), err
//   }
//   return v, nil
func (v *ChildPolicy) FromWire(w wire.Value) error {
	*v = (ChildPolicy)(w.GetI32())
	return nil
}

// String returns a readable string representation of ChildPolicy.
func (v ChildPolicy) String() string {
	w := int32(v)
	switch w {
	case 0:
		return "TERMINATE"
	case 1:
		return "REQUEST_CANCEL"
	case 2:
		return "ABANDON"
	}
	return fmt.Sprintf("ChildPolicy(%d)", w)
}

// Equals returns true if this ChildPolicy value matches the provided
// value.
func (v ChildPolicy) Equals(rhs ChildPolicy) bool {
	return v == rhs
}

// MarshalJSON serializes ChildPolicy into JSON.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements json.Marshaler.
func (v ChildPolicy) MarshalJSON() ([]byte, error) {
	switch int32(v) {
	case 0:
		return ([]byte)("\"TERMINATE\""), nil
	case 1:
		return ([]byte)("\"REQUEST_CANCEL\""), nil
	case 2:
		return ([]byte)("\"ABANDON\""), nil
	}
	return ([]byte)(strconv.FormatInt(int64(v), 10)), nil
}

// UnmarshalJSON attempts to decode ChildPolicy from its JSON
// representation.
//
// This implementation supports both, numeric and string inputs. If a
// string is provided, it must be a known enum name.
//
// This implements json.Unmarshaler.
func (v *ChildPolicy) UnmarshalJSON(text []byte) error {
	d := json.NewDecoder(bytes.NewReader(text))
	d.UseNumber()
	t, err := d.Token()
	if err != nil {
		return err
	}

	switch w := t.(type) {
	case json.Number:
		x, err := w.Int64()
		if err != nil {
			return err
		}
		if x > math.MaxInt32 {
			return fmt.Errorf("enum overflow from JSON %q for %q", text, "ChildPolicy")
		}
		if x < math.MinInt32 {
			return fmt.Errorf("enum underflow from JSON %q for %q", text, "ChildPolicy")
		}
		*v = (ChildPolicy)(x)
		return nil
	case string:
		return v.UnmarshalText([]byte(w))
	default:
		return fmt.Errorf("invalid JSON value %q (%T) to unmarshal into %q", t, t, "ChildPolicy")
	}
}

type ChildWorkflowExecutionCanceledEventAttributes struct {
	Details           []byte             `json:"details,omitempty"`
	Domain            *string            `json:"domain,omitempty"`
	WorkflowExecution *WorkflowExecution `json:"workflowExecution,omitempty"`
	WorkflowType      *WorkflowType      `json:"workflowType,omitempty"`
	InitiatedEventId  *int64             `json:"initiatedEventId,omitempty"`
	StartedEventId    *int64             `json:"startedEventId,omitempty"`
}

// ToWire translates a ChildWorkflowExecutionCanceledEventAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ChildWorkflowExecutionCanceledEventAttributes) ToWire() (wire.Value, error) {
	var (
		fields [6]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Details != nil {
		w, err = wire.NewValueBinary(v.Details), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.WorkflowExecution != nil {
		w, err = v.WorkflowExecution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.WorkflowType != nil {
		w, err = v.WorkflowType.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.InitiatedEventId != nil {
		w, err = wire.NewValueI64(*(v.InitiatedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.StartedEventId != nil {
		w, err = wire.NewValueI64(*(v.StartedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _WorkflowExecution_Read(w wire.Value) (*WorkflowExecution, error) {
	var v WorkflowExecution
	err := v.FromWire(w)
	return &v, err
}

func _WorkflowType_Read(w wire.Value) (*WorkflowType, error) {
	var v WorkflowType
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a ChildWorkflowExecutionCanceledEventAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ChildWorkflowExecutionCanceledEventAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ChildWorkflowExecutionCanceledEventAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ChildWorkflowExecutionCanceledEventAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				v.Details, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowType, err = _WorkflowType_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.InitiatedEventId = &x
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StartedEventId = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ChildWorkflowExecutionCanceledEventAttributes
// struct.
func (v *ChildWorkflowExecutionCanceledEventAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [6]string
	i := 0
	if v.Details != nil {
		fields[i] = fmt.Sprintf("Details: %v", v.Details)
		i++
	}
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.WorkflowExecution != nil {
		fields[i] = fmt.Sprintf("WorkflowExecution: %v", v.WorkflowExecution)
		i++
	}
	if v.WorkflowType != nil {
		fields[i] = fmt.Sprintf("WorkflowType: %v", v.WorkflowType)
		i++
	}
	if v.InitiatedEventId != nil {
		fields[i] = fmt.Sprintf("InitiatedEventId: %v", *(v.InitiatedEventId))
		i++
	}
	if v.StartedEventId != nil {
		fields[i] = fmt.Sprintf("StartedEventId: %v", *(v.StartedEventId))
		i++
	}

	return fmt.Sprintf("ChildWorkflowExecutionCanceledEventAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ChildWorkflowExecutionCanceledEventAttributes match the
// provided ChildWorkflowExecutionCanceledEventAttributes.
//
// This function performs a deep comparison.
func (v *ChildWorkflowExecutionCanceledEventAttributes) Equals(rhs *ChildWorkflowExecutionCanceledEventAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.Details == nil && rhs.Details == nil) || (v.Details != nil && rhs.Details != nil && bytes.Equal(v.Details, rhs.Details))) {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !((v.WorkflowExecution == nil && rhs.WorkflowExecution == nil) || (v.WorkflowExecution != nil && rhs.WorkflowExecution != nil && v.WorkflowExecution.Equals(rhs.WorkflowExecution))) {
		return false
	}
	if !((v.WorkflowType == nil && rhs.WorkflowType == nil) || (v.WorkflowType != nil && rhs.WorkflowType != nil && v.WorkflowType.Equals(rhs.WorkflowType))) {
		return false
	}
	if !_I64_EqualsPtr(v.InitiatedEventId, rhs.InitiatedEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.StartedEventId, rhs.StartedEventId) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ChildWorkflowExecutionCanceledEventAttributes.
func (v *ChildWorkflowExecutionCanceledEventAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Details != nil {
		enc.AddString("details", base64.StdEncoding.EncodeToString(v.Details))
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.WorkflowExecution != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecution", v.WorkflowExecution))
	}
	if v.WorkflowType != nil {
		err = multierr.Append(err, enc.AddObject("workflowType", v.WorkflowType))
	}
	if v.InitiatedEventId != nil {
		enc.AddInt64("initiatedEventId", *v.InitiatedEventId)
	}
	if v.StartedEventId != nil {
		enc.AddInt64("startedEventId", *v.StartedEventId)
	}
	return err
}

// GetDetails returns the value of Details if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionCanceledEventAttributes) GetDetails() (o []byte) {
	if v != nil && v.Details != nil {
		return v.Details
	}

	return
}

// IsSetDetails returns true if Details is not nil.
func (v *ChildWorkflowExecutionCanceledEventAttributes) IsSetDetails() bool {
	return v != nil && v.Details != nil
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionCanceledEventAttributes) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *ChildWorkflowExecutionCanceledEventAttributes) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetWorkflowExecution returns the value of WorkflowExecution if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionCanceledEventAttributes) GetWorkflowExecution() (o *WorkflowExecution) {
	if v != nil && v.WorkflowExecution != nil {
		return v.WorkflowExecution
	}

	return
}

// IsSetWorkflowExecution returns true if WorkflowExecution is not nil.
func (v *ChildWorkflowExecutionCanceledEventAttributes) IsSetWorkflowExecution() bool {
	return v != nil && v.WorkflowExecution != nil
}

// GetWorkflowType returns the value of WorkflowType if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionCanceledEventAttributes) GetWorkflowType() (o *WorkflowType) {
	if v != nil && v.WorkflowType != nil {
		return v.WorkflowType
	}

	return
}

// IsSetWorkflowType returns true if WorkflowType is not nil.
func (v *ChildWorkflowExecutionCanceledEventAttributes) IsSetWorkflowType() bool {
	return v != nil && v.WorkflowType != nil
}

// GetInitiatedEventId returns the value of InitiatedEventId if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionCanceledEventAttributes) GetInitiatedEventId() (o int64) {
	if v != nil && v.InitiatedEventId != nil {
		return *v.InitiatedEventId
	}

	return
}

// IsSetInitiatedEventId returns true if InitiatedEventId is not nil.
func (v *ChildWorkflowExecutionCanceledEventAttributes) IsSetInitiatedEventId() bool {
	return v != nil && v.InitiatedEventId != nil
}

// GetStartedEventId returns the value of StartedEventId if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionCanceledEventAttributes) GetStartedEventId() (o int64) {
	if v != nil && v.StartedEventId != nil {
		return *v.StartedEventId
	}

	return
}

// IsSetStartedEventId returns true if StartedEventId is not nil.
func (v *ChildWorkflowExecutionCanceledEventAttributes) IsSetStartedEventId() bool {
	return v != nil && v.StartedEventId != nil
}

type ChildWorkflowExecutionCompletedEventAttributes struct {
	Result            []byte             `json:"result,omitempty"`
	Domain            *string            `json:"domain,omitempty"`
	WorkflowExecution *WorkflowExecution `json:"workflowExecution,omitempty"`
	WorkflowType      *WorkflowType      `json:"workflowType,omitempty"`
	InitiatedEventId  *int64             `json:"initiatedEventId,omitempty"`
	StartedEventId    *int64             `json:"startedEventId,omitempty"`
}

// ToWire translates a ChildWorkflowExecutionCompletedEventAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ChildWorkflowExecutionCompletedEventAttributes) ToWire() (wire.Value, error) {
	var (
		fields [6]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Result != nil {
		w, err = wire.NewValueBinary(v.Result), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.WorkflowExecution != nil {
		w, err = v.WorkflowExecution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.WorkflowType != nil {
		w, err = v.WorkflowType.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.InitiatedEventId != nil {
		w, err = wire.NewValueI64(*(v.InitiatedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.StartedEventId != nil {
		w, err = wire.NewValueI64(*(v.StartedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ChildWorkflowExecutionCompletedEventAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ChildWorkflowExecutionCompletedEventAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ChildWorkflowExecutionCompletedEventAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ChildWorkflowExecutionCompletedEventAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				v.Result, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowType, err = _WorkflowType_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.InitiatedEventId = &x
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StartedEventId = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ChildWorkflowExecutionCompletedEventAttributes
// struct.
func (v *ChildWorkflowExecutionCompletedEventAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [6]string
	i := 0
	if v.Result != nil {
		fields[i] = fmt.Sprintf("Result: %v", v.Result)
		i++
	}
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.WorkflowExecution != nil {
		fields[i] = fmt.Sprintf("WorkflowExecution: %v", v.WorkflowExecution)
		i++
	}
	if v.WorkflowType != nil {
		fields[i] = fmt.Sprintf("WorkflowType: %v", v.WorkflowType)
		i++
	}
	if v.InitiatedEventId != nil {
		fields[i] = fmt.Sprintf("InitiatedEventId: %v", *(v.InitiatedEventId))
		i++
	}
	if v.StartedEventId != nil {
		fields[i] = fmt.Sprintf("StartedEventId: %v", *(v.StartedEventId))
		i++
	}

	return fmt.Sprintf("ChildWorkflowExecutionCompletedEventAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ChildWorkflowExecutionCompletedEventAttributes match the
// provided ChildWorkflowExecutionCompletedEventAttributes.
//
// This function performs a deep comparison.
func (v *ChildWorkflowExecutionCompletedEventAttributes) Equals(rhs *ChildWorkflowExecutionCompletedEventAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.Result == nil && rhs.Result == nil) || (v.Result != nil && rhs.Result != nil && bytes.Equal(v.Result, rhs.Result))) {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !((v.WorkflowExecution == nil && rhs.WorkflowExecution == nil) || (v.WorkflowExecution != nil && rhs.WorkflowExecution != nil && v.WorkflowExecution.Equals(rhs.WorkflowExecution))) {
		return false
	}
	if !((v.WorkflowType == nil && rhs.WorkflowType == nil) || (v.WorkflowType != nil && rhs.WorkflowType != nil && v.WorkflowType.Equals(rhs.WorkflowType))) {
		return false
	}
	if !_I64_EqualsPtr(v.InitiatedEventId, rhs.InitiatedEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.StartedEventId, rhs.StartedEventId) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ChildWorkflowExecutionCompletedEventAttributes.
func (v *ChildWorkflowExecutionCompletedEventAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Result != nil {
		enc.AddString("result", base64.StdEncoding.EncodeToString(v.Result))
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.WorkflowExecution != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecution", v.WorkflowExecution))
	}
	if v.WorkflowType != nil {
		err = multierr.Append(err, enc.AddObject("workflowType", v.WorkflowType))
	}
	if v.InitiatedEventId != nil {
		enc.AddInt64("initiatedEventId", *v.InitiatedEventId)
	}
	if v.StartedEventId != nil {
		enc.AddInt64("startedEventId", *v.StartedEventId)
	}
	return err
}

// GetResult returns the value of Result if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionCompletedEventAttributes) GetResult() (o []byte) {
	if v != nil && v.Result != nil {
		return v.Result
	}

	return
}

// IsSetResult returns true if Result is not nil.
func (v *ChildWorkflowExecutionCompletedEventAttributes) IsSetResult() bool {
	return v != nil && v.Result != nil
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionCompletedEventAttributes) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *ChildWorkflowExecutionCompletedEventAttributes) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetWorkflowExecution returns the value of WorkflowExecution if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionCompletedEventAttributes) GetWorkflowExecution() (o *WorkflowExecution) {
	if v != nil && v.WorkflowExecution != nil {
		return v.WorkflowExecution
	}

	return
}

// IsSetWorkflowExecution returns true if WorkflowExecution is not nil.
func (v *ChildWorkflowExecutionCompletedEventAttributes) IsSetWorkflowExecution() bool {
	return v != nil && v.WorkflowExecution != nil
}

// GetWorkflowType returns the value of WorkflowType if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionCompletedEventAttributes) GetWorkflowType() (o *WorkflowType) {
	if v != nil && v.WorkflowType != nil {
		return v.WorkflowType
	}

	return
}

// IsSetWorkflowType returns true if WorkflowType is not nil.
func (v *ChildWorkflowExecutionCompletedEventAttributes) IsSetWorkflowType() bool {
	return v != nil && v.WorkflowType != nil
}

// GetInitiatedEventId returns the value of InitiatedEventId if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionCompletedEventAttributes) GetInitiatedEventId() (o int64) {
	if v != nil && v.InitiatedEventId != nil {
		return *v.InitiatedEventId
	}

	return
}

// IsSetInitiatedEventId returns true if InitiatedEventId is not nil.
func (v *ChildWorkflowExecutionCompletedEventAttributes) IsSetInitiatedEventId() bool {
	return v != nil && v.InitiatedEventId != nil
}

// GetStartedEventId returns the value of StartedEventId if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionCompletedEventAttributes) GetStartedEventId() (o int64) {
	if v != nil && v.StartedEventId != nil {
		return *v.StartedEventId
	}

	return
}

// IsSetStartedEventId returns true if StartedEventId is not nil.
func (v *ChildWorkflowExecutionCompletedEventAttributes) IsSetStartedEventId() bool {
	return v != nil && v.StartedEventId != nil
}

type ChildWorkflowExecutionFailedCause int32

const (
	ChildWorkflowExecutionFailedCauseWorkflowAlreadyRunning ChildWorkflowExecutionFailedCause = 0
)

// ChildWorkflowExecutionFailedCause_Values returns all recognized values of ChildWorkflowExecutionFailedCause.
func ChildWorkflowExecutionFailedCause_Values() []ChildWorkflowExecutionFailedCause {
	return []ChildWorkflowExecutionFailedCause{
		ChildWorkflowExecutionFailedCauseWorkflowAlreadyRunning,
	}
}

// UnmarshalText tries to decode ChildWorkflowExecutionFailedCause from a byte slice
// containing its name.
//
//   var v ChildWorkflowExecutionFailedCause
//   err := v.UnmarshalText([]byte("WORKFLOW_ALREADY_RUNNING"))
func (v *ChildWorkflowExecutionFailedCause) UnmarshalText(value []byte) error {
	switch s := string(value); s {
	case "WORKFLOW_ALREADY_RUNNING":
		*v = ChildWorkflowExecutionFailedCauseWorkflowAlreadyRunning
		return nil
	default:
		val, err := strconv.ParseInt(s, 10, 32)
		if err != nil {
			return fmt.Errorf("unknown enum value %q for %q: %v", s, "ChildWorkflowExecutionFailedCause", err)
		}
		*v = ChildWorkflowExecutionFailedCause(val)
		return nil
	}
}

// MarshalText encodes ChildWorkflowExecutionFailedCause to text.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements the TextMarshaler interface.
func (v ChildWorkflowExecutionFailedCause) MarshalText() ([]byte, error) {
	switch int32(v) {
	case 0:
		return []byte("WORKFLOW_ALREADY_RUNNING"), nil
	}
	return []byte(strconv.FormatInt(int64(v), 10)), nil
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ChildWorkflowExecutionFailedCause.
// Enums are logged as objects, where the value is logged with key "value", and
// if this value's name is known, the name is logged with key "name".
func (v ChildWorkflowExecutionFailedCause) MarshalLogObject(enc zapcore.ObjectEncoder) error {
	enc.AddInt32("value", int32(v))
	switch int32(v) {
	case 0:
		enc.AddString("name", "WORKFLOW_ALREADY_RUNNING")
	}
	return nil
}

// Ptr returns a pointer to this enum value.
func (v ChildWorkflowExecutionFailedCause) Ptr() *ChildWorkflowExecutionFailedCause {
	return &v
}

// ToWire translates ChildWorkflowExecutionFailedCause into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// Enums are represented as 32-bit integers over the wire.
func (v ChildWorkflowExecutionFailedCause) ToWire() (wire.Value, error) {
	return wire.NewValueI32(int32(v)), nil
}

// FromWire deserializes ChildWorkflowExecutionFailedCause from its Thrift-level
// representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TI32)
//   if err != nil {
//     return ChildWorkflowExecutionFailedCause(0), err
//   }
//
//   var v ChildWorkflowExecutionFailedCause
//   if err := v.FromWire(x); err != nil {
//     return ChildWorkflowExecutionFailedCause(0), err
//   }
//   return v, nil
func (v *ChildWorkflowExecutionFailedCause) FromWire(w wire.Value) error {
	*v = (ChildWorkflowExecutionFailedCause)(w.GetI32())
	return nil
}

// String returns a readable string representation of ChildWorkflowExecutionFailedCause.
func (v ChildWorkflowExecutionFailedCause) String() string {
	w := int32(v)
	switch w {
	case 0:
		return "WORKFLOW_ALREADY_RUNNING"
	}
	return fmt.Sprintf("ChildWorkflowExecutionFailedCause(%d)", w)
}

// Equals returns true if this ChildWorkflowExecutionFailedCause value matches the provided
// value.
func (v ChildWorkflowExecutionFailedCause) Equals(rhs ChildWorkflowExecutionFailedCause) bool {
	return v == rhs
}

// MarshalJSON serializes ChildWorkflowExecutionFailedCause into JSON.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements json.Marshaler.
func (v ChildWorkflowExecutionFailedCause) MarshalJSON() ([]byte, error) {
	switch int32(v) {
	case 0:
		return ([]byte)("\"WORKFLOW_ALREADY_RUNNING\""), nil
	}
	return ([]byte)(strconv.FormatInt(int64(v), 10)), nil
}

// UnmarshalJSON attempts to decode ChildWorkflowExecutionFailedCause from its JSON
// representation.
//
// This implementation supports both, numeric and string inputs. If a
// string is provided, it must be a known enum name.
//
// This implements json.Unmarshaler.
func (v *ChildWorkflowExecutionFailedCause) UnmarshalJSON(text []byte) error {
	d := json.NewDecoder(bytes.NewReader(text))
	d.UseNumber()
	t, err := d.Token()
	if err != nil {
		return err
	}

	switch w := t.(type) {
	case json.Number:
		x, err := w.Int64()
		if err != nil {
			return err
		}
		if x > math.MaxInt32 {
			return fmt.Errorf("enum overflow from JSON %q for %q", text, "ChildWorkflowExecutionFailedCause")
		}
		if x < math.MinInt32 {
			return fmt.Errorf("enum underflow from JSON %q for %q", text, "ChildWorkflowExecutionFailedCause")
		}
		*v = (ChildWorkflowExecutionFailedCause)(x)
		return nil
	case string:
		return v.UnmarshalText([]byte(w))
	default:
		return fmt.Errorf("invalid JSON value %q (%T) to unmarshal into %q", t, t, "ChildWorkflowExecutionFailedCause")
	}
}

type ChildWorkflowExecutionFailedEventAttributes struct {
	Reason            *string            `json:"reason,omitempty"`
	Details           []byte             `json:"details,omitempty"`
	Domain            *string            `json:"domain,omitempty"`
	WorkflowExecution *WorkflowExecution `json:"workflowExecution,omitempty"`
	WorkflowType      *WorkflowType      `json:"workflowType,omitempty"`
	InitiatedEventId  *int64             `json:"initiatedEventId,omitempty"`
	StartedEventId    *int64             `json:"startedEventId,omitempty"`
}

// ToWire translates a ChildWorkflowExecutionFailedEventAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ChildWorkflowExecutionFailedEventAttributes) ToWire() (wire.Value, error) {
	var (
		fields [7]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Reason != nil {
		w, err = wire.NewValueString(*(v.Reason)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Details != nil {
		w, err = wire.NewValueBinary(v.Details), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.WorkflowExecution != nil {
		w, err = v.WorkflowExecution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.WorkflowType != nil {
		w, err = v.WorkflowType.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.InitiatedEventId != nil {
		w, err = wire.NewValueI64(*(v.InitiatedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}
	if v.StartedEventId != nil {
		w, err = wire.NewValueI64(*(v.StartedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 70, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ChildWorkflowExecutionFailedEventAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ChildWorkflowExecutionFailedEventAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ChildWorkflowExecutionFailedEventAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ChildWorkflowExecutionFailedEventAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Reason = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				v.Details, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowType, err = _WorkflowType_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.InitiatedEventId = &x
				if err != nil {
					return err
				}

			}
		case 70:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StartedEventId = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ChildWorkflowExecutionFailedEventAttributes
// struct.
func (v *ChildWorkflowExecutionFailedEventAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [7]string
	i := 0
	if v.Reason != nil {
		fields[i] = fmt.Sprintf("Reason: %v", *(v.Reason))
		i++
	}
	if v.Details != nil {
		fields[i] = fmt.Sprintf("Details: %v", v.Details)
		i++
	}
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.WorkflowExecution != nil {
		fields[i] = fmt.Sprintf("WorkflowExecution: %v", v.WorkflowExecution)
		i++
	}
	if v.WorkflowType != nil {
		fields[i] = fmt.Sprintf("WorkflowType: %v", v.WorkflowType)
		i++
	}
	if v.InitiatedEventId != nil {
		fields[i] = fmt.Sprintf("InitiatedEventId: %v", *(v.InitiatedEventId))
		i++
	}
	if v.StartedEventId != nil {
		fields[i] = fmt.Sprintf("StartedEventId: %v", *(v.StartedEventId))
		i++
	}

	return fmt.Sprintf("ChildWorkflowExecutionFailedEventAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ChildWorkflowExecutionFailedEventAttributes match the
// provided ChildWorkflowExecutionFailedEventAttributes.
//
// This function performs a deep comparison.
func (v *ChildWorkflowExecutionFailedEventAttributes) Equals(rhs *ChildWorkflowExecutionFailedEventAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Reason, rhs.Reason) {
		return false
	}
	if !((v.Details == nil && rhs.Details == nil) || (v.Details != nil && rhs.Details != nil && bytes.Equal(v.Details, rhs.Details))) {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !((v.WorkflowExecution == nil && rhs.WorkflowExecution == nil) || (v.WorkflowExecution != nil && rhs.WorkflowExecution != nil && v.WorkflowExecution.Equals(rhs.WorkflowExecution))) {
		return false
	}
	if !((v.WorkflowType == nil && rhs.WorkflowType == nil) || (v.WorkflowType != nil && rhs.WorkflowType != nil && v.WorkflowType.Equals(rhs.WorkflowType))) {
		return false
	}
	if !_I64_EqualsPtr(v.InitiatedEventId, rhs.InitiatedEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.StartedEventId, rhs.StartedEventId) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ChildWorkflowExecutionFailedEventAttributes.
func (v *ChildWorkflowExecutionFailedEventAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Reason != nil {
		enc.AddString("reason", *v.Reason)
	}
	if v.Details != nil {
		enc.AddString("details", base64.StdEncoding.EncodeToString(v.Details))
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.WorkflowExecution != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecution", v.WorkflowExecution))
	}
	if v.WorkflowType != nil {
		err = multierr.Append(err, enc.AddObject("workflowType", v.WorkflowType))
	}
	if v.InitiatedEventId != nil {
		enc.AddInt64("initiatedEventId", *v.InitiatedEventId)
	}
	if v.StartedEventId != nil {
		enc.AddInt64("startedEventId", *v.StartedEventId)
	}
	return err
}

// GetReason returns the value of Reason if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionFailedEventAttributes) GetReason() (o string) {
	if v != nil && v.Reason != nil {
		return *v.Reason
	}

	return
}

// IsSetReason returns true if Reason is not nil.
func (v *ChildWorkflowExecutionFailedEventAttributes) IsSetReason() bool {
	return v != nil && v.Reason != nil
}

// GetDetails returns the value of Details if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionFailedEventAttributes) GetDetails() (o []byte) {
	if v != nil && v.Details != nil {
		return v.Details
	}

	return
}

// IsSetDetails returns true if Details is not nil.
func (v *ChildWorkflowExecutionFailedEventAttributes) IsSetDetails() bool {
	return v != nil && v.Details != nil
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionFailedEventAttributes) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *ChildWorkflowExecutionFailedEventAttributes) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetWorkflowExecution returns the value of WorkflowExecution if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionFailedEventAttributes) GetWorkflowExecution() (o *WorkflowExecution) {
	if v != nil && v.WorkflowExecution != nil {
		return v.WorkflowExecution
	}

	return
}

// IsSetWorkflowExecution returns true if WorkflowExecution is not nil.
func (v *ChildWorkflowExecutionFailedEventAttributes) IsSetWorkflowExecution() bool {
	return v != nil && v.WorkflowExecution != nil
}

// GetWorkflowType returns the value of WorkflowType if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionFailedEventAttributes) GetWorkflowType() (o *WorkflowType) {
	if v != nil && v.WorkflowType != nil {
		return v.WorkflowType
	}

	return
}

// IsSetWorkflowType returns true if WorkflowType is not nil.
func (v *ChildWorkflowExecutionFailedEventAttributes) IsSetWorkflowType() bool {
	return v != nil && v.WorkflowType != nil
}

// GetInitiatedEventId returns the value of InitiatedEventId if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionFailedEventAttributes) GetInitiatedEventId() (o int64) {
	if v != nil && v.InitiatedEventId != nil {
		return *v.InitiatedEventId
	}

	return
}

// IsSetInitiatedEventId returns true if InitiatedEventId is not nil.
func (v *ChildWorkflowExecutionFailedEventAttributes) IsSetInitiatedEventId() bool {
	return v != nil && v.InitiatedEventId != nil
}

// GetStartedEventId returns the value of StartedEventId if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionFailedEventAttributes) GetStartedEventId() (o int64) {
	if v != nil && v.StartedEventId != nil {
		return *v.StartedEventId
	}

	return
}

// IsSetStartedEventId returns true if StartedEventId is not nil.
func (v *ChildWorkflowExecutionFailedEventAttributes) IsSetStartedEventId() bool {
	return v != nil && v.StartedEventId != nil
}

type ChildWorkflowExecutionStartedEventAttributes struct {
	Domain            *string            `json:"domain,omitempty"`
	InitiatedEventId  *int64             `json:"initiatedEventId,omitempty"`
	WorkflowExecution *WorkflowExecution `json:"workflowExecution,omitempty"`
	WorkflowType      *WorkflowType      `json:"workflowType,omitempty"`
	Header            *Header            `json:"header,omitempty"`
}

// ToWire translates a ChildWorkflowExecutionStartedEventAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ChildWorkflowExecutionStartedEventAttributes) ToWire() (wire.Value, error) {
	var (
		fields [5]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.InitiatedEventId != nil {
		w, err = wire.NewValueI64(*(v.InitiatedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.WorkflowExecution != nil {
		w, err = v.WorkflowExecution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.WorkflowType != nil {
		w, err = v.WorkflowType.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.Header != nil {
		w, err = v.Header.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ChildWorkflowExecutionStartedEventAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ChildWorkflowExecutionStartedEventAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ChildWorkflowExecutionStartedEventAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ChildWorkflowExecutionStartedEventAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.InitiatedEventId = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowType, err = _WorkflowType_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TStruct {
				v.Header, err = _Header_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ChildWorkflowExecutionStartedEventAttributes
// struct.
func (v *ChildWorkflowExecutionStartedEventAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [5]string
	i := 0
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.InitiatedEventId != nil {
		fields[i] = fmt.Sprintf("InitiatedEventId: %v", *(v.InitiatedEventId))
		i++
	}
	if v.WorkflowExecution != nil {
		fields[i] = fmt.Sprintf("WorkflowExecution: %v", v.WorkflowExecution)
		i++
	}
	if v.WorkflowType != nil {
		fields[i] = fmt.Sprintf("WorkflowType: %v", v.WorkflowType)
		i++
	}
	if v.Header != nil {
		fields[i] = fmt.Sprintf("Header: %v", v.Header)
		i++
	}

	return fmt.Sprintf("ChildWorkflowExecutionStartedEventAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ChildWorkflowExecutionStartedEventAttributes match the
// provided ChildWorkflowExecutionStartedEventAttributes.
//
// This function performs a deep comparison.
func (v *ChildWorkflowExecutionStartedEventAttributes) Equals(rhs *ChildWorkflowExecutionStartedEventAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !_I64_EqualsPtr(v.InitiatedEventId, rhs.InitiatedEventId) {
		return false
	}
	if !((v.WorkflowExecution == nil && rhs.WorkflowExecution == nil) || (v.WorkflowExecution != nil && rhs.WorkflowExecution != nil && v.WorkflowExecution.Equals(rhs.WorkflowExecution))) {
		return false
	}
	if !((v.WorkflowType == nil && rhs.WorkflowType == nil) || (v.WorkflowType != nil && rhs.WorkflowType != nil && v.WorkflowType.Equals(rhs.WorkflowType))) {
		return false
	}
	if !((v.Header == nil && rhs.Header == nil) || (v.Header != nil && rhs.Header != nil && v.Header.Equals(rhs.Header))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ChildWorkflowExecutionStartedEventAttributes.
func (v *ChildWorkflowExecutionStartedEventAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.InitiatedEventId != nil {
		enc.AddInt64("initiatedEventId", *v.InitiatedEventId)
	}
	if v.WorkflowExecution != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecution", v.WorkflowExecution))
	}
	if v.WorkflowType != nil {
		err = multierr.Append(err, enc.AddObject("workflowType", v.WorkflowType))
	}
	if v.Header != nil {
		err = multierr.Append(err, enc.AddObject("header", v.Header))
	}
	return err
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionStartedEventAttributes) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *ChildWorkflowExecutionStartedEventAttributes) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetInitiatedEventId returns the value of InitiatedEventId if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionStartedEventAttributes) GetInitiatedEventId() (o int64) {
	if v != nil && v.InitiatedEventId != nil {
		return *v.InitiatedEventId
	}

	return
}

// IsSetInitiatedEventId returns true if InitiatedEventId is not nil.
func (v *ChildWorkflowExecutionStartedEventAttributes) IsSetInitiatedEventId() bool {
	return v != nil && v.InitiatedEventId != nil
}

// GetWorkflowExecution returns the value of WorkflowExecution if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionStartedEventAttributes) GetWorkflowExecution() (o *WorkflowExecution) {
	if v != nil && v.WorkflowExecution != nil {
		return v.WorkflowExecution
	}

	return
}

// IsSetWorkflowExecution returns true if WorkflowExecution is not nil.
func (v *ChildWorkflowExecutionStartedEventAttributes) IsSetWorkflowExecution() bool {
	return v != nil && v.WorkflowExecution != nil
}

// GetWorkflowType returns the value of WorkflowType if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionStartedEventAttributes) GetWorkflowType() (o *WorkflowType) {
	if v != nil && v.WorkflowType != nil {
		return v.WorkflowType
	}

	return
}

// IsSetWorkflowType returns true if WorkflowType is not nil.
func (v *ChildWorkflowExecutionStartedEventAttributes) IsSetWorkflowType() bool {
	return v != nil && v.WorkflowType != nil
}

// GetHeader returns the value of Header if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionStartedEventAttributes) GetHeader() (o *Header) {
	if v != nil && v.Header != nil {
		return v.Header
	}

	return
}

// IsSetHeader returns true if Header is not nil.
func (v *ChildWorkflowExecutionStartedEventAttributes) IsSetHeader() bool {
	return v != nil && v.Header != nil
}

type ChildWorkflowExecutionTerminatedEventAttributes struct {
	Domain            *string            `json:"domain,omitempty"`
	WorkflowExecution *WorkflowExecution `json:"workflowExecution,omitempty"`
	WorkflowType      *WorkflowType      `json:"workflowType,omitempty"`
	InitiatedEventId  *int64             `json:"initiatedEventId,omitempty"`
	StartedEventId    *int64             `json:"startedEventId,omitempty"`
}

// ToWire translates a ChildWorkflowExecutionTerminatedEventAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ChildWorkflowExecutionTerminatedEventAttributes) ToWire() (wire.Value, error) {
	var (
		fields [5]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.WorkflowExecution != nil {
		w, err = v.WorkflowExecution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.WorkflowType != nil {
		w, err = v.WorkflowType.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.InitiatedEventId != nil {
		w, err = wire.NewValueI64(*(v.InitiatedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.StartedEventId != nil {
		w, err = wire.NewValueI64(*(v.StartedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ChildWorkflowExecutionTerminatedEventAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ChildWorkflowExecutionTerminatedEventAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ChildWorkflowExecutionTerminatedEventAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ChildWorkflowExecutionTerminatedEventAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowType, err = _WorkflowType_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.InitiatedEventId = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StartedEventId = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ChildWorkflowExecutionTerminatedEventAttributes
// struct.
func (v *ChildWorkflowExecutionTerminatedEventAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [5]string
	i := 0
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.WorkflowExecution != nil {
		fields[i] = fmt.Sprintf("WorkflowExecution: %v", v.WorkflowExecution)
		i++
	}
	if v.WorkflowType != nil {
		fields[i] = fmt.Sprintf("WorkflowType: %v", v.WorkflowType)
		i++
	}
	if v.InitiatedEventId != nil {
		fields[i] = fmt.Sprintf("InitiatedEventId: %v", *(v.InitiatedEventId))
		i++
	}
	if v.StartedEventId != nil {
		fields[i] = fmt.Sprintf("StartedEventId: %v", *(v.StartedEventId))
		i++
	}

	return fmt.Sprintf("ChildWorkflowExecutionTerminatedEventAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ChildWorkflowExecutionTerminatedEventAttributes match the
// provided ChildWorkflowExecutionTerminatedEventAttributes.
//
// This function performs a deep comparison.
func (v *ChildWorkflowExecutionTerminatedEventAttributes) Equals(rhs *ChildWorkflowExecutionTerminatedEventAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !((v.WorkflowExecution == nil && rhs.WorkflowExecution == nil) || (v.WorkflowExecution != nil && rhs.WorkflowExecution != nil && v.WorkflowExecution.Equals(rhs.WorkflowExecution))) {
		return false
	}
	if !((v.WorkflowType == nil && rhs.WorkflowType == nil) || (v.WorkflowType != nil && rhs.WorkflowType != nil && v.WorkflowType.Equals(rhs.WorkflowType))) {
		return false
	}
	if !_I64_EqualsPtr(v.InitiatedEventId, rhs.InitiatedEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.StartedEventId, rhs.StartedEventId) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ChildWorkflowExecutionTerminatedEventAttributes.
func (v *ChildWorkflowExecutionTerminatedEventAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.WorkflowExecution != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecution", v.WorkflowExecution))
	}
	if v.WorkflowType != nil {
		err = multierr.Append(err, enc.AddObject("workflowType", v.WorkflowType))
	}
	if v.InitiatedEventId != nil {
		enc.AddInt64("initiatedEventId", *v.InitiatedEventId)
	}
	if v.StartedEventId != nil {
		enc.AddInt64("startedEventId", *v.StartedEventId)
	}
	return err
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionTerminatedEventAttributes) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *ChildWorkflowExecutionTerminatedEventAttributes) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetWorkflowExecution returns the value of WorkflowExecution if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionTerminatedEventAttributes) GetWorkflowExecution() (o *WorkflowExecution) {
	if v != nil && v.WorkflowExecution != nil {
		return v.WorkflowExecution
	}

	return
}

// IsSetWorkflowExecution returns true if WorkflowExecution is not nil.
func (v *ChildWorkflowExecutionTerminatedEventAttributes) IsSetWorkflowExecution() bool {
	return v != nil && v.WorkflowExecution != nil
}

// GetWorkflowType returns the value of WorkflowType if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionTerminatedEventAttributes) GetWorkflowType() (o *WorkflowType) {
	if v != nil && v.WorkflowType != nil {
		return v.WorkflowType
	}

	return
}

// IsSetWorkflowType returns true if WorkflowType is not nil.
func (v *ChildWorkflowExecutionTerminatedEventAttributes) IsSetWorkflowType() bool {
	return v != nil && v.WorkflowType != nil
}

// GetInitiatedEventId returns the value of InitiatedEventId if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionTerminatedEventAttributes) GetInitiatedEventId() (o int64) {
	if v != nil && v.InitiatedEventId != nil {
		return *v.InitiatedEventId
	}

	return
}

// IsSetInitiatedEventId returns true if InitiatedEventId is not nil.
func (v *ChildWorkflowExecutionTerminatedEventAttributes) IsSetInitiatedEventId() bool {
	return v != nil && v.InitiatedEventId != nil
}

// GetStartedEventId returns the value of StartedEventId if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionTerminatedEventAttributes) GetStartedEventId() (o int64) {
	if v != nil && v.StartedEventId != nil {
		return *v.StartedEventId
	}

	return
}

// IsSetStartedEventId returns true if StartedEventId is not nil.
func (v *ChildWorkflowExecutionTerminatedEventAttributes) IsSetStartedEventId() bool {
	return v != nil && v.StartedEventId != nil
}

type ChildWorkflowExecutionTimedOutEventAttributes struct {
	TimeoutType       *TimeoutType       `json:"timeoutType,omitempty"`
	Domain            *string            `json:"domain,omitempty"`
	WorkflowExecution *WorkflowExecution `json:"workflowExecution,omitempty"`
	WorkflowType      *WorkflowType      `json:"workflowType,omitempty"`
	InitiatedEventId  *int64             `json:"initiatedEventId,omitempty"`
	StartedEventId    *int64             `json:"startedEventId,omitempty"`
}

// ToWire translates a ChildWorkflowExecutionTimedOutEventAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ChildWorkflowExecutionTimedOutEventAttributes) ToWire() (wire.Value, error) {
	var (
		fields [6]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.TimeoutType != nil {
		w, err = v.TimeoutType.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.WorkflowExecution != nil {
		w, err = v.WorkflowExecution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.WorkflowType != nil {
		w, err = v.WorkflowType.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.InitiatedEventId != nil {
		w, err = wire.NewValueI64(*(v.InitiatedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.StartedEventId != nil {
		w, err = wire.NewValueI64(*(v.StartedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ChildWorkflowExecutionTimedOutEventAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ChildWorkflowExecutionTimedOutEventAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ChildWorkflowExecutionTimedOutEventAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ChildWorkflowExecutionTimedOutEventAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI32 {
				var x TimeoutType
				x, err = _TimeoutType_Read(field.Value)
				v.TimeoutType = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowType, err = _WorkflowType_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.InitiatedEventId = &x
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StartedEventId = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ChildWorkflowExecutionTimedOutEventAttributes
// struct.
func (v *ChildWorkflowExecutionTimedOutEventAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [6]string
	i := 0
	if v.TimeoutType != nil {
		fields[i] = fmt.Sprintf("TimeoutType: %v", *(v.TimeoutType))
		i++
	}
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.WorkflowExecution != nil {
		fields[i] = fmt.Sprintf("WorkflowExecution: %v", v.WorkflowExecution)
		i++
	}
	if v.WorkflowType != nil {
		fields[i] = fmt.Sprintf("WorkflowType: %v", v.WorkflowType)
		i++
	}
	if v.InitiatedEventId != nil {
		fields[i] = fmt.Sprintf("InitiatedEventId: %v", *(v.InitiatedEventId))
		i++
	}
	if v.StartedEventId != nil {
		fields[i] = fmt.Sprintf("StartedEventId: %v", *(v.StartedEventId))
		i++
	}

	return fmt.Sprintf("ChildWorkflowExecutionTimedOutEventAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ChildWorkflowExecutionTimedOutEventAttributes match the
// provided ChildWorkflowExecutionTimedOutEventAttributes.
//
// This function performs a deep comparison.
func (v *ChildWorkflowExecutionTimedOutEventAttributes) Equals(rhs *ChildWorkflowExecutionTimedOutEventAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_TimeoutType_EqualsPtr(v.TimeoutType, rhs.TimeoutType) {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !((v.WorkflowExecution == nil && rhs.WorkflowExecution == nil) || (v.WorkflowExecution != nil && rhs.WorkflowExecution != nil && v.WorkflowExecution.Equals(rhs.WorkflowExecution))) {
		return false
	}
	if !((v.WorkflowType == nil && rhs.WorkflowType == nil) || (v.WorkflowType != nil && rhs.WorkflowType != nil && v.WorkflowType.Equals(rhs.WorkflowType))) {
		return false
	}
	if !_I64_EqualsPtr(v.InitiatedEventId, rhs.InitiatedEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.StartedEventId, rhs.StartedEventId) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ChildWorkflowExecutionTimedOutEventAttributes.
func (v *ChildWorkflowExecutionTimedOutEventAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.TimeoutType != nil {
		err = multierr.Append(err, enc.AddObject("timeoutType", *v.TimeoutType))
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.WorkflowExecution != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecution", v.WorkflowExecution))
	}
	if v.WorkflowType != nil {
		err = multierr.Append(err, enc.AddObject("workflowType", v.WorkflowType))
	}
	if v.InitiatedEventId != nil {
		enc.AddInt64("initiatedEventId", *v.InitiatedEventId)
	}
	if v.StartedEventId != nil {
		enc.AddInt64("startedEventId", *v.StartedEventId)
	}
	return err
}

// GetTimeoutType returns the value of TimeoutType if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionTimedOutEventAttributes) GetTimeoutType() (o TimeoutType) {
	if v != nil && v.TimeoutType != nil {
		return *v.TimeoutType
	}

	return
}

// IsSetTimeoutType returns true if TimeoutType is not nil.
func (v *ChildWorkflowExecutionTimedOutEventAttributes) IsSetTimeoutType() bool {
	return v != nil && v.TimeoutType != nil
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionTimedOutEventAttributes) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *ChildWorkflowExecutionTimedOutEventAttributes) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetWorkflowExecution returns the value of WorkflowExecution if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionTimedOutEventAttributes) GetWorkflowExecution() (o *WorkflowExecution) {
	if v != nil && v.WorkflowExecution != nil {
		return v.WorkflowExecution
	}

	return
}

// IsSetWorkflowExecution returns true if WorkflowExecution is not nil.
func (v *ChildWorkflowExecutionTimedOutEventAttributes) IsSetWorkflowExecution() bool {
	return v != nil && v.WorkflowExecution != nil
}

// GetWorkflowType returns the value of WorkflowType if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionTimedOutEventAttributes) GetWorkflowType() (o *WorkflowType) {
	if v != nil && v.WorkflowType != nil {
		return v.WorkflowType
	}

	return
}

// IsSetWorkflowType returns true if WorkflowType is not nil.
func (v *ChildWorkflowExecutionTimedOutEventAttributes) IsSetWorkflowType() bool {
	return v != nil && v.WorkflowType != nil
}

// GetInitiatedEventId returns the value of InitiatedEventId if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionTimedOutEventAttributes) GetInitiatedEventId() (o int64) {
	if v != nil && v.InitiatedEventId != nil {
		return *v.InitiatedEventId
	}

	return
}

// IsSetInitiatedEventId returns true if InitiatedEventId is not nil.
func (v *ChildWorkflowExecutionTimedOutEventAttributes) IsSetInitiatedEventId() bool {
	return v != nil && v.InitiatedEventId != nil
}

// GetStartedEventId returns the value of StartedEventId if it is set or its
// zero value if it is unset.
func (v *ChildWorkflowExecutionTimedOutEventAttributes) GetStartedEventId() (o int64) {
	if v != nil && v.StartedEventId != nil {
		return *v.StartedEventId
	}

	return
}

// IsSetStartedEventId returns true if StartedEventId is not nil.
func (v *ChildWorkflowExecutionTimedOutEventAttributes) IsSetStartedEventId() bool {
	return v != nil && v.StartedEventId != nil
}

type ClientVersionNotSupportedError struct {
	FeatureVersion    string `json:"featureVersion,required"`
	ClientImpl        string `json:"clientImpl,required"`
	SupportedVersions string `json:"supportedVersions,required"`
}

// ToWire translates a ClientVersionNotSupportedError struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ClientVersionNotSupportedError) ToWire() (wire.Value, error) {
	var (
		fields [3]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	w, err = wire.NewValueString(v.FeatureVersion), error(nil)
	if err != nil {
		return w, err
	}
	fields[i] = wire.Field{ID: 1, Value: w}
	i++

	w, err = wire.NewValueString(v.ClientImpl), error(nil)
	if err != nil {
		return w, err
	}
	fields[i] = wire.Field{ID: 2, Value: w}
	i++

	w, err = wire.NewValueString(v.SupportedVersions), error(nil)
	if err != nil {
		return w, err
	}
	fields[i] = wire.Field{ID: 3, Value: w}
	i++

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ClientVersionNotSupportedError struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ClientVersionNotSupportedError struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ClientVersionNotSupportedError
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ClientVersionNotSupportedError) FromWire(w wire.Value) error {
	var err error

	featureVersionIsSet := false
	clientImplIsSet := false
	supportedVersionsIsSet := false

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 1:
			if field.Value.Type() == wire.TBinary {
				v.FeatureVersion, err = field.Value.GetString(), error(nil)
				if err != nil {
					return err
				}
				featureVersionIsSet = true
			}
		case 2:
			if field.Value.Type() == wire.TBinary {
				v.ClientImpl, err = field.Value.GetString(), error(nil)
				if err != nil {
					return err
				}
				clientImplIsSet = true
			}
		case 3:
			if field.Value.Type() == wire.TBinary {
				v.SupportedVersions, err = field.Value.GetString(), error(nil)
				if err != nil {
					return err
				}
				supportedVersionsIsSet = true
			}
		}
	}

	if !featureVersionIsSet {
		return errors.New("field FeatureVersion of ClientVersionNotSupportedError is required")
	}

	if !clientImplIsSet {
		return errors.New("field ClientImpl of ClientVersionNotSupportedError is required")
	}

	if !supportedVersionsIsSet {
		return errors.New("field SupportedVersions of ClientVersionNotSupportedError is required")
	}

	return nil
}

// String returns a readable string representation of a ClientVersionNotSupportedError
// struct.
func (v *ClientVersionNotSupportedError) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [3]string
	i := 0
	fields[i] = fmt.Sprintf("FeatureVersion: %v", v.FeatureVersion)
	i++
	fields[i] = fmt.Sprintf("ClientImpl: %v", v.ClientImpl)
	i++
	fields[i] = fmt.Sprintf("SupportedVersions: %v", v.SupportedVersions)
	i++

	return fmt.Sprintf("ClientVersionNotSupportedError{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ClientVersionNotSupportedError match the
// provided ClientVersionNotSupportedError.
//
// This function performs a deep comparison.
func (v *ClientVersionNotSupportedError) Equals(rhs *ClientVersionNotSupportedError) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !(v.FeatureVersion == rhs.FeatureVersion) {
		return false
	}
	if !(v.ClientImpl == rhs.ClientImpl) {
		return false
	}
	if !(v.SupportedVersions == rhs.SupportedVersions) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ClientVersionNotSupportedError.
func (v *ClientVersionNotSupportedError) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	enc.AddString("featureVersion", v.FeatureVersion)
	enc.AddString("clientImpl", v.ClientImpl)
	enc.AddString("supportedVersions", v.SupportedVersions)
	return err
}

// GetFeatureVersion returns the value of FeatureVersion if it is set or its
// zero value if it is unset.
func (v *ClientVersionNotSupportedError) GetFeatureVersion() (o string) {
	if v != nil {
		o = v.FeatureVersion
	}
	return
}

// GetClientImpl returns the value of ClientImpl if it is set or its
// zero value if it is unset.
func (v *ClientVersionNotSupportedError) GetClientImpl() (o string) {
	if v != nil {
		o = v.ClientImpl
	}
	return
}

// GetSupportedVersions returns the value of SupportedVersions if it is set or its
// zero value if it is unset.
func (v *ClientVersionNotSupportedError) GetSupportedVersions() (o string) {
	if v != nil {
		o = v.SupportedVersions
	}
	return
}

func (v *ClientVersionNotSupportedError) Error() string {
	return v.String()
}

type ClusterReplicationConfiguration struct {
	ClusterName *string `json:"clusterName,omitempty"`
}

// ToWire translates a ClusterReplicationConfiguration struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ClusterReplicationConfiguration) ToWire() (wire.Value, error) {
	var (
		fields [1]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.ClusterName != nil {
		w, err = wire.NewValueString(*(v.ClusterName)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ClusterReplicationConfiguration struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ClusterReplicationConfiguration struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ClusterReplicationConfiguration
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ClusterReplicationConfiguration) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ClusterName = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ClusterReplicationConfiguration
// struct.
func (v *ClusterReplicationConfiguration) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [1]string
	i := 0
	if v.ClusterName != nil {
		fields[i] = fmt.Sprintf("ClusterName: %v", *(v.ClusterName))
		i++
	}

	return fmt.Sprintf("ClusterReplicationConfiguration{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ClusterReplicationConfiguration match the
// provided ClusterReplicationConfiguration.
//
// This function performs a deep comparison.
func (v *ClusterReplicationConfiguration) Equals(rhs *ClusterReplicationConfiguration) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.ClusterName, rhs.ClusterName) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ClusterReplicationConfiguration.
func (v *ClusterReplicationConfiguration) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.ClusterName != nil {
		enc.AddString("clusterName", *v.ClusterName)
	}
	return err
}

// GetClusterName returns the value of ClusterName if it is set or its
// zero value if it is unset.
func (v *ClusterReplicationConfiguration) GetClusterName() (o string) {
	if v != nil && v.ClusterName != nil {
		return *v.ClusterName
	}

	return
}

// IsSetClusterName returns true if ClusterName is not nil.
func (v *ClusterReplicationConfiguration) IsSetClusterName() bool {
	return v != nil && v.ClusterName != nil
}

type CompleteWorkflowExecutionDecisionAttributes struct {
	Result []byte `json:"result,omitempty"`
}

// ToWire translates a CompleteWorkflowExecutionDecisionAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *CompleteWorkflowExecutionDecisionAttributes) ToWire() (wire.Value, error) {
	var (
		fields [1]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Result != nil {
		w, err = wire.NewValueBinary(v.Result), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a CompleteWorkflowExecutionDecisionAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a CompleteWorkflowExecutionDecisionAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v CompleteWorkflowExecutionDecisionAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *CompleteWorkflowExecutionDecisionAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				v.Result, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a CompleteWorkflowExecutionDecisionAttributes
// struct.
func (v *CompleteWorkflowExecutionDecisionAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [1]string
	i := 0
	if v.Result != nil {
		fields[i] = fmt.Sprintf("Result: %v", v.Result)
		i++
	}

	return fmt.Sprintf("CompleteWorkflowExecutionDecisionAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this CompleteWorkflowExecutionDecisionAttributes match the
// provided CompleteWorkflowExecutionDecisionAttributes.
//
// This function performs a deep comparison.
func (v *CompleteWorkflowExecutionDecisionAttributes) Equals(rhs *CompleteWorkflowExecutionDecisionAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.Result == nil && rhs.Result == nil) || (v.Result != nil && rhs.Result != nil && bytes.Equal(v.Result, rhs.Result))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of CompleteWorkflowExecutionDecisionAttributes.
func (v *CompleteWorkflowExecutionDecisionAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Result != nil {
		enc.AddString("result", base64.StdEncoding.EncodeToString(v.Result))
	}
	return err
}

// GetResult returns the value of Result if it is set or its
// zero value if it is unset.
func (v *CompleteWorkflowExecutionDecisionAttributes) GetResult() (o []byte) {
	if v != nil && v.Result != nil {
		return v.Result
	}

	return
}

// IsSetResult returns true if Result is not nil.
func (v *CompleteWorkflowExecutionDecisionAttributes) IsSetResult() bool {
	return v != nil && v.Result != nil
}

type ContinueAsNewInitiator int32

const (
	ContinueAsNewInitiatorDecider      ContinueAsNewInitiator = 0
	ContinueAsNewInitiatorRetryPolicy  ContinueAsNewInitiator = 1
	ContinueAsNewInitiatorCronSchedule ContinueAsNewInitiator = 2
)

// ContinueAsNewInitiator_Values returns all recognized values of ContinueAsNewInitiator.
func ContinueAsNewInitiator_Values() []ContinueAsNewInitiator {
	return []ContinueAsNewInitiator{
		ContinueAsNewInitiatorDecider,
		ContinueAsNewInitiatorRetryPolicy,
		ContinueAsNewInitiatorCronSchedule,
	}
}

// UnmarshalText tries to decode ContinueAsNewInitiator from a byte slice
// containing its name.
//
//   var v ContinueAsNewInitiator
//   err := v.UnmarshalText([]byte("Decider"))
func (v *ContinueAsNewInitiator) UnmarshalText(value []byte) error {
	switch s := string(value); s {
	case "Decider":
		*v = ContinueAsNewInitiatorDecider
		return nil
	case "RetryPolicy":
		*v = ContinueAsNewInitiatorRetryPolicy
		return nil
	case "CronSchedule":
		*v = ContinueAsNewInitiatorCronSchedule
		return nil
	default:
		val, err := strconv.ParseInt(s, 10, 32)
		if err != nil {
			return fmt.Errorf("unknown enum value %q for %q: %v", s, "ContinueAsNewInitiator", err)
		}
		*v = ContinueAsNewInitiator(val)
		return nil
	}
}

// MarshalText encodes ContinueAsNewInitiator to text.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements the TextMarshaler interface.
func (v ContinueAsNewInitiator) MarshalText() ([]byte, error) {
	switch int32(v) {
	case 0:
		return []byte("Decider"), nil
	case 1:
		return []byte("RetryPolicy"), nil
	case 2:
		return []byte("CronSchedule"), nil
	}
	return []byte(strconv.FormatInt(int64(v), 10)), nil
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ContinueAsNewInitiator.
// Enums are logged as objects, where the value is logged with key "value", and
// if this value's name is known, the name is logged with key "name".
func (v ContinueAsNewInitiator) MarshalLogObject(enc zapcore.ObjectEncoder) error {
	enc.AddInt32("value", int32(v))
	switch int32(v) {
	case 0:
		enc.AddString("name", "Decider")
	case 1:
		enc.AddString("name", "RetryPolicy")
	case 2:
		enc.AddString("name", "CronSchedule")
	}
	return nil
}

// Ptr returns a pointer to this enum value.
func (v ContinueAsNewInitiator) Ptr() *ContinueAsNewInitiator {
	return &v
}

// ToWire translates ContinueAsNewInitiator into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// Enums are represented as 32-bit integers over the wire.
func (v ContinueAsNewInitiator) ToWire() (wire.Value, error) {
	return wire.NewValueI32(int32(v)), nil
}

// FromWire deserializes ContinueAsNewInitiator from its Thrift-level
// representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TI32)
//   if err != nil {
//     return ContinueAsNewInitiator(0), err
//   }
//
//   var v ContinueAsNewInitiator
//   if err := v.FromWire(x); err != nil {
//     return ContinueAsNewInitiator(0), err
//   }
//   return v, nil
func (v *ContinueAsNewInitiator) FromWire(w wire.Value) error {
	*v = (ContinueAsNewInitiator)(w.GetI32())
	return nil
}

// String returns a readable string representation of ContinueAsNewInitiator.
func (v ContinueAsNewInitiator) String() string {
	w := int32(v)
	switch w {
	case 0:
		return "Decider"
	case 1:
		return "RetryPolicy"
	case 2:
		return "CronSchedule"
	}
	return fmt.Sprintf("ContinueAsNewInitiator(%d)", w)
}

// Equals returns true if this ContinueAsNewInitiator value matches the provided
// value.
func (v ContinueAsNewInitiator) Equals(rhs ContinueAsNewInitiator) bool {
	return v == rhs
}

// MarshalJSON serializes ContinueAsNewInitiator into JSON.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements json.Marshaler.
func (v ContinueAsNewInitiator) MarshalJSON() ([]byte, error) {
	switch int32(v) {
	case 0:
		return ([]byte)("\"Decider\""), nil
	case 1:
		return ([]byte)("\"RetryPolicy\""), nil
	case 2:
		return ([]byte)("\"CronSchedule\""), nil
	}
	return ([]byte)(strconv.FormatInt(int64(v), 10)), nil
}

// UnmarshalJSON attempts to decode ContinueAsNewInitiator from its JSON
// representation.
//
// This implementation supports both, numeric and string inputs. If a
// string is provided, it must be a known enum name.
//
// This implements json.Unmarshaler.
func (v *ContinueAsNewInitiator) UnmarshalJSON(text []byte) error {
	d := json.NewDecoder(bytes.NewReader(text))
	d.UseNumber()
	t, err := d.Token()
	if err != nil {
		return err
	}

	switch w := t.(type) {
	case json.Number:
		x, err := w.Int64()
		if err != nil {
			return err
		}
		if x > math.MaxInt32 {
			return fmt.Errorf("enum overflow from JSON %q for %q", text, "ContinueAsNewInitiator")
		}
		if x < math.MinInt32 {
			return fmt.Errorf("enum underflow from JSON %q for %q", text, "ContinueAsNewInitiator")
		}
		*v = (ContinueAsNewInitiator)(x)
		return nil
	case string:
		return v.UnmarshalText([]byte(w))
	default:
		return fmt.Errorf("invalid JSON value %q (%T) to unmarshal into %q", t, t, "ContinueAsNewInitiator")
	}
}

type ContinueAsNewWorkflowExecutionDecisionAttributes struct {
	WorkflowType                        *WorkflowType           `json:"workflowType,omitempty"`
	TaskList                            *TaskList               `json:"taskList,omitempty"`
	Input                               []byte                  `json:"input,omitempty"`
	ExecutionStartToCloseTimeoutSeconds *int32                  `json:"executionStartToCloseTimeoutSeconds,omitempty"`
	TaskStartToCloseTimeoutSeconds      *int32                  `json:"taskStartToCloseTimeoutSeconds,omitempty"`
	BackoffStartIntervalInSeconds       *int32                  `json:"backoffStartIntervalInSeconds,omitempty"`
	RetryPolicy                         *RetryPolicy            `json:"retryPolicy,omitempty"`
	Initiator                           *ContinueAsNewInitiator `json:"initiator,omitempty"`
	FailureReason                       *string                 `json:"failureReason,omitempty"`
	FailureDetails                      []byte                  `json:"failureDetails,omitempty"`
	LastCompletionResult                []byte                  `json:"lastCompletionResult,omitempty"`
	CronSchedule                        *string                 `json:"cronSchedule,omitempty"`
	Header                              *Header                 `json:"header,omitempty"`
}

// ToWire translates a ContinueAsNewWorkflowExecutionDecisionAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) ToWire() (wire.Value, error) {
	var (
		fields [13]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.WorkflowType != nil {
		w, err = v.WorkflowType.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.TaskList != nil {
		w, err = v.TaskList.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.Input != nil {
		w, err = wire.NewValueBinary(v.Input), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.ExecutionStartToCloseTimeoutSeconds != nil {
		w, err = wire.NewValueI32(*(v.ExecutionStartToCloseTimeoutSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.TaskStartToCloseTimeoutSeconds != nil {
		w, err = wire.NewValueI32(*(v.TaskStartToCloseTimeoutSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.BackoffStartIntervalInSeconds != nil {
		w, err = wire.NewValueI32(*(v.BackoffStartIntervalInSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}
	if v.RetryPolicy != nil {
		w, err = v.RetryPolicy.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 70, Value: w}
		i++
	}
	if v.Initiator != nil {
		w, err = v.Initiator.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 80, Value: w}
		i++
	}
	if v.FailureReason != nil {
		w, err = wire.NewValueString(*(v.FailureReason)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 90, Value: w}
		i++
	}
	if v.FailureDetails != nil {
		w, err = wire.NewValueBinary(v.FailureDetails), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 100, Value: w}
		i++
	}
	if v.LastCompletionResult != nil {
		w, err = wire.NewValueBinary(v.LastCompletionResult), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 110, Value: w}
		i++
	}
	if v.CronSchedule != nil {
		w, err = wire.NewValueString(*(v.CronSchedule)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 120, Value: w}
		i++
	}
	if v.Header != nil {
		w, err = v.Header.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 130, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _ContinueAsNewInitiator_Read(w wire.Value) (ContinueAsNewInitiator, error) {
	var v ContinueAsNewInitiator
	err := v.FromWire(w)
	return v, err
}

// FromWire deserializes a ContinueAsNewWorkflowExecutionDecisionAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ContinueAsNewWorkflowExecutionDecisionAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ContinueAsNewWorkflowExecutionDecisionAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowType, err = _WorkflowType_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.TaskList, err = _TaskList_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				v.Input, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.ExecutionStartToCloseTimeoutSeconds = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.TaskStartToCloseTimeoutSeconds = &x
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.BackoffStartIntervalInSeconds = &x
				if err != nil {
					return err
				}

			}
		case 70:
			if field.Value.Type() == wire.TStruct {
				v.RetryPolicy, err = _RetryPolicy_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 80:
			if field.Value.Type() == wire.TI32 {
				var x ContinueAsNewInitiator
				x, err = _ContinueAsNewInitiator_Read(field.Value)
				v.Initiator = &x
				if err != nil {
					return err
				}

			}
		case 90:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.FailureReason = &x
				if err != nil {
					return err
				}

			}
		case 100:
			if field.Value.Type() == wire.TBinary {
				v.FailureDetails, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 110:
			if field.Value.Type() == wire.TBinary {
				v.LastCompletionResult, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 120:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.CronSchedule = &x
				if err != nil {
					return err
				}

			}
		case 130:
			if field.Value.Type() == wire.TStruct {
				v.Header, err = _Header_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ContinueAsNewWorkflowExecutionDecisionAttributes
// struct.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [13]string
	i := 0
	if v.WorkflowType != nil {
		fields[i] = fmt.Sprintf("WorkflowType: %v", v.WorkflowType)
		i++
	}
	if v.TaskList != nil {
		fields[i] = fmt.Sprintf("TaskList: %v", v.TaskList)
		i++
	}
	if v.Input != nil {
		fields[i] = fmt.Sprintf("Input: %v", v.Input)
		i++
	}
	if v.ExecutionStartToCloseTimeoutSeconds != nil {
		fields[i] = fmt.Sprintf("ExecutionStartToCloseTimeoutSeconds: %v", *(v.ExecutionStartToCloseTimeoutSeconds))
		i++
	}
	if v.TaskStartToCloseTimeoutSeconds != nil {
		fields[i] = fmt.Sprintf("TaskStartToCloseTimeoutSeconds: %v", *(v.TaskStartToCloseTimeoutSeconds))
		i++
	}
	if v.BackoffStartIntervalInSeconds != nil {
		fields[i] = fmt.Sprintf("BackoffStartIntervalInSeconds: %v", *(v.BackoffStartIntervalInSeconds))
		i++
	}
	if v.RetryPolicy != nil {
		fields[i] = fmt.Sprintf("RetryPolicy: %v", v.RetryPolicy)
		i++
	}
	if v.Initiator != nil {
		fields[i] = fmt.Sprintf("Initiator: %v", *(v.Initiator))
		i++
	}
	if v.FailureReason != nil {
		fields[i] = fmt.Sprintf("FailureReason: %v", *(v.FailureReason))
		i++
	}
	if v.FailureDetails != nil {
		fields[i] = fmt.Sprintf("FailureDetails: %v", v.FailureDetails)
		i++
	}
	if v.LastCompletionResult != nil {
		fields[i] = fmt.Sprintf("LastCompletionResult: %v", v.LastCompletionResult)
		i++
	}
	if v.CronSchedule != nil {
		fields[i] = fmt.Sprintf("CronSchedule: %v", *(v.CronSchedule))
		i++
	}
	if v.Header != nil {
		fields[i] = fmt.Sprintf("Header: %v", v.Header)
		i++
	}

	return fmt.Sprintf("ContinueAsNewWorkflowExecutionDecisionAttributes{%v}", strings.Join(fields[:i], ", "))
}

func _ContinueAsNewInitiator_EqualsPtr(lhs, rhs *ContinueAsNewInitiator) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return x.Equals(y)
	}
	return lhs == nil && rhs == nil
}

// Equals returns true if all the fields of this ContinueAsNewWorkflowExecutionDecisionAttributes match the
// provided ContinueAsNewWorkflowExecutionDecisionAttributes.
//
// This function performs a deep comparison.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) Equals(rhs *ContinueAsNewWorkflowExecutionDecisionAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.WorkflowType == nil && rhs.WorkflowType == nil) || (v.WorkflowType != nil && rhs.WorkflowType != nil && v.WorkflowType.Equals(rhs.WorkflowType))) {
		return false
	}
	if !((v.TaskList == nil && rhs.TaskList == nil) || (v.TaskList != nil && rhs.TaskList != nil && v.TaskList.Equals(rhs.TaskList))) {
		return false
	}
	if !((v.Input == nil && rhs.Input == nil) || (v.Input != nil && rhs.Input != nil && bytes.Equal(v.Input, rhs.Input))) {
		return false
	}
	if !_I32_EqualsPtr(v.ExecutionStartToCloseTimeoutSeconds, rhs.ExecutionStartToCloseTimeoutSeconds) {
		return false
	}
	if !_I32_EqualsPtr(v.TaskStartToCloseTimeoutSeconds, rhs.TaskStartToCloseTimeoutSeconds) {
		return false
	}
	if !_I32_EqualsPtr(v.BackoffStartIntervalInSeconds, rhs.BackoffStartIntervalInSeconds) {
		return false
	}
	if !((v.RetryPolicy == nil && rhs.RetryPolicy == nil) || (v.RetryPolicy != nil && rhs.RetryPolicy != nil && v.RetryPolicy.Equals(rhs.RetryPolicy))) {
		return false
	}
	if !_ContinueAsNewInitiator_EqualsPtr(v.Initiator, rhs.Initiator) {
		return false
	}
	if !_String_EqualsPtr(v.FailureReason, rhs.FailureReason) {
		return false
	}
	if !((v.FailureDetails == nil && rhs.FailureDetails == nil) || (v.FailureDetails != nil && rhs.FailureDetails != nil && bytes.Equal(v.FailureDetails, rhs.FailureDetails))) {
		return false
	}
	if !((v.LastCompletionResult == nil && rhs.LastCompletionResult == nil) || (v.LastCompletionResult != nil && rhs.LastCompletionResult != nil && bytes.Equal(v.LastCompletionResult, rhs.LastCompletionResult))) {
		return false
	}
	if !_String_EqualsPtr(v.CronSchedule, rhs.CronSchedule) {
		return false
	}
	if !((v.Header == nil && rhs.Header == nil) || (v.Header != nil && rhs.Header != nil && v.Header.Equals(rhs.Header))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ContinueAsNewWorkflowExecutionDecisionAttributes.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.WorkflowType != nil {
		err = multierr.Append(err, enc.AddObject("workflowType", v.WorkflowType))
	}
	if v.TaskList != nil {
		err = multierr.Append(err, enc.AddObject("taskList", v.TaskList))
	}
	if v.Input != nil {
		enc.AddString("input", base64.StdEncoding.EncodeToString(v.Input))
	}
	if v.ExecutionStartToCloseTimeoutSeconds != nil {
		enc.AddInt32("executionStartToCloseTimeoutSeconds", *v.ExecutionStartToCloseTimeoutSeconds)
	}
	if v.TaskStartToCloseTimeoutSeconds != nil {
		enc.AddInt32("taskStartToCloseTimeoutSeconds", *v.TaskStartToCloseTimeoutSeconds)
	}
	if v.BackoffStartIntervalInSeconds != nil {
		enc.AddInt32("backoffStartIntervalInSeconds", *v.BackoffStartIntervalInSeconds)
	}
	if v.RetryPolicy != nil {
		err = multierr.Append(err, enc.AddObject("retryPolicy", v.RetryPolicy))
	}
	if v.Initiator != nil {
		err = multierr.Append(err, enc.AddObject("initiator", *v.Initiator))
	}
	if v.FailureReason != nil {
		enc.AddString("failureReason", *v.FailureReason)
	}
	if v.FailureDetails != nil {
		enc.AddString("failureDetails", base64.StdEncoding.EncodeToString(v.FailureDetails))
	}
	if v.LastCompletionResult != nil {
		enc.AddString("lastCompletionResult", base64.StdEncoding.EncodeToString(v.LastCompletionResult))
	}
	if v.CronSchedule != nil {
		enc.AddString("cronSchedule", *v.CronSchedule)
	}
	if v.Header != nil {
		err = multierr.Append(err, enc.AddObject("header", v.Header))
	}
	return err
}

// GetWorkflowType returns the value of WorkflowType if it is set or its
// zero value if it is unset.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) GetWorkflowType() (o *WorkflowType) {
	if v != nil && v.WorkflowType != nil {
		return v.WorkflowType
	}

	return
}

// IsSetWorkflowType returns true if WorkflowType is not nil.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) IsSetWorkflowType() bool {
	return v != nil && v.WorkflowType != nil
}

// GetTaskList returns the value of TaskList if it is set or its
// zero value if it is unset.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) GetTaskList() (o *TaskList) {
	if v != nil && v.TaskList != nil {
		return v.TaskList
	}

	return
}

// IsSetTaskList returns true if TaskList is not nil.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) IsSetTaskList() bool {
	return v != nil && v.TaskList != nil
}

// GetInput returns the value of Input if it is set or its
// zero value if it is unset.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) GetInput() (o []byte) {
	if v != nil && v.Input != nil {
		return v.Input
	}

	return
}

// IsSetInput returns true if Input is not nil.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) IsSetInput() bool {
	return v != nil && v.Input != nil
}

// GetExecutionStartToCloseTimeoutSeconds returns the value of ExecutionStartToCloseTimeoutSeconds if it is set or its
// zero value if it is unset.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) GetExecutionStartToCloseTimeoutSeconds() (o int32) {
	if v != nil && v.ExecutionStartToCloseTimeoutSeconds != nil {
		return *v.ExecutionStartToCloseTimeoutSeconds
	}

	return
}

// IsSetExecutionStartToCloseTimeoutSeconds returns true if ExecutionStartToCloseTimeoutSeconds is not nil.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) IsSetExecutionStartToCloseTimeoutSeconds() bool {
	return v != nil && v.ExecutionStartToCloseTimeoutSeconds != nil
}

// GetTaskStartToCloseTimeoutSeconds returns the value of TaskStartToCloseTimeoutSeconds if it is set or its
// zero value if it is unset.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) GetTaskStartToCloseTimeoutSeconds() (o int32) {
	if v != nil && v.TaskStartToCloseTimeoutSeconds != nil {
		return *v.TaskStartToCloseTimeoutSeconds
	}

	return
}

// IsSetTaskStartToCloseTimeoutSeconds returns true if TaskStartToCloseTimeoutSeconds is not nil.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) IsSetTaskStartToCloseTimeoutSeconds() bool {
	return v != nil && v.TaskStartToCloseTimeoutSeconds != nil
}

// GetBackoffStartIntervalInSeconds returns the value of BackoffStartIntervalInSeconds if it is set or its
// zero value if it is unset.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) GetBackoffStartIntervalInSeconds() (o int32) {
	if v != nil && v.BackoffStartIntervalInSeconds != nil {
		return *v.BackoffStartIntervalInSeconds
	}

	return
}

// IsSetBackoffStartIntervalInSeconds returns true if BackoffStartIntervalInSeconds is not nil.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) IsSetBackoffStartIntervalInSeconds() bool {
	return v != nil && v.BackoffStartIntervalInSeconds != nil
}

// GetRetryPolicy returns the value of RetryPolicy if it is set or its
// zero value if it is unset.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) GetRetryPolicy() (o *RetryPolicy) {
	if v != nil && v.RetryPolicy != nil {
		return v.RetryPolicy
	}

	return
}

// IsSetRetryPolicy returns true if RetryPolicy is not nil.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) IsSetRetryPolicy() bool {
	return v != nil && v.RetryPolicy != nil
}

// GetInitiator returns the value of Initiator if it is set or its
// zero value if it is unset.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) GetInitiator() (o ContinueAsNewInitiator) {
	if v != nil && v.Initiator != nil {
		return *v.Initiator
	}

	return
}

// IsSetInitiator returns true if Initiator is not nil.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) IsSetInitiator() bool {
	return v != nil && v.Initiator != nil
}

// GetFailureReason returns the value of FailureReason if it is set or its
// zero value if it is unset.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) GetFailureReason() (o string) {
	if v != nil && v.FailureReason != nil {
		return *v.FailureReason
	}

	return
}

// IsSetFailureReason returns true if FailureReason is not nil.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) IsSetFailureReason() bool {
	return v != nil && v.FailureReason != nil
}

// GetFailureDetails returns the value of FailureDetails if it is set or its
// zero value if it is unset.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) GetFailureDetails() (o []byte) {
	if v != nil && v.FailureDetails != nil {
		return v.FailureDetails
	}

	return
}

// IsSetFailureDetails returns true if FailureDetails is not nil.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) IsSetFailureDetails() bool {
	return v != nil && v.FailureDetails != nil
}

// GetLastCompletionResult returns the value of LastCompletionResult if it is set or its
// zero value if it is unset.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) GetLastCompletionResult() (o []byte) {
	if v != nil && v.LastCompletionResult != nil {
		return v.LastCompletionResult
	}

	return
}

// IsSetLastCompletionResult returns true if LastCompletionResult is not nil.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) IsSetLastCompletionResult() bool {
	return v != nil && v.LastCompletionResult != nil
}

// GetCronSchedule returns the value of CronSchedule if it is set or its
// zero value if it is unset.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) GetCronSchedule() (o string) {
	if v != nil && v.CronSchedule != nil {
		return *v.CronSchedule
	}

	return
}

// IsSetCronSchedule returns true if CronSchedule is not nil.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) IsSetCronSchedule() bool {
	return v != nil && v.CronSchedule != nil
}

// GetHeader returns the value of Header if it is set or its
// zero value if it is unset.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) GetHeader() (o *Header) {
	if v != nil && v.Header != nil {
		return v.Header
	}

	return
}

// IsSetHeader returns true if Header is not nil.
func (v *ContinueAsNewWorkflowExecutionDecisionAttributes) IsSetHeader() bool {
	return v != nil && v.Header != nil
}

type CountWorkflowExecutionsRequest struct {
	Domain *string `json:"domain,omitempty"`
	Query  *string `json:"query,omitempty"`
}

// ToWire translates a CountWorkflowExecutionsRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *CountWorkflowExecutionsRequest) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Query != nil {
		w, err = wire.NewValueString(*(v.Query)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a CountWorkflowExecutionsRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a CountWorkflowExecutionsRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v CountWorkflowExecutionsRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *CountWorkflowExecutionsRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Query = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a CountWorkflowExecutionsRequest
// struct.
func (v *CountWorkflowExecutionsRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.Query != nil {
		fields[i] = fmt.Sprintf("Query: %v", *(v.Query))
		i++
	}

	return fmt.Sprintf("CountWorkflowExecutionsRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this CountWorkflowExecutionsRequest match the
// provided CountWorkflowExecutionsRequest.
//
// This function performs a deep comparison.
func (v *CountWorkflowExecutionsRequest) Equals(rhs *CountWorkflowExecutionsRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !_String_EqualsPtr(v.Query, rhs.Query) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of CountWorkflowExecutionsRequest.
func (v *CountWorkflowExecutionsRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.Query != nil {
		enc.AddString("query", *v.Query)
	}
	return err
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *CountWorkflowExecutionsRequest) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *CountWorkflowExecutionsRequest) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetQuery returns the value of Query if it is set or its
// zero value if it is unset.
func (v *CountWorkflowExecutionsRequest) GetQuery() (o string) {
	if v != nil && v.Query != nil {
		return *v.Query
	}

	return
}

// IsSetQuery returns true if Query is not nil.
func (v *CountWorkflowExecutionsRequest) IsSetQuery() bool {
	return v != nil && v.Query != nil
}

type CountWorkflowExecutionsResponse struct {
	Count *int64 `json:"count,omitempty"`
}

// ToWire translates a CountWorkflowExecutionsResponse struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *CountWorkflowExecutionsResponse) ToWire() (wire.Value, error) {
	var (
		fields [1]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Count != nil {
		w, err = wire.NewValueI64(*(v.Count)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a CountWorkflowExecutionsResponse struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a CountWorkflowExecutionsResponse struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v CountWorkflowExecutionsResponse
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *CountWorkflowExecutionsResponse) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.Count = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a CountWorkflowExecutionsResponse
// struct.
func (v *CountWorkflowExecutionsResponse) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [1]string
	i := 0
	if v.Count != nil {
		fields[i] = fmt.Sprintf("Count: %v", *(v.Count))
		i++
	}

	return fmt.Sprintf("CountWorkflowExecutionsResponse{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this CountWorkflowExecutionsResponse match the
// provided CountWorkflowExecutionsResponse.
//
// This function performs a deep comparison.
func (v *CountWorkflowExecutionsResponse) Equals(rhs *CountWorkflowExecutionsResponse) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_I64_EqualsPtr(v.Count, rhs.Count) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of CountWorkflowExecutionsResponse.
func (v *CountWorkflowExecutionsResponse) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Count != nil {
		enc.AddInt64("count", *v.Count)
	}
	return err
}

// GetCount returns the value of Count if it is set or its
// zero value if it is unset.
func (v *CountWorkflowExecutionsResponse) GetCount() (o int64) {
	if v != nil && v.Count != nil {
		return *v.Count
	}

	return
}

// IsSetCount returns true if Count is not nil.
func (v *CountWorkflowExecutionsResponse) IsSetCount() bool {
	return v != nil && v.Count != nil
}

type DataBlob struct {
	EncodingType *EncodingType `json:"EncodingType,omitempty"`
	Data         []byte        `json:"Data,omitempty"`
}

// ToWire translates a DataBlob struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *DataBlob) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.EncodingType != nil {
		w, err = v.EncodingType.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Data != nil {
		w, err = wire.NewValueBinary(v.Data), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _EncodingType_Read(w wire.Value) (EncodingType, error) {
	var v EncodingType
	err := v.FromWire(w)
	return v, err
}

// FromWire deserializes a DataBlob struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a DataBlob struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v DataBlob
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *DataBlob) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI32 {
				var x EncodingType
				x, err = _EncodingType_Read(field.Value)
				v.EncodingType = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				v.Data, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a DataBlob
// struct.
func (v *DataBlob) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.EncodingType != nil {
		fields[i] = fmt.Sprintf("EncodingType: %v", *(v.EncodingType))
		i++
	}
	if v.Data != nil {
		fields[i] = fmt.Sprintf("Data: %v", v.Data)
		i++
	}

	return fmt.Sprintf("DataBlob{%v}", strings.Join(fields[:i], ", "))
}

func _EncodingType_EqualsPtr(lhs, rhs *EncodingType) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return x.Equals(y)
	}
	return lhs == nil && rhs == nil
}

// Equals returns true if all the fields of this DataBlob match the
// provided DataBlob.
//
// This function performs a deep comparison.
func (v *DataBlob) Equals(rhs *DataBlob) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_EncodingType_EqualsPtr(v.EncodingType, rhs.EncodingType) {
		return false
	}
	if !((v.Data == nil && rhs.Data == nil) || (v.Data != nil && rhs.Data != nil && bytes.Equal(v.Data, rhs.Data))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DataBlob.
func (v *DataBlob) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.EncodingType != nil {
		err = multierr.Append(err, enc.AddObject("EncodingType", *v.EncodingType))
	}
	if v.Data != nil {
		enc.AddString("Data", base64.StdEncoding.EncodeToString(v.Data))
	}
	return err
}

// GetEncodingType returns the value of EncodingType if it is set or its
// zero value if it is unset.
func (v *DataBlob) GetEncodingType() (o EncodingType) {
	if v != nil && v.EncodingType != nil {
		return *v.EncodingType
	}

	return
}

// IsSetEncodingType returns true if EncodingType is not nil.
func (v *DataBlob) IsSetEncodingType() bool {
	return v != nil && v.EncodingType != nil
}

// GetData returns the value of Data if it is set or its
// zero value if it is unset.
func (v *DataBlob) GetData() (o []byte) {
	if v != nil && v.Data != nil {
		return v.Data
	}

	return
}

// IsSetData returns true if Data is not nil.
func (v *DataBlob) IsSetData() bool {
	return v != nil && v.Data != nil
}

type Decision struct {
	DecisionType                                             *DecisionType                                             `json:"decisionType,omitempty"`
	ScheduleActivityTaskDecisionAttributes                   *ScheduleActivityTaskDecisionAttributes                   `json:"scheduleActivityTaskDecisionAttributes,omitempty"`
	StartTimerDecisionAttributes                             *StartTimerDecisionAttributes                             `json:"startTimerDecisionAttributes,omitempty"`
	CompleteWorkflowExecutionDecisionAttributes              *CompleteWorkflowExecutionDecisionAttributes              `json:"completeWorkflowExecutionDecisionAttributes,omitempty"`
	FailWorkflowExecutionDecisionAttributes                  *FailWorkflowExecutionDecisionAttributes                  `json:"failWorkflowExecutionDecisionAttributes,omitempty"`
	RequestCancelActivityTaskDecisionAttributes              *RequestCancelActivityTaskDecisionAttributes              `json:"requestCancelActivityTaskDecisionAttributes,omitempty"`
	CancelTimerDecisionAttributes                            *CancelTimerDecisionAttributes                            `json:"cancelTimerDecisionAttributes,omitempty"`
	CancelWorkflowExecutionDecisionAttributes                *CancelWorkflowExecutionDecisionAttributes                `json:"cancelWorkflowExecutionDecisionAttributes,omitempty"`
	RequestCancelExternalWorkflowExecutionDecisionAttributes *RequestCancelExternalWorkflowExecutionDecisionAttributes `json:"requestCancelExternalWorkflowExecutionDecisionAttributes,omitempty"`
	RecordMarkerDecisionAttributes                           *RecordMarkerDecisionAttributes                           `json:"recordMarkerDecisionAttributes,omitempty"`
	ContinueAsNewWorkflowExecutionDecisionAttributes         *ContinueAsNewWorkflowExecutionDecisionAttributes         `json:"continueAsNewWorkflowExecutionDecisionAttributes,omitempty"`
	StartChildWorkflowExecutionDecisionAttributes            *StartChildWorkflowExecutionDecisionAttributes            `json:"startChildWorkflowExecutionDecisionAttributes,omitempty"`
	SignalExternalWorkflowExecutionDecisionAttributes        *SignalExternalWorkflowExecutionDecisionAttributes        `json:"signalExternalWorkflowExecutionDecisionAttributes,omitempty"`
}

// ToWire translates a Decision struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *Decision) ToWire() (wire.Value, error) {
	var (
		fields [13]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DecisionType != nil {
		w, err = v.DecisionType.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.ScheduleActivityTaskDecisionAttributes != nil {
		w, err = v.ScheduleActivityTaskDecisionAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.StartTimerDecisionAttributes != nil {
		w, err = v.StartTimerDecisionAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 25, Value: w}
		i++
	}
	if v.CompleteWorkflowExecutionDecisionAttributes != nil {
		w, err = v.CompleteWorkflowExecutionDecisionAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.FailWorkflowExecutionDecisionAttributes != nil {
		w, err = v.FailWorkflowExecutionDecisionAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 35, Value: w}
		i++
	}
	if v.RequestCancelActivityTaskDecisionAttributes != nil {
		w, err = v.RequestCancelActivityTaskDecisionAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.CancelTimerDecisionAttributes != nil {
		w, err = v.CancelTimerDecisionAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.CancelWorkflowExecutionDecisionAttributes != nil {
		w, err = v.CancelWorkflowExecutionDecisionAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}
	if v.RequestCancelExternalWorkflowExecutionDecisionAttributes != nil {
		w, err = v.RequestCancelExternalWorkflowExecutionDecisionAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 70, Value: w}
		i++
	}
	if v.RecordMarkerDecisionAttributes != nil {
		w, err = v.RecordMarkerDecisionAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 80, Value: w}
		i++
	}
	if v.ContinueAsNewWorkflowExecutionDecisionAttributes != nil {
		w, err = v.ContinueAsNewWorkflowExecutionDecisionAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 90, Value: w}
		i++
	}
	if v.StartChildWorkflowExecutionDecisionAttributes != nil {
		w, err = v.StartChildWorkflowExecutionDecisionAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 100, Value: w}
		i++
	}
	if v.SignalExternalWorkflowExecutionDecisionAttributes != nil {
		w, err = v.SignalExternalWorkflowExecutionDecisionAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 110, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _DecisionType_Read(w wire.Value) (DecisionType, error) {
	var v DecisionType
	err := v.FromWire(w)
	return v, err
}

func _ScheduleActivityTaskDecisionAttributes_Read(w wire.Value) (*ScheduleActivityTaskDecisionAttributes, error) {
	var v ScheduleActivityTaskDecisionAttributes
	err := v.FromWire(w)
	return &v, err
}

func _StartTimerDecisionAttributes_Read(w wire.Value) (*StartTimerDecisionAttributes, error) {
	var v StartTimerDecisionAttributes
	err := v.FromWire(w)
	return &v, err
}

func _CompleteWorkflowExecutionDecisionAttributes_Read(w wire.Value) (*CompleteWorkflowExecutionDecisionAttributes, error) {
	var v CompleteWorkflowExecutionDecisionAttributes
	err := v.FromWire(w)
	return &v, err
}

func _FailWorkflowExecutionDecisionAttributes_Read(w wire.Value) (*FailWorkflowExecutionDecisionAttributes, error) {
	var v FailWorkflowExecutionDecisionAttributes
	err := v.FromWire(w)
	return &v, err
}

func _RequestCancelActivityTaskDecisionAttributes_Read(w wire.Value) (*RequestCancelActivityTaskDecisionAttributes, error) {
	var v RequestCancelActivityTaskDecisionAttributes
	err := v.FromWire(w)
	return &v, err
}

func _CancelTimerDecisionAttributes_Read(w wire.Value) (*CancelTimerDecisionAttributes, error) {
	var v CancelTimerDecisionAttributes
	err := v.FromWire(w)
	return &v, err
}

func _CancelWorkflowExecutionDecisionAttributes_Read(w wire.Value) (*CancelWorkflowExecutionDecisionAttributes, error) {
	var v CancelWorkflowExecutionDecisionAttributes
	err := v.FromWire(w)
	return &v, err
}

func _RequestCancelExternalWorkflowExecutionDecisionAttributes_Read(w wire.Value) (*RequestCancelExternalWorkflowExecutionDecisionAttributes, error) {
	var v RequestCancelExternalWorkflowExecutionDecisionAttributes
	err := v.FromWire(w)
	return &v, err
}

func _RecordMarkerDecisionAttributes_Read(w wire.Value) (*RecordMarkerDecisionAttributes, error) {
	var v RecordMarkerDecisionAttributes
	err := v.FromWire(w)
	return &v, err
}

func _ContinueAsNewWorkflowExecutionDecisionAttributes_Read(w wire.Value) (*ContinueAsNewWorkflowExecutionDecisionAttributes, error) {
	var v ContinueAsNewWorkflowExecutionDecisionAttributes
	err := v.FromWire(w)
	return &v, err
}

func _StartChildWorkflowExecutionDecisionAttributes_Read(w wire.Value) (*StartChildWorkflowExecutionDecisionAttributes, error) {
	var v StartChildWorkflowExecutionDecisionAttributes
	err := v.FromWire(w)
	return &v, err
}

func _SignalExternalWorkflowExecutionDecisionAttributes_Read(w wire.Value) (*SignalExternalWorkflowExecutionDecisionAttributes, error) {
	var v SignalExternalWorkflowExecutionDecisionAttributes
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a Decision struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a Decision struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v Decision
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *Decision) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI32 {
				var x DecisionType
				x, err = _DecisionType_Read(field.Value)
				v.DecisionType = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.ScheduleActivityTaskDecisionAttributes, err = _ScheduleActivityTaskDecisionAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 25:
			if field.Value.Type() == wire.TStruct {
				v.StartTimerDecisionAttributes, err = _StartTimerDecisionAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TStruct {
				v.CompleteWorkflowExecutionDecisionAttributes, err = _CompleteWorkflowExecutionDecisionAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 35:
			if field.Value.Type() == wire.TStruct {
				v.FailWorkflowExecutionDecisionAttributes, err = _FailWorkflowExecutionDecisionAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TStruct {
				v.RequestCancelActivityTaskDecisionAttributes, err = _RequestCancelActivityTaskDecisionAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TStruct {
				v.CancelTimerDecisionAttributes, err = _CancelTimerDecisionAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TStruct {
				v.CancelWorkflowExecutionDecisionAttributes, err = _CancelWorkflowExecutionDecisionAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 70:
			if field.Value.Type() == wire.TStruct {
				v.RequestCancelExternalWorkflowExecutionDecisionAttributes, err = _RequestCancelExternalWorkflowExecutionDecisionAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 80:
			if field.Value.Type() == wire.TStruct {
				v.RecordMarkerDecisionAttributes, err = _RecordMarkerDecisionAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 90:
			if field.Value.Type() == wire.TStruct {
				v.ContinueAsNewWorkflowExecutionDecisionAttributes, err = _ContinueAsNewWorkflowExecutionDecisionAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 100:
			if field.Value.Type() == wire.TStruct {
				v.StartChildWorkflowExecutionDecisionAttributes, err = _StartChildWorkflowExecutionDecisionAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 110:
			if field.Value.Type() == wire.TStruct {
				v.SignalExternalWorkflowExecutionDecisionAttributes, err = _SignalExternalWorkflowExecutionDecisionAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a Decision
// struct.
func (v *Decision) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [13]string
	i := 0
	if v.DecisionType != nil {
		fields[i] = fmt.Sprintf("DecisionType: %v", *(v.DecisionType))
		i++
	}
	if v.ScheduleActivityTaskDecisionAttributes != nil {
		fields[i] = fmt.Sprintf("ScheduleActivityTaskDecisionAttributes: %v", v.ScheduleActivityTaskDecisionAttributes)
		i++
	}
	if v.StartTimerDecisionAttributes != nil {
		fields[i] = fmt.Sprintf("StartTimerDecisionAttributes: %v", v.StartTimerDecisionAttributes)
		i++
	}
	if v.CompleteWorkflowExecutionDecisionAttributes != nil {
		fields[i] = fmt.Sprintf("CompleteWorkflowExecutionDecisionAttributes: %v", v.CompleteWorkflowExecutionDecisionAttributes)
		i++
	}
	if v.FailWorkflowExecutionDecisionAttributes != nil {
		fields[i] = fmt.Sprintf("FailWorkflowExecutionDecisionAttributes: %v", v.FailWorkflowExecutionDecisionAttributes)
		i++
	}
	if v.RequestCancelActivityTaskDecisionAttributes != nil {
		fields[i] = fmt.Sprintf("RequestCancelActivityTaskDecisionAttributes: %v", v.RequestCancelActivityTaskDecisionAttributes)
		i++
	}
	if v.CancelTimerDecisionAttributes != nil {
		fields[i] = fmt.Sprintf("CancelTimerDecisionAttributes: %v", v.CancelTimerDecisionAttributes)
		i++
	}
	if v.CancelWorkflowExecutionDecisionAttributes != nil {
		fields[i] = fmt.Sprintf("CancelWorkflowExecutionDecisionAttributes: %v", v.CancelWorkflowExecutionDecisionAttributes)
		i++
	}
	if v.RequestCancelExternalWorkflowExecutionDecisionAttributes != nil {
		fields[i] = fmt.Sprintf("RequestCancelExternalWorkflowExecutionDecisionAttributes: %v", v.RequestCancelExternalWorkflowExecutionDecisionAttributes)
		i++
	}
	if v.RecordMarkerDecisionAttributes != nil {
		fields[i] = fmt.Sprintf("RecordMarkerDecisionAttributes: %v", v.RecordMarkerDecisionAttributes)
		i++
	}
	if v.ContinueAsNewWorkflowExecutionDecisionAttributes != nil {
		fields[i] = fmt.Sprintf("ContinueAsNewWorkflowExecutionDecisionAttributes: %v", v.ContinueAsNewWorkflowExecutionDecisionAttributes)
		i++
	}
	if v.StartChildWorkflowExecutionDecisionAttributes != nil {
		fields[i] = fmt.Sprintf("StartChildWorkflowExecutionDecisionAttributes: %v", v.StartChildWorkflowExecutionDecisionAttributes)
		i++
	}
	if v.SignalExternalWorkflowExecutionDecisionAttributes != nil {
		fields[i] = fmt.Sprintf("SignalExternalWorkflowExecutionDecisionAttributes: %v", v.SignalExternalWorkflowExecutionDecisionAttributes)
		i++
	}

	return fmt.Sprintf("Decision{%v}", strings.Join(fields[:i], ", "))
}

func _DecisionType_EqualsPtr(lhs, rhs *DecisionType) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return x.Equals(y)
	}
	return lhs == nil && rhs == nil
}

// Equals returns true if all the fields of this Decision match the
// provided Decision.
//
// This function performs a deep comparison.
func (v *Decision) Equals(rhs *Decision) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_DecisionType_EqualsPtr(v.DecisionType, rhs.DecisionType) {
		return false
	}
	if !((v.ScheduleActivityTaskDecisionAttributes == nil && rhs.ScheduleActivityTaskDecisionAttributes == nil) || (v.ScheduleActivityTaskDecisionAttributes != nil && rhs.ScheduleActivityTaskDecisionAttributes != nil && v.ScheduleActivityTaskDecisionAttributes.Equals(rhs.ScheduleActivityTaskDecisionAttributes))) {
		return false
	}
	if !((v.StartTimerDecisionAttributes == nil && rhs.StartTimerDecisionAttributes == nil) || (v.StartTimerDecisionAttributes != nil && rhs.StartTimerDecisionAttributes != nil && v.StartTimerDecisionAttributes.Equals(rhs.StartTimerDecisionAttributes))) {
		return false
	}
	if !((v.CompleteWorkflowExecutionDecisionAttributes == nil && rhs.CompleteWorkflowExecutionDecisionAttributes == nil) || (v.CompleteWorkflowExecutionDecisionAttributes != nil && rhs.CompleteWorkflowExecutionDecisionAttributes != nil && v.CompleteWorkflowExecutionDecisionAttributes.Equals(rhs.CompleteWorkflowExecutionDecisionAttributes))) {
		return false
	}
	if !((v.FailWorkflowExecutionDecisionAttributes == nil && rhs.FailWorkflowExecutionDecisionAttributes == nil) || (v.FailWorkflowExecutionDecisionAttributes != nil && rhs.FailWorkflowExecutionDecisionAttributes != nil && v.FailWorkflowExecutionDecisionAttributes.Equals(rhs.FailWorkflowExecutionDecisionAttributes))) {
		return false
	}
	if !((v.RequestCancelActivityTaskDecisionAttributes == nil && rhs.RequestCancelActivityTaskDecisionAttributes == nil) || (v.RequestCancelActivityTaskDecisionAttributes != nil && rhs.RequestCancelActivityTaskDecisionAttributes != nil && v.RequestCancelActivityTaskDecisionAttributes.Equals(rhs.RequestCancelActivityTaskDecisionAttributes))) {
		return false
	}
	if !((v.CancelTimerDecisionAttributes == nil && rhs.CancelTimerDecisionAttributes == nil) || (v.CancelTimerDecisionAttributes != nil && rhs.CancelTimerDecisionAttributes != nil && v.CancelTimerDecisionAttributes.Equals(rhs.CancelTimerDecisionAttributes))) {
		return false
	}
	if !((v.CancelWorkflowExecutionDecisionAttributes == nil && rhs.CancelWorkflowExecutionDecisionAttributes == nil) || (v.CancelWorkflowExecutionDecisionAttributes != nil && rhs.CancelWorkflowExecutionDecisionAttributes != nil && v.CancelWorkflowExecutionDecisionAttributes.Equals(rhs.CancelWorkflowExecutionDecisionAttributes))) {
		return false
	}
	if !((v.RequestCancelExternalWorkflowExecutionDecisionAttributes == nil && rhs.RequestCancelExternalWorkflowExecutionDecisionAttributes == nil) || (v.RequestCancelExternalWorkflowExecutionDecisionAttributes != nil && rhs.RequestCancelExternalWorkflowExecutionDecisionAttributes != nil && v.RequestCancelExternalWorkflowExecutionDecisionAttributes.Equals(rhs.RequestCancelExternalWorkflowExecutionDecisionAttributes))) {
		return false
	}
	if !((v.RecordMarkerDecisionAttributes == nil && rhs.RecordMarkerDecisionAttributes == nil) || (v.RecordMarkerDecisionAttributes != nil && rhs.RecordMarkerDecisionAttributes != nil && v.RecordMarkerDecisionAttributes.Equals(rhs.RecordMarkerDecisionAttributes))) {
		return false
	}
	if !((v.ContinueAsNewWorkflowExecutionDecisionAttributes == nil && rhs.ContinueAsNewWorkflowExecutionDecisionAttributes == nil) || (v.ContinueAsNewWorkflowExecutionDecisionAttributes != nil && rhs.ContinueAsNewWorkflowExecutionDecisionAttributes != nil && v.ContinueAsNewWorkflowExecutionDecisionAttributes.Equals(rhs.ContinueAsNewWorkflowExecutionDecisionAttributes))) {
		return false
	}
	if !((v.StartChildWorkflowExecutionDecisionAttributes == nil && rhs.StartChildWorkflowExecutionDecisionAttributes == nil) || (v.StartChildWorkflowExecutionDecisionAttributes != nil && rhs.StartChildWorkflowExecutionDecisionAttributes != nil && v.StartChildWorkflowExecutionDecisionAttributes.Equals(rhs.StartChildWorkflowExecutionDecisionAttributes))) {
		return false
	}
	if !((v.SignalExternalWorkflowExecutionDecisionAttributes == nil && rhs.SignalExternalWorkflowExecutionDecisionAttributes == nil) || (v.SignalExternalWorkflowExecutionDecisionAttributes != nil && rhs.SignalExternalWorkflowExecutionDecisionAttributes != nil && v.SignalExternalWorkflowExecutionDecisionAttributes.Equals(rhs.SignalExternalWorkflowExecutionDecisionAttributes))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of Decision.
func (v *Decision) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DecisionType != nil {
		err = multierr.Append(err, enc.AddObject("decisionType", *v.DecisionType))
	}
	if v.ScheduleActivityTaskDecisionAttributes != nil {
		err = multierr.Append(err, enc.AddObject("scheduleActivityTaskDecisionAttributes", v.ScheduleActivityTaskDecisionAttributes))
	}
	if v.StartTimerDecisionAttributes != nil {
		err = multierr.Append(err, enc.AddObject("startTimerDecisionAttributes", v.StartTimerDecisionAttributes))
	}
	if v.CompleteWorkflowExecutionDecisionAttributes != nil {
		err = multierr.Append(err, enc.AddObject("completeWorkflowExecutionDecisionAttributes", v.CompleteWorkflowExecutionDecisionAttributes))
	}
	if v.FailWorkflowExecutionDecisionAttributes != nil {
		err = multierr.Append(err, enc.AddObject("failWorkflowExecutionDecisionAttributes", v.FailWorkflowExecutionDecisionAttributes))
	}
	if v.RequestCancelActivityTaskDecisionAttributes != nil {
		err = multierr.Append(err, enc.AddObject("requestCancelActivityTaskDecisionAttributes", v.RequestCancelActivityTaskDecisionAttributes))
	}
	if v.CancelTimerDecisionAttributes != nil {
		err = multierr.Append(err, enc.AddObject("cancelTimerDecisionAttributes", v.CancelTimerDecisionAttributes))
	}
	if v.CancelWorkflowExecutionDecisionAttributes != nil {
		err = multierr.Append(err, enc.AddObject("cancelWorkflowExecutionDecisionAttributes", v.CancelWorkflowExecutionDecisionAttributes))
	}
	if v.RequestCancelExternalWorkflowExecutionDecisionAttributes != nil {
		err = multierr.Append(err, enc.AddObject("requestCancelExternalWorkflowExecutionDecisionAttributes", v.RequestCancelExternalWorkflowExecutionDecisionAttributes))
	}
	if v.RecordMarkerDecisionAttributes != nil {
		err = multierr.Append(err, enc.AddObject("recordMarkerDecisionAttributes", v.RecordMarkerDecisionAttributes))
	}
	if v.ContinueAsNewWorkflowExecutionDecisionAttributes != nil {
		err = multierr.Append(err, enc.AddObject("continueAsNewWorkflowExecutionDecisionAttributes", v.ContinueAsNewWorkflowExecutionDecisionAttributes))
	}
	if v.StartChildWorkflowExecutionDecisionAttributes != nil {
		err = multierr.Append(err, enc.AddObject("startChildWorkflowExecutionDecisionAttributes", v.StartChildWorkflowExecutionDecisionAttributes))
	}
	if v.SignalExternalWorkflowExecutionDecisionAttributes != nil {
		err = multierr.Append(err, enc.AddObject("signalExternalWorkflowExecutionDecisionAttributes", v.SignalExternalWorkflowExecutionDecisionAttributes))
	}
	return err
}

// GetDecisionType returns the value of DecisionType if it is set or its
// zero value if it is unset.
func (v *Decision) GetDecisionType() (o DecisionType) {
	if v != nil && v.DecisionType != nil {
		return *v.DecisionType
	}

	return
}

// IsSetDecisionType returns true if DecisionType is not nil.
func (v *Decision) IsSetDecisionType() bool {
	return v != nil && v.DecisionType != nil
}

// GetScheduleActivityTaskDecisionAttributes returns the value of ScheduleActivityTaskDecisionAttributes if it is set or its
// zero value if it is unset.
func (v *Decision) GetScheduleActivityTaskDecisionAttributes() (o *ScheduleActivityTaskDecisionAttributes) {
	if v != nil && v.ScheduleActivityTaskDecisionAttributes != nil {
		return v.ScheduleActivityTaskDecisionAttributes
	}

	return
}

// IsSetScheduleActivityTaskDecisionAttributes returns true if ScheduleActivityTaskDecisionAttributes is not nil.
func (v *Decision) IsSetScheduleActivityTaskDecisionAttributes() bool {
	return v != nil && v.ScheduleActivityTaskDecisionAttributes != nil
}

// GetStartTimerDecisionAttributes returns the value of StartTimerDecisionAttributes if it is set or its
// zero value if it is unset.
func (v *Decision) GetStartTimerDecisionAttributes() (o *StartTimerDecisionAttributes) {
	if v != nil && v.StartTimerDecisionAttributes != nil {
		return v.StartTimerDecisionAttributes
	}

	return
}

// IsSetStartTimerDecisionAttributes returns true if StartTimerDecisionAttributes is not nil.
func (v *Decision) IsSetStartTimerDecisionAttributes() bool {
	return v != nil && v.StartTimerDecisionAttributes != nil
}

// GetCompleteWorkflowExecutionDecisionAttributes returns the value of CompleteWorkflowExecutionDecisionAttributes if it is set or its
// zero value if it is unset.
func (v *Decision) GetCompleteWorkflowExecutionDecisionAttributes() (o *CompleteWorkflowExecutionDecisionAttributes) {
	if v != nil && v.CompleteWorkflowExecutionDecisionAttributes != nil {
		return v.CompleteWorkflowExecutionDecisionAttributes
	}

	return
}

// IsSetCompleteWorkflowExecutionDecisionAttributes returns true if CompleteWorkflowExecutionDecisionAttributes is not nil.
func (v *Decision) IsSetCompleteWorkflowExecutionDecisionAttributes() bool {
	return v != nil && v.CompleteWorkflowExecutionDecisionAttributes != nil
}

// GetFailWorkflowExecutionDecisionAttributes returns the value of FailWorkflowExecutionDecisionAttributes if it is set or its
// zero value if it is unset.
func (v *Decision) GetFailWorkflowExecutionDecisionAttributes() (o *FailWorkflowExecutionDecisionAttributes) {
	if v != nil && v.FailWorkflowExecutionDecisionAttributes != nil {
		return v.FailWorkflowExecutionDecisionAttributes
	}

	return
}

// IsSetFailWorkflowExecutionDecisionAttributes returns true if FailWorkflowExecutionDecisionAttributes is not nil.
func (v *Decision) IsSetFailWorkflowExecutionDecisionAttributes() bool {
	return v != nil && v.FailWorkflowExecutionDecisionAttributes != nil
}

// GetRequestCancelActivityTaskDecisionAttributes returns the value of RequestCancelActivityTaskDecisionAttributes if it is set or its
// zero value if it is unset.
func (v *Decision) GetRequestCancelActivityTaskDecisionAttributes() (o *RequestCancelActivityTaskDecisionAttributes) {
	if v != nil && v.RequestCancelActivityTaskDecisionAttributes != nil {
		return v.RequestCancelActivityTaskDecisionAttributes
	}

	return
}

// IsSetRequestCancelActivityTaskDecisionAttributes returns true if RequestCancelActivityTaskDecisionAttributes is not nil.
func (v *Decision) IsSetRequestCancelActivityTaskDecisionAttributes() bool {
	return v != nil && v.RequestCancelActivityTaskDecisionAttributes != nil
}

// GetCancelTimerDecisionAttributes returns the value of CancelTimerDecisionAttributes if it is set or its
// zero value if it is unset.
func (v *Decision) GetCancelTimerDecisionAttributes() (o *CancelTimerDecisionAttributes) {
	if v != nil && v.CancelTimerDecisionAttributes != nil {
		return v.CancelTimerDecisionAttributes
	}

	return
}

// IsSetCancelTimerDecisionAttributes returns true if CancelTimerDecisionAttributes is not nil.
func (v *Decision) IsSetCancelTimerDecisionAttributes() bool {
	return v != nil && v.CancelTimerDecisionAttributes != nil
}

// GetCancelWorkflowExecutionDecisionAttributes returns the value of CancelWorkflowExecutionDecisionAttributes if it is set or its
// zero value if it is unset.
func (v *Decision) GetCancelWorkflowExecutionDecisionAttributes() (o *CancelWorkflowExecutionDecisionAttributes) {
	if v != nil && v.CancelWorkflowExecutionDecisionAttributes != nil {
		return v.CancelWorkflowExecutionDecisionAttributes
	}

	return
}

// IsSetCancelWorkflowExecutionDecisionAttributes returns true if CancelWorkflowExecutionDecisionAttributes is not nil.
func (v *Decision) IsSetCancelWorkflowExecutionDecisionAttributes() bool {
	return v != nil && v.CancelWorkflowExecutionDecisionAttributes != nil
}

// GetRequestCancelExternalWorkflowExecutionDecisionAttributes returns the value of RequestCancelExternalWorkflowExecutionDecisionAttributes if it is set or its
// zero value if it is unset.
func (v *Decision) GetRequestCancelExternalWorkflowExecutionDecisionAttributes() (o *RequestCancelExternalWorkflowExecutionDecisionAttributes) {
	if v != nil && v.RequestCancelExternalWorkflowExecutionDecisionAttributes != nil {
		return v.RequestCancelExternalWorkflowExecutionDecisionAttributes
	}

	return
}

// IsSetRequestCancelExternalWorkflowExecutionDecisionAttributes returns true if RequestCancelExternalWorkflowExecutionDecisionAttributes is not nil.
func (v *Decision) IsSetRequestCancelExternalWorkflowExecutionDecisionAttributes() bool {
	return v != nil && v.RequestCancelExternalWorkflowExecutionDecisionAttributes != nil
}

// GetRecordMarkerDecisionAttributes returns the value of RecordMarkerDecisionAttributes if it is set or its
// zero value if it is unset.
func (v *Decision) GetRecordMarkerDecisionAttributes() (o *RecordMarkerDecisionAttributes) {
	if v != nil && v.RecordMarkerDecisionAttributes != nil {
		return v.RecordMarkerDecisionAttributes
	}

	return
}

// IsSetRecordMarkerDecisionAttributes returns true if RecordMarkerDecisionAttributes is not nil.
func (v *Decision) IsSetRecordMarkerDecisionAttributes() bool {
	return v != nil && v.RecordMarkerDecisionAttributes != nil
}

// GetContinueAsNewWorkflowExecutionDecisionAttributes returns the value of ContinueAsNewWorkflowExecutionDecisionAttributes if it is set or its
// zero value if it is unset.
func (v *Decision) GetContinueAsNewWorkflowExecutionDecisionAttributes() (o *ContinueAsNewWorkflowExecutionDecisionAttributes) {
	if v != nil && v.ContinueAsNewWorkflowExecutionDecisionAttributes != nil {
		return v.ContinueAsNewWorkflowExecutionDecisionAttributes
	}

	return
}

// IsSetContinueAsNewWorkflowExecutionDecisionAttributes returns true if ContinueAsNewWorkflowExecutionDecisionAttributes is not nil.
func (v *Decision) IsSetContinueAsNewWorkflowExecutionDecisionAttributes() bool {
	return v != nil && v.ContinueAsNewWorkflowExecutionDecisionAttributes != nil
}

// GetStartChildWorkflowExecutionDecisionAttributes returns the value of StartChildWorkflowExecutionDecisionAttributes if it is set or its
// zero value if it is unset.
func (v *Decision) GetStartChildWorkflowExecutionDecisionAttributes() (o *StartChildWorkflowExecutionDecisionAttributes) {
	if v != nil && v.StartChildWorkflowExecutionDecisionAttributes != nil {
		return v.StartChildWorkflowExecutionDecisionAttributes
	}

	return
}

// IsSetStartChildWorkflowExecutionDecisionAttributes returns true if StartChildWorkflowExecutionDecisionAttributes is not nil.
func (v *Decision) IsSetStartChildWorkflowExecutionDecisionAttributes() bool {
	return v != nil && v.StartChildWorkflowExecutionDecisionAttributes != nil
}

// GetSignalExternalWorkflowExecutionDecisionAttributes returns the value of SignalExternalWorkflowExecutionDecisionAttributes if it is set or its
// zero value if it is unset.
func (v *Decision) GetSignalExternalWorkflowExecutionDecisionAttributes() (o *SignalExternalWorkflowExecutionDecisionAttributes) {
	if v != nil && v.SignalExternalWorkflowExecutionDecisionAttributes != nil {
		return v.SignalExternalWorkflowExecutionDecisionAttributes
	}

	return
}

// IsSetSignalExternalWorkflowExecutionDecisionAttributes returns true if SignalExternalWorkflowExecutionDecisionAttributes is not nil.
func (v *Decision) IsSetSignalExternalWorkflowExecutionDecisionAttributes() bool {
	return v != nil && v.SignalExternalWorkflowExecutionDecisionAttributes != nil
}

type DecisionTaskCompletedEventAttributes struct {
	ExecutionContext []byte  `json:"executionContext,omitempty"`
	ScheduledEventId *int64  `json:"scheduledEventId,omitempty"`
	StartedEventId   *int64  `json:"startedEventId,omitempty"`
	Identity         *string `json:"identity,omitempty"`
	BinaryChecksum   *string `json:"binaryChecksum,omitempty"`
}

// ToWire translates a DecisionTaskCompletedEventAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *DecisionTaskCompletedEventAttributes) ToWire() (wire.Value, error) {
	var (
		fields [5]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.ExecutionContext != nil {
		w, err = wire.NewValueBinary(v.ExecutionContext), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.ScheduledEventId != nil {
		w, err = wire.NewValueI64(*(v.ScheduledEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.StartedEventId != nil {
		w, err = wire.NewValueI64(*(v.StartedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.Identity != nil {
		w, err = wire.NewValueString(*(v.Identity)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.BinaryChecksum != nil {
		w, err = wire.NewValueString(*(v.BinaryChecksum)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a DecisionTaskCompletedEventAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a DecisionTaskCompletedEventAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v DecisionTaskCompletedEventAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *DecisionTaskCompletedEventAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				v.ExecutionContext, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduledEventId = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StartedEventId = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Identity = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.BinaryChecksum = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a DecisionTaskCompletedEventAttributes
// struct.
func (v *DecisionTaskCompletedEventAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [5]string
	i := 0
	if v.ExecutionContext != nil {
		fields[i] = fmt.Sprintf("ExecutionContext: %v", v.ExecutionContext)
		i++
	}
	if v.ScheduledEventId != nil {
		fields[i] = fmt.Sprintf("ScheduledEventId: %v", *(v.ScheduledEventId))
		i++
	}
	if v.StartedEventId != nil {
		fields[i] = fmt.Sprintf("StartedEventId: %v", *(v.StartedEventId))
		i++
	}
	if v.Identity != nil {
		fields[i] = fmt.Sprintf("Identity: %v", *(v.Identity))
		i++
	}
	if v.BinaryChecksum != nil {
		fields[i] = fmt.Sprintf("BinaryChecksum: %v", *(v.BinaryChecksum))
		i++
	}

	return fmt.Sprintf("DecisionTaskCompletedEventAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this DecisionTaskCompletedEventAttributes match the
// provided DecisionTaskCompletedEventAttributes.
//
// This function performs a deep comparison.
func (v *DecisionTaskCompletedEventAttributes) Equals(rhs *DecisionTaskCompletedEventAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.ExecutionContext == nil && rhs.ExecutionContext == nil) || (v.ExecutionContext != nil && rhs.ExecutionContext != nil && bytes.Equal(v.ExecutionContext, rhs.ExecutionContext))) {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduledEventId, rhs.ScheduledEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.StartedEventId, rhs.StartedEventId) {
		return false
	}
	if !_String_EqualsPtr(v.Identity, rhs.Identity) {
		return false
	}
	if !_String_EqualsPtr(v.BinaryChecksum, rhs.BinaryChecksum) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DecisionTaskCompletedEventAttributes.
func (v *DecisionTaskCompletedEventAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.ExecutionContext != nil {
		enc.AddString("executionContext", base64.StdEncoding.EncodeToString(v.ExecutionContext))
	}
	if v.ScheduledEventId != nil {
		enc.AddInt64("scheduledEventId", *v.ScheduledEventId)
	}
	if v.StartedEventId != nil {
		enc.AddInt64("startedEventId", *v.StartedEventId)
	}
	if v.Identity != nil {
		enc.AddString("identity", *v.Identity)
	}
	if v.BinaryChecksum != nil {
		enc.AddString("binaryChecksum", *v.BinaryChecksum)
	}
	return err
}

// GetExecutionContext returns the value of ExecutionContext if it is set or its
// zero value if it is unset.
func (v *DecisionTaskCompletedEventAttributes) GetExecutionContext() (o []byte) {
	if v != nil && v.ExecutionContext != nil {
		return v.ExecutionContext
	}

	return
}

// IsSetExecutionContext returns true if ExecutionContext is not nil.
func (v *DecisionTaskCompletedEventAttributes) IsSetExecutionContext() bool {
	return v != nil && v.ExecutionContext != nil
}

// GetScheduledEventId returns the value of ScheduledEventId if it is set or its
// zero value if it is unset.
func (v *DecisionTaskCompletedEventAttributes) GetScheduledEventId() (o int64) {
	if v != nil && v.ScheduledEventId != nil {
		return *v.ScheduledEventId
	}

	return
}

// IsSetScheduledEventId returns true if ScheduledEventId is not nil.
func (v *DecisionTaskCompletedEventAttributes) IsSetScheduledEventId() bool {
	return v != nil && v.ScheduledEventId != nil
}

// GetStartedEventId returns the value of StartedEventId if it is set or its
// zero value if it is unset.
func (v *DecisionTaskCompletedEventAttributes) GetStartedEventId() (o int64) {
	if v != nil && v.StartedEventId != nil {
		return *v.StartedEventId
	}

	return
}

// IsSetStartedEventId returns true if StartedEventId is not nil.
func (v *DecisionTaskCompletedEventAttributes) IsSetStartedEventId() bool {
	return v != nil && v.StartedEventId != nil
}

// GetIdentity returns the value of Identity if it is set or its
// zero value if it is unset.
func (v *DecisionTaskCompletedEventAttributes) GetIdentity() (o string) {
	if v != nil && v.Identity != nil {
		return *v.Identity
	}

	return
}

// IsSetIdentity returns true if Identity is not nil.
func (v *DecisionTaskCompletedEventAttributes) IsSetIdentity() bool {
	return v != nil && v.Identity != nil
}

// GetBinaryChecksum returns the value of BinaryChecksum if it is set or its
// zero value if it is unset.
func (v *DecisionTaskCompletedEventAttributes) GetBinaryChecksum() (o string) {
	if v != nil && v.BinaryChecksum != nil {
		return *v.BinaryChecksum
	}

	return
}

// IsSetBinaryChecksum returns true if BinaryChecksum is not nil.
func (v *DecisionTaskCompletedEventAttributes) IsSetBinaryChecksum() bool {
	return v != nil && v.BinaryChecksum != nil
}

type DecisionTaskFailedCause int32

const (
	DecisionTaskFailedCauseUnhandledDecision                                   DecisionTaskFailedCause = 0
	DecisionTaskFailedCauseBadScheduleActivityAttributes                       DecisionTaskFailedCause = 1
	DecisionTaskFailedCauseBadRequestCancelActivityAttributes                  DecisionTaskFailedCause = 2
	DecisionTaskFailedCauseBadStartTimerAttributes                             DecisionTaskFailedCause = 3
	DecisionTaskFailedCauseBadCancelTimerAttributes                            DecisionTaskFailedCause = 4
	DecisionTaskFailedCauseBadRecordMarkerAttributes                           DecisionTaskFailedCause = 5
	DecisionTaskFailedCauseBadCompleteWorkflowExecutionAttributes              DecisionTaskFailedCause = 6
	DecisionTaskFailedCauseBadFailWorkflowExecutionAttributes                  DecisionTaskFailedCause = 7
	DecisionTaskFailedCauseBadCancelWorkflowExecutionAttributes                DecisionTaskFailedCause = 8
	DecisionTaskFailedCauseBadRequestCancelExternalWorkflowExecutionAttributes DecisionTaskFailedCause = 9
	DecisionTaskFailedCauseBadContinueAsNewAttributes                          DecisionTaskFailedCause = 10
	DecisionTaskFailedCauseStartTimerDuplicateID                               DecisionTaskFailedCause = 11
	DecisionTaskFailedCauseResetStickyTasklist                                 DecisionTaskFailedCause = 12
	DecisionTaskFailedCauseWorkflowWorkerUnhandledFailure                      DecisionTaskFailedCause = 13
	DecisionTaskFailedCauseBadSignalWorkflowExecutionAttributes                DecisionTaskFailedCause = 14
	DecisionTaskFailedCauseBadStartChildExecutionAttributes                    DecisionTaskFailedCause = 15
	DecisionTaskFailedCauseForceCloseDecision                                  DecisionTaskFailedCause = 16
	DecisionTaskFailedCauseFailoverCloseDecision                               DecisionTaskFailedCause = 17
	DecisionTaskFailedCauseBadSignalInputSize                                  DecisionTaskFailedCause = 18
	DecisionTaskFailedCauseResetWorkflow                                       DecisionTaskFailedCause = 19
	DecisionTaskFailedCauseBadBinary                                           DecisionTaskFailedCause = 20
)

// DecisionTaskFailedCause_Values returns all recognized values of DecisionTaskFailedCause.
func DecisionTaskFailedCause_Values() []DecisionTaskFailedCause {
	return []DecisionTaskFailedCause{
		DecisionTaskFailedCauseUnhandledDecision,
		DecisionTaskFailedCauseBadScheduleActivityAttributes,
		DecisionTaskFailedCauseBadRequestCancelActivityAttributes,
		DecisionTaskFailedCauseBadStartTimerAttributes,
		DecisionTaskFailedCauseBadCancelTimerAttributes,
		DecisionTaskFailedCauseBadRecordMarkerAttributes,
		DecisionTaskFailedCauseBadCompleteWorkflowExecutionAttributes,
		DecisionTaskFailedCauseBadFailWorkflowExecutionAttributes,
		DecisionTaskFailedCauseBadCancelWorkflowExecutionAttributes,
		DecisionTaskFailedCauseBadRequestCancelExternalWorkflowExecutionAttributes,
		DecisionTaskFailedCauseBadContinueAsNewAttributes,
		DecisionTaskFailedCauseStartTimerDuplicateID,
		DecisionTaskFailedCauseResetStickyTasklist,
		DecisionTaskFailedCauseWorkflowWorkerUnhandledFailure,
		DecisionTaskFailedCauseBadSignalWorkflowExecutionAttributes,
		DecisionTaskFailedCauseBadStartChildExecutionAttributes,
		DecisionTaskFailedCauseForceCloseDecision,
		DecisionTaskFailedCauseFailoverCloseDecision,
		DecisionTaskFailedCauseBadSignalInputSize,
		DecisionTaskFailedCauseResetWorkflow,
		DecisionTaskFailedCauseBadBinary,
	}
}

// UnmarshalText tries to decode DecisionTaskFailedCause from a byte slice
// containing its name.
//
//   var v DecisionTaskFailedCause
//   err := v.UnmarshalText([]byte("UNHANDLED_DECISION"))
func (v *DecisionTaskFailedCause) UnmarshalText(value []byte) error {
	switch s := string(value); s {
	case "UNHANDLED_DECISION":
		*v = DecisionTaskFailedCauseUnhandledDecision
		return nil
	case "BAD_SCHEDULE_ACTIVITY_ATTRIBUTES":
		*v = DecisionTaskFailedCauseBadScheduleActivityAttributes
		return nil
	case "BAD_REQUEST_CANCEL_ACTIVITY_ATTRIBUTES":
		*v = DecisionTaskFailedCauseBadRequestCancelActivityAttributes
		return nil
	case "BAD_START_TIMER_ATTRIBUTES":
		*v = DecisionTaskFailedCauseBadStartTimerAttributes
		return nil
	case "BAD_CANCEL_TIMER_ATTRIBUTES":
		*v = DecisionTaskFailedCauseBadCancelTimerAttributes
		return nil
	case "BAD_RECORD_MARKER_ATTRIBUTES":
		*v = DecisionTaskFailedCauseBadRecordMarkerAttributes
		return nil
	case "BAD_COMPLETE_WORKFLOW_EXECUTION_ATTRIBUTES":
		*v = DecisionTaskFailedCauseBadCompleteWorkflowExecutionAttributes
		return nil
	case "BAD_FAIL_WORKFLOW_EXECUTION_ATTRIBUTES":
		*v = DecisionTaskFailedCauseBadFailWorkflowExecutionAttributes
		return nil
	case "BAD_CANCEL_WORKFLOW_EXECUTION_ATTRIBUTES":
		*v = DecisionTaskFailedCauseBadCancelWorkflowExecutionAttributes
		return nil
	case "BAD_REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_ATTRIBUTES":
		*v = DecisionTaskFailedCauseBadRequestCancelExternalWorkflowExecutionAttributes
		return nil
	case "BAD_CONTINUE_AS_NEW_ATTRIBUTES":
		*v = DecisionTaskFailedCauseBadContinueAsNewAttributes
		return nil
	case "START_TIMER_DUPLICATE_ID":
		*v = DecisionTaskFailedCauseStartTimerDuplicateID
		return nil
	case "RESET_STICKY_TASKLIST":
		*v = DecisionTaskFailedCauseResetStickyTasklist
		return nil
	case "WORKFLOW_WORKER_UNHANDLED_FAILURE":
		*v = DecisionTaskFailedCauseWorkflowWorkerUnhandledFailure
		return nil
	case "BAD_SIGNAL_WORKFLOW_EXECUTION_ATTRIBUTES":
		*v = DecisionTaskFailedCauseBadSignalWorkflowExecutionAttributes
		return nil
	case "BAD_START_CHILD_EXECUTION_ATTRIBUTES":
		*v = DecisionTaskFailedCauseBadStartChildExecutionAttributes
		return nil
	case "FORCE_CLOSE_DECISION":
		*v = DecisionTaskFailedCauseForceCloseDecision
		return nil
	case "FAILOVER_CLOSE_DECISION":
		*v = DecisionTaskFailedCauseFailoverCloseDecision
		return nil
	case "BAD_SIGNAL_INPUT_SIZE":
		*v = DecisionTaskFailedCauseBadSignalInputSize
		return nil
	case "RESET_WORKFLOW":
		*v = DecisionTaskFailedCauseResetWorkflow
		return nil
	case "BAD_BINARY":
		*v = DecisionTaskFailedCauseBadBinary
		return nil
	default:
		val, err := strconv.ParseInt(s, 10, 32)
		if err != nil {
			return fmt.Errorf("unknown enum value %q for %q: %v", s, "DecisionTaskFailedCause", err)
		}
		*v = DecisionTaskFailedCause(val)
		return nil
	}
}

// MarshalText encodes DecisionTaskFailedCause to text.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements the TextMarshaler interface.
func (v DecisionTaskFailedCause) MarshalText() ([]byte, error) {
	switch int32(v) {
	case 0:
		return []byte("UNHANDLED_DECISION"), nil
	case 1:
		return []byte("BAD_SCHEDULE_ACTIVITY_ATTRIBUTES"), nil
	case 2:
		return []byte("BAD_REQUEST_CANCEL_ACTIVITY_ATTRIBUTES"), nil
	case 3:
		return []byte("BAD_START_TIMER_ATTRIBUTES"), nil
	case 4:
		return []byte("BAD_CANCEL_TIMER_ATTRIBUTES"), nil
	case 5:
		return []byte("BAD_RECORD_MARKER_ATTRIBUTES"), nil
	case 6:
		return []byte("BAD_COMPLETE_WORKFLOW_EXECUTION_ATTRIBUTES"), nil
	case 7:
		return []byte("BAD_FAIL_WORKFLOW_EXECUTION_ATTRIBUTES"), nil
	case 8:
		return []byte("BAD_CANCEL_WORKFLOW_EXECUTION_ATTRIBUTES"), nil
	case 9:
		return []byte("BAD_REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_ATTRIBUTES"), nil
	case 10:
		return []byte("BAD_CONTINUE_AS_NEW_ATTRIBUTES"), nil
	case 11:
		return []byte("START_TIMER_DUPLICATE_ID"), nil
	case 12:
		return []byte("RESET_STICKY_TASKLIST"), nil
	case 13:
		return []byte("WORKFLOW_WORKER_UNHANDLED_FAILURE"), nil
	case 14:
		return []byte("BAD_SIGNAL_WORKFLOW_EXECUTION_ATTRIBUTES"), nil
	case 15:
		return []byte("BAD_START_CHILD_EXECUTION_ATTRIBUTES"), nil
	case 16:
		return []byte("FORCE_CLOSE_DECISION"), nil
	case 17:
		return []byte("FAILOVER_CLOSE_DECISION"), nil
	case 18:
		return []byte("BAD_SIGNAL_INPUT_SIZE"), nil
	case 19:
		return []byte("RESET_WORKFLOW"), nil
	case 20:
		return []byte("BAD_BINARY"), nil
	}
	return []byte(strconv.FormatInt(int64(v), 10)), nil
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DecisionTaskFailedCause.
// Enums are logged as objects, where the value is logged with key "value", and
// if this value's name is known, the name is logged with key "name".
func (v DecisionTaskFailedCause) MarshalLogObject(enc zapcore.ObjectEncoder) error {
	enc.AddInt32("value", int32(v))
	switch int32(v) {
	case 0:
		enc.AddString("name", "UNHANDLED_DECISION")
	case 1:
		enc.AddString("name", "BAD_SCHEDULE_ACTIVITY_ATTRIBUTES")
	case 2:
		enc.AddString("name", "BAD_REQUEST_CANCEL_ACTIVITY_ATTRIBUTES")
	case 3:
		enc.AddString("name", "BAD_START_TIMER_ATTRIBUTES")
	case 4:
		enc.AddString("name", "BAD_CANCEL_TIMER_ATTRIBUTES")
	case 5:
		enc.AddString("name", "BAD_RECORD_MARKER_ATTRIBUTES")
	case 6:
		enc.AddString("name", "BAD_COMPLETE_WORKFLOW_EXECUTION_ATTRIBUTES")
	case 7:
		enc.AddString("name", "BAD_FAIL_WORKFLOW_EXECUTION_ATTRIBUTES")
	case 8:
		enc.AddString("name", "BAD_CANCEL_WORKFLOW_EXECUTION_ATTRIBUTES")
	case 9:
		enc.AddString("name", "BAD_REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_ATTRIBUTES")
	case 10:
		enc.AddString("name", "BAD_CONTINUE_AS_NEW_ATTRIBUTES")
	case 11:
		enc.AddString("name", "START_TIMER_DUPLICATE_ID")
	case 12:
		enc.AddString("name", "RESET_STICKY_TASKLIST")
	case 13:
		enc.AddString("name", "WORKFLOW_WORKER_UNHANDLED_FAILURE")
	case 14:
		enc.AddString("name", "BAD_SIGNAL_WORKFLOW_EXECUTION_ATTRIBUTES")
	case 15:
		enc.AddString("name", "BAD_START_CHILD_EXECUTION_ATTRIBUTES")
	case 16:
		enc.AddString("name", "FORCE_CLOSE_DECISION")
	case 17:
		enc.AddString("name", "FAILOVER_CLOSE_DECISION")
	case 18:
		enc.AddString("name", "BAD_SIGNAL_INPUT_SIZE")
	case 19:
		enc.AddString("name", "RESET_WORKFLOW")
	case 20:
		enc.AddString("name", "BAD_BINARY")
	}
	return nil
}

// Ptr returns a pointer to this enum value.
func (v DecisionTaskFailedCause) Ptr() *DecisionTaskFailedCause {
	return &v
}

// ToWire translates DecisionTaskFailedCause into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// Enums are represented as 32-bit integers over the wire.
func (v DecisionTaskFailedCause) ToWire() (wire.Value, error) {
	return wire.NewValueI32(int32(v)), nil
}

// FromWire deserializes DecisionTaskFailedCause from its Thrift-level
// representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TI32)
//   if err != nil {
//     return DecisionTaskFailedCause(0), err
//   }
//
//   var v DecisionTaskFailedCause
//   if err := v.FromWire(x); err != nil {
//     return DecisionTaskFailedCause(0), err
//   }
//   return v, nil
func (v *DecisionTaskFailedCause) FromWire(w wire.Value) error {
	*v = (DecisionTaskFailedCause)(w.GetI32())
	return nil
}

// String returns a readable string representation of DecisionTaskFailedCause.
func (v DecisionTaskFailedCause) String() string {
	w := int32(v)
	switch w {
	case 0:
		return "UNHANDLED_DECISION"
	case 1:
		return "BAD_SCHEDULE_ACTIVITY_ATTRIBUTES"
	case 2:
		return "BAD_REQUEST_CANCEL_ACTIVITY_ATTRIBUTES"
	case 3:
		return "BAD_START_TIMER_ATTRIBUTES"
	case 4:
		return "BAD_CANCEL_TIMER_ATTRIBUTES"
	case 5:
		return "BAD_RECORD_MARKER_ATTRIBUTES"
	case 6:
		return "BAD_COMPLETE_WORKFLOW_EXECUTION_ATTRIBUTES"
	case 7:
		return "BAD_FAIL_WORKFLOW_EXECUTION_ATTRIBUTES"
	case 8:
		return "BAD_CANCEL_WORKFLOW_EXECUTION_ATTRIBUTES"
	case 9:
		return "BAD_REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_ATTRIBUTES"
	case 10:
		return "BAD_CONTINUE_AS_NEW_ATTRIBUTES"
	case 11:
		return "START_TIMER_DUPLICATE_ID"
	case 12:
		return "RESET_STICKY_TASKLIST"
	case 13:
		return "WORKFLOW_WORKER_UNHANDLED_FAILURE"
	case 14:
		return "BAD_SIGNAL_WORKFLOW_EXECUTION_ATTRIBUTES"
	case 15:
		return "BAD_START_CHILD_EXECUTION_ATTRIBUTES"
	case 16:
		return "FORCE_CLOSE_DECISION"
	case 17:
		return "FAILOVER_CLOSE_DECISION"
	case 18:
		return "BAD_SIGNAL_INPUT_SIZE"
	case 19:
		return "RESET_WORKFLOW"
	case 20:
		return "BAD_BINARY"
	}
	return fmt.Sprintf("DecisionTaskFailedCause(%d)", w)
}

// Equals returns true if this DecisionTaskFailedCause value matches the provided
// value.
func (v DecisionTaskFailedCause) Equals(rhs DecisionTaskFailedCause) bool {
	return v == rhs
}

// MarshalJSON serializes DecisionTaskFailedCause into JSON.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements json.Marshaler.
func (v DecisionTaskFailedCause) MarshalJSON() ([]byte, error) {
	switch int32(v) {
	case 0:
		return ([]byte)("\"UNHANDLED_DECISION\""), nil
	case 1:
		return ([]byte)("\"BAD_SCHEDULE_ACTIVITY_ATTRIBUTES\""), nil
	case 2:
		return ([]byte)("\"BAD_REQUEST_CANCEL_ACTIVITY_ATTRIBUTES\""), nil
	case 3:
		return ([]byte)("\"BAD_START_TIMER_ATTRIBUTES\""), nil
	case 4:
		return ([]byte)("\"BAD_CANCEL_TIMER_ATTRIBUTES\""), nil
	case 5:
		return ([]byte)("\"BAD_RECORD_MARKER_ATTRIBUTES\""), nil
	case 6:
		return ([]byte)("\"BAD_COMPLETE_WORKFLOW_EXECUTION_ATTRIBUTES\""), nil
	case 7:
		return ([]byte)("\"BAD_FAIL_WORKFLOW_EXECUTION_ATTRIBUTES\""), nil
	case 8:
		return ([]byte)("\"BAD_CANCEL_WORKFLOW_EXECUTION_ATTRIBUTES\""), nil
	case 9:
		return ([]byte)("\"BAD_REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_ATTRIBUTES\""), nil
	case 10:
		return ([]byte)("\"BAD_CONTINUE_AS_NEW_ATTRIBUTES\""), nil
	case 11:
		return ([]byte)("\"START_TIMER_DUPLICATE_ID\""), nil
	case 12:
		return ([]byte)("\"RESET_STICKY_TASKLIST\""), nil
	case 13:
		return ([]byte)("\"WORKFLOW_WORKER_UNHANDLED_FAILURE\""), nil
	case 14:
		return ([]byte)("\"BAD_SIGNAL_WORKFLOW_EXECUTION_ATTRIBUTES\""), nil
	case 15:
		return ([]byte)("\"BAD_START_CHILD_EXECUTION_ATTRIBUTES\""), nil
	case 16:
		return ([]byte)("\"FORCE_CLOSE_DECISION\""), nil
	case 17:
		return ([]byte)("\"FAILOVER_CLOSE_DECISION\""), nil
	case 18:
		return ([]byte)("\"BAD_SIGNAL_INPUT_SIZE\""), nil
	case 19:
		return ([]byte)("\"RESET_WORKFLOW\""), nil
	case 20:
		return ([]byte)("\"BAD_BINARY\""), nil
	}
	return ([]byte)(strconv.FormatInt(int64(v), 10)), nil
}

// UnmarshalJSON attempts to decode DecisionTaskFailedCause from its JSON
// representation.
//
// This implementation supports both, numeric and string inputs. If a
// string is provided, it must be a known enum name.
//
// This implements json.Unmarshaler.
func (v *DecisionTaskFailedCause) UnmarshalJSON(text []byte) error {
	d := json.NewDecoder(bytes.NewReader(text))
	d.UseNumber()
	t, err := d.Token()
	if err != nil {
		return err
	}

	switch w := t.(type) {
	case json.Number:
		x, err := w.Int64()
		if err != nil {
			return err
		}
		if x > math.MaxInt32 {
			return fmt.Errorf("enum overflow from JSON %q for %q", text, "DecisionTaskFailedCause")
		}
		if x < math.MinInt32 {
			return fmt.Errorf("enum underflow from JSON %q for %q", text, "DecisionTaskFailedCause")
		}
		*v = (DecisionTaskFailedCause)(x)
		return nil
	case string:
		return v.UnmarshalText([]byte(w))
	default:
		return fmt.Errorf("invalid JSON value %q (%T) to unmarshal into %q", t, t, "DecisionTaskFailedCause")
	}
}

type DecisionTaskFailedEventAttributes struct {
	ScheduledEventId *int64                   `json:"scheduledEventId,omitempty"`
	StartedEventId   *int64                   `json:"startedEventId,omitempty"`
	Cause            *DecisionTaskFailedCause `json:"cause,omitempty"`
	Details          []byte                   `json:"details,omitempty"`
	Identity         *string                  `json:"identity,omitempty"`
	Reason           *string                  `json:"reason,omitempty"`
	BaseRunId        *string                  `json:"baseRunId,omitempty"`
	NewRunId         *string                  `json:"newRunId,omitempty"`
	ForkEventVersion *int64                   `json:"forkEventVersion,omitempty"`
}

// ToWire translates a DecisionTaskFailedEventAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *DecisionTaskFailedEventAttributes) ToWire() (wire.Value, error) {
	var (
		fields [9]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.ScheduledEventId != nil {
		w, err = wire.NewValueI64(*(v.ScheduledEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.StartedEventId != nil {
		w, err = wire.NewValueI64(*(v.StartedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.Cause != nil {
		w, err = v.Cause.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.Details != nil {
		w, err = wire.NewValueBinary(v.Details), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 35, Value: w}
		i++
	}
	if v.Identity != nil {
		w, err = wire.NewValueString(*(v.Identity)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.Reason != nil {
		w, err = wire.NewValueString(*(v.Reason)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.BaseRunId != nil {
		w, err = wire.NewValueString(*(v.BaseRunId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}
	if v.NewRunId != nil {
		w, err = wire.NewValueString(*(v.NewRunId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 70, Value: w}
		i++
	}
	if v.ForkEventVersion != nil {
		w, err = wire.NewValueI64(*(v.ForkEventVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 80, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _DecisionTaskFailedCause_Read(w wire.Value) (DecisionTaskFailedCause, error) {
	var v DecisionTaskFailedCause
	err := v.FromWire(w)
	return v, err
}

// FromWire deserializes a DecisionTaskFailedEventAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a DecisionTaskFailedEventAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v DecisionTaskFailedEventAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *DecisionTaskFailedEventAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduledEventId = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StartedEventId = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI32 {
				var x DecisionTaskFailedCause
				x, err = _DecisionTaskFailedCause_Read(field.Value)
				v.Cause = &x
				if err != nil {
					return err
				}

			}
		case 35:
			if field.Value.Type() == wire.TBinary {
				v.Details, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Identity = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Reason = &x
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.BaseRunId = &x
				if err != nil {
					return err
				}

			}
		case 70:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.NewRunId = &x
				if err != nil {
					return err
				}

			}
		case 80:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ForkEventVersion = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a DecisionTaskFailedEventAttributes
// struct.
func (v *DecisionTaskFailedEventAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [9]string
	i := 0
	if v.ScheduledEventId != nil {
		fields[i] = fmt.Sprintf("ScheduledEventId: %v", *(v.ScheduledEventId))
		i++
	}
	if v.StartedEventId != nil {
		fields[i] = fmt.Sprintf("StartedEventId: %v", *(v.StartedEventId))
		i++
	}
	if v.Cause != nil {
		fields[i] = fmt.Sprintf("Cause: %v", *(v.Cause))
		i++
	}
	if v.Details != nil {
		fields[i] = fmt.Sprintf("Details: %v", v.Details)
		i++
	}
	if v.Identity != nil {
		fields[i] = fmt.Sprintf("Identity: %v", *(v.Identity))
		i++
	}
	if v.Reason != nil {
		fields[i] = fmt.Sprintf("Reason: %v", *(v.Reason))
		i++
	}
	if v.BaseRunId != nil {
		fields[i] = fmt.Sprintf("BaseRunId: %v", *(v.BaseRunId))
		i++
	}
	if v.NewRunId != nil {
		fields[i] = fmt.Sprintf("NewRunId: %v", *(v.NewRunId))
		i++
	}
	if v.ForkEventVersion != nil {
		fields[i] = fmt.Sprintf("ForkEventVersion: %v", *(v.ForkEventVersion))
		i++
	}

	return fmt.Sprintf("DecisionTaskFailedEventAttributes{%v}", strings.Join(fields[:i], ", "))
}

func _DecisionTaskFailedCause_EqualsPtr(lhs, rhs *DecisionTaskFailedCause) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return x.Equals(y)
	}
	return lhs == nil && rhs == nil
}

// Equals returns true if all the fields of this DecisionTaskFailedEventAttributes match the
// provided DecisionTaskFailedEventAttributes.
//
// This function performs a deep comparison.
func (v *DecisionTaskFailedEventAttributes) Equals(rhs *DecisionTaskFailedEventAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduledEventId, rhs.ScheduledEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.StartedEventId, rhs.StartedEventId) {
		return false
	}
	if !_DecisionTaskFailedCause_EqualsPtr(v.Cause, rhs.Cause) {
		return false
	}
	if !((v.Details == nil && rhs.Details == nil) || (v.Details != nil && rhs.Details != nil && bytes.Equal(v.Details, rhs.Details))) {
		return false
	}
	if !_String_EqualsPtr(v.Identity, rhs.Identity) {
		return false
	}
	if !_String_EqualsPtr(v.Reason, rhs.Reason) {
		return false
	}
	if !_String_EqualsPtr(v.BaseRunId, rhs.BaseRunId) {
		return false
	}
	if !_String_EqualsPtr(v.NewRunId, rhs.NewRunId) {
		return false
	}
	if !_I64_EqualsPtr(v.ForkEventVersion, rhs.ForkEventVersion) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DecisionTaskFailedEventAttributes.
func (v *DecisionTaskFailedEventAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.ScheduledEventId != nil {
		enc.AddInt64("scheduledEventId", *v.ScheduledEventId)
	}
	if v.StartedEventId != nil {
		enc.AddInt64("startedEventId", *v.StartedEventId)
	}
	if v.Cause != nil {
		err = multierr.Append(err, enc.AddObject("cause", *v.Cause))
	}
	if v.Details != nil {
		enc.AddString("details", base64.StdEncoding.EncodeToString(v.Details))
	}
	if v.Identity != nil {
		enc.AddString("identity", *v.Identity)
	}
	if v.Reason != nil {
		enc.AddString("reason", *v.Reason)
	}
	if v.BaseRunId != nil {
		enc.AddString("baseRunId", *v.BaseRunId)
	}
	if v.NewRunId != nil {
		enc.AddString("newRunId", *v.NewRunId)
	}
	if v.ForkEventVersion != nil {
		enc.AddInt64("forkEventVersion", *v.ForkEventVersion)
	}
	return err
}

// GetScheduledEventId returns the value of ScheduledEventId if it is set or its
// zero value if it is unset.
func (v *DecisionTaskFailedEventAttributes) GetScheduledEventId() (o int64) {
	if v != nil && v.ScheduledEventId != nil {
		return *v.ScheduledEventId
	}

	return
}

// IsSetScheduledEventId returns true if ScheduledEventId is not nil.
func (v *DecisionTaskFailedEventAttributes) IsSetScheduledEventId() bool {
	return v != nil && v.ScheduledEventId != nil
}

// GetStartedEventId returns the value of StartedEventId if it is set or its
// zero value if it is unset.
func (v *DecisionTaskFailedEventAttributes) GetStartedEventId() (o int64) {
	if v != nil && v.StartedEventId != nil {
		return *v.StartedEventId
	}

	return
}

// IsSetStartedEventId returns true if StartedEventId is not nil.
func (v *DecisionTaskFailedEventAttributes) IsSetStartedEventId() bool {
	return v != nil && v.StartedEventId != nil
}

// GetCause returns the value of Cause if it is set or its
// zero value if it is unset.
func (v *DecisionTaskFailedEventAttributes) GetCause() (o DecisionTaskFailedCause) {
	if v != nil && v.Cause != nil {
		return *v.Cause
	}

	return
}

// IsSetCause returns true if Cause is not nil.
func (v *DecisionTaskFailedEventAttributes) IsSetCause() bool {
	return v != nil && v.Cause != nil
}

// GetDetails returns the value of Details if it is set or its
// zero value if it is unset.
func (v *DecisionTaskFailedEventAttributes) GetDetails() (o []byte) {
	if v != nil && v.Details != nil {
		return v.Details
	}

	return
}

// IsSetDetails returns true if Details is not nil.
func (v *DecisionTaskFailedEventAttributes) IsSetDetails() bool {
	return v != nil && v.Details != nil
}

// GetIdentity returns the value of Identity if it is set or its
// zero value if it is unset.
func (v *DecisionTaskFailedEventAttributes) GetIdentity() (o string) {
	if v != nil && v.Identity != nil {
		return *v.Identity
	}

	return
}

// IsSetIdentity returns true if Identity is not nil.
func (v *DecisionTaskFailedEventAttributes) IsSetIdentity() bool {
	return v != nil && v.Identity != nil
}

// GetReason returns the value of Reason if it is set or its
// zero value if it is unset.
func (v *DecisionTaskFailedEventAttributes) GetReason() (o string) {
	if v != nil && v.Reason != nil {
		return *v.Reason
	}

	return
}

// IsSetReason returns true if Reason is not nil.
func (v *DecisionTaskFailedEventAttributes) IsSetReason() bool {
	return v != nil && v.Reason != nil
}

// GetBaseRunId returns the value of BaseRunId if it is set or its
// zero value if it is unset.
func (v *DecisionTaskFailedEventAttributes) GetBaseRunId() (o string) {
	if v != nil && v.BaseRunId != nil {
		return *v.BaseRunId
	}

	return
}

// IsSetBaseRunId returns true if BaseRunId is not nil.
func (v *DecisionTaskFailedEventAttributes) IsSetBaseRunId() bool {
	return v != nil && v.BaseRunId != nil
}

// GetNewRunId returns the value of NewRunId if it is set or its
// zero value if it is unset.
func (v *DecisionTaskFailedEventAttributes) GetNewRunId() (o string) {
	if v != nil && v.NewRunId != nil {
		return *v.NewRunId
	}

	return
}

// IsSetNewRunId returns true if NewRunId is not nil.
func (v *DecisionTaskFailedEventAttributes) IsSetNewRunId() bool {
	return v != nil && v.NewRunId != nil
}

// GetForkEventVersion returns the value of ForkEventVersion if it is set or its
// zero value if it is unset.
func (v *DecisionTaskFailedEventAttributes) GetForkEventVersion() (o int64) {
	if v != nil && v.ForkEventVersion != nil {
		return *v.ForkEventVersion
	}

	return
}

// IsSetForkEventVersion returns true if ForkEventVersion is not nil.
func (v *DecisionTaskFailedEventAttributes) IsSetForkEventVersion() bool {
	return v != nil && v.ForkEventVersion != nil
}

type DecisionTaskScheduledEventAttributes struct {
	TaskList                   *TaskList `json:"taskList,omitempty"`
	StartToCloseTimeoutSeconds *int32    `json:"startToCloseTimeoutSeconds,omitempty"`
	Attempt                    *int64    `json:"attempt,omitempty"`
}

// ToWire translates a DecisionTaskScheduledEventAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *DecisionTaskScheduledEventAttributes) ToWire() (wire.Value, error) {
	var (
		fields [3]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.TaskList != nil {
		w, err = v.TaskList.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.StartToCloseTimeoutSeconds != nil {
		w, err = wire.NewValueI32(*(v.StartToCloseTimeoutSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.Attempt != nil {
		w, err = wire.NewValueI64(*(v.Attempt)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a DecisionTaskScheduledEventAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a DecisionTaskScheduledEventAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v DecisionTaskScheduledEventAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *DecisionTaskScheduledEventAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TStruct {
				v.TaskList, err = _TaskList_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.StartToCloseTimeoutSeconds = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.Attempt = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a DecisionTaskScheduledEventAttributes
// struct.
func (v *DecisionTaskScheduledEventAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [3]string
	i := 0
	if v.TaskList != nil {
		fields[i] = fmt.Sprintf("TaskList: %v", v.TaskList)
		i++
	}
	if v.StartToCloseTimeoutSeconds != nil {
		fields[i] = fmt.Sprintf("StartToCloseTimeoutSeconds: %v", *(v.StartToCloseTimeoutSeconds))
		i++
	}
	if v.Attempt != nil {
		fields[i] = fmt.Sprintf("Attempt: %v", *(v.Attempt))
		i++
	}

	return fmt.Sprintf("DecisionTaskScheduledEventAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this DecisionTaskScheduledEventAttributes match the
// provided DecisionTaskScheduledEventAttributes.
//
// This function performs a deep comparison.
func (v *DecisionTaskScheduledEventAttributes) Equals(rhs *DecisionTaskScheduledEventAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.TaskList == nil && rhs.TaskList == nil) || (v.TaskList != nil && rhs.TaskList != nil && v.TaskList.Equals(rhs.TaskList))) {
		return false
	}
	if !_I32_EqualsPtr(v.StartToCloseTimeoutSeconds, rhs.StartToCloseTimeoutSeconds) {
		return false
	}
	if !_I64_EqualsPtr(v.Attempt, rhs.Attempt) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DecisionTaskScheduledEventAttributes.
func (v *DecisionTaskScheduledEventAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.TaskList != nil {
		err = multierr.Append(err, enc.AddObject("taskList", v.TaskList))
	}
	if v.StartToCloseTimeoutSeconds != nil {
		enc.AddInt32("startToCloseTimeoutSeconds", *v.StartToCloseTimeoutSeconds)
	}
	if v.Attempt != nil {
		enc.AddInt64("attempt", *v.Attempt)
	}
	return err
}

// GetTaskList returns the value of TaskList if it is set or its
// zero value if it is unset.
func (v *DecisionTaskScheduledEventAttributes) GetTaskList() (o *TaskList) {
	if v != nil && v.TaskList != nil {
		return v.TaskList
	}

	return
}

// IsSetTaskList returns true if TaskList is not nil.
func (v *DecisionTaskScheduledEventAttributes) IsSetTaskList() bool {
	return v != nil && v.TaskList != nil
}

// GetStartToCloseTimeoutSeconds returns the value of StartToCloseTimeoutSeconds if it is set or its
// zero value if it is unset.
func (v *DecisionTaskScheduledEventAttributes) GetStartToCloseTimeoutSeconds() (o int32) {
	if v != nil && v.StartToCloseTimeoutSeconds != nil {
		return *v.StartToCloseTimeoutSeconds
	}

	return
}

// IsSetStartToCloseTimeoutSeconds returns true if StartToCloseTimeoutSeconds is not nil.
func (v *DecisionTaskScheduledEventAttributes) IsSetStartToCloseTimeoutSeconds() bool {
	return v != nil && v.StartToCloseTimeoutSeconds != nil
}

// GetAttempt returns the value of Attempt if it is set or its
// zero value if it is unset.
func (v *DecisionTaskScheduledEventAttributes) GetAttempt() (o int64) {
	if v != nil && v.Attempt != nil {
		return *v.Attempt
	}

	return
}

// IsSetAttempt returns true if Attempt is not nil.
func (v *DecisionTaskScheduledEventAttributes) IsSetAttempt() bool {
	return v != nil && v.Attempt != nil
}

type DecisionTaskStartedEventAttributes struct {
	ScheduledEventId *int64  `json:"scheduledEventId,omitempty"`
	Identity         *string `json:"identity,omitempty"`
	RequestId        *string `json:"requestId,omitempty"`
}

// ToWire translates a DecisionTaskStartedEventAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *DecisionTaskStartedEventAttributes) ToWire() (wire.Value, error) {
	var (
		fields [3]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.ScheduledEventId != nil {
		w, err = wire.NewValueI64(*(v.ScheduledEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Identity != nil {
		w, err = wire.NewValueString(*(v.Identity)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.RequestId != nil {
		w, err = wire.NewValueString(*(v.RequestId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a DecisionTaskStartedEventAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a DecisionTaskStartedEventAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v DecisionTaskStartedEventAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *DecisionTaskStartedEventAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduledEventId = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Identity = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.RequestId = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a DecisionTaskStartedEventAttributes
// struct.
func (v *DecisionTaskStartedEventAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [3]string
	i := 0
	if v.ScheduledEventId != nil {
		fields[i] = fmt.Sprintf("ScheduledEventId: %v", *(v.ScheduledEventId))
		i++
	}
	if v.Identity != nil {
		fields[i] = fmt.Sprintf("Identity: %v", *(v.Identity))
		i++
	}
	if v.RequestId != nil {
		fields[i] = fmt.Sprintf("RequestId: %v", *(v.RequestId))
		i++
	}

	return fmt.Sprintf("DecisionTaskStartedEventAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this DecisionTaskStartedEventAttributes match the
// provided DecisionTaskStartedEventAttributes.
//
// This function performs a deep comparison.
func (v *DecisionTaskStartedEventAttributes) Equals(rhs *DecisionTaskStartedEventAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduledEventId, rhs.ScheduledEventId) {
		return false
	}
	if !_String_EqualsPtr(v.Identity, rhs.Identity) {
		return false
	}
	if !_String_EqualsPtr(v.RequestId, rhs.RequestId) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DecisionTaskStartedEventAttributes.
func (v *DecisionTaskStartedEventAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.ScheduledEventId != nil {
		enc.AddInt64("scheduledEventId", *v.ScheduledEventId)
	}
	if v.Identity != nil {
		enc.AddString("identity", *v.Identity)
	}
	if v.RequestId != nil {
		enc.AddString("requestId", *v.RequestId)
	}
	return err
}

// GetScheduledEventId returns the value of ScheduledEventId if it is set or its
// zero value if it is unset.
func (v *DecisionTaskStartedEventAttributes) GetScheduledEventId() (o int64) {
	if v != nil && v.ScheduledEventId != nil {
		return *v.ScheduledEventId
	}

	return
}

// IsSetScheduledEventId returns true if ScheduledEventId is not nil.
func (v *DecisionTaskStartedEventAttributes) IsSetScheduledEventId() bool {
	return v != nil && v.ScheduledEventId != nil
}

// GetIdentity returns the value of Identity if it is set or its
// zero value if it is unset.
func (v *DecisionTaskStartedEventAttributes) GetIdentity() (o string) {
	if v != nil && v.Identity != nil {
		return *v.Identity
	}

	return
}

// IsSetIdentity returns true if Identity is not nil.
func (v *DecisionTaskStartedEventAttributes) IsSetIdentity() bool {
	return v != nil && v.Identity != nil
}

// GetRequestId returns the value of RequestId if it is set or its
// zero value if it is unset.
func (v *DecisionTaskStartedEventAttributes) GetRequestId() (o string) {
	if v != nil && v.RequestId != nil {
		return *v.RequestId
	}

	return
}

// IsSetRequestId returns true if RequestId is not nil.
func (v *DecisionTaskStartedEventAttributes) IsSetRequestId() bool {
	return v != nil && v.RequestId != nil
}

type DecisionTaskTimedOutEventAttributes struct {
	ScheduledEventId *int64       `json:"scheduledEventId,omitempty"`
	StartedEventId   *int64       `json:"startedEventId,omitempty"`
	TimeoutType      *TimeoutType `json:"timeoutType,omitempty"`
}

// ToWire translates a DecisionTaskTimedOutEventAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *DecisionTaskTimedOutEventAttributes) ToWire() (wire.Value, error) {
	var (
		fields [3]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.ScheduledEventId != nil {
		w, err = wire.NewValueI64(*(v.ScheduledEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.StartedEventId != nil {
		w, err = wire.NewValueI64(*(v.StartedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.TimeoutType != nil {
		w, err = v.TimeoutType.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a DecisionTaskTimedOutEventAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a DecisionTaskTimedOutEventAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v DecisionTaskTimedOutEventAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *DecisionTaskTimedOutEventAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduledEventId = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StartedEventId = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI32 {
				var x TimeoutType
				x, err = _TimeoutType_Read(field.Value)
				v.TimeoutType = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a DecisionTaskTimedOutEventAttributes
// struct.
func (v *DecisionTaskTimedOutEventAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [3]string
	i := 0
	if v.ScheduledEventId != nil {
		fields[i] = fmt.Sprintf("ScheduledEventId: %v", *(v.ScheduledEventId))
		i++
	}
	if v.StartedEventId != nil {
		fields[i] = fmt.Sprintf("StartedEventId: %v", *(v.StartedEventId))
		i++
	}
	if v.TimeoutType != nil {
		fields[i] = fmt.Sprintf("TimeoutType: %v", *(v.TimeoutType))
		i++
	}

	return fmt.Sprintf("DecisionTaskTimedOutEventAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this DecisionTaskTimedOutEventAttributes match the
// provided DecisionTaskTimedOutEventAttributes.
//
// This function performs a deep comparison.
func (v *DecisionTaskTimedOutEventAttributes) Equals(rhs *DecisionTaskTimedOutEventAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduledEventId, rhs.ScheduledEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.StartedEventId, rhs.StartedEventId) {
		return false
	}
	if !_TimeoutType_EqualsPtr(v.TimeoutType, rhs.TimeoutType) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DecisionTaskTimedOutEventAttributes.
func (v *DecisionTaskTimedOutEventAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.ScheduledEventId != nil {
		enc.AddInt64("scheduledEventId", *v.ScheduledEventId)
	}
	if v.StartedEventId != nil {
		enc.AddInt64("startedEventId", *v.StartedEventId)
	}
	if v.TimeoutType != nil {
		err = multierr.Append(err, enc.AddObject("timeoutType", *v.TimeoutType))
	}
	return err
}

// GetScheduledEventId returns the value of ScheduledEventId if it is set or its
// zero value if it is unset.
func (v *DecisionTaskTimedOutEventAttributes) GetScheduledEventId() (o int64) {
	if v != nil && v.ScheduledEventId != nil {
		return *v.ScheduledEventId
	}

	return
}

// IsSetScheduledEventId returns true if ScheduledEventId is not nil.
func (v *DecisionTaskTimedOutEventAttributes) IsSetScheduledEventId() bool {
	return v != nil && v.ScheduledEventId != nil
}

// GetStartedEventId returns the value of StartedEventId if it is set or its
// zero value if it is unset.
func (v *DecisionTaskTimedOutEventAttributes) GetStartedEventId() (o int64) {
	if v != nil && v.StartedEventId != nil {
		return *v.StartedEventId
	}

	return
}

// IsSetStartedEventId returns true if StartedEventId is not nil.
func (v *DecisionTaskTimedOutEventAttributes) IsSetStartedEventId() bool {
	return v != nil && v.StartedEventId != nil
}

// GetTimeoutType returns the value of TimeoutType if it is set or its
// zero value if it is unset.
func (v *DecisionTaskTimedOutEventAttributes) GetTimeoutType() (o TimeoutType) {
	if v != nil && v.TimeoutType != nil {
		return *v.TimeoutType
	}

	return
}

// IsSetTimeoutType returns true if TimeoutType is not nil.
func (v *DecisionTaskTimedOutEventAttributes) IsSetTimeoutType() bool {
	return v != nil && v.TimeoutType != nil
}

type DecisionType int32

const (
	DecisionTypeScheduleActivityTask                   DecisionType = 0
	DecisionTypeRequestCancelActivityTask              DecisionType = 1
	DecisionTypeStartTimer                             DecisionType = 2
	DecisionTypeCompleteWorkflowExecution              DecisionType = 3
	DecisionTypeFailWorkflowExecution                  DecisionType = 4
	DecisionTypeCancelTimer                            DecisionType = 5
	DecisionTypeCancelWorkflowExecution                DecisionType = 6
	DecisionTypeRequestCancelExternalWorkflowExecution DecisionType = 7
	DecisionTypeRecordMarker                           DecisionType = 8
	DecisionTypeContinueAsNewWorkflowExecution         DecisionType = 9
	DecisionTypeStartChildWorkflowExecution            DecisionType = 10
	DecisionTypeSignalExternalWorkflowExecution        DecisionType = 11
)

// DecisionType_Values returns all recognized values of DecisionType.
func DecisionType_Values() []DecisionType {
	return []DecisionType{
		DecisionTypeScheduleActivityTask,
		DecisionTypeRequestCancelActivityTask,
		DecisionTypeStartTimer,
		DecisionTypeCompleteWorkflowExecution,
		DecisionTypeFailWorkflowExecution,
		DecisionTypeCancelTimer,
		DecisionTypeCancelWorkflowExecution,
		DecisionTypeRequestCancelExternalWorkflowExecution,
		DecisionTypeRecordMarker,
		DecisionTypeContinueAsNewWorkflowExecution,
		DecisionTypeStartChildWorkflowExecution,
		DecisionTypeSignalExternalWorkflowExecution,
	}
}

// UnmarshalText tries to decode DecisionType from a byte slice
// containing its name.
//
//   var v DecisionType
//   err := v.UnmarshalText([]byte("ScheduleActivityTask"))
func (v *DecisionType) UnmarshalText(value []byte) error {
	switch s := string(value); s {
	case "ScheduleActivityTask":
		*v = DecisionTypeScheduleActivityTask
		return nil
	case "RequestCancelActivityTask":
		*v = DecisionTypeRequestCancelActivityTask
		return nil
	case "StartTimer":
		*v = DecisionTypeStartTimer
		return nil
	case "CompleteWorkflowExecution":
		*v = DecisionTypeCompleteWorkflowExecution
		return nil
	case "FailWorkflowExecution":
		*v = DecisionTypeFailWorkflowExecution
		return nil
	case "CancelTimer":
		*v = DecisionTypeCancelTimer
		return nil
	case "CancelWorkflowExecution":
		*v = DecisionTypeCancelWorkflowExecution
		return nil
	case "RequestCancelExternalWorkflowExecution":
		*v = DecisionTypeRequestCancelExternalWorkflowExecution
		return nil
	case "RecordMarker":
		*v = DecisionTypeRecordMarker
		return nil
	case "ContinueAsNewWorkflowExecution":
		*v = DecisionTypeContinueAsNewWorkflowExecution
		return nil
	case "StartChildWorkflowExecution":
		*v = DecisionTypeStartChildWorkflowExecution
		return nil
	case "SignalExternalWorkflowExecution":
		*v = DecisionTypeSignalExternalWorkflowExecution
		return nil
	default:
		val, err := strconv.ParseInt(s, 10, 32)
		if err != nil {
			return fmt.Errorf("unknown enum value %q for %q: %v", s, "DecisionType", err)
		}
		*v = DecisionType(val)
		return nil
	}
}

// MarshalText encodes DecisionType to text.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements the TextMarshaler interface.
func (v DecisionType) MarshalText() ([]byte, error) {
	switch int32(v) {
	case 0:
		return []byte("ScheduleActivityTask"), nil
	case 1:
		return []byte("RequestCancelActivityTask"), nil
	case 2:
		return []byte("StartTimer"), nil
	case 3:
		return []byte("CompleteWorkflowExecution"), nil
	case 4:
		return []byte("FailWorkflowExecution"), nil
	case 5:
		return []byte("CancelTimer"), nil
	case 6:
		return []byte("CancelWorkflowExecution"), nil
	case 7:
		return []byte("RequestCancelExternalWorkflowExecution"), nil
	case 8:
		return []byte("RecordMarker"), nil
	case 9:
		return []byte("ContinueAsNewWorkflowExecution"), nil
	case 10:
		return []byte("StartChildWorkflowExecution"), nil
	case 11:
		return []byte("SignalExternalWorkflowExecution"), nil
	}
	return []byte(strconv.FormatInt(int64(v), 10)), nil
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DecisionType.
// Enums are logged as objects, where the value is logged with key "value", and
// if this value's name is known, the name is logged with key "name".
func (v DecisionType) MarshalLogObject(enc zapcore.ObjectEncoder) error {
	enc.AddInt32("value", int32(v))
	switch int32(v) {
	case 0:
		enc.AddString("name", "ScheduleActivityTask")
	case 1:
		enc.AddString("name", "RequestCancelActivityTask")
	case 2:
		enc.AddString("name", "StartTimer")
	case 3:
		enc.AddString("name", "CompleteWorkflowExecution")
	case 4:
		enc.AddString("name", "FailWorkflowExecution")
	case 5:
		enc.AddString("name", "CancelTimer")
	case 6:
		enc.AddString("name", "CancelWorkflowExecution")
	case 7:
		enc.AddString("name", "RequestCancelExternalWorkflowExecution")
	case 8:
		enc.AddString("name", "RecordMarker")
	case 9:
		enc.AddString("name", "ContinueAsNewWorkflowExecution")
	case 10:
		enc.AddString("name", "StartChildWorkflowExecution")
	case 11:
		enc.AddString("name", "SignalExternalWorkflowExecution")
	}
	return nil
}

// Ptr returns a pointer to this enum value.
func (v DecisionType) Ptr() *DecisionType {
	return &v
}

// ToWire translates DecisionType into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// Enums are represented as 32-bit integers over the wire.
func (v DecisionType) ToWire() (wire.Value, error) {
	return wire.NewValueI32(int32(v)), nil
}

// FromWire deserializes DecisionType from its Thrift-level
// representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TI32)
//   if err != nil {
//     return DecisionType(0), err
//   }
//
//   var v DecisionType
//   if err := v.FromWire(x); err != nil {
//     return DecisionType(0), err
//   }
//   return v, nil
func (v *DecisionType) FromWire(w wire.Value) error {
	*v = (DecisionType)(w.GetI32())
	return nil
}

// String returns a readable string representation of DecisionType.
func (v DecisionType) String() string {
	w := int32(v)
	switch w {
	case 0:
		return "ScheduleActivityTask"
	case 1:
		return "RequestCancelActivityTask"
	case 2:
		return "StartTimer"
	case 3:
		return "CompleteWorkflowExecution"
	case 4:
		return "FailWorkflowExecution"
	case 5:
		return "CancelTimer"
	case 6:
		return "CancelWorkflowExecution"
	case 7:
		return "RequestCancelExternalWorkflowExecution"
	case 8:
		return "RecordMarker"
	case 9:
		return "ContinueAsNewWorkflowExecution"
	case 10:
		return "StartChildWorkflowExecution"
	case 11:
		return "SignalExternalWorkflowExecution"
	}
	return fmt.Sprintf("DecisionType(%d)", w)
}

// Equals returns true if this DecisionType value matches the provided
// value.
func (v DecisionType) Equals(rhs DecisionType) bool {
	return v == rhs
}

// MarshalJSON serializes DecisionType into JSON.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements json.Marshaler.
func (v DecisionType) MarshalJSON() ([]byte, error) {
	switch int32(v) {
	case 0:
		return ([]byte)("\"ScheduleActivityTask\""), nil
	case 1:
		return ([]byte)("\"RequestCancelActivityTask\""), nil
	case 2:
		return ([]byte)("\"StartTimer\""), nil
	case 3:
		return ([]byte)("\"CompleteWorkflowExecution\""), nil
	case 4:
		return ([]byte)("\"FailWorkflowExecution\""), nil
	case 5:
		return ([]byte)("\"CancelTimer\""), nil
	case 6:
		return ([]byte)("\"CancelWorkflowExecution\""), nil
	case 7:
		return ([]byte)("\"RequestCancelExternalWorkflowExecution\""), nil
	case 8:
		return ([]byte)("\"RecordMarker\""), nil
	case 9:
		return ([]byte)("\"ContinueAsNewWorkflowExecution\""), nil
	case 10:
		return ([]byte)("\"StartChildWorkflowExecution\""), nil
	case 11:
		return ([]byte)("\"SignalExternalWorkflowExecution\""), nil
	}
	return ([]byte)(strconv.FormatInt(int64(v), 10)), nil
}

// UnmarshalJSON attempts to decode DecisionType from its JSON
// representation.
//
// This implementation supports both, numeric and string inputs. If a
// string is provided, it must be a known enum name.
//
// This implements json.Unmarshaler.
func (v *DecisionType) UnmarshalJSON(text []byte) error {
	d := json.NewDecoder(bytes.NewReader(text))
	d.UseNumber()
	t, err := d.Token()
	if err != nil {
		return err
	}

	switch w := t.(type) {
	case json.Number:
		x, err := w.Int64()
		if err != nil {
			return err
		}
		if x > math.MaxInt32 {
			return fmt.Errorf("enum overflow from JSON %q for %q", text, "DecisionType")
		}
		if x < math.MinInt32 {
			return fmt.Errorf("enum underflow from JSON %q for %q", text, "DecisionType")
		}
		*v = (DecisionType)(x)
		return nil
	case string:
		return v.UnmarshalText([]byte(w))
	default:
		return fmt.Errorf("invalid JSON value %q (%T) to unmarshal into %q", t, t, "DecisionType")
	}
}

type DeprecateDomainRequest struct {
	Name          *string `json:"name,omitempty"`
	SecurityToken *string `json:"securityToken,omitempty"`
}

// ToWire translates a DeprecateDomainRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *DeprecateDomainRequest) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Name != nil {
		w, err = wire.NewValueString(*(v.Name)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.SecurityToken != nil {
		w, err = wire.NewValueString(*(v.SecurityToken)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a DeprecateDomainRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a DeprecateDomainRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v DeprecateDomainRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *DeprecateDomainRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Name = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.SecurityToken = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a DeprecateDomainRequest
// struct.
func (v *DeprecateDomainRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.Name != nil {
		fields[i] = fmt.Sprintf("Name: %v", *(v.Name))
		i++
	}
	if v.SecurityToken != nil {
		fields[i] = fmt.Sprintf("SecurityToken: %v", *(v.SecurityToken))
		i++
	}

	return fmt.Sprintf("DeprecateDomainRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this DeprecateDomainRequest match the
// provided DeprecateDomainRequest.
//
// This function performs a deep comparison.
func (v *DeprecateDomainRequest) Equals(rhs *DeprecateDomainRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Name, rhs.Name) {
		return false
	}
	if !_String_EqualsPtr(v.SecurityToken, rhs.SecurityToken) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DeprecateDomainRequest.
func (v *DeprecateDomainRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Name != nil {
		enc.AddString("name", *v.Name)
	}
	if v.SecurityToken != nil {
		enc.AddString("securityToken", *v.SecurityToken)
	}
	return err
}

// GetName returns the value of Name if it is set or its
// zero value if it is unset.
func (v *DeprecateDomainRequest) GetName() (o string) {
	if v != nil && v.Name != nil {
		return *v.Name
	}

	return
}

// IsSetName returns true if Name is not nil.
func (v *DeprecateDomainRequest) IsSetName() bool {
	return v != nil && v.Name != nil
}

// GetSecurityToken returns the value of SecurityToken if it is set or its
// zero value if it is unset.
func (v *DeprecateDomainRequest) GetSecurityToken() (o string) {
	if v != nil && v.SecurityToken != nil {
		return *v.SecurityToken
	}

	return
}

// IsSetSecurityToken returns true if SecurityToken is not nil.
func (v *DeprecateDomainRequest) IsSetSecurityToken() bool {
	return v != nil && v.SecurityToken != nil
}

type DescribeDomainRequest struct {
	Name *string `json:"name,omitempty"`
	UUID *string `json:"uuid,omitempty"`
}

// ToWire translates a DescribeDomainRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *DescribeDomainRequest) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Name != nil {
		w, err = wire.NewValueString(*(v.Name)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.UUID != nil {
		w, err = wire.NewValueString(*(v.UUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a DescribeDomainRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a DescribeDomainRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v DescribeDomainRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *DescribeDomainRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Name = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.UUID = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a DescribeDomainRequest
// struct.
func (v *DescribeDomainRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.Name != nil {
		fields[i] = fmt.Sprintf("Name: %v", *(v.Name))
		i++
	}
	if v.UUID != nil {
		fields[i] = fmt.Sprintf("UUID: %v", *(v.UUID))
		i++
	}

	return fmt.Sprintf("DescribeDomainRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this DescribeDomainRequest match the
// provided DescribeDomainRequest.
//
// This function performs a deep comparison.
func (v *DescribeDomainRequest) Equals(rhs *DescribeDomainRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Name, rhs.Name) {
		return false
	}
	if !_String_EqualsPtr(v.UUID, rhs.UUID) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DescribeDomainRequest.
func (v *DescribeDomainRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Name != nil {
		enc.AddString("name", *v.Name)
	}
	if v.UUID != nil {
		enc.AddString("uuid", *v.UUID)
	}
	return err
}

// GetName returns the value of Name if it is set or its
// zero value if it is unset.
func (v *DescribeDomainRequest) GetName() (o string) {
	if v != nil && v.Name != nil {
		return *v.Name
	}

	return
}

// IsSetName returns true if Name is not nil.
func (v *DescribeDomainRequest) IsSetName() bool {
	return v != nil && v.Name != nil
}

// GetUUID returns the value of UUID if it is set or its
// zero value if it is unset.
func (v *DescribeDomainRequest) GetUUID() (o string) {
	if v != nil && v.UUID != nil {
		return *v.UUID
	}

	return
}

// IsSetUUID returns true if UUID is not nil.
func (v *DescribeDomainRequest) IsSetUUID() bool {
	return v != nil && v.UUID != nil
}

type DescribeDomainResponse struct {
	DomainInfo               *DomainInfo                     `json:"domainInfo,omitempty"`
	Configuration            *DomainConfiguration            `json:"configuration,omitempty"`
	ReplicationConfiguration *DomainReplicationConfiguration `json:"replicationConfiguration,omitempty"`
	FailoverVersion          *int64                          `json:"failoverVersion,omitempty"`
	IsGlobalDomain           *bool                           `json:"isGlobalDomain,omitempty"`
}

// ToWire translates a DescribeDomainResponse struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *DescribeDomainResponse) ToWire() (wire.Value, error) {
	var (
		fields [5]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainInfo != nil {
		w, err = v.DomainInfo.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Configuration != nil {
		w, err = v.Configuration.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.ReplicationConfiguration != nil {
		w, err = v.ReplicationConfiguration.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.FailoverVersion != nil {
		w, err = wire.NewValueI64(*(v.FailoverVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.IsGlobalDomain != nil {
		w, err = wire.NewValueBool(*(v.IsGlobalDomain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _DomainInfo_Read(w wire.Value) (*DomainInfo, error) {
	var v DomainInfo
	err := v.FromWire(w)
	return &v, err
}

func _DomainConfiguration_Read(w wire.Value) (*DomainConfiguration, error) {
	var v DomainConfiguration
	err := v.FromWire(w)
	return &v, err
}

func _DomainReplicationConfiguration_Read(w wire.Value) (*DomainReplicationConfiguration, error) {
	var v DomainReplicationConfiguration
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a DescribeDomainResponse struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a DescribeDomainResponse struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v DescribeDomainResponse
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *DescribeDomainResponse) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TStruct {
				v.DomainInfo, err = _DomainInfo_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.Configuration, err = _DomainConfiguration_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TStruct {
				v.ReplicationConfiguration, err = _DomainReplicationConfiguration_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.FailoverVersion = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TBool {
				var x bool
				x, err = field.Value.GetBool(), error(nil)
				v.IsGlobalDomain = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a DescribeDomainResponse
// struct.
func (v *DescribeDomainResponse) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [5]string
	i := 0
	if v.DomainInfo != nil {
		fields[i] = fmt.Sprintf("DomainInfo: %v", v.DomainInfo)
		i++
	}
	if v.Configuration != nil {
		fields[i] = fmt.Sprintf("Configuration: %v", v.Configuration)
		i++
	}
	if v.ReplicationConfiguration != nil {
		fields[i] = fmt.Sprintf("ReplicationConfiguration: %v", v.ReplicationConfiguration)
		i++
	}
	if v.FailoverVersion != nil {
		fields[i] = fmt.Sprintf("FailoverVersion: %v", *(v.FailoverVersion))
		i++
	}
	if v.IsGlobalDomain != nil {
		fields[i] = fmt.Sprintf("IsGlobalDomain: %v", *(v.IsGlobalDomain))
		i++
	}

	return fmt.Sprintf("DescribeDomainResponse{%v}", strings.Join(fields[:i], ", "))
}

func _Bool_EqualsPtr(lhs, rhs *bool) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return (x == y)
	}
	return lhs == nil && rhs == nil
}

// Equals returns true if all the fields of this DescribeDomainResponse match the
// provided DescribeDomainResponse.
//
// This function performs a deep comparison.
func (v *DescribeDomainResponse) Equals(rhs *DescribeDomainResponse) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.DomainInfo == nil && rhs.DomainInfo == nil) || (v.DomainInfo != nil && rhs.DomainInfo != nil && v.DomainInfo.Equals(rhs.DomainInfo))) {
		return false
	}
	if !((v.Configuration == nil && rhs.Configuration == nil) || (v.Configuration != nil && rhs.Configuration != nil && v.Configuration.Equals(rhs.Configuration))) {
		return false
	}
	if !((v.ReplicationConfiguration == nil && rhs.ReplicationConfiguration == nil) || (v.ReplicationConfiguration != nil && rhs.ReplicationConfiguration != nil && v.ReplicationConfiguration.Equals(rhs.ReplicationConfiguration))) {
		return false
	}
	if !_I64_EqualsPtr(v.FailoverVersion, rhs.FailoverVersion) {
		return false
	}
	if !_Bool_EqualsPtr(v.IsGlobalDomain, rhs.IsGlobalDomain) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DescribeDomainResponse.
func (v *DescribeDomainResponse) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainInfo != nil {
		err = multierr.Append(err, enc.AddObject("domainInfo", v.DomainInfo))
	}
	if v.Configuration != nil {
		err = multierr.Append(err, enc.AddObject("configuration", v.Configuration))
	}
	if v.ReplicationConfiguration != nil {
		err = multierr.Append(err, enc.AddObject("replicationConfiguration", v.ReplicationConfiguration))
	}
	if v.FailoverVersion != nil {
		enc.AddInt64("failoverVersion", *v.FailoverVersion)
	}
	if v.IsGlobalDomain != nil {
		enc.AddBool("isGlobalDomain", *v.IsGlobalDomain)
	}
	return err
}

// GetDomainInfo returns the value of DomainInfo if it is set or its
// zero value if it is unset.
func (v *DescribeDomainResponse) GetDomainInfo() (o *DomainInfo) {
	if v != nil && v.DomainInfo != nil {
		return v.DomainInfo
	}

	return
}

// IsSetDomainInfo returns true if DomainInfo is not nil.
func (v *DescribeDomainResponse) IsSetDomainInfo() bool {
	return v != nil && v.DomainInfo != nil
}

// GetConfiguration returns the value of Configuration if it is set or its
// zero value if it is unset.
func (v *DescribeDomainResponse) GetConfiguration() (o *DomainConfiguration) {
	if v != nil && v.Configuration != nil {
		return v.Configuration
	}

	return
}

// IsSetConfiguration returns true if Configuration is not nil.
func (v *DescribeDomainResponse) IsSetConfiguration() bool {
	return v != nil && v.Configuration != nil
}

// GetReplicationConfiguration returns the value of ReplicationConfiguration if it is set or its
// zero value if it is unset.
func (v *DescribeDomainResponse) GetReplicationConfiguration() (o *DomainReplicationConfiguration) {
	if v != nil && v.ReplicationConfiguration != nil {
		return v.ReplicationConfiguration
	}

	return
}

// IsSetReplicationConfiguration returns true if ReplicationConfiguration is not nil.
func (v *DescribeDomainResponse) IsSetReplicationConfiguration() bool {
	return v != nil && v.ReplicationConfiguration != nil
}

// GetFailoverVersion returns the value of FailoverVersion if it is set or its
// zero value if it is unset.
func (v *DescribeDomainResponse) GetFailoverVersion() (o int64) {
	if v != nil && v.FailoverVersion != nil {
		return *v.FailoverVersion
	}

	return
}

// IsSetFailoverVersion returns true if FailoverVersion is not nil.
func (v *DescribeDomainResponse) IsSetFailoverVersion() bool {
	return v != nil && v.FailoverVersion != nil
}

// GetIsGlobalDomain returns the value of IsGlobalDomain if it is set or its
// zero value if it is unset.
func (v *DescribeDomainResponse) GetIsGlobalDomain() (o bool) {
	if v != nil && v.IsGlobalDomain != nil {
		return *v.IsGlobalDomain
	}

	return
}

// IsSetIsGlobalDomain returns true if IsGlobalDomain is not nil.
func (v *DescribeDomainResponse) IsSetIsGlobalDomain() bool {
	return v != nil && v.IsGlobalDomain != nil
}

type DescribeHistoryHostRequest struct {
	HostAddress      *string            `json:"hostAddress,omitempty"`
	ShardIdForHost   *int32             `json:"shardIdForHost,omitempty"`
	ExecutionForHost *WorkflowExecution `json:"executionForHost,omitempty"`
}

// ToWire translates a DescribeHistoryHostRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *DescribeHistoryHostRequest) ToWire() (wire.Value, error) {
	var (
		fields [3]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.HostAddress != nil {
		w, err = wire.NewValueString(*(v.HostAddress)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.ShardIdForHost != nil {
		w, err = wire.NewValueI32(*(v.ShardIdForHost)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.ExecutionForHost != nil {
		w, err = v.ExecutionForHost.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a DescribeHistoryHostRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a DescribeHistoryHostRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v DescribeHistoryHostRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *DescribeHistoryHostRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.HostAddress = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.ShardIdForHost = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TStruct {
				v.ExecutionForHost, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a DescribeHistoryHostRequest
// struct.
func (v *DescribeHistoryHostRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [3]string
	i := 0
	if v.HostAddress != nil {
		fields[i] = fmt.Sprintf("HostAddress: %v", *(v.HostAddress))
		i++
	}
	if v.ShardIdForHost != nil {
		fields[i] = fmt.Sprintf("ShardIdForHost: %v", *(v.ShardIdForHost))
		i++
	}
	if v.ExecutionForHost != nil {
		fields[i] = fmt.Sprintf("ExecutionForHost: %v", v.ExecutionForHost)
		i++
	}

	return fmt.Sprintf("DescribeHistoryHostRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this DescribeHistoryHostRequest match the
// provided DescribeHistoryHostRequest.
//
// This function performs a deep comparison.
func (v *DescribeHistoryHostRequest) Equals(rhs *DescribeHistoryHostRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.HostAddress, rhs.HostAddress) {
		return false
	}
	if !_I32_EqualsPtr(v.ShardIdForHost, rhs.ShardIdForHost) {
		return false
	}
	if !((v.ExecutionForHost == nil && rhs.ExecutionForHost == nil) || (v.ExecutionForHost != nil && rhs.ExecutionForHost != nil && v.ExecutionForHost.Equals(rhs.ExecutionForHost))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DescribeHistoryHostRequest.
func (v *DescribeHistoryHostRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.HostAddress != nil {
		enc.AddString("hostAddress", *v.HostAddress)
	}
	if v.ShardIdForHost != nil {
		enc.AddInt32("shardIdForHost", *v.ShardIdForHost)
	}
	if v.ExecutionForHost != nil {
		err = multierr.Append(err, enc.AddObject("executionForHost", v.ExecutionForHost))
	}
	return err
}

// GetHostAddress returns the value of HostAddress if it is set or its
// zero value if it is unset.
func (v *DescribeHistoryHostRequest) GetHostAddress() (o string) {
	if v != nil && v.HostAddress != nil {
		return *v.HostAddress
	}

	return
}

// IsSetHostAddress returns true if HostAddress is not nil.
func (v *DescribeHistoryHostRequest) IsSetHostAddress() bool {
	return v != nil && v.HostAddress != nil
}

// GetShardIdForHost returns the value of ShardIdForHost if it is set or its
// zero value if it is unset.
func (v *DescribeHistoryHostRequest) GetShardIdForHost() (o int32) {
	if v != nil && v.ShardIdForHost != nil {
		return *v.ShardIdForHost
	}

	return
}

// IsSetShardIdForHost returns true if ShardIdForHost is not nil.
func (v *DescribeHistoryHostRequest) IsSetShardIdForHost() bool {
	return v != nil && v.ShardIdForHost != nil
}

// GetExecutionForHost returns the value of ExecutionForHost if it is set or its
// zero value if it is unset.
func (v *DescribeHistoryHostRequest) GetExecutionForHost() (o *WorkflowExecution) {
	if v != nil && v.ExecutionForHost != nil {
		return v.ExecutionForHost
	}

	return
}

// IsSetExecutionForHost returns true if ExecutionForHost is not nil.
func (v *DescribeHistoryHostRequest) IsSetExecutionForHost() bool {
	return v != nil && v.ExecutionForHost != nil
}

type DescribeHistoryHostResponse struct {
	NumberOfShards        *int32           `json:"numberOfShards,omitempty"`
	ShardIDs              []int32          `json:"shardIDs,omitempty"`
	DomainCache           *DomainCacheInfo `json:"domainCache,omitempty"`
	ShardControllerStatus *string          `json:"shardControllerStatus,omitempty"`
	Address               *string          `json:"address,omitempty"`
}

type _List_I32_ValueList []int32

func (v _List_I32_ValueList) ForEach(f func(wire.Value) error) error {
	for _, x := range v {
		w, err := wire.NewValueI32(x), error(nil)
		if err != nil {
			return err
		}
		err = f(w)
		if err != nil {
			return err
		}
	}
	return nil
}

func (v _List_I32_ValueList) Size() int {
	return len(v)
}

func (_List_I32_ValueList) ValueType() wire.Type {
	return wire.TI32
}

func (_List_I32_ValueList) Close() {}

// ToWire translates a DescribeHistoryHostResponse struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *DescribeHistoryHostResponse) ToWire() (wire.Value, error) {
	var (
		fields [5]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.NumberOfShards != nil {
		w, err = wire.NewValueI32(*(v.NumberOfShards)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.ShardIDs != nil {
		w, err = wire.NewValueList(_List_I32_ValueList(v.ShardIDs)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.DomainCache != nil {
		w, err = v.DomainCache.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.ShardControllerStatus != nil {
		w, err = wire.NewValueString(*(v.ShardControllerStatus)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.Address != nil {
		w, err = wire.NewValueString(*(v.Address)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _List_I32_Read(l wire.ValueList) ([]int32, error) {
	if l.ValueType() != wire.TI32 {
		return nil, nil
	}

	o := make([]int32, 0, l.Size())
	err := l.ForEach(func(x wire.Value) error {
		i, err := x.GetI32(), error(nil)
		if err != nil {
			return err
		}
		o = append(o, i)
		return nil
	})
	l.Close()
	return o, err
}

func _DomainCacheInfo_Read(w wire.Value) (*DomainCacheInfo, error) {
	var v DomainCacheInfo
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a DescribeHistoryHostResponse struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a DescribeHistoryHostResponse struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v DescribeHistoryHostResponse
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *DescribeHistoryHostResponse) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.NumberOfShards = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TList {
				v.ShardIDs, err = _List_I32_Read(field.Value.GetList())
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TStruct {
				v.DomainCache, err = _DomainCacheInfo_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ShardControllerStatus = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Address = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a DescribeHistoryHostResponse
// struct.
func (v *DescribeHistoryHostResponse) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [5]string
	i := 0
	if v.NumberOfShards != nil {
		fields[i] = fmt.Sprintf("NumberOfShards: %v", *(v.NumberOfShards))
		i++
	}
	if v.ShardIDs != nil {
		fields[i] = fmt.Sprintf("ShardIDs: %v", v.ShardIDs)
		i++
	}
	if v.DomainCache != nil {
		fields[i] = fmt.Sprintf("DomainCache: %v", v.DomainCache)
		i++
	}
	if v.ShardControllerStatus != nil {
		fields[i] = fmt.Sprintf("ShardControllerStatus: %v", *(v.ShardControllerStatus))
		i++
	}
	if v.Address != nil {
		fields[i] = fmt.Sprintf("Address: %v", *(v.Address))
		i++
	}

	return fmt.Sprintf("DescribeHistoryHostResponse{%v}", strings.Join(fields[:i], ", "))
}

func _List_I32_Equals(lhs, rhs []int32) bool {
	if len(lhs) != len(rhs) {
		return false
	}

	for i, lv := range lhs {
		rv := rhs[i]
		if !(lv == rv) {
			return false
		}
	}

	return true
}

// Equals returns true if all the fields of this DescribeHistoryHostResponse match the
// provided DescribeHistoryHostResponse.
//
// This function performs a deep comparison.
func (v *DescribeHistoryHostResponse) Equals(rhs *DescribeHistoryHostResponse) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_I32_EqualsPtr(v.NumberOfShards, rhs.NumberOfShards) {
		return false
	}
	if !((v.ShardIDs == nil && rhs.ShardIDs == nil) || (v.ShardIDs != nil && rhs.ShardIDs != nil && _List_I32_Equals(v.ShardIDs, rhs.ShardIDs))) {
		return false
	}
	if !((v.DomainCache == nil && rhs.DomainCache == nil) || (v.DomainCache != nil && rhs.DomainCache != nil && v.DomainCache.Equals(rhs.DomainCache))) {
		return false
	}
	if !_String_EqualsPtr(v.ShardControllerStatus, rhs.ShardControllerStatus) {
		return false
	}
	if !_String_EqualsPtr(v.Address, rhs.Address) {
		return false
	}

	return true
}

type _List_I32_Zapper []int32

// MarshalLogArray implements zapcore.ArrayMarshaler, enabling
// fast logging of _List_I32_Zapper.
func (l _List_I32_Zapper) MarshalLogArray(enc zapcore.ArrayEncoder) (err error) {
	for _, v := range l {
		enc.AppendInt32(v)
	}
	return err
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DescribeHistoryHostResponse.
func (v *DescribeHistoryHostResponse) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.NumberOfShards != nil {
		enc.AddInt32("numberOfShards", *v.NumberOfShards)
	}
	if v.ShardIDs != nil {
		err = multierr.Append(err, enc.AddArray("shardIDs", (_List_I32_Zapper)(v.ShardIDs)))
	}
	if v.DomainCache != nil {
		err = multierr.Append(err, enc.AddObject("domainCache", v.DomainCache))
	}
	if v.ShardControllerStatus != nil {
		enc.AddString("shardControllerStatus", *v.ShardControllerStatus)
	}
	if v.Address != nil {
		enc.AddString("address", *v.Address)
	}
	return err
}

// GetNumberOfShards returns the value of NumberOfShards if it is set or its
// zero value if it is unset.
func (v *DescribeHistoryHostResponse) GetNumberOfShards() (o int32) {
	if v != nil && v.NumberOfShards != nil {
		return *v.NumberOfShards
	}

	return
}

// IsSetNumberOfShards returns true if NumberOfShards is not nil.
func (v *DescribeHistoryHostResponse) IsSetNumberOfShards() bool {
	return v != nil && v.NumberOfShards != nil
}

// GetShardIDs returns the value of ShardIDs if it is set or its
// zero value if it is unset.
func (v *DescribeHistoryHostResponse) GetShardIDs() (o []int32) {
	if v != nil && v.ShardIDs != nil {
		return v.ShardIDs
	}

	return
}

// IsSetShardIDs returns true if ShardIDs is not nil.
func (v *DescribeHistoryHostResponse) IsSetShardIDs() bool {
	return v != nil && v.ShardIDs != nil
}

// GetDomainCache returns the value of DomainCache if it is set or its
// zero value if it is unset.
func (v *DescribeHistoryHostResponse) GetDomainCache() (o *DomainCacheInfo) {
	if v != nil && v.DomainCache != nil {
		return v.DomainCache
	}

	return
}

// IsSetDomainCache returns true if DomainCache is not nil.
func (v *DescribeHistoryHostResponse) IsSetDomainCache() bool {
	return v != nil && v.DomainCache != nil
}

// GetShardControllerStatus returns the value of ShardControllerStatus if it is set or its
// zero value if it is unset.
func (v *DescribeHistoryHostResponse) GetShardControllerStatus() (o string) {
	if v != nil && v.ShardControllerStatus != nil {
		return *v.ShardControllerStatus
	}

	return
}

// IsSetShardControllerStatus returns true if ShardControllerStatus is not nil.
func (v *DescribeHistoryHostResponse) IsSetShardControllerStatus() bool {
	return v != nil && v.ShardControllerStatus != nil
}

// GetAddress returns the value of Address if it is set or its
// zero value if it is unset.
func (v *DescribeHistoryHostResponse) GetAddress() (o string) {
	if v != nil && v.Address != nil {
		return *v.Address
	}

	return
}

// IsSetAddress returns true if Address is not nil.
func (v *DescribeHistoryHostResponse) IsSetAddress() bool {
	return v != nil && v.Address != nil
}

type DescribeTaskListRequest struct {
	Domain                *string       `json:"domain,omitempty"`
	TaskList              *TaskList     `json:"taskList,omitempty"`
	TaskListType          *TaskListType `json:"taskListType,omitempty"`
	IncludeTaskListStatus *bool         `json:"includeTaskListStatus,omitempty"`
}

// ToWire translates a DescribeTaskListRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *DescribeTaskListRequest) ToWire() (wire.Value, error) {
	var (
		fields [4]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.TaskList != nil {
		w, err = v.TaskList.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.TaskListType != nil {
		w, err = v.TaskListType.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.IncludeTaskListStatus != nil {
		w, err = wire.NewValueBool(*(v.IncludeTaskListStatus)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _TaskListType_Read(w wire.Value) (TaskListType, error) {
	var v TaskListType
	err := v.FromWire(w)
	return v, err
}

// FromWire deserializes a DescribeTaskListRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a DescribeTaskListRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v DescribeTaskListRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *DescribeTaskListRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.TaskList, err = _TaskList_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI32 {
				var x TaskListType
				x, err = _TaskListType_Read(field.Value)
				v.TaskListType = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBool {
				var x bool
				x, err = field.Value.GetBool(), error(nil)
				v.IncludeTaskListStatus = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a DescribeTaskListRequest
// struct.
func (v *DescribeTaskListRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [4]string
	i := 0
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.TaskList != nil {
		fields[i] = fmt.Sprintf("TaskList: %v", v.TaskList)
		i++
	}
	if v.TaskListType != nil {
		fields[i] = fmt.Sprintf("TaskListType: %v", *(v.TaskListType))
		i++
	}
	if v.IncludeTaskListStatus != nil {
		fields[i] = fmt.Sprintf("IncludeTaskListStatus: %v", *(v.IncludeTaskListStatus))
		i++
	}

	return fmt.Sprintf("DescribeTaskListRequest{%v}", strings.Join(fields[:i], ", "))
}

func _TaskListType_EqualsPtr(lhs, rhs *TaskListType) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return x.Equals(y)
	}
	return lhs == nil && rhs == nil
}

// Equals returns true if all the fields of this DescribeTaskListRequest match the
// provided DescribeTaskListRequest.
//
// This function performs a deep comparison.
func (v *DescribeTaskListRequest) Equals(rhs *DescribeTaskListRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !((v.TaskList == nil && rhs.TaskList == nil) || (v.TaskList != nil && rhs.TaskList != nil && v.TaskList.Equals(rhs.TaskList))) {
		return false
	}
	if !_TaskListType_EqualsPtr(v.TaskListType, rhs.TaskListType) {
		return false
	}
	if !_Bool_EqualsPtr(v.IncludeTaskListStatus, rhs.IncludeTaskListStatus) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DescribeTaskListRequest.
func (v *DescribeTaskListRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.TaskList != nil {
		err = multierr.Append(err, enc.AddObject("taskList", v.TaskList))
	}
	if v.TaskListType != nil {
		err = multierr.Append(err, enc.AddObject("taskListType", *v.TaskListType))
	}
	if v.IncludeTaskListStatus != nil {
		enc.AddBool("includeTaskListStatus", *v.IncludeTaskListStatus)
	}
	return err
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *DescribeTaskListRequest) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *DescribeTaskListRequest) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetTaskList returns the value of TaskList if it is set or its
// zero value if it is unset.
func (v *DescribeTaskListRequest) GetTaskList() (o *TaskList) {
	if v != nil && v.TaskList != nil {
		return v.TaskList
	}

	return
}

// IsSetTaskList returns true if TaskList is not nil.
func (v *DescribeTaskListRequest) IsSetTaskList() bool {
	return v != nil && v.TaskList != nil
}

// GetTaskListType returns the value of TaskListType if it is set or its
// zero value if it is unset.
func (v *DescribeTaskListRequest) GetTaskListType() (o TaskListType) {
	if v != nil && v.TaskListType != nil {
		return *v.TaskListType
	}

	return
}

// IsSetTaskListType returns true if TaskListType is not nil.
func (v *DescribeTaskListRequest) IsSetTaskListType() bool {
	return v != nil && v.TaskListType != nil
}

// GetIncludeTaskListStatus returns the value of IncludeTaskListStatus if it is set or its
// zero value if it is unset.
func (v *DescribeTaskListRequest) GetIncludeTaskListStatus() (o bool) {
	if v != nil && v.IncludeTaskListStatus != nil {
		return *v.IncludeTaskListStatus
	}

	return
}

// IsSetIncludeTaskListStatus returns true if IncludeTaskListStatus is not nil.
func (v *DescribeTaskListRequest) IsSetIncludeTaskListStatus() bool {
	return v != nil && v.IncludeTaskListStatus != nil
}

type DescribeTaskListResponse struct {
	Pollers        []*PollerInfo   `json:"pollers,omitempty"`
	TaskListStatus *TaskListStatus `json:"taskListStatus,omitempty"`
}

type _List_PollerInfo_ValueList []*PollerInfo

func (v _List_PollerInfo_ValueList) ForEach(f func(wire.Value) error) error {
	for i, x := range v {
		if x == nil {
			return fmt.Errorf("invalid [%v]: value is nil", i)
		}
		w, err := x.ToWire()
		if err != nil {
			return err
		}
		err = f(w)
		if err != nil {
			return err
		}
	}
	return nil
}

func (v _List_PollerInfo_ValueList) Size() int {
	return len(v)
}

func (_List_PollerInfo_ValueList) ValueType() wire.Type {
	return wire.TStruct
}

func (_List_PollerInfo_ValueList) Close() {}

// ToWire translates a DescribeTaskListResponse struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *DescribeTaskListResponse) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Pollers != nil {
		w, err = wire.NewValueList(_List_PollerInfo_ValueList(v.Pollers)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.TaskListStatus != nil {
		w, err = v.TaskListStatus.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _PollerInfo_Read(w wire.Value) (*PollerInfo, error) {
	var v PollerInfo
	err := v.FromWire(w)
	return &v, err
}

func _List_PollerInfo_Read(l wire.ValueList) ([]*PollerInfo, error) {
	if l.ValueType() != wire.TStruct {
		return nil, nil
	}

	o := make([]*PollerInfo, 0, l.Size())
	err := l.ForEach(func(x wire.Value) error {
		i, err := _PollerInfo_Read(x)
		if err != nil {
			return err
		}
		o = append(o, i)
		return nil
	})
	l.Close()
	return o, err
}

func _TaskListStatus_Read(w wire.Value) (*TaskListStatus, error) {
	var v TaskListStatus
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a DescribeTaskListResponse struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a DescribeTaskListResponse struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v DescribeTaskListResponse
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *DescribeTaskListResponse) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TList {
				v.Pollers, err = _List_PollerInfo_Read(field.Value.GetList())
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.TaskListStatus, err = _TaskListStatus_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a DescribeTaskListResponse
// struct.
func (v *DescribeTaskListResponse) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.Pollers != nil {
		fields[i] = fmt.Sprintf("Pollers: %v", v.Pollers)
		i++
	}
	if v.TaskListStatus != nil {
		fields[i] = fmt.Sprintf("TaskListStatus: %v", v.TaskListStatus)
		i++
	}

	return fmt.Sprintf("DescribeTaskListResponse{%v}", strings.Join(fields[:i], ", "))
}

func _List_PollerInfo_Equals(lhs, rhs []*PollerInfo) bool {
	if len(lhs) != len(rhs) {
		return false
	}

	for i, lv := range lhs {
		rv := rhs[i]
		if !lv.Equals(rv) {
			return false
		}
	}

	return true
}

// Equals returns true if all the fields of this DescribeTaskListResponse match the
// provided DescribeTaskListResponse.
//
// This function performs a deep comparison.
func (v *DescribeTaskListResponse) Equals(rhs *DescribeTaskListResponse) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.Pollers == nil && rhs.Pollers == nil) || (v.Pollers != nil && rhs.Pollers != nil && _List_PollerInfo_Equals(v.Pollers, rhs.Pollers))) {
		return false
	}
	if !((v.TaskListStatus == nil && rhs.TaskListStatus == nil) || (v.TaskListStatus != nil && rhs.TaskListStatus != nil && v.TaskListStatus.Equals(rhs.TaskListStatus))) {
		return false
	}

	return true
}

type _List_PollerInfo_Zapper []*PollerInfo

// MarshalLogArray implements zapcore.ArrayMarshaler, enabling
// fast logging of _List_PollerInfo_Zapper.
func (l _List_PollerInfo_Zapper) MarshalLogArray(enc zapcore.ArrayEncoder) (err error) {
	for _, v := range l {
		err = multierr.Append(err, enc.AppendObject(v))
	}
	return err
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DescribeTaskListResponse.
func (v *DescribeTaskListResponse) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Pollers != nil {
		err = multierr.Append(err, enc.AddArray("pollers", (_List_PollerInfo_Zapper)(v.Pollers)))
	}
	if v.TaskListStatus != nil {
		err = multierr.Append(err, enc.AddObject("taskListStatus", v.TaskListStatus))
	}
	return err
}

// GetPollers returns the value of Pollers if it is set or its
// zero value if it is unset.
func (v *DescribeTaskListResponse) GetPollers() (o []*PollerInfo) {
	if v != nil && v.Pollers != nil {
		return v.Pollers
	}

	return
}

// IsSetPollers returns true if Pollers is not nil.
func (v *DescribeTaskListResponse) IsSetPollers() bool {
	return v != nil && v.Pollers != nil
}

// GetTaskListStatus returns the value of TaskListStatus if it is set or its
// zero value if it is unset.
func (v *DescribeTaskListResponse) GetTaskListStatus() (o *TaskListStatus) {
	if v != nil && v.TaskListStatus != nil {
		return v.TaskListStatus
	}

	return
}

// IsSetTaskListStatus returns true if TaskListStatus is not nil.
func (v *DescribeTaskListResponse) IsSetTaskListStatus() bool {
	return v != nil && v.TaskListStatus != nil
}

type DescribeWorkflowExecutionRequest struct {
	Domain    *string            `json:"domain,omitempty"`
	Execution *WorkflowExecution `json:"execution,omitempty"`
}

// ToWire translates a DescribeWorkflowExecutionRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *DescribeWorkflowExecutionRequest) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Execution != nil {
		w, err = v.Execution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a DescribeWorkflowExecutionRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a DescribeWorkflowExecutionRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v DescribeWorkflowExecutionRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *DescribeWorkflowExecutionRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.Execution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a DescribeWorkflowExecutionRequest
// struct.
func (v *DescribeWorkflowExecutionRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.Execution != nil {
		fields[i] = fmt.Sprintf("Execution: %v", v.Execution)
		i++
	}

	return fmt.Sprintf("DescribeWorkflowExecutionRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this DescribeWorkflowExecutionRequest match the
// provided DescribeWorkflowExecutionRequest.
//
// This function performs a deep comparison.
func (v *DescribeWorkflowExecutionRequest) Equals(rhs *DescribeWorkflowExecutionRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !((v.Execution == nil && rhs.Execution == nil) || (v.Execution != nil && rhs.Execution != nil && v.Execution.Equals(rhs.Execution))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DescribeWorkflowExecutionRequest.
func (v *DescribeWorkflowExecutionRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.Execution != nil {
		err = multierr.Append(err, enc.AddObject("execution", v.Execution))
	}
	return err
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *DescribeWorkflowExecutionRequest) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *DescribeWorkflowExecutionRequest) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetExecution returns the value of Execution if it is set or its
// zero value if it is unset.
func (v *DescribeWorkflowExecutionRequest) GetExecution() (o *WorkflowExecution) {
	if v != nil && v.Execution != nil {
		return v.Execution
	}

	return
}

// IsSetExecution returns true if Execution is not nil.
func (v *DescribeWorkflowExecutionRequest) IsSetExecution() bool {
	return v != nil && v.Execution != nil
}

type DescribeWorkflowExecutionResponse struct {
	ExecutionConfiguration *WorkflowExecutionConfiguration `json:"executionConfiguration,omitempty"`
	WorkflowExecutionInfo  *WorkflowExecutionInfo          `json:"workflowExecutionInfo,omitempty"`
	PendingActivities      []*PendingActivityInfo          `json:"pendingActivities,omitempty"`
}

type _List_PendingActivityInfo_ValueList []*PendingActivityInfo

func (v _List_PendingActivityInfo_ValueList) ForEach(f func(wire.Value) error) error {
	for i, x := range v {
		if x == nil {
			return fmt.Errorf("invalid [%v]: value is nil", i)
		}
		w, err := x.ToWire()
		if err != nil {
			return err
		}
		err = f(w)
		if err != nil {
			return err
		}
	}
	return nil
}

func (v _List_PendingActivityInfo_ValueList) Size() int {
	return len(v)
}

func (_List_PendingActivityInfo_ValueList) ValueType() wire.Type {
	return wire.TStruct
}

func (_List_PendingActivityInfo_ValueList) Close() {}

// ToWire translates a DescribeWorkflowExecutionResponse struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *DescribeWorkflowExecutionResponse) ToWire() (wire.Value, error) {
	var (
		fields [3]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.ExecutionConfiguration != nil {
		w, err = v.ExecutionConfiguration.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.WorkflowExecutionInfo != nil {
		w, err = v.WorkflowExecutionInfo.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.PendingActivities != nil {
		w, err = wire.NewValueList(_List_PendingActivityInfo_ValueList(v.PendingActivities)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _WorkflowExecutionConfiguration_Read(w wire.Value) (*WorkflowExecutionConfiguration, error) {
	var v WorkflowExecutionConfiguration
	err := v.FromWire(w)
	return &v, err
}

func _WorkflowExecutionInfo_Read(w wire.Value) (*WorkflowExecutionInfo, error) {
	var v WorkflowExecutionInfo
	err := v.FromWire(w)
	return &v, err
}

func _PendingActivityInfo_Read(w wire.Value) (*PendingActivityInfo, error) {
	var v PendingActivityInfo
	err := v.FromWire(w)
	return &v, err
}

func _List_PendingActivityInfo_Read(l wire.ValueList) ([]*PendingActivityInfo, error) {
	if l.ValueType() != wire.TStruct {
		return nil, nil
	}

	o := make([]*PendingActivityInfo, 0, l.Size())
	err := l.ForEach(func(x wire.Value) error {
		i, err := _PendingActivityInfo_Read(x)
		if err != nil {
			return err
		}
		o = append(o, i)
		return nil
	})
	l.Close()
	return o, err
}

// FromWire deserializes a DescribeWorkflowExecutionResponse struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a DescribeWorkflowExecutionResponse struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v DescribeWorkflowExecutionResponse
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *DescribeWorkflowExecutionResponse) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TStruct {
				v.ExecutionConfiguration, err = _WorkflowExecutionConfiguration_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecutionInfo, err = _WorkflowExecutionInfo_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TList {
				v.PendingActivities, err = _List_PendingActivityInfo_Read(field.Value.GetList())
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a DescribeWorkflowExecutionResponse
// struct.
func (v *DescribeWorkflowExecutionResponse) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [3]string
	i := 0
	if v.ExecutionConfiguration != nil {
		fields[i] = fmt.Sprintf("ExecutionConfiguration: %v", v.ExecutionConfiguration)
		i++
	}
	if v.WorkflowExecutionInfo != nil {
		fields[i] = fmt.Sprintf("WorkflowExecutionInfo: %v", v.WorkflowExecutionInfo)
		i++
	}
	if v.PendingActivities != nil {
		fields[i] = fmt.Sprintf("PendingActivities: %v", v.PendingActivities)
		i++
	}

	return fmt.Sprintf("DescribeWorkflowExecutionResponse{%v}", strings.Join(fields[:i], ", "))
}

func _List_PendingActivityInfo_Equals(lhs, rhs []*PendingActivityInfo) bool {
	if len(lhs) != len(rhs) {
		return false
	}

	for i, lv := range lhs {
		rv := rhs[i]
		if !lv.Equals(rv) {
			return false
		}
	}

	return true
}

// Equals returns true if all the fields of this DescribeWorkflowExecutionResponse match the
// provided DescribeWorkflowExecutionResponse.
//
// This function performs a deep comparison.
func (v *DescribeWorkflowExecutionResponse) Equals(rhs *DescribeWorkflowExecutionResponse) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.ExecutionConfiguration == nil && rhs.ExecutionConfiguration == nil) || (v.ExecutionConfiguration != nil && rhs.ExecutionConfiguration != nil && v.ExecutionConfiguration.Equals(rhs.ExecutionConfiguration))) {
		return false
	}
	if !((v.WorkflowExecutionInfo == nil && rhs.WorkflowExecutionInfo == nil) || (v.WorkflowExecutionInfo != nil && rhs.WorkflowExecutionInfo != nil && v.WorkflowExecutionInfo.Equals(rhs.WorkflowExecutionInfo))) {
		return false
	}
	if !((v.PendingActivities == nil && rhs.PendingActivities == nil) || (v.PendingActivities != nil && rhs.PendingActivities != nil && _List_PendingActivityInfo_Equals(v.PendingActivities, rhs.PendingActivities))) {
		return false
	}

	return true
}

type _List_PendingActivityInfo_Zapper []*PendingActivityInfo

// MarshalLogArray implements zapcore.ArrayMarshaler, enabling
// fast logging of _List_PendingActivityInfo_Zapper.
func (l _List_PendingActivityInfo_Zapper) MarshalLogArray(enc zapcore.ArrayEncoder) (err error) {
	for _, v := range l {
		err = multierr.Append(err, enc.AppendObject(v))
	}
	return err
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DescribeWorkflowExecutionResponse.
func (v *DescribeWorkflowExecutionResponse) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.ExecutionConfiguration != nil {
		err = multierr.Append(err, enc.AddObject("executionConfiguration", v.ExecutionConfiguration))
	}
	if v.WorkflowExecutionInfo != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecutionInfo", v.WorkflowExecutionInfo))
	}
	if v.PendingActivities != nil {
		err = multierr.Append(err, enc.AddArray("pendingActivities", (_List_PendingActivityInfo_Zapper)(v.PendingActivities)))
	}
	return err
}

// GetExecutionConfiguration returns the value of ExecutionConfiguration if it is set or its
// zero value if it is unset.
func (v *DescribeWorkflowExecutionResponse) GetExecutionConfiguration() (o *WorkflowExecutionConfiguration) {
	if v != nil && v.ExecutionConfiguration != nil {
		return v.ExecutionConfiguration
	}

	return
}

// IsSetExecutionConfiguration returns true if ExecutionConfiguration is not nil.
func (v *DescribeWorkflowExecutionResponse) IsSetExecutionConfiguration() bool {
	return v != nil && v.ExecutionConfiguration != nil
}

// GetWorkflowExecutionInfo returns the value of WorkflowExecutionInfo if it is set or its
// zero value if it is unset.
func (v *DescribeWorkflowExecutionResponse) GetWorkflowExecutionInfo() (o *WorkflowExecutionInfo) {
	if v != nil && v.WorkflowExecutionInfo != nil {
		return v.WorkflowExecutionInfo
	}

	return
}

// IsSetWorkflowExecutionInfo returns true if WorkflowExecutionInfo is not nil.
func (v *DescribeWorkflowExecutionResponse) IsSetWorkflowExecutionInfo() bool {
	return v != nil && v.WorkflowExecutionInfo != nil
}

// GetPendingActivities returns the value of PendingActivities if it is set or its
// zero value if it is unset.
func (v *DescribeWorkflowExecutionResponse) GetPendingActivities() (o []*PendingActivityInfo) {
	if v != nil && v.PendingActivities != nil {
		return v.PendingActivities
	}

	return
}

// IsSetPendingActivities returns true if PendingActivities is not nil.
func (v *DescribeWorkflowExecutionResponse) IsSetPendingActivities() bool {
	return v != nil && v.PendingActivities != nil
}

type DomainAlreadyExistsError struct {
	Message string `json:"message,required"`
}

// ToWire translates a DomainAlreadyExistsError struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *DomainAlreadyExistsError) ToWire() (wire.Value, error) {
	var (
		fields [1]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	w, err = wire.NewValueString(v.Message), error(nil)
	if err != nil {
		return w, err
	}
	fields[i] = wire.Field{ID: 1, Value: w}
	i++

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a DomainAlreadyExistsError struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a DomainAlreadyExistsError struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v DomainAlreadyExistsError
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *DomainAlreadyExistsError) FromWire(w wire.Value) error {
	var err error

	messageIsSet := false

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 1:
			if field.Value.Type() == wire.TBinary {
				v.Message, err = field.Value.GetString(), error(nil)
				if err != nil {
					return err
				}
				messageIsSet = true
			}
		}
	}

	if !messageIsSet {
		return errors.New("field Message of DomainAlreadyExistsError is required")
	}

	return nil
}

// String returns a readable string representation of a DomainAlreadyExistsError
// struct.
func (v *DomainAlreadyExistsError) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [1]string
	i := 0
	fields[i] = fmt.Sprintf("Message: %v", v.Message)
	i++

	return fmt.Sprintf("DomainAlreadyExistsError{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this DomainAlreadyExistsError match the
// provided DomainAlreadyExistsError.
//
// This function performs a deep comparison.
func (v *DomainAlreadyExistsError) Equals(rhs *DomainAlreadyExistsError) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !(v.Message == rhs.Message) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DomainAlreadyExistsError.
func (v *DomainAlreadyExistsError) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	enc.AddString("message", v.Message)
	return err
}

// GetMessage returns the value of Message if it is set or its
// zero value if it is unset.
func (v *DomainAlreadyExistsError) GetMessage() (o string) {
	if v != nil {
		o = v.Message
	}
	return
}

func (v *DomainAlreadyExistsError) Error() string {
	return v.String()
}

type DomainCacheInfo struct {
	NumOfItemsInCacheByID   *int64 `json:"numOfItemsInCacheByID,omitempty"`
	NumOfItemsInCacheByName *int64 `json:"numOfItemsInCacheByName,omitempty"`
}

// ToWire translates a DomainCacheInfo struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *DomainCacheInfo) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.NumOfItemsInCacheByID != nil {
		w, err = wire.NewValueI64(*(v.NumOfItemsInCacheByID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.NumOfItemsInCacheByName != nil {
		w, err = wire.NewValueI64(*(v.NumOfItemsInCacheByName)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a DomainCacheInfo struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a DomainCacheInfo struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v DomainCacheInfo
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *DomainCacheInfo) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.NumOfItemsInCacheByID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.NumOfItemsInCacheByName = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a DomainCacheInfo
// struct.
func (v *DomainCacheInfo) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.NumOfItemsInCacheByID != nil {
		fields[i] = fmt.Sprintf("NumOfItemsInCacheByID: %v", *(v.NumOfItemsInCacheByID))
		i++
	}
	if v.NumOfItemsInCacheByName != nil {
		fields[i] = fmt.Sprintf("NumOfItemsInCacheByName: %v", *(v.NumOfItemsInCacheByName))
		i++
	}

	return fmt.Sprintf("DomainCacheInfo{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this DomainCacheInfo match the
// provided DomainCacheInfo.
//
// This function performs a deep comparison.
func (v *DomainCacheInfo) Equals(rhs *DomainCacheInfo) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_I64_EqualsPtr(v.NumOfItemsInCacheByID, rhs.NumOfItemsInCacheByID) {
		return false
	}
	if !_I64_EqualsPtr(v.NumOfItemsInCacheByName, rhs.NumOfItemsInCacheByName) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DomainCacheInfo.
func (v *DomainCacheInfo) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.NumOfItemsInCacheByID != nil {
		enc.AddInt64("numOfItemsInCacheByID", *v.NumOfItemsInCacheByID)
	}
	if v.NumOfItemsInCacheByName != nil {
		enc.AddInt64("numOfItemsInCacheByName", *v.NumOfItemsInCacheByName)
	}
	return err
}

// GetNumOfItemsInCacheByID returns the value of NumOfItemsInCacheByID if it is set or its
// zero value if it is unset.
func (v *DomainCacheInfo) GetNumOfItemsInCacheByID() (o int64) {
	if v != nil && v.NumOfItemsInCacheByID != nil {
		return *v.NumOfItemsInCacheByID
	}

	return
}

// IsSetNumOfItemsInCacheByID returns true if NumOfItemsInCacheByID is not nil.
func (v *DomainCacheInfo) IsSetNumOfItemsInCacheByID() bool {
	return v != nil && v.NumOfItemsInCacheByID != nil
}

// GetNumOfItemsInCacheByName returns the value of NumOfItemsInCacheByName if it is set or its
// zero value if it is unset.
func (v *DomainCacheInfo) GetNumOfItemsInCacheByName() (o int64) {
	if v != nil && v.NumOfItemsInCacheByName != nil {
		return *v.NumOfItemsInCacheByName
	}

	return
}

// IsSetNumOfItemsInCacheByName returns true if NumOfItemsInCacheByName is not nil.
func (v *DomainCacheInfo) IsSetNumOfItemsInCacheByName() bool {
	return v != nil && v.NumOfItemsInCacheByName != nil
}

type DomainConfiguration struct {
	WorkflowExecutionRetentionPeriodInDays *int32          `json:"workflowExecutionRetentionPeriodInDays,omitempty"`
	EmitMetric                             *bool           `json:"emitMetric,omitempty"`
	ArchivalBucketName                     *string         `json:"archivalBucketName,omitempty"`
	ArchivalRetentionPeriodInDays          *int32          `json:"archivalRetentionPeriodInDays,omitempty"`
	ArchivalStatus                         *ArchivalStatus `json:"archivalStatus,omitempty"`
	ArchivalBucketOwner                    *string         `json:"archivalBucketOwner,omitempty"`
	BadBinaries                            *BadBinaries    `json:"badBinaries,omitempty"`
}

// ToWire translates a DomainConfiguration struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *DomainConfiguration) ToWire() (wire.Value, error) {
	var (
		fields [7]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.WorkflowExecutionRetentionPeriodInDays != nil {
		w, err = wire.NewValueI32(*(v.WorkflowExecutionRetentionPeriodInDays)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.EmitMetric != nil {
		w, err = wire.NewValueBool(*(v.EmitMetric)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.ArchivalBucketName != nil {
		w, err = wire.NewValueString(*(v.ArchivalBucketName)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.ArchivalRetentionPeriodInDays != nil {
		w, err = wire.NewValueI32(*(v.ArchivalRetentionPeriodInDays)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.ArchivalStatus != nil {
		w, err = v.ArchivalStatus.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.ArchivalBucketOwner != nil {
		w, err = wire.NewValueString(*(v.ArchivalBucketOwner)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}
	if v.BadBinaries != nil {
		w, err = v.BadBinaries.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 70, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _ArchivalStatus_Read(w wire.Value) (ArchivalStatus, error) {
	var v ArchivalStatus
	err := v.FromWire(w)
	return v, err
}

func _BadBinaries_Read(w wire.Value) (*BadBinaries, error) {
	var v BadBinaries
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a DomainConfiguration struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a DomainConfiguration struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v DomainConfiguration
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *DomainConfiguration) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.WorkflowExecutionRetentionPeriodInDays = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBool {
				var x bool
				x, err = field.Value.GetBool(), error(nil)
				v.EmitMetric = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ArchivalBucketName = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.ArchivalRetentionPeriodInDays = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TI32 {
				var x ArchivalStatus
				x, err = _ArchivalStatus_Read(field.Value)
				v.ArchivalStatus = &x
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ArchivalBucketOwner = &x
				if err != nil {
					return err
				}

			}
		case 70:
			if field.Value.Type() == wire.TStruct {
				v.BadBinaries, err = _BadBinaries_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a DomainConfiguration
// struct.
func (v *DomainConfiguration) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [7]string
	i := 0
	if v.WorkflowExecutionRetentionPeriodInDays != nil {
		fields[i] = fmt.Sprintf("WorkflowExecutionRetentionPeriodInDays: %v", *(v.WorkflowExecutionRetentionPeriodInDays))
		i++
	}
	if v.EmitMetric != nil {
		fields[i] = fmt.Sprintf("EmitMetric: %v", *(v.EmitMetric))
		i++
	}
	if v.ArchivalBucketName != nil {
		fields[i] = fmt.Sprintf("ArchivalBucketName: %v", *(v.ArchivalBucketName))
		i++
	}
	if v.ArchivalRetentionPeriodInDays != nil {
		fields[i] = fmt.Sprintf("ArchivalRetentionPeriodInDays: %v", *(v.ArchivalRetentionPeriodInDays))
		i++
	}
	if v.ArchivalStatus != nil {
		fields[i] = fmt.Sprintf("ArchivalStatus: %v", *(v.ArchivalStatus))
		i++
	}
	if v.ArchivalBucketOwner != nil {
		fields[i] = fmt.Sprintf("ArchivalBucketOwner: %v", *(v.ArchivalBucketOwner))
		i++
	}
	if v.BadBinaries != nil {
		fields[i] = fmt.Sprintf("BadBinaries: %v", v.BadBinaries)
		i++
	}

	return fmt.Sprintf("DomainConfiguration{%v}", strings.Join(fields[:i], ", "))
}

func _ArchivalStatus_EqualsPtr(lhs, rhs *ArchivalStatus) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return x.Equals(y)
	}
	return lhs == nil && rhs == nil
}

// Equals returns true if all the fields of this DomainConfiguration match the
// provided DomainConfiguration.
//
// This function performs a deep comparison.
func (v *DomainConfiguration) Equals(rhs *DomainConfiguration) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_I32_EqualsPtr(v.WorkflowExecutionRetentionPeriodInDays, rhs.WorkflowExecutionRetentionPeriodInDays) {
		return false
	}
	if !_Bool_EqualsPtr(v.EmitMetric, rhs.EmitMetric) {
		return false
	}
	if !_String_EqualsPtr(v.ArchivalBucketName, rhs.ArchivalBucketName) {
		return false
	}
	if !_I32_EqualsPtr(v.ArchivalRetentionPeriodInDays, rhs.ArchivalRetentionPeriodInDays) {
		return false
	}
	if !_ArchivalStatus_EqualsPtr(v.ArchivalStatus, rhs.ArchivalStatus) {
		return false
	}
	if !_String_EqualsPtr(v.ArchivalBucketOwner, rhs.ArchivalBucketOwner) {
		return false
	}
	if !((v.BadBinaries == nil && rhs.BadBinaries == nil) || (v.BadBinaries != nil && rhs.BadBinaries != nil && v.BadBinaries.Equals(rhs.BadBinaries))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DomainConfiguration.
func (v *DomainConfiguration) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.WorkflowExecutionRetentionPeriodInDays != nil {
		enc.AddInt32("workflowExecutionRetentionPeriodInDays", *v.WorkflowExecutionRetentionPeriodInDays)
	}
	if v.EmitMetric != nil {
		enc.AddBool("emitMetric", *v.EmitMetric)
	}
	if v.ArchivalBucketName != nil {
		enc.AddString("archivalBucketName", *v.ArchivalBucketName)
	}
	if v.ArchivalRetentionPeriodInDays != nil {
		enc.AddInt32("archivalRetentionPeriodInDays", *v.ArchivalRetentionPeriodInDays)
	}
	if v.ArchivalStatus != nil {
		err = multierr.Append(err, enc.AddObject("archivalStatus", *v.ArchivalStatus))
	}
	if v.ArchivalBucketOwner != nil {
		enc.AddString("archivalBucketOwner", *v.ArchivalBucketOwner)
	}
	if v.BadBinaries != nil {
		err = multierr.Append(err, enc.AddObject("badBinaries", v.BadBinaries))
	}
	return err
}

// GetWorkflowExecutionRetentionPeriodInDays returns the value of WorkflowExecutionRetentionPeriodInDays if it is set or its
// zero value if it is unset.
func (v *DomainConfiguration) GetWorkflowExecutionRetentionPeriodInDays() (o int32) {
	if v != nil && v.WorkflowExecutionRetentionPeriodInDays != nil {
		return *v.WorkflowExecutionRetentionPeriodInDays
	}

	return
}

// IsSetWorkflowExecutionRetentionPeriodInDays returns true if WorkflowExecutionRetentionPeriodInDays is not nil.
func (v *DomainConfiguration) IsSetWorkflowExecutionRetentionPeriodInDays() bool {
	return v != nil && v.WorkflowExecutionRetentionPeriodInDays != nil
}

// GetEmitMetric returns the value of EmitMetric if it is set or its
// zero value if it is unset.
func (v *DomainConfiguration) GetEmitMetric() (o bool) {
	if v != nil && v.EmitMetric != nil {
		return *v.EmitMetric
	}

	return
}

// IsSetEmitMetric returns true if EmitMetric is not nil.
func (v *DomainConfiguration) IsSetEmitMetric() bool {
	return v != nil && v.EmitMetric != nil
}

// GetArchivalBucketName returns the value of ArchivalBucketName if it is set or its
// zero value if it is unset.
func (v *DomainConfiguration) GetArchivalBucketName() (o string) {
	if v != nil && v.ArchivalBucketName != nil {
		return *v.ArchivalBucketName
	}

	return
}

// IsSetArchivalBucketName returns true if ArchivalBucketName is not nil.
func (v *DomainConfiguration) IsSetArchivalBucketName() bool {
	return v != nil && v.ArchivalBucketName != nil
}

// GetArchivalRetentionPeriodInDays returns the value of ArchivalRetentionPeriodInDays if it is set or its
// zero value if it is unset.
func (v *DomainConfiguration) GetArchivalRetentionPeriodInDays() (o int32) {
	if v != nil && v.ArchivalRetentionPeriodInDays != nil {
		return *v.ArchivalRetentionPeriodInDays
	}

	return
}

// IsSetArchivalRetentionPeriodInDays returns true if ArchivalRetentionPeriodInDays is not nil.
func (v *DomainConfiguration) IsSetArchivalRetentionPeriodInDays() bool {
	return v != nil && v.ArchivalRetentionPeriodInDays != nil
}

// GetArchivalStatus returns the value of ArchivalStatus if it is set or its
// zero value if it is unset.
func (v *DomainConfiguration) GetArchivalStatus() (o ArchivalStatus) {
	if v != nil && v.ArchivalStatus != nil {
		return *v.ArchivalStatus
	}

	return
}

// IsSetArchivalStatus returns true if ArchivalStatus is not nil.
func (v *DomainConfiguration) IsSetArchivalStatus() bool {
	return v != nil && v.ArchivalStatus != nil
}

// GetArchivalBucketOwner returns the value of ArchivalBucketOwner if it is set or its
// zero value if it is unset.
func (v *DomainConfiguration) GetArchivalBucketOwner() (o string) {
	if v != nil && v.ArchivalBucketOwner != nil {
		return *v.ArchivalBucketOwner
	}

	return
}

// IsSetArchivalBucketOwner returns true if ArchivalBucketOwner is not nil.
func (v *DomainConfiguration) IsSetArchivalBucketOwner() bool {
	return v != nil && v.ArchivalBucketOwner != nil
}

// GetBadBinaries returns the value of BadBinaries if it is set or its
// zero value if it is unset.
func (v *DomainConfiguration) GetBadBinaries() (o *BadBinaries) {
	if v != nil && v.BadBinaries != nil {
		return v.BadBinaries
	}

	return
}

// IsSetBadBinaries returns true if BadBinaries is not nil.
func (v *DomainConfiguration) IsSetBadBinaries() bool {
	return v != nil && v.BadBinaries != nil
}

type DomainInfo struct {
	Name        *string           `json:"name,omitempty"`
	Status      *DomainStatus     `json:"status,omitempty"`
	Description *string           `json:"description,omitempty"`
	OwnerEmail  *string           `json:"ownerEmail,omitempty"`
	Data        map[string]string `json:"data,omitempty"`
	UUID        *string           `json:"uuid,omitempty"`
}

type _Map_String_String_MapItemList map[string]string

func (m _Map_String_String_MapItemList) ForEach(f func(wire.MapItem) error) error {
	for k, v := range m {
		kw, err := wire.NewValueString(k), error(nil)
		if err != nil {
			return err
		}

		vw, err := wire.NewValueString(v), error(nil)
		if err != nil {
			return err
		}
		err = f(wire.MapItem{Key: kw, Value: vw})
		if err != nil {
			return err
		}
	}
	return nil
}

func (m _Map_String_String_MapItemList) Size() int {
	return len(m)
}

func (_Map_String_String_MapItemList) KeyType() wire.Type {
	return wire.TBinary
}

func (_Map_String_String_MapItemList) ValueType() wire.Type {
	return wire.TBinary
}

func (_Map_String_String_MapItemList) Close() {}

// ToWire translates a DomainInfo struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *DomainInfo) ToWire() (wire.Value, error) {
	var (
		fields [6]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Name != nil {
		w, err = wire.NewValueString(*(v.Name)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Status != nil {
		w, err = v.Status.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.Description != nil {
		w, err = wire.NewValueString(*(v.Description)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.OwnerEmail != nil {
		w, err = wire.NewValueString(*(v.OwnerEmail)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.Data != nil {
		w, err = wire.NewValueMap(_Map_String_String_MapItemList(v.Data)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.UUID != nil {
		w, err = wire.NewValueString(*(v.UUID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _DomainStatus_Read(w wire.Value) (DomainStatus, error) {
	var v DomainStatus
	err := v.FromWire(w)
	return v, err
}

func _Map_String_String_Read(m wire.MapItemList) (map[string]string, error) {
	if m.KeyType() != wire.TBinary {
		return nil, nil
	}

	if m.ValueType() != wire.TBinary {
		return nil, nil
	}

	o := make(map[string]string, m.Size())
	err := m.ForEach(func(x wire.MapItem) error {
		k, err := x.Key.GetString(), error(nil)
		if err != nil {
			return err
		}

		v, err := x.Value.GetString(), error(nil)
		if err != nil {
			return err
		}

		o[k] = v
		return nil
	})
	m.Close()
	return o, err
}

// FromWire deserializes a DomainInfo struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a DomainInfo struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v DomainInfo
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *DomainInfo) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Name = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI32 {
				var x DomainStatus
				x, err = _DomainStatus_Read(field.Value)
				v.Status = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Description = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.OwnerEmail = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TMap {
				v.Data, err = _Map_String_String_Read(field.Value.GetMap())
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.UUID = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a DomainInfo
// struct.
func (v *DomainInfo) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [6]string
	i := 0
	if v.Name != nil {
		fields[i] = fmt.Sprintf("Name: %v", *(v.Name))
		i++
	}
	if v.Status != nil {
		fields[i] = fmt.Sprintf("Status: %v", *(v.Status))
		i++
	}
	if v.Description != nil {
		fields[i] = fmt.Sprintf("Description: %v", *(v.Description))
		i++
	}
	if v.OwnerEmail != nil {
		fields[i] = fmt.Sprintf("OwnerEmail: %v", *(v.OwnerEmail))
		i++
	}
	if v.Data != nil {
		fields[i] = fmt.Sprintf("Data: %v", v.Data)
		i++
	}
	if v.UUID != nil {
		fields[i] = fmt.Sprintf("UUID: %v", *(v.UUID))
		i++
	}

	return fmt.Sprintf("DomainInfo{%v}", strings.Join(fields[:i], ", "))
}

func _DomainStatus_EqualsPtr(lhs, rhs *DomainStatus) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return x.Equals(y)
	}
	return lhs == nil && rhs == nil
}

func _Map_String_String_Equals(lhs, rhs map[string]string) bool {
	if len(lhs) != len(rhs) {
		return false
	}

	for lk, lv := range lhs {
		rv, ok := rhs[lk]
		if !ok {
			return false
		}
		if !(lv == rv) {
			return false
		}
	}
	return true
}

// Equals returns true if all the fields of this DomainInfo match the
// provided DomainInfo.
//
// This function performs a deep comparison.
func (v *DomainInfo) Equals(rhs *DomainInfo) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Name, rhs.Name) {
		return false
	}
	if !_DomainStatus_EqualsPtr(v.Status, rhs.Status) {
		return false
	}
	if !_String_EqualsPtr(v.Description, rhs.Description) {
		return false
	}
	if !_String_EqualsPtr(v.OwnerEmail, rhs.OwnerEmail) {
		return false
	}
	if !((v.Data == nil && rhs.Data == nil) || (v.Data != nil && rhs.Data != nil && _Map_String_String_Equals(v.Data, rhs.Data))) {
		return false
	}
	if !_String_EqualsPtr(v.UUID, rhs.UUID) {
		return false
	}

	return true
}

type _Map_String_String_Zapper map[string]string

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of _Map_String_String_Zapper.
func (m _Map_String_String_Zapper) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	for k, v := range m {
		enc.AddString((string)(k), v)
	}
	return err
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DomainInfo.
func (v *DomainInfo) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Name != nil {
		enc.AddString("name", *v.Name)
	}
	if v.Status != nil {
		err = multierr.Append(err, enc.AddObject("status", *v.Status))
	}
	if v.Description != nil {
		enc.AddString("description", *v.Description)
	}
	if v.OwnerEmail != nil {
		enc.AddString("ownerEmail", *v.OwnerEmail)
	}
	if v.Data != nil {
		err = multierr.Append(err, enc.AddObject("data", (_Map_String_String_Zapper)(v.Data)))
	}
	if v.UUID != nil {
		enc.AddString("uuid", *v.UUID)
	}
	return err
}

// GetName returns the value of Name if it is set or its
// zero value if it is unset.
func (v *DomainInfo) GetName() (o string) {
	if v != nil && v.Name != nil {
		return *v.Name
	}

	return
}

// IsSetName returns true if Name is not nil.
func (v *DomainInfo) IsSetName() bool {
	return v != nil && v.Name != nil
}

// GetStatus returns the value of Status if it is set or its
// zero value if it is unset.
func (v *DomainInfo) GetStatus() (o DomainStatus) {
	if v != nil && v.Status != nil {
		return *v.Status
	}

	return
}

// IsSetStatus returns true if Status is not nil.
func (v *DomainInfo) IsSetStatus() bool {
	return v != nil && v.Status != nil
}

// GetDescription returns the value of Description if it is set or its
// zero value if it is unset.
func (v *DomainInfo) GetDescription() (o string) {
	if v != nil && v.Description != nil {
		return *v.Description
	}

	return
}

// IsSetDescription returns true if Description is not nil.
func (v *DomainInfo) IsSetDescription() bool {
	return v != nil && v.Description != nil
}

// GetOwnerEmail returns the value of OwnerEmail if it is set or its
// zero value if it is unset.
func (v *DomainInfo) GetOwnerEmail() (o string) {
	if v != nil && v.OwnerEmail != nil {
		return *v.OwnerEmail
	}

	return
}

// IsSetOwnerEmail returns true if OwnerEmail is not nil.
func (v *DomainInfo) IsSetOwnerEmail() bool {
	return v != nil && v.OwnerEmail != nil
}

// GetData returns the value of Data if it is set or its
// zero value if it is unset.
func (v *DomainInfo) GetData() (o map[string]string) {
	if v != nil && v.Data != nil {
		return v.Data
	}

	return
}

// IsSetData returns true if Data is not nil.
func (v *DomainInfo) IsSetData() bool {
	return v != nil && v.Data != nil
}

// GetUUID returns the value of UUID if it is set or its
// zero value if it is unset.
func (v *DomainInfo) GetUUID() (o string) {
	if v != nil && v.UUID != nil {
		return *v.UUID
	}

	return
}

// IsSetUUID returns true if UUID is not nil.
func (v *DomainInfo) IsSetUUID() bool {
	return v != nil && v.UUID != nil
}

type DomainNotActiveError struct {
	Message        string `json:"message,required"`
	DomainName     string `json:"domainName,required"`
	CurrentCluster string `json:"currentCluster,required"`
	ActiveCluster  string `json:"activeCluster,required"`
}

// ToWire translates a DomainNotActiveError struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *DomainNotActiveError) ToWire() (wire.Value, error) {
	var (
		fields [4]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	w, err = wire.NewValueString(v.Message), error(nil)
	if err != nil {
		return w, err
	}
	fields[i] = wire.Field{ID: 1, Value: w}
	i++

	w, err = wire.NewValueString(v.DomainName), error(nil)
	if err != nil {
		return w, err
	}
	fields[i] = wire.Field{ID: 2, Value: w}
	i++

	w, err = wire.NewValueString(v.CurrentCluster), error(nil)
	if err != nil {
		return w, err
	}
	fields[i] = wire.Field{ID: 3, Value: w}
	i++

	w, err = wire.NewValueString(v.ActiveCluster), error(nil)
	if err != nil {
		return w, err
	}
	fields[i] = wire.Field{ID: 4, Value: w}
	i++

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a DomainNotActiveError struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a DomainNotActiveError struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v DomainNotActiveError
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *DomainNotActiveError) FromWire(w wire.Value) error {
	var err error

	messageIsSet := false
	domainNameIsSet := false
	currentClusterIsSet := false
	activeClusterIsSet := false

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 1:
			if field.Value.Type() == wire.TBinary {
				v.Message, err = field.Value.GetString(), error(nil)
				if err != nil {
					return err
				}
				messageIsSet = true
			}
		case 2:
			if field.Value.Type() == wire.TBinary {
				v.DomainName, err = field.Value.GetString(), error(nil)
				if err != nil {
					return err
				}
				domainNameIsSet = true
			}
		case 3:
			if field.Value.Type() == wire.TBinary {
				v.CurrentCluster, err = field.Value.GetString(), error(nil)
				if err != nil {
					return err
				}
				currentClusterIsSet = true
			}
		case 4:
			if field.Value.Type() == wire.TBinary {
				v.ActiveCluster, err = field.Value.GetString(), error(nil)
				if err != nil {
					return err
				}
				activeClusterIsSet = true
			}
		}
	}

	if !messageIsSet {
		return errors.New("field Message of DomainNotActiveError is required")
	}

	if !domainNameIsSet {
		return errors.New("field DomainName of DomainNotActiveError is required")
	}

	if !currentClusterIsSet {
		return errors.New("field CurrentCluster of DomainNotActiveError is required")
	}

	if !activeClusterIsSet {
		return errors.New("field ActiveCluster of DomainNotActiveError is required")
	}

	return nil
}

// String returns a readable string representation of a DomainNotActiveError
// struct.
func (v *DomainNotActiveError) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [4]string
	i := 0
	fields[i] = fmt.Sprintf("Message: %v", v.Message)
	i++
	fields[i] = fmt.Sprintf("DomainName: %v", v.DomainName)
	i++
	fields[i] = fmt.Sprintf("CurrentCluster: %v", v.CurrentCluster)
	i++
	fields[i] = fmt.Sprintf("ActiveCluster: %v", v.ActiveCluster)
	i++

	return fmt.Sprintf("DomainNotActiveError{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this DomainNotActiveError match the
// provided DomainNotActiveError.
//
// This function performs a deep comparison.
func (v *DomainNotActiveError) Equals(rhs *DomainNotActiveError) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !(v.Message == rhs.Message) {
		return false
	}
	if !(v.DomainName == rhs.DomainName) {
		return false
	}
	if !(v.CurrentCluster == rhs.CurrentCluster) {
		return false
	}
	if !(v.ActiveCluster == rhs.ActiveCluster) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DomainNotActiveError.
func (v *DomainNotActiveError) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	enc.AddString("message", v.Message)
	enc.AddString("domainName", v.DomainName)
	enc.AddString("currentCluster", v.CurrentCluster)
	enc.AddString("activeCluster", v.ActiveCluster)
	return err
}

// GetMessage returns the value of Message if it is set or its
// zero value if it is unset.
func (v *DomainNotActiveError) GetMessage() (o string) {
	if v != nil {
		o = v.Message
	}
	return
}

// GetDomainName returns the value of DomainName if it is set or its
// zero value if it is unset.
func (v *DomainNotActiveError) GetDomainName() (o string) {
	if v != nil {
		o = v.DomainName
	}
	return
}

// GetCurrentCluster returns the value of CurrentCluster if it is set or its
// zero value if it is unset.
func (v *DomainNotActiveError) GetCurrentCluster() (o string) {
	if v != nil {
		o = v.CurrentCluster
	}
	return
}

// GetActiveCluster returns the value of ActiveCluster if it is set or its
// zero value if it is unset.
func (v *DomainNotActiveError) GetActiveCluster() (o string) {
	if v != nil {
		o = v.ActiveCluster
	}
	return
}

func (v *DomainNotActiveError) Error() string {
	return v.String()
}

type DomainReplicationConfiguration struct {
	ActiveClusterName *string                            `json:"activeClusterName,omitempty"`
	Clusters          []*ClusterReplicationConfiguration `json:"clusters,omitempty"`
}

type _List_ClusterReplicationConfiguration_ValueList []*ClusterReplicationConfiguration

func (v _List_ClusterReplicationConfiguration_ValueList) ForEach(f func(wire.Value) error) error {
	for i, x := range v {
		if x == nil {
			return fmt.Errorf("invalid [%v]: value is nil", i)
		}
		w, err := x.ToWire()
		if err != nil {
			return err
		}
		err = f(w)
		if err != nil {
			return err
		}
	}
	return nil
}

func (v _List_ClusterReplicationConfiguration_ValueList) Size() int {
	return len(v)
}

func (_List_ClusterReplicationConfiguration_ValueList) ValueType() wire.Type {
	return wire.TStruct
}

func (_List_ClusterReplicationConfiguration_ValueList) Close() {}

// ToWire translates a DomainReplicationConfiguration struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *DomainReplicationConfiguration) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.ActiveClusterName != nil {
		w, err = wire.NewValueString(*(v.ActiveClusterName)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Clusters != nil {
		w, err = wire.NewValueList(_List_ClusterReplicationConfiguration_ValueList(v.Clusters)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _ClusterReplicationConfiguration_Read(w wire.Value) (*ClusterReplicationConfiguration, error) {
	var v ClusterReplicationConfiguration
	err := v.FromWire(w)
	return &v, err
}

func _List_ClusterReplicationConfiguration_Read(l wire.ValueList) ([]*ClusterReplicationConfiguration, error) {
	if l.ValueType() != wire.TStruct {
		return nil, nil
	}

	o := make([]*ClusterReplicationConfiguration, 0, l.Size())
	err := l.ForEach(func(x wire.Value) error {
		i, err := _ClusterReplicationConfiguration_Read(x)
		if err != nil {
			return err
		}
		o = append(o, i)
		return nil
	})
	l.Close()
	return o, err
}

// FromWire deserializes a DomainReplicationConfiguration struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a DomainReplicationConfiguration struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v DomainReplicationConfiguration
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *DomainReplicationConfiguration) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ActiveClusterName = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TList {
				v.Clusters, err = _List_ClusterReplicationConfiguration_Read(field.Value.GetList())
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a DomainReplicationConfiguration
// struct.
func (v *DomainReplicationConfiguration) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.ActiveClusterName != nil {
		fields[i] = fmt.Sprintf("ActiveClusterName: %v", *(v.ActiveClusterName))
		i++
	}
	if v.Clusters != nil {
		fields[i] = fmt.Sprintf("Clusters: %v", v.Clusters)
		i++
	}

	return fmt.Sprintf("DomainReplicationConfiguration{%v}", strings.Join(fields[:i], ", "))
}

func _List_ClusterReplicationConfiguration_Equals(lhs, rhs []*ClusterReplicationConfiguration) bool {
	if len(lhs) != len(rhs) {
		return false
	}

	for i, lv := range lhs {
		rv := rhs[i]
		if !lv.Equals(rv) {
			return false
		}
	}

	return true
}

// Equals returns true if all the fields of this DomainReplicationConfiguration match the
// provided DomainReplicationConfiguration.
//
// This function performs a deep comparison.
func (v *DomainReplicationConfiguration) Equals(rhs *DomainReplicationConfiguration) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.ActiveClusterName, rhs.ActiveClusterName) {
		return false
	}
	if !((v.Clusters == nil && rhs.Clusters == nil) || (v.Clusters != nil && rhs.Clusters != nil && _List_ClusterReplicationConfiguration_Equals(v.Clusters, rhs.Clusters))) {
		return false
	}

	return true
}

type _List_ClusterReplicationConfiguration_Zapper []*ClusterReplicationConfiguration

// MarshalLogArray implements zapcore.ArrayMarshaler, enabling
// fast logging of _List_ClusterReplicationConfiguration_Zapper.
func (l _List_ClusterReplicationConfiguration_Zapper) MarshalLogArray(enc zapcore.ArrayEncoder) (err error) {
	for _, v := range l {
		err = multierr.Append(err, enc.AppendObject(v))
	}
	return err
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DomainReplicationConfiguration.
func (v *DomainReplicationConfiguration) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.ActiveClusterName != nil {
		enc.AddString("activeClusterName", *v.ActiveClusterName)
	}
	if v.Clusters != nil {
		err = multierr.Append(err, enc.AddArray("clusters", (_List_ClusterReplicationConfiguration_Zapper)(v.Clusters)))
	}
	return err
}

// GetActiveClusterName returns the value of ActiveClusterName if it is set or its
// zero value if it is unset.
func (v *DomainReplicationConfiguration) GetActiveClusterName() (o string) {
	if v != nil && v.ActiveClusterName != nil {
		return *v.ActiveClusterName
	}

	return
}

// IsSetActiveClusterName returns true if ActiveClusterName is not nil.
func (v *DomainReplicationConfiguration) IsSetActiveClusterName() bool {
	return v != nil && v.ActiveClusterName != nil
}

// GetClusters returns the value of Clusters if it is set or its
// zero value if it is unset.
func (v *DomainReplicationConfiguration) GetClusters() (o []*ClusterReplicationConfiguration) {
	if v != nil && v.Clusters != nil {
		return v.Clusters
	}

	return
}

// IsSetClusters returns true if Clusters is not nil.
func (v *DomainReplicationConfiguration) IsSetClusters() bool {
	return v != nil && v.Clusters != nil
}

type DomainStatus int32

const (
	DomainStatusRegistered DomainStatus = 0
	DomainStatusDeprecated DomainStatus = 1
	DomainStatusDeleted    DomainStatus = 2
)

// DomainStatus_Values returns all recognized values of DomainStatus.
func DomainStatus_Values() []DomainStatus {
	return []DomainStatus{
		DomainStatusRegistered,
		DomainStatusDeprecated,
		DomainStatusDeleted,
	}
}

// UnmarshalText tries to decode DomainStatus from a byte slice
// containing its name.
//
//   var v DomainStatus
//   err := v.UnmarshalText([]byte("REGISTERED"))
func (v *DomainStatus) UnmarshalText(value []byte) error {
	switch s := string(value); s {
	case "REGISTERED":
		*v = DomainStatusRegistered
		return nil
	case "DEPRECATED":
		*v = DomainStatusDeprecated
		return nil
	case "DELETED":
		*v = DomainStatusDeleted
		return nil
	default:
		val, err := strconv.ParseInt(s, 10, 32)
		if err != nil {
			return fmt.Errorf("unknown enum value %q for %q: %v", s, "DomainStatus", err)
		}
		*v = DomainStatus(val)
		return nil
	}
}

// MarshalText encodes DomainStatus to text.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements the TextMarshaler interface.
func (v DomainStatus) MarshalText() ([]byte, error) {
	switch int32(v) {
	case 0:
		return []byte("REGISTERED"), nil
	case 1:
		return []byte("DEPRECATED"), nil
	case 2:
		return []byte("DELETED"), nil
	}
	return []byte(strconv.FormatInt(int64(v), 10)), nil
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DomainStatus.
// Enums are logged as objects, where the value is logged with key "value", and
// if this value's name is known, the name is logged with key "name".
func (v DomainStatus) MarshalLogObject(enc zapcore.ObjectEncoder) error {
	enc.AddInt32("value", int32(v))
	switch int32(v) {
	case 0:
		enc.AddString("name", "REGISTERED")
	case 1:
		enc.AddString("name", "DEPRECATED")
	case 2:
		enc.AddString("name", "DELETED")
	}
	return nil
}

// Ptr returns a pointer to this enum value.
func (v DomainStatus) Ptr() *DomainStatus {
	return &v
}

// ToWire translates DomainStatus into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// Enums are represented as 32-bit integers over the wire.
func (v DomainStatus) ToWire() (wire.Value, error) {
	return wire.NewValueI32(int32(v)), nil
}

// FromWire deserializes DomainStatus from its Thrift-level
// representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TI32)
//   if err != nil {
//     return DomainStatus(0), err
//   }
//
//   var v DomainStatus
//   if err := v.FromWire(x); err != nil {
//     return DomainStatus(0), err
//   }
//   return v, nil
func (v *DomainStatus) FromWire(w wire.Value) error {
	*v = (DomainStatus)(w.GetI32())
	return nil
}

// String returns a readable string representation of DomainStatus.
func (v DomainStatus) String() string {
	w := int32(v)
	switch w {
	case 0:
		return "REGISTERED"
	case 1:
		return "DEPRECATED"
	case 2:
		return "DELETED"
	}
	return fmt.Sprintf("DomainStatus(%d)", w)
}

// Equals returns true if this DomainStatus value matches the provided
// value.
func (v DomainStatus) Equals(rhs DomainStatus) bool {
	return v == rhs
}

// MarshalJSON serializes DomainStatus into JSON.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements json.Marshaler.
func (v DomainStatus) MarshalJSON() ([]byte, error) {
	switch int32(v) {
	case 0:
		return ([]byte)("\"REGISTERED\""), nil
	case 1:
		return ([]byte)("\"DEPRECATED\""), nil
	case 2:
		return ([]byte)("\"DELETED\""), nil
	}
	return ([]byte)(strconv.FormatInt(int64(v), 10)), nil
}

// UnmarshalJSON attempts to decode DomainStatus from its JSON
// representation.
//
// This implementation supports both, numeric and string inputs. If a
// string is provided, it must be a known enum name.
//
// This implements json.Unmarshaler.
func (v *DomainStatus) UnmarshalJSON(text []byte) error {
	d := json.NewDecoder(bytes.NewReader(text))
	d.UseNumber()
	t, err := d.Token()
	if err != nil {
		return err
	}

	switch w := t.(type) {
	case json.Number:
		x, err := w.Int64()
		if err != nil {
			return err
		}
		if x > math.MaxInt32 {
			return fmt.Errorf("enum overflow from JSON %q for %q", text, "DomainStatus")
		}
		if x < math.MinInt32 {
			return fmt.Errorf("enum underflow from JSON %q for %q", text, "DomainStatus")
		}
		*v = (DomainStatus)(x)
		return nil
	case string:
		return v.UnmarshalText([]byte(w))
	default:
		return fmt.Errorf("invalid JSON value %q (%T) to unmarshal into %q", t, t, "DomainStatus")
	}
}

type EncodingType int32

const (
	EncodingTypeThriftRW EncodingType = 0
)

// EncodingType_Values returns all recognized values of EncodingType.
func EncodingType_Values() []EncodingType {
	return []EncodingType{
		EncodingTypeThriftRW,
	}
}

// UnmarshalText tries to decode EncodingType from a byte slice
// containing its name.
//
//   var v EncodingType
//   err := v.UnmarshalText([]byte("ThriftRW"))
func (v *EncodingType) UnmarshalText(value []byte) error {
	switch s := string(value); s {
	case "ThriftRW":
		*v = EncodingTypeThriftRW
		return nil
	default:
		val, err := strconv.ParseInt(s, 10, 32)
		if err != nil {
			return fmt.Errorf("unknown enum value %q for %q: %v", s, "EncodingType", err)
		}
		*v = EncodingType(val)
		return nil
	}
}

// MarshalText encodes EncodingType to text.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements the TextMarshaler interface.
func (v EncodingType) MarshalText() ([]byte, error) {
	switch int32(v) {
	case 0:
		return []byte("ThriftRW"), nil
	}
	return []byte(strconv.FormatInt(int64(v), 10)), nil
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of EncodingType.
// Enums are logged as objects, where the value is logged with key "value", and
// if this value's name is known, the name is logged with key "name".
func (v EncodingType) MarshalLogObject(enc zapcore.ObjectEncoder) error {
	enc.AddInt32("value", int32(v))
	switch int32(v) {
	case 0:
		enc.AddString("name", "ThriftRW")
	}
	return nil
}

// Ptr returns a pointer to this enum value.
func (v EncodingType) Ptr() *EncodingType {
	return &v
}

// ToWire translates EncodingType into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// Enums are represented as 32-bit integers over the wire.
func (v EncodingType) ToWire() (wire.Value, error) {
	return wire.NewValueI32(int32(v)), nil
}

// FromWire deserializes EncodingType from its Thrift-level
// representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TI32)
//   if err != nil {
//     return EncodingType(0), err
//   }
//
//   var v EncodingType
//   if err := v.FromWire(x); err != nil {
//     return EncodingType(0), err
//   }
//   return v, nil
func (v *EncodingType) FromWire(w wire.Value) error {
	*v = (EncodingType)(w.GetI32())
	return nil
}

// String returns a readable string representation of EncodingType.
func (v EncodingType) String() string {
	w := int32(v)
	switch w {
	case 0:
		return "ThriftRW"
	}
	return fmt.Sprintf("EncodingType(%d)", w)
}

// Equals returns true if this EncodingType value matches the provided
// value.
func (v EncodingType) Equals(rhs EncodingType) bool {
	return v == rhs
}

// MarshalJSON serializes EncodingType into JSON.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements json.Marshaler.
func (v EncodingType) MarshalJSON() ([]byte, error) {
	switch int32(v) {
	case 0:
		return ([]byte)("\"ThriftRW\""), nil
	}
	return ([]byte)(strconv.FormatInt(int64(v), 10)), nil
}

// UnmarshalJSON attempts to decode EncodingType from its JSON
// representation.
//
// This implementation supports both, numeric and string inputs. If a
// string is provided, it must be a known enum name.
//
// This implements json.Unmarshaler.
func (v *EncodingType) UnmarshalJSON(text []byte) error {
	d := json.NewDecoder(bytes.NewReader(text))
	d.UseNumber()
	t, err := d.Token()
	if err != nil {
		return err
	}

	switch w := t.(type) {
	case json.Number:
		x, err := w.Int64()
		if err != nil {
			return err
		}
		if x > math.MaxInt32 {
			return fmt.Errorf("enum overflow from JSON %q for %q", text, "EncodingType")
		}
		if x < math.MinInt32 {
			return fmt.Errorf("enum underflow from JSON %q for %q", text, "EncodingType")
		}
		*v = (EncodingType)(x)
		return nil
	case string:
		return v.UnmarshalText([]byte(w))
	default:
		return fmt.Errorf("invalid JSON value %q (%T) to unmarshal into %q", t, t, "EncodingType")
	}
}

type EntityNotExistsError struct {
	Message string `json:"message,required"`
}

// ToWire translates a EntityNotExistsError struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *EntityNotExistsError) ToWire() (wire.Value, error) {
	var (
		fields [1]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	w, err = wire.NewValueString(v.Message), error(nil)
	if err != nil {
		return w, err
	}
	fields[i] = wire.Field{ID: 1, Value: w}
	i++

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a EntityNotExistsError struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a EntityNotExistsError struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v EntityNotExistsError
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *EntityNotExistsError) FromWire(w wire.Value) error {
	var err error

	messageIsSet := false

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 1:
			if field.Value.Type() == wire.TBinary {
				v.Message, err = field.Value.GetString(), error(nil)
				if err != nil {
					return err
				}
				messageIsSet = true
			}
		}
	}

	if !messageIsSet {
		return errors.New("field Message of EntityNotExistsError is required")
	}

	return nil
}

// String returns a readable string representation of a EntityNotExistsError
// struct.
func (v *EntityNotExistsError) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [1]string
	i := 0
	fields[i] = fmt.Sprintf("Message: %v", v.Message)
	i++

	return fmt.Sprintf("EntityNotExistsError{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this EntityNotExistsError match the
// provided EntityNotExistsError.
//
// This function performs a deep comparison.
func (v *EntityNotExistsError) Equals(rhs *EntityNotExistsError) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !(v.Message == rhs.Message) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of EntityNotExistsError.
func (v *EntityNotExistsError) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	enc.AddString("message", v.Message)
	return err
}

// GetMessage returns the value of Message if it is set or its
// zero value if it is unset.
func (v *EntityNotExistsError) GetMessage() (o string) {
	if v != nil {
		o = v.Message
	}
	return
}

func (v *EntityNotExistsError) Error() string {
	return v.String()
}

type EventType int32

const (
	EventTypeWorkflowExecutionStarted                        EventType = 0
	EventTypeWorkflowExecutionCompleted                      EventType = 1
	EventTypeWorkflowExecutionFailed                         EventType = 2
	EventTypeWorkflowExecutionTimedOut                       EventType = 3
	EventTypeDecisionTaskScheduled                           EventType = 4
	EventTypeDecisionTaskStarted                             EventType = 5
	EventTypeDecisionTaskCompleted                           EventType = 6
	EventTypeDecisionTaskTimedOut                            EventType = 7
	EventTypeDecisionTaskFailed                              EventType = 8
	EventTypeActivityTaskScheduled                           EventType = 9
	EventTypeActivityTaskStarted                             EventType = 10
	EventTypeActivityTaskCompleted                           EventType = 11
	EventTypeActivityTaskFailed                              EventType = 12
	EventTypeActivityTaskTimedOut                            EventType = 13
	EventTypeActivityTaskCancelRequested                     EventType = 14
	EventTypeRequestCancelActivityTaskFailed                 EventType = 15
	EventTypeActivityTaskCanceled                            EventType = 16
	EventTypeTimerStarted                                    EventType = 17
	EventTypeTimerFired                                      EventType = 18
	EventTypeCancelTimerFailed                               EventType = 19
	EventTypeTimerCanceled                                   EventType = 20
	EventTypeWorkflowExecutionCancelRequested                EventType = 21
	EventTypeWorkflowExecutionCanceled                       EventType = 22
	EventTypeRequestCancelExternalWorkflowExecutionInitiated EventType = 23
	EventTypeRequestCancelExternalWorkflowExecutionFailed    EventType = 24
	EventTypeExternalWorkflowExecutionCancelRequested        EventType = 25
	EventTypeMarkerRecorded                                  EventType = 26
	EventTypeWorkflowExecutionSignaled                       EventType = 27
	EventTypeWorkflowExecutionTerminated                     EventType = 28
	EventTypeWorkflowExecutionContinuedAsNew                 EventType = 29
	EventTypeStartChildWorkflowExecutionInitiated            EventType = 30
	EventTypeStartChildWorkflowExecutionFailed               EventType = 31
	EventTypeChildWorkflowExecutionStarted                   EventType = 32
	EventTypeChildWorkflowExecutionCompleted                 EventType = 33
	EventTypeChildWorkflowExecutionFailed                    EventType = 34
	EventTypeChildWorkflowExecutionCanceled                  EventType = 35
	EventTypeChildWorkflowExecutionTimedOut                  EventType = 36
	EventTypeChildWorkflowExecutionTerminated                EventType = 37
	EventTypeSignalExternalWorkflowExecutionInitiated        EventType = 38
	EventTypeSignalExternalWorkflowExecutionFailed           EventType = 39
	EventTypeExternalWorkflowExecutionSignaled               EventType = 40
)

// EventType_Values returns all recognized values of EventType.
func EventType_Values() []EventType {
	return []EventType{
		EventTypeWorkflowExecutionStarted,
		EventTypeWorkflowExecutionCompleted,
		EventTypeWorkflowExecutionFailed,
		EventTypeWorkflowExecutionTimedOut,
		EventTypeDecisionTaskScheduled,
		EventTypeDecisionTaskStarted,
		EventTypeDecisionTaskCompleted,
		EventTypeDecisionTaskTimedOut,
		EventTypeDecisionTaskFailed,
		EventTypeActivityTaskScheduled,
		EventTypeActivityTaskStarted,
		EventTypeActivityTaskCompleted,
		EventTypeActivityTaskFailed,
		EventTypeActivityTaskTimedOut,
		EventTypeActivityTaskCancelRequested,
		EventTypeRequestCancelActivityTaskFailed,
		EventTypeActivityTaskCanceled,
		EventTypeTimerStarted,
		EventTypeTimerFired,
		EventTypeCancelTimerFailed,
		EventTypeTimerCanceled,
		EventTypeWorkflowExecutionCancelRequested,
		EventTypeWorkflowExecutionCanceled,
		EventTypeRequestCancelExternalWorkflowExecutionInitiated,
		EventTypeRequestCancelExternalWorkflowExecutionFailed,
		EventTypeExternalWorkflowExecutionCancelRequested,
		EventTypeMarkerRecorded,
		EventTypeWorkflowExecutionSignaled,
		EventTypeWorkflowExecutionTerminated,
		EventTypeWorkflowExecutionContinuedAsNew,
		EventTypeStartChildWorkflowExecutionInitiated,
		EventTypeStartChildWorkflowExecutionFailed,
		EventTypeChildWorkflowExecutionStarted,
		EventTypeChildWorkflowExecutionCompleted,
		EventTypeChildWorkflowExecutionFailed,
		EventTypeChildWorkflowExecutionCanceled,
		EventTypeChildWorkflowExecutionTimedOut,
		EventTypeChildWorkflowExecutionTerminated,
		EventTypeSignalExternalWorkflowExecutionInitiated,
		EventTypeSignalExternalWorkflowExecutionFailed,
		EventTypeExternalWorkflowExecutionSignaled,
	}
}

// UnmarshalText tries to decode EventType from a byte slice
// containing its name.
//
//   var v EventType
//   err := v.UnmarshalText([]byte("WorkflowExecutionStarted"))
func (v *EventType) UnmarshalText(value []byte) error {
	switch s := string(value); s {
	case "WorkflowExecutionStarted":
		*v = EventTypeWorkflowExecutionStarted
		return nil
	case "WorkflowExecutionCompleted":
		*v = EventTypeWorkflowExecutionCompleted
		return nil
	case "WorkflowExecutionFailed":
		*v = EventTypeWorkflowExecutionFailed
		return nil
	case "WorkflowExecutionTimedOut":
		*v = EventTypeWorkflowExecutionTimedOut
		return nil
	case "DecisionTaskScheduled":
		*v = EventTypeDecisionTaskScheduled
		return nil
	case "DecisionTaskStarted":
		*v = EventTypeDecisionTaskStarted
		return nil
	case "DecisionTaskCompleted":
		*v = EventTypeDecisionTaskCompleted
		return nil
	case "DecisionTaskTimedOut":
		*v = EventTypeDecisionTaskTimedOut
		return nil
	case "DecisionTaskFailed":
		*v = EventTypeDecisionTaskFailed
		return nil
	case "ActivityTaskScheduled":
		*v = EventTypeActivityTaskScheduled
		return nil
	case "ActivityTaskStarted":
		*v = EventTypeActivityTaskStarted
		return nil
	case "ActivityTaskCompleted":
		*v = EventTypeActivityTaskCompleted
		return nil
	case "ActivityTaskFailed":
		*v = EventTypeActivityTaskFailed
		return nil
	case "ActivityTaskTimedOut":
		*v = EventTypeActivityTaskTimedOut
		return nil
	case "ActivityTaskCancelRequested":
		*v = EventTypeActivityTaskCancelRequested
		return nil
	case "RequestCancelActivityTaskFailed":
		*v = EventTypeRequestCancelActivityTaskFailed
		return nil
	case "ActivityTaskCanceled":
		*v = EventTypeActivityTaskCanceled
		return nil
	case "TimerStarted":
		*v = EventTypeTimerStarted
		return nil
	case "TimerFired":
		*v = EventTypeTimerFired
		return nil
	case "CancelTimerFailed":
		*v = EventTypeCancelTimerFailed
		return nil
	case "TimerCanceled":
		*v = EventTypeTimerCanceled
		return nil
	case "WorkflowExecutionCancelRequested":
		*v = EventTypeWorkflowExecutionCancelRequested
		return nil
	case "WorkflowExecutionCanceled":
		*v = EventTypeWorkflowExecutionCanceled
		return nil
	case "RequestCancelExternalWorkflowExecutionInitiated":
		*v = EventTypeRequestCancelExternalWorkflowExecutionInitiated
		return nil
	case "RequestCancelExternalWorkflowExecutionFailed":
		*v = EventTypeRequestCancelExternalWorkflowExecutionFailed
		return nil
	case "ExternalWorkflowExecutionCancelRequested":
		*v = EventTypeExternalWorkflowExecutionCancelRequested
		return nil
	case "MarkerRecorded":
		*v = EventTypeMarkerRecorded
		return nil
	case "WorkflowExecutionSignaled":
		*v = EventTypeWorkflowExecutionSignaled
		return nil
	case "WorkflowExecutionTerminated":
		*v = EventTypeWorkflowExecutionTerminated
		return nil
	case "WorkflowExecutionContinuedAsNew":
		*v = EventTypeWorkflowExecutionContinuedAsNew
		return nil
	case "StartChildWorkflowExecutionInitiated":
		*v = EventTypeStartChildWorkflowExecutionInitiated
		return nil
	case "StartChildWorkflowExecutionFailed":
		*v = EventTypeStartChildWorkflowExecutionFailed
		return nil
	case "ChildWorkflowExecutionStarted":
		*v = EventTypeChildWorkflowExecutionStarted
		return nil
	case "ChildWorkflowExecutionCompleted":
		*v = EventTypeChildWorkflowExecutionCompleted
		return nil
	case "ChildWorkflowExecutionFailed":
		*v = EventTypeChildWorkflowExecutionFailed
		return nil
	case "ChildWorkflowExecutionCanceled":
		*v = EventTypeChildWorkflowExecutionCanceled
		return nil
	case "ChildWorkflowExecutionTimedOut":
		*v = EventTypeChildWorkflowExecutionTimedOut
		return nil
	case "ChildWorkflowExecutionTerminated":
		*v = EventTypeChildWorkflowExecutionTerminated
		return nil
	case "SignalExternalWorkflowExecutionInitiated":
		*v = EventTypeSignalExternalWorkflowExecutionInitiated
		return nil
	case "SignalExternalWorkflowExecutionFailed":
		*v = EventTypeSignalExternalWorkflowExecutionFailed
		return nil
	case "ExternalWorkflowExecutionSignaled":
		*v = EventTypeExternalWorkflowExecutionSignaled
		return nil
	default:
		val, err := strconv.ParseInt(s, 10, 32)
		if err != nil {
			return fmt.Errorf("unknown enum value %q for %q: %v", s, "EventType", err)
		}
		*v = EventType(val)
		return nil
	}
}

// MarshalText encodes EventType to text.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements the TextMarshaler interface.
func (v EventType) MarshalText() ([]byte, error) {
	switch int32(v) {
	case 0:
		return []byte("WorkflowExecutionStarted"), nil
	case 1:
		return []byte("WorkflowExecutionCompleted"), nil
	case 2:
		return []byte("WorkflowExecutionFailed"), nil
	case 3:
		return []byte("WorkflowExecutionTimedOut"), nil
	case 4:
		return []byte("DecisionTaskScheduled"), nil
	case 5:
		return []byte("DecisionTaskStarted"), nil
	case 6:
		return []byte("DecisionTaskCompleted"), nil
	case 7:
		return []byte("DecisionTaskTimedOut"), nil
	case 8:
		return []byte("DecisionTaskFailed"), nil
	case 9:
		return []byte("ActivityTaskScheduled"), nil
	case 10:
		return []byte("ActivityTaskStarted"), nil
	case 11:
		return []byte("ActivityTaskCompleted"), nil
	case 12:
		return []byte("ActivityTaskFailed"), nil
	case 13:
		return []byte("ActivityTaskTimedOut"), nil
	case 14:
		return []byte("ActivityTaskCancelRequested"), nil
	case 15:
		return []byte("RequestCancelActivityTaskFailed"), nil
	case 16:
		return []byte("ActivityTaskCanceled"), nil
	case 17:
		return []byte("TimerStarted"), nil
	case 18:
		return []byte("TimerFired"), nil
	case 19:
		return []byte("CancelTimerFailed"), nil
	case 20:
		return []byte("TimerCanceled"), nil
	case 21:
		return []byte("WorkflowExecutionCancelRequested"), nil
	case 22:
		return []byte("WorkflowExecutionCanceled"), nil
	case 23:
		return []byte("RequestCancelExternalWorkflowExecutionInitiated"), nil
	case 24:
		return []byte("RequestCancelExternalWorkflowExecutionFailed"), nil
	case 25:
		return []byte("ExternalWorkflowExecutionCancelRequested"), nil
	case 26:
		return []byte("MarkerRecorded"), nil
	case 27:
		return []byte("WorkflowExecutionSignaled"), nil
	case 28:
		return []byte("WorkflowExecutionTerminated"), nil
	case 29:
		return []byte("WorkflowExecutionContinuedAsNew"), nil
	case 30:
		return []byte("StartChildWorkflowExecutionInitiated"), nil
	case 31:
		return []byte("StartChildWorkflowExecutionFailed"), nil
	case 32:
		return []byte("ChildWorkflowExecutionStarted"), nil
	case 33:
		return []byte("ChildWorkflowExecutionCompleted"), nil
	case 34:
		return []byte("ChildWorkflowExecutionFailed"), nil
	case 35:
		return []byte("ChildWorkflowExecutionCanceled"), nil
	case 36:
		return []byte("ChildWorkflowExecutionTimedOut"), nil
	case 37:
		return []byte("ChildWorkflowExecutionTerminated"), nil
	case 38:
		return []byte("SignalExternalWorkflowExecutionInitiated"), nil
	case 39:
		return []byte("SignalExternalWorkflowExecutionFailed"), nil
	case 40:
		return []byte("ExternalWorkflowExecutionSignaled"), nil
	}
	return []byte(strconv.FormatInt(int64(v), 10)), nil
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of EventType.
// Enums are logged as objects, where the value is logged with key "value", and
// if this value's name is known, the name is logged with key "name".
func (v EventType) MarshalLogObject(enc zapcore.ObjectEncoder) error {
	enc.AddInt32("value", int32(v))
	switch int32(v) {
	case 0:
		enc.AddString("name", "WorkflowExecutionStarted")
	case 1:
		enc.AddString("name", "WorkflowExecutionCompleted")
	case 2:
		enc.AddString("name", "WorkflowExecutionFailed")
	case 3:
		enc.AddString("name", "WorkflowExecutionTimedOut")
	case 4:
		enc.AddString("name", "DecisionTaskScheduled")
	case 5:
		enc.AddString("name", "DecisionTaskStarted")
	case 6:
		enc.AddString("name", "DecisionTaskCompleted")
	case 7:
		enc.AddString("name", "DecisionTaskTimedOut")
	case 8:
		enc.AddString("name", "DecisionTaskFailed")
	case 9:
		enc.AddString("name", "ActivityTaskScheduled")
	case 10:
		enc.AddString("name", "ActivityTaskStarted")
	case 11:
		enc.AddString("name", "ActivityTaskCompleted")
	case 12:
		enc.AddString("name", "ActivityTaskFailed")
	case 13:
		enc.AddString("name", "ActivityTaskTimedOut")
	case 14:
		enc.AddString("name", "ActivityTaskCancelRequested")
	case 15:
		enc.AddString("name", "RequestCancelActivityTaskFailed")
	case 16:
		enc.AddString("name", "ActivityTaskCanceled")
	case 17:
		enc.AddString("name", "TimerStarted")
	case 18:
		enc.AddString("name", "TimerFired")
	case 19:
		enc.AddString("name", "CancelTimerFailed")
	case 20:
		enc.AddString("name", "TimerCanceled")
	case 21:
		enc.AddString("name", "WorkflowExecutionCancelRequested")
	case 22:
		enc.AddString("name", "WorkflowExecutionCanceled")
	case 23:
		enc.AddString("name", "RequestCancelExternalWorkflowExecutionInitiated")
	case 24:
		enc.AddString("name", "RequestCancelExternalWorkflowExecutionFailed")
	case 25:
		enc.AddString("name", "ExternalWorkflowExecutionCancelRequested")
	case 26:
		enc.AddString("name", "MarkerRecorded")
	case 27:
		enc.AddString("name", "WorkflowExecutionSignaled")
	case 28:
		enc.AddString("name", "WorkflowExecutionTerminated")
	case 29:
		enc.AddString("name", "WorkflowExecutionContinuedAsNew")
	case 30:
		enc.AddString("name", "StartChildWorkflowExecutionInitiated")
	case 31:
		enc.AddString("name", "StartChildWorkflowExecutionFailed")
	case 32:
		enc.AddString("name", "ChildWorkflowExecutionStarted")
	case 33:
		enc.AddString("name", "ChildWorkflowExecutionCompleted")
	case 34:
		enc.AddString("name", "ChildWorkflowExecutionFailed")
	case 35:
		enc.AddString("name", "ChildWorkflowExecutionCanceled")
	case 36:
		enc.AddString("name", "ChildWorkflowExecutionTimedOut")
	case 37:
		enc.AddString("name", "ChildWorkflowExecutionTerminated")
	case 38:
		enc.AddString("name", "SignalExternalWorkflowExecutionInitiated")
	case 39:
		enc.AddString("name", "SignalExternalWorkflowExecutionFailed")
	case 40:
		enc.AddString("name", "ExternalWorkflowExecutionSignaled")
	}
	return nil
}

// Ptr returns a pointer to this enum value.
func (v EventType) Ptr() *EventType {
	return &v
}

// ToWire translates EventType into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// Enums are represented as 32-bit integers over the wire.
func (v EventType) ToWire() (wire.Value, error) {
	return wire.NewValueI32(int32(v)), nil
}

// FromWire deserializes EventType from its Thrift-level
// representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TI32)
//   if err != nil {
//     return EventType(0), err
//   }
//
//   var v EventType
//   if err := v.FromWire(x); err != nil {
//     return EventType(0), err
//   }
//   return v, nil
func (v *EventType) FromWire(w wire.Value) error {
	*v = (EventType)(w.GetI32())
	return nil
}

// String returns a readable string representation of EventType.
func (v EventType) String() string {
	w := int32(v)
	switch w {
	case 0:
		return "WorkflowExecutionStarted"
	case 1:
		return "WorkflowExecutionCompleted"
	case 2:
		return "WorkflowExecutionFailed"
	case 3:
		return "WorkflowExecutionTimedOut"
	case 4:
		return "DecisionTaskScheduled"
	case 5:
		return "DecisionTaskStarted"
	case 6:
		return "DecisionTaskCompleted"
	case 7:
		return "DecisionTaskTimedOut"
	case 8:
		return "DecisionTaskFailed"
	case 9:
		return "ActivityTaskScheduled"
	case 10:
		return "ActivityTaskStarted"
	case 11:
		return "ActivityTaskCompleted"
	case 12:
		return "ActivityTaskFailed"
	case 13:
		return "ActivityTaskTimedOut"
	case 14:
		return "ActivityTaskCancelRequested"
	case 15:
		return "RequestCancelActivityTaskFailed"
	case 16:
		return "ActivityTaskCanceled"
	case 17:
		return "TimerStarted"
	case 18:
		return "TimerFired"
	case 19:
		return "CancelTimerFailed"
	case 20:
		return "TimerCanceled"
	case 21:
		return "WorkflowExecutionCancelRequested"
	case 22:
		return "WorkflowExecutionCanceled"
	case 23:
		return "RequestCancelExternalWorkflowExecutionInitiated"
	case 24:
		return "RequestCancelExternalWorkflowExecutionFailed"
	case 25:
		return "ExternalWorkflowExecutionCancelRequested"
	case 26:
		return "MarkerRecorded"
	case 27:
		return "WorkflowExecutionSignaled"
	case 28:
		return "WorkflowExecutionTerminated"
	case 29:
		return "WorkflowExecutionContinuedAsNew"
	case 30:
		return "StartChildWorkflowExecutionInitiated"
	case 31:
		return "StartChildWorkflowExecutionFailed"
	case 32:
		return "ChildWorkflowExecutionStarted"
	case 33:
		return "ChildWorkflowExecutionCompleted"
	case 34:
		return "ChildWorkflowExecutionFailed"
	case 35:
		return "ChildWorkflowExecutionCanceled"
	case 36:
		return "ChildWorkflowExecutionTimedOut"
	case 37:
		return "ChildWorkflowExecutionTerminated"
	case 38:
		return "SignalExternalWorkflowExecutionInitiated"
	case 39:
		return "SignalExternalWorkflowExecutionFailed"
	case 40:
		return "ExternalWorkflowExecutionSignaled"
	}
	return fmt.Sprintf("EventType(%d)", w)
}

// Equals returns true if this EventType value matches the provided
// value.
func (v EventType) Equals(rhs EventType) bool {
	return v == rhs
}

// MarshalJSON serializes EventType into JSON.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements json.Marshaler.
func (v EventType) MarshalJSON() ([]byte, error) {
	switch int32(v) {
	case 0:
		return ([]byte)("\"WorkflowExecutionStarted\""), nil
	case 1:
		return ([]byte)("\"WorkflowExecutionCompleted\""), nil
	case 2:
		return ([]byte)("\"WorkflowExecutionFailed\""), nil
	case 3:
		return ([]byte)("\"WorkflowExecutionTimedOut\""), nil
	case 4:
		return ([]byte)("\"DecisionTaskScheduled\""), nil
	case 5:
		return ([]byte)("\"DecisionTaskStarted\""), nil
	case 6:
		return ([]byte)("\"DecisionTaskCompleted\""), nil
	case 7:
		return ([]byte)("\"DecisionTaskTimedOut\""), nil
	case 8:
		return ([]byte)("\"DecisionTaskFailed\""), nil
	case 9:
		return ([]byte)("\"ActivityTaskScheduled\""), nil
	case 10:
		return ([]byte)("\"ActivityTaskStarted\""), nil
	case 11:
		return ([]byte)("\"ActivityTaskCompleted\""), nil
	case 12:
		return ([]byte)("\"ActivityTaskFailed\""), nil
	case 13:
		return ([]byte)("\"ActivityTaskTimedOut\""), nil
	case 14:
		return ([]byte)("\"ActivityTaskCancelRequested\""), nil
	case 15:
		return ([]byte)("\"RequestCancelActivityTaskFailed\""), nil
	case 16:
		return ([]byte)("\"ActivityTaskCanceled\""), nil
	case 17:
		return ([]byte)("\"TimerStarted\""), nil
	case 18:
		return ([]byte)("\"TimerFired\""), nil
	case 19:
		return ([]byte)("\"CancelTimerFailed\""), nil
	case 20:
		return ([]byte)("\"TimerCanceled\""), nil
	case 21:
		return ([]byte)("\"WorkflowExecutionCancelRequested\""), nil
	case 22:
		return ([]byte)("\"WorkflowExecutionCanceled\""), nil
	case 23:
		return ([]byte)("\"RequestCancelExternalWorkflowExecutionInitiated\""), nil
	case 24:
		return ([]byte)("\"RequestCancelExternalWorkflowExecutionFailed\""), nil
	case 25:
		return ([]byte)("\"ExternalWorkflowExecutionCancelRequested\""), nil
	case 26:
		return ([]byte)("\"MarkerRecorded\""), nil
	case 27:
		return ([]byte)("\"WorkflowExecutionSignaled\""), nil
	case 28:
		return ([]byte)("\"WorkflowExecutionTerminated\""), nil
	case 29:
		return ([]byte)("\"WorkflowExecutionContinuedAsNew\""), nil
	case 30:
		return ([]byte)("\"StartChildWorkflowExecutionInitiated\""), nil
	case 31:
		return ([]byte)("\"StartChildWorkflowExecutionFailed\""), nil
	case 32:
		return ([]byte)("\"ChildWorkflowExecutionStarted\""), nil
	case 33:
		return ([]byte)("\"ChildWorkflowExecutionCompleted\""), nil
	case 34:
		return ([]byte)("\"ChildWorkflowExecutionFailed\""), nil
	case 35:
		return ([]byte)("\"ChildWorkflowExecutionCanceled\""), nil
	case 36:
		return ([]byte)("\"ChildWorkflowExecutionTimedOut\""), nil
	case 37:
		return ([]byte)("\"ChildWorkflowExecutionTerminated\""), nil
	case 38:
		return ([]byte)("\"SignalExternalWorkflowExecutionInitiated\""), nil
	case 39:
		return ([]byte)("\"SignalExternalWorkflowExecutionFailed\""), nil
	case 40:
		return ([]byte)("\"ExternalWorkflowExecutionSignaled\""), nil
	}
	return ([]byte)(strconv.FormatInt(int64(v), 10)), nil
}

// UnmarshalJSON attempts to decode EventType from its JSON
// representation.
//
// This implementation supports both, numeric and string inputs. If a
// string is provided, it must be a known enum name.
//
// This implements json.Unmarshaler.
func (v *EventType) UnmarshalJSON(text []byte) error {
	d := json.NewDecoder(bytes.NewReader(text))
	d.UseNumber()
	t, err := d.Token()
	if err != nil {
		return err
	}

	switch w := t.(type) {
	case json.Number:
		x, err := w.Int64()
		if err != nil {
			return err
		}
		if x > math.MaxInt32 {
			return fmt.Errorf("enum overflow from JSON %q for %q", text, "EventType")
		}
		if x < math.MinInt32 {
			return fmt.Errorf("enum underflow from JSON %q for %q", text, "EventType")
		}
		*v = (EventType)(x)
		return nil
	case string:
		return v.UnmarshalText([]byte(w))
	default:
		return fmt.Errorf("invalid JSON value %q (%T) to unmarshal into %q", t, t, "EventType")
	}
}

type ExternalWorkflowExecutionCancelRequestedEventAttributes struct {
	InitiatedEventId  *int64             `json:"initiatedEventId,omitempty"`
	Domain            *string            `json:"domain,omitempty"`
	WorkflowExecution *WorkflowExecution `json:"workflowExecution,omitempty"`
}

// ToWire translates a ExternalWorkflowExecutionCancelRequestedEventAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ExternalWorkflowExecutionCancelRequestedEventAttributes) ToWire() (wire.Value, error) {
	var (
		fields [3]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.InitiatedEventId != nil {
		w, err = wire.NewValueI64(*(v.InitiatedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.WorkflowExecution != nil {
		w, err = v.WorkflowExecution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ExternalWorkflowExecutionCancelRequestedEventAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ExternalWorkflowExecutionCancelRequestedEventAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ExternalWorkflowExecutionCancelRequestedEventAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ExternalWorkflowExecutionCancelRequestedEventAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.InitiatedEventId = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ExternalWorkflowExecutionCancelRequestedEventAttributes
// struct.
func (v *ExternalWorkflowExecutionCancelRequestedEventAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [3]string
	i := 0
	if v.InitiatedEventId != nil {
		fields[i] = fmt.Sprintf("InitiatedEventId: %v", *(v.InitiatedEventId))
		i++
	}
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.WorkflowExecution != nil {
		fields[i] = fmt.Sprintf("WorkflowExecution: %v", v.WorkflowExecution)
		i++
	}

	return fmt.Sprintf("ExternalWorkflowExecutionCancelRequestedEventAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ExternalWorkflowExecutionCancelRequestedEventAttributes match the
// provided ExternalWorkflowExecutionCancelRequestedEventAttributes.
//
// This function performs a deep comparison.
func (v *ExternalWorkflowExecutionCancelRequestedEventAttributes) Equals(rhs *ExternalWorkflowExecutionCancelRequestedEventAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_I64_EqualsPtr(v.InitiatedEventId, rhs.InitiatedEventId) {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !((v.WorkflowExecution == nil && rhs.WorkflowExecution == nil) || (v.WorkflowExecution != nil && rhs.WorkflowExecution != nil && v.WorkflowExecution.Equals(rhs.WorkflowExecution))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ExternalWorkflowExecutionCancelRequestedEventAttributes.
func (v *ExternalWorkflowExecutionCancelRequestedEventAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.InitiatedEventId != nil {
		enc.AddInt64("initiatedEventId", *v.InitiatedEventId)
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.WorkflowExecution != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecution", v.WorkflowExecution))
	}
	return err
}

// GetInitiatedEventId returns the value of InitiatedEventId if it is set or its
// zero value if it is unset.
func (v *ExternalWorkflowExecutionCancelRequestedEventAttributes) GetInitiatedEventId() (o int64) {
	if v != nil && v.InitiatedEventId != nil {
		return *v.InitiatedEventId
	}

	return
}

// IsSetInitiatedEventId returns true if InitiatedEventId is not nil.
func (v *ExternalWorkflowExecutionCancelRequestedEventAttributes) IsSetInitiatedEventId() bool {
	return v != nil && v.InitiatedEventId != nil
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *ExternalWorkflowExecutionCancelRequestedEventAttributes) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *ExternalWorkflowExecutionCancelRequestedEventAttributes) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetWorkflowExecution returns the value of WorkflowExecution if it is set or its
// zero value if it is unset.
func (v *ExternalWorkflowExecutionCancelRequestedEventAttributes) GetWorkflowExecution() (o *WorkflowExecution) {
	if v != nil && v.WorkflowExecution != nil {
		return v.WorkflowExecution
	}

	return
}

// IsSetWorkflowExecution returns true if WorkflowExecution is not nil.
func (v *ExternalWorkflowExecutionCancelRequestedEventAttributes) IsSetWorkflowExecution() bool {
	return v != nil && v.WorkflowExecution != nil
}

type ExternalWorkflowExecutionSignaledEventAttributes struct {
	InitiatedEventId  *int64             `json:"initiatedEventId,omitempty"`
	Domain            *string            `json:"domain,omitempty"`
	WorkflowExecution *WorkflowExecution `json:"workflowExecution,omitempty"`
	Control           []byte             `json:"control,omitempty"`
}

// ToWire translates a ExternalWorkflowExecutionSignaledEventAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ExternalWorkflowExecutionSignaledEventAttributes) ToWire() (wire.Value, error) {
	var (
		fields [4]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.InitiatedEventId != nil {
		w, err = wire.NewValueI64(*(v.InitiatedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.WorkflowExecution != nil {
		w, err = v.WorkflowExecution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.Control != nil {
		w, err = wire.NewValueBinary(v.Control), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ExternalWorkflowExecutionSignaledEventAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ExternalWorkflowExecutionSignaledEventAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ExternalWorkflowExecutionSignaledEventAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ExternalWorkflowExecutionSignaledEventAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.InitiatedEventId = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBinary {
				v.Control, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ExternalWorkflowExecutionSignaledEventAttributes
// struct.
func (v *ExternalWorkflowExecutionSignaledEventAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [4]string
	i := 0
	if v.InitiatedEventId != nil {
		fields[i] = fmt.Sprintf("InitiatedEventId: %v", *(v.InitiatedEventId))
		i++
	}
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.WorkflowExecution != nil {
		fields[i] = fmt.Sprintf("WorkflowExecution: %v", v.WorkflowExecution)
		i++
	}
	if v.Control != nil {
		fields[i] = fmt.Sprintf("Control: %v", v.Control)
		i++
	}

	return fmt.Sprintf("ExternalWorkflowExecutionSignaledEventAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ExternalWorkflowExecutionSignaledEventAttributes match the
// provided ExternalWorkflowExecutionSignaledEventAttributes.
//
// This function performs a deep comparison.
func (v *ExternalWorkflowExecutionSignaledEventAttributes) Equals(rhs *ExternalWorkflowExecutionSignaledEventAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_I64_EqualsPtr(v.InitiatedEventId, rhs.InitiatedEventId) {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !((v.WorkflowExecution == nil && rhs.WorkflowExecution == nil) || (v.WorkflowExecution != nil && rhs.WorkflowExecution != nil && v.WorkflowExecution.Equals(rhs.WorkflowExecution))) {
		return false
	}
	if !((v.Control == nil && rhs.Control == nil) || (v.Control != nil && rhs.Control != nil && bytes.Equal(v.Control, rhs.Control))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ExternalWorkflowExecutionSignaledEventAttributes.
func (v *ExternalWorkflowExecutionSignaledEventAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.InitiatedEventId != nil {
		enc.AddInt64("initiatedEventId", *v.InitiatedEventId)
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.WorkflowExecution != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecution", v.WorkflowExecution))
	}
	if v.Control != nil {
		enc.AddString("control", base64.StdEncoding.EncodeToString(v.Control))
	}
	return err
}

// GetInitiatedEventId returns the value of InitiatedEventId if it is set or its
// zero value if it is unset.
func (v *ExternalWorkflowExecutionSignaledEventAttributes) GetInitiatedEventId() (o int64) {
	if v != nil && v.InitiatedEventId != nil {
		return *v.InitiatedEventId
	}

	return
}

// IsSetInitiatedEventId returns true if InitiatedEventId is not nil.
func (v *ExternalWorkflowExecutionSignaledEventAttributes) IsSetInitiatedEventId() bool {
	return v != nil && v.InitiatedEventId != nil
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *ExternalWorkflowExecutionSignaledEventAttributes) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *ExternalWorkflowExecutionSignaledEventAttributes) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetWorkflowExecution returns the value of WorkflowExecution if it is set or its
// zero value if it is unset.
func (v *ExternalWorkflowExecutionSignaledEventAttributes) GetWorkflowExecution() (o *WorkflowExecution) {
	if v != nil && v.WorkflowExecution != nil {
		return v.WorkflowExecution
	}

	return
}

// IsSetWorkflowExecution returns true if WorkflowExecution is not nil.
func (v *ExternalWorkflowExecutionSignaledEventAttributes) IsSetWorkflowExecution() bool {
	return v != nil && v.WorkflowExecution != nil
}

// GetControl returns the value of Control if it is set or its
// zero value if it is unset.
func (v *ExternalWorkflowExecutionSignaledEventAttributes) GetControl() (o []byte) {
	if v != nil && v.Control != nil {
		return v.Control
	}

	return
}

// IsSetControl returns true if Control is not nil.
func (v *ExternalWorkflowExecutionSignaledEventAttributes) IsSetControl() bool {
	return v != nil && v.Control != nil
}

type FailWorkflowExecutionDecisionAttributes struct {
	Reason  *string `json:"reason,omitempty"`
	Details []byte  `json:"details,omitempty"`
}

// ToWire translates a FailWorkflowExecutionDecisionAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *FailWorkflowExecutionDecisionAttributes) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Reason != nil {
		w, err = wire.NewValueString(*(v.Reason)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Details != nil {
		w, err = wire.NewValueBinary(v.Details), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a FailWorkflowExecutionDecisionAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a FailWorkflowExecutionDecisionAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v FailWorkflowExecutionDecisionAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *FailWorkflowExecutionDecisionAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Reason = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				v.Details, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a FailWorkflowExecutionDecisionAttributes
// struct.
func (v *FailWorkflowExecutionDecisionAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.Reason != nil {
		fields[i] = fmt.Sprintf("Reason: %v", *(v.Reason))
		i++
	}
	if v.Details != nil {
		fields[i] = fmt.Sprintf("Details: %v", v.Details)
		i++
	}

	return fmt.Sprintf("FailWorkflowExecutionDecisionAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this FailWorkflowExecutionDecisionAttributes match the
// provided FailWorkflowExecutionDecisionAttributes.
//
// This function performs a deep comparison.
func (v *FailWorkflowExecutionDecisionAttributes) Equals(rhs *FailWorkflowExecutionDecisionAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Reason, rhs.Reason) {
		return false
	}
	if !((v.Details == nil && rhs.Details == nil) || (v.Details != nil && rhs.Details != nil && bytes.Equal(v.Details, rhs.Details))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of FailWorkflowExecutionDecisionAttributes.
func (v *FailWorkflowExecutionDecisionAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Reason != nil {
		enc.AddString("reason", *v.Reason)
	}
	if v.Details != nil {
		enc.AddString("details", base64.StdEncoding.EncodeToString(v.Details))
	}
	return err
}

// GetReason returns the value of Reason if it is set or its
// zero value if it is unset.
func (v *FailWorkflowExecutionDecisionAttributes) GetReason() (o string) {
	if v != nil && v.Reason != nil {
		return *v.Reason
	}

	return
}

// IsSetReason returns true if Reason is not nil.
func (v *FailWorkflowExecutionDecisionAttributes) IsSetReason() bool {
	return v != nil && v.Reason != nil
}

// GetDetails returns the value of Details if it is set or its
// zero value if it is unset.
func (v *FailWorkflowExecutionDecisionAttributes) GetDetails() (o []byte) {
	if v != nil && v.Details != nil {
		return v.Details
	}

	return
}

// IsSetDetails returns true if Details is not nil.
func (v *FailWorkflowExecutionDecisionAttributes) IsSetDetails() bool {
	return v != nil && v.Details != nil
}

type GetWorkflowExecutionHistoryRequest struct {
	Domain                 *string                 `json:"domain,omitempty"`
	Execution              *WorkflowExecution      `json:"execution,omitempty"`
	MaximumPageSize        *int32                  `json:"maximumPageSize,omitempty"`
	NextPageToken          []byte                  `json:"nextPageToken,omitempty"`
	WaitForNewEvent        *bool                   `json:"waitForNewEvent,omitempty"`
	HistoryEventFilterType *HistoryEventFilterType `json:"HistoryEventFilterType,omitempty"`
}

// ToWire translates a GetWorkflowExecutionHistoryRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *GetWorkflowExecutionHistoryRequest) ToWire() (wire.Value, error) {
	var (
		fields [6]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Execution != nil {
		w, err = v.Execution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.MaximumPageSize != nil {
		w, err = wire.NewValueI32(*(v.MaximumPageSize)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.NextPageToken != nil {
		w, err = wire.NewValueBinary(v.NextPageToken), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.WaitForNewEvent != nil {
		w, err = wire.NewValueBool(*(v.WaitForNewEvent)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.HistoryEventFilterType != nil {
		w, err = v.HistoryEventFilterType.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _HistoryEventFilterType_Read(w wire.Value) (HistoryEventFilterType, error) {
	var v HistoryEventFilterType
	err := v.FromWire(w)
	return v, err
}

// FromWire deserializes a GetWorkflowExecutionHistoryRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a GetWorkflowExecutionHistoryRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v GetWorkflowExecutionHistoryRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *GetWorkflowExecutionHistoryRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.Execution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.MaximumPageSize = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBinary {
				v.NextPageToken, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TBool {
				var x bool
				x, err = field.Value.GetBool(), error(nil)
				v.WaitForNewEvent = &x
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TI32 {
				var x HistoryEventFilterType
				x, err = _HistoryEventFilterType_Read(field.Value)
				v.HistoryEventFilterType = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a GetWorkflowExecutionHistoryRequest
// struct.
func (v *GetWorkflowExecutionHistoryRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [6]string
	i := 0
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.Execution != nil {
		fields[i] = fmt.Sprintf("Execution: %v", v.Execution)
		i++
	}
	if v.MaximumPageSize != nil {
		fields[i] = fmt.Sprintf("MaximumPageSize: %v", *(v.MaximumPageSize))
		i++
	}
	if v.NextPageToken != nil {
		fields[i] = fmt.Sprintf("NextPageToken: %v", v.NextPageToken)
		i++
	}
	if v.WaitForNewEvent != nil {
		fields[i] = fmt.Sprintf("WaitForNewEvent: %v", *(v.WaitForNewEvent))
		i++
	}
	if v.HistoryEventFilterType != nil {
		fields[i] = fmt.Sprintf("HistoryEventFilterType: %v", *(v.HistoryEventFilterType))
		i++
	}

	return fmt.Sprintf("GetWorkflowExecutionHistoryRequest{%v}", strings.Join(fields[:i], ", "))
}

func _HistoryEventFilterType_EqualsPtr(lhs, rhs *HistoryEventFilterType) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return x.Equals(y)
	}
	return lhs == nil && rhs == nil
}

// Equals returns true if all the fields of this GetWorkflowExecutionHistoryRequest match the
// provided GetWorkflowExecutionHistoryRequest.
//
// This function performs a deep comparison.
func (v *GetWorkflowExecutionHistoryRequest) Equals(rhs *GetWorkflowExecutionHistoryRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !((v.Execution == nil && rhs.Execution == nil) || (v.Execution != nil && rhs.Execution != nil && v.Execution.Equals(rhs.Execution))) {
		return false
	}
	if !_I32_EqualsPtr(v.MaximumPageSize, rhs.MaximumPageSize) {
		return false
	}
	if !((v.NextPageToken == nil && rhs.NextPageToken == nil) || (v.NextPageToken != nil && rhs.NextPageToken != nil && bytes.Equal(v.NextPageToken, rhs.NextPageToken))) {
		return false
	}
	if !_Bool_EqualsPtr(v.WaitForNewEvent, rhs.WaitForNewEvent) {
		return false
	}
	if !_HistoryEventFilterType_EqualsPtr(v.HistoryEventFilterType, rhs.HistoryEventFilterType) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of GetWorkflowExecutionHistoryRequest.
func (v *GetWorkflowExecutionHistoryRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.Execution != nil {
		err = multierr.Append(err, enc.AddObject("execution", v.Execution))
	}
	if v.MaximumPageSize != nil {
		enc.AddInt32("maximumPageSize", *v.MaximumPageSize)
	}
	if v.NextPageToken != nil {
		enc.AddString("nextPageToken", base64.StdEncoding.EncodeToString(v.NextPageToken))
	}
	if v.WaitForNewEvent != nil {
		enc.AddBool("waitForNewEvent", *v.WaitForNewEvent)
	}
	if v.HistoryEventFilterType != nil {
		err = multierr.Append(err, enc.AddObject("HistoryEventFilterType", *v.HistoryEventFilterType))
	}
	return err
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *GetWorkflowExecutionHistoryRequest) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *GetWorkflowExecutionHistoryRequest) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetExecution returns the value of Execution if it is set or its
// zero value if it is unset.
func (v *GetWorkflowExecutionHistoryRequest) GetExecution() (o *WorkflowExecution) {
	if v != nil && v.Execution != nil {
		return v.Execution
	}

	return
}

// IsSetExecution returns true if Execution is not nil.
func (v *GetWorkflowExecutionHistoryRequest) IsSetExecution() bool {
	return v != nil && v.Execution != nil
}

// GetMaximumPageSize returns the value of MaximumPageSize if it is set or its
// zero value if it is unset.
func (v *GetWorkflowExecutionHistoryRequest) GetMaximumPageSize() (o int32) {
	if v != nil && v.MaximumPageSize != nil {
		return *v.MaximumPageSize
	}

	return
}

// IsSetMaximumPageSize returns true if MaximumPageSize is not nil.
func (v *GetWorkflowExecutionHistoryRequest) IsSetMaximumPageSize() bool {
	return v != nil && v.MaximumPageSize != nil
}

// GetNextPageToken returns the value of NextPageToken if it is set or its
// zero value if it is unset.
func (v *GetWorkflowExecutionHistoryRequest) GetNextPageToken() (o []byte) {
	if v != nil && v.NextPageToken != nil {
		return v.NextPageToken
	}

	return
}

// IsSetNextPageToken returns true if NextPageToken is not nil.
func (v *GetWorkflowExecutionHistoryRequest) IsSetNextPageToken() bool {
	return v != nil && v.NextPageToken != nil
}

// GetWaitForNewEvent returns the value of WaitForNewEvent if it is set or its
// zero value if it is unset.
func (v *GetWorkflowExecutionHistoryRequest) GetWaitForNewEvent() (o bool) {
	if v != nil && v.WaitForNewEvent != nil {
		return *v.WaitForNewEvent
	}

	return
}

// IsSetWaitForNewEvent returns true if WaitForNewEvent is not nil.
func (v *GetWorkflowExecutionHistoryRequest) IsSetWaitForNewEvent() bool {
	return v != nil && v.WaitForNewEvent != nil
}

// GetHistoryEventFilterType returns the value of HistoryEventFilterType if it is set or its
// zero value if it is unset.
func (v *GetWorkflowExecutionHistoryRequest) GetHistoryEventFilterType() (o HistoryEventFilterType) {
	if v != nil && v.HistoryEventFilterType != nil {
		return *v.HistoryEventFilterType
	}

	return
}

// IsSetHistoryEventFilterType returns true if HistoryEventFilterType is not nil.
func (v *GetWorkflowExecutionHistoryRequest) IsSetHistoryEventFilterType() bool {
	return v != nil && v.HistoryEventFilterType != nil
}

type GetWorkflowExecutionHistoryResponse struct {
	History       *History `json:"history,omitempty"`
	NextPageToken []byte   `json:"nextPageToken,omitempty"`
	Archived      *bool    `json:"archived,omitempty"`
}

// ToWire translates a GetWorkflowExecutionHistoryResponse struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *GetWorkflowExecutionHistoryResponse) ToWire() (wire.Value, error) {
	var (
		fields [3]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.History != nil {
		w, err = v.History.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.NextPageToken != nil {
		w, err = wire.NewValueBinary(v.NextPageToken), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.Archived != nil {
		w, err = wire.NewValueBool(*(v.Archived)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _History_Read(w wire.Value) (*History, error) {
	var v History
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a GetWorkflowExecutionHistoryResponse struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a GetWorkflowExecutionHistoryResponse struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v GetWorkflowExecutionHistoryResponse
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *GetWorkflowExecutionHistoryResponse) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TStruct {
				v.History, err = _History_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				v.NextPageToken, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBool {
				var x bool
				x, err = field.Value.GetBool(), error(nil)
				v.Archived = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a GetWorkflowExecutionHistoryResponse
// struct.
func (v *GetWorkflowExecutionHistoryResponse) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [3]string
	i := 0
	if v.History != nil {
		fields[i] = fmt.Sprintf("History: %v", v.History)
		i++
	}
	if v.NextPageToken != nil {
		fields[i] = fmt.Sprintf("NextPageToken: %v", v.NextPageToken)
		i++
	}
	if v.Archived != nil {
		fields[i] = fmt.Sprintf("Archived: %v", *(v.Archived))
		i++
	}

	return fmt.Sprintf("GetWorkflowExecutionHistoryResponse{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this GetWorkflowExecutionHistoryResponse match the
// provided GetWorkflowExecutionHistoryResponse.
//
// This function performs a deep comparison.
func (v *GetWorkflowExecutionHistoryResponse) Equals(rhs *GetWorkflowExecutionHistoryResponse) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.History == nil && rhs.History == nil) || (v.History != nil && rhs.History != nil && v.History.Equals(rhs.History))) {
		return false
	}
	if !((v.NextPageToken == nil && rhs.NextPageToken == nil) || (v.NextPageToken != nil && rhs.NextPageToken != nil && bytes.Equal(v.NextPageToken, rhs.NextPageToken))) {
		return false
	}
	if !_Bool_EqualsPtr(v.Archived, rhs.Archived) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of GetWorkflowExecutionHistoryResponse.
func (v *GetWorkflowExecutionHistoryResponse) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.History != nil {
		err = multierr.Append(err, enc.AddObject("history", v.History))
	}
	if v.NextPageToken != nil {
		enc.AddString("nextPageToken", base64.StdEncoding.EncodeToString(v.NextPageToken))
	}
	if v.Archived != nil {
		enc.AddBool("archived", *v.Archived)
	}
	return err
}

// GetHistory returns the value of History if it is set or its
// zero value if it is unset.
func (v *GetWorkflowExecutionHistoryResponse) GetHistory() (o *History) {
	if v != nil && v.History != nil {
		return v.History
	}

	return
}

// IsSetHistory returns true if History is not nil.
func (v *GetWorkflowExecutionHistoryResponse) IsSetHistory() bool {
	return v != nil && v.History != nil
}

// GetNextPageToken returns the value of NextPageToken if it is set or its
// zero value if it is unset.
func (v *GetWorkflowExecutionHistoryResponse) GetNextPageToken() (o []byte) {
	if v != nil && v.NextPageToken != nil {
		return v.NextPageToken
	}

	return
}

// IsSetNextPageToken returns true if NextPageToken is not nil.
func (v *GetWorkflowExecutionHistoryResponse) IsSetNextPageToken() bool {
	return v != nil && v.NextPageToken != nil
}

// GetArchived returns the value of Archived if it is set or its
// zero value if it is unset.
func (v *GetWorkflowExecutionHistoryResponse) GetArchived() (o bool) {
	if v != nil && v.Archived != nil {
		return *v.Archived
	}

	return
}

// IsSetArchived returns true if Archived is not nil.
func (v *GetWorkflowExecutionHistoryResponse) IsSetArchived() bool {
	return v != nil && v.Archived != nil
}

type Header struct {
	Fields map[string][]byte `json:"fields,omitempty"`
}

type _Map_String_Binary_MapItemList map[string][]byte

func (m _Map_String_Binary_MapItemList) ForEach(f func(wire.MapItem) error) error {
	for k, v := range m {
		if v == nil {
			return fmt.Errorf("invalid [%v]: value is nil", k)
		}
		kw, err := wire.NewValueString(k), error(nil)
		if err != nil {
			return err
		}

		vw, err := wire.NewValueBinary(v), error(nil)
		if err != nil {
			return err
		}
		err = f(wire.MapItem{Key: kw, Value: vw})
		if err != nil {
			return err
		}
	}
	return nil
}

func (m _Map_String_Binary_MapItemList) Size() int {
	return len(m)
}

func (_Map_String_Binary_MapItemList) KeyType() wire.Type {
	return wire.TBinary
}

func (_Map_String_Binary_MapItemList) ValueType() wire.Type {
	return wire.TBinary
}

func (_Map_String_Binary_MapItemList) Close() {}

// ToWire translates a Header struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *Header) ToWire() (wire.Value, error) {
	var (
		fields [1]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Fields != nil {
		w, err = wire.NewValueMap(_Map_String_Binary_MapItemList(v.Fields)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _Map_String_Binary_Read(m wire.MapItemList) (map[string][]byte, error) {
	if m.KeyType() != wire.TBinary {
		return nil, nil
	}

	if m.ValueType() != wire.TBinary {
		return nil, nil
	}

	o := make(map[string][]byte, m.Size())
	err := m.ForEach(func(x wire.MapItem) error {
		k, err := x.Key.GetString(), error(nil)
		if err != nil {
			return err
		}

		v, err := x.Value.GetBinary(), error(nil)
		if err != nil {
			return err
		}

		o[k] = v
		return nil
	})
	m.Close()
	return o, err
}

// FromWire deserializes a Header struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a Header struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v Header
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *Header) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TMap {
				v.Fields, err = _Map_String_Binary_Read(field.Value.GetMap())
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a Header
// struct.
func (v *Header) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [1]string
	i := 0
	if v.Fields != nil {
		fields[i] = fmt.Sprintf("Fields: %v", v.Fields)
		i++
	}

	return fmt.Sprintf("Header{%v}", strings.Join(fields[:i], ", "))
}

func _Map_String_Binary_Equals(lhs, rhs map[string][]byte) bool {
	if len(lhs) != len(rhs) {
		return false
	}

	for lk, lv := range lhs {
		rv, ok := rhs[lk]
		if !ok {
			return false
		}
		if !bytes.Equal(lv, rv) {
			return false
		}
	}
	return true
}

// Equals returns true if all the fields of this Header match the
// provided Header.
//
// This function performs a deep comparison.
func (v *Header) Equals(rhs *Header) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.Fields == nil && rhs.Fields == nil) || (v.Fields != nil && rhs.Fields != nil && _Map_String_Binary_Equals(v.Fields, rhs.Fields))) {
		return false
	}

	return true
}

type _Map_String_Binary_Zapper map[string][]byte

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of _Map_String_Binary_Zapper.
func (m _Map_String_Binary_Zapper) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	for k, v := range m {
		enc.AddString((string)(k), base64.StdEncoding.EncodeToString(v))
	}
	return err
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of Header.
func (v *Header) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Fields != nil {
		err = multierr.Append(err, enc.AddObject("fields", (_Map_String_Binary_Zapper)(v.Fields)))
	}
	return err
}

// GetFields returns the value of Fields if it is set or its
// zero value if it is unset.
func (v *Header) GetFields() (o map[string][]byte) {
	if v != nil && v.Fields != nil {
		return v.Fields
	}

	return
}

// IsSetFields returns true if Fields is not nil.
func (v *Header) IsSetFields() bool {
	return v != nil && v.Fields != nil
}

type History struct {
	Events []*HistoryEvent `json:"events,omitempty"`
}

type _List_HistoryEvent_ValueList []*HistoryEvent

func (v _List_HistoryEvent_ValueList) ForEach(f func(wire.Value) error) error {
	for i, x := range v {
		if x == nil {
			return fmt.Errorf("invalid [%v]: value is nil", i)
		}
		w, err := x.ToWire()
		if err != nil {
			return err
		}
		err = f(w)
		if err != nil {
			return err
		}
	}
	return nil
}

func (v _List_HistoryEvent_ValueList) Size() int {
	return len(v)
}

func (_List_HistoryEvent_ValueList) ValueType() wire.Type {
	return wire.TStruct
}

func (_List_HistoryEvent_ValueList) Close() {}

// ToWire translates a History struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *History) ToWire() (wire.Value, error) {
	var (
		fields [1]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Events != nil {
		w, err = wire.NewValueList(_List_HistoryEvent_ValueList(v.Events)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _HistoryEvent_Read(w wire.Value) (*HistoryEvent, error) {
	var v HistoryEvent
	err := v.FromWire(w)
	return &v, err
}

func _List_HistoryEvent_Read(l wire.ValueList) ([]*HistoryEvent, error) {
	if l.ValueType() != wire.TStruct {
		return nil, nil
	}

	o := make([]*HistoryEvent, 0, l.Size())
	err := l.ForEach(func(x wire.Value) error {
		i, err := _HistoryEvent_Read(x)
		if err != nil {
			return err
		}
		o = append(o, i)
		return nil
	})
	l.Close()
	return o, err
}

// FromWire deserializes a History struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a History struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v History
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *History) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TList {
				v.Events, err = _List_HistoryEvent_Read(field.Value.GetList())
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a History
// struct.
func (v *History) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [1]string
	i := 0
	if v.Events != nil {
		fields[i] = fmt.Sprintf("Events: %v", v.Events)
		i++
	}

	return fmt.Sprintf("History{%v}", strings.Join(fields[:i], ", "))
}

func _List_HistoryEvent_Equals(lhs, rhs []*HistoryEvent) bool {
	if len(lhs) != len(rhs) {
		return false
	}

	for i, lv := range lhs {
		rv := rhs[i]
		if !lv.Equals(rv) {
			return false
		}
	}

	return true
}

// Equals returns true if all the fields of this History match the
// provided History.
//
// This function performs a deep comparison.
func (v *History) Equals(rhs *History) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.Events == nil && rhs.Events == nil) || (v.Events != nil && rhs.Events != nil && _List_HistoryEvent_Equals(v.Events, rhs.Events))) {
		return false
	}

	return true
}

type _List_HistoryEvent_Zapper []*HistoryEvent

// MarshalLogArray implements zapcore.ArrayMarshaler, enabling
// fast logging of _List_HistoryEvent_Zapper.
func (l _List_HistoryEvent_Zapper) MarshalLogArray(enc zapcore.ArrayEncoder) (err error) {
	for _, v := range l {
		err = multierr.Append(err, enc.AppendObject(v))
	}
	return err
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of History.
func (v *History) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Events != nil {
		err = multierr.Append(err, enc.AddArray("events", (_List_HistoryEvent_Zapper)(v.Events)))
	}
	return err
}

// GetEvents returns the value of Events if it is set or its
// zero value if it is unset.
func (v *History) GetEvents() (o []*HistoryEvent) {
	if v != nil && v.Events != nil {
		return v.Events
	}

	return
}

// IsSetEvents returns true if Events is not nil.
func (v *History) IsSetEvents() bool {
	return v != nil && v.Events != nil
}

type HistoryBranch struct {
	TreeID    *string               `json:"treeID,omitempty"`
	BranchID  *string               `json:"branchID,omitempty"`
	Ancestors []*HistoryBranchRange `json:"ancestors,omitempty"`
}

type _List_HistoryBranchRange_ValueList []*HistoryBranchRange

func (v _List_HistoryBranchRange_ValueList) ForEach(f func(wire.Value) error) error {
	for i, x := range v {
		if x == nil {
			return fmt.Errorf("invalid [%v]: value is nil", i)
		}
		w, err := x.ToWire()
		if err != nil {
			return err
		}
		err = f(w)
		if err != nil {
			return err
		}
	}
	return nil
}

func (v _List_HistoryBranchRange_ValueList) Size() int {
	return len(v)
}

func (_List_HistoryBranchRange_ValueList) ValueType() wire.Type {
	return wire.TStruct
}

func (_List_HistoryBranchRange_ValueList) Close() {}

// ToWire translates a HistoryBranch struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *HistoryBranch) ToWire() (wire.Value, error) {
	var (
		fields [3]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.TreeID != nil {
		w, err = wire.NewValueString(*(v.TreeID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.BranchID != nil {
		w, err = wire.NewValueString(*(v.BranchID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.Ancestors != nil {
		w, err = wire.NewValueList(_List_HistoryBranchRange_ValueList(v.Ancestors)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _HistoryBranchRange_Read(w wire.Value) (*HistoryBranchRange, error) {
	var v HistoryBranchRange
	err := v.FromWire(w)
	return &v, err
}

func _List_HistoryBranchRange_Read(l wire.ValueList) ([]*HistoryBranchRange, error) {
	if l.ValueType() != wire.TStruct {
		return nil, nil
	}

	o := make([]*HistoryBranchRange, 0, l.Size())
	err := l.ForEach(func(x wire.Value) error {
		i, err := _HistoryBranchRange_Read(x)
		if err != nil {
			return err
		}
		o = append(o, i)
		return nil
	})
	l.Close()
	return o, err
}

// FromWire deserializes a HistoryBranch struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a HistoryBranch struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v HistoryBranch
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *HistoryBranch) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.TreeID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.BranchID = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TList {
				v.Ancestors, err = _List_HistoryBranchRange_Read(field.Value.GetList())
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a HistoryBranch
// struct.
func (v *HistoryBranch) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [3]string
	i := 0
	if v.TreeID != nil {
		fields[i] = fmt.Sprintf("TreeID: %v", *(v.TreeID))
		i++
	}
	if v.BranchID != nil {
		fields[i] = fmt.Sprintf("BranchID: %v", *(v.BranchID))
		i++
	}
	if v.Ancestors != nil {
		fields[i] = fmt.Sprintf("Ancestors: %v", v.Ancestors)
		i++
	}

	return fmt.Sprintf("HistoryBranch{%v}", strings.Join(fields[:i], ", "))
}

func _List_HistoryBranchRange_Equals(lhs, rhs []*HistoryBranchRange) bool {
	if len(lhs) != len(rhs) {
		return false
	}

	for i, lv := range lhs {
		rv := rhs[i]
		if !lv.Equals(rv) {
			return false
		}
	}

	return true
}

// Equals returns true if all the fields of this HistoryBranch match the
// provided HistoryBranch.
//
// This function performs a deep comparison.
func (v *HistoryBranch) Equals(rhs *HistoryBranch) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.TreeID, rhs.TreeID) {
		return false
	}
	if !_String_EqualsPtr(v.BranchID, rhs.BranchID) {
		return false
	}
	if !((v.Ancestors == nil && rhs.Ancestors == nil) || (v.Ancestors != nil && rhs.Ancestors != nil && _List_HistoryBranchRange_Equals(v.Ancestors, rhs.Ancestors))) {
		return false
	}

	return true
}

type _List_HistoryBranchRange_Zapper []*HistoryBranchRange

// MarshalLogArray implements zapcore.ArrayMarshaler, enabling
// fast logging of _List_HistoryBranchRange_Zapper.
func (l _List_HistoryBranchRange_Zapper) MarshalLogArray(enc zapcore.ArrayEncoder) (err error) {
	for _, v := range l {
		err = multierr.Append(err, enc.AppendObject(v))
	}
	return err
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of HistoryBranch.
func (v *HistoryBranch) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.TreeID != nil {
		enc.AddString("treeID", *v.TreeID)
	}
	if v.BranchID != nil {
		enc.AddString("branchID", *v.BranchID)
	}
	if v.Ancestors != nil {
		err = multierr.Append(err, enc.AddArray("ancestors", (_List_HistoryBranchRange_Zapper)(v.Ancestors)))
	}
	return err
}

// GetTreeID returns the value of TreeID if it is set or its
// zero value if it is unset.
func (v *HistoryBranch) GetTreeID() (o string) {
	if v != nil && v.TreeID != nil {
		return *v.TreeID
	}

	return
}

// IsSetTreeID returns true if TreeID is not nil.
func (v *HistoryBranch) IsSetTreeID() bool {
	return v != nil && v.TreeID != nil
}

// GetBranchID returns the value of BranchID if it is set or its
// zero value if it is unset.
func (v *HistoryBranch) GetBranchID() (o string) {
	if v != nil && v.BranchID != nil {
		return *v.BranchID
	}

	return
}

// IsSetBranchID returns true if BranchID is not nil.
func (v *HistoryBranch) IsSetBranchID() bool {
	return v != nil && v.BranchID != nil
}

// GetAncestors returns the value of Ancestors if it is set or its
// zero value if it is unset.
func (v *HistoryBranch) GetAncestors() (o []*HistoryBranchRange) {
	if v != nil && v.Ancestors != nil {
		return v.Ancestors
	}

	return
}

// IsSetAncestors returns true if Ancestors is not nil.
func (v *HistoryBranch) IsSetAncestors() bool {
	return v != nil && v.Ancestors != nil
}

type HistoryBranchRange struct {
	BranchID    *string `json:"branchID,omitempty"`
	BeginNodeID *int64  `json:"beginNodeID,omitempty"`
	EndNodeID   *int64  `json:"endNodeID,omitempty"`
}

// ToWire translates a HistoryBranchRange struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *HistoryBranchRange) ToWire() (wire.Value, error) {
	var (
		fields [3]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.BranchID != nil {
		w, err = wire.NewValueString(*(v.BranchID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.BeginNodeID != nil {
		w, err = wire.NewValueI64(*(v.BeginNodeID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.EndNodeID != nil {
		w, err = wire.NewValueI64(*(v.EndNodeID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a HistoryBranchRange struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a HistoryBranchRange struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v HistoryBranchRange
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *HistoryBranchRange) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.BranchID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.BeginNodeID = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.EndNodeID = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a HistoryBranchRange
// struct.
func (v *HistoryBranchRange) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [3]string
	i := 0
	if v.BranchID != nil {
		fields[i] = fmt.Sprintf("BranchID: %v", *(v.BranchID))
		i++
	}
	if v.BeginNodeID != nil {
		fields[i] = fmt.Sprintf("BeginNodeID: %v", *(v.BeginNodeID))
		i++
	}
	if v.EndNodeID != nil {
		fields[i] = fmt.Sprintf("EndNodeID: %v", *(v.EndNodeID))
		i++
	}

	return fmt.Sprintf("HistoryBranchRange{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this HistoryBranchRange match the
// provided HistoryBranchRange.
//
// This function performs a deep comparison.
func (v *HistoryBranchRange) Equals(rhs *HistoryBranchRange) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.BranchID, rhs.BranchID) {
		return false
	}
	if !_I64_EqualsPtr(v.BeginNodeID, rhs.BeginNodeID) {
		return false
	}
	if !_I64_EqualsPtr(v.EndNodeID, rhs.EndNodeID) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of HistoryBranchRange.
func (v *HistoryBranchRange) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.BranchID != nil {
		enc.AddString("branchID", *v.BranchID)
	}
	if v.BeginNodeID != nil {
		enc.AddInt64("beginNodeID", *v.BeginNodeID)
	}
	if v.EndNodeID != nil {
		enc.AddInt64("endNodeID", *v.EndNodeID)
	}
	return err
}

// GetBranchID returns the value of BranchID if it is set or its
// zero value if it is unset.
func (v *HistoryBranchRange) GetBranchID() (o string) {
	if v != nil && v.BranchID != nil {
		return *v.BranchID
	}

	return
}

// IsSetBranchID returns true if BranchID is not nil.
func (v *HistoryBranchRange) IsSetBranchID() bool {
	return v != nil && v.BranchID != nil
}

// GetBeginNodeID returns the value of BeginNodeID if it is set or its
// zero value if it is unset.
func (v *HistoryBranchRange) GetBeginNodeID() (o int64) {
	if v != nil && v.BeginNodeID != nil {
		return *v.BeginNodeID
	}

	return
}

// IsSetBeginNodeID returns true if BeginNodeID is not nil.
func (v *HistoryBranchRange) IsSetBeginNodeID() bool {
	return v != nil && v.BeginNodeID != nil
}

// GetEndNodeID returns the value of EndNodeID if it is set or its
// zero value if it is unset.
func (v *HistoryBranchRange) GetEndNodeID() (o int64) {
	if v != nil && v.EndNodeID != nil {
		return *v.EndNodeID
	}

	return
}

// IsSetEndNodeID returns true if EndNodeID is not nil.
func (v *HistoryBranchRange) IsSetEndNodeID() bool {
	return v != nil && v.EndNodeID != nil
}

type HistoryEvent struct {
	EventId                                                        *int64                                                          `json:"eventId,omitempty"`
	Timestamp                                                      *int64                                                          `json:"timestamp,omitempty"`
	EventType                                                      *EventType                                                      `json:"eventType,omitempty"`
	Version                                                        *int64                                                          `json:"version,omitempty"`
	TaskId                                                         *int64                                                          `json:"taskId,omitempty"`
	WorkflowExecutionStartedEventAttributes                        *WorkflowExecutionStartedEventAttributes                        `json:"workflowExecutionStartedEventAttributes,omitempty"`
	WorkflowExecutionCompletedEventAttributes                      *WorkflowExecutionCompletedEventAttributes                      `json:"workflowExecutionCompletedEventAttributes,omitempty"`
	WorkflowExecutionFailedEventAttributes                         *WorkflowExecutionFailedEventAttributes                         `json:"workflowExecutionFailedEventAttributes,omitempty"`
	WorkflowExecutionTimedOutEventAttributes                       *WorkflowExecutionTimedOutEventAttributes                       `json:"workflowExecutionTimedOutEventAttributes,omitempty"`
	DecisionTaskScheduledEventAttributes                           *DecisionTaskScheduledEventAttributes                           `json:"decisionTaskScheduledEventAttributes,omitempty"`
	DecisionTaskStartedEventAttributes                             *DecisionTaskStartedEventAttributes                             `json:"decisionTaskStartedEventAttributes,omitempty"`
	DecisionTaskCompletedEventAttributes                           *DecisionTaskCompletedEventAttributes                           `json:"decisionTaskCompletedEventAttributes,omitempty"`
	DecisionTaskTimedOutEventAttributes                            *DecisionTaskTimedOutEventAttributes                            `json:"decisionTaskTimedOutEventAttributes,omitempty"`
	DecisionTaskFailedEventAttributes                              *DecisionTaskFailedEventAttributes                              `json:"decisionTaskFailedEventAttributes,omitempty"`
	ActivityTaskScheduledEventAttributes                           *ActivityTaskScheduledEventAttributes                           `json:"activityTaskScheduledEventAttributes,omitempty"`
	ActivityTaskStartedEventAttributes                             *ActivityTaskStartedEventAttributes                             `json:"activityTaskStartedEventAttributes,omitempty"`
	ActivityTaskCompletedEventAttributes                           *ActivityTaskCompletedEventAttributes                           `json:"activityTaskCompletedEventAttributes,omitempty"`
	ActivityTaskFailedEventAttributes                              *ActivityTaskFailedEventAttributes                              `json:"activityTaskFailedEventAttributes,omitempty"`
	ActivityTaskTimedOutEventAttributes                            *ActivityTaskTimedOutEventAttributes                            `json:"activityTaskTimedOutEventAttributes,omitempty"`
	TimerStartedEventAttributes                                    *TimerStartedEventAttributes                                    `json:"timerStartedEventAttributes,omitempty"`
	TimerFiredEventAttributes                                      *TimerFiredEventAttributes                                      `json:"timerFiredEventAttributes,omitempty"`
	ActivityTaskCancelRequestedEventAttributes                     *ActivityTaskCancelRequestedEventAttributes                     `json:"activityTaskCancelRequestedEventAttributes,omitempty"`
	RequestCancelActivityTaskFailedEventAttributes                 *RequestCancelActivityTaskFailedEventAttributes                 `json:"requestCancelActivityTaskFailedEventAttributes,omitempty"`
	ActivityTaskCanceledEventAttributes                            *ActivityTaskCanceledEventAttributes                            `json:"activityTaskCanceledEventAttributes,omitempty"`
	TimerCanceledEventAttributes                                   *TimerCanceledEventAttributes                                   `json:"timerCanceledEventAttributes,omitempty"`
	CancelTimerFailedEventAttributes                               *CancelTimerFailedEventAttributes                               `json:"cancelTimerFailedEventAttributes,omitempty"`
	MarkerRecordedEventAttributes                                  *MarkerRecordedEventAttributes                                  `json:"markerRecordedEventAttributes,omitempty"`
	WorkflowExecutionSignaledEventAttributes                       *WorkflowExecutionSignaledEventAttributes                       `json:"workflowExecutionSignaledEventAttributes,omitempty"`
	WorkflowExecutionTerminatedEventAttributes                     *WorkflowExecutionTerminatedEventAttributes                     `json:"workflowExecutionTerminatedEventAttributes,omitempty"`
	WorkflowExecutionCancelRequestedEventAttributes                *WorkflowExecutionCancelRequestedEventAttributes                `json:"workflowExecutionCancelRequestedEventAttributes,omitempty"`
	WorkflowExecutionCanceledEventAttributes                       *WorkflowExecutionCanceledEventAttributes                       `json:"workflowExecutionCanceledEventAttributes,omitempty"`
	RequestCancelExternalWorkflowExecutionInitiatedEventAttributes *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes `json:"requestCancelExternalWorkflowExecutionInitiatedEventAttributes,omitempty"`
	RequestCancelExternalWorkflowExecutionFailedEventAttributes    *RequestCancelExternalWorkflowExecutionFailedEventAttributes    `json:"requestCancelExternalWorkflowExecutionFailedEventAttributes,omitempty"`
	ExternalWorkflowExecutionCancelRequestedEventAttributes        *ExternalWorkflowExecutionCancelRequestedEventAttributes        `json:"externalWorkflowExecutionCancelRequestedEventAttributes,omitempty"`
	WorkflowExecutionContinuedAsNewEventAttributes                 *WorkflowExecutionContinuedAsNewEventAttributes                 `json:"workflowExecutionContinuedAsNewEventAttributes,omitempty"`
	StartChildWorkflowExecutionInitiatedEventAttributes            *StartChildWorkflowExecutionInitiatedEventAttributes            `json:"startChildWorkflowExecutionInitiatedEventAttributes,omitempty"`
	StartChildWorkflowExecutionFailedEventAttributes               *StartChildWorkflowExecutionFailedEventAttributes               `json:"startChildWorkflowExecutionFailedEventAttributes,omitempty"`
	ChildWorkflowExecutionStartedEventAttributes                   *ChildWorkflowExecutionStartedEventAttributes                   `json:"childWorkflowExecutionStartedEventAttributes,omitempty"`
	ChildWorkflowExecutionCompletedEventAttributes                 *ChildWorkflowExecutionCompletedEventAttributes                 `json:"childWorkflowExecutionCompletedEventAttributes,omitempty"`
	ChildWorkflowExecutionFailedEventAttributes                    *ChildWorkflowExecutionFailedEventAttributes                    `json:"childWorkflowExecutionFailedEventAttributes,omitempty"`
	ChildWorkflowExecutionCanceledEventAttributes                  *ChildWorkflowExecutionCanceledEventAttributes                  `json:"childWorkflowExecutionCanceledEventAttributes,omitempty"`
	ChildWorkflowExecutionTimedOutEventAttributes                  *ChildWorkflowExecutionTimedOutEventAttributes                  `json:"childWorkflowExecutionTimedOutEventAttributes,omitempty"`
	ChildWorkflowExecutionTerminatedEventAttributes                *ChildWorkflowExecutionTerminatedEventAttributes                `json:"childWorkflowExecutionTerminatedEventAttributes,omitempty"`
	SignalExternalWorkflowExecutionInitiatedEventAttributes        *SignalExternalWorkflowExecutionInitiatedEventAttributes        `json:"signalExternalWorkflowExecutionInitiatedEventAttributes,omitempty"`
	SignalExternalWorkflowExecutionFailedEventAttributes           *SignalExternalWorkflowExecutionFailedEventAttributes           `json:"signalExternalWorkflowExecutionFailedEventAttributes,omitempty"`
	ExternalWorkflowExecutionSignaledEventAttributes               *ExternalWorkflowExecutionSignaledEventAttributes               `json:"externalWorkflowExecutionSignaledEventAttributes,omitempty"`
}

// ToWire translates a HistoryEvent struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *HistoryEvent) ToWire() (wire.Value, error) {
	var (
		fields [46]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.EventId != nil {
		w, err = wire.NewValueI64(*(v.EventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Timestamp != nil {
		w, err = wire.NewValueI64(*(v.Timestamp)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.EventType != nil {
		w, err = v.EventType.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.Version != nil {
		w, err = wire.NewValueI64(*(v.Version)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 35, Value: w}
		i++
	}
	if v.TaskId != nil {
		w, err = wire.NewValueI64(*(v.TaskId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 36, Value: w}
		i++
	}
	if v.WorkflowExecutionStartedEventAttributes != nil {
		w, err = v.WorkflowExecutionStartedEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.WorkflowExecutionCompletedEventAttributes != nil {
		w, err = v.WorkflowExecutionCompletedEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.WorkflowExecutionFailedEventAttributes != nil {
		w, err = v.WorkflowExecutionFailedEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}
	if v.WorkflowExecutionTimedOutEventAttributes != nil {
		w, err = v.WorkflowExecutionTimedOutEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 70, Value: w}
		i++
	}
	if v.DecisionTaskScheduledEventAttributes != nil {
		w, err = v.DecisionTaskScheduledEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 80, Value: w}
		i++
	}
	if v.DecisionTaskStartedEventAttributes != nil {
		w, err = v.DecisionTaskStartedEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 90, Value: w}
		i++
	}
	if v.DecisionTaskCompletedEventAttributes != nil {
		w, err = v.DecisionTaskCompletedEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 100, Value: w}
		i++
	}
	if v.DecisionTaskTimedOutEventAttributes != nil {
		w, err = v.DecisionTaskTimedOutEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 110, Value: w}
		i++
	}
	if v.DecisionTaskFailedEventAttributes != nil {
		w, err = v.DecisionTaskFailedEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 120, Value: w}
		i++
	}
	if v.ActivityTaskScheduledEventAttributes != nil {
		w, err = v.ActivityTaskScheduledEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 130, Value: w}
		i++
	}
	if v.ActivityTaskStartedEventAttributes != nil {
		w, err = v.ActivityTaskStartedEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 140, Value: w}
		i++
	}
	if v.ActivityTaskCompletedEventAttributes != nil {
		w, err = v.ActivityTaskCompletedEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 150, Value: w}
		i++
	}
	if v.ActivityTaskFailedEventAttributes != nil {
		w, err = v.ActivityTaskFailedEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 160, Value: w}
		i++
	}
	if v.ActivityTaskTimedOutEventAttributes != nil {
		w, err = v.ActivityTaskTimedOutEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 170, Value: w}
		i++
	}
	if v.TimerStartedEventAttributes != nil {
		w, err = v.TimerStartedEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 180, Value: w}
		i++
	}
	if v.TimerFiredEventAttributes != nil {
		w, err = v.TimerFiredEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 190, Value: w}
		i++
	}
	if v.ActivityTaskCancelRequestedEventAttributes != nil {
		w, err = v.ActivityTaskCancelRequestedEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 200, Value: w}
		i++
	}
	if v.RequestCancelActivityTaskFailedEventAttributes != nil {
		w, err = v.RequestCancelActivityTaskFailedEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 210, Value: w}
		i++
	}
	if v.ActivityTaskCanceledEventAttributes != nil {
		w, err = v.ActivityTaskCanceledEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 220, Value: w}
		i++
	}
	if v.TimerCanceledEventAttributes != nil {
		w, err = v.TimerCanceledEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 230, Value: w}
		i++
	}
	if v.CancelTimerFailedEventAttributes != nil {
		w, err = v.CancelTimerFailedEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 240, Value: w}
		i++
	}
	if v.MarkerRecordedEventAttributes != nil {
		w, err = v.MarkerRecordedEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 250, Value: w}
		i++
	}
	if v.WorkflowExecutionSignaledEventAttributes != nil {
		w, err = v.WorkflowExecutionSignaledEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 260, Value: w}
		i++
	}
	if v.WorkflowExecutionTerminatedEventAttributes != nil {
		w, err = v.WorkflowExecutionTerminatedEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 270, Value: w}
		i++
	}
	if v.WorkflowExecutionCancelRequestedEventAttributes != nil {
		w, err = v.WorkflowExecutionCancelRequestedEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 280, Value: w}
		i++
	}
	if v.WorkflowExecutionCanceledEventAttributes != nil {
		w, err = v.WorkflowExecutionCanceledEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 290, Value: w}
		i++
	}
	if v.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes != nil {
		w, err = v.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 300, Value: w}
		i++
	}
	if v.RequestCancelExternalWorkflowExecutionFailedEventAttributes != nil {
		w, err = v.RequestCancelExternalWorkflowExecutionFailedEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 310, Value: w}
		i++
	}
	if v.ExternalWorkflowExecutionCancelRequestedEventAttributes != nil {
		w, err = v.ExternalWorkflowExecutionCancelRequestedEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 320, Value: w}
		i++
	}
	if v.WorkflowExecutionContinuedAsNewEventAttributes != nil {
		w, err = v.WorkflowExecutionContinuedAsNewEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 330, Value: w}
		i++
	}
	if v.StartChildWorkflowExecutionInitiatedEventAttributes != nil {
		w, err = v.StartChildWorkflowExecutionInitiatedEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 340, Value: w}
		i++
	}
	if v.StartChildWorkflowExecutionFailedEventAttributes != nil {
		w, err = v.StartChildWorkflowExecutionFailedEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 350, Value: w}
		i++
	}
	if v.ChildWorkflowExecutionStartedEventAttributes != nil {
		w, err = v.ChildWorkflowExecutionStartedEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 360, Value: w}
		i++
	}
	if v.ChildWorkflowExecutionCompletedEventAttributes != nil {
		w, err = v.ChildWorkflowExecutionCompletedEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 370, Value: w}
		i++
	}
	if v.ChildWorkflowExecutionFailedEventAttributes != nil {
		w, err = v.ChildWorkflowExecutionFailedEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 380, Value: w}
		i++
	}
	if v.ChildWorkflowExecutionCanceledEventAttributes != nil {
		w, err = v.ChildWorkflowExecutionCanceledEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 390, Value: w}
		i++
	}
	if v.ChildWorkflowExecutionTimedOutEventAttributes != nil {
		w, err = v.ChildWorkflowExecutionTimedOutEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 400, Value: w}
		i++
	}
	if v.ChildWorkflowExecutionTerminatedEventAttributes != nil {
		w, err = v.ChildWorkflowExecutionTerminatedEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 410, Value: w}
		i++
	}
	if v.SignalExternalWorkflowExecutionInitiatedEventAttributes != nil {
		w, err = v.SignalExternalWorkflowExecutionInitiatedEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 420, Value: w}
		i++
	}
	if v.SignalExternalWorkflowExecutionFailedEventAttributes != nil {
		w, err = v.SignalExternalWorkflowExecutionFailedEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 430, Value: w}
		i++
	}
	if v.ExternalWorkflowExecutionSignaledEventAttributes != nil {
		w, err = v.ExternalWorkflowExecutionSignaledEventAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 440, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _EventType_Read(w wire.Value) (EventType, error) {
	var v EventType
	err := v.FromWire(w)
	return v, err
}

func _WorkflowExecutionStartedEventAttributes_Read(w wire.Value) (*WorkflowExecutionStartedEventAttributes, error) {
	var v WorkflowExecutionStartedEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _WorkflowExecutionCompletedEventAttributes_Read(w wire.Value) (*WorkflowExecutionCompletedEventAttributes, error) {
	var v WorkflowExecutionCompletedEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _WorkflowExecutionFailedEventAttributes_Read(w wire.Value) (*WorkflowExecutionFailedEventAttributes, error) {
	var v WorkflowExecutionFailedEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _WorkflowExecutionTimedOutEventAttributes_Read(w wire.Value) (*WorkflowExecutionTimedOutEventAttributes, error) {
	var v WorkflowExecutionTimedOutEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _DecisionTaskScheduledEventAttributes_Read(w wire.Value) (*DecisionTaskScheduledEventAttributes, error) {
	var v DecisionTaskScheduledEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _DecisionTaskStartedEventAttributes_Read(w wire.Value) (*DecisionTaskStartedEventAttributes, error) {
	var v DecisionTaskStartedEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _DecisionTaskCompletedEventAttributes_Read(w wire.Value) (*DecisionTaskCompletedEventAttributes, error) {
	var v DecisionTaskCompletedEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _DecisionTaskTimedOutEventAttributes_Read(w wire.Value) (*DecisionTaskTimedOutEventAttributes, error) {
	var v DecisionTaskTimedOutEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _DecisionTaskFailedEventAttributes_Read(w wire.Value) (*DecisionTaskFailedEventAttributes, error) {
	var v DecisionTaskFailedEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _ActivityTaskScheduledEventAttributes_Read(w wire.Value) (*ActivityTaskScheduledEventAttributes, error) {
	var v ActivityTaskScheduledEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _ActivityTaskStartedEventAttributes_Read(w wire.Value) (*ActivityTaskStartedEventAttributes, error) {
	var v ActivityTaskStartedEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _ActivityTaskCompletedEventAttributes_Read(w wire.Value) (*ActivityTaskCompletedEventAttributes, error) {
	var v ActivityTaskCompletedEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _ActivityTaskFailedEventAttributes_Read(w wire.Value) (*ActivityTaskFailedEventAttributes, error) {
	var v ActivityTaskFailedEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _ActivityTaskTimedOutEventAttributes_Read(w wire.Value) (*ActivityTaskTimedOutEventAttributes, error) {
	var v ActivityTaskTimedOutEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _TimerStartedEventAttributes_Read(w wire.Value) (*TimerStartedEventAttributes, error) {
	var v TimerStartedEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _TimerFiredEventAttributes_Read(w wire.Value) (*TimerFiredEventAttributes, error) {
	var v TimerFiredEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _ActivityTaskCancelRequestedEventAttributes_Read(w wire.Value) (*ActivityTaskCancelRequestedEventAttributes, error) {
	var v ActivityTaskCancelRequestedEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _RequestCancelActivityTaskFailedEventAttributes_Read(w wire.Value) (*RequestCancelActivityTaskFailedEventAttributes, error) {
	var v RequestCancelActivityTaskFailedEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _ActivityTaskCanceledEventAttributes_Read(w wire.Value) (*ActivityTaskCanceledEventAttributes, error) {
	var v ActivityTaskCanceledEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _TimerCanceledEventAttributes_Read(w wire.Value) (*TimerCanceledEventAttributes, error) {
	var v TimerCanceledEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _CancelTimerFailedEventAttributes_Read(w wire.Value) (*CancelTimerFailedEventAttributes, error) {
	var v CancelTimerFailedEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _MarkerRecordedEventAttributes_Read(w wire.Value) (*MarkerRecordedEventAttributes, error) {
	var v MarkerRecordedEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _WorkflowExecutionSignaledEventAttributes_Read(w wire.Value) (*WorkflowExecutionSignaledEventAttributes, error) {
	var v WorkflowExecutionSignaledEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _WorkflowExecutionTerminatedEventAttributes_Read(w wire.Value) (*WorkflowExecutionTerminatedEventAttributes, error) {
	var v WorkflowExecutionTerminatedEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _WorkflowExecutionCancelRequestedEventAttributes_Read(w wire.Value) (*WorkflowExecutionCancelRequestedEventAttributes, error) {
	var v WorkflowExecutionCancelRequestedEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _WorkflowExecutionCanceledEventAttributes_Read(w wire.Value) (*WorkflowExecutionCanceledEventAttributes, error) {
	var v WorkflowExecutionCanceledEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _RequestCancelExternalWorkflowExecutionInitiatedEventAttributes_Read(w wire.Value) (*RequestCancelExternalWorkflowExecutionInitiatedEventAttributes, error) {
	var v RequestCancelExternalWorkflowExecutionInitiatedEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _RequestCancelExternalWorkflowExecutionFailedEventAttributes_Read(w wire.Value) (*RequestCancelExternalWorkflowExecutionFailedEventAttributes, error) {
	var v RequestCancelExternalWorkflowExecutionFailedEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _ExternalWorkflowExecutionCancelRequestedEventAttributes_Read(w wire.Value) (*ExternalWorkflowExecutionCancelRequestedEventAttributes, error) {
	var v ExternalWorkflowExecutionCancelRequestedEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _WorkflowExecutionContinuedAsNewEventAttributes_Read(w wire.Value) (*WorkflowExecutionContinuedAsNewEventAttributes, error) {
	var v WorkflowExecutionContinuedAsNewEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _StartChildWorkflowExecutionInitiatedEventAttributes_Read(w wire.Value) (*StartChildWorkflowExecutionInitiatedEventAttributes, error) {
	var v StartChildWorkflowExecutionInitiatedEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _StartChildWorkflowExecutionFailedEventAttributes_Read(w wire.Value) (*StartChildWorkflowExecutionFailedEventAttributes, error) {
	var v StartChildWorkflowExecutionFailedEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _ChildWorkflowExecutionStartedEventAttributes_Read(w wire.Value) (*ChildWorkflowExecutionStartedEventAttributes, error) {
	var v ChildWorkflowExecutionStartedEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _ChildWorkflowExecutionCompletedEventAttributes_Read(w wire.Value) (*ChildWorkflowExecutionCompletedEventAttributes, error) {
	var v ChildWorkflowExecutionCompletedEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _ChildWorkflowExecutionFailedEventAttributes_Read(w wire.Value) (*ChildWorkflowExecutionFailedEventAttributes, error) {
	var v ChildWorkflowExecutionFailedEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _ChildWorkflowExecutionCanceledEventAttributes_Read(w wire.Value) (*ChildWorkflowExecutionCanceledEventAttributes, error) {
	var v ChildWorkflowExecutionCanceledEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _ChildWorkflowExecutionTimedOutEventAttributes_Read(w wire.Value) (*ChildWorkflowExecutionTimedOutEventAttributes, error) {
	var v ChildWorkflowExecutionTimedOutEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _ChildWorkflowExecutionTerminatedEventAttributes_Read(w wire.Value) (*ChildWorkflowExecutionTerminatedEventAttributes, error) {
	var v ChildWorkflowExecutionTerminatedEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _SignalExternalWorkflowExecutionInitiatedEventAttributes_Read(w wire.Value) (*SignalExternalWorkflowExecutionInitiatedEventAttributes, error) {
	var v SignalExternalWorkflowExecutionInitiatedEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _SignalExternalWorkflowExecutionFailedEventAttributes_Read(w wire.Value) (*SignalExternalWorkflowExecutionFailedEventAttributes, error) {
	var v SignalExternalWorkflowExecutionFailedEventAttributes
	err := v.FromWire(w)
	return &v, err
}

func _ExternalWorkflowExecutionSignaledEventAttributes_Read(w wire.Value) (*ExternalWorkflowExecutionSignaledEventAttributes, error) {
	var v ExternalWorkflowExecutionSignaledEventAttributes
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a HistoryEvent struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a HistoryEvent struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v HistoryEvent
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *HistoryEvent) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.EventId = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.Timestamp = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI32 {
				var x EventType
				x, err = _EventType_Read(field.Value)
				v.EventType = &x
				if err != nil {
					return err
				}

			}
		case 35:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.Version = &x
				if err != nil {
					return err
				}

			}
		case 36:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.TaskId = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecutionStartedEventAttributes, err = _WorkflowExecutionStartedEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecutionCompletedEventAttributes, err = _WorkflowExecutionCompletedEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecutionFailedEventAttributes, err = _WorkflowExecutionFailedEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 70:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecutionTimedOutEventAttributes, err = _WorkflowExecutionTimedOutEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 80:
			if field.Value.Type() == wire.TStruct {
				v.DecisionTaskScheduledEventAttributes, err = _DecisionTaskScheduledEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 90:
			if field.Value.Type() == wire.TStruct {
				v.DecisionTaskStartedEventAttributes, err = _DecisionTaskStartedEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 100:
			if field.Value.Type() == wire.TStruct {
				v.DecisionTaskCompletedEventAttributes, err = _DecisionTaskCompletedEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 110:
			if field.Value.Type() == wire.TStruct {
				v.DecisionTaskTimedOutEventAttributes, err = _DecisionTaskTimedOutEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 120:
			if field.Value.Type() == wire.TStruct {
				v.DecisionTaskFailedEventAttributes, err = _DecisionTaskFailedEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 130:
			if field.Value.Type() == wire.TStruct {
				v.ActivityTaskScheduledEventAttributes, err = _ActivityTaskScheduledEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 140:
			if field.Value.Type() == wire.TStruct {
				v.ActivityTaskStartedEventAttributes, err = _ActivityTaskStartedEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 150:
			if field.Value.Type() == wire.TStruct {
				v.ActivityTaskCompletedEventAttributes, err = _ActivityTaskCompletedEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 160:
			if field.Value.Type() == wire.TStruct {
				v.ActivityTaskFailedEventAttributes, err = _ActivityTaskFailedEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 170:
			if field.Value.Type() == wire.TStruct {
				v.ActivityTaskTimedOutEventAttributes, err = _ActivityTaskTimedOutEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 180:
			if field.Value.Type() == wire.TStruct {
				v.TimerStartedEventAttributes, err = _TimerStartedEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 190:
			if field.Value.Type() == wire.TStruct {
				v.TimerFiredEventAttributes, err = _TimerFiredEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 200:
			if field.Value.Type() == wire.TStruct {
				v.ActivityTaskCancelRequestedEventAttributes, err = _ActivityTaskCancelRequestedEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 210:
			if field.Value.Type() == wire.TStruct {
				v.RequestCancelActivityTaskFailedEventAttributes, err = _RequestCancelActivityTaskFailedEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 220:
			if field.Value.Type() == wire.TStruct {
				v.ActivityTaskCanceledEventAttributes, err = _ActivityTaskCanceledEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 230:
			if field.Value.Type() == wire.TStruct {
				v.TimerCanceledEventAttributes, err = _TimerCanceledEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 240:
			if field.Value.Type() == wire.TStruct {
				v.CancelTimerFailedEventAttributes, err = _CancelTimerFailedEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 250:
			if field.Value.Type() == wire.TStruct {
				v.MarkerRecordedEventAttributes, err = _MarkerRecordedEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 260:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecutionSignaledEventAttributes, err = _WorkflowExecutionSignaledEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 270:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecutionTerminatedEventAttributes, err = _WorkflowExecutionTerminatedEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 280:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecutionCancelRequestedEventAttributes, err = _WorkflowExecutionCancelRequestedEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 290:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecutionCanceledEventAttributes, err = _WorkflowExecutionCanceledEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 300:
			if field.Value.Type() == wire.TStruct {
				v.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes, err = _RequestCancelExternalWorkflowExecutionInitiatedEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 310:
			if field.Value.Type() == wire.TStruct {
				v.RequestCancelExternalWorkflowExecutionFailedEventAttributes, err = _RequestCancelExternalWorkflowExecutionFailedEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 320:
			if field.Value.Type() == wire.TStruct {
				v.ExternalWorkflowExecutionCancelRequestedEventAttributes, err = _ExternalWorkflowExecutionCancelRequestedEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 330:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecutionContinuedAsNewEventAttributes, err = _WorkflowExecutionContinuedAsNewEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 340:
			if field.Value.Type() == wire.TStruct {
				v.StartChildWorkflowExecutionInitiatedEventAttributes, err = _StartChildWorkflowExecutionInitiatedEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 350:
			if field.Value.Type() == wire.TStruct {
				v.StartChildWorkflowExecutionFailedEventAttributes, err = _StartChildWorkflowExecutionFailedEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 360:
			if field.Value.Type() == wire.TStruct {
				v.ChildWorkflowExecutionStartedEventAttributes, err = _ChildWorkflowExecutionStartedEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 370:
			if field.Value.Type() == wire.TStruct {
				v.ChildWorkflowExecutionCompletedEventAttributes, err = _ChildWorkflowExecutionCompletedEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 380:
			if field.Value.Type() == wire.TStruct {
				v.ChildWorkflowExecutionFailedEventAttributes, err = _ChildWorkflowExecutionFailedEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 390:
			if field.Value.Type() == wire.TStruct {
				v.ChildWorkflowExecutionCanceledEventAttributes, err = _ChildWorkflowExecutionCanceledEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 400:
			if field.Value.Type() == wire.TStruct {
				v.ChildWorkflowExecutionTimedOutEventAttributes, err = _ChildWorkflowExecutionTimedOutEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 410:
			if field.Value.Type() == wire.TStruct {
				v.ChildWorkflowExecutionTerminatedEventAttributes, err = _ChildWorkflowExecutionTerminatedEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 420:
			if field.Value.Type() == wire.TStruct {
				v.SignalExternalWorkflowExecutionInitiatedEventAttributes, err = _SignalExternalWorkflowExecutionInitiatedEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 430:
			if field.Value.Type() == wire.TStruct {
				v.SignalExternalWorkflowExecutionFailedEventAttributes, err = _SignalExternalWorkflowExecutionFailedEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 440:
			if field.Value.Type() == wire.TStruct {
				v.ExternalWorkflowExecutionSignaledEventAttributes, err = _ExternalWorkflowExecutionSignaledEventAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a HistoryEvent
// struct.
func (v *HistoryEvent) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [46]string
	i := 0
	if v.EventId != nil {
		fields[i] = fmt.Sprintf("EventId: %v", *(v.EventId))
		i++
	}
	if v.Timestamp != nil {
		fields[i] = fmt.Sprintf("Timestamp: %v", *(v.Timestamp))
		i++
	}
	if v.EventType != nil {
		fields[i] = fmt.Sprintf("EventType: %v", *(v.EventType))
		i++
	}
	if v.Version != nil {
		fields[i] = fmt.Sprintf("Version: %v", *(v.Version))
		i++
	}
	if v.TaskId != nil {
		fields[i] = fmt.Sprintf("TaskId: %v", *(v.TaskId))
		i++
	}
	if v.WorkflowExecutionStartedEventAttributes != nil {
		fields[i] = fmt.Sprintf("WorkflowExecutionStartedEventAttributes: %v", v.WorkflowExecutionStartedEventAttributes)
		i++
	}
	if v.WorkflowExecutionCompletedEventAttributes != nil {
		fields[i] = fmt.Sprintf("WorkflowExecutionCompletedEventAttributes: %v", v.WorkflowExecutionCompletedEventAttributes)
		i++
	}
	if v.WorkflowExecutionFailedEventAttributes != nil {
		fields[i] = fmt.Sprintf("WorkflowExecutionFailedEventAttributes: %v", v.WorkflowExecutionFailedEventAttributes)
		i++
	}
	if v.WorkflowExecutionTimedOutEventAttributes != nil {
		fields[i] = fmt.Sprintf("WorkflowExecutionTimedOutEventAttributes: %v", v.WorkflowExecutionTimedOutEventAttributes)
		i++
	}
	if v.DecisionTaskScheduledEventAttributes != nil {
		fields[i] = fmt.Sprintf("DecisionTaskScheduledEventAttributes: %v", v.DecisionTaskScheduledEventAttributes)
		i++
	}
	if v.DecisionTaskStartedEventAttributes != nil {
		fields[i] = fmt.Sprintf("DecisionTaskStartedEventAttributes: %v", v.DecisionTaskStartedEventAttributes)
		i++
	}
	if v.DecisionTaskCompletedEventAttributes != nil {
		fields[i] = fmt.Sprintf("DecisionTaskCompletedEventAttributes: %v", v.DecisionTaskCompletedEventAttributes)
		i++
	}
	if v.DecisionTaskTimedOutEventAttributes != nil {
		fields[i] = fmt.Sprintf("DecisionTaskTimedOutEventAttributes: %v", v.DecisionTaskTimedOutEventAttributes)
		i++
	}
	if v.DecisionTaskFailedEventAttributes != nil {
		fields[i] = fmt.Sprintf("DecisionTaskFailedEventAttributes: %v", v.DecisionTaskFailedEventAttributes)
		i++
	}
	if v.ActivityTaskScheduledEventAttributes != nil {
		fields[i] = fmt.Sprintf("ActivityTaskScheduledEventAttributes: %v", v.ActivityTaskScheduledEventAttributes)
		i++
	}
	if v.ActivityTaskStartedEventAttributes != nil {
		fields[i] = fmt.Sprintf("ActivityTaskStartedEventAttributes: %v", v.ActivityTaskStartedEventAttributes)
		i++
	}
	if v.ActivityTaskCompletedEventAttributes != nil {
		fields[i] = fmt.Sprintf("ActivityTaskCompletedEventAttributes: %v", v.ActivityTaskCompletedEventAttributes)
		i++
	}
	if v.ActivityTaskFailedEventAttributes != nil {
		fields[i] = fmt.Sprintf("ActivityTaskFailedEventAttributes: %v", v.ActivityTaskFailedEventAttributes)
		i++
	}
	if v.ActivityTaskTimedOutEventAttributes != nil {
		fields[i] = fmt.Sprintf("ActivityTaskTimedOutEventAttributes: %v", v.ActivityTaskTimedOutEventAttributes)
		i++
	}
	if v.TimerStartedEventAttributes != nil {
		fields[i] = fmt.Sprintf("TimerStartedEventAttributes: %v", v.TimerStartedEventAttributes)
		i++
	}
	if v.TimerFiredEventAttributes != nil {
		fields[i] = fmt.Sprintf("TimerFiredEventAttributes: %v", v.TimerFiredEventAttributes)
		i++
	}
	if v.ActivityTaskCancelRequestedEventAttributes != nil {
		fields[i] = fmt.Sprintf("ActivityTaskCancelRequestedEventAttributes: %v", v.ActivityTaskCancelRequestedEventAttributes)
		i++
	}
	if v.RequestCancelActivityTaskFailedEventAttributes != nil {
		fields[i] = fmt.Sprintf("RequestCancelActivityTaskFailedEventAttributes: %v", v.RequestCancelActivityTaskFailedEventAttributes)
		i++
	}
	if v.ActivityTaskCanceledEventAttributes != nil {
		fields[i] = fmt.Sprintf("ActivityTaskCanceledEventAttributes: %v", v.ActivityTaskCanceledEventAttributes)
		i++
	}
	if v.TimerCanceledEventAttributes != nil {
		fields[i] = fmt.Sprintf("TimerCanceledEventAttributes: %v", v.TimerCanceledEventAttributes)
		i++
	}
	if v.CancelTimerFailedEventAttributes != nil {
		fields[i] = fmt.Sprintf("CancelTimerFailedEventAttributes: %v", v.CancelTimerFailedEventAttributes)
		i++
	}
	if v.MarkerRecordedEventAttributes != nil {
		fields[i] = fmt.Sprintf("MarkerRecordedEventAttributes: %v", v.MarkerRecordedEventAttributes)
		i++
	}
	if v.WorkflowExecutionSignaledEventAttributes != nil {
		fields[i] = fmt.Sprintf("WorkflowExecutionSignaledEventAttributes: %v", v.WorkflowExecutionSignaledEventAttributes)
		i++
	}
	if v.WorkflowExecutionTerminatedEventAttributes != nil {
		fields[i] = fmt.Sprintf("WorkflowExecutionTerminatedEventAttributes: %v", v.WorkflowExecutionTerminatedEventAttributes)
		i++
	}
	if v.WorkflowExecutionCancelRequestedEventAttributes != nil {
		fields[i] = fmt.Sprintf("WorkflowExecutionCancelRequestedEventAttributes: %v", v.WorkflowExecutionCancelRequestedEventAttributes)
		i++
	}
	if v.WorkflowExecutionCanceledEventAttributes != nil {
		fields[i] = fmt.Sprintf("WorkflowExecutionCanceledEventAttributes: %v", v.WorkflowExecutionCanceledEventAttributes)
		i++
	}
	if v.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes != nil {
		fields[i] = fmt.Sprintf("RequestCancelExternalWorkflowExecutionInitiatedEventAttributes: %v", v.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes)
		i++
	}
	if v.RequestCancelExternalWorkflowExecutionFailedEventAttributes != nil {
		fields[i] = fmt.Sprintf("RequestCancelExternalWorkflowExecutionFailedEventAttributes: %v", v.RequestCancelExternalWorkflowExecutionFailedEventAttributes)
		i++
	}
	if v.ExternalWorkflowExecutionCancelRequestedEventAttributes != nil {
		fields[i] = fmt.Sprintf("ExternalWorkflowExecutionCancelRequestedEventAttributes: %v", v.ExternalWorkflowExecutionCancelRequestedEventAttributes)
		i++
	}
	if v.WorkflowExecutionContinuedAsNewEventAttributes != nil {
		fields[i] = fmt.Sprintf("WorkflowExecutionContinuedAsNewEventAttributes: %v", v.WorkflowExecutionContinuedAsNewEventAttributes)
		i++
	}
	if v.StartChildWorkflowExecutionInitiatedEventAttributes != nil {
		fields[i] = fmt.Sprintf("StartChildWorkflowExecutionInitiatedEventAttributes: %v", v.StartChildWorkflowExecutionInitiatedEventAttributes)
		i++
	}
	if v.StartChildWorkflowExecutionFailedEventAttributes != nil {
		fields[i] = fmt.Sprintf("StartChildWorkflowExecutionFailedEventAttributes: %v", v.StartChildWorkflowExecutionFailedEventAttributes)
		i++
	}
	if v.ChildWorkflowExecutionStartedEventAttributes != nil {
		fields[i] = fmt.Sprintf("ChildWorkflowExecutionStartedEventAttributes: %v", v.ChildWorkflowExecutionStartedEventAttributes)
		i++
	}
	if v.ChildWorkflowExecutionCompletedEventAttributes != nil {
		fields[i] = fmt.Sprintf("ChildWorkflowExecutionCompletedEventAttributes: %v", v.ChildWorkflowExecutionCompletedEventAttributes)
		i++
	}
	if v.ChildWorkflowExecutionFailedEventAttributes != nil {
		fields[i] = fmt.Sprintf("ChildWorkflowExecutionFailedEventAttributes: %v", v.ChildWorkflowExecutionFailedEventAttributes)
		i++
	}
	if v.ChildWorkflowExecutionCanceledEventAttributes != nil {
		fields[i] = fmt.Sprintf("ChildWorkflowExecutionCanceledEventAttributes: %v", v.ChildWorkflowExecutionCanceledEventAttributes)
		i++
	}
	if v.ChildWorkflowExecutionTimedOutEventAttributes != nil {
		fields[i] = fmt.Sprintf("ChildWorkflowExecutionTimedOutEventAttributes: %v", v.ChildWorkflowExecutionTimedOutEventAttributes)
		i++
	}
	if v.ChildWorkflowExecutionTerminatedEventAttributes != nil {
		fields[i] = fmt.Sprintf("ChildWorkflowExecutionTerminatedEventAttributes: %v", v.ChildWorkflowExecutionTerminatedEventAttributes)
		i++
	}
	if v.SignalExternalWorkflowExecutionInitiatedEventAttributes != nil {
		fields[i] = fmt.Sprintf("SignalExternalWorkflowExecutionInitiatedEventAttributes: %v", v.SignalExternalWorkflowExecutionInitiatedEventAttributes)
		i++
	}
	if v.SignalExternalWorkflowExecutionFailedEventAttributes != nil {
		fields[i] = fmt.Sprintf("SignalExternalWorkflowExecutionFailedEventAttributes: %v", v.SignalExternalWorkflowExecutionFailedEventAttributes)
		i++
	}
	if v.ExternalWorkflowExecutionSignaledEventAttributes != nil {
		fields[i] = fmt.Sprintf("ExternalWorkflowExecutionSignaledEventAttributes: %v", v.ExternalWorkflowExecutionSignaledEventAttributes)
		i++
	}

	return fmt.Sprintf("HistoryEvent{%v}", strings.Join(fields[:i], ", "))
}

func _EventType_EqualsPtr(lhs, rhs *EventType) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return x.Equals(y)
	}
	return lhs == nil && rhs == nil
}

// Equals returns true if all the fields of this HistoryEvent match the
// provided HistoryEvent.
//
// This function performs a deep comparison.
func (v *HistoryEvent) Equals(rhs *HistoryEvent) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_I64_EqualsPtr(v.EventId, rhs.EventId) {
		return false
	}
	if !_I64_EqualsPtr(v.Timestamp, rhs.Timestamp) {
		return false
	}
	if !_EventType_EqualsPtr(v.EventType, rhs.EventType) {
		return false
	}
	if !_I64_EqualsPtr(v.Version, rhs.Version) {
		return false
	}
	if !_I64_EqualsPtr(v.TaskId, rhs.TaskId) {
		return false
	}
	if !((v.WorkflowExecutionStartedEventAttributes == nil && rhs.WorkflowExecutionStartedEventAttributes == nil) || (v.WorkflowExecutionStartedEventAttributes != nil && rhs.WorkflowExecutionStartedEventAttributes != nil && v.WorkflowExecutionStartedEventAttributes.Equals(rhs.WorkflowExecutionStartedEventAttributes))) {
		return false
	}
	if !((v.WorkflowExecutionCompletedEventAttributes == nil && rhs.WorkflowExecutionCompletedEventAttributes == nil) || (v.WorkflowExecutionCompletedEventAttributes != nil && rhs.WorkflowExecutionCompletedEventAttributes != nil && v.WorkflowExecutionCompletedEventAttributes.Equals(rhs.WorkflowExecutionCompletedEventAttributes))) {
		return false
	}
	if !((v.WorkflowExecutionFailedEventAttributes == nil && rhs.WorkflowExecutionFailedEventAttributes == nil) || (v.WorkflowExecutionFailedEventAttributes != nil && rhs.WorkflowExecutionFailedEventAttributes != nil && v.WorkflowExecutionFailedEventAttributes.Equals(rhs.WorkflowExecutionFailedEventAttributes))) {
		return false
	}
	if !((v.WorkflowExecutionTimedOutEventAttributes == nil && rhs.WorkflowExecutionTimedOutEventAttributes == nil) || (v.WorkflowExecutionTimedOutEventAttributes != nil && rhs.WorkflowExecutionTimedOutEventAttributes != nil && v.WorkflowExecutionTimedOutEventAttributes.Equals(rhs.WorkflowExecutionTimedOutEventAttributes))) {
		return false
	}
	if !((v.DecisionTaskScheduledEventAttributes == nil && rhs.DecisionTaskScheduledEventAttributes == nil) || (v.DecisionTaskScheduledEventAttributes != nil && rhs.DecisionTaskScheduledEventAttributes != nil && v.DecisionTaskScheduledEventAttributes.Equals(rhs.DecisionTaskScheduledEventAttributes))) {
		return false
	}
	if !((v.DecisionTaskStartedEventAttributes == nil && rhs.DecisionTaskStartedEventAttributes == nil) || (v.DecisionTaskStartedEventAttributes != nil && rhs.DecisionTaskStartedEventAttributes != nil && v.DecisionTaskStartedEventAttributes.Equals(rhs.DecisionTaskStartedEventAttributes))) {
		return false
	}
	if !((v.DecisionTaskCompletedEventAttributes == nil && rhs.DecisionTaskCompletedEventAttributes == nil) || (v.DecisionTaskCompletedEventAttributes != nil && rhs.DecisionTaskCompletedEventAttributes != nil && v.DecisionTaskCompletedEventAttributes.Equals(rhs.DecisionTaskCompletedEventAttributes))) {
		return false
	}
	if !((v.DecisionTaskTimedOutEventAttributes == nil && rhs.DecisionTaskTimedOutEventAttributes == nil) || (v.DecisionTaskTimedOutEventAttributes != nil && rhs.DecisionTaskTimedOutEventAttributes != nil && v.DecisionTaskTimedOutEventAttributes.Equals(rhs.DecisionTaskTimedOutEventAttributes))) {
		return false
	}
	if !((v.DecisionTaskFailedEventAttributes == nil && rhs.DecisionTaskFailedEventAttributes == nil) || (v.DecisionTaskFailedEventAttributes != nil && rhs.DecisionTaskFailedEventAttributes != nil && v.DecisionTaskFailedEventAttributes.Equals(rhs.DecisionTaskFailedEventAttributes))) {
		return false
	}
	if !((v.ActivityTaskScheduledEventAttributes == nil && rhs.ActivityTaskScheduledEventAttributes == nil) || (v.ActivityTaskScheduledEventAttributes != nil && rhs.ActivityTaskScheduledEventAttributes != nil && v.ActivityTaskScheduledEventAttributes.Equals(rhs.ActivityTaskScheduledEventAttributes))) {
		return false
	}
	if !((v.ActivityTaskStartedEventAttributes == nil && rhs.ActivityTaskStartedEventAttributes == nil) || (v.ActivityTaskStartedEventAttributes != nil && rhs.ActivityTaskStartedEventAttributes != nil && v.ActivityTaskStartedEventAttributes.Equals(rhs.ActivityTaskStartedEventAttributes))) {
		return false
	}
	if !((v.ActivityTaskCompletedEventAttributes == nil && rhs.ActivityTaskCompletedEventAttributes == nil) || (v.ActivityTaskCompletedEventAttributes != nil && rhs.ActivityTaskCompletedEventAttributes != nil && v.ActivityTaskCompletedEventAttributes.Equals(rhs.ActivityTaskCompletedEventAttributes))) {
		return false
	}
	if !((v.ActivityTaskFailedEventAttributes == nil && rhs.ActivityTaskFailedEventAttributes == nil) || (v.ActivityTaskFailedEventAttributes != nil && rhs.ActivityTaskFailedEventAttributes != nil && v.ActivityTaskFailedEventAttributes.Equals(rhs.ActivityTaskFailedEventAttributes))) {
		return false
	}
	if !((v.ActivityTaskTimedOutEventAttributes == nil && rhs.ActivityTaskTimedOutEventAttributes == nil) || (v.ActivityTaskTimedOutEventAttributes != nil && rhs.ActivityTaskTimedOutEventAttributes != nil && v.ActivityTaskTimedOutEventAttributes.Equals(rhs.ActivityTaskTimedOutEventAttributes))) {
		return false
	}
	if !((v.TimerStartedEventAttributes == nil && rhs.TimerStartedEventAttributes == nil) || (v.TimerStartedEventAttributes != nil && rhs.TimerStartedEventAttributes != nil && v.TimerStartedEventAttributes.Equals(rhs.TimerStartedEventAttributes))) {
		return false
	}
	if !((v.TimerFiredEventAttributes == nil && rhs.TimerFiredEventAttributes == nil) || (v.TimerFiredEventAttributes != nil && rhs.TimerFiredEventAttributes != nil && v.TimerFiredEventAttributes.Equals(rhs.TimerFiredEventAttributes))) {
		return false
	}
	if !((v.ActivityTaskCancelRequestedEventAttributes == nil && rhs.ActivityTaskCancelRequestedEventAttributes == nil) || (v.ActivityTaskCancelRequestedEventAttributes != nil && rhs.ActivityTaskCancelRequestedEventAttributes != nil && v.ActivityTaskCancelRequestedEventAttributes.Equals(rhs.ActivityTaskCancelRequestedEventAttributes))) {
		return false
	}
	if !((v.RequestCancelActivityTaskFailedEventAttributes == nil && rhs.RequestCancelActivityTaskFailedEventAttributes == nil) || (v.RequestCancelActivityTaskFailedEventAttributes != nil && rhs.RequestCancelActivityTaskFailedEventAttributes != nil && v.RequestCancelActivityTaskFailedEventAttributes.Equals(rhs.RequestCancelActivityTaskFailedEventAttributes))) {
		return false
	}
	if !((v.ActivityTaskCanceledEventAttributes == nil && rhs.ActivityTaskCanceledEventAttributes == nil) || (v.ActivityTaskCanceledEventAttributes != nil && rhs.ActivityTaskCanceledEventAttributes != nil && v.ActivityTaskCanceledEventAttributes.Equals(rhs.ActivityTaskCanceledEventAttributes))) {
		return false
	}
	if !((v.TimerCanceledEventAttributes == nil && rhs.TimerCanceledEventAttributes == nil) || (v.TimerCanceledEventAttributes != nil && rhs.TimerCanceledEventAttributes != nil && v.TimerCanceledEventAttributes.Equals(rhs.TimerCanceledEventAttributes))) {
		return false
	}
	if !((v.CancelTimerFailedEventAttributes == nil && rhs.CancelTimerFailedEventAttributes == nil) || (v.CancelTimerFailedEventAttributes != nil && rhs.CancelTimerFailedEventAttributes != nil && v.CancelTimerFailedEventAttributes.Equals(rhs.CancelTimerFailedEventAttributes))) {
		return false
	}
	if !((v.MarkerRecordedEventAttributes == nil && rhs.MarkerRecordedEventAttributes == nil) || (v.MarkerRecordedEventAttributes != nil && rhs.MarkerRecordedEventAttributes != nil && v.MarkerRecordedEventAttributes.Equals(rhs.MarkerRecordedEventAttributes))) {
		return false
	}
	if !((v.WorkflowExecutionSignaledEventAttributes == nil && rhs.WorkflowExecutionSignaledEventAttributes == nil) || (v.WorkflowExecutionSignaledEventAttributes != nil && rhs.WorkflowExecutionSignaledEventAttributes != nil && v.WorkflowExecutionSignaledEventAttributes.Equals(rhs.WorkflowExecutionSignaledEventAttributes))) {
		return false
	}
	if !((v.WorkflowExecutionTerminatedEventAttributes == nil && rhs.WorkflowExecutionTerminatedEventAttributes == nil) || (v.WorkflowExecutionTerminatedEventAttributes != nil && rhs.WorkflowExecutionTerminatedEventAttributes != nil && v.WorkflowExecutionTerminatedEventAttributes.Equals(rhs.WorkflowExecutionTerminatedEventAttributes))) {
		return false
	}
	if !((v.WorkflowExecutionCancelRequestedEventAttributes == nil && rhs.WorkflowExecutionCancelRequestedEventAttributes == nil) || (v.WorkflowExecutionCancelRequestedEventAttributes != nil && rhs.WorkflowExecutionCancelRequestedEventAttributes != nil && v.WorkflowExecutionCancelRequestedEventAttributes.Equals(rhs.WorkflowExecutionCancelRequestedEventAttributes))) {
		return false
	}
	if !((v.WorkflowExecutionCanceledEventAttributes == nil && rhs.WorkflowExecutionCanceledEventAttributes == nil) || (v.WorkflowExecutionCanceledEventAttributes != nil && rhs.WorkflowExecutionCanceledEventAttributes != nil && v.WorkflowExecutionCanceledEventAttributes.Equals(rhs.WorkflowExecutionCanceledEventAttributes))) {
		return false
	}
	if !((v.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes == nil && rhs.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes == nil) || (v.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes != nil && rhs.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes != nil && v.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.Equals(rhs.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes))) {
		return false
	}
	if !((v.RequestCancelExternalWorkflowExecutionFailedEventAttributes == nil && rhs.RequestCancelExternalWorkflowExecutionFailedEventAttributes == nil) || (v.RequestCancelExternalWorkflowExecutionFailedEventAttributes != nil && rhs.RequestCancelExternalWorkflowExecutionFailedEventAttributes != nil && v.RequestCancelExternalWorkflowExecutionFailedEventAttributes.Equals(rhs.RequestCancelExternalWorkflowExecutionFailedEventAttributes))) {
		return false
	}
	if !((v.ExternalWorkflowExecutionCancelRequestedEventAttributes == nil && rhs.ExternalWorkflowExecutionCancelRequestedEventAttributes == nil) || (v.ExternalWorkflowExecutionCancelRequestedEventAttributes != nil && rhs.ExternalWorkflowExecutionCancelRequestedEventAttributes != nil && v.ExternalWorkflowExecutionCancelRequestedEventAttributes.Equals(rhs.ExternalWorkflowExecutionCancelRequestedEventAttributes))) {
		return false
	}
	if !((v.WorkflowExecutionContinuedAsNewEventAttributes == nil && rhs.WorkflowExecutionContinuedAsNewEventAttributes == nil) || (v.WorkflowExecutionContinuedAsNewEventAttributes != nil && rhs.WorkflowExecutionContinuedAsNewEventAttributes != nil && v.WorkflowExecutionContinuedAsNewEventAttributes.Equals(rhs.WorkflowExecutionContinuedAsNewEventAttributes))) {
		return false
	}
	if !((v.StartChildWorkflowExecutionInitiatedEventAttributes == nil && rhs.StartChildWorkflowExecutionInitiatedEventAttributes == nil) || (v.StartChildWorkflowExecutionInitiatedEventAttributes != nil && rhs.StartChildWorkflowExecutionInitiatedEventAttributes != nil && v.StartChildWorkflowExecutionInitiatedEventAttributes.Equals(rhs.StartChildWorkflowExecutionInitiatedEventAttributes))) {
		return false
	}
	if !((v.StartChildWorkflowExecutionFailedEventAttributes == nil && rhs.StartChildWorkflowExecutionFailedEventAttributes == nil) || (v.StartChildWorkflowExecutionFailedEventAttributes != nil && rhs.StartChildWorkflowExecutionFailedEventAttributes != nil && v.StartChildWorkflowExecutionFailedEventAttributes.Equals(rhs.StartChildWorkflowExecutionFailedEventAttributes))) {
		return false
	}
	if !((v.ChildWorkflowExecutionStartedEventAttributes == nil && rhs.ChildWorkflowExecutionStartedEventAttributes == nil) || (v.ChildWorkflowExecutionStartedEventAttributes != nil && rhs.ChildWorkflowExecutionStartedEventAttributes != nil && v.ChildWorkflowExecutionStartedEventAttributes.Equals(rhs.ChildWorkflowExecutionStartedEventAttributes))) {
		return false
	}
	if !((v.ChildWorkflowExecutionCompletedEventAttributes == nil && rhs.ChildWorkflowExecutionCompletedEventAttributes == nil) || (v.ChildWorkflowExecutionCompletedEventAttributes != nil && rhs.ChildWorkflowExecutionCompletedEventAttributes != nil && v.ChildWorkflowExecutionCompletedEventAttributes.Equals(rhs.ChildWorkflowExecutionCompletedEventAttributes))) {
		return false
	}
	if !((v.ChildWorkflowExecutionFailedEventAttributes == nil && rhs.ChildWorkflowExecutionFailedEventAttributes == nil) || (v.ChildWorkflowExecutionFailedEventAttributes != nil && rhs.ChildWorkflowExecutionFailedEventAttributes != nil && v.ChildWorkflowExecutionFailedEventAttributes.Equals(rhs.ChildWorkflowExecutionFailedEventAttributes))) {
		return false
	}
	if !((v.ChildWorkflowExecutionCanceledEventAttributes == nil && rhs.ChildWorkflowExecutionCanceledEventAttributes == nil) || (v.ChildWorkflowExecutionCanceledEventAttributes != nil && rhs.ChildWorkflowExecutionCanceledEventAttributes != nil && v.ChildWorkflowExecutionCanceledEventAttributes.Equals(rhs.ChildWorkflowExecutionCanceledEventAttributes))) {
		return false
	}
	if !((v.ChildWorkflowExecutionTimedOutEventAttributes == nil && rhs.ChildWorkflowExecutionTimedOutEventAttributes == nil) || (v.ChildWorkflowExecutionTimedOutEventAttributes != nil && rhs.ChildWorkflowExecutionTimedOutEventAttributes != nil && v.ChildWorkflowExecutionTimedOutEventAttributes.Equals(rhs.ChildWorkflowExecutionTimedOutEventAttributes))) {
		return false
	}
	if !((v.ChildWorkflowExecutionTerminatedEventAttributes == nil && rhs.ChildWorkflowExecutionTerminatedEventAttributes == nil) || (v.ChildWorkflowExecutionTerminatedEventAttributes != nil && rhs.ChildWorkflowExecutionTerminatedEventAttributes != nil && v.ChildWorkflowExecutionTerminatedEventAttributes.Equals(rhs.ChildWorkflowExecutionTerminatedEventAttributes))) {
		return false
	}
	if !((v.SignalExternalWorkflowExecutionInitiatedEventAttributes == nil && rhs.SignalExternalWorkflowExecutionInitiatedEventAttributes == nil) || (v.SignalExternalWorkflowExecutionInitiatedEventAttributes != nil && rhs.SignalExternalWorkflowExecutionInitiatedEventAttributes != nil && v.SignalExternalWorkflowExecutionInitiatedEventAttributes.Equals(rhs.SignalExternalWorkflowExecutionInitiatedEventAttributes))) {
		return false
	}
	if !((v.SignalExternalWorkflowExecutionFailedEventAttributes == nil && rhs.SignalExternalWorkflowExecutionFailedEventAttributes == nil) || (v.SignalExternalWorkflowExecutionFailedEventAttributes != nil && rhs.SignalExternalWorkflowExecutionFailedEventAttributes != nil && v.SignalExternalWorkflowExecutionFailedEventAttributes.Equals(rhs.SignalExternalWorkflowExecutionFailedEventAttributes))) {
		return false
	}
	if !((v.ExternalWorkflowExecutionSignaledEventAttributes == nil && rhs.ExternalWorkflowExecutionSignaledEventAttributes == nil) || (v.ExternalWorkflowExecutionSignaledEventAttributes != nil && rhs.ExternalWorkflowExecutionSignaledEventAttributes != nil && v.ExternalWorkflowExecutionSignaledEventAttributes.Equals(rhs.ExternalWorkflowExecutionSignaledEventAttributes))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of HistoryEvent.
func (v *HistoryEvent) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.EventId != nil {
		enc.AddInt64("eventId", *v.EventId)
	}
	if v.Timestamp != nil {
		enc.AddInt64("timestamp", *v.Timestamp)
	}
	if v.EventType != nil {
		err = multierr.Append(err, enc.AddObject("eventType", *v.EventType))
	}
	if v.Version != nil {
		enc.AddInt64("version", *v.Version)
	}
	if v.TaskId != nil {
		enc.AddInt64("taskId", *v.TaskId)
	}
	if v.WorkflowExecutionStartedEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecutionStartedEventAttributes", v.WorkflowExecutionStartedEventAttributes))
	}
	if v.WorkflowExecutionCompletedEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecutionCompletedEventAttributes", v.WorkflowExecutionCompletedEventAttributes))
	}
	if v.WorkflowExecutionFailedEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecutionFailedEventAttributes", v.WorkflowExecutionFailedEventAttributes))
	}
	if v.WorkflowExecutionTimedOutEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecutionTimedOutEventAttributes", v.WorkflowExecutionTimedOutEventAttributes))
	}
	if v.DecisionTaskScheduledEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("decisionTaskScheduledEventAttributes", v.DecisionTaskScheduledEventAttributes))
	}
	if v.DecisionTaskStartedEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("decisionTaskStartedEventAttributes", v.DecisionTaskStartedEventAttributes))
	}
	if v.DecisionTaskCompletedEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("decisionTaskCompletedEventAttributes", v.DecisionTaskCompletedEventAttributes))
	}
	if v.DecisionTaskTimedOutEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("decisionTaskTimedOutEventAttributes", v.DecisionTaskTimedOutEventAttributes))
	}
	if v.DecisionTaskFailedEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("decisionTaskFailedEventAttributes", v.DecisionTaskFailedEventAttributes))
	}
	if v.ActivityTaskScheduledEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("activityTaskScheduledEventAttributes", v.ActivityTaskScheduledEventAttributes))
	}
	if v.ActivityTaskStartedEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("activityTaskStartedEventAttributes", v.ActivityTaskStartedEventAttributes))
	}
	if v.ActivityTaskCompletedEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("activityTaskCompletedEventAttributes", v.ActivityTaskCompletedEventAttributes))
	}
	if v.ActivityTaskFailedEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("activityTaskFailedEventAttributes", v.ActivityTaskFailedEventAttributes))
	}
	if v.ActivityTaskTimedOutEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("activityTaskTimedOutEventAttributes", v.ActivityTaskTimedOutEventAttributes))
	}
	if v.TimerStartedEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("timerStartedEventAttributes", v.TimerStartedEventAttributes))
	}
	if v.TimerFiredEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("timerFiredEventAttributes", v.TimerFiredEventAttributes))
	}
	if v.ActivityTaskCancelRequestedEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("activityTaskCancelRequestedEventAttributes", v.ActivityTaskCancelRequestedEventAttributes))
	}
	if v.RequestCancelActivityTaskFailedEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("requestCancelActivityTaskFailedEventAttributes", v.RequestCancelActivityTaskFailedEventAttributes))
	}
	if v.ActivityTaskCanceledEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("activityTaskCanceledEventAttributes", v.ActivityTaskCanceledEventAttributes))
	}
	if v.TimerCanceledEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("timerCanceledEventAttributes", v.TimerCanceledEventAttributes))
	}
	if v.CancelTimerFailedEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("cancelTimerFailedEventAttributes", v.CancelTimerFailedEventAttributes))
	}
	if v.MarkerRecordedEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("markerRecordedEventAttributes", v.MarkerRecordedEventAttributes))
	}
	if v.WorkflowExecutionSignaledEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecutionSignaledEventAttributes", v.WorkflowExecutionSignaledEventAttributes))
	}
	if v.WorkflowExecutionTerminatedEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecutionTerminatedEventAttributes", v.WorkflowExecutionTerminatedEventAttributes))
	}
	if v.WorkflowExecutionCancelRequestedEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecutionCancelRequestedEventAttributes", v.WorkflowExecutionCancelRequestedEventAttributes))
	}
	if v.WorkflowExecutionCanceledEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecutionCanceledEventAttributes", v.WorkflowExecutionCanceledEventAttributes))
	}
	if v.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("requestCancelExternalWorkflowExecutionInitiatedEventAttributes", v.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes))
	}
	if v.RequestCancelExternalWorkflowExecutionFailedEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("requestCancelExternalWorkflowExecutionFailedEventAttributes", v.RequestCancelExternalWorkflowExecutionFailedEventAttributes))
	}
	if v.ExternalWorkflowExecutionCancelRequestedEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("externalWorkflowExecutionCancelRequestedEventAttributes", v.ExternalWorkflowExecutionCancelRequestedEventAttributes))
	}
	if v.WorkflowExecutionContinuedAsNewEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecutionContinuedAsNewEventAttributes", v.WorkflowExecutionContinuedAsNewEventAttributes))
	}
	if v.StartChildWorkflowExecutionInitiatedEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("startChildWorkflowExecutionInitiatedEventAttributes", v.StartChildWorkflowExecutionInitiatedEventAttributes))
	}
	if v.StartChildWorkflowExecutionFailedEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("startChildWorkflowExecutionFailedEventAttributes", v.StartChildWorkflowExecutionFailedEventAttributes))
	}
	if v.ChildWorkflowExecutionStartedEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("childWorkflowExecutionStartedEventAttributes", v.ChildWorkflowExecutionStartedEventAttributes))
	}
	if v.ChildWorkflowExecutionCompletedEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("childWorkflowExecutionCompletedEventAttributes", v.ChildWorkflowExecutionCompletedEventAttributes))
	}
	if v.ChildWorkflowExecutionFailedEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("childWorkflowExecutionFailedEventAttributes", v.ChildWorkflowExecutionFailedEventAttributes))
	}
	if v.ChildWorkflowExecutionCanceledEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("childWorkflowExecutionCanceledEventAttributes", v.ChildWorkflowExecutionCanceledEventAttributes))
	}
	if v.ChildWorkflowExecutionTimedOutEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("childWorkflowExecutionTimedOutEventAttributes", v.ChildWorkflowExecutionTimedOutEventAttributes))
	}
	if v.ChildWorkflowExecutionTerminatedEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("childWorkflowExecutionTerminatedEventAttributes", v.ChildWorkflowExecutionTerminatedEventAttributes))
	}
	if v.SignalExternalWorkflowExecutionInitiatedEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("signalExternalWorkflowExecutionInitiatedEventAttributes", v.SignalExternalWorkflowExecutionInitiatedEventAttributes))
	}
	if v.SignalExternalWorkflowExecutionFailedEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("signalExternalWorkflowExecutionFailedEventAttributes", v.SignalExternalWorkflowExecutionFailedEventAttributes))
	}
	if v.ExternalWorkflowExecutionSignaledEventAttributes != nil {
		err = multierr.Append(err, enc.AddObject("externalWorkflowExecutionSignaledEventAttributes", v.ExternalWorkflowExecutionSignaledEventAttributes))
	}
	return err
}

// GetEventId returns the value of EventId if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetEventId() (o int64) {
	if v != nil && v.EventId != nil {
		return *v.EventId
	}

	return
}

// IsSetEventId returns true if EventId is not nil.
func (v *HistoryEvent) IsSetEventId() bool {
	return v != nil && v.EventId != nil
}

// GetTimestamp returns the value of Timestamp if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetTimestamp() (o int64) {
	if v != nil && v.Timestamp != nil {
		return *v.Timestamp
	}

	return
}

// IsSetTimestamp returns true if Timestamp is not nil.
func (v *HistoryEvent) IsSetTimestamp() bool {
	return v != nil && v.Timestamp != nil
}

// GetEventType returns the value of EventType if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetEventType() (o EventType) {
	if v != nil && v.EventType != nil {
		return *v.EventType
	}

	return
}

// IsSetEventType returns true if EventType is not nil.
func (v *HistoryEvent) IsSetEventType() bool {
	return v != nil && v.EventType != nil
}

// GetVersion returns the value of Version if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetVersion() (o int64) {
	if v != nil && v.Version != nil {
		return *v.Version
	}

	return
}

// IsSetVersion returns true if Version is not nil.
func (v *HistoryEvent) IsSetVersion() bool {
	return v != nil && v.Version != nil
}

// GetTaskId returns the value of TaskId if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetTaskId() (o int64) {
	if v != nil && v.TaskId != nil {
		return *v.TaskId
	}

	return
}

// IsSetTaskId returns true if TaskId is not nil.
func (v *HistoryEvent) IsSetTaskId() bool {
	return v != nil && v.TaskId != nil
}

// GetWorkflowExecutionStartedEventAttributes returns the value of WorkflowExecutionStartedEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetWorkflowExecutionStartedEventAttributes() (o *WorkflowExecutionStartedEventAttributes) {
	if v != nil && v.WorkflowExecutionStartedEventAttributes != nil {
		return v.WorkflowExecutionStartedEventAttributes
	}

	return
}

// IsSetWorkflowExecutionStartedEventAttributes returns true if WorkflowExecutionStartedEventAttributes is not nil.
func (v *HistoryEvent) IsSetWorkflowExecutionStartedEventAttributes() bool {
	return v != nil && v.WorkflowExecutionStartedEventAttributes != nil
}

// GetWorkflowExecutionCompletedEventAttributes returns the value of WorkflowExecutionCompletedEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetWorkflowExecutionCompletedEventAttributes() (o *WorkflowExecutionCompletedEventAttributes) {
	if v != nil && v.WorkflowExecutionCompletedEventAttributes != nil {
		return v.WorkflowExecutionCompletedEventAttributes
	}

	return
}

// IsSetWorkflowExecutionCompletedEventAttributes returns true if WorkflowExecutionCompletedEventAttributes is not nil.
func (v *HistoryEvent) IsSetWorkflowExecutionCompletedEventAttributes() bool {
	return v != nil && v.WorkflowExecutionCompletedEventAttributes != nil
}

// GetWorkflowExecutionFailedEventAttributes returns the value of WorkflowExecutionFailedEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetWorkflowExecutionFailedEventAttributes() (o *WorkflowExecutionFailedEventAttributes) {
	if v != nil && v.WorkflowExecutionFailedEventAttributes != nil {
		return v.WorkflowExecutionFailedEventAttributes
	}

	return
}

// IsSetWorkflowExecutionFailedEventAttributes returns true if WorkflowExecutionFailedEventAttributes is not nil.
func (v *HistoryEvent) IsSetWorkflowExecutionFailedEventAttributes() bool {
	return v != nil && v.WorkflowExecutionFailedEventAttributes != nil
}

// GetWorkflowExecutionTimedOutEventAttributes returns the value of WorkflowExecutionTimedOutEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetWorkflowExecutionTimedOutEventAttributes() (o *WorkflowExecutionTimedOutEventAttributes) {
	if v != nil && v.WorkflowExecutionTimedOutEventAttributes != nil {
		return v.WorkflowExecutionTimedOutEventAttributes
	}

	return
}

// IsSetWorkflowExecutionTimedOutEventAttributes returns true if WorkflowExecutionTimedOutEventAttributes is not nil.
func (v *HistoryEvent) IsSetWorkflowExecutionTimedOutEventAttributes() bool {
	return v != nil && v.WorkflowExecutionTimedOutEventAttributes != nil
}

// GetDecisionTaskScheduledEventAttributes returns the value of DecisionTaskScheduledEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetDecisionTaskScheduledEventAttributes() (o *DecisionTaskScheduledEventAttributes) {
	if v != nil && v.DecisionTaskScheduledEventAttributes != nil {
		return v.DecisionTaskScheduledEventAttributes
	}

	return
}

// IsSetDecisionTaskScheduledEventAttributes returns true if DecisionTaskScheduledEventAttributes is not nil.
func (v *HistoryEvent) IsSetDecisionTaskScheduledEventAttributes() bool {
	return v != nil && v.DecisionTaskScheduledEventAttributes != nil
}

// GetDecisionTaskStartedEventAttributes returns the value of DecisionTaskStartedEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetDecisionTaskStartedEventAttributes() (o *DecisionTaskStartedEventAttributes) {
	if v != nil && v.DecisionTaskStartedEventAttributes != nil {
		return v.DecisionTaskStartedEventAttributes
	}

	return
}

// IsSetDecisionTaskStartedEventAttributes returns true if DecisionTaskStartedEventAttributes is not nil.
func (v *HistoryEvent) IsSetDecisionTaskStartedEventAttributes() bool {
	return v != nil && v.DecisionTaskStartedEventAttributes != nil
}

// GetDecisionTaskCompletedEventAttributes returns the value of DecisionTaskCompletedEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetDecisionTaskCompletedEventAttributes() (o *DecisionTaskCompletedEventAttributes) {
	if v != nil && v.DecisionTaskCompletedEventAttributes != nil {
		return v.DecisionTaskCompletedEventAttributes
	}

	return
}

// IsSetDecisionTaskCompletedEventAttributes returns true if DecisionTaskCompletedEventAttributes is not nil.
func (v *HistoryEvent) IsSetDecisionTaskCompletedEventAttributes() bool {
	return v != nil && v.DecisionTaskCompletedEventAttributes != nil
}

// GetDecisionTaskTimedOutEventAttributes returns the value of DecisionTaskTimedOutEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetDecisionTaskTimedOutEventAttributes() (o *DecisionTaskTimedOutEventAttributes) {
	if v != nil && v.DecisionTaskTimedOutEventAttributes != nil {
		return v.DecisionTaskTimedOutEventAttributes
	}

	return
}

// IsSetDecisionTaskTimedOutEventAttributes returns true if DecisionTaskTimedOutEventAttributes is not nil.
func (v *HistoryEvent) IsSetDecisionTaskTimedOutEventAttributes() bool {
	return v != nil && v.DecisionTaskTimedOutEventAttributes != nil
}

// GetDecisionTaskFailedEventAttributes returns the value of DecisionTaskFailedEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetDecisionTaskFailedEventAttributes() (o *DecisionTaskFailedEventAttributes) {
	if v != nil && v.DecisionTaskFailedEventAttributes != nil {
		return v.DecisionTaskFailedEventAttributes
	}

	return
}

// IsSetDecisionTaskFailedEventAttributes returns true if DecisionTaskFailedEventAttributes is not nil.
func (v *HistoryEvent) IsSetDecisionTaskFailedEventAttributes() bool {
	return v != nil && v.DecisionTaskFailedEventAttributes != nil
}

// GetActivityTaskScheduledEventAttributes returns the value of ActivityTaskScheduledEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetActivityTaskScheduledEventAttributes() (o *ActivityTaskScheduledEventAttributes) {
	if v != nil && v.ActivityTaskScheduledEventAttributes != nil {
		return v.ActivityTaskScheduledEventAttributes
	}

	return
}

// IsSetActivityTaskScheduledEventAttributes returns true if ActivityTaskScheduledEventAttributes is not nil.
func (v *HistoryEvent) IsSetActivityTaskScheduledEventAttributes() bool {
	return v != nil && v.ActivityTaskScheduledEventAttributes != nil
}

// GetActivityTaskStartedEventAttributes returns the value of ActivityTaskStartedEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetActivityTaskStartedEventAttributes() (o *ActivityTaskStartedEventAttributes) {
	if v != nil && v.ActivityTaskStartedEventAttributes != nil {
		return v.ActivityTaskStartedEventAttributes
	}

	return
}

// IsSetActivityTaskStartedEventAttributes returns true if ActivityTaskStartedEventAttributes is not nil.
func (v *HistoryEvent) IsSetActivityTaskStartedEventAttributes() bool {
	return v != nil && v.ActivityTaskStartedEventAttributes != nil
}

// GetActivityTaskCompletedEventAttributes returns the value of ActivityTaskCompletedEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetActivityTaskCompletedEventAttributes() (o *ActivityTaskCompletedEventAttributes) {
	if v != nil && v.ActivityTaskCompletedEventAttributes != nil {
		return v.ActivityTaskCompletedEventAttributes
	}

	return
}

// IsSetActivityTaskCompletedEventAttributes returns true if ActivityTaskCompletedEventAttributes is not nil.
func (v *HistoryEvent) IsSetActivityTaskCompletedEventAttributes() bool {
	return v != nil && v.ActivityTaskCompletedEventAttributes != nil
}

// GetActivityTaskFailedEventAttributes returns the value of ActivityTaskFailedEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetActivityTaskFailedEventAttributes() (o *ActivityTaskFailedEventAttributes) {
	if v != nil && v.ActivityTaskFailedEventAttributes != nil {
		return v.ActivityTaskFailedEventAttributes
	}

	return
}

// IsSetActivityTaskFailedEventAttributes returns true if ActivityTaskFailedEventAttributes is not nil.
func (v *HistoryEvent) IsSetActivityTaskFailedEventAttributes() bool {
	return v != nil && v.ActivityTaskFailedEventAttributes != nil
}

// GetActivityTaskTimedOutEventAttributes returns the value of ActivityTaskTimedOutEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetActivityTaskTimedOutEventAttributes() (o *ActivityTaskTimedOutEventAttributes) {
	if v != nil && v.ActivityTaskTimedOutEventAttributes != nil {
		return v.ActivityTaskTimedOutEventAttributes
	}

	return
}

// IsSetActivityTaskTimedOutEventAttributes returns true if ActivityTaskTimedOutEventAttributes is not nil.
func (v *HistoryEvent) IsSetActivityTaskTimedOutEventAttributes() bool {
	return v != nil && v.ActivityTaskTimedOutEventAttributes != nil
}

// GetTimerStartedEventAttributes returns the value of TimerStartedEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetTimerStartedEventAttributes() (o *TimerStartedEventAttributes) {
	if v != nil && v.TimerStartedEventAttributes != nil {
		return v.TimerStartedEventAttributes
	}

	return
}

// IsSetTimerStartedEventAttributes returns true if TimerStartedEventAttributes is not nil.
func (v *HistoryEvent) IsSetTimerStartedEventAttributes() bool {
	return v != nil && v.TimerStartedEventAttributes != nil
}

// GetTimerFiredEventAttributes returns the value of TimerFiredEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetTimerFiredEventAttributes() (o *TimerFiredEventAttributes) {
	if v != nil && v.TimerFiredEventAttributes != nil {
		return v.TimerFiredEventAttributes
	}

	return
}

// IsSetTimerFiredEventAttributes returns true if TimerFiredEventAttributes is not nil.
func (v *HistoryEvent) IsSetTimerFiredEventAttributes() bool {
	return v != nil && v.TimerFiredEventAttributes != nil
}

// GetActivityTaskCancelRequestedEventAttributes returns the value of ActivityTaskCancelRequestedEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetActivityTaskCancelRequestedEventAttributes() (o *ActivityTaskCancelRequestedEventAttributes) {
	if v != nil && v.ActivityTaskCancelRequestedEventAttributes != nil {
		return v.ActivityTaskCancelRequestedEventAttributes
	}

	return
}

// IsSetActivityTaskCancelRequestedEventAttributes returns true if ActivityTaskCancelRequestedEventAttributes is not nil.
func (v *HistoryEvent) IsSetActivityTaskCancelRequestedEventAttributes() bool {
	return v != nil && v.ActivityTaskCancelRequestedEventAttributes != nil
}

// GetRequestCancelActivityTaskFailedEventAttributes returns the value of RequestCancelActivityTaskFailedEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetRequestCancelActivityTaskFailedEventAttributes() (o *RequestCancelActivityTaskFailedEventAttributes) {
	if v != nil && v.RequestCancelActivityTaskFailedEventAttributes != nil {
		return v.RequestCancelActivityTaskFailedEventAttributes
	}

	return
}

// IsSetRequestCancelActivityTaskFailedEventAttributes returns true if RequestCancelActivityTaskFailedEventAttributes is not nil.
func (v *HistoryEvent) IsSetRequestCancelActivityTaskFailedEventAttributes() bool {
	return v != nil && v.RequestCancelActivityTaskFailedEventAttributes != nil
}

// GetActivityTaskCanceledEventAttributes returns the value of ActivityTaskCanceledEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetActivityTaskCanceledEventAttributes() (o *ActivityTaskCanceledEventAttributes) {
	if v != nil && v.ActivityTaskCanceledEventAttributes != nil {
		return v.ActivityTaskCanceledEventAttributes
	}

	return
}

// IsSetActivityTaskCanceledEventAttributes returns true if ActivityTaskCanceledEventAttributes is not nil.
func (v *HistoryEvent) IsSetActivityTaskCanceledEventAttributes() bool {
	return v != nil && v.ActivityTaskCanceledEventAttributes != nil
}

// GetTimerCanceledEventAttributes returns the value of TimerCanceledEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetTimerCanceledEventAttributes() (o *TimerCanceledEventAttributes) {
	if v != nil && v.TimerCanceledEventAttributes != nil {
		return v.TimerCanceledEventAttributes
	}

	return
}

// IsSetTimerCanceledEventAttributes returns true if TimerCanceledEventAttributes is not nil.
func (v *HistoryEvent) IsSetTimerCanceledEventAttributes() bool {
	return v != nil && v.TimerCanceledEventAttributes != nil
}

// GetCancelTimerFailedEventAttributes returns the value of CancelTimerFailedEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetCancelTimerFailedEventAttributes() (o *CancelTimerFailedEventAttributes) {
	if v != nil && v.CancelTimerFailedEventAttributes != nil {
		return v.CancelTimerFailedEventAttributes
	}

	return
}

// IsSetCancelTimerFailedEventAttributes returns true if CancelTimerFailedEventAttributes is not nil.
func (v *HistoryEvent) IsSetCancelTimerFailedEventAttributes() bool {
	return v != nil && v.CancelTimerFailedEventAttributes != nil
}

// GetMarkerRecordedEventAttributes returns the value of MarkerRecordedEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetMarkerRecordedEventAttributes() (o *MarkerRecordedEventAttributes) {
	if v != nil && v.MarkerRecordedEventAttributes != nil {
		return v.MarkerRecordedEventAttributes
	}

	return
}

// IsSetMarkerRecordedEventAttributes returns true if MarkerRecordedEventAttributes is not nil.
func (v *HistoryEvent) IsSetMarkerRecordedEventAttributes() bool {
	return v != nil && v.MarkerRecordedEventAttributes != nil
}

// GetWorkflowExecutionSignaledEventAttributes returns the value of WorkflowExecutionSignaledEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetWorkflowExecutionSignaledEventAttributes() (o *WorkflowExecutionSignaledEventAttributes) {
	if v != nil && v.WorkflowExecutionSignaledEventAttributes != nil {
		return v.WorkflowExecutionSignaledEventAttributes
	}

	return
}

// IsSetWorkflowExecutionSignaledEventAttributes returns true if WorkflowExecutionSignaledEventAttributes is not nil.
func (v *HistoryEvent) IsSetWorkflowExecutionSignaledEventAttributes() bool {
	return v != nil && v.WorkflowExecutionSignaledEventAttributes != nil
}

// GetWorkflowExecutionTerminatedEventAttributes returns the value of WorkflowExecutionTerminatedEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetWorkflowExecutionTerminatedEventAttributes() (o *WorkflowExecutionTerminatedEventAttributes) {
	if v != nil && v.WorkflowExecutionTerminatedEventAttributes != nil {
		return v.WorkflowExecutionTerminatedEventAttributes
	}

	return
}

// IsSetWorkflowExecutionTerminatedEventAttributes returns true if WorkflowExecutionTerminatedEventAttributes is not nil.
func (v *HistoryEvent) IsSetWorkflowExecutionTerminatedEventAttributes() bool {
	return v != nil && v.WorkflowExecutionTerminatedEventAttributes != nil
}

// GetWorkflowExecutionCancelRequestedEventAttributes returns the value of WorkflowExecutionCancelRequestedEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetWorkflowExecutionCancelRequestedEventAttributes() (o *WorkflowExecutionCancelRequestedEventAttributes) {
	if v != nil && v.WorkflowExecutionCancelRequestedEventAttributes != nil {
		return v.WorkflowExecutionCancelRequestedEventAttributes
	}

	return
}

// IsSetWorkflowExecutionCancelRequestedEventAttributes returns true if WorkflowExecutionCancelRequestedEventAttributes is not nil.
func (v *HistoryEvent) IsSetWorkflowExecutionCancelRequestedEventAttributes() bool {
	return v != nil && v.WorkflowExecutionCancelRequestedEventAttributes != nil
}

// GetWorkflowExecutionCanceledEventAttributes returns the value of WorkflowExecutionCanceledEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetWorkflowExecutionCanceledEventAttributes() (o *WorkflowExecutionCanceledEventAttributes) {
	if v != nil && v.WorkflowExecutionCanceledEventAttributes != nil {
		return v.WorkflowExecutionCanceledEventAttributes
	}

	return
}

// IsSetWorkflowExecutionCanceledEventAttributes returns true if WorkflowExecutionCanceledEventAttributes is not nil.
func (v *HistoryEvent) IsSetWorkflowExecutionCanceledEventAttributes() bool {
	return v != nil && v.WorkflowExecutionCanceledEventAttributes != nil
}

// GetRequestCancelExternalWorkflowExecutionInitiatedEventAttributes returns the value of RequestCancelExternalWorkflowExecutionInitiatedEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetRequestCancelExternalWorkflowExecutionInitiatedEventAttributes() (o *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) {
	if v != nil && v.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes != nil {
		return v.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes
	}

	return
}

// IsSetRequestCancelExternalWorkflowExecutionInitiatedEventAttributes returns true if RequestCancelExternalWorkflowExecutionInitiatedEventAttributes is not nil.
func (v *HistoryEvent) IsSetRequestCancelExternalWorkflowExecutionInitiatedEventAttributes() bool {
	return v != nil && v.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes != nil
}

// GetRequestCancelExternalWorkflowExecutionFailedEventAttributes returns the value of RequestCancelExternalWorkflowExecutionFailedEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetRequestCancelExternalWorkflowExecutionFailedEventAttributes() (o *RequestCancelExternalWorkflowExecutionFailedEventAttributes) {
	if v != nil && v.RequestCancelExternalWorkflowExecutionFailedEventAttributes != nil {
		return v.RequestCancelExternalWorkflowExecutionFailedEventAttributes
	}

	return
}

// IsSetRequestCancelExternalWorkflowExecutionFailedEventAttributes returns true if RequestCancelExternalWorkflowExecutionFailedEventAttributes is not nil.
func (v *HistoryEvent) IsSetRequestCancelExternalWorkflowExecutionFailedEventAttributes() bool {
	return v != nil && v.RequestCancelExternalWorkflowExecutionFailedEventAttributes != nil
}

// GetExternalWorkflowExecutionCancelRequestedEventAttributes returns the value of ExternalWorkflowExecutionCancelRequestedEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetExternalWorkflowExecutionCancelRequestedEventAttributes() (o *ExternalWorkflowExecutionCancelRequestedEventAttributes) {
	if v != nil && v.ExternalWorkflowExecutionCancelRequestedEventAttributes != nil {
		return v.ExternalWorkflowExecutionCancelRequestedEventAttributes
	}

	return
}

// IsSetExternalWorkflowExecutionCancelRequestedEventAttributes returns true if ExternalWorkflowExecutionCancelRequestedEventAttributes is not nil.
func (v *HistoryEvent) IsSetExternalWorkflowExecutionCancelRequestedEventAttributes() bool {
	return v != nil && v.ExternalWorkflowExecutionCancelRequestedEventAttributes != nil
}

// GetWorkflowExecutionContinuedAsNewEventAttributes returns the value of WorkflowExecutionContinuedAsNewEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetWorkflowExecutionContinuedAsNewEventAttributes() (o *WorkflowExecutionContinuedAsNewEventAttributes) {
	if v != nil && v.WorkflowExecutionContinuedAsNewEventAttributes != nil {
		return v.WorkflowExecutionContinuedAsNewEventAttributes
	}

	return
}

// IsSetWorkflowExecutionContinuedAsNewEventAttributes returns true if WorkflowExecutionContinuedAsNewEventAttributes is not nil.
func (v *HistoryEvent) IsSetWorkflowExecutionContinuedAsNewEventAttributes() bool {
	return v != nil && v.WorkflowExecutionContinuedAsNewEventAttributes != nil
}

// GetStartChildWorkflowExecutionInitiatedEventAttributes returns the value of StartChildWorkflowExecutionInitiatedEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetStartChildWorkflowExecutionInitiatedEventAttributes() (o *StartChildWorkflowExecutionInitiatedEventAttributes) {
	if v != nil && v.StartChildWorkflowExecutionInitiatedEventAttributes != nil {
		return v.StartChildWorkflowExecutionInitiatedEventAttributes
	}

	return
}

// IsSetStartChildWorkflowExecutionInitiatedEventAttributes returns true if StartChildWorkflowExecutionInitiatedEventAttributes is not nil.
func (v *HistoryEvent) IsSetStartChildWorkflowExecutionInitiatedEventAttributes() bool {
	return v != nil && v.StartChildWorkflowExecutionInitiatedEventAttributes != nil
}

// GetStartChildWorkflowExecutionFailedEventAttributes returns the value of StartChildWorkflowExecutionFailedEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetStartChildWorkflowExecutionFailedEventAttributes() (o *StartChildWorkflowExecutionFailedEventAttributes) {
	if v != nil && v.StartChildWorkflowExecutionFailedEventAttributes != nil {
		return v.StartChildWorkflowExecutionFailedEventAttributes
	}

	return
}

// IsSetStartChildWorkflowExecutionFailedEventAttributes returns true if StartChildWorkflowExecutionFailedEventAttributes is not nil.
func (v *HistoryEvent) IsSetStartChildWorkflowExecutionFailedEventAttributes() bool {
	return v != nil && v.StartChildWorkflowExecutionFailedEventAttributes != nil
}

// GetChildWorkflowExecutionStartedEventAttributes returns the value of ChildWorkflowExecutionStartedEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetChildWorkflowExecutionStartedEventAttributes() (o *ChildWorkflowExecutionStartedEventAttributes) {
	if v != nil && v.ChildWorkflowExecutionStartedEventAttributes != nil {
		return v.ChildWorkflowExecutionStartedEventAttributes
	}

	return
}

// IsSetChildWorkflowExecutionStartedEventAttributes returns true if ChildWorkflowExecutionStartedEventAttributes is not nil.
func (v *HistoryEvent) IsSetChildWorkflowExecutionStartedEventAttributes() bool {
	return v != nil && v.ChildWorkflowExecutionStartedEventAttributes != nil
}

// GetChildWorkflowExecutionCompletedEventAttributes returns the value of ChildWorkflowExecutionCompletedEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetChildWorkflowExecutionCompletedEventAttributes() (o *ChildWorkflowExecutionCompletedEventAttributes) {
	if v != nil && v.ChildWorkflowExecutionCompletedEventAttributes != nil {
		return v.ChildWorkflowExecutionCompletedEventAttributes
	}

	return
}

// IsSetChildWorkflowExecutionCompletedEventAttributes returns true if ChildWorkflowExecutionCompletedEventAttributes is not nil.
func (v *HistoryEvent) IsSetChildWorkflowExecutionCompletedEventAttributes() bool {
	return v != nil && v.ChildWorkflowExecutionCompletedEventAttributes != nil
}

// GetChildWorkflowExecutionFailedEventAttributes returns the value of ChildWorkflowExecutionFailedEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetChildWorkflowExecutionFailedEventAttributes() (o *ChildWorkflowExecutionFailedEventAttributes) {
	if v != nil && v.ChildWorkflowExecutionFailedEventAttributes != nil {
		return v.ChildWorkflowExecutionFailedEventAttributes
	}

	return
}

// IsSetChildWorkflowExecutionFailedEventAttributes returns true if ChildWorkflowExecutionFailedEventAttributes is not nil.
func (v *HistoryEvent) IsSetChildWorkflowExecutionFailedEventAttributes() bool {
	return v != nil && v.ChildWorkflowExecutionFailedEventAttributes != nil
}

// GetChildWorkflowExecutionCanceledEventAttributes returns the value of ChildWorkflowExecutionCanceledEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetChildWorkflowExecutionCanceledEventAttributes() (o *ChildWorkflowExecutionCanceledEventAttributes) {
	if v != nil && v.ChildWorkflowExecutionCanceledEventAttributes != nil {
		return v.ChildWorkflowExecutionCanceledEventAttributes
	}

	return
}

// IsSetChildWorkflowExecutionCanceledEventAttributes returns true if ChildWorkflowExecutionCanceledEventAttributes is not nil.
func (v *HistoryEvent) IsSetChildWorkflowExecutionCanceledEventAttributes() bool {
	return v != nil && v.ChildWorkflowExecutionCanceledEventAttributes != nil
}

// GetChildWorkflowExecutionTimedOutEventAttributes returns the value of ChildWorkflowExecutionTimedOutEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetChildWorkflowExecutionTimedOutEventAttributes() (o *ChildWorkflowExecutionTimedOutEventAttributes) {
	if v != nil && v.ChildWorkflowExecutionTimedOutEventAttributes != nil {
		return v.ChildWorkflowExecutionTimedOutEventAttributes
	}

	return
}

// IsSetChildWorkflowExecutionTimedOutEventAttributes returns true if ChildWorkflowExecutionTimedOutEventAttributes is not nil.
func (v *HistoryEvent) IsSetChildWorkflowExecutionTimedOutEventAttributes() bool {
	return v != nil && v.ChildWorkflowExecutionTimedOutEventAttributes != nil
}

// GetChildWorkflowExecutionTerminatedEventAttributes returns the value of ChildWorkflowExecutionTerminatedEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetChildWorkflowExecutionTerminatedEventAttributes() (o *ChildWorkflowExecutionTerminatedEventAttributes) {
	if v != nil && v.ChildWorkflowExecutionTerminatedEventAttributes != nil {
		return v.ChildWorkflowExecutionTerminatedEventAttributes
	}

	return
}

// IsSetChildWorkflowExecutionTerminatedEventAttributes returns true if ChildWorkflowExecutionTerminatedEventAttributes is not nil.
func (v *HistoryEvent) IsSetChildWorkflowExecutionTerminatedEventAttributes() bool {
	return v != nil && v.ChildWorkflowExecutionTerminatedEventAttributes != nil
}

// GetSignalExternalWorkflowExecutionInitiatedEventAttributes returns the value of SignalExternalWorkflowExecutionInitiatedEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetSignalExternalWorkflowExecutionInitiatedEventAttributes() (o *SignalExternalWorkflowExecutionInitiatedEventAttributes) {
	if v != nil && v.SignalExternalWorkflowExecutionInitiatedEventAttributes != nil {
		return v.SignalExternalWorkflowExecutionInitiatedEventAttributes
	}

	return
}

// IsSetSignalExternalWorkflowExecutionInitiatedEventAttributes returns true if SignalExternalWorkflowExecutionInitiatedEventAttributes is not nil.
func (v *HistoryEvent) IsSetSignalExternalWorkflowExecutionInitiatedEventAttributes() bool {
	return v != nil && v.SignalExternalWorkflowExecutionInitiatedEventAttributes != nil
}

// GetSignalExternalWorkflowExecutionFailedEventAttributes returns the value of SignalExternalWorkflowExecutionFailedEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetSignalExternalWorkflowExecutionFailedEventAttributes() (o *SignalExternalWorkflowExecutionFailedEventAttributes) {
	if v != nil && v.SignalExternalWorkflowExecutionFailedEventAttributes != nil {
		return v.SignalExternalWorkflowExecutionFailedEventAttributes
	}

	return
}

// IsSetSignalExternalWorkflowExecutionFailedEventAttributes returns true if SignalExternalWorkflowExecutionFailedEventAttributes is not nil.
func (v *HistoryEvent) IsSetSignalExternalWorkflowExecutionFailedEventAttributes() bool {
	return v != nil && v.SignalExternalWorkflowExecutionFailedEventAttributes != nil
}

// GetExternalWorkflowExecutionSignaledEventAttributes returns the value of ExternalWorkflowExecutionSignaledEventAttributes if it is set or its
// zero value if it is unset.
func (v *HistoryEvent) GetExternalWorkflowExecutionSignaledEventAttributes() (o *ExternalWorkflowExecutionSignaledEventAttributes) {
	if v != nil && v.ExternalWorkflowExecutionSignaledEventAttributes != nil {
		return v.ExternalWorkflowExecutionSignaledEventAttributes
	}

	return
}

// IsSetExternalWorkflowExecutionSignaledEventAttributes returns true if ExternalWorkflowExecutionSignaledEventAttributes is not nil.
func (v *HistoryEvent) IsSetExternalWorkflowExecutionSignaledEventAttributes() bool {
	return v != nil && v.ExternalWorkflowExecutionSignaledEventAttributes != nil
}

type HistoryEventFilterType int32

const (
	HistoryEventFilterTypeAllEvent   HistoryEventFilterType = 0
	HistoryEventFilterTypeCloseEvent HistoryEventFilterType = 1
)

// HistoryEventFilterType_Values returns all recognized values of HistoryEventFilterType.
func HistoryEventFilterType_Values() []HistoryEventFilterType {
	return []HistoryEventFilterType{
		HistoryEventFilterTypeAllEvent,
		HistoryEventFilterTypeCloseEvent,
	}
}

// UnmarshalText tries to decode HistoryEventFilterType from a byte slice
// containing its name.
//
//   var v HistoryEventFilterType
//   err := v.UnmarshalText([]byte("ALL_EVENT"))
func (v *HistoryEventFilterType) UnmarshalText(value []byte) error {
	switch s := string(value); s {
	case "ALL_EVENT":
		*v = HistoryEventFilterTypeAllEvent
		return nil
	case "CLOSE_EVENT":
		*v = HistoryEventFilterTypeCloseEvent
		return nil
	default:
		val, err := strconv.ParseInt(s, 10, 32)
		if err != nil {
			return fmt.Errorf("unknown enum value %q for %q: %v", s, "HistoryEventFilterType", err)
		}
		*v = HistoryEventFilterType(val)
		return nil
	}
}

// MarshalText encodes HistoryEventFilterType to text.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements the TextMarshaler interface.
func (v HistoryEventFilterType) MarshalText() ([]byte, error) {
	switch int32(v) {
	case 0:
		return []byte("ALL_EVENT"), nil
	case 1:
		return []byte("CLOSE_EVENT"), nil
	}
	return []byte(strconv.FormatInt(int64(v), 10)), nil
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of HistoryEventFilterType.
// Enums are logged as objects, where the value is logged with key "value", and
// if this value's name is known, the name is logged with key "name".
func (v HistoryEventFilterType) MarshalLogObject(enc zapcore.ObjectEncoder) error {
	enc.AddInt32("value", int32(v))
	switch int32(v) {
	case 0:
		enc.AddString("name", "ALL_EVENT")
	case 1:
		enc.AddString("name", "CLOSE_EVENT")
	}
	return nil
}

// Ptr returns a pointer to this enum value.
func (v HistoryEventFilterType) Ptr() *HistoryEventFilterType {
	return &v
}

// ToWire translates HistoryEventFilterType into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// Enums are represented as 32-bit integers over the wire.
func (v HistoryEventFilterType) ToWire() (wire.Value, error) {
	return wire.NewValueI32(int32(v)), nil
}

// FromWire deserializes HistoryEventFilterType from its Thrift-level
// representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TI32)
//   if err != nil {
//     return HistoryEventFilterType(0), err
//   }
//
//   var v HistoryEventFilterType
//   if err := v.FromWire(x); err != nil {
//     return HistoryEventFilterType(0), err
//   }
//   return v, nil
func (v *HistoryEventFilterType) FromWire(w wire.Value) error {
	*v = (HistoryEventFilterType)(w.GetI32())
	return nil
}

// String returns a readable string representation of HistoryEventFilterType.
func (v HistoryEventFilterType) String() string {
	w := int32(v)
	switch w {
	case 0:
		return "ALL_EVENT"
	case 1:
		return "CLOSE_EVENT"
	}
	return fmt.Sprintf("HistoryEventFilterType(%d)", w)
}

// Equals returns true if this HistoryEventFilterType value matches the provided
// value.
func (v HistoryEventFilterType) Equals(rhs HistoryEventFilterType) bool {
	return v == rhs
}

// MarshalJSON serializes HistoryEventFilterType into JSON.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements json.Marshaler.
func (v HistoryEventFilterType) MarshalJSON() ([]byte, error) {
	switch int32(v) {
	case 0:
		return ([]byte)("\"ALL_EVENT\""), nil
	case 1:
		return ([]byte)("\"CLOSE_EVENT\""), nil
	}
	return ([]byte)(strconv.FormatInt(int64(v), 10)), nil
}

// UnmarshalJSON attempts to decode HistoryEventFilterType from its JSON
// representation.
//
// This implementation supports both, numeric and string inputs. If a
// string is provided, it must be a known enum name.
//
// This implements json.Unmarshaler.
func (v *HistoryEventFilterType) UnmarshalJSON(text []byte) error {
	d := json.NewDecoder(bytes.NewReader(text))
	d.UseNumber()
	t, err := d.Token()
	if err != nil {
		return err
	}

	switch w := t.(type) {
	case json.Number:
		x, err := w.Int64()
		if err != nil {
			return err
		}
		if x > math.MaxInt32 {
			return fmt.Errorf("enum overflow from JSON %q for %q", text, "HistoryEventFilterType")
		}
		if x < math.MinInt32 {
			return fmt.Errorf("enum underflow from JSON %q for %q", text, "HistoryEventFilterType")
		}
		*v = (HistoryEventFilterType)(x)
		return nil
	case string:
		return v.UnmarshalText([]byte(w))
	default:
		return fmt.Errorf("invalid JSON value %q (%T) to unmarshal into %q", t, t, "HistoryEventFilterType")
	}
}

type InternalServiceError struct {
	Message string `json:"message,required"`
}

// ToWire translates a InternalServiceError struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *InternalServiceError) ToWire() (wire.Value, error) {
	var (
		fields [1]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	w, err = wire.NewValueString(v.Message), error(nil)
	if err != nil {
		return w, err
	}
	fields[i] = wire.Field{ID: 1, Value: w}
	i++

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a InternalServiceError struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a InternalServiceError struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v InternalServiceError
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *InternalServiceError) FromWire(w wire.Value) error {
	var err error

	messageIsSet := false

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 1:
			if field.Value.Type() == wire.TBinary {
				v.Message, err = field.Value.GetString(), error(nil)
				if err != nil {
					return err
				}
				messageIsSet = true
			}
		}
	}

	if !messageIsSet {
		return errors.New("field Message of InternalServiceError is required")
	}

	return nil
}

// String returns a readable string representation of a InternalServiceError
// struct.
func (v *InternalServiceError) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [1]string
	i := 0
	fields[i] = fmt.Sprintf("Message: %v", v.Message)
	i++

	return fmt.Sprintf("InternalServiceError{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this InternalServiceError match the
// provided InternalServiceError.
//
// This function performs a deep comparison.
func (v *InternalServiceError) Equals(rhs *InternalServiceError) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !(v.Message == rhs.Message) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of InternalServiceError.
func (v *InternalServiceError) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	enc.AddString("message", v.Message)
	return err
}

// GetMessage returns the value of Message if it is set or its
// zero value if it is unset.
func (v *InternalServiceError) GetMessage() (o string) {
	if v != nil {
		o = v.Message
	}
	return
}

func (v *InternalServiceError) Error() string {
	return v.String()
}

type LimitExceededError struct {
	Message string `json:"message,required"`
}

// ToWire translates a LimitExceededError struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *LimitExceededError) ToWire() (wire.Value, error) {
	var (
		fields [1]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	w, err = wire.NewValueString(v.Message), error(nil)
	if err != nil {
		return w, err
	}
	fields[i] = wire.Field{ID: 1, Value: w}
	i++

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a LimitExceededError struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a LimitExceededError struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v LimitExceededError
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *LimitExceededError) FromWire(w wire.Value) error {
	var err error

	messageIsSet := false

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 1:
			if field.Value.Type() == wire.TBinary {
				v.Message, err = field.Value.GetString(), error(nil)
				if err != nil {
					return err
				}
				messageIsSet = true
			}
		}
	}

	if !messageIsSet {
		return errors.New("field Message of LimitExceededError is required")
	}

	return nil
}

// String returns a readable string representation of a LimitExceededError
// struct.
func (v *LimitExceededError) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [1]string
	i := 0
	fields[i] = fmt.Sprintf("Message: %v", v.Message)
	i++

	return fmt.Sprintf("LimitExceededError{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this LimitExceededError match the
// provided LimitExceededError.
//
// This function performs a deep comparison.
func (v *LimitExceededError) Equals(rhs *LimitExceededError) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !(v.Message == rhs.Message) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of LimitExceededError.
func (v *LimitExceededError) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	enc.AddString("message", v.Message)
	return err
}

// GetMessage returns the value of Message if it is set or its
// zero value if it is unset.
func (v *LimitExceededError) GetMessage() (o string) {
	if v != nil {
		o = v.Message
	}
	return
}

func (v *LimitExceededError) Error() string {
	return v.String()
}

type ListClosedWorkflowExecutionsRequest struct {
	Domain          *string                       `json:"domain,omitempty"`
	MaximumPageSize *int32                        `json:"maximumPageSize,omitempty"`
	NextPageToken   []byte                        `json:"nextPageToken,omitempty"`
	StartTimeFilter *StartTimeFilter              `json:"StartTimeFilter,omitempty"`
	ExecutionFilter *WorkflowExecutionFilter      `json:"executionFilter,omitempty"`
	TypeFilter      *WorkflowTypeFilter           `json:"typeFilter,omitempty"`
	StatusFilter    *WorkflowExecutionCloseStatus `json:"statusFilter,omitempty"`
}

// ToWire translates a ListClosedWorkflowExecutionsRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ListClosedWorkflowExecutionsRequest) ToWire() (wire.Value, error) {
	var (
		fields [7]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.MaximumPageSize != nil {
		w, err = wire.NewValueI32(*(v.MaximumPageSize)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.NextPageToken != nil {
		w, err = wire.NewValueBinary(v.NextPageToken), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.StartTimeFilter != nil {
		w, err = v.StartTimeFilter.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.ExecutionFilter != nil {
		w, err = v.ExecutionFilter.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.TypeFilter != nil {
		w, err = v.TypeFilter.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}
	if v.StatusFilter != nil {
		w, err = v.StatusFilter.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 70, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _StartTimeFilter_Read(w wire.Value) (*StartTimeFilter, error) {
	var v StartTimeFilter
	err := v.FromWire(w)
	return &v, err
}

func _WorkflowExecutionFilter_Read(w wire.Value) (*WorkflowExecutionFilter, error) {
	var v WorkflowExecutionFilter
	err := v.FromWire(w)
	return &v, err
}

func _WorkflowTypeFilter_Read(w wire.Value) (*WorkflowTypeFilter, error) {
	var v WorkflowTypeFilter
	err := v.FromWire(w)
	return &v, err
}

func _WorkflowExecutionCloseStatus_Read(w wire.Value) (WorkflowExecutionCloseStatus, error) {
	var v WorkflowExecutionCloseStatus
	err := v.FromWire(w)
	return v, err
}

// FromWire deserializes a ListClosedWorkflowExecutionsRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ListClosedWorkflowExecutionsRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ListClosedWorkflowExecutionsRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ListClosedWorkflowExecutionsRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.MaximumPageSize = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				v.NextPageToken, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TStruct {
				v.StartTimeFilter, err = _StartTimeFilter_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TStruct {
				v.ExecutionFilter, err = _WorkflowExecutionFilter_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TStruct {
				v.TypeFilter, err = _WorkflowTypeFilter_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 70:
			if field.Value.Type() == wire.TI32 {
				var x WorkflowExecutionCloseStatus
				x, err = _WorkflowExecutionCloseStatus_Read(field.Value)
				v.StatusFilter = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ListClosedWorkflowExecutionsRequest
// struct.
func (v *ListClosedWorkflowExecutionsRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [7]string
	i := 0
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.MaximumPageSize != nil {
		fields[i] = fmt.Sprintf("MaximumPageSize: %v", *(v.MaximumPageSize))
		i++
	}
	if v.NextPageToken != nil {
		fields[i] = fmt.Sprintf("NextPageToken: %v", v.NextPageToken)
		i++
	}
	if v.StartTimeFilter != nil {
		fields[i] = fmt.Sprintf("StartTimeFilter: %v", v.StartTimeFilter)
		i++
	}
	if v.ExecutionFilter != nil {
		fields[i] = fmt.Sprintf("ExecutionFilter: %v", v.ExecutionFilter)
		i++
	}
	if v.TypeFilter != nil {
		fields[i] = fmt.Sprintf("TypeFilter: %v", v.TypeFilter)
		i++
	}
	if v.StatusFilter != nil {
		fields[i] = fmt.Sprintf("StatusFilter: %v", *(v.StatusFilter))
		i++
	}

	return fmt.Sprintf("ListClosedWorkflowExecutionsRequest{%v}", strings.Join(fields[:i], ", "))
}

func _WorkflowExecutionCloseStatus_EqualsPtr(lhs, rhs *WorkflowExecutionCloseStatus) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return x.Equals(y)
	}
	return lhs == nil && rhs == nil
}

// Equals returns true if all the fields of this ListClosedWorkflowExecutionsRequest match the
// provided ListClosedWorkflowExecutionsRequest.
//
// This function performs a deep comparison.
func (v *ListClosedWorkflowExecutionsRequest) Equals(rhs *ListClosedWorkflowExecutionsRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !_I32_EqualsPtr(v.MaximumPageSize, rhs.MaximumPageSize) {
		return false
	}
	if !((v.NextPageToken == nil && rhs.NextPageToken == nil) || (v.NextPageToken != nil && rhs.NextPageToken != nil && bytes.Equal(v.NextPageToken, rhs.NextPageToken))) {
		return false
	}
	if !((v.StartTimeFilter == nil && rhs.StartTimeFilter == nil) || (v.StartTimeFilter != nil && rhs.StartTimeFilter != nil && v.StartTimeFilter.Equals(rhs.StartTimeFilter))) {
		return false
	}
	if !((v.ExecutionFilter == nil && rhs.ExecutionFilter == nil) || (v.ExecutionFilter != nil && rhs.ExecutionFilter != nil && v.ExecutionFilter.Equals(rhs.ExecutionFilter))) {
		return false
	}
	if !((v.TypeFilter == nil && rhs.TypeFilter == nil) || (v.TypeFilter != nil && rhs.TypeFilter != nil && v.TypeFilter.Equals(rhs.TypeFilter))) {
		return false
	}
	if !_WorkflowExecutionCloseStatus_EqualsPtr(v.StatusFilter, rhs.StatusFilter) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ListClosedWorkflowExecutionsRequest.
func (v *ListClosedWorkflowExecutionsRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.MaximumPageSize != nil {
		enc.AddInt32("maximumPageSize", *v.MaximumPageSize)
	}
	if v.NextPageToken != nil {
		enc.AddString("nextPageToken", base64.StdEncoding.EncodeToString(v.NextPageToken))
	}
	if v.StartTimeFilter != nil {
		err = multierr.Append(err, enc.AddObject("StartTimeFilter", v.StartTimeFilter))
	}
	if v.ExecutionFilter != nil {
		err = multierr.Append(err, enc.AddObject("executionFilter", v.ExecutionFilter))
	}
	if v.TypeFilter != nil {
		err = multierr.Append(err, enc.AddObject("typeFilter", v.TypeFilter))
	}
	if v.StatusFilter != nil {
		err = multierr.Append(err, enc.AddObject("statusFilter", *v.StatusFilter))
	}
	return err
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *ListClosedWorkflowExecutionsRequest) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *ListClosedWorkflowExecutionsRequest) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetMaximumPageSize returns the value of MaximumPageSize if it is set or its
// zero value if it is unset.
func (v *ListClosedWorkflowExecutionsRequest) GetMaximumPageSize() (o int32) {
	if v != nil && v.MaximumPageSize != nil {
		return *v.MaximumPageSize
	}

	return
}

// IsSetMaximumPageSize returns true if MaximumPageSize is not nil.
func (v *ListClosedWorkflowExecutionsRequest) IsSetMaximumPageSize() bool {
	return v != nil && v.MaximumPageSize != nil
}

// GetNextPageToken returns the value of NextPageToken if it is set or its
// zero value if it is unset.
func (v *ListClosedWorkflowExecutionsRequest) GetNextPageToken() (o []byte) {
	if v != nil && v.NextPageToken != nil {
		return v.NextPageToken
	}

	return
}

// IsSetNextPageToken returns true if NextPageToken is not nil.
func (v *ListClosedWorkflowExecutionsRequest) IsSetNextPageToken() bool {
	return v != nil && v.NextPageToken != nil
}

// GetStartTimeFilter returns the value of StartTimeFilter if it is set or its
// zero value if it is unset.
func (v *ListClosedWorkflowExecutionsRequest) GetStartTimeFilter() (o *StartTimeFilter) {
	if v != nil && v.StartTimeFilter != nil {
		return v.StartTimeFilter
	}

	return
}

// IsSetStartTimeFilter returns true if StartTimeFilter is not nil.
func (v *ListClosedWorkflowExecutionsRequest) IsSetStartTimeFilter() bool {
	return v != nil && v.StartTimeFilter != nil
}

// GetExecutionFilter returns the value of ExecutionFilter if it is set or its
// zero value if it is unset.
func (v *ListClosedWorkflowExecutionsRequest) GetExecutionFilter() (o *WorkflowExecutionFilter) {
	if v != nil && v.ExecutionFilter != nil {
		return v.ExecutionFilter
	}

	return
}

// IsSetExecutionFilter returns true if ExecutionFilter is not nil.
func (v *ListClosedWorkflowExecutionsRequest) IsSetExecutionFilter() bool {
	return v != nil && v.ExecutionFilter != nil
}

// GetTypeFilter returns the value of TypeFilter if it is set or its
// zero value if it is unset.
func (v *ListClosedWorkflowExecutionsRequest) GetTypeFilter() (o *WorkflowTypeFilter) {
	if v != nil && v.TypeFilter != nil {
		return v.TypeFilter
	}

	return
}

// IsSetTypeFilter returns true if TypeFilter is not nil.
func (v *ListClosedWorkflowExecutionsRequest) IsSetTypeFilter() bool {
	return v != nil && v.TypeFilter != nil
}

// GetStatusFilter returns the value of StatusFilter if it is set or its
// zero value if it is unset.
func (v *ListClosedWorkflowExecutionsRequest) GetStatusFilter() (o WorkflowExecutionCloseStatus) {
	if v != nil && v.StatusFilter != nil {
		return *v.StatusFilter
	}

	return
}

// IsSetStatusFilter returns true if StatusFilter is not nil.
func (v *ListClosedWorkflowExecutionsRequest) IsSetStatusFilter() bool {
	return v != nil && v.StatusFilter != nil
}

type ListClosedWorkflowExecutionsResponse struct {
	Executions    []*WorkflowExecutionInfo `json:"executions,omitempty"`
	NextPageToken []byte                   `json:"nextPageToken,omitempty"`
}

type _List_WorkflowExecutionInfo_ValueList []*WorkflowExecutionInfo

func (v _List_WorkflowExecutionInfo_ValueList) ForEach(f func(wire.Value) error) error {
	for i, x := range v {
		if x == nil {
			return fmt.Errorf("invalid [%v]: value is nil", i)
		}
		w, err := x.ToWire()
		if err != nil {
			return err
		}
		err = f(w)
		if err != nil {
			return err
		}
	}
	return nil
}

func (v _List_WorkflowExecutionInfo_ValueList) Size() int {
	return len(v)
}

func (_List_WorkflowExecutionInfo_ValueList) ValueType() wire.Type {
	return wire.TStruct
}

func (_List_WorkflowExecutionInfo_ValueList) Close() {}

// ToWire translates a ListClosedWorkflowExecutionsResponse struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ListClosedWorkflowExecutionsResponse) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Executions != nil {
		w, err = wire.NewValueList(_List_WorkflowExecutionInfo_ValueList(v.Executions)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.NextPageToken != nil {
		w, err = wire.NewValueBinary(v.NextPageToken), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _List_WorkflowExecutionInfo_Read(l wire.ValueList) ([]*WorkflowExecutionInfo, error) {
	if l.ValueType() != wire.TStruct {
		return nil, nil
	}

	o := make([]*WorkflowExecutionInfo, 0, l.Size())
	err := l.ForEach(func(x wire.Value) error {
		i, err := _WorkflowExecutionInfo_Read(x)
		if err != nil {
			return err
		}
		o = append(o, i)
		return nil
	})
	l.Close()
	return o, err
}

// FromWire deserializes a ListClosedWorkflowExecutionsResponse struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ListClosedWorkflowExecutionsResponse struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ListClosedWorkflowExecutionsResponse
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ListClosedWorkflowExecutionsResponse) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TList {
				v.Executions, err = _List_WorkflowExecutionInfo_Read(field.Value.GetList())
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				v.NextPageToken, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ListClosedWorkflowExecutionsResponse
// struct.
func (v *ListClosedWorkflowExecutionsResponse) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.Executions != nil {
		fields[i] = fmt.Sprintf("Executions: %v", v.Executions)
		i++
	}
	if v.NextPageToken != nil {
		fields[i] = fmt.Sprintf("NextPageToken: %v", v.NextPageToken)
		i++
	}

	return fmt.Sprintf("ListClosedWorkflowExecutionsResponse{%v}", strings.Join(fields[:i], ", "))
}

func _List_WorkflowExecutionInfo_Equals(lhs, rhs []*WorkflowExecutionInfo) bool {
	if len(lhs) != len(rhs) {
		return false
	}

	for i, lv := range lhs {
		rv := rhs[i]
		if !lv.Equals(rv) {
			return false
		}
	}

	return true
}

// Equals returns true if all the fields of this ListClosedWorkflowExecutionsResponse match the
// provided ListClosedWorkflowExecutionsResponse.
//
// This function performs a deep comparison.
func (v *ListClosedWorkflowExecutionsResponse) Equals(rhs *ListClosedWorkflowExecutionsResponse) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.Executions == nil && rhs.Executions == nil) || (v.Executions != nil && rhs.Executions != nil && _List_WorkflowExecutionInfo_Equals(v.Executions, rhs.Executions))) {
		return false
	}
	if !((v.NextPageToken == nil && rhs.NextPageToken == nil) || (v.NextPageToken != nil && rhs.NextPageToken != nil && bytes.Equal(v.NextPageToken, rhs.NextPageToken))) {
		return false
	}

	return true
}

type _List_WorkflowExecutionInfo_Zapper []*WorkflowExecutionInfo

// MarshalLogArray implements zapcore.ArrayMarshaler, enabling
// fast logging of _List_WorkflowExecutionInfo_Zapper.
func (l _List_WorkflowExecutionInfo_Zapper) MarshalLogArray(enc zapcore.ArrayEncoder) (err error) {
	for _, v := range l {
		err = multierr.Append(err, enc.AppendObject(v))
	}
	return err
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ListClosedWorkflowExecutionsResponse.
func (v *ListClosedWorkflowExecutionsResponse) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Executions != nil {
		err = multierr.Append(err, enc.AddArray("executions", (_List_WorkflowExecutionInfo_Zapper)(v.Executions)))
	}
	if v.NextPageToken != nil {
		enc.AddString("nextPageToken", base64.StdEncoding.EncodeToString(v.NextPageToken))
	}
	return err
}

// GetExecutions returns the value of Executions if it is set or its
// zero value if it is unset.
func (v *ListClosedWorkflowExecutionsResponse) GetExecutions() (o []*WorkflowExecutionInfo) {
	if v != nil && v.Executions != nil {
		return v.Executions
	}

	return
}

// IsSetExecutions returns true if Executions is not nil.
func (v *ListClosedWorkflowExecutionsResponse) IsSetExecutions() bool {
	return v != nil && v.Executions != nil
}

// GetNextPageToken returns the value of NextPageToken if it is set or its
// zero value if it is unset.
func (v *ListClosedWorkflowExecutionsResponse) GetNextPageToken() (o []byte) {
	if v != nil && v.NextPageToken != nil {
		return v.NextPageToken
	}

	return
}

// IsSetNextPageToken returns true if NextPageToken is not nil.
func (v *ListClosedWorkflowExecutionsResponse) IsSetNextPageToken() bool {
	return v != nil && v.NextPageToken != nil
}

type ListDomainsRequest struct {
	PageSize      *int32 `json:"pageSize,omitempty"`
	NextPageToken []byte `json:"nextPageToken,omitempty"`
}

// ToWire translates a ListDomainsRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ListDomainsRequest) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.PageSize != nil {
		w, err = wire.NewValueI32(*(v.PageSize)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.NextPageToken != nil {
		w, err = wire.NewValueBinary(v.NextPageToken), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ListDomainsRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ListDomainsRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ListDomainsRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ListDomainsRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.PageSize = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				v.NextPageToken, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ListDomainsRequest
// struct.
func (v *ListDomainsRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.PageSize != nil {
		fields[i] = fmt.Sprintf("PageSize: %v", *(v.PageSize))
		i++
	}
	if v.NextPageToken != nil {
		fields[i] = fmt.Sprintf("NextPageToken: %v", v.NextPageToken)
		i++
	}

	return fmt.Sprintf("ListDomainsRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ListDomainsRequest match the
// provided ListDomainsRequest.
//
// This function performs a deep comparison.
func (v *ListDomainsRequest) Equals(rhs *ListDomainsRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_I32_EqualsPtr(v.PageSize, rhs.PageSize) {
		return false
	}
	if !((v.NextPageToken == nil && rhs.NextPageToken == nil) || (v.NextPageToken != nil && rhs.NextPageToken != nil && bytes.Equal(v.NextPageToken, rhs.NextPageToken))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ListDomainsRequest.
func (v *ListDomainsRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.PageSize != nil {
		enc.AddInt32("pageSize", *v.PageSize)
	}
	if v.NextPageToken != nil {
		enc.AddString("nextPageToken", base64.StdEncoding.EncodeToString(v.NextPageToken))
	}
	return err
}

// GetPageSize returns the value of PageSize if it is set or its
// zero value if it is unset.
func (v *ListDomainsRequest) GetPageSize() (o int32) {
	if v != nil && v.PageSize != nil {
		return *v.PageSize
	}

	return
}

// IsSetPageSize returns true if PageSize is not nil.
func (v *ListDomainsRequest) IsSetPageSize() bool {
	return v != nil && v.PageSize != nil
}

// GetNextPageToken returns the value of NextPageToken if it is set or its
// zero value if it is unset.
func (v *ListDomainsRequest) GetNextPageToken() (o []byte) {
	if v != nil && v.NextPageToken != nil {
		return v.NextPageToken
	}

	return
}

// IsSetNextPageToken returns true if NextPageToken is not nil.
func (v *ListDomainsRequest) IsSetNextPageToken() bool {
	return v != nil && v.NextPageToken != nil
}

type ListDomainsResponse struct {
	Domains       []*DescribeDomainResponse `json:"domains,omitempty"`
	NextPageToken []byte                    `json:"nextPageToken,omitempty"`
}

type _List_DescribeDomainResponse_ValueList []*DescribeDomainResponse

func (v _List_DescribeDomainResponse_ValueList) ForEach(f func(wire.Value) error) error {
	for i, x := range v {
		if x == nil {
			return fmt.Errorf("invalid [%v]: value is nil", i)
		}
		w, err := x.ToWire()
		if err != nil {
			return err
		}
		err = f(w)
		if err != nil {
			return err
		}
	}
	return nil
}

func (v _List_DescribeDomainResponse_ValueList) Size() int {
	return len(v)
}

func (_List_DescribeDomainResponse_ValueList) ValueType() wire.Type {
	return wire.TStruct
}

func (_List_DescribeDomainResponse_ValueList) Close() {}

// ToWire translates a ListDomainsResponse struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ListDomainsResponse) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Domains != nil {
		w, err = wire.NewValueList(_List_DescribeDomainResponse_ValueList(v.Domains)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.NextPageToken != nil {
		w, err = wire.NewValueBinary(v.NextPageToken), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _DescribeDomainResponse_Read(w wire.Value) (*DescribeDomainResponse, error) {
	var v DescribeDomainResponse
	err := v.FromWire(w)
	return &v, err
}

func _List_DescribeDomainResponse_Read(l wire.ValueList) ([]*DescribeDomainResponse, error) {
	if l.ValueType() != wire.TStruct {
		return nil, nil
	}

	o := make([]*DescribeDomainResponse, 0, l.Size())
	err := l.ForEach(func(x wire.Value) error {
		i, err := _DescribeDomainResponse_Read(x)
		if err != nil {
			return err
		}
		o = append(o, i)
		return nil
	})
	l.Close()
	return o, err
}

// FromWire deserializes a ListDomainsResponse struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ListDomainsResponse struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ListDomainsResponse
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ListDomainsResponse) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TList {
				v.Domains, err = _List_DescribeDomainResponse_Read(field.Value.GetList())
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				v.NextPageToken, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ListDomainsResponse
// struct.
func (v *ListDomainsResponse) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.Domains != nil {
		fields[i] = fmt.Sprintf("Domains: %v", v.Domains)
		i++
	}
	if v.NextPageToken != nil {
		fields[i] = fmt.Sprintf("NextPageToken: %v", v.NextPageToken)
		i++
	}

	return fmt.Sprintf("ListDomainsResponse{%v}", strings.Join(fields[:i], ", "))
}

func _List_DescribeDomainResponse_Equals(lhs, rhs []*DescribeDomainResponse) bool {
	if len(lhs) != len(rhs) {
		return false
	}

	for i, lv := range lhs {
		rv := rhs[i]
		if !lv.Equals(rv) {
			return false
		}
	}

	return true
}

// Equals returns true if all the fields of this ListDomainsResponse match the
// provided ListDomainsResponse.
//
// This function performs a deep comparison.
func (v *ListDomainsResponse) Equals(rhs *ListDomainsResponse) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.Domains == nil && rhs.Domains == nil) || (v.Domains != nil && rhs.Domains != nil && _List_DescribeDomainResponse_Equals(v.Domains, rhs.Domains))) {
		return false
	}
	if !((v.NextPageToken == nil && rhs.NextPageToken == nil) || (v.NextPageToken != nil && rhs.NextPageToken != nil && bytes.Equal(v.NextPageToken, rhs.NextPageToken))) {
		return false
	}

	return true
}

type _List_DescribeDomainResponse_Zapper []*DescribeDomainResponse

// MarshalLogArray implements zapcore.ArrayMarshaler, enabling
// fast logging of _List_DescribeDomainResponse_Zapper.
func (l _List_DescribeDomainResponse_Zapper) MarshalLogArray(enc zapcore.ArrayEncoder) (err error) {
	for _, v := range l {
		err = multierr.Append(err, enc.AppendObject(v))
	}
	return err
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ListDomainsResponse.
func (v *ListDomainsResponse) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Domains != nil {
		err = multierr.Append(err, enc.AddArray("domains", (_List_DescribeDomainResponse_Zapper)(v.Domains)))
	}
	if v.NextPageToken != nil {
		enc.AddString("nextPageToken", base64.StdEncoding.EncodeToString(v.NextPageToken))
	}
	return err
}

// GetDomains returns the value of Domains if it is set or its
// zero value if it is unset.
func (v *ListDomainsResponse) GetDomains() (o []*DescribeDomainResponse) {
	if v != nil && v.Domains != nil {
		return v.Domains
	}

	return
}

// IsSetDomains returns true if Domains is not nil.
func (v *ListDomainsResponse) IsSetDomains() bool {
	return v != nil && v.Domains != nil
}

// GetNextPageToken returns the value of NextPageToken if it is set or its
// zero value if it is unset.
func (v *ListDomainsResponse) GetNextPageToken() (o []byte) {
	if v != nil && v.NextPageToken != nil {
		return v.NextPageToken
	}

	return
}

// IsSetNextPageToken returns true if NextPageToken is not nil.
func (v *ListDomainsResponse) IsSetNextPageToken() bool {
	return v != nil && v.NextPageToken != nil
}

type ListOpenWorkflowExecutionsRequest struct {
	Domain          *string                  `json:"domain,omitempty"`
	MaximumPageSize *int32                   `json:"maximumPageSize,omitempty"`
	NextPageToken   []byte                   `json:"nextPageToken,omitempty"`
	StartTimeFilter *StartTimeFilter         `json:"StartTimeFilter,omitempty"`
	ExecutionFilter *WorkflowExecutionFilter `json:"executionFilter,omitempty"`
	TypeFilter      *WorkflowTypeFilter      `json:"typeFilter,omitempty"`
}

// ToWire translates a ListOpenWorkflowExecutionsRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ListOpenWorkflowExecutionsRequest) ToWire() (wire.Value, error) {
	var (
		fields [6]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.MaximumPageSize != nil {
		w, err = wire.NewValueI32(*(v.MaximumPageSize)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.NextPageToken != nil {
		w, err = wire.NewValueBinary(v.NextPageToken), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.StartTimeFilter != nil {
		w, err = v.StartTimeFilter.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.ExecutionFilter != nil {
		w, err = v.ExecutionFilter.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.TypeFilter != nil {
		w, err = v.TypeFilter.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ListOpenWorkflowExecutionsRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ListOpenWorkflowExecutionsRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ListOpenWorkflowExecutionsRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ListOpenWorkflowExecutionsRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.MaximumPageSize = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				v.NextPageToken, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TStruct {
				v.StartTimeFilter, err = _StartTimeFilter_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TStruct {
				v.ExecutionFilter, err = _WorkflowExecutionFilter_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TStruct {
				v.TypeFilter, err = _WorkflowTypeFilter_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ListOpenWorkflowExecutionsRequest
// struct.
func (v *ListOpenWorkflowExecutionsRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [6]string
	i := 0
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.MaximumPageSize != nil {
		fields[i] = fmt.Sprintf("MaximumPageSize: %v", *(v.MaximumPageSize))
		i++
	}
	if v.NextPageToken != nil {
		fields[i] = fmt.Sprintf("NextPageToken: %v", v.NextPageToken)
		i++
	}
	if v.StartTimeFilter != nil {
		fields[i] = fmt.Sprintf("StartTimeFilter: %v", v.StartTimeFilter)
		i++
	}
	if v.ExecutionFilter != nil {
		fields[i] = fmt.Sprintf("ExecutionFilter: %v", v.ExecutionFilter)
		i++
	}
	if v.TypeFilter != nil {
		fields[i] = fmt.Sprintf("TypeFilter: %v", v.TypeFilter)
		i++
	}

	return fmt.Sprintf("ListOpenWorkflowExecutionsRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ListOpenWorkflowExecutionsRequest match the
// provided ListOpenWorkflowExecutionsRequest.
//
// This function performs a deep comparison.
func (v *ListOpenWorkflowExecutionsRequest) Equals(rhs *ListOpenWorkflowExecutionsRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !_I32_EqualsPtr(v.MaximumPageSize, rhs.MaximumPageSize) {
		return false
	}
	if !((v.NextPageToken == nil && rhs.NextPageToken == nil) || (v.NextPageToken != nil && rhs.NextPageToken != nil && bytes.Equal(v.NextPageToken, rhs.NextPageToken))) {
		return false
	}
	if !((v.StartTimeFilter == nil && rhs.StartTimeFilter == nil) || (v.StartTimeFilter != nil && rhs.StartTimeFilter != nil && v.StartTimeFilter.Equals(rhs.StartTimeFilter))) {
		return false
	}
	if !((v.ExecutionFilter == nil && rhs.ExecutionFilter == nil) || (v.ExecutionFilter != nil && rhs.ExecutionFilter != nil && v.ExecutionFilter.Equals(rhs.ExecutionFilter))) {
		return false
	}
	if !((v.TypeFilter == nil && rhs.TypeFilter == nil) || (v.TypeFilter != nil && rhs.TypeFilter != nil && v.TypeFilter.Equals(rhs.TypeFilter))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ListOpenWorkflowExecutionsRequest.
func (v *ListOpenWorkflowExecutionsRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.MaximumPageSize != nil {
		enc.AddInt32("maximumPageSize", *v.MaximumPageSize)
	}
	if v.NextPageToken != nil {
		enc.AddString("nextPageToken", base64.StdEncoding.EncodeToString(v.NextPageToken))
	}
	if v.StartTimeFilter != nil {
		err = multierr.Append(err, enc.AddObject("StartTimeFilter", v.StartTimeFilter))
	}
	if v.ExecutionFilter != nil {
		err = multierr.Append(err, enc.AddObject("executionFilter", v.ExecutionFilter))
	}
	if v.TypeFilter != nil {
		err = multierr.Append(err, enc.AddObject("typeFilter", v.TypeFilter))
	}
	return err
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *ListOpenWorkflowExecutionsRequest) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *ListOpenWorkflowExecutionsRequest) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetMaximumPageSize returns the value of MaximumPageSize if it is set or its
// zero value if it is unset.
func (v *ListOpenWorkflowExecutionsRequest) GetMaximumPageSize() (o int32) {
	if v != nil && v.MaximumPageSize != nil {
		return *v.MaximumPageSize
	}

	return
}

// IsSetMaximumPageSize returns true if MaximumPageSize is not nil.
func (v *ListOpenWorkflowExecutionsRequest) IsSetMaximumPageSize() bool {
	return v != nil && v.MaximumPageSize != nil
}

// GetNextPageToken returns the value of NextPageToken if it is set or its
// zero value if it is unset.
func (v *ListOpenWorkflowExecutionsRequest) GetNextPageToken() (o []byte) {
	if v != nil && v.NextPageToken != nil {
		return v.NextPageToken
	}

	return
}

// IsSetNextPageToken returns true if NextPageToken is not nil.
func (v *ListOpenWorkflowExecutionsRequest) IsSetNextPageToken() bool {
	return v != nil && v.NextPageToken != nil
}

// GetStartTimeFilter returns the value of StartTimeFilter if it is set or its
// zero value if it is unset.
func (v *ListOpenWorkflowExecutionsRequest) GetStartTimeFilter() (o *StartTimeFilter) {
	if v != nil && v.StartTimeFilter != nil {
		return v.StartTimeFilter
	}

	return
}

// IsSetStartTimeFilter returns true if StartTimeFilter is not nil.
func (v *ListOpenWorkflowExecutionsRequest) IsSetStartTimeFilter() bool {
	return v != nil && v.StartTimeFilter != nil
}

// GetExecutionFilter returns the value of ExecutionFilter if it is set or its
// zero value if it is unset.
func (v *ListOpenWorkflowExecutionsRequest) GetExecutionFilter() (o *WorkflowExecutionFilter) {
	if v != nil && v.ExecutionFilter != nil {
		return v.ExecutionFilter
	}

	return
}

// IsSetExecutionFilter returns true if ExecutionFilter is not nil.
func (v *ListOpenWorkflowExecutionsRequest) IsSetExecutionFilter() bool {
	return v != nil && v.ExecutionFilter != nil
}

// GetTypeFilter returns the value of TypeFilter if it is set or its
// zero value if it is unset.
func (v *ListOpenWorkflowExecutionsRequest) GetTypeFilter() (o *WorkflowTypeFilter) {
	if v != nil && v.TypeFilter != nil {
		return v.TypeFilter
	}

	return
}

// IsSetTypeFilter returns true if TypeFilter is not nil.
func (v *ListOpenWorkflowExecutionsRequest) IsSetTypeFilter() bool {
	return v != nil && v.TypeFilter != nil
}

type ListOpenWorkflowExecutionsResponse struct {
	Executions    []*WorkflowExecutionInfo `json:"executions,omitempty"`
	NextPageToken []byte                   `json:"nextPageToken,omitempty"`
}

// ToWire translates a ListOpenWorkflowExecutionsResponse struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ListOpenWorkflowExecutionsResponse) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Executions != nil {
		w, err = wire.NewValueList(_List_WorkflowExecutionInfo_ValueList(v.Executions)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.NextPageToken != nil {
		w, err = wire.NewValueBinary(v.NextPageToken), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ListOpenWorkflowExecutionsResponse struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ListOpenWorkflowExecutionsResponse struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ListOpenWorkflowExecutionsResponse
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ListOpenWorkflowExecutionsResponse) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TList {
				v.Executions, err = _List_WorkflowExecutionInfo_Read(field.Value.GetList())
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				v.NextPageToken, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ListOpenWorkflowExecutionsResponse
// struct.
func (v *ListOpenWorkflowExecutionsResponse) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.Executions != nil {
		fields[i] = fmt.Sprintf("Executions: %v", v.Executions)
		i++
	}
	if v.NextPageToken != nil {
		fields[i] = fmt.Sprintf("NextPageToken: %v", v.NextPageToken)
		i++
	}

	return fmt.Sprintf("ListOpenWorkflowExecutionsResponse{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ListOpenWorkflowExecutionsResponse match the
// provided ListOpenWorkflowExecutionsResponse.
//
// This function performs a deep comparison.
func (v *ListOpenWorkflowExecutionsResponse) Equals(rhs *ListOpenWorkflowExecutionsResponse) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.Executions == nil && rhs.Executions == nil) || (v.Executions != nil && rhs.Executions != nil && _List_WorkflowExecutionInfo_Equals(v.Executions, rhs.Executions))) {
		return false
	}
	if !((v.NextPageToken == nil && rhs.NextPageToken == nil) || (v.NextPageToken != nil && rhs.NextPageToken != nil && bytes.Equal(v.NextPageToken, rhs.NextPageToken))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ListOpenWorkflowExecutionsResponse.
func (v *ListOpenWorkflowExecutionsResponse) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Executions != nil {
		err = multierr.Append(err, enc.AddArray("executions", (_List_WorkflowExecutionInfo_Zapper)(v.Executions)))
	}
	if v.NextPageToken != nil {
		enc.AddString("nextPageToken", base64.StdEncoding.EncodeToString(v.NextPageToken))
	}
	return err
}

// GetExecutions returns the value of Executions if it is set or its
// zero value if it is unset.
func (v *ListOpenWorkflowExecutionsResponse) GetExecutions() (o []*WorkflowExecutionInfo) {
	if v != nil && v.Executions != nil {
		return v.Executions
	}

	return
}

// IsSetExecutions returns true if Executions is not nil.
func (v *ListOpenWorkflowExecutionsResponse) IsSetExecutions() bool {
	return v != nil && v.Executions != nil
}

// GetNextPageToken returns the value of NextPageToken if it is set or its
// zero value if it is unset.
func (v *ListOpenWorkflowExecutionsResponse) GetNextPageToken() (o []byte) {
	if v != nil && v.NextPageToken != nil {
		return v.NextPageToken
	}

	return
}

// IsSetNextPageToken returns true if NextPageToken is not nil.
func (v *ListOpenWorkflowExecutionsResponse) IsSetNextPageToken() bool {
	return v != nil && v.NextPageToken != nil
}

type ListWorkflowExecutionsRequest struct {
	Domain        *string `json:"domain,omitempty"`
	PageSize      *int32  `json:"pageSize,omitempty"`
	NextPageToken []byte  `json:"nextPageToken,omitempty"`
	Query         *string `json:"query,omitempty"`
}

// ToWire translates a ListWorkflowExecutionsRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ListWorkflowExecutionsRequest) ToWire() (wire.Value, error) {
	var (
		fields [4]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.PageSize != nil {
		w, err = wire.NewValueI32(*(v.PageSize)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.NextPageToken != nil {
		w, err = wire.NewValueBinary(v.NextPageToken), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.Query != nil {
		w, err = wire.NewValueString(*(v.Query)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ListWorkflowExecutionsRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ListWorkflowExecutionsRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ListWorkflowExecutionsRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ListWorkflowExecutionsRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.PageSize = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				v.NextPageToken, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Query = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ListWorkflowExecutionsRequest
// struct.
func (v *ListWorkflowExecutionsRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [4]string
	i := 0
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.PageSize != nil {
		fields[i] = fmt.Sprintf("PageSize: %v", *(v.PageSize))
		i++
	}
	if v.NextPageToken != nil {
		fields[i] = fmt.Sprintf("NextPageToken: %v", v.NextPageToken)
		i++
	}
	if v.Query != nil {
		fields[i] = fmt.Sprintf("Query: %v", *(v.Query))
		i++
	}

	return fmt.Sprintf("ListWorkflowExecutionsRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ListWorkflowExecutionsRequest match the
// provided ListWorkflowExecutionsRequest.
//
// This function performs a deep comparison.
func (v *ListWorkflowExecutionsRequest) Equals(rhs *ListWorkflowExecutionsRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !_I32_EqualsPtr(v.PageSize, rhs.PageSize) {
		return false
	}
	if !((v.NextPageToken == nil && rhs.NextPageToken == nil) || (v.NextPageToken != nil && rhs.NextPageToken != nil && bytes.Equal(v.NextPageToken, rhs.NextPageToken))) {
		return false
	}
	if !_String_EqualsPtr(v.Query, rhs.Query) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ListWorkflowExecutionsRequest.
func (v *ListWorkflowExecutionsRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.PageSize != nil {
		enc.AddInt32("pageSize", *v.PageSize)
	}
	if v.NextPageToken != nil {
		enc.AddString("nextPageToken", base64.StdEncoding.EncodeToString(v.NextPageToken))
	}
	if v.Query != nil {
		enc.AddString("query", *v.Query)
	}
	return err
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *ListWorkflowExecutionsRequest) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *ListWorkflowExecutionsRequest) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetPageSize returns the value of PageSize if it is set or its
// zero value if it is unset.
func (v *ListWorkflowExecutionsRequest) GetPageSize() (o int32) {
	if v != nil && v.PageSize != nil {
		return *v.PageSize
	}

	return
}

// IsSetPageSize returns true if PageSize is not nil.
func (v *ListWorkflowExecutionsRequest) IsSetPageSize() bool {
	return v != nil && v.PageSize != nil
}

// GetNextPageToken returns the value of NextPageToken if it is set or its
// zero value if it is unset.
func (v *ListWorkflowExecutionsRequest) GetNextPageToken() (o []byte) {
	if v != nil && v.NextPageToken != nil {
		return v.NextPageToken
	}

	return
}

// IsSetNextPageToken returns true if NextPageToken is not nil.
func (v *ListWorkflowExecutionsRequest) IsSetNextPageToken() bool {
	return v != nil && v.NextPageToken != nil
}

// GetQuery returns the value of Query if it is set or its
// zero value if it is unset.
func (v *ListWorkflowExecutionsRequest) GetQuery() (o string) {
	if v != nil && v.Query != nil {
		return *v.Query
	}

	return
}

// IsSetQuery returns true if Query is not nil.
func (v *ListWorkflowExecutionsRequest) IsSetQuery() bool {
	return v != nil && v.Query != nil
}

type ListWorkflowExecutionsResponse struct {
	Executions    []*WorkflowExecutionInfo `json:"executions,omitempty"`
	NextPageToken []byte                   `json:"nextPageToken,omitempty"`
}

// ToWire translates a ListWorkflowExecutionsResponse struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ListWorkflowExecutionsResponse) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Executions != nil {
		w, err = wire.NewValueList(_List_WorkflowExecutionInfo_ValueList(v.Executions)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.NextPageToken != nil {
		w, err = wire.NewValueBinary(v.NextPageToken), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ListWorkflowExecutionsResponse struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ListWorkflowExecutionsResponse struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ListWorkflowExecutionsResponse
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ListWorkflowExecutionsResponse) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TList {
				v.Executions, err = _List_WorkflowExecutionInfo_Read(field.Value.GetList())
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				v.NextPageToken, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ListWorkflowExecutionsResponse
// struct.
func (v *ListWorkflowExecutionsResponse) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.Executions != nil {
		fields[i] = fmt.Sprintf("Executions: %v", v.Executions)
		i++
	}
	if v.NextPageToken != nil {
		fields[i] = fmt.Sprintf("NextPageToken: %v", v.NextPageToken)
		i++
	}

	return fmt.Sprintf("ListWorkflowExecutionsResponse{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ListWorkflowExecutionsResponse match the
// provided ListWorkflowExecutionsResponse.
//
// This function performs a deep comparison.
func (v *ListWorkflowExecutionsResponse) Equals(rhs *ListWorkflowExecutionsResponse) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.Executions == nil && rhs.Executions == nil) || (v.Executions != nil && rhs.Executions != nil && _List_WorkflowExecutionInfo_Equals(v.Executions, rhs.Executions))) {
		return false
	}
	if !((v.NextPageToken == nil && rhs.NextPageToken == nil) || (v.NextPageToken != nil && rhs.NextPageToken != nil && bytes.Equal(v.NextPageToken, rhs.NextPageToken))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ListWorkflowExecutionsResponse.
func (v *ListWorkflowExecutionsResponse) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Executions != nil {
		err = multierr.Append(err, enc.AddArray("executions", (_List_WorkflowExecutionInfo_Zapper)(v.Executions)))
	}
	if v.NextPageToken != nil {
		enc.AddString("nextPageToken", base64.StdEncoding.EncodeToString(v.NextPageToken))
	}
	return err
}

// GetExecutions returns the value of Executions if it is set or its
// zero value if it is unset.
func (v *ListWorkflowExecutionsResponse) GetExecutions() (o []*WorkflowExecutionInfo) {
	if v != nil && v.Executions != nil {
		return v.Executions
	}

	return
}

// IsSetExecutions returns true if Executions is not nil.
func (v *ListWorkflowExecutionsResponse) IsSetExecutions() bool {
	return v != nil && v.Executions != nil
}

// GetNextPageToken returns the value of NextPageToken if it is set or its
// zero value if it is unset.
func (v *ListWorkflowExecutionsResponse) GetNextPageToken() (o []byte) {
	if v != nil && v.NextPageToken != nil {
		return v.NextPageToken
	}

	return
}

// IsSetNextPageToken returns true if NextPageToken is not nil.
func (v *ListWorkflowExecutionsResponse) IsSetNextPageToken() bool {
	return v != nil && v.NextPageToken != nil
}

type MarkerRecordedEventAttributes struct {
	MarkerName                   *string `json:"markerName,omitempty"`
	Details                      []byte  `json:"details,omitempty"`
	DecisionTaskCompletedEventId *int64  `json:"decisionTaskCompletedEventId,omitempty"`
	Header                       *Header `json:"header,omitempty"`
}

// ToWire translates a MarkerRecordedEventAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *MarkerRecordedEventAttributes) ToWire() (wire.Value, error) {
	var (
		fields [4]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.MarkerName != nil {
		w, err = wire.NewValueString(*(v.MarkerName)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Details != nil {
		w, err = wire.NewValueBinary(v.Details), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.DecisionTaskCompletedEventId != nil {
		w, err = wire.NewValueI64(*(v.DecisionTaskCompletedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.Header != nil {
		w, err = v.Header.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a MarkerRecordedEventAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a MarkerRecordedEventAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v MarkerRecordedEventAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *MarkerRecordedEventAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.MarkerName = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				v.Details, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.DecisionTaskCompletedEventId = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TStruct {
				v.Header, err = _Header_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a MarkerRecordedEventAttributes
// struct.
func (v *MarkerRecordedEventAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [4]string
	i := 0
	if v.MarkerName != nil {
		fields[i] = fmt.Sprintf("MarkerName: %v", *(v.MarkerName))
		i++
	}
	if v.Details != nil {
		fields[i] = fmt.Sprintf("Details: %v", v.Details)
		i++
	}
	if v.DecisionTaskCompletedEventId != nil {
		fields[i] = fmt.Sprintf("DecisionTaskCompletedEventId: %v", *(v.DecisionTaskCompletedEventId))
		i++
	}
	if v.Header != nil {
		fields[i] = fmt.Sprintf("Header: %v", v.Header)
		i++
	}

	return fmt.Sprintf("MarkerRecordedEventAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this MarkerRecordedEventAttributes match the
// provided MarkerRecordedEventAttributes.
//
// This function performs a deep comparison.
func (v *MarkerRecordedEventAttributes) Equals(rhs *MarkerRecordedEventAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.MarkerName, rhs.MarkerName) {
		return false
	}
	if !((v.Details == nil && rhs.Details == nil) || (v.Details != nil && rhs.Details != nil && bytes.Equal(v.Details, rhs.Details))) {
		return false
	}
	if !_I64_EqualsPtr(v.DecisionTaskCompletedEventId, rhs.DecisionTaskCompletedEventId) {
		return false
	}
	if !((v.Header == nil && rhs.Header == nil) || (v.Header != nil && rhs.Header != nil && v.Header.Equals(rhs.Header))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of MarkerRecordedEventAttributes.
func (v *MarkerRecordedEventAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.MarkerName != nil {
		enc.AddString("markerName", *v.MarkerName)
	}
	if v.Details != nil {
		enc.AddString("details", base64.StdEncoding.EncodeToString(v.Details))
	}
	if v.DecisionTaskCompletedEventId != nil {
		enc.AddInt64("decisionTaskCompletedEventId", *v.DecisionTaskCompletedEventId)
	}
	if v.Header != nil {
		err = multierr.Append(err, enc.AddObject("header", v.Header))
	}
	return err
}

// GetMarkerName returns the value of MarkerName if it is set or its
// zero value if it is unset.
func (v *MarkerRecordedEventAttributes) GetMarkerName() (o string) {
	if v != nil && v.MarkerName != nil {
		return *v.MarkerName
	}

	return
}

// IsSetMarkerName returns true if MarkerName is not nil.
func (v *MarkerRecordedEventAttributes) IsSetMarkerName() bool {
	return v != nil && v.MarkerName != nil
}

// GetDetails returns the value of Details if it is set or its
// zero value if it is unset.
func (v *MarkerRecordedEventAttributes) GetDetails() (o []byte) {
	if v != nil && v.Details != nil {
		return v.Details
	}

	return
}

// IsSetDetails returns true if Details is not nil.
func (v *MarkerRecordedEventAttributes) IsSetDetails() bool {
	return v != nil && v.Details != nil
}

// GetDecisionTaskCompletedEventId returns the value of DecisionTaskCompletedEventId if it is set or its
// zero value if it is unset.
func (v *MarkerRecordedEventAttributes) GetDecisionTaskCompletedEventId() (o int64) {
	if v != nil && v.DecisionTaskCompletedEventId != nil {
		return *v.DecisionTaskCompletedEventId
	}

	return
}

// IsSetDecisionTaskCompletedEventId returns true if DecisionTaskCompletedEventId is not nil.
func (v *MarkerRecordedEventAttributes) IsSetDecisionTaskCompletedEventId() bool {
	return v != nil && v.DecisionTaskCompletedEventId != nil
}

// GetHeader returns the value of Header if it is set or its
// zero value if it is unset.
func (v *MarkerRecordedEventAttributes) GetHeader() (o *Header) {
	if v != nil && v.Header != nil {
		return v.Header
	}

	return
}

// IsSetHeader returns true if Header is not nil.
func (v *MarkerRecordedEventAttributes) IsSetHeader() bool {
	return v != nil && v.Header != nil
}

type Memo struct {
	Fields map[string][]byte `json:"fields,omitempty"`
}

// ToWire translates a Memo struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *Memo) ToWire() (wire.Value, error) {
	var (
		fields [1]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Fields != nil {
		w, err = wire.NewValueMap(_Map_String_Binary_MapItemList(v.Fields)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a Memo struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a Memo struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v Memo
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *Memo) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TMap {
				v.Fields, err = _Map_String_Binary_Read(field.Value.GetMap())
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a Memo
// struct.
func (v *Memo) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [1]string
	i := 0
	if v.Fields != nil {
		fields[i] = fmt.Sprintf("Fields: %v", v.Fields)
		i++
	}

	return fmt.Sprintf("Memo{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this Memo match the
// provided Memo.
//
// This function performs a deep comparison.
func (v *Memo) Equals(rhs *Memo) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.Fields == nil && rhs.Fields == nil) || (v.Fields != nil && rhs.Fields != nil && _Map_String_Binary_Equals(v.Fields, rhs.Fields))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of Memo.
func (v *Memo) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Fields != nil {
		err = multierr.Append(err, enc.AddObject("fields", (_Map_String_Binary_Zapper)(v.Fields)))
	}
	return err
}

// GetFields returns the value of Fields if it is set or its
// zero value if it is unset.
func (v *Memo) GetFields() (o map[string][]byte) {
	if v != nil && v.Fields != nil {
		return v.Fields
	}

	return
}

// IsSetFields returns true if Fields is not nil.
func (v *Memo) IsSetFields() bool {
	return v != nil && v.Fields != nil
}

type PendingActivityInfo struct {
	ActivityID             *string               `json:"activityID,omitempty"`
	ActivityType           *ActivityType         `json:"activityType,omitempty"`
	State                  *PendingActivityState `json:"state,omitempty"`
	HeartbeatDetails       []byte                `json:"heartbeatDetails,omitempty"`
	LastHeartbeatTimestamp *int64                `json:"lastHeartbeatTimestamp,omitempty"`
	LastStartedTimestamp   *int64                `json:"lastStartedTimestamp,omitempty"`
	Attempt                *int32                `json:"attempt,omitempty"`
	MaximumAttempts        *int32                `json:"maximumAttempts,omitempty"`
	ScheduledTimestamp     *int64                `json:"scheduledTimestamp,omitempty"`
	ExpirationTimestamp    *int64                `json:"expirationTimestamp,omitempty"`
}

// ToWire translates a PendingActivityInfo struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *PendingActivityInfo) ToWire() (wire.Value, error) {
	var (
		fields [10]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.ActivityID != nil {
		w, err = wire.NewValueString(*(v.ActivityID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.ActivityType != nil {
		w, err = v.ActivityType.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.State != nil {
		w, err = v.State.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.HeartbeatDetails != nil {
		w, err = wire.NewValueBinary(v.HeartbeatDetails), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.LastHeartbeatTimestamp != nil {
		w, err = wire.NewValueI64(*(v.LastHeartbeatTimestamp)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.LastStartedTimestamp != nil {
		w, err = wire.NewValueI64(*(v.LastStartedTimestamp)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}
	if v.Attempt != nil {
		w, err = wire.NewValueI32(*(v.Attempt)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 70, Value: w}
		i++
	}
	if v.MaximumAttempts != nil {
		w, err = wire.NewValueI32(*(v.MaximumAttempts)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 80, Value: w}
		i++
	}
	if v.ScheduledTimestamp != nil {
		w, err = wire.NewValueI64(*(v.ScheduledTimestamp)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 90, Value: w}
		i++
	}
	if v.ExpirationTimestamp != nil {
		w, err = wire.NewValueI64(*(v.ExpirationTimestamp)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 100, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _PendingActivityState_Read(w wire.Value) (PendingActivityState, error) {
	var v PendingActivityState
	err := v.FromWire(w)
	return v, err
}

// FromWire deserializes a PendingActivityInfo struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a PendingActivityInfo struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v PendingActivityInfo
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *PendingActivityInfo) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ActivityID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.ActivityType, err = _ActivityType_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI32 {
				var x PendingActivityState
				x, err = _PendingActivityState_Read(field.Value)
				v.State = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBinary {
				v.HeartbeatDetails, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.LastHeartbeatTimestamp = &x
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.LastStartedTimestamp = &x
				if err != nil {
					return err
				}

			}
		case 70:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.Attempt = &x
				if err != nil {
					return err
				}

			}
		case 80:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.MaximumAttempts = &x
				if err != nil {
					return err
				}

			}
		case 90:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduledTimestamp = &x
				if err != nil {
					return err
				}

			}
		case 100:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ExpirationTimestamp = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a PendingActivityInfo
// struct.
func (v *PendingActivityInfo) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [10]string
	i := 0
	if v.ActivityID != nil {
		fields[i] = fmt.Sprintf("ActivityID: %v", *(v.ActivityID))
		i++
	}
	if v.ActivityType != nil {
		fields[i] = fmt.Sprintf("ActivityType: %v", v.ActivityType)
		i++
	}
	if v.State != nil {
		fields[i] = fmt.Sprintf("State: %v", *(v.State))
		i++
	}
	if v.HeartbeatDetails != nil {
		fields[i] = fmt.Sprintf("HeartbeatDetails: %v", v.HeartbeatDetails)
		i++
	}
	if v.LastHeartbeatTimestamp != nil {
		fields[i] = fmt.Sprintf("LastHeartbeatTimestamp: %v", *(v.LastHeartbeatTimestamp))
		i++
	}
	if v.LastStartedTimestamp != nil {
		fields[i] = fmt.Sprintf("LastStartedTimestamp: %v", *(v.LastStartedTimestamp))
		i++
	}
	if v.Attempt != nil {
		fields[i] = fmt.Sprintf("Attempt: %v", *(v.Attempt))
		i++
	}
	if v.MaximumAttempts != nil {
		fields[i] = fmt.Sprintf("MaximumAttempts: %v", *(v.MaximumAttempts))
		i++
	}
	if v.ScheduledTimestamp != nil {
		fields[i] = fmt.Sprintf("ScheduledTimestamp: %v", *(v.ScheduledTimestamp))
		i++
	}
	if v.ExpirationTimestamp != nil {
		fields[i] = fmt.Sprintf("ExpirationTimestamp: %v", *(v.ExpirationTimestamp))
		i++
	}

	return fmt.Sprintf("PendingActivityInfo{%v}", strings.Join(fields[:i], ", "))
}

func _PendingActivityState_EqualsPtr(lhs, rhs *PendingActivityState) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return x.Equals(y)
	}
	return lhs == nil && rhs == nil
}

// Equals returns true if all the fields of this PendingActivityInfo match the
// provided PendingActivityInfo.
//
// This function performs a deep comparison.
func (v *PendingActivityInfo) Equals(rhs *PendingActivityInfo) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.ActivityID, rhs.ActivityID) {
		return false
	}
	if !((v.ActivityType == nil && rhs.ActivityType == nil) || (v.ActivityType != nil && rhs.ActivityType != nil && v.ActivityType.Equals(rhs.ActivityType))) {
		return false
	}
	if !_PendingActivityState_EqualsPtr(v.State, rhs.State) {
		return false
	}
	if !((v.HeartbeatDetails == nil && rhs.HeartbeatDetails == nil) || (v.HeartbeatDetails != nil && rhs.HeartbeatDetails != nil && bytes.Equal(v.HeartbeatDetails, rhs.HeartbeatDetails))) {
		return false
	}
	if !_I64_EqualsPtr(v.LastHeartbeatTimestamp, rhs.LastHeartbeatTimestamp) {
		return false
	}
	if !_I64_EqualsPtr(v.LastStartedTimestamp, rhs.LastStartedTimestamp) {
		return false
	}
	if !_I32_EqualsPtr(v.Attempt, rhs.Attempt) {
		return false
	}
	if !_I32_EqualsPtr(v.MaximumAttempts, rhs.MaximumAttempts) {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduledTimestamp, rhs.ScheduledTimestamp) {
		return false
	}
	if !_I64_EqualsPtr(v.ExpirationTimestamp, rhs.ExpirationTimestamp) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of PendingActivityInfo.
func (v *PendingActivityInfo) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.ActivityID != nil {
		enc.AddString("activityID", *v.ActivityID)
	}
	if v.ActivityType != nil {
		err = multierr.Append(err, enc.AddObject("activityType", v.ActivityType))
	}
	if v.State != nil {
		err = multierr.Append(err, enc.AddObject("state", *v.State))
	}
	if v.HeartbeatDetails != nil {
		enc.AddString("heartbeatDetails", base64.StdEncoding.EncodeToString(v.HeartbeatDetails))
	}
	if v.LastHeartbeatTimestamp != nil {
		enc.AddInt64("lastHeartbeatTimestamp", *v.LastHeartbeatTimestamp)
	}
	if v.LastStartedTimestamp != nil {
		enc.AddInt64("lastStartedTimestamp", *v.LastStartedTimestamp)
	}
	if v.Attempt != nil {
		enc.AddInt32("attempt", *v.Attempt)
	}
	if v.MaximumAttempts != nil {
		enc.AddInt32("maximumAttempts", *v.MaximumAttempts)
	}
	if v.ScheduledTimestamp != nil {
		enc.AddInt64("scheduledTimestamp", *v.ScheduledTimestamp)
	}
	if v.ExpirationTimestamp != nil {
		enc.AddInt64("expirationTimestamp", *v.ExpirationTimestamp)
	}
	return err
}

// GetActivityID returns the value of ActivityID if it is set or its
// zero value if it is unset.
func (v *PendingActivityInfo) GetActivityID() (o string) {
	if v != nil && v.ActivityID != nil {
		return *v.ActivityID
	}

	return
}

// IsSetActivityID returns true if ActivityID is not nil.
func (v *PendingActivityInfo) IsSetActivityID() bool {
	return v != nil && v.ActivityID != nil
}

// GetActivityType returns the value of ActivityType if it is set or its
// zero value if it is unset.
func (v *PendingActivityInfo) GetActivityType() (o *ActivityType) {
	if v != nil && v.ActivityType != nil {
		return v.ActivityType
	}

	return
}

// IsSetActivityType returns true if ActivityType is not nil.
func (v *PendingActivityInfo) IsSetActivityType() bool {
	return v != nil && v.ActivityType != nil
}

// GetState returns the value of State if it is set or its
// zero value if it is unset.
func (v *PendingActivityInfo) GetState() (o PendingActivityState) {
	if v != nil && v.State != nil {
		return *v.State
	}

	return
}

// IsSetState returns true if State is not nil.
func (v *PendingActivityInfo) IsSetState() bool {
	return v != nil && v.State != nil
}

// GetHeartbeatDetails returns the value of HeartbeatDetails if it is set or its
// zero value if it is unset.
func (v *PendingActivityInfo) GetHeartbeatDetails() (o []byte) {
	if v != nil && v.HeartbeatDetails != nil {
		return v.HeartbeatDetails
	}

	return
}

// IsSetHeartbeatDetails returns true if HeartbeatDetails is not nil.
func (v *PendingActivityInfo) IsSetHeartbeatDetails() bool {
	return v != nil && v.HeartbeatDetails != nil
}

// GetLastHeartbeatTimestamp returns the value of LastHeartbeatTimestamp if it is set or its
// zero value if it is unset.
func (v *PendingActivityInfo) GetLastHeartbeatTimestamp() (o int64) {
	if v != nil && v.LastHeartbeatTimestamp != nil {
		return *v.LastHeartbeatTimestamp
	}

	return
}

// IsSetLastHeartbeatTimestamp returns true if LastHeartbeatTimestamp is not nil.
func (v *PendingActivityInfo) IsSetLastHeartbeatTimestamp() bool {
	return v != nil && v.LastHeartbeatTimestamp != nil
}

// GetLastStartedTimestamp returns the value of LastStartedTimestamp if it is set or its
// zero value if it is unset.
func (v *PendingActivityInfo) GetLastStartedTimestamp() (o int64) {
	if v != nil && v.LastStartedTimestamp != nil {
		return *v.LastStartedTimestamp
	}

	return
}

// IsSetLastStartedTimestamp returns true if LastStartedTimestamp is not nil.
func (v *PendingActivityInfo) IsSetLastStartedTimestamp() bool {
	return v != nil && v.LastStartedTimestamp != nil
}

// GetAttempt returns the value of Attempt if it is set or its
// zero value if it is unset.
func (v *PendingActivityInfo) GetAttempt() (o int32) {
	if v != nil && v.Attempt != nil {
		return *v.Attempt
	}

	return
}

// IsSetAttempt returns true if Attempt is not nil.
func (v *PendingActivityInfo) IsSetAttempt() bool {
	return v != nil && v.Attempt != nil
}

// GetMaximumAttempts returns the value of MaximumAttempts if it is set or its
// zero value if it is unset.
func (v *PendingActivityInfo) GetMaximumAttempts() (o int32) {
	if v != nil && v.MaximumAttempts != nil {
		return *v.MaximumAttempts
	}

	return
}

// IsSetMaximumAttempts returns true if MaximumAttempts is not nil.
func (v *PendingActivityInfo) IsSetMaximumAttempts() bool {
	return v != nil && v.MaximumAttempts != nil
}

// GetScheduledTimestamp returns the value of ScheduledTimestamp if it is set or its
// zero value if it is unset.
func (v *PendingActivityInfo) GetScheduledTimestamp() (o int64) {
	if v != nil && v.ScheduledTimestamp != nil {
		return *v.ScheduledTimestamp
	}

	return
}

// IsSetScheduledTimestamp returns true if ScheduledTimestamp is not nil.
func (v *PendingActivityInfo) IsSetScheduledTimestamp() bool {
	return v != nil && v.ScheduledTimestamp != nil
}

// GetExpirationTimestamp returns the value of ExpirationTimestamp if it is set or its
// zero value if it is unset.
func (v *PendingActivityInfo) GetExpirationTimestamp() (o int64) {
	if v != nil && v.ExpirationTimestamp != nil {
		return *v.ExpirationTimestamp
	}

	return
}

// IsSetExpirationTimestamp returns true if ExpirationTimestamp is not nil.
func (v *PendingActivityInfo) IsSetExpirationTimestamp() bool {
	return v != nil && v.ExpirationTimestamp != nil
}

type PendingActivityState int32

const (
	PendingActivityStateScheduled       PendingActivityState = 0
	PendingActivityStateStarted         PendingActivityState = 1
	PendingActivityStateCancelRequested PendingActivityState = 2
)

// PendingActivityState_Values returns all recognized values of PendingActivityState.
func PendingActivityState_Values() []PendingActivityState {
	return []PendingActivityState{
		PendingActivityStateScheduled,
		PendingActivityStateStarted,
		PendingActivityStateCancelRequested,
	}
}

// UnmarshalText tries to decode PendingActivityState from a byte slice
// containing its name.
//
//   var v PendingActivityState
//   err := v.UnmarshalText([]byte("SCHEDULED"))
func (v *PendingActivityState) UnmarshalText(value []byte) error {
	switch s := string(value); s {
	case "SCHEDULED":
		*v = PendingActivityStateScheduled
		return nil
	case "STARTED":
		*v = PendingActivityStateStarted
		return nil
	case "CANCEL_REQUESTED":
		*v = PendingActivityStateCancelRequested
		return nil
	default:
		val, err := strconv.ParseInt(s, 10, 32)
		if err != nil {
			return fmt.Errorf("unknown enum value %q for %q: %v", s, "PendingActivityState", err)
		}
		*v = PendingActivityState(val)
		return nil
	}
}

// MarshalText encodes PendingActivityState to text.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements the TextMarshaler interface.
func (v PendingActivityState) MarshalText() ([]byte, error) {
	switch int32(v) {
	case 0:
		return []byte("SCHEDULED"), nil
	case 1:
		return []byte("STARTED"), nil
	case 2:
		return []byte("CANCEL_REQUESTED"), nil
	}
	return []byte(strconv.FormatInt(int64(v), 10)), nil
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of PendingActivityState.
// Enums are logged as objects, where the value is logged with key "value", and
// if this value's name is known, the name is logged with key "name".
func (v PendingActivityState) MarshalLogObject(enc zapcore.ObjectEncoder) error {
	enc.AddInt32("value", int32(v))
	switch int32(v) {
	case 0:
		enc.AddString("name", "SCHEDULED")
	case 1:
		enc.AddString("name", "STARTED")
	case 2:
		enc.AddString("name", "CANCEL_REQUESTED")
	}
	return nil
}

// Ptr returns a pointer to this enum value.
func (v PendingActivityState) Ptr() *PendingActivityState {
	return &v
}

// ToWire translates PendingActivityState into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// Enums are represented as 32-bit integers over the wire.
func (v PendingActivityState) ToWire() (wire.Value, error) {
	return wire.NewValueI32(int32(v)), nil
}

// FromWire deserializes PendingActivityState from its Thrift-level
// representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TI32)
//   if err != nil {
//     return PendingActivityState(0), err
//   }
//
//   var v PendingActivityState
//   if err := v.FromWire(x); err != nil {
//     return PendingActivityState(0), err
//   }
//   return v, nil
func (v *PendingActivityState) FromWire(w wire.Value) error {
	*v = (PendingActivityState)(w.GetI32())
	return nil
}

// String returns a readable string representation of PendingActivityState.
func (v PendingActivityState) String() string {
	w := int32(v)
	switch w {
	case 0:
		return "SCHEDULED"
	case 1:
		return "STARTED"
	case 2:
		return "CANCEL_REQUESTED"
	}
	return fmt.Sprintf("PendingActivityState(%d)", w)
}

// Equals returns true if this PendingActivityState value matches the provided
// value.
func (v PendingActivityState) Equals(rhs PendingActivityState) bool {
	return v == rhs
}

// MarshalJSON serializes PendingActivityState into JSON.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements json.Marshaler.
func (v PendingActivityState) MarshalJSON() ([]byte, error) {
	switch int32(v) {
	case 0:
		return ([]byte)("\"SCHEDULED\""), nil
	case 1:
		return ([]byte)("\"STARTED\""), nil
	case 2:
		return ([]byte)("\"CANCEL_REQUESTED\""), nil
	}
	return ([]byte)(strconv.FormatInt(int64(v), 10)), nil
}

// UnmarshalJSON attempts to decode PendingActivityState from its JSON
// representation.
//
// This implementation supports both, numeric and string inputs. If a
// string is provided, it must be a known enum name.
//
// This implements json.Unmarshaler.
func (v *PendingActivityState) UnmarshalJSON(text []byte) error {
	d := json.NewDecoder(bytes.NewReader(text))
	d.UseNumber()
	t, err := d.Token()
	if err != nil {
		return err
	}

	switch w := t.(type) {
	case json.Number:
		x, err := w.Int64()
		if err != nil {
			return err
		}
		if x > math.MaxInt32 {
			return fmt.Errorf("enum overflow from JSON %q for %q", text, "PendingActivityState")
		}
		if x < math.MinInt32 {
			return fmt.Errorf("enum underflow from JSON %q for %q", text, "PendingActivityState")
		}
		*v = (PendingActivityState)(x)
		return nil
	case string:
		return v.UnmarshalText([]byte(w))
	default:
		return fmt.Errorf("invalid JSON value %q (%T) to unmarshal into %q", t, t, "PendingActivityState")
	}
}

type PollForActivityTaskRequest struct {
	Domain           *string           `json:"domain,omitempty"`
	TaskList         *TaskList         `json:"taskList,omitempty"`
	Identity         *string           `json:"identity,omitempty"`
	TaskListMetadata *TaskListMetadata `json:"taskListMetadata,omitempty"`
}

// ToWire translates a PollForActivityTaskRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *PollForActivityTaskRequest) ToWire() (wire.Value, error) {
	var (
		fields [4]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.TaskList != nil {
		w, err = v.TaskList.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.Identity != nil {
		w, err = wire.NewValueString(*(v.Identity)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.TaskListMetadata != nil {
		w, err = v.TaskListMetadata.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _TaskListMetadata_Read(w wire.Value) (*TaskListMetadata, error) {
	var v TaskListMetadata
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a PollForActivityTaskRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a PollForActivityTaskRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v PollForActivityTaskRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *PollForActivityTaskRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.TaskList, err = _TaskList_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Identity = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TStruct {
				v.TaskListMetadata, err = _TaskListMetadata_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a PollForActivityTaskRequest
// struct.
func (v *PollForActivityTaskRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [4]string
	i := 0
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.TaskList != nil {
		fields[i] = fmt.Sprintf("TaskList: %v", v.TaskList)
		i++
	}
	if v.Identity != nil {
		fields[i] = fmt.Sprintf("Identity: %v", *(v.Identity))
		i++
	}
	if v.TaskListMetadata != nil {
		fields[i] = fmt.Sprintf("TaskListMetadata: %v", v.TaskListMetadata)
		i++
	}

	return fmt.Sprintf("PollForActivityTaskRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this PollForActivityTaskRequest match the
// provided PollForActivityTaskRequest.
//
// This function performs a deep comparison.
func (v *PollForActivityTaskRequest) Equals(rhs *PollForActivityTaskRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !((v.TaskList == nil && rhs.TaskList == nil) || (v.TaskList != nil && rhs.TaskList != nil && v.TaskList.Equals(rhs.TaskList))) {
		return false
	}
	if !_String_EqualsPtr(v.Identity, rhs.Identity) {
		return false
	}
	if !((v.TaskListMetadata == nil && rhs.TaskListMetadata == nil) || (v.TaskListMetadata != nil && rhs.TaskListMetadata != nil && v.TaskListMetadata.Equals(rhs.TaskListMetadata))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of PollForActivityTaskRequest.
func (v *PollForActivityTaskRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.TaskList != nil {
		err = multierr.Append(err, enc.AddObject("taskList", v.TaskList))
	}
	if v.Identity != nil {
		enc.AddString("identity", *v.Identity)
	}
	if v.TaskListMetadata != nil {
		err = multierr.Append(err, enc.AddObject("taskListMetadata", v.TaskListMetadata))
	}
	return err
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *PollForActivityTaskRequest) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *PollForActivityTaskRequest) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetTaskList returns the value of TaskList if it is set or its
// zero value if it is unset.
func (v *PollForActivityTaskRequest) GetTaskList() (o *TaskList) {
	if v != nil && v.TaskList != nil {
		return v.TaskList
	}

	return
}

// IsSetTaskList returns true if TaskList is not nil.
func (v *PollForActivityTaskRequest) IsSetTaskList() bool {
	return v != nil && v.TaskList != nil
}

// GetIdentity returns the value of Identity if it is set or its
// zero value if it is unset.
func (v *PollForActivityTaskRequest) GetIdentity() (o string) {
	if v != nil && v.Identity != nil {
		return *v.Identity
	}

	return
}

// IsSetIdentity returns true if Identity is not nil.
func (v *PollForActivityTaskRequest) IsSetIdentity() bool {
	return v != nil && v.Identity != nil
}

// GetTaskListMetadata returns the value of TaskListMetadata if it is set or its
// zero value if it is unset.
func (v *PollForActivityTaskRequest) GetTaskListMetadata() (o *TaskListMetadata) {
	if v != nil && v.TaskListMetadata != nil {
		return v.TaskListMetadata
	}

	return
}

// IsSetTaskListMetadata returns true if TaskListMetadata is not nil.
func (v *PollForActivityTaskRequest) IsSetTaskListMetadata() bool {
	return v != nil && v.TaskListMetadata != nil
}

type PollForActivityTaskResponse struct {
	TaskToken                       []byte             `json:"taskToken,omitempty"`
	WorkflowExecution               *WorkflowExecution `json:"workflowExecution,omitempty"`
	ActivityId                      *string            `json:"activityId,omitempty"`
	ActivityType                    *ActivityType      `json:"activityType,omitempty"`
	Input                           []byte             `json:"input,omitempty"`
	ScheduledTimestamp              *int64             `json:"scheduledTimestamp,omitempty"`
	ScheduleToCloseTimeoutSeconds   *int32             `json:"scheduleToCloseTimeoutSeconds,omitempty"`
	StartedTimestamp                *int64             `json:"startedTimestamp,omitempty"`
	StartToCloseTimeoutSeconds      *int32             `json:"startToCloseTimeoutSeconds,omitempty"`
	HeartbeatTimeoutSeconds         *int32             `json:"heartbeatTimeoutSeconds,omitempty"`
	Attempt                         *int32             `json:"attempt,omitempty"`
	ScheduledTimestampOfThisAttempt *int64             `json:"scheduledTimestampOfThisAttempt,omitempty"`
	HeartbeatDetails                []byte             `json:"heartbeatDetails,omitempty"`
	WorkflowType                    *WorkflowType      `json:"workflowType,omitempty"`
	WorkflowDomain                  *string            `json:"workflowDomain,omitempty"`
	Header                          *Header            `json:"header,omitempty"`
}

// ToWire translates a PollForActivityTaskResponse struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *PollForActivityTaskResponse) ToWire() (wire.Value, error) {
	var (
		fields [16]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.TaskToken != nil {
		w, err = wire.NewValueBinary(v.TaskToken), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.WorkflowExecution != nil {
		w, err = v.WorkflowExecution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.ActivityId != nil {
		w, err = wire.NewValueString(*(v.ActivityId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.ActivityType != nil {
		w, err = v.ActivityType.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.Input != nil {
		w, err = wire.NewValueBinary(v.Input), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.ScheduledTimestamp != nil {
		w, err = wire.NewValueI64(*(v.ScheduledTimestamp)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 70, Value: w}
		i++
	}
	if v.ScheduleToCloseTimeoutSeconds != nil {
		w, err = wire.NewValueI32(*(v.ScheduleToCloseTimeoutSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 80, Value: w}
		i++
	}
	if v.StartedTimestamp != nil {
		w, err = wire.NewValueI64(*(v.StartedTimestamp)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 90, Value: w}
		i++
	}
	if v.StartToCloseTimeoutSeconds != nil {
		w, err = wire.NewValueI32(*(v.StartToCloseTimeoutSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 100, Value: w}
		i++
	}
	if v.HeartbeatTimeoutSeconds != nil {
		w, err = wire.NewValueI32(*(v.HeartbeatTimeoutSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 110, Value: w}
		i++
	}
	if v.Attempt != nil {
		w, err = wire.NewValueI32(*(v.Attempt)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 120, Value: w}
		i++
	}
	if v.ScheduledTimestampOfThisAttempt != nil {
		w, err = wire.NewValueI64(*(v.ScheduledTimestampOfThisAttempt)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 130, Value: w}
		i++
	}
	if v.HeartbeatDetails != nil {
		w, err = wire.NewValueBinary(v.HeartbeatDetails), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 140, Value: w}
		i++
	}
	if v.WorkflowType != nil {
		w, err = v.WorkflowType.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 150, Value: w}
		i++
	}
	if v.WorkflowDomain != nil {
		w, err = wire.NewValueString(*(v.WorkflowDomain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 160, Value: w}
		i++
	}
	if v.Header != nil {
		w, err = v.Header.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 170, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a PollForActivityTaskResponse struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a PollForActivityTaskResponse struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v PollForActivityTaskResponse
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *PollForActivityTaskResponse) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				v.TaskToken, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ActivityId = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TStruct {
				v.ActivityType, err = _ActivityType_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TBinary {
				v.Input, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 70:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduledTimestamp = &x
				if err != nil {
					return err
				}

			}
		case 80:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.ScheduleToCloseTimeoutSeconds = &x
				if err != nil {
					return err
				}

			}
		case 90:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StartedTimestamp = &x
				if err != nil {
					return err
				}

			}
		case 100:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.StartToCloseTimeoutSeconds = &x
				if err != nil {
					return err
				}

			}
		case 110:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.HeartbeatTimeoutSeconds = &x
				if err != nil {
					return err
				}

			}
		case 120:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.Attempt = &x
				if err != nil {
					return err
				}

			}
		case 130:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduledTimestampOfThisAttempt = &x
				if err != nil {
					return err
				}

			}
		case 140:
			if field.Value.Type() == wire.TBinary {
				v.HeartbeatDetails, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 150:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowType, err = _WorkflowType_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 160:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.WorkflowDomain = &x
				if err != nil {
					return err
				}

			}
		case 170:
			if field.Value.Type() == wire.TStruct {
				v.Header, err = _Header_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a PollForActivityTaskResponse
// struct.
func (v *PollForActivityTaskResponse) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [16]string
	i := 0
	if v.TaskToken != nil {
		fields[i] = fmt.Sprintf("TaskToken: %v", v.TaskToken)
		i++
	}
	if v.WorkflowExecution != nil {
		fields[i] = fmt.Sprintf("WorkflowExecution: %v", v.WorkflowExecution)
		i++
	}
	if v.ActivityId != nil {
		fields[i] = fmt.Sprintf("ActivityId: %v", *(v.ActivityId))
		i++
	}
	if v.ActivityType != nil {
		fields[i] = fmt.Sprintf("ActivityType: %v", v.ActivityType)
		i++
	}
	if v.Input != nil {
		fields[i] = fmt.Sprintf("Input: %v", v.Input)
		i++
	}
	if v.ScheduledTimestamp != nil {
		fields[i] = fmt.Sprintf("ScheduledTimestamp: %v", *(v.ScheduledTimestamp))
		i++
	}
	if v.ScheduleToCloseTimeoutSeconds != nil {
		fields[i] = fmt.Sprintf("ScheduleToCloseTimeoutSeconds: %v", *(v.ScheduleToCloseTimeoutSeconds))
		i++
	}
	if v.StartedTimestamp != nil {
		fields[i] = fmt.Sprintf("StartedTimestamp: %v", *(v.StartedTimestamp))
		i++
	}
	if v.StartToCloseTimeoutSeconds != nil {
		fields[i] = fmt.Sprintf("StartToCloseTimeoutSeconds: %v", *(v.StartToCloseTimeoutSeconds))
		i++
	}
	if v.HeartbeatTimeoutSeconds != nil {
		fields[i] = fmt.Sprintf("HeartbeatTimeoutSeconds: %v", *(v.HeartbeatTimeoutSeconds))
		i++
	}
	if v.Attempt != nil {
		fields[i] = fmt.Sprintf("Attempt: %v", *(v.Attempt))
		i++
	}
	if v.ScheduledTimestampOfThisAttempt != nil {
		fields[i] = fmt.Sprintf("ScheduledTimestampOfThisAttempt: %v", *(v.ScheduledTimestampOfThisAttempt))
		i++
	}
	if v.HeartbeatDetails != nil {
		fields[i] = fmt.Sprintf("HeartbeatDetails: %v", v.HeartbeatDetails)
		i++
	}
	if v.WorkflowType != nil {
		fields[i] = fmt.Sprintf("WorkflowType: %v", v.WorkflowType)
		i++
	}
	if v.WorkflowDomain != nil {
		fields[i] = fmt.Sprintf("WorkflowDomain: %v", *(v.WorkflowDomain))
		i++
	}
	if v.Header != nil {
		fields[i] = fmt.Sprintf("Header: %v", v.Header)
		i++
	}

	return fmt.Sprintf("PollForActivityTaskResponse{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this PollForActivityTaskResponse match the
// provided PollForActivityTaskResponse.
//
// This function performs a deep comparison.
func (v *PollForActivityTaskResponse) Equals(rhs *PollForActivityTaskResponse) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.TaskToken == nil && rhs.TaskToken == nil) || (v.TaskToken != nil && rhs.TaskToken != nil && bytes.Equal(v.TaskToken, rhs.TaskToken))) {
		return false
	}
	if !((v.WorkflowExecution == nil && rhs.WorkflowExecution == nil) || (v.WorkflowExecution != nil && rhs.WorkflowExecution != nil && v.WorkflowExecution.Equals(rhs.WorkflowExecution))) {
		return false
	}
	if !_String_EqualsPtr(v.ActivityId, rhs.ActivityId) {
		return false
	}
	if !((v.ActivityType == nil && rhs.ActivityType == nil) || (v.ActivityType != nil && rhs.ActivityType != nil && v.ActivityType.Equals(rhs.ActivityType))) {
		return false
	}
	if !((v.Input == nil && rhs.Input == nil) || (v.Input != nil && rhs.Input != nil && bytes.Equal(v.Input, rhs.Input))) {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduledTimestamp, rhs.ScheduledTimestamp) {
		return false
	}
	if !_I32_EqualsPtr(v.ScheduleToCloseTimeoutSeconds, rhs.ScheduleToCloseTimeoutSeconds) {
		return false
	}
	if !_I64_EqualsPtr(v.StartedTimestamp, rhs.StartedTimestamp) {
		return false
	}
	if !_I32_EqualsPtr(v.StartToCloseTimeoutSeconds, rhs.StartToCloseTimeoutSeconds) {
		return false
	}
	if !_I32_EqualsPtr(v.HeartbeatTimeoutSeconds, rhs.HeartbeatTimeoutSeconds) {
		return false
	}
	if !_I32_EqualsPtr(v.Attempt, rhs.Attempt) {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduledTimestampOfThisAttempt, rhs.ScheduledTimestampOfThisAttempt) {
		return false
	}
	if !((v.HeartbeatDetails == nil && rhs.HeartbeatDetails == nil) || (v.HeartbeatDetails != nil && rhs.HeartbeatDetails != nil && bytes.Equal(v.HeartbeatDetails, rhs.HeartbeatDetails))) {
		return false
	}
	if !((v.WorkflowType == nil && rhs.WorkflowType == nil) || (v.WorkflowType != nil && rhs.WorkflowType != nil && v.WorkflowType.Equals(rhs.WorkflowType))) {
		return false
	}
	if !_String_EqualsPtr(v.WorkflowDomain, rhs.WorkflowDomain) {
		return false
	}
	if !((v.Header == nil && rhs.Header == nil) || (v.Header != nil && rhs.Header != nil && v.Header.Equals(rhs.Header))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of PollForActivityTaskResponse.
func (v *PollForActivityTaskResponse) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.TaskToken != nil {
		enc.AddString("taskToken", base64.StdEncoding.EncodeToString(v.TaskToken))
	}
	if v.WorkflowExecution != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecution", v.WorkflowExecution))
	}
	if v.ActivityId != nil {
		enc.AddString("activityId", *v.ActivityId)
	}
	if v.ActivityType != nil {
		err = multierr.Append(err, enc.AddObject("activityType", v.ActivityType))
	}
	if v.Input != nil {
		enc.AddString("input", base64.StdEncoding.EncodeToString(v.Input))
	}
	if v.ScheduledTimestamp != nil {
		enc.AddInt64("scheduledTimestamp", *v.ScheduledTimestamp)
	}
	if v.ScheduleToCloseTimeoutSeconds != nil {
		enc.AddInt32("scheduleToCloseTimeoutSeconds", *v.ScheduleToCloseTimeoutSeconds)
	}
	if v.StartedTimestamp != nil {
		enc.AddInt64("startedTimestamp", *v.StartedTimestamp)
	}
	if v.StartToCloseTimeoutSeconds != nil {
		enc.AddInt32("startToCloseTimeoutSeconds", *v.StartToCloseTimeoutSeconds)
	}
	if v.HeartbeatTimeoutSeconds != nil {
		enc.AddInt32("heartbeatTimeoutSeconds", *v.HeartbeatTimeoutSeconds)
	}
	if v.Attempt != nil {
		enc.AddInt32("attempt", *v.Attempt)
	}
	if v.ScheduledTimestampOfThisAttempt != nil {
		enc.AddInt64("scheduledTimestampOfThisAttempt", *v.ScheduledTimestampOfThisAttempt)
	}
	if v.HeartbeatDetails != nil {
		enc.AddString("heartbeatDetails", base64.StdEncoding.EncodeToString(v.HeartbeatDetails))
	}
	if v.WorkflowType != nil {
		err = multierr.Append(err, enc.AddObject("workflowType", v.WorkflowType))
	}
	if v.WorkflowDomain != nil {
		enc.AddString("workflowDomain", *v.WorkflowDomain)
	}
	if v.Header != nil {
		err = multierr.Append(err, enc.AddObject("header", v.Header))
	}
	return err
}

// GetTaskToken returns the value of TaskToken if it is set or its
// zero value if it is unset.
func (v *PollForActivityTaskResponse) GetTaskToken() (o []byte) {
	if v != nil && v.TaskToken != nil {
		return v.TaskToken
	}

	return
}

// IsSetTaskToken returns true if TaskToken is not nil.
func (v *PollForActivityTaskResponse) IsSetTaskToken() bool {
	return v != nil && v.TaskToken != nil
}

// GetWorkflowExecution returns the value of WorkflowExecution if it is set or its
// zero value if it is unset.
func (v *PollForActivityTaskResponse) GetWorkflowExecution() (o *WorkflowExecution) {
	if v != nil && v.WorkflowExecution != nil {
		return v.WorkflowExecution
	}

	return
}

// IsSetWorkflowExecution returns true if WorkflowExecution is not nil.
func (v *PollForActivityTaskResponse) IsSetWorkflowExecution() bool {
	return v != nil && v.WorkflowExecution != nil
}

// GetActivityId returns the value of ActivityId if it is set or its
// zero value if it is unset.
func (v *PollForActivityTaskResponse) GetActivityId() (o string) {
	if v != nil && v.ActivityId != nil {
		return *v.ActivityId
	}

	return
}

// IsSetActivityId returns true if ActivityId is not nil.
func (v *PollForActivityTaskResponse) IsSetActivityId() bool {
	return v != nil && v.ActivityId != nil
}

// GetActivityType returns the value of ActivityType if it is set or its
// zero value if it is unset.
func (v *PollForActivityTaskResponse) GetActivityType() (o *ActivityType) {
	if v != nil && v.ActivityType != nil {
		return v.ActivityType
	}

	return
}

// IsSetActivityType returns true if ActivityType is not nil.
func (v *PollForActivityTaskResponse) IsSetActivityType() bool {
	return v != nil && v.ActivityType != nil
}

// GetInput returns the value of Input if it is set or its
// zero value if it is unset.
func (v *PollForActivityTaskResponse) GetInput() (o []byte) {
	if v != nil && v.Input != nil {
		return v.Input
	}

	return
}

// IsSetInput returns true if Input is not nil.
func (v *PollForActivityTaskResponse) IsSetInput() bool {
	return v != nil && v.Input != nil
}

// GetScheduledTimestamp returns the value of ScheduledTimestamp if it is set or its
// zero value if it is unset.
func (v *PollForActivityTaskResponse) GetScheduledTimestamp() (o int64) {
	if v != nil && v.ScheduledTimestamp != nil {
		return *v.ScheduledTimestamp
	}

	return
}

// IsSetScheduledTimestamp returns true if ScheduledTimestamp is not nil.
func (v *PollForActivityTaskResponse) IsSetScheduledTimestamp() bool {
	return v != nil && v.ScheduledTimestamp != nil
}

// GetScheduleToCloseTimeoutSeconds returns the value of ScheduleToCloseTimeoutSeconds if it is set or its
// zero value if it is unset.
func (v *PollForActivityTaskResponse) GetScheduleToCloseTimeoutSeconds() (o int32) {
	if v != nil && v.ScheduleToCloseTimeoutSeconds != nil {
		return *v.ScheduleToCloseTimeoutSeconds
	}

	return
}

// IsSetScheduleToCloseTimeoutSeconds returns true if ScheduleToCloseTimeoutSeconds is not nil.
func (v *PollForActivityTaskResponse) IsSetScheduleToCloseTimeoutSeconds() bool {
	return v != nil && v.ScheduleToCloseTimeoutSeconds != nil
}

// GetStartedTimestamp returns the value of StartedTimestamp if it is set or its
// zero value if it is unset.
func (v *PollForActivityTaskResponse) GetStartedTimestamp() (o int64) {
	if v != nil && v.StartedTimestamp != nil {
		return *v.StartedTimestamp
	}

	return
}

// IsSetStartedTimestamp returns true if StartedTimestamp is not nil.
func (v *PollForActivityTaskResponse) IsSetStartedTimestamp() bool {
	return v != nil && v.StartedTimestamp != nil
}

// GetStartToCloseTimeoutSeconds returns the value of StartToCloseTimeoutSeconds if it is set or its
// zero value if it is unset.
func (v *PollForActivityTaskResponse) GetStartToCloseTimeoutSeconds() (o int32) {
	if v != nil && v.StartToCloseTimeoutSeconds != nil {
		return *v.StartToCloseTimeoutSeconds
	}

	return
}

// IsSetStartToCloseTimeoutSeconds returns true if StartToCloseTimeoutSeconds is not nil.
func (v *PollForActivityTaskResponse) IsSetStartToCloseTimeoutSeconds() bool {
	return v != nil && v.StartToCloseTimeoutSeconds != nil
}

// GetHeartbeatTimeoutSeconds returns the value of HeartbeatTimeoutSeconds if it is set or its
// zero value if it is unset.
func (v *PollForActivityTaskResponse) GetHeartbeatTimeoutSeconds() (o int32) {
	if v != nil && v.HeartbeatTimeoutSeconds != nil {
		return *v.HeartbeatTimeoutSeconds
	}

	return
}

// IsSetHeartbeatTimeoutSeconds returns true if HeartbeatTimeoutSeconds is not nil.
func (v *PollForActivityTaskResponse) IsSetHeartbeatTimeoutSeconds() bool {
	return v != nil && v.HeartbeatTimeoutSeconds != nil
}

// GetAttempt returns the value of Attempt if it is set or its
// zero value if it is unset.
func (v *PollForActivityTaskResponse) GetAttempt() (o int32) {
	if v != nil && v.Attempt != nil {
		return *v.Attempt
	}

	return
}

// IsSetAttempt returns true if Attempt is not nil.
func (v *PollForActivityTaskResponse) IsSetAttempt() bool {
	return v != nil && v.Attempt != nil
}

// GetScheduledTimestampOfThisAttempt returns the value of ScheduledTimestampOfThisAttempt if it is set or its
// zero value if it is unset.
func (v *PollForActivityTaskResponse) GetScheduledTimestampOfThisAttempt() (o int64) {
	if v != nil && v.ScheduledTimestampOfThisAttempt != nil {
		return *v.ScheduledTimestampOfThisAttempt
	}

	return
}

// IsSetScheduledTimestampOfThisAttempt returns true if ScheduledTimestampOfThisAttempt is not nil.
func (v *PollForActivityTaskResponse) IsSetScheduledTimestampOfThisAttempt() bool {
	return v != nil && v.ScheduledTimestampOfThisAttempt != nil
}

// GetHeartbeatDetails returns the value of HeartbeatDetails if it is set or its
// zero value if it is unset.
func (v *PollForActivityTaskResponse) GetHeartbeatDetails() (o []byte) {
	if v != nil && v.HeartbeatDetails != nil {
		return v.HeartbeatDetails
	}

	return
}

// IsSetHeartbeatDetails returns true if HeartbeatDetails is not nil.
func (v *PollForActivityTaskResponse) IsSetHeartbeatDetails() bool {
	return v != nil && v.HeartbeatDetails != nil
}

// GetWorkflowType returns the value of WorkflowType if it is set or its
// zero value if it is unset.
func (v *PollForActivityTaskResponse) GetWorkflowType() (o *WorkflowType) {
	if v != nil && v.WorkflowType != nil {
		return v.WorkflowType
	}

	return
}

// IsSetWorkflowType returns true if WorkflowType is not nil.
func (v *PollForActivityTaskResponse) IsSetWorkflowType() bool {
	return v != nil && v.WorkflowType != nil
}

// GetWorkflowDomain returns the value of WorkflowDomain if it is set or its
// zero value if it is unset.
func (v *PollForActivityTaskResponse) GetWorkflowDomain() (o string) {
	if v != nil && v.WorkflowDomain != nil {
		return *v.WorkflowDomain
	}

	return
}

// IsSetWorkflowDomain returns true if WorkflowDomain is not nil.
func (v *PollForActivityTaskResponse) IsSetWorkflowDomain() bool {
	return v != nil && v.WorkflowDomain != nil
}

// GetHeader returns the value of Header if it is set or its
// zero value if it is unset.
func (v *PollForActivityTaskResponse) GetHeader() (o *Header) {
	if v != nil && v.Header != nil {
		return v.Header
	}

	return
}

// IsSetHeader returns true if Header is not nil.
func (v *PollForActivityTaskResponse) IsSetHeader() bool {
	return v != nil && v.Header != nil
}

type PollForDecisionTaskRequest struct {
	Domain         *string   `json:"domain,omitempty"`
	TaskList       *TaskList `json:"taskList,omitempty"`
	Identity       *string   `json:"identity,omitempty"`
	BinaryChecksum *string   `json:"binaryChecksum,omitempty"`
}

// ToWire translates a PollForDecisionTaskRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *PollForDecisionTaskRequest) ToWire() (wire.Value, error) {
	var (
		fields [4]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.TaskList != nil {
		w, err = v.TaskList.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.Identity != nil {
		w, err = wire.NewValueString(*(v.Identity)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.BinaryChecksum != nil {
		w, err = wire.NewValueString(*(v.BinaryChecksum)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a PollForDecisionTaskRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a PollForDecisionTaskRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v PollForDecisionTaskRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *PollForDecisionTaskRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.TaskList, err = _TaskList_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Identity = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.BinaryChecksum = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a PollForDecisionTaskRequest
// struct.
func (v *PollForDecisionTaskRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [4]string
	i := 0
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.TaskList != nil {
		fields[i] = fmt.Sprintf("TaskList: %v", v.TaskList)
		i++
	}
	if v.Identity != nil {
		fields[i] = fmt.Sprintf("Identity: %v", *(v.Identity))
		i++
	}
	if v.BinaryChecksum != nil {
		fields[i] = fmt.Sprintf("BinaryChecksum: %v", *(v.BinaryChecksum))
		i++
	}

	return fmt.Sprintf("PollForDecisionTaskRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this PollForDecisionTaskRequest match the
// provided PollForDecisionTaskRequest.
//
// This function performs a deep comparison.
func (v *PollForDecisionTaskRequest) Equals(rhs *PollForDecisionTaskRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !((v.TaskList == nil && rhs.TaskList == nil) || (v.TaskList != nil && rhs.TaskList != nil && v.TaskList.Equals(rhs.TaskList))) {
		return false
	}
	if !_String_EqualsPtr(v.Identity, rhs.Identity) {
		return false
	}
	if !_String_EqualsPtr(v.BinaryChecksum, rhs.BinaryChecksum) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of PollForDecisionTaskRequest.
func (v *PollForDecisionTaskRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.TaskList != nil {
		err = multierr.Append(err, enc.AddObject("taskList", v.TaskList))
	}
	if v.Identity != nil {
		enc.AddString("identity", *v.Identity)
	}
	if v.BinaryChecksum != nil {
		enc.AddString("binaryChecksum", *v.BinaryChecksum)
	}
	return err
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskRequest) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *PollForDecisionTaskRequest) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetTaskList returns the value of TaskList if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskRequest) GetTaskList() (o *TaskList) {
	if v != nil && v.TaskList != nil {
		return v.TaskList
	}

	return
}

// IsSetTaskList returns true if TaskList is not nil.
func (v *PollForDecisionTaskRequest) IsSetTaskList() bool {
	return v != nil && v.TaskList != nil
}

// GetIdentity returns the value of Identity if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskRequest) GetIdentity() (o string) {
	if v != nil && v.Identity != nil {
		return *v.Identity
	}

	return
}

// IsSetIdentity returns true if Identity is not nil.
func (v *PollForDecisionTaskRequest) IsSetIdentity() bool {
	return v != nil && v.Identity != nil
}

// GetBinaryChecksum returns the value of BinaryChecksum if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskRequest) GetBinaryChecksum() (o string) {
	if v != nil && v.BinaryChecksum != nil {
		return *v.BinaryChecksum
	}

	return
}

// IsSetBinaryChecksum returns true if BinaryChecksum is not nil.
func (v *PollForDecisionTaskRequest) IsSetBinaryChecksum() bool {
	return v != nil && v.BinaryChecksum != nil
}

type PollForDecisionTaskResponse struct {
	TaskToken                 []byte             `json:"taskToken,omitempty"`
	WorkflowExecution         *WorkflowExecution `json:"workflowExecution,omitempty"`
	WorkflowType              *WorkflowType      `json:"workflowType,omitempty"`
	PreviousStartedEventId    *int64             `json:"previousStartedEventId,omitempty"`
	StartedEventId            *int64             `json:"startedEventId,omitempty"`
	Attempt                   *int64             `json:"attempt,omitempty"`
	BacklogCountHint          *int64             `json:"backlogCountHint,omitempty"`
	History                   *History           `json:"history,omitempty"`
	NextPageToken             []byte             `json:"nextPageToken,omitempty"`
	Query                     *WorkflowQuery     `json:"query,omitempty"`
	WorkflowExecutionTaskList *TaskList          `json:"WorkflowExecutionTaskList,omitempty"`
}

// ToWire translates a PollForDecisionTaskResponse struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *PollForDecisionTaskResponse) ToWire() (wire.Value, error) {
	var (
		fields [11]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.TaskToken != nil {
		w, err = wire.NewValueBinary(v.TaskToken), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.WorkflowExecution != nil {
		w, err = v.WorkflowExecution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.WorkflowType != nil {
		w, err = v.WorkflowType.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.PreviousStartedEventId != nil {
		w, err = wire.NewValueI64(*(v.PreviousStartedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.StartedEventId != nil {
		w, err = wire.NewValueI64(*(v.StartedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.Attempt != nil {
		w, err = wire.NewValueI64(*(v.Attempt)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 51, Value: w}
		i++
	}
	if v.BacklogCountHint != nil {
		w, err = wire.NewValueI64(*(v.BacklogCountHint)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 54, Value: w}
		i++
	}
	if v.History != nil {
		w, err = v.History.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}
	if v.NextPageToken != nil {
		w, err = wire.NewValueBinary(v.NextPageToken), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 70, Value: w}
		i++
	}
	if v.Query != nil {
		w, err = v.Query.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 80, Value: w}
		i++
	}
	if v.WorkflowExecutionTaskList != nil {
		w, err = v.WorkflowExecutionTaskList.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 90, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _WorkflowQuery_Read(w wire.Value) (*WorkflowQuery, error) {
	var v WorkflowQuery
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a PollForDecisionTaskResponse struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a PollForDecisionTaskResponse struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v PollForDecisionTaskResponse
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *PollForDecisionTaskResponse) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				v.TaskToken, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowType, err = _WorkflowType_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.PreviousStartedEventId = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StartedEventId = &x
				if err != nil {
					return err
				}

			}
		case 51:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.Attempt = &x
				if err != nil {
					return err
				}

			}
		case 54:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.BacklogCountHint = &x
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TStruct {
				v.History, err = _History_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 70:
			if field.Value.Type() == wire.TBinary {
				v.NextPageToken, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 80:
			if field.Value.Type() == wire.TStruct {
				v.Query, err = _WorkflowQuery_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 90:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecutionTaskList, err = _TaskList_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a PollForDecisionTaskResponse
// struct.
func (v *PollForDecisionTaskResponse) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [11]string
	i := 0
	if v.TaskToken != nil {
		fields[i] = fmt.Sprintf("TaskToken: %v", v.TaskToken)
		i++
	}
	if v.WorkflowExecution != nil {
		fields[i] = fmt.Sprintf("WorkflowExecution: %v", v.WorkflowExecution)
		i++
	}
	if v.WorkflowType != nil {
		fields[i] = fmt.Sprintf("WorkflowType: %v", v.WorkflowType)
		i++
	}
	if v.PreviousStartedEventId != nil {
		fields[i] = fmt.Sprintf("PreviousStartedEventId: %v", *(v.PreviousStartedEventId))
		i++
	}
	if v.StartedEventId != nil {
		fields[i] = fmt.Sprintf("StartedEventId: %v", *(v.StartedEventId))
		i++
	}
	if v.Attempt != nil {
		fields[i] = fmt.Sprintf("Attempt: %v", *(v.Attempt))
		i++
	}
	if v.BacklogCountHint != nil {
		fields[i] = fmt.Sprintf("BacklogCountHint: %v", *(v.BacklogCountHint))
		i++
	}
	if v.History != nil {
		fields[i] = fmt.Sprintf("History: %v", v.History)
		i++
	}
	if v.NextPageToken != nil {
		fields[i] = fmt.Sprintf("NextPageToken: %v", v.NextPageToken)
		i++
	}
	if v.Query != nil {
		fields[i] = fmt.Sprintf("Query: %v", v.Query)
		i++
	}
	if v.WorkflowExecutionTaskList != nil {
		fields[i] = fmt.Sprintf("WorkflowExecutionTaskList: %v", v.WorkflowExecutionTaskList)
		i++
	}

	return fmt.Sprintf("PollForDecisionTaskResponse{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this PollForDecisionTaskResponse match the
// provided PollForDecisionTaskResponse.
//
// This function performs a deep comparison.
func (v *PollForDecisionTaskResponse) Equals(rhs *PollForDecisionTaskResponse) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.TaskToken == nil && rhs.TaskToken == nil) || (v.TaskToken != nil && rhs.TaskToken != nil && bytes.Equal(v.TaskToken, rhs.TaskToken))) {
		return false
	}
	if !((v.WorkflowExecution == nil && rhs.WorkflowExecution == nil) || (v.WorkflowExecution != nil && rhs.WorkflowExecution != nil && v.WorkflowExecution.Equals(rhs.WorkflowExecution))) {
		return false
	}
	if !((v.WorkflowType == nil && rhs.WorkflowType == nil) || (v.WorkflowType != nil && rhs.WorkflowType != nil && v.WorkflowType.Equals(rhs.WorkflowType))) {
		return false
	}
	if !_I64_EqualsPtr(v.PreviousStartedEventId, rhs.PreviousStartedEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.StartedEventId, rhs.StartedEventId) {
		return false
	}
	if !_I64_EqualsPtr(v.Attempt, rhs.Attempt) {
		return false
	}
	if !_I64_EqualsPtr(v.BacklogCountHint, rhs.BacklogCountHint) {
		return false
	}
	if !((v.History == nil && rhs.History == nil) || (v.History != nil && rhs.History != nil && v.History.Equals(rhs.History))) {
		return false
	}
	if !((v.NextPageToken == nil && rhs.NextPageToken == nil) || (v.NextPageToken != nil && rhs.NextPageToken != nil && bytes.Equal(v.NextPageToken, rhs.NextPageToken))) {
		return false
	}
	if !((v.Query == nil && rhs.Query == nil) || (v.Query != nil && rhs.Query != nil && v.Query.Equals(rhs.Query))) {
		return false
	}
	if !((v.WorkflowExecutionTaskList == nil && rhs.WorkflowExecutionTaskList == nil) || (v.WorkflowExecutionTaskList != nil && rhs.WorkflowExecutionTaskList != nil && v.WorkflowExecutionTaskList.Equals(rhs.WorkflowExecutionTaskList))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of PollForDecisionTaskResponse.
func (v *PollForDecisionTaskResponse) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.TaskToken != nil {
		enc.AddString("taskToken", base64.StdEncoding.EncodeToString(v.TaskToken))
	}
	if v.WorkflowExecution != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecution", v.WorkflowExecution))
	}
	if v.WorkflowType != nil {
		err = multierr.Append(err, enc.AddObject("workflowType", v.WorkflowType))
	}
	if v.PreviousStartedEventId != nil {
		enc.AddInt64("previousStartedEventId", *v.PreviousStartedEventId)
	}
	if v.StartedEventId != nil {
		enc.AddInt64("startedEventId", *v.StartedEventId)
	}
	if v.Attempt != nil {
		enc.AddInt64("attempt", *v.Attempt)
	}
	if v.BacklogCountHint != nil {
		enc.AddInt64("backlogCountHint", *v.BacklogCountHint)
	}
	if v.History != nil {
		err = multierr.Append(err, enc.AddObject("history", v.History))
	}
	if v.NextPageToken != nil {
		enc.AddString("nextPageToken", base64.StdEncoding.EncodeToString(v.NextPageToken))
	}
	if v.Query != nil {
		err = multierr.Append(err, enc.AddObject("query", v.Query))
	}
	if v.WorkflowExecutionTaskList != nil {
		err = multierr.Append(err, enc.AddObject("WorkflowExecutionTaskList", v.WorkflowExecutionTaskList))
	}
	return err
}

// GetTaskToken returns the value of TaskToken if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskResponse) GetTaskToken() (o []byte) {
	if v != nil && v.TaskToken != nil {
		return v.TaskToken
	}

	return
}

// IsSetTaskToken returns true if TaskToken is not nil.
func (v *PollForDecisionTaskResponse) IsSetTaskToken() bool {
	return v != nil && v.TaskToken != nil
}

// GetWorkflowExecution returns the value of WorkflowExecution if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskResponse) GetWorkflowExecution() (o *WorkflowExecution) {
	if v != nil && v.WorkflowExecution != nil {
		return v.WorkflowExecution
	}

	return
}

// IsSetWorkflowExecution returns true if WorkflowExecution is not nil.
func (v *PollForDecisionTaskResponse) IsSetWorkflowExecution() bool {
	return v != nil && v.WorkflowExecution != nil
}

// GetWorkflowType returns the value of WorkflowType if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskResponse) GetWorkflowType() (o *WorkflowType) {
	if v != nil && v.WorkflowType != nil {
		return v.WorkflowType
	}

	return
}

// IsSetWorkflowType returns true if WorkflowType is not nil.
func (v *PollForDecisionTaskResponse) IsSetWorkflowType() bool {
	return v != nil && v.WorkflowType != nil
}

// GetPreviousStartedEventId returns the value of PreviousStartedEventId if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskResponse) GetPreviousStartedEventId() (o int64) {
	if v != nil && v.PreviousStartedEventId != nil {
		return *v.PreviousStartedEventId
	}

	return
}

// IsSetPreviousStartedEventId returns true if PreviousStartedEventId is not nil.
func (v *PollForDecisionTaskResponse) IsSetPreviousStartedEventId() bool {
	return v != nil && v.PreviousStartedEventId != nil
}

// GetStartedEventId returns the value of StartedEventId if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskResponse) GetStartedEventId() (o int64) {
	if v != nil && v.StartedEventId != nil {
		return *v.StartedEventId
	}

	return
}

// IsSetStartedEventId returns true if StartedEventId is not nil.
func (v *PollForDecisionTaskResponse) IsSetStartedEventId() bool {
	return v != nil && v.StartedEventId != nil
}

// GetAttempt returns the value of Attempt if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskResponse) GetAttempt() (o int64) {
	if v != nil && v.Attempt != nil {
		return *v.Attempt
	}

	return
}

// IsSetAttempt returns true if Attempt is not nil.
func (v *PollForDecisionTaskResponse) IsSetAttempt() bool {
	return v != nil && v.Attempt != nil
}

// GetBacklogCountHint returns the value of BacklogCountHint if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskResponse) GetBacklogCountHint() (o int64) {
	if v != nil && v.BacklogCountHint != nil {
		return *v.BacklogCountHint
	}

	return
}

// IsSetBacklogCountHint returns true if BacklogCountHint is not nil.
func (v *PollForDecisionTaskResponse) IsSetBacklogCountHint() bool {
	return v != nil && v.BacklogCountHint != nil
}

// GetHistory returns the value of History if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskResponse) GetHistory() (o *History) {
	if v != nil && v.History != nil {
		return v.History
	}

	return
}

// IsSetHistory returns true if History is not nil.
func (v *PollForDecisionTaskResponse) IsSetHistory() bool {
	return v != nil && v.History != nil
}

// GetNextPageToken returns the value of NextPageToken if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskResponse) GetNextPageToken() (o []byte) {
	if v != nil && v.NextPageToken != nil {
		return v.NextPageToken
	}

	return
}

// IsSetNextPageToken returns true if NextPageToken is not nil.
func (v *PollForDecisionTaskResponse) IsSetNextPageToken() bool {
	return v != nil && v.NextPageToken != nil
}

// GetQuery returns the value of Query if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskResponse) GetQuery() (o *WorkflowQuery) {
	if v != nil && v.Query != nil {
		return v.Query
	}

	return
}

// IsSetQuery returns true if Query is not nil.
func (v *PollForDecisionTaskResponse) IsSetQuery() bool {
	return v != nil && v.Query != nil
}

// GetWorkflowExecutionTaskList returns the value of WorkflowExecutionTaskList if it is set or its
// zero value if it is unset.
func (v *PollForDecisionTaskResponse) GetWorkflowExecutionTaskList() (o *TaskList) {
	if v != nil && v.WorkflowExecutionTaskList != nil {
		return v.WorkflowExecutionTaskList
	}

	return
}

// IsSetWorkflowExecutionTaskList returns true if WorkflowExecutionTaskList is not nil.
func (v *PollForDecisionTaskResponse) IsSetWorkflowExecutionTaskList() bool {
	return v != nil && v.WorkflowExecutionTaskList != nil
}

type PollerInfo struct {
	LastAccessTime *int64   `json:"lastAccessTime,omitempty"`
	Identity       *string  `json:"identity,omitempty"`
	RatePerSecond  *float64 `json:"ratePerSecond,omitempty"`
}

// ToWire translates a PollerInfo struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *PollerInfo) ToWire() (wire.Value, error) {
	var (
		fields [3]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.LastAccessTime != nil {
		w, err = wire.NewValueI64(*(v.LastAccessTime)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Identity != nil {
		w, err = wire.NewValueString(*(v.Identity)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.RatePerSecond != nil {
		w, err = wire.NewValueDouble(*(v.RatePerSecond)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a PollerInfo struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a PollerInfo struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v PollerInfo
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *PollerInfo) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.LastAccessTime = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Identity = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TDouble {
				var x float64
				x, err = field.Value.GetDouble(), error(nil)
				v.RatePerSecond = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a PollerInfo
// struct.
func (v *PollerInfo) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [3]string
	i := 0
	if v.LastAccessTime != nil {
		fields[i] = fmt.Sprintf("LastAccessTime: %v", *(v.LastAccessTime))
		i++
	}
	if v.Identity != nil {
		fields[i] = fmt.Sprintf("Identity: %v", *(v.Identity))
		i++
	}
	if v.RatePerSecond != nil {
		fields[i] = fmt.Sprintf("RatePerSecond: %v", *(v.RatePerSecond))
		i++
	}

	return fmt.Sprintf("PollerInfo{%v}", strings.Join(fields[:i], ", "))
}

func _Double_EqualsPtr(lhs, rhs *float64) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return (x == y)
	}
	return lhs == nil && rhs == nil
}

// Equals returns true if all the fields of this PollerInfo match the
// provided PollerInfo.
//
// This function performs a deep comparison.
func (v *PollerInfo) Equals(rhs *PollerInfo) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_I64_EqualsPtr(v.LastAccessTime, rhs.LastAccessTime) {
		return false
	}
	if !_String_EqualsPtr(v.Identity, rhs.Identity) {
		return false
	}
	if !_Double_EqualsPtr(v.RatePerSecond, rhs.RatePerSecond) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of PollerInfo.
func (v *PollerInfo) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.LastAccessTime != nil {
		enc.AddInt64("lastAccessTime", *v.LastAccessTime)
	}
	if v.Identity != nil {
		enc.AddString("identity", *v.Identity)
	}
	if v.RatePerSecond != nil {
		enc.AddFloat64("ratePerSecond", *v.RatePerSecond)
	}
	return err
}

// GetLastAccessTime returns the value of LastAccessTime if it is set or its
// zero value if it is unset.
func (v *PollerInfo) GetLastAccessTime() (o int64) {
	if v != nil && v.LastAccessTime != nil {
		return *v.LastAccessTime
	}

	return
}

// IsSetLastAccessTime returns true if LastAccessTime is not nil.
func (v *PollerInfo) IsSetLastAccessTime() bool {
	return v != nil && v.LastAccessTime != nil
}

// GetIdentity returns the value of Identity if it is set or its
// zero value if it is unset.
func (v *PollerInfo) GetIdentity() (o string) {
	if v != nil && v.Identity != nil {
		return *v.Identity
	}

	return
}

// IsSetIdentity returns true if Identity is not nil.
func (v *PollerInfo) IsSetIdentity() bool {
	return v != nil && v.Identity != nil
}

// GetRatePerSecond returns the value of RatePerSecond if it is set or its
// zero value if it is unset.
func (v *PollerInfo) GetRatePerSecond() (o float64) {
	if v != nil && v.RatePerSecond != nil {
		return *v.RatePerSecond
	}

	return
}

// IsSetRatePerSecond returns true if RatePerSecond is not nil.
func (v *PollerInfo) IsSetRatePerSecond() bool {
	return v != nil && v.RatePerSecond != nil
}

type QueryFailedError struct {
	Message string `json:"message,required"`
}

// ToWire translates a QueryFailedError struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *QueryFailedError) ToWire() (wire.Value, error) {
	var (
		fields [1]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	w, err = wire.NewValueString(v.Message), error(nil)
	if err != nil {
		return w, err
	}
	fields[i] = wire.Field{ID: 1, Value: w}
	i++

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a QueryFailedError struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a QueryFailedError struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v QueryFailedError
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *QueryFailedError) FromWire(w wire.Value) error {
	var err error

	messageIsSet := false

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 1:
			if field.Value.Type() == wire.TBinary {
				v.Message, err = field.Value.GetString(), error(nil)
				if err != nil {
					return err
				}
				messageIsSet = true
			}
		}
	}

	if !messageIsSet {
		return errors.New("field Message of QueryFailedError is required")
	}

	return nil
}

// String returns a readable string representation of a QueryFailedError
// struct.
func (v *QueryFailedError) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [1]string
	i := 0
	fields[i] = fmt.Sprintf("Message: %v", v.Message)
	i++

	return fmt.Sprintf("QueryFailedError{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this QueryFailedError match the
// provided QueryFailedError.
//
// This function performs a deep comparison.
func (v *QueryFailedError) Equals(rhs *QueryFailedError) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !(v.Message == rhs.Message) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of QueryFailedError.
func (v *QueryFailedError) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	enc.AddString("message", v.Message)
	return err
}

// GetMessage returns the value of Message if it is set or its
// zero value if it is unset.
func (v *QueryFailedError) GetMessage() (o string) {
	if v != nil {
		o = v.Message
	}
	return
}

func (v *QueryFailedError) Error() string {
	return v.String()
}

type QueryTaskCompletedType int32

const (
	QueryTaskCompletedTypeCompleted QueryTaskCompletedType = 0
	QueryTaskCompletedTypeFailed    QueryTaskCompletedType = 1
)

// QueryTaskCompletedType_Values returns all recognized values of QueryTaskCompletedType.
func QueryTaskCompletedType_Values() []QueryTaskCompletedType {
	return []QueryTaskCompletedType{
		QueryTaskCompletedTypeCompleted,
		QueryTaskCompletedTypeFailed,
	}
}

// UnmarshalText tries to decode QueryTaskCompletedType from a byte slice
// containing its name.
//
//   var v QueryTaskCompletedType
//   err := v.UnmarshalText([]byte("COMPLETED"))
func (v *QueryTaskCompletedType) UnmarshalText(value []byte) error {
	switch s := string(value); s {
	case "COMPLETED":
		*v = QueryTaskCompletedTypeCompleted
		return nil
	case "FAILED":
		*v = QueryTaskCompletedTypeFailed
		return nil
	default:
		val, err := strconv.ParseInt(s, 10, 32)
		if err != nil {
			return fmt.Errorf("unknown enum value %q for %q: %v", s, "QueryTaskCompletedType", err)
		}
		*v = QueryTaskCompletedType(val)
		return nil
	}
}

// MarshalText encodes QueryTaskCompletedType to text.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements the TextMarshaler interface.
func (v QueryTaskCompletedType) MarshalText() ([]byte, error) {
	switch int32(v) {
	case 0:
		return []byte("COMPLETED"), nil
	case 1:
		return []byte("FAILED"), nil
	}
	return []byte(strconv.FormatInt(int64(v), 10)), nil
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of QueryTaskCompletedType.
// Enums are logged as objects, where the value is logged with key "value", and
// if this value's name is known, the name is logged with key "name".
func (v QueryTaskCompletedType) MarshalLogObject(enc zapcore.ObjectEncoder) error {
	enc.AddInt32("value", int32(v))
	switch int32(v) {
	case 0:
		enc.AddString("name", "COMPLETED")
	case 1:
		enc.AddString("name", "FAILED")
	}
	return nil
}

// Ptr returns a pointer to this enum value.
func (v QueryTaskCompletedType) Ptr() *QueryTaskCompletedType {
	return &v
}

// ToWire translates QueryTaskCompletedType into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// Enums are represented as 32-bit integers over the wire.
func (v QueryTaskCompletedType) ToWire() (wire.Value, error) {
	return wire.NewValueI32(int32(v)), nil
}

// FromWire deserializes QueryTaskCompletedType from its Thrift-level
// representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TI32)
//   if err != nil {
//     return QueryTaskCompletedType(0), err
//   }
//
//   var v QueryTaskCompletedType
//   if err := v.FromWire(x); err != nil {
//     return QueryTaskCompletedType(0), err
//   }
//   return v, nil
func (v *QueryTaskCompletedType) FromWire(w wire.Value) error {
	*v = (QueryTaskCompletedType)(w.GetI32())
	return nil
}

// String returns a readable string representation of QueryTaskCompletedType.
func (v QueryTaskCompletedType) String() string {
	w := int32(v)
	switch w {
	case 0:
		return "COMPLETED"
	case 1:
		return "FAILED"
	}
	return fmt.Sprintf("QueryTaskCompletedType(%d)", w)
}

// Equals returns true if this QueryTaskCompletedType value matches the provided
// value.
func (v QueryTaskCompletedType) Equals(rhs QueryTaskCompletedType) bool {
	return v == rhs
}

// MarshalJSON serializes QueryTaskCompletedType into JSON.
//
// If the enum value is recognized, its name is returned. Otherwise,
// its integer value is returned.
//
// This implements json.Marshaler.
func (v QueryTaskCompletedType) MarshalJSON() ([]byte, error) {
	switch int32(v) {
	case 0:
		return ([]byte)("\"COMPLETED\""), nil
	case 1:
		return ([]byte)("\"FAILED\""), nil
	}
	return ([]byte)(strconv.FormatInt(int64(v), 10)), nil
}

// UnmarshalJSON attempts to decode QueryTaskCompletedType from its JSON
// representation.
//
// This implementation supports both, numeric and string inputs. If a
// string is provided, it must be a known enum name.
//
// This implements json.Unmarshaler.
func (v *QueryTaskCompletedType) UnmarshalJSON(text []byte) error {
	d := json.NewDecoder(bytes.NewReader(text))
	d.UseNumber()
	t, err := d.Token()
	if err != nil {
		return err
	}

	switch w := t.(type) {
	case json.Number:
		x, err := w.Int64()
		if err != nil {
			return err
		}
		if x > math.MaxInt32 {
			return fmt.Errorf("enum overflow from JSON %q for %q", text, "QueryTaskCompletedType")
		}
		if x < math.MinInt32 {
			return fmt.Errorf("enum underflow from JSON %q for %q", text, "QueryTaskCompletedType")
		}
		*v = (QueryTaskCompletedType)(x)
		return nil
	case string:
		return v.UnmarshalText([]byte(w))
	default:
		return fmt.Errorf("invalid JSON value %q (%T) to unmarshal into %q", t, t, "QueryTaskCompletedType")
	}
}

type QueryWorkflowRequest struct {
	Domain    *string            `json:"domain,omitempty"`
	Execution *WorkflowExecution `json:"execution,omitempty"`
	Query     *WorkflowQuery     `json:"query,omitempty"`
}

// ToWire translates a QueryWorkflowRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *QueryWorkflowRequest) ToWire() (wire.Value, error) {
	var (
		fields [3]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Execution != nil {
		w, err = v.Execution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.Query != nil {
		w, err = v.Query.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a QueryWorkflowRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a QueryWorkflowRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v QueryWorkflowRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *QueryWorkflowRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.Execution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TStruct {
				v.Query, err = _WorkflowQuery_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a QueryWorkflowRequest
// struct.
func (v *QueryWorkflowRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [3]string
	i := 0
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.Execution != nil {
		fields[i] = fmt.Sprintf("Execution: %v", v.Execution)
		i++
	}
	if v.Query != nil {
		fields[i] = fmt.Sprintf("Query: %v", v.Query)
		i++
	}

	return fmt.Sprintf("QueryWorkflowRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this QueryWorkflowRequest match the
// provided QueryWorkflowRequest.
//
// This function performs a deep comparison.
func (v *QueryWorkflowRequest) Equals(rhs *QueryWorkflowRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !((v.Execution == nil && rhs.Execution == nil) || (v.Execution != nil && rhs.Execution != nil && v.Execution.Equals(rhs.Execution))) {
		return false
	}
	if !((v.Query == nil && rhs.Query == nil) || (v.Query != nil && rhs.Query != nil && v.Query.Equals(rhs.Query))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of QueryWorkflowRequest.
func (v *QueryWorkflowRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.Execution != nil {
		err = multierr.Append(err, enc.AddObject("execution", v.Execution))
	}
	if v.Query != nil {
		err = multierr.Append(err, enc.AddObject("query", v.Query))
	}
	return err
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *QueryWorkflowRequest) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *QueryWorkflowRequest) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetExecution returns the value of Execution if it is set or its
// zero value if it is unset.
func (v *QueryWorkflowRequest) GetExecution() (o *WorkflowExecution) {
	if v != nil && v.Execution != nil {
		return v.Execution
	}

	return
}

// IsSetExecution returns true if Execution is not nil.
func (v *QueryWorkflowRequest) IsSetExecution() bool {
	return v != nil && v.Execution != nil
}

// GetQuery returns the value of Query if it is set or its
// zero value if it is unset.
func (v *QueryWorkflowRequest) GetQuery() (o *WorkflowQuery) {
	if v != nil && v.Query != nil {
		return v.Query
	}

	return
}

// IsSetQuery returns true if Query is not nil.
func (v *QueryWorkflowRequest) IsSetQuery() bool {
	return v != nil && v.Query != nil
}

type QueryWorkflowResponse struct {
	QueryResult []byte `json:"queryResult,omitempty"`
}

// ToWire translates a QueryWorkflowResponse struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *QueryWorkflowResponse) ToWire() (wire.Value, error) {
	var (
		fields [1]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.QueryResult != nil {
		w, err = wire.NewValueBinary(v.QueryResult), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a QueryWorkflowResponse struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a QueryWorkflowResponse struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v QueryWorkflowResponse
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *QueryWorkflowResponse) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				v.QueryResult, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a QueryWorkflowResponse
// struct.
func (v *QueryWorkflowResponse) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [1]string
	i := 0
	if v.QueryResult != nil {
		fields[i] = fmt.Sprintf("QueryResult: %v", v.QueryResult)
		i++
	}

	return fmt.Sprintf("QueryWorkflowResponse{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this QueryWorkflowResponse match the
// provided QueryWorkflowResponse.
//
// This function performs a deep comparison.
func (v *QueryWorkflowResponse) Equals(rhs *QueryWorkflowResponse) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.QueryResult == nil && rhs.QueryResult == nil) || (v.QueryResult != nil && rhs.QueryResult != nil && bytes.Equal(v.QueryResult, rhs.QueryResult))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of QueryWorkflowResponse.
func (v *QueryWorkflowResponse) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.QueryResult != nil {
		enc.AddString("queryResult", base64.StdEncoding.EncodeToString(v.QueryResult))
	}
	return err
}

// GetQueryResult returns the value of QueryResult if it is set or its
// zero value if it is unset.
func (v *QueryWorkflowResponse) GetQueryResult() (o []byte) {
	if v != nil && v.QueryResult != nil {
		return v.QueryResult
	}

	return
}

// IsSetQueryResult returns true if QueryResult is not nil.
func (v *QueryWorkflowResponse) IsSetQueryResult() bool {
	return v != nil && v.QueryResult != nil
}

type RecordActivityTaskHeartbeatByIDRequest struct {
	Domain     *string `json:"domain,omitempty"`
	WorkflowID *string `json:"workflowID,omitempty"`
	RunID      *string `json:"runID,omitempty"`
	ActivityID *string `json:"activityID,omitempty"`
	Details    []byte  `json:"details,omitempty"`
	Identity   *string `json:"identity,omitempty"`
}

// ToWire translates a RecordActivityTaskHeartbeatByIDRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RecordActivityTaskHeartbeatByIDRequest) ToWire() (wire.Value, error) {
	var (
		fields [6]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.WorkflowID != nil {
		w, err = wire.NewValueString(*(v.WorkflowID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.RunID != nil {
		w, err = wire.NewValueString(*(v.RunID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.ActivityID != nil {
		w, err = wire.NewValueString(*(v.ActivityID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.Details != nil {
		w, err = wire.NewValueBinary(v.Details), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.Identity != nil {
		w, err = wire.NewValueString(*(v.Identity)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a RecordActivityTaskHeartbeatByIDRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RecordActivityTaskHeartbeatByIDRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RecordActivityTaskHeartbeatByIDRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RecordActivityTaskHeartbeatByIDRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.WorkflowID = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.RunID = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ActivityID = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TBinary {
				v.Details, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Identity = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RecordActivityTaskHeartbeatByIDRequest
// struct.
func (v *RecordActivityTaskHeartbeatByIDRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [6]string
	i := 0
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.WorkflowID != nil {
		fields[i] = fmt.Sprintf("WorkflowID: %v", *(v.WorkflowID))
		i++
	}
	if v.RunID != nil {
		fields[i] = fmt.Sprintf("RunID: %v", *(v.RunID))
		i++
	}
	if v.ActivityID != nil {
		fields[i] = fmt.Sprintf("ActivityID: %v", *(v.ActivityID))
		i++
	}
	if v.Details != nil {
		fields[i] = fmt.Sprintf("Details: %v", v.Details)
		i++
	}
	if v.Identity != nil {
		fields[i] = fmt.Sprintf("Identity: %v", *(v.Identity))
		i++
	}

	return fmt.Sprintf("RecordActivityTaskHeartbeatByIDRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RecordActivityTaskHeartbeatByIDRequest match the
// provided RecordActivityTaskHeartbeatByIDRequest.
//
// This function performs a deep comparison.
func (v *RecordActivityTaskHeartbeatByIDRequest) Equals(rhs *RecordActivityTaskHeartbeatByIDRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !_String_EqualsPtr(v.WorkflowID, rhs.WorkflowID) {
		return false
	}
	if !_String_EqualsPtr(v.RunID, rhs.RunID) {
		return false
	}
	if !_String_EqualsPtr(v.ActivityID, rhs.ActivityID) {
		return false
	}
	if !((v.Details == nil && rhs.Details == nil) || (v.Details != nil && rhs.Details != nil && bytes.Equal(v.Details, rhs.Details))) {
		return false
	}
	if !_String_EqualsPtr(v.Identity, rhs.Identity) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RecordActivityTaskHeartbeatByIDRequest.
func (v *RecordActivityTaskHeartbeatByIDRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.WorkflowID != nil {
		enc.AddString("workflowID", *v.WorkflowID)
	}
	if v.RunID != nil {
		enc.AddString("runID", *v.RunID)
	}
	if v.ActivityID != nil {
		enc.AddString("activityID", *v.ActivityID)
	}
	if v.Details != nil {
		enc.AddString("details", base64.StdEncoding.EncodeToString(v.Details))
	}
	if v.Identity != nil {
		enc.AddString("identity", *v.Identity)
	}
	return err
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *RecordActivityTaskHeartbeatByIDRequest) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *RecordActivityTaskHeartbeatByIDRequest) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetWorkflowID returns the value of WorkflowID if it is set or its
// zero value if it is unset.
func (v *RecordActivityTaskHeartbeatByIDRequest) GetWorkflowID() (o string) {
	if v != nil && v.WorkflowID != nil {
		return *v.WorkflowID
	}

	return
}

// IsSetWorkflowID returns true if WorkflowID is not nil.
func (v *RecordActivityTaskHeartbeatByIDRequest) IsSetWorkflowID() bool {
	return v != nil && v.WorkflowID != nil
}

// GetRunID returns the value of RunID if it is set or its
// zero value if it is unset.
func (v *RecordActivityTaskHeartbeatByIDRequest) GetRunID() (o string) {
	if v != nil && v.RunID != nil {
		return *v.RunID
	}

	return
}

// IsSetRunID returns true if RunID is not nil.
func (v *RecordActivityTaskHeartbeatByIDRequest) IsSetRunID() bool {
	return v != nil && v.RunID != nil
}

// GetActivityID returns the value of ActivityID if it is set or its
// zero value if it is unset.
func (v *RecordActivityTaskHeartbeatByIDRequest) GetActivityID() (o string) {
	if v != nil && v.ActivityID != nil {
		return *v.ActivityID
	}

	return
}

// IsSetActivityID returns true if ActivityID is not nil.
func (v *RecordActivityTaskHeartbeatByIDRequest) IsSetActivityID() bool {
	return v != nil && v.ActivityID != nil
}

// GetDetails returns the value of Details if it is set or its
// zero value if it is unset.
func (v *RecordActivityTaskHeartbeatByIDRequest) GetDetails() (o []byte) {
	if v != nil && v.Details != nil {
		return v.Details
	}

	return
}

// IsSetDetails returns true if Details is not nil.
func (v *RecordActivityTaskHeartbeatByIDRequest) IsSetDetails() bool {
	return v != nil && v.Details != nil
}

// GetIdentity returns the value of Identity if it is set or its
// zero value if it is unset.
func (v *RecordActivityTaskHeartbeatByIDRequest) GetIdentity() (o string) {
	if v != nil && v.Identity != nil {
		return *v.Identity
	}

	return
}

// IsSetIdentity returns true if Identity is not nil.
func (v *RecordActivityTaskHeartbeatByIDRequest) IsSetIdentity() bool {
	return v != nil && v.Identity != nil
}

type RecordActivityTaskHeartbeatRequest struct {
	TaskToken []byte  `json:"taskToken,omitempty"`
	Details   []byte  `json:"details,omitempty"`
	Identity  *string `json:"identity,omitempty"`
}

// ToWire translates a RecordActivityTaskHeartbeatRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RecordActivityTaskHeartbeatRequest) ToWire() (wire.Value, error) {
	var (
		fields [3]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.TaskToken != nil {
		w, err = wire.NewValueBinary(v.TaskToken), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Details != nil {
		w, err = wire.NewValueBinary(v.Details), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.Identity != nil {
		w, err = wire.NewValueString(*(v.Identity)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a RecordActivityTaskHeartbeatRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RecordActivityTaskHeartbeatRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RecordActivityTaskHeartbeatRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RecordActivityTaskHeartbeatRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				v.TaskToken, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				v.Details, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Identity = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RecordActivityTaskHeartbeatRequest
// struct.
func (v *RecordActivityTaskHeartbeatRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [3]string
	i := 0
	if v.TaskToken != nil {
		fields[i] = fmt.Sprintf("TaskToken: %v", v.TaskToken)
		i++
	}
	if v.Details != nil {
		fields[i] = fmt.Sprintf("Details: %v", v.Details)
		i++
	}
	if v.Identity != nil {
		fields[i] = fmt.Sprintf("Identity: %v", *(v.Identity))
		i++
	}

	return fmt.Sprintf("RecordActivityTaskHeartbeatRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RecordActivityTaskHeartbeatRequest match the
// provided RecordActivityTaskHeartbeatRequest.
//
// This function performs a deep comparison.
func (v *RecordActivityTaskHeartbeatRequest) Equals(rhs *RecordActivityTaskHeartbeatRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.TaskToken == nil && rhs.TaskToken == nil) || (v.TaskToken != nil && rhs.TaskToken != nil && bytes.Equal(v.TaskToken, rhs.TaskToken))) {
		return false
	}
	if !((v.Details == nil && rhs.Details == nil) || (v.Details != nil && rhs.Details != nil && bytes.Equal(v.Details, rhs.Details))) {
		return false
	}
	if !_String_EqualsPtr(v.Identity, rhs.Identity) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RecordActivityTaskHeartbeatRequest.
func (v *RecordActivityTaskHeartbeatRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.TaskToken != nil {
		enc.AddString("taskToken", base64.StdEncoding.EncodeToString(v.TaskToken))
	}
	if v.Details != nil {
		enc.AddString("details", base64.StdEncoding.EncodeToString(v.Details))
	}
	if v.Identity != nil {
		enc.AddString("identity", *v.Identity)
	}
	return err
}

// GetTaskToken returns the value of TaskToken if it is set or its
// zero value if it is unset.
func (v *RecordActivityTaskHeartbeatRequest) GetTaskToken() (o []byte) {
	if v != nil && v.TaskToken != nil {
		return v.TaskToken
	}

	return
}

// IsSetTaskToken returns true if TaskToken is not nil.
func (v *RecordActivityTaskHeartbeatRequest) IsSetTaskToken() bool {
	return v != nil && v.TaskToken != nil
}

// GetDetails returns the value of Details if it is set or its
// zero value if it is unset.
func (v *RecordActivityTaskHeartbeatRequest) GetDetails() (o []byte) {
	if v != nil && v.Details != nil {
		return v.Details
	}

	return
}

// IsSetDetails returns true if Details is not nil.
func (v *RecordActivityTaskHeartbeatRequest) IsSetDetails() bool {
	return v != nil && v.Details != nil
}

// GetIdentity returns the value of Identity if it is set or its
// zero value if it is unset.
func (v *RecordActivityTaskHeartbeatRequest) GetIdentity() (o string) {
	if v != nil && v.Identity != nil {
		return *v.Identity
	}

	return
}

// IsSetIdentity returns true if Identity is not nil.
func (v *RecordActivityTaskHeartbeatRequest) IsSetIdentity() bool {
	return v != nil && v.Identity != nil
}

type RecordActivityTaskHeartbeatResponse struct {
	CancelRequested *bool `json:"cancelRequested,omitempty"`
}

// ToWire translates a RecordActivityTaskHeartbeatResponse struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RecordActivityTaskHeartbeatResponse) ToWire() (wire.Value, error) {
	var (
		fields [1]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.CancelRequested != nil {
		w, err = wire.NewValueBool(*(v.CancelRequested)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a RecordActivityTaskHeartbeatResponse struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RecordActivityTaskHeartbeatResponse struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RecordActivityTaskHeartbeatResponse
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RecordActivityTaskHeartbeatResponse) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBool {
				var x bool
				x, err = field.Value.GetBool(), error(nil)
				v.CancelRequested = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RecordActivityTaskHeartbeatResponse
// struct.
func (v *RecordActivityTaskHeartbeatResponse) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [1]string
	i := 0
	if v.CancelRequested != nil {
		fields[i] = fmt.Sprintf("CancelRequested: %v", *(v.CancelRequested))
		i++
	}

	return fmt.Sprintf("RecordActivityTaskHeartbeatResponse{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RecordActivityTaskHeartbeatResponse match the
// provided RecordActivityTaskHeartbeatResponse.
//
// This function performs a deep comparison.
func (v *RecordActivityTaskHeartbeatResponse) Equals(rhs *RecordActivityTaskHeartbeatResponse) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_Bool_EqualsPtr(v.CancelRequested, rhs.CancelRequested) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RecordActivityTaskHeartbeatResponse.
func (v *RecordActivityTaskHeartbeatResponse) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.CancelRequested != nil {
		enc.AddBool("cancelRequested", *v.CancelRequested)
	}
	return err
}

// GetCancelRequested returns the value of CancelRequested if it is set or its
// zero value if it is unset.
func (v *RecordActivityTaskHeartbeatResponse) GetCancelRequested() (o bool) {
	if v != nil && v.CancelRequested != nil {
		return *v.CancelRequested
	}

	return
}

// IsSetCancelRequested returns true if CancelRequested is not nil.
func (v *RecordActivityTaskHeartbeatResponse) IsSetCancelRequested() bool {
	return v != nil && v.CancelRequested != nil
}

type RecordMarkerDecisionAttributes struct {
	MarkerName *string `json:"markerName,omitempty"`
	Details    []byte  `json:"details,omitempty"`
	Header     *Header `json:"header,omitempty"`
}

// ToWire translates a RecordMarkerDecisionAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RecordMarkerDecisionAttributes) ToWire() (wire.Value, error) {
	var (
		fields [3]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.MarkerName != nil {
		w, err = wire.NewValueString(*(v.MarkerName)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Details != nil {
		w, err = wire.NewValueBinary(v.Details), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.Header != nil {
		w, err = v.Header.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a RecordMarkerDecisionAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RecordMarkerDecisionAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RecordMarkerDecisionAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RecordMarkerDecisionAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.MarkerName = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				v.Details, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TStruct {
				v.Header, err = _Header_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RecordMarkerDecisionAttributes
// struct.
func (v *RecordMarkerDecisionAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [3]string
	i := 0
	if v.MarkerName != nil {
		fields[i] = fmt.Sprintf("MarkerName: %v", *(v.MarkerName))
		i++
	}
	if v.Details != nil {
		fields[i] = fmt.Sprintf("Details: %v", v.Details)
		i++
	}
	if v.Header != nil {
		fields[i] = fmt.Sprintf("Header: %v", v.Header)
		i++
	}

	return fmt.Sprintf("RecordMarkerDecisionAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RecordMarkerDecisionAttributes match the
// provided RecordMarkerDecisionAttributes.
//
// This function performs a deep comparison.
func (v *RecordMarkerDecisionAttributes) Equals(rhs *RecordMarkerDecisionAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.MarkerName, rhs.MarkerName) {
		return false
	}
	if !((v.Details == nil && rhs.Details == nil) || (v.Details != nil && rhs.Details != nil && bytes.Equal(v.Details, rhs.Details))) {
		return false
	}
	if !((v.Header == nil && rhs.Header == nil) || (v.Header != nil && rhs.Header != nil && v.Header.Equals(rhs.Header))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RecordMarkerDecisionAttributes.
func (v *RecordMarkerDecisionAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.MarkerName != nil {
		enc.AddString("markerName", *v.MarkerName)
	}
	if v.Details != nil {
		enc.AddString("details", base64.StdEncoding.EncodeToString(v.Details))
	}
	if v.Header != nil {
		err = multierr.Append(err, enc.AddObject("header", v.Header))
	}
	return err
}

// GetMarkerName returns the value of MarkerName if it is set or its
// zero value if it is unset.
func (v *RecordMarkerDecisionAttributes) GetMarkerName() (o string) {
	if v != nil && v.MarkerName != nil {
		return *v.MarkerName
	}

	return
}

// IsSetMarkerName returns true if MarkerName is not nil.
func (v *RecordMarkerDecisionAttributes) IsSetMarkerName() bool {
	return v != nil && v.MarkerName != nil
}

// GetDetails returns the value of Details if it is set or its
// zero value if it is unset.
func (v *RecordMarkerDecisionAttributes) GetDetails() (o []byte) {
	if v != nil && v.Details != nil {
		return v.Details
	}

	return
}

// IsSetDetails returns true if Details is not nil.
func (v *RecordMarkerDecisionAttributes) IsSetDetails() bool {
	return v != nil && v.Details != nil
}

// GetHeader returns the value of Header if it is set or its
// zero value if it is unset.
func (v *RecordMarkerDecisionAttributes) GetHeader() (o *Header) {
	if v != nil && v.Header != nil {
		return v.Header
	}

	return
}

// IsSetHeader returns true if Header is not nil.
func (v *RecordMarkerDecisionAttributes) IsSetHeader() bool {
	return v != nil && v.Header != nil
}

type RegisterDomainRequest struct {
	Name                                   *string                            `json:"name,omitempty"`
	Description                            *string                            `json:"description,omitempty"`
	OwnerEmail                             *string                            `json:"ownerEmail,omitempty"`
	WorkflowExecutionRetentionPeriodInDays *int32                             `json:"workflowExecutionRetentionPeriodInDays,omitempty"`
	EmitMetric                             *bool                              `json:"emitMetric,omitempty"`
	Clusters                               []*ClusterReplicationConfiguration `json:"clusters,omitempty"`
	ActiveClusterName                      *string                            `json:"activeClusterName,omitempty"`
	Data                                   map[string]string                  `json:"data,omitempty"`
	SecurityToken                          *string                            `json:"securityToken,omitempty"`
	ArchivalStatus                         *ArchivalStatus                    `json:"archivalStatus,omitempty"`
	ArchivalBucketName                     *string                            `json:"archivalBucketName,omitempty"`
}

// ToWire translates a RegisterDomainRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RegisterDomainRequest) ToWire() (wire.Value, error) {
	var (
		fields [11]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Name != nil {
		w, err = wire.NewValueString(*(v.Name)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Description != nil {
		w, err = wire.NewValueString(*(v.Description)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.OwnerEmail != nil {
		w, err = wire.NewValueString(*(v.OwnerEmail)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.WorkflowExecutionRetentionPeriodInDays != nil {
		w, err = wire.NewValueI32(*(v.WorkflowExecutionRetentionPeriodInDays)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.EmitMetric != nil {
		w, err = wire.NewValueBool(*(v.EmitMetric)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.Clusters != nil {
		w, err = wire.NewValueList(_List_ClusterReplicationConfiguration_ValueList(v.Clusters)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}
	if v.ActiveClusterName != nil {
		w, err = wire.NewValueString(*(v.ActiveClusterName)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 70, Value: w}
		i++
	}
	if v.Data != nil {
		w, err = wire.NewValueMap(_Map_String_String_MapItemList(v.Data)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 80, Value: w}
		i++
	}
	if v.SecurityToken != nil {
		w, err = wire.NewValueString(*(v.SecurityToken)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 90, Value: w}
		i++
	}
	if v.ArchivalStatus != nil {
		w, err = v.ArchivalStatus.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 100, Value: w}
		i++
	}
	if v.ArchivalBucketName != nil {
		w, err = wire.NewValueString(*(v.ArchivalBucketName)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 110, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a RegisterDomainRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RegisterDomainRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RegisterDomainRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RegisterDomainRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Name = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Description = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.OwnerEmail = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.WorkflowExecutionRetentionPeriodInDays = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TBool {
				var x bool
				x, err = field.Value.GetBool(), error(nil)
				v.EmitMetric = &x
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TList {
				v.Clusters, err = _List_ClusterReplicationConfiguration_Read(field.Value.GetList())
				if err != nil {
					return err
				}

			}
		case 70:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ActiveClusterName = &x
				if err != nil {
					return err
				}

			}
		case 80:
			if field.Value.Type() == wire.TMap {
				v.Data, err = _Map_String_String_Read(field.Value.GetMap())
				if err != nil {
					return err
				}

			}
		case 90:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.SecurityToken = &x
				if err != nil {
					return err
				}

			}
		case 100:
			if field.Value.Type() == wire.TI32 {
				var x ArchivalStatus
				x, err = _ArchivalStatus_Read(field.Value)
				v.ArchivalStatus = &x
				if err != nil {
					return err
				}

			}
		case 110:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ArchivalBucketName = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RegisterDomainRequest
// struct.
func (v *RegisterDomainRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [11]string
	i := 0
	if v.Name != nil {
		fields[i] = fmt.Sprintf("Name: %v", *(v.Name))
		i++
	}
	if v.Description != nil {
		fields[i] = fmt.Sprintf("Description: %v", *(v.Description))
		i++
	}
	if v.OwnerEmail != nil {
		fields[i] = fmt.Sprintf("OwnerEmail: %v", *(v.OwnerEmail))
		i++
	}
	if v.WorkflowExecutionRetentionPeriodInDays != nil {
		fields[i] = fmt.Sprintf("WorkflowExecutionRetentionPeriodInDays: %v", *(v.WorkflowExecutionRetentionPeriodInDays))
		i++
	}
	if v.EmitMetric != nil {
		fields[i] = fmt.Sprintf("EmitMetric: %v", *(v.EmitMetric))
		i++
	}
	if v.Clusters != nil {
		fields[i] = fmt.Sprintf("Clusters: %v", v.Clusters)
		i++
	}
	if v.ActiveClusterName != nil {
		fields[i] = fmt.Sprintf("ActiveClusterName: %v", *(v.ActiveClusterName))
		i++
	}
	if v.Data != nil {
		fields[i] = fmt.Sprintf("Data: %v", v.Data)
		i++
	}
	if v.SecurityToken != nil {
		fields[i] = fmt.Sprintf("SecurityToken: %v", *(v.SecurityToken))
		i++
	}
	if v.ArchivalStatus != nil {
		fields[i] = fmt.Sprintf("ArchivalStatus: %v", *(v.ArchivalStatus))
		i++
	}
	if v.ArchivalBucketName != nil {
		fields[i] = fmt.Sprintf("ArchivalBucketName: %v", *(v.ArchivalBucketName))
		i++
	}

	return fmt.Sprintf("RegisterDomainRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RegisterDomainRequest match the
// provided RegisterDomainRequest.
//
// This function performs a deep comparison.
func (v *RegisterDomainRequest) Equals(rhs *RegisterDomainRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Name, rhs.Name) {
		return false
	}
	if !_String_EqualsPtr(v.Description, rhs.Description) {
		return false
	}
	if !_String_EqualsPtr(v.OwnerEmail, rhs.OwnerEmail) {
		return false
	}
	if !_I32_EqualsPtr(v.WorkflowExecutionRetentionPeriodInDays, rhs.WorkflowExecutionRetentionPeriodInDays) {
		return false
	}
	if !_Bool_EqualsPtr(v.EmitMetric, rhs.EmitMetric) {
		return false
	}
	if !((v.Clusters == nil && rhs.Clusters == nil) || (v.Clusters != nil && rhs.Clusters != nil && _List_ClusterReplicationConfiguration_Equals(v.Clusters, rhs.Clusters))) {
		return false
	}
	if !_String_EqualsPtr(v.ActiveClusterName, rhs.ActiveClusterName) {
		return false
	}
	if !((v.Data == nil && rhs.Data == nil) || (v.Data != nil && rhs.Data != nil && _Map_String_String_Equals(v.Data, rhs.Data))) {
		return false
	}
	if !_String_EqualsPtr(v.SecurityToken, rhs.SecurityToken) {
		return false
	}
	if !_ArchivalStatus_EqualsPtr(v.ArchivalStatus, rhs.ArchivalStatus) {
		return false
	}
	if !_String_EqualsPtr(v.ArchivalBucketName, rhs.ArchivalBucketName) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RegisterDomainRequest.
func (v *RegisterDomainRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Name != nil {
		enc.AddString("name", *v.Name)
	}
	if v.Description != nil {
		enc.AddString("description", *v.Description)
	}
	if v.OwnerEmail != nil {
		enc.AddString("ownerEmail", *v.OwnerEmail)
	}
	if v.WorkflowExecutionRetentionPeriodInDays != nil {
		enc.AddInt32("workflowExecutionRetentionPeriodInDays", *v.WorkflowExecutionRetentionPeriodInDays)
	}
	if v.EmitMetric != nil {
		enc.AddBool("emitMetric", *v.EmitMetric)
	}
	if v.Clusters != nil {
		err = multierr.Append(err, enc.AddArray("clusters", (_List_ClusterReplicationConfiguration_Zapper)(v.Clusters)))
	}
	if v.ActiveClusterName != nil {
		enc.AddString("activeClusterName", *v.ActiveClusterName)
	}
	if v.Data != nil {
		err = multierr.Append(err, enc.AddObject("data", (_Map_String_String_Zapper)(v.Data)))
	}
	if v.SecurityToken != nil {
		enc.AddString("securityToken", *v.SecurityToken)
	}
	if v.ArchivalStatus != nil {
		err = multierr.Append(err, enc.AddObject("archivalStatus", *v.ArchivalStatus))
	}
	if v.ArchivalBucketName != nil {
		enc.AddString("archivalBucketName", *v.ArchivalBucketName)
	}
	return err
}

// GetName returns the value of Name if it is set or its
// zero value if it is unset.
func (v *RegisterDomainRequest) GetName() (o string) {
	if v != nil && v.Name != nil {
		return *v.Name
	}

	return
}

// IsSetName returns true if Name is not nil.
func (v *RegisterDomainRequest) IsSetName() bool {
	return v != nil && v.Name != nil
}

// GetDescription returns the value of Description if it is set or its
// zero value if it is unset.
func (v *RegisterDomainRequest) GetDescription() (o string) {
	if v != nil && v.Description != nil {
		return *v.Description
	}

	return
}

// IsSetDescription returns true if Description is not nil.
func (v *RegisterDomainRequest) IsSetDescription() bool {
	return v != nil && v.Description != nil
}

// GetOwnerEmail returns the value of OwnerEmail if it is set or its
// zero value if it is unset.
func (v *RegisterDomainRequest) GetOwnerEmail() (o string) {
	if v != nil && v.OwnerEmail != nil {
		return *v.OwnerEmail
	}

	return
}

// IsSetOwnerEmail returns true if OwnerEmail is not nil.
func (v *RegisterDomainRequest) IsSetOwnerEmail() bool {
	return v != nil && v.OwnerEmail != nil
}

// GetWorkflowExecutionRetentionPeriodInDays returns the value of WorkflowExecutionRetentionPeriodInDays if it is set or its
// zero value if it is unset.
func (v *RegisterDomainRequest) GetWorkflowExecutionRetentionPeriodInDays() (o int32) {
	if v != nil && v.WorkflowExecutionRetentionPeriodInDays != nil {
		return *v.WorkflowExecutionRetentionPeriodInDays
	}

	return
}

// IsSetWorkflowExecutionRetentionPeriodInDays returns true if WorkflowExecutionRetentionPeriodInDays is not nil.
func (v *RegisterDomainRequest) IsSetWorkflowExecutionRetentionPeriodInDays() bool {
	return v != nil && v.WorkflowExecutionRetentionPeriodInDays != nil
}

// GetEmitMetric returns the value of EmitMetric if it is set or its
// zero value if it is unset.
func (v *RegisterDomainRequest) GetEmitMetric() (o bool) {
	if v != nil && v.EmitMetric != nil {
		return *v.EmitMetric
	}

	return
}

// IsSetEmitMetric returns true if EmitMetric is not nil.
func (v *RegisterDomainRequest) IsSetEmitMetric() bool {
	return v != nil && v.EmitMetric != nil
}

// GetClusters returns the value of Clusters if it is set or its
// zero value if it is unset.
func (v *RegisterDomainRequest) GetClusters() (o []*ClusterReplicationConfiguration) {
	if v != nil && v.Clusters != nil {
		return v.Clusters
	}

	return
}

// IsSetClusters returns true if Clusters is not nil.
func (v *RegisterDomainRequest) IsSetClusters() bool {
	return v != nil && v.Clusters != nil
}

// GetActiveClusterName returns the value of ActiveClusterName if it is set or its
// zero value if it is unset.
func (v *RegisterDomainRequest) GetActiveClusterName() (o string) {
	if v != nil && v.ActiveClusterName != nil {
		return *v.ActiveClusterName
	}

	return
}

// IsSetActiveClusterName returns true if ActiveClusterName is not nil.
func (v *RegisterDomainRequest) IsSetActiveClusterName() bool {
	return v != nil && v.ActiveClusterName != nil
}

// GetData returns the value of Data if it is set or its
// zero value if it is unset.
func (v *RegisterDomainRequest) GetData() (o map[string]string) {
	if v != nil && v.Data != nil {
		return v.Data
	}

	return
}

// IsSetData returns true if Data is not nil.
func (v *RegisterDomainRequest) IsSetData() bool {
	return v != nil && v.Data != nil
}

// GetSecurityToken returns the value of SecurityToken if it is set or its
// zero value if it is unset.
func (v *RegisterDomainRequest) GetSecurityToken() (o string) {
	if v != nil && v.SecurityToken != nil {
		return *v.SecurityToken
	}

	return
}

// IsSetSecurityToken returns true if SecurityToken is not nil.
func (v *RegisterDomainRequest) IsSetSecurityToken() bool {
	return v != nil && v.SecurityToken != nil
}

// GetArchivalStatus returns the value of ArchivalStatus if it is set or its
// zero value if it is unset.
func (v *RegisterDomainRequest) GetArchivalStatus() (o ArchivalStatus) {
	if v != nil && v.ArchivalStatus != nil {
		return *v.ArchivalStatus
	}

	return
}

// IsSetArchivalStatus returns true if ArchivalStatus is not nil.
func (v *RegisterDomainRequest) IsSetArchivalStatus() bool {
	return v != nil && v.ArchivalStatus != nil
}

// GetArchivalBucketName returns the value of ArchivalBucketName if it is set or its
// zero value if it is unset.
func (v *RegisterDomainRequest) GetArchivalBucketName() (o string) {
	if v != nil && v.ArchivalBucketName != nil {
		return *v.ArchivalBucketName
	}

	return
}

// IsSetArchivalBucketName returns true if ArchivalBucketName is not nil.
func (v *RegisterDomainRequest) IsSetArchivalBucketName() bool {
	return v != nil && v.ArchivalBucketName != nil
}

type ReplicationInfo struct {
	Version     *int64 `json:"version,omitempty"`
	LastEventId *int64 `json:"lastEventId,omitempty"`
}

// ToWire translates a ReplicationInfo struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ReplicationInfo) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Version != nil {
		w, err = wire.NewValueI64(*(v.Version)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.LastEventId != nil {
		w, err = wire.NewValueI64(*(v.LastEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ReplicationInfo struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ReplicationInfo struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ReplicationInfo
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ReplicationInfo) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.Version = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.LastEventId = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ReplicationInfo
// struct.
func (v *ReplicationInfo) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.Version != nil {
		fields[i] = fmt.Sprintf("Version: %v", *(v.Version))
		i++
	}
	if v.LastEventId != nil {
		fields[i] = fmt.Sprintf("LastEventId: %v", *(v.LastEventId))
		i++
	}

	return fmt.Sprintf("ReplicationInfo{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ReplicationInfo match the
// provided ReplicationInfo.
//
// This function performs a deep comparison.
func (v *ReplicationInfo) Equals(rhs *ReplicationInfo) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_I64_EqualsPtr(v.Version, rhs.Version) {
		return false
	}
	if !_I64_EqualsPtr(v.LastEventId, rhs.LastEventId) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ReplicationInfo.
func (v *ReplicationInfo) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Version != nil {
		enc.AddInt64("version", *v.Version)
	}
	if v.LastEventId != nil {
		enc.AddInt64("lastEventId", *v.LastEventId)
	}
	return err
}

// GetVersion returns the value of Version if it is set or its
// zero value if it is unset.
func (v *ReplicationInfo) GetVersion() (o int64) {
	if v != nil && v.Version != nil {
		return *v.Version
	}

	return
}

// IsSetVersion returns true if Version is not nil.
func (v *ReplicationInfo) IsSetVersion() bool {
	return v != nil && v.Version != nil
}

// GetLastEventId returns the value of LastEventId if it is set or its
// zero value if it is unset.
func (v *ReplicationInfo) GetLastEventId() (o int64) {
	if v != nil && v.LastEventId != nil {
		return *v.LastEventId
	}

	return
}

// IsSetLastEventId returns true if LastEventId is not nil.
func (v *ReplicationInfo) IsSetLastEventId() bool {
	return v != nil && v.LastEventId != nil
}

type RequestCancelActivityTaskDecisionAttributes struct {
	ActivityId *string `json:"activityId,omitempty"`
}

// ToWire translates a RequestCancelActivityTaskDecisionAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RequestCancelActivityTaskDecisionAttributes) ToWire() (wire.Value, error) {
	var (
		fields [1]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.ActivityId != nil {
		w, err = wire.NewValueString(*(v.ActivityId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a RequestCancelActivityTaskDecisionAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RequestCancelActivityTaskDecisionAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RequestCancelActivityTaskDecisionAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RequestCancelActivityTaskDecisionAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ActivityId = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RequestCancelActivityTaskDecisionAttributes
// struct.
func (v *RequestCancelActivityTaskDecisionAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [1]string
	i := 0
	if v.ActivityId != nil {
		fields[i] = fmt.Sprintf("ActivityId: %v", *(v.ActivityId))
		i++
	}

	return fmt.Sprintf("RequestCancelActivityTaskDecisionAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RequestCancelActivityTaskDecisionAttributes match the
// provided RequestCancelActivityTaskDecisionAttributes.
//
// This function performs a deep comparison.
func (v *RequestCancelActivityTaskDecisionAttributes) Equals(rhs *RequestCancelActivityTaskDecisionAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.ActivityId, rhs.ActivityId) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RequestCancelActivityTaskDecisionAttributes.
func (v *RequestCancelActivityTaskDecisionAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.ActivityId != nil {
		enc.AddString("activityId", *v.ActivityId)
	}
	return err
}

// GetActivityId returns the value of ActivityId if it is set or its
// zero value if it is unset.
func (v *RequestCancelActivityTaskDecisionAttributes) GetActivityId() (o string) {
	if v != nil && v.ActivityId != nil {
		return *v.ActivityId
	}

	return
}

// IsSetActivityId returns true if ActivityId is not nil.
func (v *RequestCancelActivityTaskDecisionAttributes) IsSetActivityId() bool {
	return v != nil && v.ActivityId != nil
}

type RequestCancelActivityTaskFailedEventAttributes struct {
	ActivityId                   *string `json:"activityId,omitempty"`
	Cause                        *string `json:"cause,omitempty"`
	DecisionTaskCompletedEventId *int64  `json:"decisionTaskCompletedEventId,omitempty"`
}

// ToWire translates a RequestCancelActivityTaskFailedEventAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RequestCancelActivityTaskFailedEventAttributes) ToWire() (wire.Value, error) {
	var (
		fields [3]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.ActivityId != nil {
		w, err = wire.NewValueString(*(v.ActivityId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Cause != nil {
		w, err = wire.NewValueString(*(v.Cause)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.DecisionTaskCompletedEventId != nil {
		w, err = wire.NewValueI64(*(v.DecisionTaskCompletedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a RequestCancelActivityTaskFailedEventAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RequestCancelActivityTaskFailedEventAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RequestCancelActivityTaskFailedEventAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RequestCancelActivityTaskFailedEventAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ActivityId = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Cause = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.DecisionTaskCompletedEventId = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RequestCancelActivityTaskFailedEventAttributes
// struct.
func (v *RequestCancelActivityTaskFailedEventAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [3]string
	i := 0
	if v.ActivityId != nil {
		fields[i] = fmt.Sprintf("ActivityId: %v", *(v.ActivityId))
		i++
	}
	if v.Cause != nil {
		fields[i] = fmt.Sprintf("Cause: %v", *(v.Cause))
		i++
	}
	if v.DecisionTaskCompletedEventId != nil {
		fields[i] = fmt.Sprintf("DecisionTaskCompletedEventId: %v", *(v.DecisionTaskCompletedEventId))
		i++
	}

	return fmt.Sprintf("RequestCancelActivityTaskFailedEventAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RequestCancelActivityTaskFailedEventAttributes match the
// provided RequestCancelActivityTaskFailedEventAttributes.
//
// This function performs a deep comparison.
func (v *RequestCancelActivityTaskFailedEventAttributes) Equals(rhs *RequestCancelActivityTaskFailedEventAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.ActivityId, rhs.ActivityId) {
		return false
	}
	if !_String_EqualsPtr(v.Cause, rhs.Cause) {
		return false
	}
	if !_I64_EqualsPtr(v.DecisionTaskCompletedEventId, rhs.DecisionTaskCompletedEventId) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RequestCancelActivityTaskFailedEventAttributes.
func (v *RequestCancelActivityTaskFailedEventAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.ActivityId != nil {
		enc.AddString("activityId", *v.ActivityId)
	}
	if v.Cause != nil {
		enc.AddString("cause", *v.Cause)
	}
	if v.DecisionTaskCompletedEventId != nil {
		enc.AddInt64("decisionTaskCompletedEventId", *v.DecisionTaskCompletedEventId)
	}
	return err
}

// GetActivityId returns the value of ActivityId if it is set or its
// zero value if it is unset.
func (v *RequestCancelActivityTaskFailedEventAttributes) GetActivityId() (o string) {
	if v != nil && v.ActivityId != nil {
		return *v.ActivityId
	}

	return
}

// IsSetActivityId returns true if ActivityId is not nil.
func (v *RequestCancelActivityTaskFailedEventAttributes) IsSetActivityId() bool {
	return v != nil && v.ActivityId != nil
}

// GetCause returns the value of Cause if it is set or its
// zero value if it is unset.
func (v *RequestCancelActivityTaskFailedEventAttributes) GetCause() (o string) {
	if v != nil && v.Cause != nil {
		return *v.Cause
	}

	return
}

// IsSetCause returns true if Cause is not nil.
func (v *RequestCancelActivityTaskFailedEventAttributes) IsSetCause() bool {
	return v != nil && v.Cause != nil
}

// GetDecisionTaskCompletedEventId returns the value of DecisionTaskCompletedEventId if it is set or its
// zero value if it is unset.
func (v *RequestCancelActivityTaskFailedEventAttributes) GetDecisionTaskCompletedEventId() (o int64) {
	if v != nil && v.DecisionTaskCompletedEventId != nil {
		return *v.DecisionTaskCompletedEventId
	}

	return
}

// IsSetDecisionTaskCompletedEventId returns true if DecisionTaskCompletedEventId is not nil.
func (v *RequestCancelActivityTaskFailedEventAttributes) IsSetDecisionTaskCompletedEventId() bool {
	return v != nil && v.DecisionTaskCompletedEventId != nil
}

type RequestCancelExternalWorkflowExecutionDecisionAttributes struct {
	Domain            *string `json:"domain,omitempty"`
	WorkflowId        *string `json:"workflowId,omitempty"`
	RunId             *string `json:"runId,omitempty"`
	Control           []byte  `json:"control,omitempty"`
	ChildWorkflowOnly *bool   `json:"childWorkflowOnly,omitempty"`
}

// ToWire translates a RequestCancelExternalWorkflowExecutionDecisionAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RequestCancelExternalWorkflowExecutionDecisionAttributes) ToWire() (wire.Value, error) {
	var (
		fields [5]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.WorkflowId != nil {
		w, err = wire.NewValueString(*(v.WorkflowId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.RunId != nil {
		w, err = wire.NewValueString(*(v.RunId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.Control != nil {
		w, err = wire.NewValueBinary(v.Control), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.ChildWorkflowOnly != nil {
		w, err = wire.NewValueBool(*(v.ChildWorkflowOnly)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a RequestCancelExternalWorkflowExecutionDecisionAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RequestCancelExternalWorkflowExecutionDecisionAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RequestCancelExternalWorkflowExecutionDecisionAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RequestCancelExternalWorkflowExecutionDecisionAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.WorkflowId = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.RunId = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBinary {
				v.Control, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TBool {
				var x bool
				x, err = field.Value.GetBool(), error(nil)
				v.ChildWorkflowOnly = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RequestCancelExternalWorkflowExecutionDecisionAttributes
// struct.
func (v *RequestCancelExternalWorkflowExecutionDecisionAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [5]string
	i := 0
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.WorkflowId != nil {
		fields[i] = fmt.Sprintf("WorkflowId: %v", *(v.WorkflowId))
		i++
	}
	if v.RunId != nil {
		fields[i] = fmt.Sprintf("RunId: %v", *(v.RunId))
		i++
	}
	if v.Control != nil {
		fields[i] = fmt.Sprintf("Control: %v", v.Control)
		i++
	}
	if v.ChildWorkflowOnly != nil {
		fields[i] = fmt.Sprintf("ChildWorkflowOnly: %v", *(v.ChildWorkflowOnly))
		i++
	}

	return fmt.Sprintf("RequestCancelExternalWorkflowExecutionDecisionAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RequestCancelExternalWorkflowExecutionDecisionAttributes match the
// provided RequestCancelExternalWorkflowExecutionDecisionAttributes.
//
// This function performs a deep comparison.
func (v *RequestCancelExternalWorkflowExecutionDecisionAttributes) Equals(rhs *RequestCancelExternalWorkflowExecutionDecisionAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !_String_EqualsPtr(v.WorkflowId, rhs.WorkflowId) {
		return false
	}
	if !_String_EqualsPtr(v.RunId, rhs.RunId) {
		return false
	}
	if !((v.Control == nil && rhs.Control == nil) || (v.Control != nil && rhs.Control != nil && bytes.Equal(v.Control, rhs.Control))) {
		return false
	}
	if !_Bool_EqualsPtr(v.ChildWorkflowOnly, rhs.ChildWorkflowOnly) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RequestCancelExternalWorkflowExecutionDecisionAttributes.
func (v *RequestCancelExternalWorkflowExecutionDecisionAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.WorkflowId != nil {
		enc.AddString("workflowId", *v.WorkflowId)
	}
	if v.RunId != nil {
		enc.AddString("runId", *v.RunId)
	}
	if v.Control != nil {
		enc.AddString("control", base64.StdEncoding.EncodeToString(v.Control))
	}
	if v.ChildWorkflowOnly != nil {
		enc.AddBool("childWorkflowOnly", *v.ChildWorkflowOnly)
	}
	return err
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *RequestCancelExternalWorkflowExecutionDecisionAttributes) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *RequestCancelExternalWorkflowExecutionDecisionAttributes) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetWorkflowId returns the value of WorkflowId if it is set or its
// zero value if it is unset.
func (v *RequestCancelExternalWorkflowExecutionDecisionAttributes) GetWorkflowId() (o string) {
	if v != nil && v.WorkflowId != nil {
		return *v.WorkflowId
	}

	return
}

// IsSetWorkflowId returns true if WorkflowId is not nil.
func (v *RequestCancelExternalWorkflowExecutionDecisionAttributes) IsSetWorkflowId() bool {
	return v != nil && v.WorkflowId != nil
}

// GetRunId returns the value of RunId if it is set or its
// zero value if it is unset.
func (v *RequestCancelExternalWorkflowExecutionDecisionAttributes) GetRunId() (o string) {
	if v != nil && v.RunId != nil {
		return *v.RunId
	}

	return
}

// IsSetRunId returns true if RunId is not nil.
func (v *RequestCancelExternalWorkflowExecutionDecisionAttributes) IsSetRunId() bool {
	return v != nil && v.RunId != nil
}

// GetControl returns the value of Control if it is set or its
// zero value if it is unset.
func (v *RequestCancelExternalWorkflowExecutionDecisionAttributes) GetControl() (o []byte) {
	if v != nil && v.Control != nil {
		return v.Control
	}

	return
}

// IsSetControl returns true if Control is not nil.
func (v *RequestCancelExternalWorkflowExecutionDecisionAttributes) IsSetControl() bool {
	return v != nil && v.Control != nil
}

// GetChildWorkflowOnly returns the value of ChildWorkflowOnly if it is set or its
// zero value if it is unset.
func (v *RequestCancelExternalWorkflowExecutionDecisionAttributes) GetChildWorkflowOnly() (o bool) {
	if v != nil && v.ChildWorkflowOnly != nil {
		return *v.ChildWorkflowOnly
	}

	return
}

// IsSetChildWorkflowOnly returns true if ChildWorkflowOnly is not nil.
func (v *RequestCancelExternalWorkflowExecutionDecisionAttributes) IsSetChildWorkflowOnly() bool {
	return v != nil && v.ChildWorkflowOnly != nil
}

type RequestCancelExternalWorkflowExecutionFailedEventAttributes struct {
	Cause                        *CancelExternalWorkflowExecutionFailedCause `json:"cause,omitempty"`
	DecisionTaskCompletedEventId *int64                                      `json:"decisionTaskCompletedEventId,omitempty"`
	Domain                       *string                                     `json:"domain,omitempty"`
	WorkflowExecution            *WorkflowExecution                          `json:"workflowExecution,omitempty"`
	InitiatedEventId             *int64                                      `json:"initiatedEventId,omitempty"`
	Control                      []byte                                      `json:"control,omitempty"`
}

// ToWire translates a RequestCancelExternalWorkflowExecutionFailedEventAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RequestCancelExternalWorkflowExecutionFailedEventAttributes) ToWire() (wire.Value, error) {
	var (
		fields [6]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Cause != nil {
		w, err = v.Cause.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.DecisionTaskCompletedEventId != nil {
		w, err = wire.NewValueI64(*(v.DecisionTaskCompletedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.WorkflowExecution != nil {
		w, err = v.WorkflowExecution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.InitiatedEventId != nil {
		w, err = wire.NewValueI64(*(v.InitiatedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.Control != nil {
		w, err = wire.NewValueBinary(v.Control), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _CancelExternalWorkflowExecutionFailedCause_Read(w wire.Value) (CancelExternalWorkflowExecutionFailedCause, error) {
	var v CancelExternalWorkflowExecutionFailedCause
	err := v.FromWire(w)
	return v, err
}

// FromWire deserializes a RequestCancelExternalWorkflowExecutionFailedEventAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RequestCancelExternalWorkflowExecutionFailedEventAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RequestCancelExternalWorkflowExecutionFailedEventAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RequestCancelExternalWorkflowExecutionFailedEventAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI32 {
				var x CancelExternalWorkflowExecutionFailedCause
				x, err = _CancelExternalWorkflowExecutionFailedCause_Read(field.Value)
				v.Cause = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.DecisionTaskCompletedEventId = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.InitiatedEventId = &x
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TBinary {
				v.Control, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RequestCancelExternalWorkflowExecutionFailedEventAttributes
// struct.
func (v *RequestCancelExternalWorkflowExecutionFailedEventAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [6]string
	i := 0
	if v.Cause != nil {
		fields[i] = fmt.Sprintf("Cause: %v", *(v.Cause))
		i++
	}
	if v.DecisionTaskCompletedEventId != nil {
		fields[i] = fmt.Sprintf("DecisionTaskCompletedEventId: %v", *(v.DecisionTaskCompletedEventId))
		i++
	}
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.WorkflowExecution != nil {
		fields[i] = fmt.Sprintf("WorkflowExecution: %v", v.WorkflowExecution)
		i++
	}
	if v.InitiatedEventId != nil {
		fields[i] = fmt.Sprintf("InitiatedEventId: %v", *(v.InitiatedEventId))
		i++
	}
	if v.Control != nil {
		fields[i] = fmt.Sprintf("Control: %v", v.Control)
		i++
	}

	return fmt.Sprintf("RequestCancelExternalWorkflowExecutionFailedEventAttributes{%v}", strings.Join(fields[:i], ", "))
}

func _CancelExternalWorkflowExecutionFailedCause_EqualsPtr(lhs, rhs *CancelExternalWorkflowExecutionFailedCause) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return x.Equals(y)
	}
	return lhs == nil && rhs == nil
}

// Equals returns true if all the fields of this RequestCancelExternalWorkflowExecutionFailedEventAttributes match the
// provided RequestCancelExternalWorkflowExecutionFailedEventAttributes.
//
// This function performs a deep comparison.
func (v *RequestCancelExternalWorkflowExecutionFailedEventAttributes) Equals(rhs *RequestCancelExternalWorkflowExecutionFailedEventAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_CancelExternalWorkflowExecutionFailedCause_EqualsPtr(v.Cause, rhs.Cause) {
		return false
	}
	if !_I64_EqualsPtr(v.DecisionTaskCompletedEventId, rhs.DecisionTaskCompletedEventId) {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !((v.WorkflowExecution == nil && rhs.WorkflowExecution == nil) || (v.WorkflowExecution != nil && rhs.WorkflowExecution != nil && v.WorkflowExecution.Equals(rhs.WorkflowExecution))) {
		return false
	}
	if !_I64_EqualsPtr(v.InitiatedEventId, rhs.InitiatedEventId) {
		return false
	}
	if !((v.Control == nil && rhs.Control == nil) || (v.Control != nil && rhs.Control != nil && bytes.Equal(v.Control, rhs.Control))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RequestCancelExternalWorkflowExecutionFailedEventAttributes.
func (v *RequestCancelExternalWorkflowExecutionFailedEventAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Cause != nil {
		err = multierr.Append(err, enc.AddObject("cause", *v.Cause))
	}
	if v.DecisionTaskCompletedEventId != nil {
		enc.AddInt64("decisionTaskCompletedEventId", *v.DecisionTaskCompletedEventId)
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.WorkflowExecution != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecution", v.WorkflowExecution))
	}
	if v.InitiatedEventId != nil {
		enc.AddInt64("initiatedEventId", *v.InitiatedEventId)
	}
	if v.Control != nil {
		enc.AddString("control", base64.StdEncoding.EncodeToString(v.Control))
	}
	return err
}

// GetCause returns the value of Cause if it is set or its
// zero value if it is unset.
func (v *RequestCancelExternalWorkflowExecutionFailedEventAttributes) GetCause() (o CancelExternalWorkflowExecutionFailedCause) {
	if v != nil && v.Cause != nil {
		return *v.Cause
	}

	return
}

// IsSetCause returns true if Cause is not nil.
func (v *RequestCancelExternalWorkflowExecutionFailedEventAttributes) IsSetCause() bool {
	return v != nil && v.Cause != nil
}

// GetDecisionTaskCompletedEventId returns the value of DecisionTaskCompletedEventId if it is set or its
// zero value if it is unset.
func (v *RequestCancelExternalWorkflowExecutionFailedEventAttributes) GetDecisionTaskCompletedEventId() (o int64) {
	if v != nil && v.DecisionTaskCompletedEventId != nil {
		return *v.DecisionTaskCompletedEventId
	}

	return
}

// IsSetDecisionTaskCompletedEventId returns true if DecisionTaskCompletedEventId is not nil.
func (v *RequestCancelExternalWorkflowExecutionFailedEventAttributes) IsSetDecisionTaskCompletedEventId() bool {
	return v != nil && v.DecisionTaskCompletedEventId != nil
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *RequestCancelExternalWorkflowExecutionFailedEventAttributes) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *RequestCancelExternalWorkflowExecutionFailedEventAttributes) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetWorkflowExecution returns the value of WorkflowExecution if it is set or its
// zero value if it is unset.
func (v *RequestCancelExternalWorkflowExecutionFailedEventAttributes) GetWorkflowExecution() (o *WorkflowExecution) {
	if v != nil && v.WorkflowExecution != nil {
		return v.WorkflowExecution
	}

	return
}

// IsSetWorkflowExecution returns true if WorkflowExecution is not nil.
func (v *RequestCancelExternalWorkflowExecutionFailedEventAttributes) IsSetWorkflowExecution() bool {
	return v != nil && v.WorkflowExecution != nil
}

// GetInitiatedEventId returns the value of InitiatedEventId if it is set or its
// zero value if it is unset.
func (v *RequestCancelExternalWorkflowExecutionFailedEventAttributes) GetInitiatedEventId() (o int64) {
	if v != nil && v.InitiatedEventId != nil {
		return *v.InitiatedEventId
	}

	return
}

// IsSetInitiatedEventId returns true if InitiatedEventId is not nil.
func (v *RequestCancelExternalWorkflowExecutionFailedEventAttributes) IsSetInitiatedEventId() bool {
	return v != nil && v.InitiatedEventId != nil
}

// GetControl returns the value of Control if it is set or its
// zero value if it is unset.
func (v *RequestCancelExternalWorkflowExecutionFailedEventAttributes) GetControl() (o []byte) {
	if v != nil && v.Control != nil {
		return v.Control
	}

	return
}

// IsSetControl returns true if Control is not nil.
func (v *RequestCancelExternalWorkflowExecutionFailedEventAttributes) IsSetControl() bool {
	return v != nil && v.Control != nil
}

type RequestCancelExternalWorkflowExecutionInitiatedEventAttributes struct {
	DecisionTaskCompletedEventId *int64             `json:"decisionTaskCompletedEventId,omitempty"`
	Domain                       *string            `json:"domain,omitempty"`
	WorkflowExecution            *WorkflowExecution `json:"workflowExecution,omitempty"`
	Control                      []byte             `json:"control,omitempty"`
	ChildWorkflowOnly            *bool              `json:"childWorkflowOnly,omitempty"`
}

// ToWire translates a RequestCancelExternalWorkflowExecutionInitiatedEventAttributes struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) ToWire() (wire.Value, error) {
	var (
		fields [5]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DecisionTaskCompletedEventId != nil {
		w, err = wire.NewValueI64(*(v.DecisionTaskCompletedEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.WorkflowExecution != nil {
		w, err = v.WorkflowExecution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.Control != nil {
		w, err = wire.NewValueBinary(v.Control), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.ChildWorkflowOnly != nil {
		w, err = wire.NewValueBool(*(v.ChildWorkflowOnly)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a RequestCancelExternalWorkflowExecutionInitiatedEventAttributes struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RequestCancelExternalWorkflowExecutionInitiatedEventAttributes struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RequestCancelExternalWorkflowExecutionInitiatedEventAttributes
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.DecisionTaskCompletedEventId = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBinary {
				v.Control, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TBool {
				var x bool
				x, err = field.Value.GetBool(), error(nil)
				v.ChildWorkflowOnly = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RequestCancelExternalWorkflowExecutionInitiatedEventAttributes
// struct.
func (v *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [5]string
	i := 0
	if v.DecisionTaskCompletedEventId != nil {
		fields[i] = fmt.Sprintf("DecisionTaskCompletedEventId: %v", *(v.DecisionTaskCompletedEventId))
		i++
	}
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.WorkflowExecution != nil {
		fields[i] = fmt.Sprintf("WorkflowExecution: %v", v.WorkflowExecution)
		i++
	}
	if v.Control != nil {
		fields[i] = fmt.Sprintf("Control: %v", v.Control)
		i++
	}
	if v.ChildWorkflowOnly != nil {
		fields[i] = fmt.Sprintf("ChildWorkflowOnly: %v", *(v.ChildWorkflowOnly))
		i++
	}

	return fmt.Sprintf("RequestCancelExternalWorkflowExecutionInitiatedEventAttributes{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RequestCancelExternalWorkflowExecutionInitiatedEventAttributes match the
// provided RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.
//
// This function performs a deep comparison.
func (v *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) Equals(rhs *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_I64_EqualsPtr(v.DecisionTaskCompletedEventId, rhs.DecisionTaskCompletedEventId) {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !((v.WorkflowExecution == nil && rhs.WorkflowExecution == nil) || (v.WorkflowExecution != nil && rhs.WorkflowExecution != nil && v.WorkflowExecution.Equals(rhs.WorkflowExecution))) {
		return false
	}
	if !((v.Control == nil && rhs.Control == nil) || (v.Control != nil && rhs.Control != nil && bytes.Equal(v.Control, rhs.Control))) {
		return false
	}
	if !_Bool_EqualsPtr(v.ChildWorkflowOnly, rhs.ChildWorkflowOnly) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.
func (v *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DecisionTaskCompletedEventId != nil {
		enc.AddInt64("decisionTaskCompletedEventId", *v.DecisionTaskCompletedEventId)
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.WorkflowExecution != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecution", v.WorkflowExecution))
	}
	if v.Control != nil {
		enc.AddString("control", base64.StdEncoding.EncodeToString(v.Control))
	}
	if v.ChildWorkflowOnly != nil {
		enc.AddBool("childWorkflowOnly", *v.ChildWorkflowOnly)
	}
	return err
}

// GetDecisionTaskCompletedEventId returns the value of DecisionTaskCompletedEventId if it is set or its
// zero value if it is unset.
func (v *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) GetDecisionTaskCompletedEventId() (o int64) {
	if v != nil && v.DecisionTaskCompletedEventId != nil {
		return *v.DecisionTaskCompletedEventId
	}

	return
}

// IsSetDecisionTaskCompletedEventId returns true if DecisionTaskCompletedEventId is not nil.
func (v *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) IsSetDecisionTaskCompletedEventId() bool {
	return v != nil && v.DecisionTaskCompletedEventId != nil
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetWorkflowExecution returns the value of WorkflowExecution if it is set or its
// zero value if it is unset.
func (v *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) GetWorkflowExecution() (o *WorkflowExecution) {
	if v != nil && v.WorkflowExecution != nil {
		return v.WorkflowExecution
	}

	return
}

// IsSetWorkflowExecution returns true if WorkflowExecution is not nil.
func (v *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) IsSetWorkflowExecution() bool {
	return v != nil && v.WorkflowExecution != nil
}

// GetControl returns the value of Control if it is set or its
// zero value if it is unset.
func (v *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) GetControl() (o []byte) {
	if v != nil && v.Control != nil {
		return v.Control
	}

	return
}

// IsSetControl returns true if Control is not nil.
func (v *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) IsSetControl() bool {
	return v != nil && v.Control != nil
}

// GetChildWorkflowOnly returns the value of ChildWorkflowOnly if it is set or its
// zero value if it is unset.
func (v *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) GetChildWorkflowOnly() (o bool) {
	if v != nil && v.ChildWorkflowOnly != nil {
		return *v.ChildWorkflowOnly
	}

	return
}

// IsSetChildWorkflowOnly returns true if ChildWorkflowOnly is not nil.
func (v *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) IsSetChildWorkflowOnly() bool {
	return v != nil && v.ChildWorkflowOnly != nil
}

type RequestCancelWorkflowExecutionRequest struct {
	Domain            *string            `json:"domain,omitempty"`
	WorkflowExecution *WorkflowExecution `json:"workflowExecution,omitempty"`
	Identity          *string            `json:"identity,omitempty"`
	RequestId         *string            `json:"requestId,omitempty"`
}

// ToWire translates a RequestCancelWorkflowExecutionRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RequestCancelWorkflowExecutionRequest) ToWire() (wire.Value, error) {
	var (
		fields [4]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.WorkflowExecution != nil {
		w, err = v.WorkflowExecution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.Identity != nil {
		w, err = wire.NewValueString(*(v.Identity)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.RequestId != nil {
		w, err = wire.NewValueString(*(v.RequestId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a RequestCancelWorkflowExecutionRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RequestCancelWorkflowExecutionRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RequestCancelWorkflowExecutionRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RequestCancelWorkflowExecutionRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Identity = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.RequestId = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RequestCancelWorkflowExecutionRequest
// struct.
func (v *RequestCancelWorkflowExecutionRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [4]string
	i := 0
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.WorkflowExecution != nil {
		fields[i] = fmt.Sprintf("WorkflowExecution: %v", v.WorkflowExecution)
		i++
	}
	if v.Identity != nil {
		fields[i] = fmt.Sprintf("Identity: %v", *(v.Identity))
		i++
	}
	if v.RequestId != nil {
		fields[i] = fmt.Sprintf("RequestId: %v", *(v.RequestId))
		i++
	}

	return fmt.Sprintf("RequestCancelWorkflowExecutionRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RequestCancelWorkflowExecutionRequest match the
// provided RequestCancelWorkflowExecutionRequest.
//
// This function performs a deep comparison.
func (v *RequestCancelWorkflowExecutionRequest) Equals(rhs *RequestCancelWorkflowExecutionRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !((v.WorkflowExecution == nil && rhs.WorkflowExecution == nil) || (v.WorkflowExecution != nil && rhs.WorkflowExecution != nil && v.WorkflowExecution.Equals(rhs.WorkflowExecution))) {
		return false
	}
	if !_String_EqualsPtr(v.Identity, rhs.Identity) {
		return false
	}
	if !_String_EqualsPtr(v.RequestId, rhs.RequestId) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RequestCancelWorkflowExecutionRequest.
func (v *RequestCancelWorkflowExecutionRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.WorkflowExecution != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecution", v.WorkflowExecution))
	}
	if v.Identity != nil {
		enc.AddString("identity", *v.Identity)
	}
	if v.RequestId != nil {
		enc.AddString("requestId", *v.RequestId)
	}
	return err
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *RequestCancelWorkflowExecutionRequest) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *RequestCancelWorkflowExecutionRequest) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetWorkflowExecution returns the value of WorkflowExecution if it is set or its
// zero value if it is unset.
func (v *RequestCancelWorkflowExecutionRequest) GetWorkflowExecution() (o *WorkflowExecution) {
	if v != nil && v.WorkflowExecution != nil {
		return v.WorkflowExecution
	}

	return
}

// IsSetWorkflowExecution returns true if WorkflowExecution is not nil.
func (v *RequestCancelWorkflowExecutionRequest) IsSetWorkflowExecution() bool {
	return v != nil && v.WorkflowExecution != nil
}

// GetIdentity returns the value of Identity if it is set or its
// zero value if it is unset.
func (v *RequestCancelWorkflowExecutionRequest) GetIdentity() (o string) {
	if v != nil && v.Identity != nil {
		return *v.Identity
	}

	return
}

// IsSetIdentity returns true if Identity is not nil.
func (v *RequestCancelWorkflowExecutionRequest) IsSetIdentity() bool {
	return v != nil && v.Identity != nil
}

// GetRequestId returns the value of RequestId if it is set or its
// zero value if it is unset.
func (v *RequestCancelWorkflowExecutionRequest) GetRequestId() (o string) {
	if v != nil && v.RequestId != nil {
		return *v.RequestId
	}

	return
}

// IsSetRequestId returns true if RequestId is not nil.
func (v *RequestCancelWorkflowExecutionRequest) IsSetRequestId() bool {
	return v != nil && v.RequestId != nil
}

type ResetPointInfo struct {
	BinaryChecksum           *string `json:"binaryChecksum,omitempty"`
	RunId                    *string `json:"runId,omitempty"`
	FirstDecisionCompletedId *int64  `json:"firstDecisionCompletedId,omitempty"`
	CreatedTimeNano          *int64  `json:"createdTimeNano,omitempty"`
	ExpiringTimeNano         *int64  `json:"expiringTimeNano,omitempty"`
	Resettable               *bool   `json:"resettable,omitempty"`
}

// ToWire translates a ResetPointInfo struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ResetPointInfo) ToWire() (wire.Value, error) {
	var (
		fields [6]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.BinaryChecksum != nil {
		w, err = wire.NewValueString(*(v.BinaryChecksum)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.RunId != nil {
		w, err = wire.NewValueString(*(v.RunId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.FirstDecisionCompletedId != nil {
		w, err = wire.NewValueI64(*(v.FirstDecisionCompletedId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.CreatedTimeNano != nil {
		w, err = wire.NewValueI64(*(v.CreatedTimeNano)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.ExpiringTimeNano != nil {
		w, err = wire.NewValueI64(*(v.ExpiringTimeNano)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.Resettable != nil {
		w, err = wire.NewValueBool(*(v.Resettable)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ResetPointInfo struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ResetPointInfo struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ResetPointInfo
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ResetPointInfo) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.BinaryChecksum = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.RunId = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.FirstDecisionCompletedId = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.CreatedTimeNano = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ExpiringTimeNano = &x
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TBool {
				var x bool
				x, err = field.Value.GetBool(), error(nil)
				v.Resettable = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ResetPointInfo
// struct.
func (v *ResetPointInfo) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [6]string
	i := 0
	if v.BinaryChecksum != nil {
		fields[i] = fmt.Sprintf("BinaryChecksum: %v", *(v.BinaryChecksum))
		i++
	}
	if v.RunId != nil {
		fields[i] = fmt.Sprintf("RunId: %v", *(v.RunId))
		i++
	}
	if v.FirstDecisionCompletedId != nil {
		fields[i] = fmt.Sprintf("FirstDecisionCompletedId: %v", *(v.FirstDecisionCompletedId))
		i++
	}
	if v.CreatedTimeNano != nil {
		fields[i] = fmt.Sprintf("CreatedTimeNano: %v", *(v.CreatedTimeNano))
		i++
	}
	if v.ExpiringTimeNano != nil {
		fields[i] = fmt.Sprintf("ExpiringTimeNano: %v", *(v.ExpiringTimeNano))
		i++
	}
	if v.Resettable != nil {
		fields[i] = fmt.Sprintf("Resettable: %v", *(v.Resettable))
		i++
	}

	return fmt.Sprintf("ResetPointInfo{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ResetPointInfo match the
// provided ResetPointInfo.
//
// This function performs a deep comparison.
func (v *ResetPointInfo) Equals(rhs *ResetPointInfo) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.BinaryChecksum, rhs.BinaryChecksum) {
		return false
	}
	if !_String_EqualsPtr(v.RunId, rhs.RunId) {
		return false
	}
	if !_I64_EqualsPtr(v.FirstDecisionCompletedId, rhs.FirstDecisionCompletedId) {
		return false
	}
	if !_I64_EqualsPtr(v.CreatedTimeNano, rhs.CreatedTimeNano) {
		return false
	}
	if !_I64_EqualsPtr(v.ExpiringTimeNano, rhs.ExpiringTimeNano) {
		return false
	}
	if !_Bool_EqualsPtr(v.Resettable, rhs.Resettable) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ResetPointInfo.
func (v *ResetPointInfo) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.BinaryChecksum != nil {
		enc.AddString("binaryChecksum", *v.BinaryChecksum)
	}
	if v.RunId != nil {
		enc.AddString("runId", *v.RunId)
	}
	if v.FirstDecisionCompletedId != nil {
		enc.AddInt64("firstDecisionCompletedId", *v.FirstDecisionCompletedId)
	}
	if v.CreatedTimeNano != nil {
		enc.AddInt64("createdTimeNano", *v.CreatedTimeNano)
	}
	if v.ExpiringTimeNano != nil {
		enc.AddInt64("expiringTimeNano", *v.ExpiringTimeNano)
	}
	if v.Resettable != nil {
		enc.AddBool("resettable", *v.Resettable)
	}
	return err
}

// GetBinaryChecksum returns the value of BinaryChecksum if it is set or its
// zero value if it is unset.
func (v *ResetPointInfo) GetBinaryChecksum() (o string) {
	if v != nil && v.BinaryChecksum != nil {
		return *v.BinaryChecksum
	}

	return
}

// IsSetBinaryChecksum returns true if BinaryChecksum is not nil.
func (v *ResetPointInfo) IsSetBinaryChecksum() bool {
	return v != nil && v.BinaryChecksum != nil
}

// GetRunId returns the value of RunId if it is set or its
// zero value if it is unset.
func (v *ResetPointInfo) GetRunId() (o string) {
	if v != nil && v.RunId != nil {
		return *v.RunId
	}

	return
}

// IsSetRunId returns true if RunId is not nil.
func (v *ResetPointInfo) IsSetRunId() bool {
	return v != nil && v.RunId != nil
}

// GetFirstDecisionCompletedId returns the value of FirstDecisionCompletedId if it is set or its
// zero value if it is unset.
func (v *ResetPointInfo) GetFirstDecisionCompletedId() (o int64) {
	if v != nil && v.FirstDecisionCompletedId != nil {
		return *v.FirstDecisionCompletedId
	}

	return
}

// IsSetFirstDecisionCompletedId returns true if FirstDecisionCompletedId is not nil.
func (v *ResetPointInfo) IsSetFirstDecisionCompletedId() bool {
	return v != nil && v.FirstDecisionCompletedId != nil
}

// GetCreatedTimeNano returns the value of CreatedTimeNano if it is set or its
// zero value if it is unset.
func (v *ResetPointInfo) GetCreatedTimeNano() (o int64) {
	if v != nil && v.CreatedTimeNano != nil {
		return *v.CreatedTimeNano
	}

	return
}

// IsSetCreatedTimeNano returns true if CreatedTimeNano is not nil.
func (v *ResetPointInfo) IsSetCreatedTimeNano() bool {
	return v != nil && v.CreatedTimeNano != nil
}

// GetExpiringTimeNano returns the value of ExpiringTimeNano if it is set or its
// zero value if it is unset.
func (v *ResetPointInfo) GetExpiringTimeNano() (o int64) {
	if v != nil && v.ExpiringTimeNano != nil {
		return *v.ExpiringTimeNano
	}

	return
}

// IsSetExpiringTimeNano returns true if ExpiringTimeNano is not nil.
func (v *ResetPointInfo) IsSetExpiringTimeNano() bool {
	return v != nil && v.ExpiringTimeNano != nil
}

// GetResettable returns the value of Resettable if it is set or its
// zero value if it is unset.
func (v *ResetPointInfo) GetResettable() (o bool) {
	if v != nil && v.Resettable != nil {
		return *v.Resettable
	}

	return
}

// IsSetResettable returns true if Resettable is not nil.
func (v *ResetPointInfo) IsSetResettable() bool {
	return v != nil && v.Resettable != nil
}

type ResetPoints struct {
	Points []*ResetPointInfo `json:"points,omitempty"`
}

type _List_ResetPointInfo_ValueList []*ResetPointInfo

func (v _List_ResetPointInfo_ValueList) ForEach(f func(wire.Value) error) error {
	for i, x := range v {
		if x == nil {
			return fmt.Errorf("invalid [%v]: value is nil", i)
		}
		w, err := x.ToWire()
		if err != nil {
			return err
		}
		err = f(w)
		if err != nil {
			return err
		}
	}
	return nil
}

func (v _List_ResetPointInfo_ValueList) Size() int {
	return len(v)
}

func (_List_ResetPointInfo_ValueList) ValueType() wire.Type {
	return wire.TStruct
}

func (_List_ResetPointInfo_ValueList) Close() {}

// ToWire translates a ResetPoints struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ResetPoints) ToWire() (wire.Value, error) {
	var (
		fields [1]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Points != nil {
		w, err = wire.NewValueList(_List_ResetPointInfo_ValueList(v.Points)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _ResetPointInfo_Read(w wire.Value) (*ResetPointInfo, error) {
	var v ResetPointInfo
	err := v.FromWire(w)
	return &v, err
}

func _List_ResetPointInfo_Read(l wire.ValueList) ([]*ResetPointInfo, error) {
	if l.ValueType() != wire.TStruct {
		return nil, nil
	}

	o := make([]*ResetPointInfo, 0, l.Size())
	err := l.ForEach(func(x wire.Value) error {
		i, err := _ResetPointInfo_Read(x)
		if err != nil {
			return err
		}
		o = append(o, i)
		return nil
	})
	l.Close()
	return o, err
}

// FromWire deserializes a ResetPoints struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ResetPoints struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ResetPoints
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ResetPoints) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TList {
				v.Points, err = _List_ResetPointInfo_Read(field.Value.GetList())
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ResetPoints
// struct.
func (v *ResetPoints) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [1]string
	i := 0
	if v.Points != nil {
		fields[i] = fmt.Sprintf("Points: %v", v.Points)
		i++
	}

	return fmt.Sprintf("ResetPoints{%v}", strings.Join(fields[:i], ", "))
}

func _List_ResetPointInfo_Equals(lhs, rhs []*ResetPointInfo) bool {
	if len(lhs) != len(rhs) {
		return false
	}

	for i, lv := range lhs {
		rv := rhs[i]
		if !lv.Equals(rv) {
			return false
		}
	}

	return true
}

// Equals returns true if all the fields of this ResetPoints match the
// provided ResetPoints.
//
// This function performs a deep comparison.
func (v *ResetPoints) Equals(rhs *ResetPoints) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.Points == nil && rhs.Points == nil) || (v.Points != nil && rhs.Points != nil && _List_ResetPointInfo_Equals(v.Points, rhs.Points))) {
		return false
	}

	return true
}

type _List_ResetPointInfo_Zapper []*ResetPointInfo

// MarshalLogArray implements zapcore.ArrayMarshaler, enabling
// fast logging of _List_ResetPointInfo_Zapper.
func (l _List_ResetPointInfo_Zapper) MarshalLogArray(enc zapcore.ArrayEncoder) (err error) {
	for _, v := range l {
		err = multierr.Append(err, enc.AppendObject(v))
	}
	return err
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ResetPoints.
func (v *ResetPoints) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Points != nil {
		err = multierr.Append(err, enc.AddArray("points", (_List_ResetPointInfo_Zapper)(v.Points)))
	}
	return err
}

// GetPoints returns the value of Points if it is set or its
// zero value if it is unset.
func (v *ResetPoints) GetPoints() (o []*ResetPointInfo) {
	if v != nil && v.Points != nil {
		return v.Points
	}

	return
}

// IsSetPoints returns true if Points is not nil.
func (v *ResetPoints) IsSetPoints() bool {
	return v != nil && v.Points != nil
}

type ResetStickyTaskListRequest struct {
	Domain    *string            `json:"domain,omitempty"`
	Execution *WorkflowExecution `json:"execution,omitempty"`
}

// ToWire translates a ResetStickyTaskListRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ResetStickyTaskListRequest) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Execution != nil {
		w, err = v.Execution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ResetStickyTaskListRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ResetStickyTaskListRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ResetStickyTaskListRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ResetStickyTaskListRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.Execution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ResetStickyTaskListRequest
// struct.
func (v *ResetStickyTaskListRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.Execution != nil {
		fields[i] = fmt.Sprintf("Execution: %v", v.Execution)
		i++
	}

	return fmt.Sprintf("ResetStickyTaskListRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ResetStickyTaskListRequest match the
// provided ResetStickyTaskListRequest.
//
// This function performs a deep comparison.
func (v *ResetStickyTaskListRequest) Equals(rhs *ResetStickyTaskListRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !((v.Execution == nil && rhs.Execution == nil) || (v.Execution != nil && rhs.Execution != nil && v.Execution.Equals(rhs.Execution))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ResetStickyTaskListRequest.
func (v *ResetStickyTaskListRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.Execution != nil {
		err = multierr.Append(err, enc.AddObject("execution", v.Execution))
	}
	return err
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *ResetStickyTaskListRequest) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *ResetStickyTaskListRequest) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetExecution returns the value of Execution if it is set or its
// zero value if it is unset.
func (v *ResetStickyTaskListRequest) GetExecution() (o *WorkflowExecution) {
	if v != nil && v.Execution != nil {
		return v.Execution
	}

	return
}

// IsSetExecution returns true if Execution is not nil.
func (v *ResetStickyTaskListRequest) IsSetExecution() bool {
	return v != nil && v.Execution != nil
}

type ResetStickyTaskListResponse struct {
}

// ToWire translates a ResetStickyTaskListResponse struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ResetStickyTaskListResponse) ToWire() (wire.Value, error) {
	var (
		fields [0]wire.Field
		i      int = 0
	)

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ResetStickyTaskListResponse struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ResetStickyTaskListResponse struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ResetStickyTaskListResponse
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ResetStickyTaskListResponse) FromWire(w wire.Value) error {

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		}
	}

	return nil
}

// String returns a readable string representation of a ResetStickyTaskListResponse
// struct.
func (v *ResetStickyTaskListResponse) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [0]string
	i := 0

	return fmt.Sprintf("ResetStickyTaskListResponse{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ResetStickyTaskListResponse match the
// provided ResetStickyTaskListResponse.
//
// This function performs a deep comparison.
func (v *ResetStickyTaskListResponse) Equals(rhs *ResetStickyTaskListResponse) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ResetStickyTaskListResponse.
func (v *ResetStickyTaskListResponse) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	return err
}

type ResetWorkflowExecutionRequest struct {
	Domain                *string            `json:"domain,omitempty"`
	WorkflowExecution     *WorkflowExecution `json:"workflowExecution,omitempty"`
	Reason                *string            `json:"reason,omitempty"`
	DecisionFinishEventId *int64             `json:"decisionFinishEventId,omitempty"`
	RequestId             *string            `json:"requestId,omitempty"`
}

// ToWire translates a ResetWorkflowExecutionRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ResetWorkflowExecutionRequest) ToWire() (wire.Value, error) {
	var (
		fields [5]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.WorkflowExecution != nil {
		w, err = v.WorkflowExecution.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.Reason != nil {
		w, err = wire.NewValueString(*(v.Reason)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.DecisionFinishEventId != nil {
		w, err = wire.NewValueI64(*(v.DecisionFinishEventId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.RequestId != nil {
		w, err = wire.NewValueString(*(v.RequestId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ResetWorkflowExecutionRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ResetWorkflowExecutionRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ResetWorkflowExecutionRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ResetWorkflowExecutionRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TStruct {
				v.WorkflowExecution, err = _WorkflowExecution_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Reason = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.DecisionFinishEventId = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.RequestId = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ResetWorkflowExecutionRequest
// struct.
func (v *ResetWorkflowExecutionRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [5]string
	i := 0
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.WorkflowExecution != nil {
		fields[i] = fmt.Sprintf("WorkflowExecution: %v", v.WorkflowExecution)
		i++
	}
	if v.Reason != nil {
		fields[i] = fmt.Sprintf("Reason: %v", *(v.Reason))
		i++
	}
	if v.DecisionFinishEventId != nil {
		fields[i] = fmt.Sprintf("DecisionFinishEventId: %v", *(v.DecisionFinishEventId))
		i++
	}
	if v.RequestId != nil {
		fields[i] = fmt.Sprintf("RequestId: %v", *(v.RequestId))
		i++
	}

	return fmt.Sprintf("ResetWorkflowExecutionRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ResetWorkflowExecutionRequest match the
// provided ResetWorkflowExecutionRequest.
//
// This function performs a deep comparison.
func (v *ResetWorkflowExecutionRequest) Equals(rhs *ResetWorkflowExecutionRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !((v.WorkflowExecution == nil && rhs.WorkflowExecution == nil) || (v.WorkflowExecution != nil && rhs.WorkflowExecution != nil && v.WorkflowExecution.Equals(rhs.WorkflowExecution))) {
		return false
	}
	if !_String_EqualsPtr(v.Reason, rhs.Reason) {
		return false
	}
	if !_I64_EqualsPtr(v.DecisionFinishEventId, rhs.DecisionFinishEventId) {
		return false
	}
	if !_String_EqualsPtr(v.RequestId, rhs.RequestId) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ResetWorkflowExecutionRequest.
func (v *ResetWorkflowExecutionRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.WorkflowExecution != nil {
		err = multierr.Append(err, enc.AddObject("workflowExecution", v.WorkflowExecution))
	}
	if v.Reason != nil {
		enc.AddString("reason", *v.Reason)
	}
	if v.DecisionFinishEventId != nil {
		enc.AddInt64("decisionFinishEventId", *v.DecisionFinishEventId)
	}
	if v.RequestId != nil {
		enc.AddString("requestId", *v.RequestId)
	}
	return err
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *ResetWorkflowExecutionRequest) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *ResetWorkflowExecutionRequest) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetWorkflowExecution returns the value of WorkflowExecution if it is set or its
// zero value if it is unset.
func (v *ResetWorkflowExecutionRequest) GetWorkflowExecution() (o *WorkflowExecution) {
	if v != nil && v.WorkflowExecution != nil {
		return v.WorkflowExecution
	}

	return
}

// IsSetWorkflowExecution returns true if WorkflowExecution is not nil.
func (v *ResetWorkflowExecutionRequest) IsSetWorkflowExecution() bool {
	return v != nil && v.WorkflowExecution != nil
}

// GetReason returns the value of Reason if it is set or its
// zero value if it is unset.
func (v *ResetWorkflowExecutionRequest) GetReason() (o string) {
	if v != nil && v.Reason != nil {
		return *v.Reason
	}

	return
}

// IsSetReason returns true if Reason is not nil.
func (v *ResetWorkflowExecutionRequest) IsSetReason() bool {
	return v != nil && v.Reason != nil
}

// GetDecisionFinishEventId returns the value of DecisionFinishEventId if it is set or its
// zero value if it is unset.
func (v *ResetWorkflowExecutionRequest) GetDecisionFinishEventId() (o int64) {
	if v != nil && v.DecisionFinishEventId != nil {
		return *v.DecisionFinishEventId
	}

	return
}

// IsSetDecisionFinishEventId returns true if DecisionFinishEventId is not nil.
func (v *ResetWorkflowExecutionRequest) IsSetDecisionFinishEventId() bool {
	return v != nil && v.DecisionFinishEventId != nil
}

// GetRequestId returns the value of RequestId if it is set or its
// zero value if it is unset.
func (v *ResetWorkflowExecutionRequest) GetRequestId() (o string) {
	if v != nil && v.RequestId != nil {
		return *v.RequestId
	}

	return
}

// IsSetRequestId returns true if RequestId is not nil.
func (v *ResetWorkflowExecutionRequest) IsSetRequestId() bool {
	return v != nil && v.RequestId != nil
}

type ResetWorkflowExecutionResponse struct {
	RunId *string `json:"runId,omitempty"`
}

// ToWire translates a ResetWorkflowExecutionResponse struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ResetWorkflowExecutionResponse) ToWire() (wire.Value, error) {
	var (
		fields [1]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.RunId != nil {
		w, err = wire.NewValueString(*(v.RunId)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ResetWorkflowExecutionResponse struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ResetWorkflowExecutionResponse struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ResetWorkflowExecutionResponse
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ResetWorkflowExecutionResponse) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.RunId = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ResetWorkflowExecutionResponse
// struct.
func (v *ResetWorkflowExecutionResponse) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [1]string
	i := 0
	if v.RunId != nil {
		fields[i] = fmt.Sprintf("RunId: %v", *(v.RunId))
		i++
	}

	return fmt.Sprintf("ResetWorkflowExecutionResponse{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ResetWorkflowExecutionResponse match the
// provided ResetWorkflowExecutionResponse.
//
// This function performs a deep comparison.
func (v *ResetWorkflowExecutionResponse) Equals(rhs *ResetWorkflowExecutionResponse) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.RunId, rhs.RunId) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ResetWorkflowExecutionResponse.
func (v *ResetWorkflowExecutionResponse) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.RunId != nil {
		enc.AddString("runId", *v.RunId)
	}
	return err
}

// GetRunId returns the value of RunId if it is set or its
// zero value if it is unset.
func (v *ResetWorkflowExecutionResponse) GetRunId() (o string) {
	if v != nil && v.RunId != nil {
		return *v.RunId
	}

	return
}

// IsSetRunId returns true if RunId is not nil.
func (v *ResetWorkflowExecutionResponse) IsSetRunId() bool {
	return v != nil && v.RunId != nil
}

type RespondActivityTaskCanceledByIDRequest struct {
	Domain     *string `json:"domain,omitempty"`
	WorkflowID *string `json:"workflowID,omitempty"`
	RunID      *string `json:"runID,omitempty"`
	ActivityID *string `json:"activityID,omitempty"`
	Details    []byte  `json:"details,omitempty"`
	Identity   *string `json:"identity,omitempty"`
}

// ToWire translates a RespondActivityTaskCanceledByIDRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RespondActivityTaskCanceledByIDRequest) ToWire() (wire.Value, error) {
	var (
		fields [6]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.WorkflowID != nil {
		w, err = wire.NewValueString(*(v.WorkflowID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.RunID != nil {
		w, err = wire.NewValueString(*(v.RunID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.ActivityID != nil {
		w, err = wire.NewValueString(*(v.ActivityID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.Details != nil {
		w, err = wire.NewValueBinary(v.Details), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.Identity != nil {
		w, err = wire.NewValueString(*(v.Identity)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a RespondActivityTaskCanceledByIDRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RespondActivityTaskCanceledByIDRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RespondActivityTaskCanceledByIDRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RespondActivityTaskCanceledByIDRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.WorkflowID = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.RunID = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ActivityID = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TBinary {
				v.Details, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Identity = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RespondActivityTaskCanceledByIDRequest
// struct.
func (v *RespondActivityTaskCanceledByIDRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [6]string
	i := 0
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.WorkflowID != nil {
		fields[i] = fmt.Sprintf("WorkflowID: %v", *(v.WorkflowID))
		i++
	}
	if v.RunID != nil {
		fields[i] = fmt.Sprintf("RunID: %v", *(v.RunID))
		i++
	}
	if v.ActivityID != nil {
		fields[i] = fmt.Sprintf("ActivityID: %v", *(v.ActivityID))
		i++
	}
	if v.Details != nil {
		fields[i] = fmt.Sprintf("Details: %v", v.Details)
		i++
	}
	if v.Identity != nil {
		fields[i] = fmt.Sprintf("Identity: %v", *(v.Identity))
		i++
	}

	return fmt.Sprintf("RespondActivityTaskCanceledByIDRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RespondActivityTaskCanceledByIDRequest match the
// provided RespondActivityTaskCanceledByIDRequest.
//
// This function performs a deep comparison.
func (v *RespondActivityTaskCanceledByIDRequest) Equals(rhs *RespondActivityTaskCanceledByIDRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !_String_EqualsPtr(v.WorkflowID, rhs.WorkflowID) {
		return false
	}
	if !_String_EqualsPtr(v.RunID, rhs.RunID) {
		return false
	}
	if !_String_EqualsPtr(v.ActivityID, rhs.ActivityID) {
		return false
	}
	if !((v.Details == nil && rhs.Details == nil) || (v.Details != nil && rhs.Details != nil && bytes.Equal(v.Details, rhs.Details))) {
		return false
	}
	if !_String_EqualsPtr(v.Identity, rhs.Identity) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RespondActivityTaskCanceledByIDRequest.
func (v *RespondActivityTaskCanceledByIDRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.WorkflowID != nil {
		enc.AddString("workflowID", *v.WorkflowID)
	}
	if v.RunID != nil {
		enc.AddString("runID", *v.RunID)
	}
	if v.ActivityID != nil {
		enc.AddString("activityID", *v.ActivityID)
	}
	if v.Details != nil {
		enc.AddString("details", base64.StdEncoding.EncodeToString(v.Details))
	}
	if v.Identity != nil {
		enc.AddString("identity", *v.Identity)
	}
	return err
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskCanceledByIDRequest) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *RespondActivityTaskCanceledByIDRequest) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetWorkflowID returns the value of WorkflowID if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskCanceledByIDRequest) GetWorkflowID() (o string) {
	if v != nil && v.WorkflowID != nil {
		return *v.WorkflowID
	}

	return
}

// IsSetWorkflowID returns true if WorkflowID is not nil.
func (v *RespondActivityTaskCanceledByIDRequest) IsSetWorkflowID() bool {
	return v != nil && v.WorkflowID != nil
}

// GetRunID returns the value of RunID if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskCanceledByIDRequest) GetRunID() (o string) {
	if v != nil && v.RunID != nil {
		return *v.RunID
	}

	return
}

// IsSetRunID returns true if RunID is not nil.
func (v *RespondActivityTaskCanceledByIDRequest) IsSetRunID() bool {
	return v != nil && v.RunID != nil
}

// GetActivityID returns the value of ActivityID if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskCanceledByIDRequest) GetActivityID() (o string) {
	if v != nil && v.ActivityID != nil {
		return *v.ActivityID
	}

	return
}

// IsSetActivityID returns true if ActivityID is not nil.
func (v *RespondActivityTaskCanceledByIDRequest) IsSetActivityID() bool {
	return v != nil && v.ActivityID != nil
}

// GetDetails returns the value of Details if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskCanceledByIDRequest) GetDetails() (o []byte) {
	if v != nil && v.Details != nil {
		return v.Details
	}

	return
}

// IsSetDetails returns true if Details is not nil.
func (v *RespondActivityTaskCanceledByIDRequest) IsSetDetails() bool {
	return v != nil && v.Details != nil
}

// GetIdentity returns the value of Identity if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskCanceledByIDRequest) GetIdentity() (o string) {
	if v != nil && v.Identity != nil {
		return *v.Identity
	}

	return
}

// IsSetIdentity returns true if Identity is not nil.
func (v *RespondActivityTaskCanceledByIDRequest) IsSetIdentity() bool {
	return v != nil && v.Identity != nil
}

type RespondActivityTaskCanceledRequest struct {
	TaskToken []byte  `json:"taskToken,omitempty"`
	Details   []byte  `json:"details,omitempty"`
	Identity  *string `json:"identity,omitempty"`
}

// ToWire translates a RespondActivityTaskCanceledRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RespondActivityTaskCanceledRequest) ToWire() (wire.Value, error) {
	var (
		fields [3]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.TaskToken != nil {
		w, err = wire.NewValueBinary(v.TaskToken), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Details != nil {
		w, err = wire.NewValueBinary(v.Details), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.Identity != nil {
		w, err = wire.NewValueString(*(v.Identity)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a RespondActivityTaskCanceledRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RespondActivityTaskCanceledRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RespondActivityTaskCanceledRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RespondActivityTaskCanceledRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				v.TaskToken, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				v.Details, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Identity = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RespondActivityTaskCanceledRequest
// struct.
func (v *RespondActivityTaskCanceledRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [3]string
	i := 0
	if v.TaskToken != nil {
		fields[i] = fmt.Sprintf("TaskToken: %v", v.TaskToken)
		i++
	}
	if v.Details != nil {
		fields[i] = fmt.Sprintf("Details: %v", v.Details)
		i++
	}
	if v.Identity != nil {
		fields[i] = fmt.Sprintf("Identity: %v", *(v.Identity))
		i++
	}

	return fmt.Sprintf("RespondActivityTaskCanceledRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RespondActivityTaskCanceledRequest match the
// provided RespondActivityTaskCanceledRequest.
//
// This function performs a deep comparison.
func (v *RespondActivityTaskCanceledRequest) Equals(rhs *RespondActivityTaskCanceledRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.TaskToken == nil && rhs.TaskToken == nil) || (v.TaskToken != nil && rhs.TaskToken != nil && bytes.Equal(v.TaskToken, rhs.TaskToken))) {
		return false
	}
	if !((v.Details == nil && rhs.Details == nil) || (v.Details != nil && rhs.Details != nil && bytes.Equal(v.Details, rhs.Details))) {
		return false
	}
	if !_String_EqualsPtr(v.Identity, rhs.Identity) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RespondActivityTaskCanceledRequest.
func (v *RespondActivityTaskCanceledRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.TaskToken != nil {
		enc.AddString("taskToken", base64.StdEncoding.EncodeToString(v.TaskToken))
	}
	if v.Details != nil {
		enc.AddString("details", base64.StdEncoding.EncodeToString(v.Details))
	}
	if v.Identity != nil {
		enc.AddString("identity", *v.Identity)
	}
	return err
}

// GetTaskToken returns the value of TaskToken if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskCanceledRequest) GetTaskToken() (o []byte) {
	if v != nil && v.TaskToken != nil {
		return v.TaskToken
	}

	return
}

// IsSetTaskToken returns true if TaskToken is not nil.
func (v *RespondActivityTaskCanceledRequest) IsSetTaskToken() bool {
	return v != nil && v.TaskToken != nil
}

// GetDetails returns the value of Details if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskCanceledRequest) GetDetails() (o []byte) {
	if v != nil && v.Details != nil {
		return v.Details
	}

	return
}

// IsSetDetails returns true if Details is not nil.
func (v *RespondActivityTaskCanceledRequest) IsSetDetails() bool {
	return v != nil && v.Details != nil
}

// GetIdentity returns the value of Identity if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskCanceledRequest) GetIdentity() (o string) {
	if v != nil && v.Identity != nil {
		return *v.Identity
	}

	return
}

// IsSetIdentity returns true if Identity is not nil.
func (v *RespondActivityTaskCanceledRequest) IsSetIdentity() bool {
	return v != nil && v.Identity != nil
}

type RespondActivityTaskCompletedByIDRequest struct {
	Domain     *string `json:"domain,omitempty"`
	WorkflowID *string `json:"workflowID,omitempty"`
	RunID      *string `json:"runID,omitempty"`
	ActivityID *string `json:"activityID,omitempty"`
	Result     []byte  `json:"result,omitempty"`
	Identity   *string `json:"identity,omitempty"`
}

// ToWire translates a RespondActivityTaskCompletedByIDRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RespondActivityTaskCompletedByIDRequest) ToWire() (wire.Value, error) {
	var (
		fields [6]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.WorkflowID != nil {
		w, err = wire.NewValueString(*(v.WorkflowID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.RunID != nil {
		w, err = wire.NewValueString(*(v.RunID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.ActivityID != nil {
		w, err = wire.NewValueString(*(v.ActivityID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.Result != nil {
		w, err = wire.NewValueBinary(v.Result), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.Identity != nil {
		w, err = wire.NewValueString(*(v.Identity)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a RespondActivityTaskCompletedByIDRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RespondActivityTaskCompletedByIDRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RespondActivityTaskCompletedByIDRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RespondActivityTaskCompletedByIDRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.WorkflowID = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.RunID = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ActivityID = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TBinary {
				v.Result, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Identity = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RespondActivityTaskCompletedByIDRequest
// struct.
func (v *RespondActivityTaskCompletedByIDRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [6]string
	i := 0
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.WorkflowID != nil {
		fields[i] = fmt.Sprintf("WorkflowID: %v", *(v.WorkflowID))
		i++
	}
	if v.RunID != nil {
		fields[i] = fmt.Sprintf("RunID: %v", *(v.RunID))
		i++
	}
	if v.ActivityID != nil {
		fields[i] = fmt.Sprintf("ActivityID: %v", *(v.ActivityID))
		i++
	}
	if v.Result != nil {
		fields[i] = fmt.Sprintf("Result: %v", v.Result)
		i++
	}
	if v.Identity != nil {
		fields[i] = fmt.Sprintf("Identity: %v", *(v.Identity))
		i++
	}

	return fmt.Sprintf("RespondActivityTaskCompletedByIDRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RespondActivityTaskCompletedByIDRequest match the
// provided RespondActivityTaskCompletedByIDRequest.
//
// This function performs a deep comparison.
func (v *RespondActivityTaskCompletedByIDRequest) Equals(rhs *RespondActivityTaskCompletedByIDRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !_String_EqualsPtr(v.WorkflowID, rhs.WorkflowID) {
		return false
	}
	if !_String_EqualsPtr(v.RunID, rhs.RunID) {
		return false
	}
	if !_String_EqualsPtr(v.ActivityID, rhs.ActivityID) {
		return false
	}
	if !((v.Result == nil && rhs.Result == nil) || (v.Result != nil && rhs.Result != nil && bytes.Equal(v.Result, rhs.Result))) {
		return false
	}
	if !_String_EqualsPtr(v.Identity, rhs.Identity) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RespondActivityTaskCompletedByIDRequest.
func (v *RespondActivityTaskCompletedByIDRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.WorkflowID != nil {
		enc.AddString("workflowID", *v.WorkflowID)
	}
	if v.RunID != nil {
		enc.AddString("runID", *v.RunID)
	}
	if v.ActivityID != nil {
		enc.AddString("activityID", *v.ActivityID)
	}
	if v.Result != nil {
		enc.AddString("result", base64.StdEncoding.EncodeToString(v.Result))
	}
	if v.Identity != nil {
		enc.AddString("identity", *v.Identity)
	}
	return err
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskCompletedByIDRequest) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *RespondActivityTaskCompletedByIDRequest) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetWorkflowID returns the value of WorkflowID if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskCompletedByIDRequest) GetWorkflowID() (o string) {
	if v != nil && v.WorkflowID != nil {
		return *v.WorkflowID
	}

	return
}

// IsSetWorkflowID returns true if WorkflowID is not nil.
func (v *RespondActivityTaskCompletedByIDRequest) IsSetWorkflowID() bool {
	return v != nil && v.WorkflowID != nil
}

// GetRunID returns the value of RunID if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskCompletedByIDRequest) GetRunID() (o string) {
	if v != nil && v.RunID != nil {
		return *v.RunID
	}

	return
}

// IsSetRunID returns true if RunID is not nil.
func (v *RespondActivityTaskCompletedByIDRequest) IsSetRunID() bool {
	return v != nil && v.RunID != nil
}

// GetActivityID returns the value of ActivityID if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskCompletedByIDRequest) GetActivityID() (o string) {
	if v != nil && v.ActivityID != nil {
		return *v.ActivityID
	}

	return
}

// IsSetActivityID returns true if ActivityID is not nil.
func (v *RespondActivityTaskCompletedByIDRequest) IsSetActivityID() bool {
	return v != nil && v.ActivityID != nil
}

// GetResult returns the value of Result if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskCompletedByIDRequest) GetResult() (o []byte) {
	if v != nil && v.Result != nil {
		return v.Result
	}

	return
}

// IsSetResult returns true if Result is not nil.
func (v *RespondActivityTaskCompletedByIDRequest) IsSetResult() bool {
	return v != nil && v.Result != nil
}

// GetIdentity returns the value of Identity if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskCompletedByIDRequest) GetIdentity() (o string) {
	if v != nil && v.Identity != nil {
		return *v.Identity
	}

	return
}

// IsSetIdentity returns true if Identity is not nil.
func (v *RespondActivityTaskCompletedByIDRequest) IsSetIdentity() bool {
	return v != nil && v.Identity != nil
}

type RespondActivityTaskCompletedRequest struct {
	TaskToken []byte  `json:"taskToken,omitempty"`
	Result    []byte  `json:"result,omitempty"`
	Identity  *string `json:"identity,omitempty"`
}

// ToWire translates a RespondActivityTaskCompletedRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RespondActivityTaskCompletedRequest) ToWire() (wire.Value, error) {
	var (
		fields [3]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.TaskToken != nil {
		w, err = wire.NewValueBinary(v.TaskToken), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Result != nil {
		w, err = wire.NewValueBinary(v.Result), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.Identity != nil {
		w, err = wire.NewValueString(*(v.Identity)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a RespondActivityTaskCompletedRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RespondActivityTaskCompletedRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RespondActivityTaskCompletedRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RespondActivityTaskCompletedRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				v.TaskToken, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				v.Result, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Identity = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RespondActivityTaskCompletedRequest
// struct.
func (v *RespondActivityTaskCompletedRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [3]string
	i := 0
	if v.TaskToken != nil {
		fields[i] = fmt.Sprintf("TaskToken: %v", v.TaskToken)
		i++
	}
	if v.Result != nil {
		fields[i] = fmt.Sprintf("Result: %v", v.Result)
		i++
	}
	if v.Identity != nil {
		fields[i] = fmt.Sprintf("Identity: %v", *(v.Identity))
		i++
	}

	return fmt.Sprintf("RespondActivityTaskCompletedRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RespondActivityTaskCompletedRequest match the
// provided RespondActivityTaskCompletedRequest.
//
// This function performs a deep comparison.
func (v *RespondActivityTaskCompletedRequest) Equals(rhs *RespondActivityTaskCompletedRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.TaskToken == nil && rhs.TaskToken == nil) || (v.TaskToken != nil && rhs.TaskToken != nil && bytes.Equal(v.TaskToken, rhs.TaskToken))) {
		return false
	}
	if !((v.Result == nil && rhs.Result == nil) || (v.Result != nil && rhs.Result != nil && bytes.Equal(v.Result, rhs.Result))) {
		return false
	}
	if !_String_EqualsPtr(v.Identity, rhs.Identity) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RespondActivityTaskCompletedRequest.
func (v *RespondActivityTaskCompletedRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.TaskToken != nil {
		enc.AddString("taskToken", base64.StdEncoding.EncodeToString(v.TaskToken))
	}
	if v.Result != nil {
		enc.AddString("result", base64.StdEncoding.EncodeToString(v.Result))
	}
	if v.Identity != nil {
		enc.AddString("identity", *v.Identity)
	}
	return err
}

// GetTaskToken returns the value of TaskToken if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskCompletedRequest) GetTaskToken() (o []byte) {
	if v != nil && v.TaskToken != nil {
		return v.TaskToken
	}

	return
}

// IsSetTaskToken returns true if TaskToken is not nil.
func (v *RespondActivityTaskCompletedRequest) IsSetTaskToken() bool {
	return v != nil && v.TaskToken != nil
}

// GetResult returns the value of Result if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskCompletedRequest) GetResult() (o []byte) {
	if v != nil && v.Result != nil {
		return v.Result
	}

	return
}

// IsSetResult returns true if Result is not nil.
func (v *RespondActivityTaskCompletedRequest) IsSetResult() bool {
	return v != nil && v.Result != nil
}

// GetIdentity returns the value of Identity if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskCompletedRequest) GetIdentity() (o string) {
	if v != nil && v.Identity != nil {
		return *v.Identity
	}

	return
}

// IsSetIdentity returns true if Identity is not nil.
func (v *RespondActivityTaskCompletedRequest) IsSetIdentity() bool {
	return v != nil && v.Identity != nil
}

type RespondActivityTaskFailedByIDRequest struct {
	Domain     *string `json:"domain,omitempty"`
	WorkflowID *string `json:"workflowID,omitempty"`
	RunID      *string `json:"runID,omitempty"`
	ActivityID *string `json:"activityID,omitempty"`
	Reason     *string `json:"reason,omitempty"`
	Details    []byte  `json:"details,omitempty"`
	Identity   *string `json:"identity,omitempty"`
}

// ToWire translates a RespondActivityTaskFailedByIDRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RespondActivityTaskFailedByIDRequest) ToWire() (wire.Value, error) {
	var (
		fields [7]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Domain != nil {
		w, err = wire.NewValueString(*(v.Domain)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.WorkflowID != nil {
		w, err = wire.NewValueString(*(v.WorkflowID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.RunID != nil {
		w, err = wire.NewValueString(*(v.RunID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.ActivityID != nil {
		w, err = wire.NewValueString(*(v.ActivityID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.Reason != nil {
		w, err = wire.NewValueString(*(v.Reason)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.Details != nil {
		w, err = wire.NewValueBinary(v.Details), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}
	if v.Identity != nil {
		w, err = wire.NewValueString(*(v.Identity)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 70, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a RespondActivityTaskFailedByIDRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RespondActivityTaskFailedByIDRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RespondActivityTaskFailedByIDRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RespondActivityTaskFailedByIDRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Domain = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.WorkflowID = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.RunID = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ActivityID = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Reason = &x
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TBinary {
				v.Details, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 70:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Identity = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RespondActivityTaskFailedByIDRequest
// struct.
func (v *RespondActivityTaskFailedByIDRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [7]string
	i := 0
	if v.Domain != nil {
		fields[i] = fmt.Sprintf("Domain: %v", *(v.Domain))
		i++
	}
	if v.WorkflowID != nil {
		fields[i] = fmt.Sprintf("WorkflowID: %v", *(v.WorkflowID))
		i++
	}
	if v.RunID != nil {
		fields[i] = fmt.Sprintf("RunID: %v", *(v.RunID))
		i++
	}
	if v.ActivityID != nil {
		fields[i] = fmt.Sprintf("ActivityID: %v", *(v.ActivityID))
		i++
	}
	if v.Reason != nil {
		fields[i] = fmt.Sprintf("Reason: %v", *(v.Reason))
		i++
	}
	if v.Details != nil {
		fields[i] = fmt.Sprintf("Details: %v", v.Details)
		i++
	}
	if v.Identity != nil {
		fields[i] = fmt.Sprintf("Identity: %v", *(v.Identity))
		i++
	}

	return fmt.Sprintf("RespondActivityTaskFailedByIDRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RespondActivityTaskFailedByIDRequest match the
// provided RespondActivityTaskFailedByIDRequest.
//
// This function performs a deep comparison.
func (v *RespondActivityTaskFailedByIDRequest) Equals(rhs *RespondActivityTaskFailedByIDRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Domain, rhs.Domain) {
		return false
	}
	if !_String_EqualsPtr(v.WorkflowID, rhs.WorkflowID) {
		return false
	}
	if !_String_EqualsPtr(v.RunID, rhs.RunID) {
		return false
	}
	if !_String_EqualsPtr(v.ActivityID, rhs.ActivityID) {
		return false
	}
	if !_String_EqualsPtr(v.Reason, rhs.Reason) {
		return false
	}
	if !((v.Details == nil && rhs.Details == nil) || (v.Details != nil && rhs.Details != nil && bytes.Equal(v.Details, rhs.Details))) {
		return false
	}
	if !_String_EqualsPtr(v.Identity, rhs.Identity) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RespondActivityTaskFailedByIDRequest.
func (v *RespondActivityTaskFailedByIDRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Domain != nil {
		enc.AddString("domain", *v.Domain)
	}
	if v.WorkflowID != nil {
		enc.AddString("workflowID", *v.WorkflowID)
	}
	if v.RunID != nil {
		enc.AddString("runID", *v.RunID)
	}
	if v.ActivityID != nil {
		enc.AddString("activityID", *v.ActivityID)
	}
	if v.Reason != nil {
		enc.AddString("reason", *v.Reason)
	}
	if v.Details != nil {
		enc.AddString("details", base64.StdEncoding.EncodeToString(v.Details))
	}
	if v.Identity != nil {
		enc.AddString("identity", *v.Identity)
	}
	return err
}

// GetDomain returns the value of Domain if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskFailedByIDRequest) GetDomain() (o string) {
	if v != nil && v.Domain != nil {
		return *v.Domain
	}

	return
}

// IsSetDomain returns true if Domain is not nil.
func (v *RespondActivityTaskFailedByIDRequest) IsSetDomain() bool {
	return v != nil && v.Domain != nil
}

// GetWorkflowID returns the value of WorkflowID if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskFailedByIDRequest) GetWorkflowID() (o string) {
	if v != nil && v.WorkflowID != nil {
		return *v.WorkflowID
	}

	return
}

// IsSetWorkflowID returns true if WorkflowID is not nil.
func (v *RespondActivityTaskFailedByIDRequest) IsSetWorkflowID() bool {
	return v != nil && v.WorkflowID != nil
}

// GetRunID returns the value of RunID if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskFailedByIDRequest) GetRunID() (o string) {
	if v != nil && v.RunID != nil {
		return *v.RunID
	}

	return
}

// IsSetRunID returns true if RunID is not nil.
func (v *RespondActivityTaskFailedByIDRequest) IsSetRunID() bool {
	return v != nil && v.RunID != nil
}

// GetActivityID returns the value of ActivityID if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskFailedByIDRequest) GetActivityID() (o string) {
	if v != nil && v.ActivityID != nil {
		return *v.ActivityID
	}

	return
}

// IsSetActivityID returns true if ActivityID is not nil.
func (v *RespondActivityTaskFailedByIDRequest) IsSetActivityID() bool {
	return v != nil && v.ActivityID != nil
}

// GetReason returns the value of Reason if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskFailedByIDRequest) GetReason() (o string) {
	if v != nil && v.Reason != nil {
		return *v.Reason
	}

	return
}

// IsSetReason returns true if Reason is not nil.
func (v *RespondActivityTaskFailedByIDRequest) IsSetReason() bool {
	return v != nil && v.Reason != nil
}

// GetDetails returns the value of Details if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskFailedByIDRequest) GetDetails() (o []byte) {
	if v != nil && v.Details != nil {
		return v.Details
	}

	return
}

// IsSetDetails returns true if Details is not nil.
func (v *RespondActivityTaskFailedByIDRequest) IsSetDetails() bool {
	return v != nil && v.Details != nil
}

// GetIdentity returns the value of Identity if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskFailedByIDRequest) GetIdentity() (o string) {
	if v != nil && v.Identity != nil {
		return *v.Identity
	}

	return
}

// IsSetIdentity returns true if Identity is not nil.
func (v *RespondActivityTaskFailedByIDRequest) IsSetIdentity() bool {
	return v != nil && v.Identity != nil
}

type RespondActivityTaskFailedRequest struct {
	TaskToken []byte  `json:"taskToken,omitempty"`
	Reason    *string `json:"reason,omitempty"`
	Details   []byte  `json:"details,omitempty"`
	Identity  *string `json:"identity,omitempty"`
}

// ToWire translates a RespondActivityTaskFailedRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RespondActivityTaskFailedRequest) ToWire() (wire.Value, error) {
	var (
		fields [4]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.TaskToken != nil {
		w, err = wire.NewValueBinary(v.TaskToken), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Reason != nil {
		w, err = wire.NewValueString(*(v.Reason)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.Details != nil {
		w, err = wire.NewValueBinary(v.Details), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.Identity != nil {
		w, err = wire.NewValueString(*(v.Identity)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a RespondActivityTaskFailedRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RespondActivityTaskFailedRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RespondActivityTaskFailedRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RespondActivityTaskFailedRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				v.TaskToken, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Reason = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				v.Details, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Identity = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RespondActivityTaskFailedRequest
// struct.
func (v *RespondActivityTaskFailedRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [4]string
	i := 0
	if v.TaskToken != nil {
		fields[i] = fmt.Sprintf("TaskToken: %v", v.TaskToken)
		i++
	}
	if v.Reason != nil {
		fields[i] = fmt.Sprintf("Reason: %v", *(v.Reason))
		i++
	}
	if v.Details != nil {
		fields[i] = fmt.Sprintf("Details: %v", v.Details)
		i++
	}
	if v.Identity != nil {
		fields[i] = fmt.Sprintf("Identity: %v", *(v.Identity))
		i++
	}

	return fmt.Sprintf("RespondActivityTaskFailedRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RespondActivityTaskFailedRequest match the
// provided RespondActivityTaskFailedRequest.
//
// This function performs a deep comparison.
func (v *RespondActivityTaskFailedRequest) Equals(rhs *RespondActivityTaskFailedRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.TaskToken == nil && rhs.TaskToken == nil) || (v.TaskToken != nil && rhs.TaskToken != nil && bytes.Equal(v.TaskToken, rhs.TaskToken))) {
		return false
	}
	if !_String_EqualsPtr(v.Reason, rhs.Reason) {
		return false
	}
	if !((v.Details == nil && rhs.Details == nil) || (v.Details != nil && rhs.Details != nil && bytes.Equal(v.Details, rhs.Details))) {
		return false
	}
	if !_String_EqualsPtr(v.Identity, rhs.Identity) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RespondActivityTaskFailedRequest.
func (v *RespondActivityTaskFailedRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.TaskToken != nil {
		enc.AddString("taskToken", base64.StdEncoding.EncodeToString(v.TaskToken))
	}
	if v.Reason != nil {
		enc.AddString("reason", *v.Reason)
	}
	if v.Details != nil {
		enc.AddString("details", base64.StdEncoding.EncodeToString(v.Details))
	}
	if v.Identity != nil {
		enc.AddString("identity", *v.Identity)
	}
	return err
}

// GetTaskToken returns the value of TaskToken if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskFailedRequest) GetTaskToken() (o []byte) {
	if v != nil && v.TaskToken != nil {
		return v.TaskToken
	}

	return
}

// IsSetTaskToken returns true if TaskToken is not nil.
func (v *RespondActivityTaskFailedRequest) IsSetTaskToken() bool {
	return v != nil && v.TaskToken != nil
}

// GetReason returns the value of Reason if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskFailedRequest) GetReason() (o string) {
	if v != nil && v.Reason != nil {
		return *v.Reason
	}

	return
}

// IsSetReason returns true if Reason is not nil.
func (v *RespondActivityTaskFailedRequest) IsSetReason() bool {
	return v != nil && v.Reason != nil
}

// GetDetails returns the value of Details if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskFailedRequest) GetDetails() (o []byte) {
	if v != nil && v.Details != nil {
		return v.Details
	}

	return
}

// IsSetDetails returns true if Details is not nil.
func (v *RespondActivityTaskFailedRequest) IsSetDetails() bool {
	return v != nil && v.Details != nil
}

// GetIdentity returns the value of Identity if it is set or its
// zero value if it is unset.
func (v *RespondActivityTaskFailedRequest) GetIdentity() (o string) {
	if v != nil && v.Identity != nil {
		return *v.Identity
	}

	return
}

// IsSetIdentity returns true if Identity is not nil.
func (v *RespondActivityTaskFailedRequest) IsSetIdentity() bool {
	return v != nil && v.Identity != nil
}

type RespondDecisionTaskCompletedRequest struct {
	TaskToken                  []byte                     `json:"taskToken,omitempty"`
	Decisions                  []*Decision                `json:"decisions,omitempty"`
	ExecutionContext           []byte                     `json:"executionContext,omitempty"`
	Identity                   *string                    `json:"identity,omitempty"`
	StickyAttributes           *StickyExecutionAttributes `json:"stickyAttributes,omitempty"`
	ReturnNewDecisionTask      *bool                      `json:"returnNewDecisionTask,omitempty"`
	ForceCreateNewDecisionTask *bool                      `json:"forceCreateNewDecisionTask,omitempty"`
	BinaryChecksum             *string                    `json:"binaryChecksum,omitempty"`
}

type _List_Decision_ValueList []*Decision

func (v _List_Decision_ValueList) ForEach(f func(wire.Value) error) error {
	for i, x := range v {
		if x == nil {
			return fmt.Errorf("invalid [%v]: value is nil", i)
		}
		w, err := x.ToWire()
		if err != nil {
			return err
		}
		err = f(w)
		if err != nil {
			return err
		}
	}
	return nil
}

func (v _List_Decision_ValueList) Size() int {
	return len(v)
}

func (_List_Decision_ValueList) ValueType() wire.Type {
	return wire.TStruct
}

func (_List_Decision_ValueList) Close() {}

// ToWire translates a RespondDecisionTaskCompletedRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RespondDecisionTaskCompletedRequest) ToWire() (wire.Value, error) {
	var (
		fields [8]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.TaskToken != nil {
		w, err = wire.NewValueBinary(v.TaskToken), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Decisions != nil {
		w, err = wire.NewValueList(_List_Decision_ValueList(v.Decisions)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.ExecutionContext != nil {
		w, err = wire.NewValueBinary(v.ExecutionContext), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.Identity != nil {
		w, err = wire.NewValueString(*(v.Identity)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.StickyAttributes != nil {
		w, err = v.StickyAttributes.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.ReturnNewDecisionTask != nil {
		w, err = wire.NewValueBool(*(v.ReturnNewDecisionTask)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}
	if v.ForceCreateNewDecisionTask != nil {
		w, err = wire.NewValueBool(*(v.ForceCreateNewDecisionTask)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 70, Value: w}
		i++
	}
	if v.BinaryChecksum != nil {
		w, err = wire.NewValueString(*(v.BinaryChecksum)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 80, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _Decision_Read(w wire.Value) (*Decision, error) {
	var v Decision
	err := v.FromWire(w)
	return &v, err
}

func _List_Decision_Read(l wire.ValueList) ([]*Decision, error) {
	if l.ValueType() != wire.TStruct {
		return nil, nil
	}

	o := make([]*Decision, 0, l.Size())
	err := l.ForEach(func(x wire.Value) error {
		i, err := _Decision_Read(x)
		if err != nil {
			return err
		}
		o = append(o, i)
		return nil
	})
	l.Close()
	return o, err
}

func _StickyExecutionAttributes_Read(w wire.Value) (*StickyExecutionAttributes, error) {
	var v StickyExecutionAttributes
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a RespondDecisionTaskCompletedRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RespondDecisionTaskCompletedRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RespondDecisionTaskCompletedRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RespondDecisionTaskCompletedRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				v.TaskToken, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TList {
				v.Decisions, err = _List_Decision_Read(field.Value.GetList())
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				v.ExecutionContext, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Identity = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TStruct {
				v.StickyAttributes, err = _StickyExecutionAttributes_Read(field.Value)
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TBool {
				var x bool
				x, err = field.Value.GetBool(), error(nil)
				v.ReturnNewDecisionTask = &x
				if err != nil {
					return err
				}

			}
		case 70:
			if field.Value.Type() == wire.TBool {
				var x bool
				x, err = field.Value.GetBool(), error(nil)
				v.ForceCreateNewDecisionTask = &x
				if err != nil {
					return err
				}

			}
		case 80:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.BinaryChecksum = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RespondDecisionTaskCompletedRequest
// struct.
func (v *RespondDecisionTaskCompletedRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [8]string
	i := 0
	if v.TaskToken != nil {
		fields[i] = fmt.Sprintf("TaskToken: %v", v.TaskToken)
		i++
	}
	if v.Decisions != nil {
		fields[i] = fmt.Sprintf("Decisions: %v", v.Decisions)
		i++
	}
	if v.ExecutionContext != nil {
		fields[i] = fmt.Sprintf("ExecutionContext: %v", v.ExecutionContext)
		i++
	}
	if v.Identity != nil {
		fields[i] = fmt.Sprintf("Identity: %v", *(v.Identity))
		i++
	}
	if v.StickyAttributes != nil {
		fields[i] = fmt.Sprintf("StickyAttributes: %v", v.StickyAttributes)
		i++
	}
	if v.ReturnNewDecisionTask != nil {
		fields[i] = fmt.Sprintf("ReturnNewDecisionTask: %v", *(v.ReturnNewDecisionTask))
		i++
	}
	if v.ForceCreateNewDecisionTask != nil {
		fields[i] = fmt.Sprintf("ForceCreateNewDecisionTask: %v", *(v.ForceCreateNewDecisionTask))
		i++
	}
	if v.BinaryChecksum != nil {
		fields[i] = fmt.Sprintf("BinaryChecksum: %v", *(v.BinaryChecksum))
		i++
	}

	return fmt.Sprintf("RespondDecisionTaskCompletedRequest{%v}", strings.Join(fields[:i], ", "))
}

func _List_Decision_Equals(lhs, rhs []*Decision) bool {
	if len(lhs) != len(rhs) {
		return false
	}

	for i, lv := range lhs {
		rv := rhs[i]
		if !lv.Equals(rv) {
			return false
		}
	}

	return true
}

// Equals returns true if all the fields of this RespondDecisionTaskCompletedRequest match the
// provided RespondDecisionTaskCompletedRequest.
//
// This function performs a deep comparison.
func (v *RespondDecisionTaskCompletedRequest) Equals(rhs *RespondDecisionTaskCompletedRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.TaskToken == nil && rhs.TaskToken == nil) || (v.TaskToken != nil && rhs.TaskToken != nil && bytes.Equal(v.TaskToken, rhs.TaskToken))) {
		return false
	}
	if !((v.Decisions == nil && rhs.Decisions == nil) || (v.Decisions != nil && rhs.Decisions != nil && _List_Decision_Equals(v.Decisions, rhs.Decisions))) {
		return false
	}
	if !((v.ExecutionContext == nil && rhs.ExecutionContext == nil) || (v.ExecutionContext != nil && rhs.ExecutionContext != nil && bytes.Equal(v.ExecutionContext, rhs.ExecutionContext))) {
		return false
	}
	if !_String_EqualsPtr(v.Identity, rhs.Identity) {
		return false
	}
	if !((v.StickyAttributes == nil && rhs.StickyAttributes == nil) || (v.StickyAttributes != nil && rhs.StickyAttributes != nil && v.StickyAttributes.Equals(rhs.StickyAttributes))) {
		return false
	}
	if !_Bool_EqualsPtr(v.ReturnNewDecisionTask, rhs.ReturnNewDecisionTask) {
		return false
	}
	if !_Bool_EqualsPtr(v.ForceCreateNewDecisionTask, rhs.ForceCreateNewDecisionTask) {
		return false
	}
	if !_String_EqualsPtr(v.BinaryChecksum, rhs.BinaryChecksum) {
		return false
	}

	return true
}

type _List_Decision_Zapper []*Decision

// MarshalLogArray implements zapcore.ArrayMarshaler, enabling
// fast logging of _List_Decision_Zapper.
func (l _List_Decision_Zapper) MarshalLogArray(enc zapcore.ArrayEncoder) (err error) {
	for _, v := range l {
		err = multierr.Append(err, enc.AppendObject(v))
	}
	return err
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RespondDecisionTaskCompletedRequest.
func (v *RespondDecisionTaskCompletedRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.TaskToken != nil {
		enc.AddString("taskToken", base64.StdEncoding.EncodeToString(v.TaskToken))
	}
	if v.Decisions != nil {
		err = multierr.Append(err, enc.AddArray("decisions", (_List_Decision_Zapper)(v.Decisions)))
	}
	if v.ExecutionContext != nil {
		enc.AddString("executionContext", base64.StdEncoding.EncodeToString(v.ExecutionContext))
	}
	if v.Identity != nil {
		enc.AddString("identity", *v.Identity)
	}
	if v.StickyAttributes != nil {
		err = multierr.Append(err, enc.AddObject("stickyAttributes", v.StickyAttributes))
	}
	if v.ReturnNewDecisionTask != nil {
		enc.AddBool("returnNewDecisionTask", *v.ReturnNewDecisionTask)
	}
	if v.ForceCreateNewDecisionTask != nil {
		enc.AddBool("forceCreateNewDecisionTask", *v.ForceCreateNewDecisionTask)
	}
	if v.BinaryChecksum != nil {
		enc.AddString("binaryChecksum", *v.BinaryChecksum)
	}
	return err
}

// GetTaskToken returns the value of TaskToken if it is set or its
// zero value if it is unset.
func (v *RespondDecisionTaskCompletedRequest) GetTaskToken() (o []byte) {
	if v != nil && v.TaskToken != nil {
		return v.TaskToken
	}

	return
}

// IsSetTaskToken returns true if TaskToken is not nil.
func (v *RespondDecisionTaskCompletedRequest) IsSetTaskToken() bool {
	return v != nil && v.TaskToken != nil
}

// GetDecisions returns the value of Decisions if it is set or its
// zero value if it is unset.
func (v *RespondDecisionTaskCompletedRequest) GetDecisions() (o []*Decision) {
	if v != nil && v.Decisions != nil {
		return v.Decisions
	}

	return
}

// IsSetDecisions returns true if Decisions is not nil.
func (v *RespondDecisionTaskCompletedRequest) IsSetDecisions() bool {
	return v != nil && v.Decisions != nil
}

// GetExecutionContext returns the value of ExecutionContext if it is set or its
// zero value if it is unset.
func (v *RespondDecisionTaskCompletedRequest) GetExecutionContext() (o []byte) {
	if v != nil && v.ExecutionContext != nil {
		return v.ExecutionContext
	}

	return
}

// IsSetExecutionContext returns true if ExecutionContext is not nil.
func (v *RespondDecisionTaskCompletedRequest) IsSetExecutionContext() bool {
	return v != nil && v.ExecutionContext != nil
}

// GetIdentity returns the value of Identity if it is set or its
// zero value if it is unset.
func (v *RespondDecisionTaskCompletedRequest) GetIdentity() (o string) {
	if v != nil && v.Identity != nil {
		return *v.Identity
	}

	return
}

// IsSetIdentity returns true if Identity is not nil.
func (v *RespondDecisionTaskCompletedRequest) IsSetIdentity() bool {
	return v != nil && v.Identity != nil
}

// GetStickyAttributes returns the value of StickyAttributes if it is set or its
// zero value if it is unset.
func (v *RespondDecisionTaskCompletedRequest) GetStickyAttributes() (o *StickyExecutionAttributes) {
	if v != nil && v.StickyAttributes != nil {
		return v.StickyAttributes
	}

	return
}

// IsSetStickyAttributes returns true if StickyAttributes is not nil.
func (v *RespondDecisionTaskCompletedRequest) IsSetStickyAttributes() bool {
	return v != nil && v.StickyAttributes != nil
}

// GetReturnNewDecisionTask returns the value of ReturnNewDecisionTask if it is set or its
// zero value if it is unset.
func (v *RespondDecisionTaskCompletedRequest) GetReturnNewDecisionTask() (o bool) {
	if v != nil && v.ReturnNewDecisionTask != nil {
		return *v.ReturnNewDecisionTask
	}

	return
}

// IsSetReturnNewDecisionTask returns true if ReturnNewDecisionTask is not nil.
func (v *RespondDecisionTaskCompletedRequest) IsSetReturnNewDecisionTask() bool {
	return v != nil && v.ReturnNewDecisionTask != nil
}

// GetForceCreateNewDecisionTask returns the value of ForceCreateNewDecisionTask if it is set or its
// zero value if it is unset.
func (v *RespondDecisionTaskCompletedRequest) GetForceCreateNewDecisionTask() (o bool) {
	if v != nil && v.ForceCreateNewDecisionTask != nil {
		return *v.ForceCreateNewDecisionTask
	}

	return
}

// IsSetForceCreateNewDecisionTask returns true if ForceCreateNewDecisionTask is not nil.
func (v *RespondDecisionTaskCompletedRequest) IsSetForceCreateNewDecisionTask() bool {
	return v != nil && v.ForceCreateNewDecisionTask != nil
}

// GetBinaryChecksum returns the value of BinaryChecksum if it is set or its
// zero value if it is unset.
func (v *RespondDecisionTaskCompletedRequest) GetBinaryChecksum() (o string) {
	if v != nil && v.BinaryChecksum != nil {
		return *v.BinaryChecksum
	}

	return
}

// IsSetBinaryChecksum returns true if BinaryChecksum is not nil.
func (v *RespondDecisionTaskCompletedRequest) IsSetBinaryChecksum() bool {
	return v != nil && v.BinaryChecksum != nil
}

type RespondDecisionTaskCompletedResponse struct {
	DecisionTask *PollForDecisionTaskResponse `json:"decisionTask,omitempty"`
}

// ToWire translates a RespondDecisionTaskCompletedResponse struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RespondDecisionTaskCompletedResponse) ToWire() (wire.Value, error) {
	var (
		fields [1]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DecisionTask != nil {
		w, err = v.DecisionTask.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _PollForDecisionTaskResponse_Read(w wire.Value) (*PollForDecisionTaskResponse, error) {
	var v PollForDecisionTaskResponse
	err := v.FromWire(w)
	return &v, err
}

// FromWire deserializes a RespondDecisionTaskCompletedResponse struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RespondDecisionTaskCompletedResponse struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RespondDecisionTaskCompletedResponse
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RespondDecisionTaskCompletedResponse) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TStruct {
				v.DecisionTask, err = _PollForDecisionTaskResponse_Read(field.Value)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RespondDecisionTaskCompletedResponse
// struct.
func (v *RespondDecisionTaskCompletedResponse) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [1]string
	i := 0
	if v.DecisionTask != nil {
		fields[i] = fmt.Sprintf("DecisionTask: %v", v.DecisionTask)
		i++
	}

	return fmt.Sprintf("RespondDecisionTaskCompletedResponse{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RespondDecisionTaskCompletedResponse match the
// provided RespondDecisionTaskCompletedResponse.
//
// This function performs a deep comparison.
func (v *RespondDecisionTaskCompletedResponse) Equals(rhs *RespondDecisionTaskCompletedResponse) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.DecisionTask == nil && rhs.DecisionTask == nil) || (v.DecisionTask != nil && rhs.DecisionTask != nil && v.DecisionTask.Equals(rhs.DecisionTask))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RespondDecisionTaskCompletedResponse.
func (v *RespondDecisionTaskCompletedResponse) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DecisionTask != nil {
		err = multierr.Append(err, enc.AddObject("decisionTask", v.DecisionTask))
	}
	return err
}

// GetDecisionTask returns the value of DecisionTask if it is set or its
// zero value if it is unset.
func (v *RespondDecisionTaskCompletedResponse) GetDecisionTask() (o *PollForDecisionTaskResponse) {
	if v != nil && v.DecisionTask != nil {
		return v.DecisionTask
	}

	return
}

// IsSetDecisionTask returns true if DecisionTask is not nil.
func (v *RespondDecisionTaskCompletedResponse) IsSetDecisionTask() bool {
	return v != nil && v.DecisionTask != nil
}

type RespondDecisionTaskFailedRequest struct {
	TaskToken []byte                   `json:"taskToken,omitempty"`
	Cause     *DecisionTaskFailedCause `json:"cause,omitempty"`
	Details   []byte                   `json:"details,omitempty"`
	Identity  *string                  `json:"identity,omitempty"`
}

// ToWire translates a RespondDecisionTaskFailedRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RespondDecisionTaskFailedRequest) ToWire() (wire.Value, error) {
	var (
		fields [4]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.TaskToken != nil {
		w, err = wire.NewValueBinary(v.TaskToken), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Cause != nil {
		w, err = v.Cause.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.Details != nil {
		w, err = wire.NewValueBinary(v.Details), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.Identity != nil {
		w, err = wire.NewValueString(*(v.Identity)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a RespondDecisionTaskFailedRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RespondDecisionTaskFailedRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RespondDecisionTaskFailedRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RespondDecisionTaskFailedRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				v.TaskToken, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI32 {
				var x DecisionTaskFailedCause
				x, err = _DecisionTaskFailedCause_Read(field.Value)
				v.Cause = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				v.Details, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Identity = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RespondDecisionTaskFailedRequest
// struct.
func (v *RespondDecisionTaskFailedRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [4]string
	i := 0
	if v.TaskToken != nil {
		fields[i] = fmt.Sprintf("TaskToken: %v", v.TaskToken)
		i++
	}
	if v.Cause != nil {
		fields[i] = fmt.Sprintf("Cause: %v", *(v.Cause))
		i++
	}
	if v.Details != nil {
		fields[i] = fmt.Sprintf("Details: %v", v.Details)
		i++
	}
	if v.Identity != nil {
		fields[i] = fmt.Sprintf("Identity: %v", *(v.Identity))
		i++
	}

	return fmt.Sprintf("RespondDecisionTaskFailedRequest{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RespondDecisionTaskFailedRequest match the
// provided RespondDecisionTaskFailedRequest.
//
// This function performs a deep comparison.
func (v *RespondDecisionTaskFailedRequest) Equals(rhs *RespondDecisionTaskFailedRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.TaskToken == nil && rhs.TaskToken == nil) || (v.TaskToken != nil && rhs.TaskToken != nil && bytes.Equal(v.TaskToken, rhs.TaskToken))) {
		return false
	}
	if !_DecisionTaskFailedCause_EqualsPtr(v.Cause, rhs.Cause) {
		return false
	}
	if !((v.Details == nil && rhs.Details == nil) || (v.Details != nil && rhs.Details != nil && bytes.Equal(v.Details, rhs.Details))) {
		return false
	}
	if !_String_EqualsPtr(v.Identity, rhs.Identity) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RespondDecisionTaskFailedRequest.
func (v *RespondDecisionTaskFailedRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.TaskToken != nil {
		enc.AddString("taskToken", base64.StdEncoding.EncodeToString(v.TaskToken))
	}
	if v.Cause != nil {
		err = multierr.Append(err, enc.AddObject("cause", *v.Cause))
	}
	if v.Details != nil {
		enc.AddString("details", base64.StdEncoding.EncodeToString(v.Details))
	}
	if v.Identity != nil {
		enc.AddString("identity", *v.Identity)
	}
	return err
}

// GetTaskToken returns the value of TaskToken if it is set or its
// zero value if it is unset.
func (v *RespondDecisionTaskFailedRequest) GetTaskToken() (o []byte) {
	if v != nil && v.TaskToken != nil {
		return v.TaskToken
	}

	return
}

// IsSetTaskToken returns true if TaskToken is not nil.
func (v *RespondDecisionTaskFailedRequest) IsSetTaskToken() bool {
	return v != nil && v.TaskToken != nil
}

// GetCause returns the value of Cause if it is set or its
// zero value if it is unset.
func (v *RespondDecisionTaskFailedRequest) GetCause() (o DecisionTaskFailedCause) {
	if v != nil && v.Cause != nil {
		return *v.Cause
	}

	return
}

// IsSetCause returns true if Cause is not nil.
func (v *RespondDecisionTaskFailedRequest) IsSetCause() bool {
	return v != nil && v.Cause != nil
}

// GetDetails returns the value of Details if it is set or its
// zero value if it is unset.
func (v *RespondDecisionTaskFailedRequest) GetDetails() (o []byte) {
	if v != nil && v.Details != nil {
		return v.Details
	}

	return
}

// IsSetDetails returns true if Details is not nil.
func (v *RespondDecisionTaskFailedRequest) IsSetDetails() bool {
	return v != nil && v.Details != nil
}

// GetIdentity returns the value of Identity if it is set or its
// zero value if it is unset.
func (v *RespondDecisionTaskFailedRequest) GetIdentity() (o string) {
	if v != nil && v.Identity != nil {
		return *v.Identity
	}

	return
}

// IsSetIdentity returns true if Identity is not nil.
func (v *RespondDecisionTaskFailedRequest) IsSetIdentity() bool {
	return v != nil && v.Identity != nil
}

type RespondQueryTaskCompletedRequest struct {
	TaskToken     []byte                  `json:"taskToken,omitempty"`
	CompletedType *QueryTaskCompletedType `json:"completedType,omitempty"`
	QueryResult   []byte                  `json:"queryResult,omitempty"`
	ErrorMessage  *string                 `json:"errorMessage,omitempty"`
}

// ToWire translates a RespondQueryTaskCompletedRequest struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RespondQueryTaskCompletedRequest) ToWire() (wire.Value, error) {
	var (
		fields [4]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.TaskToken != nil {
		w, err = wire.NewValueBinary(v.TaskToken), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.CompletedType != nil {
		w, err = v.CompletedType.ToWire()
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.QueryResult != nil {
		w, err = wire.NewValueBinary(v.QueryResult), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.ErrorMessage != nil {
		w, err = wire.NewValueString(*(v.ErrorMessage)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _QueryTaskCompletedType_Read(w wire.Value) (QueryTaskCompletedType, error) {
	var v QueryTaskCompletedType
	err := v.FromWire(w)
	return v, err
}

// FromWire deserializes a RespondQueryTaskCompletedRequest struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RespondQueryTaskCompletedRequest struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RespondQueryTaskCompletedRequest
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RespondQueryTaskCompletedRequest) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				v.TaskToken, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI32 {
				var x QueryTaskCompletedType
				x, err = _QueryTaskCompletedType_Read(field.Value)
				v.CompletedType = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				v.QueryResult, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ErrorMessage = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RespondQueryTaskCompletedRequest
// struct.
func (v *RespondQueryTaskCompletedRequest) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [4]string
	i := 0
	if v.TaskToken != nil {
		fields[i] = fmt.Sprintf("TaskToken: %v", v.TaskToken)
		i++
	}
	if v.CompletedType != nil {
		fields[i] = fmt.Sprintf("CompletedType: %v", *(v.CompletedType))
		i++
	}
	if v.QueryResult != nil {
		fields[i] = fmt.Sprintf("QueryResult: %v", v.QueryResult)
		i++
	}
	if v.ErrorMessage != nil {
		fields[i] = fmt.Sprintf("ErrorMessage: %v", *(v.ErrorMessage))
		i++
	}

	return fmt.Sprintf("RespondQueryTaskCompletedRequest{%v}", strings.Join(fields[:i], ", "))
}

func _QueryTaskCompletedType_EqualsPtr(lhs, rhs *QueryTaskCompletedType) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return x.Equals(y)
	}
	return lhs == nil && rhs == nil
}

// Equals returns true if all the fields of this RespondQueryTaskCompletedRequest match the
// provided RespondQueryTaskCompletedRequest.
//
// This function performs a deep comparison.
func (v *RespondQueryTaskCompletedRequest) Equals(rhs *RespondQueryTaskCompletedRequest) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.TaskToken == nil && rhs.TaskToken == nil) || (v.TaskToken != nil && rhs.TaskToken != nil && bytes.Equal(v.TaskToken, rhs.TaskToken))) {
		return false
	}
	if !_QueryTaskCompletedType_EqualsPtr(v.CompletedType, rhs.CompletedType) {
		return false
	}
	if !((v.QueryResult == nil && rhs.QueryResult == nil) || (v.QueryResult != nil && rhs.QueryResult != nil && bytes.Equal(v.QueryResult, rhs.QueryResult))) {
		return false
	}
	if !_String_EqualsPtr(v.ErrorMessage, rhs.ErrorMessage) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RespondQueryTaskCompletedRequest.
func (v *RespondQueryTaskCompletedRequest) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.TaskToken != nil {
		enc.AddString("taskToken", base64.StdEncoding.EncodeToString(v.TaskToken))
	}
	if v.CompletedType != nil {
		err = multierr.Append(err, enc.AddObject("completedType", *v.CompletedType))
	}
	if v.QueryResult != nil {
		enc.AddString("queryResult", base64.StdEncoding.EncodeToString(v.QueryResult))
	}
	if v.ErrorMessage != nil {
		enc.AddString("errorMessage", *v.ErrorMessage)
	}
	return err
}

// GetTaskToken returns the value of TaskToken if it is set or its
// zero value if it is unset.
func (v *RespondQueryTaskCompletedRequest) GetTaskToken() (o []byte) {
	if v != nil && v.TaskToken != nil {
		return v.TaskToken
	}

	return
}

// IsSetTaskToken returns true if TaskToken is not nil.
func (v *RespondQueryTaskCompletedRequest) IsSetTaskToken() bool {
	return v != nil && v.TaskToken != nil
}

// GetCompletedType returns the value of CompletedType if it is set or its
// zero value if it is unset.
func (v *RespondQueryTaskCompletedRequest) GetCompletedType() (o QueryTaskCompletedType) {
	if v != nil && v.CompletedType != nil {
		return *v.CompletedType
	}

	return
}

// IsSetCompletedType returns true if CompletedType is not nil.
func (v *RespondQueryTaskCompletedRequest) IsSetCompletedType() bool {
	return v != nil && v.CompletedType != nil
}

// GetQueryResult returns the value of QueryResult if it is set or its
// zero value if it is unset.
func (v *RespondQueryTaskCompletedRequest) GetQueryResult() (o []byte) {
	if v != nil && v.QueryResult != nil {
		return v.QueryResult
	}

	return
}

// IsSetQueryResult returns true if QueryResult is not nil.
func (v *RespondQueryTaskCompletedRequest) IsSetQueryResult() bool {
	return v != nil && v.QueryResult != nil
}

// GetErrorMessage returns the value of ErrorMessage if it is set or its
// zero value if it is unset.
func (v *RespondQueryTaskCompletedRequest) GetErrorMessage() (o string) {
	if v != nil && v.ErrorMessage != nil {
		return *v.ErrorMessage
	}

	return
}

// IsSetErrorMessage returns true if ErrorMessage is not nil.
func (v *RespondQueryTaskCompletedRequest) IsSetErrorMessage() bool {
	return v != nil && v.ErrorMessage != nil
}

type RetryPolicy struct {
	InitialIntervalInSeconds    *int32   `json:"initialIntervalInSeconds,omitempty"`
	BackoffCoefficient          *float64 `json:"backoffCoefficient,omitempty"`
	MaximumIntervalInSeconds    *int32   `json:"maximumIntervalInSeconds,omitempty"`
	MaximumAttempts             *int32   `json:"maximumAttempts,omitempty"`
	NonRetriableErrorReasons    []string `json:"nonRetriableErrorReasons,omitempty"`
	ExpirationIntervalInSeconds *int32   `json:"expirationIntervalInSeconds,omitempty"`
}

type _List_String_ValueList []string

func (v _List_String_ValueList) ForEach(f func(wire.Value) error) error {
	for _, x := range v {
		w, err := wire.NewValueString(x), error(nil)
		if err != nil {
			return err
		}
		err = f(w)
		if err != nil {
			return err
		}
	}
	return nil
}

func (v _List_String_ValueList) Size() int {
	return len(v)
}

func (_List_String_ValueList) ValueType() wire.Type {
	return wire.TBinary
}

func (_List_String_ValueList) Close() {}

// ToWire translates a RetryPolicy struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RetryPolicy) ToWire() (wire.Value, error) {
	var (
		fields [6]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.InitialIntervalInSeconds != nil {
		w, err = wire.NewValueI32(*(v.InitialIntervalInSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.BackoffCoefficient != nil {
		w, err = wire.NewValueDouble(*(v.BackoffCoefficient)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.MaximumIntervalInSeconds != nil {
		w, err = wire.NewValueI32(*(v.MaximumIntervalInSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.MaximumAttempts != nil {
		w, err = wire.NewValueI32(*(v.MaximumAttempts)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.NonRetriableErrorReasons != nil {
		w, err = wire.NewValueList(_List_String_ValueList(v.NonRetriableErrorReasons)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.ExpirationIntervalInSeconds != nil {
		w, err = wire.NewValueI32(*(v.ExpirationIntervalInSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _List_String_Read(l wire.ValueList) ([]string, error) {
	if l.ValueType() != wire.TBinary {
		return nil, nil
	}

	o := make([]string, 0, l.Size())
	err := l.ForEach(func(x wire.Value) error {
		i, err := x.GetString(), error(nil)
		if err != nil {
			return err
		}
		o = append(o, i)
		return nil
	})
	l.Close()
	return o, err
}

// FromWire deserializes a RetryPolicy struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RetryPolicy struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RetryPolicy
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RetryPolicy) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.InitialIntervalInSeconds = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TDouble {
				var x float64
				x, err = field.Value.GetDouble(), error(nil)
				v.BackoffCoefficient = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.MaximumIntervalInSeconds = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.MaximumAttempts = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TList {
				v.NonRetriableErrorReasons, err = _List_String_Read(field.Value.GetList())
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.ExpirationIntervalInSeconds = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RetryPolicy
// struct.
func (v *RetryPolicy) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [6]string
	i := 0
	if v.InitialIntervalInSeconds != nil {
		fields[i] = fmt.Sprintf("InitialIntervalInSeconds: %v", *(v.InitialIntervalInSeconds))
		i++
	}
	if v.BackoffCoefficient != nil {
		fields[i] = fmt.Sprintf("BackoffCoefficient: %v", *(v.BackoffCoefficient))
		i++
	}
	if v.MaximumIntervalInSeconds != nil {
		fields[i] = fmt.Sprintf("MaximumIntervalInSeconds: %v", *(v.MaximumIntervalInSeconds))
		i++
	}
	if v.MaximumAttempts != nil {
		fields[i] = fmt.Sprintf("MaximumAttempts: %v", *(v.MaximumAttempts))
		i++
	}
	if v.NonRetriableErrorReasons != nil {
		fields[i] = fmt.Sprintf("NonRetriableErrorReasons: %v", v.NonRetriableErrorReasons)
		i++
	}
	if v.ExpirationIntervalInSeconds != nil {
		fields[i] = fmt.Sprintf("ExpirationIntervalInSeconds: %v", *(v.ExpirationIntervalInSeconds))
		i++
	}

	return fmt.Sprintf("RetryPolicy{%v}", strings.Join(fields[:i], ", "))
}

func _List_String_Equals(lhs, rhs []string) bool {
	if len(lhs) != len(rhs) {
		return false
	}

	for i, lv := range lhs {
		rv := rhs[i]
		if !(lv == rv) {
			return false
		}
	}

	return true
}

// Equals returns true if all the fields of this RetryPolicy match the
// provided RetryPolicy.
//
// This function performs a deep comparison.
func (v *RetryPolicy) Equals(rhs *RetryPolicy) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_I32_EqualsPtr(v.InitialIntervalInSeconds, rhs.InitialIntervalInSeconds) {
		return false
	}
	if !_Double_EqualsPtr(v.BackoffCoefficient, rhs.BackoffCoefficient) {
		return false
	}
	if !_I32_EqualsPtr(v.MaximumIntervalInSeconds, rhs.MaximumIntervalInSeconds) {
		return false
	}
	if !_I32_EqualsPtr(v.MaximumAttempts, rhs.MaximumAttempts) {
		return false
	}
	if !((v.NonRetriableErrorReasons == nil && rhs.NonRetriableErrorReasons == nil) || (v.NonRetriableErrorReasons != nil && rhs.NonRetriableErrorReasons != nil && _List_String_Equals(v.NonRetriableErrorReasons, rhs.NonRetriableErrorReasons))) {
		return false
	}
	if !_I32_EqualsPtr(v.ExpirationIntervalInSeconds, rhs.ExpirationIntervalInSeconds) {
		return false
	}

	return true
}

type _List_String_Zapper []string

// MarshalLogArray implements zapcore.ArrayMarshaler, enabling
// fast logging of _List_String_Zapper.
func (l _List_String_Zapper) MarshalLogArray(enc zapcore.ArrayEncoder) (err error) {
	for _, v := range l {
		enc.AppendString(v)
	}
	return err
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RetryPolicy.
func (v *RetryPolicy) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.InitialIntervalInSeconds != nil {
		enc.AddInt32("initialIntervalInSeconds", *v.InitialIntervalInSeconds)
	}
	if v.BackoffCoefficient != nil {
		enc.AddFloat64("backoffCoefficient", *v.BackoffCoefficient)
	}
	if v.MaximumIntervalInSeconds != nil {
		enc.AddInt32("maximumIntervalInSeconds", *v.MaximumIntervalInSeconds)
	}
	if v.MaximumAttempts != nil {
		enc.AddInt32("maximumAttempts", *v.MaximumAttempts)
	}
	if v.NonRetriableErrorReasons != nil {
		err = multierr.Append(err, enc.AddArray("nonRetriableErrorReasons", (_List_