// Copyright (c) 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Code generated by thriftrw v1.18.0. DO NOT EDIT.
// @generated

package sqlblobs

import (
	bytes "bytes"
	base64 "encoding/base64"
	fmt "fmt"
	shared "github.com/uber/cadence/.gen/go/shared"
	multierr "go.uber.org/multierr"
	wire "go.uber.org/thriftrw/wire"
	zapcore "go.uber.org/zap/zapcore"
	strings "strings"
)

type ActivityInfo struct {
	Version                       *int64   `json:"version,omitempty"`
	ScheduledEventBatchID         *int64   `json:"scheduledEventBatchID,omitempty"`
	ScheduledEvent                []byte   `json:"scheduledEvent,omitempty"`
	ScheduledEventEncoding        *string  `json:"scheduledEventEncoding,omitempty"`
	ScheduledTimeNanos            *int64   `json:"scheduledTimeNanos,omitempty"`
	StartedID                     *int64   `json:"startedID,omitempty"`
	StartedEvent                  []byte   `json:"startedEvent,omitempty"`
	StartedEventEncoding          *string  `json:"startedEventEncoding,omitempty"`
	StartedTimeNanos              *int64   `json:"startedTimeNanos,omitempty"`
	ActivityID                    *string  `json:"activityID,omitempty"`
	RequestID                     *string  `json:"requestID,omitempty"`
	ScheduleToStartTimeoutSeconds *int32   `json:"scheduleToStartTimeoutSeconds,omitempty"`
	ScheduleToCloseTimeoutSeconds *int32   `json:"scheduleToCloseTimeoutSeconds,omitempty"`
	StartToCloseTimeoutSeconds    *int32   `json:"startToCloseTimeoutSeconds,omitempty"`
	HeartbeatTimeoutSeconds       *int32   `json:"heartbeatTimeoutSeconds,omitempty"`
	CancelRequested               *bool    `json:"cancelRequested,omitempty"`
	CancelRequestID               *int64   `json:"cancelRequestID,omitempty"`
	TimerTaskStatus               *int32   `json:"timerTaskStatus,omitempty"`
	Attempt                       *int32   `json:"attempt,omitempty"`
	TaskList                      *string  `json:"taskList,omitempty"`
	StartedIdentity               *string  `json:"startedIdentity,omitempty"`
	HasRetryPolicy                *bool    `json:"hasRetryPolicy,omitempty"`
	RetryInitialIntervalSeconds   *int32   `json:"retryInitialIntervalSeconds,omitempty"`
	RetryMaximumIntervalSeconds   *int32   `json:"retryMaximumIntervalSeconds,omitempty"`
	RetryMaximumAttempts          *int32   `json:"retryMaximumAttempts,omitempty"`
	RetryExpirationTimeNanos      *int64   `json:"retryExpirationTimeNanos,omitempty"`
	RetryBackoffCoefficient       *float64 `json:"retryBackoffCoefficient,omitempty"`
	RetryNonRetryableErrors       []string `json:"retryNonRetryableErrors,omitempty"`
}

type _List_String_ValueList []string

func (v _List_String_ValueList) ForEach(f func(wire.Value) error) error {
	for _, x := range v {
		w, err := wire.NewValueString(x), error(nil)
		if err != nil {
			return err
		}
		err = f(w)
		if err != nil {
			return err
		}
	}
	return nil
}

func (v _List_String_ValueList) Size() int {
	return len(v)
}

func (_List_String_ValueList) ValueType() wire.Type {
	return wire.TBinary
}

func (_List_String_ValueList) Close() {}

// ToWire translates a ActivityInfo struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ActivityInfo) ToWire() (wire.Value, error) {
	var (
		fields [28]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Version != nil {
		w, err = wire.NewValueI64(*(v.Version)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.ScheduledEventBatchID != nil {
		w, err = wire.NewValueI64(*(v.ScheduledEventBatchID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 12, Value: w}
		i++
	}
	if v.ScheduledEvent != nil {
		w, err = wire.NewValueBinary(v.ScheduledEvent), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 14, Value: w}
		i++
	}
	if v.ScheduledEventEncoding != nil {
		w, err = wire.NewValueString(*(v.ScheduledEventEncoding)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 16, Value: w}
		i++
	}
	if v.ScheduledTimeNanos != nil {
		w, err = wire.NewValueI64(*(v.ScheduledTimeNanos)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 18, Value: w}
		i++
	}
	if v.StartedID != nil {
		w, err = wire.NewValueI64(*(v.StartedID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.StartedEvent != nil {
		w, err = wire.NewValueBinary(v.StartedEvent), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 22, Value: w}
		i++
	}
	if v.StartedEventEncoding != nil {
		w, err = wire.NewValueString(*(v.StartedEventEncoding)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 24, Value: w}
		i++
	}
	if v.StartedTimeNanos != nil {
		w, err = wire.NewValueI64(*(v.StartedTimeNanos)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 26, Value: w}
		i++
	}
	if v.ActivityID != nil {
		w, err = wire.NewValueString(*(v.ActivityID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 28, Value: w}
		i++
	}
	if v.RequestID != nil {
		w, err = wire.NewValueString(*(v.RequestID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.ScheduleToStartTimeoutSeconds != nil {
		w, err = wire.NewValueI32(*(v.ScheduleToStartTimeoutSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 32, Value: w}
		i++
	}
	if v.ScheduleToCloseTimeoutSeconds != nil {
		w, err = wire.NewValueI32(*(v.ScheduleToCloseTimeoutSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 34, Value: w}
		i++
	}
	if v.StartToCloseTimeoutSeconds != nil {
		w, err = wire.NewValueI32(*(v.StartToCloseTimeoutSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 36, Value: w}
		i++
	}
	if v.HeartbeatTimeoutSeconds != nil {
		w, err = wire.NewValueI32(*(v.HeartbeatTimeoutSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 38, Value: w}
		i++
	}
	if v.CancelRequested != nil {
		w, err = wire.NewValueBool(*(v.CancelRequested)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.CancelRequestID != nil {
		w, err = wire.NewValueI64(*(v.CancelRequestID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 42, Value: w}
		i++
	}
	if v.TimerTaskStatus != nil {
		w, err = wire.NewValueI32(*(v.TimerTaskStatus)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 44, Value: w}
		i++
	}
	if v.Attempt != nil {
		w, err = wire.NewValueI32(*(v.Attempt)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 46, Value: w}
		i++
	}
	if v.TaskList != nil {
		w, err = wire.NewValueString(*(v.TaskList)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 48, Value: w}
		i++
	}
	if v.StartedIdentity != nil {
		w, err = wire.NewValueString(*(v.StartedIdentity)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.HasRetryPolicy != nil {
		w, err = wire.NewValueBool(*(v.HasRetryPolicy)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 52, Value: w}
		i++
	}
	if v.RetryInitialIntervalSeconds != nil {
		w, err = wire.NewValueI32(*(v.RetryInitialIntervalSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 54, Value: w}
		i++
	}
	if v.RetryMaximumIntervalSeconds != nil {
		w, err = wire.NewValueI32(*(v.RetryMaximumIntervalSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 56, Value: w}
		i++
	}
	if v.RetryMaximumAttempts != nil {
		w, err = wire.NewValueI32(*(v.RetryMaximumAttempts)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 58, Value: w}
		i++
	}
	if v.RetryExpirationTimeNanos != nil {
		w, err = wire.NewValueI64(*(v.RetryExpirationTimeNanos)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}
	if v.RetryBackoffCoefficient != nil {
		w, err = wire.NewValueDouble(*(v.RetryBackoffCoefficient)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 62, Value: w}
		i++
	}
	if v.RetryNonRetryableErrors != nil {
		w, err = wire.NewValueList(_List_String_ValueList(v.RetryNonRetryableErrors)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 64, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _List_String_Read(l wire.ValueList) ([]string, error) {
	if l.ValueType() != wire.TBinary {
		return nil, nil
	}

	o := make([]string, 0, l.Size())
	err := l.ForEach(func(x wire.Value) error {
		i, err := x.GetString(), error(nil)
		if err != nil {
			return err
		}
		o = append(o, i)
		return nil
	})
	l.Close()
	return o, err
}

// FromWire deserializes a ActivityInfo struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ActivityInfo struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ActivityInfo
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ActivityInfo) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.Version = &x
				if err != nil {
					return err
				}

			}
		case 12:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduledEventBatchID = &x
				if err != nil {
					return err
				}

			}
		case 14:
			if field.Value.Type() == wire.TBinary {
				v.ScheduledEvent, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 16:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ScheduledEventEncoding = &x
				if err != nil {
					return err
				}

			}
		case 18:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduledTimeNanos = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StartedID = &x
				if err != nil {
					return err
				}

			}
		case 22:
			if field.Value.Type() == wire.TBinary {
				v.StartedEvent, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 24:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.StartedEventEncoding = &x
				if err != nil {
					return err
				}

			}
		case 26:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StartedTimeNanos = &x
				if err != nil {
					return err
				}

			}
		case 28:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ActivityID = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.RequestID = &x
				if err != nil {
					return err
				}

			}
		case 32:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.ScheduleToStartTimeoutSeconds = &x
				if err != nil {
					return err
				}

			}
		case 34:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.ScheduleToCloseTimeoutSeconds = &x
				if err != nil {
					return err
				}

			}
		case 36:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.StartToCloseTimeoutSeconds = &x
				if err != nil {
					return err
				}

			}
		case 38:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.HeartbeatTimeoutSeconds = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBool {
				var x bool
				x, err = field.Value.GetBool(), error(nil)
				v.CancelRequested = &x
				if err != nil {
					return err
				}

			}
		case 42:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.CancelRequestID = &x
				if err != nil {
					return err
				}

			}
		case 44:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.TimerTaskStatus = &x
				if err != nil {
					return err
				}

			}
		case 46:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.Attempt = &x
				if err != nil {
					return err
				}

			}
		case 48:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.TaskList = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.StartedIdentity = &x
				if err != nil {
					return err
				}

			}
		case 52:
			if field.Value.Type() == wire.TBool {
				var x bool
				x, err = field.Value.GetBool(), error(nil)
				v.HasRetryPolicy = &x
				if err != nil {
					return err
				}

			}
		case 54:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.RetryInitialIntervalSeconds = &x
				if err != nil {
					return err
				}

			}
		case 56:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.RetryMaximumIntervalSeconds = &x
				if err != nil {
					return err
				}

			}
		case 58:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.RetryMaximumAttempts = &x
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.RetryExpirationTimeNanos = &x
				if err != nil {
					return err
				}

			}
		case 62:
			if field.Value.Type() == wire.TDouble {
				var x float64
				x, err = field.Value.GetDouble(), error(nil)
				v.RetryBackoffCoefficient = &x
				if err != nil {
					return err
				}

			}
		case 64:
			if field.Value.Type() == wire.TList {
				v.RetryNonRetryableErrors, err = _List_String_Read(field.Value.GetList())
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ActivityInfo
// struct.
func (v *ActivityInfo) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [28]string
	i := 0
	if v.Version != nil {
		fields[i] = fmt.Sprintf("Version: %v", *(v.Version))
		i++
	}
	if v.ScheduledEventBatchID != nil {
		fields[i] = fmt.Sprintf("ScheduledEventBatchID: %v", *(v.ScheduledEventBatchID))
		i++
	}
	if v.ScheduledEvent != nil {
		fields[i] = fmt.Sprintf("ScheduledEvent: %v", v.ScheduledEvent)
		i++
	}
	if v.ScheduledEventEncoding != nil {
		fields[i] = fmt.Sprintf("ScheduledEventEncoding: %v", *(v.ScheduledEventEncoding))
		i++
	}
	if v.ScheduledTimeNanos != nil {
		fields[i] = fmt.Sprintf("ScheduledTimeNanos: %v", *(v.ScheduledTimeNanos))
		i++
	}
	if v.StartedID != nil {
		fields[i] = fmt.Sprintf("StartedID: %v", *(v.StartedID))
		i++
	}
	if v.StartedEvent != nil {
		fields[i] = fmt.Sprintf("StartedEvent: %v", v.StartedEvent)
		i++
	}
	if v.StartedEventEncoding != nil {
		fields[i] = fmt.Sprintf("StartedEventEncoding: %v", *(v.StartedEventEncoding))
		i++
	}
	if v.StartedTimeNanos != nil {
		fields[i] = fmt.Sprintf("StartedTimeNanos: %v", *(v.StartedTimeNanos))
		i++
	}
	if v.ActivityID != nil {
		fields[i] = fmt.Sprintf("ActivityID: %v", *(v.ActivityID))
		i++
	}
	if v.RequestID != nil {
		fields[i] = fmt.Sprintf("RequestID: %v", *(v.RequestID))
		i++
	}
	if v.ScheduleToStartTimeoutSeconds != nil {
		fields[i] = fmt.Sprintf("ScheduleToStartTimeoutSeconds: %v", *(v.ScheduleToStartTimeoutSeconds))
		i++
	}
	if v.ScheduleToCloseTimeoutSeconds != nil {
		fields[i] = fmt.Sprintf("ScheduleToCloseTimeoutSeconds: %v", *(v.ScheduleToCloseTimeoutSeconds))
		i++
	}
	if v.StartToCloseTimeoutSeconds != nil {
		fields[i] = fmt.Sprintf("StartToCloseTimeoutSeconds: %v", *(v.StartToCloseTimeoutSeconds))
		i++
	}
	if v.HeartbeatTimeoutSeconds != nil {
		fields[i] = fmt.Sprintf("HeartbeatTimeoutSeconds: %v", *(v.HeartbeatTimeoutSeconds))
		i++
	}
	if v.CancelRequested != nil {
		fields[i] = fmt.Sprintf("CancelRequested: %v", *(v.CancelRequested))
		i++
	}
	if v.CancelRequestID != nil {
		fields[i] = fmt.Sprintf("CancelRequestID: %v", *(v.CancelRequestID))
		i++
	}
	if v.TimerTaskStatus != nil {
		fields[i] = fmt.Sprintf("TimerTaskStatus: %v", *(v.TimerTaskStatus))
		i++
	}
	if v.Attempt != nil {
		fields[i] = fmt.Sprintf("Attempt: %v", *(v.Attempt))
		i++
	}
	if v.TaskList != nil {
		fields[i] = fmt.Sprintf("TaskList: %v", *(v.TaskList))
		i++
	}
	if v.StartedIdentity != nil {
		fields[i] = fmt.Sprintf("StartedIdentity: %v", *(v.StartedIdentity))
		i++
	}
	if v.HasRetryPolicy != nil {
		fields[i] = fmt.Sprintf("HasRetryPolicy: %v", *(v.HasRetryPolicy))
		i++
	}
	if v.RetryInitialIntervalSeconds != nil {
		fields[i] = fmt.Sprintf("RetryInitialIntervalSeconds: %v", *(v.RetryInitialIntervalSeconds))
		i++
	}
	if v.RetryMaximumIntervalSeconds != nil {
		fields[i] = fmt.Sprintf("RetryMaximumIntervalSeconds: %v", *(v.RetryMaximumIntervalSeconds))
		i++
	}
	if v.RetryMaximumAttempts != nil {
		fields[i] = fmt.Sprintf("RetryMaximumAttempts: %v", *(v.RetryMaximumAttempts))
		i++
	}
	if v.RetryExpirationTimeNanos != nil {
		fields[i] = fmt.Sprintf("RetryExpirationTimeNanos: %v", *(v.RetryExpirationTimeNanos))
		i++
	}
	if v.RetryBackoffCoefficient != nil {
		fields[i] = fmt.Sprintf("RetryBackoffCoefficient: %v", *(v.RetryBackoffCoefficient))
		i++
	}
	if v.RetryNonRetryableErrors != nil {
		fields[i] = fmt.Sprintf("RetryNonRetryableErrors: %v", v.RetryNonRetryableErrors)
		i++
	}

	return fmt.Sprintf("ActivityInfo{%v}", strings.Join(fields[:i], ", "))
}

func _I64_EqualsPtr(lhs, rhs *int64) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return (x == y)
	}
	return lhs == nil && rhs == nil
}

func _String_EqualsPtr(lhs, rhs *string) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return (x == y)
	}
	return lhs == nil && rhs == nil
}

func _I32_EqualsPtr(lhs, rhs *int32) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return (x == y)
	}
	return lhs == nil && rhs == nil
}

func _Bool_EqualsPtr(lhs, rhs *bool) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return (x == y)
	}
	return lhs == nil && rhs == nil
}

func _Double_EqualsPtr(lhs, rhs *float64) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return (x == y)
	}
	return lhs == nil && rhs == nil
}

func _List_String_Equals(lhs, rhs []string) bool {
	if len(lhs) != len(rhs) {
		return false
	}

	for i, lv := range lhs {
		rv := rhs[i]
		if !(lv == rv) {
			return false
		}
	}

	return true
}

// Equals returns true if all the fields of this ActivityInfo match the
// provided ActivityInfo.
//
// This function performs a deep comparison.
func (v *ActivityInfo) Equals(rhs *ActivityInfo) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_I64_EqualsPtr(v.Version, rhs.Version) {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduledEventBatchID, rhs.ScheduledEventBatchID) {
		return false
	}
	if !((v.ScheduledEvent == nil && rhs.ScheduledEvent == nil) || (v.ScheduledEvent != nil && rhs.ScheduledEvent != nil && bytes.Equal(v.ScheduledEvent, rhs.ScheduledEvent))) {
		return false
	}
	if !_String_EqualsPtr(v.ScheduledEventEncoding, rhs.ScheduledEventEncoding) {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduledTimeNanos, rhs.ScheduledTimeNanos) {
		return false
	}
	if !_I64_EqualsPtr(v.StartedID, rhs.StartedID) {
		return false
	}
	if !((v.StartedEvent == nil && rhs.StartedEvent == nil) || (v.StartedEvent != nil && rhs.StartedEvent != nil && bytes.Equal(v.StartedEvent, rhs.StartedEvent))) {
		return false
	}
	if !_String_EqualsPtr(v.StartedEventEncoding, rhs.StartedEventEncoding) {
		return false
	}
	if !_I64_EqualsPtr(v.StartedTimeNanos, rhs.StartedTimeNanos) {
		return false
	}
	if !_String_EqualsPtr(v.ActivityID, rhs.ActivityID) {
		return false
	}
	if !_String_EqualsPtr(v.RequestID, rhs.RequestID) {
		return false
	}
	if !_I32_EqualsPtr(v.ScheduleToStartTimeoutSeconds, rhs.ScheduleToStartTimeoutSeconds) {
		return false
	}
	if !_I32_EqualsPtr(v.ScheduleToCloseTimeoutSeconds, rhs.ScheduleToCloseTimeoutSeconds) {
		return false
	}
	if !_I32_EqualsPtr(v.StartToCloseTimeoutSeconds, rhs.StartToCloseTimeoutSeconds) {
		return false
	}
	if !_I32_EqualsPtr(v.HeartbeatTimeoutSeconds, rhs.HeartbeatTimeoutSeconds) {
		return false
	}
	if !_Bool_EqualsPtr(v.CancelRequested, rhs.CancelRequested) {
		return false
	}
	if !_I64_EqualsPtr(v.CancelRequestID, rhs.CancelRequestID) {
		return false
	}
	if !_I32_EqualsPtr(v.TimerTaskStatus, rhs.TimerTaskStatus) {
		return false
	}
	if !_I32_EqualsPtr(v.Attempt, rhs.Attempt) {
		return false
	}
	if !_String_EqualsPtr(v.TaskList, rhs.TaskList) {
		return false
	}
	if !_String_EqualsPtr(v.StartedIdentity, rhs.StartedIdentity) {
		return false
	}
	if !_Bool_EqualsPtr(v.HasRetryPolicy, rhs.HasRetryPolicy) {
		return false
	}
	if !_I32_EqualsPtr(v.RetryInitialIntervalSeconds, rhs.RetryInitialIntervalSeconds) {
		return false
	}
	if !_I32_EqualsPtr(v.RetryMaximumIntervalSeconds, rhs.RetryMaximumIntervalSeconds) {
		return false
	}
	if !_I32_EqualsPtr(v.RetryMaximumAttempts, rhs.RetryMaximumAttempts) {
		return false
	}
	if !_I64_EqualsPtr(v.RetryExpirationTimeNanos, rhs.RetryExpirationTimeNanos) {
		return false
	}
	if !_Double_EqualsPtr(v.RetryBackoffCoefficient, rhs.RetryBackoffCoefficient) {
		return false
	}
	if !((v.RetryNonRetryableErrors == nil && rhs.RetryNonRetryableErrors == nil) || (v.RetryNonRetryableErrors != nil && rhs.RetryNonRetryableErrors != nil && _List_String_Equals(v.RetryNonRetryableErrors, rhs.RetryNonRetryableErrors))) {
		return false
	}

	return true
}

type _List_String_Zapper []string

// MarshalLogArray implements zapcore.ArrayMarshaler, enabling
// fast logging of _List_String_Zapper.
func (l _List_String_Zapper) MarshalLogArray(enc zapcore.ArrayEncoder) (err error) {
	for _, v := range l {
		enc.AppendString(v)
	}
	return err
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ActivityInfo.
func (v *ActivityInfo) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Version != nil {
		enc.AddInt64("version", *v.Version)
	}
	if v.ScheduledEventBatchID != nil {
		enc.AddInt64("scheduledEventBatchID", *v.ScheduledEventBatchID)
	}
	if v.ScheduledEvent != nil {
		enc.AddString("scheduledEvent", base64.StdEncoding.EncodeToString(v.ScheduledEvent))
	}
	if v.ScheduledEventEncoding != nil {
		enc.AddString("scheduledEventEncoding", *v.ScheduledEventEncoding)
	}
	if v.ScheduledTimeNanos != nil {
		enc.AddInt64("scheduledTimeNanos", *v.ScheduledTimeNanos)
	}
	if v.StartedID != nil {
		enc.AddInt64("startedID", *v.StartedID)
	}
	if v.StartedEvent != nil {
		enc.AddString("startedEvent", base64.StdEncoding.EncodeToString(v.StartedEvent))
	}
	if v.StartedEventEncoding != nil {
		enc.AddString("startedEventEncoding", *v.StartedEventEncoding)
	}
	if v.StartedTimeNanos != nil {
		enc.AddInt64("startedTimeNanos", *v.StartedTimeNanos)
	}
	if v.ActivityID != nil {
		enc.AddString("activityID", *v.ActivityID)
	}
	if v.RequestID != nil {
		enc.AddString("requestID", *v.RequestID)
	}
	if v.ScheduleToStartTimeoutSeconds != nil {
		enc.AddInt32("scheduleToStartTimeoutSeconds", *v.ScheduleToStartTimeoutSeconds)
	}
	if v.ScheduleToCloseTimeoutSeconds != nil {
		enc.AddInt32("scheduleToCloseTimeoutSeconds", *v.ScheduleToCloseTimeoutSeconds)
	}
	if v.StartToCloseTimeoutSeconds != nil {
		enc.AddInt32("startToCloseTimeoutSeconds", *v.StartToCloseTimeoutSeconds)
	}
	if v.HeartbeatTimeoutSeconds != nil {
		enc.AddInt32("heartbeatTimeoutSeconds", *v.HeartbeatTimeoutSeconds)
	}
	if v.CancelRequested != nil {
		enc.AddBool("cancelRequested", *v.CancelRequested)
	}
	if v.CancelRequestID != nil {
		enc.AddInt64("cancelRequestID", *v.CancelRequestID)
	}
	if v.TimerTaskStatus != nil {
		enc.AddInt32("timerTaskStatus", *v.TimerTaskStatus)
	}
	if v.Attempt != nil {
		enc.AddInt32("attempt", *v.Attempt)
	}
	if v.TaskList != nil {
		enc.AddString("taskList", *v.TaskList)
	}
	if v.StartedIdentity != nil {
		enc.AddString("startedIdentity", *v.StartedIdentity)
	}
	if v.HasRetryPolicy != nil {
		enc.AddBool("hasRetryPolicy", *v.HasRetryPolicy)
	}
	if v.RetryInitialIntervalSeconds != nil {
		enc.AddInt32("retryInitialIntervalSeconds", *v.RetryInitialIntervalSeconds)
	}
	if v.RetryMaximumIntervalSeconds != nil {
		enc.AddInt32("retryMaximumIntervalSeconds", *v.RetryMaximumIntervalSeconds)
	}
	if v.RetryMaximumAttempts != nil {
		enc.AddInt32("retryMaximumAttempts", *v.RetryMaximumAttempts)
	}
	if v.RetryExpirationTimeNanos != nil {
		enc.AddInt64("retryExpirationTimeNanos", *v.RetryExpirationTimeNanos)
	}
	if v.RetryBackoffCoefficient != nil {
		enc.AddFloat64("retryBackoffCoefficient", *v.RetryBackoffCoefficient)
	}
	if v.RetryNonRetryableErrors != nil {
		err = multierr.Append(err, enc.AddArray("retryNonRetryableErrors", (_List_String_Zapper)(v.RetryNonRetryableErrors)))
	}
	return err
}

// GetVersion returns the value of Version if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetVersion() (o int64) {
	if v != nil && v.Version != nil {
		return *v.Version
	}

	return
}

// IsSetVersion returns true if Version is not nil.
func (v *ActivityInfo) IsSetVersion() bool {
	return v != nil && v.Version != nil
}

// GetScheduledEventBatchID returns the value of ScheduledEventBatchID if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetScheduledEventBatchID() (o int64) {
	if v != nil && v.ScheduledEventBatchID != nil {
		return *v.ScheduledEventBatchID
	}

	return
}

// IsSetScheduledEventBatchID returns true if ScheduledEventBatchID is not nil.
func (v *ActivityInfo) IsSetScheduledEventBatchID() bool {
	return v != nil && v.ScheduledEventBatchID != nil
}

// GetScheduledEvent returns the value of ScheduledEvent if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetScheduledEvent() (o []byte) {
	if v != nil && v.ScheduledEvent != nil {
		return v.ScheduledEvent
	}

	return
}

// IsSetScheduledEvent returns true if ScheduledEvent is not nil.
func (v *ActivityInfo) IsSetScheduledEvent() bool {
	return v != nil && v.ScheduledEvent != nil
}

// GetScheduledEventEncoding returns the value of ScheduledEventEncoding if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetScheduledEventEncoding() (o string) {
	if v != nil && v.ScheduledEventEncoding != nil {
		return *v.ScheduledEventEncoding
	}

	return
}

// IsSetScheduledEventEncoding returns true if ScheduledEventEncoding is not nil.
func (v *ActivityInfo) IsSetScheduledEventEncoding() bool {
	return v != nil && v.ScheduledEventEncoding != nil
}

// GetScheduledTimeNanos returns the value of ScheduledTimeNanos if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetScheduledTimeNanos() (o int64) {
	if v != nil && v.ScheduledTimeNanos != nil {
		return *v.ScheduledTimeNanos
	}

	return
}

// IsSetScheduledTimeNanos returns true if ScheduledTimeNanos is not nil.
func (v *ActivityInfo) IsSetScheduledTimeNanos() bool {
	return v != nil && v.ScheduledTimeNanos != nil
}

// GetStartedID returns the value of StartedID if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetStartedID() (o int64) {
	if v != nil && v.StartedID != nil {
		return *v.StartedID
	}

	return
}

// IsSetStartedID returns true if StartedID is not nil.
func (v *ActivityInfo) IsSetStartedID() bool {
	return v != nil && v.StartedID != nil
}

// GetStartedEvent returns the value of StartedEvent if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetStartedEvent() (o []byte) {
	if v != nil && v.StartedEvent != nil {
		return v.StartedEvent
	}

	return
}

// IsSetStartedEvent returns true if StartedEvent is not nil.
func (v *ActivityInfo) IsSetStartedEvent() bool {
	return v != nil && v.StartedEvent != nil
}

// GetStartedEventEncoding returns the value of StartedEventEncoding if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetStartedEventEncoding() (o string) {
	if v != nil && v.StartedEventEncoding != nil {
		return *v.StartedEventEncoding
	}

	return
}

// IsSetStartedEventEncoding returns true if StartedEventEncoding is not nil.
func (v *ActivityInfo) IsSetStartedEventEncoding() bool {
	return v != nil && v.StartedEventEncoding != nil
}

// GetStartedTimeNanos returns the value of StartedTimeNanos if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetStartedTimeNanos() (o int64) {
	if v != nil && v.StartedTimeNanos != nil {
		return *v.StartedTimeNanos
	}

	return
}

// IsSetStartedTimeNanos returns true if StartedTimeNanos is not nil.
func (v *ActivityInfo) IsSetStartedTimeNanos() bool {
	return v != nil && v.StartedTimeNanos != nil
}

// GetActivityID returns the value of ActivityID if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetActivityID() (o string) {
	if v != nil && v.ActivityID != nil {
		return *v.ActivityID
	}

	return
}

// IsSetActivityID returns true if ActivityID is not nil.
func (v *ActivityInfo) IsSetActivityID() bool {
	return v != nil && v.ActivityID != nil
}

// GetRequestID returns the value of RequestID if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetRequestID() (o string) {
	if v != nil && v.RequestID != nil {
		return *v.RequestID
	}

	return
}

// IsSetRequestID returns true if RequestID is not nil.
func (v *ActivityInfo) IsSetRequestID() bool {
	return v != nil && v.RequestID != nil
}

// GetScheduleToStartTimeoutSeconds returns the value of ScheduleToStartTimeoutSeconds if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetScheduleToStartTimeoutSeconds() (o int32) {
	if v != nil && v.ScheduleToStartTimeoutSeconds != nil {
		return *v.ScheduleToStartTimeoutSeconds
	}

	return
}

// IsSetScheduleToStartTimeoutSeconds returns true if ScheduleToStartTimeoutSeconds is not nil.
func (v *ActivityInfo) IsSetScheduleToStartTimeoutSeconds() bool {
	return v != nil && v.ScheduleToStartTimeoutSeconds != nil
}

// GetScheduleToCloseTimeoutSeconds returns the value of ScheduleToCloseTimeoutSeconds if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetScheduleToCloseTimeoutSeconds() (o int32) {
	if v != nil && v.ScheduleToCloseTimeoutSeconds != nil {
		return *v.ScheduleToCloseTimeoutSeconds
	}

	return
}

// IsSetScheduleToCloseTimeoutSeconds returns true if ScheduleToCloseTimeoutSeconds is not nil.
func (v *ActivityInfo) IsSetScheduleToCloseTimeoutSeconds() bool {
	return v != nil && v.ScheduleToCloseTimeoutSeconds != nil
}

// GetStartToCloseTimeoutSeconds returns the value of StartToCloseTimeoutSeconds if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetStartToCloseTimeoutSeconds() (o int32) {
	if v != nil && v.StartToCloseTimeoutSeconds != nil {
		return *v.StartToCloseTimeoutSeconds
	}

	return
}

// IsSetStartToCloseTimeoutSeconds returns true if StartToCloseTimeoutSeconds is not nil.
func (v *ActivityInfo) IsSetStartToCloseTimeoutSeconds() bool {
	return v != nil && v.StartToCloseTimeoutSeconds != nil
}

// GetHeartbeatTimeoutSeconds returns the value of HeartbeatTimeoutSeconds if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetHeartbeatTimeoutSeconds() (o int32) {
	if v != nil && v.HeartbeatTimeoutSeconds != nil {
		return *v.HeartbeatTimeoutSeconds
	}

	return
}

// IsSetHeartbeatTimeoutSeconds returns true if HeartbeatTimeoutSeconds is not nil.
func (v *ActivityInfo) IsSetHeartbeatTimeoutSeconds() bool {
	return v != nil && v.HeartbeatTimeoutSeconds != nil
}

// GetCancelRequested returns the value of CancelRequested if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetCancelRequested() (o bool) {
	if v != nil && v.CancelRequested != nil {
		return *v.CancelRequested
	}

	return
}

// IsSetCancelRequested returns true if CancelRequested is not nil.
func (v *ActivityInfo) IsSetCancelRequested() bool {
	return v != nil && v.CancelRequested != nil
}

// GetCancelRequestID returns the value of CancelRequestID if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetCancelRequestID() (o int64) {
	if v != nil && v.CancelRequestID != nil {
		return *v.CancelRequestID
	}

	return
}

// IsSetCancelRequestID returns true if CancelRequestID is not nil.
func (v *ActivityInfo) IsSetCancelRequestID() bool {
	return v != nil && v.CancelRequestID != nil
}

// GetTimerTaskStatus returns the value of TimerTaskStatus if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetTimerTaskStatus() (o int32) {
	if v != nil && v.TimerTaskStatus != nil {
		return *v.TimerTaskStatus
	}

	return
}

// IsSetTimerTaskStatus returns true if TimerTaskStatus is not nil.
func (v *ActivityInfo) IsSetTimerTaskStatus() bool {
	return v != nil && v.TimerTaskStatus != nil
}

// GetAttempt returns the value of Attempt if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetAttempt() (o int32) {
	if v != nil && v.Attempt != nil {
		return *v.Attempt
	}

	return
}

// IsSetAttempt returns true if Attempt is not nil.
func (v *ActivityInfo) IsSetAttempt() bool {
	return v != nil && v.Attempt != nil
}

// GetTaskList returns the value of TaskList if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetTaskList() (o string) {
	if v != nil && v.TaskList != nil {
		return *v.TaskList
	}

	return
}

// IsSetTaskList returns true if TaskList is not nil.
func (v *ActivityInfo) IsSetTaskList() bool {
	return v != nil && v.TaskList != nil
}

// GetStartedIdentity returns the value of StartedIdentity if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetStartedIdentity() (o string) {
	if v != nil && v.StartedIdentity != nil {
		return *v.StartedIdentity
	}

	return
}

// IsSetStartedIdentity returns true if StartedIdentity is not nil.
func (v *ActivityInfo) IsSetStartedIdentity() bool {
	return v != nil && v.StartedIdentity != nil
}

// GetHasRetryPolicy returns the value of HasRetryPolicy if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetHasRetryPolicy() (o bool) {
	if v != nil && v.HasRetryPolicy != nil {
		return *v.HasRetryPolicy
	}

	return
}

// IsSetHasRetryPolicy returns true if HasRetryPolicy is not nil.
func (v *ActivityInfo) IsSetHasRetryPolicy() bool {
	return v != nil && v.HasRetryPolicy != nil
}

// GetRetryInitialIntervalSeconds returns the value of RetryInitialIntervalSeconds if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetRetryInitialIntervalSeconds() (o int32) {
	if v != nil && v.RetryInitialIntervalSeconds != nil {
		return *v.RetryInitialIntervalSeconds
	}

	return
}

// IsSetRetryInitialIntervalSeconds returns true if RetryInitialIntervalSeconds is not nil.
func (v *ActivityInfo) IsSetRetryInitialIntervalSeconds() bool {
	return v != nil && v.RetryInitialIntervalSeconds != nil
}

// GetRetryMaximumIntervalSeconds returns the value of RetryMaximumIntervalSeconds if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetRetryMaximumIntervalSeconds() (o int32) {
	if v != nil && v.RetryMaximumIntervalSeconds != nil {
		return *v.RetryMaximumIntervalSeconds
	}

	return
}

// IsSetRetryMaximumIntervalSeconds returns true if RetryMaximumIntervalSeconds is not nil.
func (v *ActivityInfo) IsSetRetryMaximumIntervalSeconds() bool {
	return v != nil && v.RetryMaximumIntervalSeconds != nil
}

// GetRetryMaximumAttempts returns the value of RetryMaximumAttempts if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetRetryMaximumAttempts() (o int32) {
	if v != nil && v.RetryMaximumAttempts != nil {
		return *v.RetryMaximumAttempts
	}

	return
}

// IsSetRetryMaximumAttempts returns true if RetryMaximumAttempts is not nil.
func (v *ActivityInfo) IsSetRetryMaximumAttempts() bool {
	return v != nil && v.RetryMaximumAttempts != nil
}

// GetRetryExpirationTimeNanos returns the value of RetryExpirationTimeNanos if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetRetryExpirationTimeNanos() (o int64) {
	if v != nil && v.RetryExpirationTimeNanos != nil {
		return *v.RetryExpirationTimeNanos
	}

	return
}

// IsSetRetryExpirationTimeNanos returns true if RetryExpirationTimeNanos is not nil.
func (v *ActivityInfo) IsSetRetryExpirationTimeNanos() bool {
	return v != nil && v.RetryExpirationTimeNanos != nil
}

// GetRetryBackoffCoefficient returns the value of RetryBackoffCoefficient if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetRetryBackoffCoefficient() (o float64) {
	if v != nil && v.RetryBackoffCoefficient != nil {
		return *v.RetryBackoffCoefficient
	}

	return
}

// IsSetRetryBackoffCoefficient returns true if RetryBackoffCoefficient is not nil.
func (v *ActivityInfo) IsSetRetryBackoffCoefficient() bool {
	return v != nil && v.RetryBackoffCoefficient != nil
}

// GetRetryNonRetryableErrors returns the value of RetryNonRetryableErrors if it is set or its
// zero value if it is unset.
func (v *ActivityInfo) GetRetryNonRetryableErrors() (o []string) {
	if v != nil && v.RetryNonRetryableErrors != nil {
		return v.RetryNonRetryableErrors
	}

	return
}

// IsSetRetryNonRetryableErrors returns true if RetryNonRetryableErrors is not nil.
func (v *ActivityInfo) IsSetRetryNonRetryableErrors() bool {
	return v != nil && v.RetryNonRetryableErrors != nil
}

type ChildExecutionInfo struct {
	Version                *int64  `json:"version,omitempty"`
	InitiatedEventBatchID  *int64  `json:"initiatedEventBatchID,omitempty"`
	StartedID              *int64  `json:"startedID,omitempty"`
	InitiatedEvent         []byte  `json:"initiatedEvent,omitempty"`
	InitiatedEventEncoding *string `json:"initiatedEventEncoding,omitempty"`
	StartedWorkflowID      *string `json:"startedWorkflowID,omitempty"`
	StartedRunID           []byte  `json:"startedRunID,omitempty"`
	StartedEvent           []byte  `json:"startedEvent,omitempty"`
	StartedEventEncoding   *string `json:"startedEventEncoding,omitempty"`
	CreateRequestID        *string `json:"createRequestID,omitempty"`
	DomainName             *string `json:"domainName,omitempty"`
	WorkflowTypeName       *string `json:"workflowTypeName,omitempty"`
}

// ToWire translates a ChildExecutionInfo struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ChildExecutionInfo) ToWire() (wire.Value, error) {
	var (
		fields [12]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Version != nil {
		w, err = wire.NewValueI64(*(v.Version)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.InitiatedEventBatchID != nil {
		w, err = wire.NewValueI64(*(v.InitiatedEventBatchID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 12, Value: w}
		i++
	}
	if v.StartedID != nil {
		w, err = wire.NewValueI64(*(v.StartedID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 14, Value: w}
		i++
	}
	if v.InitiatedEvent != nil {
		w, err = wire.NewValueBinary(v.InitiatedEvent), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 16, Value: w}
		i++
	}
	if v.InitiatedEventEncoding != nil {
		w, err = wire.NewValueString(*(v.InitiatedEventEncoding)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 18, Value: w}
		i++
	}
	if v.StartedWorkflowID != nil {
		w, err = wire.NewValueString(*(v.StartedWorkflowID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.StartedRunID != nil {
		w, err = wire.NewValueBinary(v.StartedRunID), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 22, Value: w}
		i++
	}
	if v.StartedEvent != nil {
		w, err = wire.NewValueBinary(v.StartedEvent), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 24, Value: w}
		i++
	}
	if v.StartedEventEncoding != nil {
		w, err = wire.NewValueString(*(v.StartedEventEncoding)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 26, Value: w}
		i++
	}
	if v.CreateRequestID != nil {
		w, err = wire.NewValueString(*(v.CreateRequestID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 28, Value: w}
		i++
	}
	if v.DomainName != nil {
		w, err = wire.NewValueString(*(v.DomainName)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.WorkflowTypeName != nil {
		w, err = wire.NewValueString(*(v.WorkflowTypeName)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 32, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ChildExecutionInfo struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ChildExecutionInfo struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ChildExecutionInfo
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ChildExecutionInfo) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.Version = &x
				if err != nil {
					return err
				}

			}
		case 12:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.InitiatedEventBatchID = &x
				if err != nil {
					return err
				}

			}
		case 14:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StartedID = &x
				if err != nil {
					return err
				}

			}
		case 16:
			if field.Value.Type() == wire.TBinary {
				v.InitiatedEvent, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 18:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.InitiatedEventEncoding = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.StartedWorkflowID = &x
				if err != nil {
					return err
				}

			}
		case 22:
			if field.Value.Type() == wire.TBinary {
				v.StartedRunID, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 24:
			if field.Value.Type() == wire.TBinary {
				v.StartedEvent, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 26:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.StartedEventEncoding = &x
				if err != nil {
					return err
				}

			}
		case 28:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.CreateRequestID = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DomainName = &x
				if err != nil {
					return err
				}

			}
		case 32:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.WorkflowTypeName = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ChildExecutionInfo
// struct.
func (v *ChildExecutionInfo) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [12]string
	i := 0
	if v.Version != nil {
		fields[i] = fmt.Sprintf("Version: %v", *(v.Version))
		i++
	}
	if v.InitiatedEventBatchID != nil {
		fields[i] = fmt.Sprintf("InitiatedEventBatchID: %v", *(v.InitiatedEventBatchID))
		i++
	}
	if v.StartedID != nil {
		fields[i] = fmt.Sprintf("StartedID: %v", *(v.StartedID))
		i++
	}
	if v.InitiatedEvent != nil {
		fields[i] = fmt.Sprintf("InitiatedEvent: %v", v.InitiatedEvent)
		i++
	}
	if v.InitiatedEventEncoding != nil {
		fields[i] = fmt.Sprintf("InitiatedEventEncoding: %v", *(v.InitiatedEventEncoding))
		i++
	}
	if v.StartedWorkflowID != nil {
		fields[i] = fmt.Sprintf("StartedWorkflowID: %v", *(v.StartedWorkflowID))
		i++
	}
	if v.StartedRunID != nil {
		fields[i] = fmt.Sprintf("StartedRunID: %v", v.StartedRunID)
		i++
	}
	if v.StartedEvent != nil {
		fields[i] = fmt.Sprintf("StartedEvent: %v", v.StartedEvent)
		i++
	}
	if v.StartedEventEncoding != nil {
		fields[i] = fmt.Sprintf("StartedEventEncoding: %v", *(v.StartedEventEncoding))
		i++
	}
	if v.CreateRequestID != nil {
		fields[i] = fmt.Sprintf("CreateRequestID: %v", *(v.CreateRequestID))
		i++
	}
	if v.DomainName != nil {
		fields[i] = fmt.Sprintf("DomainName: %v", *(v.DomainName))
		i++
	}
	if v.WorkflowTypeName != nil {
		fields[i] = fmt.Sprintf("WorkflowTypeName: %v", *(v.WorkflowTypeName))
		i++
	}

	return fmt.Sprintf("ChildExecutionInfo{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ChildExecutionInfo match the
// provided ChildExecutionInfo.
//
// This function performs a deep comparison.
func (v *ChildExecutionInfo) Equals(rhs *ChildExecutionInfo) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_I64_EqualsPtr(v.Version, rhs.Version) {
		return false
	}
	if !_I64_EqualsPtr(v.InitiatedEventBatchID, rhs.InitiatedEventBatchID) {
		return false
	}
	if !_I64_EqualsPtr(v.StartedID, rhs.StartedID) {
		return false
	}
	if !((v.InitiatedEvent == nil && rhs.InitiatedEvent == nil) || (v.InitiatedEvent != nil && rhs.InitiatedEvent != nil && bytes.Equal(v.InitiatedEvent, rhs.InitiatedEvent))) {
		return false
	}
	if !_String_EqualsPtr(v.InitiatedEventEncoding, rhs.InitiatedEventEncoding) {
		return false
	}
	if !_String_EqualsPtr(v.StartedWorkflowID, rhs.StartedWorkflowID) {
		return false
	}
	if !((v.StartedRunID == nil && rhs.StartedRunID == nil) || (v.StartedRunID != nil && rhs.StartedRunID != nil && bytes.Equal(v.StartedRunID, rhs.StartedRunID))) {
		return false
	}
	if !((v.StartedEvent == nil && rhs.StartedEvent == nil) || (v.StartedEvent != nil && rhs.StartedEvent != nil && bytes.Equal(v.StartedEvent, rhs.StartedEvent))) {
		return false
	}
	if !_String_EqualsPtr(v.StartedEventEncoding, rhs.StartedEventEncoding) {
		return false
	}
	if !_String_EqualsPtr(v.CreateRequestID, rhs.CreateRequestID) {
		return false
	}
	if !_String_EqualsPtr(v.DomainName, rhs.DomainName) {
		return false
	}
	if !_String_EqualsPtr(v.WorkflowTypeName, rhs.WorkflowTypeName) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ChildExecutionInfo.
func (v *ChildExecutionInfo) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Version != nil {
		enc.AddInt64("version", *v.Version)
	}
	if v.InitiatedEventBatchID != nil {
		enc.AddInt64("initiatedEventBatchID", *v.InitiatedEventBatchID)
	}
	if v.StartedID != nil {
		enc.AddInt64("startedID", *v.StartedID)
	}
	if v.InitiatedEvent != nil {
		enc.AddString("initiatedEvent", base64.StdEncoding.EncodeToString(v.InitiatedEvent))
	}
	if v.InitiatedEventEncoding != nil {
		enc.AddString("initiatedEventEncoding", *v.InitiatedEventEncoding)
	}
	if v.StartedWorkflowID != nil {
		enc.AddString("startedWorkflowID", *v.StartedWorkflowID)
	}
	if v.StartedRunID != nil {
		enc.AddString("startedRunID", base64.StdEncoding.EncodeToString(v.StartedRunID))
	}
	if v.StartedEvent != nil {
		enc.AddString("startedEvent", base64.StdEncoding.EncodeToString(v.StartedEvent))
	}
	if v.StartedEventEncoding != nil {
		enc.AddString("startedEventEncoding", *v.StartedEventEncoding)
	}
	if v.CreateRequestID != nil {
		enc.AddString("createRequestID", *v.CreateRequestID)
	}
	if v.DomainName != nil {
		enc.AddString("domainName", *v.DomainName)
	}
	if v.WorkflowTypeName != nil {
		enc.AddString("workflowTypeName", *v.WorkflowTypeName)
	}
	return err
}

// GetVersion returns the value of Version if it is set or its
// zero value if it is unset.
func (v *ChildExecutionInfo) GetVersion() (o int64) {
	if v != nil && v.Version != nil {
		return *v.Version
	}

	return
}

// IsSetVersion returns true if Version is not nil.
func (v *ChildExecutionInfo) IsSetVersion() bool {
	return v != nil && v.Version != nil
}

// GetInitiatedEventBatchID returns the value of InitiatedEventBatchID if it is set or its
// zero value if it is unset.
func (v *ChildExecutionInfo) GetInitiatedEventBatchID() (o int64) {
	if v != nil && v.InitiatedEventBatchID != nil {
		return *v.InitiatedEventBatchID
	}

	return
}

// IsSetInitiatedEventBatchID returns true if InitiatedEventBatchID is not nil.
func (v *ChildExecutionInfo) IsSetInitiatedEventBatchID() bool {
	return v != nil && v.InitiatedEventBatchID != nil
}

// GetStartedID returns the value of StartedID if it is set or its
// zero value if it is unset.
func (v *ChildExecutionInfo) GetStartedID() (o int64) {
	if v != nil && v.StartedID != nil {
		return *v.StartedID
	}

	return
}

// IsSetStartedID returns true if StartedID is not nil.
func (v *ChildExecutionInfo) IsSetStartedID() bool {
	return v != nil && v.StartedID != nil
}

// GetInitiatedEvent returns the value of InitiatedEvent if it is set or its
// zero value if it is unset.
func (v *ChildExecutionInfo) GetInitiatedEvent() (o []byte) {
	if v != nil && v.InitiatedEvent != nil {
		return v.InitiatedEvent
	}

	return
}

// IsSetInitiatedEvent returns true if InitiatedEvent is not nil.
func (v *ChildExecutionInfo) IsSetInitiatedEvent() bool {
	return v != nil && v.InitiatedEvent != nil
}

// GetInitiatedEventEncoding returns the value of InitiatedEventEncoding if it is set or its
// zero value if it is unset.
func (v *ChildExecutionInfo) GetInitiatedEventEncoding() (o string) {
	if v != nil && v.InitiatedEventEncoding != nil {
		return *v.InitiatedEventEncoding
	}

	return
}

// IsSetInitiatedEventEncoding returns true if InitiatedEventEncoding is not nil.
func (v *ChildExecutionInfo) IsSetInitiatedEventEncoding() bool {
	return v != nil && v.InitiatedEventEncoding != nil
}

// GetStartedWorkflowID returns the value of StartedWorkflowID if it is set or its
// zero value if it is unset.
func (v *ChildExecutionInfo) GetStartedWorkflowID() (o string) {
	if v != nil && v.StartedWorkflowID != nil {
		return *v.StartedWorkflowID
	}

	return
}

// IsSetStartedWorkflowID returns true if StartedWorkflowID is not nil.
func (v *ChildExecutionInfo) IsSetStartedWorkflowID() bool {
	return v != nil && v.StartedWorkflowID != nil
}

// GetStartedRunID returns the value of StartedRunID if it is set or its
// zero value if it is unset.
func (v *ChildExecutionInfo) GetStartedRunID() (o []byte) {
	if v != nil && v.StartedRunID != nil {
		return v.StartedRunID
	}

	return
}

// IsSetStartedRunID returns true if StartedRunID is not nil.
func (v *ChildExecutionInfo) IsSetStartedRunID() bool {
	return v != nil && v.StartedRunID != nil
}

// GetStartedEvent returns the value of StartedEvent if it is set or its
// zero value if it is unset.
func (v *ChildExecutionInfo) GetStartedEvent() (o []byte) {
	if v != nil && v.StartedEvent != nil {
		return v.StartedEvent
	}

	return
}

// IsSetStartedEvent returns true if StartedEvent is not nil.
func (v *ChildExecutionInfo) IsSetStartedEvent() bool {
	return v != nil && v.StartedEvent != nil
}

// GetStartedEventEncoding returns the value of StartedEventEncoding if it is set or its
// zero value if it is unset.
func (v *ChildExecutionInfo) GetStartedEventEncoding() (o string) {
	if v != nil && v.StartedEventEncoding != nil {
		return *v.StartedEventEncoding
	}

	return
}

// IsSetStartedEventEncoding returns true if StartedEventEncoding is not nil.
func (v *ChildExecutionInfo) IsSetStartedEventEncoding() bool {
	return v != nil && v.StartedEventEncoding != nil
}

// GetCreateRequestID returns the value of CreateRequestID if it is set or its
// zero value if it is unset.
func (v *ChildExecutionInfo) GetCreateRequestID() (o string) {
	if v != nil && v.CreateRequestID != nil {
		return *v.CreateRequestID
	}

	return
}

// IsSetCreateRequestID returns true if CreateRequestID is not nil.
func (v *ChildExecutionInfo) IsSetCreateRequestID() bool {
	return v != nil && v.CreateRequestID != nil
}

// GetDomainName returns the value of DomainName if it is set or its
// zero value if it is unset.
func (v *ChildExecutionInfo) GetDomainName() (o string) {
	if v != nil && v.DomainName != nil {
		return *v.DomainName
	}

	return
}

// IsSetDomainName returns true if DomainName is not nil.
func (v *ChildExecutionInfo) IsSetDomainName() bool {
	return v != nil && v.DomainName != nil
}

// GetWorkflowTypeName returns the value of WorkflowTypeName if it is set or its
// zero value if it is unset.
func (v *ChildExecutionInfo) GetWorkflowTypeName() (o string) {
	if v != nil && v.WorkflowTypeName != nil {
		return *v.WorkflowTypeName
	}

	return
}

// IsSetWorkflowTypeName returns true if WorkflowTypeName is not nil.
func (v *ChildExecutionInfo) IsSetWorkflowTypeName() bool {
	return v != nil && v.WorkflowTypeName != nil
}

type DomainInfo struct {
	Name                        *string           `json:"name,omitempty"`
	Description                 *string           `json:"description,omitempty"`
	Owner                       *string           `json:"owner,omitempty"`
	Status                      *int32            `json:"status,omitempty"`
	RetentionDays               *int16            `json:"retentionDays,omitempty"`
	EmitMetric                  *bool             `json:"emitMetric,omitempty"`
	ArchivalBucket              *string           `json:"archivalBucket,omitempty"`
	ArchivalStatus              *int16            `json:"archivalStatus,omitempty"`
	ConfigVersion               *int64            `json:"configVersion,omitempty"`
	NotificationVersion         *int64            `json:"notificationVersion,omitempty"`
	FailoverNotificationVersion *int64            `json:"failoverNotificationVersion,omitempty"`
	FailoverVersion             *int64            `json:"failoverVersion,omitempty"`
	ActiveClusterName           *string           `json:"activeClusterName,omitempty"`
	Clusters                    []string          `json:"clusters,omitempty"`
	Data                        map[string]string `json:"data,omitempty"`
	BadBinaries                 []byte            `json:"badBinaries,omitempty"`
	BadBinariesEncoding         *string           `json:"badBinariesEncoding,omitempty"`
}

type _Map_String_String_MapItemList map[string]string

func (m _Map_String_String_MapItemList) ForEach(f func(wire.MapItem) error) error {
	for k, v := range m {
		kw, err := wire.NewValueString(k), error(nil)
		if err != nil {
			return err
		}

		vw, err := wire.NewValueString(v), error(nil)
		if err != nil {
			return err
		}
		err = f(wire.MapItem{Key: kw, Value: vw})
		if err != nil {
			return err
		}
	}
	return nil
}

func (m _Map_String_String_MapItemList) Size() int {
	return len(m)
}

func (_Map_String_String_MapItemList) KeyType() wire.Type {
	return wire.TBinary
}

func (_Map_String_String_MapItemList) ValueType() wire.Type {
	return wire.TBinary
}

func (_Map_String_String_MapItemList) Close() {}

// ToWire translates a DomainInfo struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *DomainInfo) ToWire() (wire.Value, error) {
	var (
		fields [17]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Name != nil {
		w, err = wire.NewValueString(*(v.Name)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Description != nil {
		w, err = wire.NewValueString(*(v.Description)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 12, Value: w}
		i++
	}
	if v.Owner != nil {
		w, err = wire.NewValueString(*(v.Owner)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 14, Value: w}
		i++
	}
	if v.Status != nil {
		w, err = wire.NewValueI32(*(v.Status)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 16, Value: w}
		i++
	}
	if v.RetentionDays != nil {
		w, err = wire.NewValueI16(*(v.RetentionDays)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 18, Value: w}
		i++
	}
	if v.EmitMetric != nil {
		w, err = wire.NewValueBool(*(v.EmitMetric)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.ArchivalBucket != nil {
		w, err = wire.NewValueString(*(v.ArchivalBucket)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 22, Value: w}
		i++
	}
	if v.ArchivalStatus != nil {
		w, err = wire.NewValueI16(*(v.ArchivalStatus)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 24, Value: w}
		i++
	}
	if v.ConfigVersion != nil {
		w, err = wire.NewValueI64(*(v.ConfigVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 26, Value: w}
		i++
	}
	if v.NotificationVersion != nil {
		w, err = wire.NewValueI64(*(v.NotificationVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 28, Value: w}
		i++
	}
	if v.FailoverNotificationVersion != nil {
		w, err = wire.NewValueI64(*(v.FailoverNotificationVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.FailoverVersion != nil {
		w, err = wire.NewValueI64(*(v.FailoverVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 32, Value: w}
		i++
	}
	if v.ActiveClusterName != nil {
		w, err = wire.NewValueString(*(v.ActiveClusterName)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 34, Value: w}
		i++
	}
	if v.Clusters != nil {
		w, err = wire.NewValueList(_List_String_ValueList(v.Clusters)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 36, Value: w}
		i++
	}
	if v.Data != nil {
		w, err = wire.NewValueMap(_Map_String_String_MapItemList(v.Data)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 38, Value: w}
		i++
	}
	if v.BadBinaries != nil {
		w, err = wire.NewValueBinary(v.BadBinaries), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 39, Value: w}
		i++
	}
	if v.BadBinariesEncoding != nil {
		w, err = wire.NewValueString(*(v.BadBinariesEncoding)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _Map_String_String_Read(m wire.MapItemList) (map[string]string, error) {
	if m.KeyType() != wire.TBinary {
		return nil, nil
	}

	if m.ValueType() != wire.TBinary {
		return nil, nil
	}

	o := make(map[string]string, m.Size())
	err := m.ForEach(func(x wire.MapItem) error {
		k, err := x.Key.GetString(), error(nil)
		if err != nil {
			return err
		}

		v, err := x.Value.GetString(), error(nil)
		if err != nil {
			return err
		}

		o[k] = v
		return nil
	})
	m.Close()
	return o, err
}

// FromWire deserializes a DomainInfo struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a DomainInfo struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v DomainInfo
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *DomainInfo) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Name = &x
				if err != nil {
					return err
				}

			}
		case 12:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Description = &x
				if err != nil {
					return err
				}

			}
		case 14:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Owner = &x
				if err != nil {
					return err
				}

			}
		case 16:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.Status = &x
				if err != nil {
					return err
				}

			}
		case 18:
			if field.Value.Type() == wire.TI16 {
				var x int16
				x, err = field.Value.GetI16(), error(nil)
				v.RetentionDays = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBool {
				var x bool
				x, err = field.Value.GetBool(), error(nil)
				v.EmitMetric = &x
				if err != nil {
					return err
				}

			}
		case 22:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ArchivalBucket = &x
				if err != nil {
					return err
				}

			}
		case 24:
			if field.Value.Type() == wire.TI16 {
				var x int16
				x, err = field.Value.GetI16(), error(nil)
				v.ArchivalStatus = &x
				if err != nil {
					return err
				}

			}
		case 26:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ConfigVersion = &x
				if err != nil {
					return err
				}

			}
		case 28:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.NotificationVersion = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.FailoverNotificationVersion = &x
				if err != nil {
					return err
				}

			}
		case 32:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.FailoverVersion = &x
				if err != nil {
					return err
				}

			}
		case 34:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ActiveClusterName = &x
				if err != nil {
					return err
				}

			}
		case 36:
			if field.Value.Type() == wire.TList {
				v.Clusters, err = _List_String_Read(field.Value.GetList())
				if err != nil {
					return err
				}

			}
		case 38:
			if field.Value.Type() == wire.TMap {
				v.Data, err = _Map_String_String_Read(field.Value.GetMap())
				if err != nil {
					return err
				}

			}
		case 39:
			if field.Value.Type() == wire.TBinary {
				v.BadBinaries, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.BadBinariesEncoding = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a DomainInfo
// struct.
func (v *DomainInfo) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [17]string
	i := 0
	if v.Name != nil {
		fields[i] = fmt.Sprintf("Name: %v", *(v.Name))
		i++
	}
	if v.Description != nil {
		fields[i] = fmt.Sprintf("Description: %v", *(v.Description))
		i++
	}
	if v.Owner != nil {
		fields[i] = fmt.Sprintf("Owner: %v", *(v.Owner))
		i++
	}
	if v.Status != nil {
		fields[i] = fmt.Sprintf("Status: %v", *(v.Status))
		i++
	}
	if v.RetentionDays != nil {
		fields[i] = fmt.Sprintf("RetentionDays: %v", *(v.RetentionDays))
		i++
	}
	if v.EmitMetric != nil {
		fields[i] = fmt.Sprintf("EmitMetric: %v", *(v.EmitMetric))
		i++
	}
	if v.ArchivalBucket != nil {
		fields[i] = fmt.Sprintf("ArchivalBucket: %v", *(v.ArchivalBucket))
		i++
	}
	if v.ArchivalStatus != nil {
		fields[i] = fmt.Sprintf("ArchivalStatus: %v", *(v.ArchivalStatus))
		i++
	}
	if v.ConfigVersion != nil {
		fields[i] = fmt.Sprintf("ConfigVersion: %v", *(v.ConfigVersion))
		i++
	}
	if v.NotificationVersion != nil {
		fields[i] = fmt.Sprintf("NotificationVersion: %v", *(v.NotificationVersion))
		i++
	}
	if v.FailoverNotificationVersion != nil {
		fields[i] = fmt.Sprintf("FailoverNotificationVersion: %v", *(v.FailoverNotificationVersion))
		i++
	}
	if v.FailoverVersion != nil {
		fields[i] = fmt.Sprintf("FailoverVersion: %v", *(v.FailoverVersion))
		i++
	}
	if v.ActiveClusterName != nil {
		fields[i] = fmt.Sprintf("ActiveClusterName: %v", *(v.ActiveClusterName))
		i++
	}
	if v.Clusters != nil {
		fields[i] = fmt.Sprintf("Clusters: %v", v.Clusters)
		i++
	}
	if v.Data != nil {
		fields[i] = fmt.Sprintf("Data: %v", v.Data)
		i++
	}
	if v.BadBinaries != nil {
		fields[i] = fmt.Sprintf("BadBinaries: %v", v.BadBinaries)
		i++
	}
	if v.BadBinariesEncoding != nil {
		fields[i] = fmt.Sprintf("BadBinariesEncoding: %v", *(v.BadBinariesEncoding))
		i++
	}

	return fmt.Sprintf("DomainInfo{%v}", strings.Join(fields[:i], ", "))
}

func _I16_EqualsPtr(lhs, rhs *int16) bool {
	if lhs != nil && rhs != nil {

		x := *lhs
		y := *rhs
		return (x == y)
	}
	return lhs == nil && rhs == nil
}

func _Map_String_String_Equals(lhs, rhs map[string]string) bool {
	if len(lhs) != len(rhs) {
		return false
	}

	for lk, lv := range lhs {
		rv, ok := rhs[lk]
		if !ok {
			return false
		}
		if !(lv == rv) {
			return false
		}
	}
	return true
}

// Equals returns true if all the fields of this DomainInfo match the
// provided DomainInfo.
//
// This function performs a deep comparison.
func (v *DomainInfo) Equals(rhs *DomainInfo) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.Name, rhs.Name) {
		return false
	}
	if !_String_EqualsPtr(v.Description, rhs.Description) {
		return false
	}
	if !_String_EqualsPtr(v.Owner, rhs.Owner) {
		return false
	}
	if !_I32_EqualsPtr(v.Status, rhs.Status) {
		return false
	}
	if !_I16_EqualsPtr(v.RetentionDays, rhs.RetentionDays) {
		return false
	}
	if !_Bool_EqualsPtr(v.EmitMetric, rhs.EmitMetric) {
		return false
	}
	if !_String_EqualsPtr(v.ArchivalBucket, rhs.ArchivalBucket) {
		return false
	}
	if !_I16_EqualsPtr(v.ArchivalStatus, rhs.ArchivalStatus) {
		return false
	}
	if !_I64_EqualsPtr(v.ConfigVersion, rhs.ConfigVersion) {
		return false
	}
	if !_I64_EqualsPtr(v.NotificationVersion, rhs.NotificationVersion) {
		return false
	}
	if !_I64_EqualsPtr(v.FailoverNotificationVersion, rhs.FailoverNotificationVersion) {
		return false
	}
	if !_I64_EqualsPtr(v.FailoverVersion, rhs.FailoverVersion) {
		return false
	}
	if !_String_EqualsPtr(v.ActiveClusterName, rhs.ActiveClusterName) {
		return false
	}
	if !((v.Clusters == nil && rhs.Clusters == nil) || (v.Clusters != nil && rhs.Clusters != nil && _List_String_Equals(v.Clusters, rhs.Clusters))) {
		return false
	}
	if !((v.Data == nil && rhs.Data == nil) || (v.Data != nil && rhs.Data != nil && _Map_String_String_Equals(v.Data, rhs.Data))) {
		return false
	}
	if !((v.BadBinaries == nil && rhs.BadBinaries == nil) || (v.BadBinaries != nil && rhs.BadBinaries != nil && bytes.Equal(v.BadBinaries, rhs.BadBinaries))) {
		return false
	}
	if !_String_EqualsPtr(v.BadBinariesEncoding, rhs.BadBinariesEncoding) {
		return false
	}

	return true
}

type _Map_String_String_Zapper map[string]string

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of _Map_String_String_Zapper.
func (m _Map_String_String_Zapper) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	for k, v := range m {
		enc.AddString((string)(k), v)
	}
	return err
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of DomainInfo.
func (v *DomainInfo) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Name != nil {
		enc.AddString("name", *v.Name)
	}
	if v.Description != nil {
		enc.AddString("description", *v.Description)
	}
	if v.Owner != nil {
		enc.AddString("owner", *v.Owner)
	}
	if v.Status != nil {
		enc.AddInt32("status", *v.Status)
	}
	if v.RetentionDays != nil {
		enc.AddInt16("retentionDays", *v.RetentionDays)
	}
	if v.EmitMetric != nil {
		enc.AddBool("emitMetric", *v.EmitMetric)
	}
	if v.ArchivalBucket != nil {
		enc.AddString("archivalBucket", *v.ArchivalBucket)
	}
	if v.ArchivalStatus != nil {
		enc.AddInt16("archivalStatus", *v.ArchivalStatus)
	}
	if v.ConfigVersion != nil {
		enc.AddInt64("configVersion", *v.ConfigVersion)
	}
	if v.NotificationVersion != nil {
		enc.AddInt64("notificationVersion", *v.NotificationVersion)
	}
	if v.FailoverNotificationVersion != nil {
		enc.AddInt64("failoverNotificationVersion", *v.FailoverNotificationVersion)
	}
	if v.FailoverVersion != nil {
		enc.AddInt64("failoverVersion", *v.FailoverVersion)
	}
	if v.ActiveClusterName != nil {
		enc.AddString("activeClusterName", *v.ActiveClusterName)
	}
	if v.Clusters != nil {
		err = multierr.Append(err, enc.AddArray("clusters", (_List_String_Zapper)(v.Clusters)))
	}
	if v.Data != nil {
		err = multierr.Append(err, enc.AddObject("data", (_Map_String_String_Zapper)(v.Data)))
	}
	if v.BadBinaries != nil {
		enc.AddString("badBinaries", base64.StdEncoding.EncodeToString(v.BadBinaries))
	}
	if v.BadBinariesEncoding != nil {
		enc.AddString("badBinariesEncoding", *v.BadBinariesEncoding)
	}
	return err
}

// GetName returns the value of Name if it is set or its
// zero value if it is unset.
func (v *DomainInfo) GetName() (o string) {
	if v != nil && v.Name != nil {
		return *v.Name
	}

	return
}

// IsSetName returns true if Name is not nil.
func (v *DomainInfo) IsSetName() bool {
	return v != nil && v.Name != nil
}

// GetDescription returns the value of Description if it is set or its
// zero value if it is unset.
func (v *DomainInfo) GetDescription() (o string) {
	if v != nil && v.Description != nil {
		return *v.Description
	}

	return
}

// IsSetDescription returns true if Description is not nil.
func (v *DomainInfo) IsSetDescription() bool {
	return v != nil && v.Description != nil
}

// GetOwner returns the value of Owner if it is set or its
// zero value if it is unset.
func (v *DomainInfo) GetOwner() (o string) {
	if v != nil && v.Owner != nil {
		return *v.Owner
	}

	return
}

// IsSetOwner returns true if Owner is not nil.
func (v *DomainInfo) IsSetOwner() bool {
	return v != nil && v.Owner != nil
}

// GetStatus returns the value of Status if it is set or its
// zero value if it is unset.
func (v *DomainInfo) GetStatus() (o int32) {
	if v != nil && v.Status != nil {
		return *v.Status
	}

	return
}

// IsSetStatus returns true if Status is not nil.
func (v *DomainInfo) IsSetStatus() bool {
	return v != nil && v.Status != nil
}

// GetRetentionDays returns the value of RetentionDays if it is set or its
// zero value if it is unset.
func (v *DomainInfo) GetRetentionDays() (o int16) {
	if v != nil && v.RetentionDays != nil {
		return *v.RetentionDays
	}

	return
}

// IsSetRetentionDays returns true if RetentionDays is not nil.
func (v *DomainInfo) IsSetRetentionDays() bool {
	return v != nil && v.RetentionDays != nil
}

// GetEmitMetric returns the value of EmitMetric if it is set or its
// zero value if it is unset.
func (v *DomainInfo) GetEmitMetric() (o bool) {
	if v != nil && v.EmitMetric != nil {
		return *v.EmitMetric
	}

	return
}

// IsSetEmitMetric returns true if EmitMetric is not nil.
func (v *DomainInfo) IsSetEmitMetric() bool {
	return v != nil && v.EmitMetric != nil
}

// GetArchivalBucket returns the value of ArchivalBucket if it is set or its
// zero value if it is unset.
func (v *DomainInfo) GetArchivalBucket() (o string) {
	if v != nil && v.ArchivalBucket != nil {
		return *v.ArchivalBucket
	}

	return
}

// IsSetArchivalBucket returns true if ArchivalBucket is not nil.
func (v *DomainInfo) IsSetArchivalBucket() bool {
	return v != nil && v.ArchivalBucket != nil
}

// GetArchivalStatus returns the value of ArchivalStatus if it is set or its
// zero value if it is unset.
func (v *DomainInfo) GetArchivalStatus() (o int16) {
	if v != nil && v.ArchivalStatus != nil {
		return *v.ArchivalStatus
	}

	return
}

// IsSetArchivalStatus returns true if ArchivalStatus is not nil.
func (v *DomainInfo) IsSetArchivalStatus() bool {
	return v != nil && v.ArchivalStatus != nil
}

// GetConfigVersion returns the value of ConfigVersion if it is set or its
// zero value if it is unset.
func (v *DomainInfo) GetConfigVersion() (o int64) {
	if v != nil && v.ConfigVersion != nil {
		return *v.ConfigVersion
	}

	return
}

// IsSetConfigVersion returns true if ConfigVersion is not nil.
func (v *DomainInfo) IsSetConfigVersion() bool {
	return v != nil && v.ConfigVersion != nil
}

// GetNotificationVersion returns the value of NotificationVersion if it is set or its
// zero value if it is unset.
func (v *DomainInfo) GetNotificationVersion() (o int64) {
	if v != nil && v.NotificationVersion != nil {
		return *v.NotificationVersion
	}

	return
}

// IsSetNotificationVersion returns true if NotificationVersion is not nil.
func (v *DomainInfo) IsSetNotificationVersion() bool {
	return v != nil && v.NotificationVersion != nil
}

// GetFailoverNotificationVersion returns the value of FailoverNotificationVersion if it is set or its
// zero value if it is unset.
func (v *DomainInfo) GetFailoverNotificationVersion() (o int64) {
	if v != nil && v.FailoverNotificationVersion != nil {
		return *v.FailoverNotificationVersion
	}

	return
}

// IsSetFailoverNotificationVersion returns true if FailoverNotificationVersion is not nil.
func (v *DomainInfo) IsSetFailoverNotificationVersion() bool {
	return v != nil && v.FailoverNotificationVersion != nil
}

// GetFailoverVersion returns the value of FailoverVersion if it is set or its
// zero value if it is unset.
func (v *DomainInfo) GetFailoverVersion() (o int64) {
	if v != nil && v.FailoverVersion != nil {
		return *v.FailoverVersion
	}

	return
}

// IsSetFailoverVersion returns true if FailoverVersion is not nil.
func (v *DomainInfo) IsSetFailoverVersion() bool {
	return v != nil && v.FailoverVersion != nil
}

// GetActiveClusterName returns the value of ActiveClusterName if it is set or its
// zero value if it is unset.
func (v *DomainInfo) GetActiveClusterName() (o string) {
	if v != nil && v.ActiveClusterName != nil {
		return *v.ActiveClusterName
	}

	return
}

// IsSetActiveClusterName returns true if ActiveClusterName is not nil.
func (v *DomainInfo) IsSetActiveClusterName() bool {
	return v != nil && v.ActiveClusterName != nil
}

// GetClusters returns the value of Clusters if it is set or its
// zero value if it is unset.
func (v *DomainInfo) GetClusters() (o []string) {
	if v != nil && v.Clusters != nil {
		return v.Clusters
	}

	return
}

// IsSetClusters returns true if Clusters is not nil.
func (v *DomainInfo) IsSetClusters() bool {
	return v != nil && v.Clusters != nil
}

// GetData returns the value of Data if it is set or its
// zero value if it is unset.
func (v *DomainInfo) GetData() (o map[string]string) {
	if v != nil && v.Data != nil {
		return v.Data
	}

	return
}

// IsSetData returns true if Data is not nil.
func (v *DomainInfo) IsSetData() bool {
	return v != nil && v.Data != nil
}

// GetBadBinaries returns the value of BadBinaries if it is set or its
// zero value if it is unset.
func (v *DomainInfo) GetBadBinaries() (o []byte) {
	if v != nil && v.BadBinaries != nil {
		return v.BadBinaries
	}

	return
}

// IsSetBadBinaries returns true if BadBinaries is not nil.
func (v *DomainInfo) IsSetBadBinaries() bool {
	return v != nil && v.BadBinaries != nil
}

// GetBadBinariesEncoding returns the value of BadBinariesEncoding if it is set or its
// zero value if it is unset.
func (v *DomainInfo) GetBadBinariesEncoding() (o string) {
	if v != nil && v.BadBinariesEncoding != nil {
		return *v.BadBinariesEncoding
	}

	return
}

// IsSetBadBinariesEncoding returns true if BadBinariesEncoding is not nil.
func (v *DomainInfo) IsSetBadBinariesEncoding() bool {
	return v != nil && v.BadBinariesEncoding != nil
}

type HistoryTreeInfo struct {
	CreatedTimeNanos *int64                       `json:"createdTimeNanos,omitempty"`
	Ancestors        []*shared.HistoryBranchRange `json:"ancestors,omitempty"`
	Info             *string                      `json:"info,omitempty"`
}

type _List_HistoryBranchRange_ValueList []*shared.HistoryBranchRange

func (v _List_HistoryBranchRange_ValueList) ForEach(f func(wire.Value) error) error {
	for i, x := range v {
		if x == nil {
			return fmt.Errorf("invalid [%v]: value is nil", i)
		}
		w, err := x.ToWire()
		if err != nil {
			return err
		}
		err = f(w)
		if err != nil {
			return err
		}
	}
	return nil
}

func (v _List_HistoryBranchRange_ValueList) Size() int {
	return len(v)
}

func (_List_HistoryBranchRange_ValueList) ValueType() wire.Type {
	return wire.TStruct
}

func (_List_HistoryBranchRange_ValueList) Close() {}

// ToWire translates a HistoryTreeInfo struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *HistoryTreeInfo) ToWire() (wire.Value, error) {
	var (
		fields [3]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.CreatedTimeNanos != nil {
		w, err = wire.NewValueI64(*(v.CreatedTimeNanos)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.Ancestors != nil {
		w, err = wire.NewValueList(_List_HistoryBranchRange_ValueList(v.Ancestors)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 12, Value: w}
		i++
	}
	if v.Info != nil {
		w, err = wire.NewValueString(*(v.Info)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 14, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _HistoryBranchRange_Read(w wire.Value) (*shared.HistoryBranchRange, error) {
	var v shared.HistoryBranchRange
	err := v.FromWire(w)
	return &v, err
}

func _List_HistoryBranchRange_Read(l wire.ValueList) ([]*shared.HistoryBranchRange, error) {
	if l.ValueType() != wire.TStruct {
		return nil, nil
	}

	o := make([]*shared.HistoryBranchRange, 0, l.Size())
	err := l.ForEach(func(x wire.Value) error {
		i, err := _HistoryBranchRange_Read(x)
		if err != nil {
			return err
		}
		o = append(o, i)
		return nil
	})
	l.Close()
	return o, err
}

// FromWire deserializes a HistoryTreeInfo struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a HistoryTreeInfo struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v HistoryTreeInfo
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *HistoryTreeInfo) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.CreatedTimeNanos = &x
				if err != nil {
					return err
				}

			}
		case 12:
			if field.Value.Type() == wire.TList {
				v.Ancestors, err = _List_HistoryBranchRange_Read(field.Value.GetList())
				if err != nil {
					return err
				}

			}
		case 14:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Info = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a HistoryTreeInfo
// struct.
func (v *HistoryTreeInfo) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [3]string
	i := 0
	if v.CreatedTimeNanos != nil {
		fields[i] = fmt.Sprintf("CreatedTimeNanos: %v", *(v.CreatedTimeNanos))
		i++
	}
	if v.Ancestors != nil {
		fields[i] = fmt.Sprintf("Ancestors: %v", v.Ancestors)
		i++
	}
	if v.Info != nil {
		fields[i] = fmt.Sprintf("Info: %v", *(v.Info))
		i++
	}

	return fmt.Sprintf("HistoryTreeInfo{%v}", strings.Join(fields[:i], ", "))
}

func _List_HistoryBranchRange_Equals(lhs, rhs []*shared.HistoryBranchRange) bool {
	if len(lhs) != len(rhs) {
		return false
	}

	for i, lv := range lhs {
		rv := rhs[i]
		if !lv.Equals(rv) {
			return false
		}
	}

	return true
}

// Equals returns true if all the fields of this HistoryTreeInfo match the
// provided HistoryTreeInfo.
//
// This function performs a deep comparison.
func (v *HistoryTreeInfo) Equals(rhs *HistoryTreeInfo) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_I64_EqualsPtr(v.CreatedTimeNanos, rhs.CreatedTimeNanos) {
		return false
	}
	if !((v.Ancestors == nil && rhs.Ancestors == nil) || (v.Ancestors != nil && rhs.Ancestors != nil && _List_HistoryBranchRange_Equals(v.Ancestors, rhs.Ancestors))) {
		return false
	}
	if !_String_EqualsPtr(v.Info, rhs.Info) {
		return false
	}

	return true
}

type _List_HistoryBranchRange_Zapper []*shared.HistoryBranchRange

// MarshalLogArray implements zapcore.ArrayMarshaler, enabling
// fast logging of _List_HistoryBranchRange_Zapper.
func (l _List_HistoryBranchRange_Zapper) MarshalLogArray(enc zapcore.ArrayEncoder) (err error) {
	for _, v := range l {
		err = multierr.Append(err, enc.AppendObject(v))
	}
	return err
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of HistoryTreeInfo.
func (v *HistoryTreeInfo) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.CreatedTimeNanos != nil {
		enc.AddInt64("createdTimeNanos", *v.CreatedTimeNanos)
	}
	if v.Ancestors != nil {
		err = multierr.Append(err, enc.AddArray("ancestors", (_List_HistoryBranchRange_Zapper)(v.Ancestors)))
	}
	if v.Info != nil {
		enc.AddString("info", *v.Info)
	}
	return err
}

// GetCreatedTimeNanos returns the value of CreatedTimeNanos if it is set or its
// zero value if it is unset.
func (v *HistoryTreeInfo) GetCreatedTimeNanos() (o int64) {
	if v != nil && v.CreatedTimeNanos != nil {
		return *v.CreatedTimeNanos
	}

	return
}

// IsSetCreatedTimeNanos returns true if CreatedTimeNanos is not nil.
func (v *HistoryTreeInfo) IsSetCreatedTimeNanos() bool {
	return v != nil && v.CreatedTimeNanos != nil
}

// GetAncestors returns the value of Ancestors if it is set or its
// zero value if it is unset.
func (v *HistoryTreeInfo) GetAncestors() (o []*shared.HistoryBranchRange) {
	if v != nil && v.Ancestors != nil {
		return v.Ancestors
	}

	return
}

// IsSetAncestors returns true if Ancestors is not nil.
func (v *HistoryTreeInfo) IsSetAncestors() bool {
	return v != nil && v.Ancestors != nil
}

// GetInfo returns the value of Info if it is set or its
// zero value if it is unset.
func (v *HistoryTreeInfo) GetInfo() (o string) {
	if v != nil && v.Info != nil {
		return *v.Info
	}

	return
}

// IsSetInfo returns true if Info is not nil.
func (v *HistoryTreeInfo) IsSetInfo() bool {
	return v != nil && v.Info != nil
}

type ReplicationInfo struct {
	Version     *int64 `json:"version,omitempty"`
	LastEventID *int64 `json:"lastEventID,omitempty"`
}

// ToWire translates a ReplicationInfo struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ReplicationInfo) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Version != nil {
		w, err = wire.NewValueI64(*(v.Version)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.LastEventID != nil {
		w, err = wire.NewValueI64(*(v.LastEventID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 12, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a ReplicationInfo struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ReplicationInfo struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ReplicationInfo
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ReplicationInfo) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.Version = &x
				if err != nil {
					return err
				}

			}
		case 12:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.LastEventID = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ReplicationInfo
// struct.
func (v *ReplicationInfo) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.Version != nil {
		fields[i] = fmt.Sprintf("Version: %v", *(v.Version))
		i++
	}
	if v.LastEventID != nil {
		fields[i] = fmt.Sprintf("LastEventID: %v", *(v.LastEventID))
		i++
	}

	return fmt.Sprintf("ReplicationInfo{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this ReplicationInfo match the
// provided ReplicationInfo.
//
// This function performs a deep comparison.
func (v *ReplicationInfo) Equals(rhs *ReplicationInfo) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_I64_EqualsPtr(v.Version, rhs.Version) {
		return false
	}
	if !_I64_EqualsPtr(v.LastEventID, rhs.LastEventID) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ReplicationInfo.
func (v *ReplicationInfo) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Version != nil {
		enc.AddInt64("version", *v.Version)
	}
	if v.LastEventID != nil {
		enc.AddInt64("lastEventID", *v.LastEventID)
	}
	return err
}

// GetVersion returns the value of Version if it is set or its
// zero value if it is unset.
func (v *ReplicationInfo) GetVersion() (o int64) {
	if v != nil && v.Version != nil {
		return *v.Version
	}

	return
}

// IsSetVersion returns true if Version is not nil.
func (v *ReplicationInfo) IsSetVersion() bool {
	return v != nil && v.Version != nil
}

// GetLastEventID returns the value of LastEventID if it is set or its
// zero value if it is unset.
func (v *ReplicationInfo) GetLastEventID() (o int64) {
	if v != nil && v.LastEventID != nil {
		return *v.LastEventID
	}

	return
}

// IsSetLastEventID returns true if LastEventID is not nil.
func (v *ReplicationInfo) IsSetLastEventID() bool {
	return v != nil && v.LastEventID != nil
}

type ReplicationTaskInfo struct {
	DomainID                []byte                      `json:"domainID,omitempty"`
	WorkflowID              *string                     `json:"workflowID,omitempty"`
	RunID                   []byte                      `json:"runID,omitempty"`
	TaskType                *int16                      `json:"taskType,omitempty"`
	Version                 *int64                      `json:"version,omitempty"`
	FirstEventID            *int64                      `json:"firstEventID,omitempty"`
	NextEventID             *int64                      `json:"nextEventID,omitempty"`
	ScheduledID             *int64                      `json:"scheduledID,omitempty"`
	EventStoreVersion       *int32                      `json:"eventStoreVersion,omitempty"`
	NewRunEventStoreVersion *int32                      `json:"newRunEventStoreVersion,omitempty"`
	BranchToken             []byte                      `json:"branch_token,omitempty"`
	LastReplicationInfo     map[string]*ReplicationInfo `json:"lastReplicationInfo,omitempty"`
	NewRunBranchToken       []byte                      `json:"newRunBranchToken,omitempty"`
	ResetWorkflow           *bool                       `json:"resetWorkflow,omitempty"`
}

type _Map_String_ReplicationInfo_MapItemList map[string]*ReplicationInfo

func (m _Map_String_ReplicationInfo_MapItemList) ForEach(f func(wire.MapItem) error) error {
	for k, v := range m {
		if v == nil {
			return fmt.Errorf("invalid [%v]: value is nil", k)
		}
		kw, err := wire.NewValueString(k), error(nil)
		if err != nil {
			return err
		}

		vw, err := v.ToWire()
		if err != nil {
			return err
		}
		err = f(wire.MapItem{Key: kw, Value: vw})
		if err != nil {
			return err
		}
	}
	return nil
}

func (m _Map_String_ReplicationInfo_MapItemList) Size() int {
	return len(m)
}

func (_Map_String_ReplicationInfo_MapItemList) KeyType() wire.Type {
	return wire.TBinary
}

func (_Map_String_ReplicationInfo_MapItemList) ValueType() wire.Type {
	return wire.TStruct
}

func (_Map_String_ReplicationInfo_MapItemList) Close() {}

// ToWire translates a ReplicationTaskInfo struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ReplicationTaskInfo) ToWire() (wire.Value, error) {
	var (
		fields [14]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainID != nil {
		w, err = wire.NewValueBinary(v.DomainID), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.WorkflowID != nil {
		w, err = wire.NewValueString(*(v.WorkflowID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 12, Value: w}
		i++
	}
	if v.RunID != nil {
		w, err = wire.NewValueBinary(v.RunID), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 14, Value: w}
		i++
	}
	if v.TaskType != nil {
		w, err = wire.NewValueI16(*(v.TaskType)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 16, Value: w}
		i++
	}
	if v.Version != nil {
		w, err = wire.NewValueI64(*(v.Version)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 18, Value: w}
		i++
	}
	if v.FirstEventID != nil {
		w, err = wire.NewValueI64(*(v.FirstEventID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.NextEventID != nil {
		w, err = wire.NewValueI64(*(v.NextEventID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 22, Value: w}
		i++
	}
	if v.ScheduledID != nil {
		w, err = wire.NewValueI64(*(v.ScheduledID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 24, Value: w}
		i++
	}
	if v.EventStoreVersion != nil {
		w, err = wire.NewValueI32(*(v.EventStoreVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 26, Value: w}
		i++
	}
	if v.NewRunEventStoreVersion != nil {
		w, err = wire.NewValueI32(*(v.NewRunEventStoreVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 28, Value: w}
		i++
	}
	if v.BranchToken != nil {
		w, err = wire.NewValueBinary(v.BranchToken), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.LastReplicationInfo != nil {
		w, err = wire.NewValueMap(_Map_String_ReplicationInfo_MapItemList(v.LastReplicationInfo)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 32, Value: w}
		i++
	}
	if v.NewRunBranchToken != nil {
		w, err = wire.NewValueBinary(v.NewRunBranchToken), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 34, Value: w}
		i++
	}
	if v.ResetWorkflow != nil {
		w, err = wire.NewValueBool(*(v.ResetWorkflow)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 36, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _ReplicationInfo_Read(w wire.Value) (*ReplicationInfo, error) {
	var v ReplicationInfo
	err := v.FromWire(w)
	return &v, err
}

func _Map_String_ReplicationInfo_Read(m wire.MapItemList) (map[string]*ReplicationInfo, error) {
	if m.KeyType() != wire.TBinary {
		return nil, nil
	}

	if m.ValueType() != wire.TStruct {
		return nil, nil
	}

	o := make(map[string]*ReplicationInfo, m.Size())
	err := m.ForEach(func(x wire.MapItem) error {
		k, err := x.Key.GetString(), error(nil)
		if err != nil {
			return err
		}

		v, err := _ReplicationInfo_Read(x.Value)
		if err != nil {
			return err
		}

		o[k] = v
		return nil
	})
	m.Close()
	return o, err
}

// FromWire deserializes a ReplicationTaskInfo struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ReplicationTaskInfo struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ReplicationTaskInfo
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ReplicationTaskInfo) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				v.DomainID, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 12:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.WorkflowID = &x
				if err != nil {
					return err
				}

			}
		case 14:
			if field.Value.Type() == wire.TBinary {
				v.RunID, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 16:
			if field.Value.Type() == wire.TI16 {
				var x int16
				x, err = field.Value.GetI16(), error(nil)
				v.TaskType = &x
				if err != nil {
					return err
				}

			}
		case 18:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.Version = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.FirstEventID = &x
				if err != nil {
					return err
				}

			}
		case 22:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.NextEventID = &x
				if err != nil {
					return err
				}

			}
		case 24:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduledID = &x
				if err != nil {
					return err
				}

			}
		case 26:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.EventStoreVersion = &x
				if err != nil {
					return err
				}

			}
		case 28:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.NewRunEventStoreVersion = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TBinary {
				v.BranchToken, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 32:
			if field.Value.Type() == wire.TMap {
				v.LastReplicationInfo, err = _Map_String_ReplicationInfo_Read(field.Value.GetMap())
				if err != nil {
					return err
				}

			}
		case 34:
			if field.Value.Type() == wire.TBinary {
				v.NewRunBranchToken, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 36:
			if field.Value.Type() == wire.TBool {
				var x bool
				x, err = field.Value.GetBool(), error(nil)
				v.ResetWorkflow = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ReplicationTaskInfo
// struct.
func (v *ReplicationTaskInfo) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [14]string
	i := 0
	if v.DomainID != nil {
		fields[i] = fmt.Sprintf("DomainID: %v", v.DomainID)
		i++
	}
	if v.WorkflowID != nil {
		fields[i] = fmt.Sprintf("WorkflowID: %v", *(v.WorkflowID))
		i++
	}
	if v.RunID != nil {
		fields[i] = fmt.Sprintf("RunID: %v", v.RunID)
		i++
	}
	if v.TaskType != nil {
		fields[i] = fmt.Sprintf("TaskType: %v", *(v.TaskType))
		i++
	}
	if v.Version != nil {
		fields[i] = fmt.Sprintf("Version: %v", *(v.Version))
		i++
	}
	if v.FirstEventID != nil {
		fields[i] = fmt.Sprintf("FirstEventID: %v", *(v.FirstEventID))
		i++
	}
	if v.NextEventID != nil {
		fields[i] = fmt.Sprintf("NextEventID: %v", *(v.NextEventID))
		i++
	}
	if v.ScheduledID != nil {
		fields[i] = fmt.Sprintf("ScheduledID: %v", *(v.ScheduledID))
		i++
	}
	if v.EventStoreVersion != nil {
		fields[i] = fmt.Sprintf("EventStoreVersion: %v", *(v.EventStoreVersion))
		i++
	}
	if v.NewRunEventStoreVersion != nil {
		fields[i] = fmt.Sprintf("NewRunEventStoreVersion: %v", *(v.NewRunEventStoreVersion))
		i++
	}
	if v.BranchToken != nil {
		fields[i] = fmt.Sprintf("BranchToken: %v", v.BranchToken)
		i++
	}
	if v.LastReplicationInfo != nil {
		fields[i] = fmt.Sprintf("LastReplicationInfo: %v", v.LastReplicationInfo)
		i++
	}
	if v.NewRunBranchToken != nil {
		fields[i] = fmt.Sprintf("NewRunBranchToken: %v", v.NewRunBranchToken)
		i++
	}
	if v.ResetWorkflow != nil {
		fields[i] = fmt.Sprintf("ResetWorkflow: %v", *(v.ResetWorkflow))
		i++
	}

	return fmt.Sprintf("ReplicationTaskInfo{%v}", strings.Join(fields[:i], ", "))
}

func _Map_String_ReplicationInfo_Equals(lhs, rhs map[string]*ReplicationInfo) bool {
	if len(lhs) != len(rhs) {
		return false
	}

	for lk, lv := range lhs {
		rv, ok := rhs[lk]
		if !ok {
			return false
		}
		if !lv.Equals(rv) {
			return false
		}
	}
	return true
}

// Equals returns true if all the fields of this ReplicationTaskInfo match the
// provided ReplicationTaskInfo.
//
// This function performs a deep comparison.
func (v *ReplicationTaskInfo) Equals(rhs *ReplicationTaskInfo) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.DomainID == nil && rhs.DomainID == nil) || (v.DomainID != nil && rhs.DomainID != nil && bytes.Equal(v.DomainID, rhs.DomainID))) {
		return false
	}
	if !_String_EqualsPtr(v.WorkflowID, rhs.WorkflowID) {
		return false
	}
	if !((v.RunID == nil && rhs.RunID == nil) || (v.RunID != nil && rhs.RunID != nil && bytes.Equal(v.RunID, rhs.RunID))) {
		return false
	}
	if !_I16_EqualsPtr(v.TaskType, rhs.TaskType) {
		return false
	}
	if !_I64_EqualsPtr(v.Version, rhs.Version) {
		return false
	}
	if !_I64_EqualsPtr(v.FirstEventID, rhs.FirstEventID) {
		return false
	}
	if !_I64_EqualsPtr(v.NextEventID, rhs.NextEventID) {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduledID, rhs.ScheduledID) {
		return false
	}
	if !_I32_EqualsPtr(v.EventStoreVersion, rhs.EventStoreVersion) {
		return false
	}
	if !_I32_EqualsPtr(v.NewRunEventStoreVersion, rhs.NewRunEventStoreVersion) {
		return false
	}
	if !((v.BranchToken == nil && rhs.BranchToken == nil) || (v.BranchToken != nil && rhs.BranchToken != nil && bytes.Equal(v.BranchToken, rhs.BranchToken))) {
		return false
	}
	if !((v.LastReplicationInfo == nil && rhs.LastReplicationInfo == nil) || (v.LastReplicationInfo != nil && rhs.LastReplicationInfo != nil && _Map_String_ReplicationInfo_Equals(v.LastReplicationInfo, rhs.LastReplicationInfo))) {
		return false
	}
	if !((v.NewRunBranchToken == nil && rhs.NewRunBranchToken == nil) || (v.NewRunBranchToken != nil && rhs.NewRunBranchToken != nil && bytes.Equal(v.NewRunBranchToken, rhs.NewRunBranchToken))) {
		return false
	}
	if !_Bool_EqualsPtr(v.ResetWorkflow, rhs.ResetWorkflow) {
		return false
	}

	return true
}

type _Map_String_ReplicationInfo_Zapper map[string]*ReplicationInfo

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of _Map_String_ReplicationInfo_Zapper.
func (m _Map_String_ReplicationInfo_Zapper) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	for k, v := range m {
		err = multierr.Append(err, enc.AddObject((string)(k), v))
	}
	return err
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ReplicationTaskInfo.
func (v *ReplicationTaskInfo) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainID != nil {
		enc.AddString("domainID", base64.StdEncoding.EncodeToString(v.DomainID))
	}
	if v.WorkflowID != nil {
		enc.AddString("workflowID", *v.WorkflowID)
	}
	if v.RunID != nil {
		enc.AddString("runID", base64.StdEncoding.EncodeToString(v.RunID))
	}
	if v.TaskType != nil {
		enc.AddInt16("taskType", *v.TaskType)
	}
	if v.Version != nil {
		enc.AddInt64("version", *v.Version)
	}
	if v.FirstEventID != nil {
		enc.AddInt64("firstEventID", *v.FirstEventID)
	}
	if v.NextEventID != nil {
		enc.AddInt64("nextEventID", *v.NextEventID)
	}
	if v.ScheduledID != nil {
		enc.AddInt64("scheduledID", *v.ScheduledID)
	}
	if v.EventStoreVersion != nil {
		enc.AddInt32("eventStoreVersion", *v.EventStoreVersion)
	}
	if v.NewRunEventStoreVersion != nil {
		enc.AddInt32("newRunEventStoreVersion", *v.NewRunEventStoreVersion)
	}
	if v.BranchToken != nil {
		enc.AddString("branch_token", base64.StdEncoding.EncodeToString(v.BranchToken))
	}
	if v.LastReplicationInfo != nil {
		err = multierr.Append(err, enc.AddObject("lastReplicationInfo", (_Map_String_ReplicationInfo_Zapper)(v.LastReplicationInfo)))
	}
	if v.NewRunBranchToken != nil {
		enc.AddString("newRunBranchToken", base64.StdEncoding.EncodeToString(v.NewRunBranchToken))
	}
	if v.ResetWorkflow != nil {
		enc.AddBool("resetWorkflow", *v.ResetWorkflow)
	}
	return err
}

// GetDomainID returns the value of DomainID if it is set or its
// zero value if it is unset.
func (v *ReplicationTaskInfo) GetDomainID() (o []byte) {
	if v != nil && v.DomainID != nil {
		return v.DomainID
	}

	return
}

// IsSetDomainID returns true if DomainID is not nil.
func (v *ReplicationTaskInfo) IsSetDomainID() bool {
	return v != nil && v.DomainID != nil
}

// GetWorkflowID returns the value of WorkflowID if it is set or its
// zero value if it is unset.
func (v *ReplicationTaskInfo) GetWorkflowID() (o string) {
	if v != nil && v.WorkflowID != nil {
		return *v.WorkflowID
	}

	return
}

// IsSetWorkflowID returns true if WorkflowID is not nil.
func (v *ReplicationTaskInfo) IsSetWorkflowID() bool {
	return v != nil && v.WorkflowID != nil
}

// GetRunID returns the value of RunID if it is set or its
// zero value if it is unset.
func (v *ReplicationTaskInfo) GetRunID() (o []byte) {
	if v != nil && v.RunID != nil {
		return v.RunID
	}

	return
}

// IsSetRunID returns true if RunID is not nil.
func (v *ReplicationTaskInfo) IsSetRunID() bool {
	return v != nil && v.RunID != nil
}

// GetTaskType returns the value of TaskType if it is set or its
// zero value if it is unset.
func (v *ReplicationTaskInfo) GetTaskType() (o int16) {
	if v != nil && v.TaskType != nil {
		return *v.TaskType
	}

	return
}

// IsSetTaskType returns true if TaskType is not nil.
func (v *ReplicationTaskInfo) IsSetTaskType() bool {
	return v != nil && v.TaskType != nil
}

// GetVersion returns the value of Version if it is set or its
// zero value if it is unset.
func (v *ReplicationTaskInfo) GetVersion() (o int64) {
	if v != nil && v.Version != nil {
		return *v.Version
	}

	return
}

// IsSetVersion returns true if Version is not nil.
func (v *ReplicationTaskInfo) IsSetVersion() bool {
	return v != nil && v.Version != nil
}

// GetFirstEventID returns the value of FirstEventID if it is set or its
// zero value if it is unset.
func (v *ReplicationTaskInfo) GetFirstEventID() (o int64) {
	if v != nil && v.FirstEventID != nil {
		return *v.FirstEventID
	}

	return
}

// IsSetFirstEventID returns true if FirstEventID is not nil.
func (v *ReplicationTaskInfo) IsSetFirstEventID() bool {
	return v != nil && v.FirstEventID != nil
}

// GetNextEventID returns the value of NextEventID if it is set or its
// zero value if it is unset.
func (v *ReplicationTaskInfo) GetNextEventID() (o int64) {
	if v != nil && v.NextEventID != nil {
		return *v.NextEventID
	}

	return
}

// IsSetNextEventID returns true if NextEventID is not nil.
func (v *ReplicationTaskInfo) IsSetNextEventID() bool {
	return v != nil && v.NextEventID != nil
}

// GetScheduledID returns the value of ScheduledID if it is set or its
// zero value if it is unset.
func (v *ReplicationTaskInfo) GetScheduledID() (o int64) {
	if v != nil && v.ScheduledID != nil {
		return *v.ScheduledID
	}

	return
}

// IsSetScheduledID returns true if ScheduledID is not nil.
func (v *ReplicationTaskInfo) IsSetScheduledID() bool {
	return v != nil && v.ScheduledID != nil
}

// GetEventStoreVersion returns the value of EventStoreVersion if it is set or its
// zero value if it is unset.
func (v *ReplicationTaskInfo) GetEventStoreVersion() (o int32) {
	if v != nil && v.EventStoreVersion != nil {
		return *v.EventStoreVersion
	}

	return
}

// IsSetEventStoreVersion returns true if EventStoreVersion is not nil.
func (v *ReplicationTaskInfo) IsSetEventStoreVersion() bool {
	return v != nil && v.EventStoreVersion != nil
}

// GetNewRunEventStoreVersion returns the value of NewRunEventStoreVersion if it is set or its
// zero value if it is unset.
func (v *ReplicationTaskInfo) GetNewRunEventStoreVersion() (o int32) {
	if v != nil && v.NewRunEventStoreVersion != nil {
		return *v.NewRunEventStoreVersion
	}

	return
}

// IsSetNewRunEventStoreVersion returns true if NewRunEventStoreVersion is not nil.
func (v *ReplicationTaskInfo) IsSetNewRunEventStoreVersion() bool {
	return v != nil && v.NewRunEventStoreVersion != nil
}

// GetBranchToken returns the value of BranchToken if it is set or its
// zero value if it is unset.
func (v *ReplicationTaskInfo) GetBranchToken() (o []byte) {
	if v != nil && v.BranchToken != nil {
		return v.BranchToken
	}

	return
}

// IsSetBranchToken returns true if BranchToken is not nil.
func (v *ReplicationTaskInfo) IsSetBranchToken() bool {
	return v != nil && v.BranchToken != nil
}

// GetLastReplicationInfo returns the value of LastReplicationInfo if it is set or its
// zero value if it is unset.
func (v *ReplicationTaskInfo) GetLastReplicationInfo() (o map[string]*ReplicationInfo) {
	if v != nil && v.LastReplicationInfo != nil {
		return v.LastReplicationInfo
	}

	return
}

// IsSetLastReplicationInfo returns true if LastReplicationInfo is not nil.
func (v *ReplicationTaskInfo) IsSetLastReplicationInfo() bool {
	return v != nil && v.LastReplicationInfo != nil
}

// GetNewRunBranchToken returns the value of NewRunBranchToken if it is set or its
// zero value if it is unset.
func (v *ReplicationTaskInfo) GetNewRunBranchToken() (o []byte) {
	if v != nil && v.NewRunBranchToken != nil {
		return v.NewRunBranchToken
	}

	return
}

// IsSetNewRunBranchToken returns true if NewRunBranchToken is not nil.
func (v *ReplicationTaskInfo) IsSetNewRunBranchToken() bool {
	return v != nil && v.NewRunBranchToken != nil
}

// GetResetWorkflow returns the value of ResetWorkflow if it is set or its
// zero value if it is unset.
func (v *ReplicationTaskInfo) GetResetWorkflow() (o bool) {
	if v != nil && v.ResetWorkflow != nil {
		return *v.ResetWorkflow
	}

	return
}

// IsSetResetWorkflow returns true if ResetWorkflow is not nil.
func (v *ReplicationTaskInfo) IsSetResetWorkflow() bool {
	return v != nil && v.ResetWorkflow != nil
}

type RequestCancelInfo struct {
	Version         *int64  `json:"version,omitempty"`
	CancelRequestID *string `json:"cancelRequestID,omitempty"`
}

// ToWire translates a RequestCancelInfo struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *RequestCancelInfo) ToWire() (wire.Value, error) {
	var (
		fields [2]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Version != nil {
		w, err = wire.NewValueI64(*(v.Version)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.CancelRequestID != nil {
		w, err = wire.NewValueString(*(v.CancelRequestID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 12, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a RequestCancelInfo struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a RequestCancelInfo struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v RequestCancelInfo
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *RequestCancelInfo) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.Version = &x
				if err != nil {
					return err
				}

			}
		case 12:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.CancelRequestID = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a RequestCancelInfo
// struct.
func (v *RequestCancelInfo) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [2]string
	i := 0
	if v.Version != nil {
		fields[i] = fmt.Sprintf("Version: %v", *(v.Version))
		i++
	}
	if v.CancelRequestID != nil {
		fields[i] = fmt.Sprintf("CancelRequestID: %v", *(v.CancelRequestID))
		i++
	}

	return fmt.Sprintf("RequestCancelInfo{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this RequestCancelInfo match the
// provided RequestCancelInfo.
//
// This function performs a deep comparison.
func (v *RequestCancelInfo) Equals(rhs *RequestCancelInfo) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_I64_EqualsPtr(v.Version, rhs.Version) {
		return false
	}
	if !_String_EqualsPtr(v.CancelRequestID, rhs.CancelRequestID) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of RequestCancelInfo.
func (v *RequestCancelInfo) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Version != nil {
		enc.AddInt64("version", *v.Version)
	}
	if v.CancelRequestID != nil {
		enc.AddString("cancelRequestID", *v.CancelRequestID)
	}
	return err
}

// GetVersion returns the value of Version if it is set or its
// zero value if it is unset.
func (v *RequestCancelInfo) GetVersion() (o int64) {
	if v != nil && v.Version != nil {
		return *v.Version
	}

	return
}

// IsSetVersion returns true if Version is not nil.
func (v *RequestCancelInfo) IsSetVersion() bool {
	return v != nil && v.Version != nil
}

// GetCancelRequestID returns the value of CancelRequestID if it is set or its
// zero value if it is unset.
func (v *RequestCancelInfo) GetCancelRequestID() (o string) {
	if v != nil && v.CancelRequestID != nil {
		return *v.CancelRequestID
	}

	return
}

// IsSetCancelRequestID returns true if CancelRequestID is not nil.
func (v *RequestCancelInfo) IsSetCancelRequestID() bool {
	return v != nil && v.CancelRequestID != nil
}

type ShardInfo struct {
	StolenSinceRenew          *int32           `json:"stolenSinceRenew,omitempty"`
	UpdatedAtNanos            *int64           `json:"updatedAtNanos,omitempty"`
	ReplicationAckLevel       *int64           `json:"replicationAckLevel,omitempty"`
	TransferAckLevel          *int64           `json:"transferAckLevel,omitempty"`
	TimerAckLevelNanos        *int64           `json:"timerAckLevelNanos,omitempty"`
	DomainNotificationVersion *int64           `json:"domainNotificationVersion,omitempty"`
	ClusterTransferAckLevel   map[string]int64 `json:"clusterTransferAckLevel,omitempty"`
	ClusterTimerAckLevel      map[string]int64 `json:"clusterTimerAckLevel,omitempty"`
	Owner                     *string          `json:"owner,omitempty"`
}

type _Map_String_I64_MapItemList map[string]int64

func (m _Map_String_I64_MapItemList) ForEach(f func(wire.MapItem) error) error {
	for k, v := range m {
		kw, err := wire.NewValueString(k), error(nil)
		if err != nil {
			return err
		}

		vw, err := wire.NewValueI64(v), error(nil)
		if err != nil {
			return err
		}
		err = f(wire.MapItem{Key: kw, Value: vw})
		if err != nil {
			return err
		}
	}
	return nil
}

func (m _Map_String_I64_MapItemList) Size() int {
	return len(m)
}

func (_Map_String_I64_MapItemList) KeyType() wire.Type {
	return wire.TBinary
}

func (_Map_String_I64_MapItemList) ValueType() wire.Type {
	return wire.TI64
}

func (_Map_String_I64_MapItemList) Close() {}

// ToWire translates a ShardInfo struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *ShardInfo) ToWire() (wire.Value, error) {
	var (
		fields [9]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.StolenSinceRenew != nil {
		w, err = wire.NewValueI32(*(v.StolenSinceRenew)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.UpdatedAtNanos != nil {
		w, err = wire.NewValueI64(*(v.UpdatedAtNanos)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 12, Value: w}
		i++
	}
	if v.ReplicationAckLevel != nil {
		w, err = wire.NewValueI64(*(v.ReplicationAckLevel)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 14, Value: w}
		i++
	}
	if v.TransferAckLevel != nil {
		w, err = wire.NewValueI64(*(v.TransferAckLevel)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 16, Value: w}
		i++
	}
	if v.TimerAckLevelNanos != nil {
		w, err = wire.NewValueI64(*(v.TimerAckLevelNanos)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 18, Value: w}
		i++
	}
	if v.DomainNotificationVersion != nil {
		w, err = wire.NewValueI64(*(v.DomainNotificationVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 24, Value: w}
		i++
	}
	if v.ClusterTransferAckLevel != nil {
		w, err = wire.NewValueMap(_Map_String_I64_MapItemList(v.ClusterTransferAckLevel)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 34, Value: w}
		i++
	}
	if v.ClusterTimerAckLevel != nil {
		w, err = wire.NewValueMap(_Map_String_I64_MapItemList(v.ClusterTimerAckLevel)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 36, Value: w}
		i++
	}
	if v.Owner != nil {
		w, err = wire.NewValueString(*(v.Owner)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 38, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

func _Map_String_I64_Read(m wire.MapItemList) (map[string]int64, error) {
	if m.KeyType() != wire.TBinary {
		return nil, nil
	}

	if m.ValueType() != wire.TI64 {
		return nil, nil
	}

	o := make(map[string]int64, m.Size())
	err := m.ForEach(func(x wire.MapItem) error {
		k, err := x.Key.GetString(), error(nil)
		if err != nil {
			return err
		}

		v, err := x.Value.GetI64(), error(nil)
		if err != nil {
			return err
		}

		o[k] = v
		return nil
	})
	m.Close()
	return o, err
}

// FromWire deserializes a ShardInfo struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a ShardInfo struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v ShardInfo
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *ShardInfo) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.StolenSinceRenew = &x
				if err != nil {
					return err
				}

			}
		case 12:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.UpdatedAtNanos = &x
				if err != nil {
					return err
				}

			}
		case 14:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ReplicationAckLevel = &x
				if err != nil {
					return err
				}

			}
		case 16:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.TransferAckLevel = &x
				if err != nil {
					return err
				}

			}
		case 18:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.TimerAckLevelNanos = &x
				if err != nil {
					return err
				}

			}
		case 24:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.DomainNotificationVersion = &x
				if err != nil {
					return err
				}

			}
		case 34:
			if field.Value.Type() == wire.TMap {
				v.ClusterTransferAckLevel, err = _Map_String_I64_Read(field.Value.GetMap())
				if err != nil {
					return err
				}

			}
		case 36:
			if field.Value.Type() == wire.TMap {
				v.ClusterTimerAckLevel, err = _Map_String_I64_Read(field.Value.GetMap())
				if err != nil {
					return err
				}

			}
		case 38:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Owner = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a ShardInfo
// struct.
func (v *ShardInfo) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [9]string
	i := 0
	if v.StolenSinceRenew != nil {
		fields[i] = fmt.Sprintf("StolenSinceRenew: %v", *(v.StolenSinceRenew))
		i++
	}
	if v.UpdatedAtNanos != nil {
		fields[i] = fmt.Sprintf("UpdatedAtNanos: %v", *(v.UpdatedAtNanos))
		i++
	}
	if v.ReplicationAckLevel != nil {
		fields[i] = fmt.Sprintf("ReplicationAckLevel: %v", *(v.ReplicationAckLevel))
		i++
	}
	if v.TransferAckLevel != nil {
		fields[i] = fmt.Sprintf("TransferAckLevel: %v", *(v.TransferAckLevel))
		i++
	}
	if v.TimerAckLevelNanos != nil {
		fields[i] = fmt.Sprintf("TimerAckLevelNanos: %v", *(v.TimerAckLevelNanos))
		i++
	}
	if v.DomainNotificationVersion != nil {
		fields[i] = fmt.Sprintf("DomainNotificationVersion: %v", *(v.DomainNotificationVersion))
		i++
	}
	if v.ClusterTransferAckLevel != nil {
		fields[i] = fmt.Sprintf("ClusterTransferAckLevel: %v", v.ClusterTransferAckLevel)
		i++
	}
	if v.ClusterTimerAckLevel != nil {
		fields[i] = fmt.Sprintf("ClusterTimerAckLevel: %v", v.ClusterTimerAckLevel)
		i++
	}
	if v.Owner != nil {
		fields[i] = fmt.Sprintf("Owner: %v", *(v.Owner))
		i++
	}

	return fmt.Sprintf("ShardInfo{%v}", strings.Join(fields[:i], ", "))
}

func _Map_String_I64_Equals(lhs, rhs map[string]int64) bool {
	if len(lhs) != len(rhs) {
		return false
	}

	for lk, lv := range lhs {
		rv, ok := rhs[lk]
		if !ok {
			return false
		}
		if !(lv == rv) {
			return false
		}
	}
	return true
}

// Equals returns true if all the fields of this ShardInfo match the
// provided ShardInfo.
//
// This function performs a deep comparison.
func (v *ShardInfo) Equals(rhs *ShardInfo) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_I32_EqualsPtr(v.StolenSinceRenew, rhs.StolenSinceRenew) {
		return false
	}
	if !_I64_EqualsPtr(v.UpdatedAtNanos, rhs.UpdatedAtNanos) {
		return false
	}
	if !_I64_EqualsPtr(v.ReplicationAckLevel, rhs.ReplicationAckLevel) {
		return false
	}
	if !_I64_EqualsPtr(v.TransferAckLevel, rhs.TransferAckLevel) {
		return false
	}
	if !_I64_EqualsPtr(v.TimerAckLevelNanos, rhs.TimerAckLevelNanos) {
		return false
	}
	if !_I64_EqualsPtr(v.DomainNotificationVersion, rhs.DomainNotificationVersion) {
		return false
	}
	if !((v.ClusterTransferAckLevel == nil && rhs.ClusterTransferAckLevel == nil) || (v.ClusterTransferAckLevel != nil && rhs.ClusterTransferAckLevel != nil && _Map_String_I64_Equals(v.ClusterTransferAckLevel, rhs.ClusterTransferAckLevel))) {
		return false
	}
	if !((v.ClusterTimerAckLevel == nil && rhs.ClusterTimerAckLevel == nil) || (v.ClusterTimerAckLevel != nil && rhs.ClusterTimerAckLevel != nil && _Map_String_I64_Equals(v.ClusterTimerAckLevel, rhs.ClusterTimerAckLevel))) {
		return false
	}
	if !_String_EqualsPtr(v.Owner, rhs.Owner) {
		return false
	}

	return true
}

type _Map_String_I64_Zapper map[string]int64

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of _Map_String_I64_Zapper.
func (m _Map_String_I64_Zapper) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	for k, v := range m {
		enc.AddInt64((string)(k), v)
	}
	return err
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of ShardInfo.
func (v *ShardInfo) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.StolenSinceRenew != nil {
		enc.AddInt32("stolenSinceRenew", *v.StolenSinceRenew)
	}
	if v.UpdatedAtNanos != nil {
		enc.AddInt64("updatedAtNanos", *v.UpdatedAtNanos)
	}
	if v.ReplicationAckLevel != nil {
		enc.AddInt64("replicationAckLevel", *v.ReplicationAckLevel)
	}
	if v.TransferAckLevel != nil {
		enc.AddInt64("transferAckLevel", *v.TransferAckLevel)
	}
	if v.TimerAckLevelNanos != nil {
		enc.AddInt64("timerAckLevelNanos", *v.TimerAckLevelNanos)
	}
	if v.DomainNotificationVersion != nil {
		enc.AddInt64("domainNotificationVersion", *v.DomainNotificationVersion)
	}
	if v.ClusterTransferAckLevel != nil {
		err = multierr.Append(err, enc.AddObject("clusterTransferAckLevel", (_Map_String_I64_Zapper)(v.ClusterTransferAckLevel)))
	}
	if v.ClusterTimerAckLevel != nil {
		err = multierr.Append(err, enc.AddObject("clusterTimerAckLevel", (_Map_String_I64_Zapper)(v.ClusterTimerAckLevel)))
	}
	if v.Owner != nil {
		enc.AddString("owner", *v.Owner)
	}
	return err
}

// GetStolenSinceRenew returns the value of StolenSinceRenew if it is set or its
// zero value if it is unset.
func (v *ShardInfo) GetStolenSinceRenew() (o int32) {
	if v != nil && v.StolenSinceRenew != nil {
		return *v.StolenSinceRenew
	}

	return
}

// IsSetStolenSinceRenew returns true if StolenSinceRenew is not nil.
func (v *ShardInfo) IsSetStolenSinceRenew() bool {
	return v != nil && v.StolenSinceRenew != nil
}

// GetUpdatedAtNanos returns the value of UpdatedAtNanos if it is set or its
// zero value if it is unset.
func (v *ShardInfo) GetUpdatedAtNanos() (o int64) {
	if v != nil && v.UpdatedAtNanos != nil {
		return *v.UpdatedAtNanos
	}

	return
}

// IsSetUpdatedAtNanos returns true if UpdatedAtNanos is not nil.
func (v *ShardInfo) IsSetUpdatedAtNanos() bool {
	return v != nil && v.UpdatedAtNanos != nil
}

// GetReplicationAckLevel returns the value of ReplicationAckLevel if it is set or its
// zero value if it is unset.
func (v *ShardInfo) GetReplicationAckLevel() (o int64) {
	if v != nil && v.ReplicationAckLevel != nil {
		return *v.ReplicationAckLevel
	}

	return
}

// IsSetReplicationAckLevel returns true if ReplicationAckLevel is not nil.
func (v *ShardInfo) IsSetReplicationAckLevel() bool {
	return v != nil && v.ReplicationAckLevel != nil
}

// GetTransferAckLevel returns the value of TransferAckLevel if it is set or its
// zero value if it is unset.
func (v *ShardInfo) GetTransferAckLevel() (o int64) {
	if v != nil && v.TransferAckLevel != nil {
		return *v.TransferAckLevel
	}

	return
}

// IsSetTransferAckLevel returns true if TransferAckLevel is not nil.
func (v *ShardInfo) IsSetTransferAckLevel() bool {
	return v != nil && v.TransferAckLevel != nil
}

// GetTimerAckLevelNanos returns the value of TimerAckLevelNanos if it is set or its
// zero value if it is unset.
func (v *ShardInfo) GetTimerAckLevelNanos() (o int64) {
	if v != nil && v.TimerAckLevelNanos != nil {
		return *v.TimerAckLevelNanos
	}

	return
}

// IsSetTimerAckLevelNanos returns true if TimerAckLevelNanos is not nil.
func (v *ShardInfo) IsSetTimerAckLevelNanos() bool {
	return v != nil && v.TimerAckLevelNanos != nil
}

// GetDomainNotificationVersion returns the value of DomainNotificationVersion if it is set or its
// zero value if it is unset.
func (v *ShardInfo) GetDomainNotificationVersion() (o int64) {
	if v != nil && v.DomainNotificationVersion != nil {
		return *v.DomainNotificationVersion
	}

	return
}

// IsSetDomainNotificationVersion returns true if DomainNotificationVersion is not nil.
func (v *ShardInfo) IsSetDomainNotificationVersion() bool {
	return v != nil && v.DomainNotificationVersion != nil
}

// GetClusterTransferAckLevel returns the value of ClusterTransferAckLevel if it is set or its
// zero value if it is unset.
func (v *ShardInfo) GetClusterTransferAckLevel() (o map[string]int64) {
	if v != nil && v.ClusterTransferAckLevel != nil {
		return v.ClusterTransferAckLevel
	}

	return
}

// IsSetClusterTransferAckLevel returns true if ClusterTransferAckLevel is not nil.
func (v *ShardInfo) IsSetClusterTransferAckLevel() bool {
	return v != nil && v.ClusterTransferAckLevel != nil
}

// GetClusterTimerAckLevel returns the value of ClusterTimerAckLevel if it is set or its
// zero value if it is unset.
func (v *ShardInfo) GetClusterTimerAckLevel() (o map[string]int64) {
	if v != nil && v.ClusterTimerAckLevel != nil {
		return v.ClusterTimerAckLevel
	}

	return
}

// IsSetClusterTimerAckLevel returns true if ClusterTimerAckLevel is not nil.
func (v *ShardInfo) IsSetClusterTimerAckLevel() bool {
	return v != nil && v.ClusterTimerAckLevel != nil
}

// GetOwner returns the value of Owner if it is set or its
// zero value if it is unset.
func (v *ShardInfo) GetOwner() (o string) {
	if v != nil && v.Owner != nil {
		return *v.Owner
	}

	return
}

// IsSetOwner returns true if Owner is not nil.
func (v *ShardInfo) IsSetOwner() bool {
	return v != nil && v.Owner != nil
}

type SignalInfo struct {
	Version   *int64  `json:"version,omitempty"`
	RequestID *string `json:"requestID,omitempty"`
	Name      *string `json:"name,omitempty"`
	Input     []byte  `json:"input,omitempty"`
	Control   []byte  `json:"control,omitempty"`
}

// ToWire translates a SignalInfo struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *SignalInfo) ToWire() (wire.Value, error) {
	var (
		fields [5]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Version != nil {
		w, err = wire.NewValueI64(*(v.Version)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.RequestID != nil {
		w, err = wire.NewValueString(*(v.RequestID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 12, Value: w}
		i++
	}
	if v.Name != nil {
		w, err = wire.NewValueString(*(v.Name)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 14, Value: w}
		i++
	}
	if v.Input != nil {
		w, err = wire.NewValueBinary(v.Input), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 16, Value: w}
		i++
	}
	if v.Control != nil {
		w, err = wire.NewValueBinary(v.Control), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 18, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a SignalInfo struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a SignalInfo struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v SignalInfo
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *SignalInfo) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.Version = &x
				if err != nil {
					return err
				}

			}
		case 12:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.RequestID = &x
				if err != nil {
					return err
				}

			}
		case 14:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.Name = &x
				if err != nil {
					return err
				}

			}
		case 16:
			if field.Value.Type() == wire.TBinary {
				v.Input, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 18:
			if field.Value.Type() == wire.TBinary {
				v.Control, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a SignalInfo
// struct.
func (v *SignalInfo) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [5]string
	i := 0
	if v.Version != nil {
		fields[i] = fmt.Sprintf("Version: %v", *(v.Version))
		i++
	}
	if v.RequestID != nil {
		fields[i] = fmt.Sprintf("RequestID: %v", *(v.RequestID))
		i++
	}
	if v.Name != nil {
		fields[i] = fmt.Sprintf("Name: %v", *(v.Name))
		i++
	}
	if v.Input != nil {
		fields[i] = fmt.Sprintf("Input: %v", v.Input)
		i++
	}
	if v.Control != nil {
		fields[i] = fmt.Sprintf("Control: %v", v.Control)
		i++
	}

	return fmt.Sprintf("SignalInfo{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this SignalInfo match the
// provided SignalInfo.
//
// This function performs a deep comparison.
func (v *SignalInfo) Equals(rhs *SignalInfo) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_I64_EqualsPtr(v.Version, rhs.Version) {
		return false
	}
	if !_String_EqualsPtr(v.RequestID, rhs.RequestID) {
		return false
	}
	if !_String_EqualsPtr(v.Name, rhs.Name) {
		return false
	}
	if !((v.Input == nil && rhs.Input == nil) || (v.Input != nil && rhs.Input != nil && bytes.Equal(v.Input, rhs.Input))) {
		return false
	}
	if !((v.Control == nil && rhs.Control == nil) || (v.Control != nil && rhs.Control != nil && bytes.Equal(v.Control, rhs.Control))) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of SignalInfo.
func (v *SignalInfo) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Version != nil {
		enc.AddInt64("version", *v.Version)
	}
	if v.RequestID != nil {
		enc.AddString("requestID", *v.RequestID)
	}
	if v.Name != nil {
		enc.AddString("name", *v.Name)
	}
	if v.Input != nil {
		enc.AddString("input", base64.StdEncoding.EncodeToString(v.Input))
	}
	if v.Control != nil {
		enc.AddString("control", base64.StdEncoding.EncodeToString(v.Control))
	}
	return err
}

// GetVersion returns the value of Version if it is set or its
// zero value if it is unset.
func (v *SignalInfo) GetVersion() (o int64) {
	if v != nil && v.Version != nil {
		return *v.Version
	}

	return
}

// IsSetVersion returns true if Version is not nil.
func (v *SignalInfo) IsSetVersion() bool {
	return v != nil && v.Version != nil
}

// GetRequestID returns the value of RequestID if it is set or its
// zero value if it is unset.
func (v *SignalInfo) GetRequestID() (o string) {
	if v != nil && v.RequestID != nil {
		return *v.RequestID
	}

	return
}

// IsSetRequestID returns true if RequestID is not nil.
func (v *SignalInfo) IsSetRequestID() bool {
	return v != nil && v.RequestID != nil
}

// GetName returns the value of Name if it is set or its
// zero value if it is unset.
func (v *SignalInfo) GetName() (o string) {
	if v != nil && v.Name != nil {
		return *v.Name
	}

	return
}

// IsSetName returns true if Name is not nil.
func (v *SignalInfo) IsSetName() bool {
	return v != nil && v.Name != nil
}

// GetInput returns the value of Input if it is set or its
// zero value if it is unset.
func (v *SignalInfo) GetInput() (o []byte) {
	if v != nil && v.Input != nil {
		return v.Input
	}

	return
}

// IsSetInput returns true if Input is not nil.
func (v *SignalInfo) IsSetInput() bool {
	return v != nil && v.Input != nil
}

// GetControl returns the value of Control if it is set or its
// zero value if it is unset.
func (v *SignalInfo) GetControl() (o []byte) {
	if v != nil && v.Control != nil {
		return v.Control
	}

	return
}

// IsSetControl returns true if Control is not nil.
func (v *SignalInfo) IsSetControl() bool {
	return v != nil && v.Control != nil
}

type TaskInfo struct {
	WorkflowID      *string `json:"workflowID,omitempty"`
	RunID           []byte  `json:"runID,omitempty"`
	ScheduleID      *int64  `json:"scheduleID,omitempty"`
	ExpiryTimeNanos *int64  `json:"expiryTimeNanos,omitempty"`
}

// ToWire translates a TaskInfo struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *TaskInfo) ToWire() (wire.Value, error) {
	var (
		fields [4]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.WorkflowID != nil {
		w, err = wire.NewValueString(*(v.WorkflowID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.RunID != nil {
		w, err = wire.NewValueBinary(v.RunID), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 12, Value: w}
		i++
	}
	if v.ScheduleID != nil {
		w, err = wire.NewValueI64(*(v.ScheduleID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 13, Value: w}
		i++
	}
	if v.ExpiryTimeNanos != nil {
		w, err = wire.NewValueI64(*(v.ExpiryTimeNanos)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 14, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a TaskInfo struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a TaskInfo struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v TaskInfo
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *TaskInfo) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.WorkflowID = &x
				if err != nil {
					return err
				}

			}
		case 12:
			if field.Value.Type() == wire.TBinary {
				v.RunID, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 13:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduleID = &x
				if err != nil {
					return err
				}

			}
		case 14:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ExpiryTimeNanos = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a TaskInfo
// struct.
func (v *TaskInfo) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [4]string
	i := 0
	if v.WorkflowID != nil {
		fields[i] = fmt.Sprintf("WorkflowID: %v", *(v.WorkflowID))
		i++
	}
	if v.RunID != nil {
		fields[i] = fmt.Sprintf("RunID: %v", v.RunID)
		i++
	}
	if v.ScheduleID != nil {
		fields[i] = fmt.Sprintf("ScheduleID: %v", *(v.ScheduleID))
		i++
	}
	if v.ExpiryTimeNanos != nil {
		fields[i] = fmt.Sprintf("ExpiryTimeNanos: %v", *(v.ExpiryTimeNanos))
		i++
	}

	return fmt.Sprintf("TaskInfo{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this TaskInfo match the
// provided TaskInfo.
//
// This function performs a deep comparison.
func (v *TaskInfo) Equals(rhs *TaskInfo) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_String_EqualsPtr(v.WorkflowID, rhs.WorkflowID) {
		return false
	}
	if !((v.RunID == nil && rhs.RunID == nil) || (v.RunID != nil && rhs.RunID != nil && bytes.Equal(v.RunID, rhs.RunID))) {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduleID, rhs.ScheduleID) {
		return false
	}
	if !_I64_EqualsPtr(v.ExpiryTimeNanos, rhs.ExpiryTimeNanos) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of TaskInfo.
func (v *TaskInfo) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.WorkflowID != nil {
		enc.AddString("workflowID", *v.WorkflowID)
	}
	if v.RunID != nil {
		enc.AddString("runID", base64.StdEncoding.EncodeToString(v.RunID))
	}
	if v.ScheduleID != nil {
		enc.AddInt64("scheduleID", *v.ScheduleID)
	}
	if v.ExpiryTimeNanos != nil {
		enc.AddInt64("expiryTimeNanos", *v.ExpiryTimeNanos)
	}
	return err
}

// GetWorkflowID returns the value of WorkflowID if it is set or its
// zero value if it is unset.
func (v *TaskInfo) GetWorkflowID() (o string) {
	if v != nil && v.WorkflowID != nil {
		return *v.WorkflowID
	}

	return
}

// IsSetWorkflowID returns true if WorkflowID is not nil.
func (v *TaskInfo) IsSetWorkflowID() bool {
	return v != nil && v.WorkflowID != nil
}

// GetRunID returns the value of RunID if it is set or its
// zero value if it is unset.
func (v *TaskInfo) GetRunID() (o []byte) {
	if v != nil && v.RunID != nil {
		return v.RunID
	}

	return
}

// IsSetRunID returns true if RunID is not nil.
func (v *TaskInfo) IsSetRunID() bool {
	return v != nil && v.RunID != nil
}

// GetScheduleID returns the value of ScheduleID if it is set or its
// zero value if it is unset.
func (v *TaskInfo) GetScheduleID() (o int64) {
	if v != nil && v.ScheduleID != nil {
		return *v.ScheduleID
	}

	return
}

// IsSetScheduleID returns true if ScheduleID is not nil.
func (v *TaskInfo) IsSetScheduleID() bool {
	return v != nil && v.ScheduleID != nil
}

// GetExpiryTimeNanos returns the value of ExpiryTimeNanos if it is set or its
// zero value if it is unset.
func (v *TaskInfo) GetExpiryTimeNanos() (o int64) {
	if v != nil && v.ExpiryTimeNanos != nil {
		return *v.ExpiryTimeNanos
	}

	return
}

// IsSetExpiryTimeNanos returns true if ExpiryTimeNanos is not nil.
func (v *TaskInfo) IsSetExpiryTimeNanos() bool {
	return v != nil && v.ExpiryTimeNanos != nil
}

type TaskListInfo struct {
	Kind             *int16 `json:"kind,omitempty"`
	AckLevel         *int64 `json:"ackLevel,omitempty"`
	ExpiryTimeNanos  *int64 `json:"expiryTimeNanos,omitempty"`
	LastUpdatedNanos *int64 `json:"lastUpdatedNanos,omitempty"`
}

// ToWire translates a TaskListInfo struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *TaskListInfo) ToWire() (wire.Value, error) {
	var (
		fields [4]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Kind != nil {
		w, err = wire.NewValueI16(*(v.Kind)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.AckLevel != nil {
		w, err = wire.NewValueI64(*(v.AckLevel)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 12, Value: w}
		i++
	}
	if v.ExpiryTimeNanos != nil {
		w, err = wire.NewValueI64(*(v.ExpiryTimeNanos)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 14, Value: w}
		i++
	}
	if v.LastUpdatedNanos != nil {
		w, err = wire.NewValueI64(*(v.LastUpdatedNanos)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 16, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a TaskListInfo struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a TaskListInfo struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v TaskListInfo
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *TaskListInfo) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI16 {
				var x int16
				x, err = field.Value.GetI16(), error(nil)
				v.Kind = &x
				if err != nil {
					return err
				}

			}
		case 12:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.AckLevel = &x
				if err != nil {
					return err
				}

			}
		case 14:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ExpiryTimeNanos = &x
				if err != nil {
					return err
				}

			}
		case 16:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.LastUpdatedNanos = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a TaskListInfo
// struct.
func (v *TaskListInfo) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [4]string
	i := 0
	if v.Kind != nil {
		fields[i] = fmt.Sprintf("Kind: %v", *(v.Kind))
		i++
	}
	if v.AckLevel != nil {
		fields[i] = fmt.Sprintf("AckLevel: %v", *(v.AckLevel))
		i++
	}
	if v.ExpiryTimeNanos != nil {
		fields[i] = fmt.Sprintf("ExpiryTimeNanos: %v", *(v.ExpiryTimeNanos))
		i++
	}
	if v.LastUpdatedNanos != nil {
		fields[i] = fmt.Sprintf("LastUpdatedNanos: %v", *(v.LastUpdatedNanos))
		i++
	}

	return fmt.Sprintf("TaskListInfo{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this TaskListInfo match the
// provided TaskListInfo.
//
// This function performs a deep comparison.
func (v *TaskListInfo) Equals(rhs *TaskListInfo) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_I16_EqualsPtr(v.Kind, rhs.Kind) {
		return false
	}
	if !_I64_EqualsPtr(v.AckLevel, rhs.AckLevel) {
		return false
	}
	if !_I64_EqualsPtr(v.ExpiryTimeNanos, rhs.ExpiryTimeNanos) {
		return false
	}
	if !_I64_EqualsPtr(v.LastUpdatedNanos, rhs.LastUpdatedNanos) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of TaskListInfo.
func (v *TaskListInfo) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Kind != nil {
		enc.AddInt16("kind", *v.Kind)
	}
	if v.AckLevel != nil {
		enc.AddInt64("ackLevel", *v.AckLevel)
	}
	if v.ExpiryTimeNanos != nil {
		enc.AddInt64("expiryTimeNanos", *v.ExpiryTimeNanos)
	}
	if v.LastUpdatedNanos != nil {
		enc.AddInt64("lastUpdatedNanos", *v.LastUpdatedNanos)
	}
	return err
}

// GetKind returns the value of Kind if it is set or its
// zero value if it is unset.
func (v *TaskListInfo) GetKind() (o int16) {
	if v != nil && v.Kind != nil {
		return *v.Kind
	}

	return
}

// IsSetKind returns true if Kind is not nil.
func (v *TaskListInfo) IsSetKind() bool {
	return v != nil && v.Kind != nil
}

// GetAckLevel returns the value of AckLevel if it is set or its
// zero value if it is unset.
func (v *TaskListInfo) GetAckLevel() (o int64) {
	if v != nil && v.AckLevel != nil {
		return *v.AckLevel
	}

	return
}

// IsSetAckLevel returns true if AckLevel is not nil.
func (v *TaskListInfo) IsSetAckLevel() bool {
	return v != nil && v.AckLevel != nil
}

// GetExpiryTimeNanos returns the value of ExpiryTimeNanos if it is set or its
// zero value if it is unset.
func (v *TaskListInfo) GetExpiryTimeNanos() (o int64) {
	if v != nil && v.ExpiryTimeNanos != nil {
		return *v.ExpiryTimeNanos
	}

	return
}

// IsSetExpiryTimeNanos returns true if ExpiryTimeNanos is not nil.
func (v *TaskListInfo) IsSetExpiryTimeNanos() bool {
	return v != nil && v.ExpiryTimeNanos != nil
}

// GetLastUpdatedNanos returns the value of LastUpdatedNanos if it is set or its
// zero value if it is unset.
func (v *TaskListInfo) GetLastUpdatedNanos() (o int64) {
	if v != nil && v.LastUpdatedNanos != nil {
		return *v.LastUpdatedNanos
	}

	return
}

// IsSetLastUpdatedNanos returns true if LastUpdatedNanos is not nil.
func (v *TaskListInfo) IsSetLastUpdatedNanos() bool {
	return v != nil && v.LastUpdatedNanos != nil
}

type TimerInfo struct {
	Version         *int64 `json:"version,omitempty"`
	StartedID       *int64 `json:"startedID,omitempty"`
	ExpiryTimeNanos *int64 `json:"expiryTimeNanos,omitempty"`
	TaskID          *int64 `json:"taskID,omitempty"`
}

// ToWire translates a TimerInfo struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *TimerInfo) ToWire() (wire.Value, error) {
	var (
		fields [4]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.Version != nil {
		w, err = wire.NewValueI64(*(v.Version)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.StartedID != nil {
		w, err = wire.NewValueI64(*(v.StartedID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 12, Value: w}
		i++
	}
	if v.ExpiryTimeNanos != nil {
		w, err = wire.NewValueI64(*(v.ExpiryTimeNanos)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 14, Value: w}
		i++
	}
	if v.TaskID != nil {
		w, err = wire.NewValueI64(*(v.TaskID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 16, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a TimerInfo struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a TimerInfo struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v TimerInfo
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *TimerInfo) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.Version = &x
				if err != nil {
					return err
				}

			}
		case 12:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StartedID = &x
				if err != nil {
					return err
				}

			}
		case 14:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ExpiryTimeNanos = &x
				if err != nil {
					return err
				}

			}
		case 16:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.TaskID = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a TimerInfo
// struct.
func (v *TimerInfo) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [4]string
	i := 0
	if v.Version != nil {
		fields[i] = fmt.Sprintf("Version: %v", *(v.Version))
		i++
	}
	if v.StartedID != nil {
		fields[i] = fmt.Sprintf("StartedID: %v", *(v.StartedID))
		i++
	}
	if v.ExpiryTimeNanos != nil {
		fields[i] = fmt.Sprintf("ExpiryTimeNanos: %v", *(v.ExpiryTimeNanos))
		i++
	}
	if v.TaskID != nil {
		fields[i] = fmt.Sprintf("TaskID: %v", *(v.TaskID))
		i++
	}

	return fmt.Sprintf("TimerInfo{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this TimerInfo match the
// provided TimerInfo.
//
// This function performs a deep comparison.
func (v *TimerInfo) Equals(rhs *TimerInfo) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !_I64_EqualsPtr(v.Version, rhs.Version) {
		return false
	}
	if !_I64_EqualsPtr(v.StartedID, rhs.StartedID) {
		return false
	}
	if !_I64_EqualsPtr(v.ExpiryTimeNanos, rhs.ExpiryTimeNanos) {
		return false
	}
	if !_I64_EqualsPtr(v.TaskID, rhs.TaskID) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of TimerInfo.
func (v *TimerInfo) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.Version != nil {
		enc.AddInt64("version", *v.Version)
	}
	if v.StartedID != nil {
		enc.AddInt64("startedID", *v.StartedID)
	}
	if v.ExpiryTimeNanos != nil {
		enc.AddInt64("expiryTimeNanos", *v.ExpiryTimeNanos)
	}
	if v.TaskID != nil {
		enc.AddInt64("taskID", *v.TaskID)
	}
	return err
}

// GetVersion returns the value of Version if it is set or its
// zero value if it is unset.
func (v *TimerInfo) GetVersion() (o int64) {
	if v != nil && v.Version != nil {
		return *v.Version
	}

	return
}

// IsSetVersion returns true if Version is not nil.
func (v *TimerInfo) IsSetVersion() bool {
	return v != nil && v.Version != nil
}

// GetStartedID returns the value of StartedID if it is set or its
// zero value if it is unset.
func (v *TimerInfo) GetStartedID() (o int64) {
	if v != nil && v.StartedID != nil {
		return *v.StartedID
	}

	return
}

// IsSetStartedID returns true if StartedID is not nil.
func (v *TimerInfo) IsSetStartedID() bool {
	return v != nil && v.StartedID != nil
}

// GetExpiryTimeNanos returns the value of ExpiryTimeNanos if it is set or its
// zero value if it is unset.
func (v *TimerInfo) GetExpiryTimeNanos() (o int64) {
	if v != nil && v.ExpiryTimeNanos != nil {
		return *v.ExpiryTimeNanos
	}

	return
}

// IsSetExpiryTimeNanos returns true if ExpiryTimeNanos is not nil.
func (v *TimerInfo) IsSetExpiryTimeNanos() bool {
	return v != nil && v.ExpiryTimeNanos != nil
}

// GetTaskID returns the value of TaskID if it is set or its
// zero value if it is unset.
func (v *TimerInfo) GetTaskID() (o int64) {
	if v != nil && v.TaskID != nil {
		return *v.TaskID
	}

	return
}

// IsSetTaskID returns true if TaskID is not nil.
func (v *TimerInfo) IsSetTaskID() bool {
	return v != nil && v.TaskID != nil
}

type TimerTaskInfo struct {
	DomainID        []byte  `json:"domainID,omitempty"`
	WorkflowID      *string `json:"workflowID,omitempty"`
	RunID           []byte  `json:"runID,omitempty"`
	TaskType        *int16  `json:"taskType,omitempty"`
	TimeoutType     *int16  `json:"timeoutType,omitempty"`
	Version         *int64  `json:"version,omitempty"`
	ScheduleAttempt *int64  `json:"scheduleAttempt,omitempty"`
	EventID         *int64  `json:"eventID,omitempty"`
}

// ToWire translates a TimerTaskInfo struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *TimerTaskInfo) ToWire() (wire.Value, error) {
	var (
		fields [8]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainID != nil {
		w, err = wire.NewValueBinary(v.DomainID), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.WorkflowID != nil {
		w, err = wire.NewValueString(*(v.WorkflowID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 12, Value: w}
		i++
	}
	if v.RunID != nil {
		w, err = wire.NewValueBinary(v.RunID), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 14, Value: w}
		i++
	}
	if v.TaskType != nil {
		w, err = wire.NewValueI16(*(v.TaskType)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 16, Value: w}
		i++
	}
	if v.TimeoutType != nil {
		w, err = wire.NewValueI16(*(v.TimeoutType)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 18, Value: w}
		i++
	}
	if v.Version != nil {
		w, err = wire.NewValueI64(*(v.Version)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.ScheduleAttempt != nil {
		w, err = wire.NewValueI64(*(v.ScheduleAttempt)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 22, Value: w}
		i++
	}
	if v.EventID != nil {
		w, err = wire.NewValueI64(*(v.EventID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 24, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a TimerTaskInfo struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a TimerTaskInfo struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v TimerTaskInfo
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *TimerTaskInfo) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				v.DomainID, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 12:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.WorkflowID = &x
				if err != nil {
					return err
				}

			}
		case 14:
			if field.Value.Type() == wire.TBinary {
				v.RunID, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 16:
			if field.Value.Type() == wire.TI16 {
				var x int16
				x, err = field.Value.GetI16(), error(nil)
				v.TaskType = &x
				if err != nil {
					return err
				}

			}
		case 18:
			if field.Value.Type() == wire.TI16 {
				var x int16
				x, err = field.Value.GetI16(), error(nil)
				v.TimeoutType = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.Version = &x
				if err != nil {
					return err
				}

			}
		case 22:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduleAttempt = &x
				if err != nil {
					return err
				}

			}
		case 24:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.EventID = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a TimerTaskInfo
// struct.
func (v *TimerTaskInfo) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [8]string
	i := 0
	if v.DomainID != nil {
		fields[i] = fmt.Sprintf("DomainID: %v", v.DomainID)
		i++
	}
	if v.WorkflowID != nil {
		fields[i] = fmt.Sprintf("WorkflowID: %v", *(v.WorkflowID))
		i++
	}
	if v.RunID != nil {
		fields[i] = fmt.Sprintf("RunID: %v", v.RunID)
		i++
	}
	if v.TaskType != nil {
		fields[i] = fmt.Sprintf("TaskType: %v", *(v.TaskType))
		i++
	}
	if v.TimeoutType != nil {
		fields[i] = fmt.Sprintf("TimeoutType: %v", *(v.TimeoutType))
		i++
	}
	if v.Version != nil {
		fields[i] = fmt.Sprintf("Version: %v", *(v.Version))
		i++
	}
	if v.ScheduleAttempt != nil {
		fields[i] = fmt.Sprintf("ScheduleAttempt: %v", *(v.ScheduleAttempt))
		i++
	}
	if v.EventID != nil {
		fields[i] = fmt.Sprintf("EventID: %v", *(v.EventID))
		i++
	}

	return fmt.Sprintf("TimerTaskInfo{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this TimerTaskInfo match the
// provided TimerTaskInfo.
//
// This function performs a deep comparison.
func (v *TimerTaskInfo) Equals(rhs *TimerTaskInfo) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.DomainID == nil && rhs.DomainID == nil) || (v.DomainID != nil && rhs.DomainID != nil && bytes.Equal(v.DomainID, rhs.DomainID))) {
		return false
	}
	if !_String_EqualsPtr(v.WorkflowID, rhs.WorkflowID) {
		return false
	}
	if !((v.RunID == nil && rhs.RunID == nil) || (v.RunID != nil && rhs.RunID != nil && bytes.Equal(v.RunID, rhs.RunID))) {
		return false
	}
	if !_I16_EqualsPtr(v.TaskType, rhs.TaskType) {
		return false
	}
	if !_I16_EqualsPtr(v.TimeoutType, rhs.TimeoutType) {
		return false
	}
	if !_I64_EqualsPtr(v.Version, rhs.Version) {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduleAttempt, rhs.ScheduleAttempt) {
		return false
	}
	if !_I64_EqualsPtr(v.EventID, rhs.EventID) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of TimerTaskInfo.
func (v *TimerTaskInfo) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainID != nil {
		enc.AddString("domainID", base64.StdEncoding.EncodeToString(v.DomainID))
	}
	if v.WorkflowID != nil {
		enc.AddString("workflowID", *v.WorkflowID)
	}
	if v.RunID != nil {
		enc.AddString("runID", base64.StdEncoding.EncodeToString(v.RunID))
	}
	if v.TaskType != nil {
		enc.AddInt16("taskType", *v.TaskType)
	}
	if v.TimeoutType != nil {
		enc.AddInt16("timeoutType", *v.TimeoutType)
	}
	if v.Version != nil {
		enc.AddInt64("version", *v.Version)
	}
	if v.ScheduleAttempt != nil {
		enc.AddInt64("scheduleAttempt", *v.ScheduleAttempt)
	}
	if v.EventID != nil {
		enc.AddInt64("eventID", *v.EventID)
	}
	return err
}

// GetDomainID returns the value of DomainID if it is set or its
// zero value if it is unset.
func (v *TimerTaskInfo) GetDomainID() (o []byte) {
	if v != nil && v.DomainID != nil {
		return v.DomainID
	}

	return
}

// IsSetDomainID returns true if DomainID is not nil.
func (v *TimerTaskInfo) IsSetDomainID() bool {
	return v != nil && v.DomainID != nil
}

// GetWorkflowID returns the value of WorkflowID if it is set or its
// zero value if it is unset.
func (v *TimerTaskInfo) GetWorkflowID() (o string) {
	if v != nil && v.WorkflowID != nil {
		return *v.WorkflowID
	}

	return
}

// IsSetWorkflowID returns true if WorkflowID is not nil.
func (v *TimerTaskInfo) IsSetWorkflowID() bool {
	return v != nil && v.WorkflowID != nil
}

// GetRunID returns the value of RunID if it is set or its
// zero value if it is unset.
func (v *TimerTaskInfo) GetRunID() (o []byte) {
	if v != nil && v.RunID != nil {
		return v.RunID
	}

	return
}

// IsSetRunID returns true if RunID is not nil.
func (v *TimerTaskInfo) IsSetRunID() bool {
	return v != nil && v.RunID != nil
}

// GetTaskType returns the value of TaskType if it is set or its
// zero value if it is unset.
func (v *TimerTaskInfo) GetTaskType() (o int16) {
	if v != nil && v.TaskType != nil {
		return *v.TaskType
	}

	return
}

// IsSetTaskType returns true if TaskType is not nil.
func (v *TimerTaskInfo) IsSetTaskType() bool {
	return v != nil && v.TaskType != nil
}

// GetTimeoutType returns the value of TimeoutType if it is set or its
// zero value if it is unset.
func (v *TimerTaskInfo) GetTimeoutType() (o int16) {
	if v != nil && v.TimeoutType != nil {
		return *v.TimeoutType
	}

	return
}

// IsSetTimeoutType returns true if TimeoutType is not nil.
func (v *TimerTaskInfo) IsSetTimeoutType() bool {
	return v != nil && v.TimeoutType != nil
}

// GetVersion returns the value of Version if it is set or its
// zero value if it is unset.
func (v *TimerTaskInfo) GetVersion() (o int64) {
	if v != nil && v.Version != nil {
		return *v.Version
	}

	return
}

// IsSetVersion returns true if Version is not nil.
func (v *TimerTaskInfo) IsSetVersion() bool {
	return v != nil && v.Version != nil
}

// GetScheduleAttempt returns the value of ScheduleAttempt if it is set or its
// zero value if it is unset.
func (v *TimerTaskInfo) GetScheduleAttempt() (o int64) {
	if v != nil && v.ScheduleAttempt != nil {
		return *v.ScheduleAttempt
	}

	return
}

// IsSetScheduleAttempt returns true if ScheduleAttempt is not nil.
func (v *TimerTaskInfo) IsSetScheduleAttempt() bool {
	return v != nil && v.ScheduleAttempt != nil
}

// GetEventID returns the value of EventID if it is set or its
// zero value if it is unset.
func (v *TimerTaskInfo) GetEventID() (o int64) {
	if v != nil && v.EventID != nil {
		return *v.EventID
	}

	return
}

// IsSetEventID returns true if EventID is not nil.
func (v *TimerTaskInfo) IsSetEventID() bool {
	return v != nil && v.EventID != nil
}

type TransferTaskInfo struct {
	DomainID                 []byte  `json:"domainID,omitempty"`
	WorkflowID               *string `json:"workflowID,omitempty"`
	RunID                    []byte  `json:"runID,omitempty"`
	TaskType                 *int16  `json:"taskType,omitempty"`
	TargetDomainID           []byte  `json:"targetDomainID,omitempty"`
	TargetWorkflowID         *string `json:"targetWorkflowID,omitempty"`
	TargetRunID              []byte  `json:"targetRunID,omitempty"`
	TaskList                 *string `json:"taskList,omitempty"`
	TargetChildWorkflowOnly  *bool   `json:"targetChildWorkflowOnly,omitempty"`
	ScheduleID               *int64  `json:"scheduleID,omitempty"`
	Version                  *int64  `json:"version,omitempty"`
	VisibilityTimestampNanos *int64  `json:"visibilityTimestampNanos,omitempty"`
}

// ToWire translates a TransferTaskInfo struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *TransferTaskInfo) ToWire() (wire.Value, error) {
	var (
		fields [12]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.DomainID != nil {
		w, err = wire.NewValueBinary(v.DomainID), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.WorkflowID != nil {
		w, err = wire.NewValueString(*(v.WorkflowID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 12, Value: w}
		i++
	}
	if v.RunID != nil {
		w, err = wire.NewValueBinary(v.RunID), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 14, Value: w}
		i++
	}
	if v.TaskType != nil {
		w, err = wire.NewValueI16(*(v.TaskType)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 16, Value: w}
		i++
	}
	if v.TargetDomainID != nil {
		w, err = wire.NewValueBinary(v.TargetDomainID), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 18, Value: w}
		i++
	}
	if v.TargetWorkflowID != nil {
		w, err = wire.NewValueString(*(v.TargetWorkflowID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.TargetRunID != nil {
		w, err = wire.NewValueBinary(v.TargetRunID), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 22, Value: w}
		i++
	}
	if v.TaskList != nil {
		w, err = wire.NewValueString(*(v.TaskList)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 24, Value: w}
		i++
	}
	if v.TargetChildWorkflowOnly != nil {
		w, err = wire.NewValueBool(*(v.TargetChildWorkflowOnly)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 26, Value: w}
		i++
	}
	if v.ScheduleID != nil {
		w, err = wire.NewValueI64(*(v.ScheduleID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 28, Value: w}
		i++
	}
	if v.Version != nil {
		w, err = wire.NewValueI64(*(v.Version)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.VisibilityTimestampNanos != nil {
		w, err = wire.NewValueI64(*(v.VisibilityTimestampNanos)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 32, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a TransferTaskInfo struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a TransferTaskInfo struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v TransferTaskInfo
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *TransferTaskInfo) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				v.DomainID, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 12:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.WorkflowID = &x
				if err != nil {
					return err
				}

			}
		case 14:
			if field.Value.Type() == wire.TBinary {
				v.RunID, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 16:
			if field.Value.Type() == wire.TI16 {
				var x int16
				x, err = field.Value.GetI16(), error(nil)
				v.TaskType = &x
				if err != nil {
					return err
				}

			}
		case 18:
			if field.Value.Type() == wire.TBinary {
				v.TargetDomainID, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.TargetWorkflowID = &x
				if err != nil {
					return err
				}

			}
		case 22:
			if field.Value.Type() == wire.TBinary {
				v.TargetRunID, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 24:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.TaskList = &x
				if err != nil {
					return err
				}

			}
		case 26:
			if field.Value.Type() == wire.TBool {
				var x bool
				x, err = field.Value.GetBool(), error(nil)
				v.TargetChildWorkflowOnly = &x
				if err != nil {
					return err
				}

			}
		case 28:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.ScheduleID = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.Version = &x
				if err != nil {
					return err
				}

			}
		case 32:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.VisibilityTimestampNanos = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a TransferTaskInfo
// struct.
func (v *TransferTaskInfo) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [12]string
	i := 0
	if v.DomainID != nil {
		fields[i] = fmt.Sprintf("DomainID: %v", v.DomainID)
		i++
	}
	if v.WorkflowID != nil {
		fields[i] = fmt.Sprintf("WorkflowID: %v", *(v.WorkflowID))
		i++
	}
	if v.RunID != nil {
		fields[i] = fmt.Sprintf("RunID: %v", v.RunID)
		i++
	}
	if v.TaskType != nil {
		fields[i] = fmt.Sprintf("TaskType: %v", *(v.TaskType))
		i++
	}
	if v.TargetDomainID != nil {
		fields[i] = fmt.Sprintf("TargetDomainID: %v", v.TargetDomainID)
		i++
	}
	if v.TargetWorkflowID != nil {
		fields[i] = fmt.Sprintf("TargetWorkflowID: %v", *(v.TargetWorkflowID))
		i++
	}
	if v.TargetRunID != nil {
		fields[i] = fmt.Sprintf("TargetRunID: %v", v.TargetRunID)
		i++
	}
	if v.TaskList != nil {
		fields[i] = fmt.Sprintf("TaskList: %v", *(v.TaskList))
		i++
	}
	if v.TargetChildWorkflowOnly != nil {
		fields[i] = fmt.Sprintf("TargetChildWorkflowOnly: %v", *(v.TargetChildWorkflowOnly))
		i++
	}
	if v.ScheduleID != nil {
		fields[i] = fmt.Sprintf("ScheduleID: %v", *(v.ScheduleID))
		i++
	}
	if v.Version != nil {
		fields[i] = fmt.Sprintf("Version: %v", *(v.Version))
		i++
	}
	if v.VisibilityTimestampNanos != nil {
		fields[i] = fmt.Sprintf("VisibilityTimestampNanos: %v", *(v.VisibilityTimestampNanos))
		i++
	}

	return fmt.Sprintf("TransferTaskInfo{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this TransferTaskInfo match the
// provided TransferTaskInfo.
//
// This function performs a deep comparison.
func (v *TransferTaskInfo) Equals(rhs *TransferTaskInfo) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.DomainID == nil && rhs.DomainID == nil) || (v.DomainID != nil && rhs.DomainID != nil && bytes.Equal(v.DomainID, rhs.DomainID))) {
		return false
	}
	if !_String_EqualsPtr(v.WorkflowID, rhs.WorkflowID) {
		return false
	}
	if !((v.RunID == nil && rhs.RunID == nil) || (v.RunID != nil && rhs.RunID != nil && bytes.Equal(v.RunID, rhs.RunID))) {
		return false
	}
	if !_I16_EqualsPtr(v.TaskType, rhs.TaskType) {
		return false
	}
	if !((v.TargetDomainID == nil && rhs.TargetDomainID == nil) || (v.TargetDomainID != nil && rhs.TargetDomainID != nil && bytes.Equal(v.TargetDomainID, rhs.TargetDomainID))) {
		return false
	}
	if !_String_EqualsPtr(v.TargetWorkflowID, rhs.TargetWorkflowID) {
		return false
	}
	if !((v.TargetRunID == nil && rhs.TargetRunID == nil) || (v.TargetRunID != nil && rhs.TargetRunID != nil && bytes.Equal(v.TargetRunID, rhs.TargetRunID))) {
		return false
	}
	if !_String_EqualsPtr(v.TaskList, rhs.TaskList) {
		return false
	}
	if !_Bool_EqualsPtr(v.TargetChildWorkflowOnly, rhs.TargetChildWorkflowOnly) {
		return false
	}
	if !_I64_EqualsPtr(v.ScheduleID, rhs.ScheduleID) {
		return false
	}
	if !_I64_EqualsPtr(v.Version, rhs.Version) {
		return false
	}
	if !_I64_EqualsPtr(v.VisibilityTimestampNanos, rhs.VisibilityTimestampNanos) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of TransferTaskInfo.
func (v *TransferTaskInfo) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.DomainID != nil {
		enc.AddString("domainID", base64.StdEncoding.EncodeToString(v.DomainID))
	}
	if v.WorkflowID != nil {
		enc.AddString("workflowID", *v.WorkflowID)
	}
	if v.RunID != nil {
		enc.AddString("runID", base64.StdEncoding.EncodeToString(v.RunID))
	}
	if v.TaskType != nil {
		enc.AddInt16("taskType", *v.TaskType)
	}
	if v.TargetDomainID != nil {
		enc.AddString("targetDomainID", base64.StdEncoding.EncodeToString(v.TargetDomainID))
	}
	if v.TargetWorkflowID != nil {
		enc.AddString("targetWorkflowID", *v.TargetWorkflowID)
	}
	if v.TargetRunID != nil {
		enc.AddString("targetRunID", base64.StdEncoding.EncodeToString(v.TargetRunID))
	}
	if v.TaskList != nil {
		enc.AddString("taskList", *v.TaskList)
	}
	if v.TargetChildWorkflowOnly != nil {
		enc.AddBool("targetChildWorkflowOnly", *v.TargetChildWorkflowOnly)
	}
	if v.ScheduleID != nil {
		enc.AddInt64("scheduleID", *v.ScheduleID)
	}
	if v.Version != nil {
		enc.AddInt64("version", *v.Version)
	}
	if v.VisibilityTimestampNanos != nil {
		enc.AddInt64("visibilityTimestampNanos", *v.VisibilityTimestampNanos)
	}
	return err
}

// GetDomainID returns the value of DomainID if it is set or its
// zero value if it is unset.
func (v *TransferTaskInfo) GetDomainID() (o []byte) {
	if v != nil && v.DomainID != nil {
		return v.DomainID
	}

	return
}

// IsSetDomainID returns true if DomainID is not nil.
func (v *TransferTaskInfo) IsSetDomainID() bool {
	return v != nil && v.DomainID != nil
}

// GetWorkflowID returns the value of WorkflowID if it is set or its
// zero value if it is unset.
func (v *TransferTaskInfo) GetWorkflowID() (o string) {
	if v != nil && v.WorkflowID != nil {
		return *v.WorkflowID
	}

	return
}

// IsSetWorkflowID returns true if WorkflowID is not nil.
func (v *TransferTaskInfo) IsSetWorkflowID() bool {
	return v != nil && v.WorkflowID != nil
}

// GetRunID returns the value of RunID if it is set or its
// zero value if it is unset.
func (v *TransferTaskInfo) GetRunID() (o []byte) {
	if v != nil && v.RunID != nil {
		return v.RunID
	}

	return
}

// IsSetRunID returns true if RunID is not nil.
func (v *TransferTaskInfo) IsSetRunID() bool {
	return v != nil && v.RunID != nil
}

// GetTaskType returns the value of TaskType if it is set or its
// zero value if it is unset.
func (v *TransferTaskInfo) GetTaskType() (o int16) {
	if v != nil && v.TaskType != nil {
		return *v.TaskType
	}

	return
}

// IsSetTaskType returns true if TaskType is not nil.
func (v *TransferTaskInfo) IsSetTaskType() bool {
	return v != nil && v.TaskType != nil
}

// GetTargetDomainID returns the value of TargetDomainID if it is set or its
// zero value if it is unset.
func (v *TransferTaskInfo) GetTargetDomainID() (o []byte) {
	if v != nil && v.TargetDomainID != nil {
		return v.TargetDomainID
	}

	return
}

// IsSetTargetDomainID returns true if TargetDomainID is not nil.
func (v *TransferTaskInfo) IsSetTargetDomainID() bool {
	return v != nil && v.TargetDomainID != nil
}

// GetTargetWorkflowID returns the value of TargetWorkflowID if it is set or its
// zero value if it is unset.
func (v *TransferTaskInfo) GetTargetWorkflowID() (o string) {
	if v != nil && v.TargetWorkflowID != nil {
		return *v.TargetWorkflowID
	}

	return
}

// IsSetTargetWorkflowID returns true if TargetWorkflowID is not nil.
func (v *TransferTaskInfo) IsSetTargetWorkflowID() bool {
	return v != nil && v.TargetWorkflowID != nil
}

// GetTargetRunID returns the value of TargetRunID if it is set or its
// zero value if it is unset.
func (v *TransferTaskInfo) GetTargetRunID() (o []byte) {
	if v != nil && v.TargetRunID != nil {
		return v.TargetRunID
	}

	return
}

// IsSetTargetRunID returns true if TargetRunID is not nil.
func (v *TransferTaskInfo) IsSetTargetRunID() bool {
	return v != nil && v.TargetRunID != nil
}

// GetTaskList returns the value of TaskList if it is set or its
// zero value if it is unset.
func (v *TransferTaskInfo) GetTaskList() (o string) {
	if v != nil && v.TaskList != nil {
		return *v.TaskList
	}

	return
}

// IsSetTaskList returns true if TaskList is not nil.
func (v *TransferTaskInfo) IsSetTaskList() bool {
	return v != nil && v.TaskList != nil
}

// GetTargetChildWorkflowOnly returns the value of TargetChildWorkflowOnly if it is set or its
// zero value if it is unset.
func (v *TransferTaskInfo) GetTargetChildWorkflowOnly() (o bool) {
	if v != nil && v.TargetChildWorkflowOnly != nil {
		return *v.TargetChildWorkflowOnly
	}

	return
}

// IsSetTargetChildWorkflowOnly returns true if TargetChildWorkflowOnly is not nil.
func (v *TransferTaskInfo) IsSetTargetChildWorkflowOnly() bool {
	return v != nil && v.TargetChildWorkflowOnly != nil
}

// GetScheduleID returns the value of ScheduleID if it is set or its
// zero value if it is unset.
func (v *TransferTaskInfo) GetScheduleID() (o int64) {
	if v != nil && v.ScheduleID != nil {
		return *v.ScheduleID
	}

	return
}

// IsSetScheduleID returns true if ScheduleID is not nil.
func (v *TransferTaskInfo) IsSetScheduleID() bool {
	return v != nil && v.ScheduleID != nil
}

// GetVersion returns the value of Version if it is set or its
// zero value if it is unset.
func (v *TransferTaskInfo) GetVersion() (o int64) {
	if v != nil && v.Version != nil {
		return *v.Version
	}

	return
}

// IsSetVersion returns true if Version is not nil.
func (v *TransferTaskInfo) IsSetVersion() bool {
	return v != nil && v.Version != nil
}

// GetVisibilityTimestampNanos returns the value of VisibilityTimestampNanos if it is set or its
// zero value if it is unset.
func (v *TransferTaskInfo) GetVisibilityTimestampNanos() (o int64) {
	if v != nil && v.VisibilityTimestampNanos != nil {
		return *v.VisibilityTimestampNanos
	}

	return
}

// IsSetVisibilityTimestampNanos returns true if VisibilityTimestampNanos is not nil.
func (v *TransferTaskInfo) IsSetVisibilityTimestampNanos() bool {
	return v != nil && v.VisibilityTimestampNanos != nil
}

type WorkflowExecutionInfo struct {
	ParentDomainID               []byte                      `json:"parentDomainID,omitempty"`
	ParentWorkflowID             *string                     `json:"parentWorkflowID,omitempty"`
	ParentRunID                  []byte                      `json:"parentRunID,omitempty"`
	InitiatedID                  *int64                      `json:"initiatedID,omitempty"`
	CompletionEventBatchID       *int64                      `json:"completionEventBatchID,omitempty"`
	CompletionEvent              []byte                      `json:"completionEvent,omitempty"`
	CompletionEventEncoding      *string                     `json:"completionEventEncoding,omitempty"`
	TaskList                     *string                     `json:"taskList,omitempty"`
	WorkflowTypeName             *string                     `json:"workflowTypeName,omitempty"`
	WorkflowTimeoutSeconds       *int32                      `json:"workflowTimeoutSeconds,omitempty"`
	DecisionTaskTimeoutSeconds   *int32                      `json:"decisionTaskTimeoutSeconds,omitempty"`
	ExecutionContext             []byte                      `json:"executionContext,omitempty"`
	State                        *int32                      `json:"state,omitempty"`
	CloseStatus                  *int32                      `json:"closeStatus,omitempty"`
	StartVersion                 *int64                      `json:"startVersion,omitempty"`
	CurrentVersion               *int64                      `json:"currentVersion,omitempty"`
	LastWriteEventID             *int64                      `json:"lastWriteEventID,omitempty"`
	LastReplicationInfo          map[string]*ReplicationInfo `json:"lastReplicationInfo,omitempty"`
	LastEventTaskID              *int64                      `json:"lastEventTaskID,omitempty"`
	LastFirstEventID             *int64                      `json:"lastFirstEventID,omitempty"`
	LastProcessedEvent           *int64                      `json:"lastProcessedEvent,omitempty"`
	StartTimeNanos               *int64                      `json:"startTimeNanos,omitempty"`
	LastUpdatedTimeNanos         *int64                      `json:"lastUpdatedTimeNanos,omitempty"`
	DecisionVersion              *int64                      `json:"decisionVersion,omitempty"`
	DecisionScheduleID           *int64                      `json:"decisionScheduleID,omitempty"`
	DecisionStartedID            *int64                      `json:"decisionStartedID,omitempty"`
	DecisionTimeout              *int32                      `json:"decisionTimeout,omitempty"`
	DecisionAttempt              *int64                      `json:"decisionAttempt,omitempty"`
	DecisionTimestampNanos       *int64                      `json:"decisionTimestampNanos,omitempty"`
	CancelRequested              *bool                       `json:"cancelRequested,omitempty"`
	CreateRequestID              *string                     `json:"createRequestID,omitempty"`
	DecisionRequestID            *string                     `json:"decisionRequestID,omitempty"`
	CancelRequestID              *string                     `json:"cancelRequestID,omitempty"`
	StickyTaskList               *string                     `json:"stickyTaskList,omitempty"`
	StickyScheduleToStartTimeout *int64                      `json:"stickyScheduleToStartTimeout,omitempty"`
	RetryAttempt                 *int64                      `json:"retryAttempt,omitempty"`
	RetryInitialIntervalSeconds  *int32                      `json:"retryInitialIntervalSeconds,omitempty"`
	RetryMaximumIntervalSeconds  *int32                      `json:"retryMaximumIntervalSeconds,omitempty"`
	RetryMaximumAttempts         *int32                      `json:"retryMaximumAttempts,omitempty"`
	RetryExpirationSeconds       *int32                      `json:"retryExpirationSeconds,omitempty"`
	RetryBackoffCoefficient      *float64                    `json:"retryBackoffCoefficient,omitempty"`
	RetryExpirationTimeNanos     *int64                      `json:"retryExpirationTimeNanos,omitempty"`
	RetryNonRetryableErrors      []string                    `json:"retryNonRetryableErrors,omitempty"`
	HasRetryPolicy               *bool                       `json:"hasRetryPolicy,omitempty"`
	CronSchedule                 *string                     `json:"cronSchedule,omitempty"`
	EventStoreVersion            *int32                      `json:"eventStoreVersion,omitempty"`
	EventBranchToken             []byte                      `json:"eventBranchToken,omitempty"`
	SignalCount                  *int64                      `json:"signalCount,omitempty"`
	HistorySize                  *int64                      `json:"historySize,omitempty"`
	ClientLibraryVersion         *string                     `json:"clientLibraryVersion,omitempty"`
	ClientFeatureVersion         *string                     `json:"clientFeatureVersion,omitempty"`
	ClientImpl                   *string                     `json:"clientImpl,omitempty"`
	AutoResetPoints              []byte                      `json:"autoResetPoints,omitempty"`
	AutoResetPointsEncoding      *string                     `json:"autoResetPointsEncoding,omitempty"`
}

// ToWire translates a WorkflowExecutionInfo struct into a Thrift-level intermediate
// representation. This intermediate representation may be serialized
// into bytes using a ThriftRW protocol implementation.
//
// An error is returned if the struct or any of its fields failed to
// validate.
//
//   x, err := v.ToWire()
//   if err != nil {
//     return err
//   }
//
//   if err := binaryProtocol.Encode(x, writer); err != nil {
//     return err
//   }
func (v *WorkflowExecutionInfo) ToWire() (wire.Value, error) {
	var (
		fields [54]wire.Field
		i      int = 0
		w      wire.Value
		err    error
	)

	if v.ParentDomainID != nil {
		w, err = wire.NewValueBinary(v.ParentDomainID), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 10, Value: w}
		i++
	}
	if v.ParentWorkflowID != nil {
		w, err = wire.NewValueString(*(v.ParentWorkflowID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 12, Value: w}
		i++
	}
	if v.ParentRunID != nil {
		w, err = wire.NewValueBinary(v.ParentRunID), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 14, Value: w}
		i++
	}
	if v.InitiatedID != nil {
		w, err = wire.NewValueI64(*(v.InitiatedID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 16, Value: w}
		i++
	}
	if v.CompletionEventBatchID != nil {
		w, err = wire.NewValueI64(*(v.CompletionEventBatchID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 18, Value: w}
		i++
	}
	if v.CompletionEvent != nil {
		w, err = wire.NewValueBinary(v.CompletionEvent), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 20, Value: w}
		i++
	}
	if v.CompletionEventEncoding != nil {
		w, err = wire.NewValueString(*(v.CompletionEventEncoding)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 22, Value: w}
		i++
	}
	if v.TaskList != nil {
		w, err = wire.NewValueString(*(v.TaskList)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 24, Value: w}
		i++
	}
	if v.WorkflowTypeName != nil {
		w, err = wire.NewValueString(*(v.WorkflowTypeName)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 26, Value: w}
		i++
	}
	if v.WorkflowTimeoutSeconds != nil {
		w, err = wire.NewValueI32(*(v.WorkflowTimeoutSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 28, Value: w}
		i++
	}
	if v.DecisionTaskTimeoutSeconds != nil {
		w, err = wire.NewValueI32(*(v.DecisionTaskTimeoutSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 30, Value: w}
		i++
	}
	if v.ExecutionContext != nil {
		w, err = wire.NewValueBinary(v.ExecutionContext), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 32, Value: w}
		i++
	}
	if v.State != nil {
		w, err = wire.NewValueI32(*(v.State)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 34, Value: w}
		i++
	}
	if v.CloseStatus != nil {
		w, err = wire.NewValueI32(*(v.CloseStatus)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 36, Value: w}
		i++
	}
	if v.StartVersion != nil {
		w, err = wire.NewValueI64(*(v.StartVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 38, Value: w}
		i++
	}
	if v.CurrentVersion != nil {
		w, err = wire.NewValueI64(*(v.CurrentVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 40, Value: w}
		i++
	}
	if v.LastWriteEventID != nil {
		w, err = wire.NewValueI64(*(v.LastWriteEventID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 44, Value: w}
		i++
	}
	if v.LastReplicationInfo != nil {
		w, err = wire.NewValueMap(_Map_String_ReplicationInfo_MapItemList(v.LastReplicationInfo)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 46, Value: w}
		i++
	}
	if v.LastEventTaskID != nil {
		w, err = wire.NewValueI64(*(v.LastEventTaskID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 48, Value: w}
		i++
	}
	if v.LastFirstEventID != nil {
		w, err = wire.NewValueI64(*(v.LastFirstEventID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 50, Value: w}
		i++
	}
	if v.LastProcessedEvent != nil {
		w, err = wire.NewValueI64(*(v.LastProcessedEvent)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 52, Value: w}
		i++
	}
	if v.StartTimeNanos != nil {
		w, err = wire.NewValueI64(*(v.StartTimeNanos)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 54, Value: w}
		i++
	}
	if v.LastUpdatedTimeNanos != nil {
		w, err = wire.NewValueI64(*(v.LastUpdatedTimeNanos)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 56, Value: w}
		i++
	}
	if v.DecisionVersion != nil {
		w, err = wire.NewValueI64(*(v.DecisionVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 58, Value: w}
		i++
	}
	if v.DecisionScheduleID != nil {
		w, err = wire.NewValueI64(*(v.DecisionScheduleID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 60, Value: w}
		i++
	}
	if v.DecisionStartedID != nil {
		w, err = wire.NewValueI64(*(v.DecisionStartedID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 62, Value: w}
		i++
	}
	if v.DecisionTimeout != nil {
		w, err = wire.NewValueI32(*(v.DecisionTimeout)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 64, Value: w}
		i++
	}
	if v.DecisionAttempt != nil {
		w, err = wire.NewValueI64(*(v.DecisionAttempt)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 66, Value: w}
		i++
	}
	if v.DecisionTimestampNanos != nil {
		w, err = wire.NewValueI64(*(v.DecisionTimestampNanos)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 68, Value: w}
		i++
	}
	if v.CancelRequested != nil {
		w, err = wire.NewValueBool(*(v.CancelRequested)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 70, Value: w}
		i++
	}
	if v.CreateRequestID != nil {
		w, err = wire.NewValueString(*(v.CreateRequestID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 72, Value: w}
		i++
	}
	if v.DecisionRequestID != nil {
		w, err = wire.NewValueString(*(v.DecisionRequestID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 74, Value: w}
		i++
	}
	if v.CancelRequestID != nil {
		w, err = wire.NewValueString(*(v.CancelRequestID)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 76, Value: w}
		i++
	}
	if v.StickyTaskList != nil {
		w, err = wire.NewValueString(*(v.StickyTaskList)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 78, Value: w}
		i++
	}
	if v.StickyScheduleToStartTimeout != nil {
		w, err = wire.NewValueI64(*(v.StickyScheduleToStartTimeout)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 80, Value: w}
		i++
	}
	if v.RetryAttempt != nil {
		w, err = wire.NewValueI64(*(v.RetryAttempt)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 82, Value: w}
		i++
	}
	if v.RetryInitialIntervalSeconds != nil {
		w, err = wire.NewValueI32(*(v.RetryInitialIntervalSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 84, Value: w}
		i++
	}
	if v.RetryMaximumIntervalSeconds != nil {
		w, err = wire.NewValueI32(*(v.RetryMaximumIntervalSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 86, Value: w}
		i++
	}
	if v.RetryMaximumAttempts != nil {
		w, err = wire.NewValueI32(*(v.RetryMaximumAttempts)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 88, Value: w}
		i++
	}
	if v.RetryExpirationSeconds != nil {
		w, err = wire.NewValueI32(*(v.RetryExpirationSeconds)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 90, Value: w}
		i++
	}
	if v.RetryBackoffCoefficient != nil {
		w, err = wire.NewValueDouble(*(v.RetryBackoffCoefficient)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 92, Value: w}
		i++
	}
	if v.RetryExpirationTimeNanos != nil {
		w, err = wire.NewValueI64(*(v.RetryExpirationTimeNanos)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 94, Value: w}
		i++
	}
	if v.RetryNonRetryableErrors != nil {
		w, err = wire.NewValueList(_List_String_ValueList(v.RetryNonRetryableErrors)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 96, Value: w}
		i++
	}
	if v.HasRetryPolicy != nil {
		w, err = wire.NewValueBool(*(v.HasRetryPolicy)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 98, Value: w}
		i++
	}
	if v.CronSchedule != nil {
		w, err = wire.NewValueString(*(v.CronSchedule)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 100, Value: w}
		i++
	}
	if v.EventStoreVersion != nil {
		w, err = wire.NewValueI32(*(v.EventStoreVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 102, Value: w}
		i++
	}
	if v.EventBranchToken != nil {
		w, err = wire.NewValueBinary(v.EventBranchToken), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 104, Value: w}
		i++
	}
	if v.SignalCount != nil {
		w, err = wire.NewValueI64(*(v.SignalCount)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 106, Value: w}
		i++
	}
	if v.HistorySize != nil {
		w, err = wire.NewValueI64(*(v.HistorySize)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 108, Value: w}
		i++
	}
	if v.ClientLibraryVersion != nil {
		w, err = wire.NewValueString(*(v.ClientLibraryVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 110, Value: w}
		i++
	}
	if v.ClientFeatureVersion != nil {
		w, err = wire.NewValueString(*(v.ClientFeatureVersion)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 112, Value: w}
		i++
	}
	if v.ClientImpl != nil {
		w, err = wire.NewValueString(*(v.ClientImpl)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 114, Value: w}
		i++
	}
	if v.AutoResetPoints != nil {
		w, err = wire.NewValueBinary(v.AutoResetPoints), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 115, Value: w}
		i++
	}
	if v.AutoResetPointsEncoding != nil {
		w, err = wire.NewValueString(*(v.AutoResetPointsEncoding)), error(nil)
		if err != nil {
			return w, err
		}
		fields[i] = wire.Field{ID: 116, Value: w}
		i++
	}

	return wire.NewValueStruct(wire.Struct{Fields: fields[:i]}), nil
}

// FromWire deserializes a WorkflowExecutionInfo struct from its Thrift-level
// representation. The Thrift-level representation may be obtained
// from a ThriftRW protocol implementation.
//
// An error is returned if we were unable to build a WorkflowExecutionInfo struct
// from the provided intermediate representation.
//
//   x, err := binaryProtocol.Decode(reader, wire.TStruct)
//   if err != nil {
//     return nil, err
//   }
//
//   var v WorkflowExecutionInfo
//   if err := v.FromWire(x); err != nil {
//     return nil, err
//   }
//   return &v, nil
func (v *WorkflowExecutionInfo) FromWire(w wire.Value) error {
	var err error

	for _, field := range w.GetStruct().Fields {
		switch field.ID {
		case 10:
			if field.Value.Type() == wire.TBinary {
				v.ParentDomainID, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 12:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ParentWorkflowID = &x
				if err != nil {
					return err
				}

			}
		case 14:
			if field.Value.Type() == wire.TBinary {
				v.ParentRunID, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 16:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.InitiatedID = &x
				if err != nil {
					return err
				}

			}
		case 18:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.CompletionEventBatchID = &x
				if err != nil {
					return err
				}

			}
		case 20:
			if field.Value.Type() == wire.TBinary {
				v.CompletionEvent, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 22:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.CompletionEventEncoding = &x
				if err != nil {
					return err
				}

			}
		case 24:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.TaskList = &x
				if err != nil {
					return err
				}

			}
		case 26:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.WorkflowTypeName = &x
				if err != nil {
					return err
				}

			}
		case 28:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.WorkflowTimeoutSeconds = &x
				if err != nil {
					return err
				}

			}
		case 30:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.DecisionTaskTimeoutSeconds = &x
				if err != nil {
					return err
				}

			}
		case 32:
			if field.Value.Type() == wire.TBinary {
				v.ExecutionContext, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 34:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.State = &x
				if err != nil {
					return err
				}

			}
		case 36:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.CloseStatus = &x
				if err != nil {
					return err
				}

			}
		case 38:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StartVersion = &x
				if err != nil {
					return err
				}

			}
		case 40:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.CurrentVersion = &x
				if err != nil {
					return err
				}

			}
		case 44:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.LastWriteEventID = &x
				if err != nil {
					return err
				}

			}
		case 46:
			if field.Value.Type() == wire.TMap {
				v.LastReplicationInfo, err = _Map_String_ReplicationInfo_Read(field.Value.GetMap())
				if err != nil {
					return err
				}

			}
		case 48:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.LastEventTaskID = &x
				if err != nil {
					return err
				}

			}
		case 50:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.LastFirstEventID = &x
				if err != nil {
					return err
				}

			}
		case 52:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.LastProcessedEvent = &x
				if err != nil {
					return err
				}

			}
		case 54:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StartTimeNanos = &x
				if err != nil {
					return err
				}

			}
		case 56:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.LastUpdatedTimeNanos = &x
				if err != nil {
					return err
				}

			}
		case 58:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.DecisionVersion = &x
				if err != nil {
					return err
				}

			}
		case 60:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.DecisionScheduleID = &x
				if err != nil {
					return err
				}

			}
		case 62:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.DecisionStartedID = &x
				if err != nil {
					return err
				}

			}
		case 64:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.DecisionTimeout = &x
				if err != nil {
					return err
				}

			}
		case 66:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.DecisionAttempt = &x
				if err != nil {
					return err
				}

			}
		case 68:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.DecisionTimestampNanos = &x
				if err != nil {
					return err
				}

			}
		case 70:
			if field.Value.Type() == wire.TBool {
				var x bool
				x, err = field.Value.GetBool(), error(nil)
				v.CancelRequested = &x
				if err != nil {
					return err
				}

			}
		case 72:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.CreateRequestID = &x
				if err != nil {
					return err
				}

			}
		case 74:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.DecisionRequestID = &x
				if err != nil {
					return err
				}

			}
		case 76:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.CancelRequestID = &x
				if err != nil {
					return err
				}

			}
		case 78:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.StickyTaskList = &x
				if err != nil {
					return err
				}

			}
		case 80:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.StickyScheduleToStartTimeout = &x
				if err != nil {
					return err
				}

			}
		case 82:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.RetryAttempt = &x
				if err != nil {
					return err
				}

			}
		case 84:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.RetryInitialIntervalSeconds = &x
				if err != nil {
					return err
				}

			}
		case 86:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.RetryMaximumIntervalSeconds = &x
				if err != nil {
					return err
				}

			}
		case 88:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.RetryMaximumAttempts = &x
				if err != nil {
					return err
				}

			}
		case 90:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.RetryExpirationSeconds = &x
				if err != nil {
					return err
				}

			}
		case 92:
			if field.Value.Type() == wire.TDouble {
				var x float64
				x, err = field.Value.GetDouble(), error(nil)
				v.RetryBackoffCoefficient = &x
				if err != nil {
					return err
				}

			}
		case 94:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.RetryExpirationTimeNanos = &x
				if err != nil {
					return err
				}

			}
		case 96:
			if field.Value.Type() == wire.TList {
				v.RetryNonRetryableErrors, err = _List_String_Read(field.Value.GetList())
				if err != nil {
					return err
				}

			}
		case 98:
			if field.Value.Type() == wire.TBool {
				var x bool
				x, err = field.Value.GetBool(), error(nil)
				v.HasRetryPolicy = &x
				if err != nil {
					return err
				}

			}
		case 100:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.CronSchedule = &x
				if err != nil {
					return err
				}

			}
		case 102:
			if field.Value.Type() == wire.TI32 {
				var x int32
				x, err = field.Value.GetI32(), error(nil)
				v.EventStoreVersion = &x
				if err != nil {
					return err
				}

			}
		case 104:
			if field.Value.Type() == wire.TBinary {
				v.EventBranchToken, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 106:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.SignalCount = &x
				if err != nil {
					return err
				}

			}
		case 108:
			if field.Value.Type() == wire.TI64 {
				var x int64
				x, err = field.Value.GetI64(), error(nil)
				v.HistorySize = &x
				if err != nil {
					return err
				}

			}
		case 110:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ClientLibraryVersion = &x
				if err != nil {
					return err
				}

			}
		case 112:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ClientFeatureVersion = &x
				if err != nil {
					return err
				}

			}
		case 114:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.ClientImpl = &x
				if err != nil {
					return err
				}

			}
		case 115:
			if field.Value.Type() == wire.TBinary {
				v.AutoResetPoints, err = field.Value.GetBinary(), error(nil)
				if err != nil {
					return err
				}

			}
		case 116:
			if field.Value.Type() == wire.TBinary {
				var x string
				x, err = field.Value.GetString(), error(nil)
				v.AutoResetPointsEncoding = &x
				if err != nil {
					return err
				}

			}
		}
	}

	return nil
}

// String returns a readable string representation of a WorkflowExecutionInfo
// struct.
func (v *WorkflowExecutionInfo) String() string {
	if v == nil {
		return "<nil>"
	}

	var fields [54]string
	i := 0
	if v.ParentDomainID != nil {
		fields[i] = fmt.Sprintf("ParentDomainID: %v", v.ParentDomainID)
		i++
	}
	if v.ParentWorkflowID != nil {
		fields[i] = fmt.Sprintf("ParentWorkflowID: %v", *(v.ParentWorkflowID))
		i++
	}
	if v.ParentRunID != nil {
		fields[i] = fmt.Sprintf("ParentRunID: %v", v.ParentRunID)
		i++
	}
	if v.InitiatedID != nil {
		fields[i] = fmt.Sprintf("InitiatedID: %v", *(v.InitiatedID))
		i++
	}
	if v.CompletionEventBatchID != nil {
		fields[i] = fmt.Sprintf("CompletionEventBatchID: %v", *(v.CompletionEventBatchID))
		i++
	}
	if v.CompletionEvent != nil {
		fields[i] = fmt.Sprintf("CompletionEvent: %v", v.CompletionEvent)
		i++
	}
	if v.CompletionEventEncoding != nil {
		fields[i] = fmt.Sprintf("CompletionEventEncoding: %v", *(v.CompletionEventEncoding))
		i++
	}
	if v.TaskList != nil {
		fields[i] = fmt.Sprintf("TaskList: %v", *(v.TaskList))
		i++
	}
	if v.WorkflowTypeName != nil {
		fields[i] = fmt.Sprintf("WorkflowTypeName: %v", *(v.WorkflowTypeName))
		i++
	}
	if v.WorkflowTimeoutSeconds != nil {
		fields[i] = fmt.Sprintf("WorkflowTimeoutSeconds: %v", *(v.WorkflowTimeoutSeconds))
		i++
	}
	if v.DecisionTaskTimeoutSeconds != nil {
		fields[i] = fmt.Sprintf("DecisionTaskTimeoutSeconds: %v", *(v.DecisionTaskTimeoutSeconds))
		i++
	}
	if v.ExecutionContext != nil {
		fields[i] = fmt.Sprintf("ExecutionContext: %v", v.ExecutionContext)
		i++
	}
	if v.State != nil {
		fields[i] = fmt.Sprintf("State: %v", *(v.State))
		i++
	}
	if v.CloseStatus != nil {
		fields[i] = fmt.Sprintf("CloseStatus: %v", *(v.CloseStatus))
		i++
	}
	if v.StartVersion != nil {
		fields[i] = fmt.Sprintf("StartVersion: %v", *(v.StartVersion))
		i++
	}
	if v.CurrentVersion != nil {
		fields[i] = fmt.Sprintf("CurrentVersion: %v", *(v.CurrentVersion))
		i++
	}
	if v.LastWriteEventID != nil {
		fields[i] = fmt.Sprintf("LastWriteEventID: %v", *(v.LastWriteEventID))
		i++
	}
	if v.LastReplicationInfo != nil {
		fields[i] = fmt.Sprintf("LastReplicationInfo: %v", v.LastReplicationInfo)
		i++
	}
	if v.LastEventTaskID != nil {
		fields[i] = fmt.Sprintf("LastEventTaskID: %v", *(v.LastEventTaskID))
		i++
	}
	if v.LastFirstEventID != nil {
		fields[i] = fmt.Sprintf("LastFirstEventID: %v", *(v.LastFirstEventID))
		i++
	}
	if v.LastProcessedEvent != nil {
		fields[i] = fmt.Sprintf("LastProcessedEvent: %v", *(v.LastProcessedEvent))
		i++
	}
	if v.StartTimeNanos != nil {
		fields[i] = fmt.Sprintf("StartTimeNanos: %v", *(v.StartTimeNanos))
		i++
	}
	if v.LastUpdatedTimeNanos != nil {
		fields[i] = fmt.Sprintf("LastUpdatedTimeNanos: %v", *(v.LastUpdatedTimeNanos))
		i++
	}
	if v.DecisionVersion != nil {
		fields[i] = fmt.Sprintf("DecisionVersion: %v", *(v.DecisionVersion))
		i++
	}
	if v.DecisionScheduleID != nil {
		fields[i] = fmt.Sprintf("DecisionScheduleID: %v", *(v.DecisionScheduleID))
		i++
	}
	if v.DecisionStartedID != nil {
		fields[i] = fmt.Sprintf("DecisionStartedID: %v", *(v.DecisionStartedID))
		i++
	}
	if v.DecisionTimeout != nil {
		fields[i] = fmt.Sprintf("DecisionTimeout: %v", *(v.DecisionTimeout))
		i++
	}
	if v.DecisionAttempt != nil {
		fields[i] = fmt.Sprintf("DecisionAttempt: %v", *(v.DecisionAttempt))
		i++
	}
	if v.DecisionTimestampNanos != nil {
		fields[i] = fmt.Sprintf("DecisionTimestampNanos: %v", *(v.DecisionTimestampNanos))
		i++
	}
	if v.CancelRequested != nil {
		fields[i] = fmt.Sprintf("CancelRequested: %v", *(v.CancelRequested))
		i++
	}
	if v.CreateRequestID != nil {
		fields[i] = fmt.Sprintf("CreateRequestID: %v", *(v.CreateRequestID))
		i++
	}
	if v.DecisionRequestID != nil {
		fields[i] = fmt.Sprintf("DecisionRequestID: %v", *(v.DecisionRequestID))
		i++
	}
	if v.CancelRequestID != nil {
		fields[i] = fmt.Sprintf("CancelRequestID: %v", *(v.CancelRequestID))
		i++
	}
	if v.StickyTaskList != nil {
		fields[i] = fmt.Sprintf("StickyTaskList: %v", *(v.StickyTaskList))
		i++
	}
	if v.StickyScheduleToStartTimeout != nil {
		fields[i] = fmt.Sprintf("StickyScheduleToStartTimeout: %v", *(v.StickyScheduleToStartTimeout))
		i++
	}
	if v.RetryAttempt != nil {
		fields[i] = fmt.Sprintf("RetryAttempt: %v", *(v.RetryAttempt))
		i++
	}
	if v.RetryInitialIntervalSeconds != nil {
		fields[i] = fmt.Sprintf("RetryInitialIntervalSeconds: %v", *(v.RetryInitialIntervalSeconds))
		i++
	}
	if v.RetryMaximumIntervalSeconds != nil {
		fields[i] = fmt.Sprintf("RetryMaximumIntervalSeconds: %v", *(v.RetryMaximumIntervalSeconds))
		i++
	}
	if v.RetryMaximumAttempts != nil {
		fields[i] = fmt.Sprintf("RetryMaximumAttempts: %v", *(v.RetryMaximumAttempts))
		i++
	}
	if v.RetryExpirationSeconds != nil {
		fields[i] = fmt.Sprintf("RetryExpirationSeconds: %v", *(v.RetryExpirationSeconds))
		i++
	}
	if v.RetryBackoffCoefficient != nil {
		fields[i] = fmt.Sprintf("RetryBackoffCoefficient: %v", *(v.RetryBackoffCoefficient))
		i++
	}
	if v.RetryExpirationTimeNanos != nil {
		fields[i] = fmt.Sprintf("RetryExpirationTimeNanos: %v", *(v.RetryExpirationTimeNanos))
		i++
	}
	if v.RetryNonRetryableErrors != nil {
		fields[i] = fmt.Sprintf("RetryNonRetryableErrors: %v", v.RetryNonRetryableErrors)
		i++
	}
	if v.HasRetryPolicy != nil {
		fields[i] = fmt.Sprintf("HasRetryPolicy: %v", *(v.HasRetryPolicy))
		i++
	}
	if v.CronSchedule != nil {
		fields[i] = fmt.Sprintf("CronSchedule: %v", *(v.CronSchedule))
		i++
	}
	if v.EventStoreVersion != nil {
		fields[i] = fmt.Sprintf("EventStoreVersion: %v", *(v.EventStoreVersion))
		i++
	}
	if v.EventBranchToken != nil {
		fields[i] = fmt.Sprintf("EventBranchToken: %v", v.EventBranchToken)
		i++
	}
	if v.SignalCount != nil {
		fields[i] = fmt.Sprintf("SignalCount: %v", *(v.SignalCount))
		i++
	}
	if v.HistorySize != nil {
		fields[i] = fmt.Sprintf("HistorySize: %v", *(v.HistorySize))
		i++
	}
	if v.ClientLibraryVersion != nil {
		fields[i] = fmt.Sprintf("ClientLibraryVersion: %v", *(v.ClientLibraryVersion))
		i++
	}
	if v.ClientFeatureVersion != nil {
		fields[i] = fmt.Sprintf("ClientFeatureVersion: %v", *(v.ClientFeatureVersion))
		i++
	}
	if v.ClientImpl != nil {
		fields[i] = fmt.Sprintf("ClientImpl: %v", *(v.ClientImpl))
		i++
	}
	if v.AutoResetPoints != nil {
		fields[i] = fmt.Sprintf("AutoResetPoints: %v", v.AutoResetPoints)
		i++
	}
	if v.AutoResetPointsEncoding != nil {
		fields[i] = fmt.Sprintf("AutoResetPointsEncoding: %v", *(v.AutoResetPointsEncoding))
		i++
	}

	return fmt.Sprintf("WorkflowExecutionInfo{%v}", strings.Join(fields[:i], ", "))
}

// Equals returns true if all the fields of this WorkflowExecutionInfo match the
// provided WorkflowExecutionInfo.
//
// This function performs a deep comparison.
func (v *WorkflowExecutionInfo) Equals(rhs *WorkflowExecutionInfo) bool {
	if v == nil {
		return rhs == nil
	} else if rhs == nil {
		return false
	}
	if !((v.ParentDomainID == nil && rhs.ParentDomainID == nil) || (v.ParentDomainID != nil && rhs.ParentDomainID != nil && bytes.Equal(v.ParentDomainID, rhs.ParentDomainID))) {
		return false
	}
	if !_String_EqualsPtr(v.ParentWorkflowID, rhs.ParentWorkflowID) {
		return false
	}
	if !((v.ParentRunID == nil && rhs.ParentRunID == nil) || (v.ParentRunID != nil && rhs.ParentRunID != nil && bytes.Equal(v.ParentRunID, rhs.ParentRunID))) {
		return false
	}
	if !_I64_EqualsPtr(v.InitiatedID, rhs.InitiatedID) {
		return false
	}
	if !_I64_EqualsPtr(v.CompletionEventBatchID, rhs.CompletionEventBatchID) {
		return false
	}
	if !((v.CompletionEvent == nil && rhs.CompletionEvent == nil) || (v.CompletionEvent != nil && rhs.CompletionEvent != nil && bytes.Equal(v.CompletionEvent, rhs.CompletionEvent))) {
		return false
	}
	if !_String_EqualsPtr(v.CompletionEventEncoding, rhs.CompletionEventEncoding) {
		return false
	}
	if !_String_EqualsPtr(v.TaskList, rhs.TaskList) {
		return false
	}
	if !_String_EqualsPtr(v.WorkflowTypeName, rhs.WorkflowTypeName) {
		return false
	}
	if !_I32_EqualsPtr(v.WorkflowTimeoutSeconds, rhs.WorkflowTimeoutSeconds) {
		return false
	}
	if !_I32_EqualsPtr(v.DecisionTaskTimeoutSeconds, rhs.DecisionTaskTimeoutSeconds) {
		return false
	}
	if !((v.ExecutionContext == nil && rhs.ExecutionContext == nil) || (v.ExecutionContext != nil && rhs.ExecutionContext != nil && bytes.Equal(v.ExecutionContext, rhs.ExecutionContext))) {
		return false
	}
	if !_I32_EqualsPtr(v.State, rhs.State) {
		return false
	}
	if !_I32_EqualsPtr(v.CloseStatus, rhs.CloseStatus) {
		return false
	}
	if !_I64_EqualsPtr(v.StartVersion, rhs.StartVersion) {
		return false
	}
	if !_I64_EqualsPtr(v.CurrentVersion, rhs.CurrentVersion) {
		return false
	}
	if !_I64_EqualsPtr(v.LastWriteEventID, rhs.LastWriteEventID) {
		return false
	}
	if !((v.LastReplicationInfo == nil && rhs.LastReplicationInfo == nil) || (v.LastReplicationInfo != nil && rhs.LastReplicationInfo != nil && _Map_String_ReplicationInfo_Equals(v.LastReplicationInfo, rhs.LastReplicationInfo))) {
		return false
	}
	if !_I64_EqualsPtr(v.LastEventTaskID, rhs.LastEventTaskID) {
		return false
	}
	if !_I64_EqualsPtr(v.LastFirstEventID, rhs.LastFirstEventID) {
		return false
	}
	if !_I64_EqualsPtr(v.LastProcessedEvent, rhs.LastProcessedEvent) {
		return false
	}
	if !_I64_EqualsPtr(v.StartTimeNanos, rhs.StartTimeNanos) {
		return false
	}
	if !_I64_EqualsPtr(v.LastUpdatedTimeNanos, rhs.LastUpdatedTimeNanos) {
		return false
	}
	if !_I64_EqualsPtr(v.DecisionVersion, rhs.DecisionVersion) {
		return false
	}
	if !_I64_EqualsPtr(v.DecisionScheduleID, rhs.DecisionScheduleID) {
		return false
	}
	if !_I64_EqualsPtr(v.DecisionStartedID, rhs.DecisionStartedID) {
		return false
	}
	if !_I32_EqualsPtr(v.DecisionTimeout, rhs.DecisionTimeout) {
		return false
	}
	if !_I64_EqualsPtr(v.DecisionAttempt, rhs.DecisionAttempt) {
		return false
	}
	if !_I64_EqualsPtr(v.DecisionTimestampNanos, rhs.DecisionTimestampNanos) {
		return false
	}
	if !_Bool_EqualsPtr(v.CancelRequested, rhs.CancelRequested) {
		return false
	}
	if !_String_EqualsPtr(v.CreateRequestID, rhs.CreateRequestID) {
		return false
	}
	if !_String_EqualsPtr(v.DecisionRequestID, rhs.DecisionRequestID) {
		return false
	}
	if !_String_EqualsPtr(v.CancelRequestID, rhs.CancelRequestID) {
		return false
	}
	if !_String_EqualsPtr(v.StickyTaskList, rhs.StickyTaskList) {
		return false
	}
	if !_I64_EqualsPtr(v.StickyScheduleToStartTimeout, rhs.StickyScheduleToStartTimeout) {
		return false
	}
	if !_I64_EqualsPtr(v.RetryAttempt, rhs.RetryAttempt) {
		return false
	}
	if !_I32_EqualsPtr(v.RetryInitialIntervalSeconds, rhs.RetryInitialIntervalSeconds) {
		return false
	}
	if !_I32_EqualsPtr(v.RetryMaximumIntervalSeconds, rhs.RetryMaximumIntervalSeconds) {
		return false
	}
	if !_I32_EqualsPtr(v.RetryMaximumAttempts, rhs.RetryMaximumAttempts) {
		return false
	}
	if !_I32_EqualsPtr(v.RetryExpirationSeconds, rhs.RetryExpirationSeconds) {
		return false
	}
	if !_Double_EqualsPtr(v.RetryBackoffCoefficient, rhs.RetryBackoffCoefficient) {
		return false
	}
	if !_I64_EqualsPtr(v.RetryExpirationTimeNanos, rhs.RetryExpirationTimeNanos) {
		return false
	}
	if !((v.RetryNonRetryableErrors == nil && rhs.RetryNonRetryableErrors == nil) || (v.RetryNonRetryableErrors != nil && rhs.RetryNonRetryableErrors != nil && _List_String_Equals(v.RetryNonRetryableErrors, rhs.RetryNonRetryableErrors))) {
		return false
	}
	if !_Bool_EqualsPtr(v.HasRetryPolicy, rhs.HasRetryPolicy) {
		return false
	}
	if !_String_EqualsPtr(v.CronSchedule, rhs.CronSchedule) {
		return false
	}
	if !_I32_EqualsPtr(v.EventStoreVersion, rhs.EventStoreVersion) {
		return false
	}
	if !((v.EventBranchToken == nil && rhs.EventBranchToken == nil) || (v.EventBranchToken != nil && rhs.EventBranchToken != nil && bytes.Equal(v.EventBranchToken, rhs.EventBranchToken))) {
		return false
	}
	if !_I64_EqualsPtr(v.SignalCount, rhs.SignalCount) {
		return false
	}
	if !_I64_EqualsPtr(v.HistorySize, rhs.HistorySize) {
		return false
	}
	if !_String_EqualsPtr(v.ClientLibraryVersion, rhs.ClientLibraryVersion) {
		return false
	}
	if !_String_EqualsPtr(v.ClientFeatureVersion, rhs.ClientFeatureVersion) {
		return false
	}
	if !_String_EqualsPtr(v.ClientImpl, rhs.ClientImpl) {
		return false
	}
	if !((v.AutoResetPoints == nil && rhs.AutoResetPoints == nil) || (v.AutoResetPoints != nil && rhs.AutoResetPoints != nil && bytes.Equal(v.AutoResetPoints, rhs.AutoResetPoints))) {
		return false
	}
	if !_String_EqualsPtr(v.AutoResetPointsEncoding, rhs.AutoResetPointsEncoding) {
		return false
	}

	return true
}

// MarshalLogObject implements zapcore.ObjectMarshaler, enabling
// fast logging of WorkflowExecutionInfo.
func (v *WorkflowExecutionInfo) MarshalLogObject(enc zapcore.ObjectEncoder) (err error) {
	if v == nil {
		return nil
	}
	if v.ParentDomainID != nil {
		enc.AddString("parentDomainID", base64.StdEncoding.EncodeToString(v.ParentDomainID))
	}
	if v.ParentWorkflowID != nil {
		enc.AddString("parentWorkflowID", *v.ParentWorkflowID)
	}
	if v.ParentRunID != nil {
		enc.AddString("parentRunID", base64.StdEncoding.EncodeToString(v.ParentRunID))
	}
	if v.InitiatedID != nil {
		enc.AddInt64("initiatedID", *v.InitiatedID)
	}
	if v.CompletionEventBatchID != nil {
		enc.AddInt64("completionEventBatchID", *v.CompletionEventBatchID)
	}
	if v.CompletionEvent != nil {
		enc.AddString("completionEvent", base64.StdEncoding.EncodeToString(v.CompletionEvent))
	}
	if v.CompletionEventEncoding != nil {
		enc.AddString("completionEventEncoding", *v.CompletionEventEncoding)
	}
	if v.TaskList != nil {
		enc.AddString("taskList", *v.TaskList)
	}
	if v.WorkflowTypeName != nil {
		enc.AddString("workflowTypeName", *v.WorkflowTypeName)
	}
	if v.WorkflowTimeoutSeconds != nil {
		enc.AddInt32("workflowTimeoutSeconds", *v.WorkflowTimeoutSeconds)
	}
	if v.DecisionTaskTimeoutSeconds != nil {
		enc.AddInt32("decisionTaskTimeoutSeconds", *v.DecisionTaskTimeoutSeconds)
	}
	if v.ExecutionContext != nil {
		enc.AddString("executionContext", base64.StdEncoding.EncodeToString(v.ExecutionContext))
	}
	if v.State != nil {
		enc.AddInt32("state", *v.State)
	}
	if v.CloseStatus != nil {
		enc.AddInt32("closeStatus", *v.CloseStatus)
	}
	if v.StartVersion != nil {
		enc.AddInt64("startVersion", *v.StartVersion)
	}
	if v.CurrentVersion != nil {
		enc.AddInt64("currentVersion", *v.CurrentVersion)
	}
	if v.LastWriteEventID != nil {
		enc.AddInt64("lastWriteEventID", *v.LastWriteEventID)
	}
	if v.LastReplicationInfo != nil {
		err = multierr.Append(err, enc.AddObject("lastReplicationInfo", (_Map_String_ReplicationInfo_Zapper)(v.LastReplicationInfo)))
	}
	if v.LastEventTaskID != nil {
		enc.AddInt64("lastEventTaskID", *v.LastEventTaskID)
	}
	if v.LastFirstEventID != nil {
		enc.AddInt64("lastFirstEventID", *v.LastFirstEventID)
	}
	if v.LastProcessedEvent != nil {
		enc.AddInt64("lastProcessedEvent", *v.LastProcessedEvent)
	}
	if v.StartTimeNanos != nil {
		enc.AddInt64("startTimeNanos", *v.StartTimeNanos)
	}
	if v.LastUpdatedTimeNanos != nil {
		enc.AddInt64("lastUpdatedTimeNanos", *v.LastUpdatedTimeNanos)
	}
	if v.DecisionVersion != nil {
		enc.AddInt64("decisionVersion", *v.DecisionVersion)
	}
	if v.DecisionScheduleID != nil {
		enc.AddInt64("decisionScheduleID", *v.DecisionScheduleID)
	}
	if v.DecisionStartedID != nil {
		enc.AddInt64("decisionStartedID", *v.DecisionStartedID)
	}
	if v.DecisionTimeout != nil {
		enc.AddInt32("decisionTimeout", *v.DecisionTimeout)
	}
	if v.DecisionAttempt != nil {
		enc.AddInt64("decisionAttempt", *v.DecisionAttempt)
	}
	if v.DecisionTimestampNanos != nil {
		enc.AddInt64("decisionTimestampNanos", *v.DecisionTimestampNanos)
	}
	if v.CancelRequested != nil {
		enc.AddBool("cancelRequested", *v.CancelRequested)
	}
	if v.CreateRequestID != nil {
		enc.AddString("createRequestID", *v.CreateRequestID)
	}
	if v.DecisionRequestID != nil {
		enc.AddString("decisionRequestID", *v.DecisionRequestID)
	}
	if v.CancelRequestID != nil {
		enc.AddString("cancelRequestID", *v.CancelRequestID)
	}
	if v.StickyTaskList != nil {
		enc.AddString("stickyTaskList", *v.StickyTaskList)
	}
	if v.StickyScheduleToStartTimeout != nil {
		enc.AddInt64("stickyScheduleToStartTimeout", *v.StickyScheduleToStartTimeout)
	}
	if v.RetryAttempt != nil {
		enc.AddInt64("retryAttempt", *v.RetryAttempt)
	}
	if v.RetryInitialIntervalSeconds != nil {
		enc.AddInt32("retryInitialIntervalSeconds", *v.RetryInitialIntervalSeconds)
	}
	if v.RetryMaximumIntervalSeconds != nil {
		enc.AddInt32("retryMaximumIntervalSeconds", *v.RetryMaximumIntervalSeconds)
	}
	if v.RetryMaximumAttempts != nil {
		enc.AddInt32("retryMaximumAttempts", *v.RetryMaximumAttempts)
	}
	if v.RetryExpirationSeconds != nil {
		enc.AddInt32("retryExpirationSeconds", *v.RetryExpirationSeconds)
	}
	if v.RetryBackoffCoefficient != nil {
		enc.AddFloat64("retryBackoffCoefficient", *v.RetryBackoffCoefficient)
	}
	if v.RetryExpirationTimeNanos != nil {
		enc.AddInt64("retryExpirationTimeNanos", *v.RetryExpirationTimeNanos)
	}
	if v.RetryNonRetryableErrors != nil {
		err = multierr.Append(err, enc.AddArray("retryNonRetryableErrors", (_List_String_Zapper)(v.RetryNonRetryableErrors)))
	}
	if v.HasRetryPolicy != nil {
		enc.AddBool("hasRetryPolicy", *v.HasRetryPolicy)
	}
	if v.CronSchedule != nil {
		enc.AddString("cronSchedule", *v.CronSchedule)
	}
	if v.EventStoreVersion != nil {
		enc.AddInt32("eventStoreVersion", *v.EventStoreVersion)
	}
	if v.EventBranchToken != nil {
		enc.AddString("eventBranchToken", base64.StdEncoding.EncodeToString(v.EventBranchToken))
	}
	if v.SignalCount != nil {
		enc.AddInt64("signalCount", *v.SignalCount)
	}
	if v.HistorySize != nil {
		enc.AddInt64("historySize", *v.HistorySize)
	}
	if v.ClientLibraryVersion != nil {
		enc.AddString("clientLibraryVersion", *v.ClientLibraryVersion)
	}
	if v.ClientFeatureVersion != nil {
		enc.AddString("clientFeatureVersion", *v.ClientFeatureVersion)
	}
	if v.ClientImpl != nil {
		enc.AddString("clientImpl", *v.ClientImpl)
	}
	if v.AutoResetPoints != nil {
		enc.AddString("autoResetPoints", base64.StdEncoding.EncodeToString(v.AutoResetPoints))
	}
	if v.AutoResetPointsEncoding != nil {
		enc.AddString("autoResetPointsEncoding", *v.AutoResetPointsEncoding)
	}
	return err
}

// GetParentDomainID returns the value of ParentDomainID if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetParentDomainID() (o []byte) {
	if v != nil && v.ParentDomainID != nil {
		return v.ParentDomainID
	}

	return
}

// IsSetParentDomainID returns true if ParentDomainID is not nil.
func (v *WorkflowExecutionInfo) IsSetParentDomainID() bool {
	return v != nil && v.ParentDomainID != nil
}

// GetParentWorkflowID returns the value of ParentWorkflowID if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetParentWorkflowID() (o string) {
	if v != nil && v.ParentWorkflowID != nil {
		return *v.ParentWorkflowID
	}

	return
}

// IsSetParentWorkflowID returns true if ParentWorkflowID is not nil.
func (v *WorkflowExecutionInfo) IsSetParentWorkflowID() bool {
	return v != nil && v.ParentWorkflowID != nil
}

// GetParentRunID returns the value of ParentRunID if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetParentRunID() (o []byte) {
	if v != nil && v.ParentRunID != nil {
		return v.ParentRunID
	}

	return
}

// IsSetParentRunID returns true if ParentRunID is not nil.
func (v *WorkflowExecutionInfo) IsSetParentRunID() bool {
	return v != nil && v.ParentRunID != nil
}

// GetInitiatedID returns the value of InitiatedID if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetInitiatedID() (o int64) {
	if v != nil && v.InitiatedID != nil {
		return *v.InitiatedID
	}

	return
}

// IsSetInitiatedID returns true if InitiatedID is not nil.
func (v *WorkflowExecutionInfo) IsSetInitiatedID() bool {
	return v != nil && v.InitiatedID != nil
}

// GetCompletionEventBatchID returns the value of CompletionEventBatchID if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetCompletionEventBatchID() (o int64) {
	if v != nil && v.CompletionEventBatchID != nil {
		return *v.CompletionEventBatchID
	}

	return
}

// IsSetCompletionEventBatchID returns true if CompletionEventBatchID is not nil.
func (v *WorkflowExecutionInfo) IsSetCompletionEventBatchID() bool {
	return v != nil && v.CompletionEventBatchID != nil
}

// GetCompletionEvent returns the value of CompletionEvent if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetCompletionEvent() (o []byte) {
	if v != nil && v.CompletionEvent != nil {
		return v.CompletionEvent
	}

	return
}

// IsSetCompletionEvent returns true if CompletionEvent is not nil.
func (v *WorkflowExecutionInfo) IsSetCompletionEvent() bool {
	return v != nil && v.CompletionEvent != nil
}

// GetCompletionEventEncoding returns the value of CompletionEventEncoding if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetCompletionEventEncoding() (o string) {
	if v != nil && v.CompletionEventEncoding != nil {
		return *v.CompletionEventEncoding
	}

	return
}

// IsSetCompletionEventEncoding returns true if CompletionEventEncoding is not nil.
func (v *WorkflowExecutionInfo) IsSetCompletionEventEncoding() bool {
	return v != nil && v.CompletionEventEncoding != nil
}

// GetTaskList returns the value of TaskList if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetTaskList() (o string) {
	if v != nil && v.TaskList != nil {
		return *v.TaskList
	}

	return
}

// IsSetTaskList returns true if TaskList is not nil.
func (v *WorkflowExecutionInfo) IsSetTaskList() bool {
	return v != nil && v.TaskList != nil
}

// GetWorkflowTypeName returns the value of WorkflowTypeName if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetWorkflowTypeName() (o string) {
	if v != nil && v.WorkflowTypeName != nil {
		return *v.WorkflowTypeName
	}

	return
}

// IsSetWorkflowTypeName returns true if WorkflowTypeName is not nil.
func (v *WorkflowExecutionInfo) IsSetWorkflowTypeName() bool {
	return v != nil && v.WorkflowTypeName != nil
}

// GetWorkflowTimeoutSeconds returns the value of WorkflowTimeoutSeconds if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetWorkflowTimeoutSeconds() (o int32) {
	if v != nil && v.WorkflowTimeoutSeconds != nil {
		return *v.WorkflowTimeoutSeconds
	}

	return
}

// IsSetWorkflowTimeoutSeconds returns true if WorkflowTimeoutSeconds is not nil.
func (v *WorkflowExecutionInfo) IsSetWorkflowTimeoutSeconds() bool {
	return v != nil && v.WorkflowTimeoutSeconds != nil
}

// GetDecisionTaskTimeoutSeconds returns the value of DecisionTaskTimeoutSeconds if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetDecisionTaskTimeoutSeconds() (o int32) {
	if v != nil && v.DecisionTaskTimeoutSeconds != nil {
		return *v.DecisionTaskTimeoutSeconds
	}

	return
}

// IsSetDecisionTaskTimeoutSeconds returns true if DecisionTaskTimeoutSeconds is not nil.
func (v *WorkflowExecutionInfo) IsSetDecisionTaskTimeoutSeconds() bool {
	return v != nil && v.DecisionTaskTimeoutSeconds != nil
}

// GetExecutionContext returns the value of ExecutionContext if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetExecutionContext() (o []byte) {
	if v != nil && v.ExecutionContext != nil {
		return v.ExecutionContext
	}

	return
}

// IsSetExecutionContext returns true if ExecutionContext is not nil.
func (v *WorkflowExecutionInfo) IsSetExecutionContext() bool {
	return v != nil && v.ExecutionContext != nil
}

// GetState returns the value of State if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetState() (o int32) {
	if v != nil && v.State != nil {
		return *v.State
	}

	return
}

// IsSetState returns true if State is not nil.
func (v *WorkflowExecutionInfo) IsSetState() bool {
	return v != nil && v.State != nil
}

// GetCloseStatus returns the value of CloseStatus if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetCloseStatus() (o int32) {
	if v != nil && v.CloseStatus != nil {
		return *v.CloseStatus
	}

	return
}

// IsSetCloseStatus returns true if CloseStatus is not nil.
func (v *WorkflowExecutionInfo) IsSetCloseStatus() bool {
	return v != nil && v.CloseStatus != nil
}

// GetStartVersion returns the value of StartVersion if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetStartVersion() (o int64) {
	if v != nil && v.StartVersion != nil {
		return *v.StartVersion
	}

	return
}

// IsSetStartVersion returns true if StartVersion is not nil.
func (v *WorkflowExecutionInfo) IsSetStartVersion() bool {
	return v != nil && v.StartVersion != nil
}

// GetCurrentVersion returns the value of CurrentVersion if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetCurrentVersion() (o int64) {
	if v != nil && v.CurrentVersion != nil {
		return *v.CurrentVersion
	}

	return
}

// IsSetCurrentVersion returns true if CurrentVersion is not nil.
func (v *WorkflowExecutionInfo) IsSetCurrentVersion() bool {
	return v != nil && v.CurrentVersion != nil
}

// GetLastWriteEventID returns the value of LastWriteEventID if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetLastWriteEventID() (o int64) {
	if v != nil && v.LastWriteEventID != nil {
		return *v.LastWriteEventID
	}

	return
}

// IsSetLastWriteEventID returns true if LastWriteEventID is not nil.
func (v *WorkflowExecutionInfo) IsSetLastWriteEventID() bool {
	return v != nil && v.LastWriteEventID != nil
}

// GetLastReplicationInfo returns the value of LastReplicationInfo if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetLastReplicationInfo() (o map[string]*ReplicationInfo) {
	if v != nil && v.LastReplicationInfo != nil {
		return v.LastReplicationInfo
	}

	return
}

// IsSetLastReplicationInfo returns true if LastReplicationInfo is not nil.
func (v *WorkflowExecutionInfo) IsSetLastReplicationInfo() bool {
	return v != nil && v.LastReplicationInfo != nil
}

// GetLastEventTaskID returns the value of LastEventTaskID if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetLastEventTaskID() (o int64) {
	if v != nil && v.LastEventTaskID != nil {
		return *v.LastEventTaskID
	}

	return
}

// IsSetLastEventTaskID returns true if LastEventTaskID is not nil.
func (v *WorkflowExecutionInfo) IsSetLastEventTaskID() bool {
	return v != nil && v.LastEventTaskID != nil
}

// GetLastFirstEventID returns the value of LastFirstEventID if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetLastFirstEventID() (o int64) {
	if v != nil && v.LastFirstEventID != nil {
		return *v.LastFirstEventID
	}

	return
}

// IsSetLastFirstEventID returns true if LastFirstEventID is not nil.
func (v *WorkflowExecutionInfo) IsSetLastFirstEventID() bool {
	return v != nil && v.LastFirstEventID != nil
}

// GetLastProcessedEvent returns the value of LastProcessedEvent if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetLastProcessedEvent() (o int64) {
	if v != nil && v.LastProcessedEvent != nil {
		return *v.LastProcessedEvent
	}

	return
}

// IsSetLastProcessedEvent returns true if LastProcessedEvent is not nil.
func (v *WorkflowExecutionInfo) IsSetLastProcessedEvent() bool {
	return v != nil && v.LastProcessedEvent != nil
}

// GetStartTimeNanos returns the value of StartTimeNanos if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetStartTimeNanos() (o int64) {
	if v != nil && v.StartTimeNanos != nil {
		return *v.StartTimeNanos
	}

	return
}

// IsSetStartTimeNanos returns true if StartTimeNanos is not nil.
func (v *WorkflowExecutionInfo) IsSetStartTimeNanos() bool {
	return v != nil && v.StartTimeNanos != nil
}

// GetLastUpdatedTimeNanos returns the value of LastUpdatedTimeNanos if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetLastUpdatedTimeNanos() (o int64) {
	if v != nil && v.LastUpdatedTimeNanos != nil {
		return *v.LastUpdatedTimeNanos
	}

	return
}

// IsSetLastUpdatedTimeNanos returns true if LastUpdatedTimeNanos is not nil.
func (v *WorkflowExecutionInfo) IsSetLastUpdatedTimeNanos() bool {
	return v != nil && v.LastUpdatedTimeNanos != nil
}

// GetDecisionVersion returns the value of DecisionVersion if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetDecisionVersion() (o int64) {
	if v != nil && v.DecisionVersion != nil {
		return *v.DecisionVersion
	}

	return
}

// IsSetDecisionVersion returns true if DecisionVersion is not nil.
func (v *WorkflowExecutionInfo) IsSetDecisionVersion() bool {
	return v != nil && v.DecisionVersion != nil
}

// GetDecisionScheduleID returns the value of DecisionScheduleID if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetDecisionScheduleID() (o int64) {
	if v != nil && v.DecisionScheduleID != nil {
		return *v.DecisionScheduleID
	}

	return
}

// IsSetDecisionScheduleID returns true if DecisionScheduleID is not nil.
func (v *WorkflowExecutionInfo) IsSetDecisionScheduleID() bool {
	return v != nil && v.DecisionScheduleID != nil
}

// GetDecisionStartedID returns the value of DecisionStartedID if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetDecisionStartedID() (o int64) {
	if v != nil && v.DecisionStartedID != nil {
		return *v.DecisionStartedID
	}

	return
}

// IsSetDecisionStartedID returns true if DecisionStartedID is not nil.
func (v *WorkflowExecutionInfo) IsSetDecisionStartedID() bool {
	return v != nil && v.DecisionStartedID != nil
}

// GetDecisionTimeout returns the value of DecisionTimeout if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetDecisionTimeout() (o int32) {
	if v != nil && v.DecisionTimeout != nil {
		return *v.DecisionTimeout
	}

	return
}

// IsSetDecisionTimeout returns true if DecisionTimeout is not nil.
func (v *WorkflowExecutionInfo) IsSetDecisionTimeout() bool {
	return v != nil && v.DecisionTimeout != nil
}

// GetDecisionAttempt returns the value of DecisionAttempt if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetDecisionAttempt() (o int64) {
	if v != nil && v.DecisionAttempt != nil {
		return *v.DecisionAttempt
	}

	return
}

// IsSetDecisionAttempt returns true if DecisionAttempt is not nil.
func (v *WorkflowExecutionInfo) IsSetDecisionAttempt() bool {
	return v != nil && v.DecisionAttempt != nil
}

// GetDecisionTimestampNanos returns the value of DecisionTimestampNanos if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetDecisionTimestampNanos() (o int64) {
	if v != nil && v.DecisionTimestampNanos != nil {
		return *v.DecisionTimestampNanos
	}

	return
}

// IsSetDecisionTimestampNanos returns true if DecisionTimestampNanos is not nil.
func (v *WorkflowExecutionInfo) IsSetDecisionTimestampNanos() bool {
	return v != nil && v.DecisionTimestampNanos != nil
}

// GetCancelRequested returns the value of CancelRequested if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetCancelRequested() (o bool) {
	if v != nil && v.CancelRequested != nil {
		return *v.CancelRequested
	}

	return
}

// IsSetCancelRequested returns true if CancelRequested is not nil.
func (v *WorkflowExecutionInfo) IsSetCancelRequested() bool {
	return v != nil && v.CancelRequested != nil
}

// GetCreateRequestID returns the value of CreateRequestID if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetCreateRequestID() (o string) {
	if v != nil && v.CreateRequestID != nil {
		return *v.CreateRequestID
	}

	return
}

// IsSetCreateRequestID returns true if CreateRequestID is not nil.
func (v *WorkflowExecutionInfo) IsSetCreateRequestID() bool {
	return v != nil && v.CreateRequestID != nil
}

// GetDecisionRequestID returns the value of DecisionRequestID if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetDecisionRequestID() (o string) {
	if v != nil && v.DecisionRequestID != nil {
		return *v.DecisionRequestID
	}

	return
}

// IsSetDecisionRequestID returns true if DecisionRequestID is not nil.
func (v *WorkflowExecutionInfo) IsSetDecisionRequestID() bool {
	return v != nil && v.DecisionRequestID != nil
}

// GetCancelRequestID returns the value of CancelRequestID if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetCancelRequestID() (o string) {
	if v != nil && v.CancelRequestID != nil {
		return *v.CancelRequestID
	}

	return
}

// IsSetCancelRequestID returns true if CancelRequestID is not nil.
func (v *WorkflowExecutionInfo) IsSetCancelRequestID() bool {
	return v != nil && v.CancelRequestID != nil
}

// GetStickyTaskList returns the value of StickyTaskList if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetStickyTaskList() (o string) {
	if v != nil && v.StickyTaskList != nil {
		return *v.StickyTaskList
	}

	return
}

// IsSetStickyTaskList returns true if StickyTaskList is not nil.
func (v *WorkflowExecutionInfo) IsSetStickyTaskList() bool {
	return v != nil && v.StickyTaskList != nil
}

// GetStickyScheduleToStartTimeout returns the value of StickyScheduleToStartTimeout if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetStickyScheduleToStartTimeout() (o int64) {
	if v != nil && v.StickyScheduleToStartTimeout != nil {
		return *v.StickyScheduleToStartTimeout
	}

	return
}

// IsSetStickyScheduleToStartTimeout returns true if StickyScheduleToStartTimeout is not nil.
func (v *WorkflowExecutionInfo) IsSetStickyScheduleToStartTimeout() bool {
	return v != nil && v.StickyScheduleToStartTimeout != nil
}

// GetRetryAttempt returns the value of RetryAttempt if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetRetryAttempt() (o int64) {
	if v != nil && v.RetryAttempt != nil {
		return *v.RetryAttempt
	}

	return
}

// IsSetRetryAttempt returns true if RetryAttempt is not nil.
func (v *WorkflowExecutionInfo) IsSetRetryAttempt() bool {
	return v != nil && v.RetryAttempt != nil
}

// GetRetryInitialIntervalSeconds returns the value of RetryInitialIntervalSeconds if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetRetryInitialIntervalSeconds() (o int32) {
	if v != nil && v.RetryInitialIntervalSeconds != nil {
		return *v.RetryInitialIntervalSeconds
	}

	return
}

// IsSetRetryInitialIntervalSeconds returns true if RetryInitialIntervalSeconds is not nil.
func (v *WorkflowExecutionInfo) IsSetRetryInitialIntervalSeconds() bool {
	return v != nil && v.RetryInitialIntervalSeconds != nil
}

// GetRetryMaximumIntervalSeconds returns the value of RetryMaximumIntervalSeconds if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetRetryMaximumIntervalSeconds() (o int32) {
	if v != nil && v.RetryMaximumIntervalSeconds != nil {
		return *v.RetryMaximumIntervalSeconds
	}

	return
}

// IsSetRetryMaximumIntervalSeconds returns true if RetryMaximumIntervalSeconds is not nil.
func (v *WorkflowExecutionInfo) IsSetRetryMaximumIntervalSeconds() bool {
	return v != nil && v.RetryMaximumIntervalSeconds != nil
}

// GetRetryMaximumAttempts returns the value of RetryMaximumAttempts if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetRetryMaximumAttempts() (o int32) {
	if v != nil && v.RetryMaximumAttempts != nil {
		return *v.RetryMaximumAttempts
	}

	return
}

// IsSetRetryMaximumAttempts returns true if RetryMaximumAttempts is not nil.
func (v *WorkflowExecutionInfo) IsSetRetryMaximumAttempts() bool {
	return v != nil && v.RetryMaximumAttempts != nil
}

// GetRetryExpirationSeconds returns the value of RetryExpirationSeconds if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetRetryExpirationSeconds() (o int32) {
	if v != nil && v.RetryExpirationSeconds != nil {
		return *v.RetryExpirationSeconds
	}

	return
}

// IsSetRetryExpirationSeconds returns true if RetryExpirationSeconds is not nil.
func (v *WorkflowExecutionInfo) IsSetRetryExpirationSeconds() bool {
	return v != nil && v.RetryExpirationSeconds != nil
}

// GetRetryBackoffCoefficient returns the value of RetryBackoffCoefficient if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetRetryBackoffCoefficient() (o float64) {
	if v != nil && v.RetryBackoffCoefficient != nil {
		return *v.RetryBackoffCoefficient
	}

	return
}

// IsSetRetryBackoffCoefficient returns true if RetryBackoffCoefficient is not nil.
func (v *WorkflowExecutionInfo) IsSetRetryBackoffCoefficient() bool {
	return v != nil && v.RetryBackoffCoefficient != nil
}

// GetRetryExpirationTimeNanos returns the value of RetryExpirationTimeNanos if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetRetryExpirationTimeNanos() (o int64) {
	if v != nil && v.RetryExpirationTimeNanos != nil {
		return *v.RetryExpirationTimeNanos
	}

	return
}

// IsSetRetryExpirationTimeNanos returns true if RetryExpirationTimeNanos is not nil.
func (v *WorkflowExecutionInfo) IsSetRetryExpirationTimeNanos() bool {
	return v != nil && v.RetryExpirationTimeNanos != nil
}

// GetRetryNonRetryableErrors returns the value of RetryNonRetryableErrors if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetRetryNonRetryableErrors() (o []string) {
	if v != nil && v.RetryNonRetryableErrors != nil {
		return v.RetryNonRetryableErrors
	}

	return
}

// IsSetRetryNonRetryableErrors returns true if RetryNonRetryableErrors is not nil.
func (v *WorkflowExecutionInfo) IsSetRetryNonRetryableErrors() bool {
	return v != nil && v.RetryNonRetryableErrors != nil
}

// GetHasRetryPolicy returns the value of HasRetryPolicy if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetHasRetryPolicy() (o bool) {
	if v != nil && v.HasRetryPolicy != nil {
		return *v.HasRetryPolicy
	}

	return
}

// IsSetHasRetryPolicy returns true if HasRetryPolicy is not nil.
func (v *WorkflowExecutionInfo) IsSetHasRetryPolicy() bool {
	return v != nil && v.HasRetryPolicy != nil
}

// GetCronSchedule returns the value of CronSchedule if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetCronSchedule() (o string) {
	if v != nil && v.CronSchedule != nil {
		return *v.CronSchedule
	}

	return
}

// IsSetCronSchedule returns true if CronSchedule is not nil.
func (v *WorkflowExecutionInfo) IsSetCronSchedule() bool {
	return v != nil && v.CronSchedule != nil
}

// GetEventStoreVersion returns the value of EventStoreVersion if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetEventStoreVersion() (o int32) {
	if v != nil && v.EventStoreVersion != nil {
		return *v.EventStoreVersion
	}

	return
}

// IsSetEventStoreVersion returns true if EventStoreVersion is not nil.
func (v *WorkflowExecutionInfo) IsSetEventStoreVersion() bool {
	return v != nil && v.EventStoreVersion != nil
}

// GetEventBranchToken returns the value of EventBranchToken if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetEventBranchToken() (o []byte) {
	if v != nil && v.EventBranchToken != nil {
		return v.EventBranchToken
	}

	return
}

// IsSetEventBranchToken returns true if EventBranchToken is not nil.
func (v *WorkflowExecutionInfo) IsSetEventBranchToken() bool {
	return v != nil && v.EventBranchToken != nil
}

// GetSignalCount returns the value of SignalCount if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetSignalCount() (o int64) {
	if v != nil && v.SignalCount != nil {
		return *v.SignalCount
	}

	return
}

// IsSetSignalCount returns true if SignalCount is not nil.
func (v *WorkflowExecutionInfo) IsSetSignalCount() bool {
	return v != nil && v.SignalCount != nil
}

// GetHistorySize returns the value of HistorySize if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetHistorySize() (o int64) {
	if v != nil && v.HistorySize != nil {
		return *v.HistorySize
	}

	return
}

// IsSetHistorySize returns true if HistorySize is not nil.
func (v *WorkflowExecutionInfo) IsSetHistorySize() bool {
	return v != nil && v.HistorySize != nil
}

// GetClientLibraryVersion returns the value of ClientLibraryVersion if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetClientLibraryVersion() (o string) {
	if v != nil && v.ClientLibraryVersion != nil {
		return *v.ClientLibraryVersion
	}

	return
}

// IsSetClientLibraryVersion returns true if ClientLibraryVersion is not nil.
func (v *WorkflowExecutionInfo) IsSetClientLibraryVersion() bool {
	return v != nil && v.ClientLibraryVersion != nil
}

// GetClientFeatureVersion returns the value of ClientFeatureVersion if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetClientFeatureVersion() (o string) {
	if v != nil && v.ClientFeatureVersion != nil {
		return *v.ClientFeatureVersion
	}

	return
}

// IsSetClientFeatureVersion returns true if ClientFeatureVersion is not nil.
func (v *WorkflowExecutionInfo) IsSetClientFeatureVersion() bool {
	return v != nil && v.ClientFeatureVersion != nil
}

// GetClientImpl returns the value of ClientImpl if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetClientImpl() (o string) {
	if v != nil && v.ClientImpl != nil {
		return *v.ClientImpl
	}

	return
}

// IsSetClientImpl returns true if ClientImpl is not nil.
func (v *WorkflowExecutionInfo) IsSetClientImpl() bool {
	return v != nil && v.ClientImpl != nil
}

// GetAutoResetPoints returns the value of AutoResetPoints if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetAutoResetPoints() (o []byte) {
	if v != nil && v.AutoResetPoints != nil {
		return v.AutoResetPoints
	}

	return
}

// IsSetAutoResetPoints returns true if AutoResetPoints is not nil.
func (v *WorkflowExecutionInfo) IsSetAutoResetPoints() bool {
	return v != nil && v.AutoResetPoints != nil
}

// GetAutoResetPointsEncoding returns the value of AutoResetPointsEncoding if it is set or its
// zero value if it is unset.
func (v *WorkflowExecutionInfo) GetAutoResetPointsEncoding() (o string) {
	if v != nil && v.AutoResetPointsEncoding != nil {
		return *v.AutoResetPointsEncoding
	}

	return
}

// IsSetAutoResetPointsEncoding returns true if AutoResetPointsEncoding is not nil.
func (v *WorkflowExecutionInfo) IsSetAutoResetPointsEncoding() bool {
	return v != nil && v.AutoResetPointsEncoding != nil
}
