// Copyright (c) 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

package cache

import "github.com/stretchr/testify/mock"

// DomainCacheMock is an autogenerated mock type for the DomainCache type
type DomainCacheMock struct {
	mock.Mock
}

// GetAllDomain provides a mock function with given fields:
func (_m *DomainCacheMock) GetAllDomain() map[string]*DomainCacheEntry {
	ret := _m.Called()

	var r0 map[string]*DomainCacheEntry
	if rf, ok := ret.Get(0).(func() map[string]*DomainCacheEntry); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string]*DomainCacheEntry)
		}
	}

	return r0
}

// GetCacheSize provides a mock function with given fields:
func (_m *DomainCacheMock) GetCacheSize() (int64, int64) {
	ret := _m.Called()

	var r0 int64
	if rf, ok := ret.Get(0).(func() int64); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(int64)
	}

	var r1 int64
	if rf, ok := ret.Get(1).(func() int64); ok {
		r1 = rf()
	} else {
		r1 = ret.Get(1).(int64)
	}

	return r0, r1
}

// GetDomain provides a mock function with given fields: name
func (_m *DomainCacheMock) GetDomain(name string) (*DomainCacheEntry, error) {
	ret := _m.Called(name)

	var r0 *DomainCacheEntry
	if rf, ok := ret.Get(0).(func(string) *DomainCacheEntry); ok {
		r0 = rf(name)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*DomainCacheEntry)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(name)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetDomainByID provides a mock function with given fields: id
func (_m *DomainCacheMock) GetDomainByID(id string) (*DomainCacheEntry, error) {
	ret := _m.Called(id)

	var r0 *DomainCacheEntry
	if rf, ok := ret.Get(0).(func(string) *DomainCacheEntry); ok {
		r0 = rf(id)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*DomainCacheEntry)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(id)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetDomainID provides a mock function with given fields: name
func (_m *DomainCacheMock) GetDomainID(name string) (string, error) {
	ret := _m.Called(name)

	var r0 string
	if rf, ok := ret.Get(0).(func(string) string); ok {
		r0 = rf(name)
	} else {
		r0 = ret.Get(0).(string)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(name)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// RegisterDomainChangeCallback provides a mock function with given fields: shard, initialNotificationVersion, prepareCallbackFn, callback
func (_m *DomainCacheMock) RegisterDomainChangeCallback(shard int, initialNotificationVersion int64,
	prepareCallbackFn PrepareCallbackFn, callback CallbackFn) {
	_m.Called(shard, initialNotificationVersion, prepareCallbackFn, callback)
}

// Start provides a mock function with given fields:
func (_m *DomainCacheMock) Start() {
	_m.Called()
}

// Stop provides a mock function with given fields:
func (_m *DomainCacheMock) Stop() {
	_m.Called()
}

// UnregisterDomainChangeCallback provides a mock function with given fields: shard
func (_m *DomainCacheMock) UnregisterDomainChangeCallback(shard int) {
	_m.Called(shard)
}

var _ DomainCache = (*DomainCacheMock)(nil)
