// Copyright (c) 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

package history

import (
	"time"

	"github.com/stretchr/testify/mock"
	h "github.com/uber/cadence/.gen/go/history"
	"github.com/uber/cadence/.gen/go/shared"
	"github.com/uber/cadence/common/cache"
	"github.com/uber/cadence/common/persistence"
)

// mockMutableState is an autogenerated mock type for the mockMutableState type
type mockMutableState struct {
	mock.Mock
}

var _ mutableState = (*mockMutableState)(nil)

// AddActivityTaskCancelRequestedEvent provides a mock function with given fields: _a0, _a1, _a2
func (_m *mockMutableState) AddActivityTaskCancelRequestedEvent(_a0 int64, _a1 string, _a2 string) (*shared.HistoryEvent, *persistence.ActivityInfo, bool) {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, string, string) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	var r1 *persistence.ActivityInfo
	if rf, ok := ret.Get(1).(func(int64, string, string) *persistence.ActivityInfo); ok {
		r1 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*persistence.ActivityInfo)
		}
	}

	var r2 bool
	if rf, ok := ret.Get(2).(func(int64, string, string) bool); ok {
		r2 = rf(_a0, _a1, _a2)
	} else {
		r2 = ret.Get(2).(bool)
	}

	return r0, r1, r2
}

// AddActivityTaskCanceledEvent provides a mock function with given fields: _a0, _a1, _a2, _a3, _a4
func (_m *mockMutableState) AddActivityTaskCanceledEvent(_a0 int64, _a1 int64, _a2 int64, _a3 []uint8, _a4 string) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1, _a2, _a3, _a4)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, int64, int64, []uint8, string) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2, _a3, _a4)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddActivityTaskCompletedEvent provides a mock function with given fields: _a0, _a1, _a2
func (_m *mockMutableState) AddActivityTaskCompletedEvent(_a0 int64, _a1 int64, _a2 *shared.RespondActivityTaskCompletedRequest) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, int64, *shared.RespondActivityTaskCompletedRequest) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddActivityTaskFailedEvent provides a mock function with given fields: _a0, _a1, _a2
func (_m *mockMutableState) AddActivityTaskFailedEvent(_a0 int64, _a1 int64, _a2 *shared.RespondActivityTaskFailedRequest) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, int64, *shared.RespondActivityTaskFailedRequest) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddActivityTaskScheduledEvent provides a mock function with given fields: _a0, _a1
func (_m *mockMutableState) AddActivityTaskScheduledEvent(_a0 int64, _a1 *shared.ScheduleActivityTaskDecisionAttributes) (*shared.HistoryEvent, *persistence.ActivityInfo) {
	ret := _m.Called(_a0, _a1)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, *shared.ScheduleActivityTaskDecisionAttributes) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	var r1 *persistence.ActivityInfo
	if rf, ok := ret.Get(1).(func(int64, *shared.ScheduleActivityTaskDecisionAttributes) *persistence.ActivityInfo); ok {
		r1 = rf(_a0, _a1)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*persistence.ActivityInfo)
		}
	}

	return r0, r1
}

// AddActivityTaskStartedEvent provides a mock function with given fields: _a0, _a1, _a2, _a3
func (_m *mockMutableState) AddActivityTaskStartedEvent(_a0 *persistence.ActivityInfo, _a1 int64, _a2 string, _a3 string) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1, _a2, _a3)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(*persistence.ActivityInfo, int64, string, string) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2, _a3)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddActivityTaskTimedOutEvent provides a mock function with given fields: _a0, _a1, _a2, _a3
func (_m *mockMutableState) AddActivityTaskTimedOutEvent(_a0 int64, _a1 int64, _a2 shared.TimeoutType, _a3 []uint8) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1, _a2, _a3)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, int64, shared.TimeoutType, []uint8) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2, _a3)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddCancelTimerFailedEvent provides a mock function with given fields: _a0, _a1, _a2
func (_m *mockMutableState) AddCancelTimerFailedEvent(_a0 int64, _a1 *shared.CancelTimerDecisionAttributes, _a2 string) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, *shared.CancelTimerDecisionAttributes, string) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddChildWorkflowExecutionCanceledEvent provides a mock function with given fields: _a0, _a1, _a2
func (_m *mockMutableState) AddChildWorkflowExecutionCanceledEvent(_a0 int64, _a1 *shared.WorkflowExecution, _a2 *shared.WorkflowExecutionCanceledEventAttributes) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, *shared.WorkflowExecution, *shared.WorkflowExecutionCanceledEventAttributes) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddChildWorkflowExecutionCompletedEvent provides a mock function with given fields: _a0, _a1, _a2
func (_m *mockMutableState) AddChildWorkflowExecutionCompletedEvent(_a0 int64, _a1 *shared.WorkflowExecution, _a2 *shared.WorkflowExecutionCompletedEventAttributes) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, *shared.WorkflowExecution, *shared.WorkflowExecutionCompletedEventAttributes) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddChildWorkflowExecutionFailedEvent provides a mock function with given fields: _a0, _a1, _a2
func (_m *mockMutableState) AddChildWorkflowExecutionFailedEvent(_a0 int64, _a1 *shared.WorkflowExecution, _a2 *shared.WorkflowExecutionFailedEventAttributes) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, *shared.WorkflowExecution, *shared.WorkflowExecutionFailedEventAttributes) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddChildWorkflowExecutionStartedEvent provides a mock function with given fields: _a0, _a1, _a2, _a3
func (_m *mockMutableState) AddChildWorkflowExecutionStartedEvent(_a0 *string, _a1 *shared.WorkflowExecution, _a2 *shared.WorkflowType, _a3 int64, _a4 *shared.Header) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1, _a2, _a3, _a4)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(*string, *shared.WorkflowExecution, *shared.WorkflowType, int64, *shared.Header) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2, _a3, _a4)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddChildWorkflowExecutionTerminatedEvent provides a mock function with given fields: _a0, _a1, _a2
func (_m *mockMutableState) AddChildWorkflowExecutionTerminatedEvent(_a0 int64, _a1 *shared.WorkflowExecution, _a2 *shared.WorkflowExecutionTerminatedEventAttributes) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, *shared.WorkflowExecution, *shared.WorkflowExecutionTerminatedEventAttributes) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddChildWorkflowExecutionTimedOutEvent provides a mock function with given fields: _a0, _a1, _a2
func (_m *mockMutableState) AddChildWorkflowExecutionTimedOutEvent(_a0 int64, _a1 *shared.WorkflowExecution, _a2 *shared.WorkflowExecutionTimedOutEventAttributes) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, *shared.WorkflowExecution, *shared.WorkflowExecutionTimedOutEventAttributes) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddCompletedWorkflowEvent provides a mock function with given fields: _a0, _a1
func (_m *mockMutableState) AddCompletedWorkflowEvent(_a0 int64, _a1 *shared.CompleteWorkflowExecutionDecisionAttributes) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, *shared.CompleteWorkflowExecutionDecisionAttributes) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddContinueAsNewEvent provides a mock function with given fields: _a0, _a1, _a2, _a3, _a4, _a5, _a6
func (_m *mockMutableState) AddContinueAsNewEvent(_a0 int64, _a1 int64, _a2 *cache.DomainCacheEntry, _a3 string, _a4 *shared.ContinueAsNewWorkflowExecutionDecisionAttributes, _a5 int32) (*shared.HistoryEvent, mutableState, error) {
	ret := _m.Called(_a0, _a1, _a2, _a3, _a4, _a5)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, int64, *cache.DomainCacheEntry, string, *shared.ContinueAsNewWorkflowExecutionDecisionAttributes, int32) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2, _a3, _a4, _a5)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	var r1 mutableState
	if rf, ok := ret.Get(1).(func(int64, int64, *cache.DomainCacheEntry, string, *shared.ContinueAsNewWorkflowExecutionDecisionAttributes, int32) mutableState); ok {
		r1 = rf(_a0, _a1, _a2, _a3, _a4, _a5)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(mutableState)
		}
	}

	var r2 error
	if rf, ok := ret.Get(2).(func(int64, int64, *cache.DomainCacheEntry, string, *shared.ContinueAsNewWorkflowExecutionDecisionAttributes, int32) error); ok {
		r2 = rf(_a0, _a1, _a2, _a3, _a4, _a5)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// AddDecisionTaskCompletedEvent provides a mock function with given fields: _a0, _a1, _a2
func (_m *mockMutableState) AddDecisionTaskCompletedEvent(_a0 int64, _a1 int64, _a2 *shared.RespondDecisionTaskCompletedRequest, _a3 int) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1, _a2, _a3)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, int64, *shared.RespondDecisionTaskCompletedRequest, int) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2, _a3)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddDecisionTaskFailedEvent provides a mock function with given fields
func (_m *mockMutableState) AddDecisionTaskFailedEvent(_a0 int64, _a1 int64, _a2 shared.DecisionTaskFailedCause, _a3 []uint8, _a4, _a5, _a6, _a7 string, _a8 int64) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1, _a2, _a3, _a4, _a5, _a6, _a7, _a8)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, int64, shared.DecisionTaskFailedCause, []uint8, string, string, string, string, int64) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2, _a3, _a4, _a5, _a6, _a7, _a8)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// GetAllSignalsToSend provide mocks
func (_m *mockMutableState) GetAllSignalsToSend() map[int64]*persistence.SignalInfo {
	ret := _m.Called()

	var r0 map[int64]*persistence.SignalInfo
	if rf, ok := ret.Get(0).(func() map[int64]*persistence.SignalInfo); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(map[int64]*persistence.SignalInfo)
	}

	return r0
}

func (_m *mockMutableState) GetAllRequestCancels() map[int64]*persistence.RequestCancelInfo {
	ret := _m.Called()

	var r0 map[int64]*persistence.RequestCancelInfo
	if rf, ok := ret.Get(0).(func() map[int64]*persistence.RequestCancelInfo); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(map[int64]*persistence.RequestCancelInfo)
	}

	return r0
}

// AddDecisionTaskScheduleToStartTimeoutEvent provides a mock function with given fields: _a0
func (_m *mockMutableState) AddDecisionTaskScheduleToStartTimeoutEvent(_a0 int64) *shared.HistoryEvent {
	ret := _m.Called(_a0)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64) *shared.HistoryEvent); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddDecisionTaskScheduledEvent provides a mock function with given fields:
func (_m *mockMutableState) AddDecisionTaskScheduledEvent() *decisionInfo {
	ret := _m.Called()

	var r0 *decisionInfo
	if rf, ok := ret.Get(0).(func() *decisionInfo); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*decisionInfo)
		}
	}

	return r0
}

// AddDecisionTaskStartedEvent provides a mock function with given fields: _a0, _a1, _a2
func (_m *mockMutableState) AddDecisionTaskStartedEvent(_a0 int64, _a1 string, _a2 *shared.PollForDecisionTaskRequest) (*shared.HistoryEvent, *decisionInfo) {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, string, *shared.PollForDecisionTaskRequest) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	var r1 *decisionInfo
	if rf, ok := ret.Get(1).(func(int64, string, *shared.PollForDecisionTaskRequest) *decisionInfo); ok {
		r1 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*decisionInfo)
		}
	}

	return r0, r1
}

// AddDecisionTaskTimedOutEvent provides a mock function with given fields: _a0, _a1
func (_m *mockMutableState) AddDecisionTaskTimedOutEvent(_a0 int64, _a1 int64) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, int64) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddExternalWorkflowExecutionCancelRequested provides a mock function with given fields: _a0, _a1, _a2, _a3
func (_m *mockMutableState) AddExternalWorkflowExecutionCancelRequested(_a0 int64, _a1 string, _a2 string, _a3 string) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1, _a2, _a3)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, string, string, string) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2, _a3)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddExternalWorkflowExecutionSignaled provides a mock function with given fields: _a0, _a1, _a2, _a3, _a4
func (_m *mockMutableState) AddExternalWorkflowExecutionSignaled(_a0 int64, _a1 string, _a2 string, _a3 string, _a4 []uint8) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1, _a2, _a3, _a4)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, string, string, string, []uint8) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2, _a3, _a4)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddFailWorkflowEvent provides a mock function with given fields: _a0, _a1
func (_m *mockMutableState) AddFailWorkflowEvent(_a0 int64, _a1 *shared.FailWorkflowExecutionDecisionAttributes) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, *shared.FailWorkflowExecutionDecisionAttributes) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddRecordMarkerEvent provides a mock function with given fields: _a0, _a1
func (_m *mockMutableState) AddRecordMarkerEvent(_a0 int64, _a1 *shared.RecordMarkerDecisionAttributes) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, *shared.RecordMarkerDecisionAttributes) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddRequestCancelActivityTaskFailedEvent provides a mock function with given fields: _a0, _a1, _a2
func (_m *mockMutableState) AddRequestCancelActivityTaskFailedEvent(_a0 int64, _a1 string, _a2 string) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, string, string) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddRequestCancelExternalWorkflowExecutionFailedEvent provides a mock function with given fields: _a0, _a1, _a2, _a3, _a4, _a5
func (_m *mockMutableState) AddRequestCancelExternalWorkflowExecutionFailedEvent(_a0 int64, _a1 int64, _a2 string, _a3 string, _a4 string, _a5 shared.CancelExternalWorkflowExecutionFailedCause) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1, _a2, _a3, _a4, _a5)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, int64, string, string, string, shared.CancelExternalWorkflowExecutionFailedCause) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2, _a3, _a4, _a5)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddRequestCancelExternalWorkflowExecutionInitiatedEvent provides a mock function with given fields: _a0, _a1, _a2
func (_m *mockMutableState) AddRequestCancelExternalWorkflowExecutionInitiatedEvent(_a0 int64, _a1 string, _a2 *shared.RequestCancelExternalWorkflowExecutionDecisionAttributes) (*shared.HistoryEvent, *persistence.RequestCancelInfo) {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, string, *shared.RequestCancelExternalWorkflowExecutionDecisionAttributes) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	var r1 *persistence.RequestCancelInfo
	if rf, ok := ret.Get(1).(func(int64, string, *shared.RequestCancelExternalWorkflowExecutionDecisionAttributes) *persistence.RequestCancelInfo); ok {
		r1 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*persistence.RequestCancelInfo)
		}
	}

	return r0, r1
}

// AddSignalExternalWorkflowExecutionFailedEvent provides a mock function with given fields: _a0, _a1, _a2, _a3, _a4, _a5, _a6
func (_m *mockMutableState) AddSignalExternalWorkflowExecutionFailedEvent(_a0 int64, _a1 int64, _a2 string, _a3 string, _a4 string, _a5 []uint8, _a6 shared.SignalExternalWorkflowExecutionFailedCause) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1, _a2, _a3, _a4, _a5, _a6)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, int64, string, string, string, []uint8, shared.SignalExternalWorkflowExecutionFailedCause) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2, _a3, _a4, _a5, _a6)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddSignalExternalWorkflowExecutionInitiatedEvent provides a mock function with given fields: _a0, _a1, _a2
func (_m *mockMutableState) AddSignalExternalWorkflowExecutionInitiatedEvent(_a0 int64, _a1 string, _a2 *shared.SignalExternalWorkflowExecutionDecisionAttributes) (*shared.HistoryEvent, *persistence.SignalInfo) {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, string, *shared.SignalExternalWorkflowExecutionDecisionAttributes) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	var r1 *persistence.SignalInfo
	if rf, ok := ret.Get(1).(func(int64, string, *shared.SignalExternalWorkflowExecutionDecisionAttributes) *persistence.SignalInfo); ok {
		r1 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*persistence.SignalInfo)
		}
	}

	return r0, r1
}

// AddSignalRequested provides a mock function with given fields: requestID
func (_m *mockMutableState) AddSignalRequested(requestID string) {
	_m.Called(requestID)
}

// AddStartChildWorkflowExecutionFailedEvent provides a mock function with given fields: _a0, _a1, _a2
func (_m *mockMutableState) AddStartChildWorkflowExecutionFailedEvent(_a0 int64, _a1 shared.ChildWorkflowExecutionFailedCause, _a2 *shared.StartChildWorkflowExecutionInitiatedEventAttributes) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, shared.ChildWorkflowExecutionFailedCause, *shared.StartChildWorkflowExecutionInitiatedEventAttributes) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddStartChildWorkflowExecutionInitiatedEvent provides a mock function with given fields: _a0, _a1, _a2
func (_m *mockMutableState) AddStartChildWorkflowExecutionInitiatedEvent(_a0 int64, _a1 string, _a2 *shared.StartChildWorkflowExecutionDecisionAttributes) (*shared.HistoryEvent, *persistence.ChildExecutionInfo) {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, string, *shared.StartChildWorkflowExecutionDecisionAttributes) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	var r1 *persistence.ChildExecutionInfo
	if rf, ok := ret.Get(1).(func(int64, string, *shared.StartChildWorkflowExecutionDecisionAttributes) *persistence.ChildExecutionInfo); ok {
		r1 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*persistence.ChildExecutionInfo)
		}
	}

	return r0, r1
}

// AddTimeoutWorkflowEvent provides a mock function with given fields:
func (_m *mockMutableState) AddTimeoutWorkflowEvent() *shared.HistoryEvent {
	ret := _m.Called()

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func() *shared.HistoryEvent); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddTimerCanceledEvent provides a mock function with given fields: _a0, _a1, _a2
func (_m *mockMutableState) AddTimerCanceledEvent(_a0 int64, _a1 *shared.CancelTimerDecisionAttributes, _a2 string) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, *shared.CancelTimerDecisionAttributes, string) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddTimerFiredEvent provides a mock function with given fields: _a0, _a1
func (_m *mockMutableState) AddTimerFiredEvent(_a0 int64, _a1 string) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, string) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddTimerStartedEvent provides a mock function with given fields: _a0, _a1
func (_m *mockMutableState) AddTimerStartedEvent(_a0 int64, _a1 *shared.StartTimerDecisionAttributes) (*shared.HistoryEvent, *persistence.TimerInfo) {
	ret := _m.Called(_a0, _a1)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, *shared.StartTimerDecisionAttributes) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	var r1 *persistence.TimerInfo
	if rf, ok := ret.Get(1).(func(int64, *shared.StartTimerDecisionAttributes) *persistence.TimerInfo); ok {
		r1 = rf(_a0, _a1)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*persistence.TimerInfo)
		}
	}

	return r0, r1
}

// AddWorkflowExecutionCancelRequestedEvent provides a mock function with given fields: _a0, _a1
func (_m *mockMutableState) AddWorkflowExecutionCancelRequestedEvent(_a0 string, _a1 *h.RequestCancelWorkflowExecutionRequest) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(string, *h.RequestCancelWorkflowExecutionRequest) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddWorkflowExecutionCanceledEvent provides a mock function with given fields: _a0, _a1
func (_m *mockMutableState) AddWorkflowExecutionCanceledEvent(_a0 int64, _a1 *shared.CancelWorkflowExecutionDecisionAttributes) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64, *shared.CancelWorkflowExecutionDecisionAttributes) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddWorkflowExecutionSignaled provides a mock function with given fields: _a0
func (_m *mockMutableState) AddWorkflowExecutionSignaled(_a0 string, _a1 []byte, _a2 string) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(string, []byte, string) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddWorkflowExecutionStartedEvent provides a mock function with given fields: _a0, _a1
func (_m *mockMutableState) AddWorkflowExecutionStartedEvent(_a0 shared.WorkflowExecution, _a1 *h.StartWorkflowExecutionRequest) *shared.HistoryEvent {
	ret := _m.Called(_a0, _a1)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(shared.WorkflowExecution, *h.StartWorkflowExecutionRequest) *shared.HistoryEvent); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// AddWorkflowExecutionTerminatedEvent provides a mock function with given fields: _a0
func (_m *mockMutableState) AddWorkflowExecutionTerminatedEvent(_a0 *shared.TerminateWorkflowExecutionRequest) *shared.HistoryEvent {
	ret := _m.Called(_a0)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(*shared.TerminateWorkflowExecutionRequest) *shared.HistoryEvent); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// BufferReplicationTask provides a mock function with given fields: _a0
func (_m *mockMutableState) BufferReplicationTask(_a0 *h.ReplicateEventsRequest) error {
	ret := _m.Called(_a0)

	var r0 error
	if rf, ok := ret.Get(0).(func(*h.ReplicateEventsRequest) error); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ClearStickyness provides a mock function with given fields:
func (_m *mockMutableState) ClearStickyness() {
	_m.Called()
}

// CloseUpdateSession provides a mock function with given fields:
func (_m *mockMutableState) CloseUpdateSession() (*mutableStateSessionUpdates, error) {
	ret := _m.Called()

	var r0 *mutableStateSessionUpdates
	if rf, ok := ret.Get(0).(func() *mutableStateSessionUpdates); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*mutableStateSessionUpdates)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func() error); ok {
		r1 = rf()
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CloseUpdateSession provides a mock function with given fields:
func (_m *mockMutableState) CheckResettable() error {
	ret := _m.Called()

	var r0 error
	if rf, ok := ret.Get(0).(func() error); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(error)
		}
	}

	return r0
}

// CopyToPersistence provides a mock function with given fields:
func (_m *mockMutableState) CopyToPersistence() *persistence.WorkflowMutableState {
	ret := _m.Called()

	var r0 *persistence.WorkflowMutableState
	if rf, ok := ret.Get(0).(func() *persistence.WorkflowMutableState); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*persistence.WorkflowMutableState)
		}
	}

	return r0
}

// CreateNewHistoryEvent provides a mock function with given fields: eventType
func (_m *mockMutableState) CreateNewHistoryEvent(eventType shared.EventType) *shared.HistoryEvent {
	ret := _m.Called(eventType)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(shared.EventType) *shared.HistoryEvent); ok {
		r0 = rf(eventType)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// CreateNewHistoryEventWithTimestamp provides a mock function with given fields: eventType, timestamp
func (_m *mockMutableState) CreateNewHistoryEventWithTimestamp(eventType shared.EventType, timestamp int64) *shared.HistoryEvent {
	ret := _m.Called(eventType, timestamp)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(shared.EventType, int64) *shared.HistoryEvent); ok {
		r0 = rf(eventType, timestamp)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	return r0
}

// CreateActivityRetryTimer provides a mock function with given fields: _a0, _a1
func (_m *mockMutableState) CreateActivityRetryTimer(_a0 *persistence.ActivityInfo, _a1 string) persistence.Task {
	ret := _m.Called(_a0, _a1)

	var r0 persistence.Task
	if rf, ok := ret.Get(0).(func(*persistence.ActivityInfo, string) persistence.Task); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(persistence.Task)
		}
	}

	return r0
}

// CreateTransientDecisionEvents provides a mock function with given fields: di, identity
func (_m *mockMutableState) CreateTransientDecisionEvents(di *decisionInfo, identity string) (*shared.HistoryEvent, *shared.HistoryEvent) {
	ret := _m.Called(di, identity)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(*decisionInfo, string) *shared.HistoryEvent); ok {
		r0 = rf(di, identity)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	var r1 *shared.HistoryEvent
	if rf, ok := ret.Get(1).(func(*decisionInfo, string) *shared.HistoryEvent); ok {
		r1 = rf(di, identity)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*shared.HistoryEvent)
		}
	}

	return r0, r1
}

// DeleteActivity provides a mock function with given fields: _a0
func (_m *mockMutableState) DeleteActivity(_a0 int64) error {
	ret := _m.Called(_a0)

	var r0 error
	if rf, ok := ret.Get(0).(func(int64) error); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteBufferedReplicationTask provides a mock function with given fields: _a0
func (_m *mockMutableState) DeleteBufferedReplicationTask(_a0 int64) {
	_m.Called(_a0)
}

// DeleteDecision provides a mock function with given fields:
func (_m *mockMutableState) DeleteDecision() {
	_m.Called()
}

// DeletePendingChildExecution provides a mock function with given fields: _a0
func (_m *mockMutableState) DeletePendingChildExecution(_a0 int64) {
	_m.Called(_a0)
}

// DeletePendingRequestCancel provides a mock function with given fields: _a0
func (_m *mockMutableState) DeletePendingRequestCancel(_a0 int64) {
	_m.Called(_a0)
}

// DeletePendingSignal provides a mock function with given fields: _a0
func (_m *mockMutableState) DeletePendingSignal(_a0 int64) {
	_m.Called(_a0)
}

// DeleteSignalRequested provides a mock function with given fields: requestID
func (_m *mockMutableState) DeleteSignalRequested(requestID string) {
	_m.Called(requestID)
}

// DeleteUserTimer provides a mock function with given fields: _a0
func (_m *mockMutableState) DeleteUserTimer(_a0 string) {
	_m.Called(_a0)
}

// FailDecision provides a mock function with given fields:
func (_m *mockMutableState) FailDecision(incrementAttempt bool) {
	_m.Called(incrementAttempt)
}

// FlushBufferedEvents provides a mock function with given fields:
func (_m *mockMutableState) FlushBufferedEvents() error {
	ret := _m.Called()

	var r0 error
	if rf, ok := ret.Get(0).(func() error); ok {
		r0 = rf()
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// FlushBufferedEvents provides a mock function with given fields:
func (_m *mockMutableState) GetHistorySize() int64 {
	ret := _m.Called()

	var r0 int64
	if rf, ok := ret.Get(0).(func() int64); ok {
		r0 = rf()
	} else {
		r0 = 0
	}

	return r0
}

// GetActivityByActivityID provides a mock function with given fields: _a0
func (_m *mockMutableState) GetActivityByActivityID(_a0 string) (*persistence.ActivityInfo, bool) {
	ret := _m.Called(_a0)

	var r0 *persistence.ActivityInfo
	if rf, ok := ret.Get(0).(func(string) *persistence.ActivityInfo); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*persistence.ActivityInfo)
		}
	}

	var r1 bool
	if rf, ok := ret.Get(1).(func(string) bool); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Get(1).(bool)
	}

	return r0, r1
}

// GetActivityInfo provides a mock function with given fields: _a0
func (_m *mockMutableState) GetActivityInfo(_a0 int64) (*persistence.ActivityInfo, bool) {
	ret := _m.Called(_a0)

	var r0 *persistence.ActivityInfo
	if rf, ok := ret.Get(0).(func(int64) *persistence.ActivityInfo); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*persistence.ActivityInfo)
		}
	}

	var r1 bool
	if rf, ok := ret.Get(1).(func(int64) bool); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Get(1).(bool)
	}

	return r0, r1
}

// GetActivityScheduledEvent provides a mock function with given fields: _a0
func (_m *mockMutableState) GetActivityScheduledEvent(_a0 int64) (*shared.HistoryEvent, bool) {
	ret := _m.Called(_a0)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64) *shared.HistoryEvent); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	var r1 bool
	if rf, ok := ret.Get(1).(func(int64) bool); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Get(1).(bool)
	}

	return r0, r1
}

// GetAllBufferedReplicationTasks provides a mock function with given fields:
func (_m *mockMutableState) GetAllBufferedReplicationTasks() map[int64]*persistence.BufferedReplicationTask {
	ret := _m.Called()

	var r0 map[int64]*persistence.BufferedReplicationTask
	if rf, ok := ret.Get(0).(func() map[int64]*persistence.BufferedReplicationTask); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[int64]*persistence.BufferedReplicationTask)
		}
	}

	return r0
}

// GetChildExecutionInfo provides a mock function with given fields: _a0
func (_m *mockMutableState) GetChildExecutionInfo(_a0 int64) (*persistence.ChildExecutionInfo, bool) {
	ret := _m.Called(_a0)

	var r0 *persistence.ChildExecutionInfo
	if rf, ok := ret.Get(0).(func(int64) *persistence.ChildExecutionInfo); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*persistence.ChildExecutionInfo)
		}
	}

	var r1 bool
	if rf, ok := ret.Get(1).(func(int64) bool); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Get(1).(bool)
	}

	return r0, r1
}

// GetChildExecutionInitiatedEvent provides a mock function with given fields: _a0
func (_m *mockMutableState) GetChildExecutionInitiatedEvent(_a0 int64) (*shared.HistoryEvent, bool) {
	ret := _m.Called(_a0)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(int64) *shared.HistoryEvent); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	var r1 bool
	if rf, ok := ret.Get(1).(func(int64) bool); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Get(1).(bool)
	}

	return r0, r1
}

// GetCompletionEvent provides a mock function with given fields:
func (_m *mockMutableState) GetCompletionEvent() (*shared.HistoryEvent, bool) {
	ret := _m.Called()

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func() *shared.HistoryEvent); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	var r1 bool
	if rf, ok := ret.Get(1).(func() bool); ok {
		r1 = rf()
	} else {
		r1 = ret.Get(1).(bool)
	}

	return r0, r1
}

// GetStartEvent provides a mock function with given fields:
func (_m *mockMutableState) GetStartEvent() (*shared.HistoryEvent, bool) {
	ret := _m.Called()

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func() *shared.HistoryEvent); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	var r1 bool
	if rf, ok := ret.Get(1).(func() bool); ok {
		r1 = rf()
	} else {
		r1 = ret.Get(1).(bool)
	}

	return r0, r1
}

// GetContinueAsNew provides a mock function with given fields:
func (_m *mockMutableState) GetContinueAsNew() *persistence.CreateWorkflowExecutionRequest {
	ret := _m.Called()

	var r0 *persistence.CreateWorkflowExecutionRequest
	if rf, ok := ret.Get(0).(func() *persistence.CreateWorkflowExecutionRequest); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*persistence.CreateWorkflowExecutionRequest)
		}
	}

	return r0
}

// GetCurrentVersion provides a mock function with given fields:
func (_m *mockMutableState) GetCurrentVersion() int64 {
	ret := _m.Called()

	var r0 int64
	if rf, ok := ret.Get(0).(func() int64); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(int64)
	}

	return r0
}

// GetExecutionInfo provides a mock function with given fields:
func (_m *mockMutableState) GetExecutionInfo() *persistence.WorkflowExecutionInfo {
	ret := _m.Called()

	var r0 *persistence.WorkflowExecutionInfo
	if rf, ok := ret.Get(0).(func() *persistence.WorkflowExecutionInfo); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*persistence.WorkflowExecutionInfo)
		}
	}

	return r0
}

// GetHistoryBuilder provides a mock function with given fields:
func (_m *mockMutableState) GetHistoryBuilder() *historyBuilder {
	ret := _m.Called()

	var r0 *historyBuilder
	if rf, ok := ret.Get(0).(func() *historyBuilder); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*historyBuilder)
		}
	}

	return r0
}

func (_m *mockMutableState) GetCurrentBranch() []byte {
	ret := _m.Called()

	var r0 []byte
	if rf, ok := ret.Get(0).(func() []byte); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]byte)
		}
	}

	return r0
}

func (_m *mockMutableState) GetEventStoreVersion() int32 {
	ret := _m.Called()

	var r0 int32
	if rf, ok := ret.Get(0).(func() int32); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(int32)
		}
	}

	return r0
}

func (_m *mockMutableState) GetInFlightDecisionTask() (*decisionInfo, bool) {
	ret := _m.Called()

	var r0 *decisionInfo
	if rf, ok := ret.Get(0).(func() *decisionInfo); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*decisionInfo)
		}
	}

	var r1 bool
	if rf, ok := ret.Get(1).(func() bool); ok {
		r1 = rf()
	} else {
		r1 = ret.Get(1).(bool)
	}

	return r0, r1
}

// GetLastFirstEventID provides a mock function with given fields:
func (_m *mockMutableState) GetLastFirstEventID() int64 {
	ret := _m.Called()

	var r0 int64
	if rf, ok := ret.Get(0).(func() int64); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(int64)
	}

	return r0
}

// GetLastWriteVersion provides a mock function with given fields:
func (_m *mockMutableState) GetLastWriteVersion() int64 {
	ret := _m.Called()

	var r0 int64
	if rf, ok := ret.Get(0).(func() int64); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(int64)
	}

	return r0
}

// GetNextEventID provides a mock function with given fields:
func (_m *mockMutableState) GetNextEventID() int64 {
	ret := _m.Called()

	var r0 int64
	if rf, ok := ret.Get(0).(func() int64); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(int64)
	}

	return r0
}

// GetPreviousStartedEventID returns last started decision task event ID
func (_m *mockMutableState) GetPreviousStartedEventID() int64 {
	ret := _m.Called()

	var r0 int64
	if rf, ok := ret.Get(0).(func() int64); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(int64)
	}

	return r0
}

// GetPendingActivityInfos provides a mock function with given fields:
func (_m *mockMutableState) GetPendingActivityInfos() map[int64]*persistence.ActivityInfo {
	ret := _m.Called()

	var r0 map[int64]*persistence.ActivityInfo
	if rf, ok := ret.Get(0).(func() map[int64]*persistence.ActivityInfo); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[int64]*persistence.ActivityInfo)
		}
	}

	return r0
}

// GetPendingChildExecutionInfos provides a mock function with given fields:
func (_m *mockMutableState) GetPendingChildExecutionInfos() map[int64]*persistence.ChildExecutionInfo {
	ret := _m.Called()

	var r0 map[int64]*persistence.ChildExecutionInfo
	if rf, ok := ret.Get(0).(func() map[int64]*persistence.ChildExecutionInfo); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[int64]*persistence.ChildExecutionInfo)
		}
	}

	return r0
}

// GetPendingDecision provides a mock function with given fields: _a0
func (_m *mockMutableState) GetPendingDecision(_a0 int64) (*decisionInfo, bool) {
	ret := _m.Called(_a0)

	var r0 *decisionInfo
	if rf, ok := ret.Get(0).(func(int64) *decisionInfo); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*decisionInfo)
		}
	}

	var r1 bool
	if rf, ok := ret.Get(1).(func(int64) bool); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Get(1).(bool)
	}

	return r0, r1
}

// GetPendingTimerInfos provides a mock function with given fields:
func (_m *mockMutableState) GetPendingTimerInfos() map[string]*persistence.TimerInfo {
	ret := _m.Called()

	var r0 map[string]*persistence.TimerInfo
	if rf, ok := ret.Get(0).(func() map[string]*persistence.TimerInfo); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string]*persistence.TimerInfo)
		}
	}

	return r0
}

// GetReplicationState provides a mock function with given fields:
func (_m *mockMutableState) GetReplicationState() *persistence.ReplicationState {
	ret := _m.Called()

	var r0 *persistence.ReplicationState
	if rf, ok := ret.Get(0).(func() *persistence.ReplicationState); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*persistence.ReplicationState)
		}
	}

	return r0
}

// GetRequestCancelInfo provides a mock function with given fields: _a0
func (_m *mockMutableState) GetRequestCancelInfo(_a0 int64) (*persistence.RequestCancelInfo, bool) {
	ret := _m.Called(_a0)

	var r0 *persistence.RequestCancelInfo
	if rf, ok := ret.Get(0).(func(int64) *persistence.RequestCancelInfo); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*persistence.RequestCancelInfo)
		}
	}

	var r1 bool
	if rf, ok := ret.Get(1).(func(int64) bool); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Get(1).(bool)
	}

	return r0, r1
}

// GetRetryBackoffDuration provides a mock function
func (_m *mockMutableState) GetRetryBackoffDuration(errReason string) time.Duration {
	ret := _m.Called()

	var r0 time.Duration
	if rf, ok := ret.Get(0).(func(string) time.Duration); ok {
		r0 = rf(errReason)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(time.Duration)
		}
	}

	return r0
}

// GetCronBackoffDuration provides a mock function
func (_m *mockMutableState) GetCronBackoffDuration() time.Duration {
	ret := _m.Called()

	var r0 time.Duration
	if rf, ok := ret.Get(0).(func() time.Duration); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(time.Duration)
		}
	}

	return r0
}

// GetScheduleIDByActivityID provides a mock function with given fields: _a0
func (_m *mockMutableState) GetScheduleIDByActivityID(_a0 string) (int64, bool) {
	ret := _m.Called(_a0)

	var r0 int64
	if rf, ok := ret.Get(0).(func(string) int64); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Get(0).(int64)
	}

	var r1 bool
	if rf, ok := ret.Get(1).(func(string) bool); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Get(1).(bool)
	}

	return r0, r1
}

// GetSignalInfo provides a mock function with given fields: _a0
func (_m *mockMutableState) GetSignalInfo(_a0 int64) (*persistence.SignalInfo, bool) {
	ret := _m.Called(_a0)

	var r0 *persistence.SignalInfo
	if rf, ok := ret.Get(0).(func(int64) *persistence.SignalInfo); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*persistence.SignalInfo)
		}
	}

	var r1 bool
	if rf, ok := ret.Get(1).(func(int64) bool); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Get(1).(bool)
	}

	return r0, r1
}

// GetStartVersion provides a mock function with given fields:
func (_m *mockMutableState) GetStartVersion() int64 {
	ret := _m.Called()

	var r0 int64
	if rf, ok := ret.Get(0).(func() int64); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(int64)
	}

	return r0
}

// GetUserTimer provides a mock function with given fields: _a0
func (_m *mockMutableState) GetUserTimer(_a0 string) (bool, *persistence.TimerInfo) {
	ret := _m.Called(_a0)

	var r0 bool
	if rf, ok := ret.Get(0).(func(string) bool); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Get(0).(bool)
	}

	var r1 *persistence.TimerInfo
	if rf, ok := ret.Get(1).(func(string) *persistence.TimerInfo); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*persistence.TimerInfo)
		}
	}

	return r0, r1
}

// GetWorkflowType provides a mock function with given fields:
func (_m *mockMutableState) GetWorkflowType() *shared.WorkflowType {
	ret := _m.Called()

	var r0 *shared.WorkflowType
	if rf, ok := ret.Get(0).(func() *shared.WorkflowType); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.WorkflowType)
		}
	}

	return r0
}

// HasBufferedEvents provides a mock function with given fields:
func (_m *mockMutableState) HasBufferedEvents() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// HasBufferedReplicationTasks provides a mock function with given fields:
func (_m *mockMutableState) HasBufferedReplicationTasks() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// HasInFlightDecisionTask provides a mock function with given fields:
func (_m *mockMutableState) HasInFlightDecisionTask() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// HasParentExecution provides a mock function with given fields:
func (_m *mockMutableState) HasParentExecution() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// HasPendingDecisionTask provides a mock function with given fields:
func (_m *mockMutableState) HasPendingDecisionTask() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// HasProcessedOrPendingDecisionTask provides a mock function with given fields:
func (_m *mockMutableState) HasProcessedOrPendingDecisionTask() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// IncrementHistorySize provides a mock function with given fields: appendSize
func (_m *mockMutableState) IncrementHistorySize(appendSize int) {
	_m.Called(appendSize)
}

// IsCancelRequested provides a mock function with given fields:
func (_m *mockMutableState) IsCancelRequested() (bool, string) {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	var r1 string
	if rf, ok := ret.Get(1).(func() string); ok {
		r1 = rf()
	} else {
		r1 = ret.Get(1).(string)
	}

	return r0, r1
}

// IsSignalRequested provides a mock function with given fields: requestID
func (_m *mockMutableState) IsSignalRequested(requestID string) bool {
	ret := _m.Called(requestID)

	var r0 bool
	if rf, ok := ret.Get(0).(func(string) bool); ok {
		r0 = rf(requestID)
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// IsStickyTaskListEnabled provides a mock function with given fields:
func (_m *mockMutableState) IsStickyTaskListEnabled() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// IsWorkflowExecutionRunning provides a mock function with given fields:
func (_m *mockMutableState) IsWorkflowExecutionRunning() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// Load provides a mock function with given fields: _a0
func (_m *mockMutableState) Load(_a0 *persistence.WorkflowMutableState) {
	_m.Called(_a0)
}

// ReplicateActivityInfo provides a mock function with given fields: _a0
func (_m *mockMutableState) ReplicateActivityInfo(_a0 *h.SyncActivityRequest, _a1 bool) error {
	ret := _m.Called(_a0, _a1)

	var r0 error
	if rf, ok := ret.Get(0).(func(*h.SyncActivityRequest, bool) error); ok {
		r0 = rf(_a0, _a1)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ReplicateActivityTaskCancelRequestedEvent provides a mock function with given fields: _a0
func (_m *mockMutableState) ReplicateActivityTaskCancelRequestedEvent(_a0 *shared.HistoryEvent) {
	_m.Called(_a0)
}

// ReplicateActivityTaskCanceledEvent provides a mock function with given fields: _a0
func (_m *mockMutableState) ReplicateActivityTaskCanceledEvent(_a0 *shared.HistoryEvent) error {
	ret := _m.Called(_a0)

	var r0 error
	if rf, ok := ret.Get(0).(func(*shared.HistoryEvent) error); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ReplicateActivityTaskCompletedEvent provides a mock function with given fields: _a0
func (_m *mockMutableState) ReplicateActivityTaskCompletedEvent(_a0 *shared.HistoryEvent) error {
	ret := _m.Called(_a0)

	var r0 error
	if rf, ok := ret.Get(0).(func(*shared.HistoryEvent) error); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ReplicateActivityTaskFailedEvent provides a mock function with given fields: _a0
func (_m *mockMutableState) ReplicateActivityTaskFailedEvent(_a0 *shared.HistoryEvent) error {
	ret := _m.Called(_a0)

	var r0 error
	if rf, ok := ret.Get(0).(func(*shared.HistoryEvent) error); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ReplicateActivityTaskScheduledEvent provides a mock function with given fields: _a0
func (_m *mockMutableState) ReplicateActivityTaskScheduledEvent(_a0 int64, _a1 *shared.HistoryEvent) *persistence.ActivityInfo {
	ret := _m.Called(_a0, _a1)

	var r0 *persistence.ActivityInfo
	if rf, ok := ret.Get(0).(func(int64, *shared.HistoryEvent) *persistence.ActivityInfo); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*persistence.ActivityInfo)
		}
	}

	return r0
}

// ReplicateActivityTaskStartedEvent provides a mock function with given fields: _a0
func (_m *mockMutableState) ReplicateActivityTaskStartedEvent(_a0 *shared.HistoryEvent) {
	_m.Called(_a0)
}

// ReplicateActivityTaskTimedOutEvent provides a mock function with given fields: _a0
func (_m *mockMutableState) ReplicateActivityTaskTimedOutEvent(_a0 *shared.HistoryEvent) error {
	ret := _m.Called(_a0)

	var r0 error
	if rf, ok := ret.Get(0).(func(*shared.HistoryEvent) error); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ReplicateChildWorkflowExecutionCanceledEvent provides a mock function with given fields: _a0
func (_m *mockMutableState) ReplicateChildWorkflowExecutionCanceledEvent(_a0 *shared.HistoryEvent) {
	_m.Called(_a0)
}

// ReplicateChildWorkflowExecutionCompletedEvent provides a mock function with given fields: _a0
func (_m *mockMutableState) ReplicateChildWorkflowExecutionCompletedEvent(_a0 *shared.HistoryEvent) {
	_m.Called(_a0)
}

// ReplicateChildWorkflowExecutionFailedEvent provides a mock function with given fields: _a0
func (_m *mockMutableState) ReplicateChildWorkflowExecutionFailedEvent(_a0 *shared.HistoryEvent) {
	_m.Called(_a0)
}

// ReplicateChildWorkflowExecutionStartedEvent provides a mock function with given fields: _a0
func (_m *mockMutableState) ReplicateChildWorkflowExecutionStartedEvent(_a0 *shared.HistoryEvent) error {
	ret := _m.Called(_a0)

	var r0 error
	if rf, ok := ret.Get(0).(func(*shared.HistoryEvent) error); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ReplicateChildWorkflowExecutionTerminatedEvent provides a mock function with given fields: _a0
func (_m *mockMutableState) ReplicateChildWorkflowExecutionTerminatedEvent(_a0 *shared.HistoryEvent) {
	_m.Called(_a0)
}

// ReplicateChildWorkflowExecutionTimedOutEvent provides a mock function with given fields: _a0
func (_m *mockMutableState) ReplicateChildWorkflowExecutionTimedOutEvent(_a0 *shared.HistoryEvent) {
	_m.Called(_a0)
}

// ReplicateDecisionTaskCompletedEvent provides a mock function with given fields: _a0
func (_m *mockMutableState) ReplicateDecisionTaskCompletedEvent(_a0 *shared.HistoryEvent) {
	_m.Called(_a0)
}

// ReplicateDecisionTaskFailedEvent provides a mock function with given fields: _a0, _a1
func (_m *mockMutableState) ReplicateDecisionTaskFailedEvent() {
	_m.Called()
}

// ReplicateDecisionTaskScheduledEvent provides a mock function with given fields: _a0, _a1, _a2, _a3, _a4
func (_m *mockMutableState) ReplicateDecisionTaskScheduledEvent(_a0 int64, _a1 int64, _a2 string, _a3 int32, _a4 int64) *decisionInfo {
	ret := _m.Called(_a0, _a1, _a2, _a3, _a4)

	var r0 *decisionInfo
	if rf, ok := ret.Get(0).(func(int64, int64, string, int32, int64) *decisionInfo); ok {
		r0 = rf(_a0, _a1, _a2, _a3, _a4)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*decisionInfo)
		}
	}

	return r0
}

// ReplicateDecisionTaskStartedEvent provides a mock function with given fields: _a0, _a1, _a2, _a3, _a4, _a5
func (_m *mockMutableState) ReplicateDecisionTaskStartedEvent(_a0 *decisionInfo, _a1 int64, _a2 int64, _a3 int64, _a4 string, _a5 int64) *decisionInfo {
	ret := _m.Called(_a0, _a1, _a2, _a3, _a4, _a5)

	var r0 *decisionInfo
	if rf, ok := ret.Get(0).(func(*decisionInfo, int64, int64, int64, string, int64) *decisionInfo); ok {
		r0 = rf(_a0, _a1, _a2, _a3, _a4, _a5)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*decisionInfo)
		}
	}

	return r0
}

// ReplicateDecisionTaskTimedOutEvent provides a mock function with given fields: _a0, _a1
func (_m *mockMutableState) ReplicateDecisionTaskTimedOutEvent(_a0 shared.TimeoutType) {
	_m.Called(_a0)
}

// ReplicateExternalWorkflowExecutionCancelRequested provides a mock function with given fields: _a0
func (_m *mockMutableState) ReplicateExternalWorkflowExecutionCancelRequested(_a0 *shared.HistoryEvent) {
	_m.Called(_a0)
}

// ReplicateExternalWorkflowExecutionSignaled provides a mock function with given fields: _a0
func (_m *mockMutableState) ReplicateExternalWorkflowExecutionSignaled(_a0 *shared.HistoryEvent) {
	_m.Called(_a0)
}

// ReplicateRequestCancelExternalWorkflowExecutionFailedEvent provides a mock function with given fields: _a0
func (_m *mockMutableState) ReplicateRequestCancelExternalWorkflowExecutionFailedEvent(_a0 *shared.HistoryEvent) {
	_m.Called(_a0)
}

// ReplicateRequestCancelExternalWorkflowExecutionInitiatedEvent provides a mock function with given fields: _a0, _a1
func (_m *mockMutableState) ReplicateRequestCancelExternalWorkflowExecutionInitiatedEvent(_a0 *shared.HistoryEvent, _a1 string) *persistence.RequestCancelInfo {
	ret := _m.Called(_a0, _a1)

	var r0 *persistence.RequestCancelInfo
	if rf, ok := ret.Get(0).(func(*shared.HistoryEvent, string) *persistence.RequestCancelInfo); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*persistence.RequestCancelInfo)
		}
	}

	return r0
}

// ReplicateSignalExternalWorkflowExecutionFailedEvent provides a mock function with given fields: _a0
func (_m *mockMutableState) ReplicateSignalExternalWorkflowExecutionFailedEvent(_a0 *shared.HistoryEvent) {
	_m.Called(_a0)
}

// ReplicateSignalExternalWorkflowExecutionInitiatedEvent provides a mock function with given fields: _a0, _a1
func (_m *mockMutableState) ReplicateSignalExternalWorkflowExecutionInitiatedEvent(_a0 *shared.HistoryEvent, _a1 string) *persistence.SignalInfo {
	ret := _m.Called(_a0, _a1)

	var r0 *persistence.SignalInfo
	if rf, ok := ret.Get(0).(func(*shared.HistoryEvent, string) *persistence.SignalInfo); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*persistence.SignalInfo)
		}
	}

	return r0
}

// ReplicateStartChildWorkflowExecutionFailedEvent provides a mock function with given fields: _a0
func (_m *mockMutableState) ReplicateStartChildWorkflowExecutionFailedEvent(_a0 *shared.HistoryEvent) {
	_m.Called(_a0)
}

// ReplicateStartChildWorkflowExecutionInitiatedEvent provides a mock function with given fields: _a0, _a1, _a2
func (_m *mockMutableState) ReplicateStartChildWorkflowExecutionInitiatedEvent(_a0 int64, _a1 *shared.HistoryEvent, _a2 string) *persistence.ChildExecutionInfo {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 *persistence.ChildExecutionInfo
	if rf, ok := ret.Get(0).(func(int64, *shared.HistoryEvent, string) *persistence.ChildExecutionInfo); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*persistence.ChildExecutionInfo)
		}
	}

	return r0
}

// ReplicateTimerCanceledEvent provides a mock function with given fields: _a0
func (_m *mockMutableState) ReplicateTimerCanceledEvent(_a0 *shared.HistoryEvent) {
	_m.Called(_a0)
}

// ReplicateTimerFiredEvent provides a mock function with given fields: _a0
func (_m *mockMutableState) ReplicateTimerFiredEvent(_a0 *shared.HistoryEvent) {
	_m.Called(_a0)
}

// ReplicateTimerStartedEvent provides a mock function with given fields: _a0
func (_m *mockMutableState) ReplicateTimerStartedEvent(_a0 *shared.HistoryEvent) *persistence.TimerInfo {
	ret := _m.Called(_a0)

	var r0 *persistence.TimerInfo
	if rf, ok := ret.Get(0).(func(*shared.HistoryEvent) *persistence.TimerInfo); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*persistence.TimerInfo)
		}
	}

	return r0
}

// ReplicateTransientDecisionTaskScheduled provides a mock function with given fields: _a0
func (_m *mockMutableState) ReplicateTransientDecisionTaskScheduled() *decisionInfo {
	ret := _m.Called()

	var r0 *decisionInfo
	if rf, ok := ret.Get(0).(func() *decisionInfo); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*decisionInfo)
		}
	}

	return r0
}

// ReplicateWorkflowExecutionCancelRequestedEvent provides a mock function with given fields: _a0
func (_m *mockMutableState) ReplicateWorkflowExecutionCancelRequestedEvent(_a0 *shared.HistoryEvent) {
	_m.Called(_a0)
}

// ReplicateWorkflowExecutionCanceledEvent provides a mock function with given fields: _a0, _a1
func (_m *mockMutableState) ReplicateWorkflowExecutionCanceledEvent(_a0 int64, _a1 *shared.HistoryEvent) {
	_m.Called(_a0, _a1)
}

// ReplicateWorkflowExecutionCompletedEvent provides a mock function with given fields: _a0, _a1
func (_m *mockMutableState) ReplicateWorkflowExecutionCompletedEvent(_a0 int64, _a1 *shared.HistoryEvent) {
	_m.Called(_a0, _a1)
}

// ReplicateWorkflowExecutionContinuedAsNewEvent provides a mock function with given fields: _a0, _a1, _a2, _a3, _a4, _a5
func (_m *mockMutableState) ReplicateWorkflowExecutionContinuedAsNewEvent(_a0 int64, _a1 string, _a2 string, _a3 *shared.HistoryEvent, _a4 *shared.HistoryEvent, _a5 *decisionInfo, _a6 mutableState, _a7 int32, _a8 int32) error {
	ret := _m.Called(_a0, _a1, _a2, _a3, _a4, _a5, _a6, _a7, _a8)

	var r0 error
	if rf, ok := ret.Get(0).(func(int64, string, string, *shared.HistoryEvent, *shared.HistoryEvent, *decisionInfo, mutableState, int32, int32) error); ok {
		r0 = rf(_a0, _a1, _a2, _a3, _a4, _a5, _a6, _a7, _a8)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// ReplicateWorkflowExecutionFailedEvent provides a mock function with given fields: _a0, a1
func (_m *mockMutableState) ReplicateWorkflowExecutionFailedEvent(_a0 int64, _a1 *shared.HistoryEvent) {
	_m.Called(_a0, _a1)
}

// ReplicateWorkflowExecutionSignaled provides a mock function with given fields: _a0
func (_m *mockMutableState) ReplicateWorkflowExecutionSignaled(_a0 *shared.HistoryEvent) {
	_m.Called(_a0)
}

// ReplicateWorkflowExecutionStartedEvent provides a mock function with given fields: _a0, _a1, _a2, _a3, _a4
func (_m *mockMutableState) ReplicateWorkflowExecutionStartedEvent(_a0 string, _a1 *string, _a2 shared.WorkflowExecution, _a3 string, _a4 *shared.HistoryEvent) {
	_m.Called(_a0, _a1, _a2, _a3, _a4)
}

// ReplicateWorkflowExecutionTerminatedEvent provides a mock function with given fields: _a0, _a1
func (_m *mockMutableState) ReplicateWorkflowExecutionTerminatedEvent(_a0 int64, _a1 *shared.HistoryEvent) {
	_m.Called(_a0, _a1)
}

// ReplicateWorkflowExecutionTimedoutEvent provides a mock function with given fields: _a0, _a1
func (_m *mockMutableState) ReplicateWorkflowExecutionTimedoutEvent(_a0 int64, _a1 *shared.HistoryEvent) {
	_m.Called(_a0, _a1)
}

// ResetSnapshot provides a mock function with given fields:
func (_m *mockMutableState) ResetSnapshot(_a0 string) *persistence.ResetMutableStateRequest {
	ret := _m.Called(_a0)

	var r0 *persistence.ResetMutableStateRequest
	if rf, ok := ret.Get(0).(func(string) *persistence.ResetMutableStateRequest); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*persistence.ResetMutableStateRequest)
		}
	}

	return r0
}

// SetHistoryBuilder provides a mock function with given fields: hBuilder
func (_m *mockMutableState) SetHistoryBuilder(hBuilder *historyBuilder) {
	_m.Called(hBuilder)
}

// SetNewRunSize provides a mock function with given fields: size
func (_m *mockMutableState) SetNewRunSize(size int) {
	_m.Called(size)
}

// UpdateActivity provides a mock function with given fields: _a0
func (_m *mockMutableState) UpdateActivity(_a0 *persistence.ActivityInfo) error {
	ret := _m.Called(_a0)

	var r0 error
	if rf, ok := ret.Get(0).(func(*persistence.ActivityInfo) error); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

func (_m *mockMutableState) SetHistoryTree(_a0 string) error {
	ret := _m.Called(_a0)

	var r0 error
	if rf, ok := ret.Get(0).(func(string) error); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UpdateActivityProgress provides a mock function with given fields: ai, request
func (_m *mockMutableState) UpdateActivityProgress(ai *persistence.ActivityInfo, request *shared.RecordActivityTaskHeartbeatRequest) {
	_m.Called(ai, request)
}

// UpdateDecision provides a mock function with given fields: _a0
func (_m *mockMutableState) UpdateDecision(_a0 *decisionInfo) {
	_m.Called(_a0)
}

// UpdateReplicationStateLastEventID provides a mock function with given fields: clusterName, lastWriteVersion, lastEventID
func (_m *mockMutableState) UpdateReplicationStateLastEventID(clusterName string, lastWriteVersion int64, lastEventID int64) {
	_m.Called(clusterName, lastWriteVersion, lastEventID)
}

// UpdateReplicationStateVersion provides a mock function with given fields: version, forceUpdate
func (_m *mockMutableState) UpdateReplicationStateVersion(version int64, forceUpdate bool) {
	_m.Called(version, forceUpdate)
}

// UpdateUserTimer provides a mock function with given fields: _a0, _a1
func (_m *mockMutableState) UpdateUserTimer(_a0 string, _a1 *persistence.TimerInfo) {
	_m.Called(_a0, _a1)
}
