// Copyright (c) 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

package history

import (
	"github.com/stretchr/testify/mock"
	"github.com/uber/cadence/.gen/go/shared"
	"github.com/uber/cadence/common/persistence"
)

// mockStateBuilder is an autogenerated mock type for the stateBuilder type
type mockStateBuilder struct {
	mock.Mock
}

var _ stateBuilder = (*mockStateBuilder)(nil)

// getTransferTasks provides a mock function with given fields:
func (_m *mockStateBuilder) getTransferTasks() []persistence.Task {
	ret := _m.Called()

	var r0 []persistence.Task
	if rf, ok := ret.Get(0).(func() []persistence.Task); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]persistence.Task)
		}
	}
	return r0
}

// getTimerTasks provides a mock function with given fields:
func (_m *mockStateBuilder) getTimerTasks() []persistence.Task {
	ret := _m.Called()

	var r0 []persistence.Task
	if rf, ok := ret.Get(0).(func() []persistence.Task); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]persistence.Task)
		}
	}
	return r0
}

// getNewRunTransferTasks provides a mock function with given fields:
func (_m *mockStateBuilder) getNewRunTransferTasks() []persistence.Task {
	ret := _m.Called()

	var r0 []persistence.Task
	if rf, ok := ret.Get(0).(func() []persistence.Task); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]persistence.Task)
		}
	}
	return r0
}

// getNewRunTimerTasks provides a mock function with given fields:
func (_m *mockStateBuilder) getNewRunTimerTasks() []persistence.Task {
	ret := _m.Called()

	var r0 []persistence.Task
	if rf, ok := ret.Get(0).(func() []persistence.Task); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]persistence.Task)
		}
	}
	return r0
}

// applyEvents provides a mock function with given fields: domainID, requestID, execution, _a3, newRunHistory
func (_m *mockStateBuilder) applyEvents(domainID string, requestID string, execution shared.WorkflowExecution, _a3 []*shared.HistoryEvent,
	newRunHistory []*shared.HistoryEvent, eventStoreVersion, newRunEventStoreVersion int32) (*shared.HistoryEvent, *decisionInfo, mutableState, error) {

	ret := _m.Called(domainID, requestID, execution, _a3, newRunHistory, eventStoreVersion, newRunEventStoreVersion)

	var r0 *shared.HistoryEvent
	if rf, ok := ret.Get(0).(func(string, string, shared.WorkflowExecution, []*shared.HistoryEvent, []*shared.HistoryEvent, int32, int32) *shared.HistoryEvent); ok {
		r0 = rf(domainID, requestID, execution, _a3, newRunHistory, eventStoreVersion, newRunEventStoreVersion)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*shared.HistoryEvent)
		}
	}

	var r1 *decisionInfo
	if rf, ok := ret.Get(1).(func(string, string, shared.WorkflowExecution, []*shared.HistoryEvent, []*shared.HistoryEvent, int32, int32) *decisionInfo); ok {
		r1 = rf(domainID, requestID, execution, _a3, newRunHistory, eventStoreVersion, newRunEventStoreVersion)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*decisionInfo)
		}
	}

	var r2 mutableState
	if rf, ok := ret.Get(2).(func(string, string, shared.WorkflowExecution, []*shared.HistoryEvent, []*shared.HistoryEvent, int32, int32) mutableState); ok {
		r2 = rf(domainID, requestID, execution, _a3, newRunHistory, eventStoreVersion, newRunEventStoreVersion)
	} else {
		if ret.Get(2) != nil {
			r2 = ret.Get(2).(mutableState)
		}
	}

	var r3 error
	if rf, ok := ret.Get(3).(func(string, string, shared.WorkflowExecution, []*shared.HistoryEvent, []*shared.HistoryEvent, int32, int32) error); ok {
		r3 = rf(domainID, requestID, execution, _a3, newRunHistory, eventStoreVersion, newRunEventStoreVersion)
	} else {
		r3 = ret.Error(3)
	}

	return r0, r1, r2, r3
}

// getMutableState provides a mock function with given fields:
func (_m *mockStateBuilder) getMutableState() mutableState {
	ret := _m.Called()

	var r0 mutableState
	if rf, ok := ret.Get(0).(func() mutableState); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(mutableState)
		}
	}
	return r0
}
