Cadence Worker
==============

Cadence Worker is a new role for Cadence service used for hosting any
components responsible for performing background processing on the Cadence
cluster.

Replicator
----------

Replicator is a background worker responsible for consuming replication tasks
generated by remote Cadence clusters and pass it down to processor so they
can be applied to local Cadence cluster.

It uses Kafka as the replication tasks buffer and relies on
[kafka-client library] (https://github.com/uber-go/kafka-client/) for consuming
messages from Kafka.


Quickstart for localhost development
====================================

1. Setup Kafka by following instructions:
[Kafka Quickstart](https://kafka.apache.org/quickstart)
2. Create Kafka topic for active cluster:
```
bin/kafka-topics.sh --create --zookeeper localhost:2181 --replication-factor 1 --partitions 1 --topic active
```
3. Create Kafka topic for standby cluster:
```
bin/kafka-topics.sh --create --zookeeper localhost:2181 --replication-factor 1 --partitions 1 --topic standby
```
4. Start Cadence development server for active zone:
```
./cadence-server --zone active start
```


Cadence cluster is now running with the replicator consuming messages from
Kafka topic standby.

Create replication task using CLI
---------------------------------

Kafka CLI can be used to generate a replication task for testing purpose:

```
bin/kafka-console-producer.sh --broker-list localhost:9092 --topic standby
```

Replication task message:
```
{taskType: 0}
```

Archiver
--------

Archiver is used to handle archival of workflow execution histories. It does this by hosting a cadence client worker
and running an archival system workflow. The archival client gets used to initiate archival through signal sending. The archiver
shards work across several workflows. 
