/**
 * 数字输入框
 * varstion 1.0.1
 * by Houfeng
 * Houfeng@DCloud.io
 */

(function($) {

	var touchSupport = ('ontouchstart' in document);
	var tapEventName = touchSupport ? 'tap' : 'click';
	var changeEventName = 'change';
	var holderClassName = $.className('numbox');
	var plusClassName = $.className('numbox-btn-plus');
	var minusClassName = $.className('numbox-btn-minus');
	var inputClassName = $.className('numbox-input');

	var Numbox = $.Numbox = $.Class.extend({
		/**
		 * 构造函数
		 **/
		init: function(holder, options) {
			var self = this;
			if (!holder) {
				throw "构造 numbox 时缺少容器元素";
			}
			self.holder = holder;
			options = options || {};
			options.step = parseInt(options.step || 1);
			self.options = options;
			self.input = $.qsa('.' + inputClassName, self.holder)[0];
			self.plus = $.qsa('.' + plusClassName, self.holder)[0];
			self.minus = $.qsa('.' + minusClassName, self.holder)[0];
			self.checkValue();
			self.initEvent();
		},
		/**
		 * 初始化事件绑定
		 **/
		initEvent: function() {
			var self = this;
			self.plus.addEventListener(tapEventName, function(event) {
				var val = parseInt(self.input.value) + self.options.step;
				self.input.value = val.toString();
				$.trigger(self.input, changeEventName, null);
			});
			self.minus.addEventListener(tapEventName, function(event) {
				var val = parseInt(self.input.value) - self.options.step;
				self.input.value = val.toString();
				$.trigger(self.input, changeEventName, null);
			});
			self.input.addEventListener(changeEventName, function(event) {
				self.checkValue();
				$.trigger(self, changeEventName, self.getValue());
			});
		},
		/**
		 * 获取当前值
		 **/
		getValue: function() {
			var self = this;
			return parseInt(self.input.value);
		},
		/**
		 * 验证当前值是法合法
		 **/
		checkValue: function() {
			var self = this;
			var val = self.input.value;
			if (val == null || val == '' || isNaN(val)) {
				self.input.value = self.options.min || 0;
				self.minus.disabled = self.options.min != null;
			} else {
				var val = parseInt(val);
				if (self.options.max != null && !isNaN(self.options.max) && val >= parseInt(self.options.max)) {
					val = self.options.max;
					self.plus.disabled = true;
				} else {
					self.plus.disabled = false;
				}
				if (self.options.min != null && !isNaN(self.options.min) && val <= parseInt(self.options.min)) {
					val = self.options.min;
					self.minus.disabled = true;
				} else {
					self.minus.disabled = false;
				}
				self.input.value = val;
			}
		},
		/**
		 * 更新选项
		 **/
		setOption: function(name, value) {
			var self = this;
			self.options[name] = value;
		}
	});

	$.fn.numbox = function(options) {
		var instanceArray = [];
		//遍历选择的元素
		this.each(function(i, element) {
			if (element.numbox) return;
			if (options) {
				element.numbox = new Numbox(element, options);
			} else {
				var optionsText = element.getAttribute('data-numbox-options');
				var options = optionsText ? JSON.parse(optionsText) : {};
				options.step = element.getAttribute('data-numbox-step') || options.step;
				options.min = element.getAttribute('data-numbox-min') || options.min;
				options.max = element.getAttribute('data-numbox-max') || options.max;
				element.numbox = new Numbox(element, options);
			}
		});
		return this[0] ? this[0].numbox : null;
	}

	//自动处理 class='mui-locker' 的 dom
	$.ready(function() {
		$('.' + holderClassName).numbox();
	});

}(mui))