---
layout: doc
title: Npgsql 3.1 Release Notes
---

# Migrating from 3.0 to 3.1

* CommandTimeout used to be implemented with PostgreSQL's `statement_timeout` parameter, but this wasn't a very reliable method and has been removed. CommandTimeout is now implemented via socket timeouts only, see [#689](https://github.com/npgsql/npgsql/issues/689) for more details. Note that if a socket timeout occurs, the connection is broken and must be reopened.
* The [`Persist Security Info`](../connection-string-parameters.md#security-and-encryption) parameter has been implemented and is false by default. This means that once a connection has been opened, you will not be able to get its password.
* Removed ContinuousProcessing mode, and replaced it with [Wait](../wait.md), a simpler and less bug-prone mechanism for consuming asynchronous notifications ([#1024](https://github.com/npgsql/npgsql/issues/1024)).
* The `Maximum Pool Size` connection is parameter is now 100 default instead of 20 (this is default in SqlClient, pg_bouncer...).
* The `Connection Lifetime` parameter has been renamed to `Connection Idle Lifetime`, and its default has been changed from 15 to 300. Also, once the number of seconds has elapsed the connection is closed immediately; the previous behavior closed half of the connections.
* `RegisterEnum` and `RegisterEnumGlobally` have been renamed to `MapEnum` and `MapEnumGlobally` respectively.
* If you used enum mapping in 3.0, the strategy for translating between CLR and PostgreSQL type names has changed. In 3.0 Npgsql simply used the CLR name (e.g. SomeField) as the PostgreSQL name; Npgsql 3.1 uses a user-definable name translator, default to snake case (e.g. some_field). See [#859](https://github.com/npgsql/npgsql/issues/859).
* The `EnumLabel` attribute has been replaced by the `PgName` attribute (which is also used for the new composite type support).
* When PostgreSQL sends an error, it is no longer raised by an NpgsqlException but by a PostgresException. PostgresException is a subclass of NpgsqlException so code catching NpgsqlException should still work, but the PostgreSQL-specific exception properties will only be available on PostgresException.
* The Code property on NpgsqlException has been renamed to SqlState. It has also been moved to PostgresException.
* NpgsqlNotice has been renamed to PostgresNotice
* For multistatement commands, PostgreSQL parse errors will now be thrown only when the user calls NextResult() and gets to the problematic statement.
* It is no longer possible to dispose a prepared statement while a reader is still open. Since disposing a prepared statement includes database interaction, the connection must be idle.
* Removed `NpgsqlConnection.SupportsHexByteFormat`.
* Renamed `NpgsqlConnection.Supports_E_StringPrefix` to `SupportsEStringPrefix`.
