---
layout: doc
title: Npgsql 3.2 Release Notes
---

# Npgsql 3.2

Npgsql 3.2 is out and available on nuget.org. This is a major release with substantial internal changes and should be deployed with care. For critical applications it may be advisable to wait until 3.2.1 is out.

This release contains a large number of new features, but the main focus is performance - some usage scenarios may show dramatic improvements. See below for more details.

## Major Changes

* Prepared statements are now persistent (survive beyond pooled connection close/open), providing significant performance improvements for applications with short-lived connections, such as most webapps ([#483](https://github.com/npgsql/npgsql/issues/483)). Also, statements can optionally be prepared automatically by Npgsql based on use, unlocking prepared statement performance for O/RMs and data layers which don't prepare themselves, such as Dapper or Entity Framework Core ([#1237](https://github.com/npgsql/npgsql/issues/1237)). See [this blog post for more info](http://www.roji.org/prepared-statements-in-npgsql-3-2).
* The internal I/O system has been overhauled to continue supporting sync and async I/O, but with a vastly better coding model. This should eliminate most protocol sync bugs, and make it much easier to maintain and write new type handlers ([#1326](https://github.com/npgsql/npgsql/issues/1326)).
* Kerberos login ("integrated security") is now support on Linux/Mac ([#1079](https://github.com/npgsql/npgsql/issues/1079)).
* Support for System.Transactions and distributed transactions has been rewritten, and should have fewer problems than before ([#122](https://github.com/npgsql/npgsql/issues/122)).
* Performance counters have been implemented, [similar to what SqlClient provides](https://msdn.microsoft.com/en-us/library/ms254503(v=vs.110).aspx). See [the documentation for more information](../performance.md#performance-counters) ([#619](https://github.com/npgsql/npgsql/issues/619)).
* The Visual Studio integration extension (DDEX) has been rewritten for a much better installation experience, and includes some new features as well ([#1407](https://github.com/npgsql/npgsql/issues/1407)). [See the docs for more info](../ddex.md).
* If your application attempts to make use of more than one connection at the same time, an "operation already in progress" was thrown. This exception now provides more information to help you track down the bug ([#1248](https://github.com/npgsql/npgsql/issues/1248)).

Many other small changes have been made, especially with regards to performance. [Here's the full list](https://github.com/npgsql/npgsql/milestone/24?closed=1).

## Breaking Changes from 3.1

* Connections can no longer be constructed with `NpgsqlConnectionStringBuilder` - only plain string connection strings are supported ([#1415](https://github.com/npgsql/npgsql/issues/1415)).
* The `Buffer Size` connection string parameter has been replaced by `Read Buffer Size` and `Write Buffer Size`.
