<?php

/*
 * This file is part of the Sylius package.
 *
 * (c) Paweł Jędrzejewski
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace Sylius\Component\Core\Factory;

use Sylius\Component\Core\Model\PaymentMethodInterface;
use Sylius\Component\Resource\Factory\FactoryInterface;

interface PaymentMethodFactoryInterface extends FactoryInterface
{
    /**
     * @param string $gatewayFactory
     *
     * @return PaymentMethodInterface
     */
    public function createWithGateway(string $gatewayFactory): PaymentMethodInterface;
}
