<?php

/*
 * This file is part of the Sylius package.
 *
 * (c) Paweł Jędrzejewski
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace Sylius\Component\Payment\Resolver;

use Sylius\Component\Payment\Model\PaymentInterface;
use Sylius\Component\Payment\Model\PaymentMethodInterface;

interface DefaultPaymentMethodResolverInterface
{
    /**
     * @param PaymentInterface $payment
     *
     * @return PaymentMethodInterface
     */
    public function getDefaultPaymentMethod(PaymentInterface $payment): PaymentMethodInterface;
}
