// Copyright (c) 2025 The Jaeger Authors.

package sanitizer

import (
	"time"

	"github.com/jaegertracing/jaeger-idl/model/v1"
)

const (
	minDuration     = time.Duration(1)
	invalidDuration = "InvalidNegativeDuration"
)

// negativeDurationSanitizer sanitizes all negative durations to a default value.
type negativeDurationSanitizer struct{}

// NewNegativeDurationSanitizer creates a negative duration sanitizer.
func NewNegativeDurationSanitizer() SanitizeSpan {
	negativeDurationSanitizer := negativeDurationSanitizer{}
	return negativeDurationSanitizer.Sanitize
}

// Sanitize sanitizes the spans with negative durations.
func (*negativeDurationSanitizer) Sanitize(span *model.Span) *model.Span {
	if span.Duration < minDuration {
		span.Tags = append(
			span.Tags,
			model.Binary(
				invalidDuration,
				[]byte("Duration can't be negative, so it is changed to default value"),
			),
		)
		span.Duration = minDuration
	}
	return span
}
