// Copyright (c) 2019 The Jaeger Authors.
// Copyright (c) 2017 Uber Technologies, Inc.
// SPDX-License-Identifier: Apache-2.0

package services

import (
	"github.com/crossdock/crossdock-go"
	"github.com/stretchr/testify/mock"
)

// TMock is an autogenerated mock type for the crossdock.T type.
// Correction: it used to be auto-generated, but now is't fixed.
type TMock struct {
	mock.Mock
}

// Behavior provides a mock function with given fields:
func (_m *TMock) Behavior() string {
	ret := _m.Called()

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// Param provides a mock function with given fields: key
func (_m *TMock) Param(key string) string {
	ret := _m.Called(key)

	var r0 string
	if rf, ok := ret.Get(0).(func(string) string); ok {
		r0 = rf(key)
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// Tag provides a mock function with given fields: key, value
func (_m *TMock) Tag(key string, value string) {
	_m.Called(key, value)
}

// Errorf provides a mock function with given fields: format, args
func (_m *TMock) Errorf(format string, args ...any) {
	_m.Called(format, args)
}

// Skipf provides a mock function with given fields: format, args
func (_m *TMock) Skipf(format string, args ...any) {
	_m.Called(format, args)
}

// Successf provides a mock function with given fields: format, args
func (_m *TMock) Successf(format string, args ...any) {
	_m.Called(format, args)
}

// Fatalf provides a mock function with given fields: format, args
func (_m *TMock) Fatalf(format string, args ...any) {
	_m.Called(format, args)
}

// FailNow provides a mock function with given fields:
func (_m *TMock) FailNow() {
	_m.Called()
}

// Put provides a mock function with given fields: status, output
func (_m *TMock) Put(status crossdock.Status, output string) {
	_m.Called(status, output)
}
