// Code generated by mockery; DO NOT EDIT.
// github.com/vektra/mockery
// template: testify
// Copyright (c) The Jaeger Authors.
// SPDX-License-Identifier: Apache-2.0
//
// Run 'make generate-mocks' to regenerate.

package mocks

import (
	"time"

	mock "github.com/stretchr/testify/mock"
)

// NewLock creates a new instance of Lock. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewLock(t interface {
	mock.TestingT
	Cleanup(func())
}) *Lock {
	mock := &Lock{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// Lock is an autogenerated mock type for the Lock type
type Lock struct {
	mock.Mock
}

type Lock_Expecter struct {
	mock *mock.Mock
}

func (_m *Lock) EXPECT() *Lock_Expecter {
	return &Lock_Expecter{mock: &_m.Mock}
}

// Acquire provides a mock function for the type Lock
func (_mock *Lock) Acquire(resource string, ttl time.Duration) (bool, error) {
	ret := _mock.Called(resource, ttl)

	if len(ret) == 0 {
		panic("no return value specified for Acquire")
	}

	var r0 bool
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(string, time.Duration) (bool, error)); ok {
		return returnFunc(resource, ttl)
	}
	if returnFunc, ok := ret.Get(0).(func(string, time.Duration) bool); ok {
		r0 = returnFunc(resource, ttl)
	} else {
		r0 = ret.Get(0).(bool)
	}
	if returnFunc, ok := ret.Get(1).(func(string, time.Duration) error); ok {
		r1 = returnFunc(resource, ttl)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// Lock_Acquire_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Acquire'
type Lock_Acquire_Call struct {
	*mock.Call
}

// Acquire is a helper method to define mock.On call
//   - resource string
//   - ttl time.Duration
func (_e *Lock_Expecter) Acquire(resource interface{}, ttl interface{}) *Lock_Acquire_Call {
	return &Lock_Acquire_Call{Call: _e.mock.On("Acquire", resource, ttl)}
}

func (_c *Lock_Acquire_Call) Run(run func(resource string, ttl time.Duration)) *Lock_Acquire_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 string
		if args[0] != nil {
			arg0 = args[0].(string)
		}
		var arg1 time.Duration
		if args[1] != nil {
			arg1 = args[1].(time.Duration)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *Lock_Acquire_Call) Return(acquired bool, err error) *Lock_Acquire_Call {
	_c.Call.Return(acquired, err)
	return _c
}

func (_c *Lock_Acquire_Call) RunAndReturn(run func(resource string, ttl time.Duration) (bool, error)) *Lock_Acquire_Call {
	_c.Call.Return(run)
	return _c
}

// Forfeit provides a mock function for the type Lock
func (_mock *Lock) Forfeit(resource string) (bool, error) {
	ret := _mock.Called(resource)

	if len(ret) == 0 {
		panic("no return value specified for Forfeit")
	}

	var r0 bool
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(string) (bool, error)); ok {
		return returnFunc(resource)
	}
	if returnFunc, ok := ret.Get(0).(func(string) bool); ok {
		r0 = returnFunc(resource)
	} else {
		r0 = ret.Get(0).(bool)
	}
	if returnFunc, ok := ret.Get(1).(func(string) error); ok {
		r1 = returnFunc(resource)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// Lock_Forfeit_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Forfeit'
type Lock_Forfeit_Call struct {
	*mock.Call
}

// Forfeit is a helper method to define mock.On call
//   - resource string
func (_e *Lock_Expecter) Forfeit(resource interface{}) *Lock_Forfeit_Call {
	return &Lock_Forfeit_Call{Call: _e.mock.On("Forfeit", resource)}
}

func (_c *Lock_Forfeit_Call) Run(run func(resource string)) *Lock_Forfeit_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 string
		if args[0] != nil {
			arg0 = args[0].(string)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *Lock_Forfeit_Call) Return(forfeited bool, err error) *Lock_Forfeit_Call {
	_c.Call.Return(forfeited, err)
	return _c
}

func (_c *Lock_Forfeit_Call) RunAndReturn(run func(resource string) (bool, error)) *Lock_Forfeit_Call {
	_c.Call.Return(run)
	return _c
}
