// Copyright (c) 2025 The Jaeger Authors.
// SPDX-License-Identifier: Apache-2.0

package tracestore

import (
	"time"

	"go.opentelemetry.io/collector/pdata/pcommon"

	"github.com/jaegertracing/jaeger/internal/storage/v2/clickhouse/tracestore/dbmodel"
)

var traceID = pcommon.TraceID([16]byte{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1})

var now = time.Date(2025, 6, 14, 10, 0, 0, 0, time.UTC)

var singleSpan = []*dbmodel.SpanRow{
	{
		ID:            "0000000000000001",
		TraceID:       traceID.String(),
		TraceState:    "state1",
		Name:          "GET /api/user",
		Kind:          "server",
		StartTime:     now,
		StatusCode:    "Ok",
		StatusMessage: "success",
		Duration:      1_000_000_000,
		Attributes: dbmodel.Attributes{
			BoolKeys:     []string{"authenticated", "cache_hit"},
			BoolValues:   []bool{true, false},
			DoubleKeys:   []string{"response_time", "cpu_usage"},
			DoubleValues: []float64{0.123, 45.67},
			IntKeys:      []string{"user_id", "request_size"},
			IntValues:    []int64{12345, 1024},
			StrKeys:      []string{"http.method", "http.url"},
			StrValues:    []string{"GET", "/api/user"},
			ComplexKeys: []string{
				"@bytes@request_body",
				"@map@metadata",
				"@slice@tags",
			},
			ComplexValues: []string{
				"eyJuYW1lIjoidGVzdCJ9",
				"{\"kvlistValue\":{\"values\":[{\"key\":\"key\",\"value\":{\"stringValue\":\"value\"}}]}}",
				"{\"arrayValue\":{\"values\":[{\"intValue\":\"1\"},{\"intValue\":\"2\"},{\"intValue\":\"3\"}]}}",
			},
		},
		EventNames:      []string{"login"},
		EventTimestamps: []time.Time{now},
		EventAttributes: dbmodel.Attributes2D{
			BoolKeys:     [][]string{{"event.authenticated", "event.cached"}},
			BoolValues:   [][]bool{{true, false}},
			DoubleKeys:   [][]string{{"event.response_time"}},
			DoubleValues: [][]float64{{0.001}},
			IntKeys:      [][]string{{"event.sequence"}},
			IntValues:    [][]int64{{1}},
			StrKeys:      [][]string{{"event.message"}},
			StrValues:    [][]string{{"user login successful"}},
			ComplexKeys: [][]string{
				{
					"@bytes@event.payload",
					"@map@metadata",
					"@slice@tags",
				},
			},
			ComplexValues: [][]string{
				{
					"eyJ1c2VyX2lkIjoxMjM0NX0=",
					"{\"kvlistValue\":{\"values\":[{\"key\":\"key\",\"value\":{\"stringValue\":\"value\"}}]}}",
					"{\"arrayValue\":{\"values\":[{\"intValue\":\"1\"},{\"intValue\":\"2\"},{\"intValue\":\"3\"}]}}",
				},
			},
		},
		LinkTraceIDs:    []string{"00000000000000000000000000000002"},
		LinkSpanIDs:     []string{"0000000000000002"},
		LinkTraceStates: []string{"state2"},
		LinkAttributes: dbmodel.Attributes2D{
			BoolKeys:     [][]string{{"link.validated", "link.active"}},
			BoolValues:   [][]bool{{true, true}},
			DoubleKeys:   [][]string{{"link.weight"}},
			DoubleValues: [][]float64{{0.8}},
			IntKeys:      [][]string{{"link.priority"}},
			IntValues:    [][]int64{{1}},
			StrKeys:      [][]string{{"link.type"}},
			StrValues:    [][]string{{"follows_from"}},
			ComplexKeys: [][]string{
				{
					"@bytes@link.metadata",
					"@map@metadata",
					"@slice@tags",
				},
			},
			ComplexValues: [][]string{
				{
					"eyJsaW5rX2lkIjoxfQ==",
					"{\"kvlistValue\":{\"values\":[{\"key\":\"key\",\"value\":{\"stringValue\":\"value\"}}]}}",
					"{\"arrayValue\":{\"values\":[{\"intValue\":\"1\"},{\"intValue\":\"2\"},{\"intValue\":\"3\"}]}}",
				},
			},
		},
		ServiceName: "user-service",
		ResourceAttributes: dbmodel.Attributes{
			BoolKeys:     []string{"resource.available", "resource.active"},
			BoolValues:   []bool{true, true},
			DoubleKeys:   []string{"resource.cpu_limit", "resource.memory_usage"},
			DoubleValues: []float64{2.5, 80.5},
			IntKeys:      []string{"resource.instance_id", "resource.port"},
			IntValues:    []int64{12345, 8080},
			StrKeys:      []string{"service.name", "resource.host", "resource.region"},
			StrValues:    []string{"user-service", "host-1", "us-west-1"},
			ComplexKeys: []string{
				"@bytes@resource.metadata",
				"@map@metadata",
				"@slice@tags",
			},
			ComplexValues: []string{
				"eyJkZXBsb3ltZW50IjoicHJvZCJ9",
				"{\"kvlistValue\":{\"values\":[{\"key\":\"key\",\"value\":{\"stringValue\":\"value\"}}]}}",
				"{\"arrayValue\":{\"values\":[{\"intValue\":\"1\"},{\"intValue\":\"2\"},{\"intValue\":\"3\"}]}}",
			},
		},
		ScopeName:    "auth-scope",
		ScopeVersion: "v1.0.0",
		ScopeAttributes: dbmodel.Attributes{
			BoolKeys:     []string{"scope.enabled", "scope.persistent"},
			BoolValues:   []bool{true, false},
			DoubleKeys:   []string{"scope.version_number", "scope.priority"},
			DoubleValues: []float64{1.0, 0.8},
			IntKeys:      []string{"scope.instance_count", "scope.max_spans"},
			IntValues:    []int64{5, 1000},
			StrKeys:      []string{"scope.environment", "scope.component"},
			StrValues:    []string{"production", "auth"},
			ComplexKeys: []string{
				"@bytes@scope.metadata",
				"@map@metadata",
				"@slice@tags",
			},
			ComplexValues: []string{
				"eyJzY29wZV90eXBlIjoiYXV0aGVudGljYXRpb24ifQ==",
				"{\"kvlistValue\":{\"values\":[{\"key\":\"key\",\"value\":{\"stringValue\":\"value\"}}]}}",
				"{\"arrayValue\":{\"values\":[{\"intValue\":\"1\"},{\"intValue\":\"2\"},{\"intValue\":\"3\"}]}}",
			},
		},
	},
}

var multipleSpans = []*dbmodel.SpanRow{
	{
		ID:            "0000000000000001",
		TraceID:       traceID.String(),
		TraceState:    "state1",
		Name:          "GET /api/user",
		Kind:          "server",
		StartTime:     now,
		StatusCode:    "Ok",
		StatusMessage: "success",
		Duration:      1_000_000_000,
		Attributes: dbmodel.Attributes{
			BoolKeys:     []string{"authenticated", "cache_hit"},
			BoolValues:   []bool{true, false},
			DoubleKeys:   []string{"response_time", "cpu_usage"},
			DoubleValues: []float64{0.123, 45.67},
			IntKeys:      []string{"user_id", "request_size"},
			IntValues:    []int64{12345, 1024},
			StrKeys:      []string{"http.method", "http.url"},
			StrValues:    []string{"GET", "/api/user"},
			ComplexKeys: []string{
				"@bytes@request_body",
				"@map@metadata",
				"@slice@tags",
			},
			ComplexValues: []string{
				"eyJuYW1lIjoidGVzdCJ9",
				"{\"kvlistValue\":{\"values\":[{\"key\":\"key\",\"value\":{\"stringValue\":\"value\"}}]}}",
				"{\"arrayValue\":{\"values\":[{\"intValue\":\"1\"},{\"intValue\":\"2\"},{\"intValue\":\"3\"}]}}",
			},
		},
		EventNames:      []string{"login"},
		EventTimestamps: []time.Time{now},
		EventAttributes: dbmodel.Attributes2D{
			BoolKeys:     [][]string{{"event.authenticated", "event.cached"}},
			BoolValues:   [][]bool{{true, false}},
			DoubleKeys:   [][]string{{"event.response_time"}},
			DoubleValues: [][]float64{{0.001}},
			IntKeys:      [][]string{{"event.sequence"}},
			IntValues:    [][]int64{{1}},
			StrKeys:      [][]string{{"event.message"}},
			StrValues:    [][]string{{"user login successful"}},
			ComplexKeys: [][]string{
				{
					"@bytes@event.payload",
					"@map@metadata",
					"@slice@tags",
				},
			},
			ComplexValues: [][]string{
				{
					"eyJ1c2VyX2lkIjoxMjM0NX0=",
					"{\"kvlistValue\":{\"values\":[{\"key\":\"key\",\"value\":{\"stringValue\":\"value\"}}]}}",
					"{\"arrayValue\":{\"values\":[{\"intValue\":\"1\"},{\"intValue\":\"2\"},{\"intValue\":\"3\"}]}}",
				},
			},
		},
		LinkTraceIDs:    []string{"00000000000000000000000000000002"},
		LinkSpanIDs:     []string{"0000000000000002"},
		LinkTraceStates: []string{"state2"},
		LinkAttributes: dbmodel.Attributes2D{
			BoolKeys:     [][]string{{"link.validated", "link.active"}},
			BoolValues:   [][]bool{{true, true}},
			DoubleKeys:   [][]string{{"link.weight"}},
			DoubleValues: [][]float64{{0.8}},
			IntKeys:      [][]string{{"link.priority"}},
			IntValues:    [][]int64{{1}},
			StrKeys:      [][]string{{"link.type"}},
			StrValues:    [][]string{{"follows_from"}},
			ComplexKeys: [][]string{
				{
					"@bytes@link.metadata",
					"@map@metadata",
					"@slice@tags",
				},
			},
			ComplexValues: [][]string{
				{
					"eyJsaW5rX2lkIjoxfQ==",
					"{\"kvlistValue\":{\"values\":[{\"key\":\"key\",\"value\":{\"stringValue\":\"value\"}}]}}",
					"{\"arrayValue\":{\"values\":[{\"intValue\":\"1\"},{\"intValue\":\"2\"},{\"intValue\":\"3\"}]}}",
				},
			},
		},
		ServiceName: "user-service",
		ResourceAttributes: dbmodel.Attributes{
			BoolKeys:     []string{"resource.available", "resource.active"},
			BoolValues:   []bool{true, true},
			DoubleKeys:   []string{"resource.cpu_limit", "resource.memory_usage"},
			DoubleValues: []float64{2.5, 80.5},
			IntKeys:      []string{"resource.instance_id", "resource.port"},
			IntValues:    []int64{12345, 8080},
			StrKeys:      []string{"service.name", "resource.host", "resource.region"},
			StrValues:    []string{"user-service", "host-1", "us-west-1"},
			ComplexKeys: []string{
				"@bytes@resource.metadata",
				"@map@metadata",
				"@slice@tags",
			},
			ComplexValues: []string{
				"eyJkZXBsb3ltZW50IjoicHJvZCJ9",
				"{\"kvlistValue\":{\"values\":[{\"key\":\"key\",\"value\":{\"stringValue\":\"value\"}}]}}",
				"{\"arrayValue\":{\"values\":[{\"intValue\":\"1\"},{\"intValue\":\"2\"},{\"intValue\":\"3\"}]}}",
			},
		},
		ScopeName:    "auth-scope",
		ScopeVersion: "v1.0.0",
		ScopeAttributes: dbmodel.Attributes{
			BoolKeys:     []string{"scope.enabled", "scope.persistent"},
			BoolValues:   []bool{true, false},
			DoubleKeys:   []string{"scope.version_number", "scope.priority"},
			DoubleValues: []float64{1.0, 0.8},
			IntKeys:      []string{"scope.instance_count", "scope.max_spans"},
			IntValues:    []int64{5, 1000},
			StrKeys:      []string{"scope.environment", "scope.component"},
			StrValues:    []string{"production", "auth"},
			ComplexKeys: []string{
				"@bytes@scope.metadata",
				"@map@metadata",
				"@slice@tags",
			},
			ComplexValues: []string{
				"eyJzY29wZV90eXBlIjoiYXV0aGVudGljYXRpb24ifQ==",
				"{\"kvlistValue\":{\"values\":[{\"key\":\"key\",\"value\":{\"stringValue\":\"value\"}}]}}",
				"{\"arrayValue\":{\"values\":[{\"intValue\":\"1\"},{\"intValue\":\"2\"},{\"intValue\":\"3\"}]}}",
			},
		},
	},
	{
		ID:            "0000000000000003",
		TraceID:       traceID.String(),
		TraceState:    "state1",
		ParentSpanID:  "0000000000000001",
		Name:          "SELECT /db/query",
		Kind:          "client",
		StartTime:     now.Add(10 * time.Millisecond),
		StatusCode:    "Ok",
		StatusMessage: "success",
		Duration:      500_000_000,
		Attributes: dbmodel.Attributes{
			BoolKeys:     []string{"db.cached", "db.readonly"},
			BoolValues:   []bool{false, true},
			DoubleKeys:   []string{"db.latency", "db.connections"},
			DoubleValues: []float64{0.05, 5.0},
			IntKeys:      []string{"db.rows_affected", "db.connection_id"},
			IntValues:    []int64{150, 42},
			StrKeys:      []string{"db.statement", "db.name"},
			StrValues:    []string{"SELECT * FROM users", "userdb"},
			ComplexKeys: []string{
				"@bytes@db.query_plan",
				"@map@metadata",
				"@slice@tags",
			},
			ComplexValues: []string{
				"UExBTiBTRUxFQ1Q=",
				"{\"kvlistValue\":{\"values\":[{\"key\":\"key\",\"value\":{\"stringValue\":\"value\"}}]}}",
				"{\"arrayValue\":{\"values\":[{\"intValue\":\"1\"},{\"intValue\":\"2\"},{\"intValue\":\"3\"}]}}",
			},
		},
		EventNames:      []string{"query-start", "query-end"},
		EventTimestamps: []time.Time{now.Add(10 * time.Millisecond), now.Add(510 * time.Millisecond)},
		EventAttributes: dbmodel.Attributes2D{
			BoolKeys:     [][]string{{"db.optimized", "db.indexed"}, {"db.cached", "db.successful"}},
			BoolValues:   [][]bool{{true, false}, {true, false}},
			DoubleKeys:   [][]string{{"db.query_time"}, {"db.result_time"}},
			DoubleValues: [][]float64{{0.001}, {0.5}},
			IntKeys:      [][]string{{"db.connection_pool_size"}, {"db.result_count"}},
			IntValues:    [][]int64{{10}, {150}},
			StrKeys:      [][]string{{"db.event.type"}, {"db.event.status"}},
			StrValues:    [][]string{{"query_execution_start"}, {"query_execution_complete"}},
			ComplexKeys: [][]string{
				{
					"@bytes@db.query_metadata",
					"@map@metadata",
					"@slice@tags",
				},
				{
					"@bytes@db.result_metadata",
				},
			},
			ComplexValues: [][]string{
				{
					"eyJxdWVyeV9pZCI6MTIzfQ==",
					"{\"kvlistValue\":{\"values\":[{\"key\":\"key\",\"value\":{\"stringValue\":\"value\"}}]}}",
					"{\"arrayValue\":{\"values\":[{\"intValue\":\"1\"},{\"intValue\":\"2\"},{\"intValue\":\"3\"}]}}",
				},
				{
					"eyJyb3dfY291bnQiOjE1MH0=",
				},
			},
		},
		LinkTraceIDs:    []string{"00000000000000000000000000000004"},
		LinkSpanIDs:     []string{"0000000000000004"},
		LinkTraceStates: []string{"state3"},
		LinkAttributes: dbmodel.Attributes2D{
			BoolKeys:     [][]string{{"link.persistent", "link.direct"}},
			BoolValues:   [][]bool{{true, false}},
			DoubleKeys:   [][]string{{"link.confidence"}},
			DoubleValues: [][]float64{{0.95}},
			IntKeys:      [][]string{{"link.sequence"}},
			IntValues:    [][]int64{{2}},
			StrKeys:      [][]string{{"link.operation"}},
			StrValues:    [][]string{{"child_of"}},
			ComplexKeys: [][]string{
				{
					"@bytes@link.context",
					"@map@metadata",
					"@slice@tags",
				},
			},
			ComplexValues: [][]string{
				{
					"eyJkYl9jb250ZXh0IjoidXNlcmRiIn0=",
					"{\"kvlistValue\":{\"values\":[{\"key\":\"key\",\"value\":{\"stringValue\":\"value\"}}]}}",
					"{\"arrayValue\":{\"values\":[{\"intValue\":\"1\"},{\"intValue\":\"2\"},{\"intValue\":\"3\"}]}}",
				},
			},
		},
		ServiceName: "db-service",
		ResourceAttributes: dbmodel.Attributes{
			BoolKeys:     []string{"resource.persistent", "resource.pooled"},
			BoolValues:   []bool{true, true},
			DoubleKeys:   []string{"resource.cpu_limit", "resource.memory_limit"},
			DoubleValues: []float64{1.5, 512.0},
			IntKeys:      []string{"resource.instance_id", "resource.max_connections"},
			IntValues:    []int64{67890, 100},
			StrKeys:      []string{"service.name", "resource.host", "resource.database_type"},
			StrValues:    []string{"db-service", "db-host-1", "postgresql"},
			ComplexKeys: []string{
				"@bytes@resource.config",
				"@map@metadata",
				"@slice@tags",
			},
			ComplexValues: []string{
				"eyJkYl90eXBlIjoicG9zdGdyZXNxbCJ9",
				"{\"kvlistValue\":{\"values\":[{\"key\":\"key\",\"value\":{\"stringValue\":\"value\"}}]}}",
				"{\"arrayValue\":{\"values\":[{\"intValue\":\"1\"},{\"intValue\":\"2\"},{\"intValue\":\"3\"}]}}",
			},
		},
		ScopeName:    "db-scope",
		ScopeVersion: "v1.0.0",
		ScopeAttributes: dbmodel.Attributes{
			BoolKeys:     []string{"scope.enabled", "scope.persistent"},
			BoolValues:   []bool{true, false},
			DoubleKeys:   []string{"scope.version_number", "scope.priority"},
			DoubleValues: []float64{1.0, 0.8},
			IntKeys:      []string{"scope.instance_count", "scope.max_spans"},
			IntValues:    []int64{5, 1000},
			StrKeys:      []string{"scope.environment", "scope.component"},
			StrValues:    []string{"production", "database"},
			ComplexKeys: []string{
				"@bytes@scope.metadata",
				"@map@metadata",
				"@slice@tags",
			},
			ComplexValues: []string{
				"eyJzY29wZV90eXBlIjoiZGF0YWJhc2UifQ==",
				"{\"kvlistValue\":{\"values\":[{\"key\":\"key\",\"value\":{\"stringValue\":\"value\"}}]}}",
				"{\"arrayValue\":{\"values\":[{\"intValue\":\"1\"},{\"intValue\":\"2\"},{\"intValue\":\"3\"}]}}",
			},
		},
	},
}
