﻿// <auto-generated />

using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using Microsoft.CodeAnalysis.Syntax.InternalSyntax;
using Roslyn.Utilities;

namespace Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax
{
  /// <summary>Provides the base class from which the classes that represent name syntax nodes are derived. This is an abstract class.</summary>
  internal abstract partial class NameSyntax : TypeSyntax
  {
    internal NameSyntax(SyntaxKind kind, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal NameSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    protected NameSyntax(ObjectReader reader)
       : base(reader)
    {
    }
  }

  /// <summary>Provides the base class from which the classes that represent simple name syntax nodes are derived. This is an abstract class.</summary>
  internal abstract partial class SimpleNameSyntax : NameSyntax
  {
    internal SimpleNameSyntax(SyntaxKind kind, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal SimpleNameSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    protected SimpleNameSyntax(ObjectReader reader)
       : base(reader)
    {
    }

    /// <summary>SyntaxToken representing the identifier of the simple name.</summary>
    public abstract SyntaxToken Identifier { get; }
  }

  /// <summary>Class which represents the syntax node for identifier name.</summary>
  internal sealed partial class IdentifierNameSyntax : SimpleNameSyntax
  {
    internal readonly SyntaxToken identifier;

    internal IdentifierNameSyntax(SyntaxKind kind, SyntaxToken identifier, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
    }


    internal IdentifierNameSyntax(SyntaxKind kind, SyntaxToken identifier, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
    }


    internal IdentifierNameSyntax(SyntaxKind kind, SyntaxToken identifier)
        : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
    }

    /// <summary>SyntaxToken representing the keyword for the kind of the identifier name.</summary>
    public override SyntaxToken Identifier => this.identifier;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.identifier;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.IdentifierNameSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitIdentifierName(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitIdentifierName(this);

    public IdentifierNameSyntax Update(SyntaxToken identifier)
    {
        if (identifier != this.Identifier)
        {
            var newNode = SyntaxFactory.IdentifierName(identifier);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new IdentifierNameSyntax(this.Kind, this.identifier, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new IdentifierNameSyntax(this.Kind, this.identifier, GetDiagnostics(), annotations);

    internal IdentifierNameSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 1;
      var identifier = (SyntaxToken)reader.ReadValue();
      if (identifier != null)
      {
         AdjustFlagsAndWidth(identifier);
         this.identifier = identifier;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.identifier);
    }

    static IdentifierNameSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(IdentifierNameSyntax), r => new IdentifierNameSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for qualified name.</summary>
  internal sealed partial class QualifiedNameSyntax : NameSyntax
  {
    internal readonly NameSyntax left;
    internal readonly SyntaxToken dotToken;
    internal readonly SimpleNameSyntax right;

    internal QualifiedNameSyntax(SyntaxKind kind, NameSyntax left, SyntaxToken dotToken, SimpleNameSyntax right, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(left);
        this.left = left;
        this.AdjustFlagsAndWidth(dotToken);
        this.dotToken = dotToken;
        this.AdjustFlagsAndWidth(right);
        this.right = right;
    }


    internal QualifiedNameSyntax(SyntaxKind kind, NameSyntax left, SyntaxToken dotToken, SimpleNameSyntax right, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(left);
        this.left = left;
        this.AdjustFlagsAndWidth(dotToken);
        this.dotToken = dotToken;
        this.AdjustFlagsAndWidth(right);
        this.right = right;
    }


    internal QualifiedNameSyntax(SyntaxKind kind, NameSyntax left, SyntaxToken dotToken, SimpleNameSyntax right)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(left);
        this.left = left;
        this.AdjustFlagsAndWidth(dotToken);
        this.dotToken = dotToken;
        this.AdjustFlagsAndWidth(right);
        this.right = right;
    }

    /// <summary>NameSyntax node representing the name on the left side of the dot token of the qualified name.</summary>
    public NameSyntax Left => this.left;
    /// <summary>SyntaxToken representing the dot.</summary>
    public SyntaxToken DotToken => this.dotToken;
    /// <summary>SimpleNameSyntax node representing the name on the right side of the dot token of the qualified name.</summary>
    public SimpleNameSyntax Right => this.right;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.left;
            case 1: return this.dotToken;
            case 2: return this.right;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.QualifiedNameSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitQualifiedName(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitQualifiedName(this);

    public QualifiedNameSyntax Update(NameSyntax left, SyntaxToken dotToken, SimpleNameSyntax right)
    {
        if (left != this.Left || dotToken != this.DotToken || right != this.Right)
        {
            var newNode = SyntaxFactory.QualifiedName(left, dotToken, right);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new QualifiedNameSyntax(this.Kind, this.left, this.dotToken, this.right, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new QualifiedNameSyntax(this.Kind, this.left, this.dotToken, this.right, GetDiagnostics(), annotations);

    internal QualifiedNameSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var left = (NameSyntax)reader.ReadValue();
      if (left != null)
      {
         AdjustFlagsAndWidth(left);
         this.left = left;
      }
      var dotToken = (SyntaxToken)reader.ReadValue();
      if (dotToken != null)
      {
         AdjustFlagsAndWidth(dotToken);
         this.dotToken = dotToken;
      }
      var right = (SimpleNameSyntax)reader.ReadValue();
      if (right != null)
      {
         AdjustFlagsAndWidth(right);
         this.right = right;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.left);
      writer.WriteValue(this.dotToken);
      writer.WriteValue(this.right);
    }

    static QualifiedNameSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(QualifiedNameSyntax), r => new QualifiedNameSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for generic name.</summary>
  internal sealed partial class GenericNameSyntax : SimpleNameSyntax
  {
    internal readonly SyntaxToken identifier;
    internal readonly TypeArgumentListSyntax typeArgumentList;

    internal GenericNameSyntax(SyntaxKind kind, SyntaxToken identifier, TypeArgumentListSyntax typeArgumentList, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(typeArgumentList);
        this.typeArgumentList = typeArgumentList;
    }


    internal GenericNameSyntax(SyntaxKind kind, SyntaxToken identifier, TypeArgumentListSyntax typeArgumentList, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(typeArgumentList);
        this.typeArgumentList = typeArgumentList;
    }


    internal GenericNameSyntax(SyntaxKind kind, SyntaxToken identifier, TypeArgumentListSyntax typeArgumentList)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(typeArgumentList);
        this.typeArgumentList = typeArgumentList;
    }

    /// <summary>SyntaxToken representing the name of the identifier of the generic name.</summary>
    public override SyntaxToken Identifier => this.identifier;
    /// <summary>TypeArgumentListSyntax node representing the list of type arguments of the generic name.</summary>
    public TypeArgumentListSyntax TypeArgumentList => this.typeArgumentList;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.identifier;
            case 1: return this.typeArgumentList;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.GenericNameSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitGenericName(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitGenericName(this);

    public GenericNameSyntax Update(SyntaxToken identifier, TypeArgumentListSyntax typeArgumentList)
    {
        if (identifier != this.Identifier || typeArgumentList != this.TypeArgumentList)
        {
            var newNode = SyntaxFactory.GenericName(identifier, typeArgumentList);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new GenericNameSyntax(this.Kind, this.identifier, this.typeArgumentList, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new GenericNameSyntax(this.Kind, this.identifier, this.typeArgumentList, GetDiagnostics(), annotations);

    internal GenericNameSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var identifier = (SyntaxToken)reader.ReadValue();
      if (identifier != null)
      {
         AdjustFlagsAndWidth(identifier);
         this.identifier = identifier;
      }
      var typeArgumentList = (TypeArgumentListSyntax)reader.ReadValue();
      if (typeArgumentList != null)
      {
         AdjustFlagsAndWidth(typeArgumentList);
         this.typeArgumentList = typeArgumentList;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.identifier);
      writer.WriteValue(this.typeArgumentList);
    }

    static GenericNameSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(GenericNameSyntax), r => new GenericNameSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for type argument list.</summary>
  internal sealed partial class TypeArgumentListSyntax : CSharpSyntaxNode
  {
    internal readonly SyntaxToken lessThanToken;
    internal readonly GreenNode arguments;
    internal readonly SyntaxToken greaterThanToken;

    internal TypeArgumentListSyntax(SyntaxKind kind, SyntaxToken lessThanToken, GreenNode arguments, SyntaxToken greaterThanToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(lessThanToken);
        this.lessThanToken = lessThanToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(greaterThanToken);
        this.greaterThanToken = greaterThanToken;
    }


    internal TypeArgumentListSyntax(SyntaxKind kind, SyntaxToken lessThanToken, GreenNode arguments, SyntaxToken greaterThanToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(lessThanToken);
        this.lessThanToken = lessThanToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(greaterThanToken);
        this.greaterThanToken = greaterThanToken;
    }


    internal TypeArgumentListSyntax(SyntaxKind kind, SyntaxToken lessThanToken, GreenNode arguments, SyntaxToken greaterThanToken)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(lessThanToken);
        this.lessThanToken = lessThanToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(greaterThanToken);
        this.greaterThanToken = greaterThanToken;
    }

    /// <summary>SyntaxToken representing less than.</summary>
    public SyntaxToken LessThanToken => this.lessThanToken;
    /// <summary>SeparatedSyntaxList of TypeSyntax node representing the type arguments.</summary>
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<TypeSyntax> Arguments => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<TypeSyntax>(new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<CSharpSyntaxNode>(this.arguments));
    /// <summary>SyntaxToken representing greater than.</summary>
    public SyntaxToken GreaterThanToken => this.greaterThanToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.lessThanToken;
            case 1: return this.arguments;
            case 2: return this.greaterThanToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.TypeArgumentListSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitTypeArgumentList(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitTypeArgumentList(this);

    public TypeArgumentListSyntax Update(SyntaxToken lessThanToken, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<TypeSyntax> arguments, SyntaxToken greaterThanToken)
    {
        if (lessThanToken != this.LessThanToken || arguments != this.Arguments || greaterThanToken != this.GreaterThanToken)
        {
            var newNode = SyntaxFactory.TypeArgumentList(lessThanToken, arguments, greaterThanToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new TypeArgumentListSyntax(this.Kind, this.lessThanToken, this.arguments, this.greaterThanToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new TypeArgumentListSyntax(this.Kind, this.lessThanToken, this.arguments, this.greaterThanToken, GetDiagnostics(), annotations);

    internal TypeArgumentListSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var lessThanToken = (SyntaxToken)reader.ReadValue();
      if (lessThanToken != null)
      {
         AdjustFlagsAndWidth(lessThanToken);
         this.lessThanToken = lessThanToken;
      }
      var arguments = (GreenNode)reader.ReadValue();
      if (arguments != null)
      {
         AdjustFlagsAndWidth(arguments);
         this.arguments = arguments;
      }
      var greaterThanToken = (SyntaxToken)reader.ReadValue();
      if (greaterThanToken != null)
      {
         AdjustFlagsAndWidth(greaterThanToken);
         this.greaterThanToken = greaterThanToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.lessThanToken);
      writer.WriteValue(this.arguments);
      writer.WriteValue(this.greaterThanToken);
    }

    static TypeArgumentListSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(TypeArgumentListSyntax), r => new TypeArgumentListSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for alias qualified name.</summary>
  internal sealed partial class AliasQualifiedNameSyntax : NameSyntax
  {
    internal readonly IdentifierNameSyntax alias;
    internal readonly SyntaxToken colonColonToken;
    internal readonly SimpleNameSyntax name;

    internal AliasQualifiedNameSyntax(SyntaxKind kind, IdentifierNameSyntax alias, SyntaxToken colonColonToken, SimpleNameSyntax name, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(alias);
        this.alias = alias;
        this.AdjustFlagsAndWidth(colonColonToken);
        this.colonColonToken = colonColonToken;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
    }


    internal AliasQualifiedNameSyntax(SyntaxKind kind, IdentifierNameSyntax alias, SyntaxToken colonColonToken, SimpleNameSyntax name, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(alias);
        this.alias = alias;
        this.AdjustFlagsAndWidth(colonColonToken);
        this.colonColonToken = colonColonToken;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
    }


    internal AliasQualifiedNameSyntax(SyntaxKind kind, IdentifierNameSyntax alias, SyntaxToken colonColonToken, SimpleNameSyntax name)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(alias);
        this.alias = alias;
        this.AdjustFlagsAndWidth(colonColonToken);
        this.colonColonToken = colonColonToken;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
    }

    /// <summary>IdentifierNameSyntax node representing the name of the alias</summary>
    public IdentifierNameSyntax Alias => this.alias;
    /// <summary>SyntaxToken representing colon colon.</summary>
    public SyntaxToken ColonColonToken => this.colonColonToken;
    /// <summary>SimpleNameSyntax node representing the name that is being alias qualified.</summary>
    public SimpleNameSyntax Name => this.name;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.alias;
            case 1: return this.colonColonToken;
            case 2: return this.name;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.AliasQualifiedNameSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitAliasQualifiedName(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitAliasQualifiedName(this);

    public AliasQualifiedNameSyntax Update(IdentifierNameSyntax alias, SyntaxToken colonColonToken, SimpleNameSyntax name)
    {
        if (alias != this.Alias || colonColonToken != this.ColonColonToken || name != this.Name)
        {
            var newNode = SyntaxFactory.AliasQualifiedName(alias, colonColonToken, name);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new AliasQualifiedNameSyntax(this.Kind, this.alias, this.colonColonToken, this.name, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new AliasQualifiedNameSyntax(this.Kind, this.alias, this.colonColonToken, this.name, GetDiagnostics(), annotations);

    internal AliasQualifiedNameSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var alias = (IdentifierNameSyntax)reader.ReadValue();
      if (alias != null)
      {
         AdjustFlagsAndWidth(alias);
         this.alias = alias;
      }
      var colonColonToken = (SyntaxToken)reader.ReadValue();
      if (colonColonToken != null)
      {
         AdjustFlagsAndWidth(colonColonToken);
         this.colonColonToken = colonColonToken;
      }
      var name = (SimpleNameSyntax)reader.ReadValue();
      if (name != null)
      {
         AdjustFlagsAndWidth(name);
         this.name = name;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.alias);
      writer.WriteValue(this.colonColonToken);
      writer.WriteValue(this.name);
    }

    static AliasQualifiedNameSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(AliasQualifiedNameSyntax), r => new AliasQualifiedNameSyntax(r));
    }
  }

  /// <summary>Provides the base class from which the classes that represent type syntax nodes are derived. This is an abstract class.</summary>
  internal abstract partial class TypeSyntax : ExpressionSyntax
  {
    internal TypeSyntax(SyntaxKind kind, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal TypeSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    protected TypeSyntax(ObjectReader reader)
       : base(reader)
    {
    }
  }

  /// <summary>Class which represents the syntax node for predefined types.</summary>
  internal sealed partial class PredefinedTypeSyntax : TypeSyntax
  {
    internal readonly SyntaxToken keyword;

    internal PredefinedTypeSyntax(SyntaxKind kind, SyntaxToken keyword, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
    }


    internal PredefinedTypeSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
    }


    internal PredefinedTypeSyntax(SyntaxKind kind, SyntaxToken keyword)
        : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
    }

    /// <summary>SyntaxToken which represents the keyword corresponding to the predefined type.</summary>
    public SyntaxToken Keyword => this.keyword;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.keyword;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.PredefinedTypeSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitPredefinedType(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitPredefinedType(this);

    public PredefinedTypeSyntax Update(SyntaxToken keyword)
    {
        if (keyword != this.Keyword)
        {
            var newNode = SyntaxFactory.PredefinedType(keyword);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new PredefinedTypeSyntax(this.Kind, this.keyword, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new PredefinedTypeSyntax(this.Kind, this.keyword, GetDiagnostics(), annotations);

    internal PredefinedTypeSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 1;
      var keyword = (SyntaxToken)reader.ReadValue();
      if (keyword != null)
      {
         AdjustFlagsAndWidth(keyword);
         this.keyword = keyword;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.keyword);
    }

    static PredefinedTypeSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(PredefinedTypeSyntax), r => new PredefinedTypeSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for the array type.</summary>
  internal sealed partial class ArrayTypeSyntax : TypeSyntax
  {
    internal readonly TypeSyntax elementType;
    internal readonly GreenNode rankSpecifiers;

    internal ArrayTypeSyntax(SyntaxKind kind, TypeSyntax elementType, GreenNode rankSpecifiers, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(elementType);
        this.elementType = elementType;
        if (rankSpecifiers != null)
        {
            this.AdjustFlagsAndWidth(rankSpecifiers);
            this.rankSpecifiers = rankSpecifiers;
        }
    }


    internal ArrayTypeSyntax(SyntaxKind kind, TypeSyntax elementType, GreenNode rankSpecifiers, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(elementType);
        this.elementType = elementType;
        if (rankSpecifiers != null)
        {
            this.AdjustFlagsAndWidth(rankSpecifiers);
            this.rankSpecifiers = rankSpecifiers;
        }
    }


    internal ArrayTypeSyntax(SyntaxKind kind, TypeSyntax elementType, GreenNode rankSpecifiers)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(elementType);
        this.elementType = elementType;
        if (rankSpecifiers != null)
        {
            this.AdjustFlagsAndWidth(rankSpecifiers);
            this.rankSpecifiers = rankSpecifiers;
        }
    }

    /// <summary>TypeSyntax node representing the type of the element of the array.</summary>
    public TypeSyntax ElementType => this.elementType;
    /// <summary>SyntaxList of ArrayRankSpecifierSyntax nodes representing the list of rank specifiers for the array.</summary>
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<ArrayRankSpecifierSyntax> RankSpecifiers => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<ArrayRankSpecifierSyntax>(this.rankSpecifiers);

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.elementType;
            case 1: return this.rankSpecifiers;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ArrayTypeSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitArrayType(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitArrayType(this);

    public ArrayTypeSyntax Update(TypeSyntax elementType, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<ArrayRankSpecifierSyntax> rankSpecifiers)
    {
        if (elementType != this.ElementType || rankSpecifiers != this.RankSpecifiers)
        {
            var newNode = SyntaxFactory.ArrayType(elementType, rankSpecifiers);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ArrayTypeSyntax(this.Kind, this.elementType, this.rankSpecifiers, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ArrayTypeSyntax(this.Kind, this.elementType, this.rankSpecifiers, GetDiagnostics(), annotations);

    internal ArrayTypeSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var elementType = (TypeSyntax)reader.ReadValue();
      if (elementType != null)
      {
         AdjustFlagsAndWidth(elementType);
         this.elementType = elementType;
      }
      var rankSpecifiers = (GreenNode)reader.ReadValue();
      if (rankSpecifiers != null)
      {
         AdjustFlagsAndWidth(rankSpecifiers);
         this.rankSpecifiers = rankSpecifiers;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.elementType);
      writer.WriteValue(this.rankSpecifiers);
    }

    static ArrayTypeSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ArrayTypeSyntax), r => new ArrayTypeSyntax(r));
    }
  }

  internal sealed partial class ArrayRankSpecifierSyntax : CSharpSyntaxNode
  {
    internal readonly SyntaxToken openBracketToken;
    internal readonly GreenNode sizes;
    internal readonly SyntaxToken closeBracketToken;

    internal ArrayRankSpecifierSyntax(SyntaxKind kind, SyntaxToken openBracketToken, GreenNode sizes, SyntaxToken closeBracketToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (sizes != null)
        {
            this.AdjustFlagsAndWidth(sizes);
            this.sizes = sizes;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
    }


    internal ArrayRankSpecifierSyntax(SyntaxKind kind, SyntaxToken openBracketToken, GreenNode sizes, SyntaxToken closeBracketToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (sizes != null)
        {
            this.AdjustFlagsAndWidth(sizes);
            this.sizes = sizes;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
    }


    internal ArrayRankSpecifierSyntax(SyntaxKind kind, SyntaxToken openBracketToken, GreenNode sizes, SyntaxToken closeBracketToken)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (sizes != null)
        {
            this.AdjustFlagsAndWidth(sizes);
            this.sizes = sizes;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
    }

    public SyntaxToken OpenBracketToken => this.openBracketToken;
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<ExpressionSyntax> Sizes => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<ExpressionSyntax>(new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<CSharpSyntaxNode>(this.sizes));
    public SyntaxToken CloseBracketToken => this.closeBracketToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.openBracketToken;
            case 1: return this.sizes;
            case 2: return this.closeBracketToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ArrayRankSpecifierSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitArrayRankSpecifier(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitArrayRankSpecifier(this);

    public ArrayRankSpecifierSyntax Update(SyntaxToken openBracketToken, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<ExpressionSyntax> sizes, SyntaxToken closeBracketToken)
    {
        if (openBracketToken != this.OpenBracketToken || sizes != this.Sizes || closeBracketToken != this.CloseBracketToken)
        {
            var newNode = SyntaxFactory.ArrayRankSpecifier(openBracketToken, sizes, closeBracketToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ArrayRankSpecifierSyntax(this.Kind, this.openBracketToken, this.sizes, this.closeBracketToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ArrayRankSpecifierSyntax(this.Kind, this.openBracketToken, this.sizes, this.closeBracketToken, GetDiagnostics(), annotations);

    internal ArrayRankSpecifierSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var openBracketToken = (SyntaxToken)reader.ReadValue();
      if (openBracketToken != null)
      {
         AdjustFlagsAndWidth(openBracketToken);
         this.openBracketToken = openBracketToken;
      }
      var sizes = (GreenNode)reader.ReadValue();
      if (sizes != null)
      {
         AdjustFlagsAndWidth(sizes);
         this.sizes = sizes;
      }
      var closeBracketToken = (SyntaxToken)reader.ReadValue();
      if (closeBracketToken != null)
      {
         AdjustFlagsAndWidth(closeBracketToken);
         this.closeBracketToken = closeBracketToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.openBracketToken);
      writer.WriteValue(this.sizes);
      writer.WriteValue(this.closeBracketToken);
    }

    static ArrayRankSpecifierSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ArrayRankSpecifierSyntax), r => new ArrayRankSpecifierSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for pointer type.</summary>
  internal sealed partial class PointerTypeSyntax : TypeSyntax
  {
    internal readonly TypeSyntax elementType;
    internal readonly SyntaxToken asteriskToken;

    internal PointerTypeSyntax(SyntaxKind kind, TypeSyntax elementType, SyntaxToken asteriskToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(elementType);
        this.elementType = elementType;
        this.AdjustFlagsAndWidth(asteriskToken);
        this.asteriskToken = asteriskToken;
    }


    internal PointerTypeSyntax(SyntaxKind kind, TypeSyntax elementType, SyntaxToken asteriskToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(elementType);
        this.elementType = elementType;
        this.AdjustFlagsAndWidth(asteriskToken);
        this.asteriskToken = asteriskToken;
    }


    internal PointerTypeSyntax(SyntaxKind kind, TypeSyntax elementType, SyntaxToken asteriskToken)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(elementType);
        this.elementType = elementType;
        this.AdjustFlagsAndWidth(asteriskToken);
        this.asteriskToken = asteriskToken;
    }

    /// <summary>TypeSyntax node that represents the element type of the pointer.</summary>
    public TypeSyntax ElementType => this.elementType;
    /// <summary>SyntaxToken representing the asterisk.</summary>
    public SyntaxToken AsteriskToken => this.asteriskToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.elementType;
            case 1: return this.asteriskToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.PointerTypeSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitPointerType(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitPointerType(this);

    public PointerTypeSyntax Update(TypeSyntax elementType, SyntaxToken asteriskToken)
    {
        if (elementType != this.ElementType || asteriskToken != this.AsteriskToken)
        {
            var newNode = SyntaxFactory.PointerType(elementType, asteriskToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new PointerTypeSyntax(this.Kind, this.elementType, this.asteriskToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new PointerTypeSyntax(this.Kind, this.elementType, this.asteriskToken, GetDiagnostics(), annotations);

    internal PointerTypeSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var elementType = (TypeSyntax)reader.ReadValue();
      if (elementType != null)
      {
         AdjustFlagsAndWidth(elementType);
         this.elementType = elementType;
      }
      var asteriskToken = (SyntaxToken)reader.ReadValue();
      if (asteriskToken != null)
      {
         AdjustFlagsAndWidth(asteriskToken);
         this.asteriskToken = asteriskToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.elementType);
      writer.WriteValue(this.asteriskToken);
    }

    static PointerTypeSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(PointerTypeSyntax), r => new PointerTypeSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for a nullable type.</summary>
  internal sealed partial class NullableTypeSyntax : TypeSyntax
  {
    internal readonly TypeSyntax elementType;
    internal readonly SyntaxToken questionToken;

    internal NullableTypeSyntax(SyntaxKind kind, TypeSyntax elementType, SyntaxToken questionToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(elementType);
        this.elementType = elementType;
        this.AdjustFlagsAndWidth(questionToken);
        this.questionToken = questionToken;
    }


    internal NullableTypeSyntax(SyntaxKind kind, TypeSyntax elementType, SyntaxToken questionToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(elementType);
        this.elementType = elementType;
        this.AdjustFlagsAndWidth(questionToken);
        this.questionToken = questionToken;
    }


    internal NullableTypeSyntax(SyntaxKind kind, TypeSyntax elementType, SyntaxToken questionToken)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(elementType);
        this.elementType = elementType;
        this.AdjustFlagsAndWidth(questionToken);
        this.questionToken = questionToken;
    }

    /// <summary>TypeSyntax node representing the type of the element.</summary>
    public TypeSyntax ElementType => this.elementType;
    /// <summary>SyntaxToken representing the question mark.</summary>
    public SyntaxToken QuestionToken => this.questionToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.elementType;
            case 1: return this.questionToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.NullableTypeSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitNullableType(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitNullableType(this);

    public NullableTypeSyntax Update(TypeSyntax elementType, SyntaxToken questionToken)
    {
        if (elementType != this.ElementType || questionToken != this.QuestionToken)
        {
            var newNode = SyntaxFactory.NullableType(elementType, questionToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new NullableTypeSyntax(this.Kind, this.elementType, this.questionToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new NullableTypeSyntax(this.Kind, this.elementType, this.questionToken, GetDiagnostics(), annotations);

    internal NullableTypeSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var elementType = (TypeSyntax)reader.ReadValue();
      if (elementType != null)
      {
         AdjustFlagsAndWidth(elementType);
         this.elementType = elementType;
      }
      var questionToken = (SyntaxToken)reader.ReadValue();
      if (questionToken != null)
      {
         AdjustFlagsAndWidth(questionToken);
         this.questionToken = questionToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.elementType);
      writer.WriteValue(this.questionToken);
    }

    static NullableTypeSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(NullableTypeSyntax), r => new NullableTypeSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for tuple type.</summary>
  internal sealed partial class TupleTypeSyntax : TypeSyntax
  {
    internal readonly SyntaxToken openParenToken;
    internal readonly GreenNode elements;
    internal readonly SyntaxToken closeParenToken;

    internal TupleTypeSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode elements, SyntaxToken closeParenToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (elements != null)
        {
            this.AdjustFlagsAndWidth(elements);
            this.elements = elements;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal TupleTypeSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode elements, SyntaxToken closeParenToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (elements != null)
        {
            this.AdjustFlagsAndWidth(elements);
            this.elements = elements;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal TupleTypeSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode elements, SyntaxToken closeParenToken)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (elements != null)
        {
            this.AdjustFlagsAndWidth(elements);
            this.elements = elements;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>SyntaxToken representing the open parenthesis.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<TupleElementSyntax> Elements => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<TupleElementSyntax>(new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<CSharpSyntaxNode>(this.elements));
    /// <summary>SyntaxToken representing the close parenthesis.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.openParenToken;
            case 1: return this.elements;
            case 2: return this.closeParenToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.TupleTypeSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitTupleType(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitTupleType(this);

    public TupleTypeSyntax Update(SyntaxToken openParenToken, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<TupleElementSyntax> elements, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || elements != this.Elements || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.TupleType(openParenToken, elements, closeParenToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new TupleTypeSyntax(this.Kind, this.openParenToken, this.elements, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new TupleTypeSyntax(this.Kind, this.openParenToken, this.elements, this.closeParenToken, GetDiagnostics(), annotations);

    internal TupleTypeSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var elements = (GreenNode)reader.ReadValue();
      if (elements != null)
      {
         AdjustFlagsAndWidth(elements);
         this.elements = elements;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.elements);
      writer.WriteValue(this.closeParenToken);
    }

    static TupleTypeSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(TupleTypeSyntax), r => new TupleTypeSyntax(r));
    }
  }

  /// <summary>Tuple type element.</summary>
  internal sealed partial class TupleElementSyntax : CSharpSyntaxNode
  {
    internal readonly TypeSyntax type;
    internal readonly SyntaxToken identifier;

    internal TupleElementSyntax(SyntaxKind kind, TypeSyntax type, SyntaxToken identifier, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (identifier != null)
        {
            this.AdjustFlagsAndWidth(identifier);
            this.identifier = identifier;
        }
    }


    internal TupleElementSyntax(SyntaxKind kind, TypeSyntax type, SyntaxToken identifier, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (identifier != null)
        {
            this.AdjustFlagsAndWidth(identifier);
            this.identifier = identifier;
        }
    }


    internal TupleElementSyntax(SyntaxKind kind, TypeSyntax type, SyntaxToken identifier)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (identifier != null)
        {
            this.AdjustFlagsAndWidth(identifier);
            this.identifier = identifier;
        }
    }

    /// <summary>Gets the type of the tuple element.</summary>
    public TypeSyntax Type => this.type;
    /// <summary>Gets the name of the tuple element.</summary>
    public SyntaxToken Identifier => this.identifier;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.type;
            case 1: return this.identifier;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.TupleElementSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitTupleElement(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitTupleElement(this);

    public TupleElementSyntax Update(TypeSyntax type, SyntaxToken identifier)
    {
        if (type != this.Type || identifier != this.Identifier)
        {
            var newNode = SyntaxFactory.TupleElement(type, identifier);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new TupleElementSyntax(this.Kind, this.type, this.identifier, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new TupleElementSyntax(this.Kind, this.type, this.identifier, GetDiagnostics(), annotations);

    internal TupleElementSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var type = (TypeSyntax)reader.ReadValue();
      if (type != null)
      {
         AdjustFlagsAndWidth(type);
         this.type = type;
      }
      var identifier = (SyntaxToken)reader.ReadValue();
      if (identifier != null)
      {
         AdjustFlagsAndWidth(identifier);
         this.identifier = identifier;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.type);
      writer.WriteValue(this.identifier);
    }

    static TupleElementSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(TupleElementSyntax), r => new TupleElementSyntax(r));
    }
  }

  /// <summary>Class which represents a placeholder in the type argument list of an unbound generic type.</summary>
  internal sealed partial class OmittedTypeArgumentSyntax : TypeSyntax
  {
    internal readonly SyntaxToken omittedTypeArgumentToken;

    internal OmittedTypeArgumentSyntax(SyntaxKind kind, SyntaxToken omittedTypeArgumentToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(omittedTypeArgumentToken);
        this.omittedTypeArgumentToken = omittedTypeArgumentToken;
    }


    internal OmittedTypeArgumentSyntax(SyntaxKind kind, SyntaxToken omittedTypeArgumentToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(omittedTypeArgumentToken);
        this.omittedTypeArgumentToken = omittedTypeArgumentToken;
    }


    internal OmittedTypeArgumentSyntax(SyntaxKind kind, SyntaxToken omittedTypeArgumentToken)
        : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(omittedTypeArgumentToken);
        this.omittedTypeArgumentToken = omittedTypeArgumentToken;
    }

    /// <summary>SyntaxToken representing the omitted type argument.</summary>
    public SyntaxToken OmittedTypeArgumentToken => this.omittedTypeArgumentToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.omittedTypeArgumentToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.OmittedTypeArgumentSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitOmittedTypeArgument(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitOmittedTypeArgument(this);

    public OmittedTypeArgumentSyntax Update(SyntaxToken omittedTypeArgumentToken)
    {
        if (omittedTypeArgumentToken != this.OmittedTypeArgumentToken)
        {
            var newNode = SyntaxFactory.OmittedTypeArgument(omittedTypeArgumentToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new OmittedTypeArgumentSyntax(this.Kind, this.omittedTypeArgumentToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new OmittedTypeArgumentSyntax(this.Kind, this.omittedTypeArgumentToken, GetDiagnostics(), annotations);

    internal OmittedTypeArgumentSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 1;
      var omittedTypeArgumentToken = (SyntaxToken)reader.ReadValue();
      if (omittedTypeArgumentToken != null)
      {
         AdjustFlagsAndWidth(omittedTypeArgumentToken);
         this.omittedTypeArgumentToken = omittedTypeArgumentToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.omittedTypeArgumentToken);
    }

    static OmittedTypeArgumentSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(OmittedTypeArgumentSyntax), r => new OmittedTypeArgumentSyntax(r));
    }
  }

  /// <summary>The ref modifier of a method's return value or a local.</summary>
  internal sealed partial class RefTypeSyntax : TypeSyntax
  {
    internal readonly SyntaxToken refKeyword;
    internal readonly SyntaxToken readOnlyKeyword;
    internal readonly TypeSyntax type;

    internal RefTypeSyntax(SyntaxKind kind, SyntaxToken refKeyword, SyntaxToken readOnlyKeyword, TypeSyntax type, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(refKeyword);
        this.refKeyword = refKeyword;
        if (readOnlyKeyword != null)
        {
            this.AdjustFlagsAndWidth(readOnlyKeyword);
            this.readOnlyKeyword = readOnlyKeyword;
        }
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }


    internal RefTypeSyntax(SyntaxKind kind, SyntaxToken refKeyword, SyntaxToken readOnlyKeyword, TypeSyntax type, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(refKeyword);
        this.refKeyword = refKeyword;
        if (readOnlyKeyword != null)
        {
            this.AdjustFlagsAndWidth(readOnlyKeyword);
            this.readOnlyKeyword = readOnlyKeyword;
        }
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }


    internal RefTypeSyntax(SyntaxKind kind, SyntaxToken refKeyword, SyntaxToken readOnlyKeyword, TypeSyntax type)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(refKeyword);
        this.refKeyword = refKeyword;
        if (readOnlyKeyword != null)
        {
            this.AdjustFlagsAndWidth(readOnlyKeyword);
            this.readOnlyKeyword = readOnlyKeyword;
        }
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }

    public SyntaxToken RefKeyword => this.refKeyword;
    /// <summary>Gets the optional "readonly" keyword.</summary>
    public SyntaxToken ReadOnlyKeyword => this.readOnlyKeyword;
    public TypeSyntax Type => this.type;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.refKeyword;
            case 1: return this.readOnlyKeyword;
            case 2: return this.type;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.RefTypeSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitRefType(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitRefType(this);

    public RefTypeSyntax Update(SyntaxToken refKeyword, SyntaxToken readOnlyKeyword, TypeSyntax type)
    {
        if (refKeyword != this.RefKeyword || readOnlyKeyword != this.ReadOnlyKeyword || type != this.Type)
        {
            var newNode = SyntaxFactory.RefType(refKeyword, readOnlyKeyword, type);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new RefTypeSyntax(this.Kind, this.refKeyword, this.readOnlyKeyword, this.type, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new RefTypeSyntax(this.Kind, this.refKeyword, this.readOnlyKeyword, this.type, GetDiagnostics(), annotations);

    internal RefTypeSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var refKeyword = (SyntaxToken)reader.ReadValue();
      if (refKeyword != null)
      {
         AdjustFlagsAndWidth(refKeyword);
         this.refKeyword = refKeyword;
      }
      var readOnlyKeyword = (SyntaxToken)reader.ReadValue();
      if (readOnlyKeyword != null)
      {
         AdjustFlagsAndWidth(readOnlyKeyword);
         this.readOnlyKeyword = readOnlyKeyword;
      }
      var type = (TypeSyntax)reader.ReadValue();
      if (type != null)
      {
         AdjustFlagsAndWidth(type);
         this.type = type;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.refKeyword);
      writer.WriteValue(this.readOnlyKeyword);
      writer.WriteValue(this.type);
    }

    static RefTypeSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(RefTypeSyntax), r => new RefTypeSyntax(r));
    }
  }

  /// <summary>Provides the base class from which the classes that represent expression syntax nodes are derived. This is an abstract class.</summary>
  internal abstract partial class ExpressionSyntax : CSharpSyntaxNode
  {
    internal ExpressionSyntax(SyntaxKind kind, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal ExpressionSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    protected ExpressionSyntax(ObjectReader reader)
       : base(reader)
    {
    }
  }

  /// <summary>Class which represents the syntax node for parenthesized expression.</summary>
  internal sealed partial class ParenthesizedExpressionSyntax : ExpressionSyntax
  {
    internal readonly SyntaxToken openParenToken;
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken closeParenToken;

    internal ParenthesizedExpressionSyntax(SyntaxKind kind, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal ParenthesizedExpressionSyntax(SyntaxKind kind, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal ParenthesizedExpressionSyntax(SyntaxKind kind, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>SyntaxToken representing the open parenthesis.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>ExpressionSyntax node representing the expression enclosed within the parenthesis.</summary>
    public ExpressionSyntax Expression => this.expression;
    /// <summary>SyntaxToken representing the close parenthesis.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.openParenToken;
            case 1: return this.expression;
            case 2: return this.closeParenToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ParenthesizedExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitParenthesizedExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitParenthesizedExpression(this);

    public ParenthesizedExpressionSyntax Update(SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || expression != this.Expression || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.ParenthesizedExpression(openParenToken, expression, closeParenToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ParenthesizedExpressionSyntax(this.Kind, this.openParenToken, this.expression, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ParenthesizedExpressionSyntax(this.Kind, this.openParenToken, this.expression, this.closeParenToken, GetDiagnostics(), annotations);

    internal ParenthesizedExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.expression);
      writer.WriteValue(this.closeParenToken);
    }

    static ParenthesizedExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ParenthesizedExpressionSyntax), r => new ParenthesizedExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for tuple expression.</summary>
  internal sealed partial class TupleExpressionSyntax : ExpressionSyntax
  {
    internal readonly SyntaxToken openParenToken;
    internal readonly GreenNode arguments;
    internal readonly SyntaxToken closeParenToken;

    internal TupleExpressionSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode arguments, SyntaxToken closeParenToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal TupleExpressionSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode arguments, SyntaxToken closeParenToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal TupleExpressionSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode arguments, SyntaxToken closeParenToken)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>SyntaxToken representing the open parenthesis.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>SeparatedSyntaxList of ArgumentSyntax representing the list of arguments.</summary>
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<ArgumentSyntax> Arguments => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<ArgumentSyntax>(new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<CSharpSyntaxNode>(this.arguments));
    /// <summary>SyntaxToken representing the close parenthesis.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.openParenToken;
            case 1: return this.arguments;
            case 2: return this.closeParenToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.TupleExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitTupleExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitTupleExpression(this);

    public TupleExpressionSyntax Update(SyntaxToken openParenToken, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<ArgumentSyntax> arguments, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || arguments != this.Arguments || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.TupleExpression(openParenToken, arguments, closeParenToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new TupleExpressionSyntax(this.Kind, this.openParenToken, this.arguments, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new TupleExpressionSyntax(this.Kind, this.openParenToken, this.arguments, this.closeParenToken, GetDiagnostics(), annotations);

    internal TupleExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var arguments = (GreenNode)reader.ReadValue();
      if (arguments != null)
      {
         AdjustFlagsAndWidth(arguments);
         this.arguments = arguments;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.arguments);
      writer.WriteValue(this.closeParenToken);
    }

    static TupleExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(TupleExpressionSyntax), r => new TupleExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for prefix unary expression.</summary>
  internal sealed partial class PrefixUnaryExpressionSyntax : ExpressionSyntax
  {
    internal readonly SyntaxToken operatorToken;
    internal readonly ExpressionSyntax operand;

    internal PrefixUnaryExpressionSyntax(SyntaxKind kind, SyntaxToken operatorToken, ExpressionSyntax operand, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(operand);
        this.operand = operand;
    }


    internal PrefixUnaryExpressionSyntax(SyntaxKind kind, SyntaxToken operatorToken, ExpressionSyntax operand, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(operand);
        this.operand = operand;
    }


    internal PrefixUnaryExpressionSyntax(SyntaxKind kind, SyntaxToken operatorToken, ExpressionSyntax operand)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(operand);
        this.operand = operand;
    }

    /// <summary>SyntaxToken representing the kind of the operator of the prefix unary expression.</summary>
    public SyntaxToken OperatorToken => this.operatorToken;
    /// <summary>ExpressionSyntax representing the operand of the prefix unary expression.</summary>
    public ExpressionSyntax Operand => this.operand;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.operatorToken;
            case 1: return this.operand;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.PrefixUnaryExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitPrefixUnaryExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitPrefixUnaryExpression(this);

    public PrefixUnaryExpressionSyntax Update(SyntaxToken operatorToken, ExpressionSyntax operand)
    {
        if (operatorToken != this.OperatorToken || operand != this.Operand)
        {
            var newNode = SyntaxFactory.PrefixUnaryExpression(this.Kind, operatorToken, operand);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new PrefixUnaryExpressionSyntax(this.Kind, this.operatorToken, this.operand, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new PrefixUnaryExpressionSyntax(this.Kind, this.operatorToken, this.operand, GetDiagnostics(), annotations);

    internal PrefixUnaryExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var operatorToken = (SyntaxToken)reader.ReadValue();
      if (operatorToken != null)
      {
         AdjustFlagsAndWidth(operatorToken);
         this.operatorToken = operatorToken;
      }
      var operand = (ExpressionSyntax)reader.ReadValue();
      if (operand != null)
      {
         AdjustFlagsAndWidth(operand);
         this.operand = operand;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.operatorToken);
      writer.WriteValue(this.operand);
    }

    static PrefixUnaryExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(PrefixUnaryExpressionSyntax), r => new PrefixUnaryExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for an "await" expression.</summary>
  internal sealed partial class AwaitExpressionSyntax : ExpressionSyntax
  {
    internal readonly SyntaxToken awaitKeyword;
    internal readonly ExpressionSyntax expression;

    internal AwaitExpressionSyntax(SyntaxKind kind, SyntaxToken awaitKeyword, ExpressionSyntax expression, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(awaitKeyword);
        this.awaitKeyword = awaitKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }


    internal AwaitExpressionSyntax(SyntaxKind kind, SyntaxToken awaitKeyword, ExpressionSyntax expression, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(awaitKeyword);
        this.awaitKeyword = awaitKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }


    internal AwaitExpressionSyntax(SyntaxKind kind, SyntaxToken awaitKeyword, ExpressionSyntax expression)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(awaitKeyword);
        this.awaitKeyword = awaitKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    /// <summary>SyntaxToken representing the kind "await" keyword.</summary>
    public SyntaxToken AwaitKeyword => this.awaitKeyword;
    /// <summary>ExpressionSyntax representing the operand of the "await" operator.</summary>
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.awaitKeyword;
            case 1: return this.expression;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.AwaitExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitAwaitExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitAwaitExpression(this);

    public AwaitExpressionSyntax Update(SyntaxToken awaitKeyword, ExpressionSyntax expression)
    {
        if (awaitKeyword != this.AwaitKeyword || expression != this.Expression)
        {
            var newNode = SyntaxFactory.AwaitExpression(awaitKeyword, expression);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new AwaitExpressionSyntax(this.Kind, this.awaitKeyword, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new AwaitExpressionSyntax(this.Kind, this.awaitKeyword, this.expression, GetDiagnostics(), annotations);

    internal AwaitExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var awaitKeyword = (SyntaxToken)reader.ReadValue();
      if (awaitKeyword != null)
      {
         AdjustFlagsAndWidth(awaitKeyword);
         this.awaitKeyword = awaitKeyword;
      }
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.awaitKeyword);
      writer.WriteValue(this.expression);
    }

    static AwaitExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(AwaitExpressionSyntax), r => new AwaitExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for postfix unary expression.</summary>
  internal sealed partial class PostfixUnaryExpressionSyntax : ExpressionSyntax
  {
    internal readonly ExpressionSyntax operand;
    internal readonly SyntaxToken operatorToken;

    internal PostfixUnaryExpressionSyntax(SyntaxKind kind, ExpressionSyntax operand, SyntaxToken operatorToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(operand);
        this.operand = operand;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
    }


    internal PostfixUnaryExpressionSyntax(SyntaxKind kind, ExpressionSyntax operand, SyntaxToken operatorToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(operand);
        this.operand = operand;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
    }


    internal PostfixUnaryExpressionSyntax(SyntaxKind kind, ExpressionSyntax operand, SyntaxToken operatorToken)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(operand);
        this.operand = operand;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
    }

    /// <summary>ExpressionSyntax representing the operand of the postfix unary expression.</summary>
    public ExpressionSyntax Operand => this.operand;
    /// <summary>SyntaxToken representing the kind of the operator of the postfix unary expression.</summary>
    public SyntaxToken OperatorToken => this.operatorToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.operand;
            case 1: return this.operatorToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.PostfixUnaryExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitPostfixUnaryExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitPostfixUnaryExpression(this);

    public PostfixUnaryExpressionSyntax Update(ExpressionSyntax operand, SyntaxToken operatorToken)
    {
        if (operand != this.Operand || operatorToken != this.OperatorToken)
        {
            var newNode = SyntaxFactory.PostfixUnaryExpression(this.Kind, operand, operatorToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new PostfixUnaryExpressionSyntax(this.Kind, this.operand, this.operatorToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new PostfixUnaryExpressionSyntax(this.Kind, this.operand, this.operatorToken, GetDiagnostics(), annotations);

    internal PostfixUnaryExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var operand = (ExpressionSyntax)reader.ReadValue();
      if (operand != null)
      {
         AdjustFlagsAndWidth(operand);
         this.operand = operand;
      }
      var operatorToken = (SyntaxToken)reader.ReadValue();
      if (operatorToken != null)
      {
         AdjustFlagsAndWidth(operatorToken);
         this.operatorToken = operatorToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.operand);
      writer.WriteValue(this.operatorToken);
    }

    static PostfixUnaryExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(PostfixUnaryExpressionSyntax), r => new PostfixUnaryExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for member access expression.</summary>
  internal sealed partial class MemberAccessExpressionSyntax : ExpressionSyntax
  {
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken operatorToken;
    internal readonly SimpleNameSyntax name;

    internal MemberAccessExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken operatorToken, SimpleNameSyntax name, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
    }


    internal MemberAccessExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken operatorToken, SimpleNameSyntax name, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
    }


    internal MemberAccessExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken operatorToken, SimpleNameSyntax name)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
    }

    /// <summary>ExpressionSyntax node representing the object that the member belongs to.</summary>
    public ExpressionSyntax Expression => this.expression;
    /// <summary>SyntaxToken representing the kind of the operator in the member access expression.</summary>
    public SyntaxToken OperatorToken => this.operatorToken;
    /// <summary>SimpleNameSyntax node representing the member being accessed.</summary>
    public SimpleNameSyntax Name => this.name;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.expression;
            case 1: return this.operatorToken;
            case 2: return this.name;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.MemberAccessExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitMemberAccessExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitMemberAccessExpression(this);

    public MemberAccessExpressionSyntax Update(ExpressionSyntax expression, SyntaxToken operatorToken, SimpleNameSyntax name)
    {
        if (expression != this.Expression || operatorToken != this.OperatorToken || name != this.Name)
        {
            var newNode = SyntaxFactory.MemberAccessExpression(this.Kind, expression, operatorToken, name);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new MemberAccessExpressionSyntax(this.Kind, this.expression, this.operatorToken, this.name, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new MemberAccessExpressionSyntax(this.Kind, this.expression, this.operatorToken, this.name, GetDiagnostics(), annotations);

    internal MemberAccessExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
      var operatorToken = (SyntaxToken)reader.ReadValue();
      if (operatorToken != null)
      {
         AdjustFlagsAndWidth(operatorToken);
         this.operatorToken = operatorToken;
      }
      var name = (SimpleNameSyntax)reader.ReadValue();
      if (name != null)
      {
         AdjustFlagsAndWidth(name);
         this.name = name;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.expression);
      writer.WriteValue(this.operatorToken);
      writer.WriteValue(this.name);
    }

    static MemberAccessExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(MemberAccessExpressionSyntax), r => new MemberAccessExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for conditional access expression.</summary>
  internal sealed partial class ConditionalAccessExpressionSyntax : ExpressionSyntax
  {
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken operatorToken;
    internal readonly ExpressionSyntax whenNotNull;

    internal ConditionalAccessExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken operatorToken, ExpressionSyntax whenNotNull, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(whenNotNull);
        this.whenNotNull = whenNotNull;
    }


    internal ConditionalAccessExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken operatorToken, ExpressionSyntax whenNotNull, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(whenNotNull);
        this.whenNotNull = whenNotNull;
    }


    internal ConditionalAccessExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken operatorToken, ExpressionSyntax whenNotNull)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(whenNotNull);
        this.whenNotNull = whenNotNull;
    }

    /// <summary>ExpressionSyntax node representing the object conditionally accessed.</summary>
    public ExpressionSyntax Expression => this.expression;
    /// <summary>SyntaxToken representing the question mark.</summary>
    public SyntaxToken OperatorToken => this.operatorToken;
    /// <summary>ExpressionSyntax node representing the access expression to be executed when the object is not null.</summary>
    public ExpressionSyntax WhenNotNull => this.whenNotNull;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.expression;
            case 1: return this.operatorToken;
            case 2: return this.whenNotNull;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ConditionalAccessExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitConditionalAccessExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitConditionalAccessExpression(this);

    public ConditionalAccessExpressionSyntax Update(ExpressionSyntax expression, SyntaxToken operatorToken, ExpressionSyntax whenNotNull)
    {
        if (expression != this.Expression || operatorToken != this.OperatorToken || whenNotNull != this.WhenNotNull)
        {
            var newNode = SyntaxFactory.ConditionalAccessExpression(expression, operatorToken, whenNotNull);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ConditionalAccessExpressionSyntax(this.Kind, this.expression, this.operatorToken, this.whenNotNull, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ConditionalAccessExpressionSyntax(this.Kind, this.expression, this.operatorToken, this.whenNotNull, GetDiagnostics(), annotations);

    internal ConditionalAccessExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
      var operatorToken = (SyntaxToken)reader.ReadValue();
      if (operatorToken != null)
      {
         AdjustFlagsAndWidth(operatorToken);
         this.operatorToken = operatorToken;
      }
      var whenNotNull = (ExpressionSyntax)reader.ReadValue();
      if (whenNotNull != null)
      {
         AdjustFlagsAndWidth(whenNotNull);
         this.whenNotNull = whenNotNull;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.expression);
      writer.WriteValue(this.operatorToken);
      writer.WriteValue(this.whenNotNull);
    }

    static ConditionalAccessExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ConditionalAccessExpressionSyntax), r => new ConditionalAccessExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for member binding expression.</summary>
  internal sealed partial class MemberBindingExpressionSyntax : ExpressionSyntax
  {
    internal readonly SyntaxToken operatorToken;
    internal readonly SimpleNameSyntax name;

    internal MemberBindingExpressionSyntax(SyntaxKind kind, SyntaxToken operatorToken, SimpleNameSyntax name, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
    }


    internal MemberBindingExpressionSyntax(SyntaxKind kind, SyntaxToken operatorToken, SimpleNameSyntax name, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
    }


    internal MemberBindingExpressionSyntax(SyntaxKind kind, SyntaxToken operatorToken, SimpleNameSyntax name)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
    }

    /// <summary>SyntaxToken representing dot.</summary>
    public SyntaxToken OperatorToken => this.operatorToken;
    /// <summary>SimpleNameSyntax node representing the member being bound to.</summary>
    public SimpleNameSyntax Name => this.name;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.operatorToken;
            case 1: return this.name;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.MemberBindingExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitMemberBindingExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitMemberBindingExpression(this);

    public MemberBindingExpressionSyntax Update(SyntaxToken operatorToken, SimpleNameSyntax name)
    {
        if (operatorToken != this.OperatorToken || name != this.Name)
        {
            var newNode = SyntaxFactory.MemberBindingExpression(operatorToken, name);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new MemberBindingExpressionSyntax(this.Kind, this.operatorToken, this.name, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new MemberBindingExpressionSyntax(this.Kind, this.operatorToken, this.name, GetDiagnostics(), annotations);

    internal MemberBindingExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var operatorToken = (SyntaxToken)reader.ReadValue();
      if (operatorToken != null)
      {
         AdjustFlagsAndWidth(operatorToken);
         this.operatorToken = operatorToken;
      }
      var name = (SimpleNameSyntax)reader.ReadValue();
      if (name != null)
      {
         AdjustFlagsAndWidth(name);
         this.name = name;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.operatorToken);
      writer.WriteValue(this.name);
    }

    static MemberBindingExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(MemberBindingExpressionSyntax), r => new MemberBindingExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for element binding expression.</summary>
  internal sealed partial class ElementBindingExpressionSyntax : ExpressionSyntax
  {
    internal readonly BracketedArgumentListSyntax argumentList;

    internal ElementBindingExpressionSyntax(SyntaxKind kind, BracketedArgumentListSyntax argumentList, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }


    internal ElementBindingExpressionSyntax(SyntaxKind kind, BracketedArgumentListSyntax argumentList, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }


    internal ElementBindingExpressionSyntax(SyntaxKind kind, BracketedArgumentListSyntax argumentList)
        : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }

    /// <summary>BracketedArgumentListSyntax node representing the list of arguments of the element binding expression.</summary>
    public BracketedArgumentListSyntax ArgumentList => this.argumentList;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.argumentList;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ElementBindingExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitElementBindingExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitElementBindingExpression(this);

    public ElementBindingExpressionSyntax Update(BracketedArgumentListSyntax argumentList)
    {
        if (argumentList != this.ArgumentList)
        {
            var newNode = SyntaxFactory.ElementBindingExpression(argumentList);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ElementBindingExpressionSyntax(this.Kind, this.argumentList, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ElementBindingExpressionSyntax(this.Kind, this.argumentList, GetDiagnostics(), annotations);

    internal ElementBindingExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 1;
      var argumentList = (BracketedArgumentListSyntax)reader.ReadValue();
      if (argumentList != null)
      {
         AdjustFlagsAndWidth(argumentList);
         this.argumentList = argumentList;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.argumentList);
    }

    static ElementBindingExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ElementBindingExpressionSyntax), r => new ElementBindingExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for a range expression.</summary>
  internal sealed partial class RangeExpressionSyntax : ExpressionSyntax
  {
    internal readonly ExpressionSyntax leftOperand;
    internal readonly SyntaxToken operatorToken;
    internal readonly ExpressionSyntax rightOperand;

    internal RangeExpressionSyntax(SyntaxKind kind, ExpressionSyntax leftOperand, SyntaxToken operatorToken, ExpressionSyntax rightOperand, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        if (leftOperand != null)
        {
            this.AdjustFlagsAndWidth(leftOperand);
            this.leftOperand = leftOperand;
        }
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        if (rightOperand != null)
        {
            this.AdjustFlagsAndWidth(rightOperand);
            this.rightOperand = rightOperand;
        }
    }


    internal RangeExpressionSyntax(SyntaxKind kind, ExpressionSyntax leftOperand, SyntaxToken operatorToken, ExpressionSyntax rightOperand, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        if (leftOperand != null)
        {
            this.AdjustFlagsAndWidth(leftOperand);
            this.leftOperand = leftOperand;
        }
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        if (rightOperand != null)
        {
            this.AdjustFlagsAndWidth(rightOperand);
            this.rightOperand = rightOperand;
        }
    }


    internal RangeExpressionSyntax(SyntaxKind kind, ExpressionSyntax leftOperand, SyntaxToken operatorToken, ExpressionSyntax rightOperand)
        : base(kind)
    {
        this.SlotCount = 3;
        if (leftOperand != null)
        {
            this.AdjustFlagsAndWidth(leftOperand);
            this.leftOperand = leftOperand;
        }
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        if (rightOperand != null)
        {
            this.AdjustFlagsAndWidth(rightOperand);
            this.rightOperand = rightOperand;
        }
    }

    /// <summary>ExpressionSyntax node representing the expression on the left of the range operator.</summary>
    public ExpressionSyntax LeftOperand => this.leftOperand;
    /// <summary>SyntaxToken representing the operator of the range expression.</summary>
    public SyntaxToken OperatorToken => this.operatorToken;
    /// <summary>ExpressionSyntax node representing the expression on the right of the range operator.</summary>
    public ExpressionSyntax RightOperand => this.rightOperand;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.leftOperand;
            case 1: return this.operatorToken;
            case 2: return this.rightOperand;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.RangeExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitRangeExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitRangeExpression(this);

    public RangeExpressionSyntax Update(ExpressionSyntax leftOperand, SyntaxToken operatorToken, ExpressionSyntax rightOperand)
    {
        if (leftOperand != this.LeftOperand || operatorToken != this.OperatorToken || rightOperand != this.RightOperand)
        {
            var newNode = SyntaxFactory.RangeExpression(leftOperand, operatorToken, rightOperand);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new RangeExpressionSyntax(this.Kind, this.leftOperand, this.operatorToken, this.rightOperand, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new RangeExpressionSyntax(this.Kind, this.leftOperand, this.operatorToken, this.rightOperand, GetDiagnostics(), annotations);

    internal RangeExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var leftOperand = (ExpressionSyntax)reader.ReadValue();
      if (leftOperand != null)
      {
         AdjustFlagsAndWidth(leftOperand);
         this.leftOperand = leftOperand;
      }
      var operatorToken = (SyntaxToken)reader.ReadValue();
      if (operatorToken != null)
      {
         AdjustFlagsAndWidth(operatorToken);
         this.operatorToken = operatorToken;
      }
      var rightOperand = (ExpressionSyntax)reader.ReadValue();
      if (rightOperand != null)
      {
         AdjustFlagsAndWidth(rightOperand);
         this.rightOperand = rightOperand;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.leftOperand);
      writer.WriteValue(this.operatorToken);
      writer.WriteValue(this.rightOperand);
    }

    static RangeExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(RangeExpressionSyntax), r => new RangeExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for implicit element access expression.</summary>
  internal sealed partial class ImplicitElementAccessSyntax : ExpressionSyntax
  {
    internal readonly BracketedArgumentListSyntax argumentList;

    internal ImplicitElementAccessSyntax(SyntaxKind kind, BracketedArgumentListSyntax argumentList, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }


    internal ImplicitElementAccessSyntax(SyntaxKind kind, BracketedArgumentListSyntax argumentList, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }


    internal ImplicitElementAccessSyntax(SyntaxKind kind, BracketedArgumentListSyntax argumentList)
        : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }

    /// <summary>BracketedArgumentListSyntax node representing the list of arguments of the implicit element access expression.</summary>
    public BracketedArgumentListSyntax ArgumentList => this.argumentList;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.argumentList;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ImplicitElementAccessSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitImplicitElementAccess(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitImplicitElementAccess(this);

    public ImplicitElementAccessSyntax Update(BracketedArgumentListSyntax argumentList)
    {
        if (argumentList != this.ArgumentList)
        {
            var newNode = SyntaxFactory.ImplicitElementAccess(argumentList);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ImplicitElementAccessSyntax(this.Kind, this.argumentList, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ImplicitElementAccessSyntax(this.Kind, this.argumentList, GetDiagnostics(), annotations);

    internal ImplicitElementAccessSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 1;
      var argumentList = (BracketedArgumentListSyntax)reader.ReadValue();
      if (argumentList != null)
      {
         AdjustFlagsAndWidth(argumentList);
         this.argumentList = argumentList;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.argumentList);
    }

    static ImplicitElementAccessSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ImplicitElementAccessSyntax), r => new ImplicitElementAccessSyntax(r));
    }
  }

  /// <summary>Class which represents an expression that has a binary operator.</summary>
  internal sealed partial class BinaryExpressionSyntax : ExpressionSyntax
  {
    internal readonly ExpressionSyntax left;
    internal readonly SyntaxToken operatorToken;
    internal readonly ExpressionSyntax right;

    internal BinaryExpressionSyntax(SyntaxKind kind, ExpressionSyntax left, SyntaxToken operatorToken, ExpressionSyntax right, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(left);
        this.left = left;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(right);
        this.right = right;
    }


    internal BinaryExpressionSyntax(SyntaxKind kind, ExpressionSyntax left, SyntaxToken operatorToken, ExpressionSyntax right, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(left);
        this.left = left;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(right);
        this.right = right;
    }


    internal BinaryExpressionSyntax(SyntaxKind kind, ExpressionSyntax left, SyntaxToken operatorToken, ExpressionSyntax right)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(left);
        this.left = left;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(right);
        this.right = right;
    }

    /// <summary>ExpressionSyntax node representing the expression on the left of the binary operator.</summary>
    public ExpressionSyntax Left => this.left;
    /// <summary>SyntaxToken representing the operator of the binary expression.</summary>
    public SyntaxToken OperatorToken => this.operatorToken;
    /// <summary>ExpressionSyntax node representing the expression on the right of the binary operator.</summary>
    public ExpressionSyntax Right => this.right;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.left;
            case 1: return this.operatorToken;
            case 2: return this.right;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.BinaryExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitBinaryExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitBinaryExpression(this);

    public BinaryExpressionSyntax Update(ExpressionSyntax left, SyntaxToken operatorToken, ExpressionSyntax right)
    {
        if (left != this.Left || operatorToken != this.OperatorToken || right != this.Right)
        {
            var newNode = SyntaxFactory.BinaryExpression(this.Kind, left, operatorToken, right);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new BinaryExpressionSyntax(this.Kind, this.left, this.operatorToken, this.right, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new BinaryExpressionSyntax(this.Kind, this.left, this.operatorToken, this.right, GetDiagnostics(), annotations);

    internal BinaryExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var left = (ExpressionSyntax)reader.ReadValue();
      if (left != null)
      {
         AdjustFlagsAndWidth(left);
         this.left = left;
      }
      var operatorToken = (SyntaxToken)reader.ReadValue();
      if (operatorToken != null)
      {
         AdjustFlagsAndWidth(operatorToken);
         this.operatorToken = operatorToken;
      }
      var right = (ExpressionSyntax)reader.ReadValue();
      if (right != null)
      {
         AdjustFlagsAndWidth(right);
         this.right = right;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.left);
      writer.WriteValue(this.operatorToken);
      writer.WriteValue(this.right);
    }

    static BinaryExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(BinaryExpressionSyntax), r => new BinaryExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents an expression that has an assignment operator.</summary>
  internal sealed partial class AssignmentExpressionSyntax : ExpressionSyntax
  {
    internal readonly ExpressionSyntax left;
    internal readonly SyntaxToken operatorToken;
    internal readonly ExpressionSyntax right;

    internal AssignmentExpressionSyntax(SyntaxKind kind, ExpressionSyntax left, SyntaxToken operatorToken, ExpressionSyntax right, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(left);
        this.left = left;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(right);
        this.right = right;
    }


    internal AssignmentExpressionSyntax(SyntaxKind kind, ExpressionSyntax left, SyntaxToken operatorToken, ExpressionSyntax right, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(left);
        this.left = left;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(right);
        this.right = right;
    }


    internal AssignmentExpressionSyntax(SyntaxKind kind, ExpressionSyntax left, SyntaxToken operatorToken, ExpressionSyntax right)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(left);
        this.left = left;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(right);
        this.right = right;
    }

    /// <summary>ExpressionSyntax node representing the expression on the left of the assignment operator.</summary>
    public ExpressionSyntax Left => this.left;
    /// <summary>SyntaxToken representing the operator of the assignment expression.</summary>
    public SyntaxToken OperatorToken => this.operatorToken;
    /// <summary>ExpressionSyntax node representing the expression on the right of the assignment operator.</summary>
    public ExpressionSyntax Right => this.right;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.left;
            case 1: return this.operatorToken;
            case 2: return this.right;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.AssignmentExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitAssignmentExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitAssignmentExpression(this);

    public AssignmentExpressionSyntax Update(ExpressionSyntax left, SyntaxToken operatorToken, ExpressionSyntax right)
    {
        if (left != this.Left || operatorToken != this.OperatorToken || right != this.Right)
        {
            var newNode = SyntaxFactory.AssignmentExpression(this.Kind, left, operatorToken, right);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new AssignmentExpressionSyntax(this.Kind, this.left, this.operatorToken, this.right, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new AssignmentExpressionSyntax(this.Kind, this.left, this.operatorToken, this.right, GetDiagnostics(), annotations);

    internal AssignmentExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var left = (ExpressionSyntax)reader.ReadValue();
      if (left != null)
      {
         AdjustFlagsAndWidth(left);
         this.left = left;
      }
      var operatorToken = (SyntaxToken)reader.ReadValue();
      if (operatorToken != null)
      {
         AdjustFlagsAndWidth(operatorToken);
         this.operatorToken = operatorToken;
      }
      var right = (ExpressionSyntax)reader.ReadValue();
      if (right != null)
      {
         AdjustFlagsAndWidth(right);
         this.right = right;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.left);
      writer.WriteValue(this.operatorToken);
      writer.WriteValue(this.right);
    }

    static AssignmentExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(AssignmentExpressionSyntax), r => new AssignmentExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for conditional expression.</summary>
  internal sealed partial class ConditionalExpressionSyntax : ExpressionSyntax
  {
    internal readonly ExpressionSyntax condition;
    internal readonly SyntaxToken questionToken;
    internal readonly ExpressionSyntax whenTrue;
    internal readonly SyntaxToken colonToken;
    internal readonly ExpressionSyntax whenFalse;

    internal ConditionalExpressionSyntax(SyntaxKind kind, ExpressionSyntax condition, SyntaxToken questionToken, ExpressionSyntax whenTrue, SyntaxToken colonToken, ExpressionSyntax whenFalse, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
        this.AdjustFlagsAndWidth(questionToken);
        this.questionToken = questionToken;
        this.AdjustFlagsAndWidth(whenTrue);
        this.whenTrue = whenTrue;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        this.AdjustFlagsAndWidth(whenFalse);
        this.whenFalse = whenFalse;
    }


    internal ConditionalExpressionSyntax(SyntaxKind kind, ExpressionSyntax condition, SyntaxToken questionToken, ExpressionSyntax whenTrue, SyntaxToken colonToken, ExpressionSyntax whenFalse, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
        this.AdjustFlagsAndWidth(questionToken);
        this.questionToken = questionToken;
        this.AdjustFlagsAndWidth(whenTrue);
        this.whenTrue = whenTrue;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        this.AdjustFlagsAndWidth(whenFalse);
        this.whenFalse = whenFalse;
    }


    internal ConditionalExpressionSyntax(SyntaxKind kind, ExpressionSyntax condition, SyntaxToken questionToken, ExpressionSyntax whenTrue, SyntaxToken colonToken, ExpressionSyntax whenFalse)
        : base(kind)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
        this.AdjustFlagsAndWidth(questionToken);
        this.questionToken = questionToken;
        this.AdjustFlagsAndWidth(whenTrue);
        this.whenTrue = whenTrue;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        this.AdjustFlagsAndWidth(whenFalse);
        this.whenFalse = whenFalse;
    }

    /// <summary>ExpressionSyntax node representing the condition of the conditional expression.</summary>
    public ExpressionSyntax Condition => this.condition;
    /// <summary>SyntaxToken representing the question mark.</summary>
    public SyntaxToken QuestionToken => this.questionToken;
    /// <summary>ExpressionSyntax node representing the expression to be executed when the condition is true.</summary>
    public ExpressionSyntax WhenTrue => this.whenTrue;
    /// <summary>SyntaxToken representing the colon.</summary>
    public SyntaxToken ColonToken => this.colonToken;
    /// <summary>ExpressionSyntax node representing the expression to be executed when the condition is false.</summary>
    public ExpressionSyntax WhenFalse => this.whenFalse;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.condition;
            case 1: return this.questionToken;
            case 2: return this.whenTrue;
            case 3: return this.colonToken;
            case 4: return this.whenFalse;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ConditionalExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitConditionalExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitConditionalExpression(this);

    public ConditionalExpressionSyntax Update(ExpressionSyntax condition, SyntaxToken questionToken, ExpressionSyntax whenTrue, SyntaxToken colonToken, ExpressionSyntax whenFalse)
    {
        if (condition != this.Condition || questionToken != this.QuestionToken || whenTrue != this.WhenTrue || colonToken != this.ColonToken || whenFalse != this.WhenFalse)
        {
            var newNode = SyntaxFactory.ConditionalExpression(condition, questionToken, whenTrue, colonToken, whenFalse);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ConditionalExpressionSyntax(this.Kind, this.condition, this.questionToken, this.whenTrue, this.colonToken, this.whenFalse, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ConditionalExpressionSyntax(this.Kind, this.condition, this.questionToken, this.whenTrue, this.colonToken, this.whenFalse, GetDiagnostics(), annotations);

    internal ConditionalExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 5;
      var condition = (ExpressionSyntax)reader.ReadValue();
      if (condition != null)
      {
         AdjustFlagsAndWidth(condition);
         this.condition = condition;
      }
      var questionToken = (SyntaxToken)reader.ReadValue();
      if (questionToken != null)
      {
         AdjustFlagsAndWidth(questionToken);
         this.questionToken = questionToken;
      }
      var whenTrue = (ExpressionSyntax)reader.ReadValue();
      if (whenTrue != null)
      {
         AdjustFlagsAndWidth(whenTrue);
         this.whenTrue = whenTrue;
      }
      var colonToken = (SyntaxToken)reader.ReadValue();
      if (colonToken != null)
      {
         AdjustFlagsAndWidth(colonToken);
         this.colonToken = colonToken;
      }
      var whenFalse = (ExpressionSyntax)reader.ReadValue();
      if (whenFalse != null)
      {
         AdjustFlagsAndWidth(whenFalse);
         this.whenFalse = whenFalse;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.condition);
      writer.WriteValue(this.questionToken);
      writer.WriteValue(this.whenTrue);
      writer.WriteValue(this.colonToken);
      writer.WriteValue(this.whenFalse);
    }

    static ConditionalExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ConditionalExpressionSyntax), r => new ConditionalExpressionSyntax(r));
    }
  }

  /// <summary>Provides the base class from which the classes that represent instance expression syntax nodes are derived. This is an abstract class.</summary>
  internal abstract partial class InstanceExpressionSyntax : ExpressionSyntax
  {
    internal InstanceExpressionSyntax(SyntaxKind kind, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal InstanceExpressionSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    protected InstanceExpressionSyntax(ObjectReader reader)
       : base(reader)
    {
    }
  }

  /// <summary>Class which represents the syntax node for a this expression.</summary>
  internal sealed partial class ThisExpressionSyntax : InstanceExpressionSyntax
  {
    internal readonly SyntaxToken token;

    internal ThisExpressionSyntax(SyntaxKind kind, SyntaxToken token, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(token);
        this.token = token;
    }


    internal ThisExpressionSyntax(SyntaxKind kind, SyntaxToken token, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(token);
        this.token = token;
    }


    internal ThisExpressionSyntax(SyntaxKind kind, SyntaxToken token)
        : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(token);
        this.token = token;
    }

    /// <summary>SyntaxToken representing the this keyword.</summary>
    public SyntaxToken Token => this.token;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.token;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ThisExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitThisExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitThisExpression(this);

    public ThisExpressionSyntax Update(SyntaxToken token)
    {
        if (token != this.Token)
        {
            var newNode = SyntaxFactory.ThisExpression(token);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ThisExpressionSyntax(this.Kind, this.token, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ThisExpressionSyntax(this.Kind, this.token, GetDiagnostics(), annotations);

    internal ThisExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 1;
      var token = (SyntaxToken)reader.ReadValue();
      if (token != null)
      {
         AdjustFlagsAndWidth(token);
         this.token = token;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.token);
    }

    static ThisExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ThisExpressionSyntax), r => new ThisExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for a base expression.</summary>
  internal sealed partial class BaseExpressionSyntax : InstanceExpressionSyntax
  {
    internal readonly SyntaxToken token;

    internal BaseExpressionSyntax(SyntaxKind kind, SyntaxToken token, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(token);
        this.token = token;
    }


    internal BaseExpressionSyntax(SyntaxKind kind, SyntaxToken token, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(token);
        this.token = token;
    }


    internal BaseExpressionSyntax(SyntaxKind kind, SyntaxToken token)
        : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(token);
        this.token = token;
    }

    /// <summary>SyntaxToken representing the base keyword.</summary>
    public SyntaxToken Token => this.token;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.token;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.BaseExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitBaseExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitBaseExpression(this);

    public BaseExpressionSyntax Update(SyntaxToken token)
    {
        if (token != this.Token)
        {
            var newNode = SyntaxFactory.BaseExpression(token);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new BaseExpressionSyntax(this.Kind, this.token, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new BaseExpressionSyntax(this.Kind, this.token, GetDiagnostics(), annotations);

    internal BaseExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 1;
      var token = (SyntaxToken)reader.ReadValue();
      if (token != null)
      {
         AdjustFlagsAndWidth(token);
         this.token = token;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.token);
    }

    static BaseExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(BaseExpressionSyntax), r => new BaseExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for a literal expression.</summary>
  internal sealed partial class LiteralExpressionSyntax : ExpressionSyntax
  {
    internal readonly SyntaxToken token;

    internal LiteralExpressionSyntax(SyntaxKind kind, SyntaxToken token, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(token);
        this.token = token;
    }


    internal LiteralExpressionSyntax(SyntaxKind kind, SyntaxToken token, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(token);
        this.token = token;
    }


    internal LiteralExpressionSyntax(SyntaxKind kind, SyntaxToken token)
        : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(token);
        this.token = token;
    }

    /// <summary>SyntaxToken representing the keyword corresponding to the kind of the literal expression.</summary>
    public SyntaxToken Token => this.token;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.token;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.LiteralExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitLiteralExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitLiteralExpression(this);

    public LiteralExpressionSyntax Update(SyntaxToken token)
    {
        if (token != this.Token)
        {
            var newNode = SyntaxFactory.LiteralExpression(this.Kind, token);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new LiteralExpressionSyntax(this.Kind, this.token, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new LiteralExpressionSyntax(this.Kind, this.token, GetDiagnostics(), annotations);

    internal LiteralExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 1;
      var token = (SyntaxToken)reader.ReadValue();
      if (token != null)
      {
         AdjustFlagsAndWidth(token);
         this.token = token;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.token);
    }

    static LiteralExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(LiteralExpressionSyntax), r => new LiteralExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for MakeRef expression.</summary>
  internal sealed partial class MakeRefExpressionSyntax : ExpressionSyntax
  {
    internal readonly SyntaxToken keyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken closeParenToken;

    internal MakeRefExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal MakeRefExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal MakeRefExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken)
        : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>SyntaxToken representing the MakeRefKeyword.</summary>
    public SyntaxToken Keyword => this.keyword;
    /// <summary>SyntaxToken representing open parenthesis.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>Argument of the primary function.</summary>
    public ExpressionSyntax Expression => this.expression;
    /// <summary>SyntaxToken representing close parenthesis.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.keyword;
            case 1: return this.openParenToken;
            case 2: return this.expression;
            case 3: return this.closeParenToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.MakeRefExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitMakeRefExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitMakeRefExpression(this);

    public MakeRefExpressionSyntax Update(SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken)
    {
        if (keyword != this.Keyword || openParenToken != this.OpenParenToken || expression != this.Expression || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.MakeRefExpression(keyword, openParenToken, expression, closeParenToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new MakeRefExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.expression, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new MakeRefExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.expression, this.closeParenToken, GetDiagnostics(), annotations);

    internal MakeRefExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var keyword = (SyntaxToken)reader.ReadValue();
      if (keyword != null)
      {
         AdjustFlagsAndWidth(keyword);
         this.keyword = keyword;
      }
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.keyword);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.expression);
      writer.WriteValue(this.closeParenToken);
    }

    static MakeRefExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(MakeRefExpressionSyntax), r => new MakeRefExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for RefType expression.</summary>
  internal sealed partial class RefTypeExpressionSyntax : ExpressionSyntax
  {
    internal readonly SyntaxToken keyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken closeParenToken;

    internal RefTypeExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal RefTypeExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal RefTypeExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken)
        : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>SyntaxToken representing the RefTypeKeyword.</summary>
    public SyntaxToken Keyword => this.keyword;
    /// <summary>SyntaxToken representing open parenthesis.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>Argument of the primary function.</summary>
    public ExpressionSyntax Expression => this.expression;
    /// <summary>SyntaxToken representing close parenthesis.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.keyword;
            case 1: return this.openParenToken;
            case 2: return this.expression;
            case 3: return this.closeParenToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.RefTypeExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitRefTypeExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitRefTypeExpression(this);

    public RefTypeExpressionSyntax Update(SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken)
    {
        if (keyword != this.Keyword || openParenToken != this.OpenParenToken || expression != this.Expression || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.RefTypeExpression(keyword, openParenToken, expression, closeParenToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new RefTypeExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.expression, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new RefTypeExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.expression, this.closeParenToken, GetDiagnostics(), annotations);

    internal RefTypeExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var keyword = (SyntaxToken)reader.ReadValue();
      if (keyword != null)
      {
         AdjustFlagsAndWidth(keyword);
         this.keyword = keyword;
      }
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.keyword);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.expression);
      writer.WriteValue(this.closeParenToken);
    }

    static RefTypeExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(RefTypeExpressionSyntax), r => new RefTypeExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for RefValue expression.</summary>
  internal sealed partial class RefValueExpressionSyntax : ExpressionSyntax
  {
    internal readonly SyntaxToken keyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken comma;
    internal readonly TypeSyntax type;
    internal readonly SyntaxToken closeParenToken;

    internal RefValueExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken comma, TypeSyntax type, SyntaxToken closeParenToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 6;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(comma);
        this.comma = comma;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal RefValueExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken comma, TypeSyntax type, SyntaxToken closeParenToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 6;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(comma);
        this.comma = comma;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal RefValueExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken comma, TypeSyntax type, SyntaxToken closeParenToken)
        : base(kind)
    {
        this.SlotCount = 6;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(comma);
        this.comma = comma;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>SyntaxToken representing the RefValueKeyword.</summary>
    public SyntaxToken Keyword => this.keyword;
    /// <summary>SyntaxToken representing open parenthesis.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>Typed reference expression.</summary>
    public ExpressionSyntax Expression => this.expression;
    /// <summary>Comma separating the arguments.</summary>
    public SyntaxToken Comma => this.comma;
    /// <summary>The type of the value.</summary>
    public TypeSyntax Type => this.type;
    /// <summary>SyntaxToken representing close parenthesis.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.keyword;
            case 1: return this.openParenToken;
            case 2: return this.expression;
            case 3: return this.comma;
            case 4: return this.type;
            case 5: return this.closeParenToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.RefValueExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitRefValueExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitRefValueExpression(this);

    public RefValueExpressionSyntax Update(SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken comma, TypeSyntax type, SyntaxToken closeParenToken)
    {
        if (keyword != this.Keyword || openParenToken != this.OpenParenToken || expression != this.Expression || comma != this.Comma || type != this.Type || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.RefValueExpression(keyword, openParenToken, expression, comma, type, closeParenToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new RefValueExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.expression, this.comma, this.type, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new RefValueExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.expression, this.comma, this.type, this.closeParenToken, GetDiagnostics(), annotations);

    internal RefValueExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 6;
      var keyword = (SyntaxToken)reader.ReadValue();
      if (keyword != null)
      {
         AdjustFlagsAndWidth(keyword);
         this.keyword = keyword;
      }
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
      var comma = (SyntaxToken)reader.ReadValue();
      if (comma != null)
      {
         AdjustFlagsAndWidth(comma);
         this.comma = comma;
      }
      var type = (TypeSyntax)reader.ReadValue();
      if (type != null)
      {
         AdjustFlagsAndWidth(type);
         this.type = type;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.keyword);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.expression);
      writer.WriteValue(this.comma);
      writer.WriteValue(this.type);
      writer.WriteValue(this.closeParenToken);
    }

    static RefValueExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(RefValueExpressionSyntax), r => new RefValueExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for Checked or Unchecked expression.</summary>
  internal sealed partial class CheckedExpressionSyntax : ExpressionSyntax
  {
    internal readonly SyntaxToken keyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken closeParenToken;

    internal CheckedExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal CheckedExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal CheckedExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken)
        : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>SyntaxToken representing the checked or unchecked keyword.</summary>
    public SyntaxToken Keyword => this.keyword;
    /// <summary>SyntaxToken representing open parenthesis.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>Argument of the primary function.</summary>
    public ExpressionSyntax Expression => this.expression;
    /// <summary>SyntaxToken representing close parenthesis.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.keyword;
            case 1: return this.openParenToken;
            case 2: return this.expression;
            case 3: return this.closeParenToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.CheckedExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitCheckedExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitCheckedExpression(this);

    public CheckedExpressionSyntax Update(SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken)
    {
        if (keyword != this.Keyword || openParenToken != this.OpenParenToken || expression != this.Expression || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.CheckedExpression(this.Kind, keyword, openParenToken, expression, closeParenToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new CheckedExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.expression, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new CheckedExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.expression, this.closeParenToken, GetDiagnostics(), annotations);

    internal CheckedExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var keyword = (SyntaxToken)reader.ReadValue();
      if (keyword != null)
      {
         AdjustFlagsAndWidth(keyword);
         this.keyword = keyword;
      }
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.keyword);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.expression);
      writer.WriteValue(this.closeParenToken);
    }

    static CheckedExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(CheckedExpressionSyntax), r => new CheckedExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for Default expression.</summary>
  internal sealed partial class DefaultExpressionSyntax : ExpressionSyntax
  {
    internal readonly SyntaxToken keyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly TypeSyntax type;
    internal readonly SyntaxToken closeParenToken;

    internal DefaultExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal DefaultExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal DefaultExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken)
        : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>SyntaxToken representing the DefaultKeyword.</summary>
    public SyntaxToken Keyword => this.keyword;
    /// <summary>SyntaxToken representing open parenthesis.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>Argument of the primary function.</summary>
    public TypeSyntax Type => this.type;
    /// <summary>SyntaxToken representing close parenthesis.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.keyword;
            case 1: return this.openParenToken;
            case 2: return this.type;
            case 3: return this.closeParenToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.DefaultExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitDefaultExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitDefaultExpression(this);

    public DefaultExpressionSyntax Update(SyntaxToken keyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken)
    {
        if (keyword != this.Keyword || openParenToken != this.OpenParenToken || type != this.Type || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.DefaultExpression(keyword, openParenToken, type, closeParenToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new DefaultExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.type, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new DefaultExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.type, this.closeParenToken, GetDiagnostics(), annotations);

    internal DefaultExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var keyword = (SyntaxToken)reader.ReadValue();
      if (keyword != null)
      {
         AdjustFlagsAndWidth(keyword);
         this.keyword = keyword;
      }
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var type = (TypeSyntax)reader.ReadValue();
      if (type != null)
      {
         AdjustFlagsAndWidth(type);
         this.type = type;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.keyword);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.type);
      writer.WriteValue(this.closeParenToken);
    }

    static DefaultExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(DefaultExpressionSyntax), r => new DefaultExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for TypeOf expression.</summary>
  internal sealed partial class TypeOfExpressionSyntax : ExpressionSyntax
  {
    internal readonly SyntaxToken keyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly TypeSyntax type;
    internal readonly SyntaxToken closeParenToken;

    internal TypeOfExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal TypeOfExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal TypeOfExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken)
        : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>SyntaxToken representing the TypeOfKeyword.</summary>
    public SyntaxToken Keyword => this.keyword;
    /// <summary>SyntaxToken representing open parenthesis.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>The expression to return type of.</summary>
    public TypeSyntax Type => this.type;
    /// <summary>SyntaxToken representing close parenthesis.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.keyword;
            case 1: return this.openParenToken;
            case 2: return this.type;
            case 3: return this.closeParenToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.TypeOfExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitTypeOfExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitTypeOfExpression(this);

    public TypeOfExpressionSyntax Update(SyntaxToken keyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken)
    {
        if (keyword != this.Keyword || openParenToken != this.OpenParenToken || type != this.Type || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.TypeOfExpression(keyword, openParenToken, type, closeParenToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new TypeOfExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.type, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new TypeOfExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.type, this.closeParenToken, GetDiagnostics(), annotations);

    internal TypeOfExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var keyword = (SyntaxToken)reader.ReadValue();
      if (keyword != null)
      {
         AdjustFlagsAndWidth(keyword);
         this.keyword = keyword;
      }
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var type = (TypeSyntax)reader.ReadValue();
      if (type != null)
      {
         AdjustFlagsAndWidth(type);
         this.type = type;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.keyword);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.type);
      writer.WriteValue(this.closeParenToken);
    }

    static TypeOfExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(TypeOfExpressionSyntax), r => new TypeOfExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for SizeOf expression.</summary>
  internal sealed partial class SizeOfExpressionSyntax : ExpressionSyntax
  {
    internal readonly SyntaxToken keyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly TypeSyntax type;
    internal readonly SyntaxToken closeParenToken;

    internal SizeOfExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal SizeOfExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal SizeOfExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken)
        : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>SyntaxToken representing the SizeOfKeyword.</summary>
    public SyntaxToken Keyword => this.keyword;
    /// <summary>SyntaxToken representing open parenthesis.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>Argument of the primary function.</summary>
    public TypeSyntax Type => this.type;
    /// <summary>SyntaxToken representing close parenthesis.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.keyword;
            case 1: return this.openParenToken;
            case 2: return this.type;
            case 3: return this.closeParenToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.SizeOfExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitSizeOfExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitSizeOfExpression(this);

    public SizeOfExpressionSyntax Update(SyntaxToken keyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken)
    {
        if (keyword != this.Keyword || openParenToken != this.OpenParenToken || type != this.Type || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.SizeOfExpression(keyword, openParenToken, type, closeParenToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new SizeOfExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.type, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new SizeOfExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.type, this.closeParenToken, GetDiagnostics(), annotations);

    internal SizeOfExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var keyword = (SyntaxToken)reader.ReadValue();
      if (keyword != null)
      {
         AdjustFlagsAndWidth(keyword);
         this.keyword = keyword;
      }
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var type = (TypeSyntax)reader.ReadValue();
      if (type != null)
      {
         AdjustFlagsAndWidth(type);
         this.type = type;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.keyword);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.type);
      writer.WriteValue(this.closeParenToken);
    }

    static SizeOfExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(SizeOfExpressionSyntax), r => new SizeOfExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for invocation expression.</summary>
  internal sealed partial class InvocationExpressionSyntax : ExpressionSyntax
  {
    internal readonly ExpressionSyntax expression;
    internal readonly ArgumentListSyntax argumentList;

    internal InvocationExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, ArgumentListSyntax argumentList, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }


    internal InvocationExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, ArgumentListSyntax argumentList, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }


    internal InvocationExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, ArgumentListSyntax argumentList)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }

    /// <summary>ExpressionSyntax node representing the expression part of the invocation.</summary>
    public ExpressionSyntax Expression => this.expression;
    /// <summary>ArgumentListSyntax node representing the list of arguments of the invocation expression.</summary>
    public ArgumentListSyntax ArgumentList => this.argumentList;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.expression;
            case 1: return this.argumentList;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.InvocationExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitInvocationExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitInvocationExpression(this);

    public InvocationExpressionSyntax Update(ExpressionSyntax expression, ArgumentListSyntax argumentList)
    {
        if (expression != this.Expression || argumentList != this.ArgumentList)
        {
            var newNode = SyntaxFactory.InvocationExpression(expression, argumentList);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new InvocationExpressionSyntax(this.Kind, this.expression, this.argumentList, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new InvocationExpressionSyntax(this.Kind, this.expression, this.argumentList, GetDiagnostics(), annotations);

    internal InvocationExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
      var argumentList = (ArgumentListSyntax)reader.ReadValue();
      if (argumentList != null)
      {
         AdjustFlagsAndWidth(argumentList);
         this.argumentList = argumentList;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.expression);
      writer.WriteValue(this.argumentList);
    }

    static InvocationExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(InvocationExpressionSyntax), r => new InvocationExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for element access expression.</summary>
  internal sealed partial class ElementAccessExpressionSyntax : ExpressionSyntax
  {
    internal readonly ExpressionSyntax expression;
    internal readonly BracketedArgumentListSyntax argumentList;

    internal ElementAccessExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, BracketedArgumentListSyntax argumentList, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }


    internal ElementAccessExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, BracketedArgumentListSyntax argumentList, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }


    internal ElementAccessExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, BracketedArgumentListSyntax argumentList)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }

    /// <summary>ExpressionSyntax node representing the expression which is accessing the element.</summary>
    public ExpressionSyntax Expression => this.expression;
    /// <summary>BracketedArgumentListSyntax node representing the list of arguments of the element access expression.</summary>
    public BracketedArgumentListSyntax ArgumentList => this.argumentList;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.expression;
            case 1: return this.argumentList;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ElementAccessExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitElementAccessExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitElementAccessExpression(this);

    public ElementAccessExpressionSyntax Update(ExpressionSyntax expression, BracketedArgumentListSyntax argumentList)
    {
        if (expression != this.Expression || argumentList != this.ArgumentList)
        {
            var newNode = SyntaxFactory.ElementAccessExpression(expression, argumentList);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ElementAccessExpressionSyntax(this.Kind, this.expression, this.argumentList, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ElementAccessExpressionSyntax(this.Kind, this.expression, this.argumentList, GetDiagnostics(), annotations);

    internal ElementAccessExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
      var argumentList = (BracketedArgumentListSyntax)reader.ReadValue();
      if (argumentList != null)
      {
         AdjustFlagsAndWidth(argumentList);
         this.argumentList = argumentList;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.expression);
      writer.WriteValue(this.argumentList);
    }

    static ElementAccessExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ElementAccessExpressionSyntax), r => new ElementAccessExpressionSyntax(r));
    }
  }

  /// <summary>Provides the base class from which the classes that represent argument list syntax nodes are derived. This is an abstract class.</summary>
  internal abstract partial class BaseArgumentListSyntax : CSharpSyntaxNode
  {
    internal BaseArgumentListSyntax(SyntaxKind kind, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal BaseArgumentListSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    protected BaseArgumentListSyntax(ObjectReader reader)
       : base(reader)
    {
    }

    /// <summary>SeparatedSyntaxList of ArgumentSyntax nodes representing the list of arguments.</summary>
    public abstract Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<ArgumentSyntax> Arguments { get; }
  }

  /// <summary>Class which represents the syntax node for the list of arguments.</summary>
  internal sealed partial class ArgumentListSyntax : BaseArgumentListSyntax
  {
    internal readonly SyntaxToken openParenToken;
    internal readonly GreenNode arguments;
    internal readonly SyntaxToken closeParenToken;

    internal ArgumentListSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode arguments, SyntaxToken closeParenToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal ArgumentListSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode arguments, SyntaxToken closeParenToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal ArgumentListSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode arguments, SyntaxToken closeParenToken)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>SyntaxToken representing open parenthesis.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>SeparatedSyntaxList of ArgumentSyntax representing the list of arguments.</summary>
    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<ArgumentSyntax> Arguments => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<ArgumentSyntax>(new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<CSharpSyntaxNode>(this.arguments));
    /// <summary>SyntaxToken representing close parenthesis.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.openParenToken;
            case 1: return this.arguments;
            case 2: return this.closeParenToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ArgumentListSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitArgumentList(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitArgumentList(this);

    public ArgumentListSyntax Update(SyntaxToken openParenToken, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<ArgumentSyntax> arguments, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || arguments != this.Arguments || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.ArgumentList(openParenToken, arguments, closeParenToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ArgumentListSyntax(this.Kind, this.openParenToken, this.arguments, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ArgumentListSyntax(this.Kind, this.openParenToken, this.arguments, this.closeParenToken, GetDiagnostics(), annotations);

    internal ArgumentListSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var arguments = (GreenNode)reader.ReadValue();
      if (arguments != null)
      {
         AdjustFlagsAndWidth(arguments);
         this.arguments = arguments;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.arguments);
      writer.WriteValue(this.closeParenToken);
    }

    static ArgumentListSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ArgumentListSyntax), r => new ArgumentListSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for bracketed argument list.</summary>
  internal sealed partial class BracketedArgumentListSyntax : BaseArgumentListSyntax
  {
    internal readonly SyntaxToken openBracketToken;
    internal readonly GreenNode arguments;
    internal readonly SyntaxToken closeBracketToken;

    internal BracketedArgumentListSyntax(SyntaxKind kind, SyntaxToken openBracketToken, GreenNode arguments, SyntaxToken closeBracketToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
    }


    internal BracketedArgumentListSyntax(SyntaxKind kind, SyntaxToken openBracketToken, GreenNode arguments, SyntaxToken closeBracketToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
    }


    internal BracketedArgumentListSyntax(SyntaxKind kind, SyntaxToken openBracketToken, GreenNode arguments, SyntaxToken closeBracketToken)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
    }

    /// <summary>SyntaxToken representing open bracket.</summary>
    public SyntaxToken OpenBracketToken => this.openBracketToken;
    /// <summary>SeparatedSyntaxList of ArgumentSyntax representing the list of arguments.</summary>
    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<ArgumentSyntax> Arguments => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<ArgumentSyntax>(new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<CSharpSyntaxNode>(this.arguments));
    /// <summary>SyntaxToken representing close bracket.</summary>
    public SyntaxToken CloseBracketToken => this.closeBracketToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.openBracketToken;
            case 1: return this.arguments;
            case 2: return this.closeBracketToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.BracketedArgumentListSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitBracketedArgumentList(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitBracketedArgumentList(this);

    public BracketedArgumentListSyntax Update(SyntaxToken openBracketToken, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<ArgumentSyntax> arguments, SyntaxToken closeBracketToken)
    {
        if (openBracketToken != this.OpenBracketToken || arguments != this.Arguments || closeBracketToken != this.CloseBracketToken)
        {
            var newNode = SyntaxFactory.BracketedArgumentList(openBracketToken, arguments, closeBracketToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new BracketedArgumentListSyntax(this.Kind, this.openBracketToken, this.arguments, this.closeBracketToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new BracketedArgumentListSyntax(this.Kind, this.openBracketToken, this.arguments, this.closeBracketToken, GetDiagnostics(), annotations);

    internal BracketedArgumentListSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var openBracketToken = (SyntaxToken)reader.ReadValue();
      if (openBracketToken != null)
      {
         AdjustFlagsAndWidth(openBracketToken);
         this.openBracketToken = openBracketToken;
      }
      var arguments = (GreenNode)reader.ReadValue();
      if (arguments != null)
      {
         AdjustFlagsAndWidth(arguments);
         this.arguments = arguments;
      }
      var closeBracketToken = (SyntaxToken)reader.ReadValue();
      if (closeBracketToken != null)
      {
         AdjustFlagsAndWidth(closeBracketToken);
         this.closeBracketToken = closeBracketToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.openBracketToken);
      writer.WriteValue(this.arguments);
      writer.WriteValue(this.closeBracketToken);
    }

    static BracketedArgumentListSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(BracketedArgumentListSyntax), r => new BracketedArgumentListSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for argument.</summary>
  internal sealed partial class ArgumentSyntax : CSharpSyntaxNode
  {
    internal readonly NameColonSyntax nameColon;
    internal readonly SyntaxToken refKindKeyword;
    internal readonly ExpressionSyntax expression;

    internal ArgumentSyntax(SyntaxKind kind, NameColonSyntax nameColon, SyntaxToken refKindKeyword, ExpressionSyntax expression, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        if (nameColon != null)
        {
            this.AdjustFlagsAndWidth(nameColon);
            this.nameColon = nameColon;
        }
        if (refKindKeyword != null)
        {
            this.AdjustFlagsAndWidth(refKindKeyword);
            this.refKindKeyword = refKindKeyword;
        }
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }


    internal ArgumentSyntax(SyntaxKind kind, NameColonSyntax nameColon, SyntaxToken refKindKeyword, ExpressionSyntax expression, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        if (nameColon != null)
        {
            this.AdjustFlagsAndWidth(nameColon);
            this.nameColon = nameColon;
        }
        if (refKindKeyword != null)
        {
            this.AdjustFlagsAndWidth(refKindKeyword);
            this.refKindKeyword = refKindKeyword;
        }
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }


    internal ArgumentSyntax(SyntaxKind kind, NameColonSyntax nameColon, SyntaxToken refKindKeyword, ExpressionSyntax expression)
        : base(kind)
    {
        this.SlotCount = 3;
        if (nameColon != null)
        {
            this.AdjustFlagsAndWidth(nameColon);
            this.nameColon = nameColon;
        }
        if (refKindKeyword != null)
        {
            this.AdjustFlagsAndWidth(refKindKeyword);
            this.refKindKeyword = refKindKeyword;
        }
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    /// <summary>NameColonSyntax node representing the optional name arguments.</summary>
    public NameColonSyntax NameColon => this.nameColon;
    /// <summary>SyntaxToken representing the optional ref or out keyword.</summary>
    public SyntaxToken RefKindKeyword => this.refKindKeyword;
    /// <summary>ExpressionSyntax node representing the argument.</summary>
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.nameColon;
            case 1: return this.refKindKeyword;
            case 2: return this.expression;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ArgumentSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitArgument(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitArgument(this);

    public ArgumentSyntax Update(NameColonSyntax nameColon, SyntaxToken refKindKeyword, ExpressionSyntax expression)
    {
        if (nameColon != this.NameColon || refKindKeyword != this.RefKindKeyword || expression != this.Expression)
        {
            var newNode = SyntaxFactory.Argument(nameColon, refKindKeyword, expression);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ArgumentSyntax(this.Kind, this.nameColon, this.refKindKeyword, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ArgumentSyntax(this.Kind, this.nameColon, this.refKindKeyword, this.expression, GetDiagnostics(), annotations);

    internal ArgumentSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var nameColon = (NameColonSyntax)reader.ReadValue();
      if (nameColon != null)
      {
         AdjustFlagsAndWidth(nameColon);
         this.nameColon = nameColon;
      }
      var refKindKeyword = (SyntaxToken)reader.ReadValue();
      if (refKindKeyword != null)
      {
         AdjustFlagsAndWidth(refKindKeyword);
         this.refKindKeyword = refKindKeyword;
      }
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.nameColon);
      writer.WriteValue(this.refKindKeyword);
      writer.WriteValue(this.expression);
    }

    static ArgumentSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ArgumentSyntax), r => new ArgumentSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for name colon syntax.</summary>
  internal sealed partial class NameColonSyntax : CSharpSyntaxNode
  {
    internal readonly IdentifierNameSyntax name;
    internal readonly SyntaxToken colonToken;

    internal NameColonSyntax(SyntaxKind kind, IdentifierNameSyntax name, SyntaxToken colonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }


    internal NameColonSyntax(SyntaxKind kind, IdentifierNameSyntax name, SyntaxToken colonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }


    internal NameColonSyntax(SyntaxKind kind, IdentifierNameSyntax name, SyntaxToken colonToken)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }

    /// <summary>IdentifierNameSyntax representing the identifier name.</summary>
    public IdentifierNameSyntax Name => this.name;
    /// <summary>SyntaxToken representing colon.</summary>
    public SyntaxToken ColonToken => this.colonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.name;
            case 1: return this.colonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.NameColonSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitNameColon(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitNameColon(this);

    public NameColonSyntax Update(IdentifierNameSyntax name, SyntaxToken colonToken)
    {
        if (name != this.Name || colonToken != this.ColonToken)
        {
            var newNode = SyntaxFactory.NameColon(name, colonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new NameColonSyntax(this.Kind, this.name, this.colonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new NameColonSyntax(this.Kind, this.name, this.colonToken, GetDiagnostics(), annotations);

    internal NameColonSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var name = (IdentifierNameSyntax)reader.ReadValue();
      if (name != null)
      {
         AdjustFlagsAndWidth(name);
         this.name = name;
      }
      var colonToken = (SyntaxToken)reader.ReadValue();
      if (colonToken != null)
      {
         AdjustFlagsAndWidth(colonToken);
         this.colonToken = colonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.name);
      writer.WriteValue(this.colonToken);
    }

    static NameColonSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(NameColonSyntax), r => new NameColonSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for the variable declaration in an out var declaration or a deconstruction declaration.</summary>
  internal sealed partial class DeclarationExpressionSyntax : ExpressionSyntax
  {
    internal readonly TypeSyntax type;
    internal readonly VariableDesignationSyntax designation;

    internal DeclarationExpressionSyntax(SyntaxKind kind, TypeSyntax type, VariableDesignationSyntax designation, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(designation);
        this.designation = designation;
    }


    internal DeclarationExpressionSyntax(SyntaxKind kind, TypeSyntax type, VariableDesignationSyntax designation, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(designation);
        this.designation = designation;
    }


    internal DeclarationExpressionSyntax(SyntaxKind kind, TypeSyntax type, VariableDesignationSyntax designation)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(designation);
        this.designation = designation;
    }

    public TypeSyntax Type => this.type;
    /// <summary>Declaration representing the variable declared in an out parameter or deconstruction.</summary>
    public VariableDesignationSyntax Designation => this.designation;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.type;
            case 1: return this.designation;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.DeclarationExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitDeclarationExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitDeclarationExpression(this);

    public DeclarationExpressionSyntax Update(TypeSyntax type, VariableDesignationSyntax designation)
    {
        if (type != this.Type || designation != this.Designation)
        {
            var newNode = SyntaxFactory.DeclarationExpression(type, designation);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new DeclarationExpressionSyntax(this.Kind, this.type, this.designation, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new DeclarationExpressionSyntax(this.Kind, this.type, this.designation, GetDiagnostics(), annotations);

    internal DeclarationExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var type = (TypeSyntax)reader.ReadValue();
      if (type != null)
      {
         AdjustFlagsAndWidth(type);
         this.type = type;
      }
      var designation = (VariableDesignationSyntax)reader.ReadValue();
      if (designation != null)
      {
         AdjustFlagsAndWidth(designation);
         this.designation = designation;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.type);
      writer.WriteValue(this.designation);
    }

    static DeclarationExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(DeclarationExpressionSyntax), r => new DeclarationExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for cast expression.</summary>
  internal sealed partial class CastExpressionSyntax : ExpressionSyntax
  {
    internal readonly SyntaxToken openParenToken;
    internal readonly TypeSyntax type;
    internal readonly SyntaxToken closeParenToken;
    internal readonly ExpressionSyntax expression;

    internal CastExpressionSyntax(SyntaxKind kind, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken, ExpressionSyntax expression, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }


    internal CastExpressionSyntax(SyntaxKind kind, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken, ExpressionSyntax expression, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }


    internal CastExpressionSyntax(SyntaxKind kind, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken, ExpressionSyntax expression)
        : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    /// <summary>SyntaxToken representing the open parenthesis.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>TypeSyntax node representing the type to which the expression is being cast.</summary>
    public TypeSyntax Type => this.type;
    /// <summary>SyntaxToken representing the close parenthesis.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;
    /// <summary>ExpressionSyntax node representing the expression that is being casted.</summary>
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.openParenToken;
            case 1: return this.type;
            case 2: return this.closeParenToken;
            case 3: return this.expression;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.CastExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitCastExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitCastExpression(this);

    public CastExpressionSyntax Update(SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken, ExpressionSyntax expression)
    {
        if (openParenToken != this.OpenParenToken || type != this.Type || closeParenToken != this.CloseParenToken || expression != this.Expression)
        {
            var newNode = SyntaxFactory.CastExpression(openParenToken, type, closeParenToken, expression);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new CastExpressionSyntax(this.Kind, this.openParenToken, this.type, this.closeParenToken, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new CastExpressionSyntax(this.Kind, this.openParenToken, this.type, this.closeParenToken, this.expression, GetDiagnostics(), annotations);

    internal CastExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var type = (TypeSyntax)reader.ReadValue();
      if (type != null)
      {
         AdjustFlagsAndWidth(type);
         this.type = type;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.type);
      writer.WriteValue(this.closeParenToken);
      writer.WriteValue(this.expression);
    }

    static CastExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(CastExpressionSyntax), r => new CastExpressionSyntax(r));
    }
  }

  /// <summary>Provides the base class from which the classes that represent anonymous function expressions are derived.</summary>
  internal abstract partial class AnonymousFunctionExpressionSyntax : ExpressionSyntax
  {
    internal AnonymousFunctionExpressionSyntax(SyntaxKind kind, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal AnonymousFunctionExpressionSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    protected AnonymousFunctionExpressionSyntax(ObjectReader reader)
       : base(reader)
    {
    }

    /// <summary>Gets the "async" token.</summary>
    public abstract SyntaxToken AsyncKeyword { get; }

    /// <summary>ExpressionSyntax or BlockSyntax representing the body of the lambda expression.</summary>
    public abstract CSharpSyntaxNode Body { get; }
  }

  /// <summary>Class which represents the syntax node for anonymous method expression.</summary>
  internal sealed partial class AnonymousMethodExpressionSyntax : AnonymousFunctionExpressionSyntax
  {
    internal readonly SyntaxToken asyncKeyword;
    internal readonly SyntaxToken delegateKeyword;
    internal readonly ParameterListSyntax parameterList;
    internal readonly CSharpSyntaxNode body;

    internal AnonymousMethodExpressionSyntax(SyntaxKind kind, SyntaxToken asyncKeyword, SyntaxToken delegateKeyword, ParameterListSyntax parameterList, CSharpSyntaxNode body, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        if (asyncKeyword != null)
        {
            this.AdjustFlagsAndWidth(asyncKeyword);
            this.asyncKeyword = asyncKeyword;
        }
        this.AdjustFlagsAndWidth(delegateKeyword);
        this.delegateKeyword = delegateKeyword;
        if (parameterList != null)
        {
            this.AdjustFlagsAndWidth(parameterList);
            this.parameterList = parameterList;
        }
        this.AdjustFlagsAndWidth(body);
        this.body = body;
    }


    internal AnonymousMethodExpressionSyntax(SyntaxKind kind, SyntaxToken asyncKeyword, SyntaxToken delegateKeyword, ParameterListSyntax parameterList, CSharpSyntaxNode body, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        if (asyncKeyword != null)
        {
            this.AdjustFlagsAndWidth(asyncKeyword);
            this.asyncKeyword = asyncKeyword;
        }
        this.AdjustFlagsAndWidth(delegateKeyword);
        this.delegateKeyword = delegateKeyword;
        if (parameterList != null)
        {
            this.AdjustFlagsAndWidth(parameterList);
            this.parameterList = parameterList;
        }
        this.AdjustFlagsAndWidth(body);
        this.body = body;
    }


    internal AnonymousMethodExpressionSyntax(SyntaxKind kind, SyntaxToken asyncKeyword, SyntaxToken delegateKeyword, ParameterListSyntax parameterList, CSharpSyntaxNode body)
        : base(kind)
    {
        this.SlotCount = 4;
        if (asyncKeyword != null)
        {
            this.AdjustFlagsAndWidth(asyncKeyword);
            this.asyncKeyword = asyncKeyword;
        }
        this.AdjustFlagsAndWidth(delegateKeyword);
        this.delegateKeyword = delegateKeyword;
        if (parameterList != null)
        {
            this.AdjustFlagsAndWidth(parameterList);
            this.parameterList = parameterList;
        }
        this.AdjustFlagsAndWidth(body);
        this.body = body;
    }

    /// <summary>Gets the "async" token.</summary>
    public override SyntaxToken AsyncKeyword => this.asyncKeyword;
    /// <summary>SyntaxToken representing the delegate keyword.</summary>
    public SyntaxToken DelegateKeyword => this.delegateKeyword;
    /// <summary>List of parameters of the anonymous method expression, or null if there no parameters are specified.</summary>
    public ParameterListSyntax ParameterList => this.parameterList;
    /// <summary>BlockSyntax node representing the body of the anonymous method.</summary>
    public override CSharpSyntaxNode Body => this.body;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.asyncKeyword;
            case 1: return this.delegateKeyword;
            case 2: return this.parameterList;
            case 3: return this.body;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.AnonymousMethodExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitAnonymousMethodExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitAnonymousMethodExpression(this);

    public AnonymousMethodExpressionSyntax Update(SyntaxToken asyncKeyword, SyntaxToken delegateKeyword, ParameterListSyntax parameterList, CSharpSyntaxNode body)
    {
        if (asyncKeyword != this.AsyncKeyword || delegateKeyword != this.DelegateKeyword || parameterList != this.ParameterList || body != this.Body)
        {
            var newNode = SyntaxFactory.AnonymousMethodExpression(asyncKeyword, delegateKeyword, parameterList, body);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new AnonymousMethodExpressionSyntax(this.Kind, this.asyncKeyword, this.delegateKeyword, this.parameterList, this.body, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new AnonymousMethodExpressionSyntax(this.Kind, this.asyncKeyword, this.delegateKeyword, this.parameterList, this.body, GetDiagnostics(), annotations);

    internal AnonymousMethodExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var asyncKeyword = (SyntaxToken)reader.ReadValue();
      if (asyncKeyword != null)
      {
         AdjustFlagsAndWidth(asyncKeyword);
         this.asyncKeyword = asyncKeyword;
      }
      var delegateKeyword = (SyntaxToken)reader.ReadValue();
      if (delegateKeyword != null)
      {
         AdjustFlagsAndWidth(delegateKeyword);
         this.delegateKeyword = delegateKeyword;
      }
      var parameterList = (ParameterListSyntax)reader.ReadValue();
      if (parameterList != null)
      {
         AdjustFlagsAndWidth(parameterList);
         this.parameterList = parameterList;
      }
      var body = (CSharpSyntaxNode)reader.ReadValue();
      if (body != null)
      {
         AdjustFlagsAndWidth(body);
         this.body = body;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.asyncKeyword);
      writer.WriteValue(this.delegateKeyword);
      writer.WriteValue(this.parameterList);
      writer.WriteValue(this.body);
    }

    static AnonymousMethodExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(AnonymousMethodExpressionSyntax), r => new AnonymousMethodExpressionSyntax(r));
    }
  }

  /// <summary>Provides the base class from which the classes that represent lambda expressions are derived.</summary>
  internal abstract partial class LambdaExpressionSyntax : AnonymousFunctionExpressionSyntax
  {
    internal LambdaExpressionSyntax(SyntaxKind kind, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal LambdaExpressionSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    protected LambdaExpressionSyntax(ObjectReader reader)
       : base(reader)
    {
    }

    /// <summary>SyntaxToken representing equals greater than.</summary>
    public abstract SyntaxToken ArrowToken { get; }
  }

  /// <summary>Class which represents the syntax node for a simple lambda expression.</summary>
  internal sealed partial class SimpleLambdaExpressionSyntax : LambdaExpressionSyntax
  {
    internal readonly SyntaxToken asyncKeyword;
    internal readonly ParameterSyntax parameter;
    internal readonly SyntaxToken arrowToken;
    internal readonly CSharpSyntaxNode body;

    internal SimpleLambdaExpressionSyntax(SyntaxKind kind, SyntaxToken asyncKeyword, ParameterSyntax parameter, SyntaxToken arrowToken, CSharpSyntaxNode body, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        if (asyncKeyword != null)
        {
            this.AdjustFlagsAndWidth(asyncKeyword);
            this.asyncKeyword = asyncKeyword;
        }
        this.AdjustFlagsAndWidth(parameter);
        this.parameter = parameter;
        this.AdjustFlagsAndWidth(arrowToken);
        this.arrowToken = arrowToken;
        this.AdjustFlagsAndWidth(body);
        this.body = body;
    }


    internal SimpleLambdaExpressionSyntax(SyntaxKind kind, SyntaxToken asyncKeyword, ParameterSyntax parameter, SyntaxToken arrowToken, CSharpSyntaxNode body, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        if (asyncKeyword != null)
        {
            this.AdjustFlagsAndWidth(asyncKeyword);
            this.asyncKeyword = asyncKeyword;
        }
        this.AdjustFlagsAndWidth(parameter);
        this.parameter = parameter;
        this.AdjustFlagsAndWidth(arrowToken);
        this.arrowToken = arrowToken;
        this.AdjustFlagsAndWidth(body);
        this.body = body;
    }


    internal SimpleLambdaExpressionSyntax(SyntaxKind kind, SyntaxToken asyncKeyword, ParameterSyntax parameter, SyntaxToken arrowToken, CSharpSyntaxNode body)
        : base(kind)
    {
        this.SlotCount = 4;
        if (asyncKeyword != null)
        {
            this.AdjustFlagsAndWidth(asyncKeyword);
            this.asyncKeyword = asyncKeyword;
        }
        this.AdjustFlagsAndWidth(parameter);
        this.parameter = parameter;
        this.AdjustFlagsAndWidth(arrowToken);
        this.arrowToken = arrowToken;
        this.AdjustFlagsAndWidth(body);
        this.body = body;
    }

    /// <summary>Gets the "async" token.</summary>
    public override SyntaxToken AsyncKeyword => this.asyncKeyword;
    /// <summary>ParameterSyntax node representing the parameter of the lambda expression.</summary>
    public ParameterSyntax Parameter => this.parameter;
    /// <summary>SyntaxToken representing equals greater than.</summary>
    public override SyntaxToken ArrowToken => this.arrowToken;
    /// <summary>SyntaxNode representing the body of the lambda expression.</summary>
    public override CSharpSyntaxNode Body => this.body;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.asyncKeyword;
            case 1: return this.parameter;
            case 2: return this.arrowToken;
            case 3: return this.body;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.SimpleLambdaExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitSimpleLambdaExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitSimpleLambdaExpression(this);

    public SimpleLambdaExpressionSyntax Update(SyntaxToken asyncKeyword, ParameterSyntax parameter, SyntaxToken arrowToken, CSharpSyntaxNode body)
    {
        if (asyncKeyword != this.AsyncKeyword || parameter != this.Parameter || arrowToken != this.ArrowToken || body != this.Body)
        {
            var newNode = SyntaxFactory.SimpleLambdaExpression(asyncKeyword, parameter, arrowToken, body);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new SimpleLambdaExpressionSyntax(this.Kind, this.asyncKeyword, this.parameter, this.arrowToken, this.body, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new SimpleLambdaExpressionSyntax(this.Kind, this.asyncKeyword, this.parameter, this.arrowToken, this.body, GetDiagnostics(), annotations);

    internal SimpleLambdaExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var asyncKeyword = (SyntaxToken)reader.ReadValue();
      if (asyncKeyword != null)
      {
         AdjustFlagsAndWidth(asyncKeyword);
         this.asyncKeyword = asyncKeyword;
      }
      var parameter = (ParameterSyntax)reader.ReadValue();
      if (parameter != null)
      {
         AdjustFlagsAndWidth(parameter);
         this.parameter = parameter;
      }
      var arrowToken = (SyntaxToken)reader.ReadValue();
      if (arrowToken != null)
      {
         AdjustFlagsAndWidth(arrowToken);
         this.arrowToken = arrowToken;
      }
      var body = (CSharpSyntaxNode)reader.ReadValue();
      if (body != null)
      {
         AdjustFlagsAndWidth(body);
         this.body = body;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.asyncKeyword);
      writer.WriteValue(this.parameter);
      writer.WriteValue(this.arrowToken);
      writer.WriteValue(this.body);
    }

    static SimpleLambdaExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(SimpleLambdaExpressionSyntax), r => new SimpleLambdaExpressionSyntax(r));
    }
  }

  internal sealed partial class RefExpressionSyntax : ExpressionSyntax
  {
    internal readonly SyntaxToken refKeyword;
    internal readonly ExpressionSyntax expression;

    internal RefExpressionSyntax(SyntaxKind kind, SyntaxToken refKeyword, ExpressionSyntax expression, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(refKeyword);
        this.refKeyword = refKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }


    internal RefExpressionSyntax(SyntaxKind kind, SyntaxToken refKeyword, ExpressionSyntax expression, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(refKeyword);
        this.refKeyword = refKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }


    internal RefExpressionSyntax(SyntaxKind kind, SyntaxToken refKeyword, ExpressionSyntax expression)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(refKeyword);
        this.refKeyword = refKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    public SyntaxToken RefKeyword => this.refKeyword;
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.refKeyword;
            case 1: return this.expression;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.RefExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitRefExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitRefExpression(this);

    public RefExpressionSyntax Update(SyntaxToken refKeyword, ExpressionSyntax expression)
    {
        if (refKeyword != this.RefKeyword || expression != this.Expression)
        {
            var newNode = SyntaxFactory.RefExpression(refKeyword, expression);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new RefExpressionSyntax(this.Kind, this.refKeyword, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new RefExpressionSyntax(this.Kind, this.refKeyword, this.expression, GetDiagnostics(), annotations);

    internal RefExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var refKeyword = (SyntaxToken)reader.ReadValue();
      if (refKeyword != null)
      {
         AdjustFlagsAndWidth(refKeyword);
         this.refKeyword = refKeyword;
      }
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.refKeyword);
      writer.WriteValue(this.expression);
    }

    static RefExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(RefExpressionSyntax), r => new RefExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for parenthesized lambda expression.</summary>
  internal sealed partial class ParenthesizedLambdaExpressionSyntax : LambdaExpressionSyntax
  {
    internal readonly SyntaxToken asyncKeyword;
    internal readonly ParameterListSyntax parameterList;
    internal readonly SyntaxToken arrowToken;
    internal readonly CSharpSyntaxNode body;

    internal ParenthesizedLambdaExpressionSyntax(SyntaxKind kind, SyntaxToken asyncKeyword, ParameterListSyntax parameterList, SyntaxToken arrowToken, CSharpSyntaxNode body, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        if (asyncKeyword != null)
        {
            this.AdjustFlagsAndWidth(asyncKeyword);
            this.asyncKeyword = asyncKeyword;
        }
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        this.AdjustFlagsAndWidth(arrowToken);
        this.arrowToken = arrowToken;
        this.AdjustFlagsAndWidth(body);
        this.body = body;
    }


    internal ParenthesizedLambdaExpressionSyntax(SyntaxKind kind, SyntaxToken asyncKeyword, ParameterListSyntax parameterList, SyntaxToken arrowToken, CSharpSyntaxNode body, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        if (asyncKeyword != null)
        {
            this.AdjustFlagsAndWidth(asyncKeyword);
            this.asyncKeyword = asyncKeyword;
        }
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        this.AdjustFlagsAndWidth(arrowToken);
        this.arrowToken = arrowToken;
        this.AdjustFlagsAndWidth(body);
        this.body = body;
    }


    internal ParenthesizedLambdaExpressionSyntax(SyntaxKind kind, SyntaxToken asyncKeyword, ParameterListSyntax parameterList, SyntaxToken arrowToken, CSharpSyntaxNode body)
        : base(kind)
    {
        this.SlotCount = 4;
        if (asyncKeyword != null)
        {
            this.AdjustFlagsAndWidth(asyncKeyword);
            this.asyncKeyword = asyncKeyword;
        }
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        this.AdjustFlagsAndWidth(arrowToken);
        this.arrowToken = arrowToken;
        this.AdjustFlagsAndWidth(body);
        this.body = body;
    }

    /// <summary>Gets the "async" token.</summary>
    public override SyntaxToken AsyncKeyword => this.asyncKeyword;
    /// <summary>ParameterListSyntax node representing the list of parameters for the lambda expression.</summary>
    public ParameterListSyntax ParameterList => this.parameterList;
    /// <summary>SyntaxToken representing equals greater than.</summary>
    public override SyntaxToken ArrowToken => this.arrowToken;
    /// <summary>SyntaxNode representing the body of the lambda expression.</summary>
    public override CSharpSyntaxNode Body => this.body;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.asyncKeyword;
            case 1: return this.parameterList;
            case 2: return this.arrowToken;
            case 3: return this.body;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ParenthesizedLambdaExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitParenthesizedLambdaExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitParenthesizedLambdaExpression(this);

    public ParenthesizedLambdaExpressionSyntax Update(SyntaxToken asyncKeyword, ParameterListSyntax parameterList, SyntaxToken arrowToken, CSharpSyntaxNode body)
    {
        if (asyncKeyword != this.AsyncKeyword || parameterList != this.ParameterList || arrowToken != this.ArrowToken || body != this.Body)
        {
            var newNode = SyntaxFactory.ParenthesizedLambdaExpression(asyncKeyword, parameterList, arrowToken, body);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ParenthesizedLambdaExpressionSyntax(this.Kind, this.asyncKeyword, this.parameterList, this.arrowToken, this.body, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ParenthesizedLambdaExpressionSyntax(this.Kind, this.asyncKeyword, this.parameterList, this.arrowToken, this.body, GetDiagnostics(), annotations);

    internal ParenthesizedLambdaExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var asyncKeyword = (SyntaxToken)reader.ReadValue();
      if (asyncKeyword != null)
      {
         AdjustFlagsAndWidth(asyncKeyword);
         this.asyncKeyword = asyncKeyword;
      }
      var parameterList = (ParameterListSyntax)reader.ReadValue();
      if (parameterList != null)
      {
         AdjustFlagsAndWidth(parameterList);
         this.parameterList = parameterList;
      }
      var arrowToken = (SyntaxToken)reader.ReadValue();
      if (arrowToken != null)
      {
         AdjustFlagsAndWidth(arrowToken);
         this.arrowToken = arrowToken;
      }
      var body = (CSharpSyntaxNode)reader.ReadValue();
      if (body != null)
      {
         AdjustFlagsAndWidth(body);
         this.body = body;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.asyncKeyword);
      writer.WriteValue(this.parameterList);
      writer.WriteValue(this.arrowToken);
      writer.WriteValue(this.body);
    }

    static ParenthesizedLambdaExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ParenthesizedLambdaExpressionSyntax), r => new ParenthesizedLambdaExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for initializer expression.</summary>
  internal sealed partial class InitializerExpressionSyntax : ExpressionSyntax
  {
    internal readonly SyntaxToken openBraceToken;
    internal readonly GreenNode expressions;
    internal readonly SyntaxToken closeBraceToken;

    internal InitializerExpressionSyntax(SyntaxKind kind, SyntaxToken openBraceToken, GreenNode expressions, SyntaxToken closeBraceToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (expressions != null)
        {
            this.AdjustFlagsAndWidth(expressions);
            this.expressions = expressions;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }


    internal InitializerExpressionSyntax(SyntaxKind kind, SyntaxToken openBraceToken, GreenNode expressions, SyntaxToken closeBraceToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (expressions != null)
        {
            this.AdjustFlagsAndWidth(expressions);
            this.expressions = expressions;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }


    internal InitializerExpressionSyntax(SyntaxKind kind, SyntaxToken openBraceToken, GreenNode expressions, SyntaxToken closeBraceToken)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (expressions != null)
        {
            this.AdjustFlagsAndWidth(expressions);
            this.expressions = expressions;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    /// <summary>SyntaxToken representing the open brace.</summary>
    public SyntaxToken OpenBraceToken => this.openBraceToken;
    /// <summary>SeparatedSyntaxList of ExpressionSyntax representing the list of expressions in the initializer expression.</summary>
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<ExpressionSyntax> Expressions => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<ExpressionSyntax>(new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<CSharpSyntaxNode>(this.expressions));
    /// <summary>SyntaxToken representing the close brace.</summary>
    public SyntaxToken CloseBraceToken => this.closeBraceToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.openBraceToken;
            case 1: return this.expressions;
            case 2: return this.closeBraceToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.InitializerExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitInitializerExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitInitializerExpression(this);

    public InitializerExpressionSyntax Update(SyntaxToken openBraceToken, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<ExpressionSyntax> expressions, SyntaxToken closeBraceToken)
    {
        if (openBraceToken != this.OpenBraceToken || expressions != this.Expressions || closeBraceToken != this.CloseBraceToken)
        {
            var newNode = SyntaxFactory.InitializerExpression(this.Kind, openBraceToken, expressions, closeBraceToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new InitializerExpressionSyntax(this.Kind, this.openBraceToken, this.expressions, this.closeBraceToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new InitializerExpressionSyntax(this.Kind, this.openBraceToken, this.expressions, this.closeBraceToken, GetDiagnostics(), annotations);

    internal InitializerExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var openBraceToken = (SyntaxToken)reader.ReadValue();
      if (openBraceToken != null)
      {
         AdjustFlagsAndWidth(openBraceToken);
         this.openBraceToken = openBraceToken;
      }
      var expressions = (GreenNode)reader.ReadValue();
      if (expressions != null)
      {
         AdjustFlagsAndWidth(expressions);
         this.expressions = expressions;
      }
      var closeBraceToken = (SyntaxToken)reader.ReadValue();
      if (closeBraceToken != null)
      {
         AdjustFlagsAndWidth(closeBraceToken);
         this.closeBraceToken = closeBraceToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.openBraceToken);
      writer.WriteValue(this.expressions);
      writer.WriteValue(this.closeBraceToken);
    }

    static InitializerExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(InitializerExpressionSyntax), r => new InitializerExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for object creation expression.</summary>
  internal sealed partial class ObjectCreationExpressionSyntax : ExpressionSyntax
  {
    internal readonly SyntaxToken newKeyword;
    internal readonly TypeSyntax type;
    internal readonly ArgumentListSyntax argumentList;
    internal readonly InitializerExpressionSyntax initializer;

    internal ObjectCreationExpressionSyntax(SyntaxKind kind, SyntaxToken newKeyword, TypeSyntax type, ArgumentListSyntax argumentList, InitializerExpressionSyntax initializer, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (argumentList != null)
        {
            this.AdjustFlagsAndWidth(argumentList);
            this.argumentList = argumentList;
        }
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
    }


    internal ObjectCreationExpressionSyntax(SyntaxKind kind, SyntaxToken newKeyword, TypeSyntax type, ArgumentListSyntax argumentList, InitializerExpressionSyntax initializer, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (argumentList != null)
        {
            this.AdjustFlagsAndWidth(argumentList);
            this.argumentList = argumentList;
        }
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
    }


    internal ObjectCreationExpressionSyntax(SyntaxKind kind, SyntaxToken newKeyword, TypeSyntax type, ArgumentListSyntax argumentList, InitializerExpressionSyntax initializer)
        : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (argumentList != null)
        {
            this.AdjustFlagsAndWidth(argumentList);
            this.argumentList = argumentList;
        }
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
    }

    /// <summary>SyntaxToken representing the new keyword.</summary>
    public SyntaxToken NewKeyword => this.newKeyword;
    /// <summary>TypeSyntax representing the type of the object being created.</summary>
    public TypeSyntax Type => this.type;
    /// <summary>ArgumentListSyntax representing the list of arguments passed as part of the object creation expression.</summary>
    public ArgumentListSyntax ArgumentList => this.argumentList;
    /// <summary>InitializerExpressionSyntax representing the initializer expression for the object being created.</summary>
    public InitializerExpressionSyntax Initializer => this.initializer;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.newKeyword;
            case 1: return this.type;
            case 2: return this.argumentList;
            case 3: return this.initializer;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ObjectCreationExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitObjectCreationExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitObjectCreationExpression(this);

    public ObjectCreationExpressionSyntax Update(SyntaxToken newKeyword, TypeSyntax type, ArgumentListSyntax argumentList, InitializerExpressionSyntax initializer)
    {
        if (newKeyword != this.NewKeyword || type != this.Type || argumentList != this.ArgumentList || initializer != this.Initializer)
        {
            var newNode = SyntaxFactory.ObjectCreationExpression(newKeyword, type, argumentList, initializer);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ObjectCreationExpressionSyntax(this.Kind, this.newKeyword, this.type, this.argumentList, this.initializer, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ObjectCreationExpressionSyntax(this.Kind, this.newKeyword, this.type, this.argumentList, this.initializer, GetDiagnostics(), annotations);

    internal ObjectCreationExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var newKeyword = (SyntaxToken)reader.ReadValue();
      if (newKeyword != null)
      {
         AdjustFlagsAndWidth(newKeyword);
         this.newKeyword = newKeyword;
      }
      var type = (TypeSyntax)reader.ReadValue();
      if (type != null)
      {
         AdjustFlagsAndWidth(type);
         this.type = type;
      }
      var argumentList = (ArgumentListSyntax)reader.ReadValue();
      if (argumentList != null)
      {
         AdjustFlagsAndWidth(argumentList);
         this.argumentList = argumentList;
      }
      var initializer = (InitializerExpressionSyntax)reader.ReadValue();
      if (initializer != null)
      {
         AdjustFlagsAndWidth(initializer);
         this.initializer = initializer;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.newKeyword);
      writer.WriteValue(this.type);
      writer.WriteValue(this.argumentList);
      writer.WriteValue(this.initializer);
    }

    static ObjectCreationExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ObjectCreationExpressionSyntax), r => new ObjectCreationExpressionSyntax(r));
    }
  }

  internal sealed partial class AnonymousObjectMemberDeclaratorSyntax : CSharpSyntaxNode
  {
    internal readonly NameEqualsSyntax nameEquals;
    internal readonly ExpressionSyntax expression;

    internal AnonymousObjectMemberDeclaratorSyntax(SyntaxKind kind, NameEqualsSyntax nameEquals, ExpressionSyntax expression, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        if (nameEquals != null)
        {
            this.AdjustFlagsAndWidth(nameEquals);
            this.nameEquals = nameEquals;
        }
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }


    internal AnonymousObjectMemberDeclaratorSyntax(SyntaxKind kind, NameEqualsSyntax nameEquals, ExpressionSyntax expression, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        if (nameEquals != null)
        {
            this.AdjustFlagsAndWidth(nameEquals);
            this.nameEquals = nameEquals;
        }
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }


    internal AnonymousObjectMemberDeclaratorSyntax(SyntaxKind kind, NameEqualsSyntax nameEquals, ExpressionSyntax expression)
        : base(kind)
    {
        this.SlotCount = 2;
        if (nameEquals != null)
        {
            this.AdjustFlagsAndWidth(nameEquals);
            this.nameEquals = nameEquals;
        }
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    /// <summary>NameEqualsSyntax representing the optional name of the member being initialized.</summary>
    public NameEqualsSyntax NameEquals => this.nameEquals;
    /// <summary>ExpressionSyntax representing the value the member is initialized with.</summary>
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.nameEquals;
            case 1: return this.expression;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.AnonymousObjectMemberDeclaratorSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitAnonymousObjectMemberDeclarator(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitAnonymousObjectMemberDeclarator(this);

    public AnonymousObjectMemberDeclaratorSyntax Update(NameEqualsSyntax nameEquals, ExpressionSyntax expression)
    {
        if (nameEquals != this.NameEquals || expression != this.Expression)
        {
            var newNode = SyntaxFactory.AnonymousObjectMemberDeclarator(nameEquals, expression);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new AnonymousObjectMemberDeclaratorSyntax(this.Kind, this.nameEquals, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new AnonymousObjectMemberDeclaratorSyntax(this.Kind, this.nameEquals, this.expression, GetDiagnostics(), annotations);

    internal AnonymousObjectMemberDeclaratorSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var nameEquals = (NameEqualsSyntax)reader.ReadValue();
      if (nameEquals != null)
      {
         AdjustFlagsAndWidth(nameEquals);
         this.nameEquals = nameEquals;
      }
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.nameEquals);
      writer.WriteValue(this.expression);
    }

    static AnonymousObjectMemberDeclaratorSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(AnonymousObjectMemberDeclaratorSyntax), r => new AnonymousObjectMemberDeclaratorSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for anonymous object creation expression.</summary>
  internal sealed partial class AnonymousObjectCreationExpressionSyntax : ExpressionSyntax
  {
    internal readonly SyntaxToken newKeyword;
    internal readonly SyntaxToken openBraceToken;
    internal readonly GreenNode initializers;
    internal readonly SyntaxToken closeBraceToken;

    internal AnonymousObjectCreationExpressionSyntax(SyntaxKind kind, SyntaxToken newKeyword, SyntaxToken openBraceToken, GreenNode initializers, SyntaxToken closeBraceToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (initializers != null)
        {
            this.AdjustFlagsAndWidth(initializers);
            this.initializers = initializers;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }


    internal AnonymousObjectCreationExpressionSyntax(SyntaxKind kind, SyntaxToken newKeyword, SyntaxToken openBraceToken, GreenNode initializers, SyntaxToken closeBraceToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (initializers != null)
        {
            this.AdjustFlagsAndWidth(initializers);
            this.initializers = initializers;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }


    internal AnonymousObjectCreationExpressionSyntax(SyntaxKind kind, SyntaxToken newKeyword, SyntaxToken openBraceToken, GreenNode initializers, SyntaxToken closeBraceToken)
        : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (initializers != null)
        {
            this.AdjustFlagsAndWidth(initializers);
            this.initializers = initializers;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    /// <summary>SyntaxToken representing the new keyword.</summary>
    public SyntaxToken NewKeyword => this.newKeyword;
    /// <summary>SyntaxToken representing the open brace.</summary>
    public SyntaxToken OpenBraceToken => this.openBraceToken;
    /// <summary>SeparatedSyntaxList of AnonymousObjectMemberDeclaratorSyntax representing the list of object member initializers.</summary>
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<AnonymousObjectMemberDeclaratorSyntax> Initializers => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<AnonymousObjectMemberDeclaratorSyntax>(new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<CSharpSyntaxNode>(this.initializers));
    /// <summary>SyntaxToken representing the close brace.</summary>
    public SyntaxToken CloseBraceToken => this.closeBraceToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.newKeyword;
            case 1: return this.openBraceToken;
            case 2: return this.initializers;
            case 3: return this.closeBraceToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.AnonymousObjectCreationExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitAnonymousObjectCreationExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitAnonymousObjectCreationExpression(this);

    public AnonymousObjectCreationExpressionSyntax Update(SyntaxToken newKeyword, SyntaxToken openBraceToken, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<AnonymousObjectMemberDeclaratorSyntax> initializers, SyntaxToken closeBraceToken)
    {
        if (newKeyword != this.NewKeyword || openBraceToken != this.OpenBraceToken || initializers != this.Initializers || closeBraceToken != this.CloseBraceToken)
        {
            var newNode = SyntaxFactory.AnonymousObjectCreationExpression(newKeyword, openBraceToken, initializers, closeBraceToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new AnonymousObjectCreationExpressionSyntax(this.Kind, this.newKeyword, this.openBraceToken, this.initializers, this.closeBraceToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new AnonymousObjectCreationExpressionSyntax(this.Kind, this.newKeyword, this.openBraceToken, this.initializers, this.closeBraceToken, GetDiagnostics(), annotations);

    internal AnonymousObjectCreationExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var newKeyword = (SyntaxToken)reader.ReadValue();
      if (newKeyword != null)
      {
         AdjustFlagsAndWidth(newKeyword);
         this.newKeyword = newKeyword;
      }
      var openBraceToken = (SyntaxToken)reader.ReadValue();
      if (openBraceToken != null)
      {
         AdjustFlagsAndWidth(openBraceToken);
         this.openBraceToken = openBraceToken;
      }
      var initializers = (GreenNode)reader.ReadValue();
      if (initializers != null)
      {
         AdjustFlagsAndWidth(initializers);
         this.initializers = initializers;
      }
      var closeBraceToken = (SyntaxToken)reader.ReadValue();
      if (closeBraceToken != null)
      {
         AdjustFlagsAndWidth(closeBraceToken);
         this.closeBraceToken = closeBraceToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.newKeyword);
      writer.WriteValue(this.openBraceToken);
      writer.WriteValue(this.initializers);
      writer.WriteValue(this.closeBraceToken);
    }

    static AnonymousObjectCreationExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(AnonymousObjectCreationExpressionSyntax), r => new AnonymousObjectCreationExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for array creation expression.</summary>
  internal sealed partial class ArrayCreationExpressionSyntax : ExpressionSyntax
  {
    internal readonly SyntaxToken newKeyword;
    internal readonly ArrayTypeSyntax type;
    internal readonly InitializerExpressionSyntax initializer;

    internal ArrayCreationExpressionSyntax(SyntaxKind kind, SyntaxToken newKeyword, ArrayTypeSyntax type, InitializerExpressionSyntax initializer, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
    }


    internal ArrayCreationExpressionSyntax(SyntaxKind kind, SyntaxToken newKeyword, ArrayTypeSyntax type, InitializerExpressionSyntax initializer, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
    }


    internal ArrayCreationExpressionSyntax(SyntaxKind kind, SyntaxToken newKeyword, ArrayTypeSyntax type, InitializerExpressionSyntax initializer)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
    }

    /// <summary>SyntaxToken representing the new keyword.</summary>
    public SyntaxToken NewKeyword => this.newKeyword;
    /// <summary>ArrayTypeSyntax node representing the type of the array.</summary>
    public ArrayTypeSyntax Type => this.type;
    /// <summary>InitializerExpressionSyntax node representing the initializer of the array creation expression.</summary>
    public InitializerExpressionSyntax Initializer => this.initializer;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.newKeyword;
            case 1: return this.type;
            case 2: return this.initializer;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ArrayCreationExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitArrayCreationExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitArrayCreationExpression(this);

    public ArrayCreationExpressionSyntax Update(SyntaxToken newKeyword, ArrayTypeSyntax type, InitializerExpressionSyntax initializer)
    {
        if (newKeyword != this.NewKeyword || type != this.Type || initializer != this.Initializer)
        {
            var newNode = SyntaxFactory.ArrayCreationExpression(newKeyword, type, initializer);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ArrayCreationExpressionSyntax(this.Kind, this.newKeyword, this.type, this.initializer, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ArrayCreationExpressionSyntax(this.Kind, this.newKeyword, this.type, this.initializer, GetDiagnostics(), annotations);

    internal ArrayCreationExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var newKeyword = (SyntaxToken)reader.ReadValue();
      if (newKeyword != null)
      {
         AdjustFlagsAndWidth(newKeyword);
         this.newKeyword = newKeyword;
      }
      var type = (ArrayTypeSyntax)reader.ReadValue();
      if (type != null)
      {
         AdjustFlagsAndWidth(type);
         this.type = type;
      }
      var initializer = (InitializerExpressionSyntax)reader.ReadValue();
      if (initializer != null)
      {
         AdjustFlagsAndWidth(initializer);
         this.initializer = initializer;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.newKeyword);
      writer.WriteValue(this.type);
      writer.WriteValue(this.initializer);
    }

    static ArrayCreationExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ArrayCreationExpressionSyntax), r => new ArrayCreationExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for implicit array creation expression.</summary>
  internal sealed partial class ImplicitArrayCreationExpressionSyntax : ExpressionSyntax
  {
    internal readonly SyntaxToken newKeyword;
    internal readonly SyntaxToken openBracketToken;
    internal readonly GreenNode commas;
    internal readonly SyntaxToken closeBracketToken;
    internal readonly InitializerExpressionSyntax initializer;

    internal ImplicitArrayCreationExpressionSyntax(SyntaxKind kind, SyntaxToken newKeyword, SyntaxToken openBracketToken, GreenNode commas, SyntaxToken closeBracketToken, InitializerExpressionSyntax initializer, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (commas != null)
        {
            this.AdjustFlagsAndWidth(commas);
            this.commas = commas;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
        this.AdjustFlagsAndWidth(initializer);
        this.initializer = initializer;
    }


    internal ImplicitArrayCreationExpressionSyntax(SyntaxKind kind, SyntaxToken newKeyword, SyntaxToken openBracketToken, GreenNode commas, SyntaxToken closeBracketToken, InitializerExpressionSyntax initializer, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (commas != null)
        {
            this.AdjustFlagsAndWidth(commas);
            this.commas = commas;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
        this.AdjustFlagsAndWidth(initializer);
        this.initializer = initializer;
    }


    internal ImplicitArrayCreationExpressionSyntax(SyntaxKind kind, SyntaxToken newKeyword, SyntaxToken openBracketToken, GreenNode commas, SyntaxToken closeBracketToken, InitializerExpressionSyntax initializer)
        : base(kind)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (commas != null)
        {
            this.AdjustFlagsAndWidth(commas);
            this.commas = commas;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
        this.AdjustFlagsAndWidth(initializer);
        this.initializer = initializer;
    }

    /// <summary>SyntaxToken representing the new keyword.</summary>
    public SyntaxToken NewKeyword => this.newKeyword;
    /// <summary>SyntaxToken representing the open bracket.</summary>
    public SyntaxToken OpenBracketToken => this.openBracketToken;
    /// <summary>SyntaxList of SyntaxToken representing the commas in the implicit array creation expression.</summary>
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> Commas => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken>(this.commas);
    /// <summary>SyntaxToken representing the close bracket.</summary>
    public SyntaxToken CloseBracketToken => this.closeBracketToken;
    /// <summary>InitializerExpressionSyntax representing the initializer expression of the implicit array creation expression.</summary>
    public InitializerExpressionSyntax Initializer => this.initializer;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.newKeyword;
            case 1: return this.openBracketToken;
            case 2: return this.commas;
            case 3: return this.closeBracketToken;
            case 4: return this.initializer;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ImplicitArrayCreationExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitImplicitArrayCreationExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitImplicitArrayCreationExpression(this);

    public ImplicitArrayCreationExpressionSyntax Update(SyntaxToken newKeyword, SyntaxToken openBracketToken, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> commas, SyntaxToken closeBracketToken, InitializerExpressionSyntax initializer)
    {
        if (newKeyword != this.NewKeyword || openBracketToken != this.OpenBracketToken || commas != this.Commas || closeBracketToken != this.CloseBracketToken || initializer != this.Initializer)
        {
            var newNode = SyntaxFactory.ImplicitArrayCreationExpression(newKeyword, openBracketToken, commas, closeBracketToken, initializer);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ImplicitArrayCreationExpressionSyntax(this.Kind, this.newKeyword, this.openBracketToken, this.commas, this.closeBracketToken, this.initializer, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ImplicitArrayCreationExpressionSyntax(this.Kind, this.newKeyword, this.openBracketToken, this.commas, this.closeBracketToken, this.initializer, GetDiagnostics(), annotations);

    internal ImplicitArrayCreationExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 5;
      var newKeyword = (SyntaxToken)reader.ReadValue();
      if (newKeyword != null)
      {
         AdjustFlagsAndWidth(newKeyword);
         this.newKeyword = newKeyword;
      }
      var openBracketToken = (SyntaxToken)reader.ReadValue();
      if (openBracketToken != null)
      {
         AdjustFlagsAndWidth(openBracketToken);
         this.openBracketToken = openBracketToken;
      }
      var commas = (GreenNode)reader.ReadValue();
      if (commas != null)
      {
         AdjustFlagsAndWidth(commas);
         this.commas = commas;
      }
      var closeBracketToken = (SyntaxToken)reader.ReadValue();
      if (closeBracketToken != null)
      {
         AdjustFlagsAndWidth(closeBracketToken);
         this.closeBracketToken = closeBracketToken;
      }
      var initializer = (InitializerExpressionSyntax)reader.ReadValue();
      if (initializer != null)
      {
         AdjustFlagsAndWidth(initializer);
         this.initializer = initializer;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.newKeyword);
      writer.WriteValue(this.openBracketToken);
      writer.WriteValue(this.commas);
      writer.WriteValue(this.closeBracketToken);
      writer.WriteValue(this.initializer);
    }

    static ImplicitArrayCreationExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ImplicitArrayCreationExpressionSyntax), r => new ImplicitArrayCreationExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for stackalloc array creation expression.</summary>
  internal sealed partial class StackAllocArrayCreationExpressionSyntax : ExpressionSyntax
  {
    internal readonly SyntaxToken stackAllocKeyword;
    internal readonly TypeSyntax type;
    internal readonly InitializerExpressionSyntax initializer;

    internal StackAllocArrayCreationExpressionSyntax(SyntaxKind kind, SyntaxToken stackAllocKeyword, TypeSyntax type, InitializerExpressionSyntax initializer, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(stackAllocKeyword);
        this.stackAllocKeyword = stackAllocKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
    }


    internal StackAllocArrayCreationExpressionSyntax(SyntaxKind kind, SyntaxToken stackAllocKeyword, TypeSyntax type, InitializerExpressionSyntax initializer, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(stackAllocKeyword);
        this.stackAllocKeyword = stackAllocKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
    }


    internal StackAllocArrayCreationExpressionSyntax(SyntaxKind kind, SyntaxToken stackAllocKeyword, TypeSyntax type, InitializerExpressionSyntax initializer)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(stackAllocKeyword);
        this.stackAllocKeyword = stackAllocKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
    }

    /// <summary>SyntaxToken representing the stackalloc keyword.</summary>
    public SyntaxToken StackAllocKeyword => this.stackAllocKeyword;
    /// <summary>TypeSyntax node representing the type of the stackalloc array.</summary>
    public TypeSyntax Type => this.type;
    /// <summary>InitializerExpressionSyntax node representing the initializer of the stackalloc array creation expression.</summary>
    public InitializerExpressionSyntax Initializer => this.initializer;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.stackAllocKeyword;
            case 1: return this.type;
            case 2: return this.initializer;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.StackAllocArrayCreationExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitStackAllocArrayCreationExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitStackAllocArrayCreationExpression(this);

    public StackAllocArrayCreationExpressionSyntax Update(SyntaxToken stackAllocKeyword, TypeSyntax type, InitializerExpressionSyntax initializer)
    {
        if (stackAllocKeyword != this.StackAllocKeyword || type != this.Type || initializer != this.Initializer)
        {
            var newNode = SyntaxFactory.StackAllocArrayCreationExpression(stackAllocKeyword, type, initializer);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new StackAllocArrayCreationExpressionSyntax(this.Kind, this.stackAllocKeyword, this.type, this.initializer, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new StackAllocArrayCreationExpressionSyntax(this.Kind, this.stackAllocKeyword, this.type, this.initializer, GetDiagnostics(), annotations);

    internal StackAllocArrayCreationExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var stackAllocKeyword = (SyntaxToken)reader.ReadValue();
      if (stackAllocKeyword != null)
      {
         AdjustFlagsAndWidth(stackAllocKeyword);
         this.stackAllocKeyword = stackAllocKeyword;
      }
      var type = (TypeSyntax)reader.ReadValue();
      if (type != null)
      {
         AdjustFlagsAndWidth(type);
         this.type = type;
      }
      var initializer = (InitializerExpressionSyntax)reader.ReadValue();
      if (initializer != null)
      {
         AdjustFlagsAndWidth(initializer);
         this.initializer = initializer;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.stackAllocKeyword);
      writer.WriteValue(this.type);
      writer.WriteValue(this.initializer);
    }

    static StackAllocArrayCreationExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(StackAllocArrayCreationExpressionSyntax), r => new StackAllocArrayCreationExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents the syntax node for implicit stackalloc array creation expression.</summary>
  internal sealed partial class ImplicitStackAllocArrayCreationExpressionSyntax : ExpressionSyntax
  {
    internal readonly SyntaxToken stackAllocKeyword;
    internal readonly SyntaxToken openBracketToken;
    internal readonly SyntaxToken closeBracketToken;
    internal readonly InitializerExpressionSyntax initializer;

    internal ImplicitStackAllocArrayCreationExpressionSyntax(SyntaxKind kind, SyntaxToken stackAllocKeyword, SyntaxToken openBracketToken, SyntaxToken closeBracketToken, InitializerExpressionSyntax initializer, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(stackAllocKeyword);
        this.stackAllocKeyword = stackAllocKeyword;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
        this.AdjustFlagsAndWidth(initializer);
        this.initializer = initializer;
    }


    internal ImplicitStackAllocArrayCreationExpressionSyntax(SyntaxKind kind, SyntaxToken stackAllocKeyword, SyntaxToken openBracketToken, SyntaxToken closeBracketToken, InitializerExpressionSyntax initializer, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(stackAllocKeyword);
        this.stackAllocKeyword = stackAllocKeyword;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
        this.AdjustFlagsAndWidth(initializer);
        this.initializer = initializer;
    }


    internal ImplicitStackAllocArrayCreationExpressionSyntax(SyntaxKind kind, SyntaxToken stackAllocKeyword, SyntaxToken openBracketToken, SyntaxToken closeBracketToken, InitializerExpressionSyntax initializer)
        : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(stackAllocKeyword);
        this.stackAllocKeyword = stackAllocKeyword;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
        this.AdjustFlagsAndWidth(initializer);
        this.initializer = initializer;
    }

    /// <summary>SyntaxToken representing the stackalloc keyword.</summary>
    public SyntaxToken StackAllocKeyword => this.stackAllocKeyword;
    /// <summary>SyntaxToken representing the open bracket.</summary>
    public SyntaxToken OpenBracketToken => this.openBracketToken;
    /// <summary>SyntaxToken representing the close bracket.</summary>
    public SyntaxToken CloseBracketToken => this.closeBracketToken;
    /// <summary>InitializerExpressionSyntax representing the initializer expression of the implicit stackalloc array creation expression.</summary>
    public InitializerExpressionSyntax Initializer => this.initializer;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.stackAllocKeyword;
            case 1: return this.openBracketToken;
            case 2: return this.closeBracketToken;
            case 3: return this.initializer;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ImplicitStackAllocArrayCreationExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitImplicitStackAllocArrayCreationExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitImplicitStackAllocArrayCreationExpression(this);

    public ImplicitStackAllocArrayCreationExpressionSyntax Update(SyntaxToken stackAllocKeyword, SyntaxToken openBracketToken, SyntaxToken closeBracketToken, InitializerExpressionSyntax initializer)
    {
        if (stackAllocKeyword != this.StackAllocKeyword || openBracketToken != this.OpenBracketToken || closeBracketToken != this.CloseBracketToken || initializer != this.Initializer)
        {
            var newNode = SyntaxFactory.ImplicitStackAllocArrayCreationExpression(stackAllocKeyword, openBracketToken, closeBracketToken, initializer);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ImplicitStackAllocArrayCreationExpressionSyntax(this.Kind, this.stackAllocKeyword, this.openBracketToken, this.closeBracketToken, this.initializer, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ImplicitStackAllocArrayCreationExpressionSyntax(this.Kind, this.stackAllocKeyword, this.openBracketToken, this.closeBracketToken, this.initializer, GetDiagnostics(), annotations);

    internal ImplicitStackAllocArrayCreationExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var stackAllocKeyword = (SyntaxToken)reader.ReadValue();
      if (stackAllocKeyword != null)
      {
         AdjustFlagsAndWidth(stackAllocKeyword);
         this.stackAllocKeyword = stackAllocKeyword;
      }
      var openBracketToken = (SyntaxToken)reader.ReadValue();
      if (openBracketToken != null)
      {
         AdjustFlagsAndWidth(openBracketToken);
         this.openBracketToken = openBracketToken;
      }
      var closeBracketToken = (SyntaxToken)reader.ReadValue();
      if (closeBracketToken != null)
      {
         AdjustFlagsAndWidth(closeBracketToken);
         this.closeBracketToken = closeBracketToken;
      }
      var initializer = (InitializerExpressionSyntax)reader.ReadValue();
      if (initializer != null)
      {
         AdjustFlagsAndWidth(initializer);
         this.initializer = initializer;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.stackAllocKeyword);
      writer.WriteValue(this.openBracketToken);
      writer.WriteValue(this.closeBracketToken);
      writer.WriteValue(this.initializer);
    }

    static ImplicitStackAllocArrayCreationExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ImplicitStackAllocArrayCreationExpressionSyntax), r => new ImplicitStackAllocArrayCreationExpressionSyntax(r));
    }
  }

  internal abstract partial class QueryClauseSyntax : CSharpSyntaxNode
  {
    internal QueryClauseSyntax(SyntaxKind kind, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal QueryClauseSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    protected QueryClauseSyntax(ObjectReader reader)
       : base(reader)
    {
    }
  }

  internal abstract partial class SelectOrGroupClauseSyntax : CSharpSyntaxNode
  {
    internal SelectOrGroupClauseSyntax(SyntaxKind kind, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal SelectOrGroupClauseSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    protected SelectOrGroupClauseSyntax(ObjectReader reader)
       : base(reader)
    {
    }
  }

  internal sealed partial class QueryExpressionSyntax : ExpressionSyntax
  {
    internal readonly FromClauseSyntax fromClause;
    internal readonly QueryBodySyntax body;

    internal QueryExpressionSyntax(SyntaxKind kind, FromClauseSyntax fromClause, QueryBodySyntax body, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(fromClause);
        this.fromClause = fromClause;
        this.AdjustFlagsAndWidth(body);
        this.body = body;
    }


    internal QueryExpressionSyntax(SyntaxKind kind, FromClauseSyntax fromClause, QueryBodySyntax body, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(fromClause);
        this.fromClause = fromClause;
        this.AdjustFlagsAndWidth(body);
        this.body = body;
    }


    internal QueryExpressionSyntax(SyntaxKind kind, FromClauseSyntax fromClause, QueryBodySyntax body)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(fromClause);
        this.fromClause = fromClause;
        this.AdjustFlagsAndWidth(body);
        this.body = body;
    }

    public FromClauseSyntax FromClause => this.fromClause;
    public QueryBodySyntax Body => this.body;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.fromClause;
            case 1: return this.body;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.QueryExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitQueryExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitQueryExpression(this);

    public QueryExpressionSyntax Update(FromClauseSyntax fromClause, QueryBodySyntax body)
    {
        if (fromClause != this.FromClause || body != this.Body)
        {
            var newNode = SyntaxFactory.QueryExpression(fromClause, body);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new QueryExpressionSyntax(this.Kind, this.fromClause, this.body, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new QueryExpressionSyntax(this.Kind, this.fromClause, this.body, GetDiagnostics(), annotations);

    internal QueryExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var fromClause = (FromClauseSyntax)reader.ReadValue();
      if (fromClause != null)
      {
         AdjustFlagsAndWidth(fromClause);
         this.fromClause = fromClause;
      }
      var body = (QueryBodySyntax)reader.ReadValue();
      if (body != null)
      {
         AdjustFlagsAndWidth(body);
         this.body = body;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.fromClause);
      writer.WriteValue(this.body);
    }

    static QueryExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(QueryExpressionSyntax), r => new QueryExpressionSyntax(r));
    }
  }

  internal sealed partial class QueryBodySyntax : CSharpSyntaxNode
  {
    internal readonly GreenNode clauses;
    internal readonly SelectOrGroupClauseSyntax selectOrGroup;
    internal readonly QueryContinuationSyntax continuation;

    internal QueryBodySyntax(SyntaxKind kind, GreenNode clauses, SelectOrGroupClauseSyntax selectOrGroup, QueryContinuationSyntax continuation, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        if (clauses != null)
        {
            this.AdjustFlagsAndWidth(clauses);
            this.clauses = clauses;
        }
        this.AdjustFlagsAndWidth(selectOrGroup);
        this.selectOrGroup = selectOrGroup;
        if (continuation != null)
        {
            this.AdjustFlagsAndWidth(continuation);
            this.continuation = continuation;
        }
    }


    internal QueryBodySyntax(SyntaxKind kind, GreenNode clauses, SelectOrGroupClauseSyntax selectOrGroup, QueryContinuationSyntax continuation, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        if (clauses != null)
        {
            this.AdjustFlagsAndWidth(clauses);
            this.clauses = clauses;
        }
        this.AdjustFlagsAndWidth(selectOrGroup);
        this.selectOrGroup = selectOrGroup;
        if (continuation != null)
        {
            this.AdjustFlagsAndWidth(continuation);
            this.continuation = continuation;
        }
    }


    internal QueryBodySyntax(SyntaxKind kind, GreenNode clauses, SelectOrGroupClauseSyntax selectOrGroup, QueryContinuationSyntax continuation)
        : base(kind)
    {
        this.SlotCount = 3;
        if (clauses != null)
        {
            this.AdjustFlagsAndWidth(clauses);
            this.clauses = clauses;
        }
        this.AdjustFlagsAndWidth(selectOrGroup);
        this.selectOrGroup = selectOrGroup;
        if (continuation != null)
        {
            this.AdjustFlagsAndWidth(continuation);
            this.continuation = continuation;
        }
    }

    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<QueryClauseSyntax> Clauses => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<QueryClauseSyntax>(this.clauses);
    public SelectOrGroupClauseSyntax SelectOrGroup => this.selectOrGroup;
    public QueryContinuationSyntax Continuation => this.continuation;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.clauses;
            case 1: return this.selectOrGroup;
            case 2: return this.continuation;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.QueryBodySyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitQueryBody(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitQueryBody(this);

    public QueryBodySyntax Update(Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<QueryClauseSyntax> clauses, SelectOrGroupClauseSyntax selectOrGroup, QueryContinuationSyntax continuation)
    {
        if (clauses != this.Clauses || selectOrGroup != this.SelectOrGroup || continuation != this.Continuation)
        {
            var newNode = SyntaxFactory.QueryBody(clauses, selectOrGroup, continuation);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new QueryBodySyntax(this.Kind, this.clauses, this.selectOrGroup, this.continuation, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new QueryBodySyntax(this.Kind, this.clauses, this.selectOrGroup, this.continuation, GetDiagnostics(), annotations);

    internal QueryBodySyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var clauses = (GreenNode)reader.ReadValue();
      if (clauses != null)
      {
         AdjustFlagsAndWidth(clauses);
         this.clauses = clauses;
      }
      var selectOrGroup = (SelectOrGroupClauseSyntax)reader.ReadValue();
      if (selectOrGroup != null)
      {
         AdjustFlagsAndWidth(selectOrGroup);
         this.selectOrGroup = selectOrGroup;
      }
      var continuation = (QueryContinuationSyntax)reader.ReadValue();
      if (continuation != null)
      {
         AdjustFlagsAndWidth(continuation);
         this.continuation = continuation;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.clauses);
      writer.WriteValue(this.selectOrGroup);
      writer.WriteValue(this.continuation);
    }

    static QueryBodySyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(QueryBodySyntax), r => new QueryBodySyntax(r));
    }
  }

  internal sealed partial class FromClauseSyntax : QueryClauseSyntax
  {
    internal readonly SyntaxToken fromKeyword;
    internal readonly TypeSyntax type;
    internal readonly SyntaxToken identifier;
    internal readonly SyntaxToken inKeyword;
    internal readonly ExpressionSyntax expression;

    internal FromClauseSyntax(SyntaxKind kind, SyntaxToken fromKeyword, TypeSyntax type, SyntaxToken identifier, SyntaxToken inKeyword, ExpressionSyntax expression, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(fromKeyword);
        this.fromKeyword = fromKeyword;
        if (type != null)
        {
            this.AdjustFlagsAndWidth(type);
            this.type = type;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(inKeyword);
        this.inKeyword = inKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }


    internal FromClauseSyntax(SyntaxKind kind, SyntaxToken fromKeyword, TypeSyntax type, SyntaxToken identifier, SyntaxToken inKeyword, ExpressionSyntax expression, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(fromKeyword);
        this.fromKeyword = fromKeyword;
        if (type != null)
        {
            this.AdjustFlagsAndWidth(type);
            this.type = type;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(inKeyword);
        this.inKeyword = inKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }


    internal FromClauseSyntax(SyntaxKind kind, SyntaxToken fromKeyword, TypeSyntax type, SyntaxToken identifier, SyntaxToken inKeyword, ExpressionSyntax expression)
        : base(kind)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(fromKeyword);
        this.fromKeyword = fromKeyword;
        if (type != null)
        {
            this.AdjustFlagsAndWidth(type);
            this.type = type;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(inKeyword);
        this.inKeyword = inKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    public SyntaxToken FromKeyword => this.fromKeyword;
    public TypeSyntax Type => this.type;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public SyntaxToken InKeyword => this.inKeyword;
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.fromKeyword;
            case 1: return this.type;
            case 2: return this.identifier;
            case 3: return this.inKeyword;
            case 4: return this.expression;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.FromClauseSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitFromClause(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitFromClause(this);

    public FromClauseSyntax Update(SyntaxToken fromKeyword, TypeSyntax type, SyntaxToken identifier, SyntaxToken inKeyword, ExpressionSyntax expression)
    {
        if (fromKeyword != this.FromKeyword || type != this.Type || identifier != this.Identifier || inKeyword != this.InKeyword || expression != this.Expression)
        {
            var newNode = SyntaxFactory.FromClause(fromKeyword, type, identifier, inKeyword, expression);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new FromClauseSyntax(this.Kind, this.fromKeyword, this.type, this.identifier, this.inKeyword, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new FromClauseSyntax(this.Kind, this.fromKeyword, this.type, this.identifier, this.inKeyword, this.expression, GetDiagnostics(), annotations);

    internal FromClauseSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 5;
      var fromKeyword = (SyntaxToken)reader.ReadValue();
      if (fromKeyword != null)
      {
         AdjustFlagsAndWidth(fromKeyword);
         this.fromKeyword = fromKeyword;
      }
      var type = (TypeSyntax)reader.ReadValue();
      if (type != null)
      {
         AdjustFlagsAndWidth(type);
         this.type = type;
      }
      var identifier = (SyntaxToken)reader.ReadValue();
      if (identifier != null)
      {
         AdjustFlagsAndWidth(identifier);
         this.identifier = identifier;
      }
      var inKeyword = (SyntaxToken)reader.ReadValue();
      if (inKeyword != null)
      {
         AdjustFlagsAndWidth(inKeyword);
         this.inKeyword = inKeyword;
      }
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.fromKeyword);
      writer.WriteValue(this.type);
      writer.WriteValue(this.identifier);
      writer.WriteValue(this.inKeyword);
      writer.WriteValue(this.expression);
    }

    static FromClauseSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(FromClauseSyntax), r => new FromClauseSyntax(r));
    }
  }

  internal sealed partial class LetClauseSyntax : QueryClauseSyntax
  {
    internal readonly SyntaxToken letKeyword;
    internal readonly SyntaxToken identifier;
    internal readonly SyntaxToken equalsToken;
    internal readonly ExpressionSyntax expression;

    internal LetClauseSyntax(SyntaxKind kind, SyntaxToken letKeyword, SyntaxToken identifier, SyntaxToken equalsToken, ExpressionSyntax expression, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(letKeyword);
        this.letKeyword = letKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(equalsToken);
        this.equalsToken = equalsToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }


    internal LetClauseSyntax(SyntaxKind kind, SyntaxToken letKeyword, SyntaxToken identifier, SyntaxToken equalsToken, ExpressionSyntax expression, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(letKeyword);
        this.letKeyword = letKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(equalsToken);
        this.equalsToken = equalsToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }


    internal LetClauseSyntax(SyntaxKind kind, SyntaxToken letKeyword, SyntaxToken identifier, SyntaxToken equalsToken, ExpressionSyntax expression)
        : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(letKeyword);
        this.letKeyword = letKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(equalsToken);
        this.equalsToken = equalsToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    public SyntaxToken LetKeyword => this.letKeyword;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public SyntaxToken EqualsToken => this.equalsToken;
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.letKeyword;
            case 1: return this.identifier;
            case 2: return this.equalsToken;
            case 3: return this.expression;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.LetClauseSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitLetClause(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitLetClause(this);

    public LetClauseSyntax Update(SyntaxToken letKeyword, SyntaxToken identifier, SyntaxToken equalsToken, ExpressionSyntax expression)
    {
        if (letKeyword != this.LetKeyword || identifier != this.Identifier || equalsToken != this.EqualsToken || expression != this.Expression)
        {
            var newNode = SyntaxFactory.LetClause(letKeyword, identifier, equalsToken, expression);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new LetClauseSyntax(this.Kind, this.letKeyword, this.identifier, this.equalsToken, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new LetClauseSyntax(this.Kind, this.letKeyword, this.identifier, this.equalsToken, this.expression, GetDiagnostics(), annotations);

    internal LetClauseSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var letKeyword = (SyntaxToken)reader.ReadValue();
      if (letKeyword != null)
      {
         AdjustFlagsAndWidth(letKeyword);
         this.letKeyword = letKeyword;
      }
      var identifier = (SyntaxToken)reader.ReadValue();
      if (identifier != null)
      {
         AdjustFlagsAndWidth(identifier);
         this.identifier = identifier;
      }
      var equalsToken = (SyntaxToken)reader.ReadValue();
      if (equalsToken != null)
      {
         AdjustFlagsAndWidth(equalsToken);
         this.equalsToken = equalsToken;
      }
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.letKeyword);
      writer.WriteValue(this.identifier);
      writer.WriteValue(this.equalsToken);
      writer.WriteValue(this.expression);
    }

    static LetClauseSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(LetClauseSyntax), r => new LetClauseSyntax(r));
    }
  }

  internal sealed partial class JoinClauseSyntax : QueryClauseSyntax
  {
    internal readonly SyntaxToken joinKeyword;
    internal readonly TypeSyntax type;
    internal readonly SyntaxToken identifier;
    internal readonly SyntaxToken inKeyword;
    internal readonly ExpressionSyntax inExpression;
    internal readonly SyntaxToken onKeyword;
    internal readonly ExpressionSyntax leftExpression;
    internal readonly SyntaxToken equalsKeyword;
    internal readonly ExpressionSyntax rightExpression;
    internal readonly JoinIntoClauseSyntax into;

    internal JoinClauseSyntax(SyntaxKind kind, SyntaxToken joinKeyword, TypeSyntax type, SyntaxToken identifier, SyntaxToken inKeyword, ExpressionSyntax inExpression, SyntaxToken onKeyword, ExpressionSyntax leftExpression, SyntaxToken equalsKeyword, ExpressionSyntax rightExpression, JoinIntoClauseSyntax into, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 10;
        this.AdjustFlagsAndWidth(joinKeyword);
        this.joinKeyword = joinKeyword;
        if (type != null)
        {
            this.AdjustFlagsAndWidth(type);
            this.type = type;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(inKeyword);
        this.inKeyword = inKeyword;
        this.AdjustFlagsAndWidth(inExpression);
        this.inExpression = inExpression;
        this.AdjustFlagsAndWidth(onKeyword);
        this.onKeyword = onKeyword;
        this.AdjustFlagsAndWidth(leftExpression);
        this.leftExpression = leftExpression;
        this.AdjustFlagsAndWidth(equalsKeyword);
        this.equalsKeyword = equalsKeyword;
        this.AdjustFlagsAndWidth(rightExpression);
        this.rightExpression = rightExpression;
        if (into != null)
        {
            this.AdjustFlagsAndWidth(into);
            this.into = into;
        }
    }


    internal JoinClauseSyntax(SyntaxKind kind, SyntaxToken joinKeyword, TypeSyntax type, SyntaxToken identifier, SyntaxToken inKeyword, ExpressionSyntax inExpression, SyntaxToken onKeyword, ExpressionSyntax leftExpression, SyntaxToken equalsKeyword, ExpressionSyntax rightExpression, JoinIntoClauseSyntax into, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 10;
        this.AdjustFlagsAndWidth(joinKeyword);
        this.joinKeyword = joinKeyword;
        if (type != null)
        {
            this.AdjustFlagsAndWidth(type);
            this.type = type;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(inKeyword);
        this.inKeyword = inKeyword;
        this.AdjustFlagsAndWidth(inExpression);
        this.inExpression = inExpression;
        this.AdjustFlagsAndWidth(onKeyword);
        this.onKeyword = onKeyword;
        this.AdjustFlagsAndWidth(leftExpression);
        this.leftExpression = leftExpression;
        this.AdjustFlagsAndWidth(equalsKeyword);
        this.equalsKeyword = equalsKeyword;
        this.AdjustFlagsAndWidth(rightExpression);
        this.rightExpression = rightExpression;
        if (into != null)
        {
            this.AdjustFlagsAndWidth(into);
            this.into = into;
        }
    }


    internal JoinClauseSyntax(SyntaxKind kind, SyntaxToken joinKeyword, TypeSyntax type, SyntaxToken identifier, SyntaxToken inKeyword, ExpressionSyntax inExpression, SyntaxToken onKeyword, ExpressionSyntax leftExpression, SyntaxToken equalsKeyword, ExpressionSyntax rightExpression, JoinIntoClauseSyntax into)
        : base(kind)
    {
        this.SlotCount = 10;
        this.AdjustFlagsAndWidth(joinKeyword);
        this.joinKeyword = joinKeyword;
        if (type != null)
        {
            this.AdjustFlagsAndWidth(type);
            this.type = type;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(inKeyword);
        this.inKeyword = inKeyword;
        this.AdjustFlagsAndWidth(inExpression);
        this.inExpression = inExpression;
        this.AdjustFlagsAndWidth(onKeyword);
        this.onKeyword = onKeyword;
        this.AdjustFlagsAndWidth(leftExpression);
        this.leftExpression = leftExpression;
        this.AdjustFlagsAndWidth(equalsKeyword);
        this.equalsKeyword = equalsKeyword;
        this.AdjustFlagsAndWidth(rightExpression);
        this.rightExpression = rightExpression;
        if (into != null)
        {
            this.AdjustFlagsAndWidth(into);
            this.into = into;
        }
    }

    public SyntaxToken JoinKeyword => this.joinKeyword;
    public TypeSyntax Type => this.type;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public SyntaxToken InKeyword => this.inKeyword;
    public ExpressionSyntax InExpression => this.inExpression;
    public SyntaxToken OnKeyword => this.onKeyword;
    public ExpressionSyntax LeftExpression => this.leftExpression;
    public SyntaxToken EqualsKeyword => this.equalsKeyword;
    public ExpressionSyntax RightExpression => this.rightExpression;
    public JoinIntoClauseSyntax Into => this.into;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.joinKeyword;
            case 1: return this.type;
            case 2: return this.identifier;
            case 3: return this.inKeyword;
            case 4: return this.inExpression;
            case 5: return this.onKeyword;
            case 6: return this.leftExpression;
            case 7: return this.equalsKeyword;
            case 8: return this.rightExpression;
            case 9: return this.into;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.JoinClauseSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitJoinClause(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitJoinClause(this);

    public JoinClauseSyntax Update(SyntaxToken joinKeyword, TypeSyntax type, SyntaxToken identifier, SyntaxToken inKeyword, ExpressionSyntax inExpression, SyntaxToken onKeyword, ExpressionSyntax leftExpression, SyntaxToken equalsKeyword, ExpressionSyntax rightExpression, JoinIntoClauseSyntax into)
    {
        if (joinKeyword != this.JoinKeyword || type != this.Type || identifier != this.Identifier || inKeyword != this.InKeyword || inExpression != this.InExpression || onKeyword != this.OnKeyword || leftExpression != this.LeftExpression || equalsKeyword != this.EqualsKeyword || rightExpression != this.RightExpression || into != this.Into)
        {
            var newNode = SyntaxFactory.JoinClause(joinKeyword, type, identifier, inKeyword, inExpression, onKeyword, leftExpression, equalsKeyword, rightExpression, into);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new JoinClauseSyntax(this.Kind, this.joinKeyword, this.type, this.identifier, this.inKeyword, this.inExpression, this.onKeyword, this.leftExpression, this.equalsKeyword, this.rightExpression, this.into, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new JoinClauseSyntax(this.Kind, this.joinKeyword, this.type, this.identifier, this.inKeyword, this.inExpression, this.onKeyword, this.leftExpression, this.equalsKeyword, this.rightExpression, this.into, GetDiagnostics(), annotations);

    internal JoinClauseSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 10;
      var joinKeyword = (SyntaxToken)reader.ReadValue();
      if (joinKeyword != null)
      {
         AdjustFlagsAndWidth(joinKeyword);
         this.joinKeyword = joinKeyword;
      }
      var type = (TypeSyntax)reader.ReadValue();
      if (type != null)
      {
         AdjustFlagsAndWidth(type);
         this.type = type;
      }
      var identifier = (SyntaxToken)reader.ReadValue();
      if (identifier != null)
      {
         AdjustFlagsAndWidth(identifier);
         this.identifier = identifier;
      }
      var inKeyword = (SyntaxToken)reader.ReadValue();
      if (inKeyword != null)
      {
         AdjustFlagsAndWidth(inKeyword);
         this.inKeyword = inKeyword;
      }
      var inExpression = (ExpressionSyntax)reader.ReadValue();
      if (inExpression != null)
      {
         AdjustFlagsAndWidth(inExpression);
         this.inExpression = inExpression;
      }
      var onKeyword = (SyntaxToken)reader.ReadValue();
      if (onKeyword != null)
      {
         AdjustFlagsAndWidth(onKeyword);
         this.onKeyword = onKeyword;
      }
      var leftExpression = (ExpressionSyntax)reader.ReadValue();
      if (leftExpression != null)
      {
         AdjustFlagsAndWidth(leftExpression);
         this.leftExpression = leftExpression;
      }
      var equalsKeyword = (SyntaxToken)reader.ReadValue();
      if (equalsKeyword != null)
      {
         AdjustFlagsAndWidth(equalsKeyword);
         this.equalsKeyword = equalsKeyword;
      }
      var rightExpression = (ExpressionSyntax)reader.ReadValue();
      if (rightExpression != null)
      {
         AdjustFlagsAndWidth(rightExpression);
         this.rightExpression = rightExpression;
      }
      var into = (JoinIntoClauseSyntax)reader.ReadValue();
      if (into != null)
      {
         AdjustFlagsAndWidth(into);
         this.into = into;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.joinKeyword);
      writer.WriteValue(this.type);
      writer.WriteValue(this.identifier);
      writer.WriteValue(this.inKeyword);
      writer.WriteValue(this.inExpression);
      writer.WriteValue(this.onKeyword);
      writer.WriteValue(this.leftExpression);
      writer.WriteValue(this.equalsKeyword);
      writer.WriteValue(this.rightExpression);
      writer.WriteValue(this.into);
    }

    static JoinClauseSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(JoinClauseSyntax), r => new JoinClauseSyntax(r));
    }
  }

  internal sealed partial class JoinIntoClauseSyntax : CSharpSyntaxNode
  {
    internal readonly SyntaxToken intoKeyword;
    internal readonly SyntaxToken identifier;

    internal JoinIntoClauseSyntax(SyntaxKind kind, SyntaxToken intoKeyword, SyntaxToken identifier, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(intoKeyword);
        this.intoKeyword = intoKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
    }


    internal JoinIntoClauseSyntax(SyntaxKind kind, SyntaxToken intoKeyword, SyntaxToken identifier, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(intoKeyword);
        this.intoKeyword = intoKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
    }


    internal JoinIntoClauseSyntax(SyntaxKind kind, SyntaxToken intoKeyword, SyntaxToken identifier)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(intoKeyword);
        this.intoKeyword = intoKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
    }

    public SyntaxToken IntoKeyword => this.intoKeyword;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.intoKeyword;
            case 1: return this.identifier;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.JoinIntoClauseSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitJoinIntoClause(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitJoinIntoClause(this);

    public JoinIntoClauseSyntax Update(SyntaxToken intoKeyword, SyntaxToken identifier)
    {
        if (intoKeyword != this.IntoKeyword || identifier != this.Identifier)
        {
            var newNode = SyntaxFactory.JoinIntoClause(intoKeyword, identifier);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new JoinIntoClauseSyntax(this.Kind, this.intoKeyword, this.identifier, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new JoinIntoClauseSyntax(this.Kind, this.intoKeyword, this.identifier, GetDiagnostics(), annotations);

    internal JoinIntoClauseSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var intoKeyword = (SyntaxToken)reader.ReadValue();
      if (intoKeyword != null)
      {
         AdjustFlagsAndWidth(intoKeyword);
         this.intoKeyword = intoKeyword;
      }
      var identifier = (SyntaxToken)reader.ReadValue();
      if (identifier != null)
      {
         AdjustFlagsAndWidth(identifier);
         this.identifier = identifier;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.intoKeyword);
      writer.WriteValue(this.identifier);
    }

    static JoinIntoClauseSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(JoinIntoClauseSyntax), r => new JoinIntoClauseSyntax(r));
    }
  }

  internal sealed partial class WhereClauseSyntax : QueryClauseSyntax
  {
    internal readonly SyntaxToken whereKeyword;
    internal readonly ExpressionSyntax condition;

    internal WhereClauseSyntax(SyntaxKind kind, SyntaxToken whereKeyword, ExpressionSyntax condition, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(whereKeyword);
        this.whereKeyword = whereKeyword;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
    }


    internal WhereClauseSyntax(SyntaxKind kind, SyntaxToken whereKeyword, ExpressionSyntax condition, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(whereKeyword);
        this.whereKeyword = whereKeyword;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
    }


    internal WhereClauseSyntax(SyntaxKind kind, SyntaxToken whereKeyword, ExpressionSyntax condition)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(whereKeyword);
        this.whereKeyword = whereKeyword;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
    }

    public SyntaxToken WhereKeyword => this.whereKeyword;
    public ExpressionSyntax Condition => this.condition;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.whereKeyword;
            case 1: return this.condition;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.WhereClauseSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitWhereClause(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitWhereClause(this);

    public WhereClauseSyntax Update(SyntaxToken whereKeyword, ExpressionSyntax condition)
    {
        if (whereKeyword != this.WhereKeyword || condition != this.Condition)
        {
            var newNode = SyntaxFactory.WhereClause(whereKeyword, condition);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new WhereClauseSyntax(this.Kind, this.whereKeyword, this.condition, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new WhereClauseSyntax(this.Kind, this.whereKeyword, this.condition, GetDiagnostics(), annotations);

    internal WhereClauseSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var whereKeyword = (SyntaxToken)reader.ReadValue();
      if (whereKeyword != null)
      {
         AdjustFlagsAndWidth(whereKeyword);
         this.whereKeyword = whereKeyword;
      }
      var condition = (ExpressionSyntax)reader.ReadValue();
      if (condition != null)
      {
         AdjustFlagsAndWidth(condition);
         this.condition = condition;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.whereKeyword);
      writer.WriteValue(this.condition);
    }

    static WhereClauseSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(WhereClauseSyntax), r => new WhereClauseSyntax(r));
    }
  }

  internal sealed partial class OrderByClauseSyntax : QueryClauseSyntax
  {
    internal readonly SyntaxToken orderByKeyword;
    internal readonly GreenNode orderings;

    internal OrderByClauseSyntax(SyntaxKind kind, SyntaxToken orderByKeyword, GreenNode orderings, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(orderByKeyword);
        this.orderByKeyword = orderByKeyword;
        if (orderings != null)
        {
            this.AdjustFlagsAndWidth(orderings);
            this.orderings = orderings;
        }
    }


    internal OrderByClauseSyntax(SyntaxKind kind, SyntaxToken orderByKeyword, GreenNode orderings, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(orderByKeyword);
        this.orderByKeyword = orderByKeyword;
        if (orderings != null)
        {
            this.AdjustFlagsAndWidth(orderings);
            this.orderings = orderings;
        }
    }


    internal OrderByClauseSyntax(SyntaxKind kind, SyntaxToken orderByKeyword, GreenNode orderings)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(orderByKeyword);
        this.orderByKeyword = orderByKeyword;
        if (orderings != null)
        {
            this.AdjustFlagsAndWidth(orderings);
            this.orderings = orderings;
        }
    }

    public SyntaxToken OrderByKeyword => this.orderByKeyword;
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<OrderingSyntax> Orderings => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<OrderingSyntax>(new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<CSharpSyntaxNode>(this.orderings));

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.orderByKeyword;
            case 1: return this.orderings;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.OrderByClauseSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitOrderByClause(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitOrderByClause(this);

    public OrderByClauseSyntax Update(SyntaxToken orderByKeyword, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<OrderingSyntax> orderings)
    {
        if (orderByKeyword != this.OrderByKeyword || orderings != this.Orderings)
        {
            var newNode = SyntaxFactory.OrderByClause(orderByKeyword, orderings);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new OrderByClauseSyntax(this.Kind, this.orderByKeyword, this.orderings, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new OrderByClauseSyntax(this.Kind, this.orderByKeyword, this.orderings, GetDiagnostics(), annotations);

    internal OrderByClauseSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var orderByKeyword = (SyntaxToken)reader.ReadValue();
      if (orderByKeyword != null)
      {
         AdjustFlagsAndWidth(orderByKeyword);
         this.orderByKeyword = orderByKeyword;
      }
      var orderings = (GreenNode)reader.ReadValue();
      if (orderings != null)
      {
         AdjustFlagsAndWidth(orderings);
         this.orderings = orderings;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.orderByKeyword);
      writer.WriteValue(this.orderings);
    }

    static OrderByClauseSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(OrderByClauseSyntax), r => new OrderByClauseSyntax(r));
    }
  }

  internal sealed partial class OrderingSyntax : CSharpSyntaxNode
  {
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken ascendingOrDescendingKeyword;

    internal OrderingSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken ascendingOrDescendingKeyword, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        if (ascendingOrDescendingKeyword != null)
        {
            this.AdjustFlagsAndWidth(ascendingOrDescendingKeyword);
            this.ascendingOrDescendingKeyword = ascendingOrDescendingKeyword;
        }
    }


    internal OrderingSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken ascendingOrDescendingKeyword, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        if (ascendingOrDescendingKeyword != null)
        {
            this.AdjustFlagsAndWidth(ascendingOrDescendingKeyword);
            this.ascendingOrDescendingKeyword = ascendingOrDescendingKeyword;
        }
    }


    internal OrderingSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken ascendingOrDescendingKeyword)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        if (ascendingOrDescendingKeyword != null)
        {
            this.AdjustFlagsAndWidth(ascendingOrDescendingKeyword);
            this.ascendingOrDescendingKeyword = ascendingOrDescendingKeyword;
        }
    }

    public ExpressionSyntax Expression => this.expression;
    public SyntaxToken AscendingOrDescendingKeyword => this.ascendingOrDescendingKeyword;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.expression;
            case 1: return this.ascendingOrDescendingKeyword;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.OrderingSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitOrdering(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitOrdering(this);

    public OrderingSyntax Update(ExpressionSyntax expression, SyntaxToken ascendingOrDescendingKeyword)
    {
        if (expression != this.Expression || ascendingOrDescendingKeyword != this.AscendingOrDescendingKeyword)
        {
            var newNode = SyntaxFactory.Ordering(this.Kind, expression, ascendingOrDescendingKeyword);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new OrderingSyntax(this.Kind, this.expression, this.ascendingOrDescendingKeyword, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new OrderingSyntax(this.Kind, this.expression, this.ascendingOrDescendingKeyword, GetDiagnostics(), annotations);

    internal OrderingSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
      var ascendingOrDescendingKeyword = (SyntaxToken)reader.ReadValue();
      if (ascendingOrDescendingKeyword != null)
      {
         AdjustFlagsAndWidth(ascendingOrDescendingKeyword);
         this.ascendingOrDescendingKeyword = ascendingOrDescendingKeyword;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.expression);
      writer.WriteValue(this.ascendingOrDescendingKeyword);
    }

    static OrderingSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(OrderingSyntax), r => new OrderingSyntax(r));
    }
  }

  internal sealed partial class SelectClauseSyntax : SelectOrGroupClauseSyntax
  {
    internal readonly SyntaxToken selectKeyword;
    internal readonly ExpressionSyntax expression;

    internal SelectClauseSyntax(SyntaxKind kind, SyntaxToken selectKeyword, ExpressionSyntax expression, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(selectKeyword);
        this.selectKeyword = selectKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }


    internal SelectClauseSyntax(SyntaxKind kind, SyntaxToken selectKeyword, ExpressionSyntax expression, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(selectKeyword);
        this.selectKeyword = selectKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }


    internal SelectClauseSyntax(SyntaxKind kind, SyntaxToken selectKeyword, ExpressionSyntax expression)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(selectKeyword);
        this.selectKeyword = selectKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    public SyntaxToken SelectKeyword => this.selectKeyword;
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.selectKeyword;
            case 1: return this.expression;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.SelectClauseSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitSelectClause(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitSelectClause(this);

    public SelectClauseSyntax Update(SyntaxToken selectKeyword, ExpressionSyntax expression)
    {
        if (selectKeyword != this.SelectKeyword || expression != this.Expression)
        {
            var newNode = SyntaxFactory.SelectClause(selectKeyword, expression);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new SelectClauseSyntax(this.Kind, this.selectKeyword, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new SelectClauseSyntax(this.Kind, this.selectKeyword, this.expression, GetDiagnostics(), annotations);

    internal SelectClauseSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var selectKeyword = (SyntaxToken)reader.ReadValue();
      if (selectKeyword != null)
      {
         AdjustFlagsAndWidth(selectKeyword);
         this.selectKeyword = selectKeyword;
      }
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.selectKeyword);
      writer.WriteValue(this.expression);
    }

    static SelectClauseSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(SelectClauseSyntax), r => new SelectClauseSyntax(r));
    }
  }

  internal sealed partial class GroupClauseSyntax : SelectOrGroupClauseSyntax
  {
    internal readonly SyntaxToken groupKeyword;
    internal readonly ExpressionSyntax groupExpression;
    internal readonly SyntaxToken byKeyword;
    internal readonly ExpressionSyntax byExpression;

    internal GroupClauseSyntax(SyntaxKind kind, SyntaxToken groupKeyword, ExpressionSyntax groupExpression, SyntaxToken byKeyword, ExpressionSyntax byExpression, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(groupKeyword);
        this.groupKeyword = groupKeyword;
        this.AdjustFlagsAndWidth(groupExpression);
        this.groupExpression = groupExpression;
        this.AdjustFlagsAndWidth(byKeyword);
        this.byKeyword = byKeyword;
        this.AdjustFlagsAndWidth(byExpression);
        this.byExpression = byExpression;
    }


    internal GroupClauseSyntax(SyntaxKind kind, SyntaxToken groupKeyword, ExpressionSyntax groupExpression, SyntaxToken byKeyword, ExpressionSyntax byExpression, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(groupKeyword);
        this.groupKeyword = groupKeyword;
        this.AdjustFlagsAndWidth(groupExpression);
        this.groupExpression = groupExpression;
        this.AdjustFlagsAndWidth(byKeyword);
        this.byKeyword = byKeyword;
        this.AdjustFlagsAndWidth(byExpression);
        this.byExpression = byExpression;
    }


    internal GroupClauseSyntax(SyntaxKind kind, SyntaxToken groupKeyword, ExpressionSyntax groupExpression, SyntaxToken byKeyword, ExpressionSyntax byExpression)
        : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(groupKeyword);
        this.groupKeyword = groupKeyword;
        this.AdjustFlagsAndWidth(groupExpression);
        this.groupExpression = groupExpression;
        this.AdjustFlagsAndWidth(byKeyword);
        this.byKeyword = byKeyword;
        this.AdjustFlagsAndWidth(byExpression);
        this.byExpression = byExpression;
    }

    public SyntaxToken GroupKeyword => this.groupKeyword;
    public ExpressionSyntax GroupExpression => this.groupExpression;
    public SyntaxToken ByKeyword => this.byKeyword;
    public ExpressionSyntax ByExpression => this.byExpression;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.groupKeyword;
            case 1: return this.groupExpression;
            case 2: return this.byKeyword;
            case 3: return this.byExpression;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.GroupClauseSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitGroupClause(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitGroupClause(this);

    public GroupClauseSyntax Update(SyntaxToken groupKeyword, ExpressionSyntax groupExpression, SyntaxToken byKeyword, ExpressionSyntax byExpression)
    {
        if (groupKeyword != this.GroupKeyword || groupExpression != this.GroupExpression || byKeyword != this.ByKeyword || byExpression != this.ByExpression)
        {
            var newNode = SyntaxFactory.GroupClause(groupKeyword, groupExpression, byKeyword, byExpression);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new GroupClauseSyntax(this.Kind, this.groupKeyword, this.groupExpression, this.byKeyword, this.byExpression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new GroupClauseSyntax(this.Kind, this.groupKeyword, this.groupExpression, this.byKeyword, this.byExpression, GetDiagnostics(), annotations);

    internal GroupClauseSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var groupKeyword = (SyntaxToken)reader.ReadValue();
      if (groupKeyword != null)
      {
         AdjustFlagsAndWidth(groupKeyword);
         this.groupKeyword = groupKeyword;
      }
      var groupExpression = (ExpressionSyntax)reader.ReadValue();
      if (groupExpression != null)
      {
         AdjustFlagsAndWidth(groupExpression);
         this.groupExpression = groupExpression;
      }
      var byKeyword = (SyntaxToken)reader.ReadValue();
      if (byKeyword != null)
      {
         AdjustFlagsAndWidth(byKeyword);
         this.byKeyword = byKeyword;
      }
      var byExpression = (ExpressionSyntax)reader.ReadValue();
      if (byExpression != null)
      {
         AdjustFlagsAndWidth(byExpression);
         this.byExpression = byExpression;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.groupKeyword);
      writer.WriteValue(this.groupExpression);
      writer.WriteValue(this.byKeyword);
      writer.WriteValue(this.byExpression);
    }

    static GroupClauseSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(GroupClauseSyntax), r => new GroupClauseSyntax(r));
    }
  }

  internal sealed partial class QueryContinuationSyntax : CSharpSyntaxNode
  {
    internal readonly SyntaxToken intoKeyword;
    internal readonly SyntaxToken identifier;
    internal readonly QueryBodySyntax body;

    internal QueryContinuationSyntax(SyntaxKind kind, SyntaxToken intoKeyword, SyntaxToken identifier, QueryBodySyntax body, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(intoKeyword);
        this.intoKeyword = intoKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(body);
        this.body = body;
    }


    internal QueryContinuationSyntax(SyntaxKind kind, SyntaxToken intoKeyword, SyntaxToken identifier, QueryBodySyntax body, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(intoKeyword);
        this.intoKeyword = intoKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(body);
        this.body = body;
    }


    internal QueryContinuationSyntax(SyntaxKind kind, SyntaxToken intoKeyword, SyntaxToken identifier, QueryBodySyntax body)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(intoKeyword);
        this.intoKeyword = intoKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(body);
        this.body = body;
    }

    public SyntaxToken IntoKeyword => this.intoKeyword;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public QueryBodySyntax Body => this.body;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.intoKeyword;
            case 1: return this.identifier;
            case 2: return this.body;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.QueryContinuationSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitQueryContinuation(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitQueryContinuation(this);

    public QueryContinuationSyntax Update(SyntaxToken intoKeyword, SyntaxToken identifier, QueryBodySyntax body)
    {
        if (intoKeyword != this.IntoKeyword || identifier != this.Identifier || body != this.Body)
        {
            var newNode = SyntaxFactory.QueryContinuation(intoKeyword, identifier, body);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new QueryContinuationSyntax(this.Kind, this.intoKeyword, this.identifier, this.body, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new QueryContinuationSyntax(this.Kind, this.intoKeyword, this.identifier, this.body, GetDiagnostics(), annotations);

    internal QueryContinuationSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var intoKeyword = (SyntaxToken)reader.ReadValue();
      if (intoKeyword != null)
      {
         AdjustFlagsAndWidth(intoKeyword);
         this.intoKeyword = intoKeyword;
      }
      var identifier = (SyntaxToken)reader.ReadValue();
      if (identifier != null)
      {
         AdjustFlagsAndWidth(identifier);
         this.identifier = identifier;
      }
      var body = (QueryBodySyntax)reader.ReadValue();
      if (body != null)
      {
         AdjustFlagsAndWidth(body);
         this.body = body;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.intoKeyword);
      writer.WriteValue(this.identifier);
      writer.WriteValue(this.body);
    }

    static QueryContinuationSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(QueryContinuationSyntax), r => new QueryContinuationSyntax(r));
    }
  }

  /// <summary>Class which represents a placeholder in an array size list.</summary>
  internal sealed partial class OmittedArraySizeExpressionSyntax : ExpressionSyntax
  {
    internal readonly SyntaxToken omittedArraySizeExpressionToken;

    internal OmittedArraySizeExpressionSyntax(SyntaxKind kind, SyntaxToken omittedArraySizeExpressionToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(omittedArraySizeExpressionToken);
        this.omittedArraySizeExpressionToken = omittedArraySizeExpressionToken;
    }


    internal OmittedArraySizeExpressionSyntax(SyntaxKind kind, SyntaxToken omittedArraySizeExpressionToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(omittedArraySizeExpressionToken);
        this.omittedArraySizeExpressionToken = omittedArraySizeExpressionToken;
    }


    internal OmittedArraySizeExpressionSyntax(SyntaxKind kind, SyntaxToken omittedArraySizeExpressionToken)
        : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(omittedArraySizeExpressionToken);
        this.omittedArraySizeExpressionToken = omittedArraySizeExpressionToken;
    }

    /// <summary>SyntaxToken representing the omitted array size expression.</summary>
    public SyntaxToken OmittedArraySizeExpressionToken => this.omittedArraySizeExpressionToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.omittedArraySizeExpressionToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.OmittedArraySizeExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitOmittedArraySizeExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitOmittedArraySizeExpression(this);

    public OmittedArraySizeExpressionSyntax Update(SyntaxToken omittedArraySizeExpressionToken)
    {
        if (omittedArraySizeExpressionToken != this.OmittedArraySizeExpressionToken)
        {
            var newNode = SyntaxFactory.OmittedArraySizeExpression(omittedArraySizeExpressionToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new OmittedArraySizeExpressionSyntax(this.Kind, this.omittedArraySizeExpressionToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new OmittedArraySizeExpressionSyntax(this.Kind, this.omittedArraySizeExpressionToken, GetDiagnostics(), annotations);

    internal OmittedArraySizeExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 1;
      var omittedArraySizeExpressionToken = (SyntaxToken)reader.ReadValue();
      if (omittedArraySizeExpressionToken != null)
      {
         AdjustFlagsAndWidth(omittedArraySizeExpressionToken);
         this.omittedArraySizeExpressionToken = omittedArraySizeExpressionToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.omittedArraySizeExpressionToken);
    }

    static OmittedArraySizeExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(OmittedArraySizeExpressionSyntax), r => new OmittedArraySizeExpressionSyntax(r));
    }
  }

  internal sealed partial class InterpolatedStringExpressionSyntax : ExpressionSyntax
  {
    internal readonly SyntaxToken stringStartToken;
    internal readonly GreenNode contents;
    internal readonly SyntaxToken stringEndToken;

    internal InterpolatedStringExpressionSyntax(SyntaxKind kind, SyntaxToken stringStartToken, GreenNode contents, SyntaxToken stringEndToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(stringStartToken);
        this.stringStartToken = stringStartToken;
        if (contents != null)
        {
            this.AdjustFlagsAndWidth(contents);
            this.contents = contents;
        }
        this.AdjustFlagsAndWidth(stringEndToken);
        this.stringEndToken = stringEndToken;
    }


    internal InterpolatedStringExpressionSyntax(SyntaxKind kind, SyntaxToken stringStartToken, GreenNode contents, SyntaxToken stringEndToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(stringStartToken);
        this.stringStartToken = stringStartToken;
        if (contents != null)
        {
            this.AdjustFlagsAndWidth(contents);
            this.contents = contents;
        }
        this.AdjustFlagsAndWidth(stringEndToken);
        this.stringEndToken = stringEndToken;
    }


    internal InterpolatedStringExpressionSyntax(SyntaxKind kind, SyntaxToken stringStartToken, GreenNode contents, SyntaxToken stringEndToken)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(stringStartToken);
        this.stringStartToken = stringStartToken;
        if (contents != null)
        {
            this.AdjustFlagsAndWidth(contents);
            this.contents = contents;
        }
        this.AdjustFlagsAndWidth(stringEndToken);
        this.stringEndToken = stringEndToken;
    }

    /// <summary>The first part of an interpolated string, $" or $@"</summary>
    public SyntaxToken StringStartToken => this.stringStartToken;
    /// <summary>List of parts of the interpolated string, each one is either a literal part or an interpolation.</summary>
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<InterpolatedStringContentSyntax> Contents => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<InterpolatedStringContentSyntax>(this.contents);
    /// <summary>The closing quote of the interpolated string.</summary>
    public SyntaxToken StringEndToken => this.stringEndToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.stringStartToken;
            case 1: return this.contents;
            case 2: return this.stringEndToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.InterpolatedStringExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitInterpolatedStringExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitInterpolatedStringExpression(this);

    public InterpolatedStringExpressionSyntax Update(SyntaxToken stringStartToken, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<InterpolatedStringContentSyntax> contents, SyntaxToken stringEndToken)
    {
        if (stringStartToken != this.StringStartToken || contents != this.Contents || stringEndToken != this.StringEndToken)
        {
            var newNode = SyntaxFactory.InterpolatedStringExpression(stringStartToken, contents, stringEndToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new InterpolatedStringExpressionSyntax(this.Kind, this.stringStartToken, this.contents, this.stringEndToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new InterpolatedStringExpressionSyntax(this.Kind, this.stringStartToken, this.contents, this.stringEndToken, GetDiagnostics(), annotations);

    internal InterpolatedStringExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var stringStartToken = (SyntaxToken)reader.ReadValue();
      if (stringStartToken != null)
      {
         AdjustFlagsAndWidth(stringStartToken);
         this.stringStartToken = stringStartToken;
      }
      var contents = (GreenNode)reader.ReadValue();
      if (contents != null)
      {
         AdjustFlagsAndWidth(contents);
         this.contents = contents;
      }
      var stringEndToken = (SyntaxToken)reader.ReadValue();
      if (stringEndToken != null)
      {
         AdjustFlagsAndWidth(stringEndToken);
         this.stringEndToken = stringEndToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.stringStartToken);
      writer.WriteValue(this.contents);
      writer.WriteValue(this.stringEndToken);
    }

    static InterpolatedStringExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(InterpolatedStringExpressionSyntax), r => new InterpolatedStringExpressionSyntax(r));
    }
  }

  /// <summary>Class which represents a simple pattern-matching expression using the "is" keyword.</summary>
  internal sealed partial class IsPatternExpressionSyntax : ExpressionSyntax
  {
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken isKeyword;
    internal readonly PatternSyntax pattern;

    internal IsPatternExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken isKeyword, PatternSyntax pattern, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(isKeyword);
        this.isKeyword = isKeyword;
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
    }


    internal IsPatternExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken isKeyword, PatternSyntax pattern, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(isKeyword);
        this.isKeyword = isKeyword;
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
    }


    internal IsPatternExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken isKeyword, PatternSyntax pattern)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(isKeyword);
        this.isKeyword = isKeyword;
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
    }

    /// <summary>ExpressionSyntax node representing the expression on the left of the "is" operator.</summary>
    public ExpressionSyntax Expression => this.expression;
    public SyntaxToken IsKeyword => this.isKeyword;
    /// <summary>PatternSyntax node representing the pattern on the right of the "is" operator.</summary>
    public PatternSyntax Pattern => this.pattern;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.expression;
            case 1: return this.isKeyword;
            case 2: return this.pattern;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.IsPatternExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitIsPatternExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitIsPatternExpression(this);

    public IsPatternExpressionSyntax Update(ExpressionSyntax expression, SyntaxToken isKeyword, PatternSyntax pattern)
    {
        if (expression != this.Expression || isKeyword != this.IsKeyword || pattern != this.Pattern)
        {
            var newNode = SyntaxFactory.IsPatternExpression(expression, isKeyword, pattern);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new IsPatternExpressionSyntax(this.Kind, this.expression, this.isKeyword, this.pattern, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new IsPatternExpressionSyntax(this.Kind, this.expression, this.isKeyword, this.pattern, GetDiagnostics(), annotations);

    internal IsPatternExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
      var isKeyword = (SyntaxToken)reader.ReadValue();
      if (isKeyword != null)
      {
         AdjustFlagsAndWidth(isKeyword);
         this.isKeyword = isKeyword;
      }
      var pattern = (PatternSyntax)reader.ReadValue();
      if (pattern != null)
      {
         AdjustFlagsAndWidth(pattern);
         this.pattern = pattern;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.expression);
      writer.WriteValue(this.isKeyword);
      writer.WriteValue(this.pattern);
    }

    static IsPatternExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(IsPatternExpressionSyntax), r => new IsPatternExpressionSyntax(r));
    }
  }

  internal sealed partial class ThrowExpressionSyntax : ExpressionSyntax
  {
    internal readonly SyntaxToken throwKeyword;
    internal readonly ExpressionSyntax expression;

    internal ThrowExpressionSyntax(SyntaxKind kind, SyntaxToken throwKeyword, ExpressionSyntax expression, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(throwKeyword);
        this.throwKeyword = throwKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }


    internal ThrowExpressionSyntax(SyntaxKind kind, SyntaxToken throwKeyword, ExpressionSyntax expression, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(throwKeyword);
        this.throwKeyword = throwKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }


    internal ThrowExpressionSyntax(SyntaxKind kind, SyntaxToken throwKeyword, ExpressionSyntax expression)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(throwKeyword);
        this.throwKeyword = throwKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    public SyntaxToken ThrowKeyword => this.throwKeyword;
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.throwKeyword;
            case 1: return this.expression;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ThrowExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitThrowExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitThrowExpression(this);

    public ThrowExpressionSyntax Update(SyntaxToken throwKeyword, ExpressionSyntax expression)
    {
        if (throwKeyword != this.ThrowKeyword || expression != this.Expression)
        {
            var newNode = SyntaxFactory.ThrowExpression(throwKeyword, expression);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ThrowExpressionSyntax(this.Kind, this.throwKeyword, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ThrowExpressionSyntax(this.Kind, this.throwKeyword, this.expression, GetDiagnostics(), annotations);

    internal ThrowExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var throwKeyword = (SyntaxToken)reader.ReadValue();
      if (throwKeyword != null)
      {
         AdjustFlagsAndWidth(throwKeyword);
         this.throwKeyword = throwKeyword;
      }
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.throwKeyword);
      writer.WriteValue(this.expression);
    }

    static ThrowExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ThrowExpressionSyntax), r => new ThrowExpressionSyntax(r));
    }
  }

  internal sealed partial class WhenClauseSyntax : CSharpSyntaxNode
  {
    internal readonly SyntaxToken whenKeyword;
    internal readonly ExpressionSyntax condition;

    internal WhenClauseSyntax(SyntaxKind kind, SyntaxToken whenKeyword, ExpressionSyntax condition, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(whenKeyword);
        this.whenKeyword = whenKeyword;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
    }


    internal WhenClauseSyntax(SyntaxKind kind, SyntaxToken whenKeyword, ExpressionSyntax condition, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(whenKeyword);
        this.whenKeyword = whenKeyword;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
    }


    internal WhenClauseSyntax(SyntaxKind kind, SyntaxToken whenKeyword, ExpressionSyntax condition)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(whenKeyword);
        this.whenKeyword = whenKeyword;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
    }

    public SyntaxToken WhenKeyword => this.whenKeyword;
    public ExpressionSyntax Condition => this.condition;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.whenKeyword;
            case 1: return this.condition;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.WhenClauseSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitWhenClause(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitWhenClause(this);

    public WhenClauseSyntax Update(SyntaxToken whenKeyword, ExpressionSyntax condition)
    {
        if (whenKeyword != this.WhenKeyword || condition != this.Condition)
        {
            var newNode = SyntaxFactory.WhenClause(whenKeyword, condition);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new WhenClauseSyntax(this.Kind, this.whenKeyword, this.condition, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new WhenClauseSyntax(this.Kind, this.whenKeyword, this.condition, GetDiagnostics(), annotations);

    internal WhenClauseSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var whenKeyword = (SyntaxToken)reader.ReadValue();
      if (whenKeyword != null)
      {
         AdjustFlagsAndWidth(whenKeyword);
         this.whenKeyword = whenKeyword;
      }
      var condition = (ExpressionSyntax)reader.ReadValue();
      if (condition != null)
      {
         AdjustFlagsAndWidth(condition);
         this.condition = condition;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.whenKeyword);
      writer.WriteValue(this.condition);
    }

    static WhenClauseSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(WhenClauseSyntax), r => new WhenClauseSyntax(r));
    }
  }

  internal abstract partial class PatternSyntax : CSharpSyntaxNode
  {
    internal PatternSyntax(SyntaxKind kind, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal PatternSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    protected PatternSyntax(ObjectReader reader)
       : base(reader)
    {
    }
  }

  internal sealed partial class DiscardPatternSyntax : PatternSyntax
  {
    internal readonly SyntaxToken underscoreToken;

    internal DiscardPatternSyntax(SyntaxKind kind, SyntaxToken underscoreToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(underscoreToken);
        this.underscoreToken = underscoreToken;
    }


    internal DiscardPatternSyntax(SyntaxKind kind, SyntaxToken underscoreToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(underscoreToken);
        this.underscoreToken = underscoreToken;
    }


    internal DiscardPatternSyntax(SyntaxKind kind, SyntaxToken underscoreToken)
        : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(underscoreToken);
        this.underscoreToken = underscoreToken;
    }

    public SyntaxToken UnderscoreToken => this.underscoreToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.underscoreToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.DiscardPatternSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitDiscardPattern(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitDiscardPattern(this);

    public DiscardPatternSyntax Update(SyntaxToken underscoreToken)
    {
        if (underscoreToken != this.UnderscoreToken)
        {
            var newNode = SyntaxFactory.DiscardPattern(underscoreToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new DiscardPatternSyntax(this.Kind, this.underscoreToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new DiscardPatternSyntax(this.Kind, this.underscoreToken, GetDiagnostics(), annotations);

    internal DiscardPatternSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 1;
      var underscoreToken = (SyntaxToken)reader.ReadValue();
      if (underscoreToken != null)
      {
         AdjustFlagsAndWidth(underscoreToken);
         this.underscoreToken = underscoreToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.underscoreToken);
    }

    static DiscardPatternSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(DiscardPatternSyntax), r => new DiscardPatternSyntax(r));
    }
  }

  internal sealed partial class DeclarationPatternSyntax : PatternSyntax
  {
    internal readonly TypeSyntax type;
    internal readonly VariableDesignationSyntax designation;

    internal DeclarationPatternSyntax(SyntaxKind kind, TypeSyntax type, VariableDesignationSyntax designation, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(designation);
        this.designation = designation;
    }


    internal DeclarationPatternSyntax(SyntaxKind kind, TypeSyntax type, VariableDesignationSyntax designation, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(designation);
        this.designation = designation;
    }


    internal DeclarationPatternSyntax(SyntaxKind kind, TypeSyntax type, VariableDesignationSyntax designation)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(designation);
        this.designation = designation;
    }

    public TypeSyntax Type => this.type;
    public VariableDesignationSyntax Designation => this.designation;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.type;
            case 1: return this.designation;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.DeclarationPatternSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitDeclarationPattern(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitDeclarationPattern(this);

    public DeclarationPatternSyntax Update(TypeSyntax type, VariableDesignationSyntax designation)
    {
        if (type != this.Type || designation != this.Designation)
        {
            var newNode = SyntaxFactory.DeclarationPattern(type, designation);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new DeclarationPatternSyntax(this.Kind, this.type, this.designation, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new DeclarationPatternSyntax(this.Kind, this.type, this.designation, GetDiagnostics(), annotations);

    internal DeclarationPatternSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var type = (TypeSyntax)reader.ReadValue();
      if (type != null)
      {
         AdjustFlagsAndWidth(type);
         this.type = type;
      }
      var designation = (VariableDesignationSyntax)reader.ReadValue();
      if (designation != null)
      {
         AdjustFlagsAndWidth(designation);
         this.designation = designation;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.type);
      writer.WriteValue(this.designation);
    }

    static DeclarationPatternSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(DeclarationPatternSyntax), r => new DeclarationPatternSyntax(r));
    }
  }

  internal sealed partial class VarPatternSyntax : PatternSyntax
  {
    internal readonly SyntaxToken varKeyword;
    internal readonly VariableDesignationSyntax designation;

    internal VarPatternSyntax(SyntaxKind kind, SyntaxToken varKeyword, VariableDesignationSyntax designation, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(varKeyword);
        this.varKeyword = varKeyword;
        this.AdjustFlagsAndWidth(designation);
        this.designation = designation;
    }


    internal VarPatternSyntax(SyntaxKind kind, SyntaxToken varKeyword, VariableDesignationSyntax designation, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(varKeyword);
        this.varKeyword = varKeyword;
        this.AdjustFlagsAndWidth(designation);
        this.designation = designation;
    }


    internal VarPatternSyntax(SyntaxKind kind, SyntaxToken varKeyword, VariableDesignationSyntax designation)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(varKeyword);
        this.varKeyword = varKeyword;
        this.AdjustFlagsAndWidth(designation);
        this.designation = designation;
    }

    public SyntaxToken VarKeyword => this.varKeyword;
    public VariableDesignationSyntax Designation => this.designation;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.varKeyword;
            case 1: return this.designation;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.VarPatternSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitVarPattern(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitVarPattern(this);

    public VarPatternSyntax Update(SyntaxToken varKeyword, VariableDesignationSyntax designation)
    {
        if (varKeyword != this.VarKeyword || designation != this.Designation)
        {
            var newNode = SyntaxFactory.VarPattern(varKeyword, designation);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new VarPatternSyntax(this.Kind, this.varKeyword, this.designation, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new VarPatternSyntax(this.Kind, this.varKeyword, this.designation, GetDiagnostics(), annotations);

    internal VarPatternSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var varKeyword = (SyntaxToken)reader.ReadValue();
      if (varKeyword != null)
      {
         AdjustFlagsAndWidth(varKeyword);
         this.varKeyword = varKeyword;
      }
      var designation = (VariableDesignationSyntax)reader.ReadValue();
      if (designation != null)
      {
         AdjustFlagsAndWidth(designation);
         this.designation = designation;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.varKeyword);
      writer.WriteValue(this.designation);
    }

    static VarPatternSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(VarPatternSyntax), r => new VarPatternSyntax(r));
    }
  }

  internal sealed partial class RecursivePatternSyntax : PatternSyntax
  {
    internal readonly TypeSyntax type;
    internal readonly PositionalPatternClauseSyntax positionalPatternClause;
    internal readonly PropertyPatternClauseSyntax propertyPatternClause;
    internal readonly VariableDesignationSyntax designation;

    internal RecursivePatternSyntax(SyntaxKind kind, TypeSyntax type, PositionalPatternClauseSyntax positionalPatternClause, PropertyPatternClauseSyntax propertyPatternClause, VariableDesignationSyntax designation, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        if (type != null)
        {
            this.AdjustFlagsAndWidth(type);
            this.type = type;
        }
        if (positionalPatternClause != null)
        {
            this.AdjustFlagsAndWidth(positionalPatternClause);
            this.positionalPatternClause = positionalPatternClause;
        }
        if (propertyPatternClause != null)
        {
            this.AdjustFlagsAndWidth(propertyPatternClause);
            this.propertyPatternClause = propertyPatternClause;
        }
        if (designation != null)
        {
            this.AdjustFlagsAndWidth(designation);
            this.designation = designation;
        }
    }


    internal RecursivePatternSyntax(SyntaxKind kind, TypeSyntax type, PositionalPatternClauseSyntax positionalPatternClause, PropertyPatternClauseSyntax propertyPatternClause, VariableDesignationSyntax designation, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        if (type != null)
        {
            this.AdjustFlagsAndWidth(type);
            this.type = type;
        }
        if (positionalPatternClause != null)
        {
            this.AdjustFlagsAndWidth(positionalPatternClause);
            this.positionalPatternClause = positionalPatternClause;
        }
        if (propertyPatternClause != null)
        {
            this.AdjustFlagsAndWidth(propertyPatternClause);
            this.propertyPatternClause = propertyPatternClause;
        }
        if (designation != null)
        {
            this.AdjustFlagsAndWidth(designation);
            this.designation = designation;
        }
    }


    internal RecursivePatternSyntax(SyntaxKind kind, TypeSyntax type, PositionalPatternClauseSyntax positionalPatternClause, PropertyPatternClauseSyntax propertyPatternClause, VariableDesignationSyntax designation)
        : base(kind)
    {
        this.SlotCount = 4;
        if (type != null)
        {
            this.AdjustFlagsAndWidth(type);
            this.type = type;
        }
        if (positionalPatternClause != null)
        {
            this.AdjustFlagsAndWidth(positionalPatternClause);
            this.positionalPatternClause = positionalPatternClause;
        }
        if (propertyPatternClause != null)
        {
            this.AdjustFlagsAndWidth(propertyPatternClause);
            this.propertyPatternClause = propertyPatternClause;
        }
        if (designation != null)
        {
            this.AdjustFlagsAndWidth(designation);
            this.designation = designation;
        }
    }

    public TypeSyntax Type => this.type;
    public PositionalPatternClauseSyntax PositionalPatternClause => this.positionalPatternClause;
    public PropertyPatternClauseSyntax PropertyPatternClause => this.propertyPatternClause;
    public VariableDesignationSyntax Designation => this.designation;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.type;
            case 1: return this.positionalPatternClause;
            case 2: return this.propertyPatternClause;
            case 3: return this.designation;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.RecursivePatternSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitRecursivePattern(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitRecursivePattern(this);

    public RecursivePatternSyntax Update(TypeSyntax type, PositionalPatternClauseSyntax positionalPatternClause, PropertyPatternClauseSyntax propertyPatternClause, VariableDesignationSyntax designation)
    {
        if (type != this.Type || positionalPatternClause != this.PositionalPatternClause || propertyPatternClause != this.PropertyPatternClause || designation != this.Designation)
        {
            var newNode = SyntaxFactory.RecursivePattern(type, positionalPatternClause, propertyPatternClause, designation);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new RecursivePatternSyntax(this.Kind, this.type, this.positionalPatternClause, this.propertyPatternClause, this.designation, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new RecursivePatternSyntax(this.Kind, this.type, this.positionalPatternClause, this.propertyPatternClause, this.designation, GetDiagnostics(), annotations);

    internal RecursivePatternSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var type = (TypeSyntax)reader.ReadValue();
      if (type != null)
      {
         AdjustFlagsAndWidth(type);
         this.type = type;
      }
      var positionalPatternClause = (PositionalPatternClauseSyntax)reader.ReadValue();
      if (positionalPatternClause != null)
      {
         AdjustFlagsAndWidth(positionalPatternClause);
         this.positionalPatternClause = positionalPatternClause;
      }
      var propertyPatternClause = (PropertyPatternClauseSyntax)reader.ReadValue();
      if (propertyPatternClause != null)
      {
         AdjustFlagsAndWidth(propertyPatternClause);
         this.propertyPatternClause = propertyPatternClause;
      }
      var designation = (VariableDesignationSyntax)reader.ReadValue();
      if (designation != null)
      {
         AdjustFlagsAndWidth(designation);
         this.designation = designation;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.type);
      writer.WriteValue(this.positionalPatternClause);
      writer.WriteValue(this.propertyPatternClause);
      writer.WriteValue(this.designation);
    }

    static RecursivePatternSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(RecursivePatternSyntax), r => new RecursivePatternSyntax(r));
    }
  }

  internal sealed partial class PositionalPatternClauseSyntax : CSharpSyntaxNode
  {
    internal readonly SyntaxToken openParenToken;
    internal readonly GreenNode subpatterns;
    internal readonly SyntaxToken closeParenToken;

    internal PositionalPatternClauseSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode subpatterns, SyntaxToken closeParenToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (subpatterns != null)
        {
            this.AdjustFlagsAndWidth(subpatterns);
            this.subpatterns = subpatterns;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal PositionalPatternClauseSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode subpatterns, SyntaxToken closeParenToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (subpatterns != null)
        {
            this.AdjustFlagsAndWidth(subpatterns);
            this.subpatterns = subpatterns;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal PositionalPatternClauseSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode subpatterns, SyntaxToken closeParenToken)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (subpatterns != null)
        {
            this.AdjustFlagsAndWidth(subpatterns);
            this.subpatterns = subpatterns;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    public SyntaxToken OpenParenToken => this.openParenToken;
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<SubpatternSyntax> Subpatterns => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<SubpatternSyntax>(new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<CSharpSyntaxNode>(this.subpatterns));
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.openParenToken;
            case 1: return this.subpatterns;
            case 2: return this.closeParenToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.PositionalPatternClauseSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitPositionalPatternClause(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitPositionalPatternClause(this);

    public PositionalPatternClauseSyntax Update(SyntaxToken openParenToken, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<SubpatternSyntax> subpatterns, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || subpatterns != this.Subpatterns || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.PositionalPatternClause(openParenToken, subpatterns, closeParenToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new PositionalPatternClauseSyntax(this.Kind, this.openParenToken, this.subpatterns, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new PositionalPatternClauseSyntax(this.Kind, this.openParenToken, this.subpatterns, this.closeParenToken, GetDiagnostics(), annotations);

    internal PositionalPatternClauseSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var subpatterns = (GreenNode)reader.ReadValue();
      if (subpatterns != null)
      {
         AdjustFlagsAndWidth(subpatterns);
         this.subpatterns = subpatterns;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.subpatterns);
      writer.WriteValue(this.closeParenToken);
    }

    static PositionalPatternClauseSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(PositionalPatternClauseSyntax), r => new PositionalPatternClauseSyntax(r));
    }
  }

  internal sealed partial class PropertyPatternClauseSyntax : CSharpSyntaxNode
  {
    internal readonly SyntaxToken openBraceToken;
    internal readonly GreenNode subpatterns;
    internal readonly SyntaxToken closeBraceToken;

    internal PropertyPatternClauseSyntax(SyntaxKind kind, SyntaxToken openBraceToken, GreenNode subpatterns, SyntaxToken closeBraceToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (subpatterns != null)
        {
            this.AdjustFlagsAndWidth(subpatterns);
            this.subpatterns = subpatterns;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }


    internal PropertyPatternClauseSyntax(SyntaxKind kind, SyntaxToken openBraceToken, GreenNode subpatterns, SyntaxToken closeBraceToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (subpatterns != null)
        {
            this.AdjustFlagsAndWidth(subpatterns);
            this.subpatterns = subpatterns;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }


    internal PropertyPatternClauseSyntax(SyntaxKind kind, SyntaxToken openBraceToken, GreenNode subpatterns, SyntaxToken closeBraceToken)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (subpatterns != null)
        {
            this.AdjustFlagsAndWidth(subpatterns);
            this.subpatterns = subpatterns;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    public SyntaxToken OpenBraceToken => this.openBraceToken;
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<SubpatternSyntax> Subpatterns => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<SubpatternSyntax>(new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<CSharpSyntaxNode>(this.subpatterns));
    public SyntaxToken CloseBraceToken => this.closeBraceToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.openBraceToken;
            case 1: return this.subpatterns;
            case 2: return this.closeBraceToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.PropertyPatternClauseSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitPropertyPatternClause(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitPropertyPatternClause(this);

    public PropertyPatternClauseSyntax Update(SyntaxToken openBraceToken, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<SubpatternSyntax> subpatterns, SyntaxToken closeBraceToken)
    {
        if (openBraceToken != this.OpenBraceToken || subpatterns != this.Subpatterns || closeBraceToken != this.CloseBraceToken)
        {
            var newNode = SyntaxFactory.PropertyPatternClause(openBraceToken, subpatterns, closeBraceToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new PropertyPatternClauseSyntax(this.Kind, this.openBraceToken, this.subpatterns, this.closeBraceToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new PropertyPatternClauseSyntax(this.Kind, this.openBraceToken, this.subpatterns, this.closeBraceToken, GetDiagnostics(), annotations);

    internal PropertyPatternClauseSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var openBraceToken = (SyntaxToken)reader.ReadValue();
      if (openBraceToken != null)
      {
         AdjustFlagsAndWidth(openBraceToken);
         this.openBraceToken = openBraceToken;
      }
      var subpatterns = (GreenNode)reader.ReadValue();
      if (subpatterns != null)
      {
         AdjustFlagsAndWidth(subpatterns);
         this.subpatterns = subpatterns;
      }
      var closeBraceToken = (SyntaxToken)reader.ReadValue();
      if (closeBraceToken != null)
      {
         AdjustFlagsAndWidth(closeBraceToken);
         this.closeBraceToken = closeBraceToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.openBraceToken);
      writer.WriteValue(this.subpatterns);
      writer.WriteValue(this.closeBraceToken);
    }

    static PropertyPatternClauseSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(PropertyPatternClauseSyntax), r => new PropertyPatternClauseSyntax(r));
    }
  }

  internal sealed partial class SubpatternSyntax : CSharpSyntaxNode
  {
    internal readonly NameColonSyntax nameColon;
    internal readonly PatternSyntax pattern;

    internal SubpatternSyntax(SyntaxKind kind, NameColonSyntax nameColon, PatternSyntax pattern, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        if (nameColon != null)
        {
            this.AdjustFlagsAndWidth(nameColon);
            this.nameColon = nameColon;
        }
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
    }


    internal SubpatternSyntax(SyntaxKind kind, NameColonSyntax nameColon, PatternSyntax pattern, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        if (nameColon != null)
        {
            this.AdjustFlagsAndWidth(nameColon);
            this.nameColon = nameColon;
        }
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
    }


    internal SubpatternSyntax(SyntaxKind kind, NameColonSyntax nameColon, PatternSyntax pattern)
        : base(kind)
    {
        this.SlotCount = 2;
        if (nameColon != null)
        {
            this.AdjustFlagsAndWidth(nameColon);
            this.nameColon = nameColon;
        }
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
    }

    public NameColonSyntax NameColon => this.nameColon;
    public PatternSyntax Pattern => this.pattern;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.nameColon;
            case 1: return this.pattern;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.SubpatternSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitSubpattern(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitSubpattern(this);

    public SubpatternSyntax Update(NameColonSyntax nameColon, PatternSyntax pattern)
    {
        if (nameColon != this.NameColon || pattern != this.Pattern)
        {
            var newNode = SyntaxFactory.Subpattern(nameColon, pattern);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new SubpatternSyntax(this.Kind, this.nameColon, this.pattern, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new SubpatternSyntax(this.Kind, this.nameColon, this.pattern, GetDiagnostics(), annotations);

    internal SubpatternSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var nameColon = (NameColonSyntax)reader.ReadValue();
      if (nameColon != null)
      {
         AdjustFlagsAndWidth(nameColon);
         this.nameColon = nameColon;
      }
      var pattern = (PatternSyntax)reader.ReadValue();
      if (pattern != null)
      {
         AdjustFlagsAndWidth(pattern);
         this.pattern = pattern;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.nameColon);
      writer.WriteValue(this.pattern);
    }

    static SubpatternSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(SubpatternSyntax), r => new SubpatternSyntax(r));
    }
  }

  internal sealed partial class ConstantPatternSyntax : PatternSyntax
  {
    internal readonly ExpressionSyntax expression;

    internal ConstantPatternSyntax(SyntaxKind kind, ExpressionSyntax expression, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }


    internal ConstantPatternSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }


    internal ConstantPatternSyntax(SyntaxKind kind, ExpressionSyntax expression)
        : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    /// <summary>ExpressionSyntax node representing the constant expression.</summary>
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.expression;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ConstantPatternSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitConstantPattern(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitConstantPattern(this);

    public ConstantPatternSyntax Update(ExpressionSyntax expression)
    {
        if (expression != this.Expression)
        {
            var newNode = SyntaxFactory.ConstantPattern(expression);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ConstantPatternSyntax(this.Kind, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ConstantPatternSyntax(this.Kind, this.expression, GetDiagnostics(), annotations);

    internal ConstantPatternSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 1;
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.expression);
    }

    static ConstantPatternSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ConstantPatternSyntax), r => new ConstantPatternSyntax(r));
    }
  }

  internal abstract partial class InterpolatedStringContentSyntax : CSharpSyntaxNode
  {
    internal InterpolatedStringContentSyntax(SyntaxKind kind, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal InterpolatedStringContentSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    protected InterpolatedStringContentSyntax(ObjectReader reader)
       : base(reader)
    {
    }
  }

  internal sealed partial class InterpolatedStringTextSyntax : InterpolatedStringContentSyntax
  {
    internal readonly SyntaxToken textToken;

    internal InterpolatedStringTextSyntax(SyntaxKind kind, SyntaxToken textToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(textToken);
        this.textToken = textToken;
    }


    internal InterpolatedStringTextSyntax(SyntaxKind kind, SyntaxToken textToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(textToken);
        this.textToken = textToken;
    }


    internal InterpolatedStringTextSyntax(SyntaxKind kind, SyntaxToken textToken)
        : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(textToken);
        this.textToken = textToken;
    }

    /// <summary>The text contents of a part of the interpolated string.</summary>
    public SyntaxToken TextToken => this.textToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.textToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.InterpolatedStringTextSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitInterpolatedStringText(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitInterpolatedStringText(this);

    public InterpolatedStringTextSyntax Update(SyntaxToken textToken)
    {
        if (textToken != this.TextToken)
        {
            var newNode = SyntaxFactory.InterpolatedStringText(textToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new InterpolatedStringTextSyntax(this.Kind, this.textToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new InterpolatedStringTextSyntax(this.Kind, this.textToken, GetDiagnostics(), annotations);

    internal InterpolatedStringTextSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 1;
      var textToken = (SyntaxToken)reader.ReadValue();
      if (textToken != null)
      {
         AdjustFlagsAndWidth(textToken);
         this.textToken = textToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.textToken);
    }

    static InterpolatedStringTextSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(InterpolatedStringTextSyntax), r => new InterpolatedStringTextSyntax(r));
    }
  }

  internal sealed partial class InterpolationSyntax : InterpolatedStringContentSyntax
  {
    internal readonly SyntaxToken openBraceToken;
    internal readonly ExpressionSyntax expression;
    internal readonly InterpolationAlignmentClauseSyntax alignmentClause;
    internal readonly InterpolationFormatClauseSyntax formatClause;
    internal readonly SyntaxToken closeBraceToken;

    internal InterpolationSyntax(SyntaxKind kind, SyntaxToken openBraceToken, ExpressionSyntax expression, InterpolationAlignmentClauseSyntax alignmentClause, InterpolationFormatClauseSyntax formatClause, SyntaxToken closeBraceToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        if (alignmentClause != null)
        {
            this.AdjustFlagsAndWidth(alignmentClause);
            this.alignmentClause = alignmentClause;
        }
        if (formatClause != null)
        {
            this.AdjustFlagsAndWidth(formatClause);
            this.formatClause = formatClause;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }


    internal InterpolationSyntax(SyntaxKind kind, SyntaxToken openBraceToken, ExpressionSyntax expression, InterpolationAlignmentClauseSyntax alignmentClause, InterpolationFormatClauseSyntax formatClause, SyntaxToken closeBraceToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        if (alignmentClause != null)
        {
            this.AdjustFlagsAndWidth(alignmentClause);
            this.alignmentClause = alignmentClause;
        }
        if (formatClause != null)
        {
            this.AdjustFlagsAndWidth(formatClause);
            this.formatClause = formatClause;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }


    internal InterpolationSyntax(SyntaxKind kind, SyntaxToken openBraceToken, ExpressionSyntax expression, InterpolationAlignmentClauseSyntax alignmentClause, InterpolationFormatClauseSyntax formatClause, SyntaxToken closeBraceToken)
        : base(kind)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        if (alignmentClause != null)
        {
            this.AdjustFlagsAndWidth(alignmentClause);
            this.alignmentClause = alignmentClause;
        }
        if (formatClause != null)
        {
            this.AdjustFlagsAndWidth(formatClause);
            this.formatClause = formatClause;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    public SyntaxToken OpenBraceToken => this.openBraceToken;
    public ExpressionSyntax Expression => this.expression;
    public InterpolationAlignmentClauseSyntax AlignmentClause => this.alignmentClause;
    public InterpolationFormatClauseSyntax FormatClause => this.formatClause;
    public SyntaxToken CloseBraceToken => this.closeBraceToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.openBraceToken;
            case 1: return this.expression;
            case 2: return this.alignmentClause;
            case 3: return this.formatClause;
            case 4: return this.closeBraceToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.InterpolationSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitInterpolation(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitInterpolation(this);

    public InterpolationSyntax Update(SyntaxToken openBraceToken, ExpressionSyntax expression, InterpolationAlignmentClauseSyntax alignmentClause, InterpolationFormatClauseSyntax formatClause, SyntaxToken closeBraceToken)
    {
        if (openBraceToken != this.OpenBraceToken || expression != this.Expression || alignmentClause != this.AlignmentClause || formatClause != this.FormatClause || closeBraceToken != this.CloseBraceToken)
        {
            var newNode = SyntaxFactory.Interpolation(openBraceToken, expression, alignmentClause, formatClause, closeBraceToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new InterpolationSyntax(this.Kind, this.openBraceToken, this.expression, this.alignmentClause, this.formatClause, this.closeBraceToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new InterpolationSyntax(this.Kind, this.openBraceToken, this.expression, this.alignmentClause, this.formatClause, this.closeBraceToken, GetDiagnostics(), annotations);

    internal InterpolationSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 5;
      var openBraceToken = (SyntaxToken)reader.ReadValue();
      if (openBraceToken != null)
      {
         AdjustFlagsAndWidth(openBraceToken);
         this.openBraceToken = openBraceToken;
      }
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
      var alignmentClause = (InterpolationAlignmentClauseSyntax)reader.ReadValue();
      if (alignmentClause != null)
      {
         AdjustFlagsAndWidth(alignmentClause);
         this.alignmentClause = alignmentClause;
      }
      var formatClause = (InterpolationFormatClauseSyntax)reader.ReadValue();
      if (formatClause != null)
      {
         AdjustFlagsAndWidth(formatClause);
         this.formatClause = formatClause;
      }
      var closeBraceToken = (SyntaxToken)reader.ReadValue();
      if (closeBraceToken != null)
      {
         AdjustFlagsAndWidth(closeBraceToken);
         this.closeBraceToken = closeBraceToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.openBraceToken);
      writer.WriteValue(this.expression);
      writer.WriteValue(this.alignmentClause);
      writer.WriteValue(this.formatClause);
      writer.WriteValue(this.closeBraceToken);
    }

    static InterpolationSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(InterpolationSyntax), r => new InterpolationSyntax(r));
    }
  }

  internal sealed partial class InterpolationAlignmentClauseSyntax : CSharpSyntaxNode
  {
    internal readonly SyntaxToken commaToken;
    internal readonly ExpressionSyntax value;

    internal InterpolationAlignmentClauseSyntax(SyntaxKind kind, SyntaxToken commaToken, ExpressionSyntax value, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(commaToken);
        this.commaToken = commaToken;
        this.AdjustFlagsAndWidth(value);
        this.value = value;
    }


    internal InterpolationAlignmentClauseSyntax(SyntaxKind kind, SyntaxToken commaToken, ExpressionSyntax value, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(commaToken);
        this.commaToken = commaToken;
        this.AdjustFlagsAndWidth(value);
        this.value = value;
    }


    internal InterpolationAlignmentClauseSyntax(SyntaxKind kind, SyntaxToken commaToken, ExpressionSyntax value)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(commaToken);
        this.commaToken = commaToken;
        this.AdjustFlagsAndWidth(value);
        this.value = value;
    }

    public SyntaxToken CommaToken => this.commaToken;
    public ExpressionSyntax Value => this.value;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.commaToken;
            case 1: return this.value;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.InterpolationAlignmentClauseSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitInterpolationAlignmentClause(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitInterpolationAlignmentClause(this);

    public InterpolationAlignmentClauseSyntax Update(SyntaxToken commaToken, ExpressionSyntax value)
    {
        if (commaToken != this.CommaToken || value != this.Value)
        {
            var newNode = SyntaxFactory.InterpolationAlignmentClause(commaToken, value);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new InterpolationAlignmentClauseSyntax(this.Kind, this.commaToken, this.value, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new InterpolationAlignmentClauseSyntax(this.Kind, this.commaToken, this.value, GetDiagnostics(), annotations);

    internal InterpolationAlignmentClauseSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var commaToken = (SyntaxToken)reader.ReadValue();
      if (commaToken != null)
      {
         AdjustFlagsAndWidth(commaToken);
         this.commaToken = commaToken;
      }
      var value = (ExpressionSyntax)reader.ReadValue();
      if (value != null)
      {
         AdjustFlagsAndWidth(value);
         this.value = value;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.commaToken);
      writer.WriteValue(this.value);
    }

    static InterpolationAlignmentClauseSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(InterpolationAlignmentClauseSyntax), r => new InterpolationAlignmentClauseSyntax(r));
    }
  }

  internal sealed partial class InterpolationFormatClauseSyntax : CSharpSyntaxNode
  {
    internal readonly SyntaxToken colonToken;
    internal readonly SyntaxToken formatStringToken;

    internal InterpolationFormatClauseSyntax(SyntaxKind kind, SyntaxToken colonToken, SyntaxToken formatStringToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        this.AdjustFlagsAndWidth(formatStringToken);
        this.formatStringToken = formatStringToken;
    }


    internal InterpolationFormatClauseSyntax(SyntaxKind kind, SyntaxToken colonToken, SyntaxToken formatStringToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        this.AdjustFlagsAndWidth(formatStringToken);
        this.formatStringToken = formatStringToken;
    }


    internal InterpolationFormatClauseSyntax(SyntaxKind kind, SyntaxToken colonToken, SyntaxToken formatStringToken)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        this.AdjustFlagsAndWidth(formatStringToken);
        this.formatStringToken = formatStringToken;
    }

    public SyntaxToken ColonToken => this.colonToken;
    /// <summary>The text contents of the format specifier for an interpolation.</summary>
    public SyntaxToken FormatStringToken => this.formatStringToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.colonToken;
            case 1: return this.formatStringToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.InterpolationFormatClauseSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitInterpolationFormatClause(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitInterpolationFormatClause(this);

    public InterpolationFormatClauseSyntax Update(SyntaxToken colonToken, SyntaxToken formatStringToken)
    {
        if (colonToken != this.ColonToken || formatStringToken != this.FormatStringToken)
        {
            var newNode = SyntaxFactory.InterpolationFormatClause(colonToken, formatStringToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new InterpolationFormatClauseSyntax(this.Kind, this.colonToken, this.formatStringToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new InterpolationFormatClauseSyntax(this.Kind, this.colonToken, this.formatStringToken, GetDiagnostics(), annotations);

    internal InterpolationFormatClauseSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var colonToken = (SyntaxToken)reader.ReadValue();
      if (colonToken != null)
      {
         AdjustFlagsAndWidth(colonToken);
         this.colonToken = colonToken;
      }
      var formatStringToken = (SyntaxToken)reader.ReadValue();
      if (formatStringToken != null)
      {
         AdjustFlagsAndWidth(formatStringToken);
         this.formatStringToken = formatStringToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.colonToken);
      writer.WriteValue(this.formatStringToken);
    }

    static InterpolationFormatClauseSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(InterpolationFormatClauseSyntax), r => new InterpolationFormatClauseSyntax(r));
    }
  }

  internal sealed partial class GlobalStatementSyntax : MemberDeclarationSyntax
  {
    internal readonly GreenNode attributeLists;
    internal readonly GreenNode modifiers;
    internal readonly StatementSyntax statement;

    internal GlobalStatementSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, StatementSyntax statement, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }


    internal GlobalStatementSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, StatementSyntax statement, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }


    internal GlobalStatementSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, StatementSyntax statement)
        : base(kind)
    {
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> Modifiers => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    public StatementSyntax Statement => this.statement;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 1: return this.modifiers;
            case 2: return this.statement;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.GlobalStatementSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitGlobalStatement(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitGlobalStatement(this);

    public GlobalStatementSyntax Update(Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> attributeLists, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> modifiers, StatementSyntax statement)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || statement != this.Statement)
        {
            var newNode = SyntaxFactory.GlobalStatement(attributeLists, modifiers, statement);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new GlobalStatementSyntax(this.Kind, this.attributeLists, this.modifiers, this.statement, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new GlobalStatementSyntax(this.Kind, this.attributeLists, this.modifiers, this.statement, GetDiagnostics(), annotations);

    internal GlobalStatementSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var attributeLists = (GreenNode)reader.ReadValue();
      if (attributeLists != null)
      {
         AdjustFlagsAndWidth(attributeLists);
         this.attributeLists = attributeLists;
      }
      var modifiers = (GreenNode)reader.ReadValue();
      if (modifiers != null)
      {
         AdjustFlagsAndWidth(modifiers);
         this.modifiers = modifiers;
      }
      var statement = (StatementSyntax)reader.ReadValue();
      if (statement != null)
      {
         AdjustFlagsAndWidth(statement);
         this.statement = statement;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.attributeLists);
      writer.WriteValue(this.modifiers);
      writer.WriteValue(this.statement);
    }

    static GlobalStatementSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(GlobalStatementSyntax), r => new GlobalStatementSyntax(r));
    }
  }

  /// <summary>Represents the base class for all statements syntax classes.</summary>
  internal abstract partial class StatementSyntax : CSharpSyntaxNode
  {
    internal StatementSyntax(SyntaxKind kind, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal StatementSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    protected StatementSyntax(ObjectReader reader)
       : base(reader)
    {
    }
  }

  internal sealed partial class BlockSyntax : StatementSyntax
  {
    internal readonly SyntaxToken openBraceToken;
    internal readonly GreenNode statements;
    internal readonly SyntaxToken closeBraceToken;

    internal BlockSyntax(SyntaxKind kind, SyntaxToken openBraceToken, GreenNode statements, SyntaxToken closeBraceToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (statements != null)
        {
            this.AdjustFlagsAndWidth(statements);
            this.statements = statements;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }


    internal BlockSyntax(SyntaxKind kind, SyntaxToken openBraceToken, GreenNode statements, SyntaxToken closeBraceToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (statements != null)
        {
            this.AdjustFlagsAndWidth(statements);
            this.statements = statements;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }


    internal BlockSyntax(SyntaxKind kind, SyntaxToken openBraceToken, GreenNode statements, SyntaxToken closeBraceToken)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (statements != null)
        {
            this.AdjustFlagsAndWidth(statements);
            this.statements = statements;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    public SyntaxToken OpenBraceToken => this.openBraceToken;
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<StatementSyntax> Statements => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<StatementSyntax>(this.statements);
    public SyntaxToken CloseBraceToken => this.closeBraceToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.openBraceToken;
            case 1: return this.statements;
            case 2: return this.closeBraceToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.BlockSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitBlock(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitBlock(this);

    public BlockSyntax Update(SyntaxToken openBraceToken, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<StatementSyntax> statements, SyntaxToken closeBraceToken)
    {
        if (openBraceToken != this.OpenBraceToken || statements != this.Statements || closeBraceToken != this.CloseBraceToken)
        {
            var newNode = SyntaxFactory.Block(openBraceToken, statements, closeBraceToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new BlockSyntax(this.Kind, this.openBraceToken, this.statements, this.closeBraceToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new BlockSyntax(this.Kind, this.openBraceToken, this.statements, this.closeBraceToken, GetDiagnostics(), annotations);

    internal BlockSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var openBraceToken = (SyntaxToken)reader.ReadValue();
      if (openBraceToken != null)
      {
         AdjustFlagsAndWidth(openBraceToken);
         this.openBraceToken = openBraceToken;
      }
      var statements = (GreenNode)reader.ReadValue();
      if (statements != null)
      {
         AdjustFlagsAndWidth(statements);
         this.statements = statements;
      }
      var closeBraceToken = (SyntaxToken)reader.ReadValue();
      if (closeBraceToken != null)
      {
         AdjustFlagsAndWidth(closeBraceToken);
         this.closeBraceToken = closeBraceToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.openBraceToken);
      writer.WriteValue(this.statements);
      writer.WriteValue(this.closeBraceToken);
    }

    static BlockSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(BlockSyntax), r => new BlockSyntax(r));
    }
  }

  internal sealed partial class LocalFunctionStatementSyntax : StatementSyntax
  {
    internal readonly GreenNode modifiers;
    internal readonly TypeSyntax returnType;
    internal readonly SyntaxToken identifier;
    internal readonly TypeParameterListSyntax typeParameterList;
    internal readonly ParameterListSyntax parameterList;
    internal readonly GreenNode constraintClauses;
    internal readonly BlockSyntax body;
    internal readonly ArrowExpressionClauseSyntax expressionBody;
    internal readonly SyntaxToken semicolonToken;

    internal LocalFunctionStatementSyntax(SyntaxKind kind, GreenNode modifiers, TypeSyntax returnType, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, ParameterListSyntax parameterList, GreenNode constraintClauses, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 9;
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(returnType);
        this.returnType = returnType;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }


    internal LocalFunctionStatementSyntax(SyntaxKind kind, GreenNode modifiers, TypeSyntax returnType, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, ParameterListSyntax parameterList, GreenNode constraintClauses, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 9;
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(returnType);
        this.returnType = returnType;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }


    internal LocalFunctionStatementSyntax(SyntaxKind kind, GreenNode modifiers, TypeSyntax returnType, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, ParameterListSyntax parameterList, GreenNode constraintClauses, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 9;
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(returnType);
        this.returnType = returnType;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> Modifiers => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    public TypeSyntax ReturnType => this.returnType;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public TypeParameterListSyntax TypeParameterList => this.typeParameterList;
    public ParameterListSyntax ParameterList => this.parameterList;
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> ConstraintClauses => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<TypeParameterConstraintClauseSyntax>(this.constraintClauses);
    public BlockSyntax Body => this.body;
    public ArrowExpressionClauseSyntax ExpressionBody => this.expressionBody;
    /// <summary>Gets the optional semicolon token.</summary>
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.modifiers;
            case 1: return this.returnType;
            case 2: return this.identifier;
            case 3: return this.typeParameterList;
            case 4: return this.parameterList;
            case 5: return this.constraintClauses;
            case 6: return this.body;
            case 7: return this.expressionBody;
            case 8: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.LocalFunctionStatementSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitLocalFunctionStatement(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitLocalFunctionStatement(this);

    public LocalFunctionStatementSyntax Update(Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> modifiers, TypeSyntax returnType, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, ParameterListSyntax parameterList, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> constraintClauses, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
    {
        if (modifiers != this.Modifiers || returnType != this.ReturnType || identifier != this.Identifier || typeParameterList != this.TypeParameterList || parameterList != this.ParameterList || constraintClauses != this.ConstraintClauses || body != this.Body || expressionBody != this.ExpressionBody || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.LocalFunctionStatement(modifiers, returnType, identifier, typeParameterList, parameterList, constraintClauses, body, expressionBody, semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new LocalFunctionStatementSyntax(this.Kind, this.modifiers, this.returnType, this.identifier, this.typeParameterList, this.parameterList, this.constraintClauses, this.body, this.expressionBody, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new LocalFunctionStatementSyntax(this.Kind, this.modifiers, this.returnType, this.identifier, this.typeParameterList, this.parameterList, this.constraintClauses, this.body, this.expressionBody, this.semicolonToken, GetDiagnostics(), annotations);

    internal LocalFunctionStatementSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 9;
      var modifiers = (GreenNode)reader.ReadValue();
      if (modifiers != null)
      {
         AdjustFlagsAndWidth(modifiers);
         this.modifiers = modifiers;
      }
      var returnType = (TypeSyntax)reader.ReadValue();
      if (returnType != null)
      {
         AdjustFlagsAndWidth(returnType);
         this.returnType = returnType;
      }
      var identifier = (SyntaxToken)reader.ReadValue();
      if (identifier != null)
      {
         AdjustFlagsAndWidth(identifier);
         this.identifier = identifier;
      }
      var typeParameterList = (TypeParameterListSyntax)reader.ReadValue();
      if (typeParameterList != null)
      {
         AdjustFlagsAndWidth(typeParameterList);
         this.typeParameterList = typeParameterList;
      }
      var parameterList = (ParameterListSyntax)reader.ReadValue();
      if (parameterList != null)
      {
         AdjustFlagsAndWidth(parameterList);
         this.parameterList = parameterList;
      }
      var constraintClauses = (GreenNode)reader.ReadValue();
      if (constraintClauses != null)
      {
         AdjustFlagsAndWidth(constraintClauses);
         this.constraintClauses = constraintClauses;
      }
      var body = (BlockSyntax)reader.ReadValue();
      if (body != null)
      {
         AdjustFlagsAndWidth(body);
         this.body = body;
      }
      var expressionBody = (ArrowExpressionClauseSyntax)reader.ReadValue();
      if (expressionBody != null)
      {
         AdjustFlagsAndWidth(expressionBody);
         this.expressionBody = expressionBody;
      }
      var semicolonToken = (SyntaxToken)reader.ReadValue();
      if (semicolonToken != null)
      {
         AdjustFlagsAndWidth(semicolonToken);
         this.semicolonToken = semicolonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.modifiers);
      writer.WriteValue(this.returnType);
      writer.WriteValue(this.identifier);
      writer.WriteValue(this.typeParameterList);
      writer.WriteValue(this.parameterList);
      writer.WriteValue(this.constraintClauses);
      writer.WriteValue(this.body);
      writer.WriteValue(this.expressionBody);
      writer.WriteValue(this.semicolonToken);
    }

    static LocalFunctionStatementSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(LocalFunctionStatementSyntax), r => new LocalFunctionStatementSyntax(r));
    }
  }

  internal sealed partial class LocalDeclarationStatementSyntax : StatementSyntax
  {
    internal readonly SyntaxToken awaitKeyword;
    internal readonly SyntaxToken usingKeyword;
    internal readonly GreenNode modifiers;
    internal readonly VariableDeclarationSyntax declaration;
    internal readonly SyntaxToken semicolonToken;

    internal LocalDeclarationStatementSyntax(SyntaxKind kind, SyntaxToken awaitKeyword, SyntaxToken usingKeyword, GreenNode modifiers, VariableDeclarationSyntax declaration, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 5;
        if (awaitKeyword != null)
        {
            this.AdjustFlagsAndWidth(awaitKeyword);
            this.awaitKeyword = awaitKeyword;
        }
        if (usingKeyword != null)
        {
            this.AdjustFlagsAndWidth(usingKeyword);
            this.usingKeyword = usingKeyword;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(declaration);
        this.declaration = declaration;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal LocalDeclarationStatementSyntax(SyntaxKind kind, SyntaxToken awaitKeyword, SyntaxToken usingKeyword, GreenNode modifiers, VariableDeclarationSyntax declaration, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 5;
        if (awaitKeyword != null)
        {
            this.AdjustFlagsAndWidth(awaitKeyword);
            this.awaitKeyword = awaitKeyword;
        }
        if (usingKeyword != null)
        {
            this.AdjustFlagsAndWidth(usingKeyword);
            this.usingKeyword = usingKeyword;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(declaration);
        this.declaration = declaration;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal LocalDeclarationStatementSyntax(SyntaxKind kind, SyntaxToken awaitKeyword, SyntaxToken usingKeyword, GreenNode modifiers, VariableDeclarationSyntax declaration, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 5;
        if (awaitKeyword != null)
        {
            this.AdjustFlagsAndWidth(awaitKeyword);
            this.awaitKeyword = awaitKeyword;
        }
        if (usingKeyword != null)
        {
            this.AdjustFlagsAndWidth(usingKeyword);
            this.usingKeyword = usingKeyword;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(declaration);
        this.declaration = declaration;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    public SyntaxToken AwaitKeyword => this.awaitKeyword;
    public SyntaxToken UsingKeyword => this.usingKeyword;
    /// <summary>Gets the modifier list.</summary>
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> Modifiers => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    public VariableDeclarationSyntax Declaration => this.declaration;
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.awaitKeyword;
            case 1: return this.usingKeyword;
            case 2: return this.modifiers;
            case 3: return this.declaration;
            case 4: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.LocalDeclarationStatementSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitLocalDeclarationStatement(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitLocalDeclarationStatement(this);

    public LocalDeclarationStatementSyntax Update(SyntaxToken awaitKeyword, SyntaxToken usingKeyword, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> modifiers, VariableDeclarationSyntax declaration, SyntaxToken semicolonToken)
    {
        if (awaitKeyword != this.AwaitKeyword || usingKeyword != this.UsingKeyword || modifiers != this.Modifiers || declaration != this.Declaration || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.LocalDeclarationStatement(awaitKeyword, usingKeyword, modifiers, declaration, semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new LocalDeclarationStatementSyntax(this.Kind, this.awaitKeyword, this.usingKeyword, this.modifiers, this.declaration, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new LocalDeclarationStatementSyntax(this.Kind, this.awaitKeyword, this.usingKeyword, this.modifiers, this.declaration, this.semicolonToken, GetDiagnostics(), annotations);

    internal LocalDeclarationStatementSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 5;
      var awaitKeyword = (SyntaxToken)reader.ReadValue();
      if (awaitKeyword != null)
      {
         AdjustFlagsAndWidth(awaitKeyword);
         this.awaitKeyword = awaitKeyword;
      }
      var usingKeyword = (SyntaxToken)reader.ReadValue();
      if (usingKeyword != null)
      {
         AdjustFlagsAndWidth(usingKeyword);
         this.usingKeyword = usingKeyword;
      }
      var modifiers = (GreenNode)reader.ReadValue();
      if (modifiers != null)
      {
         AdjustFlagsAndWidth(modifiers);
         this.modifiers = modifiers;
      }
      var declaration = (VariableDeclarationSyntax)reader.ReadValue();
      if (declaration != null)
      {
         AdjustFlagsAndWidth(declaration);
         this.declaration = declaration;
      }
      var semicolonToken = (SyntaxToken)reader.ReadValue();
      if (semicolonToken != null)
      {
         AdjustFlagsAndWidth(semicolonToken);
         this.semicolonToken = semicolonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.awaitKeyword);
      writer.WriteValue(this.usingKeyword);
      writer.WriteValue(this.modifiers);
      writer.WriteValue(this.declaration);
      writer.WriteValue(this.semicolonToken);
    }

    static LocalDeclarationStatementSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(LocalDeclarationStatementSyntax), r => new LocalDeclarationStatementSyntax(r));
    }
  }

  internal sealed partial class VariableDeclarationSyntax : CSharpSyntaxNode
  {
    internal readonly TypeSyntax type;
    internal readonly GreenNode variables;

    internal VariableDeclarationSyntax(SyntaxKind kind, TypeSyntax type, GreenNode variables, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (variables != null)
        {
            this.AdjustFlagsAndWidth(variables);
            this.variables = variables;
        }
    }


    internal VariableDeclarationSyntax(SyntaxKind kind, TypeSyntax type, GreenNode variables, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (variables != null)
        {
            this.AdjustFlagsAndWidth(variables);
            this.variables = variables;
        }
    }


    internal VariableDeclarationSyntax(SyntaxKind kind, TypeSyntax type, GreenNode variables)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (variables != null)
        {
            this.AdjustFlagsAndWidth(variables);
            this.variables = variables;
        }
    }

    public TypeSyntax Type => this.type;
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<VariableDeclaratorSyntax> Variables => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<VariableDeclaratorSyntax>(new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<CSharpSyntaxNode>(this.variables));

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.type;
            case 1: return this.variables;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.VariableDeclarationSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitVariableDeclaration(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitVariableDeclaration(this);

    public VariableDeclarationSyntax Update(TypeSyntax type, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<VariableDeclaratorSyntax> variables)
    {
        if (type != this.Type || variables != this.Variables)
        {
            var newNode = SyntaxFactory.VariableDeclaration(type, variables);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new VariableDeclarationSyntax(this.Kind, this.type, this.variables, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new VariableDeclarationSyntax(this.Kind, this.type, this.variables, GetDiagnostics(), annotations);

    internal VariableDeclarationSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var type = (TypeSyntax)reader.ReadValue();
      if (type != null)
      {
         AdjustFlagsAndWidth(type);
         this.type = type;
      }
      var variables = (GreenNode)reader.ReadValue();
      if (variables != null)
      {
         AdjustFlagsAndWidth(variables);
         this.variables = variables;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.type);
      writer.WriteValue(this.variables);
    }

    static VariableDeclarationSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(VariableDeclarationSyntax), r => new VariableDeclarationSyntax(r));
    }
  }

  internal sealed partial class VariableDeclaratorSyntax : CSharpSyntaxNode
  {
    internal readonly SyntaxToken identifier;
    internal readonly BracketedArgumentListSyntax argumentList;
    internal readonly EqualsValueClauseSyntax initializer;

    internal VariableDeclaratorSyntax(SyntaxKind kind, SyntaxToken identifier, BracketedArgumentListSyntax argumentList, EqualsValueClauseSyntax initializer, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (argumentList != null)
        {
            this.AdjustFlagsAndWidth(argumentList);
            this.argumentList = argumentList;
        }
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
    }


    internal VariableDeclaratorSyntax(SyntaxKind kind, SyntaxToken identifier, BracketedArgumentListSyntax argumentList, EqualsValueClauseSyntax initializer, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (argumentList != null)
        {
            this.AdjustFlagsAndWidth(argumentList);
            this.argumentList = argumentList;
        }
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
    }


    internal VariableDeclaratorSyntax(SyntaxKind kind, SyntaxToken identifier, BracketedArgumentListSyntax argumentList, EqualsValueClauseSyntax initializer)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (argumentList != null)
        {
            this.AdjustFlagsAndWidth(argumentList);
            this.argumentList = argumentList;
        }
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
    }

    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public BracketedArgumentListSyntax ArgumentList => this.argumentList;
    public EqualsValueClauseSyntax Initializer => this.initializer;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.identifier;
            case 1: return this.argumentList;
            case 2: return this.initializer;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.VariableDeclaratorSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitVariableDeclarator(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitVariableDeclarator(this);

    public VariableDeclaratorSyntax Update(SyntaxToken identifier, BracketedArgumentListSyntax argumentList, EqualsValueClauseSyntax initializer)
    {
        if (identifier != this.Identifier || argumentList != this.ArgumentList || initializer != this.Initializer)
        {
            var newNode = SyntaxFactory.VariableDeclarator(identifier, argumentList, initializer);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new VariableDeclaratorSyntax(this.Kind, this.identifier, this.argumentList, this.initializer, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new VariableDeclaratorSyntax(this.Kind, this.identifier, this.argumentList, this.initializer, GetDiagnostics(), annotations);

    internal VariableDeclaratorSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var identifier = (SyntaxToken)reader.ReadValue();
      if (identifier != null)
      {
         AdjustFlagsAndWidth(identifier);
         this.identifier = identifier;
      }
      var argumentList = (BracketedArgumentListSyntax)reader.ReadValue();
      if (argumentList != null)
      {
         AdjustFlagsAndWidth(argumentList);
         this.argumentList = argumentList;
      }
      var initializer = (EqualsValueClauseSyntax)reader.ReadValue();
      if (initializer != null)
      {
         AdjustFlagsAndWidth(initializer);
         this.initializer = initializer;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.identifier);
      writer.WriteValue(this.argumentList);
      writer.WriteValue(this.initializer);
    }

    static VariableDeclaratorSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(VariableDeclaratorSyntax), r => new VariableDeclaratorSyntax(r));
    }
  }

  internal sealed partial class EqualsValueClauseSyntax : CSharpSyntaxNode
  {
    internal readonly SyntaxToken equalsToken;
    internal readonly ExpressionSyntax value;

    internal EqualsValueClauseSyntax(SyntaxKind kind, SyntaxToken equalsToken, ExpressionSyntax value, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(equalsToken);
        this.equalsToken = equalsToken;
        this.AdjustFlagsAndWidth(value);
        this.value = value;
    }


    internal EqualsValueClauseSyntax(SyntaxKind kind, SyntaxToken equalsToken, ExpressionSyntax value, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(equalsToken);
        this.equalsToken = equalsToken;
        this.AdjustFlagsAndWidth(value);
        this.value = value;
    }


    internal EqualsValueClauseSyntax(SyntaxKind kind, SyntaxToken equalsToken, ExpressionSyntax value)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(equalsToken);
        this.equalsToken = equalsToken;
        this.AdjustFlagsAndWidth(value);
        this.value = value;
    }

    public SyntaxToken EqualsToken => this.equalsToken;
    public ExpressionSyntax Value => this.value;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.equalsToken;
            case 1: return this.value;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.EqualsValueClauseSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitEqualsValueClause(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitEqualsValueClause(this);

    public EqualsValueClauseSyntax Update(SyntaxToken equalsToken, ExpressionSyntax value)
    {
        if (equalsToken != this.EqualsToken || value != this.Value)
        {
            var newNode = SyntaxFactory.EqualsValueClause(equalsToken, value);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new EqualsValueClauseSyntax(this.Kind, this.equalsToken, this.value, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new EqualsValueClauseSyntax(this.Kind, this.equalsToken, this.value, GetDiagnostics(), annotations);

    internal EqualsValueClauseSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var equalsToken = (SyntaxToken)reader.ReadValue();
      if (equalsToken != null)
      {
         AdjustFlagsAndWidth(equalsToken);
         this.equalsToken = equalsToken;
      }
      var value = (ExpressionSyntax)reader.ReadValue();
      if (value != null)
      {
         AdjustFlagsAndWidth(value);
         this.value = value;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.equalsToken);
      writer.WriteValue(this.value);
    }

    static EqualsValueClauseSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(EqualsValueClauseSyntax), r => new EqualsValueClauseSyntax(r));
    }
  }

  internal abstract partial class VariableDesignationSyntax : CSharpSyntaxNode
  {
    internal VariableDesignationSyntax(SyntaxKind kind, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal VariableDesignationSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    protected VariableDesignationSyntax(ObjectReader reader)
       : base(reader)
    {
    }
  }

  internal sealed partial class SingleVariableDesignationSyntax : VariableDesignationSyntax
  {
    internal readonly SyntaxToken identifier;

    internal SingleVariableDesignationSyntax(SyntaxKind kind, SyntaxToken identifier, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
    }


    internal SingleVariableDesignationSyntax(SyntaxKind kind, SyntaxToken identifier, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
    }


    internal SingleVariableDesignationSyntax(SyntaxKind kind, SyntaxToken identifier)
        : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
    }

    public SyntaxToken Identifier => this.identifier;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.identifier;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.SingleVariableDesignationSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitSingleVariableDesignation(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitSingleVariableDesignation(this);

    public SingleVariableDesignationSyntax Update(SyntaxToken identifier)
    {
        if (identifier != this.Identifier)
        {
            var newNode = SyntaxFactory.SingleVariableDesignation(identifier);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new SingleVariableDesignationSyntax(this.Kind, this.identifier, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new SingleVariableDesignationSyntax(this.Kind, this.identifier, GetDiagnostics(), annotations);

    internal SingleVariableDesignationSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 1;
      var identifier = (SyntaxToken)reader.ReadValue();
      if (identifier != null)
      {
         AdjustFlagsAndWidth(identifier);
         this.identifier = identifier;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.identifier);
    }

    static SingleVariableDesignationSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(SingleVariableDesignationSyntax), r => new SingleVariableDesignationSyntax(r));
    }
  }

  internal sealed partial class DiscardDesignationSyntax : VariableDesignationSyntax
  {
    internal readonly SyntaxToken underscoreToken;

    internal DiscardDesignationSyntax(SyntaxKind kind, SyntaxToken underscoreToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(underscoreToken);
        this.underscoreToken = underscoreToken;
    }


    internal DiscardDesignationSyntax(SyntaxKind kind, SyntaxToken underscoreToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(underscoreToken);
        this.underscoreToken = underscoreToken;
    }


    internal DiscardDesignationSyntax(SyntaxKind kind, SyntaxToken underscoreToken)
        : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(underscoreToken);
        this.underscoreToken = underscoreToken;
    }

    public SyntaxToken UnderscoreToken => this.underscoreToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.underscoreToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.DiscardDesignationSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitDiscardDesignation(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitDiscardDesignation(this);

    public DiscardDesignationSyntax Update(SyntaxToken underscoreToken)
    {
        if (underscoreToken != this.UnderscoreToken)
        {
            var newNode = SyntaxFactory.DiscardDesignation(underscoreToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new DiscardDesignationSyntax(this.Kind, this.underscoreToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new DiscardDesignationSyntax(this.Kind, this.underscoreToken, GetDiagnostics(), annotations);

    internal DiscardDesignationSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 1;
      var underscoreToken = (SyntaxToken)reader.ReadValue();
      if (underscoreToken != null)
      {
         AdjustFlagsAndWidth(underscoreToken);
         this.underscoreToken = underscoreToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.underscoreToken);
    }

    static DiscardDesignationSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(DiscardDesignationSyntax), r => new DiscardDesignationSyntax(r));
    }
  }

  internal sealed partial class ParenthesizedVariableDesignationSyntax : VariableDesignationSyntax
  {
    internal readonly SyntaxToken openParenToken;
    internal readonly GreenNode variables;
    internal readonly SyntaxToken closeParenToken;

    internal ParenthesizedVariableDesignationSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode variables, SyntaxToken closeParenToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (variables != null)
        {
            this.AdjustFlagsAndWidth(variables);
            this.variables = variables;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal ParenthesizedVariableDesignationSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode variables, SyntaxToken closeParenToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (variables != null)
        {
            this.AdjustFlagsAndWidth(variables);
            this.variables = variables;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal ParenthesizedVariableDesignationSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode variables, SyntaxToken closeParenToken)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (variables != null)
        {
            this.AdjustFlagsAndWidth(variables);
            this.variables = variables;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    public SyntaxToken OpenParenToken => this.openParenToken;
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<VariableDesignationSyntax> Variables => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<VariableDesignationSyntax>(new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<CSharpSyntaxNode>(this.variables));
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.openParenToken;
            case 1: return this.variables;
            case 2: return this.closeParenToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ParenthesizedVariableDesignationSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitParenthesizedVariableDesignation(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitParenthesizedVariableDesignation(this);

    public ParenthesizedVariableDesignationSyntax Update(SyntaxToken openParenToken, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<VariableDesignationSyntax> variables, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || variables != this.Variables || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.ParenthesizedVariableDesignation(openParenToken, variables, closeParenToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ParenthesizedVariableDesignationSyntax(this.Kind, this.openParenToken, this.variables, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ParenthesizedVariableDesignationSyntax(this.Kind, this.openParenToken, this.variables, this.closeParenToken, GetDiagnostics(), annotations);

    internal ParenthesizedVariableDesignationSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var variables = (GreenNode)reader.ReadValue();
      if (variables != null)
      {
         AdjustFlagsAndWidth(variables);
         this.variables = variables;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.variables);
      writer.WriteValue(this.closeParenToken);
    }

    static ParenthesizedVariableDesignationSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ParenthesizedVariableDesignationSyntax), r => new ParenthesizedVariableDesignationSyntax(r));
    }
  }

  internal sealed partial class ExpressionStatementSyntax : StatementSyntax
  {
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken semicolonToken;

    internal ExpressionStatementSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal ExpressionStatementSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal ExpressionStatementSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    public ExpressionSyntax Expression => this.expression;
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.expression;
            case 1: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ExpressionStatementSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitExpressionStatement(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitExpressionStatement(this);

    public ExpressionStatementSyntax Update(ExpressionSyntax expression, SyntaxToken semicolonToken)
    {
        if (expression != this.Expression || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.ExpressionStatement(expression, semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ExpressionStatementSyntax(this.Kind, this.expression, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ExpressionStatementSyntax(this.Kind, this.expression, this.semicolonToken, GetDiagnostics(), annotations);

    internal ExpressionStatementSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
      var semicolonToken = (SyntaxToken)reader.ReadValue();
      if (semicolonToken != null)
      {
         AdjustFlagsAndWidth(semicolonToken);
         this.semicolonToken = semicolonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.expression);
      writer.WriteValue(this.semicolonToken);
    }

    static ExpressionStatementSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ExpressionStatementSyntax), r => new ExpressionStatementSyntax(r));
    }
  }

  internal sealed partial class EmptyStatementSyntax : StatementSyntax
  {
    internal readonly SyntaxToken semicolonToken;

    internal EmptyStatementSyntax(SyntaxKind kind, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal EmptyStatementSyntax(SyntaxKind kind, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal EmptyStatementSyntax(SyntaxKind kind, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.EmptyStatementSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitEmptyStatement(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitEmptyStatement(this);

    public EmptyStatementSyntax Update(SyntaxToken semicolonToken)
    {
        if (semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.EmptyStatement(semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new EmptyStatementSyntax(this.Kind, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new EmptyStatementSyntax(this.Kind, this.semicolonToken, GetDiagnostics(), annotations);

    internal EmptyStatementSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 1;
      var semicolonToken = (SyntaxToken)reader.ReadValue();
      if (semicolonToken != null)
      {
         AdjustFlagsAndWidth(semicolonToken);
         this.semicolonToken = semicolonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.semicolonToken);
    }

    static EmptyStatementSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(EmptyStatementSyntax), r => new EmptyStatementSyntax(r));
    }
  }

  /// <summary>Represents a labeled statement syntax.</summary>
  internal sealed partial class LabeledStatementSyntax : StatementSyntax
  {
    internal readonly SyntaxToken identifier;
    internal readonly SyntaxToken colonToken;
    internal readonly StatementSyntax statement;

    internal LabeledStatementSyntax(SyntaxKind kind, SyntaxToken identifier, SyntaxToken colonToken, StatementSyntax statement, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }


    internal LabeledStatementSyntax(SyntaxKind kind, SyntaxToken identifier, SyntaxToken colonToken, StatementSyntax statement, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }


    internal LabeledStatementSyntax(SyntaxKind kind, SyntaxToken identifier, SyntaxToken colonToken, StatementSyntax statement)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    /// <summary>Gets a SyntaxToken that represents the colon following the statement's label.</summary>
    public SyntaxToken ColonToken => this.colonToken;
    public StatementSyntax Statement => this.statement;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.identifier;
            case 1: return this.colonToken;
            case 2: return this.statement;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.LabeledStatementSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitLabeledStatement(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitLabeledStatement(this);

    public LabeledStatementSyntax Update(SyntaxToken identifier, SyntaxToken colonToken, StatementSyntax statement)
    {
        if (identifier != this.Identifier || colonToken != this.ColonToken || statement != this.Statement)
        {
            var newNode = SyntaxFactory.LabeledStatement(identifier, colonToken, statement);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new LabeledStatementSyntax(this.Kind, this.identifier, this.colonToken, this.statement, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new LabeledStatementSyntax(this.Kind, this.identifier, this.colonToken, this.statement, GetDiagnostics(), annotations);

    internal LabeledStatementSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var identifier = (SyntaxToken)reader.ReadValue();
      if (identifier != null)
      {
         AdjustFlagsAndWidth(identifier);
         this.identifier = identifier;
      }
      var colonToken = (SyntaxToken)reader.ReadValue();
      if (colonToken != null)
      {
         AdjustFlagsAndWidth(colonToken);
         this.colonToken = colonToken;
      }
      var statement = (StatementSyntax)reader.ReadValue();
      if (statement != null)
      {
         AdjustFlagsAndWidth(statement);
         this.statement = statement;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.identifier);
      writer.WriteValue(this.colonToken);
      writer.WriteValue(this.statement);
    }

    static LabeledStatementSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(LabeledStatementSyntax), r => new LabeledStatementSyntax(r));
    }
  }

  /// <summary>
  /// Represents a goto statement syntax
  /// </summary>
  internal sealed partial class GotoStatementSyntax : StatementSyntax
  {
    internal readonly SyntaxToken gotoKeyword;
    internal readonly SyntaxToken caseOrDefaultKeyword;
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken semicolonToken;

    internal GotoStatementSyntax(SyntaxKind kind, SyntaxToken gotoKeyword, SyntaxToken caseOrDefaultKeyword, ExpressionSyntax expression, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(gotoKeyword);
        this.gotoKeyword = gotoKeyword;
        if (caseOrDefaultKeyword != null)
        {
            this.AdjustFlagsAndWidth(caseOrDefaultKeyword);
            this.caseOrDefaultKeyword = caseOrDefaultKeyword;
        }
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal GotoStatementSyntax(SyntaxKind kind, SyntaxToken gotoKeyword, SyntaxToken caseOrDefaultKeyword, ExpressionSyntax expression, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(gotoKeyword);
        this.gotoKeyword = gotoKeyword;
        if (caseOrDefaultKeyword != null)
        {
            this.AdjustFlagsAndWidth(caseOrDefaultKeyword);
            this.caseOrDefaultKeyword = caseOrDefaultKeyword;
        }
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal GotoStatementSyntax(SyntaxKind kind, SyntaxToken gotoKeyword, SyntaxToken caseOrDefaultKeyword, ExpressionSyntax expression, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(gotoKeyword);
        this.gotoKeyword = gotoKeyword;
        if (caseOrDefaultKeyword != null)
        {
            this.AdjustFlagsAndWidth(caseOrDefaultKeyword);
            this.caseOrDefaultKeyword = caseOrDefaultKeyword;
        }
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    /// <summary>
    /// Gets a SyntaxToken that represents the goto keyword.
    /// </summary>
    public SyntaxToken GotoKeyword => this.gotoKeyword;
    /// <summary>
    /// Gets a SyntaxToken that represents the case or default keywords if any exists.
    /// </summary>
    public SyntaxToken CaseOrDefaultKeyword => this.caseOrDefaultKeyword;
    /// <summary>
    /// Gets a constant expression for a goto case statement.
    /// </summary>
    public ExpressionSyntax Expression => this.expression;
    /// <summary>
    /// Gets a SyntaxToken that represents the semi-colon at the end of the statement.
    /// </summary>
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.gotoKeyword;
            case 1: return this.caseOrDefaultKeyword;
            case 2: return this.expression;
            case 3: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.GotoStatementSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitGotoStatement(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitGotoStatement(this);

    public GotoStatementSyntax Update(SyntaxToken gotoKeyword, SyntaxToken caseOrDefaultKeyword, ExpressionSyntax expression, SyntaxToken semicolonToken)
    {
        if (gotoKeyword != this.GotoKeyword || caseOrDefaultKeyword != this.CaseOrDefaultKeyword || expression != this.Expression || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.GotoStatement(this.Kind, gotoKeyword, caseOrDefaultKeyword, expression, semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new GotoStatementSyntax(this.Kind, this.gotoKeyword, this.caseOrDefaultKeyword, this.expression, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new GotoStatementSyntax(this.Kind, this.gotoKeyword, this.caseOrDefaultKeyword, this.expression, this.semicolonToken, GetDiagnostics(), annotations);

    internal GotoStatementSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var gotoKeyword = (SyntaxToken)reader.ReadValue();
      if (gotoKeyword != null)
      {
         AdjustFlagsAndWidth(gotoKeyword);
         this.gotoKeyword = gotoKeyword;
      }
      var caseOrDefaultKeyword = (SyntaxToken)reader.ReadValue();
      if (caseOrDefaultKeyword != null)
      {
         AdjustFlagsAndWidth(caseOrDefaultKeyword);
         this.caseOrDefaultKeyword = caseOrDefaultKeyword;
      }
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
      var semicolonToken = (SyntaxToken)reader.ReadValue();
      if (semicolonToken != null)
      {
         AdjustFlagsAndWidth(semicolonToken);
         this.semicolonToken = semicolonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.gotoKeyword);
      writer.WriteValue(this.caseOrDefaultKeyword);
      writer.WriteValue(this.expression);
      writer.WriteValue(this.semicolonToken);
    }

    static GotoStatementSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(GotoStatementSyntax), r => new GotoStatementSyntax(r));
    }
  }

  internal sealed partial class BreakStatementSyntax : StatementSyntax
  {
    internal readonly SyntaxToken breakKeyword;
    internal readonly SyntaxToken semicolonToken;

    internal BreakStatementSyntax(SyntaxKind kind, SyntaxToken breakKeyword, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(breakKeyword);
        this.breakKeyword = breakKeyword;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal BreakStatementSyntax(SyntaxKind kind, SyntaxToken breakKeyword, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(breakKeyword);
        this.breakKeyword = breakKeyword;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal BreakStatementSyntax(SyntaxKind kind, SyntaxToken breakKeyword, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(breakKeyword);
        this.breakKeyword = breakKeyword;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    public SyntaxToken BreakKeyword => this.breakKeyword;
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.breakKeyword;
            case 1: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.BreakStatementSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitBreakStatement(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitBreakStatement(this);

    public BreakStatementSyntax Update(SyntaxToken breakKeyword, SyntaxToken semicolonToken)
    {
        if (breakKeyword != this.BreakKeyword || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.BreakStatement(breakKeyword, semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new BreakStatementSyntax(this.Kind, this.breakKeyword, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new BreakStatementSyntax(this.Kind, this.breakKeyword, this.semicolonToken, GetDiagnostics(), annotations);

    internal BreakStatementSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var breakKeyword = (SyntaxToken)reader.ReadValue();
      if (breakKeyword != null)
      {
         AdjustFlagsAndWidth(breakKeyword);
         this.breakKeyword = breakKeyword;
      }
      var semicolonToken = (SyntaxToken)reader.ReadValue();
      if (semicolonToken != null)
      {
         AdjustFlagsAndWidth(semicolonToken);
         this.semicolonToken = semicolonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.breakKeyword);
      writer.WriteValue(this.semicolonToken);
    }

    static BreakStatementSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(BreakStatementSyntax), r => new BreakStatementSyntax(r));
    }
  }

  internal sealed partial class ContinueStatementSyntax : StatementSyntax
  {
    internal readonly SyntaxToken continueKeyword;
    internal readonly SyntaxToken semicolonToken;

    internal ContinueStatementSyntax(SyntaxKind kind, SyntaxToken continueKeyword, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(continueKeyword);
        this.continueKeyword = continueKeyword;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal ContinueStatementSyntax(SyntaxKind kind, SyntaxToken continueKeyword, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(continueKeyword);
        this.continueKeyword = continueKeyword;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal ContinueStatementSyntax(SyntaxKind kind, SyntaxToken continueKeyword, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(continueKeyword);
        this.continueKeyword = continueKeyword;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    public SyntaxToken ContinueKeyword => this.continueKeyword;
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.continueKeyword;
            case 1: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ContinueStatementSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitContinueStatement(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitContinueStatement(this);

    public ContinueStatementSyntax Update(SyntaxToken continueKeyword, SyntaxToken semicolonToken)
    {
        if (continueKeyword != this.ContinueKeyword || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.ContinueStatement(continueKeyword, semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ContinueStatementSyntax(this.Kind, this.continueKeyword, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ContinueStatementSyntax(this.Kind, this.continueKeyword, this.semicolonToken, GetDiagnostics(), annotations);

    internal ContinueStatementSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var continueKeyword = (SyntaxToken)reader.ReadValue();
      if (continueKeyword != null)
      {
         AdjustFlagsAndWidth(continueKeyword);
         this.continueKeyword = continueKeyword;
      }
      var semicolonToken = (SyntaxToken)reader.ReadValue();
      if (semicolonToken != null)
      {
         AdjustFlagsAndWidth(semicolonToken);
         this.semicolonToken = semicolonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.continueKeyword);
      writer.WriteValue(this.semicolonToken);
    }

    static ContinueStatementSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ContinueStatementSyntax), r => new ContinueStatementSyntax(r));
    }
  }

  internal sealed partial class ReturnStatementSyntax : StatementSyntax
  {
    internal readonly SyntaxToken returnKeyword;
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken semicolonToken;

    internal ReturnStatementSyntax(SyntaxKind kind, SyntaxToken returnKeyword, ExpressionSyntax expression, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(returnKeyword);
        this.returnKeyword = returnKeyword;
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal ReturnStatementSyntax(SyntaxKind kind, SyntaxToken returnKeyword, ExpressionSyntax expression, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(returnKeyword);
        this.returnKeyword = returnKeyword;
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal ReturnStatementSyntax(SyntaxKind kind, SyntaxToken returnKeyword, ExpressionSyntax expression, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(returnKeyword);
        this.returnKeyword = returnKeyword;
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    public SyntaxToken ReturnKeyword => this.returnKeyword;
    public ExpressionSyntax Expression => this.expression;
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.returnKeyword;
            case 1: return this.expression;
            case 2: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ReturnStatementSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitReturnStatement(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitReturnStatement(this);

    public ReturnStatementSyntax Update(SyntaxToken returnKeyword, ExpressionSyntax expression, SyntaxToken semicolonToken)
    {
        if (returnKeyword != this.ReturnKeyword || expression != this.Expression || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.ReturnStatement(returnKeyword, expression, semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ReturnStatementSyntax(this.Kind, this.returnKeyword, this.expression, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ReturnStatementSyntax(this.Kind, this.returnKeyword, this.expression, this.semicolonToken, GetDiagnostics(), annotations);

    internal ReturnStatementSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var returnKeyword = (SyntaxToken)reader.ReadValue();
      if (returnKeyword != null)
      {
         AdjustFlagsAndWidth(returnKeyword);
         this.returnKeyword = returnKeyword;
      }
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
      var semicolonToken = (SyntaxToken)reader.ReadValue();
      if (semicolonToken != null)
      {
         AdjustFlagsAndWidth(semicolonToken);
         this.semicolonToken = semicolonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.returnKeyword);
      writer.WriteValue(this.expression);
      writer.WriteValue(this.semicolonToken);
    }

    static ReturnStatementSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ReturnStatementSyntax), r => new ReturnStatementSyntax(r));
    }
  }

  internal sealed partial class ThrowStatementSyntax : StatementSyntax
  {
    internal readonly SyntaxToken throwKeyword;
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken semicolonToken;

    internal ThrowStatementSyntax(SyntaxKind kind, SyntaxToken throwKeyword, ExpressionSyntax expression, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(throwKeyword);
        this.throwKeyword = throwKeyword;
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal ThrowStatementSyntax(SyntaxKind kind, SyntaxToken throwKeyword, ExpressionSyntax expression, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(throwKeyword);
        this.throwKeyword = throwKeyword;
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal ThrowStatementSyntax(SyntaxKind kind, SyntaxToken throwKeyword, ExpressionSyntax expression, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(throwKeyword);
        this.throwKeyword = throwKeyword;
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    public SyntaxToken ThrowKeyword => this.throwKeyword;
    public ExpressionSyntax Expression => this.expression;
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.throwKeyword;
            case 1: return this.expression;
            case 2: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ThrowStatementSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitThrowStatement(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitThrowStatement(this);

    public ThrowStatementSyntax Update(SyntaxToken throwKeyword, ExpressionSyntax expression, SyntaxToken semicolonToken)
    {
        if (throwKeyword != this.ThrowKeyword || expression != this.Expression || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.ThrowStatement(throwKeyword, expression, semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ThrowStatementSyntax(this.Kind, this.throwKeyword, this.expression, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ThrowStatementSyntax(this.Kind, this.throwKeyword, this.expression, this.semicolonToken, GetDiagnostics(), annotations);

    internal ThrowStatementSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var throwKeyword = (SyntaxToken)reader.ReadValue();
      if (throwKeyword != null)
      {
         AdjustFlagsAndWidth(throwKeyword);
         this.throwKeyword = throwKeyword;
      }
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
      var semicolonToken = (SyntaxToken)reader.ReadValue();
      if (semicolonToken != null)
      {
         AdjustFlagsAndWidth(semicolonToken);
         this.semicolonToken = semicolonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.throwKeyword);
      writer.WriteValue(this.expression);
      writer.WriteValue(this.semicolonToken);
    }

    static ThrowStatementSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ThrowStatementSyntax), r => new ThrowStatementSyntax(r));
    }
  }

  internal sealed partial class YieldStatementSyntax : StatementSyntax
  {
    internal readonly SyntaxToken yieldKeyword;
    internal readonly SyntaxToken returnOrBreakKeyword;
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken semicolonToken;

    internal YieldStatementSyntax(SyntaxKind kind, SyntaxToken yieldKeyword, SyntaxToken returnOrBreakKeyword, ExpressionSyntax expression, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(yieldKeyword);
        this.yieldKeyword = yieldKeyword;
        this.AdjustFlagsAndWidth(returnOrBreakKeyword);
        this.returnOrBreakKeyword = returnOrBreakKeyword;
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal YieldStatementSyntax(SyntaxKind kind, SyntaxToken yieldKeyword, SyntaxToken returnOrBreakKeyword, ExpressionSyntax expression, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(yieldKeyword);
        this.yieldKeyword = yieldKeyword;
        this.AdjustFlagsAndWidth(returnOrBreakKeyword);
        this.returnOrBreakKeyword = returnOrBreakKeyword;
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal YieldStatementSyntax(SyntaxKind kind, SyntaxToken yieldKeyword, SyntaxToken returnOrBreakKeyword, ExpressionSyntax expression, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(yieldKeyword);
        this.yieldKeyword = yieldKeyword;
        this.AdjustFlagsAndWidth(returnOrBreakKeyword);
        this.returnOrBreakKeyword = returnOrBreakKeyword;
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    public SyntaxToken YieldKeyword => this.yieldKeyword;
    public SyntaxToken ReturnOrBreakKeyword => this.returnOrBreakKeyword;
    public ExpressionSyntax Expression => this.expression;
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.yieldKeyword;
            case 1: return this.returnOrBreakKeyword;
            case 2: return this.expression;
            case 3: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.YieldStatementSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitYieldStatement(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitYieldStatement(this);

    public YieldStatementSyntax Update(SyntaxToken yieldKeyword, SyntaxToken returnOrBreakKeyword, ExpressionSyntax expression, SyntaxToken semicolonToken)
    {
        if (yieldKeyword != this.YieldKeyword || returnOrBreakKeyword != this.ReturnOrBreakKeyword || expression != this.Expression || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.YieldStatement(this.Kind, yieldKeyword, returnOrBreakKeyword, expression, semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new YieldStatementSyntax(this.Kind, this.yieldKeyword, this.returnOrBreakKeyword, this.expression, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new YieldStatementSyntax(this.Kind, this.yieldKeyword, this.returnOrBreakKeyword, this.expression, this.semicolonToken, GetDiagnostics(), annotations);

    internal YieldStatementSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var yieldKeyword = (SyntaxToken)reader.ReadValue();
      if (yieldKeyword != null)
      {
         AdjustFlagsAndWidth(yieldKeyword);
         this.yieldKeyword = yieldKeyword;
      }
      var returnOrBreakKeyword = (SyntaxToken)reader.ReadValue();
      if (returnOrBreakKeyword != null)
      {
         AdjustFlagsAndWidth(returnOrBreakKeyword);
         this.returnOrBreakKeyword = returnOrBreakKeyword;
      }
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
      var semicolonToken = (SyntaxToken)reader.ReadValue();
      if (semicolonToken != null)
      {
         AdjustFlagsAndWidth(semicolonToken);
         this.semicolonToken = semicolonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.yieldKeyword);
      writer.WriteValue(this.returnOrBreakKeyword);
      writer.WriteValue(this.expression);
      writer.WriteValue(this.semicolonToken);
    }

    static YieldStatementSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(YieldStatementSyntax), r => new YieldStatementSyntax(r));
    }
  }

  internal sealed partial class WhileStatementSyntax : StatementSyntax
  {
    internal readonly SyntaxToken whileKeyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly ExpressionSyntax condition;
    internal readonly SyntaxToken closeParenToken;
    internal readonly StatementSyntax statement;

    internal WhileStatementSyntax(SyntaxKind kind, SyntaxToken whileKeyword, SyntaxToken openParenToken, ExpressionSyntax condition, SyntaxToken closeParenToken, StatementSyntax statement, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(whileKeyword);
        this.whileKeyword = whileKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }


    internal WhileStatementSyntax(SyntaxKind kind, SyntaxToken whileKeyword, SyntaxToken openParenToken, ExpressionSyntax condition, SyntaxToken closeParenToken, StatementSyntax statement, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(whileKeyword);
        this.whileKeyword = whileKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }


    internal WhileStatementSyntax(SyntaxKind kind, SyntaxToken whileKeyword, SyntaxToken openParenToken, ExpressionSyntax condition, SyntaxToken closeParenToken, StatementSyntax statement)
        : base(kind)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(whileKeyword);
        this.whileKeyword = whileKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    public SyntaxToken WhileKeyword => this.whileKeyword;
    public SyntaxToken OpenParenToken => this.openParenToken;
    public ExpressionSyntax Condition => this.condition;
    public SyntaxToken CloseParenToken => this.closeParenToken;
    public StatementSyntax Statement => this.statement;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.whileKeyword;
            case 1: return this.openParenToken;
            case 2: return this.condition;
            case 3: return this.closeParenToken;
            case 4: return this.statement;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.WhileStatementSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitWhileStatement(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitWhileStatement(this);

    public WhileStatementSyntax Update(SyntaxToken whileKeyword, SyntaxToken openParenToken, ExpressionSyntax condition, SyntaxToken closeParenToken, StatementSyntax statement)
    {
        if (whileKeyword != this.WhileKeyword || openParenToken != this.OpenParenToken || condition != this.Condition || closeParenToken != this.CloseParenToken || statement != this.Statement)
        {
            var newNode = SyntaxFactory.WhileStatement(whileKeyword, openParenToken, condition, closeParenToken, statement);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new WhileStatementSyntax(this.Kind, this.whileKeyword, this.openParenToken, this.condition, this.closeParenToken, this.statement, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new WhileStatementSyntax(this.Kind, this.whileKeyword, this.openParenToken, this.condition, this.closeParenToken, this.statement, GetDiagnostics(), annotations);

    internal WhileStatementSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 5;
      var whileKeyword = (SyntaxToken)reader.ReadValue();
      if (whileKeyword != null)
      {
         AdjustFlagsAndWidth(whileKeyword);
         this.whileKeyword = whileKeyword;
      }
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var condition = (ExpressionSyntax)reader.ReadValue();
      if (condition != null)
      {
         AdjustFlagsAndWidth(condition);
         this.condition = condition;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
      var statement = (StatementSyntax)reader.ReadValue();
      if (statement != null)
      {
         AdjustFlagsAndWidth(statement);
         this.statement = statement;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.whileKeyword);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.condition);
      writer.WriteValue(this.closeParenToken);
      writer.WriteValue(this.statement);
    }

    static WhileStatementSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(WhileStatementSyntax), r => new WhileStatementSyntax(r));
    }
  }

  internal sealed partial class DoStatementSyntax : StatementSyntax
  {
    internal readonly SyntaxToken doKeyword;
    internal readonly StatementSyntax statement;
    internal readonly SyntaxToken whileKeyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly ExpressionSyntax condition;
    internal readonly SyntaxToken closeParenToken;
    internal readonly SyntaxToken semicolonToken;

    internal DoStatementSyntax(SyntaxKind kind, SyntaxToken doKeyword, StatementSyntax statement, SyntaxToken whileKeyword, SyntaxToken openParenToken, ExpressionSyntax condition, SyntaxToken closeParenToken, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 7;
        this.AdjustFlagsAndWidth(doKeyword);
        this.doKeyword = doKeyword;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
        this.AdjustFlagsAndWidth(whileKeyword);
        this.whileKeyword = whileKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal DoStatementSyntax(SyntaxKind kind, SyntaxToken doKeyword, StatementSyntax statement, SyntaxToken whileKeyword, SyntaxToken openParenToken, ExpressionSyntax condition, SyntaxToken closeParenToken, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 7;
        this.AdjustFlagsAndWidth(doKeyword);
        this.doKeyword = doKeyword;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
        this.AdjustFlagsAndWidth(whileKeyword);
        this.whileKeyword = whileKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal DoStatementSyntax(SyntaxKind kind, SyntaxToken doKeyword, StatementSyntax statement, SyntaxToken whileKeyword, SyntaxToken openParenToken, ExpressionSyntax condition, SyntaxToken closeParenToken, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 7;
        this.AdjustFlagsAndWidth(doKeyword);
        this.doKeyword = doKeyword;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
        this.AdjustFlagsAndWidth(whileKeyword);
        this.whileKeyword = whileKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    public SyntaxToken DoKeyword => this.doKeyword;
    public StatementSyntax Statement => this.statement;
    public SyntaxToken WhileKeyword => this.whileKeyword;
    public SyntaxToken OpenParenToken => this.openParenToken;
    public ExpressionSyntax Condition => this.condition;
    public SyntaxToken CloseParenToken => this.closeParenToken;
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.doKeyword;
            case 1: return this.statement;
            case 2: return this.whileKeyword;
            case 3: return this.openParenToken;
            case 4: return this.condition;
            case 5: return this.closeParenToken;
            case 6: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.DoStatementSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitDoStatement(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitDoStatement(this);

    public DoStatementSyntax Update(SyntaxToken doKeyword, StatementSyntax statement, SyntaxToken whileKeyword, SyntaxToken openParenToken, ExpressionSyntax condition, SyntaxToken closeParenToken, SyntaxToken semicolonToken)
    {
        if (doKeyword != this.DoKeyword || statement != this.Statement || whileKeyword != this.WhileKeyword || openParenToken != this.OpenParenToken || condition != this.Condition || closeParenToken != this.CloseParenToken || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.DoStatement(doKeyword, statement, whileKeyword, openParenToken, condition, closeParenToken, semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new DoStatementSyntax(this.Kind, this.doKeyword, this.statement, this.whileKeyword, this.openParenToken, this.condition, this.closeParenToken, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new DoStatementSyntax(this.Kind, this.doKeyword, this.statement, this.whileKeyword, this.openParenToken, this.condition, this.closeParenToken, this.semicolonToken, GetDiagnostics(), annotations);

    internal DoStatementSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 7;
      var doKeyword = (SyntaxToken)reader.ReadValue();
      if (doKeyword != null)
      {
         AdjustFlagsAndWidth(doKeyword);
         this.doKeyword = doKeyword;
      }
      var statement = (StatementSyntax)reader.ReadValue();
      if (statement != null)
      {
         AdjustFlagsAndWidth(statement);
         this.statement = statement;
      }
      var whileKeyword = (SyntaxToken)reader.ReadValue();
      if (whileKeyword != null)
      {
         AdjustFlagsAndWidth(whileKeyword);
         this.whileKeyword = whileKeyword;
      }
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var condition = (ExpressionSyntax)reader.ReadValue();
      if (condition != null)
      {
         AdjustFlagsAndWidth(condition);
         this.condition = condition;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
      var semicolonToken = (SyntaxToken)reader.ReadValue();
      if (semicolonToken != null)
      {
         AdjustFlagsAndWidth(semicolonToken);
         this.semicolonToken = semicolonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.doKeyword);
      writer.WriteValue(this.statement);
      writer.WriteValue(this.whileKeyword);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.condition);
      writer.WriteValue(this.closeParenToken);
      writer.WriteValue(this.semicolonToken);
    }

    static DoStatementSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(DoStatementSyntax), r => new DoStatementSyntax(r));
    }
  }

  internal sealed partial class ForStatementSyntax : StatementSyntax
  {
    internal readonly SyntaxToken forKeyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly VariableDeclarationSyntax declaration;
    internal readonly GreenNode initializers;
    internal readonly SyntaxToken firstSemicolonToken;
    internal readonly ExpressionSyntax condition;
    internal readonly SyntaxToken secondSemicolonToken;
    internal readonly GreenNode incrementors;
    internal readonly SyntaxToken closeParenToken;
    internal readonly StatementSyntax statement;

    internal ForStatementSyntax(SyntaxKind kind, SyntaxToken forKeyword, SyntaxToken openParenToken, VariableDeclarationSyntax declaration, GreenNode initializers, SyntaxToken firstSemicolonToken, ExpressionSyntax condition, SyntaxToken secondSemicolonToken, GreenNode incrementors, SyntaxToken closeParenToken, StatementSyntax statement, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 10;
        this.AdjustFlagsAndWidth(forKeyword);
        this.forKeyword = forKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (declaration != null)
        {
            this.AdjustFlagsAndWidth(declaration);
            this.declaration = declaration;
        }
        if (initializers != null)
        {
            this.AdjustFlagsAndWidth(initializers);
            this.initializers = initializers;
        }
        this.AdjustFlagsAndWidth(firstSemicolonToken);
        this.firstSemicolonToken = firstSemicolonToken;
        if (condition != null)
        {
            this.AdjustFlagsAndWidth(condition);
            this.condition = condition;
        }
        this.AdjustFlagsAndWidth(secondSemicolonToken);
        this.secondSemicolonToken = secondSemicolonToken;
        if (incrementors != null)
        {
            this.AdjustFlagsAndWidth(incrementors);
            this.incrementors = incrementors;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }


    internal ForStatementSyntax(SyntaxKind kind, SyntaxToken forKeyword, SyntaxToken openParenToken, VariableDeclarationSyntax declaration, GreenNode initializers, SyntaxToken firstSemicolonToken, ExpressionSyntax condition, SyntaxToken secondSemicolonToken, GreenNode incrementors, SyntaxToken closeParenToken, StatementSyntax statement, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 10;
        this.AdjustFlagsAndWidth(forKeyword);
        this.forKeyword = forKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (declaration != null)
        {
            this.AdjustFlagsAndWidth(declaration);
            this.declaration = declaration;
        }
        if (initializers != null)
        {
            this.AdjustFlagsAndWidth(initializers);
            this.initializers = initializers;
        }
        this.AdjustFlagsAndWidth(firstSemicolonToken);
        this.firstSemicolonToken = firstSemicolonToken;
        if (condition != null)
        {
            this.AdjustFlagsAndWidth(condition);
            this.condition = condition;
        }
        this.AdjustFlagsAndWidth(secondSemicolonToken);
        this.secondSemicolonToken = secondSemicolonToken;
        if (incrementors != null)
        {
            this.AdjustFlagsAndWidth(incrementors);
            this.incrementors = incrementors;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }


    internal ForStatementSyntax(SyntaxKind kind, SyntaxToken forKeyword, SyntaxToken openParenToken, VariableDeclarationSyntax declaration, GreenNode initializers, SyntaxToken firstSemicolonToken, ExpressionSyntax condition, SyntaxToken secondSemicolonToken, GreenNode incrementors, SyntaxToken closeParenToken, StatementSyntax statement)
        : base(kind)
    {
        this.SlotCount = 10;
        this.AdjustFlagsAndWidth(forKeyword);
        this.forKeyword = forKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (declaration != null)
        {
            this.AdjustFlagsAndWidth(declaration);
            this.declaration = declaration;
        }
        if (initializers != null)
        {
            this.AdjustFlagsAndWidth(initializers);
            this.initializers = initializers;
        }
        this.AdjustFlagsAndWidth(firstSemicolonToken);
        this.firstSemicolonToken = firstSemicolonToken;
        if (condition != null)
        {
            this.AdjustFlagsAndWidth(condition);
            this.condition = condition;
        }
        this.AdjustFlagsAndWidth(secondSemicolonToken);
        this.secondSemicolonToken = secondSemicolonToken;
        if (incrementors != null)
        {
            this.AdjustFlagsAndWidth(incrementors);
            this.incrementors = incrementors;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    public SyntaxToken ForKeyword => this.forKeyword;
    public SyntaxToken OpenParenToken => this.openParenToken;
    public VariableDeclarationSyntax Declaration => this.declaration;
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<ExpressionSyntax> Initializers => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<ExpressionSyntax>(new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<CSharpSyntaxNode>(this.initializers));
    public SyntaxToken FirstSemicolonToken => this.firstSemicolonToken;
    public ExpressionSyntax Condition => this.condition;
    public SyntaxToken SecondSemicolonToken => this.secondSemicolonToken;
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<ExpressionSyntax> Incrementors => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<ExpressionSyntax>(new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<CSharpSyntaxNode>(this.incrementors));
    public SyntaxToken CloseParenToken => this.closeParenToken;
    public StatementSyntax Statement => this.statement;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.forKeyword;
            case 1: return this.openParenToken;
            case 2: return this.declaration;
            case 3: return this.initializers;
            case 4: return this.firstSemicolonToken;
            case 5: return this.condition;
            case 6: return this.secondSemicolonToken;
            case 7: return this.incrementors;
            case 8: return this.closeParenToken;
            case 9: return this.statement;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ForStatementSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitForStatement(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitForStatement(this);

    public ForStatementSyntax Update(SyntaxToken forKeyword, SyntaxToken openParenToken, VariableDeclarationSyntax declaration, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<ExpressionSyntax> initializers, SyntaxToken firstSemicolonToken, ExpressionSyntax condition, SyntaxToken secondSemicolonToken, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<ExpressionSyntax> incrementors, SyntaxToken closeParenToken, StatementSyntax statement)
    {
        if (forKeyword != this.ForKeyword || openParenToken != this.OpenParenToken || declaration != this.Declaration || initializers != this.Initializers || firstSemicolonToken != this.FirstSemicolonToken || condition != this.Condition || secondSemicolonToken != this.SecondSemicolonToken || incrementors != this.Incrementors || closeParenToken != this.CloseParenToken || statement != this.Statement)
        {
            var newNode = SyntaxFactory.ForStatement(forKeyword, openParenToken, declaration, initializers, firstSemicolonToken, condition, secondSemicolonToken, incrementors, closeParenToken, statement);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ForStatementSyntax(this.Kind, this.forKeyword, this.openParenToken, this.declaration, this.initializers, this.firstSemicolonToken, this.condition, this.secondSemicolonToken, this.incrementors, this.closeParenToken, this.statement, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ForStatementSyntax(this.Kind, this.forKeyword, this.openParenToken, this.declaration, this.initializers, this.firstSemicolonToken, this.condition, this.secondSemicolonToken, this.incrementors, this.closeParenToken, this.statement, GetDiagnostics(), annotations);

    internal ForStatementSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 10;
      var forKeyword = (SyntaxToken)reader.ReadValue();
      if (forKeyword != null)
      {
         AdjustFlagsAndWidth(forKeyword);
         this.forKeyword = forKeyword;
      }
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var declaration = (VariableDeclarationSyntax)reader.ReadValue();
      if (declaration != null)
      {
         AdjustFlagsAndWidth(declaration);
         this.declaration = declaration;
      }
      var initializers = (GreenNode)reader.ReadValue();
      if (initializers != null)
      {
         AdjustFlagsAndWidth(initializers);
         this.initializers = initializers;
      }
      var firstSemicolonToken = (SyntaxToken)reader.ReadValue();
      if (firstSemicolonToken != null)
      {
         AdjustFlagsAndWidth(firstSemicolonToken);
         this.firstSemicolonToken = firstSemicolonToken;
      }
      var condition = (ExpressionSyntax)reader.ReadValue();
      if (condition != null)
      {
         AdjustFlagsAndWidth(condition);
         this.condition = condition;
      }
      var secondSemicolonToken = (SyntaxToken)reader.ReadValue();
      if (secondSemicolonToken != null)
      {
         AdjustFlagsAndWidth(secondSemicolonToken);
         this.secondSemicolonToken = secondSemicolonToken;
      }
      var incrementors = (GreenNode)reader.ReadValue();
      if (incrementors != null)
      {
         AdjustFlagsAndWidth(incrementors);
         this.incrementors = incrementors;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
      var statement = (StatementSyntax)reader.ReadValue();
      if (statement != null)
      {
         AdjustFlagsAndWidth(statement);
         this.statement = statement;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.forKeyword);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.declaration);
      writer.WriteValue(this.initializers);
      writer.WriteValue(this.firstSemicolonToken);
      writer.WriteValue(this.condition);
      writer.WriteValue(this.secondSemicolonToken);
      writer.WriteValue(this.incrementors);
      writer.WriteValue(this.closeParenToken);
      writer.WriteValue(this.statement);
    }

    static ForStatementSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ForStatementSyntax), r => new ForStatementSyntax(r));
    }
  }

  internal abstract partial class CommonForEachStatementSyntax : StatementSyntax
  {
    internal CommonForEachStatementSyntax(SyntaxKind kind, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal CommonForEachStatementSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    protected CommonForEachStatementSyntax(ObjectReader reader)
       : base(reader)
    {
    }

    public abstract SyntaxToken AwaitKeyword { get; }

    public abstract SyntaxToken ForEachKeyword { get; }

    public abstract SyntaxToken OpenParenToken { get; }

    public abstract SyntaxToken InKeyword { get; }

    public abstract ExpressionSyntax Expression { get; }

    public abstract SyntaxToken CloseParenToken { get; }

    public abstract StatementSyntax Statement { get; }
  }

  internal sealed partial class ForEachStatementSyntax : CommonForEachStatementSyntax
  {
    internal readonly SyntaxToken awaitKeyword;
    internal readonly SyntaxToken forEachKeyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly TypeSyntax type;
    internal readonly SyntaxToken identifier;
    internal readonly SyntaxToken inKeyword;
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken closeParenToken;
    internal readonly StatementSyntax statement;

    internal ForEachStatementSyntax(SyntaxKind kind, SyntaxToken awaitKeyword, SyntaxToken forEachKeyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken identifier, SyntaxToken inKeyword, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 9;
        if (awaitKeyword != null)
        {
            this.AdjustFlagsAndWidth(awaitKeyword);
            this.awaitKeyword = awaitKeyword;
        }
        this.AdjustFlagsAndWidth(forEachKeyword);
        this.forEachKeyword = forEachKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(inKeyword);
        this.inKeyword = inKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }


    internal ForEachStatementSyntax(SyntaxKind kind, SyntaxToken awaitKeyword, SyntaxToken forEachKeyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken identifier, SyntaxToken inKeyword, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 9;
        if (awaitKeyword != null)
        {
            this.AdjustFlagsAndWidth(awaitKeyword);
            this.awaitKeyword = awaitKeyword;
        }
        this.AdjustFlagsAndWidth(forEachKeyword);
        this.forEachKeyword = forEachKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(inKeyword);
        this.inKeyword = inKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }


    internal ForEachStatementSyntax(SyntaxKind kind, SyntaxToken awaitKeyword, SyntaxToken forEachKeyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken identifier, SyntaxToken inKeyword, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement)
        : base(kind)
    {
        this.SlotCount = 9;
        if (awaitKeyword != null)
        {
            this.AdjustFlagsAndWidth(awaitKeyword);
            this.awaitKeyword = awaitKeyword;
        }
        this.AdjustFlagsAndWidth(forEachKeyword);
        this.forEachKeyword = forEachKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(inKeyword);
        this.inKeyword = inKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    public override SyntaxToken AwaitKeyword => this.awaitKeyword;
    public override SyntaxToken ForEachKeyword => this.forEachKeyword;
    public override SyntaxToken OpenParenToken => this.openParenToken;
    public TypeSyntax Type => this.type;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public override SyntaxToken InKeyword => this.inKeyword;
    public override ExpressionSyntax Expression => this.expression;
    public override SyntaxToken CloseParenToken => this.closeParenToken;
    public override StatementSyntax Statement => this.statement;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.awaitKeyword;
            case 1: return this.forEachKeyword;
            case 2: return this.openParenToken;
            case 3: return this.type;
            case 4: return this.identifier;
            case 5: return this.inKeyword;
            case 6: return this.expression;
            case 7: return this.closeParenToken;
            case 8: return this.statement;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ForEachStatementSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitForEachStatement(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitForEachStatement(this);

    public ForEachStatementSyntax Update(SyntaxToken awaitKeyword, SyntaxToken forEachKeyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken identifier, SyntaxToken inKeyword, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement)
    {
        if (awaitKeyword != this.AwaitKeyword || forEachKeyword != this.ForEachKeyword || openParenToken != this.OpenParenToken || type != this.Type || identifier != this.Identifier || inKeyword != this.InKeyword || expression != this.Expression || closeParenToken != this.CloseParenToken || statement != this.Statement)
        {
            var newNode = SyntaxFactory.ForEachStatement(awaitKeyword, forEachKeyword, openParenToken, type, identifier, inKeyword, expression, closeParenToken, statement);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ForEachStatementSyntax(this.Kind, this.awaitKeyword, this.forEachKeyword, this.openParenToken, this.type, this.identifier, this.inKeyword, this.expression, this.closeParenToken, this.statement, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ForEachStatementSyntax(this.Kind, this.awaitKeyword, this.forEachKeyword, this.openParenToken, this.type, this.identifier, this.inKeyword, this.expression, this.closeParenToken, this.statement, GetDiagnostics(), annotations);

    internal ForEachStatementSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 9;
      var awaitKeyword = (SyntaxToken)reader.ReadValue();
      if (awaitKeyword != null)
      {
         AdjustFlagsAndWidth(awaitKeyword);
         this.awaitKeyword = awaitKeyword;
      }
      var forEachKeyword = (SyntaxToken)reader.ReadValue();
      if (forEachKeyword != null)
      {
         AdjustFlagsAndWidth(forEachKeyword);
         this.forEachKeyword = forEachKeyword;
      }
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var type = (TypeSyntax)reader.ReadValue();
      if (type != null)
      {
         AdjustFlagsAndWidth(type);
         this.type = type;
      }
      var identifier = (SyntaxToken)reader.ReadValue();
      if (identifier != null)
      {
         AdjustFlagsAndWidth(identifier);
         this.identifier = identifier;
      }
      var inKeyword = (SyntaxToken)reader.ReadValue();
      if (inKeyword != null)
      {
         AdjustFlagsAndWidth(inKeyword);
         this.inKeyword = inKeyword;
      }
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
      var statement = (StatementSyntax)reader.ReadValue();
      if (statement != null)
      {
         AdjustFlagsAndWidth(statement);
         this.statement = statement;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.awaitKeyword);
      writer.WriteValue(this.forEachKeyword);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.type);
      writer.WriteValue(this.identifier);
      writer.WriteValue(this.inKeyword);
      writer.WriteValue(this.expression);
      writer.WriteValue(this.closeParenToken);
      writer.WriteValue(this.statement);
    }

    static ForEachStatementSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ForEachStatementSyntax), r => new ForEachStatementSyntax(r));
    }
  }

  internal sealed partial class ForEachVariableStatementSyntax : CommonForEachStatementSyntax
  {
    internal readonly SyntaxToken awaitKeyword;
    internal readonly SyntaxToken forEachKeyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly ExpressionSyntax variable;
    internal readonly SyntaxToken inKeyword;
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken closeParenToken;
    internal readonly StatementSyntax statement;

    internal ForEachVariableStatementSyntax(SyntaxKind kind, SyntaxToken awaitKeyword, SyntaxToken forEachKeyword, SyntaxToken openParenToken, ExpressionSyntax variable, SyntaxToken inKeyword, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 8;
        if (awaitKeyword != null)
        {
            this.AdjustFlagsAndWidth(awaitKeyword);
            this.awaitKeyword = awaitKeyword;
        }
        this.AdjustFlagsAndWidth(forEachKeyword);
        this.forEachKeyword = forEachKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(variable);
        this.variable = variable;
        this.AdjustFlagsAndWidth(inKeyword);
        this.inKeyword = inKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }


    internal ForEachVariableStatementSyntax(SyntaxKind kind, SyntaxToken awaitKeyword, SyntaxToken forEachKeyword, SyntaxToken openParenToken, ExpressionSyntax variable, SyntaxToken inKeyword, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 8;
        if (awaitKeyword != null)
        {
            this.AdjustFlagsAndWidth(awaitKeyword);
            this.awaitKeyword = awaitKeyword;
        }
        this.AdjustFlagsAndWidth(forEachKeyword);
        this.forEachKeyword = forEachKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(variable);
        this.variable = variable;
        this.AdjustFlagsAndWidth(inKeyword);
        this.inKeyword = inKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }


    internal ForEachVariableStatementSyntax(SyntaxKind kind, SyntaxToken awaitKeyword, SyntaxToken forEachKeyword, SyntaxToken openParenToken, ExpressionSyntax variable, SyntaxToken inKeyword, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement)
        : base(kind)
    {
        this.SlotCount = 8;
        if (awaitKeyword != null)
        {
            this.AdjustFlagsAndWidth(awaitKeyword);
            this.awaitKeyword = awaitKeyword;
        }
        this.AdjustFlagsAndWidth(forEachKeyword);
        this.forEachKeyword = forEachKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(variable);
        this.variable = variable;
        this.AdjustFlagsAndWidth(inKeyword);
        this.inKeyword = inKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    public override SyntaxToken AwaitKeyword => this.awaitKeyword;
    public override SyntaxToken ForEachKeyword => this.forEachKeyword;
    public override SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>
    /// The variable(s) of the loop. In correct code this is a tuple
    /// literal, declaration expression with a tuple designator, or
    /// a discard syntax in the form of a simple identifier. In broken
    /// code it could be something else.
    /// </summary>
    public ExpressionSyntax Variable => this.variable;
    public override SyntaxToken InKeyword => this.inKeyword;
    public override ExpressionSyntax Expression => this.expression;
    public override SyntaxToken CloseParenToken => this.closeParenToken;
    public override StatementSyntax Statement => this.statement;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.awaitKeyword;
            case 1: return this.forEachKeyword;
            case 2: return this.openParenToken;
            case 3: return this.variable;
            case 4: return this.inKeyword;
            case 5: return this.expression;
            case 6: return this.closeParenToken;
            case 7: return this.statement;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ForEachVariableStatementSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitForEachVariableStatement(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitForEachVariableStatement(this);

    public ForEachVariableStatementSyntax Update(SyntaxToken awaitKeyword, SyntaxToken forEachKeyword, SyntaxToken openParenToken, ExpressionSyntax variable, SyntaxToken inKeyword, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement)
    {
        if (awaitKeyword != this.AwaitKeyword || forEachKeyword != this.ForEachKeyword || openParenToken != this.OpenParenToken || variable != this.Variable || inKeyword != this.InKeyword || expression != this.Expression || closeParenToken != this.CloseParenToken || statement != this.Statement)
        {
            var newNode = SyntaxFactory.ForEachVariableStatement(awaitKeyword, forEachKeyword, openParenToken, variable, inKeyword, expression, closeParenToken, statement);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ForEachVariableStatementSyntax(this.Kind, this.awaitKeyword, this.forEachKeyword, this.openParenToken, this.variable, this.inKeyword, this.expression, this.closeParenToken, this.statement, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ForEachVariableStatementSyntax(this.Kind, this.awaitKeyword, this.forEachKeyword, this.openParenToken, this.variable, this.inKeyword, this.expression, this.closeParenToken, this.statement, GetDiagnostics(), annotations);

    internal ForEachVariableStatementSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 8;
      var awaitKeyword = (SyntaxToken)reader.ReadValue();
      if (awaitKeyword != null)
      {
         AdjustFlagsAndWidth(awaitKeyword);
         this.awaitKeyword = awaitKeyword;
      }
      var forEachKeyword = (SyntaxToken)reader.ReadValue();
      if (forEachKeyword != null)
      {
         AdjustFlagsAndWidth(forEachKeyword);
         this.forEachKeyword = forEachKeyword;
      }
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var variable = (ExpressionSyntax)reader.ReadValue();
      if (variable != null)
      {
         AdjustFlagsAndWidth(variable);
         this.variable = variable;
      }
      var inKeyword = (SyntaxToken)reader.ReadValue();
      if (inKeyword != null)
      {
         AdjustFlagsAndWidth(inKeyword);
         this.inKeyword = inKeyword;
      }
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
      var statement = (StatementSyntax)reader.ReadValue();
      if (statement != null)
      {
         AdjustFlagsAndWidth(statement);
         this.statement = statement;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.awaitKeyword);
      writer.WriteValue(this.forEachKeyword);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.variable);
      writer.WriteValue(this.inKeyword);
      writer.WriteValue(this.expression);
      writer.WriteValue(this.closeParenToken);
      writer.WriteValue(this.statement);
    }

    static ForEachVariableStatementSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ForEachVariableStatementSyntax), r => new ForEachVariableStatementSyntax(r));
    }
  }

  internal sealed partial class UsingStatementSyntax : StatementSyntax
  {
    internal readonly SyntaxToken awaitKeyword;
    internal readonly SyntaxToken usingKeyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly VariableDeclarationSyntax declaration;
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken closeParenToken;
    internal readonly StatementSyntax statement;

    internal UsingStatementSyntax(SyntaxKind kind, SyntaxToken awaitKeyword, SyntaxToken usingKeyword, SyntaxToken openParenToken, VariableDeclarationSyntax declaration, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 7;
        if (awaitKeyword != null)
        {
            this.AdjustFlagsAndWidth(awaitKeyword);
            this.awaitKeyword = awaitKeyword;
        }
        this.AdjustFlagsAndWidth(usingKeyword);
        this.usingKeyword = usingKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (declaration != null)
        {
            this.AdjustFlagsAndWidth(declaration);
            this.declaration = declaration;
        }
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }


    internal UsingStatementSyntax(SyntaxKind kind, SyntaxToken awaitKeyword, SyntaxToken usingKeyword, SyntaxToken openParenToken, VariableDeclarationSyntax declaration, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 7;
        if (awaitKeyword != null)
        {
            this.AdjustFlagsAndWidth(awaitKeyword);
            this.awaitKeyword = awaitKeyword;
        }
        this.AdjustFlagsAndWidth(usingKeyword);
        this.usingKeyword = usingKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (declaration != null)
        {
            this.AdjustFlagsAndWidth(declaration);
            this.declaration = declaration;
        }
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }


    internal UsingStatementSyntax(SyntaxKind kind, SyntaxToken awaitKeyword, SyntaxToken usingKeyword, SyntaxToken openParenToken, VariableDeclarationSyntax declaration, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement)
        : base(kind)
    {
        this.SlotCount = 7;
        if (awaitKeyword != null)
        {
            this.AdjustFlagsAndWidth(awaitKeyword);
            this.awaitKeyword = awaitKeyword;
        }
        this.AdjustFlagsAndWidth(usingKeyword);
        this.usingKeyword = usingKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (declaration != null)
        {
            this.AdjustFlagsAndWidth(declaration);
            this.declaration = declaration;
        }
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    public SyntaxToken AwaitKeyword => this.awaitKeyword;
    public SyntaxToken UsingKeyword => this.usingKeyword;
    public SyntaxToken OpenParenToken => this.openParenToken;
    public VariableDeclarationSyntax Declaration => this.declaration;
    public ExpressionSyntax Expression => this.expression;
    public SyntaxToken CloseParenToken => this.closeParenToken;
    public StatementSyntax Statement => this.statement;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.awaitKeyword;
            case 1: return this.usingKeyword;
            case 2: return this.openParenToken;
            case 3: return this.declaration;
            case 4: return this.expression;
            case 5: return this.closeParenToken;
            case 6: return this.statement;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.UsingStatementSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitUsingStatement(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitUsingStatement(this);

    public UsingStatementSyntax Update(SyntaxToken awaitKeyword, SyntaxToken usingKeyword, SyntaxToken openParenToken, VariableDeclarationSyntax declaration, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement)
    {
        if (awaitKeyword != this.AwaitKeyword || usingKeyword != this.UsingKeyword || openParenToken != this.OpenParenToken || declaration != this.Declaration || expression != this.Expression || closeParenToken != this.CloseParenToken || statement != this.Statement)
        {
            var newNode = SyntaxFactory.UsingStatement(awaitKeyword, usingKeyword, openParenToken, declaration, expression, closeParenToken, statement);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new UsingStatementSyntax(this.Kind, this.awaitKeyword, this.usingKeyword, this.openParenToken, this.declaration, this.expression, this.closeParenToken, this.statement, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new UsingStatementSyntax(this.Kind, this.awaitKeyword, this.usingKeyword, this.openParenToken, this.declaration, this.expression, this.closeParenToken, this.statement, GetDiagnostics(), annotations);

    internal UsingStatementSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 7;
      var awaitKeyword = (SyntaxToken)reader.ReadValue();
      if (awaitKeyword != null)
      {
         AdjustFlagsAndWidth(awaitKeyword);
         this.awaitKeyword = awaitKeyword;
      }
      var usingKeyword = (SyntaxToken)reader.ReadValue();
      if (usingKeyword != null)
      {
         AdjustFlagsAndWidth(usingKeyword);
         this.usingKeyword = usingKeyword;
      }
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var declaration = (VariableDeclarationSyntax)reader.ReadValue();
      if (declaration != null)
      {
         AdjustFlagsAndWidth(declaration);
         this.declaration = declaration;
      }
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
      var statement = (StatementSyntax)reader.ReadValue();
      if (statement != null)
      {
         AdjustFlagsAndWidth(statement);
         this.statement = statement;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.awaitKeyword);
      writer.WriteValue(this.usingKeyword);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.declaration);
      writer.WriteValue(this.expression);
      writer.WriteValue(this.closeParenToken);
      writer.WriteValue(this.statement);
    }

    static UsingStatementSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(UsingStatementSyntax), r => new UsingStatementSyntax(r));
    }
  }

  internal sealed partial class FixedStatementSyntax : StatementSyntax
  {
    internal readonly SyntaxToken fixedKeyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly VariableDeclarationSyntax declaration;
    internal readonly SyntaxToken closeParenToken;
    internal readonly StatementSyntax statement;

    internal FixedStatementSyntax(SyntaxKind kind, SyntaxToken fixedKeyword, SyntaxToken openParenToken, VariableDeclarationSyntax declaration, SyntaxToken closeParenToken, StatementSyntax statement, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(fixedKeyword);
        this.fixedKeyword = fixedKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(declaration);
        this.declaration = declaration;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }


    internal FixedStatementSyntax(SyntaxKind kind, SyntaxToken fixedKeyword, SyntaxToken openParenToken, VariableDeclarationSyntax declaration, SyntaxToken closeParenToken, StatementSyntax statement, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(fixedKeyword);
        this.fixedKeyword = fixedKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(declaration);
        this.declaration = declaration;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }


    internal FixedStatementSyntax(SyntaxKind kind, SyntaxToken fixedKeyword, SyntaxToken openParenToken, VariableDeclarationSyntax declaration, SyntaxToken closeParenToken, StatementSyntax statement)
        : base(kind)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(fixedKeyword);
        this.fixedKeyword = fixedKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(declaration);
        this.declaration = declaration;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    public SyntaxToken FixedKeyword => this.fixedKeyword;
    public SyntaxToken OpenParenToken => this.openParenToken;
    public VariableDeclarationSyntax Declaration => this.declaration;
    public SyntaxToken CloseParenToken => this.closeParenToken;
    public StatementSyntax Statement => this.statement;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.fixedKeyword;
            case 1: return this.openParenToken;
            case 2: return this.declaration;
            case 3: return this.closeParenToken;
            case 4: return this.statement;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.FixedStatementSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitFixedStatement(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitFixedStatement(this);

    public FixedStatementSyntax Update(SyntaxToken fixedKeyword, SyntaxToken openParenToken, VariableDeclarationSyntax declaration, SyntaxToken closeParenToken, StatementSyntax statement)
    {
        if (fixedKeyword != this.FixedKeyword || openParenToken != this.OpenParenToken || declaration != this.Declaration || closeParenToken != this.CloseParenToken || statement != this.Statement)
        {
            var newNode = SyntaxFactory.FixedStatement(fixedKeyword, openParenToken, declaration, closeParenToken, statement);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new FixedStatementSyntax(this.Kind, this.fixedKeyword, this.openParenToken, this.declaration, this.closeParenToken, this.statement, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new FixedStatementSyntax(this.Kind, this.fixedKeyword, this.openParenToken, this.declaration, this.closeParenToken, this.statement, GetDiagnostics(), annotations);

    internal FixedStatementSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 5;
      var fixedKeyword = (SyntaxToken)reader.ReadValue();
      if (fixedKeyword != null)
      {
         AdjustFlagsAndWidth(fixedKeyword);
         this.fixedKeyword = fixedKeyword;
      }
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var declaration = (VariableDeclarationSyntax)reader.ReadValue();
      if (declaration != null)
      {
         AdjustFlagsAndWidth(declaration);
         this.declaration = declaration;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
      var statement = (StatementSyntax)reader.ReadValue();
      if (statement != null)
      {
         AdjustFlagsAndWidth(statement);
         this.statement = statement;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.fixedKeyword);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.declaration);
      writer.WriteValue(this.closeParenToken);
      writer.WriteValue(this.statement);
    }

    static FixedStatementSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(FixedStatementSyntax), r => new FixedStatementSyntax(r));
    }
  }

  internal sealed partial class CheckedStatementSyntax : StatementSyntax
  {
    internal readonly SyntaxToken keyword;
    internal readonly BlockSyntax block;

    internal CheckedStatementSyntax(SyntaxKind kind, SyntaxToken keyword, BlockSyntax block, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(block);
        this.block = block;
    }


    internal CheckedStatementSyntax(SyntaxKind kind, SyntaxToken keyword, BlockSyntax block, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(block);
        this.block = block;
    }


    internal CheckedStatementSyntax(SyntaxKind kind, SyntaxToken keyword, BlockSyntax block)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(block);
        this.block = block;
    }

    public SyntaxToken Keyword => this.keyword;
    public BlockSyntax Block => this.block;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.keyword;
            case 1: return this.block;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.CheckedStatementSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitCheckedStatement(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitCheckedStatement(this);

    public CheckedStatementSyntax Update(SyntaxToken keyword, BlockSyntax block)
    {
        if (keyword != this.Keyword || block != this.Block)
        {
            var newNode = SyntaxFactory.CheckedStatement(this.Kind, keyword, block);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new CheckedStatementSyntax(this.Kind, this.keyword, this.block, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new CheckedStatementSyntax(this.Kind, this.keyword, this.block, GetDiagnostics(), annotations);

    internal CheckedStatementSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var keyword = (SyntaxToken)reader.ReadValue();
      if (keyword != null)
      {
         AdjustFlagsAndWidth(keyword);
         this.keyword = keyword;
      }
      var block = (BlockSyntax)reader.ReadValue();
      if (block != null)
      {
         AdjustFlagsAndWidth(block);
         this.block = block;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.keyword);
      writer.WriteValue(this.block);
    }

    static CheckedStatementSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(CheckedStatementSyntax), r => new CheckedStatementSyntax(r));
    }
  }

  internal sealed partial class UnsafeStatementSyntax : StatementSyntax
  {
    internal readonly SyntaxToken unsafeKeyword;
    internal readonly BlockSyntax block;

    internal UnsafeStatementSyntax(SyntaxKind kind, SyntaxToken unsafeKeyword, BlockSyntax block, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(unsafeKeyword);
        this.unsafeKeyword = unsafeKeyword;
        this.AdjustFlagsAndWidth(block);
        this.block = block;
    }


    internal UnsafeStatementSyntax(SyntaxKind kind, SyntaxToken unsafeKeyword, BlockSyntax block, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(unsafeKeyword);
        this.unsafeKeyword = unsafeKeyword;
        this.AdjustFlagsAndWidth(block);
        this.block = block;
    }


    internal UnsafeStatementSyntax(SyntaxKind kind, SyntaxToken unsafeKeyword, BlockSyntax block)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(unsafeKeyword);
        this.unsafeKeyword = unsafeKeyword;
        this.AdjustFlagsAndWidth(block);
        this.block = block;
    }

    public SyntaxToken UnsafeKeyword => this.unsafeKeyword;
    public BlockSyntax Block => this.block;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.unsafeKeyword;
            case 1: return this.block;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.UnsafeStatementSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitUnsafeStatement(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitUnsafeStatement(this);

    public UnsafeStatementSyntax Update(SyntaxToken unsafeKeyword, BlockSyntax block)
    {
        if (unsafeKeyword != this.UnsafeKeyword || block != this.Block)
        {
            var newNode = SyntaxFactory.UnsafeStatement(unsafeKeyword, block);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new UnsafeStatementSyntax(this.Kind, this.unsafeKeyword, this.block, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new UnsafeStatementSyntax(this.Kind, this.unsafeKeyword, this.block, GetDiagnostics(), annotations);

    internal UnsafeStatementSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var unsafeKeyword = (SyntaxToken)reader.ReadValue();
      if (unsafeKeyword != null)
      {
         AdjustFlagsAndWidth(unsafeKeyword);
         this.unsafeKeyword = unsafeKeyword;
      }
      var block = (BlockSyntax)reader.ReadValue();
      if (block != null)
      {
         AdjustFlagsAndWidth(block);
         this.block = block;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.unsafeKeyword);
      writer.WriteValue(this.block);
    }

    static UnsafeStatementSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(UnsafeStatementSyntax), r => new UnsafeStatementSyntax(r));
    }
  }

  internal sealed partial class LockStatementSyntax : StatementSyntax
  {
    internal readonly SyntaxToken lockKeyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken closeParenToken;
    internal readonly StatementSyntax statement;

    internal LockStatementSyntax(SyntaxKind kind, SyntaxToken lockKeyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(lockKeyword);
        this.lockKeyword = lockKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }


    internal LockStatementSyntax(SyntaxKind kind, SyntaxToken lockKeyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(lockKeyword);
        this.lockKeyword = lockKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }


    internal LockStatementSyntax(SyntaxKind kind, SyntaxToken lockKeyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement)
        : base(kind)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(lockKeyword);
        this.lockKeyword = lockKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    public SyntaxToken LockKeyword => this.lockKeyword;
    public SyntaxToken OpenParenToken => this.openParenToken;
    public ExpressionSyntax Expression => this.expression;
    public SyntaxToken CloseParenToken => this.closeParenToken;
    public StatementSyntax Statement => this.statement;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.lockKeyword;
            case 1: return this.openParenToken;
            case 2: return this.expression;
            case 3: return this.closeParenToken;
            case 4: return this.statement;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.LockStatementSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitLockStatement(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitLockStatement(this);

    public LockStatementSyntax Update(SyntaxToken lockKeyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement)
    {
        if (lockKeyword != this.LockKeyword || openParenToken != this.OpenParenToken || expression != this.Expression || closeParenToken != this.CloseParenToken || statement != this.Statement)
        {
            var newNode = SyntaxFactory.LockStatement(lockKeyword, openParenToken, expression, closeParenToken, statement);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new LockStatementSyntax(this.Kind, this.lockKeyword, this.openParenToken, this.expression, this.closeParenToken, this.statement, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new LockStatementSyntax(this.Kind, this.lockKeyword, this.openParenToken, this.expression, this.closeParenToken, this.statement, GetDiagnostics(), annotations);

    internal LockStatementSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 5;
      var lockKeyword = (SyntaxToken)reader.ReadValue();
      if (lockKeyword != null)
      {
         AdjustFlagsAndWidth(lockKeyword);
         this.lockKeyword = lockKeyword;
      }
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
      var statement = (StatementSyntax)reader.ReadValue();
      if (statement != null)
      {
         AdjustFlagsAndWidth(statement);
         this.statement = statement;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.lockKeyword);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.expression);
      writer.WriteValue(this.closeParenToken);
      writer.WriteValue(this.statement);
    }

    static LockStatementSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(LockStatementSyntax), r => new LockStatementSyntax(r));
    }
  }

  /// <summary>
  /// Represents an if statement syntax.
  /// </summary>
  internal sealed partial class IfStatementSyntax : StatementSyntax
  {
    internal readonly SyntaxToken ifKeyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly ExpressionSyntax condition;
    internal readonly SyntaxToken closeParenToken;
    internal readonly StatementSyntax statement;
    internal readonly ElseClauseSyntax @else;

    internal IfStatementSyntax(SyntaxKind kind, SyntaxToken ifKeyword, SyntaxToken openParenToken, ExpressionSyntax condition, SyntaxToken closeParenToken, StatementSyntax statement, ElseClauseSyntax @else, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 6;
        this.AdjustFlagsAndWidth(ifKeyword);
        this.ifKeyword = ifKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
        if (@else != null)
        {
            this.AdjustFlagsAndWidth(@else);
            this.@else = @else;
        }
    }


    internal IfStatementSyntax(SyntaxKind kind, SyntaxToken ifKeyword, SyntaxToken openParenToken, ExpressionSyntax condition, SyntaxToken closeParenToken, StatementSyntax statement, ElseClauseSyntax @else, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 6;
        this.AdjustFlagsAndWidth(ifKeyword);
        this.ifKeyword = ifKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
        if (@else != null)
        {
            this.AdjustFlagsAndWidth(@else);
            this.@else = @else;
        }
    }


    internal IfStatementSyntax(SyntaxKind kind, SyntaxToken ifKeyword, SyntaxToken openParenToken, ExpressionSyntax condition, SyntaxToken closeParenToken, StatementSyntax statement, ElseClauseSyntax @else)
        : base(kind)
    {
        this.SlotCount = 6;
        this.AdjustFlagsAndWidth(ifKeyword);
        this.ifKeyword = ifKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
        if (@else != null)
        {
            this.AdjustFlagsAndWidth(@else);
            this.@else = @else;
        }
    }

    /// <summary>
    /// Gets a SyntaxToken that represents the if keyword.
    /// </summary>
    public SyntaxToken IfKeyword => this.ifKeyword;
    /// <summary>
    /// Gets a SyntaxToken that represents the open parenthesis before the if statement's condition expression.
    /// </summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>
    /// Gets an ExpressionSyntax that represents the condition of the if statement.
    /// </summary>
    public ExpressionSyntax Condition => this.condition;
    /// <summary>
    /// Gets a SyntaxToken that represents the close parenthesis after the if statement's condition expression.
    /// </summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;
    /// <summary>
    /// Gets a StatementSyntax the represents the statement to be executed when the condition is true.
    /// </summary>
    public StatementSyntax Statement => this.statement;
    /// <summary>
    /// Gets an ElseClauseSyntax that represents the statement to be executed when the condition is false if such statement exists.
    /// </summary>
    public ElseClauseSyntax Else => this.@else;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.ifKeyword;
            case 1: return this.openParenToken;
            case 2: return this.condition;
            case 3: return this.closeParenToken;
            case 4: return this.statement;
            case 5: return this.@else;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.IfStatementSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitIfStatement(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitIfStatement(this);

    public IfStatementSyntax Update(SyntaxToken ifKeyword, SyntaxToken openParenToken, ExpressionSyntax condition, SyntaxToken closeParenToken, StatementSyntax statement, ElseClauseSyntax @else)
    {
        if (ifKeyword != this.IfKeyword || openParenToken != this.OpenParenToken || condition != this.Condition || closeParenToken != this.CloseParenToken || statement != this.Statement || @else != this.Else)
        {
            var newNode = SyntaxFactory.IfStatement(ifKeyword, openParenToken, condition, closeParenToken, statement, @else);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new IfStatementSyntax(this.Kind, this.ifKeyword, this.openParenToken, this.condition, this.closeParenToken, this.statement, this.@else, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new IfStatementSyntax(this.Kind, this.ifKeyword, this.openParenToken, this.condition, this.closeParenToken, this.statement, this.@else, GetDiagnostics(), annotations);

    internal IfStatementSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 6;
      var ifKeyword = (SyntaxToken)reader.ReadValue();
      if (ifKeyword != null)
      {
         AdjustFlagsAndWidth(ifKeyword);
         this.ifKeyword = ifKeyword;
      }
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var condition = (ExpressionSyntax)reader.ReadValue();
      if (condition != null)
      {
         AdjustFlagsAndWidth(condition);
         this.condition = condition;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
      var statement = (StatementSyntax)reader.ReadValue();
      if (statement != null)
      {
         AdjustFlagsAndWidth(statement);
         this.statement = statement;
      }
      var @else = (ElseClauseSyntax)reader.ReadValue();
      if (@else != null)
      {
         AdjustFlagsAndWidth(@else);
         this.@else = @else;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.ifKeyword);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.condition);
      writer.WriteValue(this.closeParenToken);
      writer.WriteValue(this.statement);
      writer.WriteValue(this.@else);
    }

    static IfStatementSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(IfStatementSyntax), r => new IfStatementSyntax(r));
    }
  }

  /// <summary>Represents an else statement syntax.</summary>
  internal sealed partial class ElseClauseSyntax : CSharpSyntaxNode
  {
    internal readonly SyntaxToken elseKeyword;
    internal readonly StatementSyntax statement;

    internal ElseClauseSyntax(SyntaxKind kind, SyntaxToken elseKeyword, StatementSyntax statement, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(elseKeyword);
        this.elseKeyword = elseKeyword;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }


    internal ElseClauseSyntax(SyntaxKind kind, SyntaxToken elseKeyword, StatementSyntax statement, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(elseKeyword);
        this.elseKeyword = elseKeyword;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }


    internal ElseClauseSyntax(SyntaxKind kind, SyntaxToken elseKeyword, StatementSyntax statement)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(elseKeyword);
        this.elseKeyword = elseKeyword;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    /// <summary>
    /// Gets a syntax token
    /// </summary>
    public SyntaxToken ElseKeyword => this.elseKeyword;
    public StatementSyntax Statement => this.statement;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.elseKeyword;
            case 1: return this.statement;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ElseClauseSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitElseClause(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitElseClause(this);

    public ElseClauseSyntax Update(SyntaxToken elseKeyword, StatementSyntax statement)
    {
        if (elseKeyword != this.ElseKeyword || statement != this.Statement)
        {
            var newNode = SyntaxFactory.ElseClause(elseKeyword, statement);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ElseClauseSyntax(this.Kind, this.elseKeyword, this.statement, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ElseClauseSyntax(this.Kind, this.elseKeyword, this.statement, GetDiagnostics(), annotations);

    internal ElseClauseSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var elseKeyword = (SyntaxToken)reader.ReadValue();
      if (elseKeyword != null)
      {
         AdjustFlagsAndWidth(elseKeyword);
         this.elseKeyword = elseKeyword;
      }
      var statement = (StatementSyntax)reader.ReadValue();
      if (statement != null)
      {
         AdjustFlagsAndWidth(statement);
         this.statement = statement;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.elseKeyword);
      writer.WriteValue(this.statement);
    }

    static ElseClauseSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ElseClauseSyntax), r => new ElseClauseSyntax(r));
    }
  }

  /// <summary>Represents a switch statement syntax.</summary>
  internal sealed partial class SwitchStatementSyntax : StatementSyntax
  {
    internal readonly SyntaxToken switchKeyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken closeParenToken;
    internal readonly SyntaxToken openBraceToken;
    internal readonly GreenNode sections;
    internal readonly SyntaxToken closeBraceToken;

    internal SwitchStatementSyntax(SyntaxKind kind, SyntaxToken switchKeyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, SyntaxToken openBraceToken, GreenNode sections, SyntaxToken closeBraceToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 7;
        this.AdjustFlagsAndWidth(switchKeyword);
        this.switchKeyword = switchKeyword;
        if (openParenToken != null)
        {
            this.AdjustFlagsAndWidth(openParenToken);
            this.openParenToken = openParenToken;
        }
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        if (closeParenToken != null)
        {
            this.AdjustFlagsAndWidth(closeParenToken);
            this.closeParenToken = closeParenToken;
        }
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (sections != null)
        {
            this.AdjustFlagsAndWidth(sections);
            this.sections = sections;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }


    internal SwitchStatementSyntax(SyntaxKind kind, SyntaxToken switchKeyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, SyntaxToken openBraceToken, GreenNode sections, SyntaxToken closeBraceToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 7;
        this.AdjustFlagsAndWidth(switchKeyword);
        this.switchKeyword = switchKeyword;
        if (openParenToken != null)
        {
            this.AdjustFlagsAndWidth(openParenToken);
            this.openParenToken = openParenToken;
        }
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        if (closeParenToken != null)
        {
            this.AdjustFlagsAndWidth(closeParenToken);
            this.closeParenToken = closeParenToken;
        }
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (sections != null)
        {
            this.AdjustFlagsAndWidth(sections);
            this.sections = sections;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }


    internal SwitchStatementSyntax(SyntaxKind kind, SyntaxToken switchKeyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, SyntaxToken openBraceToken, GreenNode sections, SyntaxToken closeBraceToken)
        : base(kind)
    {
        this.SlotCount = 7;
        this.AdjustFlagsAndWidth(switchKeyword);
        this.switchKeyword = switchKeyword;
        if (openParenToken != null)
        {
            this.AdjustFlagsAndWidth(openParenToken);
            this.openParenToken = openParenToken;
        }
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        if (closeParenToken != null)
        {
            this.AdjustFlagsAndWidth(closeParenToken);
            this.closeParenToken = closeParenToken;
        }
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (sections != null)
        {
            this.AdjustFlagsAndWidth(sections);
            this.sections = sections;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    /// <summary>
    /// Gets a SyntaxToken that represents the switch keyword.
    /// </summary>
    public SyntaxToken SwitchKeyword => this.switchKeyword;
    /// <summary>
    /// Gets a SyntaxToken that represents the open parenthesis preceding the switch governing expression.
    /// </summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>
    /// Gets an ExpressionSyntax representing the expression of the switch statement.
    /// </summary>
    public ExpressionSyntax Expression => this.expression;
    /// <summary>
    /// Gets a SyntaxToken that represents the close parenthesis following the switch governing expression.
    /// </summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;
    /// <summary>
    /// Gets a SyntaxToken that represents the open braces preceding the switch sections.
    /// </summary>
    public SyntaxToken OpenBraceToken => this.openBraceToken;
    /// <summary>
    /// Gets a SyntaxList of SwitchSectionSyntax's that represents the switch sections of the switch statement.
    /// </summary>
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SwitchSectionSyntax> Sections => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SwitchSectionSyntax>(this.sections);
    /// <summary>
    /// Gets a SyntaxToken that represents the open braces following the switch sections.
    /// </summary>
    public SyntaxToken CloseBraceToken => this.closeBraceToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.switchKeyword;
            case 1: return this.openParenToken;
            case 2: return this.expression;
            case 3: return this.closeParenToken;
            case 4: return this.openBraceToken;
            case 5: return this.sections;
            case 6: return this.closeBraceToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.SwitchStatementSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitSwitchStatement(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitSwitchStatement(this);

    public SwitchStatementSyntax Update(SyntaxToken switchKeyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, SyntaxToken openBraceToken, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SwitchSectionSyntax> sections, SyntaxToken closeBraceToken)
    {
        if (switchKeyword != this.SwitchKeyword || openParenToken != this.OpenParenToken || expression != this.Expression || closeParenToken != this.CloseParenToken || openBraceToken != this.OpenBraceToken || sections != this.Sections || closeBraceToken != this.CloseBraceToken)
        {
            var newNode = SyntaxFactory.SwitchStatement(switchKeyword, openParenToken, expression, closeParenToken, openBraceToken, sections, closeBraceToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new SwitchStatementSyntax(this.Kind, this.switchKeyword, this.openParenToken, this.expression, this.closeParenToken, this.openBraceToken, this.sections, this.closeBraceToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new SwitchStatementSyntax(this.Kind, this.switchKeyword, this.openParenToken, this.expression, this.closeParenToken, this.openBraceToken, this.sections, this.closeBraceToken, GetDiagnostics(), annotations);

    internal SwitchStatementSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 7;
      var switchKeyword = (SyntaxToken)reader.ReadValue();
      if (switchKeyword != null)
      {
         AdjustFlagsAndWidth(switchKeyword);
         this.switchKeyword = switchKeyword;
      }
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
      var openBraceToken = (SyntaxToken)reader.ReadValue();
      if (openBraceToken != null)
      {
         AdjustFlagsAndWidth(openBraceToken);
         this.openBraceToken = openBraceToken;
      }
      var sections = (GreenNode)reader.ReadValue();
      if (sections != null)
      {
         AdjustFlagsAndWidth(sections);
         this.sections = sections;
      }
      var closeBraceToken = (SyntaxToken)reader.ReadValue();
      if (closeBraceToken != null)
      {
         AdjustFlagsAndWidth(closeBraceToken);
         this.closeBraceToken = closeBraceToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.switchKeyword);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.expression);
      writer.WriteValue(this.closeParenToken);
      writer.WriteValue(this.openBraceToken);
      writer.WriteValue(this.sections);
      writer.WriteValue(this.closeBraceToken);
    }

    static SwitchStatementSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(SwitchStatementSyntax), r => new SwitchStatementSyntax(r));
    }
  }

  /// <summary>Represents a switch section syntax of a switch statement.</summary>
  internal sealed partial class SwitchSectionSyntax : CSharpSyntaxNode
  {
    internal readonly GreenNode labels;
    internal readonly GreenNode statements;

    internal SwitchSectionSyntax(SyntaxKind kind, GreenNode labels, GreenNode statements, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        if (labels != null)
        {
            this.AdjustFlagsAndWidth(labels);
            this.labels = labels;
        }
        if (statements != null)
        {
            this.AdjustFlagsAndWidth(statements);
            this.statements = statements;
        }
    }


    internal SwitchSectionSyntax(SyntaxKind kind, GreenNode labels, GreenNode statements, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        if (labels != null)
        {
            this.AdjustFlagsAndWidth(labels);
            this.labels = labels;
        }
        if (statements != null)
        {
            this.AdjustFlagsAndWidth(statements);
            this.statements = statements;
        }
    }


    internal SwitchSectionSyntax(SyntaxKind kind, GreenNode labels, GreenNode statements)
        : base(kind)
    {
        this.SlotCount = 2;
        if (labels != null)
        {
            this.AdjustFlagsAndWidth(labels);
            this.labels = labels;
        }
        if (statements != null)
        {
            this.AdjustFlagsAndWidth(statements);
            this.statements = statements;
        }
    }

    /// <summary>
    /// Gets a SyntaxList of SwitchLabelSyntax's the represents the possible labels that control can transfer to within the section.
    /// </summary>
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SwitchLabelSyntax> Labels => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SwitchLabelSyntax>(this.labels);
    /// <summary>
    /// Gets a SyntaxList of StatementSyntax's the represents the statements to be executed when control transfer to a label the belongs to the section.
    /// </summary>
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<StatementSyntax> Statements => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<StatementSyntax>(this.statements);

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.labels;
            case 1: return this.statements;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.SwitchSectionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitSwitchSection(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitSwitchSection(this);

    public SwitchSectionSyntax Update(Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SwitchLabelSyntax> labels, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<StatementSyntax> statements)
    {
        if (labels != this.Labels || statements != this.Statements)
        {
            var newNode = SyntaxFactory.SwitchSection(labels, statements);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new SwitchSectionSyntax(this.Kind, this.labels, this.statements, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new SwitchSectionSyntax(this.Kind, this.labels, this.statements, GetDiagnostics(), annotations);

    internal SwitchSectionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var labels = (GreenNode)reader.ReadValue();
      if (labels != null)
      {
         AdjustFlagsAndWidth(labels);
         this.labels = labels;
      }
      var statements = (GreenNode)reader.ReadValue();
      if (statements != null)
      {
         AdjustFlagsAndWidth(statements);
         this.statements = statements;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.labels);
      writer.WriteValue(this.statements);
    }

    static SwitchSectionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(SwitchSectionSyntax), r => new SwitchSectionSyntax(r));
    }
  }

  /// <summary>Represents a switch label within a switch statement.</summary>
  internal abstract partial class SwitchLabelSyntax : CSharpSyntaxNode
  {
    internal SwitchLabelSyntax(SyntaxKind kind, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal SwitchLabelSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    protected SwitchLabelSyntax(ObjectReader reader)
       : base(reader)
    {
    }

    /// <summary>
    /// Gets a SyntaxToken that represents a case or default keyword that belongs to a switch label.
    /// </summary>
    public abstract SyntaxToken Keyword { get; }

    /// <summary>
    /// Gets a SyntaxToken that represents the colon that terminates the switch label.
    /// </summary>
    public abstract SyntaxToken ColonToken { get; }
  }

  /// <summary>Represents a case label within a switch statement.</summary>
  internal sealed partial class CasePatternSwitchLabelSyntax : SwitchLabelSyntax
  {
    internal readonly SyntaxToken keyword;
    internal readonly PatternSyntax pattern;
    internal readonly WhenClauseSyntax whenClause;
    internal readonly SyntaxToken colonToken;

    internal CasePatternSwitchLabelSyntax(SyntaxKind kind, SyntaxToken keyword, PatternSyntax pattern, WhenClauseSyntax whenClause, SyntaxToken colonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
        if (whenClause != null)
        {
            this.AdjustFlagsAndWidth(whenClause);
            this.whenClause = whenClause;
        }
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }


    internal CasePatternSwitchLabelSyntax(SyntaxKind kind, SyntaxToken keyword, PatternSyntax pattern, WhenClauseSyntax whenClause, SyntaxToken colonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
        if (whenClause != null)
        {
            this.AdjustFlagsAndWidth(whenClause);
            this.whenClause = whenClause;
        }
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }


    internal CasePatternSwitchLabelSyntax(SyntaxKind kind, SyntaxToken keyword, PatternSyntax pattern, WhenClauseSyntax whenClause, SyntaxToken colonToken)
        : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
        if (whenClause != null)
        {
            this.AdjustFlagsAndWidth(whenClause);
            this.whenClause = whenClause;
        }
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }

    /// <summary>Gets the case keyword token.</summary>
    public override SyntaxToken Keyword => this.keyword;
    /// <summary>
    /// Gets a PatternSyntax that represents the pattern that gets matched for the case label.
    /// </summary>
    public PatternSyntax Pattern => this.pattern;
    public WhenClauseSyntax WhenClause => this.whenClause;
    public override SyntaxToken ColonToken => this.colonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.keyword;
            case 1: return this.pattern;
            case 2: return this.whenClause;
            case 3: return this.colonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.CasePatternSwitchLabelSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitCasePatternSwitchLabel(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitCasePatternSwitchLabel(this);

    public CasePatternSwitchLabelSyntax Update(SyntaxToken keyword, PatternSyntax pattern, WhenClauseSyntax whenClause, SyntaxToken colonToken)
    {
        if (keyword != this.Keyword || pattern != this.Pattern || whenClause != this.WhenClause || colonToken != this.ColonToken)
        {
            var newNode = SyntaxFactory.CasePatternSwitchLabel(keyword, pattern, whenClause, colonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new CasePatternSwitchLabelSyntax(this.Kind, this.keyword, this.pattern, this.whenClause, this.colonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new CasePatternSwitchLabelSyntax(this.Kind, this.keyword, this.pattern, this.whenClause, this.colonToken, GetDiagnostics(), annotations);

    internal CasePatternSwitchLabelSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var keyword = (SyntaxToken)reader.ReadValue();
      if (keyword != null)
      {
         AdjustFlagsAndWidth(keyword);
         this.keyword = keyword;
      }
      var pattern = (PatternSyntax)reader.ReadValue();
      if (pattern != null)
      {
         AdjustFlagsAndWidth(pattern);
         this.pattern = pattern;
      }
      var whenClause = (WhenClauseSyntax)reader.ReadValue();
      if (whenClause != null)
      {
         AdjustFlagsAndWidth(whenClause);
         this.whenClause = whenClause;
      }
      var colonToken = (SyntaxToken)reader.ReadValue();
      if (colonToken != null)
      {
         AdjustFlagsAndWidth(colonToken);
         this.colonToken = colonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.keyword);
      writer.WriteValue(this.pattern);
      writer.WriteValue(this.whenClause);
      writer.WriteValue(this.colonToken);
    }

    static CasePatternSwitchLabelSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(CasePatternSwitchLabelSyntax), r => new CasePatternSwitchLabelSyntax(r));
    }
  }

  /// <summary>Represents a case label within a switch statement.</summary>
  internal sealed partial class CaseSwitchLabelSyntax : SwitchLabelSyntax
  {
    internal readonly SyntaxToken keyword;
    internal readonly ExpressionSyntax value;
    internal readonly SyntaxToken colonToken;

    internal CaseSwitchLabelSyntax(SyntaxKind kind, SyntaxToken keyword, ExpressionSyntax value, SyntaxToken colonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(value);
        this.value = value;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }


    internal CaseSwitchLabelSyntax(SyntaxKind kind, SyntaxToken keyword, ExpressionSyntax value, SyntaxToken colonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(value);
        this.value = value;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }


    internal CaseSwitchLabelSyntax(SyntaxKind kind, SyntaxToken keyword, ExpressionSyntax value, SyntaxToken colonToken)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(value);
        this.value = value;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }

    /// <summary>Gets the case keyword token.</summary>
    public override SyntaxToken Keyword => this.keyword;
    /// <summary>
    /// Gets an ExpressionSyntax that represents the constant expression that gets matched for the case label.
    /// </summary>
    public ExpressionSyntax Value => this.value;
    public override SyntaxToken ColonToken => this.colonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.keyword;
            case 1: return this.value;
            case 2: return this.colonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.CaseSwitchLabelSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitCaseSwitchLabel(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitCaseSwitchLabel(this);

    public CaseSwitchLabelSyntax Update(SyntaxToken keyword, ExpressionSyntax value, SyntaxToken colonToken)
    {
        if (keyword != this.Keyword || value != this.Value || colonToken != this.ColonToken)
        {
            var newNode = SyntaxFactory.CaseSwitchLabel(keyword, value, colonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new CaseSwitchLabelSyntax(this.Kind, this.keyword, this.value, this.colonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new CaseSwitchLabelSyntax(this.Kind, this.keyword, this.value, this.colonToken, GetDiagnostics(), annotations);

    internal CaseSwitchLabelSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var keyword = (SyntaxToken)reader.ReadValue();
      if (keyword != null)
      {
         AdjustFlagsAndWidth(keyword);
         this.keyword = keyword;
      }
      var value = (ExpressionSyntax)reader.ReadValue();
      if (value != null)
      {
         AdjustFlagsAndWidth(value);
         this.value = value;
      }
      var colonToken = (SyntaxToken)reader.ReadValue();
      if (colonToken != null)
      {
         AdjustFlagsAndWidth(colonToken);
         this.colonToken = colonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.keyword);
      writer.WriteValue(this.value);
      writer.WriteValue(this.colonToken);
    }

    static CaseSwitchLabelSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(CaseSwitchLabelSyntax), r => new CaseSwitchLabelSyntax(r));
    }
  }

  /// <summary>Represents a default label within a switch statement.</summary>
  internal sealed partial class DefaultSwitchLabelSyntax : SwitchLabelSyntax
  {
    internal readonly SyntaxToken keyword;
    internal readonly SyntaxToken colonToken;

    internal DefaultSwitchLabelSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken colonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }


    internal DefaultSwitchLabelSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken colonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }


    internal DefaultSwitchLabelSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken colonToken)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }

    /// <summary>Gets the default keyword token.</summary>
    public override SyntaxToken Keyword => this.keyword;
    public override SyntaxToken ColonToken => this.colonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.keyword;
            case 1: return this.colonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.DefaultSwitchLabelSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitDefaultSwitchLabel(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitDefaultSwitchLabel(this);

    public DefaultSwitchLabelSyntax Update(SyntaxToken keyword, SyntaxToken colonToken)
    {
        if (keyword != this.Keyword || colonToken != this.ColonToken)
        {
            var newNode = SyntaxFactory.DefaultSwitchLabel(keyword, colonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new DefaultSwitchLabelSyntax(this.Kind, this.keyword, this.colonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new DefaultSwitchLabelSyntax(this.Kind, this.keyword, this.colonToken, GetDiagnostics(), annotations);

    internal DefaultSwitchLabelSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var keyword = (SyntaxToken)reader.ReadValue();
      if (keyword != null)
      {
         AdjustFlagsAndWidth(keyword);
         this.keyword = keyword;
      }
      var colonToken = (SyntaxToken)reader.ReadValue();
      if (colonToken != null)
      {
         AdjustFlagsAndWidth(colonToken);
         this.colonToken = colonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.keyword);
      writer.WriteValue(this.colonToken);
    }

    static DefaultSwitchLabelSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(DefaultSwitchLabelSyntax), r => new DefaultSwitchLabelSyntax(r));
    }
  }

  internal sealed partial class SwitchExpressionSyntax : ExpressionSyntax
  {
    internal readonly ExpressionSyntax governingExpression;
    internal readonly SyntaxToken switchKeyword;
    internal readonly SyntaxToken openBraceToken;
    internal readonly GreenNode arms;
    internal readonly SyntaxToken closeBraceToken;

    internal SwitchExpressionSyntax(SyntaxKind kind, ExpressionSyntax governingExpression, SyntaxToken switchKeyword, SyntaxToken openBraceToken, GreenNode arms, SyntaxToken closeBraceToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(governingExpression);
        this.governingExpression = governingExpression;
        this.AdjustFlagsAndWidth(switchKeyword);
        this.switchKeyword = switchKeyword;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (arms != null)
        {
            this.AdjustFlagsAndWidth(arms);
            this.arms = arms;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }


    internal SwitchExpressionSyntax(SyntaxKind kind, ExpressionSyntax governingExpression, SyntaxToken switchKeyword, SyntaxToken openBraceToken, GreenNode arms, SyntaxToken closeBraceToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(governingExpression);
        this.governingExpression = governingExpression;
        this.AdjustFlagsAndWidth(switchKeyword);
        this.switchKeyword = switchKeyword;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (arms != null)
        {
            this.AdjustFlagsAndWidth(arms);
            this.arms = arms;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }


    internal SwitchExpressionSyntax(SyntaxKind kind, ExpressionSyntax governingExpression, SyntaxToken switchKeyword, SyntaxToken openBraceToken, GreenNode arms, SyntaxToken closeBraceToken)
        : base(kind)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(governingExpression);
        this.governingExpression = governingExpression;
        this.AdjustFlagsAndWidth(switchKeyword);
        this.switchKeyword = switchKeyword;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (arms != null)
        {
            this.AdjustFlagsAndWidth(arms);
            this.arms = arms;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    public ExpressionSyntax GoverningExpression => this.governingExpression;
    public SyntaxToken SwitchKeyword => this.switchKeyword;
    public SyntaxToken OpenBraceToken => this.openBraceToken;
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<SwitchExpressionArmSyntax> Arms => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<SwitchExpressionArmSyntax>(new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<CSharpSyntaxNode>(this.arms));
    public SyntaxToken CloseBraceToken => this.closeBraceToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.governingExpression;
            case 1: return this.switchKeyword;
            case 2: return this.openBraceToken;
            case 3: return this.arms;
            case 4: return this.closeBraceToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.SwitchExpressionSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitSwitchExpression(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitSwitchExpression(this);

    public SwitchExpressionSyntax Update(ExpressionSyntax governingExpression, SyntaxToken switchKeyword, SyntaxToken openBraceToken, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<SwitchExpressionArmSyntax> arms, SyntaxToken closeBraceToken)
    {
        if (governingExpression != this.GoverningExpression || switchKeyword != this.SwitchKeyword || openBraceToken != this.OpenBraceToken || arms != this.Arms || closeBraceToken != this.CloseBraceToken)
        {
            var newNode = SyntaxFactory.SwitchExpression(governingExpression, switchKeyword, openBraceToken, arms, closeBraceToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new SwitchExpressionSyntax(this.Kind, this.governingExpression, this.switchKeyword, this.openBraceToken, this.arms, this.closeBraceToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new SwitchExpressionSyntax(this.Kind, this.governingExpression, this.switchKeyword, this.openBraceToken, this.arms, this.closeBraceToken, GetDiagnostics(), annotations);

    internal SwitchExpressionSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 5;
      var governingExpression = (ExpressionSyntax)reader.ReadValue();
      if (governingExpression != null)
      {
         AdjustFlagsAndWidth(governingExpression);
         this.governingExpression = governingExpression;
      }
      var switchKeyword = (SyntaxToken)reader.ReadValue();
      if (switchKeyword != null)
      {
         AdjustFlagsAndWidth(switchKeyword);
         this.switchKeyword = switchKeyword;
      }
      var openBraceToken = (SyntaxToken)reader.ReadValue();
      if (openBraceToken != null)
      {
         AdjustFlagsAndWidth(openBraceToken);
         this.openBraceToken = openBraceToken;
      }
      var arms = (GreenNode)reader.ReadValue();
      if (arms != null)
      {
         AdjustFlagsAndWidth(arms);
         this.arms = arms;
      }
      var closeBraceToken = (SyntaxToken)reader.ReadValue();
      if (closeBraceToken != null)
      {
         AdjustFlagsAndWidth(closeBraceToken);
         this.closeBraceToken = closeBraceToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.governingExpression);
      writer.WriteValue(this.switchKeyword);
      writer.WriteValue(this.openBraceToken);
      writer.WriteValue(this.arms);
      writer.WriteValue(this.closeBraceToken);
    }

    static SwitchExpressionSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(SwitchExpressionSyntax), r => new SwitchExpressionSyntax(r));
    }
  }

  internal sealed partial class SwitchExpressionArmSyntax : CSharpSyntaxNode
  {
    internal readonly PatternSyntax pattern;
    internal readonly WhenClauseSyntax whenClause;
    internal readonly SyntaxToken equalsGreaterThanToken;
    internal readonly ExpressionSyntax expression;

    internal SwitchExpressionArmSyntax(SyntaxKind kind, PatternSyntax pattern, WhenClauseSyntax whenClause, SyntaxToken equalsGreaterThanToken, ExpressionSyntax expression, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
        if (whenClause != null)
        {
            this.AdjustFlagsAndWidth(whenClause);
            this.whenClause = whenClause;
        }
        this.AdjustFlagsAndWidth(equalsGreaterThanToken);
        this.equalsGreaterThanToken = equalsGreaterThanToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }


    internal SwitchExpressionArmSyntax(SyntaxKind kind, PatternSyntax pattern, WhenClauseSyntax whenClause, SyntaxToken equalsGreaterThanToken, ExpressionSyntax expression, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
        if (whenClause != null)
        {
            this.AdjustFlagsAndWidth(whenClause);
            this.whenClause = whenClause;
        }
        this.AdjustFlagsAndWidth(equalsGreaterThanToken);
        this.equalsGreaterThanToken = equalsGreaterThanToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }


    internal SwitchExpressionArmSyntax(SyntaxKind kind, PatternSyntax pattern, WhenClauseSyntax whenClause, SyntaxToken equalsGreaterThanToken, ExpressionSyntax expression)
        : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
        if (whenClause != null)
        {
            this.AdjustFlagsAndWidth(whenClause);
            this.whenClause = whenClause;
        }
        this.AdjustFlagsAndWidth(equalsGreaterThanToken);
        this.equalsGreaterThanToken = equalsGreaterThanToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    public PatternSyntax Pattern => this.pattern;
    public WhenClauseSyntax WhenClause => this.whenClause;
    public SyntaxToken EqualsGreaterThanToken => this.equalsGreaterThanToken;
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.pattern;
            case 1: return this.whenClause;
            case 2: return this.equalsGreaterThanToken;
            case 3: return this.expression;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.SwitchExpressionArmSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitSwitchExpressionArm(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitSwitchExpressionArm(this);

    public SwitchExpressionArmSyntax Update(PatternSyntax pattern, WhenClauseSyntax whenClause, SyntaxToken equalsGreaterThanToken, ExpressionSyntax expression)
    {
        if (pattern != this.Pattern || whenClause != this.WhenClause || equalsGreaterThanToken != this.EqualsGreaterThanToken || expression != this.Expression)
        {
            var newNode = SyntaxFactory.SwitchExpressionArm(pattern, whenClause, equalsGreaterThanToken, expression);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new SwitchExpressionArmSyntax(this.Kind, this.pattern, this.whenClause, this.equalsGreaterThanToken, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new SwitchExpressionArmSyntax(this.Kind, this.pattern, this.whenClause, this.equalsGreaterThanToken, this.expression, GetDiagnostics(), annotations);

    internal SwitchExpressionArmSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var pattern = (PatternSyntax)reader.ReadValue();
      if (pattern != null)
      {
         AdjustFlagsAndWidth(pattern);
         this.pattern = pattern;
      }
      var whenClause = (WhenClauseSyntax)reader.ReadValue();
      if (whenClause != null)
      {
         AdjustFlagsAndWidth(whenClause);
         this.whenClause = whenClause;
      }
      var equalsGreaterThanToken = (SyntaxToken)reader.ReadValue();
      if (equalsGreaterThanToken != null)
      {
         AdjustFlagsAndWidth(equalsGreaterThanToken);
         this.equalsGreaterThanToken = equalsGreaterThanToken;
      }
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.pattern);
      writer.WriteValue(this.whenClause);
      writer.WriteValue(this.equalsGreaterThanToken);
      writer.WriteValue(this.expression);
    }

    static SwitchExpressionArmSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(SwitchExpressionArmSyntax), r => new SwitchExpressionArmSyntax(r));
    }
  }

  internal sealed partial class TryStatementSyntax : StatementSyntax
  {
    internal readonly SyntaxToken tryKeyword;
    internal readonly BlockSyntax block;
    internal readonly GreenNode catches;
    internal readonly FinallyClauseSyntax @finally;

    internal TryStatementSyntax(SyntaxKind kind, SyntaxToken tryKeyword, BlockSyntax block, GreenNode catches, FinallyClauseSyntax @finally, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(tryKeyword);
        this.tryKeyword = tryKeyword;
        this.AdjustFlagsAndWidth(block);
        this.block = block;
        if (catches != null)
        {
            this.AdjustFlagsAndWidth(catches);
            this.catches = catches;
        }
        if (@finally != null)
        {
            this.AdjustFlagsAndWidth(@finally);
            this.@finally = @finally;
        }
    }


    internal TryStatementSyntax(SyntaxKind kind, SyntaxToken tryKeyword, BlockSyntax block, GreenNode catches, FinallyClauseSyntax @finally, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(tryKeyword);
        this.tryKeyword = tryKeyword;
        this.AdjustFlagsAndWidth(block);
        this.block = block;
        if (catches != null)
        {
            this.AdjustFlagsAndWidth(catches);
            this.catches = catches;
        }
        if (@finally != null)
        {
            this.AdjustFlagsAndWidth(@finally);
            this.@finally = @finally;
        }
    }


    internal TryStatementSyntax(SyntaxKind kind, SyntaxToken tryKeyword, BlockSyntax block, GreenNode catches, FinallyClauseSyntax @finally)
        : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(tryKeyword);
        this.tryKeyword = tryKeyword;
        this.AdjustFlagsAndWidth(block);
        this.block = block;
        if (catches != null)
        {
            this.AdjustFlagsAndWidth(catches);
            this.catches = catches;
        }
        if (@finally != null)
        {
            this.AdjustFlagsAndWidth(@finally);
            this.@finally = @finally;
        }
    }

    public SyntaxToken TryKeyword => this.tryKeyword;
    public BlockSyntax Block => this.block;
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<CatchClauseSyntax> Catches => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<CatchClauseSyntax>(this.catches);
    public FinallyClauseSyntax Finally => this.@finally;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.tryKeyword;
            case 1: return this.block;
            case 2: return this.catches;
            case 3: return this.@finally;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.TryStatementSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitTryStatement(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitTryStatement(this);

    public TryStatementSyntax Update(SyntaxToken tryKeyword, BlockSyntax block, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<CatchClauseSyntax> catches, FinallyClauseSyntax @finally)
    {
        if (tryKeyword != this.TryKeyword || block != this.Block || catches != this.Catches || @finally != this.Finally)
        {
            var newNode = SyntaxFactory.TryStatement(tryKeyword, block, catches, @finally);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new TryStatementSyntax(this.Kind, this.tryKeyword, this.block, this.catches, this.@finally, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new TryStatementSyntax(this.Kind, this.tryKeyword, this.block, this.catches, this.@finally, GetDiagnostics(), annotations);

    internal TryStatementSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var tryKeyword = (SyntaxToken)reader.ReadValue();
      if (tryKeyword != null)
      {
         AdjustFlagsAndWidth(tryKeyword);
         this.tryKeyword = tryKeyword;
      }
      var block = (BlockSyntax)reader.ReadValue();
      if (block != null)
      {
         AdjustFlagsAndWidth(block);
         this.block = block;
      }
      var catches = (GreenNode)reader.ReadValue();
      if (catches != null)
      {
         AdjustFlagsAndWidth(catches);
         this.catches = catches;
      }
      var @finally = (FinallyClauseSyntax)reader.ReadValue();
      if (@finally != null)
      {
         AdjustFlagsAndWidth(@finally);
         this.@finally = @finally;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.tryKeyword);
      writer.WriteValue(this.block);
      writer.WriteValue(this.catches);
      writer.WriteValue(this.@finally);
    }

    static TryStatementSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(TryStatementSyntax), r => new TryStatementSyntax(r));
    }
  }

  internal sealed partial class CatchClauseSyntax : CSharpSyntaxNode
  {
    internal readonly SyntaxToken catchKeyword;
    internal readonly CatchDeclarationSyntax declaration;
    internal readonly CatchFilterClauseSyntax filter;
    internal readonly BlockSyntax block;

    internal CatchClauseSyntax(SyntaxKind kind, SyntaxToken catchKeyword, CatchDeclarationSyntax declaration, CatchFilterClauseSyntax filter, BlockSyntax block, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(catchKeyword);
        this.catchKeyword = catchKeyword;
        if (declaration != null)
        {
            this.AdjustFlagsAndWidth(declaration);
            this.declaration = declaration;
        }
        if (filter != null)
        {
            this.AdjustFlagsAndWidth(filter);
            this.filter = filter;
        }
        this.AdjustFlagsAndWidth(block);
        this.block = block;
    }


    internal CatchClauseSyntax(SyntaxKind kind, SyntaxToken catchKeyword, CatchDeclarationSyntax declaration, CatchFilterClauseSyntax filter, BlockSyntax block, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(catchKeyword);
        this.catchKeyword = catchKeyword;
        if (declaration != null)
        {
            this.AdjustFlagsAndWidth(declaration);
            this.declaration = declaration;
        }
        if (filter != null)
        {
            this.AdjustFlagsAndWidth(filter);
            this.filter = filter;
        }
        this.AdjustFlagsAndWidth(block);
        this.block = block;
    }


    internal CatchClauseSyntax(SyntaxKind kind, SyntaxToken catchKeyword, CatchDeclarationSyntax declaration, CatchFilterClauseSyntax filter, BlockSyntax block)
        : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(catchKeyword);
        this.catchKeyword = catchKeyword;
        if (declaration != null)
        {
            this.AdjustFlagsAndWidth(declaration);
            this.declaration = declaration;
        }
        if (filter != null)
        {
            this.AdjustFlagsAndWidth(filter);
            this.filter = filter;
        }
        this.AdjustFlagsAndWidth(block);
        this.block = block;
    }

    public SyntaxToken CatchKeyword => this.catchKeyword;
    public CatchDeclarationSyntax Declaration => this.declaration;
    public CatchFilterClauseSyntax Filter => this.filter;
    public BlockSyntax Block => this.block;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.catchKeyword;
            case 1: return this.declaration;
            case 2: return this.filter;
            case 3: return this.block;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.CatchClauseSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitCatchClause(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitCatchClause(this);

    public CatchClauseSyntax Update(SyntaxToken catchKeyword, CatchDeclarationSyntax declaration, CatchFilterClauseSyntax filter, BlockSyntax block)
    {
        if (catchKeyword != this.CatchKeyword || declaration != this.Declaration || filter != this.Filter || block != this.Block)
        {
            var newNode = SyntaxFactory.CatchClause(catchKeyword, declaration, filter, block);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new CatchClauseSyntax(this.Kind, this.catchKeyword, this.declaration, this.filter, this.block, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new CatchClauseSyntax(this.Kind, this.catchKeyword, this.declaration, this.filter, this.block, GetDiagnostics(), annotations);

    internal CatchClauseSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var catchKeyword = (SyntaxToken)reader.ReadValue();
      if (catchKeyword != null)
      {
         AdjustFlagsAndWidth(catchKeyword);
         this.catchKeyword = catchKeyword;
      }
      var declaration = (CatchDeclarationSyntax)reader.ReadValue();
      if (declaration != null)
      {
         AdjustFlagsAndWidth(declaration);
         this.declaration = declaration;
      }
      var filter = (CatchFilterClauseSyntax)reader.ReadValue();
      if (filter != null)
      {
         AdjustFlagsAndWidth(filter);
         this.filter = filter;
      }
      var block = (BlockSyntax)reader.ReadValue();
      if (block != null)
      {
         AdjustFlagsAndWidth(block);
         this.block = block;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.catchKeyword);
      writer.WriteValue(this.declaration);
      writer.WriteValue(this.filter);
      writer.WriteValue(this.block);
    }

    static CatchClauseSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(CatchClauseSyntax), r => new CatchClauseSyntax(r));
    }
  }

  internal sealed partial class CatchDeclarationSyntax : CSharpSyntaxNode
  {
    internal readonly SyntaxToken openParenToken;
    internal readonly TypeSyntax type;
    internal readonly SyntaxToken identifier;
    internal readonly SyntaxToken closeParenToken;

    internal CatchDeclarationSyntax(SyntaxKind kind, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken identifier, SyntaxToken closeParenToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (identifier != null)
        {
            this.AdjustFlagsAndWidth(identifier);
            this.identifier = identifier;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal CatchDeclarationSyntax(SyntaxKind kind, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken identifier, SyntaxToken closeParenToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (identifier != null)
        {
            this.AdjustFlagsAndWidth(identifier);
            this.identifier = identifier;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal CatchDeclarationSyntax(SyntaxKind kind, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken identifier, SyntaxToken closeParenToken)
        : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (identifier != null)
        {
            this.AdjustFlagsAndWidth(identifier);
            this.identifier = identifier;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    public SyntaxToken OpenParenToken => this.openParenToken;
    public TypeSyntax Type => this.type;
    public SyntaxToken Identifier => this.identifier;
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.openParenToken;
            case 1: return this.type;
            case 2: return this.identifier;
            case 3: return this.closeParenToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.CatchDeclarationSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitCatchDeclaration(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitCatchDeclaration(this);

    public CatchDeclarationSyntax Update(SyntaxToken openParenToken, TypeSyntax type, SyntaxToken identifier, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || type != this.Type || identifier != this.Identifier || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.CatchDeclaration(openParenToken, type, identifier, closeParenToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new CatchDeclarationSyntax(this.Kind, this.openParenToken, this.type, this.identifier, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new CatchDeclarationSyntax(this.Kind, this.openParenToken, this.type, this.identifier, this.closeParenToken, GetDiagnostics(), annotations);

    internal CatchDeclarationSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var type = (TypeSyntax)reader.ReadValue();
      if (type != null)
      {
         AdjustFlagsAndWidth(type);
         this.type = type;
      }
      var identifier = (SyntaxToken)reader.ReadValue();
      if (identifier != null)
      {
         AdjustFlagsAndWidth(identifier);
         this.identifier = identifier;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.type);
      writer.WriteValue(this.identifier);
      writer.WriteValue(this.closeParenToken);
    }

    static CatchDeclarationSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(CatchDeclarationSyntax), r => new CatchDeclarationSyntax(r));
    }
  }

  internal sealed partial class CatchFilterClauseSyntax : CSharpSyntaxNode
  {
    internal readonly SyntaxToken whenKeyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly ExpressionSyntax filterExpression;
    internal readonly SyntaxToken closeParenToken;

    internal CatchFilterClauseSyntax(SyntaxKind kind, SyntaxToken whenKeyword, SyntaxToken openParenToken, ExpressionSyntax filterExpression, SyntaxToken closeParenToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(whenKeyword);
        this.whenKeyword = whenKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(filterExpression);
        this.filterExpression = filterExpression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal CatchFilterClauseSyntax(SyntaxKind kind, SyntaxToken whenKeyword, SyntaxToken openParenToken, ExpressionSyntax filterExpression, SyntaxToken closeParenToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(whenKeyword);
        this.whenKeyword = whenKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(filterExpression);
        this.filterExpression = filterExpression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal CatchFilterClauseSyntax(SyntaxKind kind, SyntaxToken whenKeyword, SyntaxToken openParenToken, ExpressionSyntax filterExpression, SyntaxToken closeParenToken)
        : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(whenKeyword);
        this.whenKeyword = whenKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(filterExpression);
        this.filterExpression = filterExpression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    public SyntaxToken WhenKeyword => this.whenKeyword;
    public SyntaxToken OpenParenToken => this.openParenToken;
    public ExpressionSyntax FilterExpression => this.filterExpression;
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.whenKeyword;
            case 1: return this.openParenToken;
            case 2: return this.filterExpression;
            case 3: return this.closeParenToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.CatchFilterClauseSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitCatchFilterClause(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitCatchFilterClause(this);

    public CatchFilterClauseSyntax Update(SyntaxToken whenKeyword, SyntaxToken openParenToken, ExpressionSyntax filterExpression, SyntaxToken closeParenToken)
    {
        if (whenKeyword != this.WhenKeyword || openParenToken != this.OpenParenToken || filterExpression != this.FilterExpression || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.CatchFilterClause(whenKeyword, openParenToken, filterExpression, closeParenToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new CatchFilterClauseSyntax(this.Kind, this.whenKeyword, this.openParenToken, this.filterExpression, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new CatchFilterClauseSyntax(this.Kind, this.whenKeyword, this.openParenToken, this.filterExpression, this.closeParenToken, GetDiagnostics(), annotations);

    internal CatchFilterClauseSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var whenKeyword = (SyntaxToken)reader.ReadValue();
      if (whenKeyword != null)
      {
         AdjustFlagsAndWidth(whenKeyword);
         this.whenKeyword = whenKeyword;
      }
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var filterExpression = (ExpressionSyntax)reader.ReadValue();
      if (filterExpression != null)
      {
         AdjustFlagsAndWidth(filterExpression);
         this.filterExpression = filterExpression;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.whenKeyword);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.filterExpression);
      writer.WriteValue(this.closeParenToken);
    }

    static CatchFilterClauseSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(CatchFilterClauseSyntax), r => new CatchFilterClauseSyntax(r));
    }
  }

  internal sealed partial class FinallyClauseSyntax : CSharpSyntaxNode
  {
    internal readonly SyntaxToken finallyKeyword;
    internal readonly BlockSyntax block;

    internal FinallyClauseSyntax(SyntaxKind kind, SyntaxToken finallyKeyword, BlockSyntax block, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(finallyKeyword);
        this.finallyKeyword = finallyKeyword;
        this.AdjustFlagsAndWidth(block);
        this.block = block;
    }


    internal FinallyClauseSyntax(SyntaxKind kind, SyntaxToken finallyKeyword, BlockSyntax block, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(finallyKeyword);
        this.finallyKeyword = finallyKeyword;
        this.AdjustFlagsAndWidth(block);
        this.block = block;
    }


    internal FinallyClauseSyntax(SyntaxKind kind, SyntaxToken finallyKeyword, BlockSyntax block)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(finallyKeyword);
        this.finallyKeyword = finallyKeyword;
        this.AdjustFlagsAndWidth(block);
        this.block = block;
    }

    public SyntaxToken FinallyKeyword => this.finallyKeyword;
    public BlockSyntax Block => this.block;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.finallyKeyword;
            case 1: return this.block;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.FinallyClauseSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitFinallyClause(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitFinallyClause(this);

    public FinallyClauseSyntax Update(SyntaxToken finallyKeyword, BlockSyntax block)
    {
        if (finallyKeyword != this.FinallyKeyword || block != this.Block)
        {
            var newNode = SyntaxFactory.FinallyClause(finallyKeyword, block);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new FinallyClauseSyntax(this.Kind, this.finallyKeyword, this.block, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new FinallyClauseSyntax(this.Kind, this.finallyKeyword, this.block, GetDiagnostics(), annotations);

    internal FinallyClauseSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var finallyKeyword = (SyntaxToken)reader.ReadValue();
      if (finallyKeyword != null)
      {
         AdjustFlagsAndWidth(finallyKeyword);
         this.finallyKeyword = finallyKeyword;
      }
      var block = (BlockSyntax)reader.ReadValue();
      if (block != null)
      {
         AdjustFlagsAndWidth(block);
         this.block = block;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.finallyKeyword);
      writer.WriteValue(this.block);
    }

    static FinallyClauseSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(FinallyClauseSyntax), r => new FinallyClauseSyntax(r));
    }
  }

  internal sealed partial class CompilationUnitSyntax : CSharpSyntaxNode
  {
    internal readonly GreenNode externs;
    internal readonly GreenNode usings;
    internal readonly GreenNode attributeLists;
    internal readonly GreenNode members;
    internal readonly SyntaxToken endOfFileToken;

    internal CompilationUnitSyntax(SyntaxKind kind, GreenNode externs, GreenNode usings, GreenNode attributeLists, GreenNode members, SyntaxToken endOfFileToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 5;
        if (externs != null)
        {
            this.AdjustFlagsAndWidth(externs);
            this.externs = externs;
        }
        if (usings != null)
        {
            this.AdjustFlagsAndWidth(usings);
            this.usings = usings;
        }
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        this.AdjustFlagsAndWidth(endOfFileToken);
        this.endOfFileToken = endOfFileToken;
    }


    internal CompilationUnitSyntax(SyntaxKind kind, GreenNode externs, GreenNode usings, GreenNode attributeLists, GreenNode members, SyntaxToken endOfFileToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 5;
        if (externs != null)
        {
            this.AdjustFlagsAndWidth(externs);
            this.externs = externs;
        }
        if (usings != null)
        {
            this.AdjustFlagsAndWidth(usings);
            this.usings = usings;
        }
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        this.AdjustFlagsAndWidth(endOfFileToken);
        this.endOfFileToken = endOfFileToken;
    }


    internal CompilationUnitSyntax(SyntaxKind kind, GreenNode externs, GreenNode usings, GreenNode attributeLists, GreenNode members, SyntaxToken endOfFileToken)
        : base(kind)
    {
        this.SlotCount = 5;
        if (externs != null)
        {
            this.AdjustFlagsAndWidth(externs);
            this.externs = externs;
        }
        if (usings != null)
        {
            this.AdjustFlagsAndWidth(usings);
            this.usings = usings;
        }
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        this.AdjustFlagsAndWidth(endOfFileToken);
        this.endOfFileToken = endOfFileToken;
    }

    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<ExternAliasDirectiveSyntax> Externs => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<ExternAliasDirectiveSyntax>(this.externs);
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<UsingDirectiveSyntax> Usings => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<UsingDirectiveSyntax>(this.usings);
    /// <summary>Gets the attribute declaration list.</summary>
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<MemberDeclarationSyntax> Members => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<MemberDeclarationSyntax>(this.members);
    public SyntaxToken EndOfFileToken => this.endOfFileToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.externs;
            case 1: return this.usings;
            case 2: return this.attributeLists;
            case 3: return this.members;
            case 4: return this.endOfFileToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.CompilationUnitSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitCompilationUnit(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitCompilationUnit(this);

    public CompilationUnitSyntax Update(Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<ExternAliasDirectiveSyntax> externs, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<UsingDirectiveSyntax> usings, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> attributeLists, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<MemberDeclarationSyntax> members, SyntaxToken endOfFileToken)
    {
        if (externs != this.Externs || usings != this.Usings || attributeLists != this.AttributeLists || members != this.Members || endOfFileToken != this.EndOfFileToken)
        {
            var newNode = SyntaxFactory.CompilationUnit(externs, usings, attributeLists, members, endOfFileToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new CompilationUnitSyntax(this.Kind, this.externs, this.usings, this.attributeLists, this.members, this.endOfFileToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new CompilationUnitSyntax(this.Kind, this.externs, this.usings, this.attributeLists, this.members, this.endOfFileToken, GetDiagnostics(), annotations);

    internal CompilationUnitSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 5;
      var externs = (GreenNode)reader.ReadValue();
      if (externs != null)
      {
         AdjustFlagsAndWidth(externs);
         this.externs = externs;
      }
      var usings = (GreenNode)reader.ReadValue();
      if (usings != null)
      {
         AdjustFlagsAndWidth(usings);
         this.usings = usings;
      }
      var attributeLists = (GreenNode)reader.ReadValue();
      if (attributeLists != null)
      {
         AdjustFlagsAndWidth(attributeLists);
         this.attributeLists = attributeLists;
      }
      var members = (GreenNode)reader.ReadValue();
      if (members != null)
      {
         AdjustFlagsAndWidth(members);
         this.members = members;
      }
      var endOfFileToken = (SyntaxToken)reader.ReadValue();
      if (endOfFileToken != null)
      {
         AdjustFlagsAndWidth(endOfFileToken);
         this.endOfFileToken = endOfFileToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.externs);
      writer.WriteValue(this.usings);
      writer.WriteValue(this.attributeLists);
      writer.WriteValue(this.members);
      writer.WriteValue(this.endOfFileToken);
    }

    static CompilationUnitSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(CompilationUnitSyntax), r => new CompilationUnitSyntax(r));
    }
  }

  /// <summary>
  /// Represents an ExternAlias directive syntax, e.g. "extern alias MyAlias;" with specifying "/r:MyAlias=SomeAssembly.dll " on the compiler command line.
  /// </summary>
  internal sealed partial class ExternAliasDirectiveSyntax : CSharpSyntaxNode
  {
    internal readonly SyntaxToken externKeyword;
    internal readonly SyntaxToken aliasKeyword;
    internal readonly SyntaxToken identifier;
    internal readonly SyntaxToken semicolonToken;

    internal ExternAliasDirectiveSyntax(SyntaxKind kind, SyntaxToken externKeyword, SyntaxToken aliasKeyword, SyntaxToken identifier, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(externKeyword);
        this.externKeyword = externKeyword;
        this.AdjustFlagsAndWidth(aliasKeyword);
        this.aliasKeyword = aliasKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal ExternAliasDirectiveSyntax(SyntaxKind kind, SyntaxToken externKeyword, SyntaxToken aliasKeyword, SyntaxToken identifier, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(externKeyword);
        this.externKeyword = externKeyword;
        this.AdjustFlagsAndWidth(aliasKeyword);
        this.aliasKeyword = aliasKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal ExternAliasDirectiveSyntax(SyntaxKind kind, SyntaxToken externKeyword, SyntaxToken aliasKeyword, SyntaxToken identifier, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(externKeyword);
        this.externKeyword = externKeyword;
        this.AdjustFlagsAndWidth(aliasKeyword);
        this.aliasKeyword = aliasKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    /// <summary>SyntaxToken representing the extern keyword.</summary>
    public SyntaxToken ExternKeyword => this.externKeyword;
    /// <summary>SyntaxToken representing the alias keyword.</summary>
    public SyntaxToken AliasKeyword => this.aliasKeyword;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    /// <summary>SyntaxToken representing the semicolon token.</summary>
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.externKeyword;
            case 1: return this.aliasKeyword;
            case 2: return this.identifier;
            case 3: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ExternAliasDirectiveSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitExternAliasDirective(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitExternAliasDirective(this);

    public ExternAliasDirectiveSyntax Update(SyntaxToken externKeyword, SyntaxToken aliasKeyword, SyntaxToken identifier, SyntaxToken semicolonToken)
    {
        if (externKeyword != this.ExternKeyword || aliasKeyword != this.AliasKeyword || identifier != this.Identifier || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.ExternAliasDirective(externKeyword, aliasKeyword, identifier, semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ExternAliasDirectiveSyntax(this.Kind, this.externKeyword, this.aliasKeyword, this.identifier, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ExternAliasDirectiveSyntax(this.Kind, this.externKeyword, this.aliasKeyword, this.identifier, this.semicolonToken, GetDiagnostics(), annotations);

    internal ExternAliasDirectiveSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var externKeyword = (SyntaxToken)reader.ReadValue();
      if (externKeyword != null)
      {
         AdjustFlagsAndWidth(externKeyword);
         this.externKeyword = externKeyword;
      }
      var aliasKeyword = (SyntaxToken)reader.ReadValue();
      if (aliasKeyword != null)
      {
         AdjustFlagsAndWidth(aliasKeyword);
         this.aliasKeyword = aliasKeyword;
      }
      var identifier = (SyntaxToken)reader.ReadValue();
      if (identifier != null)
      {
         AdjustFlagsAndWidth(identifier);
         this.identifier = identifier;
      }
      var semicolonToken = (SyntaxToken)reader.ReadValue();
      if (semicolonToken != null)
      {
         AdjustFlagsAndWidth(semicolonToken);
         this.semicolonToken = semicolonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.externKeyword);
      writer.WriteValue(this.aliasKeyword);
      writer.WriteValue(this.identifier);
      writer.WriteValue(this.semicolonToken);
    }

    static ExternAliasDirectiveSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ExternAliasDirectiveSyntax), r => new ExternAliasDirectiveSyntax(r));
    }
  }

  internal sealed partial class UsingDirectiveSyntax : CSharpSyntaxNode
  {
    internal readonly SyntaxToken usingKeyword;
    internal readonly SyntaxToken staticKeyword;
    internal readonly NameEqualsSyntax alias;
    internal readonly NameSyntax name;
    internal readonly SyntaxToken semicolonToken;

    internal UsingDirectiveSyntax(SyntaxKind kind, SyntaxToken usingKeyword, SyntaxToken staticKeyword, NameEqualsSyntax alias, NameSyntax name, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(usingKeyword);
        this.usingKeyword = usingKeyword;
        if (staticKeyword != null)
        {
            this.AdjustFlagsAndWidth(staticKeyword);
            this.staticKeyword = staticKeyword;
        }
        if (alias != null)
        {
            this.AdjustFlagsAndWidth(alias);
            this.alias = alias;
        }
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal UsingDirectiveSyntax(SyntaxKind kind, SyntaxToken usingKeyword, SyntaxToken staticKeyword, NameEqualsSyntax alias, NameSyntax name, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(usingKeyword);
        this.usingKeyword = usingKeyword;
        if (staticKeyword != null)
        {
            this.AdjustFlagsAndWidth(staticKeyword);
            this.staticKeyword = staticKeyword;
        }
        if (alias != null)
        {
            this.AdjustFlagsAndWidth(alias);
            this.alias = alias;
        }
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal UsingDirectiveSyntax(SyntaxKind kind, SyntaxToken usingKeyword, SyntaxToken staticKeyword, NameEqualsSyntax alias, NameSyntax name, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(usingKeyword);
        this.usingKeyword = usingKeyword;
        if (staticKeyword != null)
        {
            this.AdjustFlagsAndWidth(staticKeyword);
            this.staticKeyword = staticKeyword;
        }
        if (alias != null)
        {
            this.AdjustFlagsAndWidth(alias);
            this.alias = alias;
        }
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    public SyntaxToken UsingKeyword => this.usingKeyword;
    public SyntaxToken StaticKeyword => this.staticKeyword;
    public NameEqualsSyntax Alias => this.alias;
    public NameSyntax Name => this.name;
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.usingKeyword;
            case 1: return this.staticKeyword;
            case 2: return this.alias;
            case 3: return this.name;
            case 4: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.UsingDirectiveSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitUsingDirective(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitUsingDirective(this);

    public UsingDirectiveSyntax Update(SyntaxToken usingKeyword, SyntaxToken staticKeyword, NameEqualsSyntax alias, NameSyntax name, SyntaxToken semicolonToken)
    {
        if (usingKeyword != this.UsingKeyword || staticKeyword != this.StaticKeyword || alias != this.Alias || name != this.Name || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.UsingDirective(usingKeyword, staticKeyword, alias, name, semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new UsingDirectiveSyntax(this.Kind, this.usingKeyword, this.staticKeyword, this.alias, this.name, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new UsingDirectiveSyntax(this.Kind, this.usingKeyword, this.staticKeyword, this.alias, this.name, this.semicolonToken, GetDiagnostics(), annotations);

    internal UsingDirectiveSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 5;
      var usingKeyword = (SyntaxToken)reader.ReadValue();
      if (usingKeyword != null)
      {
         AdjustFlagsAndWidth(usingKeyword);
         this.usingKeyword = usingKeyword;
      }
      var staticKeyword = (SyntaxToken)reader.ReadValue();
      if (staticKeyword != null)
      {
         AdjustFlagsAndWidth(staticKeyword);
         this.staticKeyword = staticKeyword;
      }
      var alias = (NameEqualsSyntax)reader.ReadValue();
      if (alias != null)
      {
         AdjustFlagsAndWidth(alias);
         this.alias = alias;
      }
      var name = (NameSyntax)reader.ReadValue();
      if (name != null)
      {
         AdjustFlagsAndWidth(name);
         this.name = name;
      }
      var semicolonToken = (SyntaxToken)reader.ReadValue();
      if (semicolonToken != null)
      {
         AdjustFlagsAndWidth(semicolonToken);
         this.semicolonToken = semicolonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.usingKeyword);
      writer.WriteValue(this.staticKeyword);
      writer.WriteValue(this.alias);
      writer.WriteValue(this.name);
      writer.WriteValue(this.semicolonToken);
    }

    static UsingDirectiveSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(UsingDirectiveSyntax), r => new UsingDirectiveSyntax(r));
    }
  }

  /// <summary>Member declaration syntax.</summary>
  internal abstract partial class MemberDeclarationSyntax : CSharpSyntaxNode
  {
    internal MemberDeclarationSyntax(SyntaxKind kind, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal MemberDeclarationSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    protected MemberDeclarationSyntax(ObjectReader reader)
       : base(reader)
    {
    }

    /// <summary>Gets the attribute declaration list.</summary>
    public abstract Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> AttributeLists { get; }

    /// <summary>Gets the modifier list.</summary>
    public abstract Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> Modifiers { get; }
  }

  internal sealed partial class NamespaceDeclarationSyntax : MemberDeclarationSyntax
  {
    internal readonly GreenNode attributeLists;
    internal readonly GreenNode modifiers;
    internal readonly SyntaxToken namespaceKeyword;
    internal readonly NameSyntax name;
    internal readonly SyntaxToken openBraceToken;
    internal readonly GreenNode externs;
    internal readonly GreenNode usings;
    internal readonly GreenNode members;
    internal readonly SyntaxToken closeBraceToken;
    internal readonly SyntaxToken semicolonToken;

    internal NamespaceDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken namespaceKeyword, NameSyntax name, SyntaxToken openBraceToken, GreenNode externs, GreenNode usings, GreenNode members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 10;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(namespaceKeyword);
        this.namespaceKeyword = namespaceKeyword;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (externs != null)
        {
            this.AdjustFlagsAndWidth(externs);
            this.externs = externs;
        }
        if (usings != null)
        {
            this.AdjustFlagsAndWidth(usings);
            this.usings = usings;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }


    internal NamespaceDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken namespaceKeyword, NameSyntax name, SyntaxToken openBraceToken, GreenNode externs, GreenNode usings, GreenNode members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 10;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(namespaceKeyword);
        this.namespaceKeyword = namespaceKeyword;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (externs != null)
        {
            this.AdjustFlagsAndWidth(externs);
            this.externs = externs;
        }
        if (usings != null)
        {
            this.AdjustFlagsAndWidth(usings);
            this.usings = usings;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }


    internal NamespaceDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken namespaceKeyword, NameSyntax name, SyntaxToken openBraceToken, GreenNode externs, GreenNode usings, GreenNode members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 10;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(namespaceKeyword);
        this.namespaceKeyword = namespaceKeyword;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (externs != null)
        {
            this.AdjustFlagsAndWidth(externs);
            this.externs = externs;
        }
        if (usings != null)
        {
            this.AdjustFlagsAndWidth(usings);
            this.usings = usings;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> Modifiers => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    public SyntaxToken NamespaceKeyword => this.namespaceKeyword;
    public NameSyntax Name => this.name;
    public SyntaxToken OpenBraceToken => this.openBraceToken;
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<ExternAliasDirectiveSyntax> Externs => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<ExternAliasDirectiveSyntax>(this.externs);
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<UsingDirectiveSyntax> Usings => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<UsingDirectiveSyntax>(this.usings);
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<MemberDeclarationSyntax> Members => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<MemberDeclarationSyntax>(this.members);
    public SyntaxToken CloseBraceToken => this.closeBraceToken;
    /// <summary>Gets the optional semicolon token.</summary>
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 1: return this.modifiers;
            case 2: return this.namespaceKeyword;
            case 3: return this.name;
            case 4: return this.openBraceToken;
            case 5: return this.externs;
            case 6: return this.usings;
            case 7: return this.members;
            case 8: return this.closeBraceToken;
            case 9: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.NamespaceDeclarationSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitNamespaceDeclaration(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitNamespaceDeclaration(this);

    public NamespaceDeclarationSyntax Update(Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> attributeLists, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken namespaceKeyword, NameSyntax name, SyntaxToken openBraceToken, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<ExternAliasDirectiveSyntax> externs, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<UsingDirectiveSyntax> usings, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<MemberDeclarationSyntax> members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || namespaceKeyword != this.NamespaceKeyword || name != this.Name || openBraceToken != this.OpenBraceToken || externs != this.Externs || usings != this.Usings || members != this.Members || closeBraceToken != this.CloseBraceToken || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.NamespaceDeclaration(attributeLists, modifiers, namespaceKeyword, name, openBraceToken, externs, usings, members, closeBraceToken, semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new NamespaceDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.namespaceKeyword, this.name, this.openBraceToken, this.externs, this.usings, this.members, this.closeBraceToken, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new NamespaceDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.namespaceKeyword, this.name, this.openBraceToken, this.externs, this.usings, this.members, this.closeBraceToken, this.semicolonToken, GetDiagnostics(), annotations);

    internal NamespaceDeclarationSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 10;
      var attributeLists = (GreenNode)reader.ReadValue();
      if (attributeLists != null)
      {
         AdjustFlagsAndWidth(attributeLists);
         this.attributeLists = attributeLists;
      }
      var modifiers = (GreenNode)reader.ReadValue();
      if (modifiers != null)
      {
         AdjustFlagsAndWidth(modifiers);
         this.modifiers = modifiers;
      }
      var namespaceKeyword = (SyntaxToken)reader.ReadValue();
      if (namespaceKeyword != null)
      {
         AdjustFlagsAndWidth(namespaceKeyword);
         this.namespaceKeyword = namespaceKeyword;
      }
      var name = (NameSyntax)reader.ReadValue();
      if (name != null)
      {
         AdjustFlagsAndWidth(name);
         this.name = name;
      }
      var openBraceToken = (SyntaxToken)reader.ReadValue();
      if (openBraceToken != null)
      {
         AdjustFlagsAndWidth(openBraceToken);
         this.openBraceToken = openBraceToken;
      }
      var externs = (GreenNode)reader.ReadValue();
      if (externs != null)
      {
         AdjustFlagsAndWidth(externs);
         this.externs = externs;
      }
      var usings = (GreenNode)reader.ReadValue();
      if (usings != null)
      {
         AdjustFlagsAndWidth(usings);
         this.usings = usings;
      }
      var members = (GreenNode)reader.ReadValue();
      if (members != null)
      {
         AdjustFlagsAndWidth(members);
         this.members = members;
      }
      var closeBraceToken = (SyntaxToken)reader.ReadValue();
      if (closeBraceToken != null)
      {
         AdjustFlagsAndWidth(closeBraceToken);
         this.closeBraceToken = closeBraceToken;
      }
      var semicolonToken = (SyntaxToken)reader.ReadValue();
      if (semicolonToken != null)
      {
         AdjustFlagsAndWidth(semicolonToken);
         this.semicolonToken = semicolonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.attributeLists);
      writer.WriteValue(this.modifiers);
      writer.WriteValue(this.namespaceKeyword);
      writer.WriteValue(this.name);
      writer.WriteValue(this.openBraceToken);
      writer.WriteValue(this.externs);
      writer.WriteValue(this.usings);
      writer.WriteValue(this.members);
      writer.WriteValue(this.closeBraceToken);
      writer.WriteValue(this.semicolonToken);
    }

    static NamespaceDeclarationSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(NamespaceDeclarationSyntax), r => new NamespaceDeclarationSyntax(r));
    }
  }

  /// <summary>Class representing one or more attributes applied to a language construct.</summary>
  internal sealed partial class AttributeListSyntax : CSharpSyntaxNode
  {
    internal readonly SyntaxToken openBracketToken;
    internal readonly AttributeTargetSpecifierSyntax target;
    internal readonly GreenNode attributes;
    internal readonly SyntaxToken closeBracketToken;

    internal AttributeListSyntax(SyntaxKind kind, SyntaxToken openBracketToken, AttributeTargetSpecifierSyntax target, GreenNode attributes, SyntaxToken closeBracketToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (target != null)
        {
            this.AdjustFlagsAndWidth(target);
            this.target = target;
        }
        if (attributes != null)
        {
            this.AdjustFlagsAndWidth(attributes);
            this.attributes = attributes;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
    }


    internal AttributeListSyntax(SyntaxKind kind, SyntaxToken openBracketToken, AttributeTargetSpecifierSyntax target, GreenNode attributes, SyntaxToken closeBracketToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (target != null)
        {
            this.AdjustFlagsAndWidth(target);
            this.target = target;
        }
        if (attributes != null)
        {
            this.AdjustFlagsAndWidth(attributes);
            this.attributes = attributes;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
    }


    internal AttributeListSyntax(SyntaxKind kind, SyntaxToken openBracketToken, AttributeTargetSpecifierSyntax target, GreenNode attributes, SyntaxToken closeBracketToken)
        : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (target != null)
        {
            this.AdjustFlagsAndWidth(target);
            this.target = target;
        }
        if (attributes != null)
        {
            this.AdjustFlagsAndWidth(attributes);
            this.attributes = attributes;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
    }

    /// <summary>Gets the open bracket token.</summary>
    public SyntaxToken OpenBracketToken => this.openBracketToken;
    /// <summary>Gets the optional construct targeted by the attribute.</summary>
    public AttributeTargetSpecifierSyntax Target => this.target;
    /// <summary>Gets the attribute declaration list.</summary>
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<AttributeSyntax> Attributes => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<AttributeSyntax>(new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<CSharpSyntaxNode>(this.attributes));
    /// <summary>Gets the close bracket token.</summary>
    public SyntaxToken CloseBracketToken => this.closeBracketToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.openBracketToken;
            case 1: return this.target;
            case 2: return this.attributes;
            case 3: return this.closeBracketToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.AttributeListSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitAttributeList(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitAttributeList(this);

    public AttributeListSyntax Update(SyntaxToken openBracketToken, AttributeTargetSpecifierSyntax target, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<AttributeSyntax> attributes, SyntaxToken closeBracketToken)
    {
        if (openBracketToken != this.OpenBracketToken || target != this.Target || attributes != this.Attributes || closeBracketToken != this.CloseBracketToken)
        {
            var newNode = SyntaxFactory.AttributeList(openBracketToken, target, attributes, closeBracketToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new AttributeListSyntax(this.Kind, this.openBracketToken, this.target, this.attributes, this.closeBracketToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new AttributeListSyntax(this.Kind, this.openBracketToken, this.target, this.attributes, this.closeBracketToken, GetDiagnostics(), annotations);

    internal AttributeListSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var openBracketToken = (SyntaxToken)reader.ReadValue();
      if (openBracketToken != null)
      {
         AdjustFlagsAndWidth(openBracketToken);
         this.openBracketToken = openBracketToken;
      }
      var target = (AttributeTargetSpecifierSyntax)reader.ReadValue();
      if (target != null)
      {
         AdjustFlagsAndWidth(target);
         this.target = target;
      }
      var attributes = (GreenNode)reader.ReadValue();
      if (attributes != null)
      {
         AdjustFlagsAndWidth(attributes);
         this.attributes = attributes;
      }
      var closeBracketToken = (SyntaxToken)reader.ReadValue();
      if (closeBracketToken != null)
      {
         AdjustFlagsAndWidth(closeBracketToken);
         this.closeBracketToken = closeBracketToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.openBracketToken);
      writer.WriteValue(this.target);
      writer.WriteValue(this.attributes);
      writer.WriteValue(this.closeBracketToken);
    }

    static AttributeListSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(AttributeListSyntax), r => new AttributeListSyntax(r));
    }
  }

  /// <summary>Class representing what language construct an attribute targets.</summary>
  internal sealed partial class AttributeTargetSpecifierSyntax : CSharpSyntaxNode
  {
    internal readonly SyntaxToken identifier;
    internal readonly SyntaxToken colonToken;

    internal AttributeTargetSpecifierSyntax(SyntaxKind kind, SyntaxToken identifier, SyntaxToken colonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }


    internal AttributeTargetSpecifierSyntax(SyntaxKind kind, SyntaxToken identifier, SyntaxToken colonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }


    internal AttributeTargetSpecifierSyntax(SyntaxKind kind, SyntaxToken identifier, SyntaxToken colonToken)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }

    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    /// <summary>Gets the colon token.</summary>
    public SyntaxToken ColonToken => this.colonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.identifier;
            case 1: return this.colonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.AttributeTargetSpecifierSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitAttributeTargetSpecifier(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitAttributeTargetSpecifier(this);

    public AttributeTargetSpecifierSyntax Update(SyntaxToken identifier, SyntaxToken colonToken)
    {
        if (identifier != this.Identifier || colonToken != this.ColonToken)
        {
            var newNode = SyntaxFactory.AttributeTargetSpecifier(identifier, colonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new AttributeTargetSpecifierSyntax(this.Kind, this.identifier, this.colonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new AttributeTargetSpecifierSyntax(this.Kind, this.identifier, this.colonToken, GetDiagnostics(), annotations);

    internal AttributeTargetSpecifierSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var identifier = (SyntaxToken)reader.ReadValue();
      if (identifier != null)
      {
         AdjustFlagsAndWidth(identifier);
         this.identifier = identifier;
      }
      var colonToken = (SyntaxToken)reader.ReadValue();
      if (colonToken != null)
      {
         AdjustFlagsAndWidth(colonToken);
         this.colonToken = colonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.identifier);
      writer.WriteValue(this.colonToken);
    }

    static AttributeTargetSpecifierSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(AttributeTargetSpecifierSyntax), r => new AttributeTargetSpecifierSyntax(r));
    }
  }

  /// <summary>Attribute syntax.</summary>
  internal sealed partial class AttributeSyntax : CSharpSyntaxNode
  {
    internal readonly NameSyntax name;
    internal readonly AttributeArgumentListSyntax argumentList;

    internal AttributeSyntax(SyntaxKind kind, NameSyntax name, AttributeArgumentListSyntax argumentList, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        if (argumentList != null)
        {
            this.AdjustFlagsAndWidth(argumentList);
            this.argumentList = argumentList;
        }
    }


    internal AttributeSyntax(SyntaxKind kind, NameSyntax name, AttributeArgumentListSyntax argumentList, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        if (argumentList != null)
        {
            this.AdjustFlagsAndWidth(argumentList);
            this.argumentList = argumentList;
        }
    }


    internal AttributeSyntax(SyntaxKind kind, NameSyntax name, AttributeArgumentListSyntax argumentList)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        if (argumentList != null)
        {
            this.AdjustFlagsAndWidth(argumentList);
            this.argumentList = argumentList;
        }
    }

    /// <summary>Gets the name.</summary>
    public NameSyntax Name => this.name;
    public AttributeArgumentListSyntax ArgumentList => this.argumentList;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.name;
            case 1: return this.argumentList;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.AttributeSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitAttribute(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitAttribute(this);

    public AttributeSyntax Update(NameSyntax name, AttributeArgumentListSyntax argumentList)
    {
        if (name != this.Name || argumentList != this.ArgumentList)
        {
            var newNode = SyntaxFactory.Attribute(name, argumentList);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new AttributeSyntax(this.Kind, this.name, this.argumentList, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new AttributeSyntax(this.Kind, this.name, this.argumentList, GetDiagnostics(), annotations);

    internal AttributeSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var name = (NameSyntax)reader.ReadValue();
      if (name != null)
      {
         AdjustFlagsAndWidth(name);
         this.name = name;
      }
      var argumentList = (AttributeArgumentListSyntax)reader.ReadValue();
      if (argumentList != null)
      {
         AdjustFlagsAndWidth(argumentList);
         this.argumentList = argumentList;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.name);
      writer.WriteValue(this.argumentList);
    }

    static AttributeSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(AttributeSyntax), r => new AttributeSyntax(r));
    }
  }

  /// <summary>Attribute argument list syntax.</summary>
  internal sealed partial class AttributeArgumentListSyntax : CSharpSyntaxNode
  {
    internal readonly SyntaxToken openParenToken;
    internal readonly GreenNode arguments;
    internal readonly SyntaxToken closeParenToken;

    internal AttributeArgumentListSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode arguments, SyntaxToken closeParenToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal AttributeArgumentListSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode arguments, SyntaxToken closeParenToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal AttributeArgumentListSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode arguments, SyntaxToken closeParenToken)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>Gets the open paren token.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>Gets the arguments syntax list.</summary>
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<AttributeArgumentSyntax> Arguments => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<AttributeArgumentSyntax>(new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<CSharpSyntaxNode>(this.arguments));
    /// <summary>Gets the close paren token.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.openParenToken;
            case 1: return this.arguments;
            case 2: return this.closeParenToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.AttributeArgumentListSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitAttributeArgumentList(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitAttributeArgumentList(this);

    public AttributeArgumentListSyntax Update(SyntaxToken openParenToken, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<AttributeArgumentSyntax> arguments, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || arguments != this.Arguments || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.AttributeArgumentList(openParenToken, arguments, closeParenToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new AttributeArgumentListSyntax(this.Kind, this.openParenToken, this.arguments, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new AttributeArgumentListSyntax(this.Kind, this.openParenToken, this.arguments, this.closeParenToken, GetDiagnostics(), annotations);

    internal AttributeArgumentListSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var arguments = (GreenNode)reader.ReadValue();
      if (arguments != null)
      {
         AdjustFlagsAndWidth(arguments);
         this.arguments = arguments;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.arguments);
      writer.WriteValue(this.closeParenToken);
    }

    static AttributeArgumentListSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(AttributeArgumentListSyntax), r => new AttributeArgumentListSyntax(r));
    }
  }

  /// <summary>Attribute argument syntax.</summary>
  internal sealed partial class AttributeArgumentSyntax : CSharpSyntaxNode
  {
    internal readonly NameEqualsSyntax nameEquals;
    internal readonly NameColonSyntax nameColon;
    internal readonly ExpressionSyntax expression;

    internal AttributeArgumentSyntax(SyntaxKind kind, NameEqualsSyntax nameEquals, NameColonSyntax nameColon, ExpressionSyntax expression, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        if (nameEquals != null)
        {
            this.AdjustFlagsAndWidth(nameEquals);
            this.nameEquals = nameEquals;
        }
        if (nameColon != null)
        {
            this.AdjustFlagsAndWidth(nameColon);
            this.nameColon = nameColon;
        }
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }


    internal AttributeArgumentSyntax(SyntaxKind kind, NameEqualsSyntax nameEquals, NameColonSyntax nameColon, ExpressionSyntax expression, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        if (nameEquals != null)
        {
            this.AdjustFlagsAndWidth(nameEquals);
            this.nameEquals = nameEquals;
        }
        if (nameColon != null)
        {
            this.AdjustFlagsAndWidth(nameColon);
            this.nameColon = nameColon;
        }
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }


    internal AttributeArgumentSyntax(SyntaxKind kind, NameEqualsSyntax nameEquals, NameColonSyntax nameColon, ExpressionSyntax expression)
        : base(kind)
    {
        this.SlotCount = 3;
        if (nameEquals != null)
        {
            this.AdjustFlagsAndWidth(nameEquals);
            this.nameEquals = nameEquals;
        }
        if (nameColon != null)
        {
            this.AdjustFlagsAndWidth(nameColon);
            this.nameColon = nameColon;
        }
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    public NameEqualsSyntax NameEquals => this.nameEquals;
    public NameColonSyntax NameColon => this.nameColon;
    /// <summary>Gets the expression.</summary>
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.nameEquals;
            case 1: return this.nameColon;
            case 2: return this.expression;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.AttributeArgumentSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitAttributeArgument(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitAttributeArgument(this);

    public AttributeArgumentSyntax Update(NameEqualsSyntax nameEquals, NameColonSyntax nameColon, ExpressionSyntax expression)
    {
        if (nameEquals != this.NameEquals || nameColon != this.NameColon || expression != this.Expression)
        {
            var newNode = SyntaxFactory.AttributeArgument(nameEquals, nameColon, expression);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new AttributeArgumentSyntax(this.Kind, this.nameEquals, this.nameColon, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new AttributeArgumentSyntax(this.Kind, this.nameEquals, this.nameColon, this.expression, GetDiagnostics(), annotations);

    internal AttributeArgumentSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var nameEquals = (NameEqualsSyntax)reader.ReadValue();
      if (nameEquals != null)
      {
         AdjustFlagsAndWidth(nameEquals);
         this.nameEquals = nameEquals;
      }
      var nameColon = (NameColonSyntax)reader.ReadValue();
      if (nameColon != null)
      {
         AdjustFlagsAndWidth(nameColon);
         this.nameColon = nameColon;
      }
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.nameEquals);
      writer.WriteValue(this.nameColon);
      writer.WriteValue(this.expression);
    }

    static AttributeArgumentSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(AttributeArgumentSyntax), r => new AttributeArgumentSyntax(r));
    }
  }

  /// <summary>Class representing an identifier name followed by an equals token.</summary>
  internal sealed partial class NameEqualsSyntax : CSharpSyntaxNode
  {
    internal readonly IdentifierNameSyntax name;
    internal readonly SyntaxToken equalsToken;

    internal NameEqualsSyntax(SyntaxKind kind, IdentifierNameSyntax name, SyntaxToken equalsToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(equalsToken);
        this.equalsToken = equalsToken;
    }


    internal NameEqualsSyntax(SyntaxKind kind, IdentifierNameSyntax name, SyntaxToken equalsToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(equalsToken);
        this.equalsToken = equalsToken;
    }


    internal NameEqualsSyntax(SyntaxKind kind, IdentifierNameSyntax name, SyntaxToken equalsToken)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(equalsToken);
        this.equalsToken = equalsToken;
    }

    /// <summary>Gets the identifier name.</summary>
    public IdentifierNameSyntax Name => this.name;
    public SyntaxToken EqualsToken => this.equalsToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.name;
            case 1: return this.equalsToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.NameEqualsSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitNameEquals(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitNameEquals(this);

    public NameEqualsSyntax Update(IdentifierNameSyntax name, SyntaxToken equalsToken)
    {
        if (name != this.Name || equalsToken != this.EqualsToken)
        {
            var newNode = SyntaxFactory.NameEquals(name, equalsToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new NameEqualsSyntax(this.Kind, this.name, this.equalsToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new NameEqualsSyntax(this.Kind, this.name, this.equalsToken, GetDiagnostics(), annotations);

    internal NameEqualsSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var name = (IdentifierNameSyntax)reader.ReadValue();
      if (name != null)
      {
         AdjustFlagsAndWidth(name);
         this.name = name;
      }
      var equalsToken = (SyntaxToken)reader.ReadValue();
      if (equalsToken != null)
      {
         AdjustFlagsAndWidth(equalsToken);
         this.equalsToken = equalsToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.name);
      writer.WriteValue(this.equalsToken);
    }

    static NameEqualsSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(NameEqualsSyntax), r => new NameEqualsSyntax(r));
    }
  }

  /// <summary>Type parameter list syntax.</summary>
  internal sealed partial class TypeParameterListSyntax : CSharpSyntaxNode
  {
    internal readonly SyntaxToken lessThanToken;
    internal readonly GreenNode parameters;
    internal readonly SyntaxToken greaterThanToken;

    internal TypeParameterListSyntax(SyntaxKind kind, SyntaxToken lessThanToken, GreenNode parameters, SyntaxToken greaterThanToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(lessThanToken);
        this.lessThanToken = lessThanToken;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
        this.AdjustFlagsAndWidth(greaterThanToken);
        this.greaterThanToken = greaterThanToken;
    }


    internal TypeParameterListSyntax(SyntaxKind kind, SyntaxToken lessThanToken, GreenNode parameters, SyntaxToken greaterThanToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(lessThanToken);
        this.lessThanToken = lessThanToken;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
        this.AdjustFlagsAndWidth(greaterThanToken);
        this.greaterThanToken = greaterThanToken;
    }


    internal TypeParameterListSyntax(SyntaxKind kind, SyntaxToken lessThanToken, GreenNode parameters, SyntaxToken greaterThanToken)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(lessThanToken);
        this.lessThanToken = lessThanToken;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
        this.AdjustFlagsAndWidth(greaterThanToken);
        this.greaterThanToken = greaterThanToken;
    }

    /// <summary>Gets the &lt; token.</summary>
    public SyntaxToken LessThanToken => this.lessThanToken;
    /// <summary>Gets the parameter list.</summary>
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<TypeParameterSyntax> Parameters => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<TypeParameterSyntax>(new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<CSharpSyntaxNode>(this.parameters));
    /// <summary>Gets the &gt; token.</summary>
    public SyntaxToken GreaterThanToken => this.greaterThanToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.lessThanToken;
            case 1: return this.parameters;
            case 2: return this.greaterThanToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.TypeParameterListSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitTypeParameterList(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitTypeParameterList(this);

    public TypeParameterListSyntax Update(SyntaxToken lessThanToken, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<TypeParameterSyntax> parameters, SyntaxToken greaterThanToken)
    {
        if (lessThanToken != this.LessThanToken || parameters != this.Parameters || greaterThanToken != this.GreaterThanToken)
        {
            var newNode = SyntaxFactory.TypeParameterList(lessThanToken, parameters, greaterThanToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new TypeParameterListSyntax(this.Kind, this.lessThanToken, this.parameters, this.greaterThanToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new TypeParameterListSyntax(this.Kind, this.lessThanToken, this.parameters, this.greaterThanToken, GetDiagnostics(), annotations);

    internal TypeParameterListSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var lessThanToken = (SyntaxToken)reader.ReadValue();
      if (lessThanToken != null)
      {
         AdjustFlagsAndWidth(lessThanToken);
         this.lessThanToken = lessThanToken;
      }
      var parameters = (GreenNode)reader.ReadValue();
      if (parameters != null)
      {
         AdjustFlagsAndWidth(parameters);
         this.parameters = parameters;
      }
      var greaterThanToken = (SyntaxToken)reader.ReadValue();
      if (greaterThanToken != null)
      {
         AdjustFlagsAndWidth(greaterThanToken);
         this.greaterThanToken = greaterThanToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.lessThanToken);
      writer.WriteValue(this.parameters);
      writer.WriteValue(this.greaterThanToken);
    }

    static TypeParameterListSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(TypeParameterListSyntax), r => new TypeParameterListSyntax(r));
    }
  }

  /// <summary>Type parameter syntax.</summary>
  internal sealed partial class TypeParameterSyntax : CSharpSyntaxNode
  {
    internal readonly GreenNode attributeLists;
    internal readonly SyntaxToken varianceKeyword;
    internal readonly SyntaxToken identifier;

    internal TypeParameterSyntax(SyntaxKind kind, GreenNode attributeLists, SyntaxToken varianceKeyword, SyntaxToken identifier, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (varianceKeyword != null)
        {
            this.AdjustFlagsAndWidth(varianceKeyword);
            this.varianceKeyword = varianceKeyword;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
    }


    internal TypeParameterSyntax(SyntaxKind kind, GreenNode attributeLists, SyntaxToken varianceKeyword, SyntaxToken identifier, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (varianceKeyword != null)
        {
            this.AdjustFlagsAndWidth(varianceKeyword);
            this.varianceKeyword = varianceKeyword;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
    }


    internal TypeParameterSyntax(SyntaxKind kind, GreenNode attributeLists, SyntaxToken varianceKeyword, SyntaxToken identifier)
        : base(kind)
    {
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (varianceKeyword != null)
        {
            this.AdjustFlagsAndWidth(varianceKeyword);
            this.varianceKeyword = varianceKeyword;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
    }

    /// <summary>Gets the attribute declaration list.</summary>
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public SyntaxToken VarianceKeyword => this.varianceKeyword;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 1: return this.varianceKeyword;
            case 2: return this.identifier;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.TypeParameterSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitTypeParameter(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitTypeParameter(this);

    public TypeParameterSyntax Update(Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> attributeLists, SyntaxToken varianceKeyword, SyntaxToken identifier)
    {
        if (attributeLists != this.AttributeLists || varianceKeyword != this.VarianceKeyword || identifier != this.Identifier)
        {
            var newNode = SyntaxFactory.TypeParameter(attributeLists, varianceKeyword, identifier);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new TypeParameterSyntax(this.Kind, this.attributeLists, this.varianceKeyword, this.identifier, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new TypeParameterSyntax(this.Kind, this.attributeLists, this.varianceKeyword, this.identifier, GetDiagnostics(), annotations);

    internal TypeParameterSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var attributeLists = (GreenNode)reader.ReadValue();
      if (attributeLists != null)
      {
         AdjustFlagsAndWidth(attributeLists);
         this.attributeLists = attributeLists;
      }
      var varianceKeyword = (SyntaxToken)reader.ReadValue();
      if (varianceKeyword != null)
      {
         AdjustFlagsAndWidth(varianceKeyword);
         this.varianceKeyword = varianceKeyword;
      }
      var identifier = (SyntaxToken)reader.ReadValue();
      if (identifier != null)
      {
         AdjustFlagsAndWidth(identifier);
         this.identifier = identifier;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.attributeLists);
      writer.WriteValue(this.varianceKeyword);
      writer.WriteValue(this.identifier);
    }

    static TypeParameterSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(TypeParameterSyntax), r => new TypeParameterSyntax(r));
    }
  }

  /// <summary>Base class for type declaration syntax.</summary>
  internal abstract partial class BaseTypeDeclarationSyntax : MemberDeclarationSyntax
  {
    internal BaseTypeDeclarationSyntax(SyntaxKind kind, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal BaseTypeDeclarationSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    protected BaseTypeDeclarationSyntax(ObjectReader reader)
       : base(reader)
    {
    }

    /// <summary>Gets the identifier.</summary>
    public abstract SyntaxToken Identifier { get; }

    /// <summary>Gets the base type list.</summary>
    public abstract BaseListSyntax BaseList { get; }

    /// <summary>Gets the open brace token.</summary>
    public abstract SyntaxToken OpenBraceToken { get; }

    /// <summary>Gets the close brace token.</summary>
    public abstract SyntaxToken CloseBraceToken { get; }

    /// <summary>Gets the optional semicolon token.</summary>
    public abstract SyntaxToken SemicolonToken { get; }
  }

  /// <summary>Base class for type declaration syntax (class, struct, interface).</summary>
  internal abstract partial class TypeDeclarationSyntax : BaseTypeDeclarationSyntax
  {
    internal TypeDeclarationSyntax(SyntaxKind kind, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal TypeDeclarationSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    protected TypeDeclarationSyntax(ObjectReader reader)
       : base(reader)
    {
    }

    /// <summary>Gets the type keyword token ("class", "struct", "interface").</summary>
    public abstract SyntaxToken Keyword { get; }

    public abstract TypeParameterListSyntax TypeParameterList { get; }

    /// <summary>Gets the type constraint list.</summary>
    public abstract Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> ConstraintClauses { get; }

    /// <summary>Gets the member declarations.</summary>
    public abstract Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<MemberDeclarationSyntax> Members { get; }
  }

  /// <summary>Class type declaration syntax.</summary>
  internal sealed partial class ClassDeclarationSyntax : TypeDeclarationSyntax
  {
    internal readonly GreenNode attributeLists;
    internal readonly GreenNode modifiers;
    internal readonly SyntaxToken keyword;
    internal readonly SyntaxToken identifier;
    internal readonly TypeParameterListSyntax typeParameterList;
    internal readonly BaseListSyntax baseList;
    internal readonly GreenNode constraintClauses;
    internal readonly SyntaxToken openBraceToken;
    internal readonly GreenNode members;
    internal readonly SyntaxToken closeBraceToken;
    internal readonly SyntaxToken semicolonToken;

    internal ClassDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken keyword, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, BaseListSyntax baseList, GreenNode constraintClauses, SyntaxToken openBraceToken, GreenNode members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 11;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        if (baseList != null)
        {
            this.AdjustFlagsAndWidth(baseList);
            this.baseList = baseList;
        }
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }


    internal ClassDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken keyword, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, BaseListSyntax baseList, GreenNode constraintClauses, SyntaxToken openBraceToken, GreenNode members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 11;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        if (baseList != null)
        {
            this.AdjustFlagsAndWidth(baseList);
            this.baseList = baseList;
        }
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }


    internal ClassDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken keyword, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, BaseListSyntax baseList, GreenNode constraintClauses, SyntaxToken openBraceToken, GreenNode members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 11;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        if (baseList != null)
        {
            this.AdjustFlagsAndWidth(baseList);
            this.baseList = baseList;
        }
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> Modifiers => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    /// <summary>Gets the class keyword token.</summary>
    public override SyntaxToken Keyword => this.keyword;
    public override SyntaxToken Identifier => this.identifier;
    public override TypeParameterListSyntax TypeParameterList => this.typeParameterList;
    public override BaseListSyntax BaseList => this.baseList;
    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> ConstraintClauses => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<TypeParameterConstraintClauseSyntax>(this.constraintClauses);
    public override SyntaxToken OpenBraceToken => this.openBraceToken;
    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<MemberDeclarationSyntax> Members => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<MemberDeclarationSyntax>(this.members);
    public override SyntaxToken CloseBraceToken => this.closeBraceToken;
    public override SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 1: return this.modifiers;
            case 2: return this.keyword;
            case 3: return this.identifier;
            case 4: return this.typeParameterList;
            case 5: return this.baseList;
            case 6: return this.constraintClauses;
            case 7: return this.openBraceToken;
            case 8: return this.members;
            case 9: return this.closeBraceToken;
            case 10: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ClassDeclarationSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitClassDeclaration(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitClassDeclaration(this);

    public ClassDeclarationSyntax Update(Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> attributeLists, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken keyword, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, BaseListSyntax baseList, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> constraintClauses, SyntaxToken openBraceToken, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<MemberDeclarationSyntax> members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || keyword != this.Keyword || identifier != this.Identifier || typeParameterList != this.TypeParameterList || baseList != this.BaseList || constraintClauses != this.ConstraintClauses || openBraceToken != this.OpenBraceToken || members != this.Members || closeBraceToken != this.CloseBraceToken || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.ClassDeclaration(attributeLists, modifiers, keyword, identifier, typeParameterList, baseList, constraintClauses, openBraceToken, members, closeBraceToken, semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ClassDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.keyword, this.identifier, this.typeParameterList, this.baseList, this.constraintClauses, this.openBraceToken, this.members, this.closeBraceToken, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ClassDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.keyword, this.identifier, this.typeParameterList, this.baseList, this.constraintClauses, this.openBraceToken, this.members, this.closeBraceToken, this.semicolonToken, GetDiagnostics(), annotations);

    internal ClassDeclarationSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 11;
      var attributeLists = (GreenNode)reader.ReadValue();
      if (attributeLists != null)
      {
         AdjustFlagsAndWidth(attributeLists);
         this.attributeLists = attributeLists;
      }
      var modifiers = (GreenNode)reader.ReadValue();
      if (modifiers != null)
      {
         AdjustFlagsAndWidth(modifiers);
         this.modifiers = modifiers;
      }
      var keyword = (SyntaxToken)reader.ReadValue();
      if (keyword != null)
      {
         AdjustFlagsAndWidth(keyword);
         this.keyword = keyword;
      }
      var identifier = (SyntaxToken)reader.ReadValue();
      if (identifier != null)
      {
         AdjustFlagsAndWidth(identifier);
         this.identifier = identifier;
      }
      var typeParameterList = (TypeParameterListSyntax)reader.ReadValue();
      if (typeParameterList != null)
      {
         AdjustFlagsAndWidth(typeParameterList);
         this.typeParameterList = typeParameterList;
      }
      var baseList = (BaseListSyntax)reader.ReadValue();
      if (baseList != null)
      {
         AdjustFlagsAndWidth(baseList);
         this.baseList = baseList;
      }
      var constraintClauses = (GreenNode)reader.ReadValue();
      if (constraintClauses != null)
      {
         AdjustFlagsAndWidth(constraintClauses);
         this.constraintClauses = constraintClauses;
      }
      var openBraceToken = (SyntaxToken)reader.ReadValue();
      if (openBraceToken != null)
      {
         AdjustFlagsAndWidth(openBraceToken);
         this.openBraceToken = openBraceToken;
      }
      var members = (GreenNode)reader.ReadValue();
      if (members != null)
      {
         AdjustFlagsAndWidth(members);
         this.members = members;
      }
      var closeBraceToken = (SyntaxToken)reader.ReadValue();
      if (closeBraceToken != null)
      {
         AdjustFlagsAndWidth(closeBraceToken);
         this.closeBraceToken = closeBraceToken;
      }
      var semicolonToken = (SyntaxToken)reader.ReadValue();
      if (semicolonToken != null)
      {
         AdjustFlagsAndWidth(semicolonToken);
         this.semicolonToken = semicolonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.attributeLists);
      writer.WriteValue(this.modifiers);
      writer.WriteValue(this.keyword);
      writer.WriteValue(this.identifier);
      writer.WriteValue(this.typeParameterList);
      writer.WriteValue(this.baseList);
      writer.WriteValue(this.constraintClauses);
      writer.WriteValue(this.openBraceToken);
      writer.WriteValue(this.members);
      writer.WriteValue(this.closeBraceToken);
      writer.WriteValue(this.semicolonToken);
    }

    static ClassDeclarationSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ClassDeclarationSyntax), r => new ClassDeclarationSyntax(r));
    }
  }

  /// <summary>Struct type declaration syntax.</summary>
  internal sealed partial class StructDeclarationSyntax : TypeDeclarationSyntax
  {
    internal readonly GreenNode attributeLists;
    internal readonly GreenNode modifiers;
    internal readonly SyntaxToken keyword;
    internal readonly SyntaxToken identifier;
    internal readonly TypeParameterListSyntax typeParameterList;
    internal readonly BaseListSyntax baseList;
    internal readonly GreenNode constraintClauses;
    internal readonly SyntaxToken openBraceToken;
    internal readonly GreenNode members;
    internal readonly SyntaxToken closeBraceToken;
    internal readonly SyntaxToken semicolonToken;

    internal StructDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken keyword, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, BaseListSyntax baseList, GreenNode constraintClauses, SyntaxToken openBraceToken, GreenNode members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 11;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        if (baseList != null)
        {
            this.AdjustFlagsAndWidth(baseList);
            this.baseList = baseList;
        }
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }


    internal StructDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken keyword, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, BaseListSyntax baseList, GreenNode constraintClauses, SyntaxToken openBraceToken, GreenNode members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 11;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        if (baseList != null)
        {
            this.AdjustFlagsAndWidth(baseList);
            this.baseList = baseList;
        }
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }


    internal StructDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken keyword, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, BaseListSyntax baseList, GreenNode constraintClauses, SyntaxToken openBraceToken, GreenNode members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 11;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        if (baseList != null)
        {
            this.AdjustFlagsAndWidth(baseList);
            this.baseList = baseList;
        }
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> Modifiers => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    /// <summary>Gets the struct keyword token.</summary>
    public override SyntaxToken Keyword => this.keyword;
    public override SyntaxToken Identifier => this.identifier;
    public override TypeParameterListSyntax TypeParameterList => this.typeParameterList;
    public override BaseListSyntax BaseList => this.baseList;
    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> ConstraintClauses => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<TypeParameterConstraintClauseSyntax>(this.constraintClauses);
    public override SyntaxToken OpenBraceToken => this.openBraceToken;
    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<MemberDeclarationSyntax> Members => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<MemberDeclarationSyntax>(this.members);
    public override SyntaxToken CloseBraceToken => this.closeBraceToken;
    public override SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 1: return this.modifiers;
            case 2: return this.keyword;
            case 3: return this.identifier;
            case 4: return this.typeParameterList;
            case 5: return this.baseList;
            case 6: return this.constraintClauses;
            case 7: return this.openBraceToken;
            case 8: return this.members;
            case 9: return this.closeBraceToken;
            case 10: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.StructDeclarationSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitStructDeclaration(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitStructDeclaration(this);

    public StructDeclarationSyntax Update(Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> attributeLists, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken keyword, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, BaseListSyntax baseList, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> constraintClauses, SyntaxToken openBraceToken, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<MemberDeclarationSyntax> members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || keyword != this.Keyword || identifier != this.Identifier || typeParameterList != this.TypeParameterList || baseList != this.BaseList || constraintClauses != this.ConstraintClauses || openBraceToken != this.OpenBraceToken || members != this.Members || closeBraceToken != this.CloseBraceToken || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.StructDeclaration(attributeLists, modifiers, keyword, identifier, typeParameterList, baseList, constraintClauses, openBraceToken, members, closeBraceToken, semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new StructDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.keyword, this.identifier, this.typeParameterList, this.baseList, this.constraintClauses, this.openBraceToken, this.members, this.closeBraceToken, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new StructDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.keyword, this.identifier, this.typeParameterList, this.baseList, this.constraintClauses, this.openBraceToken, this.members, this.closeBraceToken, this.semicolonToken, GetDiagnostics(), annotations);

    internal StructDeclarationSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 11;
      var attributeLists = (GreenNode)reader.ReadValue();
      if (attributeLists != null)
      {
         AdjustFlagsAndWidth(attributeLists);
         this.attributeLists = attributeLists;
      }
      var modifiers = (GreenNode)reader.ReadValue();
      if (modifiers != null)
      {
         AdjustFlagsAndWidth(modifiers);
         this.modifiers = modifiers;
      }
      var keyword = (SyntaxToken)reader.ReadValue();
      if (keyword != null)
      {
         AdjustFlagsAndWidth(keyword);
         this.keyword = keyword;
      }
      var identifier = (SyntaxToken)reader.ReadValue();
      if (identifier != null)
      {
         AdjustFlagsAndWidth(identifier);
         this.identifier = identifier;
      }
      var typeParameterList = (TypeParameterListSyntax)reader.ReadValue();
      if (typeParameterList != null)
      {
         AdjustFlagsAndWidth(typeParameterList);
         this.typeParameterList = typeParameterList;
      }
      var baseList = (BaseListSyntax)reader.ReadValue();
      if (baseList != null)
      {
         AdjustFlagsAndWidth(baseList);
         this.baseList = baseList;
      }
      var constraintClauses = (GreenNode)reader.ReadValue();
      if (constraintClauses != null)
      {
         AdjustFlagsAndWidth(constraintClauses);
         this.constraintClauses = constraintClauses;
      }
      var openBraceToken = (SyntaxToken)reader.ReadValue();
      if (openBraceToken != null)
      {
         AdjustFlagsAndWidth(openBraceToken);
         this.openBraceToken = openBraceToken;
      }
      var members = (GreenNode)reader.ReadValue();
      if (members != null)
      {
         AdjustFlagsAndWidth(members);
         this.members = members;
      }
      var closeBraceToken = (SyntaxToken)reader.ReadValue();
      if (closeBraceToken != null)
      {
         AdjustFlagsAndWidth(closeBraceToken);
         this.closeBraceToken = closeBraceToken;
      }
      var semicolonToken = (SyntaxToken)reader.ReadValue();
      if (semicolonToken != null)
      {
         AdjustFlagsAndWidth(semicolonToken);
         this.semicolonToken = semicolonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.attributeLists);
      writer.WriteValue(this.modifiers);
      writer.WriteValue(this.keyword);
      writer.WriteValue(this.identifier);
      writer.WriteValue(this.typeParameterList);
      writer.WriteValue(this.baseList);
      writer.WriteValue(this.constraintClauses);
      writer.WriteValue(this.openBraceToken);
      writer.WriteValue(this.members);
      writer.WriteValue(this.closeBraceToken);
      writer.WriteValue(this.semicolonToken);
    }

    static StructDeclarationSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(StructDeclarationSyntax), r => new StructDeclarationSyntax(r));
    }
  }

  /// <summary>Interface type declaration syntax.</summary>
  internal sealed partial class InterfaceDeclarationSyntax : TypeDeclarationSyntax
  {
    internal readonly GreenNode attributeLists;
    internal readonly GreenNode modifiers;
    internal readonly SyntaxToken keyword;
    internal readonly SyntaxToken identifier;
    internal readonly TypeParameterListSyntax typeParameterList;
    internal readonly BaseListSyntax baseList;
    internal readonly GreenNode constraintClauses;
    internal readonly SyntaxToken openBraceToken;
    internal readonly GreenNode members;
    internal readonly SyntaxToken closeBraceToken;
    internal readonly SyntaxToken semicolonToken;

    internal InterfaceDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken keyword, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, BaseListSyntax baseList, GreenNode constraintClauses, SyntaxToken openBraceToken, GreenNode members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 11;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        if (baseList != null)
        {
            this.AdjustFlagsAndWidth(baseList);
            this.baseList = baseList;
        }
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }


    internal InterfaceDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken keyword, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, BaseListSyntax baseList, GreenNode constraintClauses, SyntaxToken openBraceToken, GreenNode members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 11;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        if (baseList != null)
        {
            this.AdjustFlagsAndWidth(baseList);
            this.baseList = baseList;
        }
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }


    internal InterfaceDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken keyword, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, BaseListSyntax baseList, GreenNode constraintClauses, SyntaxToken openBraceToken, GreenNode members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 11;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        if (baseList != null)
        {
            this.AdjustFlagsAndWidth(baseList);
            this.baseList = baseList;
        }
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> Modifiers => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    /// <summary>Gets the interface keyword token.</summary>
    public override SyntaxToken Keyword => this.keyword;
    public override SyntaxToken Identifier => this.identifier;
    public override TypeParameterListSyntax TypeParameterList => this.typeParameterList;
    public override BaseListSyntax BaseList => this.baseList;
    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> ConstraintClauses => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<TypeParameterConstraintClauseSyntax>(this.constraintClauses);
    public override SyntaxToken OpenBraceToken => this.openBraceToken;
    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<MemberDeclarationSyntax> Members => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<MemberDeclarationSyntax>(this.members);
    public override SyntaxToken CloseBraceToken => this.closeBraceToken;
    public override SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 1: return this.modifiers;
            case 2: return this.keyword;
            case 3: return this.identifier;
            case 4: return this.typeParameterList;
            case 5: return this.baseList;
            case 6: return this.constraintClauses;
            case 7: return this.openBraceToken;
            case 8: return this.members;
            case 9: return this.closeBraceToken;
            case 10: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.InterfaceDeclarationSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitInterfaceDeclaration(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitInterfaceDeclaration(this);

    public InterfaceDeclarationSyntax Update(Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> attributeLists, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken keyword, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, BaseListSyntax baseList, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> constraintClauses, SyntaxToken openBraceToken, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<MemberDeclarationSyntax> members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || keyword != this.Keyword || identifier != this.Identifier || typeParameterList != this.TypeParameterList || baseList != this.BaseList || constraintClauses != this.ConstraintClauses || openBraceToken != this.OpenBraceToken || members != this.Members || closeBraceToken != this.CloseBraceToken || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.InterfaceDeclaration(attributeLists, modifiers, keyword, identifier, typeParameterList, baseList, constraintClauses, openBraceToken, members, closeBraceToken, semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new InterfaceDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.keyword, this.identifier, this.typeParameterList, this.baseList, this.constraintClauses, this.openBraceToken, this.members, this.closeBraceToken, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new InterfaceDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.keyword, this.identifier, this.typeParameterList, this.baseList, this.constraintClauses, this.openBraceToken, this.members, this.closeBraceToken, this.semicolonToken, GetDiagnostics(), annotations);

    internal InterfaceDeclarationSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 11;
      var attributeLists = (GreenNode)reader.ReadValue();
      if (attributeLists != null)
      {
         AdjustFlagsAndWidth(attributeLists);
         this.attributeLists = attributeLists;
      }
      var modifiers = (GreenNode)reader.ReadValue();
      if (modifiers != null)
      {
         AdjustFlagsAndWidth(modifiers);
         this.modifiers = modifiers;
      }
      var keyword = (SyntaxToken)reader.ReadValue();
      if (keyword != null)
      {
         AdjustFlagsAndWidth(keyword);
         this.keyword = keyword;
      }
      var identifier = (SyntaxToken)reader.ReadValue();
      if (identifier != null)
      {
         AdjustFlagsAndWidth(identifier);
         this.identifier = identifier;
      }
      var typeParameterList = (TypeParameterListSyntax)reader.ReadValue();
      if (typeParameterList != null)
      {
         AdjustFlagsAndWidth(typeParameterList);
         this.typeParameterList = typeParameterList;
      }
      var baseList = (BaseListSyntax)reader.ReadValue();
      if (baseList != null)
      {
         AdjustFlagsAndWidth(baseList);
         this.baseList = baseList;
      }
      var constraintClauses = (GreenNode)reader.ReadValue();
      if (constraintClauses != null)
      {
         AdjustFlagsAndWidth(constraintClauses);
         this.constraintClauses = constraintClauses;
      }
      var openBraceToken = (SyntaxToken)reader.ReadValue();
      if (openBraceToken != null)
      {
         AdjustFlagsAndWidth(openBraceToken);
         this.openBraceToken = openBraceToken;
      }
      var members = (GreenNode)reader.ReadValue();
      if (members != null)
      {
         AdjustFlagsAndWidth(members);
         this.members = members;
      }
      var closeBraceToken = (SyntaxToken)reader.ReadValue();
      if (closeBraceToken != null)
      {
         AdjustFlagsAndWidth(closeBraceToken);
         this.closeBraceToken = closeBraceToken;
      }
      var semicolonToken = (SyntaxToken)reader.ReadValue();
      if (semicolonToken != null)
      {
         AdjustFlagsAndWidth(semicolonToken);
         this.semicolonToken = semicolonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.attributeLists);
      writer.WriteValue(this.modifiers);
      writer.WriteValue(this.keyword);
      writer.WriteValue(this.identifier);
      writer.WriteValue(this.typeParameterList);
      writer.WriteValue(this.baseList);
      writer.WriteValue(this.constraintClauses);
      writer.WriteValue(this.openBraceToken);
      writer.WriteValue(this.members);
      writer.WriteValue(this.closeBraceToken);
      writer.WriteValue(this.semicolonToken);
    }

    static InterfaceDeclarationSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(InterfaceDeclarationSyntax), r => new InterfaceDeclarationSyntax(r));
    }
  }

  /// <summary>Enum type declaration syntax.</summary>
  internal sealed partial class EnumDeclarationSyntax : BaseTypeDeclarationSyntax
  {
    internal readonly GreenNode attributeLists;
    internal readonly GreenNode modifiers;
    internal readonly SyntaxToken enumKeyword;
    internal readonly SyntaxToken identifier;
    internal readonly BaseListSyntax baseList;
    internal readonly SyntaxToken openBraceToken;
    internal readonly GreenNode members;
    internal readonly SyntaxToken closeBraceToken;
    internal readonly SyntaxToken semicolonToken;

    internal EnumDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken enumKeyword, SyntaxToken identifier, BaseListSyntax baseList, SyntaxToken openBraceToken, GreenNode members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(enumKeyword);
        this.enumKeyword = enumKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (baseList != null)
        {
            this.AdjustFlagsAndWidth(baseList);
            this.baseList = baseList;
        }
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }


    internal EnumDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken enumKeyword, SyntaxToken identifier, BaseListSyntax baseList, SyntaxToken openBraceToken, GreenNode members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(enumKeyword);
        this.enumKeyword = enumKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (baseList != null)
        {
            this.AdjustFlagsAndWidth(baseList);
            this.baseList = baseList;
        }
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }


    internal EnumDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken enumKeyword, SyntaxToken identifier, BaseListSyntax baseList, SyntaxToken openBraceToken, GreenNode members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(enumKeyword);
        this.enumKeyword = enumKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (baseList != null)
        {
            this.AdjustFlagsAndWidth(baseList);
            this.baseList = baseList;
        }
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> Modifiers => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    /// <summary>Gets the enum keyword token.</summary>
    public SyntaxToken EnumKeyword => this.enumKeyword;
    public override SyntaxToken Identifier => this.identifier;
    public override BaseListSyntax BaseList => this.baseList;
    public override SyntaxToken OpenBraceToken => this.openBraceToken;
    /// <summary>Gets the members declaration list.</summary>
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<EnumMemberDeclarationSyntax> Members => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<EnumMemberDeclarationSyntax>(new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<CSharpSyntaxNode>(this.members));
    public override SyntaxToken CloseBraceToken => this.closeBraceToken;
    /// <summary>Gets the optional semicolon token.</summary>
    public override SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 1: return this.modifiers;
            case 2: return this.enumKeyword;
            case 3: return this.identifier;
            case 4: return this.baseList;
            case 5: return this.openBraceToken;
            case 6: return this.members;
            case 7: return this.closeBraceToken;
            case 8: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.EnumDeclarationSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitEnumDeclaration(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitEnumDeclaration(this);

    public EnumDeclarationSyntax Update(Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> attributeLists, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken enumKeyword, SyntaxToken identifier, BaseListSyntax baseList, SyntaxToken openBraceToken, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<EnumMemberDeclarationSyntax> members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || enumKeyword != this.EnumKeyword || identifier != this.Identifier || baseList != this.BaseList || openBraceToken != this.OpenBraceToken || members != this.Members || closeBraceToken != this.CloseBraceToken || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.EnumDeclaration(attributeLists, modifiers, enumKeyword, identifier, baseList, openBraceToken, members, closeBraceToken, semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new EnumDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.enumKeyword, this.identifier, this.baseList, this.openBraceToken, this.members, this.closeBraceToken, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new EnumDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.enumKeyword, this.identifier, this.baseList, this.openBraceToken, this.members, this.closeBraceToken, this.semicolonToken, GetDiagnostics(), annotations);

    internal EnumDeclarationSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 9;
      var attributeLists = (GreenNode)reader.ReadValue();
      if (attributeLists != null)
      {
         AdjustFlagsAndWidth(attributeLists);
         this.attributeLists = attributeLists;
      }
      var modifiers = (GreenNode)reader.ReadValue();
      if (modifiers != null)
      {
         AdjustFlagsAndWidth(modifiers);
         this.modifiers = modifiers;
      }
      var enumKeyword = (SyntaxToken)reader.ReadValue();
      if (enumKeyword != null)
      {
         AdjustFlagsAndWidth(enumKeyword);
         this.enumKeyword = enumKeyword;
      }
      var identifier = (SyntaxToken)reader.ReadValue();
      if (identifier != null)
      {
         AdjustFlagsAndWidth(identifier);
         this.identifier = identifier;
      }
      var baseList = (BaseListSyntax)reader.ReadValue();
      if (baseList != null)
      {
         AdjustFlagsAndWidth(baseList);
         this.baseList = baseList;
      }
      var openBraceToken = (SyntaxToken)reader.ReadValue();
      if (openBraceToken != null)
      {
         AdjustFlagsAndWidth(openBraceToken);
         this.openBraceToken = openBraceToken;
      }
      var members = (GreenNode)reader.ReadValue();
      if (members != null)
      {
         AdjustFlagsAndWidth(members);
         this.members = members;
      }
      var closeBraceToken = (SyntaxToken)reader.ReadValue();
      if (closeBraceToken != null)
      {
         AdjustFlagsAndWidth(closeBraceToken);
         this.closeBraceToken = closeBraceToken;
      }
      var semicolonToken = (SyntaxToken)reader.ReadValue();
      if (semicolonToken != null)
      {
         AdjustFlagsAndWidth(semicolonToken);
         this.semicolonToken = semicolonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.attributeLists);
      writer.WriteValue(this.modifiers);
      writer.WriteValue(this.enumKeyword);
      writer.WriteValue(this.identifier);
      writer.WriteValue(this.baseList);
      writer.WriteValue(this.openBraceToken);
      writer.WriteValue(this.members);
      writer.WriteValue(this.closeBraceToken);
      writer.WriteValue(this.semicolonToken);
    }

    static EnumDeclarationSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(EnumDeclarationSyntax), r => new EnumDeclarationSyntax(r));
    }
  }

  /// <summary>Delegate declaration syntax.</summary>
  internal sealed partial class DelegateDeclarationSyntax : MemberDeclarationSyntax
  {
    internal readonly GreenNode attributeLists;
    internal readonly GreenNode modifiers;
    internal readonly SyntaxToken delegateKeyword;
    internal readonly TypeSyntax returnType;
    internal readonly SyntaxToken identifier;
    internal readonly TypeParameterListSyntax typeParameterList;
    internal readonly ParameterListSyntax parameterList;
    internal readonly GreenNode constraintClauses;
    internal readonly SyntaxToken semicolonToken;

    internal DelegateDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken delegateKeyword, TypeSyntax returnType, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, ParameterListSyntax parameterList, GreenNode constraintClauses, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(delegateKeyword);
        this.delegateKeyword = delegateKeyword;
        this.AdjustFlagsAndWidth(returnType);
        this.returnType = returnType;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal DelegateDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken delegateKeyword, TypeSyntax returnType, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, ParameterListSyntax parameterList, GreenNode constraintClauses, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(delegateKeyword);
        this.delegateKeyword = delegateKeyword;
        this.AdjustFlagsAndWidth(returnType);
        this.returnType = returnType;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal DelegateDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken delegateKeyword, TypeSyntax returnType, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, ParameterListSyntax parameterList, GreenNode constraintClauses, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(delegateKeyword);
        this.delegateKeyword = delegateKeyword;
        this.AdjustFlagsAndWidth(returnType);
        this.returnType = returnType;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> Modifiers => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    /// <summary>Gets the "delegate" keyword.</summary>
    public SyntaxToken DelegateKeyword => this.delegateKeyword;
    /// <summary>Gets the return type.</summary>
    public TypeSyntax ReturnType => this.returnType;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public TypeParameterListSyntax TypeParameterList => this.typeParameterList;
    /// <summary>Gets the parameter list.</summary>
    public ParameterListSyntax ParameterList => this.parameterList;
    /// <summary>Gets the constraint clause list.</summary>
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> ConstraintClauses => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<TypeParameterConstraintClauseSyntax>(this.constraintClauses);
    /// <summary>Gets the semicolon token.</summary>
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 1: return this.modifiers;
            case 2: return this.delegateKeyword;
            case 3: return this.returnType;
            case 4: return this.identifier;
            case 5: return this.typeParameterList;
            case 6: return this.parameterList;
            case 7: return this.constraintClauses;
            case 8: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.DelegateDeclarationSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitDelegateDeclaration(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitDelegateDeclaration(this);

    public DelegateDeclarationSyntax Update(Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> attributeLists, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken delegateKeyword, TypeSyntax returnType, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, ParameterListSyntax parameterList, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> constraintClauses, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || delegateKeyword != this.DelegateKeyword || returnType != this.ReturnType || identifier != this.Identifier || typeParameterList != this.TypeParameterList || parameterList != this.ParameterList || constraintClauses != this.ConstraintClauses || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.DelegateDeclaration(attributeLists, modifiers, delegateKeyword, returnType, identifier, typeParameterList, parameterList, constraintClauses, semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new DelegateDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.delegateKeyword, this.returnType, this.identifier, this.typeParameterList, this.parameterList, this.constraintClauses, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new DelegateDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.delegateKeyword, this.returnType, this.identifier, this.typeParameterList, this.parameterList, this.constraintClauses, this.semicolonToken, GetDiagnostics(), annotations);

    internal DelegateDeclarationSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 9;
      var attributeLists = (GreenNode)reader.ReadValue();
      if (attributeLists != null)
      {
         AdjustFlagsAndWidth(attributeLists);
         this.attributeLists = attributeLists;
      }
      var modifiers = (GreenNode)reader.ReadValue();
      if (modifiers != null)
      {
         AdjustFlagsAndWidth(modifiers);
         this.modifiers = modifiers;
      }
      var delegateKeyword = (SyntaxToken)reader.ReadValue();
      if (delegateKeyword != null)
      {
         AdjustFlagsAndWidth(delegateKeyword);
         this.delegateKeyword = delegateKeyword;
      }
      var returnType = (TypeSyntax)reader.ReadValue();
      if (returnType != null)
      {
         AdjustFlagsAndWidth(returnType);
         this.returnType = returnType;
      }
      var identifier = (SyntaxToken)reader.ReadValue();
      if (identifier != null)
      {
         AdjustFlagsAndWidth(identifier);
         this.identifier = identifier;
      }
      var typeParameterList = (TypeParameterListSyntax)reader.ReadValue();
      if (typeParameterList != null)
      {
         AdjustFlagsAndWidth(typeParameterList);
         this.typeParameterList = typeParameterList;
      }
      var parameterList = (ParameterListSyntax)reader.ReadValue();
      if (parameterList != null)
      {
         AdjustFlagsAndWidth(parameterList);
         this.parameterList = parameterList;
      }
      var constraintClauses = (GreenNode)reader.ReadValue();
      if (constraintClauses != null)
      {
         AdjustFlagsAndWidth(constraintClauses);
         this.constraintClauses = constraintClauses;
      }
      var semicolonToken = (SyntaxToken)reader.ReadValue();
      if (semicolonToken != null)
      {
         AdjustFlagsAndWidth(semicolonToken);
         this.semicolonToken = semicolonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.attributeLists);
      writer.WriteValue(this.modifiers);
      writer.WriteValue(this.delegateKeyword);
      writer.WriteValue(this.returnType);
      writer.WriteValue(this.identifier);
      writer.WriteValue(this.typeParameterList);
      writer.WriteValue(this.parameterList);
      writer.WriteValue(this.constraintClauses);
      writer.WriteValue(this.semicolonToken);
    }

    static DelegateDeclarationSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(DelegateDeclarationSyntax), r => new DelegateDeclarationSyntax(r));
    }
  }

  internal sealed partial class EnumMemberDeclarationSyntax : MemberDeclarationSyntax
  {
    internal readonly GreenNode attributeLists;
    internal readonly GreenNode modifiers;
    internal readonly SyntaxToken identifier;
    internal readonly EqualsValueClauseSyntax equalsValue;

    internal EnumMemberDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken identifier, EqualsValueClauseSyntax equalsValue, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (equalsValue != null)
        {
            this.AdjustFlagsAndWidth(equalsValue);
            this.equalsValue = equalsValue;
        }
    }


    internal EnumMemberDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken identifier, EqualsValueClauseSyntax equalsValue, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (equalsValue != null)
        {
            this.AdjustFlagsAndWidth(equalsValue);
            this.equalsValue = equalsValue;
        }
    }


    internal EnumMemberDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken identifier, EqualsValueClauseSyntax equalsValue)
        : base(kind)
    {
        this.SlotCount = 4;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (equalsValue != null)
        {
            this.AdjustFlagsAndWidth(equalsValue);
            this.equalsValue = equalsValue;
        }
    }

    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> Modifiers => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public EqualsValueClauseSyntax EqualsValue => this.equalsValue;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 1: return this.modifiers;
            case 2: return this.identifier;
            case 3: return this.equalsValue;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.EnumMemberDeclarationSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitEnumMemberDeclaration(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitEnumMemberDeclaration(this);

    public EnumMemberDeclarationSyntax Update(Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> attributeLists, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken identifier, EqualsValueClauseSyntax equalsValue)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || identifier != this.Identifier || equalsValue != this.EqualsValue)
        {
            var newNode = SyntaxFactory.EnumMemberDeclaration(attributeLists, modifiers, identifier, equalsValue);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new EnumMemberDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.identifier, this.equalsValue, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new EnumMemberDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.identifier, this.equalsValue, GetDiagnostics(), annotations);

    internal EnumMemberDeclarationSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var attributeLists = (GreenNode)reader.ReadValue();
      if (attributeLists != null)
      {
         AdjustFlagsAndWidth(attributeLists);
         this.attributeLists = attributeLists;
      }
      var modifiers = (GreenNode)reader.ReadValue();
      if (modifiers != null)
      {
         AdjustFlagsAndWidth(modifiers);
         this.modifiers = modifiers;
      }
      var identifier = (SyntaxToken)reader.ReadValue();
      if (identifier != null)
      {
         AdjustFlagsAndWidth(identifier);
         this.identifier = identifier;
      }
      var equalsValue = (EqualsValueClauseSyntax)reader.ReadValue();
      if (equalsValue != null)
      {
         AdjustFlagsAndWidth(equalsValue);
         this.equalsValue = equalsValue;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.attributeLists);
      writer.WriteValue(this.modifiers);
      writer.WriteValue(this.identifier);
      writer.WriteValue(this.equalsValue);
    }

    static EnumMemberDeclarationSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(EnumMemberDeclarationSyntax), r => new EnumMemberDeclarationSyntax(r));
    }
  }

  /// <summary>Base list syntax.</summary>
  internal sealed partial class BaseListSyntax : CSharpSyntaxNode
  {
    internal readonly SyntaxToken colonToken;
    internal readonly GreenNode types;

    internal BaseListSyntax(SyntaxKind kind, SyntaxToken colonToken, GreenNode types, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        if (types != null)
        {
            this.AdjustFlagsAndWidth(types);
            this.types = types;
        }
    }


    internal BaseListSyntax(SyntaxKind kind, SyntaxToken colonToken, GreenNode types, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        if (types != null)
        {
            this.AdjustFlagsAndWidth(types);
            this.types = types;
        }
    }


    internal BaseListSyntax(SyntaxKind kind, SyntaxToken colonToken, GreenNode types)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        if (types != null)
        {
            this.AdjustFlagsAndWidth(types);
            this.types = types;
        }
    }

    /// <summary>Gets the colon token.</summary>
    public SyntaxToken ColonToken => this.colonToken;
    /// <summary>Gets the base type references.</summary>
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<BaseTypeSyntax> Types => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<BaseTypeSyntax>(new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<CSharpSyntaxNode>(this.types));

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.colonToken;
            case 1: return this.types;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.BaseListSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitBaseList(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitBaseList(this);

    public BaseListSyntax Update(SyntaxToken colonToken, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<BaseTypeSyntax> types)
    {
        if (colonToken != this.ColonToken || types != this.Types)
        {
            var newNode = SyntaxFactory.BaseList(colonToken, types);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new BaseListSyntax(this.Kind, this.colonToken, this.types, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new BaseListSyntax(this.Kind, this.colonToken, this.types, GetDiagnostics(), annotations);

    internal BaseListSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var colonToken = (SyntaxToken)reader.ReadValue();
      if (colonToken != null)
      {
         AdjustFlagsAndWidth(colonToken);
         this.colonToken = colonToken;
      }
      var types = (GreenNode)reader.ReadValue();
      if (types != null)
      {
         AdjustFlagsAndWidth(types);
         this.types = types;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.colonToken);
      writer.WriteValue(this.types);
    }

    static BaseListSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(BaseListSyntax), r => new BaseListSyntax(r));
    }
  }

  /// <summary>Provides the base class from which the classes that represent base type syntax nodes are derived. This is an abstract class.</summary>
  internal abstract partial class BaseTypeSyntax : CSharpSyntaxNode
  {
    internal BaseTypeSyntax(SyntaxKind kind, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal BaseTypeSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    protected BaseTypeSyntax(ObjectReader reader)
       : base(reader)
    {
    }

    public abstract TypeSyntax Type { get; }
  }

  internal sealed partial class SimpleBaseTypeSyntax : BaseTypeSyntax
  {
    internal readonly TypeSyntax type;

    internal SimpleBaseTypeSyntax(SyntaxKind kind, TypeSyntax type, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }


    internal SimpleBaseTypeSyntax(SyntaxKind kind, TypeSyntax type, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }


    internal SimpleBaseTypeSyntax(SyntaxKind kind, TypeSyntax type)
        : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }

    public override TypeSyntax Type => this.type;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.type;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.SimpleBaseTypeSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitSimpleBaseType(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitSimpleBaseType(this);

    public SimpleBaseTypeSyntax Update(TypeSyntax type)
    {
        if (type != this.Type)
        {
            var newNode = SyntaxFactory.SimpleBaseType(type);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new SimpleBaseTypeSyntax(this.Kind, this.type, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new SimpleBaseTypeSyntax(this.Kind, this.type, GetDiagnostics(), annotations);

    internal SimpleBaseTypeSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 1;
      var type = (TypeSyntax)reader.ReadValue();
      if (type != null)
      {
         AdjustFlagsAndWidth(type);
         this.type = type;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.type);
    }

    static SimpleBaseTypeSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(SimpleBaseTypeSyntax), r => new SimpleBaseTypeSyntax(r));
    }
  }

  /// <summary>Type parameter constraint clause.</summary>
  internal sealed partial class TypeParameterConstraintClauseSyntax : CSharpSyntaxNode
  {
    internal readonly SyntaxToken whereKeyword;
    internal readonly IdentifierNameSyntax name;
    internal readonly SyntaxToken colonToken;
    internal readonly GreenNode constraints;

    internal TypeParameterConstraintClauseSyntax(SyntaxKind kind, SyntaxToken whereKeyword, IdentifierNameSyntax name, SyntaxToken colonToken, GreenNode constraints, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(whereKeyword);
        this.whereKeyword = whereKeyword;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        if (constraints != null)
        {
            this.AdjustFlagsAndWidth(constraints);
            this.constraints = constraints;
        }
    }


    internal TypeParameterConstraintClauseSyntax(SyntaxKind kind, SyntaxToken whereKeyword, IdentifierNameSyntax name, SyntaxToken colonToken, GreenNode constraints, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(whereKeyword);
        this.whereKeyword = whereKeyword;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        if (constraints != null)
        {
            this.AdjustFlagsAndWidth(constraints);
            this.constraints = constraints;
        }
    }


    internal TypeParameterConstraintClauseSyntax(SyntaxKind kind, SyntaxToken whereKeyword, IdentifierNameSyntax name, SyntaxToken colonToken, GreenNode constraints)
        : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(whereKeyword);
        this.whereKeyword = whereKeyword;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        if (constraints != null)
        {
            this.AdjustFlagsAndWidth(constraints);
            this.constraints = constraints;
        }
    }

    public SyntaxToken WhereKeyword => this.whereKeyword;
    /// <summary>Gets the identifier.</summary>
    public IdentifierNameSyntax Name => this.name;
    /// <summary>Gets the colon token.</summary>
    public SyntaxToken ColonToken => this.colonToken;
    /// <summary>Gets the constraints list.</summary>
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<TypeParameterConstraintSyntax> Constraints => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<TypeParameterConstraintSyntax>(new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<CSharpSyntaxNode>(this.constraints));

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.whereKeyword;
            case 1: return this.name;
            case 2: return this.colonToken;
            case 3: return this.constraints;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.TypeParameterConstraintClauseSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitTypeParameterConstraintClause(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitTypeParameterConstraintClause(this);

    public TypeParameterConstraintClauseSyntax Update(SyntaxToken whereKeyword, IdentifierNameSyntax name, SyntaxToken colonToken, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SeparatedSyntaxList<TypeParameterConstraintSyntax> constraints)
    {
        if (whereKeyword != this.WhereKeyword || name != this.Name || colonToken != this.ColonToken || constraints != this.Constraints)
        {
            var newNode = SyntaxFactory.TypeParameterConstraintClause(whereKeyword, name, colonToken, constraints);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new TypeParameterConstraintClauseSyntax(this.Kind, this.whereKeyword, this.name, this.colonToken, this.constraints, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new TypeParameterConstraintClauseSyntax(this.Kind, this.whereKeyword, this.name, this.colonToken, this.constraints, GetDiagnostics(), annotations);

    internal TypeParameterConstraintClauseSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var whereKeyword = (SyntaxToken)reader.ReadValue();
      if (whereKeyword != null)
      {
         AdjustFlagsAndWidth(whereKeyword);
         this.whereKeyword = whereKeyword;
      }
      var name = (IdentifierNameSyntax)reader.ReadValue();
      if (name != null)
      {
         AdjustFlagsAndWidth(name);
         this.name = name;
      }
      var colonToken = (SyntaxToken)reader.ReadValue();
      if (colonToken != null)
      {
         AdjustFlagsAndWidth(colonToken);
         this.colonToken = colonToken;
      }
      var constraints = (GreenNode)reader.ReadValue();
      if (constraints != null)
      {
         AdjustFlagsAndWidth(constraints);
         this.constraints = constraints;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.whereKeyword);
      writer.WriteValue(this.name);
      writer.WriteValue(this.colonToken);
      writer.WriteValue(this.constraints);
    }

    static TypeParameterConstraintClauseSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(TypeParameterConstraintClauseSyntax), r => new TypeParameterConstraintClauseSyntax(r));
    }
  }

  /// <summary>Base type for type parameter constraint syntax.</summary>
  internal abstract partial class TypeParameterConstraintSyntax : CSharpSyntaxNode
  {
    internal TypeParameterConstraintSyntax(SyntaxKind kind, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal TypeParameterConstraintSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    protected TypeParameterConstraintSyntax(ObjectReader reader)
       : base(reader)
    {
    }
  }

  /// <summary>Constructor constraint syntax.</summary>
  internal sealed partial class ConstructorConstraintSyntax : TypeParameterConstraintSyntax
  {
    internal readonly SyntaxToken newKeyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly SyntaxToken closeParenToken;

    internal ConstructorConstraintSyntax(SyntaxKind kind, SyntaxToken newKeyword, SyntaxToken openParenToken, SyntaxToken closeParenToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal ConstructorConstraintSyntax(SyntaxKind kind, SyntaxToken newKeyword, SyntaxToken openParenToken, SyntaxToken closeParenToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }


    internal ConstructorConstraintSyntax(SyntaxKind kind, SyntaxToken newKeyword, SyntaxToken openParenToken, SyntaxToken closeParenToken)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>Gets the "new" keyword.</summary>
    public SyntaxToken NewKeyword => this.newKeyword;
    /// <summary>Gets the open paren keyword.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>Gets the close paren keyword.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.newKeyword;
            case 1: return this.openParenToken;
            case 2: return this.closeParenToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ConstructorConstraintSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitConstructorConstraint(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitConstructorConstraint(this);

    public ConstructorConstraintSyntax Update(SyntaxToken newKeyword, SyntaxToken openParenToken, SyntaxToken closeParenToken)
    {
        if (newKeyword != this.NewKeyword || openParenToken != this.OpenParenToken || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.ConstructorConstraint(newKeyword, openParenToken, closeParenToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ConstructorConstraintSyntax(this.Kind, this.newKeyword, this.openParenToken, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ConstructorConstraintSyntax(this.Kind, this.newKeyword, this.openParenToken, this.closeParenToken, GetDiagnostics(), annotations);

    internal ConstructorConstraintSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var newKeyword = (SyntaxToken)reader.ReadValue();
      if (newKeyword != null)
      {
         AdjustFlagsAndWidth(newKeyword);
         this.newKeyword = newKeyword;
      }
      var openParenToken = (SyntaxToken)reader.ReadValue();
      if (openParenToken != null)
      {
         AdjustFlagsAndWidth(openParenToken);
         this.openParenToken = openParenToken;
      }
      var closeParenToken = (SyntaxToken)reader.ReadValue();
      if (closeParenToken != null)
      {
         AdjustFlagsAndWidth(closeParenToken);
         this.closeParenToken = closeParenToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.newKeyword);
      writer.WriteValue(this.openParenToken);
      writer.WriteValue(this.closeParenToken);
    }

    static ConstructorConstraintSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ConstructorConstraintSyntax), r => new ConstructorConstraintSyntax(r));
    }
  }

  /// <summary>Base type for class or struct constraint syntax.</summary>
  internal sealed partial class ClassOrStructConstraintSyntax : TypeParameterConstraintSyntax
  {
    internal readonly SyntaxToken classOrStructKeyword;
    internal readonly SyntaxToken questionToken;

    internal ClassOrStructConstraintSyntax(SyntaxKind kind, SyntaxToken classOrStructKeyword, SyntaxToken questionToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(classOrStructKeyword);
        this.classOrStructKeyword = classOrStructKeyword;
        if (questionToken != null)
        {
            this.AdjustFlagsAndWidth(questionToken);
            this.questionToken = questionToken;
        }
    }


    internal ClassOrStructConstraintSyntax(SyntaxKind kind, SyntaxToken classOrStructKeyword, SyntaxToken questionToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(classOrStructKeyword);
        this.classOrStructKeyword = classOrStructKeyword;
        if (questionToken != null)
        {
            this.AdjustFlagsAndWidth(questionToken);
            this.questionToken = questionToken;
        }
    }


    internal ClassOrStructConstraintSyntax(SyntaxKind kind, SyntaxToken classOrStructKeyword, SyntaxToken questionToken)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(classOrStructKeyword);
        this.classOrStructKeyword = classOrStructKeyword;
        if (questionToken != null)
        {
            this.AdjustFlagsAndWidth(questionToken);
            this.questionToken = questionToken;
        }
    }

    /// <summary>Gets the constraint keyword ("class" or "struct").</summary>
    public SyntaxToken ClassOrStructKeyword => this.classOrStructKeyword;
    /// <summary>SyntaxToken representing the question mark.</summary>
    public SyntaxToken QuestionToken => this.questionToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.classOrStructKeyword;
            case 1: return this.questionToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ClassOrStructConstraintSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitClassOrStructConstraint(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitClassOrStructConstraint(this);

    public ClassOrStructConstraintSyntax Update(SyntaxToken classOrStructKeyword, SyntaxToken questionToken)
    {
        if (classOrStructKeyword != this.ClassOrStructKeyword || questionToken != this.QuestionToken)
        {
            var newNode = SyntaxFactory.ClassOrStructConstraint(this.Kind, classOrStructKeyword, questionToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ClassOrStructConstraintSyntax(this.Kind, this.classOrStructKeyword, this.questionToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ClassOrStructConstraintSyntax(this.Kind, this.classOrStructKeyword, this.questionToken, GetDiagnostics(), annotations);

    internal ClassOrStructConstraintSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var classOrStructKeyword = (SyntaxToken)reader.ReadValue();
      if (classOrStructKeyword != null)
      {
         AdjustFlagsAndWidth(classOrStructKeyword);
         this.classOrStructKeyword = classOrStructKeyword;
      }
      var questionToken = (SyntaxToken)reader.ReadValue();
      if (questionToken != null)
      {
         AdjustFlagsAndWidth(questionToken);
         this.questionToken = questionToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.classOrStructKeyword);
      writer.WriteValue(this.questionToken);
    }

    static ClassOrStructConstraintSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ClassOrStructConstraintSyntax), r => new ClassOrStructConstraintSyntax(r));
    }
  }

  /// <summary>Type constraint syntax.</summary>
  internal sealed partial class TypeConstraintSyntax : TypeParameterConstraintSyntax
  {
    internal readonly TypeSyntax type;

    internal TypeConstraintSyntax(SyntaxKind kind, TypeSyntax type, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }


    internal TypeConstraintSyntax(SyntaxKind kind, TypeSyntax type, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }


    internal TypeConstraintSyntax(SyntaxKind kind, TypeSyntax type)
        : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }

    /// <summary>Gets the type syntax.</summary>
    public TypeSyntax Type => this.type;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.type;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.TypeConstraintSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitTypeConstraint(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitTypeConstraint(this);

    public TypeConstraintSyntax Update(TypeSyntax type)
    {
        if (type != this.Type)
        {
            var newNode = SyntaxFactory.TypeConstraint(type);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new TypeConstraintSyntax(this.Kind, this.type, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new TypeConstraintSyntax(this.Kind, this.type, GetDiagnostics(), annotations);

    internal TypeConstraintSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 1;
      var type = (TypeSyntax)reader.ReadValue();
      if (type != null)
      {
         AdjustFlagsAndWidth(type);
         this.type = type;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.type);
    }

    static TypeConstraintSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(TypeConstraintSyntax), r => new TypeConstraintSyntax(r));
    }
  }

  internal abstract partial class BaseFieldDeclarationSyntax : MemberDeclarationSyntax
  {
    internal BaseFieldDeclarationSyntax(SyntaxKind kind, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal BaseFieldDeclarationSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    protected BaseFieldDeclarationSyntax(ObjectReader reader)
       : base(reader)
    {
    }

    public abstract VariableDeclarationSyntax Declaration { get; }

    public abstract SyntaxToken SemicolonToken { get; }
  }

  internal sealed partial class FieldDeclarationSyntax : BaseFieldDeclarationSyntax
  {
    internal readonly GreenNode attributeLists;
    internal readonly GreenNode modifiers;
    internal readonly VariableDeclarationSyntax declaration;
    internal readonly SyntaxToken semicolonToken;

    internal FieldDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, VariableDeclarationSyntax declaration, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(declaration);
        this.declaration = declaration;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal FieldDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, VariableDeclarationSyntax declaration, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(declaration);
        this.declaration = declaration;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal FieldDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, VariableDeclarationSyntax declaration, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 4;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(declaration);
        this.declaration = declaration;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> Modifiers => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    public override VariableDeclarationSyntax Declaration => this.declaration;
    public override SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 1: return this.modifiers;
            case 2: return this.declaration;
            case 3: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.FieldDeclarationSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitFieldDeclaration(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitFieldDeclaration(this);

    public FieldDeclarationSyntax Update(Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> attributeLists, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> modifiers, VariableDeclarationSyntax declaration, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || declaration != this.Declaration || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.FieldDeclaration(attributeLists, modifiers, declaration, semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new FieldDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.declaration, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new FieldDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.declaration, this.semicolonToken, GetDiagnostics(), annotations);

    internal FieldDeclarationSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 4;
      var attributeLists = (GreenNode)reader.ReadValue();
      if (attributeLists != null)
      {
         AdjustFlagsAndWidth(attributeLists);
         this.attributeLists = attributeLists;
      }
      var modifiers = (GreenNode)reader.ReadValue();
      if (modifiers != null)
      {
         AdjustFlagsAndWidth(modifiers);
         this.modifiers = modifiers;
      }
      var declaration = (VariableDeclarationSyntax)reader.ReadValue();
      if (declaration != null)
      {
         AdjustFlagsAndWidth(declaration);
         this.declaration = declaration;
      }
      var semicolonToken = (SyntaxToken)reader.ReadValue();
      if (semicolonToken != null)
      {
         AdjustFlagsAndWidth(semicolonToken);
         this.semicolonToken = semicolonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.attributeLists);
      writer.WriteValue(this.modifiers);
      writer.WriteValue(this.declaration);
      writer.WriteValue(this.semicolonToken);
    }

    static FieldDeclarationSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(FieldDeclarationSyntax), r => new FieldDeclarationSyntax(r));
    }
  }

  internal sealed partial class EventFieldDeclarationSyntax : BaseFieldDeclarationSyntax
  {
    internal readonly GreenNode attributeLists;
    internal readonly GreenNode modifiers;
    internal readonly SyntaxToken eventKeyword;
    internal readonly VariableDeclarationSyntax declaration;
    internal readonly SyntaxToken semicolonToken;

    internal EventFieldDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken eventKeyword, VariableDeclarationSyntax declaration, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 5;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(eventKeyword);
        this.eventKeyword = eventKeyword;
        this.AdjustFlagsAndWidth(declaration);
        this.declaration = declaration;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal EventFieldDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken eventKeyword, VariableDeclarationSyntax declaration, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 5;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(eventKeyword);
        this.eventKeyword = eventKeyword;
        this.AdjustFlagsAndWidth(declaration);
        this.declaration = declaration;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }


    internal EventFieldDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken eventKeyword, VariableDeclarationSyntax declaration, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 5;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(eventKeyword);
        this.eventKeyword = eventKeyword;
        this.AdjustFlagsAndWidth(declaration);
        this.declaration = declaration;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> Modifiers => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    public SyntaxToken EventKeyword => this.eventKeyword;
    public override VariableDeclarationSyntax Declaration => this.declaration;
    public override SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 1: return this.modifiers;
            case 2: return this.eventKeyword;
            case 3: return this.declaration;
            case 4: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.EventFieldDeclarationSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitEventFieldDeclaration(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitEventFieldDeclaration(this);

    public EventFieldDeclarationSyntax Update(Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> attributeLists, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken eventKeyword, VariableDeclarationSyntax declaration, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || eventKeyword != this.EventKeyword || declaration != this.Declaration || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.EventFieldDeclaration(attributeLists, modifiers, eventKeyword, declaration, semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new EventFieldDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.eventKeyword, this.declaration, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new EventFieldDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.eventKeyword, this.declaration, this.semicolonToken, GetDiagnostics(), annotations);

    internal EventFieldDeclarationSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 5;
      var attributeLists = (GreenNode)reader.ReadValue();
      if (attributeLists != null)
      {
         AdjustFlagsAndWidth(attributeLists);
         this.attributeLists = attributeLists;
      }
      var modifiers = (GreenNode)reader.ReadValue();
      if (modifiers != null)
      {
         AdjustFlagsAndWidth(modifiers);
         this.modifiers = modifiers;
      }
      var eventKeyword = (SyntaxToken)reader.ReadValue();
      if (eventKeyword != null)
      {
         AdjustFlagsAndWidth(eventKeyword);
         this.eventKeyword = eventKeyword;
      }
      var declaration = (VariableDeclarationSyntax)reader.ReadValue();
      if (declaration != null)
      {
         AdjustFlagsAndWidth(declaration);
         this.declaration = declaration;
      }
      var semicolonToken = (SyntaxToken)reader.ReadValue();
      if (semicolonToken != null)
      {
         AdjustFlagsAndWidth(semicolonToken);
         this.semicolonToken = semicolonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.attributeLists);
      writer.WriteValue(this.modifiers);
      writer.WriteValue(this.eventKeyword);
      writer.WriteValue(this.declaration);
      writer.WriteValue(this.semicolonToken);
    }

    static EventFieldDeclarationSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(EventFieldDeclarationSyntax), r => new EventFieldDeclarationSyntax(r));
    }
  }

  internal sealed partial class ExplicitInterfaceSpecifierSyntax : CSharpSyntaxNode
  {
    internal readonly NameSyntax name;
    internal readonly SyntaxToken dotToken;

    internal ExplicitInterfaceSpecifierSyntax(SyntaxKind kind, NameSyntax name, SyntaxToken dotToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(dotToken);
        this.dotToken = dotToken;
    }


    internal ExplicitInterfaceSpecifierSyntax(SyntaxKind kind, NameSyntax name, SyntaxToken dotToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(dotToken);
        this.dotToken = dotToken;
    }


    internal ExplicitInterfaceSpecifierSyntax(SyntaxKind kind, NameSyntax name, SyntaxToken dotToken)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(dotToken);
        this.dotToken = dotToken;
    }

    public NameSyntax Name => this.name;
    public SyntaxToken DotToken => this.dotToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.name;
            case 1: return this.dotToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ExplicitInterfaceSpecifierSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitExplicitInterfaceSpecifier(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitExplicitInterfaceSpecifier(this);

    public ExplicitInterfaceSpecifierSyntax Update(NameSyntax name, SyntaxToken dotToken)
    {
        if (name != this.Name || dotToken != this.DotToken)
        {
            var newNode = SyntaxFactory.ExplicitInterfaceSpecifier(name, dotToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ExplicitInterfaceSpecifierSyntax(this.Kind, this.name, this.dotToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ExplicitInterfaceSpecifierSyntax(this.Kind, this.name, this.dotToken, GetDiagnostics(), annotations);

    internal ExplicitInterfaceSpecifierSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var name = (NameSyntax)reader.ReadValue();
      if (name != null)
      {
         AdjustFlagsAndWidth(name);
         this.name = name;
      }
      var dotToken = (SyntaxToken)reader.ReadValue();
      if (dotToken != null)
      {
         AdjustFlagsAndWidth(dotToken);
         this.dotToken = dotToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.name);
      writer.WriteValue(this.dotToken);
    }

    static ExplicitInterfaceSpecifierSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ExplicitInterfaceSpecifierSyntax), r => new ExplicitInterfaceSpecifierSyntax(r));
    }
  }

  /// <summary>Base type for method declaration syntax.</summary>
  internal abstract partial class BaseMethodDeclarationSyntax : MemberDeclarationSyntax
  {
    internal BaseMethodDeclarationSyntax(SyntaxKind kind, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal BaseMethodDeclarationSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    protected BaseMethodDeclarationSyntax(ObjectReader reader)
       : base(reader)
    {
    }

    /// <summary>Gets the parameter list.</summary>
    public abstract ParameterListSyntax ParameterList { get; }

    public abstract BlockSyntax Body { get; }

    public abstract ArrowExpressionClauseSyntax ExpressionBody { get; }

    /// <summary>Gets the optional semicolon token.</summary>
    public abstract SyntaxToken SemicolonToken { get; }
  }

  /// <summary>Method declaration syntax.</summary>
  internal sealed partial class MethodDeclarationSyntax : BaseMethodDeclarationSyntax
  {
    internal readonly GreenNode attributeLists;
    internal readonly GreenNode modifiers;
    internal readonly TypeSyntax returnType;
    internal readonly ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier;
    internal readonly SyntaxToken identifier;
    internal readonly TypeParameterListSyntax typeParameterList;
    internal readonly ParameterListSyntax parameterList;
    internal readonly GreenNode constraintClauses;
    internal readonly BlockSyntax body;
    internal readonly ArrowExpressionClauseSyntax expressionBody;
    internal readonly SyntaxToken semicolonToken;

    internal MethodDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, TypeSyntax returnType, ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, ParameterListSyntax parameterList, GreenNode constraintClauses, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 11;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(returnType);
        this.returnType = returnType;
        if (explicitInterfaceSpecifier != null)
        {
            this.AdjustFlagsAndWidth(explicitInterfaceSpecifier);
            this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }


    internal MethodDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, TypeSyntax returnType, ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, ParameterListSyntax parameterList, GreenNode constraintClauses, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 11;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(returnType);
        this.returnType = returnType;
        if (explicitInterfaceSpecifier != null)
        {
            this.AdjustFlagsAndWidth(explicitInterfaceSpecifier);
            this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }


    internal MethodDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, TypeSyntax returnType, ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, ParameterListSyntax parameterList, GreenNode constraintClauses, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 11;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(returnType);
        this.returnType = returnType;
        if (explicitInterfaceSpecifier != null)
        {
            this.AdjustFlagsAndWidth(explicitInterfaceSpecifier);
            this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> Modifiers => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    /// <summary>Gets the return type syntax.</summary>
    public TypeSyntax ReturnType => this.returnType;
    public ExplicitInterfaceSpecifierSyntax ExplicitInterfaceSpecifier => this.explicitInterfaceSpecifier;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public TypeParameterListSyntax TypeParameterList => this.typeParameterList;
    public override ParameterListSyntax ParameterList => this.parameterList;
    /// <summary>Gets the constraint clause list.</summary>
    public Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> ConstraintClauses => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<TypeParameterConstraintClauseSyntax>(this.constraintClauses);
    public override BlockSyntax Body => this.body;
    public override ArrowExpressionClauseSyntax ExpressionBody => this.expressionBody;
    /// <summary>Gets the optional semicolon token.</summary>
    public override SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 1: return this.modifiers;
            case 2: return this.returnType;
            case 3: return this.explicitInterfaceSpecifier;
            case 4: return this.identifier;
            case 5: return this.typeParameterList;
            case 6: return this.parameterList;
            case 7: return this.constraintClauses;
            case 8: return this.body;
            case 9: return this.expressionBody;
            case 10: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.MethodDeclarationSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitMethodDeclaration(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitMethodDeclaration(this);

    public MethodDeclarationSyntax Update(Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> attributeLists, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> modifiers, TypeSyntax returnType, ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, ParameterListSyntax parameterList, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> constraintClauses, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || returnType != this.ReturnType || explicitInterfaceSpecifier != this.ExplicitInterfaceSpecifier || identifier != this.Identifier || typeParameterList != this.TypeParameterList || parameterList != this.ParameterList || constraintClauses != this.ConstraintClauses || body != this.Body || expressionBody != this.ExpressionBody || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.MethodDeclaration(attributeLists, modifiers, returnType, explicitInterfaceSpecifier, identifier, typeParameterList, parameterList, constraintClauses, body, expressionBody, semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new MethodDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.returnType, this.explicitInterfaceSpecifier, this.identifier, this.typeParameterList, this.parameterList, this.constraintClauses, this.body, this.expressionBody, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new MethodDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.returnType, this.explicitInterfaceSpecifier, this.identifier, this.typeParameterList, this.parameterList, this.constraintClauses, this.body, this.expressionBody, this.semicolonToken, GetDiagnostics(), annotations);

    internal MethodDeclarationSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 11;
      var attributeLists = (GreenNode)reader.ReadValue();
      if (attributeLists != null)
      {
         AdjustFlagsAndWidth(attributeLists);
         this.attributeLists = attributeLists;
      }
      var modifiers = (GreenNode)reader.ReadValue();
      if (modifiers != null)
      {
         AdjustFlagsAndWidth(modifiers);
         this.modifiers = modifiers;
      }
      var returnType = (TypeSyntax)reader.ReadValue();
      if (returnType != null)
      {
         AdjustFlagsAndWidth(returnType);
         this.returnType = returnType;
      }
      var explicitInterfaceSpecifier = (ExplicitInterfaceSpecifierSyntax)reader.ReadValue();
      if (explicitInterfaceSpecifier != null)
      {
         AdjustFlagsAndWidth(explicitInterfaceSpecifier);
         this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
      }
      var identifier = (SyntaxToken)reader.ReadValue();
      if (identifier != null)
      {
         AdjustFlagsAndWidth(identifier);
         this.identifier = identifier;
      }
      var typeParameterList = (TypeParameterListSyntax)reader.ReadValue();
      if (typeParameterList != null)
      {
         AdjustFlagsAndWidth(typeParameterList);
         this.typeParameterList = typeParameterList;
      }
      var parameterList = (ParameterListSyntax)reader.ReadValue();
      if (parameterList != null)
      {
         AdjustFlagsAndWidth(parameterList);
         this.parameterList = parameterList;
      }
      var constraintClauses = (GreenNode)reader.ReadValue();
      if (constraintClauses != null)
      {
         AdjustFlagsAndWidth(constraintClauses);
         this.constraintClauses = constraintClauses;
      }
      var body = (BlockSyntax)reader.ReadValue();
      if (body != null)
      {
         AdjustFlagsAndWidth(body);
         this.body = body;
      }
      var expressionBody = (ArrowExpressionClauseSyntax)reader.ReadValue();
      if (expressionBody != null)
      {
         AdjustFlagsAndWidth(expressionBody);
         this.expressionBody = expressionBody;
      }
      var semicolonToken = (SyntaxToken)reader.ReadValue();
      if (semicolonToken != null)
      {
         AdjustFlagsAndWidth(semicolonToken);
         this.semicolonToken = semicolonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.attributeLists);
      writer.WriteValue(this.modifiers);
      writer.WriteValue(this.returnType);
      writer.WriteValue(this.explicitInterfaceSpecifier);
      writer.WriteValue(this.identifier);
      writer.WriteValue(this.typeParameterList);
      writer.WriteValue(this.parameterList);
      writer.WriteValue(this.constraintClauses);
      writer.WriteValue(this.body);
      writer.WriteValue(this.expressionBody);
      writer.WriteValue(this.semicolonToken);
    }

    static MethodDeclarationSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(MethodDeclarationSyntax), r => new MethodDeclarationSyntax(r));
    }
  }

  /// <summary>Operator declaration syntax.</summary>
  internal sealed partial class OperatorDeclarationSyntax : BaseMethodDeclarationSyntax
  {
    internal readonly GreenNode attributeLists;
    internal readonly GreenNode modifiers;
    internal readonly TypeSyntax returnType;
    internal readonly SyntaxToken operatorKeyword;
    internal readonly SyntaxToken operatorToken;
    internal readonly ParameterListSyntax parameterList;
    internal readonly BlockSyntax body;
    internal readonly ArrowExpressionClauseSyntax expressionBody;
    internal readonly SyntaxToken semicolonToken;

    internal OperatorDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, TypeSyntax returnType, SyntaxToken operatorKeyword, SyntaxToken operatorToken, ParameterListSyntax parameterList, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(returnType);
        this.returnType = returnType;
        this.AdjustFlagsAndWidth(operatorKeyword);
        this.operatorKeyword = operatorKeyword;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }


    internal OperatorDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, TypeSyntax returnType, SyntaxToken operatorKeyword, SyntaxToken operatorToken, ParameterListSyntax parameterList, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(returnType);
        this.returnType = returnType;
        this.AdjustFlagsAndWidth(operatorKeyword);
        this.operatorKeyword = operatorKeyword;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }


    internal OperatorDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, TypeSyntax returnType, SyntaxToken operatorKeyword, SyntaxToken operatorToken, ParameterListSyntax parameterList, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(returnType);
        this.returnType = returnType;
        this.AdjustFlagsAndWidth(operatorKeyword);
        this.operatorKeyword = operatorKeyword;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> Modifiers => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    /// <summary>Gets the return type.</summary>
    public TypeSyntax ReturnType => this.returnType;
    /// <summary>Gets the "operator" keyword.</summary>
    public SyntaxToken OperatorKeyword => this.operatorKeyword;
    /// <summary>Gets the operator token.</summary>
    public SyntaxToken OperatorToken => this.operatorToken;
    public override ParameterListSyntax ParameterList => this.parameterList;
    public override BlockSyntax Body => this.body;
    public override ArrowExpressionClauseSyntax ExpressionBody => this.expressionBody;
    public override SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 1: return this.modifiers;
            case 2: return this.returnType;
            case 3: return this.operatorKeyword;
            case 4: return this.operatorToken;
            case 5: return this.parameterList;
            case 6: return this.body;
            case 7: return this.expressionBody;
            case 8: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.OperatorDeclarationSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitOperatorDeclaration(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitOperatorDeclaration(this);

    public OperatorDeclarationSyntax Update(Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> attributeLists, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> modifiers, TypeSyntax returnType, SyntaxToken operatorKeyword, SyntaxToken operatorToken, ParameterListSyntax parameterList, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || returnType != this.ReturnType || operatorKeyword != this.OperatorKeyword || operatorToken != this.OperatorToken || parameterList != this.ParameterList || body != this.Body || expressionBody != this.ExpressionBody || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.OperatorDeclaration(attributeLists, modifiers, returnType, operatorKeyword, operatorToken, parameterList, body, expressionBody, semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new OperatorDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.returnType, this.operatorKeyword, this.operatorToken, this.parameterList, this.body, this.expressionBody, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new OperatorDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.returnType, this.operatorKeyword, this.operatorToken, this.parameterList, this.body, this.expressionBody, this.semicolonToken, GetDiagnostics(), annotations);

    internal OperatorDeclarationSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 9;
      var attributeLists = (GreenNode)reader.ReadValue();
      if (attributeLists != null)
      {
         AdjustFlagsAndWidth(attributeLists);
         this.attributeLists = attributeLists;
      }
      var modifiers = (GreenNode)reader.ReadValue();
      if (modifiers != null)
      {
         AdjustFlagsAndWidth(modifiers);
         this.modifiers = modifiers;
      }
      var returnType = (TypeSyntax)reader.ReadValue();
      if (returnType != null)
      {
         AdjustFlagsAndWidth(returnType);
         this.returnType = returnType;
      }
      var operatorKeyword = (SyntaxToken)reader.ReadValue();
      if (operatorKeyword != null)
      {
         AdjustFlagsAndWidth(operatorKeyword);
         this.operatorKeyword = operatorKeyword;
      }
      var operatorToken = (SyntaxToken)reader.ReadValue();
      if (operatorToken != null)
      {
         AdjustFlagsAndWidth(operatorToken);
         this.operatorToken = operatorToken;
      }
      var parameterList = (ParameterListSyntax)reader.ReadValue();
      if (parameterList != null)
      {
         AdjustFlagsAndWidth(parameterList);
         this.parameterList = parameterList;
      }
      var body = (BlockSyntax)reader.ReadValue();
      if (body != null)
      {
         AdjustFlagsAndWidth(body);
         this.body = body;
      }
      var expressionBody = (ArrowExpressionClauseSyntax)reader.ReadValue();
      if (expressionBody != null)
      {
         AdjustFlagsAndWidth(expressionBody);
         this.expressionBody = expressionBody;
      }
      var semicolonToken = (SyntaxToken)reader.ReadValue();
      if (semicolonToken != null)
      {
         AdjustFlagsAndWidth(semicolonToken);
         this.semicolonToken = semicolonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.attributeLists);
      writer.WriteValue(this.modifiers);
      writer.WriteValue(this.returnType);
      writer.WriteValue(this.operatorKeyword);
      writer.WriteValue(this.operatorToken);
      writer.WriteValue(this.parameterList);
      writer.WriteValue(this.body);
      writer.WriteValue(this.expressionBody);
      writer.WriteValue(this.semicolonToken);
    }

    static OperatorDeclarationSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(OperatorDeclarationSyntax), r => new OperatorDeclarationSyntax(r));
    }
  }

  /// <summary>Conversion operator declaration syntax.</summary>
  internal sealed partial class ConversionOperatorDeclarationSyntax : BaseMethodDeclarationSyntax
  {
    internal readonly GreenNode attributeLists;
    internal readonly GreenNode modifiers;
    internal readonly SyntaxToken implicitOrExplicitKeyword;
    internal readonly SyntaxToken operatorKeyword;
    internal readonly TypeSyntax type;
    internal readonly ParameterListSyntax parameterList;
    internal readonly BlockSyntax body;
    internal readonly ArrowExpressionClauseSyntax expressionBody;
    internal readonly SyntaxToken semicolonToken;

    internal ConversionOperatorDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken implicitOrExplicitKeyword, SyntaxToken operatorKeyword, TypeSyntax type, ParameterListSyntax parameterList, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(implicitOrExplicitKeyword);
        this.implicitOrExplicitKeyword = implicitOrExplicitKeyword;
        this.AdjustFlagsAndWidth(operatorKeyword);
        this.operatorKeyword = operatorKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }


    internal ConversionOperatorDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken implicitOrExplicitKeyword, SyntaxToken operatorKeyword, TypeSyntax type, ParameterListSyntax parameterList, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(implicitOrExplicitKeyword);
        this.implicitOrExplicitKeyword = implicitOrExplicitKeyword;
        this.AdjustFlagsAndWidth(operatorKeyword);
        this.operatorKeyword = operatorKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }


    internal ConversionOperatorDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken implicitOrExplicitKeyword, SyntaxToken operatorKeyword, TypeSyntax type, ParameterListSyntax parameterList, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(implicitOrExplicitKeyword);
        this.implicitOrExplicitKeyword = implicitOrExplicitKeyword;
        this.AdjustFlagsAndWidth(operatorKeyword);
        this.operatorKeyword = operatorKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> Modifiers => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    /// <summary>Gets the "implicit" or "explicit" token.</summary>
    public SyntaxToken ImplicitOrExplicitKeyword => this.implicitOrExplicitKeyword;
    /// <summary>Gets the "operator" token.</summary>
    public SyntaxToken OperatorKeyword => this.operatorKeyword;
    /// <summary>Gets the type.</summary>
    public TypeSyntax Type => this.type;
    public override ParameterListSyntax ParameterList => this.parameterList;
    public override BlockSyntax Body => this.body;
    public override ArrowExpressionClauseSyntax ExpressionBody => this.expressionBody;
    /// <summary>Gets the optional semicolon token.</summary>
    public override SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 1: return this.modifiers;
            case 2: return this.implicitOrExplicitKeyword;
            case 3: return this.operatorKeyword;
            case 4: return this.type;
            case 5: return this.parameterList;
            case 6: return this.body;
            case 7: return this.expressionBody;
            case 8: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ConversionOperatorDeclarationSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitConversionOperatorDeclaration(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitConversionOperatorDeclaration(this);

    public ConversionOperatorDeclarationSyntax Update(Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> attributeLists, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken implicitOrExplicitKeyword, SyntaxToken operatorKeyword, TypeSyntax type, ParameterListSyntax parameterList, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || implicitOrExplicitKeyword != this.ImplicitOrExplicitKeyword || operatorKeyword != this.OperatorKeyword || type != this.Type || parameterList != this.ParameterList || body != this.Body || expressionBody != this.ExpressionBody || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.ConversionOperatorDeclaration(attributeLists, modifiers, implicitOrExplicitKeyword, operatorKeyword, type, parameterList, body, expressionBody, semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ConversionOperatorDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.implicitOrExplicitKeyword, this.operatorKeyword, this.type, this.parameterList, this.body, this.expressionBody, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ConversionOperatorDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.implicitOrExplicitKeyword, this.operatorKeyword, this.type, this.parameterList, this.body, this.expressionBody, this.semicolonToken, GetDiagnostics(), annotations);

    internal ConversionOperatorDeclarationSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 9;
      var attributeLists = (GreenNode)reader.ReadValue();
      if (attributeLists != null)
      {
         AdjustFlagsAndWidth(attributeLists);
         this.attributeLists = attributeLists;
      }
      var modifiers = (GreenNode)reader.ReadValue();
      if (modifiers != null)
      {
         AdjustFlagsAndWidth(modifiers);
         this.modifiers = modifiers;
      }
      var implicitOrExplicitKeyword = (SyntaxToken)reader.ReadValue();
      if (implicitOrExplicitKeyword != null)
      {
         AdjustFlagsAndWidth(implicitOrExplicitKeyword);
         this.implicitOrExplicitKeyword = implicitOrExplicitKeyword;
      }
      var operatorKeyword = (SyntaxToken)reader.ReadValue();
      if (operatorKeyword != null)
      {
         AdjustFlagsAndWidth(operatorKeyword);
         this.operatorKeyword = operatorKeyword;
      }
      var type = (TypeSyntax)reader.ReadValue();
      if (type != null)
      {
         AdjustFlagsAndWidth(type);
         this.type = type;
      }
      var parameterList = (ParameterListSyntax)reader.ReadValue();
      if (parameterList != null)
      {
         AdjustFlagsAndWidth(parameterList);
         this.parameterList = parameterList;
      }
      var body = (BlockSyntax)reader.ReadValue();
      if (body != null)
      {
         AdjustFlagsAndWidth(body);
         this.body = body;
      }
      var expressionBody = (ArrowExpressionClauseSyntax)reader.ReadValue();
      if (expressionBody != null)
      {
         AdjustFlagsAndWidth(expressionBody);
         this.expressionBody = expressionBody;
      }
      var semicolonToken = (SyntaxToken)reader.ReadValue();
      if (semicolonToken != null)
      {
         AdjustFlagsAndWidth(semicolonToken);
         this.semicolonToken = semicolonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.attributeLists);
      writer.WriteValue(this.modifiers);
      writer.WriteValue(this.implicitOrExplicitKeyword);
      writer.WriteValue(this.operatorKeyword);
      writer.WriteValue(this.type);
      writer.WriteValue(this.parameterList);
      writer.WriteValue(this.body);
      writer.WriteValue(this.expressionBody);
      writer.WriteValue(this.semicolonToken);
    }

    static ConversionOperatorDeclarationSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ConversionOperatorDeclarationSyntax), r => new ConversionOperatorDeclarationSyntax(r));
    }
  }

  /// <summary>Constructor declaration syntax.</summary>
  internal sealed partial class ConstructorDeclarationSyntax : BaseMethodDeclarationSyntax
  {
    internal readonly GreenNode attributeLists;
    internal readonly GreenNode modifiers;
    internal readonly SyntaxToken identifier;
    internal readonly ParameterListSyntax parameterList;
    internal readonly ConstructorInitializerSyntax initializer;
    internal readonly BlockSyntax body;
    internal readonly ArrowExpressionClauseSyntax expressionBody;
    internal readonly SyntaxToken semicolonToken;

    internal ConstructorDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken identifier, ParameterListSyntax parameterList, ConstructorInitializerSyntax initializer, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }


    internal ConstructorDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken identifier, ParameterListSyntax parameterList, ConstructorInitializerSyntax initializer, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }


    internal ConstructorDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken identifier, ParameterListSyntax parameterList, ConstructorInitializerSyntax initializer, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> Modifiers => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public override ParameterListSyntax ParameterList => this.parameterList;
    public ConstructorInitializerSyntax Initializer => this.initializer;
    public override BlockSyntax Body => this.body;
    public override ArrowExpressionClauseSyntax ExpressionBody => this.expressionBody;
    /// <summary>Gets the optional semicolon token.</summary>
    public override SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 1: return this.modifiers;
            case 2: return this.identifier;
            case 3: return this.parameterList;
            case 4: return this.initializer;
            case 5: return this.body;
            case 6: return this.expressionBody;
            case 7: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ConstructorDeclarationSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitConstructorDeclaration(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitConstructorDeclaration(this);

    public ConstructorDeclarationSyntax Update(Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> attributeLists, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken identifier, ParameterListSyntax parameterList, ConstructorInitializerSyntax initializer, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || identifier != this.Identifier || parameterList != this.ParameterList || initializer != this.Initializer || body != this.Body || expressionBody != this.ExpressionBody || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.ConstructorDeclaration(attributeLists, modifiers, identifier, parameterList, initializer, body, expressionBody, semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ConstructorDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.identifier, this.parameterList, this.initializer, this.body, this.expressionBody, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ConstructorDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.identifier, this.parameterList, this.initializer, this.body, this.expressionBody, this.semicolonToken, GetDiagnostics(), annotations);

    internal ConstructorDeclarationSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 8;
      var attributeLists = (GreenNode)reader.ReadValue();
      if (attributeLists != null)
      {
         AdjustFlagsAndWidth(attributeLists);
         this.attributeLists = attributeLists;
      }
      var modifiers = (GreenNode)reader.ReadValue();
      if (modifiers != null)
      {
         AdjustFlagsAndWidth(modifiers);
         this.modifiers = modifiers;
      }
      var identifier = (SyntaxToken)reader.ReadValue();
      if (identifier != null)
      {
         AdjustFlagsAndWidth(identifier);
         this.identifier = identifier;
      }
      var parameterList = (ParameterListSyntax)reader.ReadValue();
      if (parameterList != null)
      {
         AdjustFlagsAndWidth(parameterList);
         this.parameterList = parameterList;
      }
      var initializer = (ConstructorInitializerSyntax)reader.ReadValue();
      if (initializer != null)
      {
         AdjustFlagsAndWidth(initializer);
         this.initializer = initializer;
      }
      var body = (BlockSyntax)reader.ReadValue();
      if (body != null)
      {
         AdjustFlagsAndWidth(body);
         this.body = body;
      }
      var expressionBody = (ArrowExpressionClauseSyntax)reader.ReadValue();
      if (expressionBody != null)
      {
         AdjustFlagsAndWidth(expressionBody);
         this.expressionBody = expressionBody;
      }
      var semicolonToken = (SyntaxToken)reader.ReadValue();
      if (semicolonToken != null)
      {
         AdjustFlagsAndWidth(semicolonToken);
         this.semicolonToken = semicolonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.attributeLists);
      writer.WriteValue(this.modifiers);
      writer.WriteValue(this.identifier);
      writer.WriteValue(this.parameterList);
      writer.WriteValue(this.initializer);
      writer.WriteValue(this.body);
      writer.WriteValue(this.expressionBody);
      writer.WriteValue(this.semicolonToken);
    }

    static ConstructorDeclarationSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ConstructorDeclarationSyntax), r => new ConstructorDeclarationSyntax(r));
    }
  }

  /// <summary>Constructor initializer syntax.</summary>
  internal sealed partial class ConstructorInitializerSyntax : CSharpSyntaxNode
  {
    internal readonly SyntaxToken colonToken;
    internal readonly SyntaxToken thisOrBaseKeyword;
    internal readonly ArgumentListSyntax argumentList;

    internal ConstructorInitializerSyntax(SyntaxKind kind, SyntaxToken colonToken, SyntaxToken thisOrBaseKeyword, ArgumentListSyntax argumentList, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        this.AdjustFlagsAndWidth(thisOrBaseKeyword);
        this.thisOrBaseKeyword = thisOrBaseKeyword;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }


    internal ConstructorInitializerSyntax(SyntaxKind kind, SyntaxToken colonToken, SyntaxToken thisOrBaseKeyword, ArgumentListSyntax argumentList, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        this.AdjustFlagsAndWidth(thisOrBaseKeyword);
        this.thisOrBaseKeyword = thisOrBaseKeyword;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }


    internal ConstructorInitializerSyntax(SyntaxKind kind, SyntaxToken colonToken, SyntaxToken thisOrBaseKeyword, ArgumentListSyntax argumentList)
        : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        this.AdjustFlagsAndWidth(thisOrBaseKeyword);
        this.thisOrBaseKeyword = thisOrBaseKeyword;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }

    /// <summary>Gets the colon token.</summary>
    public SyntaxToken ColonToken => this.colonToken;
    /// <summary>Gets the "this" or "base" keyword.</summary>
    public SyntaxToken ThisOrBaseKeyword => this.thisOrBaseKeyword;
    public ArgumentListSyntax ArgumentList => this.argumentList;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.colonToken;
            case 1: return this.thisOrBaseKeyword;
            case 2: return this.argumentList;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ConstructorInitializerSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitConstructorInitializer(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitConstructorInitializer(this);

    public ConstructorInitializerSyntax Update(SyntaxToken colonToken, SyntaxToken thisOrBaseKeyword, ArgumentListSyntax argumentList)
    {
        if (colonToken != this.ColonToken || thisOrBaseKeyword != this.ThisOrBaseKeyword || argumentList != this.ArgumentList)
        {
            var newNode = SyntaxFactory.ConstructorInitializer(this.Kind, colonToken, thisOrBaseKeyword, argumentList);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ConstructorInitializerSyntax(this.Kind, this.colonToken, this.thisOrBaseKeyword, this.argumentList, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ConstructorInitializerSyntax(this.Kind, this.colonToken, this.thisOrBaseKeyword, this.argumentList, GetDiagnostics(), annotations);

    internal ConstructorInitializerSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 3;
      var colonToken = (SyntaxToken)reader.ReadValue();
      if (colonToken != null)
      {
         AdjustFlagsAndWidth(colonToken);
         this.colonToken = colonToken;
      }
      var thisOrBaseKeyword = (SyntaxToken)reader.ReadValue();
      if (thisOrBaseKeyword != null)
      {
         AdjustFlagsAndWidth(thisOrBaseKeyword);
         this.thisOrBaseKeyword = thisOrBaseKeyword;
      }
      var argumentList = (ArgumentListSyntax)reader.ReadValue();
      if (argumentList != null)
      {
         AdjustFlagsAndWidth(argumentList);
         this.argumentList = argumentList;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.colonToken);
      writer.WriteValue(this.thisOrBaseKeyword);
      writer.WriteValue(this.argumentList);
    }

    static ConstructorInitializerSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ConstructorInitializerSyntax), r => new ConstructorInitializerSyntax(r));
    }
  }

  /// <summary>Destructor declaration syntax.</summary>
  internal sealed partial class DestructorDeclarationSyntax : BaseMethodDeclarationSyntax
  {
    internal readonly GreenNode attributeLists;
    internal readonly GreenNode modifiers;
    internal readonly SyntaxToken tildeToken;
    internal readonly SyntaxToken identifier;
    internal readonly ParameterListSyntax parameterList;
    internal readonly BlockSyntax body;
    internal readonly ArrowExpressionClauseSyntax expressionBody;
    internal readonly SyntaxToken semicolonToken;

    internal DestructorDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken tildeToken, SyntaxToken identifier, ParameterListSyntax parameterList, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(tildeToken);
        this.tildeToken = tildeToken;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }


    internal DestructorDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken tildeToken, SyntaxToken identifier, ParameterListSyntax parameterList, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(tildeToken);
        this.tildeToken = tildeToken;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }


    internal DestructorDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken tildeToken, SyntaxToken identifier, ParameterListSyntax parameterList, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(tildeToken);
        this.tildeToken = tildeToken;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> Modifiers => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    /// <summary>Gets the tilde token.</summary>
    public SyntaxToken TildeToken => this.tildeToken;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public override ParameterListSyntax ParameterList => this.parameterList;
    public override BlockSyntax Body => this.body;
    public override ArrowExpressionClauseSyntax ExpressionBody => this.expressionBody;
    /// <summary>Gets the optional semicolon token.</summary>
    public override SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 1: return this.modifiers;
            case 2: return this.tildeToken;
            case 3: return this.identifier;
            case 4: return this.parameterList;
            case 5: return this.body;
            case 6: return this.expressionBody;
            case 7: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.DestructorDeclarationSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitDestructorDeclaration(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitDestructorDeclaration(this);

    public DestructorDeclarationSyntax Update(Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> attributeLists, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken tildeToken, SyntaxToken identifier, ParameterListSyntax parameterList, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || tildeToken != this.TildeToken || identifier != this.Identifier || parameterList != this.ParameterList || body != this.Body || expressionBody != this.ExpressionBody || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.DestructorDeclaration(attributeLists, modifiers, tildeToken, identifier, parameterList, body, expressionBody, semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new DestructorDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.tildeToken, this.identifier, this.parameterList, this.body, this.expressionBody, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new DestructorDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.tildeToken, this.identifier, this.parameterList, this.body, this.expressionBody, this.semicolonToken, GetDiagnostics(), annotations);

    internal DestructorDeclarationSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 8;
      var attributeLists = (GreenNode)reader.ReadValue();
      if (attributeLists != null)
      {
         AdjustFlagsAndWidth(attributeLists);
         this.attributeLists = attributeLists;
      }
      var modifiers = (GreenNode)reader.ReadValue();
      if (modifiers != null)
      {
         AdjustFlagsAndWidth(modifiers);
         this.modifiers = modifiers;
      }
      var tildeToken = (SyntaxToken)reader.ReadValue();
      if (tildeToken != null)
      {
         AdjustFlagsAndWidth(tildeToken);
         this.tildeToken = tildeToken;
      }
      var identifier = (SyntaxToken)reader.ReadValue();
      if (identifier != null)
      {
         AdjustFlagsAndWidth(identifier);
         this.identifier = identifier;
      }
      var parameterList = (ParameterListSyntax)reader.ReadValue();
      if (parameterList != null)
      {
         AdjustFlagsAndWidth(parameterList);
         this.parameterList = parameterList;
      }
      var body = (BlockSyntax)reader.ReadValue();
      if (body != null)
      {
         AdjustFlagsAndWidth(body);
         this.body = body;
      }
      var expressionBody = (ArrowExpressionClauseSyntax)reader.ReadValue();
      if (expressionBody != null)
      {
         AdjustFlagsAndWidth(expressionBody);
         this.expressionBody = expressionBody;
      }
      var semicolonToken = (SyntaxToken)reader.ReadValue();
      if (semicolonToken != null)
      {
         AdjustFlagsAndWidth(semicolonToken);
         this.semicolonToken = semicolonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.attributeLists);
      writer.WriteValue(this.modifiers);
      writer.WriteValue(this.tildeToken);
      writer.WriteValue(this.identifier);
      writer.WriteValue(this.parameterList);
      writer.WriteValue(this.body);
      writer.WriteValue(this.expressionBody);
      writer.WriteValue(this.semicolonToken);
    }

    static DestructorDeclarationSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(DestructorDeclarationSyntax), r => new DestructorDeclarationSyntax(r));
    }
  }

  /// <summary>Base type for property declaration syntax.</summary>
  internal abstract partial class BasePropertyDeclarationSyntax : MemberDeclarationSyntax
  {
    internal BasePropertyDeclarationSyntax(SyntaxKind kind, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal BasePropertyDeclarationSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    protected BasePropertyDeclarationSyntax(ObjectReader reader)
       : base(reader)
    {
    }

    /// <summary>Gets the type syntax.</summary>
    public abstract TypeSyntax Type { get; }

    /// <summary>Gets the optional explicit interface specifier.</summary>
    public abstract ExplicitInterfaceSpecifierSyntax ExplicitInterfaceSpecifier { get; }

    public abstract AccessorListSyntax AccessorList { get; }
  }

  internal sealed partial class PropertyDeclarationSyntax : BasePropertyDeclarationSyntax
  {
    internal readonly GreenNode attributeLists;
    internal readonly GreenNode modifiers;
    internal readonly TypeSyntax type;
    internal readonly ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier;
    internal readonly SyntaxToken identifier;
    internal readonly AccessorListSyntax accessorList;
    internal readonly ArrowExpressionClauseSyntax expressionBody;
    internal readonly EqualsValueClauseSyntax initializer;
    internal readonly SyntaxToken semicolonToken;

    internal PropertyDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, TypeSyntax type, ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier, SyntaxToken identifier, AccessorListSyntax accessorList, ArrowExpressionClauseSyntax expressionBody, EqualsValueClauseSyntax initializer, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (explicitInterfaceSpecifier != null)
        {
            this.AdjustFlagsAndWidth(explicitInterfaceSpecifier);
            this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (accessorList != null)
        {
            this.AdjustFlagsAndWidth(accessorList);
            this.accessorList = accessorList;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }


    internal PropertyDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, TypeSyntax type, ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier, SyntaxToken identifier, AccessorListSyntax accessorList, ArrowExpressionClauseSyntax expressionBody, EqualsValueClauseSyntax initializer, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (explicitInterfaceSpecifier != null)
        {
            this.AdjustFlagsAndWidth(explicitInterfaceSpecifier);
            this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (accessorList != null)
        {
            this.AdjustFlagsAndWidth(accessorList);
            this.accessorList = accessorList;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }


    internal PropertyDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, TypeSyntax type, ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier, SyntaxToken identifier, AccessorListSyntax accessorList, ArrowExpressionClauseSyntax expressionBody, EqualsValueClauseSyntax initializer, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (explicitInterfaceSpecifier != null)
        {
            this.AdjustFlagsAndWidth(explicitInterfaceSpecifier);
            this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (accessorList != null)
        {
            this.AdjustFlagsAndWidth(accessorList);
            this.accessorList = accessorList;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> Modifiers => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    public override TypeSyntax Type => this.type;
    public override ExplicitInterfaceSpecifierSyntax ExplicitInterfaceSpecifier => this.explicitInterfaceSpecifier;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public override AccessorListSyntax AccessorList => this.accessorList;
    public ArrowExpressionClauseSyntax ExpressionBody => this.expressionBody;
    public EqualsValueClauseSyntax Initializer => this.initializer;
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 1: return this.modifiers;
            case 2: return this.type;
            case 3: return this.explicitInterfaceSpecifier;
            case 4: return this.identifier;
            case 5: return this.accessorList;
            case 6: return this.expressionBody;
            case 7: return this.initializer;
            case 8: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.PropertyDeclarationSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitPropertyDeclaration(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitPropertyDeclaration(this);

    public PropertyDeclarationSyntax Update(Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> attributeLists, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> modifiers, TypeSyntax type, ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier, SyntaxToken identifier, AccessorListSyntax accessorList, ArrowExpressionClauseSyntax expressionBody, EqualsValueClauseSyntax initializer, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || type != this.Type || explicitInterfaceSpecifier != this.ExplicitInterfaceSpecifier || identifier != this.Identifier || accessorList != this.AccessorList || expressionBody != this.ExpressionBody || initializer != this.Initializer || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.PropertyDeclaration(attributeLists, modifiers, type, explicitInterfaceSpecifier, identifier, accessorList, expressionBody, initializer, semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new PropertyDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.type, this.explicitInterfaceSpecifier, this.identifier, this.accessorList, this.expressionBody, this.initializer, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new PropertyDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.type, this.explicitInterfaceSpecifier, this.identifier, this.accessorList, this.expressionBody, this.initializer, this.semicolonToken, GetDiagnostics(), annotations);

    internal PropertyDeclarationSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 9;
      var attributeLists = (GreenNode)reader.ReadValue();
      if (attributeLists != null)
      {
         AdjustFlagsAndWidth(attributeLists);
         this.attributeLists = attributeLists;
      }
      var modifiers = (GreenNode)reader.ReadValue();
      if (modifiers != null)
      {
         AdjustFlagsAndWidth(modifiers);
         this.modifiers = modifiers;
      }
      var type = (TypeSyntax)reader.ReadValue();
      if (type != null)
      {
         AdjustFlagsAndWidth(type);
         this.type = type;
      }
      var explicitInterfaceSpecifier = (ExplicitInterfaceSpecifierSyntax)reader.ReadValue();
      if (explicitInterfaceSpecifier != null)
      {
         AdjustFlagsAndWidth(explicitInterfaceSpecifier);
         this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
      }
      var identifier = (SyntaxToken)reader.ReadValue();
      if (identifier != null)
      {
         AdjustFlagsAndWidth(identifier);
         this.identifier = identifier;
      }
      var accessorList = (AccessorListSyntax)reader.ReadValue();
      if (accessorList != null)
      {
         AdjustFlagsAndWidth(accessorList);
         this.accessorList = accessorList;
      }
      var expressionBody = (ArrowExpressionClauseSyntax)reader.ReadValue();
      if (expressionBody != null)
      {
         AdjustFlagsAndWidth(expressionBody);
         this.expressionBody = expressionBody;
      }
      var initializer = (EqualsValueClauseSyntax)reader.ReadValue();
      if (initializer != null)
      {
         AdjustFlagsAndWidth(initializer);
         this.initializer = initializer;
      }
      var semicolonToken = (SyntaxToken)reader.ReadValue();
      if (semicolonToken != null)
      {
         AdjustFlagsAndWidth(semicolonToken);
         this.semicolonToken = semicolonToken;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.attributeLists);
      writer.WriteValue(this.modifiers);
      writer.WriteValue(this.type);
      writer.WriteValue(this.explicitInterfaceSpecifier);
      writer.WriteValue(this.identifier);
      writer.WriteValue(this.accessorList);
      writer.WriteValue(this.expressionBody);
      writer.WriteValue(this.initializer);
      writer.WriteValue(this.semicolonToken);
    }

    static PropertyDeclarationSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(PropertyDeclarationSyntax), r => new PropertyDeclarationSyntax(r));
    }
  }

  /// <summary>The syntax for the expression body of an expression-bodied member.</summary>
  internal sealed partial class ArrowExpressionClauseSyntax : CSharpSyntaxNode
  {
    internal readonly SyntaxToken arrowToken;
    internal readonly ExpressionSyntax expression;

    internal ArrowExpressionClauseSyntax(SyntaxKind kind, SyntaxToken arrowToken, ExpressionSyntax expression, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(arrowToken);
        this.arrowToken = arrowToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }


    internal ArrowExpressionClauseSyntax(SyntaxKind kind, SyntaxToken arrowToken, ExpressionSyntax expression, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(arrowToken);
        this.arrowToken = arrowToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }


    internal ArrowExpressionClauseSyntax(SyntaxKind kind, SyntaxToken arrowToken, ExpressionSyntax expression)
        : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(arrowToken);
        this.arrowToken = arrowToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    public SyntaxToken ArrowToken => this.arrowToken;
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.arrowToken;
            case 1: return this.expression;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.ArrowExpressionClauseSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitArrowExpressionClause(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitArrowExpressionClause(this);

    public ArrowExpressionClauseSyntax Update(SyntaxToken arrowToken, ExpressionSyntax expression)
    {
        if (arrowToken != this.ArrowToken || expression != this.Expression)
        {
            var newNode = SyntaxFactory.ArrowExpressionClause(arrowToken, expression);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new ArrowExpressionClauseSyntax(this.Kind, this.arrowToken, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
        => new ArrowExpressionClauseSyntax(this.Kind, this.arrowToken, this.expression, GetDiagnostics(), annotations);

    internal ArrowExpressionClauseSyntax(ObjectReader reader)
        : base(reader)
    {
      this.SlotCount = 2;
      var arrowToken = (SyntaxToken)reader.ReadValue();
      if (arrowToken != null)
      {
         AdjustFlagsAndWidth(arrowToken);
         this.arrowToken = arrowToken;
      }
      var expression = (ExpressionSyntax)reader.ReadValue();
      if (expression != null)
      {
         AdjustFlagsAndWidth(expression);
         this.expression = expression;
      }
    }

    internal override void WriteTo(ObjectWriter writer)
    {
      base.WriteTo(writer);
      writer.WriteValue(this.arrowToken);
      writer.WriteValue(this.expression);
    }

    static ArrowExpressionClauseSyntax()
    {
       ObjectBinder.RegisterTypeReader(typeof(ArrowExpressionClauseSyntax), r => new ArrowExpressionClauseSyntax(r));
    }
  }

  internal sealed partial class EventDeclarationSyntax : BasePropertyDeclarationSyntax
  {
    internal readonly GreenNode attributeLists;
    internal readonly GreenNode modifiers;
    internal readonly SyntaxToken eventKeyword;
    internal readonly TypeSyntax type;
    internal readonly ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier;
    internal readonly SyntaxToken identifier;
    internal readonly AccessorListSyntax accessorList;
    internal readonly SyntaxToken semicolonToken;

    internal EventDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken eventKeyword, TypeSyntax type, ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier, SyntaxToken identifier, AccessorListSyntax accessorList, SyntaxToken semicolonToken, DiagnosticInfo[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(eventKeyword);
        this.eventKeyword = eventKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (explicitInterfaceSpecifier != null)
        {
            this.AdjustFlagsAndWidth(explicitInterfaceSpecifier);
            this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (accessorList != null)
        {
            this.AdjustFlagsAndWidth(accessorList);
            this.accessorList = accessorList;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }


    internal EventDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken eventKeyword, TypeSyntax type, ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier, SyntaxToken identifier, AccessorListSyntax accessorList, SyntaxToken semicolonToken, SyntaxFactoryContext context)
        : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(eventKeyword);
        this.eventKeyword = eventKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (explicitInterfaceSpecifier != null)
        {
            this.AdjustFlagsAndWidth(explicitInterfaceSpecifier);
            this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (accessorList != null)
        {
            this.AdjustFlagsAndWidth(accessorList);
            this.accessorList = accessorList;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }


    internal EventDeclarationSyntax(SyntaxKind kind, GreenNode attributeLists, GreenNode modifiers, SyntaxToken eventKeyword, TypeSyntax type, ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier, SyntaxToken identifier, AccessorListSyntax accessorList, SyntaxToken semicolonToken)
        : base(kind)
    {
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(eventKeyword);
        this.eventKeyword = eventKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (explicitInterfaceSpecifier != null)
        {
            this.AdjustFlagsAndWidth(explicitInterfaceSpecifier);
            this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (accessorList != null)
        {
            this.AdjustFlagsAndWidth(accessorList);
            this.accessorList = accessorList;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> Modifiers => new Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    public SyntaxToken EventKeyword => this.eventKeyword;
    public override TypeSyntax Type => this.type;
    public override ExplicitInterfaceSpecifierSyntax ExplicitInterfaceSpecifier => this.explicitInterfaceSpecifier;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public override AccessorListSyntax AccessorList => this.accessorList;
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return this.attributeLists;
            case 1: return this.modifiers;
            case 2: return this.eventKeyword;
            case 3: return this.type;
            case 4: return this.explicitInterfaceSpecifier;
            case 5: return this.identifier;
            case 6: return this.accessorList;
            case 7: return this.semicolonToken;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position) => new CSharp.Syntax.EventDeclarationSyntax(this, parent, position);

    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitEventDeclaration(this);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitEventDeclaration(this);

    public EventDeclarationSyntax Update(Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<AttributeListSyntax> attributeLists, Microsoft.CodeAnalysis.Syntax.InternalSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken eventKeyword, TypeSyntax type, ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier, SyntaxToken identifier, AccessorListSyntax accessorList, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || eventKeyword != this.EventKeyword || type != this.Type || explicitInterfaceSpecifier != this.ExplicitInterfaceSpecifier || identifier != this.Identifier || accessorList != this.AccessorList || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.EventDeclaration(attributeLists, modifiers, eventKeyword, type, explicitInterfaceSpecifier, identifier, accessorList, semicolonToken);
            var diags = this.GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = this.GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[] diagnostics)
        => new EventDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.eventKeyword, this.type, this.explicitInterfaceSpecifier, this.identifier, this.acc