/*
 * Decompiled with CFR 0.152.
 */
package org.mbassy;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.mbassy.AbstractMessageBus;
import org.mbassy.BusConfiguration;
import org.mbassy.MessagePublication;
import org.mbassy.PublicationError;
import org.mbassy.SyncAsyncPostCommand;
import org.mbassy.subscription.Subscription;

public class MBassador<T>
extends AbstractMessageBus<T, SyncAsyncPostCommand<T>> {
    public MBassador(BusConfiguration configuration) {
        super(configuration);
    }

    public MessagePublication<T> publishAsync(T message) {
        return this.addAsynchronousDeliveryRequest(MessagePublication.Create(this.getSubscriptionsByMessageType(message.getClass()), message));
    }

    public MessagePublication<T> publishAsync(T message, long timeout, TimeUnit unit) {
        return this.addAsynchronousDeliveryRequest(MessagePublication.Create(this.getSubscriptionsByMessageType(message.getClass()), message), timeout, unit);
    }

    public void publish(T message) {
        try {
            Collection<Subscription> subscriptions = this.getSubscriptionsByMessageType(message.getClass());
            if (subscriptions == null) {
                return;
            }
            for (Subscription subscription : subscriptions) {
                subscription.publish(message);
            }
        }
        catch (Throwable e) {
            this.handlePublicationError(new PublicationError().setMessage("Error during publication of message").setCause(e).setPublishedObject(message));
        }
    }

    @Override
    public SyncAsyncPostCommand<T> post(T message) {
        return new SyncAsyncPostCommand<T>(this, message);
    }
}

