/*
 * Decompiled with CFR 0.152.
 */
package org.mbassy.dispatch;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.mbassy.IPublicationErrorHandler;
import org.mbassy.PublicationError;
import org.mbassy.dispatch.MessagingContext;

public class AbstractHandlerInvocation {
    private MessagingContext context;

    protected void handlePublicationError(PublicationError error) {
        Collection<IPublicationErrorHandler> handlers = this.getContext().getOwningBus().getRegisteredErrorHandlers();
        for (IPublicationErrorHandler handler : handlers) {
            handler.handleError(error);
        }
    }

    protected void invokeHandler(Object message, Object listener, Method handler) {
        try {
            handler.invoke(listener, message);
        }
        catch (IllegalAccessException e) {
            this.handlePublicationError(new PublicationError(e, "Error during messageHandler notification. The class or method is not accessible", handler, listener, message));
        }
        catch (IllegalArgumentException e) {
            this.handlePublicationError(new PublicationError(e, "Error during messageHandler notification. Wrong arguments passed to method. Was: " + message.getClass() + "Expected: " + handler.getParameterTypes()[0], handler, listener, message));
        }
        catch (InvocationTargetException e) {
            this.handlePublicationError(new PublicationError(e, "Error during messageHandler notification. Message handler threw exception", handler, listener, message));
        }
        catch (Throwable e) {
            this.handlePublicationError(new PublicationError(e, "Error during messageHandler notification. Unexpected exception", handler, listener, message));
        }
    }

    public AbstractHandlerInvocation(MessagingContext context) {
        this.context = context;
    }

    public MessagingContext getContext() {
        return this.context;
    }
}

