/*
 * Decompiled with CFR 0.152.
 */
package org.mbassy.listener;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mbassy.common.IPredicate;
import org.mbassy.common.ReflectionUtils;
import org.mbassy.listener.Enveloped;
import org.mbassy.listener.Filter;
import org.mbassy.listener.IMessageFilter;
import org.mbassy.listener.Listener;
import org.mbassy.listener.MessageHandlerMetadata;
import org.mbassy.listener.MessageListenerMetadata;
import org.mbassy.subscription.MessageEnvelope;

public class MetadataReader {
    private static final IPredicate<Method> AllMessageHandlers = new IPredicate<Method>(){

        @Override
        public boolean apply(Method target) {
            return target.getAnnotation(Listener.class) != null;
        }
    };
    private final Map<Class<? extends IMessageFilter>, IMessageFilter> filterCache = new HashMap<Class<? extends IMessageFilter>, IMessageFilter>();

    private IMessageFilter[] getFilter(Listener subscription) {
        if (subscription.filters().length == 0) {
            return null;
        }
        IMessageFilter[] filters = new IMessageFilter[subscription.filters().length];
        int i = 0;
        for (Filter filterDef : subscription.filters()) {
            IMessageFilter filter = this.filterCache.get(filterDef.value());
            if (filter == null) {
                try {
                    filter = filterDef.value().newInstance();
                    this.filterCache.put(filterDef.value(), filter);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            filters[i] = filter;
            ++i;
        }
        return filters;
    }

    public MessageHandlerMetadata getHandlerMetadata(Method messageHandler) {
        Listener config = messageHandler.getAnnotation(Listener.class);
        return new MessageHandlerMetadata(messageHandler, this.getFilter(config), config);
    }

    public List<MessageHandlerMetadata> getMessageHandlers(Class<?> target) {
        List<Method> allMethods = ReflectionUtils.getMethods(AllMessageHandlers, target);
        LinkedList<MessageHandlerMetadata> handlers = new LinkedList<MessageHandlerMetadata>();
        for (Method handler : allMethods) {
            Method overriddenHandler = ReflectionUtils.getOverridingMethod(handler, target);
            if (overriddenHandler != null || !this.isValidMessageHandler(handler)) continue;
            handlers.add(this.getHandlerMetadata(handler));
        }
        return handlers;
    }

    public <T> MessageListenerMetadata<T> getMessageListener(Class<T> target) {
        return new MessageListenerMetadata<T>(this.getMessageHandlers(target), target);
    }

    private boolean isValidMessageHandler(Method handler) {
        if (handler.getParameterTypes().length != 1) {
            System.out.println("Found no or more than one parameter in messageHandler [" + handler.getName() + "]. A messageHandler must define exactly one parameter");
            return false;
        }
        Enveloped envelope = handler.getAnnotation(Enveloped.class);
        if (envelope != null && !MessageEnvelope.class.isAssignableFrom(handler.getParameterTypes()[0])) {
            System.out.println("Message envelope configured but no subclass of MessageEnvelope found as parameter");
            return false;
        }
        if (envelope != null && envelope.messages().length == 0) {
            System.out.println("Message envelope configured but message types defined for handler");
            return false;
        }
        return true;
    }
}

