/*
 * Decompiled with CFR 0.152.
 */
package org.mbassy;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.mbassy.IMessageBus;
import org.mbassy.IPublicationErrorHandler;
import org.mbassy.PublicationError;
import org.mbassy.listener.MetadataReader;
import org.mbassy.subscription.Subscription;
import org.mbassy.subscription.SubscriptionDeliveryRequest;
import org.mbassy.subscription.SubscriptionFactory;

public abstract class AbstractMessageBus<T, P extends IMessageBus.IPostCommand>
implements IMessageBus<T, P> {
    private ExecutorService executor;
    private MetadataReader metadataReader = new MetadataReader();
    private final Map<Class, Collection<Subscription>> subscriptionsPerMessage = new HashMap<Class, Collection<Subscription>>(50);
    private final Map<Class, Collection<Subscription>> subscriptionsPerListener = new HashMap<Class, Collection<Subscription>>(50);
    private final Collection<Class> nonListeners = new HashSet<Class>();
    private CopyOnWriteArrayList<IPublicationErrorHandler> errorHandlers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<Thread> dispatchers = new CopyOnWriteArrayList();
    private final LinkedBlockingQueue<SubscriptionDeliveryRequest<T>> pendingMessages = new LinkedBlockingQueue();
    private final SubscriptionFactory subscriptionFactory;

    private void initDispatcherThreads(int numberOfThreads) {
        for (int i = 0; i < numberOfThreads; ++i) {
            Thread dispatcher = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            ((SubscriptionDeliveryRequest)AbstractMessageBus.this.pendingMessages.take()).execute();
                        }
                    }
                    catch (InterruptedException e) {
                        AbstractMessageBus.this.handlePublicationError(new PublicationError(e, "Asynchronous publication interrupted", null, null, null));
                        return;
                    }
                }
            });
            this.dispatchers.add(dispatcher);
            dispatcher.start();
        }
    }

    public AbstractMessageBus() {
        this(2);
    }

    public AbstractMessageBus(int dispatcherThreadCount) {
        this(2, new ThreadPoolExecutor(5, 50, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>()));
    }

    public AbstractMessageBus(int dispatcherThreadCount, ExecutorService executor) {
        this.executor = executor;
        this.initDispatcherThreads(dispatcherThreadCount > 0 ? dispatcherThreadCount : 2);
        this.addErrorHandler(new IPublicationErrorHandler.ConsoleLogger());
        this.subscriptionFactory = this.getSubscriptionFactory();
        this.initialize();
    }

    protected abstract SubscriptionFactory getSubscriptionFactory();

    protected void initialize() {
    }

    @Override
    public Collection<IPublicationErrorHandler> getRegisteredErrorHandlers() {
        return Collections.unmodifiableCollection(this.errorHandlers);
    }

    @Override
    public boolean unsubscribe(Object listener) {
        if (listener == null) {
            return false;
        }
        Collection<Subscription> subscriptions = this.subscriptionsPerListener.get(listener.getClass());
        if (subscriptions == null) {
            return false;
        }
        boolean isRemoved = false;
        for (Subscription subscription : subscriptions) {
            isRemoved = isRemoved || subscription.unsubscribe(listener);
        }
        return isRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(Object listener) {
        try {
            Class<?> listeningClass = listener.getClass();
            if (this.nonListeners.contains(listeningClass)) {
                return;
            }
            Collection<Subscription> subscriptionsByListener = this.subscriptionsPerListener.get(listeningClass);
            if (subscriptionsByListener == null) {
                AbstractMessageBus abstractMessageBus = this;
                synchronized (abstractMessageBus) {
                    subscriptionsByListener = this.subscriptionsPerListener.get(listeningClass);
                    if (subscriptionsByListener == null) {
                        List<Method> messageHandlers = this.metadataReader.getListeners(listeningClass);
                        subscriptionsByListener = new ArrayList<Subscription>(messageHandlers.size());
                        if (messageHandlers.isEmpty()) {
                            this.nonListeners.add(listeningClass);
                            return;
                        }
                        for (Method messageHandler : messageHandlers) {
                            if (!this.isValidMessageHandler(messageHandler)) continue;
                            Class eventType = AbstractMessageBus.getMessageType(messageHandler);
                            Subscription subscription = this.subscriptionFactory.createSubscription(this.metadataReader.getHandlerMetadata(messageHandler));
                            subscription.subscribe(listener);
                            this.addMessageTypeSubscription(eventType, subscription);
                            subscriptionsByListener.add(subscription);
                        }
                        this.subscriptionsPerListener.put(listeningClass, subscriptionsByListener);
                    }
                }
            }
            for (Subscription sub : subscriptionsByListener) {
                sub.subscribe(listener);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addErrorHandler(IPublicationErrorHandler handler) {
        this.errorHandlers.add(handler);
    }

    protected void addAsynchronousDeliveryRequest(SubscriptionDeliveryRequest<T> request) {
        this.pendingMessages.offer(request);
    }

    protected Collection<Subscription> getSubscriptionsByMessageType(Class messageType) {
        TreeSet<Subscription> subscriptions = new TreeSet<Subscription>(Subscription.SubscriptionByPriorityDesc);
        if (this.subscriptionsPerMessage.get(messageType) != null) {
            subscriptions.addAll(this.subscriptionsPerMessage.get(messageType));
        }
        for (Class eventSuperType : this.getSuperclasses(messageType)) {
            if (this.subscriptionsPerMessage.get(eventSuperType) == null) continue;
            subscriptions.addAll(this.subscriptionsPerMessage.get(eventSuperType));
        }
        return subscriptions;
    }

    private Collection<Class> getSuperclasses(Class from) {
        LinkedList<Class> superclasses = new LinkedList<Class>();
        while (!from.equals(Object.class)) {
            superclasses.add(from.getSuperclass());
            from = from.getSuperclass();
        }
        return superclasses;
    }

    private void addMessageTypeSubscription(Class messageType, Subscription subscription) {
        Collection<Subscription> subscriptions = this.subscriptionsPerMessage.get(messageType);
        if (subscriptions == null) {
            subscriptions = new CopyOnWriteArraySet<Subscription>();
            this.subscriptionsPerMessage.put(messageType, subscriptions);
        }
        subscriptions.add(subscription);
    }

    private boolean isValidMessageHandler(Method handler) {
        if (handler.getParameterTypes().length != 1) {
            System.out.println("Found no or more than one parameter in messageHandler [" + handler.getName() + "]. A messageHandler must define exactly one parameter");
            return false;
        }
        return true;
    }

    private static Class getMessageType(Method listener) {
        return listener.getParameterTypes()[0];
    }

    public void handlePublicationError(PublicationError error) {
        for (IPublicationErrorHandler errorHandler : this.errorHandlers) {
            errorHandler.handleError(error);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        for (Thread dispatcher : this.dispatchers) {
            dispatcher.interrupt();
        }
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }
}

