/*
 * Decompiled with CFR 0.152.
 */
package org.mbassy;

import java.util.Collection;
import java.util.concurrent.ExecutorService;
import org.mbassy.AbstractMessageBus;
import org.mbassy.PublicationError;
import org.mbassy.SimplePostCommand;
import org.mbassy.subscription.Subscription;
import org.mbassy.subscription.SubscriptionDeliveryRequest;
import org.mbassy.subscription.SubscriptionFactory;

public class MBassador<T>
extends AbstractMessageBus<T, SimplePostCommand<T>> {
    public MBassador() {
        this(2);
    }

    public MBassador(int dispatcherThreadCount) {
        super(dispatcherThreadCount);
    }

    public MBassador(int dispatcherThreadCount, ExecutorService executor) {
        super(dispatcherThreadCount, executor);
    }

    @Override
    protected SubscriptionFactory getSubscriptionFactory() {
        return new SubscriptionFactory(this);
    }

    public void publishAsync(T message) {
        this.addAsynchronousDeliveryRequest(new SubscriptionDeliveryRequest<T>(this.getSubscriptionsByMessageType(message.getClass()), message));
    }

    public void publish(T message) {
        try {
            Collection<Subscription> subscriptions = this.getSubscriptionsByMessageType(message.getClass());
            if (subscriptions == null) {
                return;
            }
            for (Subscription subscription : subscriptions) {
                subscription.publish(message);
            }
        }
        catch (Throwable e) {
            this.handlePublicationError(new PublicationError().setMessage("Error during publication of message").setCause(e).setPublishedObject(message));
        }
    }

    @Override
    public SimplePostCommand post(T message) {
        return new SimplePostCommand<T>(this, message);
    }
}

