/*
 * Decompiled with CFR 0.152.
 */
package org.mbassy.subscription;

import java.util.Iterator;
import org.mbassy.IMessageBus;
import org.mbassy.listener.MessageFilter;
import org.mbassy.listener.MessageHandlerMetadata;
import org.mbassy.subscription.Subscription;

public abstract class FilteredSubscription
extends Subscription {
    private final MessageFilter[] filter;

    public FilteredSubscription(IMessageBus mBassador, MessageHandlerMetadata messageHandler) {
        super(mBassador, messageHandler);
        this.filter = messageHandler.getFilter();
    }

    private boolean passesFilter(Object message, Object listener) {
        if (this.filter == null) {
            return true;
        }
        for (int i = 0; i < this.filter.length; ++i) {
            if (this.filter[i].accepts(message, listener)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void publish(Object message) {
        Iterator iterator = this.listeners.iterator();
        Object listener = null;
        while (true) {
            Object t = iterator.next();
            listener = t;
            if (t == null) break;
            if (!this.passesFilter(message, listener)) continue;
            this.dispatch(message, listener);
        }
    }
}

