/*
 * Decompiled with CFR 0.152.
 */
package org.mbassy.subscription;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Comparator;
import java.util.UUID;
import org.mbassy.IMessageBus;
import org.mbassy.IPublicationErrorHandler;
import org.mbassy.PublicationError;
import org.mbassy.common.ConcurrentSet;
import org.mbassy.listener.MessageHandlerMetadata;

public abstract class Subscription {
    private UUID id = UUID.randomUUID();
    private final Method handler;
    protected ConcurrentSet<Object> listeners = new ConcurrentSet();
    private int priority = 0;
    private IMessageBus owningBus;
    public static final Comparator<Subscription> SubscriptionByPriorityDesc = new Comparator<Subscription>(){

        @Override
        public int compare(Subscription o1, Subscription o2) {
            int result = o1.getPriority() - o2.getPriority();
            return result == 0 ? o1.id.compareTo(o2.id) : result;
        }
    };

    public Subscription(IMessageBus owningBus, MessageHandlerMetadata messageHandler) {
        this.owningBus = owningBus;
        this.priority = messageHandler.getPriority();
        this.handler = messageHandler.getHandler();
        this.handler.setAccessible(true);
    }

    public abstract void publish(Object var1);

    protected abstract void dispatch(Object var1, Object var2);

    protected IMessageBus getMessageBus() {
        return this.owningBus;
    }

    public int getPriority() {
        return this.priority;
    }

    public void subscribe(Object o) {
        this.listeners.add(o);
    }

    protected void handlePublicationError(PublicationError error) {
        Collection<IPublicationErrorHandler> handlers = this.owningBus.getRegisteredErrorHandlers();
        for (IPublicationErrorHandler handler : handlers) {
            handler.handleError(error);
        }
    }

    protected void invokeHandler(Object message, Object listener) {
        try {
            this.handler.invoke(listener, message);
        }
        catch (IllegalAccessException e) {
            this.handlePublicationError(new PublicationError(e, "Error during messageHandler notification. The class or method is not accessible", this.handler, listener, message));
        }
        catch (IllegalArgumentException e) {
            this.handlePublicationError(new PublicationError(e, "Error during messageHandler notification. Wrong arguments passed to method. Was: " + message.getClass() + "Expected: " + this.handler.getParameterTypes()[0], this.handler, listener, message));
        }
        catch (InvocationTargetException e) {
            this.handlePublicationError(new PublicationError(e, "Error during messageHandler notification. Message handler threw exception", this.handler, listener, message));
        }
        catch (Throwable e) {
            this.handlePublicationError(new PublicationError(e, "Error during messageHandler notification. Unexpected exception", this.handler, listener, message));
        }
    }

    public boolean unsubscribe(Object existingListener) {
        return this.listeners.remove(existingListener);
    }
}

