/*
 * Decompiled with CFR 0.152.
 */
package org.mbassy.subscription;

import org.mbassy.IMessageBus;
import org.mbassy.listener.MessageHandlerMetadata;
import org.mbassy.subscription.FilteredAsynchronousSubscription;
import org.mbassy.subscription.FilteredSynchronousSubscription;
import org.mbassy.subscription.Subscription;
import org.mbassy.subscription.UnfilteredAsynchronousSubscription;
import org.mbassy.subscription.UnfilteredSynchronousSubscription;

public class SubscriptionFactory {
    private IMessageBus owner;

    public SubscriptionFactory(IMessageBus owner) {
        this.owner = owner;
    }

    public Subscription createSubscription(MessageHandlerMetadata messageHandlerMetadata) {
        if (messageHandlerMetadata.isFiltered()) {
            if (messageHandlerMetadata.isAsynchronous()) {
                return new UnfilteredAsynchronousSubscription(this.owner, messageHandlerMetadata);
            }
            return new UnfilteredSynchronousSubscription(this.owner, messageHandlerMetadata);
        }
        if (messageHandlerMetadata.isAsynchronous()) {
            return new FilteredAsynchronousSubscription(this.owner, messageHandlerMetadata);
        }
        return new FilteredSynchronousSubscription(this.owner, messageHandlerMetadata);
    }
}

