/*
 * Decompiled with CFR 0.152.
 */
package org.mbassy;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mbassy.BusConfiguration;
import org.mbassy.IMessageBus;
import org.mbassy.IPublicationErrorHandler;
import org.mbassy.PublicationError;
import org.mbassy.common.ReflectionUtils;
import org.mbassy.dispatch.MessagingContext;
import org.mbassy.listener.MetadataReader;
import org.mbassy.subscription.Subscription;
import org.mbassy.subscription.SubscriptionDeliveryRequest;
import org.mbassy.subscription.SubscriptionFactory;

public abstract class AbstractMessageBus<T, P extends IMessageBus.IPostCommand>
implements IMessageBus<T, P> {
    private final ExecutorService executor;
    private final MetadataReader metadataReader;
    private final Map<Class, Collection<Subscription>> subscriptionsPerMessage = new HashMap<Class, Collection<Subscription>>(50);
    private final Map<Class, Collection<Subscription>> subscriptionsPerListener = new HashMap<Class, Collection<Subscription>>(50);
    private final Collection<Class> nonListeners = new HashSet<Class>();
    private final List<IPublicationErrorHandler> errorHandlers = new CopyOnWriteArrayList<IPublicationErrorHandler>();
    private final List<Thread> dispatchers = new CopyOnWriteArrayList<Thread>();
    private final LinkedBlockingQueue<SubscriptionDeliveryRequest<T>> pendingMessages;
    private final SubscriptionFactory subscriptionFactory;
    private final AtomicBoolean isShutDown = new AtomicBoolean(false);

    public AbstractMessageBus(BusConfiguration configuration) {
        this.executor = configuration.getExecutor();
        this.subscriptionFactory = configuration.getSubscriptionFactory();
        this.metadataReader = configuration.getMetadataReader();
        this.pendingMessages = new LinkedBlockingQueue(configuration.getMaximumNumberOfPendingMessages());
        this.initDispatcherThreads(configuration.getNumberOfMessageDispatchers());
        this.addErrorHandler(new IPublicationErrorHandler.ConsoleLogger());
    }

    private void initDispatcherThreads(int numberOfThreads) {
        for (int i = 0; i < numberOfThreads; ++i) {
            Thread dispatcher = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            ((SubscriptionDeliveryRequest)AbstractMessageBus.this.pendingMessages.take()).execute();
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            });
            dispatcher.setDaemon(true);
            this.dispatchers.add(dispatcher);
            dispatcher.start();
        }
    }

    @Override
    public Collection<IPublicationErrorHandler> getRegisteredErrorHandlers() {
        return Collections.unmodifiableCollection(this.errorHandlers);
    }

    @Override
    public boolean unsubscribe(Object listener) {
        if (listener == null) {
            return false;
        }
        Collection<Subscription> subscriptions = this.subscriptionsPerListener.get(listener.getClass());
        if (subscriptions == null) {
            return false;
        }
        boolean isRemoved = true;
        for (Subscription subscription : subscriptions) {
            isRemoved = isRemoved && subscription.unsubscribe(listener);
        }
        return isRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(Object listener) {
        try {
            Class<?> listeningClass = listener.getClass();
            if (this.nonListeners.contains(listeningClass)) {
                return;
            }
            Collection<Subscription> subscriptionsByListener = this.subscriptionsPerListener.get(listeningClass);
            if (subscriptionsByListener == null) {
                AbstractMessageBus abstractMessageBus = this;
                synchronized (abstractMessageBus) {
                    subscriptionsByListener = this.subscriptionsPerListener.get(listeningClass);
                    if (subscriptionsByListener == null) {
                        List<Method> messageHandlers = this.metadataReader.getMessageHandlers(listeningClass);
                        if (messageHandlers.isEmpty()) {
                            this.nonListeners.add(listeningClass);
                            return;
                        }
                        subscriptionsByListener = new ArrayList<Subscription>(messageHandlers.size());
                        for (Method messageHandler : messageHandlers) {
                            if (!this.isValidMessageHandler(messageHandler)) continue;
                            Class eventType = AbstractMessageBus.getMessageType(messageHandler);
                            Subscription subscription = this.subscriptionFactory.createSubscription(new MessagingContext(this, this.metadataReader.getHandlerMetadata(messageHandler)));
                            subscription.subscribe(listener);
                            this.addMessageTypeSubscription(eventType, subscription);
                            subscriptionsByListener.add(subscription);
                        }
                        this.subscriptionsPerListener.put(listeningClass, subscriptionsByListener);
                    }
                }
            }
            for (Subscription sub : subscriptionsByListener) {
                sub.subscribe(listener);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addErrorHandler(IPublicationErrorHandler handler) {
        this.errorHandlers.add(handler);
    }

    protected void addAsynchronousDeliveryRequest(SubscriptionDeliveryRequest<T> request) {
        this.pendingMessages.offer(request);
    }

    protected Collection<Subscription> getSubscriptionsByMessageType(Class messageType) {
        TreeSet<Subscription> subscriptions = new TreeSet<Subscription>(Subscription.SubscriptionByPriorityDesc);
        if (this.subscriptionsPerMessage.get(messageType) != null) {
            subscriptions.addAll(this.subscriptionsPerMessage.get(messageType));
        }
        for (Class eventSuperType : ReflectionUtils.getSuperclasses(messageType)) {
            if (this.subscriptionsPerMessage.get(eventSuperType) == null) continue;
            subscriptions.addAll(this.subscriptionsPerMessage.get(eventSuperType));
        }
        return subscriptions;
    }

    private void addMessageTypeSubscription(Class messageType, Subscription subscription) {
        Collection<Subscription> subscriptions = this.subscriptionsPerMessage.get(messageType);
        if (subscriptions == null) {
            subscriptions = new LinkedList<Subscription>();
            this.subscriptionsPerMessage.put(messageType, subscriptions);
        }
        subscriptions.add(subscription);
    }

    private boolean isValidMessageHandler(Method handler) {
        if (handler.getParameterTypes().length != 1) {
            System.out.println("Found no or more than one parameter in messageHandler [" + handler.getName() + "]. A messageHandler must define exactly one parameter");
            return false;
        }
        return true;
    }

    private static Class getMessageType(Method listener) {
        return listener.getParameterTypes()[0];
    }

    public void handlePublicationError(PublicationError error) {
        for (IPublicationErrorHandler errorHandler : this.errorHandlers) {
            errorHandler.handleError(error);
        }
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }

    private void shutdown() {
        for (Thread dispatcher : this.dispatchers) {
            dispatcher.interrupt();
        }
        this.executor.shutdown();
        this.isShutDown.set(true);
    }

    @Override
    public boolean hasPendingMessages() {
        return this.pendingMessages.size() > 0;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }
}

