/*
 * Decompiled with CFR 0.152.
 */
package org.mbassy;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.mbassy.listener.MetadataReader;
import org.mbassy.subscription.SubscriptionFactory;

public class BusConfiguration {
    private int numberOfMessageDispatchers = 2;
    private ExecutorService executor;
    private int maximumNumberOfPendingMessages = Integer.MAX_VALUE;
    private SubscriptionFactory subscriptionFactory = new SubscriptionFactory();
    private MetadataReader metadataReader;

    public static final BusConfiguration Default() {
        return new BusConfiguration();
    }

    public BusConfiguration() {
        this.executor = new ThreadPoolExecutor(5, 20, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
        this.metadataReader = new MetadataReader();
    }

    public MetadataReader getMetadataReader() {
        return this.metadataReader;
    }

    public BusConfiguration setMetadataReader(MetadataReader metadataReader) {
        this.metadataReader = metadataReader;
        return this;
    }

    public int getNumberOfMessageDispatchers() {
        return this.numberOfMessageDispatchers > 0 ? this.numberOfMessageDispatchers : 2;
    }

    public BusConfiguration setNumberOfMessageDispatchers(int numberOfMessageDispatchers) {
        this.numberOfMessageDispatchers = numberOfMessageDispatchers;
        return this;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public BusConfiguration setExecutor(ExecutorService executor) {
        this.executor = executor;
        return this;
    }

    public int getMaximumNumberOfPendingMessages() {
        return this.maximumNumberOfPendingMessages;
    }

    public BusConfiguration setMaximumNumberOfPendingMessages(int maximumNumberOfPendingMessages) {
        this.maximumNumberOfPendingMessages = maximumNumberOfPendingMessages > 0 ? maximumNumberOfPendingMessages : Integer.MAX_VALUE;
        return this;
    }

    public SubscriptionFactory getSubscriptionFactory() {
        return this.subscriptionFactory;
    }

    public BusConfiguration setSubscriptionFactory(SubscriptionFactory subscriptionFactory) {
        this.subscriptionFactory = subscriptionFactory;
        return this;
    }
}

