/*
 * Decompiled with CFR 0.152.
 */
package org.mbassy;

import java.util.Collection;
import org.mbassy.AbstractMessageBus;
import org.mbassy.BusConfiguration;
import org.mbassy.PublicationError;
import org.mbassy.SyncAsyncPostCommand;
import org.mbassy.subscription.Subscription;
import org.mbassy.subscription.SubscriptionDeliveryRequest;

public class MBassador<T>
extends AbstractMessageBus<T, SyncAsyncPostCommand<T>> {
    public MBassador(BusConfiguration configuration) {
        super(configuration);
    }

    public void publishAsync(T message) {
        this.addAsynchronousDeliveryRequest(new SubscriptionDeliveryRequest<T>(this.getSubscriptionsByMessageType(message.getClass()), message));
    }

    public void publish(T message) {
        try {
            Collection<Subscription> subscriptions = this.getSubscriptionsByMessageType(message.getClass());
            if (subscriptions == null) {
                return;
            }
            for (Subscription subscription : subscriptions) {
                subscription.publish(message);
            }
        }
        catch (Throwable e) {
            this.handlePublicationError(new PublicationError().setMessage("Error during publication of message").setCause(e).setPublishedObject(message));
        }
    }

    @Override
    public SyncAsyncPostCommand post(T message) {
        return new SyncAsyncPostCommand<T>(this, message);
    }
}

