/*
 * Decompiled with CFR 0.152.
 */
package org.mbassy.listener;

import java.lang.reflect.Method;
import org.mbassy.listener.IMessageFilter;
import org.mbassy.listener.Listener;
import org.mbassy.listener.Mode;

public class MessageHandlerMetadata {
    private Method handler;
    private IMessageFilter[] filter;
    private Listener listenerConfig;
    private boolean isAsynchronous = false;

    public MessageHandlerMetadata(Method handler, IMessageFilter[] filter, Listener listenerConfig) {
        this.handler = handler;
        this.filter = filter;
        this.listenerConfig = listenerConfig;
        this.isAsynchronous = listenerConfig.dispatch().equals((Object)Mode.Asynchronous);
        this.handler.setAccessible(true);
    }

    public boolean isAsynchronous() {
        return this.isAsynchronous;
    }

    public boolean isFiltered() {
        return this.filter != null && this.filter.length > 0;
    }

    public int getPriority() {
        return this.listenerConfig.priority();
    }

    public Method getHandler() {
        return this.handler;
    }

    public IMessageFilter[] getFilter() {
        return this.filter;
    }

    public Class getDeclaredMessageType() {
        return this.handler.getParameterTypes()[0];
    }
}

