/*
 * Decompiled with CFR 0.152.
 */
package org.mbassy.listener;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mbassy.common.IPredicate;
import org.mbassy.common.ReflectionUtils;
import org.mbassy.listener.Filter;
import org.mbassy.listener.IMessageFilter;
import org.mbassy.listener.Listener;
import org.mbassy.listener.MessageHandlerMetadata;

public class MetadataReader {
    private static final IPredicate<Method> AllMessageHandlers = new IPredicate<Method>(){

        @Override
        public boolean apply(Method target) {
            return target.getAnnotation(Listener.class) != null;
        }
    };
    private final Map<Class<? extends IMessageFilter>, IMessageFilter> filterCache = new HashMap<Class<? extends IMessageFilter>, IMessageFilter>();

    private IMessageFilter[] getFilter(Listener subscription) throws Exception {
        if (subscription.filters().length == 0) {
            return null;
        }
        IMessageFilter[] filters = new IMessageFilter[subscription.filters().length];
        int i = 0;
        for (Filter filterDef : subscription.filters()) {
            IMessageFilter filter = this.filterCache.get(filterDef.value());
            if (filter == null) {
                filter = filterDef.value().newInstance();
                this.filterCache.put(filterDef.value(), filter);
            }
            filters[i] = filter;
            ++i;
        }
        return filters;
    }

    public MessageHandlerMetadata getHandlerMetadata(Method messageHandler) throws Exception {
        Listener config = messageHandler.getAnnotation(Listener.class);
        IMessageFilter[] filter = this.getFilter(config);
        return new MessageHandlerMetadata(messageHandler, filter, config);
    }

    public List<Method> getMessageHandlers(Class<?> target) {
        List<Method> allMethods = ReflectionUtils.getMethods(AllMessageHandlers, target);
        LinkedList<Method> handlers = new LinkedList<Method>();
        for (Method listener : allMethods) {
            Method overriddenHandler = ReflectionUtils.getOverridingMethod(listener, target);
            if (overriddenHandler != null && MetadataReader.isHandler(overriddenHandler)) {
                handlers.add(overriddenHandler);
            }
            if (overriddenHandler != null) continue;
            handlers.add(listener);
        }
        return ReflectionUtils.withoutOverridenSuperclassMethods(handlers);
    }

    private static boolean isHandler(Method m) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = m.getDeclaredAnnotations()) {
            if (!annotation.equals(Listener.class)) continue;
            return true;
        }
        return false;
    }
}

